﻿/**
 * iconvalidation - jQuery jwwUI Copyright (c) 2013-2015 www.jeeww.com. All
 * rights reserved. Licensed under the GPL or commercial licenses
 */
(function($) {
	function setSize(target, sizeValue) {
		var inputiconboxDefs = $.data(target, "inputiconbox").defs;
		var inputiconboxObj = $.data(target, "inputiconbox").inputiconbox;
		if (sizeValue) {
			inputiconboxDefs.width = sizeValue;
		}
		var inputiconboxTextObj = inputiconboxObj.find("input.inputiconbox-text");
		var inputiconboxIconObj = inputiconboxObj.find(".inputiconbox-icon");
		var iconWidth = inputiconboxDefs.hasIcon ? inputiconboxIconObj._outerWidth() : 0;
		// inputiconboxTextObj._outerWidth(inputiconboxObj.width() -
		// iconWidth);
		var oWidth = inputiconboxObj.width();
		var textWidth = (oWidth - iconWidth - 10) / oWidth;
		textWidth = textWidth.toFixed(2) * 100;
		textWidth = textWidth + "%";
		inputiconboxTextObj.css({
			width : textWidth
		// height : inputiconboxObj.height() + "px",
		// lineHeight : inputiconboxObj.height() + "px"
		});
		inputiconboxIconObj._outerHeight(inputiconboxObj.height());
	}
	;
	function setIconShowOrHide(target) {
		var inputiconboxDefs = $.data(target, "inputiconbox").defs;
		var inputiconboxObj = $.data(target, "inputiconbox").inputiconbox;
		if (inputiconboxDefs.hasIcon) {
			inputiconboxObj.find(".inputiconbox-icon").show();
		} else {
			inputiconboxObj.find(".inputiconbox-icon").hide();
		}
	}
	;
	function createIconinputboxObj(target, defs) {
		$(target).addClass("inputiconbox-f").hide();
		var inputiconboxObj = null;
		if (defs.cusCls) {
			inputiconboxObj = $("<span class=\"inputiconbox\"></span>").addClass(defs.cusCls);
		} else {
			inputiconboxObj = $("<span class=\"inputiconbox\"></span>");
		}
		if (defs.border) {
			inputiconboxObj.addClass("inputiconbox-border");
		}
		inputiconboxObj.insertAfter(target);
		var inputiconboxTextObj = $("<input type=\"text\" class=\"inputiconbox-text\">").appendTo(
		        inputiconboxObj);
		if (defs.iconCls) {
			$("<span class=\"inputiconbox-icon\"></span>").addClass(defs.iconCls).appendTo(inputiconboxObj);
		} else {
			$("<span><span class=\"inputiconbox-icon\"></span></span>").appendTo(inputiconboxObj);
		}
		var inputiconboxPropertyName = $(target).attr("name");
		if (inputiconboxPropertyName) {
			inputiconboxObj.find("input.inputiconbox-text").attr("name", inputiconboxPropertyName);
			$(target).removeAttr("name").attr("inputiconboxName", inputiconboxPropertyName);
		}
		inputiconboxTextObj.attr("autocomplete", "off");
		return {
			inputiconbox : inputiconboxObj
		};
	}
	;
	function destroy(target) {
		var inputiconboxTextObj = $.data(target, "inputiconbox").inputiconbox.find("input.inputiconbox-text");
		inputiconboxTextObj.inputbox("destroy");
		$.data(target, "inputiconbox").inputiconbox.remove();
		$(target).remove();
	}
	;
	function bindEvents(target) {
		var inputiconboxObj = $.data(target, "inputiconbox");
		var inputiconboxDefs = inputiconboxObj.defs;
		var inputiconboxObjInner = $.data(target, "inputiconbox").inputiconbox;
		var inputiconboxText = inputiconboxObjInner.find(".inputiconbox-text");
		var inputiconboxIcon = inputiconboxObjInner.find(".inputiconbox-icon");
		$(document).unbind(".inputiconbox").bind("mousedown.inputiconbox", function(e) {
			
		});
		inputiconboxObjInner.unbind(".inputiconbox");
		inputiconboxText.unbind(".inputiconbox");
		inputiconboxIcon.unbind(".inputiconbox");
		if (!inputiconboxDefs.disabled) {
			inputiconboxText.bind("mousedown.inputiconbox", function(e) {
				e.stopPropagation();
			}).bind("keydown.inputiconbox", function(e) {
				switch (e.keyCode) {
				case 38:
					inputiconboxDefs.keyHandler.up.call(target);
					break;
				case 40:
					inputiconboxDefs.keyHandler.down.call(target);
					break;
				case 13:
					e.preventDefault();
					inputiconboxDefs.keyHandler.enter.call(target);
					return false;
				case 9:
				case 27:
					break;
				default:
					if (inputiconboxDefs.editable) {
						if (inputiconboxObj.timer) {
							clearTimeout(inputiconboxObj.timer);
						}
						inputiconboxObj.timer = setTimeout(function() {
							var q = inputiconboxText.val();
							if (inputiconboxObj.previousValue != q) {
								inputiconboxObj.previousValue = q;
								inputiconboxDefs.keyHandler.query.call(target, inputiconboxText.val());
								validate(target, true);
							}
						}, inputiconboxDefs.delay);
					}
				}
			});
			inputiconboxIcon.bind("click.inputiconbox", function() {
				if (inputiconboxDefs.iconClick) {
					inputiconboxDefs.value = inputiconboxText.val();
					var name = inputiconboxText.attr("name");
					inputiconboxDefs.iconClick.call(target, inputiconboxDefs.value, name);
					inputiconboxText.focus();
				}
			}).bind("mouseenter.inputiconbox", function() {
				$(this).addClass("inputiconbox-icon-hover");
			}).bind("mouseleave.inputiconbox", function() {
				$(this).removeClass("inputiconbox-icon-hover");
			}).bind("mousedown.inputiconbox", function() {
			});
		}
	}
	;
	function validate(target, validateFlag) {
		var inputiconboxDefs = $.data(target, "inputiconbox").defs;
		var inputiconboxObj = $.data(target, "inputiconbox").inputiconbox.find("input.inputiconbox-text");
		inputiconboxDefs.border=false;//remove inner border
		inputiconboxObj.inputbox(inputiconboxDefs);
		if (validateFlag) {
			inputiconboxObj.inputbox("validate");
		}
	}
	;
	function setDisabled(target, flag) {
		var inputiconboxDefs = $.data(target, "inputiconbox").defs;
		var inputiconboxObj = $.data(target, "inputiconbox").inputiconbox;
		if (flag) {
			inputiconboxDefs.disabled = true;
			$(target).attr("disabled", true);
			inputiconboxObj.find(".inputiconbox-text").attr("disabled", true);
		} else {
			inputiconboxDefs.disabled = false;
			$(target).removeAttr("disabled");
			inputiconboxObj.find(".inputiconbox-text").removeAttr("disabled");
		}
	}
	;
	function clear(target) {
		var inputiconboxObj = $.data(target, "inputiconbox").inputiconbox;
		inputiconboxObj.find("input.inputiconbox-text").val("");
	}
	;
	function getIconinputboxValue(target) {
		var inputiconboxObj = $.data(target, "inputiconbox").inputiconbox;
		return inputiconboxObj.find("input.inputiconbox-text").val();
	}
	;
	function setIconinputboxValue(target, textValue) {
		var inputiconboxObj = $.data(target, "inputiconbox").inputiconbox;
		inputiconboxObj.find("input.inputiconbox-text").val(textValue);
		validate(target, true);
		$.data(target, "inputiconbox").previousValue = textValue;
	}
	;
	function inputiconboxOnChange(inputiconboxObj) {
		var inputiconboxDefs = $.data(inputiconboxObj, "inputiconbox").defs;
		var fn = inputiconboxDefs.onChange;
		inputiconboxDefs.onChange = function() {
		};
		setIconinputboxValue(inputiconboxObj, inputiconboxDefs.value);
		inputiconboxDefs.originalValue = inputiconboxDefs.value;
		inputiconboxDefs.onChange = fn;
	}
	;
	$.fn.inputiconbox = function(defs, param) {
		if (typeof defs == "string") {
			return $.fn.inputiconbox.methods[defs](this, param);
		}
		defs = defs || {};
		return this.each(function() {
			var inputiconboxObj = $.data(this, "inputiconbox");
			if (inputiconboxObj) {
				$.extend(inputiconboxObj.defs, defs);
			} else {
				var newDefs = $.extend({}, $.fn.inputiconbox.defaults, $.fn.inputiconbox.getDefs(this),
				        defs);
				var r = createIconinputboxObj(this, newDefs);
				inputiconboxObj = $.data(this, "inputiconbox", {
				    defs : newDefs,
				    inputiconbox : r.inputiconbox,
				    previousValue : null
				});
				$(this).removeAttr("disabled");
			}
			$("input.inputiconbox-text", inputiconboxObj.inputiconbox).attr("readonly",
			        !inputiconboxObj.defs.editable);
			setIconShowOrHide(this);
			setDisabled(this, inputiconboxObj.defs.disabled);
			setSize(this);
			bindEvents(this);
			validate(this);
			inputiconboxOnChange(this);
		});
	};
	$.fn.inputiconbox.methods = {
	    defs : function(jq) {
		    return $.data(jq[0], "inputiconbox").defs;
	    },
	    textbox : function(jq) {
		    return $.data(jq[0], "inputiconbox").inputiconbox.find("input.inputiconbox-text");
	    },
	    destroy : function(jq) {
		    return jq.each(function() {
			    destroy(this);
		    });
	    },
	    resize : function(jq, width) {
		    return jq.each(function() {
			    setSize(this, width);
		    });
	    },
	    disable : function(jq) {
		    return jq.each(function() {
			    setDisabled(this, true);
			    bindEvents(this);
		    });
	    },
	    enable : function(jq) {
		    return jq.each(function() {
			    setDisabled(this, false);
			    bindEvents(this);
		    });
	    },
	    validate : function(jq) {
		    return jq.each(function() {
			    validate(this, true);
		    });
	    },
	    isValid : function(jq) {
		    var inputiconboxTextObj = $.data(jq[0], "inputiconbox").inputiconbox.find("input.inputiconbox-text");
		    return inputiconboxTextObj.inputbox("isValid");
	    },
	    clear : function(jq) {
		    return jq.each(function() {
			    clear(this);
		    });
	    },
	    reset : function(jq) {
		    return jq.each(function() {
			    var inputiconboxDefs = $.data(this, "inputiconbox").defs;
			    $(this).inputiconbox("setValue", inputiconboxDefs.originalValue);
		    });
	    },
	    getValue : function(jq) {
		    return getIconinputboxValue(jq[0]);
	    },
	    setValue : function(jq, v) {
		    return jq.each(function() {
			    setIconinputboxValue(this, v);
		    });
	    }
	};
	$.fn.inputiconbox.getDefs = function(target) {
		var t = $(target);
		return $.extend({}, $.fn.inputbox.getDefs(target), $.parser.getDefs(target, [ "width",
		        "height", "separator", {
		            editable : "boolean",
		            hasIcon : "boolean",
		            delay : "number"
		        } ]), {
		    multiple : (t.attr("multiple") ? true : undefined),
		    disabled : (t.attr("disabled") ? true : undefined),
		    value : (t.val() || undefined),
		    iconClick : (t.attr("iconClick") ? $.parser.localEval(t.attr("iconClick")) : undefined)
		});
	};
	$.fn.inputiconbox.defaults = $.extend({}, $.fn.inputbox.defaults, {
	    cusCls : null,
	    iconCls : null,
	    border : false,
	    width : "auto",
	    height : 22,
	    multiple : false,
	    separator : ",",
	    editable : true,
	    disabled : false,
	    hasIcon : true,
	    value : "",
	    delay : 200,
	    keyHandler : {
	        up : function() {
	        },
	        down : function() {
	        },
	        enter : function() {
	        },
	        query : function(q) {
	        }
	    },
	    onChange : function(target, v) {
	    }
	});
})(jQuery);
