﻿/**
 * pagination - jQuery jwwUI Copyright (c) 2013-2015 www.jeeww.com. All rights
 * reserved. Licensed under the GPL or commercial licenses
 */
(function($) {
	function create(target) {
		var pagination = $.data(target, "pagination");
		var defs = pagination.defs;
		var bb = pagination.bb = {};
		var pagerObj = $(target).addClass("pagination").html(
		        "<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\"><tr></tr></table>");
		var tr = pagerObj.find("tr");
		function renderPagerButton(buttonFlag) {
			var navButton = defs.nav[buttonFlag];
			var a = $("<a href=\"javascript:void(0)\"></a>").appendTo(tr);
			a.wrap("<td></td>");
			a.button({
			    iconCls : navButton.iconCls,
			    plain : true,
			    pagerbtn : true
			}).unbind(".pagination").bind("click.pagination", function() {
				navButton.handler.call(target);
			});
			return a;
		}
		;
		if (defs.showPageList) {
			var ps = $("<select class=\"pagination-page-list\"></select>");
			ps.bind("change", function() {
				defs.pageSize = parseInt($(this).val());
				defs.onChangePageSize.call(target, defs.pageSize);
				selectByPageNumber(target, defs.pageNumber);
			});
			for ( var i = 0; i < defs.pageList.length; i++) {
				$("<option></option>").text(defs.pageList[i]).appendTo(ps);
			}
			$("<td></td>").append(ps).appendTo(tr);
			$("<td><div class=\"pagination-btn-separator\"></div></td>").appendTo(tr);
		}
		bb.first = renderPagerButton("first");
		bb.prev = renderPagerButton("prev");
		$("<td><div class=\"pagination-btn-separator\"></div></td>").appendTo(tr);
		$("<span style=\"padding-left:6px;\"></span>").html(defs.beforePageText).appendTo(tr).wrap("<td></td>");
		bb.num = $("<input class=\"pagination-num\" type=\"text\" value=\"1\" size=\"2\">").appendTo(tr).wrap(
		        "<td></td>");
		bb.num.unbind(".pagination").bind("keydown.pagination", function(e) {
			if (e.keyCode == 13) {
				var number = parseInt($(this).val()) || 1;
				selectByPageNumber(target, number);
				return false;
			}
		});
		bb.after = $("<span style=\"padding-right:6px;\"></span>").appendTo(tr).wrap("<td><div class=\"l-btn-plain-pager-ltd\"></div></td>");
		$("<td><div class=\"pagination-btn-separator\"></div></td>").appendTo(tr);
		bb.next = renderPagerButton("next");
		bb.last = renderPagerButton("last");
		if (defs.showRefresh) {
			$("<td><div class=\"pagination-btn-separator\"></div></td>").appendTo(tr);
			bb.refresh = renderPagerButton("refresh");
		}
		if (defs.buttons) {
			$("<td><div class=\"pagination-btn-separator\"></div></td>").appendTo(tr);
			for ( var i = 0; i < defs.buttons.length; i++) {
				var buttons = defs.buttons[i];
				if (buttons == "-") {
					$("<td><div class=\"pagination-btn-separator\"></div></td>").appendTo(tr);
				} else {
					var td = $("<td></td>").appendTo(tr);
					$("<a href=\"javascript:void(0)\"></a>").appendTo(td).button($.extend(buttons, {
						plain : true
					})).bind("click", $.parser.localEval(buttons.handler || function() {
					}));
				}
			}
		}
		$("<div class=\"pagination-info\"></div>").appendTo(pagerObj);
		$("<div style=\"clear:both;\"></div>").appendTo(pagerObj);
	}
	;
	function selectByPageNumber(target, number) {
		var defs = $.data(target, "pagination").defs;
		var pageNumber = Math.ceil(defs.total / defs.pageSize) || 1;
		defs.pageNumber = number;
		if (defs.pageNumber < 1) {
			defs.pageNumber = 1;
		}
		if (defs.pageNumber > pageNumber) {
			defs.pageNumber = pageNumber;
		}
		refreshPager(target, {
			pageNumber : defs.pageNumber
		});
		defs.onSelectPage.call(target, defs.pageNumber, defs.pageSize);
	}
	;
	function refreshPager(target, defsParam) {
		var defs = $.data(target, "pagination").defs;
		var bb = $.data(target, "pagination").bb;
		$.extend(defs, defsParam || {});
		var ps = $(target).find("select.pagination-page-list");
		if (ps.length) {
			ps.val(defs.pageSize + "");
			defs.pageSize = parseInt(ps.val());
		}
		var pageNumber = Math.ceil(defs.total / defs.pageSize) || 1;
		bb.num.val(defs.pageNumber);
		bb.after.html(defs.afterPageText.replace(/{pages}/, pageNumber));
		var displayMsg = defs.displayMsg;
		displayMsg = displayMsg.replace(/{from}/, defs.total == 0 ? 0 : defs.pageSize
		        * (defs.pageNumber - 1) + 1);
		displayMsg = displayMsg.replace(/{to}/, Math.min(defs.pageSize * (defs.pageNumber),
		        defs.total));
		displayMsg = displayMsg.replace(/{total}/, defs.total);
		$(target).find("div.pagination-info").html(displayMsg);
		bb.first.add(bb.prev).button({
			disabled : (defs.pageNumber == 1)
		});
		bb.next.add(bb.last).button({
			disabled : (defs.pageNumber == pageNumber)
		});
		loadHandel(target, defs.loading);
	}
	;
	function loadHandel(target, loading) {
		var defs = $.data(target, "pagination").defs;
		var bb = $.data(target, "pagination").bb;
		defs.loading = loading;
		if (defs.showRefresh) {
			if (defs.loading) {
				bb.refresh.button({
					iconCls : "pagination-loading"
				});
			} else {
				bb.refresh.button({
					iconCls : "pagination-load"
				});
			}
		}
	}
	;
	$.fn.pagination = function(defs, param) {
		if (typeof defs == "string") {
			return $.fn.pagination.methods[defs](this, param);
		}
		defs = defs || {};
		return this.each(function() {
			var newDefs;
			var pagination = $.data(this, "pagination");
			if (pagination) {
				newDefs = $.extend(pagination.defs, defs);
			} else {
				newDefs = $.extend({}, $.fn.pagination.defaults, $.fn.pagination.getDefs(this),
				        defs);
				$.data(this, "pagination", {
					defs : newDefs
				});
			}
			create(this);
			refreshPager(this);
		});
	};
	$.fn.pagination.methods = {
	    defs : function(jq) {
		    return $.data(jq[0], "pagination").defs;
	    },
	    loading : function(jq) {
		    return jq.each(function() {
			    loadHandel(this, true);
		    });
	    },
	    loaded : function(jq) {
		    return jq.each(function() {
			    loadHandel(this, false);
		    });
	    },
	    refresh : function(jq, defs) {
		    return jq.each(function() {
			    refreshPager(this, defs);
		    });
	    },
	    select : function(jq, pageNumber) {
		    return jq.each(function() {
			    selectByPageNumber(this, pageNumber);
		    });
	    }
	};
	$.fn.pagination.getDefs = function(target) {
		var t = $(target);
		return $.extend({}, $.parser.getDefs(target, [ {
		    total : "number",
		    pageSize : "number",
		    pageNumber : "number"
		}, {
		    loading : "boolean",
		    showPageList : "boolean",
		    showRefresh : "boolean"
		} ]), {
			pageList : (t.attr("pageList") ? $.parser.localEval(t.attr("pageList")) : undefined)
		});
	};
	$.fn.pagination.defaults = {
	    total : 1,
	    pageSize : 10,
	    pageNumber : 1,
	    pageList : [ 10, 20, 30, 50 ],
	    loading : false,
	    buttons : null,
	    showPageList : true,
	    showRefresh : true,
	    onSelectPage : function(pageNumber, pageSize) {
	    },
	    onBeforeRefresh : function(pageNumber, pageSize) {
	    },
	    onRefresh : function(pageNumber, pageSize) {
	    },
	    onChangePageSize : function(pageSize) {
	    },
	    beforePageText : "Page",
	    afterPageText : "of {pages}",
	    displayMsg : "Displaying {from} to {to} of {total} items",
	    nav : {
	        first : {
	            iconCls : "pagination-first",
	            handler : function() {
		            var defs = $(this).pagination("defs");
		            if (defs.pageNumber > 1) {
			            $(this).pagination("select", 1);
		            }
	            }
	        },
	        prev : {
	            iconCls : "pagination-prev",
	            handler : function() {
		            var defs = $(this).pagination("defs");
		            if (defs.pageNumber > 1) {
			            $(this).pagination("select", defs.pageNumber - 1);
		            }
	            }
	        },
	        next : {
	            iconCls : "pagination-next",
	            handler : function() {
		            var defs = $(this).pagination("defs");
		            var pageNumber = Math.ceil(defs.total / defs.pageSize);
		            if (defs.pageNumber < pageNumber) {
			            $(this).pagination("select", defs.pageNumber + 1);
		            }
	            }
	        },
	        last : {
	            iconCls : "pagination-last",
	            handler : function() {
		            var defs = $(this).pagination("defs");
		            var pageNumber = Math.ceil(defs.total / defs.pageSize);
		            if (defs.pageNumber < pageNumber) {
			            $(this).pagination("select", pageNumber);
		            }
	            }
	        },
	        refresh : {
	            iconCls : "pagination-refresh",
	            handler : function() {
		            var defs = $(this).pagination("defs");
		            if (defs.onBeforeRefresh.call(this, defs.pageNumber, defs.pageSize) != false) {
			            $(this).pagination("select", defs.pageNumber);
			            defs.onRefresh.call(this, defs.pageNumber, defs.pageSize);
		            }
	            }
	        }
	    }
	};
})(jQuery);
