﻿/**
 * spinner - jQuery jwwUI Copyright (c) 2013-2015 www.jeeww.com. All rights
 * reserved. Licensed under the GPL or commercial licenses
 */
(function($) {
	function create(target, vdefs) {
		var spinnerObj = null;
		if (vdefs.border) {
			spinnerObj = $(
			        "<div class=\"spinner spinner-border\">" + "<div class=\"spinner-arrow\">"
			                + "<div class=\"spinner-arrow-up\"></div>" + "<div class=\"spinner-arrow-down\"></div>"
			                + "</div>" + "</div>").insertAfter(target);
		} else {
			spinnerObj = $(
			        "<div class=\"spinner\">" + "<div class=\"spinner-arrow\">"
			                + "<div class=\"spinner-arrow-up\"></div>" + "<div class=\"spinner-arrow-down\"></div>"
			                + "</div>" + "</div>").insertAfter(target);
		}
		if (vdefs.cusCls) {
			$(target).addClass(vdefs.cusCls);
		}
		$(target).addClass("spinner-text spinner-f").prependTo(spinnerObj);
		return spinnerObj;
	}
	;
	function resizeSpinner(target, width) {
		var defs = $.data(target, "spinner").defs;
		var spinner = $.data(target, "spinner").spinner;
		if (width) {
			defs.width = width;
		}
		var spinnerArrow = spinner.find(".spinner-arrow");
		spinner._outerWidth(defs.width)._outerHeight(defs.height);
		$(target)._outerWidth(spinner.width() - spinnerArrow.outerWidth());
		// $(target).css({ height : spinner.height() + "px", lineHeight :
		// spinner.height() + "px" });
		var spinnerTextObj = spinner.find("input.spinner-text");
//		spinnerTextObj._outerWidth(spinner.width() - spinnerArrow.outerWidth() - 5);
		
		var oWidth = spinner._outerWidth();
		var textWidth = (spinner.width() - spinnerArrow.outerWidth() - 10) / oWidth;
		textWidth = textWidth.toFixed(2) * 100;
		textWidth = textWidth + "%";
		spinnerTextObj.css({
			width : textWidth
		// height : comboObj.height() + "px",
		// lineHeight : comboObj.height() + "px"
		});
		
		
		// var timeSpinner = spinner.find("input.timespinner-f");
		// if (timeSpinner.length > 0) {
		// spinnerTextObj._outerWidth(spinner.width() -
		// spinnerArrow.outerWidth() - 5);
		// } else {
		// spinnerTextObj._outerWidth(spinner.width() -
		// spinnerArrow.outerWidth() - 5);
		// }
	}
	;
	function bindSpinnerInfo(target) {
		var defs = $.data(target, "spinner").defs;
		var spinner = $.data(target, "spinner").spinner;
		spinner.find(".spinner-arrow-up,.spinner-arrow-down").unbind(".spinner");
		if (!defs.disabled) {
			spinner.find(".spinner-arrow-up").bind("mouseenter.spinner", function() {
				$(this).addClass("spinner-arrow-hover");
			}).bind("mouseleave.spinner", function() {
				$(this).removeClass("spinner-arrow-hover");
			}).bind("click.spinner", function() {
				defs.spin.call(target, false);
				defs.onSpinUp.call(target);
				$(target).inputbox("validate");
			});
			spinner.find(".spinner-arrow-down").bind("mouseenter.spinner", function() {
				$(this).addClass("spinner-arrow-hover");
			}).bind("mouseleave.spinner", function() {
				$(this).removeClass("spinner-arrow-hover");
			}).bind("click.spinner", function() {
				defs.spin.call(target, true);
				defs.onSpinDown.call(target);
				$(target).inputbox("validate");
			});
		}
	}
	;
	function disableOrEnable(target, flag) {
		var defs = $.data(target, "spinner").defs;
		if (flag) {
			defs.disabled = true;
			$(target).attr("disabled", true);
		} else {
			defs.disabled = false;
			$(target).removeAttr("disabled");
		}
	}
	;
	$.fn.spinner = function(defs, param) {
		if (typeof defs == "string") {
			var fun = $.fn.spinner.methods[defs];
			if (fun) {
				return fun(this, param);
			} else {
				return this.inputbox(defs, param);
			}
		}
		defs = defs || {};
		return this.each(function() {
			var spinner = $.data(this, "spinner");
			if (spinner) {
				$.extend(spinner.defs, defs);
			} else {
				var defsTemp = $.extend({}, $.fn.spinner.defaults, $.fn.spinner.getDefs(this),
				        defs);
				spinner = $.data(this, "spinner", {
				    defs : defsTemp,
				    spinner : create(this, defsTemp)
				});
				$(this).removeAttr("disabled");
			}
			spinner.defs.originalValue = spinner.defs.value;
			$(this).val(spinner.defs.value);
			$(this).attr("readonly", !spinner.defs.editable);
			disableOrEnable(this, spinner.defs.disabled);
			resizeSpinner(this);
			spinner.defs.border = false;// remove inner text border
			$(this).inputbox(spinner.defs);
			bindSpinnerInfo(this);
		});
	};
	$.fn.spinner.methods = {
	    defs : function(jq) {
		    var defs = $.data(jq[0], "spinner").defs;
		    return $.extend(defs, {
			    value : jq.val()
		    });
	    },
	    destroy : function(jq) {
		    return jq.each(function() {
			    var spinner = $.data(this, "spinner").spinner;
			    $(this).inputbox("destroy");
			    spinner.remove();
		    });
	    },
	    resize : function(jq, width) {
		    return jq.each(function() {
			    resizeSpinner(this, width);
		    });
	    },
	    enable : function(jq) {
		    return jq.each(function() {
			    disableOrEnable(this, false);
			    bindSpinnerInfo(this);
		    });
	    },
	    disable : function(jq) {
		    return jq.each(function() {
			    disableOrEnable(this, true);
			    bindSpinnerInfo(this);
		    });
	    },
	    getValue : function(jq) {
		    return jq.val();
	    },
	    setValue : function(jq, value) {
		    return jq.each(function() {
			    var defs = $.data(this, "spinner").defs;
			    defs.value = value;
			    $(this).val(value);
		    });
	    },
	    clear : function(jq) {
		    return jq.each(function() {
			    var defs = $.data(this, "spinner").defs;
			    defs.value = "";
			    $(this).val("");
		    });
	    },
	    reset : function(jq) {
		    return jq.each(function() {
			    var defs = $(this).spinner("defs");
			    $(this).spinner("setValue", defs.originalValue);
		    });
	    }
	};
	$.fn.spinner.getDefs = function(target) {
		var t = $(target);
		return $.extend({}, $.fn.inputbox.getDefs(target), $.parser.getDefs(target, [ "width",
		        "height", "min", "max", {
		            increment : "number",
		            editable : "boolean"
		        } ]), {
		    value : (t.val() || undefined),
		    disabled : (t.attr("disabled") ? true : undefined)
		});
	};
	$.fn.spinner.defaults = $.extend({}, $.fn.inputbox.defaults, {
	    width : "auto",
	    height : "auto",
	    value : "",
	    min : null,
	    max : null,
	    increment : 1,
	    editable : true,
	    disabled : false,
	    spin : function(num) {
	    },
	    onSpinUp : function() {
	    },
	    onSpinDown : function() {
	    }
	});
})(jQuery);
