-- --------------------------------------------------------
-- 主机:                           127.0.0.1
-- 服务器版本:                        5.6.10 - MySQL Community Server (GPL)
-- 服务器操作系统:                      Win32
-- HeidiSQL 版本:                  9.1.0.4867
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8mb4 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

-- 导出 infocomshop 的数据库结构
DROP DATABASE IF EXISTS `infocomshop`;
CREATE DATABASE IF NOT EXISTS `infocomshop` /*!40100 DEFAULT CHARACTER SET gb2312 */;
USE `infocomshop`;


-- 导出  表 infocomshop.ad 结构
DROP TABLE IF EXISTS `ad`;
CREATE TABLE IF NOT EXISTS `ad` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `remark` longtext,
  `inputdatetime` datetime DEFAULT NULL,
  KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=gb2312;

-- 正在导出表  infocomshop.ad 的数据：~7 rows (大约)
DELETE FROM `ad`;
/*!40000 ALTER TABLE `ad` DISABLE KEYS */;
INSERT INTO `ad` (`id`, `title`, `pic`, `url`, `remark`, `inputdatetime`) VALUES
	(8, ' vxcvxvcx', 'images\\t018d22f70471e7caf7.jpg', NULL, '&nbsp;xcvxvcx', '2015-06-14 15:20:03'),
	(13, 'fsdfsdf', 'images\\20120228151246457731.jpg', NULL, '&nbsp;sdfsdfsdf', '2015-06-14 15:47:20'),
	(14, '江西省抚州市信通网络科技有限公司', 'images\\jxfzxtbanner.jpg', 'http://localhost:8080/jxfzxtnet', '&nbsp;fsdfsdfsfsdsafsafadsdfsfasfsdafassdfafdaf', '2015-08-01 10:46:11'),
	(15, '信通商务网', 'images\\adbanner2.jpg', 'http://localhost:8080/infocomb2b', 'sdfsfsdfsdf', '2015-06-15 20:31:41'),
	(16, 'gdfgdfg', 'images\\19300000229465132005613047770_950.jpg', NULL, 'gfdgfdgfd', '2015-06-14 20:35:23'),
	(19, 'fdsfdsfsf', 'images\\banner.jpg', '', '', '2015-07-27 13:29:52');
/*!40000 ALTER TABLE `ad` ENABLE KEYS */;


-- 导出  表 infocomshop.admin 结构
DROP TABLE IF EXISTS `admin`;
CREATE TABLE IF NOT EXISTS `admin` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `adminname` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=gb2312;

-- 正在导出表  infocomshop.admin 的数据：~0 rows (大约)
DELETE FROM `admin`;
/*!40000 ALTER TABLE `admin` DISABLE KEYS */;
INSERT INTO `admin` (`Id`, `adminname`, `password`) VALUES
	(1, 'admin', '123456789');
/*!40000 ALTER TABLE `admin` ENABLE KEYS */;


-- 导出  表 infocomshop.bigtype 结构
DROP TABLE IF EXISTS `bigtype`;
CREATE TABLE IF NOT EXISTS `bigtype` (
  `bigtypeid` int(11) NOT NULL AUTO_INCREMENT,
  `bigtypename` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`bigtypeid`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=gb2312;

-- 正在导出表  infocomshop.bigtype 的数据：~14 rows (大约)
DELETE FROM `bigtype`;
/*!40000 ALTER TABLE `bigtype` DISABLE KEYS */;
INSERT INTO `bigtype` (`bigtypeid`, `bigtypename`) VALUES
	(1, '通信'),
	(2, '电视'),
	(3, '音箱'),
	(4, '食品'),
	(5, '服装'),
	(6, '袜子'),
	(7, '鞋'),
	(8, '皮具'),
	(9, '电脑'),
	(10, '数码'),
	(11, '汽车'),
	(12, '房地产'),
	(13, '家具'),
	(14, '书籍');
/*!40000 ALTER TABLE `bigtype` ENABLE KEYS */;


-- 导出  表 infocomshop.news 结构
DROP TABLE IF EXISTS `news`;
CREATE TABLE IF NOT EXISTS `news` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `author` varchar(255) DEFAULT NULL,
  `newstype` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `content` text,
  `recommend` int(11) DEFAULT NULL,
  `cc` varchar(255) DEFAULT NULL,
  `publicdatetime` datetime DEFAULT NULL,
  `visit` int(11) DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=46 DEFAULT CHARSET=gb2312;

-- 正在导出表  infocomshop.news 的数据：~11 rows (大约)
DELETE FROM `news`;
/*!40000 ALTER TABLE `news` DISABLE KEYS */;
INSERT INTO `news` (`Id`, `title`, `author`, `newstype`, `pic`, `content`, `recommend`, `cc`, `publicdatetime`, `visit`) VALUES
	(18, '马云：收购雅虎的200多亿美元早就做了准备', '崔西 云芳', '行业新闻', 'images\\U5009P2T1D6189106F13DT20111017173256.jpg ', '&nbsp;&nbsp;&nbsp;&nbsp; 新浪科技讯 10月17日下午消息，马云(微博)在今日举行的淘宝商城媒体恳谈会上表示，阿里巴巴(微博)早就为收购雅虎的200多亿美金做了准备。此次淘宝商城新规提高服务费并非是为了圈钱买雅虎。<BR>　　“我们是互联网公司中现金储备最多的公司，我们为200多亿美金早就做了准备。”专程从美国赶回来的马云在媒体恳谈会上在解释淘宝遭围攻事件时一并谈到了收购雅虎的传闻。<BR>　　马云表示，外界认为淘宝新规是为收购雅虎“圈钱”的说法并不确切。阿里巴巴早就开始准备收购需要的200多亿美金。随后有提问问到阿里是否确认要竞购雅虎，马云回应说：“我只能告诉你，钱我们早筹备了，其他的还真不能说。”<BR>　　面对媒体对此事的追问，马云在现场再三表示涉及雅虎的事情不好表态，希望大家理解。他表示雅虎对阿里巴巴很重要，自己对雅虎的兴趣也没有改变过。“如果能做什么，我们当然希望做，今天不能讲怎么做，以后会给大家讲讲怎么做。”<BR>　　现场的一个细节是，马云来参会前在手上写了四五个“忍”字，在回答雅虎这个问题前他看了看手上的这些“忍”字。', NULL, '新浪科技', '2011-10-19 13:57:09', NULL),
	(28, '2011年中国网购奢侈品市场规模达107亿元', '', '行业新闻', 'images\\1323844853405.gif ', '&nbsp;\r\n<P>【TechWeb报道】12月14日消息，艾瑞咨询近期推出2011年中国奢侈品网络购物行业研究报告》，针对中国奢侈品网络购物市场现状深入探讨。报告研究数据显示，中国内地2010年奢侈品网络购物交易规模（C2C部分与B2C部分合计）为63.6亿元，2011年交易规模预计将达107.3亿元，实现68.8%的年增长。艾瑞同时预计2015年中国网购奢侈品交易规模或将达到372.4亿元。</P>\r\n<P style="TEXT-ALIGN: center">艾瑞还在报告中介绍道，根据我国网络购物市场交易规模核算，奢侈品品类占网络购物交易规模的比例均保持在1-2%之内，其2010年占比为1.38%，预计2011年其占比为1.41%。从奢侈品网络购物交易规模占国内奢侈品交易规模的比例来看，2010年其渗透率为3.16%，2011年渗透率将达到4.37%，预计2015年奢侈品网购占比将达到8.03%。</P>', NULL, 'TechWeb.com.cn ', '2011-12-14 22:14:57', NULL),
	(29, '2011年电商行业盘点：交易规模将超7500亿元', '乐天', '行业新闻', 'images\\img20111213236712450.jpg ', '&nbsp;\r\n<P style="TEXT-INDENT: 2em"><STRONG>腾讯科技讯</STRONG>（乐天）12月12日消息，艾瑞分析师丁佳琪、张晶近日发布报告，预计2011年网购市场交易规模超7500亿元。第四季度为网络购物高峰期，环比增速将超过15.0%，其中国庆节、双十一光棍节、以及圣诞节、元旦春节等节日气氛促进网络购物高速增长。</P>\r\n<P style="TEXT-INDENT: 2em">2011年网络购物行业延续了2010年高速发展的势头，前三季度同比增速保持在70%以上，同时呈现多个特点。资本方面，行业经历了先热后冷的过程，从2011年下半年开始，部分B2C企业遇到资金吃紧或IPO受阻等困难；</P>\r\n<P style="TEXT-INDENT: 2em">企业经营方面，各类型网购企业纷纷加速横向业务扩展和纵向供应链建设，增强核心竞争力；与此同时，传统企业开展电子商务成为大势，明确业务定位是其成败关键；各大领先电商企业纷纷推出手机客户端，布局手机购物市场；</P>\r\n<P style="TEXT-INDENT: 2em">此外，网络购物跨越式发展，使得消费者权益保护成为一大问题，消费者维权成热点。展望2012年，中国网络购物行业将进一步成熟，精细化、规范化和规模化将是主要特色。</P>\r\n<P style="TEXT-INDENT: 2em"><STRONG>盘点一：资本市场前热后冷，部分企业资金压力增大</STRONG></P>\r\n<P style="TEXT-INDENT: 2em"><STRONG>相关事件一：上半年融资事件频发，下半年投融资笔数减少</STRONG></P>\r\n<P style="TEXT-INDENT: 2em">2011年上半年，除京东商城外，诸多细分领域的电商企业获得融资。鞋类领域，1月份乐淘网宣布获得2亿元融资，3月份，好乐买获得6000万美元。天天网、聚美优品、米奇网等化妆品类、米兰网、聚尚网、尊库网等时尚奢侈品网站及麦包包、七格格、绿盒子、斯波帝卡等淘品牌纷纷获得注资。从7月份开始，下半年网络购物领域的融资事件，相较上半年，有所减少。</P>\r\n<P style="TEXT-INDENT: 2em"><STRONG>相关事件二：海外上市遇冷，多家企业IPO计划延期</STRONG></P>\r\n<P style="TEXT-INDENT: 2em">2011年中国企业境外IPO遭冷遇，一些综合B2C、垂直B2C和团购网站均传出海外上市的计划或意愿，但截止11月下旬仍没有一家新电商企业成功上市。典型的企业为拉手网，2010-2011年总共融资1.66亿美元，累计亏损人民币4.7亿元，今年10月底，正式启动赴美上市计划，计划通过IPO融资1亿美元，但因各种缘由，目前已停止IPO计划。同样，凡客诚品赴美上市的消息一直没有间断过，直至11月20日凡客诚品并未如期上市。</P>\r\n<P style="TEXT-INDENT: 2em"><STRONG>相关事件三：电商企业倒闭，市场渐现洗牌潮</STRONG></P>\r\n<P style="TEXT-INDENT: 2em">2011年部分电商企业因战略定位、运营不善而出现倒闭或转型。一类是传统企业，如美邦服饰剥离邦购网至其母公司上海华服投资有限公司。第二类是团购企业，后半年出现较多裁员、撤站、降薪事件，如长沙本土团购网站搜团网、厦门本土团购网站E团网等地方网站陆续关闭；全国性团购网站24券淮安站关闭，窝窝团整体裁员约500人，将目前35个5线城市由完整的10-20人团队配置，缩减至2-3人。三是部分垂直B2C，如大货栈、西米网、淘鹊网、爱挑食网、七十二变零食网等不堪高额运营成本的压力而倒闭或转型。</P>\r\n<P style="TEXT-INDENT: 2em"><STRONG>艾瑞点评</STRONG></P>\r\n<P style="TEXT-INDENT: 2em">电子商务行业融资环境的变化，主要原因有二：一是中概股企业诚信问题以及政府对VIE协议态度不明朗的影响，加大了海外风险基金投资国内电商企业的整体风险；二是过去一年中，电子商务行业融资过热，形成一定的泡沫，目前资本方面进入调整期，投资有所缩减。</P>\r\n<P style="TEXT-INDENT: 2em">发展方向：考虑到行业的增长潜力，未来电子商务行业仍将是互联网领域中资本投资的重点，并且电商领域投资热点将转向创新模式、垂直品类及配套服务等细分领域，如11月刚获得融资的购物分享社区美丽说、礼品类的唯礼网等。</P>\r\n<P style="TEXT-INDENT: 2em"><STRONG>盘点二：网络购物企业通过横向拓展与纵向供应链建设</STRONG></P>\r\n<P style="TEXT-INDENT: 2em"><STRONG>相关事件一：巨头投资加大，电商企业横向扩展业务范围</STRONG></P>\r\n<P style="TEXT-INDENT: 2em">一方面京东商城、亚马逊中国、当当网、苏宁易购等综合商城纷纷拓充网站商品品类。2011年京东商城新进入图书、医药、奢侈品等领域；亚马逊中国、当当网开放平台，持续推进百货化；苏宁易购也从主营家电数码向图书、百货拓展。</P>\r\n<P style="TEXT-INDENT: 2em">另一方面，部分垂直B2C网站也开始加速品类扩充。2月B2C购物网站红孩子推出缤购网，专营化妆、食品、保健、家居等商品品类；8月意大利品牌Redsand（红砂）入驻好乐买，好乐买也从以运动品牌为主，向休闲、户外、女鞋、男鞋品牌的扩展；10月优购网高管先后表示，优购网定位渠道品牌，未来将引进更多商品品类和品牌。</P>\r\n<P style="TEXT-INDENT: 2em"><STRONG>相关事件二：电商企业纵向加速供应链整合</STRONG></P>\r\n<P style="TEXT-INDENT: 2em">2011年5月，<SPAN class=infoMblog>阿里巴巴集团</SPAN>与交通银行全面达成战略合作，双方将在快捷支付、手机支付、中小企业网络融资等众多方面开展合作。6月，阿里巴巴集团与广发银行签署全面战略合作协议，加强在快捷支付、联名卡、中小企业金融合作等领域的深入合作。</P>\r\n<P style="TEXT-INDENT: 2em">2011年1月，阿里巴巴集团在北京发布物流战略，通过“物流宝”平台大力推进物流信息管理系统，由集团层面主导、投入100亿元的资金着手兴建全国性仓储网络平台。京东正在建设6个亚洲一号仓库，预计2012年将在350个城市实现自建物流配送，未来两年内实现35个城市“211限时达”。此外，10月当当网启动百城战略，全国普及次日达、刷卡付费；11月麦考林1000多个城市实现货到付款，上门退货退现金。</P>\r\n<P style="TEXT-INDENT: 2em"><STRONG>相关事件三：网络购物领域价格战频频上演</STRONG></P>\r\n<P style="TEXT-INDENT: 2em">2011年网络购物市场价格战不断。先是2011年初，京东商城上线图书，掀起京东商城、当当网与卓越亚马逊三方的多轮图书价格战；之后3C类购物网站又启动另一轮价格战，尤其十一期间，京东商城、当当网、苏宁易购、国美(<SPAN class=infoMblog>微博</SPAN>)库巴、亚马逊等纷纷加入其中。此外，双十一光棍节，淘宝商城、京东商城等均上演大规模促销。目前各家正为随后的圣诞节、元旦春节策划营销活动。</P>\r\n<P style="TEXT-INDENT: 2em"><STRONG>艾瑞点评</STRONG></P>\r\n<P style="TEXT-INDENT: 2em">市场格局：中国网络购物行业经过十几年的发展，尚处于战国时代，市场格局仍有很大变数。考虑到中国多数消费者仍为价格敏感型用户，价格战成为网络购物企业获取用户的重要利器。</P>\r\n<P style="TEXT-INDENT: 2em">发展方向：网络购物企业若想占据市场领先地位并且培养核心竞争力，拓展产品品类、丰富产品线与加强供应链、完善物流配送体系将是企业发展的重要方向。艾瑞咨询预计，上述现象仍将是未来三年中国网络购物行业发展的重要特征。</P>\r\n<P style="TEXT-INDENT: 2em"><STRONG>盘点三：传统企业进一步发力电商，明确业务定位是关键</STRONG></P>\r\n<P style="TEXT-INDENT: 2em"><STRONG>相关事件一：传统企业全网分销业务发展迅猛</STRONG></P>\r\n<P style="TEXT-INDENT: 2em">传统企业通过制定合理的全网营销战略，线上销售的水平屡创新高。来自淘宝的数据，2011年，仅在淘宝分销平台上进行分销的供应商或品牌商达8.1万家，入驻的分销商达130万家，参与分销的品牌商中传统企业占据重要份额，典型的企业有波司登、艾美特、Thinkpad、帮宝适、博洋家纺、澳优、TCL、惠氏、格兰仕等。</P>\r\n<P style="TEXT-INDENT: 2em">此外，传统企业的网络旗舰店在2011年体现出极强的实力。2011年淘宝双十一光棍节促销当天，传统企业旗舰店GXG、骆驼服饰、博洋家纺三家的销量超过4000万，杰克琼斯的销量突破3000万，富安娜、真维斯、水星家纺三家突破2000万。</P>\r\n<P style="TEXT-INDENT: 2em"><STRONG>相关事件二：传统企业自建网站收效甚微</STRONG></P>\r\n<P style="TEXT-INDENT: 2em">近年来，随着苏宁易购网正式上线，银泰集团推出银泰网，国美收购库巴网（原世纪电器网）80%股份，富士康推出飞虎乐购，中国邮政推出邮乐网，中粮集团创立我买网等，百丽新推优购网，国内大型传统企业纷纷进入电子商务市场。</P>\r\n<P style="TEXT-INDENT: 2em">目前，以苏宁易购为代表的传统企业发展较为平稳，连续3个季度销售额均超过10亿元，跻身中国B2C网络购物市场前五。同时，部分传统企业电商平台发展远低于预期，其中邦购网被剥离，飞虎乐购拟剥离百货业务，李宁、九阳等传统企业电子商务负责人纷纷离职，种种迹象表明传统企业涉水电商市场并非易事。</P>\r\n<P style="TEXT-INDENT: 2em"><STRONG>艾瑞点评</STRONG></P>\r\n<P style="TEXT-INDENT: 2em">发展状况：传统企业已普遍意识到电子商务的发展机遇，积极尝试线上业务；但是对于电子商务业务的定位，各家略有差异。多数企业将电子商务作为其一个新销售渠道，依靠淘宝此类平台，构建线上分销渠道。部分企业则将电子商务作为一个新机会，尝试构建自营的线上零售渠道。总结目前中国传统企业电子商务业务的发展状况，艾瑞咨询发现，依靠平台发展的模式整体发展状况好于自营线上零售渠道的模式的发展状况。</P>\r\n<P style="TEXT-INDENT: 2em">发展方向：艾瑞咨询认为，传统企业开展电子商务业务已成大势。传统企业做电商核心优势在于货源，如何合理定位线上业务，并配以恰当的运营策略及时满足消费者需求，是传统企业在未来电子商务发展中首要解决的问题。</P>\r\n<P style="TEXT-INDENT: 2em"><STRONG>盘点四：移动电商崭露头角</STRONG></P>\r\n<P style="TEXT-INDENT: 2em"><STRONG>相关事件一：电商企业纷纷推出客户端</STRONG></P>\r\n<P style="TEXT-INDENT: 2em">随着移动互联网用户规模的快速增长以及网民上网习惯的转变，电商企业开始布局移动互联网市场。今年2月京东商城iPhone客户端上线；2月凡客诚品全面支持手机购物，并在3月推出手机秒杀活动；4月手机淘宝开放平台，构建移动互联网盈利基础平台；5月麦考林继苹果客户端后再推安卓客户端。</P>\r\n<P style="TEXT-INDENT: 2em"><STRONG>相关事件二：手机购物行业仍处于发展初期</STRONG></P>\r\n<P style="TEXT-INDENT: 2em">各家企业推出手机购物初见成效，凡客诚品每天来自手机平台的成交量在1.5万单左右；当当网每天来自移动客户端的下单量已经超过7000单；乐淘客户端下载激活量共计160万，占比6.5%，仅次于凡客；6月京东商城手机下单日交易额已达200万；淘宝移动电商上半年收入为45亿元，而双十一当天，淘宝商城手机版交易额突破1.5亿元。</P>\r\n<P style="TEXT-INDENT: 2em"><STRONG>艾瑞点评</STRONG></P>\r\n<P style="TEXT-INDENT: 2em">发展阶段：艾瑞最新数据显示，2011Q3手机电子商务（C2C和B2C网购部分）交易规模为37.7亿元，同比增长508.1%，继续保持迅猛的发展态势。同时，2011Q3中国网络购物（不含手机端）市场规模达到1975.1亿元，相比之下，手机购物仍处于发展初期。</P>\r\n<P style="TEXT-INDENT: 2em">增长原因：随着智能手机的普及，移动近程通讯技术（包括NFC、RFID等）的应用，手机上网用户规模的增加，以及各大电商企业的积极推动，中国用户的移动购物习惯正逐步养成，移动互联网、移动电商正逐步成为网络购物生态系统中的重要环节。</P>\r\n<P style="TEXT-INDENT: 2em">发展瓶颈：移动电商实时性、便捷性、区域性等优势逐步显现，目前移动电商发展主要受制于手机购物用户规模较小、手机支付及网络环境（带宽、资费等）不完善。未来移动电商将逐步消除以上制约因素，保持高增长态势。</P>\r\n<P style="TEXT-INDENT: 2em"><STRONG>盘点五：网上消费投诉多，消费者维权成热点 </STRONG></P>\r\n<P style="TEXT-INDENT: 2em"><STRONG>相关事件：网络购物投诉多</STRONG></P>\r\n<P style="TEXT-INDENT: 2em">网络购物市场发展快速，尤其团购市场从去年开始到今年上半年得到了飞跃式的发展，其中也伴随不少问题。截止2011年10月初，福州市工商局已受理团购相关申诉141件，较去年同期的7件增长20倍。同时，五一、十一黄金周期间的网络消费投诉增长显著，北京市2011年十一期间共受理网上购物消费投诉1204件，占整体投诉量的40.8%。</P>\r\n<P style="TEXT-INDENT: 2em"><STRONG>艾瑞点评</STRONG></P>\r\n<P style="TEXT-INDENT: 2em">这些现象出现，并且维权较为困难，主要原因有如下三类：一是网上交易自身特点，消费者容易遇到钓鱼网站和个人信息泄露等情况，并且购物欺骗相关事件发生后难以追溯犯罪源；二是国内网站仍处于高速发展期，现阶段物流配送等基础服务仍有欠缺，尤其在节假日和大型促销活动时凸显；三是网购政策空白多，如打折前提价、产品与网站描述不符等问题频现，对于企业缺乏相应监管措施和能力。</P>\r\n<P style="TEXT-INDENT: 2em">解决措施：第一类问题需要政府、行业协会及相关企业加大宣传力度，增强消费者网购安全意识，从用户角度进行有效规避；第二类问题需要网络购物产业链各参与者加强自身建设，提高服务能力，以此提升消费者购物满意度；第三类问题需要政府相关部门、电商行业协会和各大电商企业的共同重视和努力，从商家信誉认证和货源渠道公开等方面入手，为消费者提供一个规范、可信的网上消费环境。</P>', NULL, '腾讯科技讯', '2011-12-14 22:17:21', NULL),
	(36, '创客为何选择前海 ？又为何犹豫', '陈熊海 ', '行业新闻', 'images\\Img418036612.jpg', '&nbsp;\r\n<DIV align=center><FONT style="FONT-SIZE: 12px">按计划，梦工场可容纳约200家创业企业和团队入驻。南都资料图</FONT></DIV>\r\n<P sizset="55" sizcache003332695723833906="21">　　上周四（7月30日），首家进入前海深港青年梦工场的孵化器―前海厚德孵化器举行首期团队毕业典礼，第一期17家团队毕业，其中有一个团队已经进入A轮投资，半数以上获得了天使轮和种子轮投资。节事传媒、学成旅游、P rintact作为其中的成员，他们为何选择前海？又为何有所犹豫？<A href="http://product.it.sohu.com/list/subcate_685_1.html" target=_blank>其他</A>没有选择前海的团队，又因何止步？</P>\r\n<P>　　入驻</P>\r\n<P>　　进入梦工场有两渠道向孵化器申请更方便</P>\r\n<P>　　节事传媒的创始人陈峥所在的团队，从2009年开始就为媒体做活动现场的短信互动平台，当时不少电视台节目为了调动现场氛围，对这方面需求比较大。</P>\r\n<P sizset="56" sizcache003332695723833906="21">　　后来由于智能<A href="http://product.it.sohu.com/list/subcate_57_1.html" target=_blank>手机</A>、微信的出现，2011年起该团队转向移动互联网，2013-2014年开始研究利用app的互动解决方案。“当时我们找到前海厚德，也是希望借此转型，填补国内活动管理工具的空白”。</P>\r\n<P>　　“2014年5月我们团队离开原公司，后来参加了厚德孵化器的创业魔法学院课程，大约在去年年底向厚德申请进驻、路演，今年4月份成功进驻”。据陈铮介绍，进入前海深港青年梦工场有两个渠道，一个是官方渠道，另一个是向孵化器申请。和官方渠道比，向孵化器申请方便一些。之所以选择进入前海厚德，一方面是考虑到品牌效应，另一方面厚德也与清华大学校训“厚德载物”相关，自己看到后有一种共鸣。</P>\r\n<P>　　据陈铮介绍，前海的政策只是一方面，其更看重的还是在前海的创业氛围、活动、视野，有很多和国际接触的机会，例如前海和硅谷签署战略合作协议，打造“前海硅谷国际+孵化加速平台”。另外，前海的税收优惠、免除场地费用、水电费用这些措施也为创业团队减轻不少负担，陈铮提到，前海以及孵化器这个平台可以找人辅导路演、提供资金、管理等服务，“让自己的团队专注于产品和技术，剩下的事情则依靠平台”。</P>\r\n<P>　　陈铮团队的产品今年5月开发，目前进行了初步市场调查，预计8月上线。陈铮表示，“融资和路演完全依托于孵化器，一开始先做深圳市场，然后再打造一个区域市场，进行商业模式验证，目前需要大约200万元的天使投资”。</P>\r\n<P>　　对此，前海厚德孵化器相关人员表示，厚德有一个前海英诺天使投资基金，是厚德孵化器的一个投资基金，可以帮助创业团队融资，也可以帮助创业团队找寻其他投资人、对接政府，“政府对市场的把握不够，但这些创业团队更多的还是靠市场运作”。</P>\r\n<P>　　现状</P>\r\n<P>　　香港团队入驻火爆</P>\r\n<P>　　望能改善园区住宿</P>\r\n<P>　　何颖菁，土生土长的香港女孩，2013年大学毕业后，她和几个朋友一起，创办了一间名为“学成旅游”的公司，主打香港学生群体游学市场，目前已经开辟了韩国、新加坡、马来西亚等多条线路。2014年底，该团队进驻前海深港青年梦工场</P>\r\n<P>　　据何颖菁创业团队中的一位员工介绍，今年3-6月他们一直在前海梦工场完成项目，每周5-6天住在深圳，因为人才驿站未整修好没法入住，只好在大新地铁站旁租了一个房子，租了3个多月，“价钱大约1200，并且还是一套房被隔成很多间的那种，当时就期盼着人才公寓早点开放就不用这么麻烦了。”</P>\r\n<P>　　虽然目前前海区内已经开通接驳车、电动公交往返地铁站、南山区、宝安区，但仍旧有不便之处。该员工表示，她住在宝安区，3月来到前海梦工场工作的时候都是要坐到大新地铁站转乘公交坐到前海区内，“公交特别少，大约半小时1班，后来5月鲤鱼门地铁站有了接驳车，6月份前海区内自己运营的电动巴士开通，稍稍方便了一些，但有一个最大的问题是不能加班，电动车在晚上7：00结束运营，加班就坐不了，只能用手机软件叫车。”</P>\r\n<P>　　据南都记者观察，前海区内电动巴士上下班时间人数较多，运力紧张。另外前海虽开通了深圳湾口岸环线的接驳公交，但班次仍旧不多。前海往来香港的车也只有上下班时间各一趟，且需前往深圳湾口岸接驳。</P>\r\n<P sizset="57" sizcache003332695723833906="21">　　D ata所创立的printact团队同样遭遇这些问题。去年底香港大学博士毕业的D ataN g，2013年在学校时便已开始进行并联式立体<A href="http://product.it.sohu.com/list/subcate_828_1.html" target=_blank>3D打印机</A>的制作研发，后创立printact团队。一开始在学校附近创业，后来在厚德孵化器合作伙伴香港企业家俱乐部的引荐下进入前海深港青年梦工场。</P>\r\n<P>　　D ata说，他们进驻前海的初衷是了解内地市场。据Data介绍，他们把香港的设计复制过来，然后去华强北采购零件，“和香港比，华强北是中国最大的电子元器件市场，可以买到自己需要的很多配件，比较方便，还可免关税。”</P>\r\n<P>　　基础设施不足也是困扰Printact团队在此工作的一大难题。目前Printact团队两个人，一周只在前海呆1-2天，从香港前往深圳湾口岸再到前海，当天往返，“每天在路上要耗费3-4小时，前海往返香港的车只有早上、下午上下班时各一班，如果错过了就只能自己坐车。”</P>\r\n<P>　　生活上，D ata说，今年头3个月梦工场附近也没有吃饭的地方，后来开了7-11等便利店有所改善。</P>\r\n<P>　　人才公寓、交通、生活配套的不完善，导致部分香港团队或香港青年并没有长期入驻前海梦工场的打算。也有区内人员表示，基础设施、生活配套的不便让他们招人都有些困难。据梦工场一工作人员介绍，很多香港团队办公桌空着，而一些和香港有关的孵化器也还没有人，这需要一个过程。</P>\r\n<P>　　据悉，人才公寓是目前前海梦工场唯一没有投入使用的建筑。按照最初规划，人才公寓规模在160人之内，分为2、4、6人间不等。但随着梦工场投入使用，团队入驻火爆，不少创业者都希望能够在园区内住宿，为此，公寓正在进行小规模地改造。</P>\r\n<P>　　交通方面，在梦工场出入口，由前海方面提供的电动车免费接送乘客到前海区内地铁、公交站，另外，每日上下班往来香港的跨境巴士也于去年底开通。</P>\r\n<P>　　建议</P>\r\n<P>　　生物技术产业门槛高</P>\r\n<P>　　望资金和政府能支持</P>\r\n<P>　　在深圳长大的小马，曾就读于港科大，去年在深圳成立了一家重组蛋白药物研发的公司。小马说，重组方法相较提取方法有一定优势，目前内地这方面技术不足。</P>\r\n<P>　　来深创业，一方面是内地市场较大，深圳生物技术研发公司较少；另一方面是香港的支持资源不够，深圳创业氛围较好，自己也熟悉。目前，小马的公司入驻深圳南山区科技园香港科技大学孵化基地。他说，入驻学校的孵化器有一定的学校资源支持，如租金约110元/平方米，比外面便宜10-20元。</P>\r\n<P>　　为何不选择在前海自贸区创业？小马表示，主要是产业原因。由于其企业从事生物制药的研发工作，首先需要实验室，门槛比较高。“之前我们和前海也接触过，虽然他们大力引进科技服务业，但以互联网、硬件等产业为主。另外，前海青年梦工场缺乏建造生物实验室的条件，门槛同样很高。像一个生物实验室至少要200万元”。</P>\r\n<P>　　真正的孵化器不仅仅是提供物业，还要看在其它方面能做到多细致，希望相关机构能为这类企业提供公共实验室平台“。</P>\r\n<P>　　“很多生物技术的研发需要8-10年才能有成果，按照资本运行的逻辑，投资人一般很少选择生物技术产业投资，比较偏好回报快、资金周转率高的行业。”但其实从行业角度讲它更需要政府的帮助。</P>\r\n<P>　　据悉，前海并非不支持生物相关产业的发展，生物技术产业已被列入前海的产业目录中，在前海发布的企业所得税优惠目录中，生物医药、基因测序、干细胞、功能蛋白、生命健康等新兴科学技术研发与服务仍作为前海科技服务业中的条目出现。</P>\r\n<P>　　前海深港青年梦工场</P>\r\n<P>　　A</P>\r\n<P>　　近百家团队入驻逾1/3来自香港</P>\r\n<P>　　前海深港青年梦工场是前海区内特别搭建的供深港两地青年创业团队入驻的主要平台，由前海管理局投资建设，深圳市青年联合会及香港青年协会联合运营。按照计划，梦工场可容纳约200家创业企业和团队入驻。截至5月底，前海深港青年梦工场已经吸引了8-9家来自内地及香港的创业孵化器入驻，包括厚德、中科院、电信、联想之星、香港互联网专业协会等，近百家团队已确定入驻，其中超过1/3为香港团队。这些创业团队的领域涉及智能硬件、移动互联网、电子商务、大数据、动漫、微电影、新媒体、3D打印、设计模拟、新能源、新材料等各方面。</P>\r\n<P>　　梦工场项目占地面积约3.9万平方米、建筑面积约2.7万平方米，由7栋功能、形态各异的钢结构建筑和1栋智慧前海业务机房组成。梦工场1号楼设有会议及展览中心，目前已经举办了不少展览、座谈会、工作坊等。多功能创新中心则提供综合多媒体互动平台，团队路演、讲座培训都在此进行。此外，照顾到青年创业者多方面的需求，中、小型会议室及多功能演讲厅等都配备得十分齐全。在各建筑群中央，还有一个宽阔的青年广场，作为各创业者聚会议论及表演的地方。除此之外，还有运动设施包括5人小型足球场、篮球场、网球场，一条全长1150米的缓跑径及一个休闲的后花园，目前已经全部启用。</P>\r\n<P>　　B</P>\r\n<P>　　在前海创业可享受两“区”叠加双优惠</P>\r\n<P>　　从政策上来说，前海梦工场创业团队可以享受前海深港合作区和广东自贸区的所有优惠政策，不仅可享受企业和个人税收优惠，更可享一定时期内免除场地租金。</P>\r\n<P>　　按照规定，入驻前海的优惠目录企业都将按15%的税率征收企业所得税，境外高端和紧缺人才可享15%个人工资薪金所得税优惠，由深圳市政府以财政补贴形式归还。入驻孵化器的团队，第一年可享受免租金，第二年租金减半。</P>\r\n<P>　　资金方面，香港创业者在前海设立的企业可申请专项扶持，扶持方式包括贷款贴息和财政资助，最高可达200万元，另外还有前海区内的众多金融服务机构覆盖，享受相应金融创新业务。</P>\r\n<P>　　另外，入驻梦工场的创业团队还可享受拎包入住、一站式创业服务、深港通讯资费方面的优惠，包括投融资、会计、法律等咨询服务，协助企业与团队解决在创业过程中遇到的各种困难与问题。</P>\r\n<P>　　采写：南都记者陈熊海</P><!-- seo标签描述 -->\r\n<DIV style="DISPLAY: none"><SPAN id=url itemprop="url">http://it.sohu.com/20150803/n418036611.shtml</SPAN> <SPAN id=indexUrl itemprop="indexUrl">it.sohu.com</SPAN> <SPAN id=isOriginal itemprop="isOriginal">false</SPAN> <SPAN id=sourceOrganization itemtype="http://schema.org/Organization" itemscope itemprop="sourceOrganization"><SPAN itemprop="name">综合</SPAN></SPAN> <SPAN id=author itemtype="http://schema.org/Organization" itemscope itemprop="author"><SPAN itemprop="name">南方都市报/陈熊海</SPAN></SPAN> <SPAN id=isBasedOnUrl itemprop="isBasedOnUrl">http://epaper.oeeee.com/epaper/A/html/2015-08/03/content_3452341.htm?div=-1</SPAN> <SPAN id=genre itemprop="genre">report</SPAN> <SPAN id=wordCount itemprop="wordCount">4800</SPAN> <SPAN id=description itemprop="description">按计划，梦工场可容纳约200家创业企业和团队入驻。南都资料图上周四（7月30日），首家进入前海深港青年梦工场的孵化器―前海厚德孵化器举行首期团队毕业典礼，第一期</SPAN> </DIV>', 1, '南方都市报', '2015-08-03 21:02:23', NULL),
	(37, 'SNH48当一日店长 富士影像旗舰店Wonder Photo Shop在魔都开业', 'alsed', '行业新闻', 'images\\53F1E679354A513AA2C4CA3AA4823705.jpg', '&nbsp;\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 2em; MARGIN: 26px 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px 宋体, sans-serif; WHITE-SPACE: normal; COLOR: rgb(37,37,37); WORD-SPACING: 0px; PADDING-TOP: 0px; -webkit-text-stroke-width: 0px">今天上午，如果你正巧路过魔都来福士对面的高盛商厦，一定会看见西藏中路192号的门前被围了个水泄不通。今日，富士影像旗舰店Wonder Photo Shop在这里开业，而那些围观的群众中有很大一部分人是另有目的。因为今天的开业仪式，SNH48的6名成员也会到场，所以才引来了大批粉丝的围观。</P>\r\n<P style="PADDING-BOTTOM: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 2em; MARGIN: 26px 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px 宋体, sans-serif; WHITE-SPACE: normal; COLOR: rgb(37,37,37); WORD-SPACING: 0px; PADDING-TOP: 0px; -webkit-text-stroke-width: 0px" align=center><IMG style="BORDER-RIGHT-WIDTH: 0px; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; VERTICAL-ALIGN: top; BORDER-LEFT-WIDTH: 0px" src="http://localhost:8080/infocomshop/admin/news/SNH48当一日店长%20富士影像旗舰店Wonder%20Photo%20Shop在魔都开业_网易数码_files/53F1E679354A513AA2C4CA3AA4823705.jpg"></P>\r\n<P style="PADDING-BOTTOM: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 2em; MARGIN: 26px 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px 宋体, sans-serif; WHITE-SPACE: normal; COLOR: rgb(37,37,37); WORD-SPACING: 0px; PADDING-TOP: 0px; -webkit-text-stroke-width: 0px" align=center><IMG style="BORDER-RIGHT-WIDTH: 0px; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; VERTICAL-ALIGN: top; BORDER-LEFT-WIDTH: 0px" src="http://localhost:8080/infocomshop/admin/news/SNH48当一日店长%20富士影像旗舰店Wonder%20Photo%20Shop在魔都开业_网易数码_files/BCFE6A3CCC69A938024A0BE826A96085.jpg"><BR>（<SPAN style="LINE-HEIGHT: 22px">富士影像旗舰店Wonder Photo Shop外的SNH48粉丝</SPAN><SPAN style="LINE-HEIGHT: 22px; TEXT-INDENT: 2em">）</SPAN></P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 2em; MARGIN: 26px 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px 宋体, sans-serif; WHITE-SPACE: normal; COLOR: rgb(37,37,37); WORD-SPACING: 0px; PADDING-TOP: 0px; -webkit-text-stroke-width: 0px"><SPAN style="LINE-HEIGHT: 22px">Wonder Photo Shop，是富士最早开在日本东京原宿的一家旗舰店。在店内，人们可以通过富士的照片打印机打印手机内的照片，甚至为照片添加上各类效果。有趣的是，在胶片普遍被认为日渐式微的今天，Wonder Photo Shop在日本受到了许多年轻时尚人群的喜爱。主要原因在于富士抓住了智能手机时代的特点，人们虽然喜欢使用智能手机拍照，但实体照片作为留存、装饰、赠送的方式并没有消失，类似拍立得这样的照相机依然活跃在许多妹子的手上。这让富士看到了一种全新的照片服务模式，不是传统的照片冲印店，而是走时尚的一站式影像服务。</SPAN></P>\r\n<P style="PADDING-BOTTOM: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 2em; MARGIN: 26px 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px 宋体, sans-serif; WHITE-SPACE: normal; COLOR: rgb(37,37,37); WORD-SPACING: 0px; PADDING-TOP: 0px; -webkit-text-stroke-width: 0px" align=center><IMG style="BORDER-RIGHT-WIDTH: 0px; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; VERTICAL-ALIGN: top; BORDER-LEFT-WIDTH: 0px" src="http://localhost:8080/infocomshop/admin/news/SNH48当一日店长%20富士影像旗舰店Wonder%20Photo%20Shop在魔都开业_网易数码_files/4DB56DC5A0C2EDD60E059072B4F38F61.jpg"></P>\r\n<P style="PADDING-BOTTOM: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 2em; MARGIN: 26px 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px 宋体, sans-serif; WHITE-SPACE: normal; COLOR: rgb(37,37,37); WORD-SPACING: 0px; PADDING-TOP: 0px; -webkit-text-stroke-width: 0px" align=center><IMG style="BORDER-RIGHT-WIDTH: 0px; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; VERTICAL-ALIGN: top; BORDER-LEFT-WIDTH: 0px" src="http://localhost:8080/infocomshop/admin/news/SNH48当一日店长%20富士影像旗舰店Wonder%20Photo%20Shop在魔都开业_网易数码_files/B8A749D4DEA60D72360504419BDA054F.jpg">&nbsp;<IMG style="BORDER-RIGHT-WIDTH: 0px; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; VERTICAL-ALIGN: top; BORDER-LEFT-WIDTH: 0px" src="http://localhost:8080/infocomshop/admin/news/SNH48当一日店长%20富士影像旗舰店Wonder%20Photo%20Shop在魔都开业_网易数码_files/D877B806CCB0A33C6C80D096B7A7682E.jpg"></P>\r\n<P style="PADDING-BOTTOM: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 2em; MARGIN: 26px 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px 宋体, sans-serif; WHITE-SPACE: normal; COLOR: rgb(37,37,37); WORD-SPACING: 0px; PADDING-TOP: 0px; -webkit-text-stroke-width: 0px" align=center><IMG style="BORDER-RIGHT-WIDTH: 0px; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; VERTICAL-ALIGN: top; BORDER-LEFT-WIDTH: 0px" src="http://localhost:8080/infocomshop/admin/news/SNH48当一日店长%20富士影像旗舰店Wonder%20Photo%20Shop在魔都开业_网易数码_files/E57C8EF2918412EADE3105DBF24E33FD.jpg">&nbsp;<IMG style="BORDER-RIGHT-WIDTH: 0px; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; VERTICAL-ALIGN: top; BORDER-LEFT-WIDTH: 0px" src="http://localhost:8080/infocomshop/admin/news/SNH48当一日店长%20富士影像旗舰店Wonder%20Photo%20Shop在魔都开业_网易数码_files/B908E8488C0DCCBB368F701C321EBFD0.jpg"></P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 2em; MARGIN: 26px 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px 宋体, sans-serif; WHITE-SPACE: normal; COLOR: rgb(37,37,37); WORD-SPACING: 0px; PADDING-TOP: 0px; -webkit-text-stroke-width: 0px">之前富士就推出过Checky一次成像相机、X系列数码相机、CheckyCiao手机照片打印机、PrinCiao自助照片打印机等产品，他们支撑起了Wonder Photo Shop从前期拍摄、中期加工到末端输出的一整条照片冲印流水线。如果你正巧和小伙伴在人民广场周边游玩，几个人一起拍了几张照片想打印出来留作纪念，Wonder Photo Shop正好为你提供了这么一个场所。坐在店面中央的电脑前，可以享受自助式的照片打印服务。如果你没有好的相机也没关系，Wonder Photo Shop里面也提供拍摄区，你可以用专业的设备为自己拍照，然后在电脑上编辑并打印。另外Wonder Photo Shop也有各类的胶片贩售，再也不怕你的Checky拍到没胶片啦。</P>\r\n<P style="PADDING-BOTTOM: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 2em; MARGIN: 26px 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px 宋体, sans-serif; WHITE-SPACE: normal; COLOR: rgb(37,37,37); WORD-SPACING: 0px; PADDING-TOP: 0px; -webkit-text-stroke-width: 0px" align=center><IMG style="BORDER-RIGHT-WIDTH: 0px; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; VERTICAL-ALIGN: top; BORDER-LEFT-WIDTH: 0px" src="http://localhost:8080/infocomshop/admin/news/SNH48当一日店长%20富士影像旗舰店Wonder%20Photo%20Shop在魔都开业_网易数码_files/6F33EAD2470D85CADCF4C2354E650D24.jpg"></P>\r\n<P style="PADDING-BOTTOM: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 2em; MARGIN: 26px 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px 宋体, sans-serif; WHITE-SPACE: normal; COLOR: rgb(37,37,37); WORD-SPACING: 0px; PADDING-TOP: 0px; -webkit-text-stroke-width: 0px" align=center><IMG style="BORDER-RIGHT-WIDTH: 0px; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; VERTICAL-ALIGN: top; BORDER-LEFT-WIDTH: 0px" src="http://localhost:8080/infocomshop/admin/news/SNH48当一日店长%20富士影像旗舰店Wonder%20Photo%20Shop在魔都开业_网易数码_files/F122EC319E2521001CC56FB77725C5FF.jpg"></P>\r\n<P style="PADDING-BOTTOM: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 2em; MARGIN: 26px 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px 宋体, sans-serif; WHITE-SPACE: normal; COLOR: rgb(37,37,37); WORD-SPACING: 0px; PADDING-TOP: 0px; -webkit-text-stroke-width: 0px" align=center><IMG style="BORDER-RIGHT-WIDTH: 0px; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; VERTICAL-ALIGN: top; BORDER-LEFT-WIDTH: 0px" src="http://localhost:8080/infocomshop/admin/news/SNH48当一日店长%20富士影像旗舰店Wonder%20Photo%20Shop在魔都开业_网易数码_files/D5AA00018169B7B510C65680E4C01997.jpg"></P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 2em; MARGIN: 26px 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px 宋体, sans-serif; WHITE-SPACE: normal; COLOR: rgb(37,37,37); WORD-SPACING: 0px; PADDING-TOP: 0px; -webkit-text-stroke-width: 0px">用富士的话来说，这就是照片的文艺复兴。谁说实体照片没有市场？Wonder Photo Shop就告诉人们，在智能手机时代实体照片依然大受欢迎。上海的这家旗舰店已经是Wonder Photo Shop在全球的第四家分店，目前Wonder Photo Shop还开设在日本、哥伦比亚和菲律宾。此次选址在人民广场附近，也是看中这里游客居多的环境吧。</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 2em; MARGIN: 26px 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px 宋体, sans-serif; WHITE-SPACE: normal; COLOR: rgb(37,37,37); WORD-SPACING: 0px; PADDING-TOP: 0px; -webkit-text-stroke-width: 0px"></P>\r\n<P style="PADDING-BOTTOM: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 2em; MARGIN: 26px 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px 宋体, sans-serif; WHITE-SPACE: normal; COLOR: rgb(37,37,37); WORD-SPACING: 0px; PADDING-TOP: 0px; -webkit-text-stroke-width: 0px" align=center><IMG style="BORDER-RIGHT-WIDTH: 0px; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; VERTICAL-ALIGN: top; BORDER-LEFT-WIDTH: 0px" src="http://localhost:8080/infocomshop/admin/news/SNH48当一日店长%20富士影像旗舰店Wonder%20Photo%20Shop在魔都开业_网易数码_files/1ADC3D073CF86B857FEDEEB41F98BB82.jpg"><BR>（<SPAN style="LINE-HEIGHT: 22px">SNH48队长莫寒</SPAN><SPAN style="LINE-HEIGHT: 22px; TEXT-INDENT: 2em">）</SPAN></P>\r\n<P style="PADDING-BOTTOM: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 2em; MARGIN: 26px 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px 宋体, sans-serif; WHITE-SPACE: normal; COLOR: rgb(37,37,37); WORD-SPACING: 0px; PADDING-TOP: 0px; -webkit-text-stroke-width: 0px" align=center><IMG style="BORDER-RIGHT-WIDTH: 0px; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; VERTICAL-ALIGN: top; BORDER-LEFT-WIDTH: 0px" src="http://localhost:8080/infocomshop/admin/news/SNH48当一日店长%20富士影像旗舰店Wonder%20Photo%20Shop在魔都开业_网易数码_files/45078E725C2768DFE007FD4EC5354439.jpg"><BR>（SNH48成员陈思和张语格）</P>\r\n<P style="PADDING-BOTTOM: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 2em; MARGIN: 26px 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px 宋体, sans-serif; WHITE-SPACE: normal; COLOR: rgb(37,37,37); WORD-SPACING: 0px; PADDING-TOP: 0px; -webkit-text-stroke-width: 0px" align=center><IMG style="BORDER-RIGHT-WIDTH: 0px; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; VERTICAL-ALIGN: top; BORDER-LEFT-WIDTH: 0px" src="http://localhost:8080/infocomshop/admin/news/SNH48当一日店长%20富士影像旗舰店Wonder%20Photo%20Shop在魔都开业_网易数码_files/7FD610267C0BB655D235CA9031019956.jpg"><BR>（SNH48成员许佳琪和戴萌）</P>\r\n<P style="PADDING-BOTTOM: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 2em; MARGIN: 26px 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px 宋体, sans-serif; WHITE-SPACE: normal; COLOR: rgb(37,37,37); WORD-SPACING: 0px; PADDING-TOP: 0px; -webkit-text-stroke-width: 0px" align=center><IMG style="BORDER-RIGHT-WIDTH: 0px; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; VERTICAL-ALIGN: top; BORDER-LEFT-WIDTH: 0px" src="http://localhost:8080/infocomshop/admin/news/SNH48当一日店长%20富士影像旗舰店Wonder%20Photo%20Shop在魔都开业_网易数码_files/E10C0DC36C81D4837396E20B43B115ED.jpg"><BR>（<SPAN style="LINE-HEIGHT: 22px">SNH48成员孔肖吟</SPAN><SPAN style="LINE-HEIGHT: 22px; TEXT-INDENT: 2em">）</SPAN></P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 2em; MARGIN: 26px 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px 宋体, sans-serif; WHITE-SPACE: normal; COLOR: rgb(37,37,37); WORD-SPACING: 0px; PADDING-TOP: 0px; -webkit-text-stroke-width: 0px"></P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 2em; MARGIN: 26px 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px 宋体, sans-serif; WHITE-SPACE: normal; COLOR: rgb(37,37,37); WORD-SPACING: 0px; PADDING-TOP: 0px; -webkit-text-stroke-width: 0px">如果你今天前往Wonder Photo Shop，还有机会看到SNH48的成员哦。SNH48的队长莫寒，以及成员张语格、戴萌、陈思、孔肖吟、许佳琪将作为开业日的“一日店长”，在店内为你服务。不懂富士产品？没关系，就让SNH48的妹纸们为你一一讲解吧。不过前提是，你能挤到他们的面前。反正今天中午小编离开的时候，仍有大批粉丝等在店外准备排队入场，生男孩的魅力着实不小啊。</P>', 1, '爱活网', '2015-08-04 10:15:11', NULL),
	(39, '亚马逊市值冲2600亿美元揭秘', '', '行业新闻', '', '&nbsp;\r\n<P style="PADDING-BOTTOM: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 15px 0px 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px &#65533;&#65533;&#65533;&#65533;; WHITE-SPACE: normal; COLOR: rgb(0,0,0); WORD-SPACING: 0px; PADDING-TOP: 0px; -webkit-text-stroke-width: 0px">　　亚马逊(NASDAQ：AMZN)2015年第二季度扭亏为盈，超预期业绩刺激股价单日暴涨，创出历史新高；市值曾冲破2600亿美元，一举超过老牌零售巨头沃尔玛。这成为一个标志性事件，亦引发全球热议。市场认为，这不仅是亚马逊对于沃尔玛的胜利，更是互联网新<A style="COLOR: rgb(13,81,156); FONT-SIZE: 14px; TEXT-DECORATION: none" title="兴业 00323042" href="http://app.finance.china.com.cn/fund/company.php?id=00323042" target=_blank>兴业</A>态挑战传统业态取得的胜利。</P>\r\n<P style="PADDING-BOTTOM: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 15px 0px 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px &#65533;&#65533;&#65533;&#65533;; WHITE-SPACE: normal; COLOR: rgb(0,0,0); WORD-SPACING: 0px; PADDING-TOP: 0px; -webkit-text-stroke-width: 0px">　　　有趣的是，亚马逊一直以“微盈利甚至亏损”著称，但华尔街却愿意不断给予其高估值。究竟亚马逊有何与众不同之处？《每日经济新闻》记者通过深入研究，试图揭开亚马逊的神秘面纱。</P>\r\n<P style="PADDING-BOTTOM: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 15px 0px 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px &#65533;&#65533;&#65533;&#65533;; WHITE-SPACE: normal; COLOR: rgb(0,0,0); WORD-SPACING: 0px; PADDING-TOP: 0px; -webkit-text-stroke-width: 0px"><STRONG>　　　从网上书城到超级公司</STRONG></P>\r\n<P style="PADDING-BOTTOM: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 15px 0px 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px &#65533;&#65533;&#65533;&#65533;; WHITE-SPACE: normal; COLOR: rgb(0,0,0); WORD-SPACING: 0px; PADDING-TOP: 0px; -webkit-text-stroke-width: 0px">　　　7月末，亚马逊公布了一份超预期的季报。2015财年第二财季，亚马逊营收为231.8亿美元，较上年同期增长20%；净利润为9200万美元，上年同期为净亏损1.26亿美元；在亚马逊扭亏为盈的消息刺激下，7月24日股价飙涨创出580.57美元，市值冲破2600亿美元，超越沃尔玛，成功登顶全球零售业王者宝座。</P>\r\n<P style="PADDING-BOTTOM: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 15px 0px 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px &#65533;&#65533;&#65533;&#65533;; WHITE-SPACE: normal; COLOR: rgb(0,0,0); WORD-SPACING: 0px; PADDING-TOP: 0px; -webkit-text-stroke-width: 0px">　　　沃尔玛，这家曾改变了传统零售业态，将小型商家贩售商品聚集到更大的店面集中销售，开创了一站式购物的消费模式，成功解决了过去零散消费的阵痛；沃尔玛的创新受到了二级市场追捧，市值水涨船高，并逐渐成为全球零售企业标杆。</P>\r\n<P style="PADDING-BOTTOM: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 15px 0px 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px &#65533;&#65533;&#65533;&#65533;; WHITE-SPACE: normal; COLOR: rgb(0,0,0); WORD-SPACING: 0px; PADDING-TOP: 0px; -webkit-text-stroke-width: 0px">　　　当其扩张到一定规模后，过去的优势诸如配送中心、大型店铺带来的成本愈发高企，营收开始明显受到拖累，进而导致增长出现停滞；伴随互联网的兴起，消费习惯逐渐转移至线上，更是对沃尔玛这种传统模式受益者构成了直接的冲击。</P>\r\n<P style="PADDING-BOTTOM: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 15px 0px 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px &#65533;&#65533;&#65533;&#65533;; WHITE-SPACE: normal; COLOR: rgb(0,0,0); WORD-SPACING: 0px; PADDING-TOP: 0px; -webkit-text-stroke-width: 0px">　　　亚马逊恰是互联网时代的弄潮儿。从最初在网上卖书撬开一个市场缺口，到现在，你可以在亚马逊上买到生活中大多数想买的商品，这种线上销售的创新方式，传统小型零售企业是无法与之抗衡的，连沃尔玛等这样的零售巨头现在也受到了严重威胁。</P>\r\n<P style="PADDING-BOTTOM: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 15px 0px 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px &#65533;&#65533;&#65533;&#65533;; WHITE-SPACE: normal; COLOR: rgb(0,0,0); WORD-SPACING: 0px; PADDING-TOP: 0px; -webkit-text-stroke-width: 0px">　　　目前，亚马逊还是一个以出售图书和电子产品为主的网站，服装的销售仅占其总销售的一小部分，这意味着公司在服装上还有很大的发展空间。</P>\r\n<P style="PADDING-BOTTOM: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 15px 0px 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px &#65533;&#65533;&#65533;&#65533;; WHITE-SPACE: normal; COLOR: rgb(0,0,0); WORD-SPACING: 0px; PADDING-TOP: 0px; -webkit-text-stroke-width: 0px">　　　亚马逊深谙其道，一直在大量投资时尚业。在过去几年，亚马逊收购了时尚零售网站Shopbop，并推出了服装折扣网站Myhabit以及男装网站East Dane。此外，该公司还赞助了今年的纽约男装周。</P>\r\n<P style="PADDING-BOTTOM: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 15px 0px 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px &#65533;&#65533;&#65533;&#65533;; WHITE-SPACE: normal; COLOR: rgb(0,0,0); WORD-SPACING: 0px; PADDING-TOP: 0px; -webkit-text-stroke-width: 0px">　　　据金融公司Cowen and Company预测，亚马逊将于2017年超越梅西百货，成为全美第一大服装零售商；服装将成为亚马逊零售板块的领先增长品类。</P>\r\n<P style="PADDING-BOTTOM: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 15px 0px 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px &#65533;&#65533;&#65533;&#65533;; WHITE-SPACE: normal; COLOR: rgb(0,0,0); WORD-SPACING: 0px; PADDING-TOP: 0px; -webkit-text-stroke-width: 0px">　　　不过，这还不是故事的全部。尽管市场仍以亚马逊初创期的业态为准，将其归于零售类企业，然而这家由网上书城成长起来的企业早已不是一家纯粹的零售商，而更像是一家科技公司。</P>', 1, '大河网', '2015-08-04 10:21:56', NULL),
	(40, '威博V5SHOP商学院助推中国企业微商联盟', '', '公司新闻', 'images\\6808.jpg', '&nbsp;\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　――采访威博V5SHOP商学院院长陈真</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　由移动智能分销以及O2O系统领跑者上海威博(V5SHOP)发起的中国企业微商联盟已经于6月28日正式启动了。威博V5SHOP商学院作为中国企业微商联盟最重要的组织，携手十大风云导师共同创建企业微商培训体系，建立资源共享平台，创建企业微商绿色生态圈。记者非常有幸采访到了威博V5SHOP商学院陈真院长。</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　以下是陈真院长简历：</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　计算机本科专业毕业，毕业后一直从事互联网及互联网营销推广工作;</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　2011年开始互联网创业;</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　2012年底进入微信营销，从最早帮客户注册公众账号开始，属于中国第一批微信营销创业者;</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　2013年操盘运营中国最大微营销培训公司，普及微营销学员超过十万人，同年底运营中国最大的微信生活服务平台：“我的微生活”，覆盖中国73个城市，现在依旧运营的有17个城市，服务终端用户超过700万。</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　2014年开始利用微信营销运作产品及项目，一年操作3个产品，其中泛亚金融在没有任何百度推广前提下利用微信营销一年创造2.2亿的营收。同年7月开始正式进入微商;</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　2015年在参与运营传统微商半年后发现诸多问题之后开始研究移动分销系统和模式，自己亲自操作“爆款汇”平台利用移动分销平台获得成功后开始服务传统企业利用微信分销升级转型，截止目前团队服务超过170家企业。</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　<IMG style="TEXT-ALIGN: center; PADDING-BOTTOM: 0px; BORDER-RIGHT-WIDTH: 0px; MARGIN: 0px auto; PADDING-LEFT: 0px; PADDING-RIGHT: 0px; DISPLAY: block; FONT-FAMILY: \'Microsoft Yahei\', Tahoma, SimSun; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; BORDER-LEFT-WIDTH: 0px; PADDING-TOP: 0px" alt="" src="http://localhost:8080/infocomshop/admin/news/威博V5SHOP商学院助推中国企业微商联盟-MSN中国科技频道_files/1143.jpg" width=500 height=332></P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　2015年6月1日正式受聘成为威博网络(集团)旗下中国移动分销第一品牌V5shop商学院院长，帮助V5shop平台上的移动分销会员开启企业的移动电商新模式。</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　记者：陈院长您好，很荣幸今天能够采访您，你自己也创业这么几年，也接触很多企业家，尤其是传统老板，现在企业都面临哪些问题你给我们说说?</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　陈真院长(以下简称陈真)：你好，我自己经历以及跟身边传统企业老板打交道下来发现他们现在主要有以下几个问题：</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　第一、库存挤压不知如何消化;</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　第二、想做电商又不知道如何下手;</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　第三、业务团队人员成本很高，产出率很低;</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　第四、想扩张但门店费用又太高;</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　第五、品牌没有粉丝只有不断开发新客户;</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　记者：我看前面陈院长的经历，你自己创业同时有帮传统企业升级转型的成功经验，你给我们介绍下你是如何自己成功又同时帮助传统企业升级转型的?</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　陈真：好的。大家都知道今天传统线下门店或者进商超的门槛非常高，同时越来越多的人线上购物，所以传统线下门店生意对于很多传统老板来说已经是很难了，而今天传统电商天猫淘宝逐步成了大品牌的角斗场，在大品牌还没有进去的时候淘品牌还可以生存，大品牌烧钱进入的时候给淘品牌就带来了很高的门槛，所以对于很多创业型的企业来说，天猫已经有了很高的门槛，没有半年以上的运营和投入是很难盈利的。</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　我从12年就开始了利用低成本高效率的微信营销，最开始微信营销很简单，就是个人通过朋友圈刷屏的形式，后面逐渐通过微信公众号开始了企业微商1.0也就是B2C模式，就是通过在企业的微信公众平台上面搭建微信商城，利用微信商城卖货，现在很多企业依旧用这个方式在销售，这种方式相对适合有一定品牌知名度的企业，把线下的粉丝转到线上公众号圈养起来，粉丝以后买东西就可以直接通过公众号购买，不需要去淘宝天猫或者电脑上，对于消费者来说便捷了很多，它的弊端就是不太适合初创型的企业，因为没有粉丝，没人关注企业服务号就没有销量。典型的企业有：罗辑思维，三只松鼠等知名品牌。</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　企业微商2.0就是B2C2C，也就是现在被大家熟知的微商模式，移动互联网时代有两个关键词：分享和参与，社交工具让分享变得非常容易：看到好看的，吃到好吃的，买到漂亮衣服就会分享到朋友圈，但是以前是义务分享，直到有一天大家发现自己分享朋友圈的东西很多朋友要求他代购，嗅觉灵敏的人就发现了商机所以代购就出现了，也就是最早的微商，逐步发展到今天所有产品都通过微商形式销售，也就是B2C2C模式，这个模式中消费者不仅仅是消费者，因为他参与了流通产生了价值所以成为消费商，赚取了流通过程中对应的收益。这种模式相当于把线下传统的省代市代县代模式搬上了微信，而且没有区域限制，所以出来之后发展的非常快，很多企业都采取了这样的模式。微商2.0代理模式从一级代理到三级甚至五级，最低级的代理往往就是最终端的消费者，这种的弊端就是各层级代理需要缴纳不同程度的代理费也就是首次进货费，级别的高低取决进货量的多少，所以出现一批新微商从业人员在没有扎实基础知识前提下进了大批的货最终卖不出去。典型的企业有：思埠，韩束，俏十岁，百雀羚等新老品牌。</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　企业微商3.0即F2C模式，也就是今天我们讲的移动分销模式，微商3.0模式结合了微商1.0企业发货，企业收款确保产品品质的优势和微商2.0零售渠道的优势，一经出来立刻受到企业和新老微商从业人员的欢迎，这种模式的核心是每个客户只要购买一次企业的产品就可以自动成为企业的分销会员，可以通过推广赚取推广费用也可以让自己享受会员优惠价，不需要投资高额的代理费，也不需要暴力刷屏，产品全部由企业统一发货避免假货流通，同时货款全部由企业收取再返给分销会员，企业和分销会员都能得到自己想要的结果。典型企业有：北京故事，巴布豆等。</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　记者：哇，听完陈院长讲完微商发展的几个阶段让我对微商豁然开朗，太精彩了!尤其是微商3.0，原来已经有这么先进的技术平台可以实现原来那么负责的流程了，陈院长给我们具体说说微商3.0的功能和价值?</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　陈真：微商3.0之所以能发挥出来最关键在于有这么一套成熟的微信分销系统，这是我们威博公司电商从业13年的结晶，我们V5shop分销系统可以为企业带来四大核心价值：</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　一、可以让全员分销，让员工和客户都成为我们的分销员帮我们卖货;</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　二、可以轻松的开出成千上万的线上店铺，每个会员就是一个店铺，里面卖的都是企业同样的产品;</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　三、可以利用分销系统快速吸引一万乃至十万粉丝;</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　四、可以近乎零投入开启店铺同时轻松盈利;</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　记者：太棒了!咱们V5shop做了13年肯定有很多不同之处，您给我们说说V5shop分销系统有哪些优势?</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　陈真：我们分销系统有十大优势：1、开店非常便捷，3分钟开启一个店铺;2、店铺风格百变;3、通过二维码，链接和个人名片都可以进入会员店铺;4、分销会员可以随时随地看到自己的收入;5、分销会员可以随时提取自己的佣金;6、后台可以简单管理订单系统;7、推广非常简单一键推送朋友圈;8、报表清晰明了;9、多种模板消息推送，客户关注或购买都可以收到信息;10、还可以把店铺直接放到手机桌面APP下载，一键打开店铺。</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　记者：听完您介绍我都想自己去买一套分销系统去创业卖货了，那您作为商学院院长又给客户带来哪些服务呢?</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　陈真：我们给客户提供的不仅仅是一套软件分销系统，我们在把分销系统做到行业第一名的同时加强我们给客户的运营指导服务，我们相信，再好的工具如果没有好的操作也发挥不出它最大的效果，所以我们除了帮助客户搭建他们自己的分销商城以外，我们还帮助每一个客户建立属于他们自己的企业在线分销商学院，在分销商城项目启动前我们会告诉我们V5shop的分销会员如何选择分销爆款产品，如何设计分销机制，如何打造运营团队，如何培养分销团队等，分销商城启动后我们给每一家会员企业的在线商学院录制7段不同课程，方便会员企业周一到周天晚上每天晚上可以通过他们在线商学院给他们的分销会员培训，教他们如何运营微信朋友圈，如何解除客户抗拒，如何介绍公司产品价值，如何讲解分销模式的好处，如何管理他们的社群，如何一对多的在线成交客户等，通过项目启动前后的辅导确保我们威博V5shop每一家分销会员都可以得到他们想要的结果，我们的会员每个月利用分销商城平台收入百万的以及很多，有机会可以百度搜索：V5shop微分销系统了解详情。</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　记者：好的，谢谢陈院长今天给我们满满的干货分享!也预祝我们V5shop商学院可以帮助到更多的传统企业升级转型!那我们今天的访谈就到此结束，再次谢谢陈院长!</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　<IMG style="TEXT-ALIGN: center; PADDING-BOTTOM: 0px; BORDER-RIGHT-WIDTH: 0px; MARGIN: 0px auto; PADDING-LEFT: 0px; PADDING-RIGHT: 0px; DISPLAY: block; FONT-FAMILY: \'Microsoft Yahei\', Tahoma, SimSun; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; BORDER-LEFT-WIDTH: 0px; PADDING-TOP: 0px" alt="" src="http://localhost:8080/infocomshop/admin/news/威博V5SHOP商学院助推中国企业微商联盟-MSN中国科技频道_files/6653.png" width=500 height=332></P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　V5shop微信分销系统是什么?</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　由上海威博网络技术有限公司自主研发的V5shop微信分销系统是一款以总部布控，发动店员、职员等移动端零售人员发展三级店铺的微信店中店系统，帮助企业打造“企业微商城+粉丝微店+员工微店”的多层级微信营销模式，并基于朋友圈的传播。店中店模式可快速复制店铺，轻松带领成千上万的人一起为你销售商品。V5shop微信分销首创的采用“三级分销，两类佣金”模式，低成本迅速积累百万粉丝，圈子裂变理论让销售业绩倍增。</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　看看都有谁在用V5shop微信分销系统?</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　著名丝巾品牌北京故事、职业装第一股GIUSEPPE 乔治白、著名童装品牌巴布豆、皮鞋名牌红蜻蜓、诗柔服饰、化妆品紫仁堂、化妆品bliv信美肌、中俄电商E俄商城、汽配第一品牌通润、保温杯第一品牌思乐得……</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　关于V5shop――O2O系统与电商运营服务领跑者</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　PC官网：www.v5shop.com.cn www.v5shop.com</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　手机官网：wap.v5shop.com</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　咨询热线：400-600-5786,400-013-0670</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　营销QQ：400-600-5786</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　――采访威博V5SHOP商学院院长陈真</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　由移动智能分销以及O2O系统领跑者上海威博(V5SHOP)发起的中国企业微商联盟已经于6月28日正式启动了。威博V5SHOP商学院作为中国企业微商联盟最重要的组织，携手十大风云导师共同创建企业微商培训体系，建立资源共享平台，创建企业微商绿色生态圈。记者非常有幸采访到了威博V5SHOP商学院陈真院长。</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　<IMG style="TEXT-ALIGN: center; PADDING-BOTTOM: 0px; BORDER-RIGHT-WIDTH: 0px; MARGIN: 0px auto; PADDING-LEFT: 0px; PADDING-RIGHT: 0px; DISPLAY: block; FONT-FAMILY: \'Microsoft Yahei\', Tahoma, SimSun; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; BORDER-LEFT-WIDTH: 0px; PADDING-TOP: 0px" alt="" src="http://localhost:8080/infocomshop/admin/news/威博V5SHOP商学院助推中国企业微商联盟-MSN中国科技频道_files/6808.jpg" width=500 height=283></P>\r\n<P style="TEXT-ALIGN: center; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px" align=center>　　陈真，中国企业微商联盟创始人，V5shop商学院陈真院长。</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　以下是陈真院长简历：</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　计算机本科专业毕业，毕业后一直从事互联网及互联网营销推广工作;</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　2011年开始互联网创业;</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　2012年底进入微信营销，从最早帮客户注册公众账号开始，属于中国第一批微信营销创业者;</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　2013年操盘运营中国最大微营销培训公司，普及微营销学员超过十万人，同年底运营中国最大的微信生活服务平台：“我的微生活”，覆盖中国73个城市，现在依旧运营的有17个城市，服务终端用户超过700万。</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　2014年开始利用微信营销运作产品及项目，一年操作3个产品，其中泛亚金融在没有任何百度推广前提下利用微信营销一年创造2.2亿的营收。同年7月开始正式进入微商;</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　2015年在参与运营传统微商半年后发现诸多问题之后开始研究移动分销系统和模式，自己亲自操作“爆款汇”平台利用移动分销平台获得成功后开始服务传统企业利用微信分销升级转型，截止目前团队服务超过170家企业。</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　<IMG style="TEXT-ALIGN: center; PADDING-BOTTOM: 0px; BORDER-RIGHT-WIDTH: 0px; MARGIN: 0px auto; PADDING-LEFT: 0px; PADDING-RIGHT: 0px; DISPLAY: block; FONT-FAMILY: \'Microsoft Yahei\', Tahoma, SimSun; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; BORDER-LEFT-WIDTH: 0px; PADDING-TOP: 0px" alt="" src="http://localhost:8080/infocomshop/admin/news/威博V5SHOP商学院助推中国企业微商联盟-MSN中国科技频道_files/1143.jpg" width=500 height=332></P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　2015年6月1日正式受聘成为威博网络(集团)旗下中国移动分销第一品牌V5shop商学院院长，帮助V5shop平台上的移动分销会员开启企业的移动电商新模式。</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　记者：陈院长您好，很荣幸今天能够采访您，你自己也创业这么几年，也接触很多企业家，尤其是传统老板，现在企业都面临哪些问题你给我们说说?</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　陈真院长(以下简称陈真)：你好，我自己经历以及跟身边传统企业老板打交道下来发现他们现在主要有以下几个问题：</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　第一、库存挤压不知如何消化;</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　第二、想做电商又不知道如何下手;</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　第三、业务团队人员成本很高，产出率很低;</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　第四、想扩张但门店费用又太高;</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　第五、品牌没有粉丝只有不断开发新客户;</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　记者：我看前面陈院长的经历，你自己创业同时有帮传统企业升级转型的成功经验，你给我们介绍下你是如何自己成功又同时帮助传统企业升级转型的?</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　陈真：好的。大家都知道今天传统线下门店或者进商超的门槛非常高，同时越来越多的人线上购物，所以传统线下门店生意对于很多传统老板来说已经是很难了，而今天传统电商天猫淘宝逐步成了大品牌的角斗场，在大品牌还没有进去的时候淘品牌还可以生存，大品牌烧钱进入的时候给淘品牌就带来了很高的门槛，所以对于很多创业型的企业来说，天猫已经有了很高的门槛，没有半年以上的运营和投入是很难盈利的。</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　我从12年就开始了利用低成本高效率的微信营销，最开始微信营销很简单，就是个人通过朋友圈刷屏的形式，后面逐渐通过微信公众号开始了企业微商1.0也就是B2C模式，就是通过在企业的微信公众平台上面搭建微信商城，利用微信商城卖货，现在很多企业依旧用这个方式在销售，这种方式相对适合有一定品牌知名度的企业，把线下的粉丝转到线上公众号圈养起来，粉丝以后买东西就可以直接通过公众号购买，不需要去淘宝天猫或者电脑上，对于消费者来说便捷了很多，它的弊端就是不太适合初创型的企业，因为没有粉丝，没人关注企业服务号就没有销量。典型的企业有：罗辑思维，三只松鼠等知名品牌。</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　企业微商2.0就是B2C2C，也就是现在被大家熟知的微商模式，移动互联网时代有两个关键词：分享和参与，社交工具让分享变得非常容易：看到好看的，吃到好吃的，买到漂亮衣服就会分享到朋友圈，但是以前是义务分享，直到有一天大家发现自己分享朋友圈的东西很多朋友要求他代购，嗅觉灵敏的人就发现了商机所以代购就出现了，也就是最早的微商，逐步发展到今天所有产品都通过微商形式销售，也就是B2C2C模式，这个模式中消费者不仅仅是消费者，因为他参与了流通产生了价值所以成为消费商，赚取了流通过程中对应的收益。这种模式相当于把线下传统的省代市代县代模式搬上了微信，而且没有区域限制，所以出来之后发展的非常快，很多企业都采取了这样的模式。微商2.0代理模式从一级代理到三级甚至五级，最低级的代理往往就是最终端的消费者，这种的弊端就是各层级代理需要缴纳不同程度的代理费也就是首次进货费，级别的高低取决进货量的多少，所以出现一批新微商从业人员在没有扎实基础知识前提下进了大批的货最终卖不出去。典型的企业有：思埠，韩束，俏十岁，百雀羚等新老品牌。</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　企业微商3.0即F2C模式，也就是今天我们讲的移动分销模式，微商3.0模式结合了微商1.0企业发货，企业收款确保产品品质的优势和微商2.0零售渠道的优势，一经出来立刻受到企业和新老微商从业人员的欢迎，这种模式的核心是每个客户只要购买一次企业的产品就可以自动成为企业的分销会员，可以通过推广赚取推广费用也可以让自己享受会员优惠价，不需要投资高额的代理费，也不需要暴力刷屏，产品全部由企业统一发货避免假货流通，同时货款全部由企业收取再返给分销会员，企业和分销会员都能得到自己想要的结果。典型企业有：北京故事，巴布豆等。</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　记者：哇，听完陈院长讲完微商发展的几个阶段让我对微商豁然开朗，太精彩了!尤其是微商3.0，原来已经有这么先进的技术平台可以实现原来那么负责的流程了，陈院长给我们具体说说微商3.0的功能和价值?</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　陈真：微商3.0之所以能发挥出来最关键在于有这么一套成熟的微信分销系统，这是我们威博公司电商从业13年的结晶，我们V5shop分销系统可以为企业带来四大核心价值：</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　一、可以让全员分销，让员工和客户都成为我们的分销员帮我们卖货;</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　二、可以轻松的开出成千上万的线上店铺，每个会员就是一个店铺，里面卖的都是企业同样的产品;</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　三、可以利用分销系统快速吸引一万乃至十万粉丝;</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　四、可以近乎零投入开启店铺同时轻松盈利;</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　记者：太棒了!咱们V5shop做了13年肯定有很多不同之处，您给我们说说V5shop分销系统有哪些优势?</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　陈真：我们分销系统有十大优势：1、开店非常便捷，3分钟开启一个店铺;2、店铺风格百变;3、通过二维码，链接和个人名片都可以进入会员店铺;4、分销会员可以随时随地看到自己的收入;5、分销会员可以随时提取自己的佣金;6、后台可以简单管理订单系统;7、推广非常简单一键推送朋友圈;8、报表清晰明了;9、多种模板消息推送，客户关注或购买都可以收到信息;10、还可以把店铺直接放到手机桌面APP下载，一键打开店铺。</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　记者：听完您介绍我都想自己去买一套分销系统去创业卖货了，那您作为商学院院长又给客户带来哪些服务呢?</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　陈真：我们给客户提供的不仅仅是一套软件分销系统，我们在把分销系统做到行业第一名的同时加强我们给客户的运营指导服务，我们相信，再好的工具如果没有好的操作也发挥不出它最大的效果，所以我们除了帮助客户搭建他们自己的分销商城以外，我们还帮助每一个客户建立属于他们自己的企业在线分销商学院，在分销商城项目启动前我们会告诉我们V5shop的分销会员如何选择分销爆款产品，如何设计分销机制，如何打造运营团队，如何培养分销团队等，分销商城启动后我们给每一家会员企业的在线商学院录制7段不同课程，方便会员企业周一到周天晚上每天晚上可以通过他们在线商学院给他们的分销会员培训，教他们如何运营微信朋友圈，如何解除客户抗拒，如何介绍公司产品价值，如何讲解分销模式的好处，如何管理他们的社群，如何一对多的在线成交客户等，通过项目启动前后的辅导确保我们威博V5shop每一家分销会员都可以得到他们想要的结果，我们的会员每个月利用分销商城平台收入百万的以及很多，有机会可以百度搜索：V5shop微分销系统了解详情。</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　记者：好的，谢谢陈院长今天给我们满满的干货分享!也预祝我们V5shop商学院可以帮助到更多的传统企业升级转型!那我们今天的访谈就到此结束，再次谢谢陈院长!</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　<IMG style="TEXT-ALIGN: center; PADDING-BOTTOM: 0px; BORDER-RIGHT-WIDTH: 0px; MARGIN: 0px auto; PADDING-LEFT: 0px; PADDING-RIGHT: 0px; DISPLAY: block; FONT-FAMILY: \'Microsoft Yahei\', Tahoma, SimSun; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; BORDER-LEFT-WIDTH: 0px; PADDING-TOP: 0px" alt="" src="http://localhost:8080/infocomshop/admin/news/威博V5SHOP商学院助推中国企业微商联盟-MSN中国科技频道_files/6653.png" width=500 height=332></P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　V5shop微信分销系统是什么?</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　由上海威博网络技术有限公司自主研发的V5shop微信分销系统是一款以总部布控，发动店员、职员等移动端零售人员发展三级店铺的微信店中店系统，帮助企业打造“企业微商城+粉丝微店+员工微店”的多层级微信营销模式，并基于朋友圈的传播。店中店模式可快速复制店铺，轻松带领成千上万的人一起为你销售商品。V5shop微信分销首创的采用“三级分销，两类佣金”模式，低成本迅速积累百万粉丝，圈子裂变理论让销售业绩倍增。</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　看看都有谁在用V5shop微信分销系统?</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　著名丝巾品牌北京故事、职业装第一股GIUSEPPE 乔治白、著名童装品牌巴布豆、皮鞋名牌红蜻蜓、诗柔服饰、化妆品紫仁堂、化妆品bliv信美肌、中俄电商E俄商城、汽配第一品牌通润、保温杯第一品牌思乐得……</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　关于V5shop――O2O系统与电商运营服务领跑者</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　PC官网：www.v5shop.com.cn www.v5shop.com</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　手机官网：wap.v5shop.com</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　咨询热线：400-600-5786,400-013-0670</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 5px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); LIST-STYLE-TYPE: none; TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/24px \'Microsoft Yahei\', Tahoma, SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); WORD-SPACING: 0px; PADDING-TOP: 5px; -webkit-text-stroke-width: 0px">　　营销QQ：400-600-5786</P>', 1, '天极网络 ', '2015-08-04 10:24:12', NULL),
	(41, '随时随地网络购物：发展态势下的南孚商城', '', '行业新闻', 'images\\U12873P693DT20150731114653.jpg', '&nbsp;\r\n<P style="PADDING-BOTTOM: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 0px; MARGIN: 20px 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/26px 宋体; WHITE-SPACE: normal; COLOR: rgb(69,69,69); WORD-SPACING: 0px; PADDING-TOP: 0px; -webkit-text-stroke-width: 0px">　　未来，网络购物垂直领域热度会持续攀升，之前传统企业做电子商务领域的一大问题就是缺流量。所有公司在产品做出来之后第一件事情就是去找消费者、流量的集中点。而未来的行业市场差异化会很明显，一个好的公司有好的产品并不代表电商渠道一定会有良好的成绩。很关键的一点是有垂直的平台、完整的系统帮助公司培养、导入消费者。</P>\r\n<P style="PADDING-BOTTOM: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 0px; MARGIN: 20px 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/26px 宋体; WHITE-SPACE: normal; COLOR: rgb(69,69,69); WORD-SPACING: 0px; PADDING-TOP: 0px; -webkit-text-stroke-width: 0px">　　目前，网购平台的销售系统日趋成熟化，南孚电池公司研究了很多大数据，也研究了很多移动端数据。发现在网购时代消费者的活跃量呈直线上升，高居不下。从研究报告中也充分说明网络已经成为了好的产品推广最有力的手段。如今移动端的网络覆盖，将购物的穿透性爆发到一个新的高度，如今的线上线下销售两不误，已经不是什么新鲜事。</P>\r\n<P style="PADDING-BOTTOM: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 0px; MARGIN: 20px 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/26px 宋体; WHITE-SPACE: normal; COLOR: rgb(69,69,69); WORD-SPACING: 0px; PADDING-TOP: 0px; -webkit-text-stroke-width: 0px">　　网络购物“随时随地”的特性十分具有吸引力。我们也感受到这其中蕴含着很大的市场空间，不过市场监管的差强人意，也出现了损害消费者利益的大量案例。在这样的环境中，如何让大型的电池企业做到销售源头的品质保障呢？南孚公司表示，在电池的品质方面，不仅要做到售后的完美服务，更重要的是网络购物渠道的普及认知。目前南孚电池自建了南孚商城并以良好地态势向前发展着，从源头上保证了销售渠道的正规化。这样产品也就有了强力的正品保障。</P>', 1, '中国网', '2015-08-04 10:26:07', NULL),
	(42, '网络购买玉器有风险 需谨慎考虑', '', '行业新闻', '', '<SPAN style="TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 0px; LETTER-SPACING: normal; DISPLAY: inline !important; FONT: 12px/36px SimSun; WHITE-SPACE: normal; FLOAT: none; COLOR: rgb(128,128,128); WORD-SPACING: 0px; -webkit-text-stroke-width: 0px">\r\n<DIV style="PADDING-BOTTOM: 10px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(245,245,245); TEXT-INDENT: 0px; MARGIN: 4px 0px 0px; PADDING-LEFT: 10px; WIDTH: 600px; LETTER-SPACING: normal; PADDING-RIGHT: 10px; FONT: 12px/28px SimSun; WHITE-SPACE: normal; COLOR: rgb(153,153,153); WORD-SPACING: 0px; PADDING-TOP: 10px; -webkit-text-stroke-width: 0px" class=summary><SPAN style="PADDING-BOTTOM: 0px; LINE-HEIGHT: 20px; BACKGROUND-COLOR: rgb(186,48,34); MARGIN: 4px 10px 0px 0px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; DISPLAY: inline-block; FLOAT: left; COLOR: rgb(255,255,255); PADDING-TOP: 0px">摘要</SPAN>网上购物已经成为一种消费时尚，不少投资者还通过网络购买贵金属玉器等贵重物品。</DIV>\r\n<DIV style="PADDING-BOTTOM: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 0px; MARGIN: 10px 0px 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 12px SimSun; WHITE-SPACE: normal; COLOR: rgb(80,80,80); WORD-SPACING: 0px; PADDING-TOP: 0px; -webkit-text-stroke-width: 0px">\r\n<DIV style="PADDING-BOTTOM: 0px; MARGIN: 0px; PADDING-LEFT: 0px; PADDING-RIGHT: 0px; PADDING-TOP: 0px" id=BAIDU_DUP_wrapper_1069437_0></DIV></DIV>\r\n<DIV style="PADDING-BOTTOM: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; WIDTH: 620px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/30px SimSun; WHITE-SPACE: normal; COLOR: rgb(51,51,51); OVERFLOW: hidden; WORD-SPACING: 0px; PADDING-TOP: 0px; -webkit-text-stroke-width: 0px" id=zoom class=content>\r\n<P style="PADDING-BOTTOM: 0px; TEXT-INDENT: 2em; MARGIN: 0px 0px 30px; PADDING-LEFT: 0px; PADDING-RIGHT: 0px; PADDING-TOP: 0px"><A style="COLOR: rgb(55,126,188); TEXT-DECORATION: underline" href="http://zhubao.cngold.org/" target=_blank><STRONG>金投珠宝网</STRONG></A><STRONG>（http://zhubao.cngold.org/）7月31日讯，</STRONG>网上购物已经成为一种消费时尚，不少投资者还通过网络购买贵金属<A style="COLOR: rgb(55,126,188); TEXT-DECORATION: underline" href="http://zhubao.cngold.org/yuqi/" target=_blank>玉器</A>等贵重物品。不过其中存在较大风险，不少投资者通过网上销售买到假货，尤其对“白菜价”的贵金属玉器需有质疑态度，最好选择正规渠道。</P>\r\n<P style="PADDING-BOTTOM: 0px; TEXT-INDENT: 2em; MARGIN: 0px 0px 30px; PADDING-LEFT: 0px; PADDING-RIGHT: 0px; PADDING-TOP: 0px">据悉，一位网友从网上购买一套生肖彩色贵金属币套装，行情只有1000多元，比正规的特许零售店便宜了近3000元。但他的一位朋友发现这套贵金属币做工粗糙，随后该网友去专业机构进行鉴定，发现是仿冒品。实际上，“吐槽”自己在网上买到贵金属、玉器受骗上当的大有人在。</P>\r\n<P style="PADDING-BOTTOM: 0px; TEXT-INDENT: 2em; MARGIN: 0px 0px 30px; PADDING-LEFT: 0px; PADDING-RIGHT: 0px; PADDING-TOP: 0px">理财专家策略，在网上购买这类产品时，最好选择愿意给买家提供验货时间的卖家，也许者是正规商家旗下的网上直营店。</P>\r\n<P style="PADDING-BOTTOM: 0px; TEXT-INDENT: 2em; MARGIN: 0px 0px 30px; PADDING-LEFT: 0px; PADDING-RIGHT: 0px; PADDING-TOP: 0px">另一位人士表示，金银价非常透明，若在网上购买金子，行情低于市价很多则需谨慎，可能这些金子纯度不够。目前假货一般有三种：纯金、纯银但不是出自国内金币公司；贵金属纯度不够、重量不够；无中生有的臆造币。目前，国内金币总公司是国内人民银行(走势专区)直属的我国唯一经营贵金属纪念币的行业性公司，履行贵金属货币的发售职能。投资者最好选择这类正规渠道，不要因小失大。</P>\r\n<P style="PADDING-BOTTOM: 0px; TEXT-INDENT: 2em; MARGIN: 0px 0px 30px; PADDING-LEFT: 0px; PADDING-RIGHT: 0px; PADDING-TOP: 0px">关注<STRONG><A style="COLOR: rgb(55,126,188); TEXT-DECORATION: underline" href="http://m.cngold.org/" target=_blank>手机金投网</A></STRONG>（http://m.cngold.org），更多珠宝信息随时看。<SPAN style="POSITION: relative; TOP: 4px" class=icons><A style="COLOR: rgb(55,126,188); TEXT-DECORATION: underline" title=金投网 href="http://www.cngold.org/" target=_blank><IMG style="BORDER-RIGHT-WIDTH: 0px; TEXT-INDENT: -2em; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; BORDER-LEFT-WIDTH: 0px" alt=金投网 src="http://res.cngoldres.com/web/img/cngold_ico.jpg"></A></SPAN></P></DIV></SPAN>', 1, '贵金属网', '2015-08-04 10:30:08', NULL),
	(43, '借助“互联网+”带动农户增收 急水村变身“电商村”', '', '行业新闻', 'images\\20150803100905.jpg', '&nbsp;\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 0px; MARGIN: 5px auto; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 12px/30px arial, simsun, sans-serif; WHITE-SPACE: normal; COLOR: rgb(0,0,0); WORD-SPACING: 0px; PADDING-TOP: 0px; -webkit-text-stroke-width: 0px"><SPAN style="FONT-SIZE: medium">　　</SPAN><SPAN style="FONT-SIZE: small">湘桥区磷溪镇急水村的村民接到网上订单后，忙于将青柠檬贴标签、包装，准备通过快递发往全国各地。</SPAN></P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 0px; MARGIN: 5px auto; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 12px/30px arial, simsun, sans-serif; WHITE-SPACE: normal; COLOR: rgb(0,0,0); WORD-SPACING: 0px; PADDING-TOP: 0px; -webkit-text-stroke-width: 0px"><SPAN style="FONT-SIZE: medium">　　记者昨天在湘桥区磷溪镇急水村了解到，该村以农村电商龙头企业为核心，在“公司+农业合作社+农户”模式基础上，触电“互联网+”，逐步走出一条独具特色的农村电子商务产业链发展道路。</SPAN></P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 0px; MARGIN: 5px auto; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 12px/30px arial, simsun, sans-serif; WHITE-SPACE: normal; COLOR: rgb(0,0,0); WORD-SPACING: 0px; PADDING-TOP: 0px; -webkit-text-stroke-width: 0px"><SPAN style="FONT-SIZE: medium">　　记者来到急水村时，村民陈思源和伙伴们正忙着将刚从自家地里采摘下来的新鲜青柠檬进行分拣、称重、包装，贴标单，准备发往江苏常州客户。陈思源今年26岁，高中毕业后曾在珠三角城市打工，前年返回村里，依托本地电商企业中志农业开发有限公司的销售平台，以“互联网+农产品”的形式销售自家生产的青柠檬、番石榴、青枣、杨桃等农产品。陈思源说，家里种有12亩多水果，目前月均网上销售额近万元，年纯收入比传统销售方式增加3万多元。</SPAN></P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 0px; MARGIN: 5px auto; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 12px/30px arial, simsun, sans-serif; WHITE-SPACE: normal; COLOR: rgb(0,0,0); WORD-SPACING: 0px; PADDING-TOP: 0px; -webkit-text-stroke-width: 0px"><SPAN style="FONT-SIZE: medium">　　“电子商务以青年人为主，由于销路打开收益好，村民们积极性提高，也陆续参加进来，效果不错”，急水村村支部书记蔡荣浩对记者说，如今急水村已成为周边知名的“电商村”。据了解，2012年，中志公司与村委会联合成立了水果供销合作社，与近200户农户签订合同，整合村果树种植面积2100多亩，以农户为单位进行种植。公司先后投入资金1300多万元，为农户购置现代化设备，提供种苗、肥料、技术支持和农科信息等资金和服务，推动集约化、规模化、标准化种植。在此模式基础上，公司积极搭建电商创新平台，广泛招募合作村民，进行专业化电商营销培训，积极推进“互联网+三农”融合发展。今年6月8日-9日，公司参与“广货网上行”活动，通过淘宝聚划算平台销售旗下“韩金果”品牌青柠檬，仅2天时间销售超过5万斤68万元，10天销售超过8.5万斤达110万元，为淘宝商品行业交易指数第一位，农户们分享到了“互联网+”带来的红利。据中志公司电商主管黄晓东介绍，参与公司合作的农户销售量最多的月均销售额3万多元，去年参合农户每户纯收入增加约3万元。</SPAN></P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 0px; MARGIN: 5px auto; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 12px/30px arial, simsun, sans-serif; WHITE-SPACE: normal; COLOR: rgb(0,0,0); WORD-SPACING: 0px; PADDING-TOP: 0px; -webkit-text-stroke-width: 0px"><SPAN style="FONT-SIZE: medium">　　促进农户增收、大众创业，“急水模式”是可以复制的。目前，中志公司已规划建设农村电子商务营运中心，并与13个村签订合同，着力打造“万亩青柠檬种植基地”。预计，随着中志公司电商项目的推进，将创造2000个就业岗位及带动周边2万农户增收，急水村及周边村农民电商创业热情空前高涨。</SPAN></P>', 1, '潮州新闻网', '2015-08-04 10:36:22', NULL),
	(44, '瞄准跨境B2B物流 宅急送要借“仓”翻身', '', '行业新闻', 'images\\8537422438574322.jpg', '&nbsp; \r\n<P style="PADDING-BOTTOM: 0px; BORDER-RIGHT-WIDTH: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/26px 微软雅黑, 宋体; WORD-WRAP: break-word; WHITE-SPACE: normal; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; COLOR: rgb(0,0,0); BORDER-LEFT-WIDTH: 0px; WORD-SPACING: 0px; PADDING-TOP: 26px; -webkit-text-stroke-width: 0px">　<SPAN style="PADDING-BOTTOM: 0px; BORDER-RIGHT-WIDTH: 0px; MARGIN: 0px; PADDING-LEFT: 0px; PADDING-RIGHT: 0px; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; FONT-SIZE: 14px; BORDER-LEFT-WIDTH: 0px; PADDING-TOP: 0px"><STRONG style="PADDING-BOTTOM: 0px; BORDER-RIGHT-WIDTH: 0px; MARGIN: 0px; PADDING-LEFT: 0px; PADDING-RIGHT: 0px; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; FONT-SIZE: 14px; BORDER-LEFT-WIDTH: 0px; FONT-WEIGHT: bold; PADDING-TOP: 0px"><SPAN style="PADDING-BOTTOM: 0px; BORDER-RIGHT-WIDTH: 0px; MARGIN: 0px; PADDING-LEFT: 0px; PADDING-RIGHT: 0px; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; FONT-SIZE: 14px; BORDER-LEFT-WIDTH: 0px; PADDING-TOP: 0px">【编者按】今年是宅急送走过的第21个年头。从B2B物流发家，经历过C2C、B2C两次转型失败后，这家老牌物流企业于上年突然获得五大财团的战略投资。</SPAN></STRONG></SPAN></P>\r\n<P style="PADDING-BOTTOM: 0px; BORDER-RIGHT-WIDTH: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/26px 微软雅黑, 宋体; WORD-WRAP: break-word; WHITE-SPACE: normal; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; COLOR: rgb(0,0,0); BORDER-LEFT-WIDTH: 0px; WORD-SPACING: 0px; PADDING-TOP: 26px; -webkit-text-stroke-width: 0px">　　<SPAN style="PADDING-BOTTOM: 0px; BORDER-RIGHT-WIDTH: 0px; MARGIN: 0px; PADDING-LEFT: 0px; PADDING-RIGHT: 0px; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; FONT-SIZE: 14px; BORDER-LEFT-WIDTH: 0px; PADDING-TOP: 0px"><STRONG style="PADDING-BOTTOM: 0px; BORDER-RIGHT-WIDTH: 0px; MARGIN: 0px; PADDING-LEFT: 0px; PADDING-RIGHT: 0px; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; FONT-SIZE: 14px; BORDER-LEFT-WIDTH: 0px; FONT-WEIGHT: bold; PADDING-TOP: 0px"><SPAN style="PADDING-BOTTOM: 0px; BORDER-RIGHT-WIDTH: 0px; MARGIN: 0px; PADDING-LEFT: 0px; PADDING-RIGHT: 0px; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; FONT-SIZE: 14px; BORDER-LEFT-WIDTH: 0px; PADDING-TOP: 0px">拥有充裕的资金注入后，宅急送将如何借势重振其在物流界的地位？宅急送国际物流有限公司总经理殷俭认为，以仓配为重点的跨境B2B物流服务，已成了宅急送未来翻身的重要出路。</SPAN></STRONG></SPAN></P><SPAN style="PADDING-BOTTOM: 0px; BORDER-RIGHT-WIDTH: 0px; MARGIN: 0px; PADDING-LEFT: 0px; PADDING-RIGHT: 0px; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; FONT-SIZE: 14px; BORDER-LEFT-WIDTH: 0px; PADDING-TOP: 0px"><STRONG style="PADDING-BOTTOM: 0px; BORDER-RIGHT-WIDTH: 0px; MARGIN: 0px; PADDING-LEFT: 0px; PADDING-RIGHT: 0px; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; FONT-SIZE: 14px; BORDER-LEFT-WIDTH: 0px; FONT-WEIGHT: bold; PADDING-TOP: 0px"><SPAN style="PADDING-BOTTOM: 0px; BORDER-RIGHT-WIDTH: 0px; MARGIN: 0px; PADDING-LEFT: 0px; PADDING-RIGHT: 0px; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; FONT-SIZE: 14px; BORDER-LEFT-WIDTH: 0px; PADDING-TOP: 0px">\r\n<P style="PADDING-BOTTOM: 0px; BORDER-RIGHT-WIDTH: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/26px 微软雅黑, 宋体; WORD-WRAP: break-word; WHITE-SPACE: normal; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; COLOR: rgb(0,0,0); BORDER-LEFT-WIDTH: 0px; WORD-SPACING: 0px; PADDING-TOP: 26px; -webkit-text-stroke-width: 0px">　<STRONG style="PADDING-BOTTOM: 0px; BORDER-RIGHT-WIDTH: 0px; MARGIN: 0px; PADDING-LEFT: 0px; PADDING-RIGHT: 0px; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; FONT-SIZE: 14px; BORDER-LEFT-WIDTH: 0px; FONT-WEIGHT: bold; PADDING-TOP: 0px">21年的沉淀成跨境业务发力点</STRONG></P>\r\n<P style="PADDING-BOTTOM: 0px; BORDER-RIGHT-WIDTH: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/26px 微软雅黑, 宋体; WORD-WRAP: break-word; WHITE-SPACE: normal; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; COLOR: rgb(0,0,0); BORDER-LEFT-WIDTH: 0px; WORD-SPACING: 0px; PADDING-TOP: 26px; -webkit-text-stroke-width: 0px">　　2014年8月，宅急送开始成立独立法人的宅急送国际物流子公司，并在9月份把新公司总部设立在跨境电商行业发展最迅猛的深圳。</P>\r\n<P style="PADDING-BOTTOM: 0px; BORDER-RIGHT-WIDTH: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/26px 微软雅黑, 宋体; WORD-WRAP: break-word; WHITE-SPACE: normal; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; COLOR: rgb(0,0,0); BORDER-LEFT-WIDTH: 0px; WORD-SPACING: 0px; PADDING-TOP: 26px; -webkit-text-stroke-width: 0px">　　虽说国际物流子公司仅成立一年，但殷俭认为，宅急送跨境物流的配套设施早已在二十来年的物流行业打滚中得以沉淀下来，也是这个原因使得这位老牌物流企业在去年十月获得五大财团的青睐。</P>\r\n<P style="PADDING-BOTTOM: 0px; BORDER-RIGHT-WIDTH: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/26px 微软雅黑, 宋体; WORD-WRAP: break-word; WHITE-SPACE: normal; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; COLOR: rgb(0,0,0); BORDER-LEFT-WIDTH: 0px; WORD-SPACING: 0px; PADDING-TOP: 26px; -webkit-text-stroke-width: 0px">　　“一张取派网、一张分拨网、一张干线网以及一张仓储网络，四者支撑起宅急送在国内做仓配的基础。而无论做出口物流还是进口物流，国内仓配资源是非常重要的。”殷俭分析到，“针对出口物流，宅急送在国内积累了强大的网络资源、取件能力。而对于进口物流而言，宅急送国内C端的派送能力也是非常有价值的。”</P>\r\n<P style="PADDING-BOTTOM: 0px; BORDER-RIGHT-WIDTH: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/26px 微软雅黑, 宋体; WORD-WRAP: break-word; WHITE-SPACE: normal; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; COLOR: rgb(0,0,0); BORDER-LEFT-WIDTH: 0px; WORD-SPACING: 0px; PADDING-TOP: 26px; -webkit-text-stroke-width: 0px">　　实际上，据亿邦动力网了解，目前，宅急送的取派网点已有4700多个，覆盖中国2000多个城市，一级分拨站点13个，二级22个，三级296个，还有干线网、干线班车119条，省地班车472条，地县班车1377条，航空线路700条，仓储网包含40个配送中心，48个地址仓，23万平方米仓储面积。</P>\r\n<P style="PADDING-BOTTOM: 0px; BORDER-RIGHT-WIDTH: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/26px 微软雅黑, 宋体; WORD-WRAP: break-word; WHITE-SPACE: normal; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; COLOR: rgb(0,0,0); BORDER-LEFT-WIDTH: 0px; WORD-SPACING: 0px; PADDING-TOP: 26px; -webkit-text-stroke-width: 0px">　　“这些都是宅急送多年来的积累，是宅急送做跨境的核心竞争力。”殷俭说道。</P>\r\n<P style="PADDING-BOTTOM: 0px; BORDER-RIGHT-WIDTH: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/26px 微软雅黑, 宋体; WORD-WRAP: break-word; WHITE-SPACE: normal; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; COLOR: rgb(0,0,0); BORDER-LEFT-WIDTH: 0px; WORD-SPACING: 0px; PADDING-TOP: 26px; -webkit-text-stroke-width: 0px">　　<STRONG style="PADDING-BOTTOM: 0px; BORDER-RIGHT-WIDTH: 0px; MARGIN: 0px; PADDING-LEFT: 0px; PADDING-RIGHT: 0px; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; FONT-SIZE: 14px; BORDER-LEFT-WIDTH: 0px; FONT-WEIGHT: bold; PADDING-TOP: 0px">未来出口物流必然是B2B年代</STRONG></P>\r\n<P style="PADDING-BOTTOM: 0px; BORDER-RIGHT-WIDTH: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/26px 微软雅黑, 宋体; WORD-WRAP: break-word; WHITE-SPACE: normal; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; COLOR: rgb(0,0,0); BORDER-LEFT-WIDTH: 0px; WORD-SPACING: 0px; PADDING-TOP: 26px; -webkit-text-stroke-width: 0px">　　值得注意的是，在出口物流的布局上，宅急送并无心恋战2C端，而是把眼光放在更广阔的B2B市场。</P>\r\n<P style="PADDING-BOTTOM: 0px; BORDER-RIGHT-WIDTH: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/26px 微软雅黑, 宋体; WORD-WRAP: break-word; WHITE-SPACE: normal; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; COLOR: rgb(0,0,0); BORDER-LEFT-WIDTH: 0px; WORD-SPACING: 0px; PADDING-TOP: 26px; -webkit-text-stroke-width: 0px">　　殷俭介绍，目前，宅急送跟出口相关的产品有四款，分别为邮政小包业务“宅邮宝”、商业快递“宅特快”、专线业务“全球送”以及海外仓业务“宅仓宝”。</P>\r\n<P style="PADDING-BOTTOM: 0px; BORDER-RIGHT-WIDTH: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/26px 微软雅黑, 宋体; WORD-WRAP: break-word; WHITE-SPACE: normal; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; COLOR: rgb(0,0,0); BORDER-LEFT-WIDTH: 0px; WORD-SPACING: 0px; PADDING-TOP: 26px; -webkit-text-stroke-width: 0px">　　其中，以B2B为侧重点的“全球送”和“宅仓宝”成了宅急送跨境出口最核心的两款产品。在殷俭眼中，未来跨境出口物流的现状必然会从“大单变小”过渡为“小单变大”的年代。</P>\r\n<P style="PADDING-BOTTOM: 0px; BORDER-RIGHT-WIDTH: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/26px 微软雅黑, 宋体; WORD-WRAP: break-word; WHITE-SPACE: normal; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; COLOR: rgb(0,0,0); BORDER-LEFT-WIDTH: 0px; WORD-SPACING: 0px; PADDING-TOP: 26px; -webkit-text-stroke-width: 0px">　　他分析，在过去，中国卖家利用跨境电商平台把性价比高的产品卖到国外，物流手段大多局限在邮政小包。而随着中国品牌走出国门，以及大卖家的外贸转型，“小单变大”终成外贸电商的趋势，这时，跨境电商卖家的供应链势必下沉，以海外仓为基础的“仓对仓”物流形式将占据主导地位。</P>\r\n<P style="PADDING-BOTTOM: 0px; BORDER-RIGHT-WIDTH: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/26px 微软雅黑, 宋体; WORD-WRAP: break-word; WHITE-SPACE: normal; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; COLOR: rgb(0,0,0); BORDER-LEFT-WIDTH: 0px; WORD-SPACING: 0px; PADDING-TOP: 26px; -webkit-text-stroke-width: 0px">　　此外，殷俭认为，随着外国消费者的体验不断增加，以及多个跨境电商目标国在政策上的越趋严格，海外仓也成了商家必然选择。“有的国家政策要求卖家14天之内允许退换货，这些政策限制通过邮政小包是解决不了的，所以只能走海外仓。”殷俭说道。</P>\r\n<P style="PADDING-BOTTOM: 0px; BORDER-RIGHT-WIDTH: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/26px 微软雅黑, 宋体; WORD-WRAP: break-word; WHITE-SPACE: normal; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; COLOR: rgb(0,0,0); BORDER-LEFT-WIDTH: 0px; WORD-SPACING: 0px; PADDING-TOP: 26px; -webkit-text-stroke-width: 0px">　　因此，宅急送瞄准了未来跨境物流的趋势，在跨境业务上更加关注于“订单前”的工作，即海外仓以及B2B物流。殷俭透露，目前，宅急送已经在研发一套基于电商的WMS系统以对接宅急送的海外仓，并跟美国、欧洲等地的企业建立起合作关系，将在第三季度上线整个海外仓业务。</P>\r\n<P style="PADDING-BOTTOM: 0px; BORDER-RIGHT-WIDTH: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/26px 微软雅黑, 宋体; WORD-WRAP: break-word; WHITE-SPACE: normal; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; COLOR: rgb(0,0,0); BORDER-LEFT-WIDTH: 0px; WORD-SPACING: 0px; PADDING-TOP: 26px; -webkit-text-stroke-width: 0px">　　当然，宅急送不会完全放弃邮政小包，“宅邮宝”将成为宅急送跨境出口物流业务的一个补充。“因为邮政小包是不会消亡的，小卖家仍会延续用小包业务寄送低价格轻质量的商品。”殷俭说道。</P>\r\n<P style="PADDING-BOTTOM: 0px; BORDER-RIGHT-WIDTH: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/26px 微软雅黑, 宋体; WORD-WRAP: break-word; WHITE-SPACE: normal; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; COLOR: rgb(0,0,0); BORDER-LEFT-WIDTH: 0px; WORD-SPACING: 0px; PADDING-TOP: 26px; -webkit-text-stroke-width: 0px">　　<STRONG style="PADDING-BOTTOM: 0px; BORDER-RIGHT-WIDTH: 0px; MARGIN: 0px; PADDING-LEFT: 0px; PADDING-RIGHT: 0px; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; FONT-SIZE: 14px; BORDER-LEFT-WIDTH: 0px; FONT-WEIGHT: bold; PADDING-TOP: 0px">进口物流不能单点突破</STRONG></P>\r\n<P style="PADDING-BOTTOM: 0px; BORDER-RIGHT-WIDTH: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/26px 微软雅黑, 宋体; WORD-WRAP: break-word; WHITE-SPACE: normal; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; COLOR: rgb(0,0,0); BORDER-LEFT-WIDTH: 0px; WORD-SPACING: 0px; PADDING-TOP: 26px; -webkit-text-stroke-width: 0px">　　跟出口物流业务一样，殷俭认为宅急送在进口物流业务也应该以“仓”为基础，在打法上，宅急送把自己定位为一体化全流程的物流服务商。</P>\r\n<P style="PADDING-BOTTOM: 0px; BORDER-RIGHT-WIDTH: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/26px 微软雅黑, 宋体; WORD-WRAP: break-word; WHITE-SPACE: normal; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; COLOR: rgb(0,0,0); BORDER-LEFT-WIDTH: 0px; WORD-SPACING: 0px; PADDING-TOP: 26px; -webkit-text-stroke-width: 0px">　　他认为，目前部分物流企业都是趁着进口电商这个风口，针对跨境物流流程中的几个核心点提供“小散乱”的物流服务，接入的只是跨境进口物流链条中间的其中一环。</P>\r\n<P style="PADDING-BOTTOM: 0px; BORDER-RIGHT-WIDTH: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/26px 微软雅黑, 宋体; WORD-WRAP: break-word; WHITE-SPACE: normal; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; COLOR: rgb(0,0,0); BORDER-LEFT-WIDTH: 0px; WORD-SPACING: 0px; PADDING-TOP: 26px; -webkit-text-stroke-width: 0px">　　而宅急送依靠本身国内积累的资源优势，设计了针对进口物流全流程的“宅进宝”业务。</P>\r\n<P style="PADDING-BOTTOM: 0px; BORDER-RIGHT-WIDTH: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/26px 微软雅黑, 宋体; WORD-WRAP: break-word; WHITE-SPACE: normal; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; COLOR: rgb(0,0,0); BORDER-LEFT-WIDTH: 0px; WORD-SPACING: 0px; PADDING-TOP: 26px; -webkit-text-stroke-width: 0px">　　“从海外的集货到干线的运输，到保税仓，到海关通关，到国内配送，宅急送会提供全流程的进口物流服务。而且宅急送的系统跟电子口岸搭建的通关服务平台是对接的，商品从国外到国内的订单都是一体化的，而目前很多转运公司都需要换单才能把商品进口到国内。”殷俭说到。</P>\r\n<P style="PADDING-BOTTOM: 0px; BORDER-RIGHT-WIDTH: 0px; TEXT-TRANSFORM: none; BACKGROUND-COLOR: rgb(255,255,255); TEXT-INDENT: 0px; MARGIN: 0px; PADDING-LEFT: 0px; LETTER-SPACING: normal; PADDING-RIGHT: 0px; FONT: 14px/26px 微软雅黑, 宋体; WORD-WRAP: break-word; WHITE-SPACE: normal; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; COLOR: rgb(0,0,0); BORDER-LEFT-WIDTH: 0px; WORD-SPACING: 0px; PADDING-TOP: 26px; -webkit-text-stroke-width: 0px">　　除此之外，殷俭还透露，未来宅急送会尝试对接供应链金融以及支付服务，并不排除在保税仓内做展示营销，提供保税仓内的个性化服务。</P></SPAN></STRONG></SPAN><SPAN style="PADDING-BOTTOM: 0px; BORDER-RIGHT-WIDTH: 0px; MARGIN: 0px; PADDING-LEFT: 0px; PADDING-RIGHT: 0px; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; FONT-SIZE: 14px; BORDER-LEFT-WIDTH: 0px; PADDING-TOP: 0px"><STRONG style="PADDING-BOTTOM: 0px; BORDER-RIGHT-WIDTH: 0px; MARGIN: 0px; PADDING-LEFT: 0px; PADDING-RIGHT: 0px; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; FONT-SIZE: 14px; BORDER-LEFT-WIDTH: 0px; FONT-WEIGHT: bold; PADDING-TOP: 0px"><SPAN style="PADDING-BOTTOM: 0px; BORDER-RIGHT-WIDTH: 0px; MARGIN: 0px; PADDING-LEFT: 0px; PADDING-RIGHT: 0px; BORDER-TOP-WIDTH: 0px; BORDER-BOTTOM-WIDTH: 0px; FONT-SIZE: 14px; BORDER-LEFT-WIDTH: 0px; PADDING-TOP: 0px"></SPAN></STRONG></SPAN>', 1, '亿邦动力网', '2015-08-04 10:54:42', NULL),
	(45, '荷兰网络消费者超过1000万人', '', '行业新闻', '', '&nbsp;\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 20px; TEXT-TRANSFORM: none; TEXT-INDENT: 2em; MARGIN: 0px; PADDING-LEFT: 30px; LETTER-SPACING: normal; PADDING-RIGHT: 30px; FONT: 14px/28px Simsun; WHITE-SPACE: normal; COLOR: rgb(0,0,0); WORD-SPACING: 0px; PADDING-TOP: 0px; -webkit-text-stroke-width: 0px"><A style="TEXT-DECORATION: none" class=keylink href="http://helan.haiwainet.cn/" target=_blank>荷兰</A>统计局近日发布数据显示，2014年荷兰网络消费者达1040万人，其中频繁进行网上购物的消费者人数（在调查前三个月内曾进行网购）从2005年的390万增至790万人。此外，还有约200万网民从未上网购物。2014年，荷兰网络零售额同比增长11%。</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 20px; TEXT-TRANSFORM: none; TEXT-INDENT: 2em; MARGIN: 0px; PADDING-LEFT: 30px; LETTER-SPACING: normal; PADDING-RIGHT: 30px; FONT: 14px/28px Simsun; WHITE-SPACE: normal; COLOR: rgb(0,0,0); WORD-SPACING: 0px; PADDING-TOP: 0px; -webkit-text-stroke-width: 0px">在网络零售商品和服务中，<A style="TEXT-DECORATION: none" class=keylink href="http://travel.haiwainet.cn/" target=_blank>旅游</A>、服装和票务类产品最受欢迎，频繁网络购物者中三分之二购买过旅游服务以及服装和鞋类，逾二分之一曾购买门票。购买生活用品的网络消费者占比从2013年的31%增至39%，<A style="TEXT-DECORATION: none" class=keylink href="http://shipin.haiwainet.cn/" target=_blank>食品</A>、化妆品和清洁产品网络购物占比也有所提高。</P>\r\n<P style="TEXT-ALIGN: left; PADDING-BOTTOM: 20px; TEXT-TRANSFORM: none; TEXT-INDENT: 2em; MARGIN: 0px; PADDING-LEFT: 30px; LETTER-SPACING: normal; PADDING-RIGHT: 30px; FONT: 14px/28px Simsun; WHITE-SPACE: normal; COLOR: rgb(0,0,0); WORD-SPACING: 0px; PADDING-TOP: 0px; -webkit-text-stroke-width: 0px">在支付方式上，92%的网络消费者利用网上银行进行支付，逾40%使用信用卡，约30%使用现金或银行转账，预付卡和电子钱包等方式使用极少。94%的荷兰网络消费者从本国购物，28%曾从其他欧盟国家购物，20%曾从非欧盟国家进行网络购物。</P>', 0, '海外网', '2015-08-04 11:07:56', NULL);
/*!40000 ALTER TABLE `news` ENABLE KEYS */;


-- 导出  表 infocomshop.notice 结构
DROP TABLE IF EXISTS `notice`;
CREATE TABLE IF NOT EXISTS `notice` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `author` varchar(255) DEFAULT NULL,
  `noticetype` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `content` text,
  `recommend` int(11) DEFAULT NULL,
  `cc` varchar(255) DEFAULT NULL,
  `publicdatetime` datetime DEFAULT NULL,
  `visit` int(11) DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=gb2312 ROW_FORMAT=COMPACT;

-- 正在导出表  infocomshop.notice 的数据：~5 rows (大约)
DELETE FROM `notice`;
/*!40000 ALTER TABLE `notice` DISABLE KEYS */;
INSERT INTO `notice` (`Id`, `title`, `author`, `noticetype`, `pic`, `content`, `recommend`, `cc`, `publicdatetime`, `visit`) VALUES
	(38, 'sdfsf', 'dfsf', '公司公告', 'images\\02.jpeg', '', 1, 'fsdfsf', '2015-06-14 09:56:51', NULL),
	(39, 'fssff', 'fsfs', '公司公告', 'images\\2.jpg', 'ggfddgf', 1, 'gggggg', '2015-06-14 10:01:26', NULL),
	(40, 'rete', 'ter', '公司公告', 'images\\3C532DE8E0F4D2A3DD9BEEF7A770157C.jpg', '&nbsp;rtret', 1, 'etetet', '2015-06-14 10:03:08', NULL),
	(41, 'erwr', 'wrwr', '公司公告', 'images\\172362186_125x110.jpg', '&nbsp;ewre', 1, 'rwrwr', '2015-06-14 10:04:38', NULL),
	(42, 'fff', 'fdsfs', '公司公告', 'images\\2.jpg', '&nbsp;fdfs', 1, 'fsdfdf', '2015-06-14 10:08:51', NULL),
	(43, 'fdsfds', 'fsfs', '公司公告', '', '&nbsp;sdfsfsf', 1, 'dfdsfdsf', '2015-08-08 19:55:40', NULL);
/*!40000 ALTER TABLE `notice` ENABLE KEYS */;


-- 导出  表 infocomshop.order 结构
DROP TABLE IF EXISTS `order`;
CREATE TABLE IF NOT EXISTS `order` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `username` char(50) DEFAULT NULL,
  `productid` int(11) DEFAULT NULL,
  `quantity` int(11) DEFAULT NULL,
  `totalprice` decimal(10,2) DEFAULT NULL,
  `payment` varchar(255) DEFAULT NULL,
  `postway` varchar(255) DEFAULT NULL,
  `orderdatetime` datetime DEFAULT NULL,
  `ifpay` int(3) DEFAULT NULL,
  `ifsent` int(3) DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=130 DEFAULT CHARSET=gb2312;

-- 正在导出表  infocomshop.order 的数据：~27 rows (大约)
DELETE FROM `order`;
/*!40000 ALTER TABLE `order` DISABLE KEYS */;
INSERT INTO `order` (`Id`, `username`, `productid`, `quantity`, `totalprice`, `payment`, `postway`, `orderdatetime`, `ifpay`, `ifsent`) VALUES
	(97, 'sglg', 26, 1, 50.00, '银行转账', '平邮', '2011-06-12 01:32:38', NULL, NULL),
	(98, 'sglg', 26, 1, 50.00, '银行转账', '平邮', '2011-06-12 01:32:38', NULL, NULL),
	(99, 'sglg', 26, 1, 50.00, '银行转账', '平邮', '2011-06-12 01:32:38', NULL, NULL),
	(100, 'sglg', 26, 1, 50.00, '银行转账', '平邮', '2011-06-12 01:32:38', NULL, NULL),
	(101, 'sglg', 26, 1, 50.00, '银行转账', '平邮', '2011-06-12 01:32:38', NULL, NULL),
	(102, 'sglg', 26, 1, 50.00, '银行转账', '平邮', '2011-06-12 01:32:39', NULL, NULL),
	(103, 'sglg', 26, 1, 50.00, '银行转账', '平邮', '2011-06-12 01:32:39', NULL, NULL),
	(104, 'sglg', 26, 1, 50.00, '银行转账', '平邮', '2011-06-12 01:32:39', NULL, NULL),
	(105, 'sglg', 26, 1, 50.00, '银行转账', '平邮', '2011-06-12 01:32:39', NULL, NULL),
	(106, 'sglg', 26, 1, 50.00, '银行转账', '平邮', '2011-06-12 01:49:11', NULL, NULL),
	(107, 'sglg', 26, 1, 50.00, '银行转账', '平邮', '2011-06-27 22:08:55', NULL, NULL),
	(108, 'sglg', 27, 1, 60.00, '银行转账', '平邮', '2011-06-27 22:09:01', NULL, NULL),
	(109, 'sglg', 26, 1, 50.00, '银行转账', '平邮', '2011-08-18 00:35:47', NULL, NULL),
	(110, 'sglg', 30, 1, 2.50, '银行转账', '平邮', '2011-12-14 10:32:10', NULL, NULL),
	(111, 'sglg', 64, 1, 70000.00, '网上银行', '平邮', '2013-06-27 06:24:50', NULL, NULL),
	(112, 'sglg', 63, 1, 999.00, '网上银行', '平邮', '2013-06-27 06:24:50', NULL, NULL),
	(113, '', 64, 1, 70000.00, '网上银行', '快递EMS', '2013-07-13 18:13:37', NULL, NULL),
	(114, '', 68, 2, 200.00, '网上银行', '快递EMS', '2015-06-12 20:43:13', NULL, NULL),
	(115, '', 71, 2, 800.00, '支付宝', '快递EMS', '2015-07-09 12:47:53', NULL, NULL),
	(116, '', 59, 1, 4300.00, '支付宝', '快递EMS', '2015-07-09 12:47:55', NULL, NULL),
	(117, '', 58, 1, 399.00, '支付宝', '快递EMS', '2015-07-09 12:47:56', NULL, NULL),
	(118, '', 71, 2, 800.00, '支付宝', '快递EMS', '2015-07-09 12:47:58', NULL, NULL),
	(119, '', 59, 1, 4300.00, '支付宝', '快递EMS', '2015-07-09 12:47:59', NULL, NULL),
	(120, '', 58, 1, 399.00, '支付宝', '快递EMS', '2015-07-09 12:47:59', NULL, NULL),
	(121, '', 71, 2, 800.00, '支付宝', '快递EMS', '2015-07-09 12:47:59', NULL, NULL),
	(122, '', 59, 1, 4300.00, '支付宝', '快递EMS', '2015-07-09 12:47:59', NULL, NULL),
	(123, '', 58, 1, 399.00, '支付宝', '快递EMS', '2015-07-09 12:48:00', NULL, NULL),
	(124, '', 71, 1, 400.00, '网银在线', '中通速递', '2015-07-09 20:54:01', NULL, NULL),
	(125, '', 72, 1, 60000.00, '支付宝', '快递EMS', '2015-07-16 16:17:18', NULL, NULL),
	(126, '', 71, 2, 800.00, '支付宝', '快递EMS', '2015-07-16 16:17:18', NULL, NULL),
	(127, '', 73, 5, 20000.00, '支付宝', '快递EMS', '2015-08-04 15:43:02', NULL, NULL),
	(128, '', 58, 1, 399.00, '支付宝', '快递EMS', '2015-08-04 15:43:02', NULL, NULL),
	(129, '', 70, 1, 6000.00, '支付宝', '快递EMS', '2015-08-04 15:43:02', NULL, NULL);
/*!40000 ALTER TABLE `order` ENABLE KEYS */;


-- 导出  表 infocomshop.products 结构
DROP TABLE IF EXISTS `products`;
CREATE TABLE IF NOT EXISTS `products` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `productname` varchar(255) DEFAULT NULL,
  `bigcategory` varchar(255) DEFAULT NULL,
  `smallcategory` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `price` decimal(10,2) DEFAULT NULL,
  `introduce` text,
  `parameter` text,
  `recommend` int(11) DEFAULT NULL,
  `regdatetime` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=75 DEFAULT CHARSET=gb2312;

-- 正在导出表  infocomshop.products 的数据：~7 rows (大约)
DELETE FROM `products`;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` (`Id`, `productname`, `bigcategory`, `smallcategory`, `pic`, `price`, `introduce`, `parameter`, `recommend`, `regdatetime`) VALUES
	(57, '夏普 LCD-40LX3', '电视', '液晶电视', 'images\\3.jpg', 4999.00, '&nbsp; \r\n<table style="margin: auto; color: rgb(51, 51, 51); font-size: 12px; table-layout: fixed;" id="Jtable" class="tbWrap" border="0" cellSpacing="0" cellPadding="0" width="740">\r\n<thead>\r\n<tr>\r\n<td style="background: rgb(212, 234, 255); border-width: 1px 1px medium; border-style: solid solid none; border-color: rgb(212, 234, 255) rgb(212, 234, 255) currentColor; padding-top: 6px; padding-bottom: 7px; padding-left: 10px; vertical-align: middle;">\r\n<table border="0" cellSpacing="0" cellPadding="0" width="100%">\r\n<tbody>\r\n<tr>\r\n<td align="left"><strong style="line-height: 16px; font-size: 14px;">夏普 LCD-40LX330A 详细参数</strong></td>\r\n<td width="165">查看：<a style="font-weight: 400;" href="http://product.pconline.com.cn/lcd_tv/sharp/485837_detail.html"><font color="#0055aa">更多信息</font></a> | <a style="font-weight: 400;" href="http://product.pconline.com.cn/pdlib/485837_picture.html"><font color="#0055aa">产品图片</font></a></td></tr></tbody></table></td></tr></thead>\r\n<tbody>\r\n<tr>\r\n<td style="padding: 10px 0px 5px 10px; border: 1px solid rgb(156, 191, 229);"><a title="屏幕尺寸：40" href="http://k.pconline.com.cn/question/2685065.html" target="_blank"><font color="#0055aa"><img style="padding: 0px 4px 4px 0px;" alt="尺寸" src="http://img.pconline.com.cn/images/product/20112/28/12988891865635570.jpg" width="36" height="36"> </font></a><a title="屏幕比例：16:9" href="http://k.pconline.com.cn/question/1172.html" target="_blank"><font color="#0055aa"><img style="padding: 0px 4px 4px 0px;" alt="屏幕" src="http://img.pconline.com.cn/images/product/20112/24/12985307829863250.png" width="36" height="36"> </font></a><a title="屏幕分辨率：1920×1080" href="http://k.pconline.com.cn/question/1512.html" target="_blank"><font color="#0055aa"><img style="padding: 0px 4px 4px 0px;" alt="分辨率" src="http://img.pconline.com.cn/images/product/20112/28/12988896502723250.jpg" width="36" height="36"> </font></a><a title="高清格式：1080p" href="http://k.pconline.com.cn/question/2612.html" target="_blank"><font color="#0055aa"><img style="padding: 0px 4px 4px 0px;" alt="1080P" src="http://img.pconline.com.cn/images/product/20112/24/12985303130024680.png" width="36" height="36"> </font></a><font color="#0055aa"><img style="padding: 0px 4px 4px 0px;" alt="面板" src="http://img.pconline.com.cn/images/product/20112/28/12988894873421560.jpg" width="36" height="36"></font> <a title="背光性能：LED背光源" href="http://k.pconline.com.cn/question/2685459.html" target="_blank"><img style="padding: 0px 4px 4px 0px;" alt="背光" src="http://img.pconline.com.cn/images/product/20112/28/12988897597803000.jpg" width="36" height="36"><font color="#0055aa"> </font></a><a title="输入端口：HDMI接口" href="http://k.pconline.com.cn/question/2685470.html" target="_blank"><font color="#0055aa"><img style="padding: 0px 4px 4px 0px;" alt="HDMI" src="http://img.pconline.com.cn/images/product/20112/24/12985322204140180.png" width="36" height="36"> </font></a></td></tr>\r\n<tr>\r\n<td style="background: rgb(212, 234, 255); border-width: medium 1px 1px; border-style: none solid solid; border-color: currentColor rgb(156, 191, 229) rgb(156, 191, 229); text-align: left; padding-top: 6px; padding-bottom: 7px; padding-left: 15px; vertical-align: middle;"><strong>基本参数</strong></td></tr>\r\n<tr>\r\n<td style="border-width: medium 1px 1px; border-style: none solid solid; border-color: currentColor rgb(156, 191, 229) rgb(156, 191, 229);">\r\n<table style="border-spacing: 0;" class="param" border="0" cellSpacing="0" cellPadding="0" width="100%">\r\n<tbody>\r\n<tr>\r\n<td style="background: rgb(242, 249, 255); border-width: medium 1px 1px medium; border-style: none dotted dotted none; border-color: currentColor rgb(156, 191, 229) rgb(156, 191, 229) currentColor; text-align: center; color: rgb(119, 119, 119); padding-top: 6px; padding-bottom: 7px; font-weight: 400; vertical-align: middle; zoom: 1.0001;" width="110">型号</td>\r\n<td style="padding-left: 10px; border-bottom-color: rgb(156, 191, 229); border-bottom-width: 1px; border-bottom-style: dotted;">LCD-40LX330A</td></tr>\r\n<tr>\r\n<td style="background: rgb(242, 249, 255); border-width: medium 1px 1px medium; border-style: none dotted dotted none; border-color: currentColor rgb(156, 191, 229) rgb(156, 191, 229) currentColor; text-align: center; color: rgb(119, 119, 119); padding-top: 6px; padding-bottom: 7px; font-weight: 400; vertical-align: middle; zoom: 1.0001;" width="110">特色分类</td>\r\n<td style="padding-left: 10px; border-bottom-color: rgb(156, 191, 229); border-bottom-width: 1px; border-bottom-style: dotted;">LED电视,全高清电视</td></tr>\r\n<tr>\r\n<td style="background: rgb(242, 249, 255); border-width: medium 1px 1px medium; border-style: none dotted dotted none; border-color: currentColor rgb(156, 191, 229) rgb(156, 191, 229) currentColor; text-align: center; color: rgb(119, 119, 119); padding-top: 6px; padding-bottom: 7px; font-weight: 400; vertical-align: middle; zoom: 1.0001;" width="110">屏幕尺寸</td>\r\n<td style="padding-left: 10px; border-bottom-color: rgb(156, 191, 229); border-bottom-width: 1px; border-bottom-style: dotted;">40英寸</td></tr>\r\n<tr>\r\n<td style="background: rgb(242, 249, 255); border-width: medium 1px 1px medium; border-style: none dotted dotted none; border-color: currentColor rgb(156, 191, 229) rgb(156, 191, 229) currentColor; text-align: center; color: rgb(119, 119, 119); padding-top: 6px; padding-bottom: 7px; font-weight: 400; vertical-align: middle; zoom: 1.0001;" width="110">屏幕比例</td>\r\n<td style="padding-left: 10px; border-bottom-color: rgb(156, 191, 229); border-bottom-width: 1px; border-bottom-style: dotted;">16:9</td></tr>\r\n<tr>\r\n<td style="background: rgb(242, 249, 255); border-width: medium 1px 1px medium; border-style: none dotted dotted none; border-color: currentColor rgb(156, 191, 229) rgb(156, 191, 229) currentColor; text-align: center; color: rgb(119, 119, 119); padding-top: 6px; padding-bottom: 7px; font-weight: 400; vertical-align: middle; zoom: 1.0001;" width="110">屏幕分辨率</td>\r\n<td style="padding-left: 10px; border-bottom-color: rgb(156, 191, 229); border-bottom-width: 1px; border-bottom-style: dotted;">1920×1080</td></tr>\r\n<tr>\r\n<td style="background: rgb(242, 249, 255); border-width: medium 1px 1px medium; border-style: none dotted dotted none; border-color: currentColor rgb(156, 191, 229) rgb(156, 191, 229) currentColor; text-align: center; color: rgb(119, 119, 119); padding-top: 6px; padding-bottom: 7px; font-weight: 400; vertical-align: middle; zoom: 1.0001;" width="110">高清格式</td>\r\n<td style="padding-left: 10px; border-bottom-color: rgb(156, 191, 229); border-bottom-width: 1px; border-bottom-style: dotted;">1080p</td></tr>\r\n<tr>\r\n<td style="background: rgb(242, 249, 255); border-width: medium 1px 1px medium; border-style: none dotted dotted none; border-color: currentColor rgb(156, 191, 229) rgb(156, 191, 229) currentColor; text-align: center; color: rgb(119, 119, 119); padding-top: 6px; padding-bottom: 7px; font-weight: 400; vertical-align: middle; zoom: 1.0001;" width="110">面板类型</td>\r\n<td style="padding-left: 10px; border-bottom-color: rgb(156, 191, 229); border-bottom-width: 1px; border-bottom-style: dotted;">VA面板</td></tr>\r\n<tr>\r\n<td style="background: rgb(242, 249, 255); border-width: medium 1px medium medium; border-style: none dotted none none; border-color: currentColor rgb(156, 191, 229) currentColor currentColor; text-align: center; color: rgb(119, 119, 119); padding-top: 6px; padding-bottom: 7px; font-weight: 400; vertical-align: middle; zoom: 1.0001;" width="110">最佳观看距离</td>\r\n<td style="padding-left: 10px; border-bottom-color: currentColor; border-bottom-width: medium; border-bottom-style: none;">1.8-2.5米</td></tr></tbody></table></td></tr>\r\n<tr>\r\n<td style="background: rgb(212, 234, 255); border-width: medium 1px 1px; border-style: none solid solid; border-color: currentColor rgb(156, 191, 229) rgb(156, 191, 229); text-align: left; padding-top: 6px; padding-bottom: 7px; padding-left: 15px; vertical-align: middle;"><strong>图像参数</strong></td></tr>\r\n<tr>\r\n<td style="border-width: medium 1px 1px; border-style: none solid solid; border-color: currentColor rgb(156, 191, 229) rgb(156, 191, 229);">\r\n<table style="border-spacing: 0;" class="param" border="0" cellSpacing="0" cellPadding="0" width="100%">\r\n<tbody>\r\n<tr>\r\n<td style="background: rgb(242, 249, 255); border-width: medium 1px 1px medium; border-style: none dotted dotted none; border-color: currentColor rgb(156, 191, 229) rgb(156, 191, 229) currentColor; text-align: center; color: rgb(119, 119, 119); padding-top: 6px; padding-bottom: 7px; font-weight: 400; vertical-align: middle; zoom: 1.0001;" width="110">背光性能</td>\r\n<td style="padding-left: 10px; border-bottom-color: rgb(156, 191, 229); border-bottom-width: 1px; border-bottom-style: dotted;">LED背光源</td></tr>\r\n<tr>\r\n<td style="background: rgb(242, 249, 255); border-width: medium 1px medium medium; border-style: none dotted none none; border-color: currentColor rgb(156, 191, 229) currentColor currentColor; text-align: center; color: rgb(119, 119, 119); padding-top: 6px; padding-bottom: 7px; font-weight: 400; vertical-align: middle; zoom: 1.0001;" width="110">USB流媒体</td>\r\n<td style="padding-left: 10px; border-bottom-color: currentColor; border-bottom-width: medium; border-bottom-style: none;">支持，USB支持移动硬盘容量：可接USB支持视频格式：AVI/MPEG/MP4USB支持音频格式：MP3,USB支持图片格式：JPEG </td></tr></tbody></table></td></tr>\r\n<tr>\r\n<td style="background: rgb(212, 234, 255); border-width: medium 1px 1px; border-style: none solid solid; border-color: currentColor rgb(156, 191, 229) rgb(156, 191, 229); text-align: left; padding-top: 6px; padding-bottom: 7px; padding-left: 15px; vertical-align: middle;"><strong>音效性能</strong></td></tr>\r\n<tr>\r\n<td style="border-width: medium 1px 1px; border-style: none solid solid; border-color: currentColor rgb(156, 191, 229) rgb(156, 191, 229);">\r\n<table style="border-spacing: 0;" class="param" border="0" cellSpacing="0" cellPadding="0" width="100%">\r\n<tbody>\r\n<tr>\r\n<td style="background: rgb(242, 249, 255); border-width: medium 1px 1px medium; border-style: none dotted dotted none; border-color: currentColor rgb(156, 191, 229) rgb(156, 191, 229) currentColor; text-align: center; color: rgb(119, 119, 119); padding-top: 6px; padding-bottom: 7px; font-weight: 400; vertical-align: middle; zoom: 1.0001;" width="110">扬声器</td>\r\n<td style="padding-left: 10px; border-bottom-color: rgb(156, 191, 229); border-bottom-width: 1px; border-bottom-style: dotted;">2个</td></tr>\r\n<tr>\r\n<td style="background: rgb(242, 249, 255); border-width: medium 1px medium medium; border-style: none dotted none none; border-color: currentColor rgb(156, 191, 229) currentColor currentColor; text-align: center; color: rgb(119, 119, 119); padding-top: 6px; padding-bottom: 7px; font-weight: 400; vertical-align: middle; zoom: 1.0001;" width="110">声音输出功率</td>\r\n<td style="padding-left: 10px; border-bottom-color: currentColor; border-bottom-width: medium; border-bottom-style: none;">10W+10W</td></tr></tbody></table></td></tr>\r\n<tr>\r\n<td style="background: rgb(212, 234, 255); border-width: medium 1px 1px; border-style: none solid solid; border-color: currentColor rgb(156, 191, 229) rgb(156, 191, 229); text-align: left; padding-top: 6px; padding-bottom: 7px; padding-left: 15px; vertical-align: middle;"><strong>功能参数</strong></td></tr>\r\n<tr>\r\n<td style="border-width: medium 1px 1px; border-style: none solid solid; border-color: currentColor rgb(156, 191, 229) rgb(156, 191, 229);">\r\n<table style="border-spacing: 0;" class="param" border="0" cellSpacing="0" cellPadding="0" width="100%">\r\n<tbody></tbody></table></td></tr>\r\n<tr>\r\n<td style="background: rgb(212, 234, 255); border-width: medium 1px 1px; border-style: none solid solid; border-color: currentColor rgb(156, 191, 229) rgb(156, 191, 229); text-align: left; padding-top: 6px; padding-bottom: 7px; padding-left: 15px; vertical-align: middle;"><strong>输入输出</strong></td></tr>\r\n<tr>\r\n<td style="border-width: medium 1px 1px; border-style: none solid solid; border-color: currentColor rgb(156, 191, 229) rgb(156, 191, 229);">\r\n<table style="border-spacing: 0;" class="param" border="0" cellSpacing="0" cellPadding="0" width="100%">\r\n<tbody>\r\n<tr>\r\n<td style="background: rgb(242, 249, 255); border-width: medium 1px 1px medium; border-style: none dotted dotted none; border-color: currentColor rgb(156, 191, 229) rgb(156, 191, 229) currentColor; text-align: center; color: rgb(119, 119, 119); padding-top: 6px; padding-bottom: 7px; font-weight: 400; vertical-align: middle; zoom: 1.0001;" width="110">输入端口</td>\r\n<td style="padding-left: 10px; border-bottom-color: rgb(156, 191, 229); border-bottom-width: 1px; border-bottom-style: dotted;">HDMI接口,分量视频接口,TV输入,USB接口</td></tr>\r\n<tr>\r\n<td style="background: rgb(242, 249, 255); border-width: medium 1px 1px medium; border-style: none dotted dotted none; border-color: currentColor rgb(156, 191, 229) rgb(156, 191, 229) currentColor; text-align: center; color: rgb(119, 119, 119); padding-top: 6px; padding-bottom: 7px; font-weight: 400; vertical-align: middle; zoom: 1.0001;" width="110">HDMI接口</td>\r\n<td style="padding-left: 10px; border-bottom-color: rgb(156, 191, 229); border-bottom-width: 1px; border-bottom-style: dotted;">1组</td></tr>\r\n<tr>\r\n<td style="background: rgb(242, 249, 255); border-width: medium 1px 1px medium; border-style: none dotted dotted none; border-color: currentColor rgb(156, 191, 229) rgb(156, 191, 229) currentColor; text-align: center; color: rgb(119, 119, 119); padding-top: 6px; padding-bottom: 7px; font-weight: 400; vertical-align: middle; zoom: 1.0001;" width="110">TV端子</td>\r\n<td style="padding-left: 10px; border-bottom-color: rgb(156, 191, 229); border-bottom-width: 1px; border-bottom-style: dotted;">1组</td></tr>\r\n<tr>\r\n<td style="background: rgb(242, 249, 255); border-width: medium 1px 1px medium; border-style: none dotted dotted none; border-color: currentColor rgb(156, 191, 229) rgb(156, 191, 229) currentColor; text-align: center; color: rgb(119, 119, 119); padding-top: 6px; padding-bottom: 7px; font-weight: 400; vertical-align: middle; zoom: 1.0001;" width="110">色差分量端子</td>\r\n<td style="padding-left: 10px; border-bottom-color: rgb(156, 191, 229); border-bottom-width: 1px; border-bottom-style: dotted;">1组</td></tr>\r\n<tr>\r\n<td style="background: rgb(242, 249, 255); border-width: medium 1px 1px medium; border-style: none dotted dotted none; border-color: currentColor rgb(156, 191, 229) rgb(156, 191, 229) currentColor; text-align: center; color: rgb(119, 119, 119); padding-top: 6px; padding-bottom: 7px; font-weight: 400; vertical-align: middle; zoom: 1.0001;" width="110">USB接口</td>\r\n<td style="padding-left: 10px; border-bottom-color: rgb(156, 191, 229); border-bottom-width: 1px; border-bottom-style: dotted;">1组</td></tr>\r\n<tr>\r\n<td style="background: rgb(242, 249, 255); border-width: medium 1px medium medium; border-style: none dotted none none; border-color: currentColor rgb(156, 191, 229) currentColor currentColor; text-align: center; color: rgb(119, 119, 119); padding-top: 6px; padding-bottom: 7px; font-weight: 400; vertical-align: middle; zoom: 1.0001;" width="110">其他接口类型</td>\r\n<td style="padding-left: 10px; border-bottom-color: currentColor; border-bottom-width: medium; border-bottom-style: none;">网线接口</td></tr></tbody></table></td></tr>\r\n<tr>\r\n<td style="background: rgb(212, 234, 255); border-width: medium 1px 1px; border-style: none solid solid; border-color: currentColor rgb(156, 191, 229) rgb(156, 191, 229); text-align: left; padding-top: 6px; padding-bottom: 7px; padding-left: 15px; vertical-align: middle;"><strong>外观参数</strong></td></tr>\r\n<tr>\r\n<td style="border-width: medium 1px 1px; border-style: none solid solid; border-color: currentColor rgb(156, 191, 229) rgb(156, 191, 229);">\r\n<table style="border-spacing: 0;" class="param" border="0" cellSpacing="0" cellPadding="0" width="100%">\r\n<tbody>\r\n<tr>\r\n<td style="background: rgb(242, 249, 255); border-width: medium 1px 1px medium; border-style: none dotted dotted none; border-color: currentColor rgb(156, 191, 229) rgb(156, 191, 229) currentColor; text-align: center; color: rgb(119, 119, 119); padding-top: 6px; padding-bottom: 7px; font-weight: 400; vertical-align: middle; zoom: 1.0001;" width="110">机身尺寸</td>\r\n<td style="padding-left: 10px; border-bottom-color: rgb(156, 191, 229); border-bottom-width: 1px; border-bottom-style: dotted;">含底座:958×637×290mm,不含底座:958×595×55mm</td></tr>\r\n<tr>\r\n<td style="background: rgb(242, 249, 255); border-width: medium 1px medium medium; border-style: none dotted none none; border-color: currentColor rgb(156, 191, 229) currentColor currentColor; text-align: center; color: rgb(119, 119, 119); padding-top: 6px; padding-bottom: 7px; font-weight: 400; vertical-align: middle; zoom: 1.0001;" width="110">重量</td>\r\n<td style="padding-left: 10px; border-bottom-color: currentColor; border-bottom-width: medium; border-bottom-style: none;">含底座:13.5kg,不含底座:12.5kg</td></tr></tbody></table></td></tr>\r\n<tr>\r\n<td style="background: rgb(212, 234, 255); border-width: medium 1px 1px; border-style: none solid solid; border-color: currentColor rgb(156, 191, 229) rgb(156, 191, 229); text-align: left; padding-top: 6px; padding-bottom: 7px; padding-left: 15px; vertical-align: middle;"><strong>其他参数</strong></td></tr>\r\n<tr>\r\n<td style="border-width: medium 1px 1px; border-style: none solid solid; border-color: currentColor rgb(156, 191, 229) rgb(156, 191, 229);">\r\n<table style="border-spacing: 0;" class="param" border="0" cellSpacing="0" cellPadding="0" width="100%">\r\n<tbody>\r\n<tr>\r\n<td style="background: rgb(242, 249, 255); border-width: medium 1px 1px medium; border-style: none dotted dotted none; border-color: currentColor rgb(156, 191, 229) rgb(156, 191, 229) currentColor; text-align: center; color: rgb(119, 119, 119); padding-top: 6px; padding-bottom: 7px; font-weight: 400; vertical-align: middle; zoom: 1.0001;" width="110">电源要求</td>\r\n<td style="padding-left: 10px; border-bottom-color: rgb(156, 191, 229); border-bottom-width: 1px; border-bottom-style: dotted;">220V</td></tr>\r\n<tr>\r\n<td style="background: rgb(242, 249, 255); border-width: medium 1px 1px medium; border-style: none dotted dotted none; border-color: currentColor rgb(156, 191, 229) rgb(156, 191, 229) currentColor; text-align: center; color: rgb(119, 119, 119); padding-top: 6px; padding-bottom: 7px; font-weight: 400; vertical-align: middle; zoom: 1.0001;" width="110">功耗</td>\r\n<td style="padding-left: 10px; border-bottom-color: rgb(156, 191, 229); border-bottom-width: 1px; border-bottom-style: dotted;">95W</td></tr>\r\n<tr>\r\n<td style="background: rgb(242, 249, 255); border-width: medium 1px medium medium; border-style: none dotted none none; border-color: currentColor rgb(156, 191, 229) currentColor currentColor; text-align: center; color: rgb(119, 119, 119); padding-top: 6px; padding-bottom: 7px; font-weight: 400; vertical-align: middle; zoom: 1.0001;" width="110">休眠功耗</td>\r\n<td style="padding-left: 10px; border-bottom-color: currentColor; border-bottom-width: medium; border-bottom-style: none;">0.5W</td></tr></tbody></table></td></tr>\r\n<tr>\r\n<td style="background: rgb(242, 249, 255); border-width: medium 1px 1px; border-style: none solid solid; border-color: currentColor rgb(156, 191, 229) rgb(156, 191, 229); padding: 7px 9px; text-align: right; color: rgb(119, 119, 119);" class="btm">数据来源：<a href="http://www.pconline.com.cn/" target="_blank"><font color="#0055aa">太平洋电脑网</font></a>&nbsp;<a href="http://product.pconline.com.cn/" target="_blank"><font color="#0055aa">产品报价 (product.pconline.com.cn)</font></a></td></tr></tbody></table>', '', 0, '2015-07-05 08:53:29'),
	(58, '2011新款冬装羽绒服 男 可脱卸帽男士保暖加厚羽绒服 正品 90%绒 黑色 XXL', '服装', '羽绒服', 'images\\8fc325d1-1310-4572-b64d-0fe04a88266b.jpg', 399.00, '<FONT color=#000000><FONT style="BACKGROUND-COLOR: #ffffff">\r\n<P><FONT color=#000000><FONT style="BACKGROUND-COLOR: #ffffff">&nbsp;<SPAN style="FONT-SIZE: medium"><FONT size=3><SPAN style="COLOR: #003366">这是一款极品短款羽绒外套，是采用填充物为膨松度800的高压缩鸭绒，非常的轻盈，保暖性能极佳，且里面的鸭绒不是那种随便的普通的鸭毛。不好的羽绒服都用鸭背部的羽毛，加工较简单，而且背部的毛是有硬梗的，所以摸上去都会有硬刷刷的感觉，柔软度也不是特别好！因为此款羽绒服梗毛相对较少，羽翼相对细密，柔软舒适，羽绒服外表纯棉涂层材质，加上今年流行的亚光质感</SPAN><SPAN style="COLOR: #6600cc">（含绒量90%）。</SPAN></FONT></SPAN></FONT></FONT></P>\r\n<P></FONT></FONT>&nbsp;</P>', NULL, 1, '2011-12-25 23:45:00'),
	(59, '苹果iPhone 4（8GB）', '通信', '手机', 'images\\celN293jBrBiQ.jpg', 4300.00, '&nbsp;\r\n<DIV style="BORDER-BOTTOM: #aac4e5 1px solid; BORDER-LEFT: #aac4e5 1px solid; LINE-HEIGHT: 26px; BACKGROUND-COLOR: #aac4e5; FONT-VARIANT: normal; FONT-STYLE: normal; MARGIN: 0px auto; WIDTH: 560px; FONT-SIZE: 14px; OVERFLOW: hidden; BORDER-TOP: #aac4e5 1px solid; FONT-WEIGHT: normal; BORDER-RIGHT: #aac4e5 1px solid" id=layoutTab>\r\n<TABLE style="BORDER-BOTTOM: #aac4e5 2px solid; BORDER-LEFT: #aac4e5 2px solid; COLOR: #333; FONT-SIZE: 12px; BORDER-TOP: #aac4e5 2px solid; BORDER-RIGHT: #aac4e5 2px solid" cellSpacing=1 cellPadding=0 width="100%">\r\n<TBODY>\r\n<TR>\r\n<TD bgColor=#ffffff colSpan=2>\r\n<TABLE style="BORDER-COLLAPSE: collapse" border=0 cellSpacing=0 cellPadding=0 width="100%">\r\n<TBODY>\r\n<TR style="PADDING-BOTTOM: 14px; PADDING-LEFT: 14px; PADDING-RIGHT: 14px; PADDING-TOP: 14px">\r\n<TD>\r\n<H3 style="PADDING-BOTTOM: 0px; LINE-HEIGHT: 26px; FONT-VARIANT: normal; FONT-STYLE: normal; MARGIN: 0px; PADDING-LEFT: 0px; PADDING-RIGHT: 0px; FONT-SIZE: 14px; FONT-WEIGHT: bold; PADDING-TOP: 0px">苹果iPhone 4（8GB）</H3>\r\n<H4 style="PADDING-BOTTOM: 0px; LINE-HEIGHT: 26px; FONT-VARIANT: normal; FONT-STYLE: normal; MARGIN: 0px; PADDING-LEFT: 0px; PADDING-RIGHT: 0px; COLOR: #999; FONT-SIZE: 18px; FONT-WEIGHT: bold; PADDING-TOP: 0px">参数规格</H4></TD>\r\n<TD style="PADDING-BOTTOM: 10px; PADDING-LEFT: 10px; PADDING-RIGHT: 10px; FONT-SIZE: 12px; PADDING-TOP: 10px" vAlign=bottom align=right>查看： <A style="COLOR: #0267a7; TEXT-DECORATION: none" href="">更多信息</A> 或 <A style="COLOR: #0267a7; TEXT-DECORATION: none" href="">更多图片</A> </TD></TR></TBODY></TABLE></TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px">\r\n<TD style="BACKGROUND: #f2f7fd" colSpan=2><B>基本参数</B></TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>上市日期</SPAN></TD>\r\n<TD>2011年</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>手机类型</SPAN></TD>\r\n<TD>3G手机，智能手机，音乐手机</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>外观设计</SPAN></TD>\r\n<TD>直板</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>主屏尺寸</SPAN></TD>\r\n<TD>3.5英寸</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>触摸屏</SPAN></TD>\r\n<TD>电容屏，多点触控</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>主屏材质</SPAN></TD>\r\n<TD>IPS</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>主屏分辨率</SPAN></TD>\r\n<TD>640x960像素</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>网络模式</SPAN></TD>\r\n<TD>GSM，WCDMA</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>数据业务</SPAN></TD>\r\n<TD>GPRS，EDGE，HSPA</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>支持频段</SPAN></TD>\r\n<TD>2G：GSM 800/850/900/1800/1900<BR>3G：WCDMA 850/900/1900/2100MHz</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>操作系统</SPAN></TD>\r\n<TD>iOS 4.0</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>CPU型号</SPAN></TD>\r\n<TD>苹果 A4</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>CPU频率</SPAN></TD>\r\n<TD>1024MHz</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>GPU型号</SPAN></TD>\r\n<TD>Imagination PowerVR SGX535</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>可用空间</SPAN></TD>\r\n<TD>8GB</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>理论通话时间</SPAN></TD>\r\n<TD>840分钟（2G），420分钟（3G）</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>理论待机时间</SPAN></TD>\r\n<TD>300小时</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>其它使用时间</SPAN></TD>\r\n<TD>3G网络时间：6小时<BR>WLAN网络时间：10小时<BR>音乐播放时间：40小时<BR>视频播放时间：10小时</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>键盘类型</SPAN></TD>\r\n<TD>虚拟QWERTY键盘</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>机身颜色</SPAN></TD>\r\n<TD>黑色，白色</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>手机尺寸</SPAN></TD>\r\n<TD>115.2x58.6x9.3mm</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>手机重量</SPAN></TD>\r\n<TD>137g</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>机身特点</SPAN></TD>\r\n<TD>屏幕采用Retina显示技术；Multi-Touch 触控宽屏幕 ，正反面采用防油渍防指纹外膜，支持多种语言文字同时显示<BR>双麦克风设计，有助于降噪；<BR>机身周边的固定框被设计为了iPhone4的天线</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px">\r\n<TD style="BACKGROUND: #f2f7fd" colSpan=2><B>基本功能</B></TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>输入法</SPAN></TD>\r\n<TD>中文输入法，英文输入法，第三方输入法</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>输入方式</SPAN></TD>\r\n<TD>手写</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>通话记录</SPAN></TD>\r\n<TD>已接+已拨+未接电话</TD></TR>\r\n<TR style="PADDING-BOTTOM: 8px; PADDING-LEFT: 5px; PADDING-RIGHT: 0px; PADDING-TOP: 8px">\r\n<TD bgColor=#ffffff vAlign=center colSpan=2>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0>\r\n<TBODY>\r\n<TR>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width="100%" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style="COLOR: #333; FONT-SIZE: 12px" bgColor=#f1f7fc height=18 align=middle>短信(SMS)</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width="100%" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style="COLOR: #333; FONT-SIZE: 12px" bgColor=#f1f7fc height=18 align=middle>彩信(MMS)</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width="100%" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style="COLOR: #333; FONT-SIZE: 12px" bgColor=#f1f7fc height=18 align=middle>免提通话</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width="100%" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style="COLOR: #333; FONT-SIZE: 12px" bgColor=#f1f7fc height=18 align=middle>录音功能</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width="100%" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style="COLOR: #333; FONT-SIZE: 12px" bgColor=#f1f7fc height=18 align=middle>情景模式</TD></TR></TBODY></TABLE></TD></TR>\r\n<TR>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width="100%" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style="COLOR: #333; FONT-SIZE: 12px" bgColor=#f1f7fc height=18 align=middle>动画屏保</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width="100%" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style="COLOR: #333; FONT-SIZE: 12px" bgColor=#f1f7fc height=18 align=middle>待机图片</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width="100%" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style="COLOR: #333; FONT-SIZE: 12px" bgColor=#f1f7fc height=18 align=middle>主题菜单</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width="100%" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style="COLOR: #333; FONT-SIZE: 12px" bgColor=#f1f7fc height=18 align=middle>来电铃声识别</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width="100%" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style="COLOR: #333; FONT-SIZE: 12px" bgColor=#f1f7fc height=18 align=middle>来电图片识别</TD></TR></TBODY></TABLE></TD></TR>\r\n<TR>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width="100%" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style="COLOR: #333; FONT-SIZE: 12px" bgColor=#f1f7fc height=18 align=middle>自动键盘锁</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width="100%" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style="COLOR: #333; FONT-SIZE: 12px" bgColor=#f1f7fc height=18 align=middle>日历功能</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width="100%" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style="COLOR: #333; FONT-SIZE: 12px" bgColor=#f1f7fc height=18 align=middle>闹钟功能</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width="100%" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style="COLOR: #333; FONT-SIZE: 12px" bgColor=#f1f7fc height=18 align=middle>秒表</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width="100%" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style="COLOR: #333; FONT-SIZE: 12px" bgColor=#f1f7fc height=18 align=middle>计算器</TD></TR></TBODY></TABLE></TD></TR>\r\n<TR>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width="100%" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style="COLOR: #333; FONT-SIZE: 12px" bgColor=#f1f7fc height=18 align=middle>单位换算</TD></TR></TBODY></TABLE></TD></TR></TBODY></TABLE></TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px">\r\n<TD style="BACKGROUND: #f2f7fd" colSpan=2><B>产品特性</B></TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>GPS导航</SPAN></TD>\r\n<TD>内置GPS</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>电子罗盘</SPAN></TD>\r\n<TD>数字指南针</TD></TR>\r\n<TR style="PADDING-BOTTOM: 8px; PADDING-LEFT: 5px; PADDING-RIGHT: 0px; PADDING-TOP: 8px">\r\n<TD bgColor=#ffffff vAlign=center colSpan=2>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0>\r\n<TBODY>\r\n<TR>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width="100%" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style="COLOR: #333; FONT-SIZE: 12px" bgColor=#f1f7fc height=18 align=middle>地图软件</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width="100%" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style="COLOR: #333; FONT-SIZE: 12px" bgColor=#f1f7fc height=18 align=middle>重力感应器</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width="100%" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style="COLOR: #333; FONT-SIZE: 12px" bgColor=#f1f7fc height=18 align=middle>加速传感器</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width="100%" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style="COLOR: #333; FONT-SIZE: 12px" bgColor=#f1f7fc height=18 align=middle>光线传感器</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width="100%" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style="COLOR: #333; FONT-SIZE: 12px" bgColor=#f1f7fc height=18 align=middle>距离传感器</TD></TR></TBODY></TABLE></TD></TR>\r\n<TR>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width="100%" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style="COLOR: #333; FONT-SIZE: 12px" bgColor=#f1f7fc height=18 align=middle>3D加速</TD></TR></TBODY></TABLE></TD></TR></TBODY></TABLE></TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px">\r\n<TD style="BACKGROUND: #f2f7fd" colSpan=2><B>拍照功能</B></TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>摄像头</SPAN></TD>\r\n<TD>内置</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>摄像头类型</SPAN></TD>\r\n<TD>双摄像头（前后）</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>摄像头像素</SPAN></TD>\r\n<TD>前：30万像素，后：500万像素</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>闪光灯</SPAN></TD>\r\n<TD>LED补光灯</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>数码变焦</SPAN></TD>\r\n<TD>5倍数码变焦</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>自动对焦</SPAN></TD>\r\n<TD>支持</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>拍摄场景</SPAN></TD>\r\n<TD>支持</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>照片特效</SPAN></TD>\r\n<TD>支持</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>图像尺寸</SPAN></TD>\r\n<TD>最大支持2592×1944像素照片拍摄</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>连拍功能</SPAN></TD>\r\n<TD>支持</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>定时器</SPAN></TD>\r\n<TD>支持</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>视频拍摄</SPAN></TD>\r\n<TD>720p（1280×720，30帧/秒）视频录制</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>其它功能</SPAN></TD>\r\n<TD>照片和视频地理标记功能</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px">\r\n<TD style="BACKGROUND: #f2f7fd" colSpan=2><B>娱乐功能</B></TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>视频播放</SPAN></TD>\r\n<TD>支持MP4/3GP/AVC/AVI/MPEG-4等格式</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>音频播放</SPAN></TD>\r\n<TD>支持MP3/AAC/AAC+/AMR/WMA/WAV等格式</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>铃音描述</SPAN></TD>\r\n<TD>支持MP3/MIDI/WMA/AMR/AAC等格式</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>图形格式</SPAN></TD>\r\n<TD>支持JPEG/EXIF等格式</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>游戏</SPAN></TD>\r\n<TD>内置PZS，Real Tennis，极品飞车变速，RF10，Doodle Find，EndlessRace，Rugby，PooINinja，CC Tennis</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>SNS支持</SPAN></TD>\r\n<TD>支持Twitter，MySpace，Facebook，YouTube，Flickr，Picasa等</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>即时通讯</SPAN></TD>\r\n<TD>支持QQ，MSN，飞信等</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>服务特色</SPAN></TD>\r\n<TD>App store</TD></TR>\r\n<TR style="PADDING-BOTTOM: 8px; PADDING-LEFT: 5px; PADDING-RIGHT: 0px; PADDING-TOP: 8px">\r\n<TD bgColor=#ffffff vAlign=center colSpan=2>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0>\r\n<TBODY>\r\n<TR>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width="100%" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style="COLOR: #333; FONT-SIZE: 12px" bgColor=#f1f7fc height=18 align=middle>电子书</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width="100%" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style="COLOR: #333; FONT-SIZE: 12px" bgColor=#f1f7fc height=18 align=middle>Java扩展</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width="100%" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style="COLOR: #333; FONT-SIZE: 12px" bgColor=#f1f7fc height=18 align=middle>应用程序</TD></TR></TBODY></TABLE></TD></TR></TBODY></TABLE></TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px">\r\n<TD style="BACKGROUND: #f2f7fd" colSpan=2><B>数据功能</B></TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>蓝牙传输</SPAN></TD>\r\n<TD>支持蓝牙2.1+EDR</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>WLAN功能</SPAN></TD>\r\n<TD>WIFI</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>数据接口</SPAN></TD>\r\n<TD>30-pin dock</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>耳机插孔</SPAN></TD>\r\n<TD>3.5mm</TD></TR>\r\n<TR style="PADDING-BOTTOM: 8px; PADDING-LEFT: 5px; PADDING-RIGHT: 0px; PADDING-TOP: 8px">\r\n<TD bgColor=#ffffff vAlign=center colSpan=2>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0>\r\n<TBODY>\r\n<TR>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width="100%" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style="COLOR: #333; FONT-SIZE: 12px" bgColor=#f1f7fc height=18 align=middle>WAP浏览器</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width="100%" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style="COLOR: #333; FONT-SIZE: 12px" bgColor=#f1f7fc height=18 align=middle>WWW浏览器</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width="100%" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style="COLOR: #333; FONT-SIZE: 12px" bgColor=#f1f7fc height=18 align=middle>PC数据同步</TD></TR></TBODY></TABLE></TD></TR></TBODY></TABLE></TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px">\r\n<TD style="BACKGROUND: #f2f7fd" colSpan=2><B>商务功能</B></TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>办公工具</SPAN></TD>\r\n<TD>TXT，Quick Office，Adobe PDF，zip管理</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>SyncML功能</SPAN></TD>\r\n<TD>支持</TD></TR>\r\n<TR style="PADDING-BOTTOM: 8px; PADDING-LEFT: 5px; PADDING-RIGHT: 0px; PADDING-TOP: 8px">\r\n<TD bgColor=#ffffff vAlign=center colSpan=2>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0>\r\n<TBODY>\r\n<TR>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width="100%" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style="COLOR: #333; FONT-SIZE: 12px" bgColor=#f1f7fc height=18 align=middle>电子邮件</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width="100%" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style="COLOR: #333; FONT-SIZE: 12px" bgColor=#f1f7fc height=18 align=middle>飞行模式</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width="100%" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style="COLOR: #333; FONT-SIZE: 12px" bgColor=#f1f7fc height=18 align=middle>世界时间</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width="100%" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style="COLOR: #333; FONT-SIZE: 12px" bgColor=#f1f7fc height=18 align=middle>备忘录</TD></TR></TBODY></TABLE></TD>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width="100%" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style="COLOR: #333; FONT-SIZE: 12px" bgColor=#f1f7fc height=18 align=middle>日程表</TD></TR></TBODY></TABLE></TD></TR>\r\n<TR>\r\n<TD width=98>\r\n<TABLE border=0 cellSpacing=1 cellPadding=0 width="100%" bgColor=#aac4e5>\r\n<TBODY>\r\n<TR>\r\n<TD style="COLOR: #333; FONT-SIZE: 12px" bgColor=#f1f7fc height=18 align=middle>记事本</TD></TR></TBODY></TABLE></TD></TR></TBODY></TABLE></TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px">\r\n<TD style="BACKGROUND: #f2f7fd" colSpan=2><B>手机附件</B></TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>包装清单</SPAN></TD>\r\n<TD>主机&nbsp;x1<BR>数据线&nbsp;x1<BR>耳机&nbsp;x1<BR>充电器&nbsp;x1&nbsp; <BR>说明书&nbsp;x1</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px">\r\n<TD style="BACKGROUND: #f2f7fd" colSpan=2><B>保修信息</B></TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>保修政策</SPAN></TD>\r\n<TD>全国联保，享受三包服务</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>质保时间</SPAN></TD>\r\n<TD>1年</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>质保备注</SPAN></TD>\r\n<TD>主机1年，电池6个月，充电器1年，有线耳机3个月</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>客服电话</SPAN></TD>\r\n<TD>400-627-2273</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>电话备注</SPAN></TD>\r\n<TD>周一至周五：9:00-21:00；周六至周日：9:00-18:00</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>详细内容</SPAN></TD>\r\n<TD>自购机日起（以购机发票为准），如因质量问题或故障，凭厂商维修中心或特约维修点的质量检测证明，享受7日内退货，15日内换货，15日以上在质保期内享受免费保修等三包服务！<BR>注：单独购买手机配件产品的用户，请完好保存配件外包装以及发票原件，如无法提供上述凭证的，将无法进行正常的配件保修或更换。<A href="http://www.apple.com.cn/support/applecare/aasp/" target=_blank>进入官网&gt;&gt;</A></TD></TR>\r\n<TR>\r\n<TD bgColor=#ffffff height=25 colSpan=2 align=right>数据来源： <A style="COLOR: #0267a7; TEXT-DECORATION: none" href="http://detail.zol.com.cn/">中关村在线 报价中心</A> (detail.zol.com.cn) </TD></TR></TBODY></TABLE></DIV>', NULL, 1, '2012-01-25 12:25:50'),
	(61, '纽曼A80HD（8GB）', '数码', 'mp3/mp4', 'images\\ceUmw3svJkBL.jpg', 699.00, '&nbsp; \r\n<DIV style="BORDER-BOTTOM: #aac4e5 1px solid; BORDER-LEFT: #aac4e5 1px solid; LINE-HEIGHT: 26px; BACKGROUND-COLOR: #aac4e5; FONT-VARIANT: normal; FONT-STYLE: normal; MARGIN: 0px auto; WIDTH: 560px; FONT-SIZE: 14px; OVERFLOW: hidden; BORDER-TOP: #aac4e5 1px solid; FONT-WEIGHT: normal; BORDER-RIGHT: #aac4e5 1px solid" id=layoutTab>\r\n<TABLE style="BORDER-BOTTOM: #aac4e5 2px solid; BORDER-LEFT: #aac4e5 2px solid; COLOR: #333; FONT-SIZE: 12px; BORDER-TOP: #aac4e5 2px solid; BORDER-RIGHT: #aac4e5 2px solid" cellSpacing=1 cellPadding=0 width="100%">\r\n<TBODY>\r\n<TR>\r\n<TD bgColor=#ffffff colSpan=2>\r\n<TABLE style="BORDER-COLLAPSE: collapse" border=0 cellSpacing=0 cellPadding=0 width="100%">\r\n<TBODY>\r\n<TR style="PADDING-BOTTOM: 14px; PADDING-LEFT: 14px; PADDING-RIGHT: 14px; PADDING-TOP: 14px">\r\n<TD>\r\n<H3 style="PADDING-BOTTOM: 0px; LINE-HEIGHT: 26px; FONT-VARIANT: normal; FONT-STYLE: normal; MARGIN: 0px; PADDING-LEFT: 0px; PADDING-RIGHT: 0px; FONT-SIZE: 14px; FONT-WEIGHT: bold; PADDING-TOP: 0px">纽曼A80HD（8GB）</H3>\r\n<H4 style="PADDING-BOTTOM: 0px; LINE-HEIGHT: 26px; FONT-VARIANT: normal; FONT-STYLE: normal; MARGIN: 0px; PADDING-LEFT: 0px; PADDING-RIGHT: 0px; COLOR: #999; FONT-SIZE: 18px; FONT-WEIGHT: bold; PADDING-TOP: 0px">参数规格</H4></TD>\r\n<TD style="PADDING-BOTTOM: 10px; PADDING-LEFT: 10px; PADDING-RIGHT: 10px; FONT-SIZE: 12px; PADDING-TOP: 10px" vAlign=bottom align=right>查看： <A style="COLOR: #0267a7; TEXT-DECORATION: none" href="">更多信息</A> 或 <A style="COLOR: #0267a7; TEXT-DECORATION: none" href="">更多图片</A> </TD></TR></TBODY></TABLE></TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px">\r\n<TD style="BACKGROUND: #f2f7fd" colSpan=2><B>基本性能</B></TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>产品类型</SPAN></TD>\r\n<TD>高清视频MP4</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>存储介质</SPAN></TD>\r\n<TD>闪存</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>存储容量</SPAN></TD>\r\n<TD>8GB</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>扩展卡</SPAN></TD>\r\n<TD>支持MicroSD（TF）卡，最大32GB</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>操作方式</SPAN></TD>\r\n<TD>按键式</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>电池容量</SPAN></TD>\r\n<TD>3300mAh</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px">\r\n<TD style="BACKGROUND: #f2f7fd" colSpan=2><B>机身特点</B></TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>屏幕尺寸</SPAN></TD>\r\n<TD>8英寸</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>屏幕类型</SPAN></TD>\r\n<TD>宽屏（16:9）</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>屏幕分辨率</SPAN></TD>\r\n<TD>1280×800像素</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px">\r\n<TD style="BACKGROUND: #f2f7fd" colSpan=2><B>视频性能</B></TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>视频格式</SPAN></TD>\r\n<TD>支持RM，RMVB，AVI，MOV，TP，M2TS，TS，MKV，MPG，MP4等格式</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>视频分辨率</SPAN></TD>\r\n<TD>1080P</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>视频输出</SPAN></TD>\r\n<TD>支持（TV-OUT）</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>其他视频特点</SPAN></TD>\r\n<TD>支持多格式的字幕显示</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px">\r\n<TD style="BACKGROUND: #f2f7fd" colSpan=2><B>音频性能</B></TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>音乐格式</SPAN></TD>\r\n<TD>支持支持MP3，WMA，WAV，APE，FLAC等格式</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>歌词同步</SPAN></TD>\r\n<TD>支持歌词同步显示</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px">\r\n<TD style="BACKGROUND: #f2f7fd" colSpan=2><B>图像文本</B></TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>图片浏览格式</SPAN></TD>\r\n<TD>支持JPG，BMP，PNG格式</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px">\r\n<TD style="BACKGROUND: #f2f7fd" colSpan=2><B>主要功能</B></TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>遥控功能</SPAN></TD>\r\n<TD>支持</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>其他描述</SPAN></TD>\r\n<TD>支持多任务操作</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px">\r\n<TD style="BACKGROUND: #f2f7fd" colSpan=2><B>其他说明</B></TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>机形特点</SPAN></TD>\r\n<TD>精致纤薄，容易摆放，携带方便，IML外壳工艺</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px">\r\n<TD style="BACKGROUND: #f2f7fd" colSpan=2><B>保修信息</B></TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>保修政策</SPAN></TD>\r\n<TD>全国联保，享受三包服务</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>质保时间</SPAN></TD>\r\n<TD>1年</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>客服电话</SPAN></TD>\r\n<TD>400-890-9890，400-810-1989，010-8268-9216</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>电话备注</SPAN></TD>\r\n<TD>周一至周日：9:00-18:00</TD></TR>\r\n<TR style="PADDING-BOTTOM: 5px; PADDING-LEFT: 5px; PADDING-RIGHT: 5px; PADDING-TOP: 5px" bgColor=#ffffff>\r\n<TD style="WIDTH: 80px"><SPAN>详细内容</SPAN></TD>\r\n<TD>您在购买本产品之日起7日内（含），若产品主机经纽曼红色服务快车中心检测出由于本机元器件所引发之故障，您可以选择退货，更换或维修。如您选择退货，请您携带有效购机凭证和有效三包凭证与故障设备及其全部物件到销售商处，销售商将免费为您退货，并按照购买价格（以有效购机凭证价格为准）一次性退清货款。<A href="http://www.newsmy.com/Page/shfwcn_1.html" target=_blank>进入官网&gt;&gt;</A></TD></TR>\r\n<TR>\r\n<TD bgColor=#ffffff height=25 colSpan=2 align=right>数据来源： <A style="COLOR: #0267a7; TEXT-DECORATION: none" href="http://detail.zol.com.cn/">中关村在线 报价中心</A> (detail.zol.com.cn) </TD></TR></TBODY></TABLE></DIV>', NULL, 1, '2015-06-12 20:41:51'),
	(63, '韩式田园 韩式田园家具-白色1.5米排骨架床 韩菲', '家具', '家用家具', 'images\\1338853863194324533.jpg', 999.00, '&nbsp; \r\n<DT><SPAN class="gray goods_sn nright">( 编号：<SPAN id=JS_attr_title_sn>HFE-A3</SPAN><SPAN id=JS_attr_title_born>| 产地：广东惠州</SPAN> )</SPAN> </DT>\r\n<DT>配&#8194;置： </DT>\r\n<DD><A id=JS_join_goods_nav_16311_16311 class=current onclick="GF.setCurrentById(\'16311\');" href="javascript:;">1.5*2.0米排骨架床</A><A id=JS_join_goods_nav_16311_16312 onclick="GF.setCurrentById(\'16312\');" href="javascript:;">1.8*2.0米排骨架床</A> </DD>\r\n<DL id=JS_panel_trans_type_16311 class="clearfix none">\r\n<DT>配&#8194;送： </DT>\r\n<DD><A id=JS_panel_trans_type_16311_0 class=current onclick="GL[\'16311\'].setTransType(0);return false;" href="javascript:;">包物流</A><A id=JS_panel_trans_type_16311_1 onclick="GL[\'16311\'].setTransType(1);return false;" href="javascript:;">包快递</A> </DD></DL>\r\n<DL class=clearfix>\r\n<DT>颜&#8194;色： </DT>\r\n<DD><SPAN class=current>象牙白</SPAN> </DD></DL>\r\n<DL class=clearfix>\r\n<DT>内&#8194;径： </DT>\r\n<DD><SPAN class=current>1.5*2.0米</SPAN> </DD></DL>\r\n<DL class=clearfix>\r\n<DT>外&#8194;径： </DT>\r\n<DD><SPAN class=current>长2095*宽1650*高1160mm；125mm（床沿深）</SPAN> </DD>\r\n<DD>fsfsd</DD></DL>', NULL, 1, '2015-06-12 20:41:28'),
	(70, '明国大厦', '房地产', '写字楼', 'images\\01.jpeg', 6000.00, '&nbsp;sdfdsfsdfsdfsdfsdfsdfdsfdsf', NULL, 1, '2015-06-13 10:16:06'),
	(72, '力帆汽车620', '汽车', '轿车', 'images\\1221788701_48d3041d059c0.jpg', 60000.00, '&nbsp;dvdgdfd', '&nbsp;gfdgdfgdfg', 1, '2015-07-05 20:43:48'),
	(73, '抚州房地产', '房地产', '商品房', 'images\\10001020.gif', 4000.00, '&nbsp;sfdsfdsf', '&nbsp;dfdsfdsfsf', 1, '2015-08-04 10:38:52'),
	(74, 'gdfgdfgfdg', '通信', '手机', '', 100.00, '&nbsp;rtdgdrgregdfgdg', '&nbsp;fdgfdgdgfdg', 1, '2015-08-08 19:43:24');
/*!40000 ALTER TABLE `products` ENABLE KEYS */;


-- 导出  表 infocomshop.smalltype 结构
DROP TABLE IF EXISTS `smalltype`;
CREATE TABLE IF NOT EXISTS `smalltype` (
  `smalltypeid` int(11) NOT NULL AUTO_INCREMENT,
  `bigtypeid` int(11) DEFAULT NULL,
  `smalltypename` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`smalltypeid`)
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=gb2312;

-- 正在导出表  infocomshop.smalltype 的数据：~44 rows (大约)
DELETE FROM `smalltype`;
/*!40000 ALTER TABLE `smalltype` DISABLE KEYS */;
INSERT INTO `smalltype` (`smalltypeid`, `bigtypeid`, `smalltypename`) VALUES
	(2, 2, '液晶电视'),
	(3, 3, '家庭音箱'),
	(4, 8, '皮包'),
	(5, 8, '钱包'),
	(6, 8, '男士皮包'),
	(7, 8, '女士皮包'),
	(8, 5, '上衣'),
	(9, 5, '长裤'),
	(10, 5, '西服'),
	(11, 5, '休闲服'),
	(12, 6, '长袜'),
	(13, 6, '短袜'),
	(14, 7, '皮鞋'),
	(15, 7, '波鞋'),
	(16, 7, '凉鞋'),
	(17, 1, '手机'),
	(18, 1, '电话'),
	(19, 4, '大米'),
	(20, 4, '蔬菜'),
	(21, 4, '肉类'),
	(22, 4, '副食品'),
	(23, 4, '酒'),
	(26, 4, '海鲜'),
	(27, 4, '早点'),
	(28, 5, '羽绒服'),
	(30, 5, '皮衣'),
	(31, 9, '笔记本'),
	(32, 10, '数码相机'),
	(33, 10, 'mp3/mp4'),
	(34, 12, '商品房'),
	(35, 12, '别墅'),
	(36, 11, '轿车'),
	(37, 11, '商务车'),
	(38, 13, '酒店家具'),
	(39, 13, '家用家具'),
	(40, 14, '小学'),
	(41, 14, '初中'),
	(42, 14, '高中'),
	(43, 14, '大学'),
	(44, 14, '成人'),
	(45, 14, '自考'),
	(46, 14, '考研'),
	(47, 14, '英语'),
	(48, 14, '技术'),
	(49, 15, 'ddddd'),
	(50, 12, '写字楼'),
	(51, 5, '运动服');
/*!40000 ALTER TABLE `smalltype` ENABLE KEYS */;


-- 导出  表 infocomshop.user 结构
DROP TABLE IF EXISTS `user`;
CREATE TABLE IF NOT EXISTS `user` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(20) DEFAULT NULL,
  `password` varchar(20) DEFAULT NULL,
  `sex` int(11) DEFAULT NULL,
  `education` varchar(50) DEFAULT NULL,
  `job` varchar(50) DEFAULT NULL,
  `friends` varchar(50) DEFAULT NULL,
  `pic` varchar(200) DEFAULT NULL,
  `message` text,
  `hobby` varchar(255) DEFAULT NULL,
  `province` varchar(50) DEFAULT NULL,
  `city` varchar(50) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `post` int(6) DEFAULT NULL,
  `telphone` varchar(255) DEFAULT NULL,
  `mobilephone` char(50) DEFAULT NULL,
  `regdatetime` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=157 DEFAULT CHARSET=gb2312;

-- 正在导出表  infocomshop.user 的数据：~4 rows (大约)
DELETE FROM `user`;
/*!40000 ALTER TABLE `user` DISABLE KEYS */;
INSERT INTO `user` (`Id`, `username`, `password`, `sex`, `education`, `job`, `friends`, `pic`, `message`, `hobby`, `province`, `city`, `address`, `post`, `telphone`, `mobilephone`, `regdatetime`) VALUES
	(153, 'sglg', '123456789', 1, '大专', '自由职业', '小明', 'images\\1_sglg1983.gif', 'czczxcz', '请选择', '江西', '抚州', '江西省抚州市金溪县左坊镇官桥村', 344814, '0794-5311812', '18679476435', '2015-07-04 20:42:57'),
	(154, '', '', 1, '请选择', '请选择', '', '', '', '请选择', NULL, NULL, '', NULL, '', '', '2015-07-08 17:16:08'),
	(155, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2015-08-08 17:40:37'),
	(156, 'sglg1983', '123456789', 1, '大专', 'web程序员', '', 'C:\\Program Files\\Apache Software Foundation\\Tomcat 7.0\\webapps\\infocomshop\\images\\1_sglg1983.gif', 'fsdfsf', '读书', '江西', '抚州', '江西省抚州市金溪县左坊镇官桥村', 344814, '0794-5311812', '18679476435', '2015-08-08 17:42:05');
/*!40000 ALTER TABLE `user` ENABLE KEYS */;
/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IF(@OLD_FOREIGN_KEY_CHECKS IS NULL, 1, @OLD_FOREIGN_KEY_CHECKS) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
