﻿<%@ Page Language="C#" %>

<%@ Import Namespace="System.Data" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<script type="text/C#" runat="server">
    
    void CreateMenuHtml()
    {
        DataTable menuTable = CreateMenuTable();
        StringBuilder sbHtml = new StringBuilder();
        CreateMenuItemHtml(sbHtml, 0, menuTable, 0);
        divMenu.InnerHtml = sbHtml.ToString();
    }

    void CreateMenuItemHtml(StringBuilder sbHtml, int parentId, DataTable menuTable, int depth)
    {
        DataRow[] menuItemRows = menuTable.Select("ParentID=" + parentId);
        if (menuItemRows.Length > 0)
        {
            string ulClass = String.Empty;
            if (depth == 0) { ulClass = "topmenu"; }
            else if (depth == 1) { ulClass = "submenu1"; }
            else { ulClass = "submenu11"; }
            sbHtml.AppendFormat("<ul class='{0}'>", ulClass);
            foreach (DataRow dr in menuItemRows)
            {
                int id = (int)dr["ID"];
                sbHtml.AppendFormat("<li><a href='#{0}'>{1}</a>", id, dr["DisplayName"]);
                CreateMenuItemHtml(sbHtml, id, menuTable, depth + 1);
                sbHtml.AppendFormat("</li>");
            }
            sbHtml.Append("</ul>");
        }
    }

    DataTable CreateMenuTable()
    {
        DataTable menu = new DataTable();
        menu.Columns.Add("ID", typeof(int));
        menu.Columns.Add("DisplayName", typeof(string));
        menu.Columns.Add("ParentID", typeof(int));

        menu.Rows.Add(1, "Home", 0);
        menu.Rows.Add(2, "Tutorials", 0);
        menu.Rows.Add(3, "Resources", 0);
        menu.Rows.Add(4, "About Us", 0);
        menu.Rows.Add(5, "Advertise", 0);
        menu.Rows.Add(6, "Submit", 0);
        menu.Rows.Add(7, "Contact Us", 0);

        CreateChildRows(menu, 2, 3, "Ch");
        CreateChildRows(menu, 3, 3, "Resx");

        return menu;
    }

    void CreateChildRows(DataTable tbl, int parentId, int count, string prefix)
    {
        if (parentId > 10000) return;

        for (int i = 0; i < count; i++)
        {
            int id = parentId * 10 + i;
            tbl.Rows.Add(id, prefix + id.ToString(), parentId);
            if (i % 2 == 0) continue;
            CreateChildRows(tbl, id, count + 1, prefix);
        }
    }

    void Page_Load(object sender, EventArgs e)
    {
        CreateMenuHtml();
    }
</script>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>SexyDropDownMenu2010 | Xiaofeng Wang</title>
    <link href="styles/sexydropdownmenu21.css" type="text/css" rel="stylesheet" />

    <script type="text/javascript" src="js/jquery-latest.js"></script>

    <script type="text/javascript" src="js/sexydropdownmenu21.js"></script>

</head>
<body>
    <div class="container">
        <div id="header">
            <div class="version">
                2010</div>
            <div class="disclaimer">
                Sexy Drop Down Menu Tutorial by <a href="http://www.sohtanaka.com/">Soh Tanaka</a>
                Adapted by <a href="http://www.leoworks.net">Xiaofeng Wang</a>.</div>
        </div>
        <div id="divMenu" runat="server">
        </div>
    </div>
</body>
</html>
