/*
 *Author:karry
 *Version:1.0
 *Time:2009-02-09
 *jquery1.3.0
 *图片翻转滚动
 */
(function($) {
    var time=1;
    var opts=null;
    var intervalId = null;
    $.fn.pictureRoll = function(options) {
        opts = $.extend({},  $.fn.pictureRoll.defaults, options);
        //初始化
        //将除第一个外的图片隐藏
        $(opts.imgContainer+":not(:first)").hide();
        $(opts.container).height($(opts.titleContainer).outerHeight(true)*$(opts.titleContainer).size()+$(opts.imgContainer).outerHeight());
        //给第一个加样式
        $(opts.titleContainer+":first").addClass(opts.activeClass);
        intervalId = window.setInterval(autoRoll,opts.timeInterval);
        //鼠标移上去之后停止滚动，移开后继续滚动
        $(opts.imgContainer).hover(function(){
            clearInterval(intervalId);
        },function(){
             intervalId = window.setInterval(autoRoll,opts.timeInterval);
        });
        //点击文字后，跳转到对应的图片重新开始循环滚动
        $(opts.titleContainer).each(function(index) {
            $(this).click(function() {
                if (time != index+1)
                {
                    clearInterval(intervalId);
                    $(opts.imgContainer+":visible").slideUp("slow").parent().children(opts.titleContainer).removeClass(opts.activeClass);
			        $(this).addClass("active").parent().children(opts.imgContainer).slideDown("slow");
                    time = index+1;
                    intervalId = window.setInterval(autoRoll, opts.timeInterval);
                }
            });
        });
    }
    function autoRoll(){
           if(time == $(opts.imgContainer).size()){
				time = 0;
			}
			$(opts.imgContainer+":visible").slideUp("slow").parent().children(opts.titleContainer).removeClass(opts.activeClass);
			$(opts.imgContainer+":eq("+time+")").slideDown("slow").parent().children(opts.titleContainer).addClass(opts.activeClass);
			time++;
    }
     $.fn.pictureRoll.defaults = {
        container:"#pictureRoll",
        titleContainer:"#pictureRoll span",
        imgContainer:"#pictureRoll img",
        activeClass:"active",
        timeInterval:4000
    }
})(jQuery);
