Ext.data.JsonP.Ext_EventObject({
  "allMixins": [

  ],
  "deprecated": null,
  "docauthor": null,
  "members": {
    "cfg": [

    ],
    "method": [
      {
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "method",
        "href": "Base3.html#Ext-Base-method-addStatics",
        "shortDoc": "Add / override static properties of this class. ...",
        "static": true,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/class/Base.js",
        "private": false,
        "params": [
          {
            "type": "Object",
            "optional": false,
            "doc": "\n",
            "name": "members"
          }
        ],
        "name": "addStatics",
        "owner": "Ext.Base",
        "doc": "<p>Add / override static properties of this class.</p>\n\n<pre><code>Ext.define('My.cool.Class', {\n    ...\n});\n\nMy.cool.Class.addStatics({\n    someProperty: 'someValue',      // My.cool.Class.someProperty = 'someValue'\n    method1: function() { ... },    // My.cool.Class.method1 = function() { ... };\n    method2: function() { ... }     // My.cool.Class.method2 = function() { ... };\n});\n</code></pre>\n",
        "linenr": 388,
        "return": {
          "type": "Ext.Base",
          "doc": "<p>this</p>\n"
        },
        "html_filename": "Base3.html"
      },
      {
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "method",
        "href": "Base3.html#Ext-Base-method-callOverridden",
        "shortDoc": "Call the original method that was previously overridden with Ext.Base.override\n\nExt.define('My.Cat', {\n    constructo...",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/class/Base.js",
        "private": false,
        "params": [
          {
            "type": "Array/Arguments",
            "optional": false,
            "doc": "<p>The arguments, either an array or the <code>arguments</code> object</p>\n",
            "name": "args"
          }
        ],
        "name": "callOverridden",
        "owner": "Ext.Base",
        "doc": "<p>Call the original method that was previously overridden with <a href=\"#/api/Ext.Base-method-override\" rel=\"Ext.Base-method-override\" class=\"docClass\">Ext.Base.override</a></p>\n\n<pre><code>Ext.define('My.Cat', {\n    constructor: function() {\n        alert(\"I'm a cat!\");\n\n        return this;\n    }\n});\n\nMy.Cat.override({\n    constructor: function() {\n        alert(\"I'm going to be a cat!\");\n\n        var instance = this.callOverridden();\n\n        alert(\"Meeeeoooowwww\");\n\n        return instance;\n    }\n});\n\nvar kitty = new My.Cat(); // alerts \"I'm going to be a cat!\"\n                          // alerts \"I'm a cat!\"\n                          // alerts \"Meeeeoooowwww\"\n</code></pre>\n",
        "linenr": 269,
        "return": {
          "type": "Mixed",
          "doc": "<p>Returns the result after calling the overridden method</p>\n"
        },
        "html_filename": "Base3.html"
      },
      {
        "deprecated": null,
        "alias": null,
        "protected": true,
        "tagname": "method",
        "href": "Base3.html#Ext-Base-method-callParent",
        "shortDoc": "Call the parent's overridden method. ...",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/class/Base.js",
        "private": false,
        "params": [
          {
            "type": "Array/Arguments",
            "optional": false,
            "doc": "<p>The arguments, either an array or the <code>arguments</code> object\nfrom the current method, for example: <code>this.callParent(arguments)</code></p>\n",
            "name": "args"
          }
        ],
        "name": "callParent",
        "owner": "Ext.Base",
        "doc": "<p>Call the parent's overridden method. For example:</p>\n\n<pre><code>Ext.define('My.own.A', {\n    constructor: function(test) {\n        alert(test);\n    }\n});\n\nExt.define('My.own.B', {\n    extend: 'My.own.A',\n\n    constructor: function(test) {\n        alert(test);\n\n        this.callParent([test + 1]);\n    }\n});\n\nExt.define('My.own.C', {\n    extend: 'My.own.B',\n\n    constructor: function() {\n        alert(\"Going to call parent's overriden constructor...\");\n\n        this.callParent(arguments);\n    }\n});\n\nvar a = new My.own.A(1); // alerts '1'\nvar b = new My.own.B(1); // alerts '1', then alerts '2'\nvar c = new My.own.C(2); // alerts \"Going to call parent's overriden constructor...\"\n                         // alerts '2', then alerts '3'\n</code></pre>\n",
        "linenr": 124,
        "return": {
          "type": "Mixed",
          "doc": "<p>Returns the result from the superclass' method</p>\n"
        },
        "html_filename": "Base3.html"
      },
      {
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "method",
        "href": "EventObject.html#Ext-EventObject-method-correctWheelDelta",
        "shortDoc": "Correctly scales a given wheel delta. ...",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "params": [
          {
            "type": "Number",
            "optional": false,
            "doc": "<p>The delta value.</p>\n",
            "name": "delta"
          }
        ],
        "name": "correctWheelDelta",
        "owner": "Ext.EventObject",
        "doc": "<p>Correctly scales a given wheel delta.</p>\n",
        "linenr": 468,
        "return": {
          "type": "void",
          "doc": "\n"
        },
        "html_filename": "EventObject.html"
      },
      {
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "method",
        "href": "Base3.html#Ext-Base-method-create",
        "shortDoc": "Create a new instance of this Class. ...",
        "static": true,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/class/Base.js",
        "private": false,
        "params": [

        ],
        "name": "create",
        "owner": "Ext.Base",
        "doc": "<p>Create a new instance of this Class.</p>\n\n<pre><code>Ext.define('My.cool.Class', {\n    ...\n});\n\nMy.cool.Class.create({\n    someConfig: true\n});\n</code></pre>\n\n<p>All parameters are passed to the constructor of the class.</p>\n",
        "linenr": 329,
        "return": {
          "type": "Object",
          "doc": "<p>the created instance.</p>\n"
        },
        "html_filename": "Base3.html"
      },
      {
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "method",
        "href": "Base3.html#Ext-Base-method-createAlias",
        "shortDoc": "Create aliases for existing prototype methods. ...",
        "static": true,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/class/Base.js",
        "private": false,
        "params": [
          {
            "type": "String/Object",
            "optional": false,
            "doc": "<p>The new method name, or an object to set multiple aliases. See\n<a href=\"#/api/Ext.Function-method-flexSetter\" rel=\"Ext.Function-method-flexSetter\" class=\"docClass\">flexSetter</a></p>\n",
            "name": "alias"
          },
          {
            "type": "String/Object",
            "optional": false,
            "doc": "<p>The original method name</p>\n",
            "name": "origin"
          }
        ],
        "name": "createAlias",
        "owner": "Ext.Base",
        "doc": "<p>Create aliases for existing prototype methods. Example:</p>\n\n<pre><code>Ext.define('My.cool.Class', {\n    method1: function() { ... },\n    method2: function() { ... }\n});\n\nvar test = new My.cool.Class();\n\nMy.cool.Class.createAlias({\n    method3: 'method1',\n    method4: 'method2'\n});\n\ntest.method3(); // test.method1()\n\nMy.cool.Class.createAlias('method5', 'method3');\n\ntest.method5(); // test.method3() -&gt; test.method1()\n</code></pre>\n",
        "linenr": 648,
        "return": {
          "type": "void",
          "doc": "\n"
        },
        "html_filename": "Base3.html"
      },
      {
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "method",
        "href": "EventObject.html#Ext-EventObject-method-getCharCode",
        "shortDoc": "Gets the character code for the event. ...",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "params": [

        ],
        "name": "getCharCode",
        "owner": "Ext.EventObject",
        "doc": "<p>Gets the character code for the event.</p>\n",
        "linenr": 367,
        "return": {
          "type": "Number",
          "doc": "\n"
        },
        "html_filename": "EventObject.html"
      },
      {
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "method",
        "href": "EventObject.html#Ext-EventObject-method-getKey",
        "shortDoc": "Returns a normalized keyCode for the event. ...",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "params": [

        ],
        "name": "getKey",
        "owner": "Ext.EventObject",
        "doc": "<p>Returns a normalized keyCode for the event.</p>\n",
        "linenr": 375,
        "return": {
          "type": "Number",
          "doc": "<p>The key code</p>\n"
        },
        "html_filename": "EventObject.html"
      },
      {
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "method",
        "href": "Base3.html#Ext-Base-method-getName",
        "shortDoc": "Get the current class' name in string format. ...",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/class/Base.js",
        "private": false,
        "params": [

        ],
        "name": "getName",
        "owner": "Ext.Base",
        "doc": "<p>Get the current class' name in string format.</p>\n\n<pre><code>Ext.define('My.cool.Class', {\n    constructor: function() {\n        alert(this.self.getName()); // alerts 'My.cool.Class'\n    }\n});\n\nMy.cool.Class.getName(); // 'My.cool.Class'\n</code></pre>\n",
        "linenr": 631,
        "return": {
          "type": "String",
          "doc": "<p>className</p>\n"
        },
        "html_filename": "Base3.html"
      },
      {
        "deprecated": {
          "version": "4.0",
          "text": "<p>Replaced by <a href=\"#/api/Ext.EventObject-method-getX\" rel=\"Ext.EventObject-method-getX\" class=\"docClass\">getX</a></p>\n",
          "tagname": "deprecated",
          "doc": null
        },
        "alias": null,
        "protected": false,
        "tagname": "method",
        "href": "EventObject.html#Ext-EventObject-method-getPageX",
        "shortDoc": "Gets the x coordinate of the event. ...",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "params": [

        ],
        "name": "getPageX",
        "owner": "Ext.EventObject",
        "doc": "<p>Gets the x coordinate of the event.</p>\n",
        "linenr": 394,
        "return": {
          "type": "Number",
          "doc": "\n"
        },
        "html_filename": "EventObject.html"
      },
      {
        "deprecated": {
          "version": "4.0",
          "text": "<p>Replaced by <a href=\"#/api/Ext.EventObject-method-getY\" rel=\"Ext.EventObject-method-getY\" class=\"docClass\">getY</a></p>\n",
          "tagname": "deprecated",
          "doc": null
        },
        "alias": null,
        "protected": false,
        "tagname": "method",
        "href": "EventObject.html#Ext-EventObject-method-getPageY",
        "shortDoc": "Gets the y coordinate of the event. ...",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "params": [

        ],
        "name": "getPageY",
        "owner": "Ext.EventObject",
        "doc": "<p>Gets the y coordinate of the event.</p>\n",
        "linenr": 403,
        "return": {
          "type": "Number",
          "doc": "\n"
        },
        "html_filename": "EventObject.html"
      },
      {
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "method",
        "href": "EventObject.html#Ext-EventObject-method-getPoint",
        "shortDoc": "Returns a point object that consists of the object coordinates. ...",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "params": [

        ],
        "name": "getPoint",
        "owner": "Ext.EventObject",
        "doc": "<p>Returns a point object that consists of the object coordinates.</p>\n",
        "linenr": 598,
        "return": {
          "type": "Ext.util.Point",
          "doc": "<p>point</p>\n"
        },
        "html_filename": "EventObject.html"
      },
      {
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "method",
        "href": "EventObject.html#Ext-EventObject-method-getRelatedTarget",
        "shortDoc": "Gets the related target. ...",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "params": [
          {
            "type": "String",
            "optional": true,
            "doc": "<p>(optional) A simple selector to filter the target or look for an ancestor of the target</p>\n",
            "name": "selector"
          },
          {
            "type": "Number/Mixed",
            "optional": true,
            "doc": "<p>(optional) The max depth to search as a number or element (defaults to 10 || document.body)</p>\n",
            "name": "maxDepth"
          },
          {
            "type": "Boolean",
            "optional": true,
            "doc": "<p>(optional) True to return a <a href=\"#/api/Ext.core.Element\" rel=\"Ext.core.Element\" class=\"docClass\">Ext.core.Element</a> object instead of DOM node</p>\n",
            "name": "returnEl"
          }
        ],
        "name": "getRelatedTarget",
        "owner": "Ext.EventObject",
        "doc": "<p>Gets the related target.</p>\n",
        "linenr": 454,
        "return": {
          "type": "HTMLElement",
          "doc": "\n"
        },
        "html_filename": "EventObject.html"
      },
      {
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "method",
        "href": "EventObject.html#Ext-EventObject-method-getTarget",
        "shortDoc": "Gets the target for the event. ...",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "params": [
          {
            "type": "String",
            "optional": true,
            "doc": "<p>(optional) A simple selector to filter the target or look for an ancestor of the target</p>\n",
            "name": "selector"
          },
          {
            "type": "Number/Mixed",
            "optional": true,
            "doc": "<p>(optional) The max depth to search as a number or element (defaults to 10 || document.body)</p>\n",
            "name": "maxDepth"
          },
          {
            "type": "Boolean",
            "optional": true,
            "doc": "<p>(optional) True to return a <a href=\"#/api/Ext.core.Element\" rel=\"Ext.core.Element\" class=\"docClass\">Ext.core.Element</a> object instead of DOM node</p>\n",
            "name": "returnEl"
          }
        ],
        "name": "getTarget",
        "owner": "Ext.EventObject",
        "doc": "<p>Gets the target for the event.</p>\n",
        "linenr": 440,
        "return": {
          "type": "HTMLelement",
          "doc": "\n"
        },
        "html_filename": "EventObject.html"
      },
      {
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "method",
        "href": "EventObject.html#Ext-EventObject-method-getWheelDelta",
        "shortDoc": "Normalizes mouse wheel y-delta across browsers. ...",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "params": [

        ],
        "name": "getWheelDelta",
        "owner": "Ext.EventObject",
        "doc": "<p>Normalizes mouse wheel y-delta across browsers. To get x-delta information, use\n<a href=\"#/api/Ext.EventObject-method-getWheelDeltas\" rel=\"Ext.EventObject-method-getWheelDeltas\" class=\"docClass\">getWheelDeltas</a> instead.</p>\n",
        "linenr": 522,
        "return": {
          "type": "Number",
          "doc": "<p>The mouse wheel y-delta</p>\n"
        },
        "html_filename": "EventObject.html"
      },
      {
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "method",
        "href": "EventObject.html#Ext-EventObject-method-getWheelDeltas",
        "shortDoc": "Returns the mouse wheel deltas for this event. ...",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "params": [

        ],
        "name": "getWheelDeltas",
        "owner": "Ext.EventObject",
        "doc": "<p>Returns the mouse wheel deltas for this event.</p>\n",
        "linenr": 483,
        "return": {
          "type": "Object",
          "doc": "<p>An object with \"x\" and \"y\" properties holding the mouse wheel deltas.</p>\n"
        },
        "html_filename": "EventObject.html"
      },
      {
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "method",
        "href": "EventObject.html#Ext-EventObject-method-getX",
        "shortDoc": "Gets the x coordinate of the event. ...",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "params": [

        ],
        "name": "getX",
        "owner": "Ext.EventObject",
        "doc": "<p>Gets the x coordinate of the event.</p>\n",
        "linenr": 412,
        "return": {
          "type": "Number",
          "doc": "\n"
        },
        "html_filename": "EventObject.html"
      },
      {
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "method",
        "href": "EventObject.html#Ext-EventObject-method-getXY",
        "shortDoc": "Gets the page coordinates of the event. ...",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "params": [

        ],
        "name": "getXY",
        "owner": "Ext.EventObject",
        "doc": "<p>Gets the page coordinates of the event.</p>\n",
        "linenr": 428,
        "return": {
          "type": "Array",
          "doc": "<p>The xy values like [x, y]</p>\n"
        },
        "html_filename": "EventObject.html"
      },
      {
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "method",
        "href": "EventObject.html#Ext-EventObject-method-getY",
        "shortDoc": "Gets the y coordinate of the event. ...",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "params": [

        ],
        "name": "getY",
        "owner": "Ext.EventObject",
        "doc": "<p>Gets the y coordinate of the event.</p>\n",
        "linenr": 420,
        "return": {
          "type": "Number",
          "doc": "\n"
        },
        "html_filename": "EventObject.html"
      },
      {
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "method",
        "href": "EventObject.html#Ext-EventObject-method-hasModifier",
        "shortDoc": "Returns true if the control, meta, shift or alt key was pressed during this event. ...",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "params": [

        ],
        "name": "hasModifier",
        "owner": "Ext.EventObject",
        "doc": "<p>Returns true if the control, meta, shift or alt key was pressed during this event.</p>\n",
        "linenr": 607,
        "return": {
          "type": "Boolean",
          "doc": "\n"
        },
        "html_filename": "EventObject.html"
      },
      {
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "method",
        "href": "Base3.html#Ext-Base-method-implement",
        "shortDoc": "Add methods / properties to the prototype of this class. ...",
        "static": true,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/class/Base.js",
        "private": false,
        "params": [
          {
            "type": "Object",
            "optional": false,
            "doc": "\n",
            "name": "members"
          }
        ],
        "name": "implement",
        "owner": "Ext.Base",
        "doc": "<p>Add methods / properties to the prototype of this class.</p>\n\n<pre><code>Ext.define('My.awesome.Cat', {\n    constructor: function() {\n        ...\n    }\n});\n\n My.awesome.Cat.implement({\n     meow: function() {\n        alert('Meowww...');\n     }\n });\n\n var kitty = new My.awesome.Cat;\n kitty.meow();\n</code></pre>\n",
        "linenr": 415,
        "return": {
          "type": "void",
          "doc": "\n"
        },
        "html_filename": "Base3.html"
      },
      {
        "deprecated": null,
        "alias": null,
        "protected": true,
        "tagname": "method",
        "href": "Base3.html#Ext-Base-method-initConfig",
        "shortDoc": "Initialize configuration for this class. ...",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/class/Base.js",
        "private": false,
        "params": [
          {
            "type": "Object",
            "optional": false,
            "doc": "\n",
            "name": "config"
          }
        ],
        "name": "initConfig",
        "owner": "Ext.Base",
        "doc": "<p>Initialize configuration for this class. a typical example:</p>\n\n<pre><code>Ext.define('My.awesome.Class', {\n    // The default config\n    config: {\n        name: 'Awesome',\n        isAwesome: true\n    },\n\n    constructor: function(config) {\n        this.initConfig(config);\n\n        return this;\n    }\n});\n\nvar awesome = new My.awesome.Class({\n    name: 'Super Awesome'\n});\n\nalert(awesome.getName()); // 'Super Awesome'\n</code></pre>\n",
        "linenr": 63,
        "return": {
          "type": "Object",
          "doc": "<p>mixins The mixin prototypes as key - value pairs</p>\n"
        },
        "html_filename": "Base3.html"
      },
      {
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "method",
        "href": "EventObject.html#Ext-EventObject-method-injectEvent",
        "shortDoc": "Injects a DOM event using the data in this object and (optionally) a new target. ...",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "params": [
          {
            "type": "Element/HTMLElement",
            "optional": false,
            "doc": "<p>If specified, the target for the event. This\nis likely to be used when relaying a DOM event. If not specified, <a href=\"#/api/Ext.EventObject-method-getTarget\" rel=\"Ext.EventObject-method-getTarget\" class=\"docClass\">getTarget</a>\nis used to determine the target.</p>\n",
            "name": "target"
          }
        ],
        "name": "injectEvent",
        "owner": "Ext.EventObject",
        "doc": "<p>Injects a DOM event using the data in this object and (optionally) a new target.\nThis is a low-level technique and not likely to be used by application code. The\ncurrently supported event types are:</p>\n\n<p><b>HTMLEvents</b></p>\n\n\n<ul>\n<li>load</li>\n<li>unload</li>\n<li>select</li>\n<li>change</li>\n<li>submit</li>\n<li>reset</li>\n<li>resize</li>\n<li>scroll</li>\n</ul>\n\n\n<p><b>MouseEvents</b></p>\n\n\n<ul>\n<li>click</li>\n<li>dblclick</li>\n<li>mousedown</li>\n<li>mouseup</li>\n<li>mouseover</li>\n<li>mousemove</li>\n<li>mouseout</li>\n</ul>\n\n\n<p><b>UIEvents</b></p>\n\n\n<ul>\n<li>focusin</li>\n<li>focusout</li>\n<li>activate</li>\n<li>focus</li>\n<li>blur</li>\n</ul>\n\n",
        "linenr": 615,
        "return": {
          "type": "void",
          "doc": "\n"
        },
        "html_filename": "EventObject.html"
      },
      {
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "method",
        "href": "EventObject.html#Ext-EventObject-method-isNavKeyPress",
        "shortDoc": "Checks if the key pressed was a \"navigation\" key ...",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "params": [

        ],
        "name": "isNavKeyPress",
        "owner": "Ext.EventObject",
        "doc": "<p>Checks if the key pressed was a \"navigation\" key</p>\n",
        "linenr": 571,
        "return": {
          "type": "Boolean",
          "doc": "<p>True if the press is a navigation keypress</p>\n"
        },
        "html_filename": "EventObject.html"
      },
      {
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "method",
        "href": "EventObject.html#Ext-EventObject-method-isSpecialKey",
        "shortDoc": "Checks if the key pressed was a \"special\" key ...",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "params": [

        ],
        "name": "isSpecialKey",
        "owner": "Ext.EventObject",
        "doc": "<p>Checks if the key pressed was a \"special\" key</p>\n",
        "linenr": 585,
        "return": {
          "type": "Boolean",
          "doc": "<p>True if the press is a special keypress</p>\n"
        },
        "html_filename": "EventObject.html"
      },
      {
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "method",
        "href": "Base3.html#Ext-Base-method-override",
        "shortDoc": "Override prototype members of this class. ...",
        "static": true,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/class/Base.js",
        "private": false,
        "params": [
          {
            "type": "Object",
            "optional": false,
            "doc": "\n",
            "name": "members"
          }
        ],
        "name": "override",
        "owner": "Ext.Base",
        "doc": "<p>Override prototype members of this class. Overridden methods can be invoked via\n<a href=\"#/api/Ext.Base-method-callOverridden\" rel=\"Ext.Base-method-callOverridden\" class=\"docClass\">Ext.Base.callOverridden</a></p>\n\n<pre><code>Ext.define('My.Cat', {\n    constructor: function() {\n        alert(\"I'm a cat!\");\n\n        return this;\n    }\n});\n\nMy.Cat.override({\n    constructor: function() {\n        alert(\"I'm going to be a cat!\");\n\n        var instance = this.callOverridden();\n\n        alert(\"Meeeeoooowwww\");\n\n        return instance;\n    }\n});\n\nvar kitty = new My.Cat(); // alerts \"I'm going to be a cat!\"\n                          // alerts \"I'm a cat!\"\n                          // alerts \"Meeeeoooowwww\"\n</code></pre>\n",
        "linenr": 518,
        "return": {
          "type": "Ext.Base",
          "doc": "<p>this</p>\n"
        },
        "html_filename": "Base3.html"
      },
      {
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "method",
        "href": "EventObject.html#Ext-EventObject-method-preventDefault",
        "shortDoc": "Prevents the browsers default handling of the event. ...",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "params": [

        ],
        "name": "preventDefault",
        "owner": "Ext.EventObject",
        "doc": "<p>Prevents the browsers default handling of the event.</p>\n",
        "linenr": 344,
        "return": {
          "type": "void",
          "doc": "\n"
        },
        "html_filename": "EventObject.html"
      },
      {
        "deprecated": null,
        "alias": null,
        "protected": true,
        "tagname": "method",
        "href": "Base3.html#Ext-Base-method-statics",
        "shortDoc": "Get the reference to the class from which this object was instantiated. ...",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/class/Base.js",
        "private": false,
        "params": [

        ],
        "name": "statics",
        "owner": "Ext.Base",
        "doc": "<p>Get the reference to the class from which this object was instantiated. Note that unlike <a href=\"#/api/Ext.Base-property-self\" rel=\"Ext.Base-property-self\" class=\"docClass\">Ext.Base.self</a>,\n<code>this.statics()</code> is scope-independent and it always returns the class from which it was called, regardless of what\n<code>this</code> points to during run-time</p>\n\n<pre><code>Ext.define('My.Cat', {\n    statics: {\n        totalCreated: 0,\n        speciesName: 'Cat' // My.Cat.speciesName = 'Cat'\n    },\n\n    constructor: function() {\n        var statics = this.statics();\n\n        alert(statics.speciesName);     // always equals to 'Cat' no matter what 'this' refers to\n                                        // equivalent to: My.Cat.speciesName\n\n        alert(this.self.speciesName);   // dependent on 'this'\n\n        statics.totalCreated++;\n\n        return this;\n    },\n\n    clone: function() {\n        var cloned = new this.self;                      // dependent on 'this'\n\n        cloned.groupName = this.statics().speciesName;   // equivalent to: My.Cat.speciesName\n\n        return cloned;\n    }\n});\n\n\nExt.define('My.SnowLeopard', {\n    extend: 'My.Cat',\n\n    statics: {\n        speciesName: 'Snow Leopard'     // My.SnowLeopard.speciesName = 'Snow Leopard'\n    },\n\n    constructor: function() {\n        this.callParent();\n    }\n});\n\nvar cat = new My.Cat();                 // alerts 'Cat', then alerts 'Cat'\n\nvar snowLeopard = new My.SnowLeopard(); // alerts 'Cat', then alerts 'Snow Leopard'\n\nvar clone = snowLeopard.clone();\nalert(Ext.getClassName(clone));         // alerts 'My.SnowLeopard'\nalert(clone.groupName);                 // alerts 'Cat'\n\nalert(My.Cat.totalCreated);             // alerts 3\n</code></pre>\n",
        "linenr": 199,
        "return": {
          "type": "Class",
          "doc": "\n"
        },
        "html_filename": "Base3.html"
      },
      {
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "method",
        "href": "EventObject.html#Ext-EventObject-method-stopEvent",
        "shortDoc": "Stop the event (preventDefault and stopPropagation) ...",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "params": [

        ],
        "name": "stopEvent",
        "owner": "Ext.EventObject",
        "doc": "<p>Stop the event (preventDefault and stopPropagation)</p>\n",
        "linenr": 336,
        "return": {
          "type": "void",
          "doc": "\n"
        },
        "html_filename": "EventObject.html"
      },
      {
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "method",
        "href": "EventObject.html#Ext-EventObject-method-stopPropagation",
        "shortDoc": "Cancels bubbling of the event. ...",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "params": [

        ],
        "name": "stopPropagation",
        "owner": "Ext.EventObject",
        "doc": "<p>Cancels bubbling of the event.</p>\n",
        "linenr": 353,
        "return": {
          "type": "void",
          "doc": "\n"
        },
        "html_filename": "EventObject.html"
      },
      {
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "method",
        "href": "EventObject.html#Ext-EventObject-method-within",
        "shortDoc": "Returns true if the target of this event is a child of el. ...",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "params": [
          {
            "type": "Mixed",
            "optional": false,
            "doc": "<p>The id, DOM element or <a href=\"#/api/Ext.core.Element\" rel=\"Ext.core.Element\" class=\"docClass\">Ext.core.Element</a> to check</p>\n",
            "name": "el"
          },
          {
            "type": "Boolean",
            "optional": true,
            "doc": "<p>(optional) true to test if the related target is within el instead of the target</p>\n",
            "name": "related"
          },
          {
            "type": "Boolean",
            "optional": false,
            "doc": "<p>{optional} true to also check if the passed element is the target or related target</p>\n",
            "name": "allowEl"
          }
        ],
        "name": "within",
        "owner": "Ext.EventObject",
        "doc": "<p>Returns true if the target of this event is a child of el.  Unless the allowEl parameter is set, it will return false if if the target is el.\nExample usage:</p>\n\n<pre><code>// Handle click on any child of an element\nExt.getBody().on('click', function(e){\n    if(e.within('some-el')){\n        alert('Clicked on a child of some-el!');\n    }\n});\n\n// Handle click directly on an element, ignoring clicks on child nodes\nExt.getBody().on('click', function(e,t){\n    if((t.id == 'some-el') && !e.within(t, true)){\n        alert('Clicked directly on some-el!');\n    }\n});\n</code></pre>\n\n",
        "linenr": 533,
        "return": {
          "type": "Boolean",
          "doc": "\n"
        },
        "html_filename": "EventObject.html"
      }
    ],
    "property": [
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-A",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "A",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 99,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-ALT",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "ALT",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 47,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-B",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "B",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 101,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-BACKSPACE",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "BACKSPACE",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 33,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-C",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "C",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 103,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-CAPS_LOCK",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "CAPS_LOCK",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 51,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-CONTEXT_MENU",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "CONTEXT_MENU",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 151,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-CTRL",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "CTRL",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 45,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-D",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "D",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 105,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-DELETE",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "DELETE",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 77,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-DOWN",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "DOWN",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 71,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-E",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "E",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 107,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-EIGHT",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "EIGHT",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 95,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-END",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "END",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 61,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-ENTER",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "ENTER",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 39,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-ESC",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "ESC",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 53,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-F",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "F",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 109,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-F1",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "F1",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 183,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-F10",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "F10",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 201,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-F11",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "F11",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 203,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-F12",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "F12",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 205,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-F2",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "F2",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 185,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-F3",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "F3",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 187,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-F4",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "F4",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 189,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-F5",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "F5",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 191,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-F6",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "F6",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 193,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-F7",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "F7",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 195,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-F8",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "F8",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 197,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-F9",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "F9",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 199,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-FIVE",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "FIVE",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 89,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-FOUR",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "FOUR",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 87,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-G",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "G",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 111,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-H",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "H",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 113,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-HOME",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "HOME",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 63,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-I",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "I",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 115,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-INSERT",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "INSERT",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 75,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-J",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "J",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 117,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-K",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "K",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 119,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-L",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "L",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 121,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-LEFT",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "LEFT",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 65,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-M",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "M",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 123,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-N",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "N",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 125,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-NINE",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "NINE",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 97,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-NUM_CENTER",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "NUM_CENTER",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 37,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-NUM_DIVISION",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "NUM_DIVISION",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 181,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-NUM_EIGHT",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "NUM_EIGHT",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 169,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-NUM_FIVE",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "NUM_FIVE",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 163,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-NUM_FOUR",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "NUM_FOUR",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 161,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-NUM_MINUS",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "NUM_MINUS",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 177,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-NUM_MULTIPLY",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "NUM_MULTIPLY",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 173,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-NUM_NINE",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "NUM_NINE",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 171,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-NUM_ONE",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "NUM_ONE",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 155,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-NUM_PERIOD",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "NUM_PERIOD",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 179,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-NUM_PLUS",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "NUM_PLUS",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 175,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-NUM_SEVEN",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "NUM_SEVEN",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 167,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-NUM_SIX",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "NUM_SIX",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 165,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-NUM_THREE",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "NUM_THREE",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 159,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-NUM_TWO",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "NUM_TWO",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 157,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-NUM_ZERO",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "NUM_ZERO",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 153,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-O",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "O",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 127,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-ONE",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "ONE",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 81,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-P",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "P",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 129,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-PAGE_DOWN",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "PAGE_DOWN",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 59,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-PAGE_UP",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "PAGE_UP",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 57,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-PAUSE",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "PAUSE",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 49,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-PRINT_SCREEN",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "PRINT_SCREEN",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 73,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-Q",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "Q",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 131,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-R",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "R",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 133,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-RETURN",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "RETURN",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 41,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-RIGHT",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "RIGHT",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 69,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-S",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "S",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 135,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-SEVEN",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "SEVEN",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 93,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-SHIFT",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "SHIFT",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 43,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-SIX",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "SIX",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 91,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-SPACE",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "SPACE",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 55,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-T",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "T",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 137,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-TAB",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "TAB",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 35,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-THREE",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "THREE",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 85,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-TWO",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "TWO",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 83,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-U",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "U",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 139,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-UP",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "UP",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 67,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-V",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "V",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 141,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-W",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "W",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 143,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-WHEEL_SCALE",
        "shortDoc": "The mouse wheel delta scaling factor. ...",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "WHEEL_SCALE",
        "owner": "Ext.EventObject",
        "doc": "<p>The mouse wheel delta scaling factor. This value depends on browser version and OS and\nattempts to produce a similar scrolling experience across all platforms and browsers.</p>\n\n<p>To change this value:</p>\n\n<pre><code> Ext.EventObjectImpl.prototype.WHEEL_SCALE = 72;\n</code></pre>\n",
        "linenr": 207,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-X",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "X",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 145,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-Y",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "Y",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 147,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-Z",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "Z",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 149,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Number",
        "deprecated": null,
        "alias": null,
        "protected": false,
        "tagname": "property",
        "href": "EventObject.html#Ext-EventObject-property-ZERO",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
        "private": false,
        "name": "ZERO",
        "owner": "Ext.EventObject",
        "doc": "<p>Key constant</p>\n",
        "linenr": 79,
        "html_filename": "EventObject.html"
      },
      {
        "type": "Class",
        "deprecated": null,
        "alias": null,
        "protected": true,
        "tagname": "property",
        "href": "Base3.html#Ext-Base-property-self",
        "shortDoc": "Get the reference to the current class from which this object was instantiated. ...",
        "static": false,
        "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/class/Base.js",
        "private": false,
        "name": "self",
        "owner": "Ext.Base",
        "doc": "<p>Get the reference to the current class from which this object was instantiated. Unlike <a href=\"#/api/Ext.Base-method-statics\" rel=\"Ext.Base-method-statics\" class=\"docClass\">Ext.Base.statics</a>,\n<code>this.self</code> is scope-dependent and it's meant to be used for dynamic inheritance. See <a href=\"#/api/Ext.Base-method-statics\" rel=\"Ext.Base-method-statics\" class=\"docClass\">Ext.Base.statics</a>\nfor a detailed comparison</p>\n\n<pre><code>Ext.define('My.Cat', {\n    statics: {\n        speciesName: 'Cat' // My.Cat.speciesName = 'Cat'\n    },\n\n    constructor: function() {\n        alert(this.self.speciesName); / dependent on 'this'\n\n        return this;\n    },\n\n    clone: function() {\n        return new this.self();\n    }\n});\n\n\nExt.define('My.SnowLeopard', {\n    extend: 'My.Cat',\n    statics: {\n        speciesName: 'Snow Leopard'         // My.SnowLeopard.speciesName = 'Snow Leopard'\n    }\n});\n\nvar cat = new My.Cat();                     // alerts 'Cat'\nvar snowLeopard = new My.SnowLeopard();     // alerts 'Snow Leopard'\n\nvar clone = snowLeopard.clone();\nalert(Ext.getClassName(clone));             // alerts 'My.SnowLeopard'\n</code></pre>\n",
        "linenr": 18,
        "html_filename": "Base3.html"
      }
    ],
    "cssVar": [

    ],
    "cssMixin": [

    ],
    "event": [

    ]
  },
  "singleton": true,
  "alias": null,
  "superclasses": [
    "Ext.Base"
  ],
  "protected": false,
  "tagname": "class",
  "mixins": [

  ],
  "href": "EventObject.html#Ext-EventObject",
  "subclasses": [

  ],
  "static": false,
  "author": null,
  "component": false,
  "filename": "/mnt/ebs/nightly/git/SDK/platform/core/src/EventObject.js",
  "private": false,
  "alternateClassNames": [

  ],
  "name": "Ext.EventObject",
  "doc": "<p>Just as <a href=\"#/api/Ext.core.Element\" rel=\"Ext.core.Element\" class=\"docClass\">Ext.core.Element</a> wraps around a native DOM node, <a href=\"#/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a>\nwraps the browser's native event-object normalizing cross-browser differences,\nsuch as which mouse button is clicked, keys pressed, mechanisms to stop\nevent-propagation along with a method to prevent default actions from taking place.</p>\n\n<p>For example:</p>\n\n<pre><code>function handleClick(e, t){ // e is not a standard event object, it is a <a href=\"#/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a>\n    e.preventDefault();\n    var target = e.getTarget(); // same as t (the target HTMLElement)\n    ...\n}\n\nvar myDiv = <a href=\"#/api/Ext-method-get\" rel=\"Ext-method-get\" class=\"docClass\">Ext.get</a>(\"myDiv\");  // get reference to an <a href=\"#/api/Ext.core.Element\" rel=\"Ext.core.Element\" class=\"docClass\">Ext.core.Element</a>\nmyDiv.on(         // 'on' is shorthand for addListener\n    \"click\",      // perform an action on click of myDiv\n    handleClick   // reference to the action handler\n);\n\n// other methods to do the same:\nExt.EventManager.on(\"myDiv\", 'click', handleClick);\nExt.EventManager.addListener(\"myDiv\", 'click', handleClick);\n</code></pre>\n",
  "mixedInto": [

  ],
  "linenr": 1,
  "xtypes": [

  ],
  "html_filename": "EventObject.html",
  "extends": "Ext.Base"
});