﻿<%@ WebHandler Language="C#" Class="get_nodes" Debug="true" %>
#region License
//
// Extjs example aspx version.
// Written by Jamblues (extjscn@yahoo.com.hk)
// Copyright (c) 2008 extjs.org.cn. All rights reserved.
//
#endregion

using System;
using System.Web;
using System.Data;
using System.IO;

public class get_nodes : IHttpHandler
{

    public void ProcessRequest(HttpContext context)
    {
        context.Response.Charset = "utf-8";
        context.Response.ContentType = "text/html";
        //context.Response.Write(FormatBytes(10119,2,"SI", "B"));
        string lib = context.Request.Params["lib"];
        string dir = (lib != null)&&(lib == "yui") ? "../../../" : "../../";
        string node = context.Request.Params["node"];
        node = (node != null)? node : "";
        if(node.IndexOf("..") > 0){
            context.Response.Write("Nice try buddy.");
            return;
        }

        string path = context.Server.MapPath(".") + "/" + dir + node +　"/";
        string json = "[";
        if (Directory.Exists(path))
        {
            string[] dirctoryEntries = Directory.GetDirectories(path);
            foreach (string directoryName in dirctoryEntries)
            {
                string myDirectoryName = directoryName.Replace(path, "");
                json += "{\"text\":\"" + myDirectoryName + "\",\"id\":\"" + node + "\\/" + myDirectoryName + "\",\"cls\":\"folder\"},";
            }
            
            string[] fileEntries = Directory.GetFiles(path);
            foreach (string fileName in fileEntries)
            {
                string myFileName = fileName.Replace(path, "");
                json += "{\"text\":\"" + myFileName + "\",\"id\":\"" + node + "\\/" + myFileName + "\",\"leaf\":true,\"cls\":\"file\"},";
            }
        }
        else
        {
            context.Response.Write(path + " is not a valid file or directory.");
        }
        json += "]";
        json = json.Replace(",]", "]");
        context.Response.Write(json);
    }

    public bool IsReusable
    {
        get
        {
            return false;
        }
    }

    public string FormatBytes(double val, int digits, string mode, string bB)
    { //$mode == "SI"|"IEC", $bB == "b"|"B"
        string[] si = { "", "K", "M", "G", "T", "P", "E", "Z", "Y" };
        string[] iec = { "", "Ki", "Mi", "Gi", "Ti", "Pi", "Ei", "Zi", "Yi" };
        int factor;
        string[] symbols;
        switch (mode.ToUpper())
        {
            case "SI": factor = 1000; symbols = si; break;
            case "IEC": factor = 1024; symbols = iec; break;
            default: factor = 1000; symbols = si; break;
        }
        switch (bB)
        {
            case "b": val *= 8; break;
            default: bB = "B"; break;
        }
        int i = 0;
        for (; i < symbols.Length - 1 && val >= factor; i++)
            val /= factor;
        int p = val.ToString().IndexOf(".");
        if (p > 0 && p > digits)
            val = Math.Round(val);
        else if (p > 0)
            val = Math.Round(val, digits - p);
        
        return Math.Round(val, digits) + " " + symbols[i] + bB;

    }
}