﻿<%@ WebHandler Language="C#" Class="get_images" %>
#region License
//
// Extjs example aspx version.
// Written by Jamblues (extjscn@yahoo.com.hk)
// Copyright (c) 2008 extjs.org.cn. All rights reserved.
//
#endregion

using System;
using System.Web;
using System.IO;

public class get_images : IHttpHandler {
    
    public void ProcessRequest (HttpContext context) {
        context.Response.ContentType = "text/html";
        string dir = "images/thumbs/";
        string path = context.Server.MapPath(".") + "/" + dir;
        string json = "{\"images\":[";
        if (Directory.Exists(path))
        {
            string[] fileEntries = Directory.GetFiles(path);
            //限定只能上传jpg和gif图片
            string[] allowExtension = { ".jpg", ".gif", ".png" };
            foreach (string fileName in fileEntries)
            {
                FileInfo fileInfo = new FileInfo(fileName);
                string fileSize = fileInfo.Length.ToString();
                UInt32 lastModifyTime = this.GetStamp(fileInfo.LastWriteTime)*1000;
                //取得文件的扩展名,并转换成小写
                string fileExtension = Path.GetExtension(fileName).ToLower();
                //对上传的文件的类型进行一个个匹对
                for (int i = 0; i < allowExtension.Length; i++)
                {
                    if (fileExtension == allowExtension[i])
                    {
                        string myFileName = fileName.Replace(path, "");
                        json += "{\"name\":\"" + myFileName + "\",\"size\":" + fileSize + ",\"lastmod\":" + lastModifyTime.ToString() + ",\"url\":\"" + dir + myFileName + "\"},";
                    }
                }
            }
        }
        else
        {
            context.Response.Write(path + " is not a valid file or directory.");
        }
        json += "]}";
        json = json.Replace(",]}", "]}");
        context.Response.Write(json);
    }
 
    public bool IsReusable {
        get {
            return false;
        }
    }

    /// <summary>
    /// 将时间转换成UNIX时间戳
    /// </summary>
    /// <param name="dt">时间</param>
    /// <returns>UNIX时间戳</returns>
    public UInt32 GetStamp(DateTime dt)
    {
        TimeSpan ts = dt - TimeZone.CurrentTimeZone.ToLocalTime(new DateTime(1970, 1, 1));
        UInt32 uiStamp = Convert.ToUInt32(ts.TotalSeconds);
        return uiStamp;
    }

}