/*
    Copyright 2008,2009
        Matthias Ehmann,
        Michael Gerhaeuser,
        Carsten Miller,
        Bianca Valentin,
        Alfred Wassermann,
        Peter Wilfahrt

    This file is part of JSXGraph.

    JSXGraph is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    JSXGraph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with JSXGraph.  If not, see <http://www.gnu.org/licenses/>.
*/
    var JXG={};JXG.countDrawings=0;JXG.countTime=0;JXG.require=function(b){};JXG.rendererFiles=[];JXG.rendererFiles.svg="SVGRenderer";JXG.rendererFiles.vml="VMLRenderer";JXG.baseFiles=null;JXG.Math=new Object();JXG.Math.eps=0.000001;JXG.Math.Vector=function(d){this.length=0;if((typeof d!=undefined)&&(d!=null)){for(var b=0;b<d.length;b++){this.push(d[b])}}};JXG.Math.Vector.prototype=new Array();JXG.Math.Vector.prototype.n=function(){return this.length};JXG.Math.Vector.prototype.exchange=function(e,d){var b=this[e];this[e]=this[d];this[d]=b};JXG.Math.Matrix=function(g){this.length=0;var e=0;var f=false;if((typeof g!=undefined)&&(g!=null)){for(var d=0;d<g.length;d++){this.push(new Array());if(f){if(e!=g[d].length){this.length=0;throw new JXG.DimensionMismatchException("Your array contains arrays with different lengths.")}}for(var b=0;b<g[d].length;b++){this[d].push(g[d][b])}e=g[d].length;f=true}}};JXG.Math.Matrix.prototype=new Array();JXG.Math.Matrix.prototype.m=function(){return this.length};JXG.Math.Matrix.prototype.n=function(){if(this.length>0){return this[0].length}else{return 0}};JXG.Math.Matrix.prototype.exchangeRows=function(e,d){var b=this[e];this[e]=this[d];this[d]=b};JXG.DimensionMismatchException=function(b){if((typeof b!=undefined)&&(b!=null)){this.message=b}else{this.message=null}};JXG.DimensionMismatchException.prototype.what=function(){var b="Matrix has incorrect dimensions";if(this.message!=null){return b+": "+this.message+"."}else{return b+"."}};JXG.SingularMatrixException=function(b){if((typeof b!=undefined)&&(b!=null)){this.message=b}else{this.message=null}};JXG.SingularMatrixException.prototype.what=function(){var b="Matrix is singular";if(this.message!=null){return b+": "+this.message+"."}else{return b+"."}};JXG.memoizer=function(d){if(d.memo){return d.memo}var b={},e=Array.prototype.join;return(d.memo=function(){var f=e.call(arguments);return(f in b)?b[f]:b[f]=d.apply(this,arguments)})};JXG.Math.factorial=JXG.memoizer(function(b){if(b<0){return NaN}if(b==0||b==1){return 1}return b*arguments.callee(b-1)});JXG.Math.binomial=JXG.memoizer(function(g,e){if(e>g||e<0){return 0}if(e==0||e==g){return 1}var d=1;for(var f=0;f<e;f++){d*=(g-f);d/=(f+1)}return d});JXG.Math.round=function(b,f){var e=b-Math.ceil(b);var d=e.toString();if(e<0){d=d.substr(0,f+3)}else{d=d.substr(0,f+2)}e=parseFloat(d);t=parseInt(b.toString());return t+e};JXG.Math.Numerics=new Object();JXG.Math.Numerics.INT_TRAPEZ=1;JXG.Math.Numerics.INT_SIMPSON=2;JXG.Math.Numerics.INT_MILNE=3;JXG.Math.Numerics.number_of_nodes=28;JXG.Math.Numerics.integration_type=JXG.INT_MILNE;JXG.Math.Numerics.backwardSolve=function(h,e){var d=e;for(var g=h.m()-1;g>=0;g--){for(var f=h.n()-1;f>g;f--){d[g]-=h[g][f]*d[f]}d[g]/=h[g][g]}return d};JXG.Math.Numerics.Gauss=function(d,m){var o=1e-12;var h=new JXG.Math.Vector();for(var g=0;g<d.n();g++){h.push(g)}for(var f=0;f<d.n();f++){for(var g=d.n()-1;g>f;g--){if(Math.abs(d[g][f])>JXG.Math.eps){if(Math.abs(d[f][f])<JXG.Math.eps){d.exchangeRows(g,f);m.exchange(g,f);h.exchange(g,f)}else{d[g][f]/=d[f][f];m[g]-=d[g][f]*m[f];for(var e=f+1;e<d.n();e++){d[g][e]-=d[g][f]*d[f][e]}}}if(Math.abs(d[f][f])<JXG.Math.eps){throw new SingularMatrixException()}}}var l=JXG.Math.Numerics.backwardSolve(d,m);var n=new JXG.Math.Vector();for(var g=0;g<l.n();g++){n.push(l[h[g]])}return n};JXG.Math.Numerics.QR=function(e,d){};JXG.Math.Numerics.NewtonCotes=function(g,j){var d=0;var b=(g[1]-g[0])/this.number_of_nodes;switch(this.integration_type){case JXG.INT_TRAPEZ:d=(j(g[0])+j(g[1]))*0.5;var k=g[0];for(var h=0;h<this.number_of_nodes-1;h++){k+=b;d+=j(k)}d*=b;break;case JXG.INT_SIMPSON:if(this.number_of_nodes%2>0){throw"Error: INT_SIMPSONS requires Algebra.number_of_nodes dividable by 2."}var e=this.number_of_nodes/2;d=j(g[0])+j(g[1]);k=g[0];for(h=0;h<e-1;h++){k+=2*b;d+=2*j(k)}k=g[0]-b;for(h=0;h<e;h++){k+=2*b;d+=4*j(k)}d*=b/3;break;default:if(this.number_of_nodes%4>0){throw"Error in INT_MILNE: Algebra.number_of_nodes must be a multiple of 4"}e=this.number_of_nodes*0.25;d=7*(j(g[0])+j(g[1]));k=g[0];for(h=0;h<e-1;h++){k+=4*b;d+=14*j(k)}k=g[0]-3*b;for(h=0;h<e;h++){k+=4*b;d+=32*(j(k)+j(k+2*b))}k=g[0]-2*b;for(h=0;h<e;h++){k+=4*b;d+=12*j(k)}d*=2*b/45}return d};JXG.Math.Numerics.splineDef=function(m,k){if(m.length!=k.length){throw"Error in JXG.Math.Numerics.splineDef: Input vector dimensions do not match."}var b=m.length;var f=new Array();var e;for(var g=0;g<b;g++){e={X:m[g],Y:k[g]};f.push(e)}f.sort(function(n,l){return n.X-l.X});for(var g=0;g<b;g++){m[g]=f[g].X;k[g]=f[g].Y}var q=new Array();var o=new Array();for(var g=0;g<b-1;g++){q.push(m[g+1]-m[g])}for(var g=0;g<b-2;g++){o.push(6*(k[g+2]-k[g+1])/(q[g+1])-6*(k[g+1]-k[g])/(q[g]))}var h=new Array();var j=new Array();var d;h.push(2*(q[0]+q[1]));j.push(o[0]);for(var g=0;g<b-3;g++){d=q[g+1]/h[g];h.push(2*(q[g+1]+q[g+2])-d*q[g+1]);j.push(o[g+1]-d*j[g])}var p=new Array();p[b-3]=j[b-3]/h[b-3];for(var g=b-4;g>=0;g--){p[g]=(j[g]-(q[g+1]*p[g+1]))/h[g]}for(var g=b-3;g>=0;g--){p[g+1]=p[g]}p[0]=0;p[b-1]=0;return p};JXG.Math.Numerics.splineEval=function(f,v,s,z){if(v.length!=s.length){throw"Error in JXG.Math.Numerics.splineEval: Defining vector dimensions do not match."}var g=v.length;var k=1;var h=false;if(JXG.IsArray(f)){k=f.length;h=true}else{f=[f]}var w=new Array();for(var o=0;o<k;o++){if((f[o]<v[0])||(v[o]>v[g-1])){return"NaN"}var m;for(m=1;m<g;m++){if(f[o]<=v[m]){break}}m--;var u=s[m];var r=(s[m+1]-s[m])/(v[m+1]-v[m])-(v[m+1]-v[m])/6*(z[m+1]+2*z[m]);var q=z[m]/2;var p=(z[m+1]-z[m])/(6*(v[m+1]-v[m]));var e=f[o]-v[m];w.push(u+(r+(q+p*e)*e)*e)}if(h){return w}else{return w[0]}};JXG.Math.Numerics.lagrangePolynomial=function(b){return function(d){var g,e;var j=0;var h=[];for(g=0;g<b.length;g++){h[g]=b[g].X()}for(g=0;g<b.length;g++){var f=b[g].Y();for(e=0;e<b.length;e++){if(e!=g){f*=(d-h[e])/(h[g]-h[e])}}j+=f}return j}};JXG.Math.Numerics.neville=function(b){return[function(g){var f,e,d;var h=0;for(f=0;f<b.length;f++){d=b[f].X();for(e=0;e<b.length;e++){if(e!=f){d*=(g-e)/(f-e)}}h+=d}return h},function(g){var f,e,d;var h=0;for(f=0;f<b.length;f++){d=b[f].Y();for(e=0;e<b.length;e++){if(e!=f){d*=(g-e)/(f-e)}}h+=d}return h},0,function(){return b.length-1}]};JXG.Math.Numerics.D=function(d,e){var b=0.00001;if(arguments.length==1){return function(f){return(d(f+b)-d(f-b))/(2*b)}}else{return function(f){return(d.apply(e,[f+b])-d.apply(e,[f-b]))/(2*b)}}};JXG.Math.Numerics.I=function(b,d){return JXG.Math.Numerics.NewtonCotes(b,d)};JXG.Math.Numerics.newton=function(j,b,k){var d=0;var e=1e-7;var g=j.apply(k,[b]);while(d<50&&Math.abs(g)>e){var l=this.D(j,k)(b);if(Math.abs(l)>e){b-=g/l}else{b+=(Math.random()*0.2-1)}g=j.apply(k,[b]);d++}return b};JXG.Math.Numerics.root=function(d,b,e){return this.newton(d,b,e)};JXG.Math.Numerics.cosh=function(b){return(Math.exp(b)+Math.exp(-b))*0.5};JXG.Math.Numerics.sinh=function(b){return(Math.exp(b)-Math.exp(-b))*0.5};JXG.Math.Numerics.riemann=function(o,h,p,e,k){var g,v,m,u,l,s,q,d,b,r;g=[];v=[];l=0;s=e;h=Math.floor(h);g[l]=s;v[l]=0;if(h>0){u=(k-e)/h;b=u*0.01;for(m=0;m<h;m++){if(p=="right"){q=o(s+u)}else{if(p=="middle"){q=o(s+u*0.5)}else{if((p=="left")||(p=="trapezodial")){q=o(s)}else{if(p=="lower"){q=o(s);for(d=s+b;d<=s+u;d+=b){r=o(d);if(r<q){q=r}}}else{q=o(s);for(d=s+b;d<=s+u;d+=b){r=o(d);if(r>q){q=r}}}}}}l++;g[l]=s;v[l]=q;l++;s+=u;if(p=="trapezodial"){q=o(s)}g[l]=s;v[l]=q;l++;g[l]=s;v[l]=0}}return[g,v]};JXG.Math.Numerics.riemannsum=function(k,g,m,e,h){var l,j,r,q,o,d,b,p;l=0;q=e;g=Math.floor(g);if(g>0){r=(h-e)/g;b=r*0.01;for(j=0;j<g;j++){if(m=="right"){o=k(q+r)}else{if(m=="middle"){o=k(q+r*0.5)}else{if(m=="trapezodial"){o=0.5*(k(q+r)+k(q))}else{if(m=="left"){o=k(q)}else{if(m=="lower"){o=k(q);for(d=q+b;d<=q+r;d+=b){p=k(d);if(p<o){o=p}}}else{o=k(q);for(d=q+b;d<=q+r;d+=b){p=k(d);if(p>o){o=p}}}}}}}l+=r*o;q+=r}}return l};JXG.MathStatistics=function(){};JXG.MathStatistics.prototype.sum=function(d){var f=0;for(var e=0,b=d.length;e<b;e++){f+=d[e]}return f};JXG.MathStatistics.prototype.prod=function(d){var f=1;for(var e=0,b=d.length;e<b;e++){f*=d[e]}return f};JXG.MathStatistics.prototype.mean=function(b){if(b.length>0){return this.sum(b)/b.length}else{return 0}};JXG.MathStatistics.prototype.median=function(d){if(d.length>0){var e=d.clone();e.sort(function(g,f){return g-f});var b=e.length;if(b%2==1){return e[parseInt(b*0.5)]}else{return(e[b*0.5-1]+e[b*0.5])*0.5}}else{return 0}};JXG.MathStatistics.prototype.variance=function(e){if(e.length>1){var d=this.mean(e);var g=0;for(var f=0,b=e.length;f<b;f++){g+=(e[f]-d)*(e[f]-d)}return g/(e.length-1)}else{return 0}};JXG.MathStatistics.prototype.sd=function(b){return Math.sqrt(this.variance(b))};JXG.MathStatistics.prototype.weightedMean=function(b,d){if(b.length!=d.length){return}if(b.length>0){var e=this.multiply(b,d);return this.mean(e)}else{return 0}};JXG.MathStatistics.prototype.max=function(d){if(d.length==0){return NaN}var f=d[0];for(var e=1,b=d.length;e<b;e++){f=(d[e]>f)?(d[e]):f}return f};JXG.MathStatistics.prototype.min=function(d){if(d.length==0){return NaN}var f=d[0];for(var e=1,b=d.length;e<b;e++){f=(d[e]<f)?(d[e]):f}return f};JXG.MathStatistics.prototype.range=function(b){return[this.min(b),this.max(b)]};JXG.MathStatistics.prototype.diff=function(b){return b};JXG.MathStatistics.prototype.min=function(d){if(d.length==0){return NaN}var f=d[0];for(var e=1,b=d.length;e<b;e++){f=(d[e]<f)?(d[e]):f}return f};JXG.MathStatistics.prototype.abs=function(d){var f=[];if(typeof JXG.IsArray(arr1)){for(var e=0,b=d.length;e<b;e++){f[e]=Math.abs(d[e])}}else{if(typeof d=="number"){return Math.abs(d)}else{f=null}}return f};JXG.MathStatistics.prototype.add=function(e,d){var g=[];if(typeof JXG.IsArray(e)&&typeof d=="number"){for(var f=0,b=Math.min(e.length,d.length);f<b;f++){g[f]=e[f]+d}}else{if(typeof e=="number"&&typeof JXG.IsArray(d)){for(var f=0,b=Math.min(e.length,d.length);f<b;f++){g[f]=e+d[f]}}else{if(typeof JXG.IsArray(e)&&typeof JXG.IsArray(d)){for(var f=0,b=Math.min(e.length,d.length);f<b;f++){g[f]=e[f]+d[f]}}else{if(typeof e=="number"&&typeof d=="number"){for(var f=0,b=Math.min(e.length,d.length);f<b;f++){g[f]=e+d}}else{g=null}}}}return g};JXG.MathStatistics.prototype.divide=function(e,d){var g=[];if(typeof JXG.IsArray(e)&&typeof d=="number"){for(var f=0,b=Math.min(e.length,d.length);f<b;f++){g[f]=e[f]/d}}else{if(typeof e=="number"&&typeof JXG.IsArray(d)){for(var f=0,b=Math.min(e.length,d.length);f<b;f++){g[f]=e/d[f]}}else{if(typeof JXG.IsArray(e)&&typeof JXG.IsArray(d)){for(var f=0,b=Math.min(e.length,d.length);f<b;f++){g[f]=e[f]/d[f]}}else{if(typeof e=="number"&&typeof d=="number"){for(var f=0,b=Math.min(e.length,d.length);f<b;f++){g[f]=e/d}}else{g=null}}}}return g};JXG.MathStatistics.prototype.mod=function(e,d){var g=[];if(typeof JXG.IsArray(e)&&typeof d=="number"){for(var f=0,b=Math.min(e.length,d.length);f<b;f++){g[f]=e[f]%d}}else{if(typeof e=="number"&&typeof JXG.IsArray(d)){for(var f=0,b=Math.min(e.length,d.length);f<b;f++){g[f]=e%d[f]}}else{if(typeof JXG.IsArray(e)&&typeof JXG.IsArray(d)){for(var f=0,b=Math.min(e.length,d.length);f<b;f++){g[f]=e[f]%d[f]}}else{if(typeof e=="number"&&typeof d=="number"){for(var f=0,b=Math.min(e.length,d.length);f<b;f++){g[f]=e%d}}else{g=null}}}}return g};JXG.MathStatistics.prototype.multiply=function(e,d){var g=[];if(typeof JXG.IsArray(e)&&typeof d=="number"){for(var f=0,b=Math.min(e.length,d.length);f<b;f++){g[f]=e[f]*d}}else{if(typeof e=="number"&&typeof JXG.IsArray(d)){for(var f=0,b=Math.min(e.length,d.length);f<b;f++){g[f]=e*d[f]}}else{if(typeof JXG.IsArray(e)&&typeof JXG.IsArray(d)){for(var f=0,b=Math.min(e.length,d.length);f<b;f++){g[f]=e[f]*d[f]}}else{if(typeof e=="number"&&typeof d=="number"){for(var f=0,b=Math.min(e.length,d.length);f<b;f++){g[f]=e*d}}else{g=null}}}}return g};JXG.MathStatistics.prototype.subtract=function(e,d){var g=[];if(typeof JXG.IsArray(e)&&typeof d=="number"){for(var f=0,b=Math.min(e.length,d.length);f<b;f++){g[f]=e[f]-d}}else{if(typeof e=="number"&&typeof JXG.IsArray(d)){for(var f=0,b=Math.min(e.length,d.length);f<b;f++){g[f]=e-d[f]}}else{if(typeof JXG.IsArray(e)&&typeof JXG.IsArray(d)){for(var f=0,b=Math.min(e.length,d.length);f<b;f++){g[f]=e[f]-d[f]}}else{if(typeof e=="number"&&typeof d=="number"){for(var f=0,b=Math.min(e.length,d.length);f<b;f++){g[f]=e-d}}else{g=null}}}}return g};JXG.AbstractRenderer=function(){this.vOffsetText=8;this.enhancedRendering=true};JXG.AbstractRenderer.prototype.drawPoint=function(e){var f;var b;var d=this.getPointSize(e.visProp.style);if(e.visProp.style==0||e.visProp.style==1||e.visProp.style==2){f=this.createPrimitive("line",e.id+"_x1");b=this.createPrimitive("line",e.id+"_x2");this.appendChildPrimitive(f,"points");this.appendChildPrimitive(b,"points");e.rendNodeX1=f;e.rendNodeX2=b}else{if(e.visProp.style==3||e.visProp.style==4||e.visProp.style==5||e.visProp.style==6){f=this.createPrimitive("circle",e.id);this.appendChildPrimitive(f,"points");e.rendNode=f}else{if(e.visProp.style==7||e.visProp.style==8||e.visProp.style==9){f=this.createPrimitive("rect",e.id);this.appendChildPrimitive(f,"points");e.rendNode=f}else{if(e.visProp.style==10||e.visProp.style==11||e.visProp.style==12){f=this.createPrimitive("line",e.id+"_x1");b=this.createPrimitive("line",e.id+"_x2");this.appendChildPrimitive(f,"points");this.appendChildPrimitive(b,"points");e.rendNodeX1=f;e.rendNodeX2=b}}}}this.setObjectStrokeWidth(e,e.visProp.strokeWidth);this.setObjectStrokeColor(e,e.visProp.strokeColor,e.visProp.strokeOpacity);this.setObjectFillColor(e,e.visProp.fillColor,e.visProp.fillOpacity);this.setDraft(e);this.updatePoint(e)};JXG.AbstractRenderer.prototype.updatePoint=function(d){if(this.enhancedRendering){if(!d.visProp.draft){this.setObjectStrokeWidth(d,d.visProp.strokeWidth);this.setObjectStrokeColor(d,d.visProp.strokeColor,d.visProp.strokeOpacity);this.setObjectFillColor(d,d.visProp.fillColor,d.visProp.fillOpacity)}else{this.setDraft(d)}}var b=this.getPointSize(d.visProp.style);if(d.visProp.style==0||d.visProp.style==1||d.visProp.style==2){this.updateLinePrimitive(d.rendNodeX1,d.coords.scrCoords[1]-b,d.coords.scrCoords[2]-b,d.coords.scrCoords[1]+b,d.coords.scrCoords[2]+b);this.updateLinePrimitive(d.rendNodeX2,d.coords.scrCoords[1]+b,d.coords.scrCoords[2]-b,d.coords.scrCoords[1]-b,d.coords.scrCoords[2]+b)}else{if(d.visProp.style==3||d.visProp.style==4||d.visProp.style==5||d.visProp.style==6){this.updateCirclePrimitive(d.rendNode,d.coords.scrCoords[1],d.coords.scrCoords[2],b+1)}else{if(d.visProp.style==7||d.visProp.style==8||d.visProp.style==9){this.updateRectPrimitive(d.rendNode,d.coords.scrCoords[1]-b,d.coords.scrCoords[2]-b,b*2,b*2)}else{if(d.visProp.style==10||d.visProp.style==11||d.visProp.style==12){this.updateLinePrimitive(d.rendNodeX1,d.coords.scrCoords[1]-b,d.coords.scrCoords[2],d.coords.scrCoords[1]+b,d.coords.scrCoords[2]);this.updateLinePrimitive(d.rendNodeX2,d.coords.scrCoords[1],d.coords.scrCoords[2]-b,d.coords.scrCoords[1],d.coords.scrCoords[2]+b)}}}}};JXG.AbstractRenderer.prototype.changePointStyle=function(b){var d=this.getElementById(b.id);if(d!=null){this.remove(d)}else{this.remove(this.getElementById(b.id+"_x1"));this.remove(this.getElementById(b.id+"_x2"))}this.drawPoint(b);if(!b.visProp.visible){this.hide(b)}if(b.visProp.draft){this.setDraft(b)}};JXG.AbstractRenderer.prototype.drawLine=function(b){var d=this.createPrimitive("line",b.id);this.appendChildPrimitive(d,"lines");b.rendNode=d;this.setDashStyle(b.rendNode,b.visProp);this.updateLine(b)};JXG.AbstractRenderer.prototype.updateLine=function(d){var o=new JXG.Coords(JXG.COORDS_BY_USER,d.point1.coords.usrCoords,d.board);var n=new JXG.Coords(JXG.COORDS_BY_USER,d.point2.coords.usrCoords,d.board);if(d.visProp.straightFirst||d.visProp.straightLast){this.calcStraight(d,o,n)}this.updateLinePrimitive(d.rendNode,o.scrCoords[1],o.scrCoords[2],n.scrCoords[1],n.scrCoords[2]);if(d.image!=null){var b=o.scrCoords[1];var p=o.scrCoords[2];var h=n.scrCoords[1];var g=n.scrCoords[2];var l;var f=(h-b>0)?1:-1;if(Math.abs(h-b)>1e-7){l=Math.atan((g-p)/(h-b))+((f<0)?Math.PI:0)}else{l=((g-p>0)?0.5:-0.5)*Math.PI}var k=250;var j=256;var e=[[1,0,0],[k*(1-Math.cos(l))+j*Math.sin(l),Math.cos(l),-Math.sin(l)],[j*(1-Math.cos(l))-k*Math.sin(l),Math.sin(l),Math.cos(l)]];d.imageTransformMatrix=e}this.makeArrows(d);if(this.enhancedRendering){if(!d.visProp.draft){this.setObjectStrokeWidth(d,d.visProp.strokeWidth);this.setObjectStrokeColor(d,d.visProp.strokeColor,d.visProp.strokeOpacity)}else{this.setDraft(d)}}};JXG.AbstractRenderer.prototype.drawCurve=function(b){var d=this.createPrimitive("path",b.id);this.appendChildPrimitive(d,"curves");b.rendNode=d;this.setObjectStrokeWidth(b,b.visProp.strokeWidth);this.setObjectStrokeColor(b,b.visProp.strokeColor,b.visProp.strokeOpacity);this.setObjectFillColor(b,b.visProp.fillColor,b.visProp.fillOpacity);this.setDashStyle(b.rendNode,b.visProp);this.updateCurve(b)};JXG.AbstractRenderer.prototype.updateCurve=function(b){if(this.enhancedRendering){if(!b.visProp.draft){this.setObjectStrokeWidth(b,b.visProp.strokeWidth);this.setObjectStrokeColor(b,b.visProp.strokeColor,b.visProp.strokeOpacity);this.setObjectFillColor(b,b.visProp.fillColor,b.visProp.fillOpacity)}else{this.setDraft(b)}}this.updatePathPrimitive(b.rendNode,this.updatePathStringPrimitive(b),b.board)};JXG.AbstractRenderer.prototype.calcStraight=function(g,q,o){var e,d,m,k,r,f,p,n,w,l,h,v,u;p=g.board.algebra;r=g.visProp.straightFirst;f=g.visProp.straightLast;if(!r&&!f){return}if(Math.abs(q.scrCoords[0])<p.eps||Math.abs(o.scrCoords[0])<p.eps){r=true;f=true}n=[];n[0]=g.stdform[0]-g.stdform[1]*g.board.origin.scrCoords[1]/(g.board.unitX*g.board.zoomX)+g.stdform[2]*g.board.origin.scrCoords[2]/(g.board.unitY*g.board.zoomY);n[1]=g.stdform[1]/(g.board.unitX*g.board.zoomX);n[2]=g.stdform[2]/(-g.board.unitY*g.board.zoomY);if(isNaN(n[0]+n[1]+n[2])){return}w=[];w[0]=p.crossProduct(n,[0,0,1]);w[1]=p.crossProduct(n,[0,1,0]);w[2]=p.crossProduct(n,[-g.board.canvasHeight,0,1]);w[3]=p.crossProduct(n,[-g.board.canvasWidth,1,0]);for(l=0;l<4;l++){if(Math.abs(w[l][0])>p.eps){for(h=2;h>0;h--){w[l][h]/=w[l][0]}w[l][0]=1}}e=false;d=false;if(!r&&q.scrCoords[1]>=0&&q.scrCoords[1]<=g.board.canvasWidth&&q.scrCoords[2]>=0&&q.scrCoords[2]<=g.board.canvasHeight){e=true}if(!f&&o.scrCoords[1]>=0&&o.scrCoords[1]<=g.board.canvasWidth&&o.scrCoords[2]>=0&&o.scrCoords[2]<=g.board.canvasHeight){d=true}if(Math.abs(w[1][0])<p.eps){m=w[0];k=w[2]}else{if(Math.abs(w[0][0])<p.eps){m=w[1];k=w[3]}else{if(w[1][2]<0){m=w[0];if(w[3][2]>g.board.canvasHeight){k=w[2]}else{k=w[3]}}else{if(w[1][2]>g.board.canvasHeight){m=w[2];if(w[3][2]<0){k=w[0]}else{k=w[3]}}else{m=w[1];if(w[3][2]<0){k=w[0]}else{if(w[3][2]>g.board.canvasHeight){k=w[2]}else{k=w[3]}}}}}}m=new JXG.Coords(JXG.COORDS_BY_SCREEN,m.slice(1),g.board);k=new JXG.Coords(JXG.COORDS_BY_SCREEN,k.slice(1),g.board);if(!e){if(!d){if(this.isSameDirection(q,o,m)){if(!this.isSameDirection(q,o,k)){u=m;v=k}else{if(g.board.algebra.affineDistance(o.usrCoords,m.usrCoords)<g.board.algebra.affineDistance(o.usrCoords,k.usrCoords)){v=m;u=k}else{u=m;v=k}}}else{if(this.isSameDirection(q,o,k)){v=m;u=k}else{if(g.board.algebra.affineDistance(o.usrCoords,m.usrCoords)<g.board.algebra.affineDistance(o.usrCoords,k.usrCoords)){u=m;v=k}else{v=m;u=k}}}}else{if(this.isSameDirection(o,q,m)){v=m}else{v=k}}}else{if(!d){if(this.isSameDirection(q,o,m)){u=m}else{u=k}}}if(v){q.setCoordinates(JXG.COORDS_BY_USER,v.usrCoords.slice(1))}if(u){o.setCoordinates(JXG.COORDS_BY_USER,u.usrCoords.slice(1))}};JXG.AbstractRenderer.prototype.isSameDirection=function(j,f,e){var d,b,h,g;d=f.usrCoords[1]-j.usrCoords[1];b=f.usrCoords[2]-j.usrCoords[2];h=e.usrCoords[1]-j.usrCoords[1];g=e.usrCoords[2]-j.usrCoords[2];if(Math.abs(d)<JXG.Math.eps){d=0}if(Math.abs(b)<JXG.Math.eps){b=0}if(Math.abs(h)<JXG.Math.eps){h=0}if(Math.abs(g)<JXG.Math.eps){g=0}if(d>=0&&h>=0){if((b>=0&&g>=0)||(b<=0&&g<=0)){return true}}else{if(d<=0&&h<=0){if((b>=0&&g>=0)||(b<=0&&g<=0)){return true}}}return false};JXG.AbstractRenderer.prototype.drawCircle=function(b){var d=this.createPrimitive("ellipse",b.id);b.rendNode=d;this.setDashStyle(d,b.visProp);this.appendChildPrimitive(d,"circles");this.setDraft(b);this.updateCircle(b)};JXG.AbstractRenderer.prototype.updateCircle=function(d){if(this.enhancedRendering){if(!d.visProp.draft){this.setObjectStrokeWidth(d,d.visProp.strokeWidth);this.setObjectStrokeColor(d,d.visProp.strokeColor,d.visProp.strokeOpacity);this.setObjectFillColor(d,d.visProp.fillColor,d.visProp.fillOpacity)}else{this.setDraft(d)}}var b=d.getRadius();this.updateEllipsePrimitive(d.rendNode,d.midpoint.coords.scrCoords[1],d.midpoint.coords.scrCoords[2],(b*d.board.unitX*d.board.zoomX),(b*d.board.unitY*d.board.zoomY))};JXG.AbstractRenderer.prototype.drawPolygon=function(b){var d=this.createPrimitive("polygon",b.id);b.visProp.fillOpacity=0.3;this.appendChildPrimitive(d,"polygone");b.rendNode=d;this.setDraft(b);this.updatePolygon(b)};JXG.AbstractRenderer.prototype.updatePolygon=function(b){if(this.enhancedRendering){if(!b.visProp.draft){this.setObjectStrokeWidth(b,b.visProp.strokeWidth);this.setObjectFillColor(b,b.visProp.fillColor,b.visProp.fillOpacity)}else{this.setDraft(b)}}this.updatePolygonePrimitive(b.rendNode,b)};JXG.AbstractRenderer.prototype.drawArrow=function(b){var d=this.createPrimitive("line",b.id);this.setObjectStrokeWidth(b,b.visProp.strokeWidth);this.setObjectStrokeColor(b,b.visProp.strokeColor,b.visProp.strokeOpacity);this.setObjectFillColor(b,b.visProp.fillColor,b.visProp.fillOpacity);this.setDashStyle(d,b.visProp);this.makeArrow(d,b);this.appendChildPrimitive(d,"lines");b.rendNode=d;this.setDraft(b);this.updateArrow(b)};JXG.AbstractRenderer.prototype.updateArrow=function(b){if(this.enhancedRendering){if(!b.visProp.draft){this.setObjectStrokeWidth(b,b.visProp.strokeWidth);this.setObjectStrokeColor(b,b.visProp.strokeColor,b.visProp.strokeOpacity);this.setObjectFillColor(b,b.visProp.fillColor,b.visProp.fillOpacity)}else{this.setDraft(b)}}this.updateLinePrimitive(b.rendNode,b.point1.coords.scrCoords[1],b.point1.coords.scrCoords[2],b.point2.coords.scrCoords[1],b.point2.coords.scrCoords[2])};JXG.AbstractRenderer.prototype.updateTicks=function(e,d,b){};JXG.AbstractRenderer.prototype.removeTicks=function(b){var d=this.getElementById(b.id+"_ticks");this.remove(d)};JXG.AbstractRenderer.prototype.drawArc=function(b){};JXG.AbstractRenderer.prototype.updateArc=function(b){};JXG.AbstractRenderer.prototype.drawLabel=function(b){var d=this.container.ownerDocument.createElement("div");d.style.position="absolute";d.style.fontSize=b.board.fontSize+"px";d.style.color=b.color;d.className="JXGText";d.style.zIndex="10";d.setAttribute("id",b.id);d.innerHTML=b.nameHTML;this.container.appendChild(d);b.rendNode=d;this.updateLabel(b)};JXG.AbstractRenderer.prototype.updateLabel=function(b){b.rendNode.style.left=(b.coords.scrCoords[1])+"px";b.rendNode.style.top=(b.coords.scrCoords[2]-this.vOffsetText)+"px";b.rendNode.innerHTML=b.nameHTML};JXG.AbstractRenderer.prototype.drawText=function(b){var d=this.container.ownerDocument.createElement("div");d.setAttribute("id",b.id);d.style.position="absolute";d.style.fontSize=b.board.fontSize+"px";d.style.color=b.visProp.strokeColor;d.className="JXGtext";d.style.zIndex="10";this.container.appendChild(d);b.rendNode=d;this.updateText(b)};JXG.AbstractRenderer.prototype.updateText=function(b){this.updateTextStyle(b);b.rendNode.style.left=(b.coords.scrCoords[1])+"px";b.rendNode.style.top=(b.coords.scrCoords[2]-this.vOffsetText)+"px";b.rendNode.innerHTML=b.plaintextStr};JXG.AbstractRenderer.prototype.updateTextStyle=function(d){if(d.visProp.fontSize){if(typeof d.visProp.fontSize=="function"){var b=d.visProp.fontSize();d.rendNode.style.fontSize=(b>0?b:0)}else{d.rendNode.style.fontSize=(d.visProp.fontSize)}}};JXG.AbstractRenderer.prototype.drawAngle=function(b){};JXG.AbstractRenderer.prototype.updateAngle=function(b){};JXG.AbstractRenderer.prototype.drawImage=function(b){};JXG.AbstractRenderer.prototype.updateImage=function(b){this.updateRectPrimitive(b.rendNode,b.coords.scrCoords[1],b.coords.scrCoords[2]-b.size[1],b.size[0],b.size[1]);if(b.parent!=null){this.transformImageParent(b,b.parent.imageTransformMatrix)}else{this.transformImageParent(b)}this.transformImage(b,b.transformations)};JXG.AbstractRenderer.prototype.drawGrid=function(f){f.hasGrid=true;var x=f.gridX;var v=f.gridY;var p;var s=new JXG.Coords(JXG.COORDS_BY_SCREEN,[0,0],f);var g=new JXG.Coords(JXG.COORDS_BY_SCREEN,[f.canvasWidth,f.canvasHeight],f);var y=Math.ceil(s.usrCoords[1]);var u=0;for(var w=0;w<=x+1;w++){if(y-w/x<s.usrCoords[1]){u=w-1;break}}y=Math.floor(g.usrCoords[1]);var b=0;for(var w=0;w<=x+1;w++){if(y+w/x>g.usrCoords[1]){b=w-1;break}}y=Math.ceil(g.usrCoords[2]);var r=0;for(var w=0;w<=v+1;w++){if(y-w/v<g.usrCoords[2]){r=w-1;break}}y=Math.floor(s.usrCoords[2]);var q=0;for(var w=0;w<=v+1;w++){if(y+w/v>s.usrCoords[2]){q=w-1;break}}var n=Math.round((1/x)*f.zoomX*f.unitX);var m=Math.round((1/v)*f.zoomY*f.unitY);var o=new JXG.Coords(JXG.COORDS_BY_USER,[Math.ceil(s.usrCoords[1])-u/x,Math.floor(s.usrCoords[2])+q/v],f);var h=new JXG.Coords(JXG.COORDS_BY_USER,[Math.floor(g.usrCoords[1])+b/x,Math.ceil(g.usrCoords[2])-r/v],f);var d=this.drawVerticalGrid(o,h,n,f);if(!f.snapToGrid){var e=new Object();e.rendNode=d;e.elementClass=JXG.OBJECT_CLASS_LINE;e.id="gridx";this.setObjectStrokeColor(e,f.gridColor,f.gridOpacity)}else{var e=new Object();e.rendNode=d;e.elementClass=JXG.OBJECT_CLASS_LINE;e.id="gridx";this.setObjectStrokeColor(e,"#FF8080",0.5)}this.setPropertyPrimitive(d,"stroke-width","0.4px");if(f.gridDash){this.setPropertyPrimitive(d,"stroke-dasharray","5, 5")}this.appendChildPrimitive(d,"grid");var d=this.drawHorizontalGrid(o,h,m,f);if(!f.snapToGrid){var e=new Object();e.rendNode=d;e.elementClass=JXG.OBJECT_CLASS_LINE;e.id="gridy";this.setObjectStrokeColor(e,f.gridColor,f.gridOpacity)}else{var e=new Object();e.rendNode=d;e.elementClass=JXG.OBJECT_CLASS_LINE;e.id="gridy";this.setObjectStrokeColor(e,"#FF8080",0.5)}this.setPropertyPrimitive(d,"stroke-width","0.4px");if(f.gridDash){this.setPropertyPrimitive(d,"stroke-dasharray","5, 5")}this.appendChildPrimitive(d,"grid")};JXG.AbstractRenderer.prototype.removeGrid=function(b){};JXG.AbstractRenderer.prototype.hide=function(b){};JXG.AbstractRenderer.prototype.show=function(b){};JXG.AbstractRenderer.prototype.setObjectStrokeWidth=function(d,b){};JXG.AbstractRenderer.prototype.setObjectStrokeColor=function(e,b,d){};JXG.AbstractRenderer.prototype.setObjectDash=function(b){};JXG.AbstractRenderer.prototype.setObjectFillColor=function(e,b,d){};JXG.AbstractRenderer.prototype.setDraft=function(d){if(!d.visProp.draft){return}var b=d.board.options.elements.draft.color;var e=d.board.options.elements.draft.opacity;if(d.type==JXG.OBJECTT_TYPE_POLYGON){this.setObjectFillColor(d,b,e)}else{if(d.elementClass==JXG.OBJECT_CLASS_POINT){this.setObjectFillColor(d,b,e)}else{this.setObjectFillColor(d,"none",0)}this.setObjectStrokeColor(d,b,e);this.setObjectStrokeWidth(d,d.board.options.elements.draft.strokeWidth)}};JXG.AbstractRenderer.prototype.removeDraft=function(b){if(b.type==JXG.OBJECT_TYPE_POLYGON){this.setObjectFillColor(b,b.visProp.fillColor,b.visProp.fillColorOpacity)}else{if(b.type==JXG.OBJECT_CLASS_POINT){this.setObjectFillColor(b,b.visProp.fillColor,b.visProp.fillColorOpacity)}this.setObjectStrokeColor(b,b.visProp.strokeColor,b.visProp.strokeColorOpacity);this.setObjectStrokeWidth(b,b.visProp.strokeWidth)}};JXG.AbstractRenderer.prototype.highlight=function(d){if(d.visProp.draft==false){if(d.type==JXG.OBJECT_CLASS_POINT){this.setObjectStrokeColor(d,d.visProp.highlightStrokeColor,d.visProp.highlightStrokeOpacity);this.setObjectFillColor(d,d.visProp.highlightStrokeColor,d.visProp.highlightStrokeOpacity)}else{if(d.type==JXG.OBJECT_TYPE_POLYGON){this.setObjectFillColor(d,d.visProp.highlightFillColor,d.visProp.highlightFillOpacity);for(var b=0;b<d.borders.length;b++){this.setObjectStrokeColor(d.borders[b],d.borders[b].visProp.highlightStrokeColor,d.visProp.highlightStrokeOpacity)}}else{this.setObjectStrokeColor(d,d.visProp.highlightStrokeColor,d.visProp.highlightStrokeOpacity);this.setObjectFillColor(d,d.visProp.highlightFillColor,d.visProp.highlightFillOpacity)}}}};JXG.AbstractRenderer.prototype.noHighlight=function(b){if(b.visProp.draft==false){if(b.type==JXG.OBJECT_CLASS_POINT){this.setObjectStrokeColor(b,b.visProp.strokeColor,b.visProp.strokeOpacity);this.setObjectFillColor(b,b.visProp.strokeColor,b.visProp.strokeOpacity)}else{if(b.type==JXG.OBJECT_TYPE_POLYGON){this.setObjectFillColor(b,b.visProp.fillColor,b.visProp.fillOpacity);for(i=0;i<b.borders.length;i++){this.setObjectStrokeColor(b.borders[i],b.borders[i].visProp.strokeColor,b.visProp.strokeOpacity)}}else{this.setObjectStrokeColor(b,b.visProp.strokeColor,b.visProp.strokeOpacity);this.setObjectFillColor(b,b.visProp.fillColor,b.visProp.fillOpacity)}}}};JXG.AbstractRenderer.prototype.setLabelColor=function(b){b.rendNode.style.color=b.color};JXG.AbstractRenderer.prototype.suspendRedraw=function(){};JXG.AbstractRenderer.prototype.unsuspendRedraw=function(){};JXG.AbstractRenderer.prototype.remove=function(b){};JXG.AbstractRenderer.prototype.getPointSize=function(d){var b=0;switch(d){case 0:b=2;break;case 1:b=3;break;case 2:b=4;break;case 3:b=1;break;case 4:b=2;break;case 5:b=3;break;case 6:b=4;break;case 7:b=2;break;case 8:b=3;break;case 9:b=4;break;case 10:b=2;break;case 11:b=3;break;case 12:b=4;break;default:}return b};JXG.AbstractRenderer.prototype.drawZoomBar=function(j){var e=this.container.ownerDocument.createElement("div");e.className="JXGtext";e.style.color="#aaaaaa";e.style.backgroundColor="#f5f5f5";e.style.padding="2px";e.style.position="absolute";e.style.fontSize="10px";e.style.cursor="pointer";e.style.zIndex="100";this.container.appendChild(e);e.style.right="5px";e.style.bottom="5px";var h=this.container.ownerDocument.createElement("span");e.appendChild(h);h.innerHTML="&nbsp;&ndash;&nbsp;";JXG.addEvent(h,"click",j.zoomOut,j);var g=this.container.ownerDocument.createElement("span");e.appendChild(g);g.innerHTML="&nbsp;o&nbsp;";JXG.addEvent(g,"click",j.zoom100,j);var d=this.container.ownerDocument.createElement("span");e.appendChild(d);d.innerHTML="&nbsp;+&nbsp;";JXG.addEvent(d,"click",j.zoomIn,j);var l=this.container.ownerDocument.createElement("span");e.appendChild(l);l.innerHTML="&nbsp;&larr;&nbsp;";JXG.addEvent(l,"click",j.clickLeftArrow,j);var k=this.container.ownerDocument.createElement("span");e.appendChild(k);k.innerHTML="&nbsp;&uarr;&nbsp;";JXG.addEvent(k,"click",j.clickUpArrow,j);var b=this.container.ownerDocument.createElement("span");e.appendChild(b);b.innerHTML="&nbsp;&darr;&nbsp;";JXG.addEvent(b,"click",j.clickDownArrow,j);var f=this.container.ownerDocument.createElement("span");e.appendChild(f);f.innerHTML="&nbsp;&rarr;&nbsp;";JXG.addEvent(f,"click",j.clickRightArrow,j)};JXG.AbstractRenderer.prototype.getElementById=function(b){return document.getElementById(b)};JXG.FileReader=new function(){this.parseFileContent=function(b,d,g){this.request=false;var f;try{this.request=new XMLHttpRequest();if(g.toLowerCase()=="raw"){this.request.overrideMimeType("text/plain; charset=iso-8859-1")}else{this.request.overrideMimeType("text/xml; charset=iso-8859-1")}}catch(f){try{this.request=new ActiveXObject("Msxml2.XMLHTTP")}catch(f){try{this.request=new ActiveXObject("Microsoft.XMLHTTP")}catch(f){this.request=false}}}if(!this.request){alert("AJAX not activated!");return}this.request.open("GET",b,true);if(g.toLowerCase()=="raw"){this.cbp=function(){var e=this.request;if(e.readyState==4){d(e.responseText)}}}else{this.cbp=function(){var e=this.request;if(e.readyState==4){this.parseString(e.responseText,d,g,b)}}}this.cb=JXG.bind(this.cbp,this);this.request.onreadystatechange=this.cb;this.request.send(null)};this.cleanWhitespace=function(b){var d=b.firstChild;while(d!=null){if(d.nodeType==3&&!/\S/.test(d.nodeValue)){b.removeChild(d)}else{if(d.nodeType==1){this.cleanWhitespace(d)}}d=d.nextSibling}};this.stringToXMLTree=function(d){if(typeof DOMParser=="undefined"){DOMParser=function(){};DOMParser.prototype.parseFromString=function(g,h){if(typeof ActiveXObject!="undefined"){var f=new ActiveXObject("MSXML.DomDocument");f.loadXML(g);return f}}}var e=new DOMParser();var b=e.parseFromString(d,"text/xml");this.cleanWhitespace(b);return b};this.parseString=function(f,e,g,d){if(g.toLowerCase()=="geonext"){f=JXG.GeonextReader.prepareString(f)}if(g.toLowerCase()=="geogebra"){f=JXG.GeogebraReader.prepareString(f)}if(g.toLowerCase()=="intergeo"){f=JXG.IntergeoReader.prepareString(f)}e.xmlString=f;var b=this.stringToXMLTree(f);this.readElements(b,e,g)};this.readElements=function(b,d,e){d.suspendUpdate();if(e.toLowerCase()=="geonext"){if(b.getElementsByTagName("GEONEXT").length!=0){JXG.GeonextReader.readGeonext(b,d)}}else{if(b.getElementsByTagName("geogebra").length!=0){JXG.GeogebraReader.readGeogebra(b,d)}else{if(e.toLowerCase()=="intergeo"){JXG.IntergeoReader.readIntergeo(b,d)}}}d.unsuspendUpdate();d.afterLoad()}};JXG.GeonextReader=new function(){this.changeOriginIds=function(b,d){if((d=="gOOe0")||(d=="gXOe0")||(d=="gYOe0")||(d=="gXLe0")||(d=="gYLe0")){return b.id+d}else{return d}};this.colorProperties=function(d,b){d.colorStroke=b.getElementsByTagName("color")[0].getElementsByTagName("stroke")[0].firstChild.data;d.highlightStrokeColor=b.getElementsByTagName("color")[0].getElementsByTagName("lighting")[0].firstChild.data;d.colorFill=b.getElementsByTagName("color")[0].getElementsByTagName("fill")[0].firstChild.data;d.colorLabel=b.getElementsByTagName("color")[0].getElementsByTagName("label")[0].firstChild.data;d.colorDraft=b.getElementsByTagName("color")[0].getElementsByTagName("draft")[0].firstChild.data;return d};this.firstLevelProperties=function(g,e){var b=e.childNodes;for(var f=0;f<b.length;f++){if(b[f].firstChild!=null&&b[f].nodeName!="data"&&b[f].nodeName!="straight"){var d=b[f].nodeName;g[d]=b[f].firstChild.data}}return g};this.boardProperties=function(d,b){return d};this.defProperties=function(d,b){if(b.nodeType==3||b.nodeType==8){return null}d.ident=b.nodeName;if(d.ident=="text"||d.ident=="intersection"||d.ident=="composition"){d.name=""}else{d.name=b.getElementsByTagName("name")[0].firstChild.data}d.id=b.getElementsByTagName("id")[0].firstChild.data;return d};this.visualProperties=function(d,b){d.visible=b.getElementsByTagName("visible")[0].firstChild.data;d.trace=b.getElementsByTagName("trace")[0].firstChild.data;return d};this.readNodes=function(j,f,d,g){var e;var b=f.getElementsByTagName(d)[0].childNodes;for(var h=0;h<b.length;h++){if(b[h].firstChild!=null){if(g!=null){e=g+JXG.capitalize(b[h].nodeName)}else{e=b[h].nodeName}j[e]=b[h].firstChild.data}}return j};this.subtreeToString=function(b){try{return(new XMLSerializer()).serializeToString(b)}catch(d){return b.xml}return null};this.readImage=function(e){var d="";var b=e;if(b!=null){d=b.data;while(b.nextSibling!=null){b=b.nextSibling;d+=b.data}}return d};this.parseImage=function(l,k,b,o,n,p,j,f){if(k==null){return null}if(k.getElementsByTagName("src")[0]!=null){var s="src"}else{if(k.getElementsByTagName("image")[0]!=null){var s="image"}else{return null}}var e=this.readImage(k.getElementsByTagName(s)[0].firstChild);if(e!=""){if(s=="src"){var o=k.getElementsByTagName("x")[0].firstChild.data;var n=k.getElementsByTagName("y")[0].firstChild.data;var p=k.getElementsByTagName("width")[0].firstChild.data;var j=k.getElementsByTagName("height")[0].firstChild.data}else{var g=document.createElement("img");g.setAttribute("id","tmpimg");g.style.display="none";document.getElementsByTagName("body")[0].appendChild(g);g.setAttribute("src","data:image/png;base64,"+e);var r=g.width;var q=g.height;r=(r==0)?3:r;q=(q==0)?3:q;n-=q*p/r*0.5;j=q*p/r;document.getElementsByTagName("body")[0].removeChild(g)}if(f!=null){var d=f.id+"_image"}else{var d=false}var m=new JXG.Image(l,e,[o,n],[p,j],b,d,false,f);return m}};this.readConditions=function(h,g){g.conditions="";if(h!=null){for(var d=0;d<h.getElementsByTagName("data").length;d++){var f;var j;var b=h.getElementsByTagName("data")[d];f=JXG.GeonextReader.subtreeToString(b);g.conditions+=f}}};this.printDebugMessage=function(b,f,e,d){};this.readGeonext=function(u,m){var o={};boardData=u.getElementsByTagName("board")[0];o.ident="board";o.id=boardData.getElementsByTagName("id")[0].firstChild.data;o.width=boardData.getElementsByTagName("width")[0].firstChild.data;o.height=boardData.getElementsByTagName("height")[0].firstChild.data;o.fontSize=(boardData.getElementsByTagName("fontsize")[0]!=null)?document.body.style.fontSize=boardData.getElementsByTagName("fontsize")[0].firstChild.data:document.body.style.fontSize;o.modus=boardData.getElementsByTagName("modus")[0].firstChild.data;o.originX=boardData.getElementsByTagName("coordinates")[0].getElementsByTagName("origin")[0].getElementsByTagName("x")[0].firstChild.data;o.originY=boardData.getElementsByTagName("coordinates")[0].getElementsByTagName("origin")[0].getElementsByTagName("y")[0].firstChild.data;o.zoomX=boardData.getElementsByTagName("coordinates")[0].getElementsByTagName("zoom")[0].getElementsByTagName("x")[0].firstChild.data;o.zoomY=boardData.getElementsByTagName("coordinates")[0].getElementsByTagName("zoom")[0].getElementsByTagName("y")[0].firstChild.data;o.unitX=boardData.getElementsByTagName("coordinates")[0].getElementsByTagName("unit")[0].getElementsByTagName("x")[0].firstChild.data;o.unitY=boardData.getElementsByTagName("coordinates")[0].getElementsByTagName("unit")[0].getElementsByTagName("y")[0].firstChild.data;o.viewportTop=boardData.getElementsByTagName("coordinates")[0].getElementsByTagName("viewport")[0].getElementsByTagName("top")[0].firstChild.data;o.viewportLeft=boardData.getElementsByTagName("coordinates")[0].getElementsByTagName("viewport")[0].getElementsByTagName("left")[0].firstChild.data;o.viewportBottom=boardData.getElementsByTagName("coordinates")[0].getElementsByTagName("viewport")[0].getElementsByTagName("bottom")[0].firstChild.data;o.viewportRight=boardData.getElementsByTagName("coordinates")[0].getElementsByTagName("viewport")[0].getElementsByTagName("right")[0].firstChild.data;this.readConditions(boardData.getElementsByTagName("conditions")[0],o);m.origin={};m.origin.usrCoords=[1,0,0];m.origin.scrCoords=[1,1*o.originX,1*o.originY];m.zoomX=1*o.zoomX;m.zoomY=1*o.zoomY;m.unitX=1*o.unitX;m.unitY=1*o.unitY;m.fontSize=1*o.fontSize;m.geonextCompatibilityMode=true;delete (JXG.JSXGraph.boards[m.id]);m.id=o.id;JXG.JSXGraph.boards[m.id]=m;m.initGeonextBoard();m.renderer.enhancedRendering=true;JXG.GeonextReader.parseImage(m,boardData.getElementsByTagName("file")[0],"images");var f=(boardData.getElementsByTagName("coordinates")[0].getElementsByTagName("snap")[0].firstChild.data=="true")?m.snapToGrid=true:null;var j=(boardData.getElementsByTagName("grid")[1].getElementsByTagName("x")[0].firstChild.data)?m.gridX=boardData.getElementsByTagName("grid")[1].getElementsByTagName("x")[0].firstChild.data*1:null;var h=(boardData.getElementsByTagName("grid")[1].getElementsByTagName("y")[0].firstChild.data)?m.gridY=boardData.getElementsByTagName("grid")[1].getElementsByTagName("y")[0].firstChild.data*1:null;m.calculateSnapSizes();var n=boardData.getElementsByTagName("grid")[1].getElementsByTagName("dash")[0].firstChild.data;m.gridDash=m.algebra.str2Bool(n);var p=boardData.getElementsByTagName("grid")[1].getElementsByTagName("color")[0].firstChild.data;var l;if(p.length=="9"&&p.substr(0,1)=="#"){l=p.substr(7,2);l=parseInt(l.toUpperCase(),16)/255;p=p.substr(0,7)}else{l="1"}m.gridColor=p;m.gridOpacity=l;var b=(boardData.getElementsByTagName("coordinates")[0].getElementsByTagName("grid")[0].firstChild.data=="true")?m.renderer.drawGrid(m):null;if(boardData.getElementsByTagName("coordinates")[0].getElementsByTagName("coord")[0].firstChild.data=="true"){var e=m.createElement("axis",[[0,0],[1,0]]);e.setProperty("strokeColor:"+e.visProp.strokeColor,"strokeWidth:"+e.visProp.strokeWidth,"fillColor:none","highlightStrokeColor:"+e.visProp.highlightStrokeColor,"highlightFillColor:none","visible:true");var d=m.createElement("axis",[[0,0],[0,1]]);d.setProperty("strokeColor:"+d.visProp.strokeColor,"strokeWidth:"+d.visProp.strokeWidth,"fillColor:none","highlightStrokeColor:"+d.visProp.highlightStrokeColor,"highlightFillColor:none","visible:true")}var r=boardData.getElementsByTagName("background")[0].getElementsByTagName("color")[0].firstChild.data;var k=1;if(r.length=="9"&&r.substr(0,1)=="#"){k=r.substr(7,2);r=r.substr(0,7)}m.containerObj.style.backgroundColor=r;var g=u.getElementsByTagName("elements")[0].childNodes;for(var q=0;q<g.length;q++){(function(T){var U=g[T];var ak={};ak=JXG.GeonextReader.defProperties(ak,U);if(ak==null){return}switch(U.nodeName.toLowerCase()){case"point":ak=JXG.GeonextReader.boardProperties(ak,U);ak=JXG.GeonextReader.colorProperties(ak,U);ak=JXG.GeonextReader.visualProperties(ak,U);ak=JXG.GeonextReader.firstLevelProperties(ak,U);ak=JXG.GeonextReader.readNodes(ak,U,"data");ak.fixed=U.getElementsByTagName("fix")[0].firstChild.data;JXG.GeonextReader.parseImage(m,U.getElementsByTagName("image")[0],"points");try{W=new JXG.Point(m,[1*ak.x,1*ak.y],ak.id,ak.name,true);W.setProperty("strokeColor:"+ak.colorStroke,"strokeWidth:"+ak.strokewidth,"fillColor:"+ak.colorStroke,"highlightStrokeColor:"+ak.highlightStrokeColor,"highlightFillColor:"+ak.highlightStrokeColor,"labelColor:"+ak.colorLabel,"visible:"+ak.visible,"fixed:"+ak.fixed,"draft:"+ak.draft);W.setStyle(1*ak.style);W.traced=(ak.trace=="false")?false:true;JXG.GeonextReader.printDebugMessage("debug",ak,U.nodeName,"OK")}catch(ah){}break;case"line":ak=JXG.GeonextReader.boardProperties(ak,U);ak=JXG.GeonextReader.colorProperties(ak,U);ak=JXG.GeonextReader.visualProperties(ak,U);ak=JXG.GeonextReader.firstLevelProperties(ak,U);ak=JXG.GeonextReader.readNodes(ak,U,"data");ak=JXG.GeonextReader.readNodes(ak,U,"straight","straight");ak.first=JXG.GeonextReader.changeOriginIds(m,ak.first);ak.last=JXG.GeonextReader.changeOriginIds(m,ak.last);var Z=new JXG.Line(m,ak.first,ak.last,ak.id,ak.name);var P=Z.point1.coords.usrCoords[1];var O=Z.point1.coords.usrCoords[2];var Q=Z.point1.coords.distance(JXG.COORDS_BY_USER,Z.point2.coords);var ad=0;Z.image=JXG.GeonextReader.parseImage(m,U,"lines",P,O,Q,ad,Z);ak.straightFirst=(ak.straightFirst=="false")?false:true;ak.straightLast=(ak.straightLast=="false")?false:true;Z.setStraight(ak.straightFirst,ak.straightLast);Z.setProperty("strokeColor:"+ak.colorStroke,"strokeWidth:"+ak.strokewidth,"fillColor:"+ak.colorFill,"highlightStrokeColor:"+ak.highlightStrokeColor,"highlightFillColor:"+ak.colorFill,"visible:"+ak.visible,"dash:"+ak.dash,"draft:"+ak.draft);Z.traced=(ak.trace=="false")?false:true;JXG.GeonextReader.printDebugMessage("debug",ak,U.nodeName,"OK");break;case"circle":ak=JXG.GeonextReader.boardProperties(ak,U);ak=JXG.GeonextReader.colorProperties(ak,U);ak=JXG.GeonextReader.visualProperties(ak,U);ak=JXG.GeonextReader.firstLevelProperties(ak,U);ak.midpoint=U.getElementsByTagName("data")[0].getElementsByTagName("midpoint")[0].firstChild.data;JXG.GeonextReader.parseImage(m,U.getElementsByTagName("image")[0],"circles");if(U.getElementsByTagName("data")[0].getElementsByTagName("radius").length>0){ak.radiuspoint=U.getElementsByTagName("data")[0].getElementsByTagName("radius")[0].firstChild.data;ak.radius=null;ak.method="twoPoints"}else{if(U.getElementsByTagName("data")[0].getElementsByTagName("radiusvalue").length>0){ak.radiuspoint=null;ak.radius=U.getElementsByTagName("data")[0].getElementsByTagName("radiusvalue")[0].firstChild.data;ak.radiusnum=U.getElementsByTagName("data")[0].getElementsByTagName("radiusnum")[0].firstChild.data;ak.method="pointRadius"}}if(ak.method=="twoPoints"){if(m.objects[ak.radiuspoint].type==JXG.OBJECT_TYPE_LINE){ak.method="pointLine";ak.radiuspoint=JXG.GeonextReader.changeOriginIds(m,ak.radiuspoint)}else{if(m.objects[ak.radiuspoint].type==JXG.OBJECT_TYPE_CIRCLE){ak.method="pointCircle"}}}if(ak.method=="pointRadius"){ak.midpoint=JXG.GeonextReader.changeOriginIds(m,ak.midpoint);var ai=new JXG.Circle(m,ak.method,ak.midpoint,ak.radius,ak.id,ak.name)}else{ak.midpoint=JXG.GeonextReader.changeOriginIds(m,ak.midpoint);var ai=new JXG.Circle(m,ak.method,ak.midpoint,ak.radiuspoint,ak.id,ak.name)}ai.setProperty("strokeColor:"+ak.colorStroke,"strokeWidth:"+ak.strokewidth,"fillColor:"+ak.colorFill,"highlightStrokeColor:"+ak.highlightStrokeColor,"highlightFillColor:"+ak.colorFill,"visible:"+ak.visible,"dash:"+ak.dash,"draft:"+ak.draft);ai.traced=(ak.trace=="false")?false:true;JXG.GeonextReader.printDebugMessage("debug",ak,U.nodeName,"OK");break;case"slider":ak=JXG.GeonextReader.colorProperties(ak,U);ak=JXG.GeonextReader.boardProperties(ak,U);ak=JXG.GeonextReader.visualProperties(ak,U);ak=JXG.GeonextReader.firstLevelProperties(ak,U);ak=JXG.GeonextReader.readNodes(ak,U,"data");ak.fixed=U.getElementsByTagName("fix")[0].firstChild.data;ak=JXG.GeonextReader.readNodes(ak,U,"animate","animate");JXG.GeonextReader.parseImage(m,U.getElementsByTagName("image")[0],"points");try{var W=new JXG.Point(m,[1*ak.x,1*ak.y],ak.id,ak.name,true);ak.parent=JXG.GeonextReader.changeOriginIds(m,ak.parent);W.makeGlider(ak.parent);W.setProperty("strokeColor:"+ak.colorStroke,"strokeWidth:"+ak.strokewidth,"fillColor:"+ak.colorStroke,"highlightStrokeColor:"+ak.highlightStrokeColor,"highlightFillColor:"+ak.highlightStrokeColor,"visible:"+ak.visible,"fixed:"+ak.fixed,"labelColor:"+ak.colorLabel,"draft:"+ak.draft);W.onPolygon=m.algebra.str2Bool(ak.onpolygon);W.traced=(ak.trace=="false")?false:true;W.setStyle(1*ak.style);JXG.GeonextReader.printDebugMessage("debug",ak,U.nodeName,"OK")}catch(ah){}break;case"cas":ak=JXG.GeonextReader.boardProperties(ak,U);ak=JXG.GeonextReader.colorProperties(ak,U);ak=JXG.GeonextReader.visualProperties(ak,U);ak=JXG.GeonextReader.firstLevelProperties(ak,U);ak.fixed=U.getElementsByTagName("fix")[0].firstChild.data;ak=JXG.GeonextReader.readNodes(ak,U,"data");JXG.GeonextReader.parseImage(m,U.getElementsByTagName("image")[0],"points");var W=new JXG.Point(m,[1*ak.xval,1*ak.yval],ak.id,ak.name,true);W.addConstraint([ak.x,ak.y]);W.setProperty("strokeColor:"+ak.colorStroke,"strokeWidth:"+ak.strokewidth,"fillColor:"+ak.colorStroke,"highlightStrokeColor:"+ak.highlightStrokeColor,"highlightFillColor:"+ak.highlightStrokeColor,"visible:"+ak.visible,"fixed:"+ak.fixed,"labelColor:"+ak.colorLabel,"draft:"+ak.draft);W.traced=(ak.trace=="false")?false:true;W.setStyle(1*ak.style);JXG.GeonextReader.printDebugMessage("debug",ak,U.nodeName,"OK");break;case"intersection":ak=JXG.GeonextReader.readNodes(ak,U,"data");ak.outputFirstId=U.getElementsByTagName("first")[1].getElementsByTagName("id")[0].firstChild.data;ak.outputFirstName=U.getElementsByTagName("first")[1].getElementsByTagName("name")[0].firstChild.data;ak.outputFirstVisible=U.getElementsByTagName("first")[1].getElementsByTagName("visible")[0].firstChild.data;ak.outputFirstTrace=U.getElementsByTagName("first")[1].getElementsByTagName("trace")[0].firstChild.data;ak.outputFirstFixed=U.getElementsByTagName("first")[1].getElementsByTagName("fix")[0].firstChild.data;ak.outputFirstStyle=U.getElementsByTagName("first")[1].getElementsByTagName("style")[0].firstChild.data;ak.outputFirstStrokewidth=U.getElementsByTagName("first")[1].getElementsByTagName("strokewidth")[0].firstChild.data;ak.outputFirstColorStroke=U.getElementsByTagName("first")[1].getElementsByTagName("color")[0].getElementsByTagName("stroke")[0].firstChild.data;ak.outputFirstHighlightStrokeColor=U.getElementsByTagName("first")[1].getElementsByTagName("color")[0].getElementsByTagName("lighting")[0].firstChild.data;ak.outputFirstColorFill=U.getElementsByTagName("first")[1].getElementsByTagName("color")[0].getElementsByTagName("fill")[0].firstChild.data;ak.outputFirstColorLabel=U.getElementsByTagName("first")[1].getElementsByTagName("color")[0].getElementsByTagName("label")[0].firstChild.data;ak.outputFirstColorDraft=U.getElementsByTagName("first")[1].getElementsByTagName("color")[0].getElementsByTagName("draft")[0].firstChild.data;ak.first=JXG.GeonextReader.changeOriginIds(m,ak.first);ak.last=JXG.GeonextReader.changeOriginIds(m,ak.last);if((((m.objects[ak.first]).type==(m.objects[ak.last]).type)&&((m.objects[ak.first]).type==JXG.OBJECT_TYPE_LINE||(m.objects[ak.first]).type==JXG.OBJECT_TYPE_ARROW))||(((m.objects[ak.first]).type==JXG.OBJECT_TYPE_LINE)&&((m.objects[ak.last]).type==JXG.OBJECT_TYPE_ARROW))||(((m.objects[ak.last]).type==JXG.OBJECT_TYPE_LINE)&&((m.objects[ak.first]).type==JXG.OBJECT_TYPE_ARROW))){var Y=new JXG.Intersection(m,ak.id,m.objects[ak.first],m.objects[ak.last],ak.outputFirstId,"",ak.outputFirstName,"");if(ak.outputFirstVisible=="false"){Y.hideElement()}Y.p.setProperty("strokeColor:"+ak.outputFirstColorStroke,"strokeWidth:"+ak.outputFirstStrokewidth,"fillColor:"+ak.outputFirstColorStroke,"highlightStrokeColor:"+ak.outputFirstHighlightStrokeColor,"highlightFillColor:"+ak.outputFirstHighlightStrokeColor,"visible:"+ak.outputFirstVisible,"labelColor:"+ak.outputFirstColorLabel,"draft:"+ak.draft);Y.p.setStyle(1*ak.outputFirstStyle);Y.p.traced=(ak.outputFirstTrace=="false")?false:true}else{ak.outputLastId=U.getElementsByTagName("last")[1].getElementsByTagName("id")[0].firstChild.data;ak.outputLastName=U.getElementsByTagName("last")[1].getElementsByTagName("name")[0].firstChild.data;ak.outputLastVisible=U.getElementsByTagName("last")[1].getElementsByTagName("visible")[0].firstChild.data;ak.outputLastTrace=U.getElementsByTagName("last")[1].getElementsByTagName("trace")[0].firstChild.data;ak.outputLastFixed=U.getElementsByTagName("last")[1].getElementsByTagName("fix")[0].firstChild.data;ak.outputLastStyle=U.getElementsByTagName("last")[1].getElementsByTagName("style")[0].firstChild.data;ak.outputLastStrokewidth=U.getElementsByTagName("last")[1].getElementsByTagName("strokewidth")[0].firstChild.data;var V=U.getElementsByTagName("last")[1].getElementsByTagName("color")[0];ak.outputLastColorStroke=V.getElementsByTagName("stroke")[0].firstChild.data;ak.outputLastHighlightStrokeColor=V.getElementsByTagName("lighting")[0].firstChild.data;ak.outputLastColorFill=V.getElementsByTagName("fill")[0].firstChild.data;ak.outputLastColorLabel=V.getElementsByTagName("label")[0].firstChild.data;ak.outputLastColorDraft=V.getElementsByTagName("draft")[0].firstChild.data;var Y=new JXG.Intersection(m,ak.id,m.objects[ak.first],m.objects[ak.last],ak.outputFirstId,ak.outputLastId,ak.outputFirstName,ak.outputLastName);Y.p1.setProperty("strokeColor:"+ak.outputFirstColorStroke,"strokeWidth:"+ak.outputFirstStrokewidth,"fillColor:"+ak.outputFirstColorStroke,"highlightStrokeColor:"+ak.outputFirstHighlightStrokeColor,"highlightFillColor:"+ak.outputFirstHighlightStrokeColor,"visible:"+ak.outputFirstVisible,"labelColor:"+ak.outputFirstColorLabel,"draft:"+ak.draft);Y.p1.setStyle(1*ak.outputFirstStyle);Y.p1.traced=(ak.outputFirstTrace=="false")?false:true;Y.p2.setProperty("strokeColor:"+ak.outputLastColorStroke,"strokeWidth:"+ak.outputLastStrokewidth,"fillColor:"+ak.outputLastColorStroke,"highlightStrokeColor:"+ak.outputLastHighlightStrokeColor,"highlightFillColor:"+ak.outputLastHighlightStrokeColor,"visible:"+ak.outputLastVisible,"labelColor:"+ak.outputLastColorLabel,"draft:"+ak.draft);Y.p2.setStyle(1*ak.outputLastStyle);Y.p2.traced=(ak.outputLastTrace=="false")?false:true;if(ak.outputFirstVisible=="false"){if(ak.outputLastVisible=="false"){Y.hideElement()}else{Y.p1.hideElement()}}else{if(ak.outputLastVisible=="false"){Y.p2.hideElement()}}}JXG.GeonextReader.printDebugMessage("debug",ak,U.nodeName,"OK");break;case"composition":ak=JXG.GeonextReader.readNodes(ak,U,"data");ak=JXG.GeonextReader.firstLevelProperties(ak,U);switch(ak.type){case"210070":ak.typeName="ARROW_PARALLEL";break;case"210080":ak.typeName="BISECTOR";break;case"210090":ak.typeName="CIRCUMCIRCLE";break;case"210100":ak.typeName="CIRCUMCIRCLE_CENTER";break;case"210110":ak.typeName="MIDPOINT";break;case"210120":ak.typeName="MIRROR_LINE";break;case"210125":ak.typeName="MIRROR_POINT";break;case"210130":ak.typeName="NORMAL";break;case"210140":ak.typeName="PARALLEL";break;case"210150":ak.typeName="PARALLELOGRAM_POINT";break;case"210160":ak.typeName="PERPENDICULAR";break;case"210170":ak.typeName="PERPENDICULAR_POINT";break;case"210180":ak.typeName="ROTATION";break;case"210190":ak.typeName="SECTOR";break}ak.defEl=[];var X=0;for(var ab=0;ab<U.getElementsByTagName("data")[0].getElementsByTagName("input").length;ab++){ak.defEl[ab]=U.getElementsByTagName("data")[0].getElementsByTagName("input")[ab].firstChild.data;X=ab+1}ak.outputId=U.getElementsByTagName("output")[0].getElementsByTagName("id")[0].firstChild.data;ak.outputName=U.getElementsByTagName("output")[0].getElementsByTagName("name")[0].firstChild.data;ak.outputVisible=U.getElementsByTagName("output")[0].getElementsByTagName("visible")[0].firstChild.data;ak.outputTrace=U.getElementsByTagName("output")[0].getElementsByTagName("trace")[0].firstChild.data;ak.outputStrokewidth=ak=JXG.GeonextReader.readNodes(ak,U,"output","output");ak.outputName=U.getElementsByTagName("output")[0].getElementsByTagName("name")[0].firstChild.data;ak.outputDash=U.getElementsByTagName("output")[0].getElementsByTagName("dash")[0].firstChild.data;ak.outputDraft=U.getElementsByTagName("output")[0].getElementsByTagName("draft")[0].firstChild.data;ak.outputStrokewidth=U.getElementsByTagName("output")[0].getElementsByTagName("strokewidth")[0].firstChild.data;ak.outputColorStroke=U.getElementsByTagName("output")[0].getElementsByTagName("color")[0].getElementsByTagName("stroke")[0].firstChild.data;ak.outputHighlightStrokeColor=U.getElementsByTagName("output")[0].getElementsByTagName("color")[0].getElementsByTagName("lighting")[0].firstChild.data;ak.outputColorFill=U.getElementsByTagName("output")[0].getElementsByTagName("color")[0].getElementsByTagName("fill")[0].firstChild.data;ak.outputColorLabel=U.getElementsByTagName("output")[0].getElementsByTagName("color")[0].getElementsByTagName("label")[0].firstChild.data;ak.outputColorDraft=U.getElementsByTagName("output")[0].getElementsByTagName("color")[0].getElementsByTagName("draft")[0].firstChild.data;ak.defEl[0]=JXG.GeonextReader.changeOriginIds(m,ak.defEl[0]);ak.defEl[1]=JXG.GeonextReader.changeOriginIds(m,ak.defEl[1]);ak.defEl[2]=JXG.GeonextReader.changeOriginIds(m,ak.defEl[2]);if(ak.typeName=="MIDPOINT"){if(X==2){m.addMidpoint(ak.defEl[0],ak.defEl[1],ak.outputId,ak.outputName)}else{if(X==1){m.addMidpoint(m.objects[ak.defEl[0]].point1.id,m.objects[ak.defEl[0]].point2.id,ak.outputId,ak.outputName)}}}else{if(ak.typeName=="NORMAL"){m.addNormal(ak.defEl[1],ak.defEl[0],ak.outputId,ak.outputName)}else{if(ak.typeName=="PARALLEL"){m.addParallel(ak.defEl[1],ak.defEl[0],ak.outputId,ak.outputName)}else{if(ak.typeName=="CIRCUMCIRCLE"){var R=U.getElementsByTagName("output")[1].getElementsByTagName("id")[0].firstChild.data;var E=U.getElementsByTagName("output")[1].getElementsByTagName("name")[0].firstChild.data;m.addCircumcenter(ak.defEl[0],ak.defEl[1],ak.defEl[2],ak.outputId,ak.outputName,R,E)}else{if(ak.typeName=="CIRCUMCIRCLE_CENTER"){m.addCircumcenterMidpoint(ak.defEl[0],ak.defEl[1],ak.defEl[2],ak.outputId,ak.outputName)}else{if(ak.typeName=="BISECTOR"){m.addAngleBisector(ak.defEl[0],ak.defEl[1],ak.defEl[2],ak.outputId,ak.outputName)}else{if(ak.typeName=="MIRROR_LINE"){m.addReflection(ak.defEl[1],ak.defEl[0],ak.outputId,ak.outputName)}else{if(ak.typeName=="MIRROR_POINT"){m.addRotation(ak.defEl[0],ak.defEl[1],Math.PI,ak.outputId,ak.outputName)}else{if(ak.typeName=="PARALLELOGRAM_POINT"){if(ak.defEl.length==2){m.addParallelPoint(JXG.GetReferenceFromParameter(ak.defEl[0]).point1,JXG.GetReferenceFromParameter(ak.defEl[0]).point2,ak.defEl[1],ak.outputId,ak.outputName)}else{m.addParallelPoint(ak.defEl[0],ak.defEl[1],ak.defEl[2],ak.outputId,ak.outputName)}}else{if(ak.typeName=="SECTOR"){JXG.GeonextReader.parseImage(m,U.getElementsByTagName("image")[0],"sectors");var J=[];var S=[];var L=[];var N=[];var ac=[];var aa=[];var C=[];var I=[];var v=[];var H=[];var F=[];for(var ab=0;ab<U.getElementsByTagName("output").length;ab++){J[ab]=U.getElementsByTagName("output")[ab].getElementsByTagName("id")[0].firstChild.data;J[ab]=JXG.GeonextReader.changeOriginIds(m,J[ab]);S[ab]=U.getElementsByTagName("output")[ab].getElementsByTagName("name")[0];L[ab]=U.getElementsByTagName("output")[ab].getElementsByTagName("visible")[0].firstChild.data;N[ab]=U.getElementsByTagName("output")[ab].getElementsByTagName("trace")[0].firstChild.data;ac[ab]=U.getElementsByTagName("output")[ab].getElementsByTagName("dash")[0].firstChild.data;aa[ab]=U.getElementsByTagName("output")[ab].getElementsByTagName("draft")[0].firstChild.data;C[ab]=U.getElementsByTagName("output")[ab].getElementsByTagName("strokewidth")[0].firstChild.data;var V=U.getElementsByTagName("output")[ab].getElementsByTagName("color")[0];I[ab]=V.getElementsByTagName("stroke")[0].firstChild.data;v[ab]=V.getElementsByTagName("lighting")[0].firstChild.data;H[ab]=V.getElementsByTagName("fill")[0].firstChild.data;F[ab]=V.getElementsByTagName("label")[0].firstChild.data}var ae=new JXG.Sector(m,ak.defEl[0],ak.defEl[1],ak.defEl[2],[J[0],J[1],J[2],J[3]],[S[0].firstChild.data,S[1].firstChild.data,S[2].firstChild.data,S[3].firstChild.data],ak.id);var ag=J[0];m.objects[ag].setProperty("strokeColor:"+I[0],"strokeWidth:"+C[0],"fillColor:"+H[0],"highlightStrokeColor:"+v[0],"highlightFillColor:"+H[0],"visible:"+L[0],"dash:"+ac[0],"draft:"+aa[0]);m.objects[ag].traced=(N[0]=="false")?false:true;ak.firstArrow=U.getElementsByTagName("output")[0].getElementsByTagName("firstarrow")[0].firstChild.data;ak.lastArrow=U.getElementsByTagName("output")[0].getElementsByTagName("lastarrow")[0].firstChild.data;ak.firstArrow=(ak.firstArrow=="false")?false:true;ak.lastArrow=(ak.lastArrow=="false")?false:true;m.objects[ag].setArrow(ak.firstArrow,ak.lastArrow);var K=J[1];ak.fixed=U.getElementsByTagName("output")[1].getElementsByTagName("fix")[0].firstChild.data;m.objects[K].setProperty("strokeColor:"+I[1],"strokeWidth:"+C[1],"fillColor:"+I[1],"highlightStrokeColor:"+v[1],"highlightFillColor:"+v[1],"visible:"+L[1],"fixed:"+ak.fixed,"labelColor:"+F[1],"draft:"+aa[1]);ak.style=U.getElementsByTagName("output")[1].getElementsByTagName("style")[0].firstChild.data;m.objects[K].setStyle(1*ak.style);m.objects[K].traced=(N[1]=="false")?false:true;var D=J[2];var V=U.getElementsByTagName("output")[2].getElementsByTagName("straight")[0];ak.straightFirst=V.getElementsByTagName("first")[0].firstChild.data;ak.straightLast=V.getElementsByTagName("last")[0].firstChild.data;ak.straightFirst=(ak.straightFirst=="false")?false:true;ak.straightLast=(ak.straightLast=="false")?false:true;m.objects[D].setStraight(ak.straightFirst,ak.straightLast);m.objects[D].setProperty("strokeColor:"+I[2],"strokeWidth:"+C[2],"fillColor:"+H[2],"highlightStrokeColor:"+v[2],"highlightFillColor:"+H[2],"visible:"+L[2],"dash:"+ac[2],"draft:"+aa[2]);m.objects[D].traced=(N[2]=="false")?false:true;var z=J[3];V=U.getElementsByTagName("output")[3].getElementsByTagName("straight")[0];ak.straightFirst=V.getElementsByTagName("first")[0].firstChild.data;ak.straightLast=V.getElementsByTagName("last")[0].firstChild.data;ak.straightFirst=(ak.straightFirst=="false")?false:true;ak.straightLast=(ak.straightLast=="false")?false:true;m.objects[z].setStraight(ak.straightFirst,ak.straightLast);m.objects[z].setProperty("strokeColor:"+I[3],"strokeWidth:"+C[3],"fillColor:"+H[3],"highlightStrokeColor:"+v[3],"highlightFillColor:"+H[3],"visible:"+L[3],"dash:"+ac[3],"draft:"+aa[3]);m.objects[z].traced=(N[3]=="false")?false:true}else{if(ak.typeName=="PERPENDICULAR"){var J=[];var S=[];var L=[];var N=[];var ac=[];var aa=[];var C=[];var I=[];var v=[];var H=[];var F=[];for(var ab=0;ab<U.getElementsByTagName("output").length;ab++){J[ab]=U.getElementsByTagName("output")[ab].getElementsByTagName("id")[0].firstChild.data;J[ab]=JXG.GeonextReader.changeOriginIds(m,J[ab]);S[ab]=U.getElementsByTagName("output")[ab].getElementsByTagName("name")[0];L[ab]=U.getElementsByTagName("output")[ab].getElementsByTagName("visible")[0].firstChild.data;N[ab]=U.getElementsByTagName("output")[ab].getElementsByTagName("trace")[0].firstChild.data;ac[ab]=U.getElementsByTagName("output")[ab].getElementsByTagName("dash")[0].firstChild.data;aa[ab]=U.getElementsByTagName("output")[ab].getElementsByTagName("draft")[0].firstChild.data;C[ab]=U.getElementsByTagName("output")[ab].getElementsByTagName("strokewidth")[0].firstChild.data;var V=U.getElementsByTagName("output")[ab].getElementsByTagName("color")[0];I[ab]=V.getElementsByTagName("stroke")[0].firstChild.data;v[ab]=V.getElementsByTagName("lighting")[0].firstChild.data;H[ab]=V.getElementsByTagName("fill")[0].firstChild.data;F[ab]=V.getElementsByTagName("label")[0].firstChild.data}ak.outputFixed=U.getElementsByTagName("output")[0].getElementsByTagName("fix")[0].firstChild.data;ak.outputStyle=U.getElementsByTagName("output")[0].getElementsByTagName("style")[0].firstChild.data;m.addPerpendicular(ak.defEl[1],ak.defEl[0],J[1],S[1].firstChild.data,J[0],S[0].firstChild.data);var M=J[0];m.objects[M].setProperty("strokeColor:"+I[0],"strokeWidth:"+C[0],"fillColor:"+I[0],"highlightStrokeColor:"+v[0],"highlightFillColor:"+v[0],"visible:"+L[0],"fixed:"+ak.outputFixed,"labelColor:"+F[0],"draft:"+aa[0]);m.objects[M].setStyle(1*ak.outputStyle);m.objects[M].traced=(N[0]=="false")?false:true;var A=J[1];m.objects[A].setProperty("strokeColor:"+I[1],"strokeWidth:"+C[1],"fillColor:"+H[1],"highlightStrokeColor:"+v[1],"highlightFillColor:"+H[1],"visible:"+L[1],"dash:"+ac[1],"draft:"+aa[1]);m.objects[A].traced=(N[1]=="false")?false:true}else{if(ak.typeName=="ARROW_PARALLEL"){var J=[];var S=[];var L=[];var N=[];var ac=[];var aa=[];var C=[];var I=[];var v=[];var H=[];var F=[];for(var ab=0;ab<U.getElementsByTagName("output").length;ab++){J[ab]=U.getElementsByTagName("output")[ab].getElementsByTagName("id")[0].firstChild.data;J[ab]=JXG.GeonextReader.changeOriginIds(m,J[ab]);S[ab]=U.getElementsByTagName("output")[ab].getElementsByTagName("name")[0];L[ab]=U.getElementsByTagName("output")[ab].getElementsByTagName("visible")[0].firstChild.data;N[ab]=U.getElementsByTagName("output")[ab].getElementsByTagName("trace")[0].firstChild.data;ac[ab]=U.getElementsByTagName("output")[ab].getElementsByTagName("dash")[0].firstChild.data;aa[ab]=U.getElementsByTagName("output")[ab].getElementsByTagName("draft")[0].firstChild.data;C[ab]=U.getElementsByTagName("output")[ab].getElementsByTagName("strokewidth")[0].firstChild.data;var V=U.getElementsByTagName("output")[ab].getElementsByTagName("color")[0];I[ab]=V.getElementsByTagName("stroke")[0].firstChild.data;v[ab]=V.getElementsByTagName("lighting")[0].firstChild.data;H[ab]=V.getElementsByTagName("fill")[0].firstChild.data;F[ab]=V.getElementsByTagName("label")[0].firstChild.data}ak.outputFixed=U.getElementsByTagName("output")[1].getElementsByTagName("fix")[0].firstChild.data;ak.outputStyle=U.getElementsByTagName("output")[1].getElementsByTagName("style")[0].firstChild.data;m.addArrowParallel(ak.defEl[1],ak.defEl[0],J[0],J[1],S[0].firstChild.data,S[1].firstChild.data);var G=J[0];m.objects[G].setProperty("strokeColor:"+I[0],"strokeWidth:"+C[0],"fillColor:"+H[0],"highlightStrokeColor:"+v[0],"highlightFillColor:"+H[0],"visible:"+L[0],"dash:"+ac[0],"draft:"+aa[0]);m.objects[G].traced=(N[0]=="false")?false:true;var M=J[1];m.objects[M].setProperty("strokeColor:"+I[1],"strokeWidth:"+C[1],"fillColor:"+I[1],"highlightStrokeColor:"+v[1],"highlightFillColor:"+v[1],"visible:"+L[1],"fixed:"+ak.outputFixed,"labelColor:"+F[1],"draft:"+aa[1]);m.objects[M].setStyle(1*ak.outputStyle);m.objects[M].traced=(N[1]=="false")?false:true}else{if(ak.typeName=="PERPENDICULAR_POINT"){m.addPerpendicularPoint(ak.defEl[1],ak.defEl[0],ak.outputId,ak.outputName)}else{throw ("GEONExT-Element "+ak.typeName+" not yet implemented")}}}}}}}}}}}}}if(ak.typeName=="MIDPOINT"||ak.typeName=="MIRROR_LINE"||ak.typeName=="CIRCUMCIRCLE_CENTER"||ak.typeName=="PERPENDICULAR_POINT"||ak.typeName=="MIRROR_POINT"||ak.typeName=="PARALLELOGRAM_POINT"){ak.outputFixed=U.getElementsByTagName("output")[0].getElementsByTagName("fix")[0].firstChild.data;ak.outputStyle=U.getElementsByTagName("output")[0].getElementsByTagName("style")[0].firstChild.data;m.objects[ak.outputId].setProperty("strokeColor:"+ak.outputColorStroke,"strokeWidth:"+ak.outputStrokewidth,"fillColor:"+ak.outputColorStroke,"highlightStrokeColor:"+ak.outputHighlightStrokeColor,"highlightFillColor:"+ak.outputHighlightStrokeColor,"visible:"+ak.outputVisible,"fixed:"+ak.outputFixed,"labelColor:"+ak.outputColorLabel,"draft:"+ak.outputDraft);m.objects[ak.outputId].setStyle(1*ak.outputStyle);m.objects[ak.outputId].traced=(ak.outputTrace=="false")?false:true}else{if(ak.typeName=="BISECTOR"||ak.typeName=="NORMAL"||ak.typeName=="PARALLEL"){var V=U.getElementsByTagName("output")[0].getElementsByTagName("straight")[0];ak.straightFirst=V.getElementsByTagName("first")[0].firstChild.data;ak.straightLast=V.getElementsByTagName("last")[0].firstChild.data;ak.straightFirst=(ak.straightFirst=="false")?false:true;ak.straightLast=(ak.straightLast=="false")?false:true;m.objects[ak.outputId].setStraight(ak.straightFirst,ak.straightLast);m.objects[ak.outputId].setProperty("strokeColor:"+ak.outputColorStroke,"strokeWidth:"+ak.outputStrokewidth,"fillColor:"+ak.outputColorFill,"highlightStrokeColor:"+ak.outputHighlightStrokeColor,"highlightFillColor:"+ak.outputColorFill,"visible:"+ak.outputVisible,"dash:"+ak.outputDash,"draft:"+ak.outputDraft);m.objects[ak.outputId].traced=(ak.outputTrace=="false")?false:true}else{if(ak.typeName=="CIRCUMCIRCLE"){var J=[];var S=[];var L=[];var N=[];var ac=[];var aa=[];var C=[];var I=[];var v=[];var H=[];var F=[];for(var ab=0;ab<U.getElementsByTagName("output").length;ab++){J[ab]=U.getElementsByTagName("output")[ab].getElementsByTagName("id")[0].firstChild.data;J[ab]=JXG.GeonextReader.changeOriginIds(m,J[ab]);S[ab]=U.getElementsByTagName("output")[ab].getElementsByTagName("name")[0];L[ab]=U.getElementsByTagName("output")[ab].getElementsByTagName("visible")[0].firstChild.data;N[ab]=U.getElementsByTagName("output")[ab].getElementsByTagName("trace")[0].firstChild.data;ac[ab]=U.getElementsByTagName("output")[ab].getElementsByTagName("dash")[0].firstChild.data;aa[ab]=U.getElementsByTagName("output")[ab].getElementsByTagName("draft")[0].firstChild.data;C[ab]=U.getElementsByTagName("output")[ab].getElementsByTagName("strokewidth")[0].firstChild.data;var V=U.getElementsByTagName("output")[ab].getElementsByTagName("color")[0];I[ab]=V.getElementsByTagName("stroke")[0].firstChild.data;v[ab]=V.getElementsByTagName("lighting")[0].firstChild.data;H[ab]=V.getElementsByTagName("fill")[0].firstChild.data;F[ab]=V.getElementsByTagName("label")[0].firstChild.data}ak.outputFixed=U.getElementsByTagName("output")[0].getElementsByTagName("fix")[0].firstChild.data;ak.outputStyle=U.getElementsByTagName("output")[0].getElementsByTagName("style")[0].firstChild.data;var M=J[0];m.objects[M].setProperty("strokeColor:"+I[0],"strokeWidth:"+C[0],"fillColor:"+I[0],"highlightStrokeColor:"+v[0],"highlightFillColor:"+v[0],"visible:"+L[0],"fixed:"+ak.outputFixed,"labelColor:"+F[0],"draft:"+aa[0]);m.objects[M].setStyle(1*ak.outputStyle);m.objects[M].traced=(N[0]=="false")?false:true;var B=J[1];m.objects[B].setProperty("strokeColor:"+I[1],"strokeWidth:"+C[1],"fillColor:"+H[1],"highlightStrokeColor:"+v[1],"highlightFillColor:"+H[1],"visible:"+L[1],"dash:"+ac[1],"draft:"+aa[1]);m.objects[B].traced=(N[1]=="false")?false:true}}}JXG.GeonextReader.printDebugMessage("debug",ak,U.nodeName,"OK");break;case"polygon":ak=JXG.GeonextReader.colorProperties(ak,U);ak=JXG.GeonextReader.firstLevelProperties(ak,U);ak.dataVertex=[];for(var ab=0;ab<U.getElementsByTagName("data")[0].getElementsByTagName("vertex").length;ab++){ak.dataVertex[ab]=U.getElementsByTagName("data")[0].getElementsByTagName("vertex")[ab].firstChild.data;ak.dataVertex[ab]=JXG.GeonextReader.changeOriginIds(m,ak.dataVertex[ab])}ak.border=[];for(var ab=0;ab<U.getElementsByTagName("border").length;ab++){ak.border[ab]={};var V=U.getElementsByTagName("border")[ab];ak.border[ab].id=V.getElementsByTagName("id")[0].firstChild.data;ak.border[ab].name=V.getElementsByTagName("name")[0].firstChild.data;ak.border[ab].straightFirst=V.getElementsByTagName("straight")[0].getElementsByTagName("first")[0].firstChild.data;ak.border[ab].straightLast=V.getElementsByTagName("straight")[0].getElementsByTagName("last")[0].firstChild.data;ak.border[ab].straightFirst=(ak.border[ab].straightFirst=="false")?false:true;ak.border[ab].straightLast=(ak.border[ab].straightLast=="false")?false:true;ak.border[ab].strokewidth=V.getElementsByTagName("strokewidth")[0].firstChild.data;ak.border[ab].dash=V.getElementsByTagName("dash")[0].firstChild.data;ak.border[ab].visible=V.getElementsByTagName("visible")[0].firstChild.data;ak.border[ab].draft=V.getElementsByTagName("draft")[0].firstChild.data;ak.border[ab].trace=V.getElementsByTagName("trace")[0].firstChild.data;ak.border[ab].colorStroke=V.getElementsByTagName("color")[0].getElementsByTagName("stroke")[0].firstChild.data;ak.border[ab].highlightStrokeColor=V.getElementsByTagName("color")[0].getElementsByTagName("lighting")[0].firstChild.data;ak.border[ab].colorFill=V.getElementsByTagName("color")[0].getElementsByTagName("fill")[0].firstChild.data;ak.border[ab].colorLabel=V.getElementsByTagName("color")[0].getElementsByTagName("label")[0].firstChild.data;ak.border[ab].colorDraft=V.getElementsByTagName("color")[0].getElementsByTagName("draft")[0].firstChild.data}JXG.GeonextReader.parseImage(m,U.getElementsByTagName("image")[0],"polygone");var W=new JXG.Polygon(m,ak.dataVertex,ak.border,ak.id,ak.name);W.setProperty("strokeColor:"+ak.colorStroke,"strokeWidth:"+ak.strokewidth,"fillColor:"+ak.colorFill,"highlightStrokeColor:"+ak.highlightStrokeColor,"highlightFillColor:"+ak.colorFill,"visible:"+ak.visible,"draft:"+ak.draft,"trace:"+ak.trace);for(ab=0;ab<W.borders.length;ab++){W.borders[ab].setStraight(ak.border[ab].straightFirst,ak.border[ab].straightLast);W.borders[ab].setProperty("strokeColor:"+ak.border[ab].colorStroke,"strokeWidth:"+ak.border[ab].strokewidth,"fillColor:"+ak.border[ab].colorFill,"highlightStrokeColor:"+ak.border[ab].highlightStrokeColor,"highlightFillColor:"+ak.border[ab].colorFill,"visible:"+ak.border[ab].visible,"dash:"+ak.border[ab].dash,"draft:"+ak.border[ab].draft,"trace:"+ak.border[ab].trace)}JXG.GeonextReader.printDebugMessage("debug",ak,U.nodeName,"OK");break;case"graph":ak=JXG.GeonextReader.colorProperties(ak,U);ak=JXG.GeonextReader.firstLevelProperties(ak,U);ak.funct=U.getElementsByTagName("data")[0].getElementsByTagName("function")[0].firstChild.data;JXG.GeonextReader.parseImage(m,U.getElementsByTagName("image")[0],"graphs");var af=new JXG.Curve(m,["x","x",ak.funct],ak.id,ak.name);JXG.GeonextReader.printDebugMessage("debug",ak,U.nodeName,"OK");af.setProperty("strokeColor:"+ak.colorStroke,"strokeWidth:"+ak.strokewidth,"fillColor:none","highlightStrokeColor:"+ak.highlightStrokeColor);break;case"arrow":ak=JXG.GeonextReader.colorProperties(ak,U);ak=JXG.GeonextReader.boardProperties(ak,U);ak=JXG.GeonextReader.firstLevelProperties(ak,U);ak=JXG.GeonextReader.readNodes(ak,U,"data");ak=JXG.GeonextReader.readNodes(ak,U,"straight","straight");ak=JXG.GeonextReader.visualProperties(ak,U);ak.first=JXG.GeonextReader.changeOriginIds(m,ak.first);ak.last=JXG.GeonextReader.changeOriginIds(m,ak.last);var aj=new JXG.Line(m,ak.first,ak.last,ak.id,ak.name);aj.setProperty("strokeColor:"+ak.colorStroke,"strokeWidth:"+ak.strokewidth,"fillColor:"+ak.colorFill,"highlightStrokeColor:"+ak.highlightStrokeColor,"highlightFillColor:"+ak.colorFill,"visible:"+ak.visible,"dash:"+ak.dash,"draft:"+ak.draft);aj.setStraight(false,false);aj.setArrow(false,true);aj.traced=(ak.trace=="false")?false:true;JXG.GeonextReader.printDebugMessage("debug",aj,U.nodeName,"OK");break;case"arc":ak=JXG.GeonextReader.colorProperties(ak,U);ak=JXG.GeonextReader.visualProperties(ak,U);ak=JXG.GeonextReader.boardProperties(ak,U);ak=JXG.GeonextReader.firstLevelProperties(ak,U);ak=JXG.GeonextReader.readNodes(ak,U,"data");ak.firstArrow=U.getElementsByTagName("firstarrow")[0].firstChild.data;ak.lastArrow=U.getElementsByTagName("lastarrow")[0].firstChild.data;JXG.GeonextReader.parseImage(m,U.getElementsByTagName("image")[0],"arcs");ak.midpoint=JXG.GeonextReader.changeOriginIds(m,ak.midpoint);ak.angle=JXG.GeonextReader.changeOriginIds(m,ak.angle);ak.radius=JXG.GeonextReader.changeOriginIds(m,ak.radius);var aj=new JXG.Arc(m,ak.midpoint,ak.radius,ak.angle,ak.id,ak.name);aj.setProperty("strokeColor:"+ak.colorStroke,"strokeWidth:"+ak.strokewidth,"fillColor:"+ak.colorFill,"highlightStrokeColor:"+ak.highlightStrokeColor,"highlightFillColor:"+ak.colorFill,"visible:"+ak.visible,"dash:"+ak.dash,"draft:"+ak.draft);aj.traced=(ak.trace=="false")?false:true;ak.firstArrow=(ak.firstArrow=="false")?false:true;ak.lastArrow=(ak.lastArrow=="false")?false:true;aj.setArrow(ak.firstArrow,ak.lastArrow);JXG.GeonextReader.printDebugMessage("debug",aj,U.nodeName,"OK");break;case"angle":ak=JXG.GeonextReader.boardProperties(ak,U);ak=JXG.GeonextReader.colorProperties(ak,U);ak=JXG.GeonextReader.visualProperties(ak,U);ak=JXG.GeonextReader.firstLevelProperties(ak,U);ak=JXG.GeonextReader.readNodes(ak,U,"data");ak.txt=JXG.GeonextReader.subtreeToString(U.getElementsByTagName("text")[0]);var aj=new JXG.Angle(m,ak.first,ak.middle,ak.last,ak.radius,ak.txt,ak.id,ak.name);aj.setProperty("strokeColor:"+ak.colorStroke,"strokeWidth:"+ak.strokewidth,"fillColor:"+ak.colorFill,"highlightStrokeColor:"+ak.highlightStrokeColor,"highlightFillColor:"+ak.colorFill,"visible:"+ak.visible,"dash:"+ak.dash);JXG.GeonextReader.printDebugMessage("debug",ak,U.nodeName,"OK");break;case"text":if(ak.id.match(/oldVersion/)){break}ak=JXG.GeonextReader.boardProperties(ak,U);ak=JXG.GeonextReader.colorProperties(ak,U);ak=JXG.GeonextReader.visualProperties(ak,U);ak=JXG.GeonextReader.firstLevelProperties(ak,U);ak=JXG.GeonextReader.readNodes(ak,U,"data");ak.mpStr=JXG.GeonextReader.subtreeToString(U.getElementsByTagName("data")[0].getElementsByTagName("mp")[0]);ak.mpStr=ak.mpStr.replace(/<\/?mp>/g,"");try{if(U.getElementsByTagName("data")[0].getElementsByTagName("parent")[0].firstChild){ak.parent=U.getElementsByTagName("data")[0].getElementsByTagName("parent")[0].firstChild.data}}catch(ah){}ak.condition=U.getElementsByTagName("condition")[0].firstChild.data;ak.content=U.getElementsByTagName("content")[0].firstChild.data;ak.fix=U.getElementsByTagName("fix")[0].firstChild.data;ak.autodigits=U.getElementsByTagName("digits")[0].firstChild.data;ak.parent=JXG.GeonextReader.changeOriginIds(m,ak.parent);var ai=new JXG.Text(m,ak.mpStr,ak.parent,[ak.x,ak.y],ak.id,ak.name,ak.autodigits);ai.setProperty("labelColor:"+ak.colorLabel);if(ak.visible=="false"){ai.hideElement()}break;case"parametercurve":ak=JXG.GeonextReader.colorProperties(ak,U);ak=JXG.GeonextReader.firstLevelProperties(ak,U);ak.functionx=U.getElementsByTagName("functionx")[0].firstChild.data;ak.functiony=U.getElementsByTagName("functiony")[0].firstChild.data;ak.min=U.getElementsByTagName("min")[0].firstChild.data;ak.max=U.getElementsByTagName("max")[0].firstChild.data;var af=new JXG.Curve(m,["t",ak.functionx,ak.functiony,ak.min,ak.max],ak.id,ak.name);af.setProperty("strokeColor:"+ak.colorStroke,"strokeWidth:"+ak.strokewidth,"fillColor:none","highlightStrokeColor:"+ak.highlightStrokeColor);JXG.GeonextReader.printDebugMessage("debug",ak,U.nodeName,"OK");break;case"tracecurve":ak.tracepoint=U.getElementsByTagName("tracepoint")[0].firstChild.data;ak.traceslider=U.getElementsByTagName("traceslider")[0].firstChild.data;JXG.GeonextReader.printDebugMessage("debug",ak,U.nodeName,"<b>ERR</b>");break;case"group":ak=JXG.GeonextReader.boardProperties(ak,U);ak=JXG.GeonextReader.colorProperties(ak,U);ak=JXG.GeonextReader.firstLevelProperties(ak,U);ak.members=[];for(var ab=0;ab<U.getElementsByTagName("data")[0].getElementsByTagName("member").length;ab++){ak.members[ab]=U.getElementsByTagName("data")[0].getElementsByTagName("member")[ab].firstChild.data;ak.members[ab]=JXG.GeonextReader.changeOriginIds(m,ak.members[ab])}var af=new JXG.Group(m,ak.id,ak.name,ak.members);JXG.GeonextReader.printDebugMessage("debug",ak,U.nodeName,"OK");break;default:if(U.nodeName!="#text"){}}delete (ak)})(q)}m.addConditions(o.conditions)};this.decodeString=function(d){if(d.indexOf("<GEONEXT>")<0){var b=(new JXG.Util.Unzip(JXG.Util.Base64.decodeAsArray(d))).unzip();if(b==""){return d}else{return b}}else{return d}};this.prepareString=function(b){if(b.indexOf("GEONEXT")<0){b=(JXG.GeonextReader.decodeString(b))[0][0]}b=JXG.GeonextReader.fixXML(b);return b};this.fixXML=function(g){var b=["active","angle","animate","animated","arc","area","arrow","author","autodigits","axis","back","background","board","border","bottom","buttonsize","cas","circle","color","comment","composition","condition","conditions","content","continuous","control","coord","coordinates","cross","cs","dash","data","description","digits","direction","draft","editable","elements","event","file","fill","first","firstarrow","fix","fontsize","free","full","function","functionx","functiony","GEONEXT","graph","grid","group","height","id","image","info","information","input","intersection","item","jsf","label","last","lastarrow","left","lefttoolbar","lighting","line","loop","max","maximized","member","middle","midpoint","min","modifier","modus","mp","mpx","multi","name","onpolygon","order","origin","output","overline","parametercurve","parent","point","pointsnap","polygon","position","radius","radiusnum","radiusvalue","right","section","selectedlefttoolbar","showconstruction","showcoord","showinfo","showunit","showx","showy","size","slider","snap","speed","src","start","stop","straight","stroke","strokewidth","style","term","text","top","trace","tracecurve","type","unit","value","VERSION","vertex","viewport","visible","width","wot","x","xooy","xval","y","yval","zoom"];g=JXG.escapeHTML(g);var e=b.join("|");var d="&lt;(/?("+e+"))&gt;";var f=new RegExp(d,"g");g=g.replace(f,"<$1>");g=g.replace(/(<content>.*)<arc>(.*<\/content>)/g,"$1&lt;arc&gt;$2");g=g.replace(/(<mp>.*)<arc>(.*<\/mpx>)/g,"$1&lt;arc&gt;$2");g=g.replace(/(<mpx>.*)<arc>(.*<\/mpx>)/g,"$1&lt;arc&gt;$2");return g}};JXG.IntergeoReader=new function(){this.board=null;this.objects={};this.readIntergeo=function(b,d){this.board=d;this.board.origin={};this.board.origin.usrCoords=[1,0,0];this.board.origin.scrCoords=[1,400,300];this.board.unitX=30;this.board.unitY=30;this.readElements(b.getElementsByTagName("elements"));this.readConstraints(b.getElementsByTagName("constraints"))};this.readElements=function(b){for(var d=0;d<b[0].childNodes.length;d++){(function(e){var f=b[0].childNodes[e];if(f.nodeType>1){return}if(f.nodeName=="point"){JXG.IntergeoReader.addPoint(f)}else{if(f.nodeName=="line"){JXG.IntergeoReader.storeLine(f)}else{}}})(d)}};this.addPoint=function(f){var d=0;var e;var g=f.childNodes[d];while(g.nodeType>1){d++;g=f.childNodes[d]}if(g.nodeName=="homogeneous_coordinates"){var h=[];for(var b=0;b<g.childNodes.length;b++){if(g.childNodes[b].nodeType==1){if(g.childNodes[b].nodeName=="double"){h.push(g.childNodes[b].firstChild.data)}else{}}}for(b=0;b<3;b++){h[b]=parseFloat(h[b])}e=this.board.createElement("point",[h[2],h[0],h[1]],{name:f.getAttribute("id")})}else{if(g.nodeName=="euclidean_coordinates"){var h=[];for(var b=0;b<g.childNodes.length;b++){if(g.childNodes[b].nodeType==1){h.push(g.childNodes[b].firstChild.data)}}e=this.board.createElement("point",[h[0],h[1]],{name:f.getAttribute("id")})}else{if(g.nodeName=="polar_coordinates"){var h=[];for(var b=0;b<g.childNodes.length;b++){if(g.childNodes[b].nodeType==1){h.push(g.childNodes[b].firstChild.data)}}e=this.board.createElement("point",[h[0]*Math.cos(h[1]),h[0]*Math.sin(h[1])],{name:f.getAttribute("id")})}else{return}}}this.objects[f.getAttribute("id")]=e};this.storeLine=function(e){this.objects[e.getAttribute("id")]={id:e.getAttribute("id"),coords:null};var d=0;var f=e.childNodes[d];while(f.nodeType>1){d++;f=e.childNodes[d]}if(f.nodeName=="homogeneous_coordinates"){var g=[];for(var b=0;b<f.childNodes.length;b++){if(f.childNodes[b].nodeType==1){if(f.childNodes[b].nodeName=="double"){g.push(parseFloat(f.childNodes[b].firstChild.data))}else{}}}this.objects[e.getAttribute("id")].coords=g}};this.readConstraints=function(b){for(var d=0;d<b[0].childNodes.length;d++){(function(e){var f=b[0].childNodes[e];if(f.nodeType>1){return}if(f.nodeName=="line_through_two_points"){JXG.IntergeoReader.addLineThroughTwoPoints(f)}else{if(f.nodeName=="line_parallel_to_line_through_point"){JXG.IntergeoReader.addLineParallelToLineThroughPoint(f)}else{if(f.nodeName=="line_perpendicular_to_line_through_point"){JXG.IntergeoReader.addLinePerpendicularToLineThroughPoint(f)}else{if(f.nodeName=="point_intersection_of_two_lines"){JXG.IntergeoReader.addPointIntersectionOfTwoLines(f)}else{if(f.nodeName=="free_point"){}else{if(f.nodeName=="free_line"){JXG.IntergeoReader.addFreeLine(f)}else{if(f.nodeName=="point_on_line"){JXG.IntergeoReader.addPointOnLine(f)}else{if(f.nodeName=="angular_bisector_of_three_points"){JXG.IntergeoReader.addAngularBisectorOfThreePoints(f)}else{}}}}}}}}})(d)}};this.readParams=function(d){var e=[];for(var b=0;b<d.childNodes.length;b++){if(d.childNodes[b].nodeType==1){e.push(d.childNodes[b].firstChild.data)}}return e};this.addLineThroughTwoPoints=function(d){var e=JXG.IntergeoReader.readParams(d);var b=this.board.createElement("line",[this.objects[e[1]],this.objects[e[2]]],{name:e[0]});this.objects[e[0]]=b};this.addLineParallelToLineThroughPoint=function(d){var e=JXG.IntergeoReader.readParams(d);var b=this.board.createElement("parallel",[this.objects[e[1]].id,this.objects[e[2]].id],{name:e[0]});this.objects[e[0]]=b};this.addLinePerpendicularToLineThroughPoint=function(d){var e=JXG.IntergeoReader.readParams(d);var b=this.board.createElement("perpendicular",[this.objects[e[1]].id,this.objects[e[2]].id],{name:e[0]});b[0].setProperty("straightFirst:true","straightLast:true");b[1].setProperty("visible:false");this.objects[e[0]]=b[0]};this.addPointIntersectionOfTwoLines=function(b){var d=JXG.IntergeoReader.readParams(b);this.objects[d[0]].addConstraint([this.board.intersectionFunc(this.objects[d[1]],this.objects[d[2]],0)])};this.addFreeLine=function(g){var h=JXG.IntergeoReader.readParams(g);var e=this.objects[h[0]].coords[0];var d=this.objects[h[0]].coords[1];var j=this.objects[h[0]].coords[2];var f=this.board.createElement("line",[j,e,d],{name:h[0],id:h[0]});this.objects[h[0]]=f};this.addPointOnLine=function(d){var e=JXG.IntergeoReader.readParams(d);var b=JXG.GetReferenceFromParameter(this.board,e[0]);b.makeGlider(this.objects[e[1]]);this.objects[e[0]]=b};this.addAngularBisectorOfThreePoints=function(d){var e=JXG.IntergeoReader.readParams(d);var b=this.board.createElement("bisector",[e[1],e[2],e[3]],{name:e[0],id:e[0]});b.setProperty("straightFirst:false","straightLast:true");this.objects[e[0]]=b};this.prepareString=function(b){if(b.indexOf("<")!=0){bA=[];binary=false;for(i=0;i<b.length;i++){bA[i]=JXG.Util.asciiCharCodeAt(b,i)}b=(new JXG.Util.Unzip(bA)).unzipFile("construction/intergeo.xml")}return b}};JXG.JSXGraph=new function(g){this.licenseText="JSXGraph v0.72 Copyright (C) see http://jsxgraph.org";this.rendererType="";this.boards={};this.elements={};var h;var d;if((g=="undefined")||(g==null)||(g=="")){h=navigator.appVersion.match(/MSIE (\d\.\d)/);d=(navigator.userAgent.toLowerCase().indexOf("opera")!=-1);if((!h)||(d)){this.rendererType="svg"}else{this.rendererType="vml";function e(j){document.body.scrollLeft;document.body.scrollTop}document.onmousemove=e}}else{this.rendererType=g}var b=JXG.rendererFiles[this.rendererType].split(",");for(var f=0;f<b.length;f++){(function(j){JXG.require(JXG.requirePath+j+".js")})(b[f])}this.initBoard=function(l,k){var n;if(typeof k=="undefined"){k={}}var v=((typeof k.originX)=="undefined"?150:k.originX);var u=((typeof k.originY)=="undefined"?150:k.originY);var s=((typeof k.zoom)=="undefined"?1:k.zoom);var r=s*((typeof k.zoomX)=="undefined"?1:k.zoomX);var q=s*((typeof k.zoomY)=="undefined"?1:k.zoomY);var p=((typeof k.unitX)=="undefined"?50:k.unitX);var o=((typeof k.unitY)=="undefined"?50:k.unitY);var j=JXG.getDimensions(l);if(this.rendererType=="svg"){n=new JXG.SVGRenderer(document.getElementById(l))}else{if(this.rendererType=="vml"){n=new JXG.VMLRenderer(document.getElementById(l))}else{n=new JXG.SilverlightRenderer(document.getElementById(l),j.width,j.height)}}var m=new JXG.Board(l,n,"",[v,u],1,1,p,o,j.width,j.height);this.boards[m.id]=m;m.initGeonextBoard();if((typeof k.axis!="undefined")&&k.axis){m.createElement("axis",[[0,0],[1,0]],{});m.createElement("axis",[[0,0],[0,1]],{})}if((typeof k.grid!="undefined")&&k.grid){m.renderer.drawGrid(m)}if(true){m.renderer.drawZoomBar(m)}return m};this.loadBoardFromFile=function(m,j,o){var n;if(this.rendererType=="svg"){n=new JXG.SVGRenderer(document.getElementById(m))}else{n=new JXG.VMLRenderer(document.getElementById(m))}var l=JXG.getDimensions(m);var k=new JXG.Board(m,n,"",[150,150],1,1,50,50,l.width,l.height);k.beforeLoad();JXG.FileReader.parseFileContent(j,k,o);if(true){k.renderer.drawZoomBar(k)}this.boards[k.id]=k;return k};this.loadBoardFromString=function(m,j,o){var n;if(this.rendererType=="svg"){n=new JXG.SVGRenderer(document.getElementById(m))}else{n=new JXG.VMLRenderer(document.getElementById(m))}var l=JXG.getDimensions(m);var k=new JXG.Board(m,n,"",[150,150],1,1,50,50,l.width,l.height);k.beforeLoad();JXG.FileReader.parseString(j,k,o);if(true){k.renderer.drawZoomBar(k)}this.boards[k.id]=k;return k};this.freeBoard=function(k){if(typeof(k)=="string"){k=this.boards[k]}JXG.removeEvent(document,"mousedown",k.mouseDownListener,k);JXG.removeEvent(document,"mouseup",k.mouseUpListener,k);JXG.removeEvent(k.containerObj,"mousemove",k.mouseMoveListener,k);for(var j in k.objects){k.removeObject(k.objects[j])}k.containerObj.innerHTML="";for(var j in k.objects){delete (k.objects[j])}delete (k.renderer);delete (k.algebra);delete (this.boards[k.id])};this.registerElement=function(j,k){j=j.toLowerCase();this.elements[j]=k};this.unregisterElement=function(j){delete (this.elements[j])}};JXG.GetReferenceFromParameter=function(d,b){if(typeof(b)=="string"){if(d.objects[b]!=null){b=d.objects[b]}else{if(d.elementsByName[b]!=null){b=d.elementsByName[b]}}}return b};JXG.IsString=function(b){return typeof b=="string"};JXG.IsNumber=function(b){return typeof b=="number"};JXG.IsFunction=function(b){return typeof b=="function"};JXG.IsArray=function(b){return b!=null&&typeof b=="object"&&"splice" in b&&"join" in b};JXG.IsPoint=function(b){if(typeof b=="object"){return(b.elementClass==JXG.OBJECT_CLASS_POINT)}return false};JXG.createEvalFunction=function(d,h,j){var e=[];for(var b=0;b<j;b++){if(typeof h[b]=="string"){var g=d.algebra.geonext2JS(h[b]);g=g.replace(/this\.board\./g,"board.");e[b]=new Function("","return "+(g)+";")}}return function(l){var f=h[l];if(typeof f=="string"){return e[l]()}else{if(typeof f=="function"){return f()}else{if(typeof f=="number"){return f}}}return 0}};JXG.getDimensions=function(h){var g=document.getElementById(h);var k=g.style.display;if(k!="none"&&k!=null){return{width:g.offsetWidth,height:g.offsetHeight}}var e=g.style;var l=e.visibility;var j=e.position;var d=e.display;e.visibility="hidden";e.position="absolute";e.display="block";var b=g.clientWidth;var f=g.clientHeight;e.display=d;e.position=j;e.visibility=l;return{width:b,height:f}};JXG.addEvent=function(f,e,d,b){if(typeof Prototype!="undefined"&&typeof Prototype.Browser!="undefined"){b["_internal"+e]=d.bindAsEventListener(b);Event.observe(f,e,b["_internal"+e])}else{b["_internal"+e]=function(){return d.apply(b,arguments)};$(f).bind(e,b["_internal"+e])}};JXG.bind=function(d,b){return function(){return d.apply(b,arguments)}};JXG.removeEvent=function(f,e,d,b){if(typeof Prototype!="undefined"&&typeof Prototype.Browser!="undefined"){Event.stopObserving(f,e,b["_internal"+e])}else{$(f).unbind(e,b["_internal"+e])}};JXG.getPosition=function(d){var b=0;var e=0;if(!d){var d=window.event}if(d.pageX||d.pageY){b=d.pageX;e=d.pageY}else{if(d.clientX||d.clientY){b=d.clientX+document.body.scrollLeft+document.documentElement.scrollLeft;e=d.clientY+document.body.scrollTop+document.documentElement.scrollTop}}return[b,e]};JXG.getOffset=function(b){if(typeof Prototype!="undefined"&&typeof Prototype.Browser!="undefined"){return Element.cumulativeOffset(b)}else{var d=$(b).offset();return[d.left,d.top]}};JXG.getStyle=function(d,b){if(typeof Prototype!="undefined"&&typeof Prototype.Browser!="undefined"){return $(d).getStyle(b)}else{if(typeof $(d).attr(b)!="undefined"){return $(d).attr(b)}else{return $(d).css(b)}}};JXG.keys=function(b){var d=[];for(var e in b){d.push(e)}return d};JXG.escapeHTML=function(b){return b.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;")};JXG.unescapeHTML=function(b){return b.replace(/<\/?[^>]+>/gi,"").replace(/&amp;/g,"&").replace(/&lt;/g,"<").replace(/&gt;/g,">")};JXG.capitalize=function(b){return b.charAt(0).toUpperCase()+b.substring(1).toLowerCase()};JXG.OBJECT_TYPE_ARC=1330921795;JXG.OBJECT_TYPE_ARROW=1330921815;JXG.OBJECT_TYPE_AXIS=1330921816;JXG.OBJECT_TYPE_TICKS=1330926680;JXG.OBJECT_TYPE_CIRCLE=1330922316;JXG.OBJECT_TYPE_CURVE=1330923344;JXG.OBJECT_TYPE_IMAGE=1330926157;JXG.OBJECT_TYPE_LINE=1330924622;JXG.OBJECT_TYPE_POINT=1330925652;JXG.OBJECT_TYPE_SLIDER=1330926404;JXG.OBJECT_TYPE_CAS=1330922320;JXG.OBJECT_TYPE_POLYGON=1330925657;JXG.OBJECT_TYPE_SECTOR=1330926403;JXG.OBJECT_TYPE_TEXT=1330926661;JXG.OBJECT_TYPE_ANGLE=1330921799;JXG.OBJECT_TYPE_INTERSECTION=1330926158;JXG.OBJECT_CLASS_POINT=1;JXG.OBJECT_CLASS_LINE=2;JXG.OBJECT_CLASS_CIRCLE=3;JXG.OBJECT_CLASS_CURVE=4;JXG.OBJECT_CLASS_AREA=5;JXG.OBJECT_CLASS_OTHER=6;JXG.GeometryElement=function(){this.board=null;this.id="";this.needsUpdate=true;this.name="";this.visProp={};this.isReal=true;this.visProp.dash=0;this.childElements={};this.notExistingParents={};this.traced=false;this.traces={};this.numTraces=0;this.transformations=[];this.baseElement=null;this.descendants={};this.ancestors={};this.stdform=[1,0,0,0,1,1,0,0];this.afterFirstUpdate=false;this.needsRegularUpdate=true};JXG.GeometryElement.prototype.init=function(d,e,b){if(typeof(d)=="string"){d=JXG.JSXGraph.boards[d]}this.board=d;this.id=e;if((b!=null)&&(typeof b!="undefined")){b=b}else{b=this.board.generateName(this)}this.board.elementsByName[b]=this;this.name=b;this.visProp.strokeColor=this.board.options.elements.color.strokeColor;this.visProp.highlightStrokeColor=this.board.options.elements.color.highlightStrokeColor;this.visProp.fillColor=this.board.options.elements.color.fillColor;this.visProp.highlightFillColor=this.board.options.elements.color.highlightFillColor;this.visProp.strokeWidth=this.board.options.elements.strokeWidth;this.visProp.strokeOpacity=this.board.options.elements.color.strokeOpacity;this.visProp.highlightStrokeOpacity=this.board.options.elements.color.highlightStrokeOpacity;this.visProp.fillOpacity=this.board.options.elements.color.fillOpacity;this.visProp.highlightFillOpacity=this.board.options.elements.color.highlightFillOpacity;this.visProp.draft=this.board.options.elements.draft.draft};JXG.GeometryElement.prototype.addChild=function(e){this.childElements[e.id]=e;this.addDescendants(e);e.ancestors[this.id]=this;for(var d in this.descendants){this.descendants[d].ancestors[this.id]=this;for(var b in this.ancestors){this.descendants[d].ancestors[this.ancestors[b].id]=this.ancestors[b]}}for(var d in this.ancestors){for(var b in this.descendants){this.ancestors[d].descendants[this.descendants[b].id]=this.descendants[b]}}};JXG.GeometryElement.prototype.addDescendants=function(b){this.descendants[b.id]=b;for(el in b.childElements){this.addDescendants(b.childElements[el])}};JXG.GeometryElement.prototype.update=function(){if(this.traced){this.cloneToBackground(true)}};JXG.GeometryElement.prototype.updateRenderer=function(){};JXG.GeometryElement.prototype.hideElement=function(){this.visProp.visible=false;this.board.renderer.hide(this);if(this.label!=null){this.label.hiddenByParent=true;if(this.label.show){this.board.renderer.hide(this.label);this.label.show=true}}};JXG.GeometryElement.prototype.showElement=function(){this.visProp.visible=true;this.board.renderer.show(this);if(this.label!=null&&this.label.hiddenByParent){this.label.hiddenByParent=false;if(this.label.show){this.board.renderer.show(this.label)}}};JXG.GeometryElement.prototype.setProperty=function(){var e;var f;var j;for(var h=0;h<arguments.length;h++){var d=arguments[h];if(typeof d=="string"){j=d.split(":")}else{if(!JXG.IsArray(d)){for(var g in d){this.setProperty([g,d[g]])}return}else{j=d}}switch(j[0].replace(/\s+/g).toLowerCase()){case"strokewidth":this.visProp.strokeWidth=j[1];this.board.renderer.setObjectStrokeWidth(this,this.visProp.strokeWidth);break;case"strokecolor":e=j[1];if(e.length=="9"&&e.substr(0,1)=="#"){f=e.substr(7,2);e=e.substr(0,7)}else{f="FF"}this.visProp.strokeColor=e;this.visProp.strokeOpacity=parseInt(f.toUpperCase(),16)/255;this.board.renderer.setObjectStrokeColor(this,this.visProp.strokeColor,this.visProp.strokeOpacity);break;case"fillcolor":e=j[1];if(e.length=="9"&&e.substr(0,1)=="#"){f=e.substr(7,2);e=e.substr(0,7)}else{f="FF"}this.visProp.fillColor=e;this.visProp.fillOpacity=parseInt(f.toUpperCase(),16)/255;this.board.renderer.setObjectFillColor(this,this.visProp.fillColor,this.visProp.fillOpacity);break;case"highlightstrokecolor":e=j[1];if(e.length=="9"&&e.substr(0,1)=="#"){f=e.substr(7,2);e=e.substr(0,7)}else{f="FF"}this.visProp.highlightStrokeColor=e;this.visProp.highlightStrokeOpacity=parseInt(f.toUpperCase(),16)/255;break;case"highlightfillcolor":e=j[1];if(e.length=="9"&&e.substr(0,1)=="#"){f=e.substr(7,2);e=e.substr(0,7)}else{f="FF"}this.visProp.highlightFillColor=e;this.visProp.highlightFillOpacity=parseInt(f.toUpperCase(),16)/255;break;case"fillopacity":this.visProp.fillOpacity=j[1];this.board.renderer.setObjectFillColor(this,this.visProp.fillColor,this.visProp.fillOpacity);break;case"strokeopacity":this.visProp.strokeOpacity=j[1];this.board.renderer.setObjectStrokeColor(this,this.visProp.strokeColor,this.visProp.strokeOpacity);break;case"highlightfillopacity":this.visProp.highlightFillOpacity=j[1];break;case"strokeopacity":this.visProp.highlightStrokeOpacity=j[1];break;case"labelcolor":e=j[1];if(e.length=="9"&&e.substr(0,1)=="#"){f=e.substr(7,2);e=e.substr(0,7)}else{f="FF"}if(f=="00"){if(this.label!=null){this.label.hideElement()}}if(this.label!=null){this.label.color=e;this.board.renderer.setLabelColor(this.label)}if(this.type==JXG.OBJECT_TYPE_TEXT){this.visProp.strokeColor=e;this.board.renderer.setObjectStrokeColor(this,this.visProp.strokeColor,1)}break;case"visible":if(j[1]=="false"||j[1]==false){this.visProp.visible=false;this.hideElement()}else{if(j[1]=="true"||j[1]==true){this.visProp.visible=true;this.showElement()}}break;case"dash":this.setDash(j[1]);break;case"trace":if(j[1]=="false"||j[1]==false){this.traced=false}else{if(j[1]=="true"||j[1]==true){this.traced=true}}break;case"style":this.setStyle(1*j[1]);break;case"fixed":this.fixed=(j[1]=="false")?false:true;break;case"draft":if(j[1]=="false"||j[1]==false){if(this.visProp.draft==true){this.visProp.draft=false;this.board.renderer.removeDraft(this)}}else{if(j[1]=="true"||j[1]==true){this.visProp.draft=true;this.board.renderer.setDraft(this)}}break;case"straightfirst":if(j[1]=="false"||j[1]==false){this.visProp.straightFirst=false}else{if(j[1]=="true"||j[1]==true){this.visProp.straightFirst=true}}this.setStraight(this.visProp.straightFirst,this.visProp.straightLast);break;case"straightlast":if(j[1]=="false"||j[1]==false){this.visProp.straightLast=false}else{if(j[1]=="true"||j[1]==true){this.visProp.straightLast=true}}this.setStraight(this.visProp.straightFirst,this.visProp.straightLast);break;case"firstarrow":if(j[1]=="false"||j[1]==false){this.visProp.firstArrow=false}else{if(j[1]=="true"||j[1]==true){this.visProp.firstArrow=true}}this.setArrow(this.visProp.firstArrow,this.visProp.lastArrow);break;case"lastarrow":if(j[1]=="false"||j[1]==false){this.visProp.lastArrow=false}else{if(j[1]=="true"||j[1]==true){this.visProp.lastArrow=true}}this.setArrow(this.visProp.firstArrow,this.visProp.lastArrow);break;case"curvetype":this.curveType=j[1];break;case"fontsize":this.visProp.fontSize=j[1];break;case"insertticks":if(this.type==JXG.OBJECT_TYPE_TICKS){var b=this.insertTicks;this.insertTicks=true;if(j[1]=="false"||j[1]==false){this.insertTicks=false}if(b!=this.insertTicks){this.calculateTicksCoordinates()}}break;case"drawlabels":if(this.type==JXG.OBJECT_TYPE_TICKS){var b=this.drawLabels;this.drawLabels=true;if(j[1]=="false"||j[1]==false){this.drawLabels=false}if(b!=this.drawLabels){this.calculateTicksCoordinates()}}break;case"drawzero":if(this.type==JXG.OBJECT_TYPE_TICKS){var b=this.drawZero;this.drawZero=true;if(j[1]=="false"||j[1]==false){this.drawZero=false}if(b!=this.drawZero){this.calculateTicksCoordinates()}}break;case"minorticks":if(this.type==JXG.OBJECT_TYPE_TICKS){var b=this.minorTicks;if((j[1]!=null)&&(j[1]>0)){this.minorTicks=j[1]}if(b!=this.minorTicks){this.calculateTicksCoordinates()}}break;case"majortickheight":if(this.type==JXG.OBJECT_TYPE_TICKS){var b=this.majorHeight;if((j[1]!=null)&&(j[1]>0)){this.majorHeight=j[1]}if(b!=this.majorHeight){this.calculateTicksCoordinates()}}break;case"minortickheight":if(this.type==JXG.OBJECT_TYPE_TICKS){var b=this.minorHeight;if((j[1]!=null)&&(j[1]>0)){this.minorHeight=j[1]}if(b!=this.minorHeight){this.calculateTicksCoordinates()}}break}}};JXG.GeometryElement.prototype.setDash=function(b){this.visProp.dash=b;this.board.renderer.setObjectDash(this)};JXG.GeometryElement.prototype.prepareUpdate=function(){this.needsUpdate=true;return;for(var b in this.childElements){if(this.board.objects[b]!=undefined){this.childElements[b].prepareUpdate()}else{delete (this.childElements[b])}}};JXG.GeometryElement.prototype.remove=function(){this.board.renderer.remove(document.getElementById(this.id))};JXG.GeometryElement.prototype.getTextAnchor=function(){return new JXG.Coords(JXG.COORDS_BY_USER,[0,0],this.board)};JXG.GeometryElement.prototype.setStyle=function(b){};JXG.GeometryElement.prototype.setStraight=function(b,d){};JXG.GeometryElement.prototype.setArrow=function(d,b){};JXG.GeometryElement.prototype.clearTrace=function(){for(var b in this.traces){this.board.renderer.remove(this.traces[b])}this.numTraces=0};JXG.GeometryElement.prototype.cloneToBackground=function(b){return};JXG.GeometryElement.prototype.normalize=function(){this.stdform=this.board.algebra.normalize(this.stdform)};JXG.GeometryElement.prototype.toJSON=function(){var d='{"name":'+this.name;d+=', "id":'+this.id;var e=[];for(var b in this.visProp){if(this.visProp[b]!=null){e.push('"'+b+'":'+this.visProp[b])}}d+=', "visProp":{'+e.toString()+"}";d+="}";return d};JXG.COORDS_BY_USER=1;JXG.COORDS_BY_SCREEN=2;JXG.Coords=function(e,d,b){this.board=b;this.usrCoords=[1,0,0];this.scrCoords=[1,0,0];if(e==JXG.COORDS_BY_USER){if(d.length<=2){this.usrCoords[1]=d[0];this.usrCoords[2]=d[1]}else{this.usrCoords[0]=d[0];this.usrCoords[1]=d[1];this.usrCoords[2]=d[2];this.normalizeUsrCoords()}this.usr2screen()}else{this.scrCoords[1]=d[0];this.scrCoords[2]=d[1];this.screen2usr()}};JXG.Coords.prototype.normalizeUsrCoords=function(){var b=0.000001;if(Math.abs(this.usrCoords[0])>b){this.usrCoords[1]/=this.usrCoords[0];this.usrCoords[2]/=this.usrCoords[0];this.usrCoords[0]=1}};JXG.Coords.prototype.usr2screen=function(){this.scrCoords[0]=Math.round(this.usrCoords[0]);this.scrCoords[1]=Math.round(this.usrCoords[0]*this.board.origin.scrCoords[1]+this.usrCoords[1]*this.board.unitX*this.board.zoomX);this.scrCoords[2]=Math.round(this.usrCoords[0]*this.board.origin.scrCoords[2]-this.usrCoords[2]*this.board.unitY*this.board.zoomY)};JXG.Coords.prototype.screen2usr=function(){this.usrCoords[0]=1;this.usrCoords[1]=(this.scrCoords[1]-this.board.origin.scrCoords[1])/(this.board.unitX*this.board.zoomX);this.usrCoords[2]=(this.board.origin.scrCoords[2]-this.scrCoords[2])/(this.board.unitY*this.board.zoomY)};JXG.Coords.prototype.distance=function(f,e){var d=0;if(f==JXG.COORDS_BY_USER){for(var b=0;b<=this.board.dimension;b++){d+=(this.usrCoords[b]-e.usrCoords[b])*(this.usrCoords[b]-e.usrCoords[b])}}else{for(var b=0;b<=this.board.dimension;b++){d+=(this.scrCoords[b]-e.scrCoords[b])*(this.scrCoords[b]-e.scrCoords[b])}}return Math.sqrt(d)};JXG.Coords.prototype.setCoordinates=function(d,b){if(d==JXG.COORDS_BY_USER){if(b.length==2){this.usrCoords[0]=1;this.usrCoords[1]=b[0];this.usrCoords[2]=b[1]}else{this.usrCoords[0]=b[0];this.usrCoords[1]=b[1];this.usrCoords[2]=b[2];this.normalizeUsrCoords()}this.usr2screen()}else{this.scrCoords[1]=b[0];this.scrCoords[2]=b[1];this.screen2usr()}};JXG.Point=function(e,f,g,d,b){this.constructor();this.type=JXG.OBJECT_TYPE_POINT;this.elementClass=JXG.OBJECT_CLASS_POINT;this.init(e,g,d);if(f==null){f=[0,0]}this.coords=new JXG.Coords(JXG.COORDS_BY_USER,f,this.board);this.initialCoords=new JXG.Coords(JXG.COORDS_BY_USER,f,this.board);this.label=new JXG.Label(this.board,this.name,this.coords,this.id+"Label");this.label.show=b;if(!b){this.label.hiddenByParent=true}this.fixed=false;this.position=null;this.onPolygon=false;this.visProp.style=this.board.options.point.style;this.r=this.board.options.precision.hasPoint;this.visProp.fillColor=this.board.options.point.fillColor;this.visProp.highlightFillColor=this.board.options.point.highlightFillColor;this.visProp.strokeColor=this.board.options.point.strokeColor;this.visProp.highlightStrokeColor=this.board.options.point.highlightStrokeColor;this.visProp.visible=b;this.slideObject=null;this.group=[];this.id=this.board.addPoint(this)};JXG.Point.prototype=new JXG.GeometryElement();JXG.Point.prototype.hasPoint=function(d,e){var b=this.coords.scrCoords;return((Math.abs(b[1]-d)<this.r+2)&&(Math.abs(b[2]-e))<this.r+2)};JXG.Point.prototype.updateConstraint=function(){};JXG.Point.prototype.update=function(g){if(!this.needsUpdate){return}if(typeof g=="undefined"){g=false}if(this.traced){this.cloneToBackground(true)}if(this.type==JXG.OBJECT_TYPE_GLIDER){if(this.slideObject.type==JXG.OBJECT_TYPE_CIRCLE){if(g){this.coords.setCoordinates(JXG.COORDS_BY_USER,[this.slideObject.midpoint.X()+Math.cos(this.position),this.slideObject.midpoint.Y()+Math.sin(this.position)]);this.coords=this.board.algebra.projectPointToCircle(this,this.slideObject)}else{this.coords=this.board.algebra.projectPointToCircle(this,this.slideObject);this.position=this.board.algebra.rad([this.slideObject.midpoint.X()+1,this.slideObject.midpoint.Y()],this.slideObject.midpoint,this)}}else{if(this.slideObject.type==JXG.OBJECT_TYPE_LINE){this.coords=this.board.algebra.projectPointToLine(this,this.slideObject);var f=this.slideObject.point1.coords;var k=this.slideObject.point2.coords;if(g){this.coords.setCoordinates(JXG.COORDS_BY_USER,[f.usrCoords[1]+this.position*(k.usrCoords[1]-f.usrCoords[1]),f.usrCoords[2]+this.position*(k.usrCoords[2]-f.usrCoords[2])])}else{var l=1;var p=f.distance(JXG.COORDS_BY_USER,this.coords);var d=f.distance(JXG.COORDS_BY_USER,k);var j=k.distance(JXG.COORDS_BY_USER,this.coords);if(((p>d)||(j>d))&&(p<j)){l=-1}this.position=l*p/d}var e=this.slideObject.point1.coords.scrCoords;var o=this.slideObject.point2.coords.scrCoords;var h;if(this.slideObject.getSlope()==0){h=1}else{h=2}var m=this.coords.scrCoords[h];if(!this.slideObject.visProp.straightFirst){if(e[h]<o[h]){if(m<e[h]){this.coords=this.slideObject.point1.coords}}else{if(e[h]>o[h]){if(m>e[h]){this.coords=this.slideObject.point1.coords}}}}if(!this.slideObject.visProp.straightLast){if(e[h]<o[h]){if(m>o[h]){this.coords=this.slideObject.point2.coords}}else{if(e[h]>o[h]){if(m<o[h]){this.coords=this.slideObject.point2.coords}}}}if(this.onPolygon){var q=this.slideObject.point1.coords;var n=this.slideObject.point2.coords;if(Math.abs(this.coords.scrCoords[1]-q.scrCoords[1])<this.r&&Math.abs(this.coords.scrCoords[2]-q.scrCoords[2])<this.r){var b=this.slideObject.parentPolygon;for(var h=0;h<b.borders.length;h++){if(this.slideObject==b.borders[h]){this.slideObject=b.borders[(h-1+b.borders.length)%b.borders.length];break}}}else{if(Math.abs(this.coords.scrCoords[1]-n.scrCoords[1])<this.r&&Math.abs(this.coords.scrCoords[2]-n.scrCoords[2])<this.r){var b=this.slideObject.parentPolygon;for(var h=0;h<b.borders.length;h++){if(this.slideObject==b.borders[h]){this.slideObject=b.borders[(h+1+b.borders.length)%b.borders.length];break}}}}}}else{if(this.slideObject.type==JXG.OBJECT_TYPE_CURVE){this.updateConstraint();this.coords=this.board.algebra.projectPointToCurve(this,this.slideObject)}}}}if(this.type==JXG.OBJECT_TYPE_CAS){this.updateConstraint()}this.updateTransform();this.needsUpdate=false};JXG.Point.prototype.updateRenderer=function(){if(this.visProp.visible){var b=this.isReal;this.isReal=(isNaN(this.coords.usrCoords[1]+this.coords.usrCoords[2]))?false:true;this.isReal=(Math.abs(this.coords.usrCoords[0])>this.board.algebra.eps)?this.isReal:false;if(this.isReal){if(b!=this.isReal){this.board.renderer.show(this);if(this.label.show){this.board.renderer.show(this.label)}}this.board.renderer.updatePoint(this)}else{if(b!=this.isReal){this.board.renderer.hide(this);if(this.label.show){this.board.renderer.hide(this.label)}}}}if(this.label.show&&this.isReal){this.label.setCoordinates(this.coords);this.board.renderer.updateLabel(this.label)}};JXG.Point.prototype.X=function(){return this.coords.usrCoords[1]};JXG.Point.prototype.Y=function(){return this.coords.usrCoords[2]};JXG.Point.prototype.Z=function(){return this.coords.usrCoords[0]};JXG.Point.prototype.XEval=function(){return this.coords.usrCoords[1]};JXG.Point.prototype.YEval=function(){return this.coords.usrCoords[2]};JXG.Point.prototype.ZEval=function(){return this.coords.usrCoords[0]};JXG.Point.prototype.Dist=function(b){return this.coords.distance(JXG.COORDS_BY_USER,b.coords)};JXG.Point.prototype.setPositionDirectly=function(f,b,e){var d=this.coords;this.coords=new JXG.Coords(f,[b,e],this.board);if(this.group.length!=0){this.group[this.group.length-1].dX=this.coords.scrCoords[1]-d.scrCoords[1];this.group[this.group.length-1].dY=this.coords.scrCoords[2]-d.scrCoords[2];this.group[this.group.length-1].update(this)}else{this.update()}};JXG.Point.prototype.setPositionByTransform=function(g,b,f){var e=this.coords;var d=this.board.createElement("transform",[b,f],{type:"translate"});if(this.transformations.length>0&&this.transformations[this.transformations.length-1].isNumericMatrix){this.transformations[this.transformations.length-1].melt(d)}else{this.addTransform(this,d)}if(this.group.length!=0){}else{this.update()}};JXG.Point.prototype.setPosition=function(e,b,d){this.setPositionByTransform(e,b,d)};JXG.Point.prototype.makeGlider=function(b){this.slideObject=JXG.GetReferenceFromParameter(this.board,b);this.type=JXG.OBJECT_TYPE_GLIDER;this.slideObject.addChild(this);this.needsUpdate=true;this.update()};JXG.Point.prototype.addConstraint=function(g){this.type=JXG.OBJECT_TYPE_CAS;var h=this.board.elementsByName;var j=[];var b;for(var f=0;f<g.length;f++){var d=g[f];if(typeof d=="string"){var e=this.board.algebra.geonext2JS(d);j[f]=new Function("","return "+e+";")}else{if(typeof d=="function"){j[f]=d}else{if(typeof d=="number"){j[f]=function(k){return function(){return k}}(d)}}}}if(g.length==1){this.updateConstraint=function(){this.coords=j[0]()};if(!this.board.isSuspendedUpdate){this.update()}return}else{if(g.length==2){this.XEval=j[0];this.YEval=j[1];b="this.coords.setCoordinates(JXG.COORDS_BY_USER,[this.XEval(),this.YEval()]);";this.updateConstraint=new Function("",b)}else{this.ZEval=j[0];this.XEval=j[1];this.YEval=j[2];b="this.coords.setCoordinates(JXG.COORDS_BY_USER,[this.ZEval(),this.XEval(),this.YEval()]);";this.updateConstraint=new Function("",b)}}if(!this.board.isSuspendedUpdate){this.update()}return};JXG.Point.prototype.addConstraintOld=function(g,e){this.type=JXG.OBJECT_TYPE_CAS;var f=this.board.elementsByName;if(e==null){this.updateConstraint=function(){this.coords=g()};if(!this.board.isSuspendedUpdate){this.update()}return}if(typeof g=="string"){var d=this.board.algebra.geonext2JS(g);this.XEval=new Function("","return "+d+";")}else{if(typeof g=="function"){this.XEval=g}else{if(typeof g=="number"){this.XEval=function(){return g}}}}if(typeof e=="string"){var h=this.board.algebra.geonext2JS(e);this.YEval=new Function("","return "+h+";")}else{if(typeof e=="function"){this.YEval=e}else{if(typeof e=="number"){this.YEval=function(){return e}}}}var b="this.coords.setCoordinates(JXG.COORDS_BY_USER,[this.XEval(),this.YEval()]);";this.updateConstraint=new Function("",b);if(!this.board.isSuspendedUpdate){this.update()}return};JXG.Point.prototype.updateTransform=function(){if(this.transformations.length==0||this.baseElement==null){return}if(this===this.baseElement){var d=this.transformations[0].apply(this.baseElement,"self")}else{var d=this.transformations[0].apply(this.baseElement)}this.coords.setCoordinates(JXG.COORDS_BY_USER,[d[1],d[2]]);for(var b=1;b<this.transformations.length;b++){d=this.transformations[b].apply(this);this.coords.setCoordinates(JXG.COORDS_BY_USER,[d[1],d[2]])}};JXG.Point.prototype.addTransform=function(e,b){if(this.transformations.length==0){this.baseElement=e}var f;if(JXG.IsArray(b)){f=b}else{f=[b]}for(var d=0;d<f.length;d++){this.transformations.push(f[d])}};JXG.Point.prototype.startAnimation=function(b,d){if((this.type==JXG.OBJECT_TYPE_GLIDER)&&(typeof this.intervalCode=="undefined")){this.intervalCode=window.setInterval("JXG.JSXGraph.boards['"+this.board.id+"'].objects['"+this.id+"'].animate("+b+", "+d+")",250);if(typeof this.intervalCount=="undefined"){this.intervalCount=0}}};JXG.Point.prototype.stopAnimation=function(){if(typeof this.intervalCode!="undefined"){window.clearInterval(this.intervalCode);delete (this.intervalCode)}};JXG.Point.prototype.animate=function(n,h){this.intervalCount++;if(this.intervalCount>h){this.intervalCount=0}if(this.slideObject.type==JXG.OBJECT_TYPE_LINE){var d=this.slideObject.point1.coords.distance(JXG.COORDS_BY_SCREEN,this.slideObject.point2.coords);var l=this.slideObject.getSlope();var j;var g;if(l!="INF"){var f=Math.atan(l);j=Math.round((this.intervalCount/h)*d*Math.cos(f));g=Math.round((this.intervalCount/h)*d*Math.sin(f))}else{j=0;g=Math.round((this.intervalCount/h)*d)}var e;var m=1;if(n<0){e=this.slideObject.point2;if(this.slideObject.point2.coords.scrCoords[1]-this.slideObject.point1.coords.scrCoords[1]>0){m=-1}else{if(this.slideObject.point2.coords.scrCoords[1]-this.slideObject.point1.coords.scrCoords[1]==0){if(this.slideObject.point2.coords.scrCoords[2]-this.slideObject.point1.coords.scrCoords[2]>0){m=-1}}}}else{e=this.slideObject.point1;if(this.slideObject.point1.coords.scrCoords[1]-this.slideObject.point2.coords.scrCoords[1]>0){m=-1}else{if(this.slideObject.point1.coords.scrCoords[1]-this.slideObject.point2.coords.scrCoords[1]==0){if(this.slideObject.point1.coords.scrCoords[2]-this.slideObject.point2.coords.scrCoords[2]>0){m=-1}}}}this.coords.setCoordinates(JXG.COORDS_BY_SCREEN,[e.coords.scrCoords[1]+m*j,e.coords.scrCoords[2]+m*g])}else{if(this.slideObject.type==JXG.OBJECT_TYPE_CURVE){var b;if(n>0){b=Math.round(this.intervalCount/h*this.board.canvasWidth)}else{b=Math.round((h-this.intervalCount)/h*this.board.canvasWidth)}this.coords.setCoordinates(JXG.COORDS_BY_SCREEN,[b,0]);this.coords=this.board.algebra.projectPointToCurve(this,this.slideObject)}else{if(this.slideObject.type==JXG.OBJECT_TYPE_CIRCLE){var f;if(n<0){f=this.intervalCount/h*2*Math.PI}else{f=(h-this.intervalCount)/h*2*Math.PI}var k=this.slideObject.getRadius();this.coords.setCoordinates(JXG.COORDS_BY_USER,[this.slideObject.midpoint.coords.usrCoords[1]+k*Math.cos(f),this.slideObject.midpoint.coords.usrCoords[2]+k*Math.sin(f)])}}}this.board.update(this)};JXG.Point.prototype.setStyle=function(b){this.visProp.style=b;this.board.renderer.changePointStyle(this)};JXG.Point.prototype.remove=function(){this.board.renderer.remove(document.getElementById(this.label.id));if(this.visProp.style>=3&&this.visProp.style<=9){this.board.renderer.remove(document.getElementById(this.id))}else{this.board.renderer.remove(document.getElementById(this.id+"_x1"));this.board.renderer.remove(document.getElementById(this.id+"_x2"))}};JXG.Point.prototype.getTextAnchor=function(){return this.coords};JXG.Point.prototype.cloneToBackground=function(b){var d={};d.id=this.id+"T"+this.numTraces;this.numTraces++;d.coords=this.coords;d.visProp=this.visProp;d.elementClass=JXG.OBJECT_CLASS_POINT;this.board.renderer.drawPoint(d);if((this.visProp.style>=3)&&(this.visProp.style<=9)){this.traces[d.id]=document.getElementById(d.id)}else{this.traces[d.id+"_x1"]=document.getElementById(d.id+"_x1");this.traces[d.id+"_x2"]=document.getElementById(d.id+"_x2")}delete d};JXG.createPoint=function(g,d,h){var f;var b=false;for(var e=0;e<d.length;e++){if(typeof d[e]=="function"||typeof d[e]=="string"){b=true}}if(!b){if((JXG.IsNumber(d[0]))&&(JXG.IsNumber(d[1]))){f=new JXG.Point(g,d,h.id,h.name,(h.visible==undefined)||g.algebra.str2Bool(h.visible));if(h.slideObject!=null){f.makeGlider(h.slideObject)}else{f.baseElement=f}}else{if((typeof d[0]=="object")&&(typeof d[1]=="object")){f=new JXG.Point(g,[0,0],h.id,h.name,(h.visible==undefined)||g.algebra.str2Bool(h.visible));f.addTransform(d[0],d[1])}else{throw ("JSXGraph error: Can't create point with parent types '"+(typeof d[0])+"' and '"+(typeof d[1])+"'.")}}}else{f=new JXG.Point(g,[0,0],h.id,h.name,(h.visible==undefined)||g.algebra.str2Bool(h.visible));f.addConstraint(d)}return f};JXG.createGlider=function(e,b,f){var d;if(b.length==1){d=new JXG.Point(e,[0,0],f.id,f.name,(f.visible==undefined)||e.algebra.str2Bool(f.visible))}else{d=e.createElement("point",b.slice(0,-1),f)}d.makeGlider(b[b.length-1]);return d};JXG.JSXGraph.registerElement("point",JXG.createPoint);JXG.JSXGraph.registerElement("glider",JXG.createGlider);JXG.Line=function(d,f,e,g,b){this.constructor();this.init(d,g,b);this.type=JXG.OBJECT_TYPE_LINE;this.elementClass=JXG.OBJECT_CLASS_LINE;this.point1=JXG.GetReferenceFromParameter(this.board,f);this.point2=JXG.GetReferenceFromParameter(this.board,e);this.image=null;this.imageTransformMatrix=[[1,0,0],[0,1,0],[0,0,1]];this.r=this.board.options.precision.hasPoint;this.visProp.fillColor=this.board.options.line.fillColor;this.visProp.highlightFillColor=this.board.options.line.highlightFillColor;this.visProp.strokeColor=this.board.options.line.strokeColor;this.visProp.highlightStrokeColor=this.board.options.line.highlightStrokeColor;this.visProp.straightFirst=this.board.options.line.straightFirst;this.visProp.straightLast=this.board.options.line.straightLast;this.visProp.visible=true;this.visProp.firstArrow=this.board.options.line.firstArrow;this.visProp.lastArrow=this.board.options.line.lastArrow;this.ticks=[];this.defaultTicks=null;this.parentPolygon=null;this.id=this.board.addLine(this);this.point1.addChild(this);this.point2.addChild(this);this.update()};JXG.Line.prototype=new JXG.GeometryElement;JXG.Line.prototype.hasPoint=function(m,k){var l=new JXG.Coords(JXG.COORDS_BY_SCREEN,[m,k],this.board);var o=false;var e;var f=this.getSlope();var j=this.getRise();if(this.visProp.straightFirst&&this.visProp.straightLast){var h=[];h[0]=this.stdform[0]-this.stdform[1]*this.board.origin.scrCoords[1]/(this.board.unitX*this.board.zoomX)+this.stdform[2]*this.board.origin.scrCoords[2]/(this.board.unitY*this.board.zoomY);h[1]=this.stdform[1]/(this.board.unitX*this.board.zoomX);h[2]=this.stdform[2]/(-this.board.unitY*this.board.zoomY);var q=this.board.algebra.innerProduct(h,l.scrCoords,3);return(Math.abs(q)<0.5)?true:false}else{var d=this.point1.coords.scrCoords;var n=this.point2.coords.scrCoords;if(f!="INF"){for(e=-this.r;e<this.r;e++){o=o|(Math.abs(k-(f*(m+e)+j))<this.r)}if(o){var p=l.distance(JXG.COORDS_BY_SCREEN,this.point1.coords);var g=l.distance(JXG.COORDS_BY_SCREEN,this.point2.coords);var b=this.point1.coords.distance(JXG.COORDS_BY_SCREEN,this.point2.coords);if((p>b)||(g>b)){if(p<g){if(!this.visProp.straightFirst){o=false}}else{if(!this.visProp.straightLast){o=false}}}}}else{o=(Math.abs(m-d[1])<this.r);if(o){if(!this.visProp.straightFirst){if(d[2]<n[2]){if(k<d[2]){o=false}}else{if(d[2]>n[2]){if(k>d[2]){o=false}}}}if(!this.visProp.straightLast){if(d[2]<n[2]){if(k>n[2]){o=false}}else{if(d[2]>n[2]){if(k<n[2]){o=false}}}}}}}return o};JXG.Line.prototype.hasPointOld=function(l,j){var d=this.point1.coords.scrCoords;var m=this.point2.coords.scrCoords;var k=new JXG.Coords(JXG.COORDS_BY_SCREEN,[l,j],this.board);var n=false;var e;var f=this.getSlope();var h=this.getRise();if(this.visProp.straightFirst&&this.visProp.straightLast){if(f!="INF"){for(e=-this.r;e<this.r;e++){n=n|(Math.abs(j-(f*(l+e)+h))<this.r)}}else{n=(Math.abs(l-d[1])<this.r)}}else{if(f!="INF"){for(e=-this.r;e<this.r;e++){n=n|(Math.abs(j-(f*(l+e)+h))<this.r)}if(n){var o=k.distance(JXG.COORDS_BY_SCREEN,this.point1.coords);var g=k.distance(JXG.COORDS_BY_SCREEN,this.point2.coords);var b=this.point1.coords.distance(JXG.COORDS_BY_SCREEN,this.point2.coords);if((o>b)||(g>b)){if(o<g){if(!this.visProp.straightFirst){n=false}}else{if(!this.visProp.straightLast){n=false}}}}}else{n=(Math.abs(l-d[1])<this.r);if(n){if(!this.visProp.straightFirst){if(d[2]<m[2]){if(j<d[2]){n=false}}else{if(d[2]>m[2]){if(j>d[2]){n=false}}}}if(!this.visProp.straightLast){if(d[2]<m[2]){if(j>m[2]){n=false}}else{if(d[2]>m[2]){if(j<m[2]){n=false}}}}}}}return n};JXG.Line.prototype.update=function(){if(this.needsUpdate){if(true||!this.board.geonextCompatibilityMode){this.updateStdform()}for(var b=0;b<this.ticks.length;b++){if(typeof this.ticks[b]!="undefined"){this.ticks[b].calculateTicksCoordinates()}}}if(this.traced){this.cloneToBackground(true)}};JXG.Line.prototype.updateStdform=function(){var b=[];b=this.board.algebra.crossProduct(this.point1.coords.usrCoords,this.point2.coords.usrCoords);this.stdform[0]=b[0];this.stdform[1]=b[1];this.stdform[2]=b[2];this.stdform[3]=0;this.normalize()};JXG.Line.prototype.updateRenderer=function(){if(this.needsUpdate&&this.visProp.visible){var b=this.isReal;this.isReal=(isNaN(this.point1.coords.usrCoords[1]+this.point1.coords.usrCoords[2]+this.point2.coords.usrCoords[1]+this.point2.coords.usrCoords[2]))?false:true;if(this.isReal){if(b!=this.isReal){this.board.renderer.show(this)}this.board.renderer.updateLine(this)}else{if(b!=this.isReal){this.board.renderer.hide(this)}}this.needsUpdate=false}};JXG.Line.prototype.getRise=function(){var b=this.point1.coords.scrCoords;var d=this.point2.coords.scrCoords;return Math.round((b[2]-(b[1]*(d[2]-b[2]))/(d[1]-b[1])))};JXG.Line.prototype.getSlope=function(){var e=this.point1.coords.scrCoords;var b=this.point2.coords.scrCoords;var f=this.point1.coords.usrCoords;var d=this.point2.coords.usrCoords;if(Math.abs(b[1]-e[1])<=Math.abs(d[1]-f[1])){b=d;e=f}if(Math.abs(b[1]-e[1])>=JXG.Math.eps){return((b[2]-e[2])/(b[1]-e[1]))}else{return"INF"}};JXG.Line.prototype.setStraight=function(b,d){this.visProp.straightFirst=b;this.visProp.straightLast=d;this.board.renderer.updateLine(this)};JXG.Line.prototype.setArrow=function(d,b){this.visProp.firstArrow=d;this.visProp.lastArrow=b;this.board.renderer.updateLine(this)};JXG.Line.prototype.getTextAnchor=function(){return new JXG.Coords(JXG.COORDS_BY_USER,[0.5*(this.point2.X()-this.point1.X()),0.5*(this.point2.Y()-this.point1.Y())],this.board)};JXG.Line.prototype.cloneToBackground=function(d){var f={};f.id=this.id+"T"+this.numTraces;this.numTraces++;f.point1=this.point1;f.point2=this.point2;f.stdform=this.stdform;f.board={};f.board.unitX=this.board.unitX;f.board.unitY=this.board.unitY;f.board.zoomX=this.board.zoomX;f.board.zoomY=this.board.zoomY;f.board.origin=this.board.origin;f.board.canvasHeight=this.board.canvasHeight;f.board.canvasWidth=this.board.canvasWidth;f.board.dimension=this.board.dimension;f.board.algebra=this.board.algebra;f.visProp=this.visProp;var b=this.getSlope();var e=this.getRise();f.getSlope=function(){return b};f.getRise=function(){return e};this.board.renderer.enhancedRendering=true;this.board.renderer.drawLine(f);this.board.renderer.enhancedRendering=false;this.traces[f.id]=document.getElementById(f.id);delete f};JXG.Line.prototype.addTransform=function(b){var e;if(JXG.IsArray(b)){e=b}else{e=[b]}for(var d=0;d<e.length;d++){this.point1.transformations.push(e[d]);this.point2.transformations.push(e[d])}};JXG.Line.prototype.setPosition=function(f,b,e){var d=this.board.createElement("transform",[b,e],{type:"translate"});if(this.point1.transformations.length>0&&this.point1.transformations[this.point1.transformations.length-1].isNumericMatrix){this.point1.transformations[this.point1.transformations.length-1].melt(d)}else{this.point1.addTransform(this.point1,d)}if(this.point2.transformations.length>0&&this.point2.transformations[this.point2.transformations.length-1].isNumericMatrix){this.point2.transformations[this.point2.transformations.length-1].melt(d)}else{this.point2.addTransform(this.point2,d)}};JXG.Line.prototype.X=function(j){j*=Math.PI;var m=this.stdform[1];var l=this.stdform[2];var k=this.stdform[0];var g=m*Math.cos(j)+l*Math.sin(j);var f=k;var d=Math.sqrt(g*g+f*f);var e=-f/d;var h=g/d;if(Math.abs(h)<this.board.algebra.eps){h=1}return e*Math.cos(j)/h};JXG.Line.prototype.Y=function(j){j*=Math.PI;var m=this.stdform[1];var l=this.stdform[2];var k=this.stdform[0];var g=m*Math.cos(j)+l*Math.sin(j);var f=k;var d=Math.sqrt(g*g+f*f);var e=-f/d;var h=g/d;if(Math.abs(h)<this.board.algebra.eps){h=1}return e*Math.sin(j)/h};JXG.Line.prototype.Z=function(h){h*=Math.PI;var f=this.stdform[1];var e=this.stdform[2];var l=this.stdform[0];var d=f*Math.cos(h)+e*Math.sin(h);var k=l;var g=Math.sqrt(d*d+k*k);var j=d/g;if(Math.abs(j)>=this.board.algebra.eps){return 1}else{return 0}};JXG.Line.prototype.minX=function(){return 0};JXG.Line.prototype.maxX=function(){return 1};JXG.Line.prototype.addTicks=function(b){if(b.id==""||typeof b.id=="undefined"){b.id=this.id+"_ticks_"+(this.ticks.length+1)}this.board.renderer.drawTicks(b);this.ticks.push(b);this.ticks[this.ticks.length-1].updateRenderer();return b.id};JXG.Line.prototype.removeAllTicks=function(){for(var b=this.ticks.length;b>0;b--){this.board.renderer.remove(this.ticks[b-1].rendNode)}this.ticks=new Array()};JXG.Line.prototype.removeTicks=function(e){if(this.defaultTicks!=null&&this.defaultTicks==e){this.defaultTicks=null}for(var d=this.ticks.length;d>0;d--){if(this.ticks[d-1]==e){this.board.renderer.remove(this.ticks[d-1].rendNode);for(var b=0;b<this.ticks[d-1].ticks.length;b++){if(this.ticks[d-1].labels[b]!=null){if(this.ticks[d-1].labels[b].show){this.board.renderer.remove(this.ticks[d-1].labels[b].rendNode)}}}delete (this.ticks[d-1])}}};JXG.createLine=function(f,k,e){var b;if((k[0].elementClass==JXG.OBJECT_CLASS_POINT)&&(k[1].elementClass==JXG.OBJECT_CLASS_POINT)){var m=JXG.GetReferenceFromParameter(f,k[0]);var l=JXG.GetReferenceFromParameter(f,k[1]);b=new JXG.Line(f,m.id,l.id,e.id,e.name)}else{if(k.length==3){var h=[];for(var d=0;d<3;d++){if(typeof k[d]=="number"){h[d]=function(n){return function(){return n}}(k[d])}else{if(typeof k[d]=="function"){h[d]=k[d]}else{throw ("Can't create line with parent types '"+(typeof k[0])+"' and '"+(typeof k[1])+"' and '"+(typeof k[2])+"'.");return}}}var m=f.createElement("point",[function(){return 0},function(){return h[2]()},function(){return -h[1]()}],{visible:false,name:" "});var l=f.createElement("point",[function(){return h[2]()*h[2]()+h[1]()*h[1]()},function(){return -h[1]()*h[0]()+h[2]()},function(){return -h[2]()*h[0]()-h[1]()}],{visible:false,name:" "});b=new JXG.Line(f,m.id,l.id,e.id,e.name)}else{if((k.length==2)&&(k[0].length>1&&k[1].length>1)){var j=f.createElement("point",k[0],{visible:false,fixed:true});var g=f.createElement("point",k[1],{visible:false,fixed:true});b=new JXG.Line(f,j.id,g.id,e.id,e.name)}else{throw ("Can't create line with parent types '"+(typeof k[0])+"' and '"+(typeof k[1])+"'.")}}}return b};JXG.JSXGraph.registerElement("line",JXG.createLine);JXG.createSegment=function(e,b,f){var d;if(f==null){f=new Object()}f.straightFirst=false;f.straightLast=false;d=e.createElement("line",b,f);return d};JXG.JSXGraph.registerElement("segment",JXG.createSegment);JXG.createArrow=function(f,d,b){var e;if((JXG.IsPoint(d[0]))&&(JXG.IsPoint(d[1]))){e=new JXG.Line(f,d[0],d[1],b.id,b.name);e.setStraight(false,false);e.setArrow(false,true)}else{throw ("Can't create arrow with parent types '"+(typeof d[0])+"' and '"+(typeof d[1])+"'.")}return e};JXG.JSXGraph.registerElement("arrow",JXG.createArrow);JXG.createAxis=function(g,m,d){if((JXG.IsArray(m[0])||JXG.IsPoint(m[0]))&&(JXG.IsArray(m[1])||JXG.IsPoint(m[1]))){var k;if(JXG.IsPoint(m[0])){k=m[0]}else{k=new JXG.Point(g,m[0],"","",false)}var j;if(JXG.IsPoint(m[1])){j=m[1]}else{j=new JXG.Point(g,m[1],"","",false)}k.fixed=true;j.fixed=true;if(d==null){d=new Object()}d.lastArrow=true;d.straightFirst=true;d.straightLast=true;if(d.strokeWidth==null){d.strokeWidth=1}var n=g.createElement("line",[k,j],d);n.needsRegularUpdate=false;if(d.minorTicks=="undefined"||d.minorTicks==null){d.minorTicks=4}if((d.insertTicks=="undefined")||(d.insertTicks==null)){d.insertTicks="true"}var h;if(d.ticksDistance!="undefined"&&d.ticksDistance!=null){h=d.ticksDistance}else{var e=new JXG.Coords(JXG.COORDS_BY_USER,[n.point1.coords.usrCoords.slice(1)],g);var b=new JXG.Coords(JXG.COORDS_BY_USER,[n.point2.coords.usrCoords.slice(1)],g);g.renderer.calcStraight(n,e,b);var f=e.distance(JXG.COORDS_BY_USER,b);h=1}var l=g.createElement("ticks",[n,h],d);l.needsRegularUpdate=false;n.defaultTicks=l}else{throw ("Can't create point with parent types '"+(typeof m[0])+"' and '"+(typeof m[1])+"'.")}return n};JXG.JSXGraph.registerElement("axis",JXG.createAxis);JXG.createTangent=function(j,l,d){var b=l[0];var k=b.slideObject;if(k.elementClass==JXG.OBJECT_CLASS_LINE){return j.createElement("line",[k.point1,k.point2],d)}else{if(k.elementClass==JXG.OBJECT_CLASS_CURVE){var e=k.X;var h=k.Y;return j.createElement("line",[function(){return -b.X()*j.D(h)(b.position)+b.Y()*j.D(e)(b.position)},function(){return j.D(h)(b.position)},function(){return -j.D(e)(b.position)}],d)}else{if(k.elementClass==JXG.OBJECT_CLASS_CIRCLE){var m=function(f){return -k.getRadius()*Math.sin(f)};var n=function(f){return k.getRadius()*Math.cos(f)};return j.createElement("line",[function(){return -b.X()*n(b.position)+b.Y()*m(b.position)},function(){return n(b.position)},function(){return -m(b.position)}],d)}}}};JXG.JSXGraph.registerElement("tangent",JXG.createTangent);JXG.Group=function(g,k,b){this.board=g;this.objects={};var h=this.board.numObjects;this.board.numObjects++;if((k=="")||(k==null)||(typeof k=="undefined")){this.id=this.board.id+"Group"+h}else{this.id=k}this.type=JXG.OBJECT_TYPE_POINT;this.elementClass=JXG.OBJECT_CLASS_POINT;if((b=="")||(b==null)||(typeof b=="undefined")){this.name="group_"+this.board.generateName(this)}else{this.name=b}delete (this.type);var f;if((arguments.length==4)&&(JXG.IsArray(arguments[3]))){f=arguments[3]}else{f=[];for(var d=3;d<arguments.length;d++){f.push(arguments[d])}}for(var d=0;d<f.length;d++){var j=JXG.GetReferenceFromParameter(this.board,f[d]);if((!j.fixed)&&((j.type==JXG.OBJECT_TYPE_POINT)||(j.type==JXG.OBJECT_TYPE_GLIDER))){if(j.group.length!=0){this.addGroup(j.group[j.group.length-1])}else{this.addPoint(j)}}}for(var e in this.objects){this.objects[e].group.push(this)}this.dX=0;this.dY=0};JXG.Group.prototype.ungroup=function(){for(var b in this.objects){if(this.objects[b].group[this.objects[b].group.length-1]==this){this.objects[b].group.pop()}delete (this.objects[b])}};JXG.Group.prototype.update=function(b){var d=null;for(var e in this.objects){d=this.objects[e];if(d.id!=b.id){d.coords=new JXG.Coords(JXG.COORDS_BY_SCREEN,[d.coords.scrCoords[1]+this.dX,d.coords.scrCoords[2]+this.dY],d.board)}}for(var e in this.objects){if(this.board.objects[e]!=undefined){this.objects[e].update(false)}else{delete (this.objects[e])}}};JXG.Group.prototype.addPoint=function(b){this.objects[b.id]=b};JXG.Group.prototype.addPoints=function(b){for(var d in b){this.objects[d.id]=d}};JXG.Group.prototype.addGroup=function(d){for(var b in d.objects){this.addPoint(d.objects[b])}};JXG.createGroup=function(e,d,b){var f=new JXG.Group(e,b.id,b.name,d);return f};JXG.JSXGraph.registerElement("group",JXG.createGroup);JXG.Circle=function(f,h,e,d,g,b){this.constructor();this.init(f,g,b);this.type=JXG.OBJECT_TYPE_CIRCLE;this.elementClass=JXG.OBJECT_CLASS_CIRCLE;this.method=h;this.midpoint=JXG.GetReferenceFromParameter(this.board,e);this.midpoint.addChild(this);this.visProp.visible=true;this.visProp.fillColor=this.board.options.circle.fillColor;this.visProp.highlightFillColor=this.board.options.circle.highlightFillColor;this.visProp.strokeColor=this.board.options.circle.strokeColor;this.visProp.highlightStrokeColor=this.board.options.circle.highlightStrokeColor;this.point2=null;this.radius=0;this.line=null;this.circle=null;if(h=="twoPoints"){this.point2=JXG.GetReferenceFromParameter(f,d);this.point2.addChild(this);this.radius=this.getRadius();this.id=this.board.addCircle(this)}else{if(h=="pointRadius"){this.generateTerm(d);this.updateRadius();this.id=this.board.addCircle(this);this.notifyParents(d)}else{if(h=="pointLine"){this.line=JXG.GetReferenceFromParameter(f,d);this.radius=this.line.point1.coords.distance(JXG.COORDS_BY_USER,this.line.point2.coords);this.line.addChild(this);this.id=this.board.addCircle(this)}else{if(h=="pointCircle"){this.circle=JXG.GetReferenceFromParameter(f,d);this.radius=this.circle.getRadius();this.circle.addChild(this);this.id=this.board.addCircle(this)}}}}};JXG.Circle.prototype=new JXG.GeometryElement;JXG.Circle.prototype.hasPoint=function(b,h){var g=this.board.options.precision.hasPoint;g=g/(this.board.unitX*this.board.zoomX);var f=new JXG.Coords(JXG.COORDS_BY_SCREEN,[b,h],this.board);var d=this.getRadius();var e=Math.sqrt(Math.pow(this.midpoint.coords.usrCoords[1]-f.usrCoords[1],2)+Math.pow(this.midpoint.coords.usrCoords[2]-f.usrCoords[2],2));return(Math.abs(e-d)<g)};JXG.Circle.prototype.update=function(){if(this.traced){this.cloneToBackground(true)}if(this.needsUpdate){if(this.method=="pointLine"){this.radius=this.line.point1.coords.distance(JXG.COORDS_BY_USER,this.line.point2.coords)}else{if(this.method=="pointCircle"){this.radius=this.circle.getRadius()}else{if(this.method=="pointRadius"){this.radius=this.updateRadius()}}}if(!this.board.geonextCompatibilityMode){this.updateStdform()}}};JXG.Circle.prototype.updateStdform=function(){this.stdform[3]=0.5;this.stdform[4]=this.getRadius();this.stdform[1]=-this.midpoint.coords.usrCoords[1];this.stdform[2]=-this.midpoint.coords.usrCoords[2];this.normalize()};JXG.Circle.prototype.updateRenderer=function(){if(this.needsUpdate&&this.visProp.visible){var b=this.isReal;this.isReal=(isNaN(this.midpoint.coords.usrCoords[1]+this.midpoint.coords.usrCoords[2]+this.getRadius()))?false:true;if(this.isReal){if(b!=this.isReal){this.board.renderer.show(this)}this.board.renderer.updateCircle(this)}else{if(b!=this.isReal){this.board.renderer.hide(this)}}this.needsUpdate=false}};JXG.Circle.prototype.generateTerm=function(d){if(typeof d=="string"){var e=this.board.elementsByName;var b=this.board.algebra.geonext2JS(d+"");this.updateRadius=new Function("return "+b+";")}else{if(typeof d=="number"){this.updateRadius=function(){return d}}else{this.updateRadius=d}}};JXG.Circle.prototype.notifyParents=function(d){var b=null;var e=this.board.elementsByName;this.board.algebra.findDependencies(this,d+"")};JXG.Circle.prototype.getRadius=function(){if(this.method=="twoPoints"){return(Math.sqrt(Math.pow(this.midpoint.coords.usrCoords[1]-this.point2.coords.usrCoords[1],2)+Math.pow(this.midpoint.coords.usrCoords[2]-this.point2.coords.usrCoords[2],2)))}else{if(this.method=="pointLine"||this.method=="pointCircle"){return this.radius}else{if(this.method=="pointRadius"){return this.updateRadius()}}}};JXG.Circle.prototype.getTextAnchor=function(){return this.midpoint.coords};JXG.Circle.prototype.cloneToBackground=function(b){var e={};e.id=this.id+"T"+this.numTraces;this.numTraces++;e.midpoint={};e.midpoint.coords=this.midpoint.coords;var d=this.getRadius();e.getRadius=function(){return d};e.board={};e.board.unitX=this.board.unitX;e.board.unitY=this.board.unitY;e.board.zoomX=this.board.zoomX;e.board.zoomY=this.board.zoomY;e.visProp=this.visProp;this.board.renderer.drawCircle(e);this.traces[e.id]=document.getElementById(e.id);delete e};JXG.Circle.prototype.addTransform=function(b){var e;if(JXG.IsArray(b)){e=b}else{e=[b]}for(var d=0;d<e.length;d++){this.midpoint.transformations.push(e[d]);if(this.method=="twoPoints"){this.point2.transformations.push(e[d])}}};JXG.Circle.prototype.setPosition=function(f,b,e){var d=this.board.createElement("transform",[b,e],{type:"translate"});this.addTransform(d)};JXG.Circle.prototype.X=function(b){b*=2*Math.PI;return this.getRadius()*Math.cos(b)+this.midpoint.coords.usrCoords[1]};JXG.Circle.prototype.Y=function(b){b*=2*Math.PI;return this.getRadius()*Math.sin(b)+this.midpoint.coords.usrCoords[2]};JXG.Circle.prototype.minX=function(){return 0};JXG.Circle.prototype.maxX=function(){return 1};JXG.createCircle=function(f,j,h){var e,g,d;g=[];for(d=0;d<j.length;d++){if(JXG.IsPoint(j[d])){g[d]=j[d]}else{if(j[d].length>1){g[d]=f.createElement("point",j[d],{visible:false,fixed:true})}else{g[d]=j[d]}}}if(j.length==2&&JXG.IsPoint(g[0])&&JXG.IsPoint(g[1])){e=new JXG.Circle(f,"twoPoints",g[0],g[1],h.id,h.name)}else{if((JXG.IsNumber(g[0])||JXG.IsFunction(g[0])||JXG.IsString(g[0]))&&JXG.IsPoint(g[1])){e=new JXG.Circle(f,"pointRadius",g[1],g[0],h.id,h.name)}else{if((JXG.IsNumber(g[1])||JXG.IsFunction(g[1])||JXG.IsString(g[1]))&&JXG.IsPoint(g[0])){e=new JXG.Circle(f,"pointRadius",g[0],g[1],h.id,h.name)}else{if((g[0].type==JXG.OBJECT_TYPE_CIRCLE)&&JXG.IsPoint(g[1])){e=new JXG.Circle(f,"pointCircle",g[1],g[0],h.id,h.name)}else{if((g[1].type==JXG.OBJECT_TYPE_CIRCLE)&&JXG.IsPoint(g[0])){e=new JXG.Circle(f,"pointCircle",g[0],g[1],h.id,h.name)}else{if((g[0].type==JXG.OBJECT_TYPE_LINE)&&JXG.IsPoint(g[1])){e=new JXG.Circle(f,"pointLine",g[1],g[0],h.id,h.name)}else{if((g[1].type==JXG.OBJECT_TYPE_LINE)&&JXG.IsPoint(g[0])){e=new JXG.Circle(f,"pointLine",g[0],g[1],h.id,h.name)}else{if(j.length==3&&JXG.IsPoint(g[0])&&JXG.IsPoint(g[1])&&JXG.IsPoint(g[2])){var b=JXG.createCircumcircle(f,g,h);b[0].setProperty({visible:false});return b[1]}else{throw ("Can't create circle with parent types '"+(typeof j[0])+"' and '"+(typeof j[1])+"'.")}}}}}}}}return e};JXG.JSXGraph.registerElement("circle",JXG.createCircle);JXG.Polygon=function(j,k,m,d,b,e){this.constructor();this.type=JXG.OBJECT_TYPE_POLYGON;this.elementClass=JXG.OBJECT_CLASS_AREA;this.init(j,d,b);if((typeof e=="undefined")||(e==null)){e=true}this.withLines=e;this.vertices=[];for(var g=0;g<k.length;g++){var h=JXG.GetReferenceFromParameter(this.board,k[g]);this.vertices[g]=h}if((typeof m=="undefined")||(m==null)){m=[];for(var g=0;g<k.length-1;g++){m[g]={}}}if(this.vertices[this.vertices.length-1]!=this.vertices[0]){this.vertices.push(this.vertices[0]);m.push({})}this.visProp.fillColor=this.board.options.polygon.fillColor;this.visProp.highlightFillColor=this.board.options.polygon.highlightFillColor;this.visProp.fillOpacity=this.board.options.polygon.fillOpacity;this.visProp.highlightFillOpacity=this.board.options.polygon.highlightFillOpacity;var f;this.borders=[];if(e){for(var g=0;g<this.vertices.length-1;g++){f=new JXG.Line(j,this.vertices[g],this.vertices[g+1],m[g].id,m[g].name);f.setStraight(false,false);this.borders[g]=f;f.parentPolygon=this}}for(var g=0;g<this.vertices.length-1;g++){var h=JXG.GetReferenceFromParameter(this.board,this.vertices[g]);h.addChild(this)}this.id=this.board.addPolygon(this)};JXG.Polygon.prototype=new JXG.GeometryElement;JXG.Polygon.prototype.hasPoint=function(b,d){return false};JXG.Polygon.prototype.updateRenderer=function(){if(this.needsUpdate){this.board.renderer.updatePolygon(this);this.needsUpdate=false}};JXG.Polygon.prototype.getTextAnchor=function(){var f=0;var e=0;var d=0;var h=0;f=d=this.vertices[0].X();e=h=this.vertices[0].Y();for(var g=0;g<this.vertices.length;g++){if(this.vertices[g].X()<f){f=this.vertices[g].X()}if(this.vertices[g].X()>d){d=this.vertices[g].X()}if(this.vertices[g].Y()>e){e=this.vertices[g].Y()}if(this.vertices[g].Y()<h){h=this.vertices[g].Y()}}return new JXG.Coords(JXG.COORDS_BY_USER,[(f+d)*0.5,(e+h)*0.5],this.board)};JXG.Polygon.prototype.cloneToBackground=function(b){var d={};d.id=this.id+"T"+this.numTraces;this.numTraces++;d.vertices=this.vertices;d.visProp=this.visProp;this.board.renderer.drawPolygon(d);this.traces[d.id]=$(d.id);delete d};JXG.createPolygon=function(f,b,g){var e;for(var d=0;d<b.length;d++){if(!JXG.IsPoint(b[d])){throw ("Can't create polygon with parent types other than 'point'.")}}e=new JXG.Polygon(f,b,g.borders,g.id,g.name,g.withLines);return e};JXG.JSXGraph.registerElement("polygon",JXG.createPolygon);JXG.Curve=function(e,d,f,b){this.constructor();this.points=[];this.numberPoints=0;this.type=JXG.OBJECT_TYPE_CURVE;this.elementClass=JXG.OBJECT_CLASS_CURVE;this.init(e,f,b);this.init(e,f,b);this.visProp.strokeWidth=this.board.options.curve.strokeWidth;this.visProp.visible=true;this.dataX=null;this.dataY=null;this.curveType=null;if(d[0]!=null){this.varname=d[0]}else{this.varname="x"}this.xterm=d[1];this.yterm=d[2];this.generateTerm(this.varname,this.xterm,this.yterm,d[3],d[4]);this.updateCurve();this.id=this.board.addCurve(this);if(typeof this.xterm=="string"){this.notifyParents(this.xterm)}if(typeof this.yterm=="string"){this.notifyParents(this.yterm)}};JXG.Curve.prototype=new JXG.GeometryElement;JXG.Curve.prototype.minX=function(){if(this.curveType=="polar"){return 0}else{var b=new JXG.Coords(JXG.COORDS_BY_SCREEN,[0,0],this.board);return b.usrCoords[1]}};JXG.Curve.prototype.maxX=function(){if(this.curveType=="polar"){return 2*Math.PI}else{var b=new JXG.Coords(JXG.COORDS_BY_SCREEN,[this.board.canvasWidth,0],this.board);return b.usrCoords[1]}};JXG.Curve.prototype.hasPoint=function(p,n){var r,l,k,s,f,e,q,o;var b=5/(this.board.unitX*this.board.zoomX);var g=new JXG.Coords(JXG.COORDS_BY_SCREEN,[p,n],this.board);p=g.usrCoords[1];n=g.usrCoords[2];if(this.curveType=="parameter"||this.curveType=="polar"){var m=300;var h=(this.maxX()-this.minX())/m;for(f=0,r=this.minX();f<m;f++){q=this.X(r);o=this.Y(r);for(e=0;e<this.transformations.length;e++){s=this.transformations[e];s.update();k=s.matVecMult(s.matrix,[1,q,o]);q=k[1];o=k[2]}l=Math.sqrt((p-q)*(p-q)+(n-o)*(n-o));if(l<b){return true}r+=h}}else{var m=300;var h=(this.maxX()-this.minX())/m;for(f=0,r=this.minX();f<m;f++){q=this.X(r);o=this.Y(r);for(e=0;e<this.transformations.length;e++){s=this.transformations[e];s.update();k=s.matVecMult(s.matrix,[1,q,o]);q=k[1];o=k[2]}l=Math.sqrt((p-q)*(p-q)+(n-o)*(n-o));if(l<b){return true}r+=h}}return(l<b)};JXG.Curve.prototype.allocatePoints=function(){if(this.points.length<this.numberPoints){for(var b=this.points.length;b<this.numberPoints;b++){this.points[b]=new JXG.Coords(JXG.COORDS_BY_USER,[0,0],this.board)}}};JXG.Curve.prototype.update=function(){if(this.needsUpdate){this.updateCurve()}};JXG.Curve.prototype.updateRenderer=function(){if(this.needsUpdate){this.board.renderer.updateCurve(this);this.needsUpdate=false}};JXG.Curve.prototype.updateDataArray=function(){};JXG.Curve.prototype.updateCurve=function(){this.updateDataArray();if(this.curveType=="plot"&&this.dataX!=null){this.numberPoints=this.dataX.length}else{if(this.board.updateQuality==this.board.BOARD_QUALITY_HIGH){this.numberPoints=this.board.canvasWidth*1.3}else{this.numberPoints=this.board.canvasWidth*0.25}}this.allocatePoints();var e=this.numberPoints;var f=this.minX();var j=this.maxX();var d,h;var b=(j-f)/e;for(var g=0;g<e;g++){if(this.dataX!=null){d=g;if(this.dataY!=null){h=g}else{h=this.X(d)}}else{d=f+g*b;h=d}this.points[g].setCoordinates(JXG.COORDS_BY_USER,[this.X(d),this.Y(h)]);this.updateTransform(this.points[g])}};JXG.Curve.prototype.updateTransform=function(e){if(this.transformations.length==0){return e}for(var d=0;d<this.transformations.length;d++){var b=this.transformations[d];b.update();var f=b.matVecMult(b.matrix,e.usrCoords);e.setCoordinates(JXG.COORDS_BY_USER,[f[1],f[2]])}return e};JXG.Curve.prototype.addTransform=function(b){var e;if(JXG.IsArray(b)){e=b}else{e=[b]}for(var d=0;d<e.length;d++){this.transformations.push(e[d])}};JXG.Curve.prototype.setPosition=function(f,b,e){var d=this.board.createElement("transform",[b,e],{type:"translate"});if(this.transformations.length>0&&this.transformations[this.transformations.length-1].isNumericMatrix){this.transformations[this.transformations.length-1].melt(d)}else{this.addTransform(d)}};JXG.Curve.prototype.generateTerm=function(b,l,j,g,k){this.numberPoints=this.board.canvasWidth*1;if(typeof l=="string"){var f=this.board.algebra.geonext2JS(l);this.X=new Function(b,"return "+f+";");this.curveType="functiongraph"}else{if(typeof l=="function"){this.X=l;this.curveType="parameter"}else{if(typeof l=="number"){this.X=function(){return l};this.curveType="parameter"}else{if(typeof l=="object"){this.curveType="plot";this.dataX=l;this.X=function(m){return this.dataX[m]};this.numberPoints=this.dataX.length}}}}if(typeof j=="string"){var d=this.board.algebra.geonext2JS(j);this.Y=new Function(b,"return "+d+";")}else{if(typeof j=="function"){this.Y=j}else{if(typeof j=="number"){this.Y=function(){return j}}else{if(typeof j=="object"){this.dataY=j;this.Y=function(m){return this.dataY[m]}}}}}if(typeof l=="function"&&typeof j=="object"){this.X=function(m){return(l)(m)*Math.cos(m)+j[0]};this.Y=function(m){return(l)(m)*Math.sin(m)+j[1]};this.curveType="parameter"}if(g!=null){if(typeof g=="string"){var e=this.board.algebra.geonext2JS(g);this.minX=new Function("","return "+e+";")}else{if(typeof g=="function"){this.minX=g}else{if(typeof g=="number"){this.minX=function(){return g}}}}}if(k!=null){if(typeof k=="string"){var h=this.board.algebra.geonext2JS(k);this.maxX=new Function("","return "+h+";")}else{if(typeof k=="function"){this.maxX=k}else{if(typeof k=="number"){this.maxX=function(){return k}}}}}};JXG.Curve.prototype.notifyParents=function(d){var b=null;var e=this.board.elementsByName;this.board.algebra.findDependencies(this,d)};JXG.createCurve=function(e,d,b){return new JXG.Curve(e,["x"].concat(d),b.id,b.name)};JXG.JSXGraph.registerElement("curve",JXG.createCurve);JXG.createFunctiongraph=function(f,d,b){var e=["x","x"].concat(d);if(b==null){b={}}b.curveType="functiongraph";return new JXG.Curve(f,e,b.id,b.name)};JXG.JSXGraph.registerElement("functiongraph",JXG.createFunctiongraph);JXG.createSpline=function(e,d,b){var f=function(j){var g=new Array();var l=new Array();for(var h=0;h<d.length;h++){if(!JXG.IsPoint(d[h])){throw"JXG.createSpline: Parents has to be an array of JXG.Point."}g.push(d[h].X());l.push(d[h].Y())}var k=JXG.Math.Numerics.splineDef(g,l);return JXG.Math.Numerics.splineEval(j,g,l,k)};return new JXG.Curve(e,["x","x",f],b)};JXG.JSXGraph.registerElement("spline",JXG.createSpline);JXG.createRiemannsum=function(h,m,d){var e,b,l,g;g=m[0];if(typeof m[1]=="number"){b=function(){return m[1]}}else{if(typeof m[1]=="function"){b=m[1]}else{throw"JXG.createRiemannsum: n has to be number or function."}}if(typeof m[2]=="string"){l=function(){return m[2]}}else{if(typeof m[2]=="function"){l=m[2]}else{throw"JXG.createRiemannsum: type has to be string or function."}}var j=["x",[0],[0]].concat(m.slice(3));if(d==null){d={}}d.opacity=d.opacity||0.3;d.fillColor=d.fillColor||"#ffff00";d.curveType="plot";var k=new JXG.Curve(h,j,d.id,d.name);k.updateDataArray=function(){var f=JXG.Math.Numerics.riemann(g,b(),l(),this.minX(),this.maxX());this.dataX=f[0];this.dataY=f[1]};return k};JXG.JSXGraph.registerElement("riemannsum",JXG.createRiemannsum);JXG.Arc=function(d,g,f,e,h,b){this.constructor();this.type=JXG.OBJECT_TYPE_ARC;this.elementClass=JXG.OBJECT_CLASS_CIRCLE;this.init(d,h,b);this.midpoint=JXG.GetReferenceFromParameter(this.board,g);this.point2=JXG.GetReferenceFromParameter(this.board,f);this.point3=JXG.GetReferenceFromParameter(this.board,e);this.r=this.board.options.precision.hasPoint;this.visProp.visible=true;this.visProp.firstArrow=this.board.options.arc.firstArrow;this.visProp.lastArrow=this.board.options.arc.lastArrow;this.visProp.fillColor=this.board.options.arc.fillColor;this.visProp.highlightFillColor=this.board.options.arc.highlightFillColor;this.visProp.strokeColor=this.board.options.arc.strokeColor;this.visProp.highlightStrokeColor=this.board.options.arc.highlightStrokeColor;this.id=this.board.addArc(this);this.midpoint.addChild(this);this.point2.addChild(this);this.point3.addChild(this)};JXG.Arc.prototype=new JXG.GeometryElement;JXG.Arc.prototype.hasPoint=function(l,k){var n=this.r/(this.board.unitX*this.board.zoomX);var h=new JXG.Coords(JXG.COORDS_BY_SCREEN,[l,k],this.board);var b=this.getRadius();var j=Math.sqrt(Math.pow(this.midpoint.coords.usrCoords[1]-h.usrCoords[1],2)+Math.pow(this.midpoint.coords.usrCoords[2]-h.usrCoords[2],2));var m=(Math.abs(j-b)<n);if(m){var d={};d.coords=new JXG.Coords(JXG.COORDS_BY_USER,[this.midpoint.coords.usrCoords[1],this.board.origin.usrCoords[2]/(this.board.unitY*this.board.zoomY)],this.board);var g=this.board.algebra.trueAngle(this.point2,this.midpoint,d);var f=this.board.algebra.trueAngle(this.point3,this.midpoint,d);var o={};o.coords=h;var e=this.board.algebra.trueAngle(o,this.midpoint,d);if(g>=f){if(g<e||e<f){m=false}}else{if(e>g){if(e<f){m=false}}}}return m};JXG.Arc.prototype.getRadius=function(){return(Math.sqrt(Math.pow(this.midpoint.coords.usrCoords[1]-this.point2.coords.usrCoords[1],2)+Math.pow(this.midpoint.coords.usrCoords[2]-this.point2.coords.usrCoords[2],2)))};JXG.Arc.prototype.updateRenderer=function(){if(this.needsUpdate){this.board.renderer.updateArc(this);this.needsUpdate=false}};JXG.Arc.prototype.setArrow=function(d,b){this.visProp.firstArrow=d;this.visProp.lastArrow=b;this.board.renderer.updateArc(this)};JXG.createArc=function(f,d,b){var e;if((JXG.IsPoint(d[0]))&&(JXG.IsPoint(d[1]))&&(JXG.IsPoint(d[2]))){e=new JXG.Arc(f,d[0],d[1],d[2],b.id,b.name)}else{throw ("Can't create Arc with parent types '"+(typeof d[0])+"' and '"+(typeof d[1])+"' and '"+(typeof d[2])+"'.")}return e};JXG.JSXGraph.registerElement("arc",JXG.createArc);JXG.Sector=function(k,r,q,o,b,l,f){this.constructor();this.type=JXG.OBJECT_TYPE_SECTOR;this.elementClass=JXG.OBJECT_CLASS_AREA;this.init(k,f,"");if(!JXG.IsArray(b)){b=[null,null,null,null]}if(!JXG.IsArray(l)){l=[null,null,null,null]}this.point1=JXG.GetReferenceFromParameter(this.board,r);this.point2=JXG.GetReferenceFromParameter(this.board,q);this.point3=JXG.GetReferenceFromParameter(this.board,o);this.r=this.board.options.precision.hasPoint;this.visProp.visible=true;var d={};d.midpoint=this.point1;var j=this.getRadius();d.getRadius=function(){return j};var n=this.board.algebra.projectPointToCircle(this.point3,d);var e=new JXG.Point(k,[n.usrCoords[1],n.usrCoords[2]],b[1],l[1],true);e.fixed=true;this.addChild(e);e.update=function(){var s={};s.midpoint=JXG.GetReferenceFromParameter(this.board,r);var p=(Math.sqrt(Math.pow(JXG.GetReferenceFromParameter(this.board,r).coords.usrCoords[1]-JXG.GetReferenceFromParameter(this.board,q).coords.usrCoords[1],2)+Math.pow(JXG.GetReferenceFromParameter(this.board,r).coords.usrCoords[2]-JXG.GetReferenceFromParameter(this.board,q).coords.usrCoords[2],2)));s.getRadius=function(){return p};n=this.board.algebra.projectPointToCircle(JXG.GetReferenceFromParameter(this.board,o),s);this.coords=n;this.board.renderer.updatePoint(this);if(this.label.show){this.label.setCoordinates(this.coords);this.board.renderer.updateLabel(this.label)}};var h=new JXG.Line(k,r,q,b[2],l[2]);var g=new JXG.Line(k,r,e.id,b[3],l[3]);h.setStraight(false,false);g.setStraight(false,false);var m=new JXG.Arc(k,r,q,o,b[0],l[0]);m.visProp.fillColor=this.board.options.sector.fillColor;m.visProp.highlightFillColor=this.board.options.sector.highlightFillColor;m.visProp.fillOpacity=this.board.options.sector.fillOpacity;m.visProp.highlightFillOpacity=this.board.options.sector.highlightFillOpacity;this.point4=e;this.lines=[h,g];this.arc=m;this.id=this.board.addSector(this);this.point1.addChild(this);this.point2.addChild(this);this.point3.addChild(this)};JXG.Sector.prototype=new JXG.GeometryElement;JXG.Sector.prototype.hasPoint=function(b,d){return false};JXG.Sector.prototype.getRadius=function(){return(Math.sqrt(Math.pow(this.point1.coords.usrCoords[1]-this.point2.coords.usrCoords[1],2)+Math.pow(this.point1.coords.usrCoords[2]-this.point2.coords.usrCoords[2],2)))};JXG.Sector.prototype.updateRenderer=function(){};JXG.createSector=function(d,f,e){var b;if((JXG.IsPoint(f[0]))&&(JXG.IsPoint(f[1]))&&(JXG.IsPoint(f[2]))){b=new JXG.Sector(d,f[0],f[1],f[2],e.ids,e.names,e.id)}else{throw ("Can't create sector with parent types '"+(typeof f[0])+"' and '"+(typeof f[1])+"' and '"+(typeof f[2])+"'.")}return b};JXG.JSXGraph.registerElement("sector",JXG.createSector);JXG.Angle=function(e,j,g,f,b,h,k,d){this.constructor();this.type=JXG.OBJECT_TYPE_ANGLE;this.elementClass=JXG.OBJECT_CLASS_AREA;this.init(e,k,d);this.point1=JXG.GetReferenceFromParameter(this.board,j);this.point2=JXG.GetReferenceFromParameter(this.board,g);this.point3=JXG.GetReferenceFromParameter(this.board,f);this.radius=this.board.options.angle.radius;if(b!=undefined&&b!=null){this.radius=b}this.visProp.fillColor=this.board.options.angle.fillColor;this.visProp.highlightFillColor=this.board.options.angle.highlightFillColor;this.visProp.fillOpacity=this.board.options.angle.fillOpacity;this.visProp.highlightFillOpacity=this.board.options.angle.highlightFillOpacity;this.visProp.strokeColor=this.board.options.angle.strokeColor;this.text=h;this.id=this.board.addAngle(this);this.point1.addChild(this);this.point2.addChild(this);this.point3.addChild(this)};JXG.Angle.prototype=new JXG.GeometryElement;JXG.Angle.prototype.hasPoint=function(b,d){return false};JXG.Angle.prototype.updateRenderer=function(){if(this.needsUpdate){this.board.renderer.updateAngle(this);this.needsUpdate=false}};JXG.createAngle=function(f,d,b){var e;if((JXG.IsPoint(d[0]))&&(JXG.IsPoint(d[1]))&&(JXG.IsPoint(d[2]))){e=new JXG.Angle(f,d[0],d[1],d[2],b.id,b.name)}else{throw ("Can't create angle with parent types '"+(typeof d[0])+"' and '"+(typeof d[1])+"' and '"+(typeof d[2])+"'.")}return e};JXG.JSXGraph.registerElement("angle",JXG.createAngle);JXG.Label=function(d,b,e,f){if(typeof(d)=="string"){d=JXG.Geonext.boards[d]}this.board=d;this.id=f;this.name=b+"Label";this.nameHTML=this.board.algebra.replaceSup(this.board.algebra.replaceSub(b));this.distanceX=10;this.distanceY=10;this.coords=new JXG.Coords(JXG.COORDS_BY_USER,[e.usrCoords[1]*1+this.distanceX/(this.board.unitX*this.board.zoomX),e.usrCoords[2]*1+this.distanceY/(this.board.unitY*this.board.zoomY)],this.board);this.show=true;this.color="#000000";this.hiddenByParent=false};JXG.Label.prototype.hideElement=function(){this.show=false;this.board.renderer.hide(this)};JXG.Label.prototype.showElement=function(){this.show=true;this.board.renderer.show(this)};JXG.Label.prototype.setCoordinates=function(b){this.coords=new JXG.Coords(JXG.COORDS_BY_USER,[b.usrCoords[1]*1+this.distanceX/(this.board.unitX*this.board.zoomX),b.usrCoords[2]*1+this.distanceY/(this.board.unitY*this.board.zoomY)],this.board)};JXG.Algebra=function(b){this.board=b;this.eps=0.00001};JXG.Algebra.prototype.angle=function(g,e,d){var k=[];var j=[];var h=[];if(g.coords==null){k[0]=g[0];k[1]=g[1]}else{k[0]=g.coords.usrCoords[1];k[1]=g.coords.usrCoords[2]}if(e.coords==null){j[0]=e[0];j[1]=e[1]}else{j[0]=e.coords.usrCoords[1];j[1]=e.coords.usrCoords[2]}if(d.coords==null){h[0]=d[0];h[1]=d[1]}else{h[0]=d.coords.usrCoords[1];h[1]=d.coords.usrCoords[2]}var m=k[0]-j[0];var l=k[1]-j[1];var o=h[0]-j[0];var n=h[1]-j[1];var f=Math.atan((m*n-l*o)/(m*o+l*n));return f};JXG.Algebra.prototype.trueAngle=function(h,g,e){var b;var s;var q;var o;var m;var l;if(h.coords==null){b=h[0];s=h[1]}else{b=h.coords.usrCoords[1];s=h.coords.usrCoords[2]}if(g.coords==null){q=g[0];o=g[1]}else{q=g.coords.usrCoords[1];o=g.coords.usrCoords[2]}if(e.coords==null){m=e[0];l=e[1]}else{m=e.coords.usrCoords[1];l=e.coords.usrCoords[2]}var f=(m-q)*(b-q)+(l-o)*(s-o);var p=(b-q)*(l-o)-(s-o)*(m-q);var k=Math.sqrt((b-q)*(b-q)+(s-o)*(s-o));var j=Math.sqrt((m-q)*(m-q)+(l-o)*(l-o));var d=f/(k*j);if(d>1){d=1}else{if(d<-1){d=-1}}var r=Math.acos(d);var n=0;if((Math.sin(r)*p)<0){n=2*Math.PI-r}else{n=r}n=(n/Math.PI)*180;return n};JXG.Algebra.prototype.angleBisector=function(g,f,e){var l=g.coords.usrCoords[1]-f.coords.usrCoords[1];var k=g.coords.usrCoords[2]-f.coords.usrCoords[2];var j=Math.sqrt(l*l+k*k);l/=j;k/=j;var b=Math.acos(l);if(k<0){b*=-1}if(b<0){b+=2*Math.PI}l=e.coords.usrCoords[1]-f.coords.usrCoords[1];k=e.coords.usrCoords[2]-f.coords.usrCoords[2];j=Math.sqrt(l*l+k*k);l/=j;k/=j;var m=Math.acos(l);if(k<0){m*=-1}if(m<0){m+=2*Math.PI}var h=(b+m)*0.5;if(b>m){h+=Math.PI}l=Math.cos(h)+f.coords.usrCoords[1];k=Math.sin(h)+f.coords.usrCoords[2];return new JXG.Coords(JXG.COORDS_BY_USER,[l,k],this.board)};JXG.Algebra.prototype.midpoint=function(b,d){return new JXG.Coords(JXG.COORDS_BY_USER,[(b.coords.usrCoords[1]+d.coords.usrCoords[1])/2,(b.coords.usrCoords[2]+d.coords.usrCoords[2])/2],this.board)};JXG.Algebra.prototype.parallel=function(g,f,d){var e=1;var b=d.coords.usrCoords[1]+e*(f.coords.usrCoords[1]-g.coords.usrCoords[1]);var h=d.coords.usrCoords[2]+e*(f.coords.usrCoords[2]-g.coords.usrCoords[2]);return new JXG.Coords(JXG.COORDS_BY_USER,[b,h],this.board)};JXG.Algebra.prototype.reflection=function(k,h){var j=k.point2.coords.usrCoords[1]-k.point1.coords.usrCoords[1];var g=k.point2.coords.usrCoords[2]-k.point1.coords.usrCoords[2];var d=h.coords.usrCoords[1]-k.point1.coords.usrCoords[1];var f=h.coords.usrCoords[2]-k.point1.coords.usrCoords[2];var l=(j*f-g*d)/(j*j+g*g);var b=h.coords.usrCoords[1]+2*l*g;var e=h.coords.usrCoords[2]-2*l*j;return new JXG.Coords(JXG.COORDS_BY_USER,[b,e],this.board)};JXG.Algebra.prototype.rotation=function(b,k,f){var e=k.coords.usrCoords[1]-b.coords.usrCoords[1];var j=k.coords.usrCoords[2]-b.coords.usrCoords[2];var d,h;var g=Math.cos(f);var l=Math.sin(f);d=e*g-j*l+b.coords.usrCoords[1];h=e*l+j*g+b.coords.usrCoords[2];return new JXG.Coords(JXG.COORDS_BY_USER,[d,h],this.board)};JXG.Algebra.prototype.perpendicular=function(p,n){var l;var j;var k;var g=p.point1.coords;var f=p.point2.coords;var d=n.coords;if(n==p.point1){l=g.usrCoords[1]+f.usrCoords[2]-g.usrCoords[2];j=g.usrCoords[2]-f.usrCoords[1]+g.usrCoords[1];k=true}else{if(n==p.point2){l=f.usrCoords[1]+g.usrCoords[2]-f.usrCoords[2];j=f.usrCoords[2]-g.usrCoords[1]+f.usrCoords[1];k=false}else{if(((Math.abs(g.usrCoords[1]-f.usrCoords[1])>this.eps)&&(Math.abs(d.usrCoords[2]-(g.usrCoords[2]-f.usrCoords[2])*(d.usrCoords[1]-g.usrCoords[1])/(g.usrCoords[1]-f.usrCoords[1])-g.usrCoords[2])<this.eps))||((Math.abs(g.usrCoords[1]-f.usrCoords[1])<=this.eps)&&(Math.abs(g.usrCoords[1]-d.usrCoords[1])<this.eps))){l=d.usrCoords[1]+f.usrCoords[2]-d.usrCoords[2];j=d.usrCoords[2]-f.usrCoords[1]+d.usrCoords[1];k=true;if(Math.abs(l-d.usrCoords[1])<this.eps&&Math.abs(j-d.usrCoords[2])<this.eps){l=d.usrCoords[1]+g.usrCoords[2]-d.usrCoords[2];j=d.usrCoords[2]-g.usrCoords[1]+d.usrCoords[1];k=false}}else{var o=p.point1.coords.usrCoords[2]-p.point2.coords.usrCoords[2];var h=p.point1.coords.usrCoords[1]-p.point2.coords.usrCoords[1];var e=p.point2.coords.usrCoords[1]*o-p.point2.coords.usrCoords[2]*h;var b=n.coords.usrCoords[1]*h+n.coords.usrCoords[2]*o;var m=o*o+h*h;if(Math.abs(m)<this.eps){m=this.eps}l=(e*o+b*h)/m;j=(b*o-e*h)/m;k=true}}}return[new JXG.Coords(JXG.COORDS_BY_USER,[l,j],this.board),k]};JXG.Algebra.prototype.circumcenterMidpoint=function(h,g,f){var e=((h.coords.usrCoords[1]-g.coords.usrCoords[1])*(h.coords.usrCoords[1]+g.coords.usrCoords[1])+(h.coords.usrCoords[2]-g.coords.usrCoords[2])*(h.coords.usrCoords[2]+g.coords.usrCoords[2]))/2;var d=((g.coords.usrCoords[1]-f.coords.usrCoords[1])*(g.coords.usrCoords[1]+f.coords.usrCoords[1])+(g.coords.usrCoords[2]-f.coords.usrCoords[2])*(g.coords.usrCoords[2]+f.coords.usrCoords[2]))/2;var k=(h.coords.usrCoords[1]-g.coords.usrCoords[1])*(g.coords.usrCoords[2]-f.coords.usrCoords[2])-(g.coords.usrCoords[1]-f.coords.usrCoords[1])*(h.coords.usrCoords[2]-g.coords.usrCoords[2]);if(Math.abs(k)<this.eps){k=this.eps}var b=(e*(g.coords.usrCoords[2]-f.coords.usrCoords[2])-d*(h.coords.usrCoords[2]-g.coords.usrCoords[2]))/k;var j=(d*(h.coords.usrCoords[1]-g.coords.usrCoords[1])-e*(g.coords.usrCoords[1]-f.coords.usrCoords[1]))/k;return new JXG.Coords(JXG.COORDS_BY_USER,[b,j],this.board)};JXG.Algebra.prototype.intersectLineLine=function(e,d){var g=e.point1.coords.usrCoords[1]*e.point2.coords.usrCoords[2]-e.point1.coords.usrCoords[2]*e.point2.coords.usrCoords[1];var f=d.point1.coords.usrCoords[1]*d.point2.coords.usrCoords[2]-d.point1.coords.usrCoords[2]*d.point2.coords.usrCoords[1];var j=(e.point2.coords.usrCoords[2]-e.point1.coords.usrCoords[2])*(d.point1.coords.usrCoords[1]-d.point2.coords.usrCoords[1])-(e.point1.coords.usrCoords[1]-e.point2.coords.usrCoords[1])*(d.point2.coords.usrCoords[2]-d.point1.coords.usrCoords[2]);if(Math.abs(j)<this.eps){j=this.eps}var b=(g*(d.point1.coords.usrCoords[1]-d.point2.coords.usrCoords[1])-f*(e.point1.coords.usrCoords[1]-e.point2.coords.usrCoords[1]))/j;var h=(f*(e.point2.coords.usrCoords[2]-e.point1.coords.usrCoords[2])-g*(d.point2.coords.usrCoords[2]-d.point1.coords.usrCoords[2]))/j;return new JXG.Coords(JXG.COORDS_BY_USER,[b,h],this.board)};JXG.Algebra.prototype.intersectCircleLine=function(m,v){var K=v.point1;var I=v.point2;var g=m.midpoint;var C=K.Dist(I);if(C>0){var e=g.Dist(K);var J=g.Dist(I);var H=((e*e)+(C*C)-(J*J))/(2*C);var A=(e*e)-(H*H);A=(A<0)?0:A;var F=Math.sqrt(A);var D=m.getRadius();var n=Math.sqrt((D*D)-F*F);var B=I.coords.usrCoords[1]-K.coords.usrCoords[1];var z=I.coords.usrCoords[2]-K.coords.usrCoords[2];var k=g.coords.usrCoords[1]+(F/C)*z;var j=g.coords.usrCoords[2]-(F/C)*B;e=(I.coords.usrCoords[1]*z)-(I.coords.usrCoords[2]*B);J=(k*B)+(j*z);var E=(z*z)+(B*B);if(Math.abs(E)<this.eps){E=this.eps}var q=((e*z)+(J*B))/E;var o=((J*z)-(e*B))/E;var f=n/C;var u=new JXG.Coords(JXG.COORDS_BY_USER,[q+f*B,o+f*z],this.board);var p=new JXG.Coords(JXG.COORDS_BY_USER,[q-f*B,o-f*z],this.board);var G=g.coords.distance(JXG.COORDS_BY_USER,u);if((D<(G-1))||isNaN(G)){return[0]}else{return[2,u,p]}}};JXG.Algebra.prototype.intersectCircleLineOrg=function(g,p){var k={};var I=p.point1;var G=p.point2;var f=g.midpoint;var A=I.Dist(G);if(A>0){var e=f.Dist(I);var H=f.Dist(G);var F=((e*e)+(A*A)-(H*H))/(2*A);var u=(e*e)-(F*F);u=(u<0)?0:u;var D=Math.sqrt(u);var B=g.getRadius();var j=Math.sqrt((B*B)-(D*D));var z=G.X()-I.X();var q=G.Y()-I.Y();var v=new JXG.Coords(JXG.COORDS_BY_USER,[f.X()+(D/A)*q,f.Y()-(D/A)*z],this.board);e=(G.X()*q)-(G.Y()*z);H=(v.usrCoords[1]*z)+(v.usrCoords[2]*q);var C=(q*q)+(z*z);if(Math.abs(C)<this.eps){C=this.eps}var o=((e*q)+(H*z))/C;var m=((H*q)-(e*z))/C;v=new JXG.Coords(JXG.COORDS_BY_USER,[o+(j/A)*z,m+(j/A)*q],this.board);var n=new JXG.Coords(JXG.COORDS_BY_USER,[o-(j/A)*z,m-(j/A)*q],this.board);var E=f.coords.distance(JXG.COORDS_BY_USER,v);if((B<(E-1))||isNaN(E)){k[0]=0}else{k[0]=2}k[1]=v;k[2]=n;return k}};JXG.Algebra.prototype.intersectCircleCircleOrg=function(m,l){var d={};var g=m.getRadius();var f=l.getRadius();var r=g+f;var j=Math.abs(g-f);var k=m.midpoint.coords.distance(JXG.COORDS_BY_USER,l.midpoint.coords);if(k>r){return[0]}else{if(k<j){return[0]}else{d[0]=1;var q=(g*g-f*f+k*k)/(2*k);var n=Math.sqrt(g*g-q*q);var u=(l.midpoint.coords.usrCoords[1]-m.midpoint.coords.usrCoords[1]);var s=(l.midpoint.coords.usrCoords[2]-m.midpoint.coords.usrCoords[2]);var e=new JXG.Coords(JXG.COORDS_BY_USER,[m.midpoint.coords.usrCoords[1]+u*q/k,m.midpoint.coords.usrCoords[2]+s*q/k],this.board);var o=n/k;d[1]=new JXG.Coords(JXG.COORDS_BY_USER,[e.usrCoords[1]-o*s,e.usrCoords[2]+o*u],this.board);d[2]=new JXG.Coords(JXG.COORDS_BY_USER,[e.usrCoords[1]+o*s,e.usrCoords[2]-o*u],this.board);return d}}};JXG.Algebra.prototype.intersectCircleCircle=function(k,j){var b={};var e=k.getRadius();var d=j.getRadius();var n=e+d;var f=Math.abs(e-d);var g=k.midpoint.coords.distance(JXG.COORDS_BY_USER,j.midpoint.coords);if(g>n){return[0]}else{if(g<f){return[0]}else{var q=g;if(q!=0){b[0]=1;var p=j.midpoint.coords.usrCoords[1]-k.midpoint.coords.usrCoords[1];var o=j.midpoint.coords.usrCoords[2]-k.midpoint.coords.usrCoords[2];var m=(q*q-d*d+e*e)/(2*q);var l=Math.sqrt(e*e-m*m);b[1]=new JXG.Coords(JXG.COORDS_BY_USER,[k.midpoint.coords.usrCoords[1]+(m/q)*p+(l/q)*o,k.midpoint.coords.usrCoords[2]+(m/q)*o-(l/q)*p],this.board);b[2]=new JXG.Coords(JXG.COORDS_BY_USER,[k.midpoint.coords.usrCoords[1]+(m/q)*p-(l/q)*o,k.midpoint.coords.usrCoords[2]+(m/q)*o+(l/q)*p],this.board)}else{return[0]}return b}}};JXG.Algebra.prototype.projectPointToCircle=function(d,f){var g=d.coords.distance(JXG.COORDS_BY_USER,f.midpoint.coords);if(Math.abs(g)<this.eps){g=this.eps}var e=f.getRadius()/g;var b=f.midpoint.coords.usrCoords[1]+e*(d.coords.usrCoords[1]-f.midpoint.coords.usrCoords[1]);var h=f.midpoint.coords.usrCoords[2]+e*(d.coords.usrCoords[2]-f.midpoint.coords.usrCoords[2]);return new JXG.Coords(JXG.COORDS_BY_USER,[b,h],this.board)};JXG.Algebra.prototype.projectPointToLine=function(j,l){var k=l.point1.coords.usrCoords[2]-l.point2.coords.usrCoords[2];var f=l.point1.coords.usrCoords[1]-l.point2.coords.usrCoords[1];var d=l.point2.coords.usrCoords[1]*k-l.point2.coords.usrCoords[2]*f;var b=j.coords.usrCoords[1]*f+j.coords.usrCoords[2]*k;var h=k*k+f*f;if(Math.abs(h)<this.eps){h=this.eps}var g=(d*k+b*f)/h;var e=(b*k-d*f)/h;return new JXG.Coords(JXG.COORDS_BY_USER,[g,e],this.board)};JXG.Algebra.prototype.projectPointToCurve=function(d,g){var f,b,h,e;if(g.curveType=="parameter"||g.curveType=="polar"){b=d.X();h=d.Y();e=d.position||0;e=JXG.Math.Numerics.root(JXG.Math.Numerics.D(function(j){return(b-g.X(j))*(b-g.X(j))+(h-g.Y(j))*(h-g.Y(j))}),e);if(e<g.minX()){e=g.minX()}if(e>g.maxX()){e=g.maxX()}f=new JXG.Coords(JXG.COORDS_BY_USER,[g.X(e),g.Y(e)],this.board)}else{e=d.X();b=e;h=g.Y(e);f=new JXG.Coords(JXG.COORDS_BY_USER,[b,h],this.board)}d.position=e;return g.updateTransform(f)};JXG.Algebra.prototype.replacePow=function(e){var j,m,k;var q="";var h,l;var g=e.indexOf("^");while(g>=0){var d=e.slice(0,g);if(d.charAt(d.length-1)==")"){j=1;m=d.length-2;while(m>=0&&j>0){k=d.charAt(m);if(k==")"){j++}else{if(k=="("){j--}}m--}if(j==0){h="";var f=d.substring(0,m+1);var b=m;while(b>=0&&f.substr(b,1).match(/(\w+)/)){h=RegExp.$1+h;b--}h+=d.substring(m+1,d.length);h=h.replace(/([\(\)\+\*\%\^\-\/\]\[])/g,"\\$1")}}else{h="\\w+"}var o=e.slice(g+1);if(o.match(/^([\w\.]*\()/)){j=1;m=RegExp.$1.length;while(m<o.length&&j>0){k=o.charAt(m);if(k==")"){j--}else{if(k=="("){j++}}m++}if(j==0){l=o.substring(0,m);l=l.replace(/([\(\)\+\*\%\^\-\/\[\]])/g,"\\$1")}}else{l="[\\w\\.]+"}var n=new RegExp("("+h+")\\^("+l+")");e=e.replace(n,"this.board.algebra.pow($1,$2)");g=e.indexOf("^")}return e};JXG.Algebra.prototype.replaceIf=function(d){var q="";var e,p;var g=null;var b=null;var k=null;var f=d.indexOf("If(");if(f<0){return d}d=d.replace(/""/g,"0");while(f>=0){e=d.slice(0,f);p=d.slice(f+3);var h=1;var o=0;var l=-1;var j=-1;while(o<p.length&&h>0){var m=p.charAt(o);if(m==")"){h--}else{if(m=="("){h++}else{if(m==","&&h==1){if(l<0){l=o}else{j=o}}}}o++}var n=p.slice(0,o-1);p=p.slice(o);if(l<0){return""}if(j<0){return""}g=n.slice(0,l);b=n.slice(l+1,j);k=n.slice(j+1);g=this.replaceIf(g);b=this.replaceIf(b);k=this.replaceIf(k);q+=e+"(("+g+")?("+b+"):("+k+"))";d=p;g=null;b=null;f=d.indexOf("If(")}q+=p;return q};JXG.Algebra.prototype.replaceSub=function(e){var d=e.indexOf("_{");while(d>=0){e=e.substr(0,d)+e.substr(d).replace(/_\{/,"<sub>");var b=e.substr(d).indexOf("}");if(b>=0){e=e.substr(0,b)+e.substr(b).replace(/\}/,"</sub>")}d=e.indexOf("_{")}d=e.indexOf("_");while(d>=0){e=e.substr(0,d)+e.substr(d).replace(/_(.?)/,"<sub>$1</sub>");d=e.indexOf("_")}return e};JXG.Algebra.prototype.replaceSup=function(e){var d=e.indexOf("^{");while(d>=0){e=e.substr(0,d)+e.substr(d).replace(/\^\{/,"<sup>");var b=e.substr(d).indexOf("}");if(b>=0){e=e.substr(0,b)+e.substr(b).replace(/\}/,"</sup>")}d=e.indexOf("^{")}d=e.indexOf("^");while(d>=0){e=e.substr(0,d)+e.substr(d).replace(/\^(.?)/,"<sup>$1</sup>");d=e.indexOf("^")}return e};JXG.Algebra.prototype.replaceNameById=function(e){var h=0;var b;var g;var d;var f;h=e.indexOf("X(");while(h>=0){if(h>=0){b=e.indexOf(")",h+2);if(b>=0){g=e.slice(h+2,b);g=g.replace(/\\(['"])?/g,"$1");f=this.board.elementsByName[g];e=e.slice(0,h+2)+f.id+e.slice(b)}}b=e.indexOf(")",h+2);h=e.indexOf("X(",b)}h=e.indexOf("Y(");while(h>=0){if(h>=0){b=e.indexOf(")",h+2);if(b>=0){g=e.slice(h+2,b);g=g.replace(/\\(['"])?/g,"$1");f=this.board.elementsByName[g];e=e.slice(0,h+2)+f.id+e.slice(b)}}b=e.indexOf(")",h+2);h=e.indexOf("Y(",b)}h=e.indexOf("L(");while(h>=0){if(h>=0){b=e.indexOf(")",h+2);if(b>=0){g=e.slice(h+2,b);g=g.replace(/\\(['"])?/g,"$1");f=this.board.elementsByName[g];e=e.slice(0,h+2)+f.id+e.slice(b)}}b=e.indexOf(")",h+2);h=e.indexOf("L(",b)}h=e.indexOf("Dist(");while(h>=0){if(h>=0){b=e.indexOf(",",h+5);if(b>=0){g=e.slice(h+5,b);g=g.replace(/\\(['"])?/g,"$1");f=this.board.elementsByName[g];e=e.slice(0,h+5)+f.id+e.slice(b)}}b=e.indexOf(",",h+5);h=e.indexOf(",",b);b=e.indexOf(")",h+1);if(b>=0){g=e.slice(h+1,b);g=g.replace(/\\(['"])?/g,"$1");f=this.board.elementsByName[g];e=e.slice(0,h+1)+f.id+e.slice(b)}b=e.indexOf(")",h+1);h=e.indexOf("Dist(",b)}h=e.indexOf("Deg(");while(h>=0){if(h>=0){b=e.indexOf(",",h+4);if(b>=0){g=e.slice(h+4,b);g=g.replace(/\\(['"])?/g,"$1");f=this.board.elementsByName[g];e=e.slice(0,h+4)+f.id+e.slice(b)}}b=e.indexOf(",",h+4);h=e.indexOf(",",b);b=e.indexOf(",",h+1);if(b>=0){g=e.slice(h+1,b);g=g.replace(/\\(['"])?/g,"$1");f=this.board.elementsByName[g];e=e.slice(0,h+1)+f.id+e.slice(b)}b=e.indexOf(",",h+1);h=e.indexOf(",",b);b=e.indexOf(")",h+1);if(b>=0){g=e.slice(h+1,b);g=g.replace(/\\(['"])?/g,"$1");f=this.board.elementsByName[g];e=e.slice(0,h+1)+f.id+e.slice(b)}b=e.indexOf(")",h+1);h=e.indexOf("Deg(",b)}h=e.indexOf("Rad(");while(h>=0){if(h>=0){b=e.indexOf(",",h+4);if(b>=0){g=e.slice(h+4,b);g=g.replace(/\\(['"])?/g,"$1");f=this.board.elementsByName[g];e=e.slice(0,h+4)+f.id+e.slice(b)}}b=e.indexOf(",",h+4);h=e.indexOf(",",b);b=e.indexOf(",",h+1);if(b>=0){g=e.slice(h+1,b);g=g.replace(/\\(['"])?/g,"$1");f=this.board.elementsByName[g];e=e.slice(0,h+1)+f.id+e.slice(b)}b=e.indexOf(",",h+1);h=e.indexOf(",",b);b=e.indexOf(")",h+1);if(b>=0){g=e.slice(h+1,b);g=g.replace(/\\(['"])?/g,"$1");f=this.board.elementsByName[g];e=e.slice(0,h+1)+f.id+e.slice(b)}b=e.indexOf(")",h+1);h=e.indexOf("Rad(",b)}return e};JXG.Algebra.prototype.replaceIdByObj=function(b){var d=/(X|Y|L)\(([\w_]+)\)/g;b=b.replace(d,'this.board.objects["$2"].$1()');d=/(Dist)\(([\w_]+),([\w_]+)\)/g;b=b.replace(d,'this.board.objects["$2"].Dist(this.board.objects["$3"])');d=/(Deg)\(([\w_]+),([ \w\[\w_]+),([\w_]+)\)/g;b=b.replace(d,'this.board.algebra.trueAngle(this.board.objects["$2"],this.board.objects["$3"],this.board.objects["$4"])');d=/Rad\(([\w_]+),([\w_]+),([\w_]+)\)/g;b=b.replace(d,'this.board.algebra.rad(this.board.objects["$1"],this.board.objects["$2"],this.board.objects["$3"])');return b};JXG.Algebra.prototype.geonext2JS=function(d){d=d.replace(/&lt;/g,"<");d=d.replace(/&gt;/g,">");d=d.replace(/&amp;/g,"&");var f=this.board.elementsByName;var g;var e=d;e=this.replaceNameById(e);e=this.replaceIf(e);e=this.replacePow(e);e=this.replaceIdByObj(e);var j=["Abs","ACos","ASin","ATan","Ceil","Cos","Exp","Floor","Log","Max","Min","Pow","Random","Round","Sin","Sqrt","Tan","Trunc"];var h=["Math.abs","Math.acos","Math.asin","Math.atan","Math.ceil","Math.cos","Math.exp","Math.floor","Math.log","Math.max","Math.min","Math.pow","Math.random","this.board.round","Math.sin","Math.sqrt","Math.tan","Math.ceil"];for(var b=0;b<j.length;b++){g=new RegExp(j[b],"g");e=e.replace(g,h[b])}e=e.replace(/True/g,"true");e=e.replace(/False/g,"false");e=e.replace(/fasle/g,"false");e=e.replace(/Pi/g,"Math.PI");return e};JXG.Algebra.prototype.findDependencies=function(f,d){var e;var h;var g=this.board.elementsByName;for(e in g){if(e!=f.name){var b=e.replace(/\[/g,"\\[");b=b.replace(/\]/g,"\\]");h=new RegExp("\\(([\\w\\[\\]'_ ]+,)*("+b+")(,[\\w\\[\\]'_ ]+)*\\)","g");if(d.search(h)>=0){g[e].addChild(f)}}}};JXG.Algebra.prototype.distance=function(f,e){var d=0;if(f.length!=e.length){return}for(var b=0;b<f.length;b++){d+=(f[b]-e[b])*(f[b]-e[b])}return Math.sqrt(d)};JXG.Algebra.prototype.affineDistance=function(e,b){if(e.length!=b.length){return}var f=this.distance(e,b);if(f>this.eps&&(Math.abs(e[0])<this.eps||Math.abs(b[0])<this.eps)){return Infinity}else{return f}};JXG.Algebra.prototype.rad=function(b,f,e){var d=this.trueAngle(b,f,e);return d*Math.PI/180};JXG.Algebra.prototype.matVecMult=function(j,g){var b=j.length;var l=g.length;var f=[];for(var e=0;e<b;e++){var h=0;for(var d=0;d<l;d++){h+=j[e][d]*g[d]}f[e]=h}return f};JXG.Algebra.prototype.matMatMult=function(d,b){var f=d.length;var e=b[0].length;var p=b.length;var o=[];for(var l=0;l<d.length;l++){o[l]=[]}for(l=0;l<f;l++){for(var h=0;h<e;h++){var q=0;for(var g=0;g<p;g++){q+=d[l][g]*b[g][h]}o[l][h]=q}}return o};JXG.Algebra.prototype.str2Bool=function(b){if(b==undefined||b==null){return true}if(typeof b=="boolean"){return b}if(b.toLowerCase()!="true"){return false}else{return true}};JXG.Algebra.prototype.pow=function(e,d){if(e==null||d==null){return 1}if(Math.floor(d)==d){return Math.pow(e,d)}else{if(e>0){return Math.exp(d*Math.log(Math.abs(e)))}else{return null}}};JXG.Algebra.prototype.crossProduct=function(e,d){var b=e[1]*d[2]-e[2]*d[1];var g=e[2]*d[0]-e[0]*d[2];var f=e[0]*d[1]-e[1]*d[0];return[b,g,f]};JXG.Algebra.prototype.innerProduct=function(e,d,h){var f;var g=0;for(f=0;f<h;f++){g+=e[f]*d[f]}return g};JXG.Algebra.prototype.meet=function(f,d,e){var b=0.000001;if(Math.abs(f[3])<b&&Math.abs(d[3])<b){return this.meetLineLine(f,d,e)}else{if(Math.abs(f[3])>=b&&Math.abs(d[3])<b){return this.meetLineCircle(d,f,e)}else{if(Math.abs(f[3])<b&&Math.abs(d[3])>=b){return this.meetLineCircle(f,d,e)}else{return this.meetCircleCircle(f,d,e)}}}};JXG.Algebra.prototype.meetLineLine=function(d,b,e){var f=this.crossProduct(d,b);if(Math.abs(f[0])>this.eps){f[1]/=f[0];f[2]/=f[0];f[0]=1}return new JXG.Coords(JXG.COORDS_BY_USER,f,this.board)};JXG.Algebra.prototype.meetLineCircle=function(j,e,o){if(e[4]<this.eps){return new JXG.Coords(JXG.COORDS_BY_USER,e.slice(1,3),this.board)}var s,r,q,p,l,h,g,f,m,u;q=e[0];r=e.slice(1,3);s=e[3];p=j[0];l=j.slice(1,3);h=s;g=(r[0]*l[1]-r[1]*l[0]);f=s*p*p-(r[0]*l[0]+r[1]*l[1])*p+q;m=g*g-4*h*f;if(m>=0){m=Math.sqrt(m);u=[(-g+m)/(2*h),(-g-m)/(2*h)];return((o==0)?new JXG.Coords(JXG.COORDS_BY_USER,[-u[0]*(-l[1])-p*l[0],-u[0]*l[0]-p*l[1]],this.board):new JXG.Coords(JXG.COORDS_BY_USER,[-u[1]*(-l[1])-p*l[0],-u[1]*l[0]-p*l[1]],this.board))}else{return new JXG.Coords(JXG.COORDS_BY_USER,[NaN,NaN],this.board)}};JXG.Algebra.prototype.meetCircleCircle=function(e,b,d){var f;if(e[4]<this.eps){if(this.distance(e.slice(1,3),b.slice(1,3))==b[4]){return new JXG.Coords(JXG.COORDS_BY_USER,e.slice(1,3),this.board)}else{return new JXG.Coords(JXG.COORDS_BY_USER,[NaN,NaN],this.board)}}if(b[4]<this.eps){if(this.distance(b.slice(1,3),e.slice(1,3))==e[4]){return new JXG.Coords(JXG.COORDS_BY_USER,b.slice(1,3),this.board)}else{return new JXG.Coords(JXG.COORDS_BY_USER,[NaN,NaN],this.board)}}f=[b[3]*e[0]-e[3]*b[0],b[3]*e[1]-e[3]*b[1],b[3]*e[2]-e[3]*b[2],0,1,Infinity,Infinity,Infinity];f=this.normalize(f);return this.meetLineCircle(f,e,d)};JXG.Algebra.prototype.normalize=function(e){var b=2*e[3];var f=e[4]/(b);e[5]=f;e[6]=-e[1]/b;e[7]=-e[2]/b;if(f==Infinity||isNaN(f)){var g=Math.sqrt(e[1]*e[1]+e[2]*e[2]);e[0]/=g;e[1]/=g;e[2]/=g;e[3]=0;e[4]=1}else{if(Math.abs(f)>=1){e[0]=(e[6]*e[6]+e[7]*e[7]-f*f)/(2*f);e[1]=-e[6]/f;e[2]=-e[7]/f;e[3]=1/(2*f);e[4]=1}else{var d=(f<=0)?(-1):(1);e[0]=d*(e[6]*e[6]+e[7]*e[7]-f*f)*0.5;e[1]=-d*e[6];e[2]=-d*e[7];e[3]=d/2;e[4]=d*f}}return e};JXG.Algebra.prototype.meetCurveCurve=function(k,h,g,v){var o=0;var m,l;var u,s,r,q,j;var p,n;if(arguments.callee.t1memo){m=arguments.callee.t1memo;l=arguments.callee.t2memo}else{m=g;l=v}if(m>k.maxX()){m=k.maxX()}if(m<k.minX()){m=k.minX()}if(l>h.maxX()){l=h.maxX()}if(l<h.minX()){l=h.minX()}p=k.X(m)-h.X(l);n=k.Y(m)-h.Y(l);var w=p*p+n*n;while(w>JXG.Math.eps&&o<1000){u=k.board.D(k.X,k)(m);s=-h.board.D(h.X,h)(l);r=k.board.D(k.Y,k)(m);q=-h.board.D(h.Y,h)(l);j=u*q-s*r;m-=(q*p-s*n)/j;l-=(u*n-r*p)/j;p=k.X(m)-h.X(l);n=k.Y(m)-h.Y(l);w=p*p+n*n;o++}arguments.callee.t1memo=m;arguments.callee.t2memo=l;if(Math.abs(m)<Math.abs(l)){return(new JXG.Coords(JXG.COORDS_BY_USER,[k.X(m),k.Y(m)],this.board))}else{return(new JXG.Coords(JXG.COORDS_BY_USER,[h.X(l),h.Y(l)],this.board))}};JXG.Intersection=function(g,d,f,e,j,h,n,m){this.constructor();this.board=g;this.id=d;this.name=this.id;this.visProp={};this.visProp.visible=true;this.show=true;this.real=true;this.notExistingParents={};this.intersect1=JXG.GetReferenceFromParameter(this.board,f);this.intersect2=JXG.GetReferenceFromParameter(this.board,e);this.type=JXG.OBJECT_TYPE_INTERSECTION;if(((this.intersect1=="")||(this.intersect1==undefined))&&((this.intersect2=="")||(this.intersect2==undefined))){return}if(((this.intersect1.type==this.intersect2.type)&&(this.intersect1.type==JXG.OBJECT_TYPE_LINE||this.intersect1.type==JXG.OBJECT_TYPE_ARROW))||((this.intersect1.type==JXG.OBJECT_TYPE_LINE)&&(this.intersect2.type==JXG.OBJECT_TYPE_ARROW))||((this.intersect2.type==JXG.OBJECT_TYPE_LINE)&&(this.intersect1.type==JXG.OBJECT_TYPE_ARROW))){var k=this.board.algebra.intersectLineLine(this.intersect1,this.intersect2).usrCoords.slice(1);this.p=new JXG.Point(this.board,k,j,n,true);this.p.fixed=true;this.addChild(this.p);this.real=true;this.update=function(){if(this.needsUpdate){this.p.coords=this.board.algebra.intersectLineLine(this.intersect1,this.intersect2);this.needsUpdate=false}};this.hideElement=function(){this.visProp.visible=false;this.p.hideElement()};this.showElement=function(){this.visProp.visible=true;this.p.showElement()};this.hideChild=function(p){this.notExistingParents[p]=this.board.objects[p];for(var o in this.descendants){if(this.descendants[o].visProp.visible&&this.descendants[o].type!=JXG.OBJECT_TYPE_INTERSECTION){this.descendants[o].hideElement();this.descendants[o].visProp.visible=true}this.descendants[o].notExistingParents[p]=this.board.objects[p]}};this.showChild=function(p){for(var o in this.board.objects){delete (this.board.objects[o].notExistingParents[p]);if(this.board.objects[o].visProp.visible&&JXG.keys(this.board.objects[o].notExistingParents).length==0){if(this.board.objects[o].type!=JXG.OBJECT_TYPE_INTERSECTION){this.board.objects[o].showElement()}}}}}else{if(((f.type==e.type)&&(f.type==JXG.OBJECT_TYPE_CIRCLE||f.type==JXG.OBJECT_TYPE_ARC))||(f.type==JXG.OBJECT_TYPE_CIRCLE&&e.type==JXG.OBJECT_TYPE_ARC)||(e.type==JXG.OBJECT_TYPE_CIRCLE&&f.type==JXG.OBJECT_TYPE_ARC)){this.p1=new JXG.Point(this.board,[0,0],j,n,false);this.p1.fixed=true;this.p1.label.show=true;this.p2=new JXG.Point(this.board,[0,0],h,m,false);this.p2.fixed=true;this.p2.label.show=true;this.addChild(this.p1);this.addChild(this.p2);var l=this.board.algebra.intersectCircleCircle(this.intersect1,this.intersect2);if(l[0]==1){this.p1.coords=l[1];this.p1.showElement();this.p1.updateRenderer();this.p2.coords=l[2];this.p2.showElement();this.p2.updateRenderer();this.real=true}else{this.real=false}this.update=function(){if(!this.needsUpdate){return}var q=this.board.algebra.intersectCircleCircle(this.intersect1,this.intersect2);var p=this.p1.visProp.visible;var o=this.p2.visProp.visible;if(q[0]==0){if(this.real){this.hideChild(this.id);this.p1.visProp.visible=p;this.p2.visProp.visible=o;this.real=false}}else{this.p1.coords=q[1];this.p2.coords=q[2];if(!this.real){this.showChild(this.id);this.real=true}}this.needsUpdate=false};this.hideElement=function(){this.visProp.visible=false;this.p1.hideElement();this.p2.hideElement()};this.showElement=function(){this.visProp.visible=true;this.p1.showElement();this.p2.showElement()};this.hideChild=function(p){this.notExistingParents[p]=this.board.objects[p];for(var o in this.descendants){if(this.descendants[o].visProp.visible&&this.descendants[o].type!=JXG.OBJECT_TYPE_INTERSECTION){this.descendants[o].hideElement();this.descendants[o].visProp.visible=true}this.descendants[o].notExistingParents[p]=this.board.objects[p]}};this.showChild=function(o){for(el in this.board.objects){delete (this.board.objects[el].notExistingParents[o]);if(this.board.objects[el].visProp.visible&&JXG.keys(this.board.objects[el].notExistingParents).length==0){if(this.board.objects[el].type!=JXG.OBJECT_TYPE_INTERSECTION){this.board.objects[el].showElement()}}}}}else{this.p1=new JXG.Point(this.board,[0,0],j,n,false);this.p1.fixed=true;this.p1.label.show=true;this.p2=new JXG.Point(this.board,[0,0],h,m,false);this.p2.fixed=true;this.p2.label.show=true;this.addChild(this.p1);this.addChild(this.p2);if(this.intersect1.type==JXG.OBJECT_TYPE_LINE||this.intersect1.type==JXG.OBJECT_TYPE_ARROW){var b=this.intersect1;this.intersect1=this.intersect2;this.intersect2=b}var l=this.board.algebra.intersectCircleLine(this.intersect1,this.intersect2);if(l[0]==1){this.p1.coords=l[1];this.p1.showElement();this.p1.update()}else{if(l[0]==2){this.p1.coords=l[1];this.p1.showElement();this.p2.coords=l[2];this.p2.showElement();this.p1.updateRenderer();this.p2.updateRenderer();this.real=true}else{this.real=false}}this.update=function(){if(!this.needsUpdate){return}var q=this.board.algebra.intersectCircleLine(this.intersect1,this.intersect2);var p=this.p1.visProp.visible;var o=this.p2.visProp.visible;if(q[0]==0){if(this.real){this.hideChild(this.id);this.p1.visProp.visible=p;this.p2.visProp.visible=o;this.real=false}}else{if(q[0]==2){this.p1.coords=q[1];this.p2.coords=q[2];if(!this.real){this.showChild(this.id);this.real=true}}}this.needsUpdate=false};this.hideElement=function(){this.visProp.visible=false;this.p1.hideElement();this.p2.hideElement()};this.showElement=function(){this.visProp.visible=true;this.p1.showElement();this.p2.showElement()};this.hideChild=function(p){this.notExistingParents[p]=this.board.objects[p];for(var o in this.descendants){if(this.descendants[o].visProp.visible&&this.descendants[o].type!=JXG.OBJECT_TYPE_INTERSECTION){this.descendants[o].hideElement();this.descendants[o].visProp.visible=true}this.descendants[o].notExistingParents[p]=this.board.objects[p]}};this.showChild=function(o){for(el in this.board.objects){delete (this.board.objects[el].notExistingParents[o]);if(this.board.objects[el].visProp.visible&&JXG.keys(this.board.objects[el].notExistingParents).length==0){if(this.board.objects[el].type!=JXG.OBJECT_TYPE_INTERSECTION){this.board.objects[el].showElement()}}}}}}this.id=this.board.addIntersection(this)};JXG.Intersection.prototype=new JXG.GeometryElement();JXG.Intersection.prototype.update=function(){return};JXG.Intersection.prototype.hasPoint=function(b,d){return false};JXG.Intersection.prototype.hideChild=function(b){};JXG.Intersection.prototype.showChild=function(b){};JXG.Intersection.prototype.remove=function(){if(this.p!=undefined){this.board.removeObject(this.p)}if(this.p1!=undefined){this.board.removeObject(this.p1)}if(this.p2!=undefined){this.board.removeObject(this.p2)}return};JXG.Intersection.prototype.updateRenderer=function(){};JXG.createPerpendicular=function(b,e,d){if(JXG.IsPoint(e[0])&&e[1].type==JXG.OBJECT_TYPE_LINE){if(!JXG.IsArray(d.id)){d.id=["",""]}if(!JXG.IsArray(d.name)){d.name=["",""]}return b.addPerpendicular(e[1],e[0],d.id[0],d.name[0],d.id[1],d.name[1])}else{if(JXG.IsPoint(e[1])&&e[0].type==JXG.OBJECT_TYPE_LINE){if(!JXG.IsArray(d.id)){d.id=["",""]}if(!JXG.IsArray(d.name)){d.name=["",""]}return b.addPerpendicular(e[0],e[1],d.id[0],d.name[0],d.id[1],d.name[1])}else{throw ("Can't create perpendicular with parent types '"+(typeof e[0])+"' and '"+(typeof e[1])+"'.")}}};JXG.createMidpoint=function(b,e,d){if(e.length==2&&JXG.IsPoint(e[0])&&JXG.IsPoint(e[1])){return b.addMidpoint(e[0],e[1],d.id,d.name)}else{if(e.length==1&&e[0].type==JXG.OBJECT_TYPE_LINE){return b.addMidpoint(e[0].point1,e[0].point2,d.id,d.name)}else{throw ("Can't create midpoint.")}}};JXG.createParallel=function(b,e,d){if(JXG.IsPoint(e[0])&&e[1].type==JXG.OBJECT_TYPE_LINE){return b.addParallel(e[1],e[0],d.id,d.name)}else{if(JXG.IsPoint(e[1])&&e[0].type==JXG.OBJECT_TYPE_LINE){return b.addParallel(e[0],e[1],d.id,d.name)}else{throw ("Can't create parallel with parent types '"+(typeof e[0])+"' and '"+(typeof e[1])+"'.")}}};JXG.createNormal=function(j,l,d){var b;var k;if(l.length==1){b=l[0];k=b.slideObject}else{if(l.length==2){if(JXG.IsPoint(l[0])){b=l[0];k=l[1]}else{if(JXG.IsPoint(l[1])){k=l[0];b=l[1]}else{throw ("Can't create normal with parent types '"+(typeof l[0])+"' and '"+(typeof l[1])+"'.")}}}else{throw ("Can't create normal with parent types '"+(typeof l[0])+"' and '"+(typeof l[1])+"'.")}}if(k.elementClass==JXG.OBJECT_CLASS_LINE){return j.createElement("line",[function(){return k.stdform[1]*b.Y()-k.stdform[2]*b.X()},function(){return k.stdform[2]*b.Z()},function(){return -k.stdform[1]*b.Z()}],d)}else{if(k.elementClass==JXG.OBJECT_CLASS_CIRCLE){var m=function(f){return -k.getRadius()*Math.sin(f)};var n=function(f){return k.getRadius()*Math.cos(f)};return j.createElement("line",[function(){return -b.X()*m(b.position)-b.Y()*n(b.position)},function(){return m(b.position)},function(){return n(b.position)}],d)}else{if(k.elementClass==JXG.OBJECT_CLASS_CURVE){var e=k.X;var h=k.Y;return j.createElement("line",[function(){return -b.X()*j.D(e)(b.position)-b.Y()*j.D(h)(b.position)},function(){return j.D(e)(b.position)},function(){return j.D(h)(b.position)}],d)}else{throw ("Can't create normal with parent types '"+(typeof l[0])+"' and '"+(typeof l[1])+"'.")}}}};JXG.createBisector=function(b,e,d){if(JXG.IsPoint(e[0])&&JXG.IsPoint(e[1])&&JXG.IsPoint(e[2])){return b.addAngleBisector(e[0],e[1],e[2],d.id,d.name)}else{throw ("Can't create angle bisector with parent types '"+(typeof e[0])+"' and '"+(typeof e[1])+"'.")}};JXG.createArrowParallel=function(b,e,d){if(JXG.IsPoint(e[0])&&e[1].type==JXG.OBJECT_TYPE_ARROW){if(!JXG.IsArray(d.id)){d.id=["",""]}if(!JXG.IsArray(d.name)){d.name=["",""]}return b.addArrowParallel(e[1],e[0],d.id[0],d.name[0],d.id[1],d.name[1])}else{if(JXG.IsPoint(e[1])&&e[0].type==JXG.OBJECT_TYPE_ARROW){if(!JXG.IsArray(d.id)){d.id=["",""]}if(!JXG.IsArray(d.name)){d.name=["",""]}return b.addArrowParallel(e[0],e[1],d.id[0],d.name[0],d.id[1],d.name[1])}else{throw ("Can't create parallel arrow with parent types '"+(typeof e[0])+"' and '"+(typeof e[1])+"'.")}}};JXG.createCircumcircle=function(b,e,d){if(JXG.IsPoint(e[0])&&JXG.IsPoint(e[1])&&JXG.IsPoint(e[2])){if(!JXG.IsArray(d.id)){d.id=["",""]}if(!JXG.IsArray(d.name)){d.name=["",""]}return b.addCircumcenter(e[0],e[1],e[2],d.id[0],d.name[0],d.id[1],d.name[1])}else{throw ("Can't create circumcircle with parent types '"+(typeof e[0])+"', '"+(typeof e[1])+"' and '"+(typeof e[2])+"'.")}};JXG.createCircumcircleMidpoint=function(b,e,d){if(JXG.IsPoint(e[0])&&JXG.IsPoint(e[1])&&JXG.IsPoint(e[2])){return b.addCircumcenterMidpoint(e[0],e[1],e[2],d.id,d.name)}else{throw ("Can't create circumcircle midpoint with parent types '"+(typeof e[0])+"', '"+(typeof e[1])+"' and '"+(typeof e[2])+"'.")}};JXG.createParallelPoint=function(b,e,d){if(JXG.IsPoint(e[0])&&JXG.IsPoint(e[1])&&JXG.IsPoint(e[2])){return b.addParallelPoint(e[0],e[1],e[2],d.id,d.name)}else{throw ("Can't create parallel point with parent types '"+(typeof e[0])+"', '"+(typeof e[1])+"' and '"+(typeof e[2])+"'.")}};JXG.createReflection=function(b,e,d){if(JXG.IsPoint(e[0])&&e[1].type==JXG.OBJECT_TYPE_LINE){return b.addReflection(e[1],e[0],d.id,d.name)}else{if(JXG.IsPoint(e[1])&&e[0].type==JXG.OBJECT_TYPE_LINE){return b.addReflection(e[0],e[1],d.id,d.name)}else{throw ("Can't create reflection point with parent types '"+(typeof e[0])+"' and '"+(typeof e[1])+"'.")}}};JXG.createPerpendicularPoint=function(b,e,d){if(JXG.IsPoint(e[0])&&e[1].type==JXG.OBJECT_TYPE_LINE){return b.addPerpendicularPoint(e[1],e[0],d.id,d.name)}else{if(JXG.IsPoint(e[1])&&e[0].type==JXG.OBJECT_TYPE_LINE){return b.addPerpendicularPoint(e[0],e[1],d.id,d.name)}else{throw ("Can't create perpendicular point with parent types '"+(typeof e[0])+"' and '"+(typeof e[1])+"'.")}}};JXG.createMirrorPoint=function(b,e,d){if(JXG.IsPoint(e[0])&&JXG.IsPoint(e[1])){return b.addRotation(e[0],e[1],Math.PI,d.id,d.name)}else{throw ("Can't create mirror point with parent types '"+(typeof e[0])+"' and '"+(typeof e[1])+"'.")}};JXG.createIntegral=function(b,e,d){if(!JXG.IsArray(d.id)||(d.id.length!=5)){d.id=["","","","",""]}if(!JXG.IsArray(d.name)||(d.name.length!=5)){d.name=["","","","",""]}if(JXG.IsArray(e[0])&&e[1].type==JXG.OBJECT_TYPE_CURVE){return b.addIntegral(e[0],e[1],d.id,d.name,d)}else{if(JXG.IsArray(e[1])&&e[0].type==JXG.OBJECT_TYPE_CURVE){return b.addIntegral(e[1],e[0],d.id,d.name,d)}else{throw ("Can't create integral with parent types '"+(typeof e[0])+"' and '"+(typeof e[1])+"'.")}}};JXG.JSXGraph.registerElement("arrowparallel",JXG.createArrowParallel);JXG.JSXGraph.registerElement("bisector",JXG.createBisector);JXG.JSXGraph.registerElement("circumcircle",JXG.createCircumcircle);JXG.JSXGraph.registerElement("circumcirclemidpoint",JXG.createCircumcircleMidpoint);JXG.JSXGraph.registerElement("integral",JXG.createIntegral);JXG.JSXGraph.registerElement("midpoint",JXG.createMidpoint);JXG.JSXGraph.registerElement("mirrorpoint",JXG.createMirrorPoint);JXG.JSXGraph.registerElement("normal",JXG.createNormal);JXG.JSXGraph.registerElement("parallel",JXG.createParallel);JXG.JSXGraph.registerElement("parallelpoint",JXG.createParallelPoint);JXG.JSXGraph.registerElement("perpendicular",JXG.createPerpendicular);JXG.JSXGraph.registerElement("perpendicularpoint",JXG.createPerpendicularPoint);JXG.JSXGraph.registerElement("reflection",JXG.createReflection);JXG.Text=function(m,q,j,o,e,b,f){this.constructor();this.type=JXG.OBJECT_TYPE_TEXT;this.elementClass=JXG.OBJECT_CLASS_OTHER;this.init(m,e,b);this.contentStr=q;this.plaintextStr="";this.visProp.strokeColor=this.board.options.text.strokeColor;this.visProp.visible=true;if(f!=null){this.digits=f}else{this.digits=2}if((this.element=this.board.objects[j])){var k=this.element.getTextAnchor();this.element.addChild(this);this.relativeCoords=new JXG.Coords(JXG.COORDS_BY_USER,[parseFloat(o[0]),parseFloat(o[1])],this.board);this.coords=new JXG.Coords(JXG.COORDS_BY_USER,[this.relativeCoords.usrCoords[1]+k.usrCoords[1],this.relativeCoords.usrCoords[2]+k.usrCoords[2]],this.board)}else{var p=o[0];if(typeof p=="string"){var h=this.board.algebra.geonext2JS(p);this.X=new Function("","return "+h+";")}else{if(typeof p=="function"){this.X=p}else{if(typeof p=="number"){this.X=function(){return p}}}}var n=o[1];if(typeof n=="string"){var g=this.board.algebra.geonext2JS(n);this.Y=new Function("","return "+g+";")}else{if(typeof n=="function"){this.Y=n}else{if(typeof n=="number"){this.Y=function(){return n}}}}this.coords=new JXG.Coords(JXG.COORDS_BY_USER,[this.X(),this.Y()],this.board);var l="this.coords.setCoordinates(JXG.COORDS_BY_USER,[this.X(),this.Y()]);";this.updateCoords=new Function("",l)}if(typeof this.contentStr=="function"){this.updateText=function(){this.plaintextStr=this.contentStr()}}else{var d;if(typeof this.contentStr=="number"){d=(this.contentStr).toFixed(this.digits)}else{d=this.generateTerm(this.contentStr)}this.updateText=new Function("this.plaintextStr = "+d+";")}this.updateText();this.id=this.board.addText(this);this.notifyParents(this.contentStr)};JXG.Text.prototype=new JXG.GeometryElement();JXG.Text.prototype.hasPoint=function(b,d){return false};JXG.Text.prototype.update=function(){if(this.needsUpdate){if(this.relativeCoords){var b=this.element.getTextAnchor();this.coords.setCoordinates(JXG.COORDS_BY_USER,[this.relativeCoords.usrCoords[1]+b.usrCoords[1],this.relativeCoords.usrCoords[2]+b.usrCoords[2]])}else{this.updateCoords()}this.updateText()}};JXG.Text.prototype.updateRenderer=function(){if(this.needsUpdate){this.board.renderer.updateText(this);this.needsUpdate=false}};JXG.Text.prototype.generateTerm=function(g){var f=null;var k=this.board.elementsByName;var h='""';g=g.replace(/\"/g,'\\"');g=g.replace(/\'/g,"\\'");g=g.replace(/&amp;arc;/g,"&ang;");g=g.replace(/<arc\s*\/>/g,"&ang;");g=g.replace(/<sqrt\s*\/>/g,"&radic;");var e;e=g.indexOf("<value>");var b=g.indexOf("</value>");if(e>=0){while(e>=0){h+=' + "'+this.board.algebra.replaceSub(this.board.algebra.replaceSup(g.slice(0,e)))+'"';var d=g.slice(e+7,b);var f=this.board.algebra.geonext2JS(d);f=f.replace(/\\"/g,'"');f=f.replace(/\\'/g,"'");if(f.indexOf("toFixed")<0){h+="+("+f+").toFixed("+(this.digits)+")"}else{h+="+("+f+")"}g=g.slice(b+8);e=g.indexOf("<value>");b=g.indexOf("</value>")}}h+=' + "'+this.board.algebra.replaceSub(this.board.algebra.replaceSup(g))+'"';h=h.replace(/<overline>/g,"<span style=text-decoration:overline>");h=h.replace(/<\/overline>/g,"</span>");h=h.replace(/<arrow>/g,"<span style=text-decoration:overline>");h=h.replace(/<\/arrow>/g,"</span>");h=h.replace(/&amp;/g,"&");return h};JXG.Text.prototype.notifyParents=function(e){var d=null;var f=this.board.elementsByName;do{var b=/<value>([\w\s\*\/\^\-\+\(\)\[\],<>=!]+)<\/value>/;d=b.exec(e);if(d!=null){this.board.algebra.findDependencies(this,d[1]);e=e.substr(d.index);e=e.replace(b,"")}}while(d!=null)};JXG.createText=function(b,e,d){return new JXG.Text(b,e[e.length-1],null,e,d.id,d.name,d.digits)};JXG.JSXGraph.registerElement("text",JXG.createText);JXG.Image=function(g,f,j,d,h,k,b,e){this.type=JXG.OBJECT_TYPE_IMAGE;this.elementClass=JXG.OBJECT_CLASS_OTHER;this.transformations=[];this.init(g,k,b);this.coords=new JXG.Coords(JXG.COORDS_BY_USER,j,this.board);this.initialCoords=new JXG.Coords(JXG.COORDS_BY_USER,j,this.board);this.size=[d[0]*g.zoomX*g.unitX,d[1]*g.zoomY*g.unitY];this.imageBase64String=f;this.displayLevel=h;this.parent=e;this.visProp.visible=true;this.id=this.board.addImage(this)};JXG.Image.prototype=new JXG.GeometryElement;JXG.Image.prototype.hasPoint=function(b,d){return false};JXG.Image.prototype.updateRenderer=function(){this.updateTransform();this.board.renderer.updateImage(this)};JXG.Image.prototype.updateTransform=function(){if(this.transformations.length==0){return}for(var b=0;b<this.transformations.length;b++){this.transformations[b].update()}};JXG.Image.prototype.addTransform=function(b){if(JXG.IsArray(b)){for(var d=0;d<b.length;d++){this.transformations.push(b[d])}}else{this.transformations.push(b)}};JXG.createImage=function(b,e,d){return new JXG.Image(b,d.imageString,e[0],e[1],"images",false,false,undefined)};JXG.JSXGraph.registerElement("image",JXG.createImage);JXG.createSlider=function(o,v,r){var k,j,w,l,x,f,e,u,y,m,h,g,d,s,b,q,p;k=v[0];j=v[1];w=v[2][0];l=v[2][1];x=v[2][2];f=o.createElement("point",k,{visible:false,fixed:true,name:""});e=o.createElement("point",j,{visible:false,fixed:true,name:""});u=o.createElement("line",[f,e],{straightFirst:false,straightLast:false,strokewidth:1,name:""});y=1;m=o.createElement("ticks",[u,e.Dist(f)/y],{insertTicks:true,drawLabels:false,drawZero:true});f.needsRegularUpdate=false;e.needsRegularUpdate=false;u.needsRegularUpdate=false;h=k[0]+(j[0]-k[0])*(l-w)/(x-w);g=k[1]+(j[1]-k[1])*(l-w)/(x-w);d=o.createElement("point",[h,g],{slideObject:u,style:6,strokeColor:"#0080c0",fillColor:"#0080c0",name:""});s=o.createElement("line",[f,d],{straightFirst:false,straightLast:false,strokewidth:3,strokeColor:"#0080c0",name:""});b=o.createElement("point",[function(){return d.Dist(f)/e.Dist(f)*(x-w)+w},function(){return d.Dist(f)/e.Dist(f)*(x-w)+w}],{visible:false,name:""});b.Value=b.X;if(r.name&&r.name!=""){q=r.name+" = "}else{q=""}p=o.createElement("text",[((j[0]-k[0])*0.05+j[0]),((j[1]-k[1])*0.05+j[1]),function(){return q+(b.X()).toFixed(2)}],{name:""});return b};JXG.JSXGraph.registerElement("slider",JXG.createSlider);JXG.Chart=function(j,m,f){this.constructor();if(m.length==0){return}this.elements=[];var e=f.id||"";var d=f.name||"";this.init(j,e,d);var n,l,g;if(m.length>0&&(typeof m[0]=="number")){l=m;n=[];for(g=0;g<l.length;g++){n[g]=g+1}}else{if(m.length==1){l=m[0];n=[];var h;if(typeof l=="function"){h=l().length}else{h=l.length}for(g=0;g<h;g++){n[g]=g+1}}if(m.length==2){n=m[0];l=m[1]}}if(f==undefined){f={}}var b=f.chartStyle||"line";b=b.replace(/ /g,"");b=b.split(",");var k;for(g=0;g<b.length;g++){switch(b[g]){case"bar":k=this.drawBar(j,[n,l],f);break;case"line":k=this.drawLine(j,[n,l],f);break;case"spline":k=this.drawSpline(j,[n,l],f);break;case"pie":k=this.drawPie(j,[l],f);break;case"point":k=this.drawPoints(j,[n,l],f);break}}this.id=this.board.addChart(this)};JXG.Chart.prototype=new JXG.GeometryElement;JXG.Chart.prototype.drawLine=function(e,d,b){var f=e.createElement("curve",d,b);this.rendNode=f.rendNode;return f};JXG.Chart.prototype.drawSpline=function(e,j,b){var k=j[0];var g=j[1];var n=JXG.Math.Numerics.splineDef(k,g);var l=new Array();var d=0;var m=(k[k.length-1]-k[0])/e.canvasWidth*1;while(k[0]+d*m<k[k.length-1]){l[d]=k[0]+d*m;d++}var h=JXG.Math.Numerics.splineEval(l,k,g,n);var f=e.createElement("curve",[l,h],b);this.rendNode=f.rendNode;return f};JXG.Chart.prototype.drawBar=function(k,m,h){var j;var g=[];if(h.fillOpacity==undefined){h.fillOpacity=0.6}var n=m[0];var l=m[1];var o;if(h&&h.width){o=h.width}else{if(n.length<=1){o=1}else{o=n[1]-n[0];for(j=1;j<n.length-1;j++){o=(n[j+1]-n[j]<o)?(n[j+1]-n[j]):o}}o*=0.8}for(j=0;j<n.length;j++){var e,r,q,d,b;if(typeof n[j]=="function"){e=function(){return n[j]()-o*0.5};r=function(){return n[j]()};q=function(){return n[j]()+o*0.5}}else{e=n[j]-o*0.5;r=n[j];q=n[j]+o*0.5}if(typeof l[j]=="function"){b=d}else{b=l[j]+0.2}d=l[j];var f=[];if(h.dir=="horizontal"){f[0]=k.createElement("point",[0,e],{name:"",fixed:true,visible:false});f[1]=k.createElement("point",[d,e],{name:"",fixed:true,visible:false});f[2]=k.createElement("point",[d,q],{name:"",fixed:true,visible:false});f[3]=k.createElement("point",[0,q],{name:"",fixed:true,visible:false});if(h.labels&&h.labels[j]){k.createElement("text",[d,q,h.labels[j]],h)}}else{f[0]=k.createElement("point",[e,0],{name:"",fixed:true,visible:false});f[1]=k.createElement("point",[e,d],{name:"",fixed:true,visible:false});f[2]=k.createElement("point",[q,d],{name:"",fixed:true,visible:false});f[3]=k.createElement("point",[q,0],{name:"",fixed:true,visible:false});if(h.labels&&h.labels[j]){k.createElement("text",[q,d,h.labels[j]],h)}}h.withLines=false;g[j]=k.createElement("polygon",f,h)}this.rendNode=g[0].rendNode;return g};JXG.Chart.prototype.drawPoints=function(h,e,d){var f;var g=[];d.fixed=true;d.name="";var b=e[0];var j=e[1];for(f=0;f<b.length;f++){g[f]=h.createElement("point",[b[f],j[f]],d)}this.rendNode=g[0].rendNode;return g};JXG.Chart.prototype.drawPie=function(f,v,h){var j=v[0];if(j.length<=0){return}if(typeof j[0]=="function"){return}var u;var q=[];var l=[];var g=[];var m=f.mathStatistics.sum(j);var e=h.colorArray||["#B02B2C","#3F4C6B","#C79810","#D15600","#FFFF88","#C3D9FF","#4096EE","#008C00"];var d=h.radius||4;var w={};w.name=h.name;w.id=h.id;w.strokeWidth=h.strokeWidth||1;w.strokeColor=h.strokeColor||"none";w.straightFirst=false;w.straightLast=false;w.fillColor=h.fillColor||"#FFFF88";w.fillOpacity=h.fillOpacity||0.6;w.highlightFillColor=h.highlightFillColor||"#FF7400";w.highlightStrokeColor=h.highlightStrokeColor||"#FF7400";var o=h.center||[0,0];var r=o[0];var b=o[1];var x=f.createElement("point",[r,b],{name:"",fixed:true,visible:false});q[0]=f.createElement("point",[d+r,0+b],{name:"",fixed:true,visible:false});var z=0;for(u=0;u<j.length;u++){z+=(m!=0)?(2*Math.PI*j[u]/m):0;var k=d*Math.cos(z)+r;var n=d*Math.sin(z)+b;q[u+1]=f.createElement("point",[k,n],{name:"",fixed:true,visible:false});l[u]=f.createElement("line",[x,q[u]],{strokeColor:"#ffffff",straightFirst:false,straightLast:false,strokeWidth:6,strokeOpacity:1});w.fillColor=e[u%e.length];g[u]=f.createElement("arc",[x,q[u],q[u+1]],w)}this.rendNode=g[0].rendNode;return g};JXG.Chart.prototype.updateRenderer=function(){};JXG.Chart.prototype.update=function(){if(this.needsUpdate){this.updateDataArray()}};JXG.Chart.prototype.updateDataArray=function(){};JXG.createChart=function(e,d,b){return new JXG.Chart(e,d,b)};JXG.JSXGraph.registerElement("chart",JXG.createChart);JXG.Transformation=function(d,b,e){this.elementClass=JXG.OBJECT_CLASS_OTHER;this.matrix=[[1,0,0],[0,1,0],[0,0,1]];this.board=d;this.isNumericMatrix=false;this.setMatrix(d,b,e)};JXG.Transformation.prototype={};JXG.Transformation.prototype.update=function(){};JXG.Transformation.prototype.setMatrix=function(e,d,f){var b;this.isNumericMatrix=true;for(b=0;b<f.length;b++){if(typeof f[b]!="number"){this.isNumericMatrix=false;break}}if(d=="translate"){this.evalParam=JXG.createEvalFunction(e,f,2);this.update=function(){this.matrix[1][0]=this.evalParam(0);this.matrix[2][0]=this.evalParam(1)}}else{if(d=="scale"){this.evalParam=JXG.createEvalFunction(e,f,2);this.update=function(){this.matrix[1][1]=this.evalParam(0);this.matrix[2][2]=this.evalParam(1)}}else{if(d=="reflect"){if(f.length<4){f[0]=JXG.GetReferenceFromParameter(e,f[0])}if(f.length==2){f[1]=JXG.GetReferenceFromParameter(e,f[1])}if(f.length==4){this.evalParam=JXG.createEvalFunction(e,f,4)}this.update=function(){if(f.length==1){var g=f[0].point2.X()-f[0].point1.X();var l=f[0].point2.Y()-f[0].point1.Y();var h=f[0].point1.X();var k=f[0].point1.Y()}else{if(f.length==2){var g=f[1].X()-f[0].X();var l=f[1].Y()-f[0].Y();var h=f[0].X();var k=f[0].Y()}else{if(f.length==4){var g=this.evalParam(2)-this.evalParam(0);var l=this.evalParam(3)-this.evalParam(1);var h=this.evalParam(0);var k=this.evalParam(1)}}}var j=g*g+l*l;this.matrix[1][1]=(g*g-l*l)/j;this.matrix[1][2]=2*g*l/j;this.matrix[2][1]=2*g*l/j;this.matrix[2][2]=(-g*g+l*l)/j;this.matrix[1][0]=h*(1-this.matrix[1][1])-k*this.matrix[1][2];this.matrix[2][0]=k*(1-this.matrix[2][2])-h*this.matrix[2][1]}}else{if(d=="rotate"){if(f.length==3){this.evalParam=JXG.createEvalFunction(e,f,3)}else{if(f.length<=2){this.evalParam=JXG.createEvalFunction(e,f,1);if(f.length==2){f[1]=JXG.GetReferenceFromParameter(e,f[1])}}}this.update=function(){var h=this.evalParam(0);this.matrix[1][1]=Math.cos(h);this.matrix[1][2]=-Math.sin(h);this.matrix[2][1]=Math.sin(h);this.matrix[2][2]=Math.cos(h);if(f.length>1){if(f.length==3){var g=this.evalParam(1);var j=this.evalParam(2)}else{var g=f[1].X();var j=f[1].Y()}this.matrix[1][0]=g*(1-Math.cos(h))+j*Math.sin(h);this.matrix[2][0]=j*(1-Math.cos(h))-g*Math.sin(h)}}}else{if(d=="shear"){this.evalParam=JXG.createEvalFunction(e,f,1);this.update=function(){var g=this.evalParam(0);this.matrix[1][1]=Math.tan(g)}}else{if(d=="generic"){this.evalParam=JXG.createEvalFunction(e,f,9);this.update=function(){this.matrix[0][0]=this.evalParam(0);this.matrix[0][1]=this.evalParam(1);this.matrix[0][2]=this.evalParam(2);this.matrix[1][0]=this.evalParam(3);this.matrix[1][1]=this.evalParam(4);this.matrix[1][2]=this.evalParam(5);this.matrix[2][0]=this.evalParam(6);this.matrix[2][1]=this.evalParam(7);this.matrix[2][2]=this.evalParam(8)}}}}}}}};JXG.Transformation.prototype.apply=function(b){this.update();if(arguments[1]!=null){return this.matVecMult(this.matrix,b.initialCoords.usrCoords)}else{return this.matVecMult(this.matrix,b.coords.usrCoords)}};JXG.Transformation.prototype.applyOnce=function(d){if(!JXG.IsArray(d)){this.update();var e=this.matVecMult(this.matrix,d.coords.usrCoords);d.coords.setCoordinates(JXG.COORDS_BY_USER,[e[1],e[2]])}else{for(var b=0;b<d.length;b++){this.update();var e=this.matVecMult(this.matrix,d[b].coords.usrCoords);d[b].coords.setCoordinates(JXG.COORDS_BY_USER,[e[1],e[2]])}}};JXG.Transformation.prototype.bindTo=function(d){if(JXG.IsArray(d)){for(var b=0;b<d.length;b++){d[b].transformations.push(this)}}else{d.transformations.push(this)}};JXG.Transformation.prototype.matVecMult=function(d,b){return this.board.algebra.matVecMult(d,b)};JXG.Transformation.prototype.setProperty=function(b){};JXG.Transformation.prototype.melt=function(g){var f=[];for(var e=0;e<g.matrix.length;e++){f[e]=[]}this.update();g.update();for(e=0;e<g.matrix.length;e++){for(var d=0;d<this.matrix[0].length;d++){var h=0;for(var b=0;b<this.matrix.length;b++){h+=g.matrix[e][b]*this.matrix[b][d]}f[e][d]=h}}this.update=function(){for(e=0;e<this.matrix.length;e++){for(d=0;d<this.matrix[0].length;d++){this.matrix[e][d]=f[e][d]}}};return true};JXG.createTransform=function(b,e,d){return new JXG.Transformation(b,d.type,e)};JXG.JSXGraph.registerElement("transform",JXG.createTransform);JXG.Turtle=function(e,d,b){this.arrowLen=20;this.turtleIsHidden=false;this.board=e;if(b==null){this.attributes={}}else{this.attributes=b}this.attributes.straightFirst=false;this.attributes.straightLast=false;this.init();if(d.length!=0){if(d.length==3){this.setPos(d[0],d[1]);this.right(90-d[2])}else{if(d.length==2){if(JXG.IsArray(d[0])){this.setPos(d[0][0],d[0][1]);this.right(90-d[1])}else{this.setPos(d[0],d[1])}}else{this.setPos(d[0][0],d[0][1])}}}return this};JXG.Turtle.prototype=new JXG.GeometryElement;JXG.Turtle.prototype.init=function(){this.arrowLen=20/Math.sqrt(this.board.unitX*this.board.unitX+this.board.unitY*this.board.unitY);this.pos=[0,0];this.isPenDown=true;this.dir=90;this.stack=[];this.objects=[];this.attributes.curveType="plot";this.curve=this.board.createElement("curve",[[this.pos[0]],[this.pos[1]]],this.attributes);this.objects.push(this.curve);this.turtle=this.board.createElement("point",this.pos,{fixed:true,name:" ",visible:false});this.objects.push(this.turtle);this.turtle2=this.board.createElement("point",[this.pos[0],this.pos[1]+this.arrowLen],{fixed:true,name:" ",visible:false});this.objects.push(this.turtle2);var b=this.attributes.strokeWidth||this.attributes.strokewidth||2;this.arrow=this.board.createElement("line",[this.turtle,this.turtle2],{lastArrow:true,strokeColor:"#ff0000",straightFirst:false,straightLast:false,strokeWidth:b});this.objects.push(this.arrow);this.board.update()};JXG.Turtle.prototype.forward=function(b){if(b==0){return}var e=b*Math.cos(this.dir*Math.PI/180);var d=b*Math.sin(this.dir*Math.PI/180);if(!this.turtleIsHidden){var f=this.board.createElement("transform",[e,d],{type:"translate"});f.applyOnce(this.turtle);f.applyOnce(this.turtle2)}if(this.isPenDown){if(this.curve.dataX.length>=8192){this.curve=this.board.createElement("curve",[[this.pos[0]],[this.pos[1]]],this.attributes);this.objects.push(this.curve)}}this.pos[0]+=e;this.pos[1]+=d;if(this.isPenDown){this.curve.dataX.push(this.pos[0]);this.curve.dataY.push(this.pos[1])}this.board.update();return this};JXG.Turtle.prototype.back=function(b){return this.forward(-b)};JXG.Turtle.prototype.right=function(d){this.dir-=d;this.dir%=360;if(!this.turtleIsHidden){var b=this.board.createElement("transform",[-d*Math.PI/180,this.turtle],{type:"rotate"});b.applyOnce(this.turtle2)}this.board.update();return this};JXG.Turtle.prototype.left=function(b){return this.right(-b)};JXG.Turtle.prototype.penUp=function(){this.isPenDown=false;return this};JXG.Turtle.prototype.penDown=function(){this.isPenDown=true;this.curve=this.board.createElement("curve",[[this.pos[0]],[this.pos[1]]],this.attributes);this.objects.push(this.curve);return this};JXG.Turtle.prototype.clean=function(){for(var b=0;b<this.objects.length;b++){var d=this.objects[b];if(d.type==JXG.OBJECT_TYPE_CURVE){this.board.removeObject(d.id);this.objects.splice(b,1)}}this.curve=this.board.createElement("curve",[[this.pos[0]],[this.pos[1]]],this.attributes);this.objects.push(this.curve);this.board.update();return this};JXG.Turtle.prototype.clearScreen=function(){for(var b=0;b<this.objects.length;b++){var d=this.objects[b];this.board.removeObject(d.id)}this.init();return this};JXG.Turtle.prototype.setPos=function(b,e){if(JXG.IsArray(b)){this.pos=b}else{this.pos=[b,e]}if(!this.turtleIsHidden){this.turtle.setPositionDirectly(JXG.COORDS_BY_USER,b,e);this.turtle2.setPositionDirectly(JXG.COORDS_BY_USER,b,e+this.arrowLen);var d=this.board.createElement("transform",[-(this.dir-90)*Math.PI/180,this.turtle],{type:"rotate"});d.applyOnce(this.turtle2)}this.curve=this.board.createElement("curve",[[this.pos[0]],[this.pos[1]]],this.attributes);this.objects.push(this.curve);this.board.update();return this};JXG.Turtle.prototype.setPenSize=function(b){this.attributes.strokeWidth=b;this.curve=this.board.createElement("curve",[[this.pos[0]],[this.pos[1]]],this.attributes);this.objects.push(this.curve);return this};JXG.Turtle.prototype.setPenColor=function(b){this.attributes.strokeColor=b;this.curve=this.board.createElement("curve",[[this.pos[0]],[this.pos[1]]],this.attributes);this.objects.push(this.curve);return this};JXG.Turtle.prototype.setProperty=function(){var f;var b;var e;var d;for(e=0;e<arguments.length;e++){b=arguments[e];if(typeof b=="string"){f=b.split(":")}else{if(!JXG.IsArray(b)){for(var d in b){this.setProperty([d,b[d]])}return this}else{f=b}}this.attributes[f[0]]=f[1]}this.curve=this.board.createElement("curve",[[this.pos[0]],[this.pos[1]]],this.attributes);this.objects.push(this.curve);return this};JXG.Turtle.prototype.showTurtle=function(){this.turtleIsHidden=false;this.arrow.setProperty("visible:true");this.setPos(this.pos[0],this.pos[1]);this.board.update();return this};JXG.Turtle.prototype.hideTurtle=function(){this.turtleIsHidden=true;this.arrow.setProperty("visible:false");this.setPos(this.pos[0],this.pos[1]);this.board.update();return this};JXG.Turtle.prototype.home=function(){this.pos=[0,0];this.setPos(this.pos[0],this.pos[1]);return this};JXG.Turtle.prototype.pushTurtle=function(){this.stack.push([this.pos[0],this.pos[1],this.dir]);return this};JXG.Turtle.prototype.popTurtle=function(){var b=this.stack.pop();this.pos[0]=b[0];this.pos[1]=b[1];this.dir=b[2];this.setPos(this.pos[0],this.pos[1]);return this};JXG.Turtle.prototype.lookTo=function(g){if(JXG.IsArray(g)){var d=this.pos[0];var b=this.pos[1];var j=g[0];var f=g[1];var e;var h=(j-d>0)?1:-1;if(Math.abs(j-d)>1e-7){e=Math.atan((f-b)/(j-d))+((h<0)?Math.PI:0)}else{e=((f-b>0)?0.5:-0.5)*Math.PI}this.right(this.dir-(e*180/Math.PI))}else{if(JXG.IsNumber(g)){this.right(this.dir-(g))}}return this};JXG.Turtle.prototype.moveTo=function(f){if(JXG.IsArray(f)){var d=f[0]-this.pos[0];var b=f[1]-this.pos[1];if(!this.turtleIsHidden){var e=this.board.createElement("transform",[d,b],{type:"translate"});e.applyOnce(this.turtle);e.applyOnce(this.turtle2)}if(this.isPenDown){if(this.curve.dataX.length>=8192){this.curve=this.board.createElement("curve",[[this.pos[0]],[this.pos[1]]],this.attributes);this.objects.push(this.curve)}}this.pos[0]=f[0];this.pos[1]=f[1];if(this.isPenDown){this.curve.dataX.push(this.pos[0]);this.curve.dataY.push(this.pos[1])}this.board.update()}return this};JXG.Turtle.prototype.fd=function(b){return this.forward(b)};JXG.Turtle.prototype.bk=function(b){return this.back(b)};JXG.Turtle.prototype.lt=function(b){return this.left(b)};JXG.Turtle.prototype.rt=function(b){return this.right(b)};JXG.Turtle.prototype.pu=function(){return this.penUp()};JXG.Turtle.prototype.pd=function(){return this.penDown()};JXG.Turtle.prototype.ht=function(){return this.hideTurtle()};JXG.Turtle.prototype.st=function(){return this.showTurtle()};JXG.Turtle.prototype.cs=function(){return this.clearScreen()};JXG.Turtle.prototype.push=function(){return this.pushTurtle()};JXG.Turtle.prototype.pop=function(){return this.popTurtle()};JXG.Turtle.prototype.X=function(b){return this.pos[0]};JXG.Turtle.prototype.Y=function(b){return this.pos[1]};JXG.createTurtle=function(e,d,b){if(d==null){var d=[]}return new JXG.Turtle(e,d,b)};JXG.JSXGraph.registerElement("turtle",JXG.createTurtle);JXG.RGBColor=function(j){this.ok=false;if(j.charAt(0)=="#"){j=j.substr(1,6)}j=j.replace(/ /g,"");j=j.toLowerCase();var b={aliceblue:"f0f8ff",antiquewhite:"faebd7",aqua:"00ffff",aquamarine:"7fffd4",azure:"f0ffff",beige:"f5f5dc",bisque:"ffe4c4",black:"000000",blanchedalmond:"ffebcd",blue:"0000ff",blueviolet:"8a2be2",brown:"a52a2a",burlywood:"deb887",cadetblue:"5f9ea0",chartreuse:"7fff00",chocolate:"d2691e",coral:"ff7f50",cornflowerblue:"6495ed",cornsilk:"fff8dc",crimson:"dc143c",cyan:"00ffff",darkblue:"00008b",darkcyan:"008b8b",darkgoldenrod:"b8860b",darkgray:"a9a9a9",darkgreen:"006400",darkkhaki:"bdb76b",darkmagenta:"8b008b",darkolivegreen:"556b2f",darkorange:"ff8c00",darkorchid:"9932cc",darkred:"8b0000",darksalmon:"e9967a",darkseagreen:"8fbc8f",darkslateblue:"483d8b",darkslategray:"2f4f4f",darkturquoise:"00ced1",darkviolet:"9400d3",deeppink:"ff1493",deepskyblue:"00bfff",dimgray:"696969",dodgerblue:"1e90ff",feldspar:"d19275",firebrick:"b22222",floralwhite:"fffaf0",forestgreen:"228b22",fuchsia:"ff00ff",gainsboro:"dcdcdc",ghostwhite:"f8f8ff",gold:"ffd700",goldenrod:"daa520",gray:"808080",green:"008000",greenyellow:"adff2f",honeydew:"f0fff0",hotpink:"ff69b4",indianred:"cd5c5c",indigo:"4b0082",ivory:"fffff0",khaki:"f0e68c",lavender:"e6e6fa",lavenderblush:"fff0f5",lawngreen:"7cfc00",lemonchiffon:"fffacd",lightblue:"add8e6",lightcoral:"f08080",lightcyan:"e0ffff",lightgoldenrodyellow:"fafad2",lightgrey:"d3d3d3",lightgreen:"90ee90",lightpink:"ffb6c1",lightsalmon:"ffa07a",lightseagreen:"20b2aa",lightskyblue:"87cefa",lightslateblue:"8470ff",lightslategray:"778899",lightsteelblue:"b0c4de",lightyellow:"ffffe0",lime:"00ff00",limegreen:"32cd32",linen:"faf0e6",magenta:"ff00ff",maroon:"800000",mediumaquamarine:"66cdaa",mediumblue:"0000cd",mediumorchid:"ba55d3",mediumpurple:"9370d8",mediumseagreen:"3cb371",mediumslateblue:"7b68ee",mediumspringgreen:"00fa9a",mediumturquoise:"48d1cc",mediumvioletred:"c71585",midnightblue:"191970",mintcream:"f5fffa",mistyrose:"ffe4e1",moccasin:"ffe4b5",navajowhite:"ffdead",navy:"000080",oldlace:"fdf5e6",olive:"808000",olivedrab:"6b8e23",orange:"ffa500",orangered:"ff4500",orchid:"da70d6",palegoldenrod:"eee8aa",palegreen:"98fb98",paleturquoise:"afeeee",palevioletred:"d87093",papayawhip:"ffefd5",peachpuff:"ffdab9",peru:"cd853f",pink:"ffc0cb",plum:"dda0dd",powderblue:"b0e0e6",purple:"800080",red:"ff0000",rosybrown:"bc8f8f",royalblue:"4169e1",saddlebrown:"8b4513",salmon:"fa8072",sandybrown:"f4a460",seagreen:"2e8b57",seashell:"fff5ee",sienna:"a0522d",silver:"c0c0c0",skyblue:"87ceeb",slateblue:"6a5acd",slategray:"708090",snow:"fffafa",springgreen:"00ff7f",steelblue:"4682b4",tan:"d2b48c",teal:"008080",thistle:"d8bfd8",tomato:"ff6347",turquoise:"40e0d0",violet:"ee82ee",violetred:"d02090",wheat:"f5deb3",white:"ffffff",whitesmoke:"f5f5f5",yellow:"ffff00",yellowgreen:"9acd32"};for(var e in b){if(j==e){j=b[e]}}var k=[{re:/^rgb\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,example:["rgb(123, 234, 45)","rgb(255,234,245)"],process:function(l){return[parseInt(l[1]),parseInt(l[2]),parseInt(l[3])]}},{re:/^(\w{2})(\w{2})(\w{2})$/,example:["#00ff00","336699"],process:function(l){return[parseInt(l[1],16),parseInt(l[2],16),parseInt(l[3],16)]}},{re:/^(\w{1})(\w{1})(\w{1})$/,example:["#fb0","f0f"],process:function(l){return[parseInt(l[1]+l[1],16),parseInt(l[2]+l[2],16),parseInt(l[3]+l[3],16)]}}];for(var d=0;d<k.length;d++){var g=k[d].re;var f=k[d].process;var h=g.exec(j);if(h){channels=f(h);this.r=channels[0];this.g=channels[1];this.b=channels[2];this.ok=true}}this.r=(this.r<0||isNaN(this.r))?0:((this.r>255)?255:this.r);this.g=(this.g<0||isNaN(this.g))?0:((this.g>255)?255:this.g);this.b=(this.b<0||isNaN(this.b))?0:((this.b>255)?255:this.b)};JXG.RGBColor.prototype.toRGB=function(){return"rgb("+this.r+", "+this.g+", "+this.b+")"};JXG.RGBColor.prototype.toHex=function(){var f=this.r.toString(16);var e=this.g.toString(16);var d=this.b.toString(16);if(f.length==1){f="0"+f}if(e.length==1){e="0"+e}if(d.length==1){d="0"+d}return"#"+f+e+d};JXG.Board=function(b,g,d,m,l,k,j,h,e,f){this.BOARD_MODE_NONE=0;this.BOARD_MODE_DRAG=1;this.BOARD_MODE_CONSTRUCT=16;this.BOARD_MODE_MOVE_ORIGIN=2;this.BOARD_QUALITY_LOW=1;this.BOARD_QUALITY_HIGH=2;this.CONSTRUCTION_TYPE_POINT=1129599060;this.CONSTRUCTION_TYPE_CIRCLE=1129595724;this.CONSTRUCTION_TYPE_LINE=1129598030;this.CONSTRUCTION_TYPE_GLIDER=1129596740;this.CONSTRUCTION_TYPE_MIDPOINT=1129598288;this.CONSTRUCTION_TYPE_PERPENDICULAR=1129599044;this.CONSTRUCTION_TYPE_PARALLEL=1129599052;this.CONSTRUCTION_TYPE_INTERSECTION=1129597267;this.container=b;this.containerObj=document.getElementById(this.container);this.renderer=g;this.options=new JXG.Options();this.dimension=2;this.origin={};this.origin.usrCoords=[1,0,0];this.origin.scrCoords=[1,m[0],m[1]];this.zoomX=l;this.zoomY=k;this.unitX=j;this.unitY=h;this.canvasWidth=e;this.canvasHeight=f;this.fontSize=this.options.fontSize;this.algebra=new JXG.Algebra(this);this.mathStatistics=new JXG.MathStatistics();if((d!="")&&(d!=null)&&(typeof document.getElementById(d)!="undefined")){this.id=d}else{this.id=this.generateId()}this.hooks=[];this.objects={};this.highlightedObjects={};this.numObjects=0;this.elementsByName={};this.mode=this.BOARD_MODE_NONE;this.updateQuality=this.BOARD_QUALITY_HIGH;this.isSuspendedRedraw=false;this.snapToGrid=this.options.grid.snapToGrid;this.gridX=this.options.grid.gridX;this.gridY=this.options.grid.gridY;this.gridColor=this.options.grid.gridColor;this.gridOpacity=this.options.grid.gridOpacity;this.gridDash=this.options.grid.gridDash;this.snapSizeX=this.options.grid.snapSizeX;this.snapSizeY=this.options.grid.snapSizeY;this.calculateSnapSizes();this.hasGrid=this.options.grid.hasGrid;this.drag_dx=0;this.drag_dy=0;this.drag_obj=null;this.xmlString="";this.renderer.displayCopyright(JXG.JSXGraph.licenseText,this.options.fontSize);this.fullUpdate=false;this.reducedUpdate=false;this.geonextCompatibilityMode=false;JXG.addEvent(document,"mousedown",this.mouseDownListener,this);JXG.addEvent(this.containerObj,"mousemove",this.mouseMoveListener,this);this.pstricks=new JXG.PsTricks()};JXG.Board.prototype.generateName=function(d){var k;if(d.elementClass==JXG.OBJECT_CLASS_POINT){k=["","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"]}else{k=["","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z"]}var f=3;var l="";if(d.elementClass==JXG.OBJECT_CLASS_POINT||d.elementClass==JXG.OBJECT_CLASS_LINE){l=""}else{if(d.type==JXG.OBJECT_TYPE_POLYGON){l="P_"}else{if(d.type==JXG.OBJECT_TYPE_CIRCLE){l="k_"}else{l="s_"}}}var m=[];var b="";var g="";var h=0;var e=0;for(h=0;h<f;h++){m[h]=0}while(m[f-1]<k.length){for(m[0]=1;m[0]<k.length;m[0]++){b=l;for(h=f;h>0;h--){b+=k[m[h-1]]}if(this.elementsByName[b]==null){return b}}m[0]=k.length;for(h=1;h<f;h++){if(m[h-1]==k.length){m[h-1]=1;m[h]++}}}return""};JXG.Board.prototype.generateId=function(){var b=1;while(JXG.JSXGraph.boards["gxtBoard"+b]!=null){b=Math.round(Math.random()*33)}return("gxtBoard"+b)};JXG.Board.prototype.getRelativeMouseCoordinates=function(d){var e=this.containerObj;var b=JXG.getOffset(e);b[0]+=parseInt(JXG.getStyle(e,"borderLeftWidth"));b[1]+=parseInt(JXG.getStyle(e,"borderTopWidth"));b[0]+=parseInt(JXG.getStyle(e,"paddingLeft"));b[1]+=parseInt(JXG.getStyle(e,"paddingTop"));return b};JXG.Board.prototype.clickLeftArrow=function(b){this.origin.scrCoords[1]+=this.canvasWidth*0.1;this.fullUpdate=true;this.moveOrigin();this.fullUpdate=false};JXG.Board.prototype.clickRightArrow=function(b){this.origin.scrCoords[1]-=this.canvasWidth*0.1;this.fullUpdate=true;this.moveOrigin();this.fullUpdate=false};JXG.Board.prototype.clickUpArrow=function(b){this.origin.scrCoords[2]+=this.canvasHeight*0.1;this.fullUpdate=true;this.moveOrigin();this.fullUpdate=false};JXG.Board.prototype.clickDownArrow=function(b){this.origin.scrCoords[2]-=this.canvasHeight*0.1;this.fullUpdate=true;this.moveOrigin();this.fullUpdate=false};JXG.Board.prototype.mouseUpListener=function(b){this.updateQuality=this.BOARD_QUALITY_HIGH;JXG.removeEvent(document,"mouseup",this.mouseUpListener,this);if(this.mode==this.BOARD_MODE_MOVE_ORIGIN){this.fullUpdate=true;this.moveOrigin()}this.mode=this.BOARD_MODE_NONE;var d=this.reducedUpdate;this.reducedUpdate=false;this.update();this.reducedUpdate=d;this.fullUpdate=false;this.drag_obj=null};JXG.Board.prototype.mouseDownListener=function(h){var f;var g=this.getRelativeMouseCoordinates(h);var b=JXG.getPosition(h);var e=b[0]-g[0];var d=b[1]-g[1];if(h.shiftKey){this.drag_dx=e-this.origin.scrCoords[1];this.drag_dy=d-this.origin.scrCoords[2];this.mode=this.BOARD_MODE_MOVE_ORIGIN;JXG.addEvent(document,"mouseup",this.mouseUpListener,this);return}if(this.mode==this.BOARD_MODE_CONSTRUCT){return}this.mode=this.BOARD_MODE_DRAG;if(this.mode==this.BOARD_MODE_DRAG){for(f in this.objects){if((this.objects[f].hasPoint!=undefined)&&(this.objects[f].hasPoint(e,d))&&((this.objects[f].type==JXG.OBJECT_TYPE_POINT)||(this.objects[f].type==JXG.OBJECT_TYPE_GLIDER))&&(this.objects[f].visProp.visible)&&(!this.objects[f].fixed)){this.drag_obj=this.objects[f];if((this.objects[f].type==JXG.OBJECT_TYPE_POINT)||(this.objects[f].type==JXG.OBJECT_TYPE_GLIDER)){break}}}}if(this.drag_obj==null){this.mode=this.BOARD_MODE_NONE;return}this.dragObjCoords=new JXG.Coords(JXG.COORDS_BY_SCREEN,[e,d],this);JXG.addEvent(document,"mouseup",this.mouseUpListener,this)};JXG.Board.prototype.mouseMoveListener=function(e){var g;var j=this.getRelativeMouseCoordinates(e);var d=JXG.getPosition(e);var b=d[0]-j[0];var k=d[1]-j[1];this.updateQuality=this.BOARD_QUALITY_LOW;this.dehighlightAll();if(this.mode!=this.BOARD_MODE_DRAG){this.renderer.hide(this.infobox)}if(this.mode==this.BOARD_MODE_MOVE_ORIGIN){this.origin.scrCoords[1]=b-this.drag_dx;this.origin.scrCoords[2]=k-this.drag_dy;this.fullUpdate=true;this.moveOrigin()}else{if(this.mode==this.BOARD_MODE_DRAG){var f=new JXG.Coords(JXG.COORDS_BY_SCREEN,this.getScrCoordsOfMouse(b,k),this);if(this.drag_obj.type==JXG.OBJECT_TYPE_POINT||this.drag_obj.type==JXG.OBJECT_TYPE_LINE||this.drag_obj.type==JXG.OBJECT_TYPE_CIRCLE||this.drag_obj.type==JXG.OBJECT_TYPE_CURVE){if((this.geonextCompatibilityMode&&this.drag_obj.type==JXG.OBJECT_TYPE_POINT)||this.drag_obj.group.length!=0){this.drag_obj.setPositionDirectly(JXG.COORDS_BY_USER,f.usrCoords[1],f.usrCoords[2])}else{this.drag_obj.setPositionByTransform(JXG.COORDS_BY_USER,f.usrCoords[1]-this.dragObjCoords.usrCoords[1],f.usrCoords[2]-this.dragObjCoords.usrCoords[2]);this.dragObjCoords=f}this.update()}else{if(this.drag_obj.type==JXG.OBJECT_TYPE_GLIDER){var h=this.drag_obj.coords;this.drag_obj.setPositionDirectly(JXG.COORDS_BY_USER,f.usrCoords[1],f.usrCoords[2]);if(this.drag_obj.slideObject.type==JXG.OBJECT_TYPE_CIRCLE){this.drag_obj.coords=this.algebra.projectPointToCircle(this.drag_obj,this.drag_obj.slideObject)}else{if(this.drag_obj.slideObject.type==JXG.OBJECT_TYPE_LINE){this.drag_obj.coords=this.algebra.projectPointToLine(this.drag_obj,this.drag_obj.slideObject)}}if(this.drag_obj.group.length!=0){this.drag_obj.group[this.drag_obj.group.length-1].dX=this.drag_obj.coords.scrCoords[1]-h.scrCoords[1];this.drag_obj.group[this.drag_obj.group.length-1].dY=this.drag_obj.coords.scrCoords[2]-h.scrCoords[2];this.drag_obj.group[this.drag_obj.group.length-1].update(this)}else{this.update(this.drag_obj)}}}this.updateInfobox(this.drag_obj)}else{for(g in this.objects){if((this.objects[g].hasPoint!=undefined)&&(this.objects[g].hasPoint(b,k))&&(this.objects[g].visProp.visible==true)){this.renderer.highlight(this.objects[g]);this.highlightedObjects[g]=this.objects[g];this.updateInfobox(this.objects[g])}}}}this.fullUpdate=false};JXG.Board.prototype.updateInfobox=function(d){var b,e;if(d.elementClass==JXG.OBJECT_CLASS_POINT){this.infobox.setCoordinates(d.coords);b=Math.abs(d.coords.usrCoords[1]);if(b>0.1){b=d.coords.usrCoords[1].toFixed(2)}else{if(b>=0.01){b=d.coords.usrCoords[1].toFixed(4)}else{if(b>=0.0001){b=d.coords.usrCoords[1].toFixed(6)}else{b=d.coords.usrCoords[1]}}}e=Math.abs(d.coords.usrCoords[2]);if(e>0.1){e=d.coords.usrCoords[2].toFixed(2)}else{if(e>=0.01){e=d.coords.usrCoords[2].toFixed(4)}else{if(e>=0.0001){e=d.coords.usrCoords[2].toFixed(6)}else{e=d.coords.usrCoords[2]}}}this.infobox.nameHTML='<span style="color:#bbbbbb;">('+b+", "+e+")</span>";this.renderer.show(this.infobox);this.renderer.updateLabel(this.infobox)}};JXG.Board.prototype.dehighlightAll=function(){for(var b in this.highlightedObjects){this.renderer.noHighlight(this.highlightedObjects[b])}this.highlightedObjects={}};JXG.Board.prototype.getScrCoordsOfMouse=function(b,e){if(this.snapToGrid){var d=new JXG.Coords(JXG.COORDS_BY_SCREEN,[b,e],this);d.setCoordinates(JXG.COORDS_BY_USER,[Math.round((d.usrCoords[1])*this.snapSizeX)/this.snapSizeX,Math.round((d.usrCoords[2])*this.snapSizeY)/this.snapSizeY]);return[d.scrCoords[1],d.scrCoords[2]]}else{return[b,e]}};JXG.Board.prototype.getUsrCoordsOfMouse=function(g){var e=this.getRelativeMouseCoordinates(g);var d=JXG.getPosition(g);var b=d[0]-e[0];var h=d[1]-e[1];var f=new JXG.Coords(JXG.COORDS_BY_SCREEN,[b,h],this);if(this.snapToGrid){f.setCoordinates(JXG.COORDS_BY_USER,[Math.round((f.usrCoords[1])*this.snapSizeX)/this.snapSizeX,Math.round((f.usrCoords[2])*this.snapSizeY)/this.snapSizeY])}return[f.usrCoords[1],f.usrCoords[2]]};JXG.Board.prototype.getAllUnderMouse=function(d){var b=this.getAllObjectsUnderMouse(d);b.push(this.getUsrCoordsOfMouse(d));return b};JXG.Board.prototype.getAllObjectsUnderMouse=function(j){var h=this.getRelativeMouseCoordinates(j);var b=JXG.getPosition(j);var e=b[0]-h[0];var d=b[1]-h[1];var f=[];for(var g in this.objects){if(this.objects[g].hasPoint(e,d)){f.push(this.objects[g])}}return f};JXG.Board.prototype.setBoardMode=function(b){this.mode=b};JXG.Board.prototype.moveOrigin=function(){for(var b in this.objects){if((this.objects[b].elementClass==JXG.OBJECT_CLASS_POINT)||(this.objects[b].type==JXG.OBJECT_TYPE_CURVE)||(this.objects[b].type==JXG.OBJECT_TYPE_AXIS)||(this.objects[b].type==JXG.OBJECT_TYPE_TEXT)){if((this.objects[b].type!=JXG.OBJECT_TYPE_CURVE)&&(this.objects[b].type!=JXG.OBJECT_TYPE_AXIS)){this.objects[b].coords.usr2screen()}}}this.clearTraces();this.update();if(this.hasGrid){this.renderer.removeGrid(this);this.renderer.drawGrid(this)}};JXG.Board.prototype.addPoint=function(e){var d=this.numObjects;this.numObjects++;var b=e.id;if((b=="")||(b==null)){b=this.id+"P"+d}e.label.id=b+"Label";this.objects[b]=e;this.elementsByName[e.name]=e;e.id=b;this.renderer.drawPoint(e);this.renderer.drawLabel(e.label);if(!e.visProp.visible){this.renderer.hide(e)}if(!e.label.show){this.renderer.hide(e.label)}return b};JXG.Board.prototype.addLine=function(e){var d=this.numObjects;this.numObjects++;var b=e.id;if((b=="")||(b==null)){b=this.id+"L"+d}this.objects[b]=e;e.id=b;this.renderer.drawLine(e);return b};JXG.Board.prototype.addCircle=function(e){var d=this.numObjects;this.numObjects++;var b=e.id;if((b=="")||(b==null)){b=this.id+"C"+d}this.objects[b]=e;e.id=b;this.renderer.drawCircle(e);return b};JXG.Board.prototype.addPolygon=function(e){var d=this.numObjects;this.numObjects++;var b=e.id;if((b=="")||(b==null)){b=this.id+"Py"+d}this.objects[b]=e;e.id=b;this.renderer.drawPolygon(e);return b};JXG.Board.prototype.addArc=function(e){var d=this.numObjects;this.numObjects++;var b=e.id;if((b=="")||(b==null)){b=this.id+"Ac"+d}this.objects[b]=e;e.id=b;this.renderer.drawArc(e);return b};JXG.Board.prototype.addSector=function(e){var d=this.numObjects;this.numObjects++;var b=e.id;if((b=="")||(b==null)){b=this.id+"Sc"+d}this.objects[b]=e;e.id=b;return b};JXG.Board.prototype.addAngle=function(e){var d=this.numObjects;this.numObjects++;var b=e.id;if((b=="")||(b==null)){b=this.id+"Ag"+d}this.objects[b]=e;e.id=b;this.renderer.drawAngle(e);return b};JXG.Board.prototype.addCurve=function(e){var d=this.numObjects;this.numObjects++;var b=e.id;if((b=="")||(b==null)){b=this.id+"G"+d}this.objects[b]=e;e.id=b;this.renderer.drawCurve(e);return b};JXG.Board.prototype.addChart=function(e){var d=this.numObjects;this.numObjects++;var b=e.id;if((b=="")||(b==null)){b=this.id+"Chart"+d}this.objects[b]=e;e.id=b;return b};JXG.Board.prototype.addMidpoint=function(j,h,k,d){var f=JXG.GetReferenceFromParameter(this,j);var e=JXG.GetReferenceFromParameter(this,h);var b=this.algebra.midpoint(f,e).usrCoords.slice(1);var g=new JXG.Point(this,b,k,d,true);g.fixed=true;f.addChild(g);e.addChild(g);g.update=function(){if(this.needsUpdate){this.coords=this.board.algebra.midpoint(f,e);this.label.setCoordinates(this.coords);if(this.traced){this.cloneToBackground(true)}}};return g};JXG.Board.prototype.addReflection=function(f,e,k,h){var g=JXG.GetReferenceFromParameter(this,e);var d=JXG.GetReferenceFromParameter(this,f);var b=this.algebra.reflection(d,g).usrCoords.slice(1);var j=new JXG.Point(this,b,k,h,true);j.fixed=true;g.addChild(j);d.addChild(j);j.update=function(){if(this.needsUpdate){this.coords=this.board.algebra.reflection(d,g);this.label.setCoordinates(this.coords);if(this.traced){this.cloneToBackground(true)}}};return j};JXG.Board.prototype.addRotation=function(b,l,k,f,d){var g=JXG.GetReferenceFromParameter(this,l);var j=JXG.GetReferenceFromParameter(this,b);var h=this.algebra.rotation(j,g,k).usrCoords.slice(1);var e=new JXG.Point(this,h,f,d,true);e.fixed=true;g.addChild(e);j.addChild(e);e.update=function(){if(this.needsUpdate){this.coords=this.board.algebra.rotation(j,g,k);this.label.setCoordinates(this.coords);this.needsUpdate=false;if(this.traced){this.cloneToBackground(true)}}};return e};JXG.Board.prototype.addParallel=function(f,e,d,b){var m=JXG.GetReferenceFromParameter(this,e);var n=JXG.GetReferenceFromParameter(this,f);var g=this.numObjects;g++;if((d=="")||(d==null)){d=this.id+"L"+g}var j=this.algebra.parallel(n.point1,n.point2,m).usrCoords.slice(1);var k=new JXG.Point(this,j,d+"P2",b,false);k.fixed=true;m.addChild(k);var h=new JXG.Line(this,m.id,k.id,d,d);h.update=function(){if(this.needsUpdate){this.point2.coords=this.board.algebra.parallel(n.point1,n.point2,m);this.updateStdform();if(this.traced){this.cloneToBackground(true)}}};return h};JXG.Board.prototype.addArrowParallel=function(l,b,n,f,g,h){var o=JXG.GetReferenceFromParameter(this,b);var m=JXG.GetReferenceFromParameter(this,l);var d=this.numObjects;d++;if((n=="")||(n==null)){n=this.id+"A"+d}d++;if((f=="")||(f==null)){f=this.id+"P"+d}var j=this.algebra.parallel(m.point1,m.point2,o).usrCoords.slice(1);var k=new JXG.Point(this,j,f,h,true);k.fixed=true;o.addChild(k);m.addChild(k);var e=new JXG.Line(this,o.id,k.id,n,g);e.setStraight(false,false);e.setArrow(false,true);e.update=function(){if(this.needsUpdate){this.point2.coords=this.board.algebra.parallel(m.point1,m.point2,o);this.updateStdform();if(this.traced){this.cloneToBackground(true)}}};k.update=function(){if(this.needsUpdate){this.coords=this.board.algebra.parallel(m.point1,m.point2,o);if(this.label.show){this.label.setCoordinates(this.coords)}if(this.traced){this.cloneToBackground(true)}}};return[e,k]};JXG.Board.prototype.addParallelPoint=function(j,h,g,k,b){var f=this.numObjects;f++;if((k=="")||(k==null)){k=this.id+"P"+f}j=JXG.GetReferenceFromParameter(this,j);h=JXG.GetReferenceFromParameter(this,h);g=JXG.GetReferenceFromParameter(this,g);var e=this.algebra.parallel(j,h,g).usrCoords.slice(1);var d=new JXG.Point(this,e,k,b,true);d.fixed=true;j.addChild(d);g.addChild(d);if(j.type==JXG.OBJECT_TYPE_POINT){h.addChild(d)}d.update=function(){if(this.needsUpdate){this.coords=this.board.algebra.parallel(j,h,g);this.label.setCoordinates(this.coords);if(this.traced){this.cloneToBackground(true)}}};return d};JXG.Board.prototype.addArrow=function(e){var d=this.numObjects;this.numObjects++;var b=e.id;if((b=="")||(b==null)){b=this.id+"A"+d}this.objects[b]=e;e.id=b;this.renderer.drawArrow(e);return b};JXG.Board.prototype.addNormal=function(g,e,d,b){var n=JXG.GetReferenceFromParameter(this,e);var o=JXG.GetReferenceFromParameter(this,g);var h=this.numObjects;h++;if((d=="")||(d==null)){d=this.id+"L"+h}var m=this.algebra.perpendicular(o,n);var j=m[0].usrCoords.slice(1);var k=new JXG.Point(this,j,d+"P2","",false);k.fixed=true;n.addChild(k);o.addChild(k);var f;if(m[1]){f=new JXG.Line(this,k.id,n.id,d,b)}else{f=new JXG.Line(this,n.id,k.id,d,b)}f.changed=m[1];f.update=function(){if(this.needsUpdate){var p=this.board.algebra.perpendicular(o,n);k.coords=p[0];if(this.changed!=p[1]){var l=this.point1;this.point1=this.point2;this.point2=l}this.updateStdform();if(this.traced){this.cloneToBackground(true)}}};return f};JXG.Board.prototype.addPerpendicular=function(f,b,n,h,j,d){var q=JXG.GetReferenceFromParameter(this,b);var r=JXG.GetReferenceFromParameter(this,f);var g=this.numObjects;g++;if((n=="")||(n==null)){n=this.id+"L"+g}g++;if((j=="")||(j==null)){j=this.id+"P"+g}var o=this.algebra.perpendicular(r,q);var k=o[0].usrCoords.slice(1);var m=new JXG.Point(this,k,j,d,true);m.fixed=true;q.addChild(m);r.addChild(m);var e;if(o[1]){e=new JXG.Line(this,m.id,q.id,n,h)}else{e=new JXG.Line(this,q.id,m.id,n,h)}e.setStraight(false,false);e.changed=o[1];e.update=function(){if(this.needsUpdate){var p=this.board.algebra.perpendicular(r,q);m.coords=p[0];if(this.changed!=p[1]){var l=this.point1;this.point1=this.point2;this.point2=l}this.updateStdform();if(this.traced){this.cloneToBackground(true)}}};return[e,m]};JXG.Board.prototype.addPerpendicularPoint=function(e,b,g,d){var k=JXG.GetReferenceFromParameter(this,b);var m=JXG.GetReferenceFromParameter(this,e);var f=this.numObjects;f++;if((g=="")||(g==null)){g=this.id+"P"+f}var h=this.algebra.perpendicular(m,k)[0].usrCoords.slice(1);var j=new JXG.Point(this,h,g,d,true);j.fixed=true;k.addChild(j);m.addChild(j);j.update=function(){if(this.needsUpdate){this.coords=this.board.algebra.perpendicular(m,k)[0];this.label.setCoordinates(this.coords);if(this.traced){this.cloneToBackground(true)}}};return j};JXG.Board.prototype.addCircumcenter=function(k,g,f,h,j,e,b){var n=JXG.GetReferenceFromParameter(this,k);var m=JXG.GetReferenceFromParameter(this,g);var l=JXG.GetReferenceFromParameter(this,f);var d=this.algebra.circumcenterMidpoint(n,m,l);var p=new JXG.Point(this,d.usrCoords.slice(1),h,j,true);p.fixed=true;n.addChild(p);m.addChild(p);l.addChild(p);var o=new JXG.Circle(this,"pointRadius",p.id,function(){return this.midpoint.coords.distance(JXG.COORDS_BY_USER,n.coords)},e,b);n.addChild(o);m.addChild(o);l.addChild(o);p.update=function(){if(this.needsUpdate){this.coords=this.board.algebra.circumcenterMidpoint(n,m,l);if(this.label.show){this.label.setCoordinates(this.coords)}if(this.traced){this.cloneToBackground(true)}}};o.update=function(){if(this.needsUpdate){this.updateRadius();this.updateStdform();if(this.traced){this.cloneToBackground(true)}}};return[p,o]};JXG.Board.prototype.addCircumcenterMidpoint=function(h,e,d,f,g){var l=JXG.GetReferenceFromParameter(this,h);var k=JXG.GetReferenceFromParameter(this,e);var j=JXG.GetReferenceFromParameter(this,d);var b=this.algebra.circumcenterMidpoint(l,k,j).usrCoords.slice(1);var m=new JXG.Point(this,b,f,g,true);m.fixed=true;l.addChild(m);k.addChild(m);j.addChild(m);m.update=function(){if(this.needsUpdate){this.coords=this.board.algebra.circumcenterMidpoint(l,k,j);if(this.label.show){this.label.setCoordinates(this.coords)}if(this.traced){this.cloneToBackground(true)}}};return m};JXG.Board.prototype.addIntersection=function(e){var d=this.numObjects;this.numObjects++;var b=e.id;if((b=="")||(b==null)){b=this.id+"I"+d}this.objects[b]=e;e.id=b;e.intersect1.addChild(e);e.intersect2.addChild(e);return b};JXG.Board.prototype.addAngleBisector=function(o,n,m,d,b){var k=JXG.GetReferenceFromParameter(this,o);var h=JXG.GetReferenceFromParameter(this,n);var f=JXG.GetReferenceFromParameter(this,m);var e=this.numObjects;e++;if((d=="")||(d==null)){d=this.id+"L"+e}var j=this.algebra.angleBisector(k,h,f).usrCoords.slice(1);var l=new JXG.Point(this,j,d+"P2","",false);l.fixed=true;k.addChild(l);h.addChild(l);f.addChild(l);var g=new JXG.Line(this,n,l.id,d,b);g.setStraight(false,true);g.update=function(){if(this.needsUpdate){this.point2.coords=this.board.algebra.angleBisector(k,h,f);this.updateStdform();if(this.traced){this.cloneToBackground(true)}}};return g};JXG.Board.prototype.addText=function(e){var d=this.numObjects;this.numObjects++;var b=e.id;if((b=="")||(b==null)){b=this.id+"T"+d}this.objects[b]=e;e.id=b;this.renderer.drawText(e);return b};JXG.Board.prototype.addConditions=function(o){var n=null;var d="var el,x,y,c;\n";var l=o.indexOf("<data>");var k=o.indexOf("</data>");if(l<0){return}while(l>=0){var h=o.slice(l+6,k);var g=h.indexOf("=");var f=h.slice(0,g);var q=h.slice(g+1);g=f.indexOf(".");var b=f.slice(0,g);var e=this.elementsByName[JXG.unescapeHTML(b)];var p=f.slice(g+1).replace(/\s+/g,"").toLowerCase();q=this.algebra.geonext2JS(q);q=q.replace(/this\.board\./g,"this.");if(typeof this.elementsByName[b]=="undefined"){alert("debug conditions: |"+b+"| undefined")}d+='el = this.objects["'+e.id+'"];\n';switch(p){case"x":d+="y=el.coords.usrCoords[2];\n";d+="el.setPositionDirectly(JXG.COORDS_BY_USER,"+(q)+",y);\n";d+="el.update();\n";break;case"y":d+="x=el.coords.usrCoords[1];\n";d+="el.coords=new JXG.Coords(JXG.COORDS_BY_USER,[x,"+(q)+"],this);\n";break;case"visible":d+="c="+(q)+";\n";d+="if (c) {el.showElement();} else {el.hideElement();}\n";break;case"position":d+="el.position = "+(q)+";\n";d+="el.update();\n";break;case"stroke":d+="el.strokeColor = "+(q)+";\n";break;case"strokewidth":d+="el.strokeWidth = "+(q)+";\n";break;case"label":break;default:alert("property '"+p+"' in conditions not implemented:"+q);break}o=o.slice(k+7);l=o.indexOf("<data>");k=o.indexOf("</data>")}d+="this.prepareUpdate();\n";d+="this.updateElements();\n";d+="return true;\n";this.updateConditions=new Function(d);this.updateConditions()};JXG.Board.prototype.updateConditions=function(){return false};JXG.Board.prototype.addImage=function(e){var d=this.numObjects;this.numObjects++;var b=e.id;if((b=="")||(b==null)){b=this.id+"Im"+d}this.objects[b]=e;this.elementsByName[e.name]=e;e.id=b;this.renderer.drawImage(e);if(!e.visProp.visible){this.renderer.hide(e)}return b};JXG.Board.prototype.addIntegral=function(g,j,b,q,o){if(!JXG.IsArray(b)||(b.length!=5)){b=["","","","",""]}if(!JXG.IsArray(q)||(q.length!=5)){q=["","","","",""]}var u=[];var d={};if((typeof o!="undefined")&&(o!=null)){d=o}d.name=q[0];d.id=b[0];d.slideObject=j;var f=0;if(g[0]>j.points[0].usrCoords[1]){f=g[0]}else{f=j.points[0].usrCoords[1]}var r=board.createElement("point",[f,j.yterm(f)],d);d.name=q[1];d.id=b[1];d.visible=false;d.slideObject=null;var s=board.createElement("point",[function(){return r.X()},0],d);u.push(s);u.push(r);r.addChild(s);var l;for(var m=0;m<j.numberPoints;m++){if((g[0]<=j.points[m].usrCoords[1])&&(j.points[m].usrCoords[1]<=g[1])){l={type:JXG.OBJECT_TYPE_POINT,elementClass:JXG.OBJECT_CLASS_POINT,addChild:function(p){},coords:j.points[m]};u.push(l)}}d.name=q[2];d.id=b[2];d.slideObject=j;d.visible=true;var h=board.createElement("point",[u[u.length-1].coords.usrCoords[1],j.yterm(u[u.length-1].coords.usrCoords[1])],d);d.name=q[3];d.id=b[3];d.slideObject=null;d.visible=false;var k=board.createElement("point",[function(){return h.X()},0],d);u.push(h);u.push(k);h.addChild(k);var n=JXG.Math.Numerics.I([u[0].coords.usrCoords[1],u[u.length-1].coords.usrCoords[1]],j.yterm);var v=board.createElement("text",[function(){return h.X()+0.2},function(){return h.Y()-1},"&int; = "+(n).toFixed(4)]);var d={};if((typeof o!="undefined")&&(o!=null)){d=o}d.withLines=false;d.name=q[4];d.id=b[4];d.visible=true;var e=board.createElement("polygon",u,d);e.update=function(){var w;var y=[s,r];for(var p=0;p<j.numberPoints;p++){if((s.X()<=j.points[p].usrCoords[1])&&(j.points[p].usrCoords[1]<=k.X())){w={type:JXG.OBJECT_TYPE_POINT,elementClass:JXG.OBJECT_CLASS_POINT,addChild:function(z){},coords:j.points[p]};y.push(w)}}y.push(h);y.push(k);y.push(s);var x=JXG.Math.Numerics.I([u[0].coords.usrCoords[1],u[u.length-1].coords.usrCoords[1]],j.yterm);v.plaintextStr="&int; = "+(x).toFixed(4);this.vertices=y};r.addChild(e);h.addChild(e);r.addChild(v);h.addChild(v);return e};JXG.Board.prototype.calculateSnapSizes=function(){var e=new JXG.Coords(JXG.COORDS_BY_USER,[0,0],this);var d=new JXG.Coords(JXG.COORDS_BY_USER,[1/this.gridX,1/this.gridY],this);var b=e.scrCoords[1]-d.scrCoords[1];var f=e.scrCoords[2]-d.scrCoords[2];this.snapSizeX=this.gridX;while(Math.abs(b)>25){this.snapSizeX*=2;b/=2}this.snapSizeY=this.gridY;while(Math.abs(f)>25){this.snapSizeY*=2;f/=2}};JXG.Board.prototype.applyZoom=function(){this.updateQuality=this.BOARD_QUALITY_HIGH;for(var b in this.objects){if((this.objects[b].elementClass==JXG.OBJECT_CLASS_POINT)||(this.objects[b].type==JXG.OBJECT_TYPE_CURVE)||(this.objects[b].type==JXG.OBJECT_TYPE_AXIS)||(this.objects[b].type==JXG.OBJECT_TYPE_TEXT)){if((this.objects[b].type!=JXG.OBJECT_TYPE_CURVE)&&(this.objects[b].type!=JXG.OBJECT_TYPE_AXIS)){this.objects[b].coords.usr2screen()}}}this.calculateSnapSizes();this.clearTraces();this.fullUpdate=true;this.update();this.fullUpdate=false;if(this.hasGrid){this.renderer.removeGrid(this);this.renderer.drawGrid(this)}};JXG.Board.prototype.zoomIn=function(){this.zoomX*=this.options.zoom.factor;this.zoomY*=this.options.zoom.factor;this.applyZoom()};JXG.Board.prototype.zoomOut=function(){this.zoomX/=this.options.zoom.factor;this.zoomY/=this.options.zoom.factor;this.applyZoom()};JXG.Board.prototype.zoom100=function(){this.zoomX=1;this.zoomY=1;this.applyZoom()};JXG.Board.prototype.zoomAllPoints=function(){var n=this.zoomX/this.zoomY;var k=0;var f=0;var j=0;var d=0;for(var h in this.objects){if((this.objects[h].elementClass==JXG.OBJECT_CLASS_POINT)&&this.objects[h].visProp.visible){if(this.objects[h].coords.usrCoords[1]<k){k=this.objects[h].coords.usrCoords[1]}if(this.objects[h].coords.usrCoords[1]>f){f=this.objects[h].coords.usrCoords[1]}if(this.objects[h].coords.usrCoords[2]>d){d=this.objects[h].coords.usrCoords[2]}if(this.objects[h].coords.usrCoords[2]<j){j=this.objects[h].coords.usrCoords[2]}}}var l=50;var r=l/(this.unitX*this.zoomX);var q=l/(this.unitY*this.zoomY);var p=f-k+2*r;var o=d-j+2*q;var m=Math.min(this.canvasWidth/(this.unitX*p),this.canvasHeight/(this.unitY*o));var e=m;var g=m*n;var b=-(k-r)*this.unitX*g;var s=(d+q)*this.unitY*e;this.origin=new JXG.Coords(JXG.COORDS_BY_SCREEN,[b,s],this);this.zoomX=g;this.zoomY=e;this.applyZoom()};JXG.Board.prototype.removeObject=function(b){b=JXG.GetReferenceFromParameter(this,b);if(b==undefined){return}try{for(var g in b.childElements){b.childElements[g].board.removeObject(b.childElements[g])}for(var d in this.objects){if(typeof this.objects[d].childElements!="undefined"){delete (this.objects[d].childElements[b.id])}}delete (this.objects[b.id]);delete (this.elementsByName[b.name]);if(b.remove!=undefined){b.remove()}}catch(f){}};JXG.Board.prototype.initGeonextBoard=function(){var g=new JXG.Point(this,[0,0],this.id+"gOOe0","Ursprung",false);g.fixed=true;var f=new JXG.Point(this,[1,0],this.id+"gXOe0","Punkt_1_0",false);f.fixed=true;var e=new JXG.Point(this,[0,1],this.id+"gYOe0","Punkt_0_1",false);e.fixed=true;var d=new JXG.Line(this,this.id+"gOOe0",this.id+"gXOe0",this.id+"gXLe0","X-Achse");d.hideElement();var b=new JXG.Line(this,this.id+"gOOe0",this.id+"gYOe0",this.id+"gYLe0","Y-Achse");b.hideElement();this.infobox=new JXG.Label(this,"0,0",new JXG.Coords(JXG.COORDS_BY_USER,[0,0],this),this.id+"__infobox");this.infobox.distanceX=-20;this.infobox.distanceY=25;this.renderer.drawLabel(this.infobox);this.renderer.hide(this.infobox)};JXG.Board.prototype.resizeContainer=function(b,d){this.canvasWidth=1*b;this.canvasHeight=1*d;this.containerObj.style.width=(this.canvasWidth)+"px";this.containerObj.style.height=(this.canvasHeight)+"px"};JXG.Board.prototype.showDependencies=function(){var e;var d="<p>\n";for(e in this.objects){var b=0;for(var h in this.objects[e].childElements){b++}if(b>=0){d+="<b>"+this.objects[e].id+":</b> "}for(var h in this.objects[e].childElements){d+=this.objects[e].childElements[h].id+"("+this.objects[e].childElements[h].name+"), "}d+="<p>\n"}d+="</p>\n";var g=window.open();g.document.open();g.document.write(d);g.document.close()};JXG.Board.prototype.showXML=function(){var b=window.open("");b.document.open();b.document.write("<pre>"+JXG.escapeHTML(this.xmlString)+"</pre>");b.document.close()};JXG.Board.prototype.prepareUpdate=function(d){for(var b in this.objects){this.objects[b].needsUpdate=true}};JXG.Board.prototype.updateElements=function(d){d=JXG.GetReferenceFromParameter(this,d);var e=-1;if(!this.reducedUpdate){e=1}for(var b in this.objects){var f=this.objects[b];if(!this.fullUpdate&&!f.needsRegularUpdate&&f.afterFirstUpdate){continue}if(d==null||f.id!=d.id){if(e>=0||!f.afterFirstUpdate||this.fullUpdate){f.update(true)}}else{f.update(false);e=5}if(this.reducedUpdate){e--}}};JXG.Board.prototype.updateRenderer=function(d){var d=JXG.GetReferenceFromParameter(this,d);var e=-1;if(!this.reducedUpdate){e=1}for(var b in this.objects){var f=this.objects[b];if(!this.fullUpdate&&!f.needsRegularUpdate&&f.afterFirstUpdate){continue}if(d==null||f.id!=d.id){if(e>=0||!f.afterFirstUpdate||this.fullUpdate){f.updateRenderer()}}else{f.updateRenderer();e=5}if(this.reducedUpdate){e--}f.afterFirstUpdate=true}};JXG.Board.prototype.addHook=function(b){this.hooks.push(b);b(this);return(this.hooks.length-1)};JXG.Board.prototype.removeHook=function(b){this.hooks[b]=null};JXG.Board.prototype.updateHooks=function(){for(var b=0;b<this.hooks.length;b++){if(this.hooks[b]!=null){this.hooks[b](this)}}};JXG.Board.prototype.update=function(b){if(this.isSuspendedUpdate){return}this.prepareUpdate(b);this.updateElements(b);this.updateConditions();this.renderer.suspendRedraw();this.updateRenderer(b);this.renderer.unsuspendRedraw();this.updateHooks();for(var d in JXG.JSXGraph.boards){if(JXG.JSXGraph.boards[d]!=this){JXG.JSXGraph.boards[d].prepareUpdate(b);JXG.JSXGraph.boards[d].updateElements(b);JXG.JSXGraph.boards[d].updateConditions();JXG.JSXGraph.boards[d].renderer.suspendRedraw();JXG.JSXGraph.boards[d].updateRenderer(b);JXG.JSXGraph.boards[d].renderer.unsuspendRedraw();JXG.JSXGraph.boards[d].updateHooks()}}};JXG.Board.prototype.createElement=function(d,e,b){if(d!="turtle"&&(e==null||e.length==0)){return null}if(e==null){e=[]}var h;d=d.toLowerCase();if(b==null){b={}}for(var f=0;f<e.length;f++){e[f]=JXG.GetReferenceFromParameter(this,e[f])}if(JXG.JSXGraph.elements[d]!=null){h=JXG.JSXGraph.elements[d](this,e,b)}else{throw"JXG.createElement: Unknown element type given: "+d}if(h==undefined){return}if(JXG.IsArray(b)){b=b[0]}if(h.multipleElements){for(var g in h){if(typeof h[g].setProperty!="undefined"){h[g].setProperty(b)}}}else{if(typeof h.setProperty!="undefined"){h.setProperty(b)}}this.update();return h};JXG.Board.prototype.clearTraces=function(){for(var b in this.objects){if(this.objects[b].traced){this.objects[b].clearTrace()}}};JXG.Board.prototype.beforeLoad=function(){};JXG.Board.prototype.afterLoad=function(){};JXG.Board.prototype.suspendUpdate=function(){this.isSuspendedUpdate=true};JXG.Board.prototype.unsuspendUpdate=function(){this.isSuspendedUpdate=false;this.update()};JXG.Options=function(){this.fontSize=12;this.grid=new Object();this.grid.hasGrid=false;this.grid.gridX=2;this.grid.gridY=2;this.grid.gridColor="#C0C0C0";this.grid.gridOpacity="0.5";this.grid.gridDash=true;this.grid.snapToGrid=false;this.grid.snapSizeX=2;this.grid.snapSizeY=2;this.zoom=new Object();this.zoom.factor=1.25;this.elements=new Object();this.elements.color=new Object();this.elements.color.strokeOpacity=1;this.elements.color.highlightStrokeOpacity=1;this.elements.color.fillOpacity=1;this.elements.color.highlightFillOpacity=1;this.elements.color.strokeColor="#0000ff";this.elements.color.highlightStrokeColor="#C3D9FF";this.elements.color.fillColor="none";this.elements.color.highlightFillColor="none";this.elements.strokeWidth="2px";this.elements.draft=new Object();this.elements.draft.draft=false;this.elements.draft.color="#565656";this.elements.draft.opacity=0.8;this.elements.draft.strokeWidth="1px";this.point=new Object();this.point.style=5;this.point.fillColor="#ff0000";this.point.highlightFillColor="#EEEEEE";this.point.strokeColor=this.elements.color.strokeColor;this.point.highlightStrokeColor=this.elements.color.highlightStrokeColor;this.line=new Object();this.line.firstArrow=false;this.line.lastArrow=false;this.line.straightFirst=true;this.line.straightLast=true;this.line.fillColor=this.elements.color.fillColor;this.line.highlightFillColor=this.elements.color.highlightFillColor;this.line.strokeColor=this.elements.color.strokeColor;this.line.highlightStrokeColor=this.elements.color.highlightStrokeColor;this.line.ticks=new Object();this.line.ticks.drawLabels=true;this.line.ticks.drawZero=false;this.line.ticks.insertTicks=false;this.line.ticks.minTicksDistance=100;this.line.ticks.maxTicksDistance=300;this.line.ticks.minorHeight=4;this.line.ticks.majorHeight=10;this.line.ticks.minorTicks=4;this.line.ticks.defaultDistance=5;this.circle=new Object();this.circle.fillColor=this.elements.color.fillColor;this.circle.highlightFillColor=this.elements.color.highlightFillColor;this.circle.strokeColor=this.elements.color.strokeColor;this.circle.highlightStrokeColor=this.elements.color.highlightStrokeColor;this.angle=new Object();this.angle.radius=1;this.angle.fillColor="#FF7F00";this.angle.highlightFillColor="#FF7F00";this.angle.strokeColor="#FF7F00";this.angle.fillOpacity=0.3;this.angle.highlightFillOpacity=0.3;this.arc=new Object();this.arc.firstArrow=false;this.arc.lastArrow=false;this.arc.fillColor=this.elements.color.fillColor;this.arc.highlightFillColor=this.elements.color.highlightFillColor;this.arc.strokeColor=this.elements.color.strokeColor;this.arc.highlightStrokeColor=this.elements.color.highlightStrokeColor;this.polygon=new Object();this.polygon.fillColor="#00FF00";this.polygon.highlightFillColor="#00FF00";this.polygon.fillOpacity=0.3;this.polygon.highlightFillOpacity=0.3;this.sector=new Object();this.sector.fillColor="#00FF00";this.sector.highlightFillColor="#00FF00";this.sector.fillOpacity=0.3;this.sector.highlightFillOpacity=0.3;this.text=new Object();this.text.strokeColor="#000000";this.curve=new Object();this.curve.strokeWidth="1px";this.curve.strokeColor=this.elements.color.strokeColor;this.precision=new Object();this.precision.hasPoint=4;this.precision.epsilon=0.0001};JXG.Options.prototype.useStandardOptions=function(f){var e=f.hasGrid;f.hasGrid=this.grid.hasGrid;f.gridX=this.grid.gridX;f.gridY=this.grid.gridY;f.gridColor=this.grid.gridColor;f.gridOpacity=this.grid.gridOpacity;f.gridDash=this.grid.gridDash;f.snapToGrid=this.grid.snapToGrid;f.snapSizeX=this.grid.SnapSizeX;f.snapSizeY=this.grid.SnapSizeY;for(var d in f.objects){if(f.objects[d].type==JXG.OBJECT_TYPE_POINT){f.objects[d].visProp.fillColor=this.point.fillColor;f.objects[d].visProp.highlightFillColor=this.point.highlightFillColor;f.objects[d].visProp.strokeColor=this.point.strokeColor;f.objects[d].visProp.highlightStrokeColor=this.point.highlightStrokeColor}else{if(f.objects[d].type==JXG.OBJECT_TYPE_LINE){f.objects[d].visProp.fillColor=this.line.fillColor;f.objects[d].visProp.highlightFillColor=this.line.highlightFillColor;f.objects[d].visProp.strokeColor=this.line.strokeColor;f.objects[d].visProp.highlightStrokeColor=this.line.highlightStrokeColor;for(var b in f.objects[d].ticks){b.majorTicks=this.line.ticks.majorTicks;b.minTicksDistance=this.line.ticks.minTicksDistance;b.minorHeight=this.line.ticks.minorHeight;b.majorHeight=this.line.ticks.majorHeight}}else{if(f.objects[d].type==JXG.OBJECT_TYPE_CIRCLE){f.objects[d].visProp.fillColor=this.circle.fillColor;f.objects[d].visProp.highlightFillColor=this.circle.highlightFillColor;f.objects[d].visProp.strokeColor=this.circle.strokeColor;f.objects[d].visProp.highlightStrokeColor=this.circle.highlightStrokeColor}else{if(f.objects[d].type==JXG.OBJECT_TYPE_ANGLE){f.objects[d].visProp.fillColor=this.angle.fillColor;f.objects[d].visProp.highlightFillColor=this.angle.highlightFillColor;f.objects[d].visProp.strokeColor=this.angle.strokeColor}else{if(f.objects[d].type==JXG.OBJECT_TYPE_ARC){f.objects[d].visProp.fillColor=this.arc.fillColor;f.objects[d].visProp.highlightFillColor=this.arc.highlightFillColor;f.objects[d].visProp.strokeColor=this.arc.strokeColor;f.objects[d].visProp.highlightStrokeColor=this.arc.highlightStrokeColor}else{if(f.objects[d].type==JXG.OBJECT_TYPE_POLYGON){f.objects[d].visProp.fillColor=this.polygon.fillColor;f.objects[d].visProp.highlightFillColor=this.polygon.highlightFillColor;f.objects[d].visProp.fillOpacity=this.polygon.fillOpacity;f.objects[d].visProp.highlightFillOpacity=this.polygon.highlightFillOpacity}else{if(f.objects[d].type==JXG.OBJECT_TYPE_CURVE){f.objects[d].visProp.strokeColor=this.curve.strokeColor}}}}}}}}for(var d in f.objects){if(f.objects[d].type==JXG.OBJECT_TYPE_SECTOR){f.objects[d].arc.visProp.fillColor=this.sector.fillColor;f.objects[d].arc.visProp.highlightFillColor=this.sector.highlightFillColor;f.objects[d].arc.visProp.fillOpacity=this.sector.fillOpacity;f.objects[d].arc.visProp.highlightFillOpacity=this.sector.highlightFillOpacity}}f.fullUpdate=true;f.update();f.fullUpdate=false;if(e&&f.hasGrid){f.renderer.removeGrid(f);f.renderer.drawGrid(f)}else{if(e&&!f.hasGrid){f.renderer.removeGrid(f)}else{if(!e&&f.hasGrid){f.renderer.drawGrid(f)}}}};JXG.Options.prototype.useBlackWhiteOptions=function(b){this.point.fillColor=this.changeColorToBlackWhite(this.point.fillColor);this.point.highlightFillColor=this.changeColorToBlackWhite(this.point.highlightFillColor);this.point.strokeColor=this.changeColorToBlackWhite(this.point.strokeColor);this.point.highlightStrokeColor=this.changeColorToBlackWhite(this.point.highlightStrokeColor);this.line.fillColor=this.changeColorToBlackWhite(this.line.fillColor);this.line.highlightFillColor=this.changeColorToBlackWhite(this.line.highlightFillColor);this.line.strokeColor=this.changeColorToBlackWhite(this.line.strokeColor);this.line.highlightStrokeColor=this.changeColorToBlackWhite(this.line.highlightStrokeColor);this.circle.fillColor=this.changeColorToBlackWhite(this.circle.fillColor);this.circle.highlightFillColor=this.changeColorToBlackWhite(this.circle.highlightFillColor);this.circle.strokeColor=this.changeColorToBlackWhite(this.circle.strokeColor);this.circle.highlightStrokeColor=this.changeColorToBlackWhite(this.circle.highlightStrokeColor);this.arc.fillColor=this.changeColorToBlackWhite(this.arc.fillColor);this.arc.highlightFillColor=this.changeColorToBlackWhite(this.arc.highlightFillColor);this.arc.strokeColor=this.changeColorToBlackWhite(this.arc.strokeColor);this.arc.highlightStrokeColor=this.changeColorToBlackWhite(this.arc.highlightStrokeColor);this.polygon.fillColor=this.changeColorToBlackWhite(this.polygon.fillColor);this.polygon.highlightFillColor=this.changeColorToBlackWhite(this.polygon.highlightFillColor);this.sector.fillColor=this.changeColorToBlackWhite(this.sector.fillColor);this.sector.highlightFillColor=this.changeColorToBlackWhite(this.sector.highlightFillColor);this.curve.strokeColor=this.changeColorToBlackWhite(this.curve.strokeColor);this.grid.gridColor=this.changeColorToBlackWhite(this.grid.gridColor);this.useStandardOptions(b)};JXG.Options.prototype.changeColorToBlackWhite=function(f){if(f=="none"){return f}var h=new JXG.RGBColor(f);var l=h.r;var k=h.g;var e=h.b;var d=0.3*l+0.59*k+0.11*e;var m="0123456789ABCDEF";var j=m.charAt((d>>4)&15)+m.charAt(d&15);f="#"+j+""+j+""+j;return f};JXG.Options.prototype.loadFromFile=function(d,e,b){this.cbp=function(f){this.parseString(f,e,b)};this.cb=JXG.bind(this.cbp,this);JXG.FileReader.parseFileContent(d,this.cb,"raw")};JXG.Options.prototype.parseString=function(text,applyTo,board){var newOptions="";if(text!=""){newOptions=eval("("+text+")")}else{return}var maxDepth=10;var applyOption=function(base,option,depth){if(depth==10){return}depth++;for(var key in option){if((JXG.IsNumber(option[key]))||(JXG.IsArray(option[key]))||(JXG.IsString(option[key]))||(option[key]==true)||(option[key]==false)){base[key]=option[key]}else{applyOption(base[key],option[key],depth)}}};applyOption(this,newOptions,0);if(applyTo&&typeof board!="undefined"){this.useStandardOptions(board)}};JXG.Board.prototype.angle=function(b,e,d){return this.algebra.angle(b,e,d)};JXG.Board.prototype.rad=function(b,e,d){return this.algebra.rad(b,e,d)};JXG.Board.prototype.distance=function(d,b){return this.algebra.distance(d,b)};JXG.Board.prototype.pow=function(e,d){return this.algebra.pow(e,d)};JXG.Board.prototype.round=function(b,d){return(b).toFixed(d)};JXG.Board.prototype.cosh=function(b){return JXG.Math.Numerics.cosh(b)};JXG.Board.prototype.sinh=function(b){return JXG.Math.Numerics.sinh(b)};JXG.Board.prototype.sgn=function(b){return(b==0?0:b/(Math.abs(b)))};JXG.Board.prototype.D=function(b,d){return JXG.Math.Numerics.D(b,d)};JXG.Board.prototype.I=function(b,d){return JXG.Math.Numerics.I(b,d)};JXG.Board.prototype.root=function(d,b,e){return JXG.Math.Numerics.root(d,b,e)};JXG.Board.prototype.lagrangePolynomial=function(b){return JXG.Math.Numerics.lagrangePolynomial(b)};JXG.Board.prototype.neville=function(b){return JXG.Math.Numerics.neville(b)};JXG.Board.prototype.riemannsum=function(e,h,d,g,b){return JXG.Math.Numerics.riemannsum(e,h,d,g,b)};JXG.Board.prototype.abs=Math.abs;JXG.Board.prototype.acos=Math.acos;JXG.Board.prototype.asin=Math.asin;JXG.Board.prototype.atan=Math.atan;JXG.Board.prototype.ceil=Math.ceil;JXG.Board.prototype.cos=Math.cos;JXG.Board.prototype.exp=Math.exp;JXG.Board.prototype.floor=Math.floor;JXG.Board.prototype.log=Math.log;JXG.Board.prototype.max=Math.max;JXG.Board.prototype.min=Math.min;JXG.Board.prototype.random=Math.random;JXG.Board.prototype.sin=Math.sin;JXG.Board.prototype.sqrt=Math.sqrt;JXG.Board.prototype.tan=Math.tan;JXG.Board.prototype.trunc=Math.ceil;JXG.Board.prototype.factorial=function(b){return JXG.Math.factorial(b)};JXG.Board.prototype.binomial=function(d,b){return JXG.Math.binomial(d,b)};JXG.Point.prototype.setPositionX=function(e,b){var d=(e==JXG.COORDS_BY_USER)?this.coords.usrCoords[2]:this.coords.scrCoords[2];this.setPosition(e,b,d)};JXG.Point.prototype.setPositionY=function(e,d){var b=(e==JXG.COORDS_BY_USER)?this.coords.usrCoords[1]:this.coords.scrCoords[1];this.setPosition(e,b,d)};JXG.Board.prototype.getElement=function(b){return JXG.GetReferenceFromParameter(this,b)};JXG.Board.prototype.intersectionOptions=["point",[[JXG.OBJECT_CLASS_LINE,JXG.OBJECT_CLASS_LINE],[JXG.OBJECT_CLASS_LINE,JXG.OBJECT_CLASS_CIRCLE],[JXG.OBJECT_CLASS_CIRCLE,JXG.OBJECT_CLASS_CIRCLE]]];JXG.Board.prototype.intersection=function(f,d,e,b){f=JXG.GetReferenceFromParameter(this,f);d=JXG.GetReferenceFromParameter(this,d);if(f.elementClass==JXG.OBJECT_CLASS_CURVE||d.elementClass==JXG.OBJECT_CLASS_CURVE){return function(){return f.board.algebra.meetCurveCurve(f,d,e,b)}}else{return function(){return f.board.algebra.meet(f.stdform,d.stdform,e)}}};JXG.Board.prototype.intersectionFunc=function(f,d,e,b){return this.intersection(f,d,e,b)};JXG.Board.prototype.pointFunc=function(){return[null]};JXG.Board.prototype.pointOptions=["point",[[JXG.OBJECT_CLASS_POINT]]];JXG.Board.prototype.lineFunc=function(){return arguments};JXG.Board.prototype.lineOptions=["line",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT]]];JXG.Board.prototype.linesegmentFunc=function(){return arguments};JXG.Board.prototype.linesegmentOptions=["line",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT]]];JXG.Board.prototype.linesegmentAtts={straightFirst:false,straightLast:false};JXG.Board.prototype.arrowFunc=function(){return arguments};JXG.Board.prototype.arrowOptions=["arrow",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT]]];JXG.Board.prototype.circleFunc=function(){return arguments};JXG.Board.prototype.circleOptions=["circle",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT],[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_LINE],[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_CIRCLE]]];JXG.Board.prototype.arrowparallelOptions=["arrowparallel",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_LINE]]];JXG.Board.prototype.arrowparallelFunc=function(){return arguments};JXG.Board.prototype.bisectorOptions=["bisector",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT]]];JXG.Board.prototype.bisectorFunc=function(){return arguments};JXG.Board.prototype.circumcircleOptions=["circumcircle",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT]]];JXG.Board.prototype.circumcircleFunc=function(){return arguments};JXG.Board.prototype.circumcirclemidpointOptions=["circumcirclemidpoint",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT]]];JXG.Board.prototype.circumcirclemidpointFunc=function(){return arguments};JXG.Board.prototype.integralOptions=["integral",[[]]];JXG.Board.prototype.integralFunc=function(){return arguments};JXG.Board.prototype.midpointOptions=["midpoint",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT],[JXG.OBJECT_CLASS_LINE]]];JXG.Board.prototype.midpointFunc=function(){return arguments};JXG.Board.prototype.mirrorpointOptions=["mirrorpoint",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT]]];JXG.Board.prototype.mirrorpointFunc=function(){return arguments};JXG.Board.prototype.normalOptions=["normal",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_LINE]]];JXG.Board.prototype.normalFunc=function(){return arguments};JXG.Board.prototype.parallelOptions=["parallel",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_LINE]]];JXG.Board.prototype.parallelFunc=function(){return arguments};JXG.Board.prototype.parallelpointOptions=["parallelpoint",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_POINT]]];JXG.Board.prototype.parallelpointFunc=function(){return arguments};JXG.Board.prototype.perpendicularOptions=["perpendicular",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_LINE]]];JXG.Board.prototype.perpendicularFunc=function(){return arguments};JXG.Board.prototype.perpendicularpointOptions=["perpendicularpoint",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_LINE]]];JXG.Board.prototype.perpendicularpointFunc=function(){return arguments};JXG.Board.prototype.reflectionOptions=["reflection",[[JXG.OBJECT_CLASS_POINT,JXG.OBJECT_CLASS_LINE]]];JXG.Board.prototype.reflectionFunc=function(){return arguments};JXG.Ticks=function(b,g,f,h,d,j,e){this.constructor();this.type=JXG.OBJECT_TYPE_TICKS;this.elementClass=JXG.OBJECT_CLASS_LINE;this.line=b;this.board=this.line.board;this.ticksFunction=null;this.fixedTicks=null;this.equidistant=false;if(JXG.IsFunction(g)){this.ticksFunction=g}else{if(JXG.IsArray(g)){this.fixedTicks=g}else{if(Math.abs(g)<JXG.Math.eps){g=this.board.options.line.ticks.defaultDistance}this.ticksFunction=function(k){return g};this.equidistant=true}}this.minorTicks=((f==null)||(f==0)?this.board.options.line.ticks.minorTicks:f);if(this.minorTicks<0){this.minorTicks=-this.minorTicks}this.majorHeight=((h==null)||(h==0)?this.board.options.line.ticks.majorHeight:h);if(this.majorHeight<0){this.majorHeight=-this.majorHeight}this.minorHeight=((d==null)||(d==0)?this.board.options.line.ticks.minorHeight:d);if(this.minorHeight<0){this.minorHeight=-this.minorHeight}this.minTicksDistance=this.board.options.line.ticks.minTicksDistance;this.maxTicksDistance=this.board.options.line.ticks.maxTicksDistance;this.insertTicks=this.board.options.line.ticks.insertTicks;this.drawZero=this.board.options.line.ticks.drawZero;this.drawLabels=this.board.options.line.ticks.drawLabels;this.init(this.board,j,e);this.visProp.visible=true;this.visProp.fillColor=this.line.visProp.fillColor;this.visProp.highlightFillColor=this.line.visProp.highlightFillColor;this.visProp.strokeColor=this.line.visProp.strokeColor;this.visProp.highlightStrokeColor=this.line.visProp.highlightStrokeColor;this.visProp.strokeWidth=this.line.visProp.strokeWidth;this.id=this.line.addTicks(this)};JXG.Ticks.prototype=new JXG.GeometryElement;JXG.Ticks.prototype.hasPoint=function(b,d){return false};JXG.Ticks.prototype.makeTicks=function(h,e,G,D){var w=h.usrCoords[1]-e.usrCoords[1];var u=h.usrCoords[2]-e.usrCoords[2];var F=0;var j=Math.sqrt(w*w+u*u);if(j<=JXG.Math.eps){return}var s=h.usrCoords[1];var r=h.usrCoords[2];var E=G/Math.abs(G);F=Math.abs(this.ticksFunction(E));var I=(F*w)/(j);var H=(F*u)/(j);var B=0;if(this.equidistant){var d=I;var A=H;var b=F;var v=new JXG.Coords(JXG.COORDS_BY_USER,[0,0],this.board);var C=new JXG.Coords(JXG.COORDS_BY_USER,[I,H],this.board);B=(C.scrCoords[1]-v.scrCoords[1])*(C.scrCoords[1]-v.scrCoords[1])+(C.scrCoords[2]-v.scrCoords[2])*(C.scrCoords[2]-v.scrCoords[2]);while(B<this.minTicksDistance*this.minTicksDistance){I+=d;H+=A;F+=b;C=new JXG.Coords(JXG.COORDS_BY_USER,[I,H],this.board);B=(C.scrCoords[1]-v.scrCoords[1])*(C.scrCoords[1]-v.scrCoords[1])+(C.scrCoords[2]-v.scrCoords[2])*(C.scrCoords[2]-v.scrCoords[2])}}var J=G*F;var p=new JXG.Coords(JXG.COORDS_BY_USER,[s,r],this.board);var g=null;var f=null;var n="";var o=null;var m=true;var l=s;var k=r;while(m||(((this.board.sgn(I)*(s-D*I)>=this.board.sgn(I)*e.usrCoords[1])&&(this.board.sgn(H)*(r-D*H)>=this.board.sgn(H)*e.usrCoords[2])))){m=false;s=s-I;r=r-H;g=new JXG.Coords(JXG.COORDS_BY_USER,[s,r],this.board);if(!this.equidistant){B=(p.scrCoords[1]-g.scrCoords[1])*(p.scrCoords[1]-g.scrCoords[1])+(p.scrCoords[2]-g.scrCoords[2])*(p.scrCoords[2]-g.scrCoords[2])}if(this.insertTicks&&this.equidistant&&(B>this.maxTicksDistance*this.maxTicksDistance)){while(B>this.maxTicksDistance*this.maxTicksDistance){I=I/2;H=H/2;s=s+I;r=r+H;F=F/2;J=J-G*F;g=new JXG.Coords(JXG.COORDS_BY_USER,[s,r],this.board);B=(p.scrCoords[1]-g.scrCoords[1])*(p.scrCoords[1]-g.scrCoords[1])+(p.scrCoords[2]-g.scrCoords[2])*(p.scrCoords[2]-g.scrCoords[2])}}if(this.equidistant){for(var q=1;q<this.minorTicks+1;q++){f=new JXG.Coords(JXG.COORDS_BY_USER,[l-(I*q)/(this.minorTicks+1),k-(H*q)/(this.minorTicks+1)],this.board);f.major=false;this.ticks.push(f);this.labels.push(null)}}if(this.equidistant||(B>this.minTicksDistance*this.minTicksDistance)){g.major=true;this.ticks.push(g);n=J.toString();if(n.length>5){n=J.toPrecision(3).toString()}o=new JXG.Label(this.board,n,g,this.id+E+"Label");o.distanceX=0;o.distanceY=-10;o.setCoordinates(g);if(this.drawLabels){o.show=true}else{o.show=false}this.labels.push(o);l=s;k=r;p=g}E=E+G*1;if(!this.equidistant){F=Math.abs(this.ticksFunction(E))}J=J+G*F;if(!this.equidistant){I=(F*w)/(j);H=(F*u)/(j)}}};JXG.Ticks.prototype.calculateTicksCoordinates=function(){var y=1;var r=2;var s=y+r;var z=new JXG.Coords(JXG.COORDS_BY_USER,[this.line.point1.coords.usrCoords[1],this.line.point1.coords.usrCoords[2]],this.board);var x=new JXG.Coords(JXG.COORDS_BY_USER,[this.line.point2.coords.usrCoords[1],this.line.point2.coords.usrCoords[2]],this.board);this.board.renderer.calcStraight(this.line,z,x);var d=this.line.point1.coords;if(this.board.renderer.isSameDirection(d,z,x)){if(this.board.renderer.isSameDirection(d,this.line.point2.coords,z)){s=r;if(d.distance(JXG.COORDS_BY_USER,z)>d.distance(JXG.COORDS_BY_USER,x)){x=z}}else{s=y;if(d.distance(JXG.COORDS_BY_USER,z)<d.distance(JXG.COORDS_BY_USER,x)){z=x}}}else{if(this.board.renderer.isSameDirection(d,this.line.point2.coords,z)){var h=z;z=x;x=h}}if(this.ticks!=null){for(var B=0;B<this.ticks.length;B++){if(this.labels[B]!=null){if(this.labels[B].show){this.board.renderer.remove(this.labels[B].rendNode)}}}}this.ticks=new Array();this.labels=new Array();var n=null;var l="";var g=null;if(this.ticksFunction!=null){if(this.drawZero){g=new JXG.Coords(JXG.COORDS_BY_USER,[d.usrCoords[1],d.usrCoords[2]],this.board);this.ticks.push(g);n=new JXG.Label(this.board,"0",g,this.id+"0Label");if(this.drawLabels){n.show=true}else{n.show=false}this.labels.push(n);this.ticks[0].major=true}if(y==(s&y)){if(this.line.visProp.straightFirst){this.makeTicks(d,z,-1,0)}}if(r==(s&r)){if(this.line.visProp.straightLast){this.makeTicks(d,x,+1,0)}else{this.makeTicks(d,this.line.point2.coords,+1,1)}}}else{if(!this.line.visProp.straightFirst){z=d}var o=d.usrCoords[1]-z.usrCoords[1];var m=d.usrCoords[2]-z.usrCoords[2];var G=Math.sqrt(o*o+m*m);if(!this.line.visProp.straightLast){x=this.line.point2.coords}var k=d.usrCoords[1]-x.usrCoords[1];var p=d.usrCoords[2]-x.usrCoords[2];var e=Math.sqrt(k*k+p*p);var E=0;var D=0;for(var C=0;C<this.fixedTicks.length;C++){if((-G<=this.fixedTicks[C])&&(this.fixedTicks[C]<=e)){if(this.fixedTicks[C]<0){E=Math.abs(o)*this.fixedTicks[C]/G;D=Math.abs(m)*this.fixedTicks[C]/G}else{E=Math.abs(k)*this.fixedTicks[C]/e;D=Math.abs(p)*this.fixedTicks[C]/e}g=new JXG.Coords(JXG.COORDS_BY_USER,[d.usrCoords[1]+E,d.usrCoords[2]+D],this.board);this.ticks.push(g);this.ticks[this.ticks.length-1].major=true;l=this.fixedTicks[C].toString();if(l.length>5){l=this.fixedTicks[C].toFixed(3).toString()}n=new JXG.Label(this.board,l,g,this.id+C+"Label");n.distanceX=0;n.distanceY=-10;n.setCoordinates(g);if(this.drawLabels){n.show=true}else{n.show=false}this.labels.push(n)}}}var v=JXG.Math.eps;var q=-this.line.getSlope();var u=this.majorHeight/2;var f=this.minorHeight/2;var F=0;var b=0;var w=0;var A=0;if(Math.abs(q)<v){F=0;b=u;w=0;A=f}else{if((Math.abs(q)>1/v)||(isNaN(q))){F=u;b=0;w=f;A=0}else{F=u/Math.sqrt(1/(q*q)+1);b=-F/q;w=f/Math.sqrt(1/(q*q)+1);A=-w/q}}this.board.renderer.updateTicks(this,F,b,w,A)};JXG.Ticks.prototype.updateRenderer=function(){if(this.needsUpdate){this.calculateTicksCoordinates();this.needsUpdate=false}};JXG.createTicks=function(f,d,b){var e;if((d[0].elementClass==JXG.OBJECT_CLASS_LINE)&&(JXG.IsFunction(d[1])||JXG.IsArray(d[1])||JXG.IsNumber(d[1]))){e=new JXG.Ticks(d[0],d[1],b.minorTicks,b.majHeight,b.minHeight,b.id,b.name)}else{throw ("Can't create Ticks with parent types '"+(typeof d[0])+"' and '"+(typeof d[1])+"' and '"+(typeof d[2])+"'.")}return e};JXG.JSXGraph.registerElement("ticks",JXG.createTicks);JXG.Util=new Object();JXG.Util.Unzip=function(S){var p=[];var G="";var E=false;var B;var H=0;var P=[];var W=[0,128,64,192,32,160,96,224,16,144,80,208,48,176,112,240,8,136,72,200,40,168,104,232,24,152,88,216,56,184,120,248,4,132,68,196,36,164,100,228,20,148,84,212,52,180,116,244,12,140,76,204,44,172,108,236,28,156,92,220,60,188,124,252,2,130,66,194,34,162,98,226,18,146,82,210,50,178,114,242,10,138,74,202,42,170,106,234,26,154,90,218,58,186,122,250,6,134,70,198,38,166,102,230,22,150,86,214,54,182,118,246,14,142,78,206,46,174,110,238,30,158,94,222,62,190,126,254,1,129,65,193,33,161,97,225,17,145,81,209,49,177,113,241,9,137,73,201,41,169,105,233,25,153,89,217,57,185,121,249,5,133,69,197,37,165,101,229,21,149,85,213,53,181,117,245,13,141,77,205,45,173,109,237,29,157,93,221,61,189,125,253,3,131,67,195,35,163,99,227,19,147,83,211,51,179,115,243,11,139,75,203,43,171,107,235,27,155,91,219,59,187,123,251,7,135,71,199,39,167,103,231,23,151,87,215,55,183,119,247,15,143,79,207,47,175,111,239,31,159,95,223,63,191,127,255];var aa=[3,4,5,6,7,8,9,10,11,13,15,17,19,23,27,31,35,43,51,59,67,83,99,115,131,163,195,227,258,0,0];var R=[0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0,99,99];var L=[1,2,3,4,5,7,9,13,17,25,33,49,65,97,129,193,257,385,513,769,1025,1537,2049,3073,4097,6145,8193,12289,16385,24577];var A=[0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13];var q=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15];var w=S;var d=0;var j=0;var ab=1;var b=0;var Z=256;var h=[];var m;function f(){b+=8;if(d<w.length){return w[d++]}else{return -1}}function r(){ab=1}function V(){b++;var ad=(ab&1);ab>>=1;if(ab==0){ab=f();ad=(ab&1);ab=(ab>>1)|128}return ad}function T(ad){var af=0;var ae=ad;while(ae--){af=(af<<1)|V()}if(ad){af=W[af]>>(8-ad)}return af}var k=new Array(32768);var X=0;var U,I;function e(){X=0}function y(ad){I++;k[X++]=ad;p.push(String.fromCharCode(ad));if(X==32768){X=0}}function o(){this.b0=0;this.b1=0;this.jump=null;this.jumppos=-1}var g=288;var x=new Array(g);var N=new Array(32);var J=0;var Y=null;var s=null;var M=new Array(64);var K=new Array(64);var z=0;var D=new Array(17);D[0]=0;var O;var v;function l(){while(1){if(D[z]>=v){return -1}if(O[D[z]]==z){return D[z]++}D[z]++}}function F(){var ae=Y[J];var ad;if(E){document.write("<br>len:"+z+" treepos:"+J)}if(z==17){return -1}J++;z++;ad=l();if(E){document.write("<br>IsPat "+ad)}if(ad>=0){ae.b0=ad;if(E){document.write("<br>b0 "+ae.b0)}}else{ae.b0=32768;if(E){document.write("<br>b0 "+ae.b0)}if(F()){return -1}}ad=l();if(ad>=0){ae.b1=ad;if(E){document.write("<br>b1 "+ae.b1)}ae.jump=null}else{ae.b1=32768;if(E){document.write("<br>b1 "+ae.b1)}ae.jump=Y[J];ae.jumppos=J;if(F()){return -1}}z--;return 0}function n(ag,ae,ah,ad){var af;if(E){document.write("currentTree "+ag+" numval "+ae+" lengths "+ah+" show "+ad)}Y=ag;J=0;O=ah;v=ae;for(af=0;af<17;af++){D[af]=0}z=0;if(F()){if(E){alert("invalid huffman tree\n")}return -1}if(E){document.write("<br>Tree: "+Y.length);for(a=0;a<32;a++){document.write("Places["+a+"].b0="+Y[a].b0+"<br>");document.write("Places["+a+"].b1="+Y[a].b1+"<br>")}}return 0}function C(af){var ah=0;var ag=af[ah];while(1){var ad=V();if(E){document.write("b="+ad)}if(ad){if(!(ag.b1&32768)){if(E){document.write("ret1")}return ag.b1}ag=ag.jump;for(var ae=0;ae<af.length;ae++){if(af[ae]===ag){ah=ae;break}}}else{if(!(ag.b0&32768)){if(E){document.write("ret2")}return ag.b0}ah++;ag=af[ah]}}if(E){document.write("ret3")}return -1}function ac(){var ah,au,ae,ar;do{var ah=V();var ae=T(2);switch(ae){case 0:if(E){alert("Stored\n")}break;case 1:if(E){alert("Fixed Huffman codes\n")}break;case 2:if(E){alert("Dynamic Huffman codes\n")}break;case 3:if(E){alert("Reserved block type!!\n")}break;default:if(E){alert("Unexpected value %d!\n",ae)}break}if(ae==0){var ap,ad;r();ap=f();ap|=(f()<<8);ad=f();ad|=(f()<<8);if(((ap^~ad)&65535)){document.write("BlockLen checksum mismatch\n")}while(ap--){au=f();y(au)}}else{if(ae==1){var aq;while(1){aq=(W[T(7)]>>1);if(aq>23){aq=(aq<<1)|V();if(aq>199){aq-=128;aq=(aq<<1)|V()}else{aq-=48;if(aq>143){aq=aq+136}}}else{aq+=256}if(aq<256){y(aq)}else{if(aq==256){break}else{var at,am;aq-=256+1;at=T(R[aq])+aa[aq];aq=W[T(5)]>>3;if(A[aq]>8){am=T(8);am|=(T(A[aq]-8)<<8)}else{am=T(A[aq])}am+=L[aq];for(aq=0;aq<at;aq++){var au=k[(X-am)&32767];y(au)}}}}}else{if(ae==2){var aq,an,af,ak,al;var aj=new Array(288+32);af=257+T(5);ak=1+T(5);al=4+T(4);for(aq=0;aq<19;aq++){aj[aq]=0}for(aq=0;aq<al;aq++){aj[q[aq]]=T(3)}for(ar=0;ar<N.length;ar++){N[ar]=new o()}if(n(N,19,aj,0)){e();return 1}if(E){document.write("<br>distanceTree");for(var av=0;av<N.length;av++){document.write("<br>"+N[av].b0+" "+N[av].b1+" "+N[av].jump+" "+N[av].jumppos)}}an=af+ak;ar=0;var ag=-1;if(E){document.write("<br>n="+an+" bits: "+b+"<br>")}while(ar<an){ag++;aq=C(N);if(E){document.write("<br>"+ag+" i:"+ar+" decode: "+aq+"    bits "+b+"<br>")}if(aq<16){aj[ar++]=aq}else{if(aq==16){var ao;aq=3+T(2);if(ar+aq>an){e();return 1}ao=ar?aj[ar-1]:0;while(aq--){aj[ar++]=ao}}else{if(aq==17){aq=3+T(3)}else{aq=11+T(7)}if(ar+aq>an){e();return 1}while(aq--){aj[ar++]=0}}}}for(ar=0;ar<x.length;ar++){x[ar]=new o()}if(n(x,af,aj,0)){e();return 1}for(ar=0;ar<N.length;ar++){N[ar]=new o()}var ai=new Array();for(ar=af;ar<aj.length;ar++){ai[ar-af]=aj[ar]}if(n(N,ak,ai,0)){e();return 1}if(E){document.write("<br>literalTree")}while(1){aq=C(x);if(aq>=256){var at,am;aq-=256;if(aq==0){break}aq--;at=T(R[aq])+aa[aq];aq=C(N);if(A[aq]>8){am=T(8);am|=(T(A[aq]-8)<<8)}else{am=T(A[aq])}am+=L[aq];while(at--){var au=k[(X-am)&32767];y(au)}}else{y(aq)}}}}}}while(!ah);e();r();return 0}JXG.Util.Unzip.prototype.unzipFile=function(ad){this.unzip();for(i=0;i<P.length;i++){if(P[i][1]==ad){return P[i][0]}}};JXG.Util.Unzip.prototype.unzip=function(){if(E){alert(w)}u();return P};function u(){if(E){alert("NEXTFILE")}p=[];tmp=[];tmp[0]=f();tmp[1]=f();if(tmp[0]==parseInt("78",16)&&tmp[1]==parseInt("da",16)){if(E){alert("GEONExT-GZIP")}ac();if(E){alert(p.join(""))}P[H]=new Array(2);P[H][0]=p.join("");P[H][1]="geonext.gxt";H++}if(tmp[0]==parseInt("50",16)&&tmp[1]==parseInt("4b",16)){tmp[2]=f();tmp[3]=f();if(tmp[2]==parseInt("3",16)&&tmp[3]==parseInt("4",16)){tmp[0]=f();tmp[1]=f();if(E){alert("ZIP-Version: "+tmp[1]+" "+tmp[0]/10+"."+tmp[0]%10)}B=f();B|=(f()<<8);method=f();method|=(f()<<8);if(E){alert("method: "+method)}f();f();f();f();crc=f();crc|=(f()<<8);crc|=(f()<<16);crc|=(f()<<24);compSize=f();compSize|=(f()<<8);compSize|=(f()<<16);compSize|=(f()<<24);size=f();size|=(f()<<8);size|=(f()<<16);size|=(f()<<24);if(E){alert("local CRC: "+crc+"\nlocal Size: "+size+"\nlocal CompSize: "+compSize)}filelen=f();filelen|=(f()<<8);extralen=f();extralen|=(f()<<8);if(E){alert("filelen "+filelen)}i=0;h=[];while(filelen--){c=f();if(c=="/"|c==":"){i=0}else{if(i<Z-1){h[i++]=String.fromCharCode(c)}}}if(E){alert("nameBuf: "+h)}if(!m){m=h}i=0;while(i<extralen){c=f()}U=4294967295;I=0;if(size=0&&fileOut.charAt(m.length-1)=="/"){if(E){alert("skipdir")}}if(method==8){ac();if(E){alert(p.join(""))}P[H]=new Array(2);P[H][0]=p.join("");P[H][1]=h.join("");H++}Q()}}}function Q(){tmp=[];if((B&8)){tmp[0]=f();tmp[1]=f();tmp[2]=f();tmp[3]=f();if(tmp[0]==parseInt("50",16)&&tmp[1]==parseInt("4b",16)&&tmp[2]==parseInt("07",16)&&tmp[3]==parseInt("08",16)){crc=f();crc|=(f()<<8);crc|=(f()<<16);crc|=(f()<<24)}else{crc=tmp[0]|(tmp[1]<<8)|(tmp[2]<<16)|(tmp[3]<<24)}compSize=f();compSize|=(f()<<8);compSize|=(f()<<16);compSize|=(f()<<24);size=f();size|=(f()<<8);size|=(f()<<16);size|=(f()<<24);if(E){alert("CRC:")}u()}tmp[0]=f();if(tmp[0]!=8){if(E){alert("Unknown compression method!")}return 0}B=f();if(E){if((B&~(parseInt("1f",16)))){alert("Unknown flags set!")}}f();f();f();f();f();os=f();if((B&4)){tmp[0]=f();tmp[2]=f();z=tmp[0]+256*tmp[1];if(E){alert("Extra field size: "+z)}for(i=0;i<z;i++){f()}}if((B&8)){i=0;h=[];while(c=f()){if(c=="7"||c==":"){i=0}if(i<Z-1){h[i++]=c}}if(E){alert("original file name: "+h)}}if((B&16)){while(c=f()){}}if((B&2)){reabByte();reabByte()}ac();crc=f();crc|=(f()<<8);crc|=(f()<<16);crc|=(f()<<24);size=f();size|=(f()<<8);size|=(f()<<16);size|=(f()<<24);u()}};JXG.Util.Base64={_keyStr:"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",encode:function(e){var b="";var m,k,h,l,j,g,f;var d=0;e=JXG.Util.Base64._utf8_encode(e);while(d<e.length){m=e.charCodeAt(d++);k=e.charCodeAt(d++);h=e.charCodeAt(d++);l=m>>2;j=((m&3)<<4)|(k>>4);g=((k&15)<<2)|(h>>6);f=h&63;if(isNaN(k)){g=f=64}else{if(isNaN(h)){f=64}}b=b+this._keyStr.charAt(l)+this._keyStr.charAt(j)+this._keyStr.charAt(g)+this._keyStr.charAt(f)}return b},decode:function(f,e){var b="";var n,l,j;var m,k,h,g;var d=0;f=f.replace(/[^A-Za-z0-9\+\/\=]/g,"");while(d<f.length){m=this._keyStr.indexOf(f.charAt(d++));k=this._keyStr.indexOf(f.charAt(d++));h=this._keyStr.indexOf(f.charAt(d++));g=this._keyStr.indexOf(f.charAt(d++));n=(m<<2)|(k>>4);l=((k&15)<<4)|(h>>2);j=((h&3)<<6)|g;b=b+String.fromCharCode(n);if(h!=64){b=b+String.fromCharCode(l)}if(g!=64){b=b+String.fromCharCode(j)}}if(e){b=JXG.Util.Base64._utf8_decode(b)}return b},_utf8_encode:function(d){d=d.replace(/\r\n/g,"\n");var b="";for(var f=0;f<d.length;f++){var e=d.charCodeAt(f);if(e<128){b+=String.fromCharCode(e)}else{if((e>127)&&(e<2048)){b+=String.fromCharCode((e>>6)|192);b+=String.fromCharCode((e&63)|128)}else{b+=String.fromCharCode((e>>12)|224);b+=String.fromCharCode(((e>>6)&63)|128);b+=String.fromCharCode((e&63)|128)}}}return b},_utf8_decode:function(b){var e="";var g=0;var h,f,d;h=f=d=0;while(g<b.length){h=b.charCodeAt(g);if(h<128){e+=String.fromCharCode(h);g++}else{if((h>191)&&(h<224)){f=b.charCodeAt(g+1);e+=String.fromCharCode(((h&31)<<6)|(f&63));g+=2}else{f=b.charCodeAt(g+1);d=b.charCodeAt(g+2);e+=String.fromCharCode(((h&15)<<12)|((f&63)<<6)|(d&63));g+=3}}}return e},_destrip:function(f){f.replace(/ /g,"");lines=[];var e=f.length/76;for(var d=0;d<e;d++){lines[d]=f.substr(d*76,76)}if(e!=f.length/76){lines[lines.length]=f.substr(e*76,f.length-(e*76))}var b="";for(var d=0;d<lines.length;d++){b+=lines[d]+"\n"}return b},decodeAsArray:function(d){var e=this.decode(d);var b=[];for(i=0;i<e.length;i++){b[i]=e.charCodeAt(i)}return b},decodeGEONExT:function(b){return decodeAsArray(destrip(b),false)}};JXG.Util.asciiCharCodeAt=function(d,b){c=d.charCodeAt(b);if(c>255){switch(c){case 8364:c=128;break;case 8218:c=130;break;case 402:c=131;break;case 8222:c=132;break;case 8230:c=133;break;case 8224:c=134;break;case 8225:c=135;break;case 710:c=136;break;case 8240:c=137;break;case 352:c=138;break;case 8249:c=139;break;case 338:c=140;break;case 381:c=142;break;case 8216:c=145;break;case 8217:c=146;break;case 8220:c=147;break;case 8221:c=148;break;case 8226:c=149;break;case 8211:c=150;break;case 8212:c=151;break;case 732:c=152;break;case 8482:c=153;break;case 353:c=154;break;case 8250:c=155;break;case 339:c=156;break;case 382:c=158;break;case 376:c=159;break;default:break}}return c};JXG.PsTricks=function(){this.psTricksString=""};JXG.PsTricks.prototype.convertBoardToPsTricks=function(d){var f=new JXG.Coords(JXG.COORDS_BY_SCREEN,[d.canvasWidth,d.canvasHeight],d);var e=new JXG.Coords(JXG.COORDS_BY_SCREEN,[0,0],d);this.psTricksString="\\begin{pspicture*}("+e.usrCoords[1]+","+f.usrCoords[2]+")("+f.usrCoords[1]+","+e.usrCoords[2]+")\n";for(var b in d.objects){var g=d.objects[b];if(g.type==JXG.OBJECT_TYPE_ARC){if(g.visProp.visible){this.addSector(g)}}}for(var b in d.objects){var g=d.objects[b];if(g.type==JXG.OBJECT_TYPE_POLYGON){if(g.visProp.visible){this.addPolygon(g)}}}for(var b in d.objects){var g=d.objects[b];if(g.type==JXG.OBJECT_TYPE_ANGLE){if(g.visProp.visible){this.addAngle(g)}}}for(var b in d.objects){var g=d.objects[b];if(g.type==JXG.OBJECT_TYPE_CIRCLE){if(g.visProp.visible){this.addCircle(g)}}}for(var b in d.objects){var g=d.objects[b];if(g.type==JXG.OBJECT_TYPE_ARC){if(g.visProp.visible){this.addArc(g)}}}for(var b in d.objects){var g=d.objects[b];if(g.type==JXG.OBJECT_TYPE_LINE){if(g.visProp.visible){this.addLine(g)}}}for(var b in d.objects){var g=d.objects[b];if(g.type==JXG.OBJECT_TYPE_POINT){if(g.visProp.visible){this.addPoint(g)}}}this.psTricksString+="\\end{pspicture*}"};JXG.PsTricks.prototype.givePsTricksToDiv=function(b,d){this.convertBoardToPsTricks(d);document.getElementById(b).innerHTML=this.psTricksString};JXG.PsTricks.prototype.addPoint=function(b){this.psTricksString+="\\psdot";this.psTricksString+="[linecolor="+this.parseColor(b.visProp.strokeColor)+",";this.psTricksString+="dotstyle=";if(b.visProp.style==0||b.visProp.style==1||b.visProp.style==2){this.psTricksString+="x, dotsize=";if(b.visProp.style==0){this.psTricksString+="2pt 2"}else{if(b.visProp.style==1){this.psTricksString+="5pt 2"}else{if(b.visProp.style==2){this.psTricksString+="5pt 3"}}}}else{if(b.visProp.style==3||b.visProp.style==4||b.visProp.style==5||b.visProp.style==6){this.psTricksString+="*, dotsize=";if(b.visProp.style==3){this.psTricksString+="2pt 2"}else{if(b.visProp.style==4){this.psTricksString+="4pt 2"}else{if(b.visProp.style==5){this.psTricksString+="6pt 2"}else{if(b.visProp.style==6){this.psTricksString+="6pt 3"}}}}}else{if(b.visProp.style==7||b.visProp.style==8||b.visProp.style==9){this.psTricksString+="square*, dotsize=";if(b.visProp.style==7){this.psTricksString+="2pt 2"}else{if(b.visProp.style==8){this.psTricksString+="5pt 2"}else{if(b.visProp.style==9){this.psTricksString+="5pt 3"}}}}else{if(b.visProp.style==10||b.visProp.style==11||b.visProp.style==12){this.psTricksString+="+, dotsize=";if(b.visProp.style==10){this.psTricksString+="2pt 2"}else{if(b.visProp.style==11){this.psTricksString+="5pt 2"}else{if(b.visProp.style==12){this.psTricksString+="5pt 3"}}}}}}}this.psTricksString+="]";this.psTricksString+="("+b.coords.usrCoords[1]+","+b.coords.usrCoords[2]+")\n";this.psTricksString+="\\rput("+(b.coords.usrCoords[1]+15/b.board.unitY/b.board.zoomY)+","+(b.coords.usrCoords[2]+15/b.board.unitY/b.board.zoomY)+"){\\small $"+b.name+"$}\n"};JXG.PsTricks.prototype.addLine=function(e){var d=new JXG.Coords(JXG.COORDS_BY_USER,e.point1.coords.usrCoords,e.board);var b=new JXG.Coords(JXG.COORDS_BY_USER,e.point2.coords.usrCoords,e.board);if(e.visProp.straightFirst||e.visProp.straightLast){e.board.renderer.calcStraight(e,d,b)}this.psTricksString+="\\psline";this.psTricksString+="[linecolor="+this.parseColor(e.visProp.strokeColor)+", linewidth="+e.visProp.strokeWidth+"px";this.psTricksString+="]";if(e.visProp.firstArrow){if(e.visProp.lastArrow){this.psTricksString+="{<->}"}else{this.psTricksString+="{<-}"}}else{if(e.visProp.lastArrow){this.psTricksString+="{->}"}}this.psTricksString+="("+d.usrCoords[1]+","+d.usrCoords[2]+")("+b.usrCoords[1]+","+b.usrCoords[2]+")\n"};JXG.PsTricks.prototype.addCircle=function(d){var b=d.getRadius();this.psTricksString+="\\pscircle";this.psTricksString+="[linecolor="+this.parseColor(d.visProp.strokeColor)+", linewidth="+d.visProp.strokeWidth+"px";if(d.visProp.fillColor!="none"&&d.visProp.fillOpacity!=0){this.psTricksString+=", fillstyle=solid, fillcolor="+this.parseColor(d.visProp.fillColor)+", opacity="+JXG.Math.round(d.visProp.fillOpacity,5)}this.psTricksString+="]";this.psTricksString+="("+d.midpoint.coords.usrCoords[1]+","+d.midpoint.coords.usrCoords[2]+"){"+b+"}\n"};JXG.PsTricks.prototype.addPolygon=function(d){this.psTricksString+="\\pspolygon";this.psTricksString+="[linestyle=none, fillstyle=solid, fillcolor="+this.parseColor(d.visProp.fillColor)+", opacity="+JXG.Math.round(d.visProp.fillOpacity,5)+"]";for(var b=0;b<d.vertices.length;b++){this.psTricksString+="("+d.vertices[b].coords.usrCoords[1]+","+d.vertices[b].coords.usrCoords[2]+")"}this.psTricksString+="\n"};JXG.PsTricks.prototype.addArc=function(d){var b=d.getRadius();var f={};f.coords=new JXG.Coords(JXG.COORDS_BY_USER,[d.board.canvasWidth/(d.board.unitY*d.board.zoomY),d.midpoint.coords.usrCoords[2]],d.board);var e=JXG.Math.round(d.board.algebra.trueAngle(f,d.midpoint,d.point2),4);var g=JXG.Math.round(d.board.algebra.trueAngle(f,d.midpoint,d.point3),4);this.psTricksString+="\\psarc";this.psTricksString+="[linecolor="+this.parseColor(d.visProp.strokeColor)+", linewidth="+d.visProp.strokeWidth+"px";this.psTricksString+="]";if(d.visProp.lastArrow){if(d.visProp.firstArrow){this.psTricksString+="{<->}"}else{this.psTricksString+="{<-}"}}else{if(d.visProp.firstArrow){this.psTricksString+="{->}"}}this.psTricksString+="("+d.midpoint.coords.usrCoords[1]+","+d.midpoint.coords.usrCoords[2]+"){"+b+"}{"+e+"}{"+g+"}\n"};JXG.PsTricks.prototype.addSector=function(d){var b=d.getRadius();var f={};f.coords=new JXG.Coords(JXG.COORDS_BY_USER,[d.board.canvasWidth/(d.board.unitY*d.board.zoomY),d.midpoint.coords.usrCoords[2]],d.board);var e=JXG.Math.round(d.board.algebra.trueAngle(f,d.midpoint,d.point2),4);var g=JXG.Math.round(d.board.algebra.trueAngle(f,d.midpoint,d.point3),4);if(d.visProp.fillColor!="none"&&d.visProp.fillOpacity!=0){this.psTricksString+="\\pswedge";this.psTricksString+="[linestyle=none, fillstyle=solid, fillcolor="+this.parseColor(d.visProp.fillColor)+", opacity="+JXG.Math.round(d.visProp.fillOpacity,5)+"]";this.psTricksString+="("+d.midpoint.coords.usrCoords[1]+","+d.midpoint.coords.usrCoords[2]+"){"+b+"}{"+e+"}{"+g+"}\n"}};JXG.PsTricks.prototype.addAngle=function(d){var b=d.radius;var f={};f.coords=new JXG.Coords(JXG.COORDS_BY_USER,[d.board.canvasWidth/(d.board.unitY*d.board.zoomY),d.point2.coords.usrCoords[2]],d.board);var e=JXG.Math.round(d.board.algebra.trueAngle(f,d.point2,d.point1),4);var g=JXG.Math.round(d.board.algebra.trueAngle(f,d.point2,d.point3),4);if(d.visProp.fillColor!="none"&&d.visProp.fillOpacity!=0){this.psTricksString+="\\pswedge";this.psTricksString+="[linestyle=none, fillstyle=solid, fillcolor="+this.parseColor(d.visProp.fillColor)+", opacity="+JXG.Math.round(d.visProp.fillOpacity,5)+"]";this.psTricksString+="("+d.point2.coords.usrCoords[1]+","+d.point2.coords.usrCoords[2]+"){"+b+"}{"+e+"}{"+g+"}\n"}this.psTricksString+="\\psarc";this.psTricksString+="[linecolor="+this.parseColor(d.visProp.strokeColor)+", linewidth="+d.visProp.strokeWidth+"px";this.psTricksString+="]";this.psTricksString+="("+d.point2.coords.usrCoords[1]+","+d.point2.coords.usrCoords[2]+"){"+b+"}{"+e+"}{"+g+"}\n"};JXG.PsTricks.prototype.parseColor=function(b){var d=new JXG.RGBColor(b);return"{[rgb]{"+d.r/255+","+d.g/255+","+d.b/255+"}}"};JXG.SVGRenderer=function(b){this.constructor();this.svgRoot=null;this.suspendHandle=null;this.svgNamespace="http://www.w3.org/2000/svg";this.xlinkNamespace="http://www.w3.org/1999/xlink";this.container=b;this.container.style.MozUserSelect="none";this.container.style.overflow="hidden";if(this.container.style.position==""){this.container.style.position="relative"}this.svgRoot=this.container.ownerDocument.createElementNS(this.svgNamespace,"svg");this.container.appendChild(this.svgRoot);this.defs=this.container.ownerDocument.createElementNS(this.svgNamespace,"defs");this.svgRoot.appendChild(this.defs);this.images=this.container.ownerDocument.createElementNS(this.svgNamespace,"g");this.svgRoot.appendChild(this.images);this.grid=this.container.ownerDocument.createElementNS(this.svgNamespace,"g");this.svgRoot.appendChild(this.grid);this.angles=this.container.ownerDocument.createElementNS(this.svgNamespace,"g");this.svgRoot.appendChild(this.angles);this.sectors=this.container.ownerDocument.createElementNS(this.svgNamespace,"g");this.svgRoot.appendChild(this.sectors);this.polygone=this.container.ownerDocument.createElementNS(this.svgNamespace,"g");this.svgRoot.appendChild(this.polygone);this.curves=this.container.ownerDocument.createElementNS(this.svgNamespace,"g");this.svgRoot.appendChild(this.curves);this.circles=this.container.ownerDocument.createElementNS(this.svgNamespace,"g");this.svgRoot.appendChild(this.circles);this.lines=this.container.ownerDocument.createElementNS(this.svgNamespace,"g");this.svgRoot.appendChild(this.lines);this.arcs=this.container.ownerDocument.createElementNS(this.svgNamespace,"g");this.svgRoot.appendChild(this.arcs);this.points=this.container.ownerDocument.createElementNS(this.svgNamespace,"g");this.svgRoot.appendChild(this.points);this.dashArray=["2, 2","5, 5","10, 10","20, 20","20, 10, 10, 10","20, 5, 10, 5"]};JXG.SVGRenderer.prototype=new JXG.AbstractRenderer;JXG.SVGRenderer.prototype.displayCopyright=function(e,f){var d=this.createPrimitive("text","licenseText");d.setAttributeNS(null,"x","20");d.setAttributeNS(null,"y",2+f);d.setAttributeNS(null,"style","font-family:Arial,Helvetica,sans-serif; font-size:"+f+"px; fill:#356AA0;  opacity:0.3;");var b=document.createTextNode(e);d.appendChild(b);this.appendChildPrimitive(d,"images")};JXG.SVGRenderer.prototype.drawTicks=function(b){var d=this.createPrimitive("path",b.id);this.appendChildPrimitive(d,"lines");b.rendNode=d};JXG.SVGRenderer.prototype.updateTicks=function(e,f,b,h,d){var g="";for(var j=0;j<e.ticks.length;j++){var k=e.ticks[j];if(k.major){if(e.labels[j].show){this.drawLabel(e.labels[j])}g+="M "+(k.scrCoords[1]+f)+" "+(k.scrCoords[2]-b)+" L "+(k.scrCoords[1]-f)+" "+(k.scrCoords[2]+b)+" "}else{g+="M "+(k.scrCoords[1]+h)+" "+(k.scrCoords[2]-d)+" L "+(k.scrCoords[1]-h)+" "+(k.scrCoords[2]+d)+" "}}var l=document.getElementById(e.id);if(l==null){l=this.createPrimitive("path",e.id);this.appendChildPrimitive(l,"lines")}l.setAttributeNS(null,"stroke",e.visProp.strokeColor);l.setAttributeNS(null,"stroke-opacity",e.visProp.strokeOpacity);l.setAttributeNS(null,"stroke-width",e.visProp.strokeWidth);this.updatePathPrimitive(l,g,e.board)};JXG.SVGRenderer.prototype.drawArc=function(d){var e=this.createPrimitive("path",d.id);d.rendNode=e;var j=d.getRadius();var f=d.board.algebra.trueAngle(d.point2,d.midpoint,d.point3);var b={};b.midpoint=d.midpoint;b.getRadius=function(){return j};var k=d.board.algebra.projectPointToCircle(d.point3,b);var g="M "+d.point2.coords.scrCoords[1]+" "+d.point2.coords.scrCoords[2]+" A ";g+=Math.round(j*d.board.unitX*d.board.zoomX)+" "+Math.round(j*d.board.unitY*d.board.zoomY)+" 0 ";if(f>=180){g+="1 "}else{g+="0 "}g+="0 ";g+=k.scrCoords[1]+" "+k.scrCoords[2];this.updatePathPrimitive(e,g,d.board);if(d.visProp.strokeColor!=null){e.setAttributeNS(null,"stroke",d.visProp.strokeColor)}if(d.visProp.strokeOpacity!=null){e.setAttributeNS(null,"stroke-opacity",d.visProp.strokeOpacity)}if(d.visProp.strokeWidth!=null){e.setAttributeNS(null,"stroke-width",d.visProp.strokeWidth)}e.setAttributeNS(null,"fill","none");this.setDashStyle(e,d.visProp);var n;var m;if(d.visProp.firstArrow){var n=this.createArrowHead(d,"Start");this.defs.appendChild(n);d.rendNodeTriangleStart=n;e.setAttributeNS(null,"marker-end","url(#"+d.id+"TriangleStart)")}if(d.visProp.lastArrow){var n=this.createArrowHead(d,"End");this.defs.appendChild(n);d.rendNodeTriangleEnd=n;e.setAttributeNS(null,"marker-start","url(#"+d.id+"TriangleEnd)")}var l=this.createPrimitive("path",d.id+"_fill");var h="M "+d.midpoint.coords.scrCoords[1]+" "+d.midpoint.coords.scrCoords[2];h+=" L "+d.point2.coords.scrCoords[1]+" "+d.point2.coords.scrCoords[2]+" A ";h+=Math.round(j*d.board.unitX*d.board.zoomX)+" "+Math.round(j*d.board.unitY*d.board.zoomY)+" 0 ";if(f>=180){h+="1 "}else{h+="0 "}h+="0 ";h+=k.scrCoords[1]+" "+k.scrCoords[2];h+=" L "+d.midpoint.coords.scrCoords[1]+" "+d.midpoint.coords.scrCoords[2]+" z";this.updatePathPrimitive(l,h,d.board);if(d.visProp.fillColor!=null){l.setAttributeNS(null,"fill",d.visProp.fillColor)}if(d.visProp.fillOpacity!=null){l.setAttributeNS(null,"fill-opacity",d.visProp.fillOpacity)}l.setAttributeNS(null,"stroke","none");this.arcs.appendChild(e);this.sectors.appendChild(l);d.rendNodeFill=l;this.setDraft(d);if(!d.visProp.visible){d.hideElement()}};JXG.AbstractRenderer.prototype.updateArc=function(b){this.remove(b.rendNode);this.remove(b.rendNodeFill);var d=b.rendNodeTriangleStart;if(d!=null){this.remove(d)}d=b.rendNodeTriangleEnd;if(d!=null){this.remove(d)}this.drawArc(b);this.setDraft(b);return};JXG.SVGRenderer.prototype.drawAngle=function(g){var k=g.board.algebra.trueAngle(g.point1,g.point2,g.point3);var j={};j.midpoint=g.point2;j.getRadius=function(){return g.radius};var f=g.board.algebra.projectPointToCircle(g.point1,j);var d=g.board.algebra.projectPointToCircle(g.point3,j);var h=this.createPrimitive("path",g.id+"_1");var e="M "+g.point2.coords.scrCoords[1]+" "+g.point2.coords.scrCoords[2];e+=" L "+f.scrCoords[1]+" "+f.scrCoords[2]+" A ";e+=Math.round(g.radius*g.board.unitX*g.board.zoomX)+" "+Math.round(g.radius*g.board.unitY*g.board.zoomY)+" 0 ";if(k>=180){e+="1 "}else{e+="0 "}e+="0 ";e+=d.scrCoords[1]+" "+d.scrCoords[2];e+=" L "+g.point2.coords.scrCoords[1]+" "+g.point2.coords.scrCoords[2]+" z";h.setAttributeNS(null,"d",e);h.setAttributeNS(null,"fill",g.visProp.fillColor);h.setAttributeNS(null,"fill-opacity",g.visProp.fillOpacity);h.setAttributeNS(null,"stroke","none");var b=this.createPrimitive("path",g.id+"_2");var e="M "+f.scrCoords[1]+" "+f.scrCoords[2]+" A ";e+=Math.round(g.radius*g.board.unitX*g.board.zoomX)+" "+Math.round(g.radius*g.board.unitY*g.board.zoomY)+" 0 ";if(k>=180){e+="1 "}else{e+="0 "}e+="0 ";e+=d.scrCoords[1]+" "+d.scrCoords[2];b.setAttributeNS(null,"d",e);b.setAttributeNS(null,"id",g.id+"_2");b.setAttributeNS(null,"fill","none");b.setAttributeNS(null,"stroke",g.visProp.strokeColor);b.setAttributeNS(null,"stroke-opacity",g.visProp.strokeOpacity);this.appendChildPrimitive(h,"angles");g.rendNode1=h;this.appendChildPrimitive(b,"angles");g.rendNode2=b;this.setObjectStrokeWidth(g,g.visProp.strokeWidth)};JXG.SVGRenderer.prototype.updateAngle=function(b){this.remove(b.rendNode1);this.remove(b.rendNode2);this.drawAngle(b);if(!b.visProp.visible){b.hideElement()}return};JXG.SVGRenderer.prototype.drawImage=function(d){var b="data:image/png;base64,"+d.imageBase64String;var e=this.createPrimitive("image",d.id);e.setAttributeNS(this.xlinkNamespace,"xlink:href",b);this.appendChildPrimitive(e,d.displayLevel);d.rendNode=e;this.updateImage(d)};JXG.SVGRenderer.prototype.transformImage=function(d,b){var e=d.rendNode;var f=e.getAttributeNS(null,"transform");f+=" "+this.joinTransforms(d,b);e.setAttributeNS(null,"transform",f)};JXG.SVGRenderer.prototype.joinTransforms=function(f,d){var g="";for(var b=0;b<d.length;b++){var e=d[b].matrix[1][1]+","+d[b].matrix[2][1]+","+d[b].matrix[1][2]+","+d[b].matrix[2][2]+","+d[b].matrix[1][0]+","+d[b].matrix[2][0];g+="matrix("+e+") "}return g};JXG.SVGRenderer.prototype.transformImageParent=function(e,b){if(b!=null){var d=b[1][1]+","+b[2][1]+","+b[1][2]+","+b[2][2]+","+b[1][0]+","+b[2][0];var f="matrix("+d+")"}else{var f=""}e.rendNode.setAttributeNS(null,"transform",f)};JXG.SVGRenderer.prototype.removeGrid=function(b){b.hasGrid=false;var d=this.grid;while(d.childNodes.length>0){d.removeChild(d.firstChild)}};JXG.SVGRenderer.prototype.setObjectDash=function(b){if(b.elementClass!=JXG.OBJECT_CLASS_POINT){var d;if(b.type==JXG.OBJECT_TYPE_ANGLE){d=b.rendNode2}else{d=b.rendNode}if(b.visProp.dash>0){var e=b.visProp.dash;d.setAttributeNS(null,"stroke-dasharray",this.dashArray[e-1])}else{if(d.hasAttributeNS(null,"stroke-dasharray")){d.removeAttributeNS(null,"stroke-dasharray")}}}};JXG.SVGRenderer.prototype.setObjectStrokeColor=function(e,b,d){if(d==undefined){d=1}var h,g;if(typeof d=="function"){g=d()}else{g=d}g=(g>0)?g:0;if(typeof b=="function"){h=b()}else{h=b}if(e.elementClass!=JXG.OBJECT_CLASS_POINT){var f=e.rendNode;if(e.type==JXG.OBJECT_TYPE_TEXT){f.style.color=h}else{if(e.type==JXG.OBJECT_TYPE_ANGLE){f=e.rendNode2;f.setAttributeNS(null,"stroke",h);f.setAttributeNS(null,"stroke-opacity",g)}else{f.setAttributeNS(null,"stroke",h);f.setAttributeNS(null,"stroke-opacity",g)}}if(e.type==JXG.OBJECT_TYPE_ARROW){e.rendNodeTriangle.setAttributeNS(null,"stroke",h);e.rendNodeTriangle.setAttributeNS(null,"stroke-opacity",g);e.rendNodeTriangle.setAttributeNS(null,"fill",h);e.rendNodeTriangle.setAttributeNS(null,"fill-opacity",g)}if(e.type==JXG.OBJECT_TYPE_ARC){if(e.visProp.firstArrow){e.rendNodeTriangleStart.setAttributeNS(null,"stroke",h);e.rendNodeTriangleStart.setAttributeNS(null,"stroke-opacity",g);e.rendNodeTriangleStart.setAttributeNS(null,"fill",h);e.rendNodeTriangleStart.setAttributeNS(null,"fill-opacity",g)}if(e.visProp.lastArrow){e.rendNodeTriangleEnd.setAttributeNS(null,"stroke",h);e.rendNodeTriangleEnd.setAttributeNS(null,"stroke-opacity",g);e.rendNodeTriangleEnd.setAttributeNS(null,"fill",h);e.rendNodeTriangleEnd.setAttributeNS(null,"fill-opacity",g)}}else{if(e.type==JXG.OBJECT_TYPE_LINE){if(e.visProp.firstArrow){e.rendNodeTriangleStart.setAttributeNS(null,"stroke",h);e.rendNodeTriangleStart.setAttributeNS(null,"stroke-opacity",g);e.rendNodeTriangleStart.setAttributeNS(null,"fill",h);e.rendNodeTriangleStart.setAttributeNS(null,"fill-opacity",g)}if(e.visProp.lastArrow){e.rendNodeTriangleEnd.setAttributeNS(null,"stroke",h);e.rendNodeTriangleEnd.setAttributeNS(null,"stroke-opacity",g);e.rendNodeTriangleEnd.setAttributeNS(null,"fill",h);e.rendNodeTriangleEnd.setAttributeNS(null,"fill-opacity",g)}}}}else{if(e.visProp.style>=3&&e.visProp.style<=9){var f=e.rendNode;f.setAttributeNS(null,"stroke",h);f.setAttributeNS(null,"stroke-opacity",g)}else{var f=e.rendNodeX1;f.setAttributeNS(null,"stroke",h);f.setAttributeNS(null,"stroke-opacity",g);f=e.rendNodeX2;f.setAttributeNS(null,"stroke",h);f.setAttributeNS(null,"stroke-opacity",g)}}};JXG.SVGRenderer.prototype.setObjectFillColor=function(e,b,d){if(d==undefined){d=1}var h,g;if(typeof d=="function"){g=d()}else{g=d}g=(g>0)?g:0;if(typeof b=="function"){h=b()}else{h=b}if(e.elementClass!=JXG.OBJECT_CLASS_POINT){if(e.type==JXG.OBJECT_TYPE_ARC){var f=e.rendNodeFill;f.setAttributeNS(null,"fill",h);f.setAttributeNS(null,"fill-opacity",g)}else{if(e.type==JXG.OBJECT_TYPE_ANGLE){f=e.rendNode1;f.setAttributeNS(null,"fill",h);f.setAttributeNS(null,"fill-opacity",g)}else{var f=e.rendNode;f.setAttributeNS(null,"fill",h);f.setAttributeNS(null,"fill-opacity",g)}}}else{if(e.visProp.style>=3&&e.visProp.style<=9){var f=e.rendNode;f.setAttributeNS(null,"fill",h);f.setAttributeNS(null,"fill-opacity",g)}else{var f=e.rendNodeX1;f.setAttributeNS(null,"fill",h);f.setAttributeNS(null,"fill-opacity",g);f=e.rendNodeX2;f.setAttributeNS(null,"fill",h);f.setAttributeNS(null,"fill-opacity",g)}}};JXG.SVGRenderer.prototype.setObjectStrokeWidth=function(e,d){var b;if(typeof d=="function"){b=d()}else{b=d}if(e.elementClass!=JXG.OBJECT_CLASS_POINT){var f;if(e.type==JXG.OBJECT_TYPE_ANGLE){f=e.rendNode2}else{f=e.rendNode}this.setPropertyPrimitive(f,"stroked","true");if(b!=null){this.setPropertyPrimitive(f,"stroke-width",b)}}else{if(e.visProp.style>=3&&e.visProp.style<=9){var f=e.rendNode;this.setPropertyPrimitive(f,"stroked","true");if(b!=null){this.setPropertyPrimitive(f,"stroke-width",b)}}else{var f=e.rendNodeX1;this.setPropertyPrimitive(f,"stroked","true");if(b!=null){this.setPropertyPrimitive(f,"stroke-width",b)}var f=e.rendNodeX2;this.setPropertyPrimitive(f,"stroked","true");if(b!=null){this.setPropertyPrimitive(f,"stroke-width",b)}}}};JXG.SVGRenderer.prototype.hide=function(b){if(JXG.IsPoint(b)){if(b.visProp.style>=3&&b.visProp.style<=9){var d=b.rendNode;d.setAttributeNS(null,"display","none");d.style.visibility="hidden"}else{var d=b.rendNodeX1;d.setAttributeNS(null,"display","none");d.style.visibility="hidden";d=b.rendNodeX2;d.setAttributeNS(null,"display","none");d.style.visibility="hidden"}}else{if(b.type==JXG.OBJECT_TYPE_ARC){var d=b.rendNode;d.setAttributeNS(null,"display","none");d.style.visibility="hidden";d=b.rendNodeFill;d.setAttributeNS(null,"display","none");d.style.visibility="hidden"}else{if(b.type==JXG.OBJECT_TYPE_ANGLE){var d=b.rendNode1;d.setAttributeNS(null,"display","none");d.style.visibility="hidden";d=b.rendNode2;d.setAttributeNS(null,"display","none");d.style.visibility="hidden"}else{var d=b.rendNode;d.setAttributeNS(null,"display","none");d.style.visibility="hidden"}}}};JXG.SVGRenderer.prototype.show=function(b){if(JXG.IsPoint(b)){if(b.visProp.style>=3&&b.visProp.style<=9){var d=b.rendNode;d.setAttributeNS(null,"display","inline");d.style.visibility="inherit"}else{var d=b.rendNodeX1;d.setAttributeNS(null,"display","inline");d.style.visibility="inherit";d=b.rendNodeX2;d.setAttributeNS(null,"display","inline");d.style.visibility="inherit"}}else{if(b.type==JXG.OBJECT_TYPE_ARC){var d=b.rendNode;d.setAttributeNS(null,"display","inline");d.style.visibility="inherit";d=b.rendNodeFill;d.setAttributeNS(null,"display","inline");d.style.visibility="inherit"}else{if(b.type==JXG.OBJECT_TYPE_ANGLE){var d=b.rendNode1;d.setAttributeNS(null,"display","inline");d.style.visibility="inherit";d=b.rendNode2;d.setAttributeNS(null,"display","inline");d.style.visibility="inherit"}else{var d=b.rendNode;d.setAttributeNS(null,"display","inline");d.style.visibility="inherit"}}}};JXG.SVGRenderer.prototype.remove=function(b){if(b!=null&&b.parentNode!=null){b.parentNode.removeChild(b)}};JXG.SVGRenderer.prototype.suspendRedraw=function(){if(true){this.suspendHandle=this.svgRoot.suspendRedraw(10000)}};JXG.SVGRenderer.prototype.unsuspendRedraw=function(){if(true){this.svgRoot.unsuspendRedraw(this.suspendHandle);this.svgRoot.forceRedraw()}};JXG.SVGRenderer.prototype.setDashStyle=function(d,b){if(b.dash>0){var e=b.dash;d.setAttributeNS(null,"stroke-dasharray",this.dashArray[e-1])}};JXG.SVGRenderer.prototype.createPrimitive=function(b,e){var d=this.container.ownerDocument.createElementNS(this.svgNamespace,b);d.setAttributeNS(null,"id",e);d.style.position="absolute";return d};JXG.SVGRenderer.prototype.createArrowHead=function(e,g){var f=e.id+"Triangle";if(g!=null){f+=g}var d=this.createPrimitive("marker",f);d.setAttributeNS(null,"viewBox","0 0 10 6");d.setAttributeNS(null,"refY","3");d.setAttributeNS(null,"markerUnits","strokeWidth");d.setAttributeNS(null,"markerHeight","6");d.setAttributeNS(null,"markerWidth","6");d.setAttributeNS(null,"orient","auto");d.setAttributeNS(null,"stroke",e.visProp.strokeColor);d.setAttributeNS(null,"stroke-opacity",e.visProp.strokeOpacity);d.setAttributeNS(null,"fill",e.visProp.strokeColor);d.setAttributeNS(null,"fill-opacity",e.visProp.strokeOpacity);var b=this.container.ownerDocument.createElementNS(this.svgNamespace,"path");if(g=="End"){d.setAttributeNS(null,"refX","0");b.setAttributeNS(null,"d","M 0 3 L 10 6 L 10 0 z")}else{d.setAttributeNS(null,"refX","10");b.setAttributeNS(null,"d","M 0 0 L 10 3 L 0 6 z")}d.appendChild(b);return d};JXG.SVGRenderer.prototype.makeArrow=function(e,d,f){var b=this.createArrowHead(d,f);this.defs.appendChild(b);e.setAttributeNS(null,"marker-end","url(#"+d.id+"Triangle)");d.rendNodeTriangle=b};JXG.SVGRenderer.prototype.makeArrows=function(d){if(d.visProp.firstArrow){var b=d.rendNodeTriangleStart;if(b==null){b=this.createArrowHead(d,"End");this.defs.appendChild(b);d.rendNodeTriangleStart=b;d.rendNode.setAttributeNS(null,"marker-start","url(#"+d.id+"TriangleEnd)")}}else{var b=d.rendNodeTriangleStart;if(b!=null){this.remove(b)}}if(d.visProp.lastArrow){var b=d.rendNodeTriangleEnd;if(b==null){b=this.createArrowHead(d,"Start");this.defs.appendChild(b);d.rendNodeTriangleEnd=b;d.rendNode.setAttributeNS(null,"marker-end","url(#"+d.id+"TriangleStart)")}}else{var b=d.rendNodeTriangleEnd;if(b!=null){this.remove(b)}}};JXG.SVGRenderer.prototype.updateLinePrimitive=function(g,d,b,f,e){g.setAttributeNS(null,"x1",d);g.setAttributeNS(null,"y1",b);g.setAttributeNS(null,"x2",f);g.setAttributeNS(null,"y2",e)};JXG.SVGRenderer.prototype.updateCirclePrimitive=function(e,b,f,d){e.setAttributeNS(null,"cx",(b));e.setAttributeNS(null,"cy",(f));e.setAttributeNS(null,"r",(d))};JXG.SVGRenderer.prototype.updateEllipsePrimitive=function(d,b,g,f,e){d.setAttributeNS(null,"cx",(b));d.setAttributeNS(null,"cy",(g));d.setAttributeNS(null,"rx",(f));d.setAttributeNS(null,"ry",(e))};JXG.SVGRenderer.prototype.updateRectPrimitive=function(f,b,g,d,e){f.setAttributeNS(null,"x",(b));f.setAttributeNS(null,"y",(g));f.setAttributeNS(null,"width",(d));f.setAttributeNS(null,"height",(e))};JXG.SVGRenderer.prototype.updatePathPrimitive=function(d,e,b){d.setAttributeNS(null,"d",e);d.setAttributeNS(null,"stroke-linecap","round");d.setAttributeNS(null,"stroke-linejoin","round")};JXG.SVGRenderer.prototype.updatePathStringPrimitive=function(f){if(f.numberPoints<=0){return""}var k=" M ";var j="";var e=100*f.board.canvasHeight;var b=100*f.board.canvasWidth;for(var d=0;d<f.numberPoints;d++){var g=f.points[d].scrCoords;if(isNaN(g[1])||isNaN(g[2])||Math.abs(g[1])>b||Math.abs(g[2])>e){k=" M "}else{j+=k+g[1]+" "+g[2];k=" L "}}return j};JXG.SVGRenderer.prototype.updatePolygonePrimitive=function(f,d){f.setAttributeNS(null,"stroke","none");var g="";for(var b=0;b<d.vertices.length-1;b++){var e=d.vertices[b].coords.scrCoords;g=g+e[1]+","+e[2];if(b<d.vertices.length-2){g+=" "}}f.setAttributeNS(null,"points",g)};JXG.SVGRenderer.prototype.appendChildPrimitive=function(b,d){switch(d){case"images":this.images.appendChild(b);break;case"grid":this.grid.appendChild(b);break;case"angles":this.angles.appendChild(b);break;case"sectors":this.sectors.appendChild(b);break;case"polygone":this.polygone.appendChild(b);break;case"curves":this.lines.appendChild(b);break;case"circles":this.lines.appendChild(b);break;case"lines":this.lines.appendChild(b);break;case"arcs":this.arcs.appendChild(b);break;case"points":this.points.appendChild(b);break}};JXG.SVGRenderer.prototype.setPropertyPrimitive=function(d,b,e){if(b=="stroked"){return}d.setAttributeNS(null,b,e)};JXG.SVGRenderer.prototype.drawVerticalGrid=function(f,d,h,e){var g=this.createPrimitive("path","gridx");var b="";while(f.scrCoords[1]<d.scrCoords[1]+h-1){b+=" M "+f.scrCoords[1]+" "+0+" L "+f.scrCoords[1]+" "+e.canvasHeight+" ";f.setCoordinates(JXG.COORDS_BY_SCREEN,[f.scrCoords[1]+h,f.scrCoords[2]])}this.updatePathPrimitive(g,b,e);return g};JXG.SVGRenderer.prototype.drawHorizontalGrid=function(f,d,h,e){var g=this.createPrimitive("path","gridy");var b="";while(f.scrCoords[2]<=d.scrCoords[2]+h-1){b+=" M "+0+" "+f.scrCoords[2]+" L "+e.canvasWidth+" "+f.scrCoords[2]+" ";f.setCoordinates(JXG.COORDS_BY_SCREEN,[f.scrCoords[1],f.scrCoords[2]+h])}this.updatePathPrimitive(g,b,e);return g};JXG.VMLRenderer=function(b){this.constructor();this.container=b;this.container.style.overflow="hidden";this.container.onselectstart=function(){return false};b.ownerDocument.namespaces.add("v","urn:schemas-microsoft-com:vml");b.ownerDocument.createStyleSheet().addRule("v\\:*","behavior: url(#default#VML);");this.dashArray=["Solid","1 1","ShortDash","Dash","LongDash","ShortDashDot","LongDashDot"]};JXG.VMLRenderer.prototype=new JXG.AbstractRenderer;JXG.VMLRenderer.prototype.displayCopyright=function(e,f){var d=this.createPrimitive("textbox","licenseText");d.style.left=20;d.style.top=(2);d.style.fontSize=(f);d.style.color="#356AA0";d.style.fontFamily="Arial,Helvetica,sans-serif";d.setAttribute("opacity","30%");d.style.filter="alpha(opacity = 30)";var b=document.createTextNode(e);d.appendChild(b);this.appendChildPrimitive(d,"images")};JXG.VMLRenderer.prototype.drawTicks=function(b){var d=this.createPrimitive("path",b.id+"_ticks");this.appendChildPrimitive(d,"lines");b.rendNode=d};JXG.VMLRenderer.prototype.updateTicks=function(f,g,b,h,e){var d=[];for(var j=0;j<f.ticks.length;j++){var k=f.ticks[j];if(k.major){if(f.labels[j].show){this.drawLabel(f.labels[j])}d.push(" m "+Math.round(k.scrCoords[1]+g)+", "+Math.round(k.scrCoords[2]-b)+" l "+Math.round(k.scrCoords[1]-g)+", "+Math.round(k.scrCoords[2]+b)+" ")}else{d.push(" m "+Math.round(k.scrCoords[1]+h)+", "+Math.round(k.scrCoords[2]-e)+" l "+Math.round(k.scrCoords[1]-h)+", "+Math.round(k.scrCoords[2]+e)+" ")}}var l=document.getElementById(f.id+"_ticks");if(l==null){l=this.createPrimitive("path",f.id+"_ticks");this.appendChildPrimitive(l,"lines")}l.setAttribute("stroked","true");l.setAttribute("strokecolor",f.visProp.strokeColor,1);l.setAttribute("strokeweight",f.visProp.strokeWidth);this.updatePathPrimitive(l,d,f.board)};JXG.VMLRenderer.prototype.drawArcLine=function(j,b,h,g,d,e){var f=this.createPrimitive("arc",j);f.style.position="absolute";f.setAttribute("filled","false");f.style.left=(d.coords.scrCoords[1]-Math.round(b*e.unitX*e.zoomX))+"px";f.style.top=(d.coords.scrCoords[2]-Math.round(b*e.unitY*e.zoomY))+"px";f.style.width=(Math.round(b*e.unitX*e.zoomX)*2)+"px";f.style.height=(Math.round(b*e.unitY*e.zoomY)*2)+"px";f.setAttribute("startangle",h);f.setAttribute("endangle",g);return f};JXG.VMLRenderer.prototype.drawArcFill=function(b,e,n,j,g,f){var m=this.createPrimitive("shape",b+"_fill");m.setAttribute("stroked","false");var l=Math.round(e*f.unitX*f.zoomX);var k=Math.round(e*f.unitY*f.zoomY);m.style.width=l;m.style.height=k;m.setAttribute("coordsize",l+","+k);var h=this.container.ownerDocument.createElement("v:path");h.setAttribute("id",b+"path");var d="m "+n.coords.scrCoords[1]+","+n.coords.scrCoords[2]+" l ";d+=j.coords.scrCoords[1]+","+j.coords.scrCoords[2]+" at ";d+=(n.coords.scrCoords[1]-l)+","+(n.coords.scrCoords[2]-k)+",";d+=(n.coords.scrCoords[1]+l)+","+(n.coords.scrCoords[2]+k);d+=" "+j.coords.scrCoords[1]+","+j.coords.scrCoords[2];d+=", "+g.coords.scrCoords[1]+","+g.coords.scrCoords[2]+" l ";d+=n.coords.scrCoords[1]+","+n.coords.scrCoords[2]+" x e";h.setAttribute("v",d);m.appendChild(h);return m};JXG.VMLRenderer.prototype.drawArc=function(d){var k=d.getRadius();var b={};b.coords=new JXG.Coords(JXG.COORDS_BY_USER,[d.midpoint.coords.usrCoords[1],d.board.origin.scrCoords[2]/(d.board.unitY*d.board.zoomY)],d.board);var h=d.board.algebra.trueAngle(d.point2,d.midpoint,b);var j=d.board.algebra.trueAngle(d.point3,d.midpoint,b);if(h<j){j-=360}var f=this.drawArcLine(d.id,k,j,h,d.midpoint,d.board);d.rendNode=f;var e=this.getElementById(d.id+"stroke");if(e==null){e=this.container.ownerDocument.createElement("v:stroke");e.setAttribute("id",d.id+"stroke");f.appendChild(e)}if(d.visProp.lastArrow){e.setAttribute("endarrow","block");e.setAttribute("endarrowlength","long")}if(d.visProp.firstArrow){e.setAttribute("startarrow","block");e.setAttribute("startarrowlength","long")}this.setObjectStrokeColor(d,d.visProp.strokeColor,d.visProp.strokeOpacity);this.setObjectStrokeWidth(d,d.visProp.strokeWidth);var g=d.visProp.dash;e.setAttribute("dashstyle",this.dashArray[g]);f.appendChild(e);var l={};l.coords=d.board.algebra.projectPointToCircle(d.point3,d);var m=this.drawArcFill(d.id,k,d.midpoint,d.point2,l,d.board);d.rendNode2=m;this.setObjectFillColor(d,d.visProp.fillColor,d.visProp.fillOpacity);this.appendChildPrimitive(f,"lines");this.appendChildPrimitive(m,"angles");if(d.visProp.draft){this.setDraft(d)}};JXG.AbstractRenderer.prototype.updateArc=function(b){this.remove(b.rendNode);this.remove(b.rendNodeFill);this.remove(b.rendNode2);this.drawArc(b);this.setDraft(b);return};JXG.VMLRenderer.prototype.drawAngle=function(f){var b={};b.midpoint=f.point2;b.getRadius=function(){return f.radius};var q=f.board.algebra.projectPointToCircle(f.point1,b);var o=f.board.algebra.projectPointToCircle(f.point3,b);var d={};d.coords=new JXG.Coords(JXG.COORDS_BY_USER,[f.point2.coords.usrCoords[1],f.board.origin.scrCoords[2]/(f.board.unitY*f.board.zoomY)],f.board);var j=f.board.algebra.trueAngle(f.point1,f.point2,d);var k=f.board.algebra.trueAngle(f.point3,f.point2,d);if(j<k){k-=360}var g=this.drawArcLine(f.id,f.radius,k,j,f.point2,f.board);f.rendNode=g;this.setObjectStrokeColor(f,f.visProp.strokeColor,f.visProp.strokeOpacity);this.setObjectStrokeWidth(f,f.visProp.strokeWidth);var h=f.visProp.dash;var e=this.getElementById(f.id+"stroke");if(e==null){e=this.container.ownerDocument.createElement("v:stroke");e.setAttribute("id",f.id+"stroke");g.appendChild(e)}e.setAttribute("dashstyle",this.dashArray[h]);g.appendChild(e);var n={};n.coords=q;var l={};l.coords=o;var m=this.drawArcFill(f.id,f.radius,f.point2,n,l,f.board);f.rendNode2=m;this.setObjectFillColor(f,f.visProp.fillColor,f.visProp.fillOpacity);this.appendChildPrimitive(g,"lines");this.appendChildPrimitive(m,"angles");if(f.visProp.draft){this.setDraft(f)}if(!f.visProp.visible){f.hideElement(f)}};JXG.VMLRenderer.prototype.updateAngle=function(b){this.remove(b.rendNode);this.remove(b.rendNode2);this.drawAngle(b);return};JXG.VMLRenderer.prototype.drawImage=function(d){var b="data:image/png;base64,"+d.imageBase64String;var e=this.container.ownerDocument.createElement("img");e.style.position="absolute";e.setAttribute("id",d.id);e.setAttribute("src",b);this.container.appendChild(e);this.appendChildPrimitive(e,d.displayLevel);e.style.filter="progid:DXImageTransform.Microsoft.Matrix(M11='1.0', sizingMethod='auto expand')";d.rendNode=e;this.updateImage(d)};JXG.VMLRenderer.prototype.transformImage=function(e,d){var f=e.rendNode;var b=this.joinTransforms(e,d);f.style.left=(e.coords.scrCoords[1]+b[1][0])+"px";f.style.top=(e.coords.scrCoords[2]-e.size[1]+b[2][0])+"px";f.filters.item(0).M11=b[1][1];f.filters.item(0).M12=b[1][2];f.filters.item(0).M21=b[2][1];f.filters.item(0).M22=b[2][2]};JXG.VMLRenderer.prototype.joinTransforms=function(f,e){var b=[[1,0,0],[0,1,0],[0,0,1]];for(var d=0;d<e.length;d++){b=f.board.algebra.matMatMult(e[d].matrix,b)}return b};JXG.VMLRenderer.prototype.transformImageParent=function(d,b){};JXG.VMLRenderer.prototype.removeGrid=function(b){b.hasGrid=false;var d=document.getElementById("gridx");this.remove(d);var d=document.getElementById("gridy");this.remove(d)};JXG.VMLRenderer.prototype.hide=function(b){if(!JXG.IsPoint(b)){var d=b.rendNode;d.style.visibility="hidden";if(b.type==JXG.OBJECT_TYPE_ARC||b.type==JXG.OBJECT_TYPE_ANGLE){d=b.rendNodeFill;d.style.visibility="hidden"}}else{if(b.visProp.style>=3&&b.visProp.style<=9){var d=b.rendNode;d.style.visibility="hidden"}else{var d=b.rendNodeX1;d.style.visibility="hidden";var d=b.rendNodeX2;d.style.visibility="hidden"}}};JXG.VMLRenderer.prototype.show=function(b){if(!JXG.IsPoint(b)){var d=b.rendNode;d.style.visibility="inherit";if(b.type==JXG.OBJECT_TYPE_ARC||b.type==JXG.OBJECT_TYPE_ANGLE){d=b.rendNodeFill;d.style.visibility="inherit"}}else{if(b.visProp.style>=3&&b.visProp.style<=9){var d=b.rendNode;d.style.visibility="inherit"}else{var d=b.rendNodeX1;d.style.visibility="inherit";var d=b.rendNodeX2;d.style.visibility="inherit"}}};JXG.VMLRenderer.prototype.setObjectDash=function(d){if(d.elementClass!=JXG.OBJECT_CLASS_POINT){if(d.type==JXG.OBJECT_TYPE_ANGLE){var e=d.rendNode;var b=d.visProp.dash;e.setAttribute("dashstyle",this.dashArray[b])}else{var e=document.getElementById(d.id+"stroke");if(e){var b=d.visProp.dash;e.setAttribute("dashstyle",this.dashArray[b])}}}};JXG.VMLRenderer.prototype.setObjectStrokeColor=function(f,b,d){var j,h;if(typeof d=="function"){h=d()}else{h=d}h=(h>0)?h:0;if(typeof b=="function"){j=b()}else{j=b}if(f.elementClass!=JXG.OBJECT_CLASS_POINT){if(f.type==JXG.OBJECT_TYPE_TEXT){f.rendNode.style.color=j}else{var g=f.rendNode;g.setAttribute("stroked","true");g.setAttribute("strokecolor",j);var e=this.getElementById(f.id+"stroke");if(e==null){e=this.container.ownerDocument.createElement("v:stroke");e.setAttribute("id",f.id+"stroke");g.appendChild(e)}if(h!=undefined){e.setAttribute("opacity",(h*100)+"%")}}}else{if(f.visProp.style>=3&&f.visProp.style<=9){var g=f.rendNode;g.setAttribute("stroked","true");g.setAttribute("strokecolor",j);var e=this.getElementById(f.id+"stroke");if(e==null){e=this.container.ownerDocument.createElement("v:stroke");e.setAttribute("id",f.id+"stroke");g.appendChild(e)}if(h!=undefined){e.setAttribute("opacity",(h*100)+"%")}}else{var g=f.rendNodeX1;g.setAttribute("stroked","true");g.setAttribute("strokecolor",j);var e=this.getElementById(f.id+"_x1stroke");if(e==null){e=this.container.ownerDocument.createElement("v:stroke");e.setAttribute("id",f.id+"_x1stroke");g.appendChild(e)}if(h!=undefined){e.setAttribute("opacity",(h*100)+"%")}var g=f.rendNodeX2;g.setAttribute("stroked","true");g.setAttribute("strokecolor",j);e=this.getElementById(f.id+"_x2stroke");if(e==null){e=this.container.ownerDocument.createElement("v:stroke");e.setAttribute("id",f.id+"_x2stroke");g.appendChild(e)}if(h!=undefined){e.setAttribute("opacity",(h*100)+"%")}}}};JXG.VMLRenderer.prototype.setObjectFillColor=function(f,b,d){var g;var j,h;if(typeof d=="function"){h=d()}else{h=d}h=(h>0)?h:0;if(typeof b=="function"){j=b()}else{j=b}if(f.elementClass!=JXG.OBJECT_CLASS_POINT){if(f.type==JXG.OBJECT_TYPE_ARC||f.type==JXG.OBJECT_TYPE_ANGLE){var g=document.getElementById(f.id+"_fillnode");if(g==null){g=this.container.ownerDocument.createElement("v:fill");g.setAttribute("id",f.id+"_fillnode");f.rendNode2.appendChild(g)}f.rendNodeFill=g;if(j=="none"){f.rendNode2.setAttribute("filled","false")}else{f.rendNode2.setAttribute("filled","true");f.rendNode2.setAttribute("fillcolor",j)}}else{g=f.rendNode;if(j=="none"){g.setAttribute("filled","false")}else{g.setAttribute("filled","true");g.setAttribute("fillcolor",j)}}}else{if(f.visProp.style>=3&&f.visProp.style<=9){var g=f.rendNode;var e=document.getElementById(f.id+"_fillnode");if(e==null){e=this.container.ownerDocument.createElement("v:fill");e.setAttribute("id",f.id+"_fillnode");g.appendChild(e)}f.rendNodeFill=e;if(j=="none"){g.setAttribute("filled","false")}else{g.setAttribute("filled","true");g.setAttribute("fillcolor",j);if(h!=undefined){e.setAttribute("opacity",(h*100)+"%")}}}else{var g=f.rendNodeX1;if(j=="none"){g.setAttribute("filled","false")}else{g.setAttribute("filled","true");g.setAttribute("fillcolor",j)}var g=f.rendNodeX2;if(j=="none"){g.setAttribute("filled","false")}else{g.setAttribute("filled","true");g.setAttribute("fillcolor",j)}}}if(f.type==JXG.OBJECT_TYPE_POLYGON||f.type==JXG.OBJECT_TYPE_CIRCLE||f.type==JXG.OBJECT_TYPE_ARC||f.type==JXG.OBJECT_TYPE_ANGLE||f.type==JXG.OBJECT_TYPE_CURVE){var e=document.getElementById(f.id+"_fillnode");if(e==null){e=this.container.ownerDocument.createElement("v:fill");e.setAttribute("id",f.id+"_fillnode");if(f.type==JXG.OBJECT_TYPE_ARC||f.type==JXG.OBJECT_TYPE_ANGLE){f.rendNode2.appendChild(e)}else{f.rendNode.appendChild(e)}}f.rendNodeFill=e;if(h!=undefined){e.setAttribute("opacity",(h*100)+"%")}}};JXG.VMLRenderer.prototype.remove=function(b){b.removeNode(true)};JXG.VMLRenderer.prototype.suspendRedraw=function(){this.container.style.display="none"};JXG.VMLRenderer.prototype.unsuspendRedraw=function(){this.container.style.display=""};JXG.VMLRenderer.prototype.setAttributes=function(f,e,j,d){var h;for(var b=0;b<e.length;b++){var g=e[b];if(d[g]!=null){if(typeof d[g]=="function"){h=d[g]();h=(h>0)?h:0}else{h=d[g]}f.setAttribute(j[b],h)}}};JXG.VMLRenderer.prototype.setDashStyle=function(e,d){if(d.dash>=0){var b=this.container.ownerDocument.createElement("v:stroke");b.setAttribute("id",e.id+"stroke");b.setAttribute("dashstyle",this.dashArray[d.dash]);e.appendChild(b)}};JXG.AbstractRenderer.prototype.setObjectStrokeWidth=function(e,d){var b;if(typeof d=="function"){b=d()}else{b=d}if(e.elementClass!=JXG.OBJECT_CLASS_POINT){var f=e.rendNode;this.setPropertyPrimitive(f,"stroked","true");if(b!=null){this.setPropertyPrimitive(f,"stroke-width",b)}}else{if(e.visProp.style>=3&&e.visProp.style<=9){var f=e.rendNode;this.setPropertyPrimitive(f,"stroked","true");if(b!=null){this.setPropertyPrimitive(f,"stroke-width",b)}}else{var f=e.rendNodeX1;this.setPropertyPrimitive(f,"stroked","true");if(b!=null){this.setPropertyPrimitive(f,"stroke-width",b)}var f=e.rendNodeX2;this.setPropertyPrimitive(f,"stroked","true");if(b!=null){this.setPropertyPrimitive(f,"stroke-width",b)}}}};JXG.VMLRenderer.prototype.createPrimitive=function(b,e){var d;if(b=="circle"||b=="ellipse"){d=this.container.ownerDocument.createElement("v:oval")}else{if(b=="polygon"){d=this.container.ownerDocument.createElement("v:shape")}else{if(b=="path"){d=this.container.ownerDocument.createElement("v:shape")}else{d=this.container.ownerDocument.createElement("v:"+b)}}}d.style.position="absolute";d.setAttribute("id",e);return d};JXG.VMLRenderer.prototype.makeArrow=function(e,d,f){var b=this.container.ownerDocument.createElement("v:stroke");b.setAttribute("endarrow","block");b.setAttribute("endarrowlength","long");e.appendChild(b)};JXG.VMLRenderer.prototype.makeArrows=function(d){if(d.visProp.firstArrow){var b=d.rendNodeStroke;if(b==null){b=this.container.ownerDocument.createElement("v:stroke");b.setAttribute("id",d.id+"stroke");b.setAttribute("startarrow","block");b.setAttribute("startarrowlength","long");d.rendNode.appendChild(b);d.rendNodeStroke=b}}else{var b=d.rendNodeStroke;if(b!=null){b.setAttribute("startarrow","none")}}if(d.visProp.lastArrow){var b=d.rendNodeStroke;if(b==null){b=this.container.ownerDocument.createElement("v:stroke");d.rendNode.appendChild(b);d.rendNodeStroke=b}b.setAttribute("id",d.id+"stroke");b.setAttribute("endarrow","block");b.setAttribute("endarrowlength","long")}else{var b=d.rendNodeStroke;if(b!=null){b.setAttribute("endarrow","none")}}};JXG.VMLRenderer.prototype.updateLinePrimitive=function(g,d,b,f,e){g.setAttribute("from",[d,b].join(","));g.setAttribute("to",[f,e].join(","))};JXG.VMLRenderer.prototype.updateCirclePrimitive=function(e,b,f,d){e.style.left=(b-d)+"px";e.style.top=(f-d)+"px";e.style.width=(d*2)+"px";e.style.height=(d*2)+"px"};JXG.VMLRenderer.prototype.updateRectPrimitive=function(f,b,g,d,e){f.style.left=(b)+"px";f.style.top=(g)+"px";f.style.width=(d)+"px";f.style.height=(e)+"px"};JXG.VMLRenderer.prototype.updateEllipsePrimitive=function(d,b,g,f,e){d.style.left=(b-f)+"px";d.style.top=(g-e)+"px";d.style.width=(f*2)+"px";d.style.height=(e*2)+"px"};JXG.VMLRenderer.prototype.updatePathPrimitive=function(e,f,d){var b=d.canvasWidth;var g=d.canvasHeight;e.style.width=b;e.style.height=g;e.setAttribute("coordsize",b+","+g);e.setAttribute("path",f.join(""))};JXG.VMLRenderer.prototype.updatePathStringPrimitive=function(g){if(g.numberPoints<=0){return""}var l=" m ";var k=[];var f=100*g.board.canvasHeight;var d=100*g.board.canvasWidth;var b=Math.min(g.numberPoints,8192);for(var e=0;e<b;e++){var j=g.points[e].scrCoords;if(isNaN(j[1])||isNaN(j[2])||Math.abs(j[1])>d||Math.abs(j[2])>f){l=" m "}else{k.push(l+j[1]+", "+j[2]);l=" l "}}k.push(" e");return k};JXG.VMLRenderer.prototype.updatePolygonePrimitive=function(g,e){g.setAttribute("stroked","false");var h=e.vertices[0].coords.scrCoords[1];var d=e.vertices[0].coords.scrCoords[1];var f=e.vertices[0].coords.scrCoords[2];var b=e.vertices[0].coords.scrCoords[2];for(var j=1;j<e.vertices.length-1;j++){var n=e.vertices[j].coords.scrCoords;if(n[1]<h){h=n[1]}if(n[1]>d){d=n[1]}if(n[2]<f){f=n[2]}if(n[2]>b){b=n[2]}}var m=Math.round(d-h);var l=Math.round(b-f);g.style.width=m;g.style.height=l;g.setAttribute("coordsize",m+","+l);var k=[];k.push("m ");var n=e.vertices[0].coords.scrCoords;k.push(n[1]+","+n[2]);k.push(" l ");for(var j=1;j<e.vertices.length-1;j++){var n=e.vertices[j].coords.scrCoords;k.push(n[1]+","+n[2]);if(j<e.vertices.length-2){k.push(", ")}}k.push(" x e");g.setAttribute("path",k.join(""))};JXG.VMLRenderer.prototype.appendChildPrimitive=function(b,d){switch(d){case"images":b.style.zIndex="1";break;case"grid":b.style.zIndex="1";break;case"angles":b.style.zIndex="2";break;case"sectors":b.style.zIndex="2";break;case"polygone":b.style.zIndex="2";break;case"curves":b.style.zIndex="4";break;case"circles":b.style.zIndex="4";break;case"lines":b.style.zIndex="4";break;case"arcs":b.style.zIndex="4";break;case"points":b.style.zIndex="5";break}this.container.appendChild(b)};JXG.VMLRenderer.prototype.setPropertyPrimitive=function(g,f,h){var e="";switch(f){case"stroke":e="strokecolor";break;case"stroke-width":e="strokeweight";break;case"stroke-dasharray":e="dashstyle";break}if(f=="stroke-dasharray"){var b=this.container.ownerDocument.createElement("v:stroke");b.setAttribute("id",g.id+"stroke");b.setAttribute("dashstyle","Dash");g.appendChild(b)}else{if(e!=""){var d;if(typeof h=="function"){d=h()}else{d=h}g.setAttribute(e,d)}}};JXG.VMLRenderer.prototype.drawVerticalGrid=function(f,d,h,e){var g=this.createPrimitive("path","gridx");var b=[];while(f.scrCoords[1]<d.scrCoords[1]+h-1){b.push(" m "+f.scrCoords[1]+", "+0+" l "+f.scrCoords[1]+", "+e.canvasHeight+" ");f.setCoordinates(JXG.COORDS_BY_SCREEN,[f.scrCoords[1]+h,f.scrCoords[2]])}this.updatePathPrimitive(g,b,e);return g};JXG.VMLRenderer.prototype.drawHorizontalGrid=function(f,d,h,e){var g=this.createPrimitive("path","gridy");var b=[];while(f.scrCoords[2]<=d.scrCoords[2]+h-1){b.push(" m "+0+", "+f.scrCoords[2]+" l "+e.canvasWidth+", "+f.scrCoords[2]+" ");f.setCoordinates(JXG.COORDS_BY_SCREEN,[f.scrCoords[1],f.scrCoords[2]+h])}this.updatePathPrimitive(g,b,e);return g};