<?php

/**
 * 子比主题
 * Zibll Theme
 * 官方网站：http://www.yunziyuan.com.cn/
 * 作者QQ：770349780
 * 感谢您使用子比主题，主题源码有详细的注释，支持二次开发
 * 如您需要定制功能、或者其它任何交流欢迎加QQ
 */

if ('POST' != $_SERVER['REQUEST_METHOD']) {
    header('Allow: POST');
    header('HTTP/1.1 405 Method Not Allowed');
    header('Content-Type: text/plain');
    echo '错误请求';
    exit;
}

require(dirname(__FILE__) . '/../../../../wp-load.php');

function err($ErrMsg)
{
    header('HTTP/1.1 405 Method Not Allowed');
    echo $ErrMsg;
    exit;
}

if (!empty($_POST['action'])) {
    if (empty($_POST['comment_id'])) {
        echo (json_encode(array('error' => 1, 'ys' => 'danger', 'msg' => '数据传入出错')));
        exit();
    }
    $comment_id = absint($_POST['comment_id']);
    $comment = get_comment($comment_id);
    if (!$comment) {
        echo (json_encode(array('error' => 1, 'ys' => 'danger', 'msg' => '查找数据出错')));
        exit();
    }

    if ((!_pz('user_edit_comment','true') || $comment->user_id!=get_current_user_id()) && !is_super_admin()) {
        echo (json_encode(array('error' => 1, 'ys' => 'danger', 'msg' => '编辑权限不足')));
        exit();
    }
    if ('trash' == $comment->comment_approved) {
        echo (json_encode(array('error' => 1, 'ys' => 'danger', 'msg' => '评论已删除')));
        exit();
    }
    if ($_POST['action'] == 'get_comment') {
        echo json_encode(get_comment($comment));
        exit;
    }
    if ($_POST['action'] == 'trash_comment') {
        if(wp_trash_comment( $comment )){
            echo (json_encode(array('msg' => '评论已删除')));
        }else{
            echo (json_encode(array('error' => 1, 'ys' => 'danger', 'msg' => '操作失败')));
        }
        exit;
    }
}

if (!empty($_POST['edit_comment_ID'])) {

    $commentarr = array(
        'comment_ID' => $_POST['edit_comment_ID'],
        'comment_post_ID' => $_POST['comment_post_ID'],
        'comment_content' => $_POST['comment'],
    );
    $comment_id = absint($_POST['edit_comment_ID']);
    $lod_comment = get_comment($comment_id);
    if ($lod_comment->comment_content == $_POST['comment']) {
        err('内容未修改');
        exit;
    }
    $comment = wp_update_comment($commentarr);
    if (!$comment) {
        err('更新失败');
    }
    $con =  preg_replace('/\[img=(.*?)\]/', '<img class="box-img lazyload" src="$1">', convert_smilies($_POST['comment']));

    if (_pz('lazy_comment')) {
        $con =  str_replace(' src=', ' src="' . zib_default_thumb() . '" data-src=', $con);
    }
    $con =  preg_replace('/\[g=(.*?)\]/', '<img class="smilie-icon" src="' . get_stylesheet_directory_uri() . '/img/smilies/$1.gif">', $con);
    echo $con;
    exit;
}

$comment = wp_handle_comment_submission(wp_unslash($_POST));
if (is_wp_error($comment)) {
    $data = $comment->get_error_data();
    if (!empty($data)) {
        err($comment->get_error_message());
    } else {
        exit;
    }
}
$user = wp_get_current_user();
do_action('set_comment_cookies', $comment, $user);

zib_get_comments_list($comment);

exit;
