<?php
$functions = array(
    'user',
    'sign_register'
);

foreach ($functions as $function) {
    require_once $function . '.php';
}

/**设置验证码 */
function zib_get_captcha($counts = 6)
{
    $originalcode = '0,1,2,3,4,5,6,7,8,9';
    $originalcode = explode(',', $originalcode);
    $countdistrub = 10;
    $_dscode      = "";
    for ($j = 0; $j < $counts; $j++) {
        $dscode = $originalcode[rand(0, $countdistrub - 1)];
        $_dscode .= $dscode;
    }
    return strtolower($_dscode);
}

/**发送验证码 */
function zib_send_captcha($to, $type = 'email', $title = '', $message = '')
{
    session_start();
    $code = zib_get_captcha(6);
    /**保存验证码到缓存 */
    $_SESSION['zib_captcha'] = $code;
    $_SESSION['zib_verification_to'] = $to;

    $send = '';
    $result = false;
    $blog_name = get_bloginfo('name');

    if (filter_var($to, FILTER_VALIDATE_EMAIL)) {
        $title = '[' . $blog_name . ']' . $title;
        $send .= $message . "\r\n\r\n";
        $send .= '您的邮箱为：' . $to . "\r\n\r\n";
        $send .= '您的验证码为：';
        $send .= '<p style="font-size:34px;color:#3095f1;"><span style="border-bottom: 1px dashed rgb(204, 204, 204); z-index: 1; position: static;">' . $code . '</span></p>';

        $result = wp_mail($to, $title, $send);
    }

    return $result;
}
/**验证码效验 */
function zib_is_captcha($to, $code)
{

    if (empty($_SESSION['zib_captcha']) || $_SESSION['zib_captcha'] != $code || empty($_SESSION['zib_verification_to']) || $_SESSION['zib_verification_to'] != $to) {
        return false;
    } else {
        return true;
    }
}

/**前端AJAX发送验证码 */
function zib_ajax_signup_captcha()
{
    header('Content-type:application/json; Charset=utf-8');
    $captcha = !empty($_POST['captcha_type']) ? $_POST['captcha_type'] : 'email';

    switch ($captcha) {
        case 'email':
            if (empty($_POST['email'])) {
                echo json_encode(array('error' => 1, 'msg' => '请输入邮箱帐号'));
                exit;
            }
            global $wpdb;
            $user_email = !empty($_POST['email']) ? esc_sql($_POST['email']) : null;
            $user_email = apply_filters('user_registration_email', $user_email);
            $user_email = $wpdb->_escape(trim($user_email));

            if (email_exists($user_email) && empty($_POST['repeat'])) {
                echo json_encode(array('error' => 1, 'msg' => '邮箱已存在'));
                exit;
            }
            $send = zib_send_captcha($user_email, 'email', '收到验证码', '您正在本站进行验证操作，如非您本人操作，请忽略此邮件。验证码30分钟内有效，如果超时请重新获取');
            if ($send) {
                echo json_encode(array('error' => 0, 'msg' => '验证码已发送，请在邮箱查看'));
                exit;
            } else {
                echo json_encode(array('error' => 1, 'msg' => '验证码发送失败'));
                exit;
            }
            break;
    }
}
add_action('wp_ajax_signup_captcha', 'zib_ajax_signup_captcha');
add_action('wp_ajax_nopriv_signup_captcha', 'zib_ajax_signup_captcha');



/**前端AJAX链接提交 */
function zib_ajax_frontend_links_submit()
{

    if (isset($_COOKIE['zib_links_submit_time'])) {
        echo (json_encode(array('error' => 1, 'ys' => 'danger', 'msg' => '操作过于频繁，请稍候再试')));
        exit();
    }
    if (empty($_POST['link_name'])) {
        echo (json_encode(array('error' => 1, 'ys' => 'danger', 'msg' => '请填写链接名称')));
        exit();
    }
    if (empty($_POST['link_url'])) {
        echo (json_encode(array('error' => 1, 'ys' => 'danger', 'msg' => '请填写链接地址')));
        exit();
    }
    /**准备数据 */
    $linkdata = array(
        'link_name'   => esc_attr($_POST['link_name']),
        'link_url'    => esc_url($_POST['link_url']),
        'link_description' => !empty($_POST['link_description']) ? esc_attr($_POST['link_description']) : '',
        'link_image' => !empty($_POST['link_image']) ? esc_attr($_POST['link_image']) : '',
        'link_visible' => 'N'
    );
    /**添加链接 */
    $links_id = wp_insert_link($linkdata);
    if (is_wp_error($links_id)) {
        echo (json_encode(array('error' => 1, 'ys' => 'danger', 'msg' => $links_id->get_error_message())));
        exit();
    }
    //设置浏览器缓存限制提交的间隔时间
    $expire = time() + 30;
    setcookie('zib_links_submit_time', time(), $expire, '/', '', false);

    /**添加执行挂钩 */
    do_action('zib_ajax_frontend_links_submit', $_POST);
    echo (json_encode(array('msg' => '提交成功，等待管理员处理')));
    exit();
}
add_action('wp_ajax_frontend_links_submit', 'zib_ajax_frontend_links_submit');
add_action('wp_ajax_nopriv_frontend_links_submit', 'zib_ajax_frontend_links_submit');


//上传图像
function zib_php_upload($file='file')
{
    if (empty($_FILES)) {
        return array('error' => 1, '_FILES' => '' , 'msg' => '图片信息错误，请重新选择图片');
    }

    if ($_FILES) {
        require_once(ABSPATH . "wp-admin" . '/includes/image.php');
        require_once(ABSPATH . "wp-admin" . '/includes/file.php');
        require_once(ABSPATH . "wp-admin" . '/includes/media.php');
            $attach_id = media_handle_upload($file, 0);
        if (is_wp_error($attach_id)) {
            return array('error' => 1, '_FILES' => $_FILES , 'msg' => $attach_id->get_error_message());
        } else {
            return $attach_id;
        }
    }
}

/**评论上传图片 */
function zib_ajax_comment_upload_img()
{

    $cuid = get_current_user_id();
    if (!$cuid) {
        echo (json_encode(array('error' => 1,'error_id' => 'nologged', 'ys' => 'danger', 'msg' => '请先登录')));
        exit;
    }
    if (!wp_verify_nonce($_POST['comment_upload_img_nonce'], 'comment_upload_img')) {
        echo (json_encode(array('error' => 1, 'ys' => 'danger', 'msg' => '安全验证失败，请稍候再试')));
        exit();
    }

    //开始上传
    $img_id = zib_php_upload();
    if (!empty($img_id['error'])) {
        echo (json_encode(array('error' => 1, 'ys' => 'danger', 'msg' => $img_id['msg'])));
        exit();
    }
    $img_url = wp_get_attachment_image_src($img_id, 'large')[0];

    echo (json_encode(array('error' => '', 'ys' => '', 'msg' => '图片已插入','img_url' => $img_url)));
    exit();
}
add_action('wp_ajax_comment_upload_img', 'zib_ajax_comment_upload_img');
add_action('wp_ajax_nopriv_frontend_links_submit', 'zib_ajax_frontend_links_submit');





