<?php

/**
 * 子比主题
 * Zibll Theme
 * 官方网站：http://www.yunziyuan.com.cn/
 * 作者QQ：770349780
 * 感谢您使用子比主题，主题源码有详细的注释，支持二次开发
 * 如您需要定制功能、或者其它任何交流欢迎加QQ
 */


/**用户登录 */
function zib_ajax_user_signup()
{
    if (_new_strlen($_POST['password2']) < 6) {
        echo(json_encode(array('error' => 1, 'msg' => '密码太短,至少6位')));
        exit();
    }

    if ($_POST['password2'] !== $_POST['repassword']) {
        echo(json_encode(array('error' => 1, 'msg' => '两次密码输入不一致')));
        exit();
    }

    if (_pz('user_verification')) {
        if (_new_strlen($_POST['canvas_yz']) < 4) {
            echo(json_encode(array('error' => 1, 'msg' => '请输入图形验证码')));
            exit();
        }
    }
    if (is_user_logged_in()) {
        echo(json_encode(array('error' => 1, 'msg' => '你已经登录，请刷新页面')));
        exit;
    }
    if (!filter_var($_POST['email'], FILTER_VALIDATE_EMAIL)) {
        echo(json_encode(array('error' => 1, 'msg' => '邮箱格式错误')));
        exit();
    }
    $captch = _pz('user_signup_captch');

    if ($captch) {
        session_start();
        if (empty($_POST['captch'])) {
            echo(json_encode(array('error' => 1, 'msg' => '请输入验证码')));
            exit();
        }
        if (!zib_is_captcha($_POST['email'], $_POST['captch'])) {
            echo (json_encode(array('error' => 1, 'msg' => '验证码错误')));
            exit();
        }
    }

    if (is_disable_username($_POST['name'])) {
        echo(json_encode(array('error' => 1, 'msg' => '昵称含保留或非法字符')));
        exit();
    }
    if (_pz('no_repetition_name', true)) {
        $db_name = '';
        global $wpdb;
        $db_name = $wpdb->get_var("SELECT id FROM $wpdb->users WHERE `user_nicename`='" . $_POST['name'] . "' OR `display_name`='" . $_POST['name'] . "' ");

        if ($db_name) {
            echo (json_encode(array('error' => 1, 'ys' => 'danger', 'msg' => '昵称已经存在，请换一个试试')));
            exit();
        }
    }
    $status = wp_create_user($_POST['name'], $_POST['password2'], $_POST['email']);

    if (is_wp_error($status)) {
        if (!empty($err['existing_user_login'])) {
            echo(json_encode(array('error' => 1, 'wp_error' => json_encode($status), 'msg' => '用户名已存在，换一个试试')));
            exit();
        } else if (!empty($err['existing_user_email'])) {
            echo(json_encode(array('error' => 1, 'wp_error' => json_encode($status), 'msg' => '邮箱已存在，您可以尝试找回密码')));
            exit();
        }
        echo(json_encode(array('error' => 1, 'wp_error' => json_encode($status), 'msg' =>  $status->get_error_message())));
        exit();
    }

    //登录
    $user = get_user_by('id', $status);
    wp_set_current_user($status, $user->user_login);
    wp_set_auth_cookie($status, true);
    do_action('wp_login', $user->user_login, $user);

    echo(json_encode(array('error' => 0, 'msg' => '注册成功，欢迎您：' . $_POST['name'])));
    exit();
}
add_action('wp_ajax_user_signup', 'zib_ajax_user_signup');
add_action('wp_ajax_nopriv_user_signup', 'zib_ajax_user_signup');

/**用户登录 */
function zib_ajax_user_signin()
{

    if (empty($_POST['username'])) {
        echo(json_encode(array('error' => 1, 'msg' => '请输入用户名')));
        exit();
    }
    if (empty($_POST['password'])) {
        echo(json_encode(array('error' => 1, 'msg' => '请输入密码')));
        exit();
    }
    if (_pz('user_verification')) {
        if (_new_strlen($_POST['canvas_yz']) < 4) {
            echo(json_encode(array('error' => 1, 'msg' => '请输入图形验证码')));
            exit();
        }
    }

    if (is_user_logged_in()) {
        echo(json_encode(array('error' => 1, 'msg' => '你已经登录，请刷新页面')));
        exit;
    }

    if (!filter_var($_POST['username'], FILTER_VALIDATE_EMAIL)) {
        $user_data = get_user_by('login', $_POST['username']);
        if (empty($user_data)) {
            echo(json_encode(array('error' => 1, 'msg' => '用户名或密码错误')));
            exit();
        }
    } else {
        $user_data = get_user_by('email', $_POST['username']);
        if (empty($user_data)) {
            echo(json_encode(array('error' => 1, 'msg' => '邮箱或密码错误')));
            exit();
        }
    }

    $username = $user_data->user_login;

    if ($_POST['remember']) $_POST['remember'] = "true";
    else $_POST['remember'] = "false";

    $login_data = array(
        'user_login' => $username,
        'user_password' => $_POST['password'],
        'remember' => $_POST['remember']
    );

    $user_verify = wp_signon($login_data);

    if (is_wp_error($user_verify)) {
        echo(json_encode(array('error' => 1, 'msg' => '帐号或密码错误')));
        exit();
    }

    echo(json_encode(array('error' => 0, 'msg' => '成功登录，页面跳转中')));
    exit();
}
add_action('wp_ajax_user_signin', 'zib_ajax_user_signin');
add_action('wp_ajax_nopriv_user_signin', 'zib_ajax_user_signin');







