<?php
function zib_comments_list($comment, $args, $depth)
{
	$GLOBALS['comment'] = $comment;
	global $commentcount, $wpdb, $post;
	zib_get_comments_list($comment, $depth);
}

function zib_get_comments_list($comment, $depth = 0)
{

	if (!$comment) return false;
	$user_id = $comment->user_id;
	$c_like = zib_get_comment_like('action action-comment-like pull-right muted-2-color', $comment->comment_ID);
    $vip_icon = '';
    if($user_id){
        $vip_icon = zibpay_get_vip_icon(zib_get_user_vip_level($user_id),"");
        $vip_icon = $vip_icon ? '<div class="avatar-icontag">'.$vip_icon.'</div>' : '';
    }
	echo '<li '.comment_class('', null, null, false).' id="comment-' . get_comment_ID() . '">';
	echo '<ul class="list-inline">';
	if (!$comment->comment_parent > 0) {
		echo '<li>';
		echo '<div class="comt-avatar relative">' . zib_get_data_avatar($user_id) . $vip_icon.'</div>';
		echo '</li>';
	}
	echo '<li class="comt-main" id="div-comment-' . get_comment_ID() . '">';
	$con =  preg_replace('/\[img=(.*?)\]/', '<img class="box-img lazyload" src="$1">', convert_smilies($comment->comment_content));

	if (_pz('lazy_comment')) {
		$con =  str_replace(' src=', ' src="' . zib_default_thumb() . '" data-src=', $con);
	}
	$con =  preg_replace('/\[g=(.*?)\]/', '<img class="smilie-icon" src="' . get_stylesheet_directory_uri() . '/img/smilies/$1.gif">', $con);

	$author_link  = '<strong class="mr6">' . $comment->comment_author . '</strong>';
	if ($user_id) {
		$author_link = '<a href="' . get_author_posts_url($user_id) . '">' . $author_link . '</a>';

		if ($user_id ==  get_the_author_meta('ID')&&_pz('comment_author_tag',true)) {
			$author_link  .= '<span class="badg c-red hollow badg-sm">作者</span>';
		}

	}
	if ($comment->comment_parent > 0) {
		$author_link = '<div class="comt-avatar-mini mr10 relative">' . zib_get_data_avatar($user_id) .$vip_icon. '</div>' . $author_link;
	}
	if ($comment->comment_approved == '0') {
		$author_link .= '<span class="badg c-red badg-sm ml6">待审核</span>';
	}

	echo '<div class="comt-avatar-name  mb10">' . $author_link . $c_like . '</div>';
	echo '<div class="mb10 comment-content">' . $con . '</div>';
	echo '<div class="comt-meta muted-2-color">';

	echo '<span class="comt-author">';
	echo zib_get_time_ago($comment->comment_date);
	echo '</span>';

	if ($comment->comment_parent > 0) {
		echo '<span>@<a rel="nofollow" class="url" href="javascript:(scrollTo(\'#comment-' . $comment->comment_parent . '\',-70));">' . get_comment_author($comment->comment_parent) . '</a></span>';
	}

	$max_depth = get_option('thread_comments_depth');
	if ($comment->comment_approved !== '0' && $depth) {
		$replyText = get_comment_reply_link(array('add_below' => 'div-comment', 'reply_text' => '回复','login_text'=>'回复', 'depth' => $depth, 'max_depth' => $max_depth),$comment->comment_ID);
		if (strstr($replyText, 'reply-login')) {
			$replyText =  preg_replace('# class="[\s\S]*?" href="[\s\S]*?"#', ' class="signin-loader" href="javascript:;"', $replyText);
		} else {
			$replyText =  preg_replace('# aria-label=#', ' data-toggle="tooltip" data-original-title=', $replyText);
		}
		echo '<span>' . $replyText . '</span>';
	}

	$edit_but = '<span class="pull-right px12"><a class="but comment-edit-link" data-commentid="'.$comment->comment_ID.'" data-postid="'.$comment->comment_post_ID.'" href="javascript:;">编辑</a></span>';
	$trash_but = '<span class="pull-right px12"><a class="but comment-trash-link" data-commentid="'.$comment->comment_ID.'" data-postid="'.$comment->comment_post_ID.'" href="javascript:;">删除</a></span>';
	if((_pz('user_edit_comment','true') && $user_id==get_current_user_id())||is_super_admin()){
		echo $trash_but.$edit_but;
	}

	echo '</div>';
	echo '</li>';
	echo '</ul>';
	//echo '</li>';
}

function zib_comments_author_list($comment, $args = '')
{
	if (!$comment) return false;
	$c_like = zib_get_comment_like('action action-comment-like pull-right muted-2-color', $comment->comment_ID);

	$cont =  preg_replace('/\[img=(.*?)\]/', '<img class="box-img" src="$1">', convert_smilies($comment->comment_content));
	$cont =  preg_replace('/\<img(.*?)\>/', '[图片]', $cont);
	$cont =  preg_replace('/\[g=(.*?)\]/', '<img class="smilie-icon" src="' . get_stylesheet_directory_uri() . '/img/smilies/$1.gif">', $cont);
	$_link = get_comment_link($comment->comment_ID);
	$post_title = get_the_title( $comment->comment_post_ID );
	$post_tlink = get_the_permalink( $comment->comment_post_ID );

	$time = $comment->comment_date;
	$approved = '';
	$parent = '';
	$post = '<a class="muted-color" href="'.$post_tlink .'">'.$post_title.'</a>';

	$cont = '<a href="'.$_link .'">'.$cont.'</a>';
	if ($comment->comment_parent > 0) {
		$parent = '<span class="mr10" >@' . get_comment_author($comment->comment_parent) . '</span>';
	}

	if ($comment->comment_approved == '0') {
		$approved = '<span class="badg c-red badg-sm mr6">待审核</span>';
	}

	$time = zib_get_time_ago($comment->comment_date);

	echo '<div class="list-inline">';
	echo '<div class="author-set-left muted-2-color">';
	echo $time;
	echo '</div>';

	echo '<div class="author-set-right">';
	echo '<div class="mb10 comment-content">';
	echo $approved.$cont;

	echo '</div>';
	echo '<span class="muted-2-color em09">';
	echo $parent.'评论于：'.$post;

	echo '</span>';
	echo '</div>';

	echo '</div>';
}


function zib_widget_comments($limit, $outpost, $outer)
{
	global $wpdb;
	$args = array(
		'number' => $limit,
		'orderby' => 'comment_date',
		'number' => $limit,
		'status' => 'approve',
		'author__not_in' =>  preg_split("/,|，|\s|\n/", $outer),
		'post__not_in' =>  preg_split("/,|，|\s|\n/", $outpost),
	);

	$comments = get_comments( $args );;

	$output = '';
	foreach ($comments as $comment) {
		$cont =  preg_replace('/\[img=(.*?)\]/', '<img class="box-img" src="$1">', convert_smilies(strip_tags($comment->comment_content)));
		$cont =  preg_replace('/\<img(.*?)\>/', '[图片]', $cont);
		$cont =  preg_replace('/\[g=(.*?)\]/', '<img class="smilie-icon" src="' . get_stylesheet_directory_uri() . '/img/smilies/$1.gif">', $cont);
		$_link = get_comment_link($comment->comment_ID);
		$post_title = $comment->post_title;
		$post_link = get_the_permalink($comment->ID);

		$time = zib_get_time_ago($comment->comment_date);

		$user_name = $comment->comment_author;
		$user_id = $comment->user_id;
		$c_like = zib_get_comment_like('action action-comment-like pull-right muted-2-color', $comment->comment_ID);
		$vip_icon = '';

		if ($user_id) {
			$user_name = '<a href="' . get_author_posts_url($user_id) . '">' . $user_name . '</a>';
			$vip_icon = zibpay_get_vip_icon(zib_get_user_vip_level($user_id),"");
			$vip_icon = $vip_icon ? '<div class="avatar-icontag">'.$vip_icon.'</div>' : '';
		}
		$avatar = '<div class="avatar-img relative">' . zib_get_data_avatar($user_id, '22') .$vip_icon. '</div>';


		echo '<div class="posts-mini">';
		echo $avatar;
		echo '<div class="comment-con em09">';
		echo '<p>';
		echo $user_name;
		echo '<span class="icon-spot muted-3-color">' . $time . '</span>';
		echo '<span class="pull-right">' . $c_like . '</span>';
		echo '</p>';

		echo '<a class="muted-color" href="' . $_link . '">' . $cont . '</a>';
		echo '</div>';
		echo '</div>';
	}
};

