<?php
function zib_get_page_header($post_id='')
{
    if(!$post_id){
        global $post;
        $post_id = $post->ID;
    }
    $header_style = zib_get_page_header_style($post_id);
    if (!$header_style) return;
    $title = get_the_title($post_id);
    $html = '';
    if($header_style == 1){
        $html = '<div class="box-body notop"><h3 class="title-h-center text-center mt10">'.$title.'</h3></div>';
    }elseif($header_style == 2){
        $html = '<div class="zib-widget"><div><h3 class="title-h-center text-center">'.$title.'</h3></div></div>';
    }elseif($header_style == 3){
        $img = '';
        $post_thumbnail_id = get_post_thumbnail_id( $post_id );
        if($post_thumbnail_id){
            $image = wp_get_attachment_image_src( $post_thumbnail_id, 'full');
            $img = !empty($image[0]) ? $image[0] : '';
        }

        $src = get_stylesheet_directory_uri() . '/img/thumbnail-lg.svg';
        $img = $img ? $img : _pz('page_header_cover_img', get_stylesheet_directory_uri() . '/img/user_t.jpg');
        $html = '<div class="page-cover theme-box radius8 main-shadow">
        <img class="fit-cover no-scale lazyload" '. (_pz('lazy_cover', true) ? 'src="' . $src . '" data-src="' . $img . '"' : 'src="' . $img . '"').'>
        <div class="absolute page-mask"></div>
            <div class="list-inline box-body abs-center text-center">
                <div class="title-h-center">
                    <h3>'.$title.'</h3>
                </div>
            </div>
        </div>';
    }

    return $html;
}

function zib_get_page_header_style($post_id='')
{
    if(!$post_id){
        global $post;
        $post_id = $post->ID;
    }
    $header_style = get_post_meta($post_id, 'page_header_style', true);
    if (!$header_style) $header_style=_pz('page_header_style');
    return $header_style;
}