<?php
/*
	项目管理
*/
defined('BY_JYA') or exit('error');
$_RQ['op']=$_RQ['op']?$_RQ['op']:'list';
$return=array();
//声明页面上方tab按钮
$tabs=array(
	array('op'=>'list','title'=>'项目列表'),
	array('op'=>'edit','title'=>'添加/编辑项目'),
);
set_html('tabs',$tabs);
//声明列表页
if($_RQ['op']=='list'){
	//初始化返回前端的筛选条件数组
	$return['params']=array();
	//整理列表数据查询条件
	$params=array('uniacid'=>$_SESSION['uniacid'],'store_id'=>$store_id);
	$psize=15;
	$pindex=intval($_RQ['page'])?:1;
	$parameter=array(
		'params'=>$params,
		'limit'=>array($pindex,$psize),
		'orderby'=>'id desc',
	);
	//执行分页查询
	$list=$this->get_list('store_serve',$parameter,$total);
	if($list){
		foreach($list as &$item){
			$goods=$this->pdo_get('serve',array('id'=>$item['serve_id']));
			$item=array_merge($goods,$item);
		}
	}
	//将查询到的结果数组放入$return以备传回前端
	$return['list']=$list;
	//整理分页
	$return['totalpage'] =intval(ceil($total/$psize));
	$return['params']['page'] =$pindex;
	//声明列表页样式数组
	$htmls=array(
		'type'=>'list',
		//'export'=>'export',//声明导出动作op，如无需导出功能，可不声明该字段
		'list'=>array('data'=>'list','list'=>array(
			//列表展示列
			array('name'=>'title','title'=>'项目名称','type'=>'string'),
			array('name'=>'image','title'=>'项目图片','type'=>'image'),
			array('name'=>'status','title'=>'是否上架','type'=>'switch','set'=>'set'),
			array('name'=>'total','title'=>'项目数量','type'=>'string'),
		),'action'=>array(
			array('type'=>'modal','op'=>'change','title'=>'增加库存'),
		)),
		'search'=>array(
			//列表查询表单
			array('type'=>'choose','width'=>15,'name'=>'serve_id','title'=>'项目ID','action'=>'serve/choose'),
		),
	);
	$return['htmls']=$htmls;
	//把数据返回前端
	exi($return);
}
//修改库存
if($_RQ['op']=='change'){
	if($_RQ['postdata']){
		$post=get_postdata();
		$id=intval($post['id']);
		
		$add=intval($post['add']);
		if(!$id || !$add){
			exi('增加库存失败，未选择项目或者未设置增加数量！','error');
		}
		$this->pdo_update('store_serve',array('total +='=>$add),array('id'=>$id,'uniacid'=>$_SESSION['uniacid'],'store_id'=>$store_id));
		exi('库存增加成功！');
	}
	$id=intval($_RQ['id']);
	$item=$this->pdo_get('store_serve',array('id'=>$id,'uniacid'=>$_SESSION['uniacid'],'store_id'=>$store_id),array('id','total'));
	if(!$item){
		exi('未选择项目或者指定项目不存在！','error');
	}
	$return['item']=$item;
	$return['htmls']=array(
		'type'=>'edit',
		'desc'=>'增加库存',
		'edit'=>array(
			array('type'=>'string','name'=>'total','title'=>'当前库存','read'=>true),
			array('type'=>'string','name'=>'add','title'=>'增加数量'),
		),
	);
	exi($return);
}
//声明编辑页
if($_RQ['op']=='edit'){
	$id=intval($_RQ['id']);
	//编辑页表单项数组
	$edit_fields=array(
		array('type'=>'choose','action'=>'jy_meye/serve/choose/','name'=>'serve_id','title'=>'选择项目','must'=>true,'read'=>$id?true:false),
		array('type'=>'string','name'=>'total','title'=>'设置库存'),
		array('type'=>'switch','name'=>'status','title'=>'是否上架'),
		array('type'=>'string','name'=>'display','title'=>'排序','help'=>'填写数字，数字越大越靠前'),
	);
	if($_RQ['postdata']){
		//处理表单提交
		$post=get_postdata($edit_fields);
		//获取表单数据
		$data=array_fields(array('total','status','display'),$post);
		//将数组类型表单数据转为字符串以备入库
		$id=intval($post['id']);
		if($id){
			//更新数据
			$this->pdo_update('store_serve',$data,array('id'=>$id,'uniacid'=>$_SESSION['uniacid']));
			exi('修改成功！','','list');
		}else{
			//插入数据
			$check=$this->pdo_getcolumn('store_serve',array('uniacid'=>$_SESSION['uniacid'],'store_id'=>$store_id,'serve_id'=>$post['serve_id']),'id');
			if($check){
				exi('该项目已添加，请勿重复添加！','error');
			}
			//声明插入数据时的默认内容
			$insert=array(
				'uniacid'=>$_SESSION['uniacid'],
				'store_id'=>$store_id,
				'serve_id'=>$post['serve_id'],
				'createtime'=>TIMESTAMP,
			);
			$insert=array_merge($insert,$data);
			$this->pdo_insert('store_serve',$insert);
			exi('添加成功！','','list');
		}
	}
	//整理编辑页
	
	if($id){
		//如果有ID表示编辑已有数据，此处获取已有数据
		$item=$this->pdo_get('store_serve',array('id'=>$id,'uniacid'=>$_SESSION['uniacid']));
		
	}else{
		$item=array();
	}
    $return['item']=$item;
	//声明表单页样式数组
	$htmls=array(
		'type'=>'edit',
		'desc'=>'项目设置',
		'edit'=>$edit_fields,
	);
	$return['htmls']=$htmls;
	//返回前端
	exi($return);
}
//删除动作
if($_RQ['op']=='del'){
	$dels=array();
	$id=intval($_RQ['id']);
	if($id){
		//删除单个
		$dels[]=$id;
	}elseif($_RQ['del']){
		//批量删除
		$dels=str_array($_RQ['del']);
	}
	if(empty($dels)){
		exi('请先选择要删除的商品！','error');
	}
	//执行删除
	foreach($dels as $id){
		$this->pdo_delete('store_serve',array('id'=>$id,'uniacid'=>$_SESSION['uniacid']));
		//如有额外操作，可在此执行
	}
	exi('删除成功！');
}
