<?php
namespace app\admin\model;
use think\Model;
use think\facade\Cache;
use think\Db;
use app\admin\validate\Collect as CollectValidate;

class Collect extends Model{

    protected $autoWriteTimestamp = true;
    protected $json = ['rule','category_equivalents'];
    protected $jsonAssoc = true;

    public function getTypeTextAttr($value,$data){
        $status = ['novel'=>'小说','news'=>'文章'];
        return $status[$data['type']];
    }

    public function getRuleAttr($value){
        foreach ($value as $k => $v) {
            if(!empty($v['replace'])){
                $value[$k]['replace']=json_decode($v['replace'],true);
            }
        }
        return $value;
    }

	public function info($id){
		$map['id'] = $id;
    	$info=Collect::where($map)->find()->toArray();
		return $info;
	}

    public function lists(){
        return Collect::order('id asc')->paginate(config('web.list_rows'));
    }

	public function edit($data){
        $validate = new CollectValidate;
        if (!$validate->scene($data['type'])->check($data)) {
            $this->error=$validate->getError();
            return false;
        }
        $Collect = new Collect();
        if(empty($data['id'])){
            $result = $Collect->allowField(true)->save($data);
        }else{
            Cache::clear('collect');
            $result = $Collect->allowField(true)->isUpdate(true)->save($data);
        }
        if(false === $result){
            $this->error=$Collect->getError();
            return false;
        }
        return $result;
    }

    public function sever_data($info,$field){
        $chapter=[];
        $chapter_field=[];
        $data_link=[];
        if(is_array($field)){
            $field_data['category']=$field['category'];
            $field_data['title']=$field['title'];
            $field_data['pic']=$field['pic'];
            $field_data['content']=$field['content'];
            $field_data['update_time']=time();
            $field_data['reurl']=$field["reurl"];
            if($info['type']=='novel'){
                $field_data['author']=$field['author'];
                $field_data['serialize']=$field['serialize'];
                $field_data['tag']=$field['tag'];
                $field_data['word']=count($field['chapter'])*2000;
            }
            $field_data['create_time']=time();
            $data_id=Db::name($info['type'])->insertGetId($field_data);
            $data_link[]=url('home/'.$info['type'].'/index',['id'=>$data_id]);
            if($info['type']=='novel'){
                foreach ($field["chapter"] as $value) {
                    $chapter_data=[];
                    $keys=uniqidReal();
                    $chapter_data['title']=$value["title"];
                    $chapter_data['intro']='';
                    $chapter_data['update_time']=time();
                    $chapter_data['issued']=1;
                    $chapter_data['word']=2000;
                    $chapter_data['reurl']=$value["url"];
                    $chapter_data['auto']=2;
                    $chapter_data['path']=$data_id.DIRECTORY_SEPARATOR.$keys.'.txt';
                    $chapter[$keys]=$chapter_data;
                }
                $chapter_db=json_encode($chapter);
                $chapter_db=model('common/api')->compress_chapter($chapter_db);
                $chapter_field['status']=1;
                $chapter_field['novel_id']=$data_id;
                $chapter_field['chapter']=$chapter_db;
                $chapter_field['reurl']=$field['chapter_url'];
                $chapter_field['collect_id']=$info['id'];
                $chapter_field['run_time']=time()+600;
                $chapter_id=Db::name($info['type'].'_chapter')->insertGetId($chapter_field);
                foreach ($chapter as $key => $value) {
                    $data_link[]=url('home/chapter/index',['id'=>$chapter_id,'key'=>$key]);
                }
            }
            model('common/DataOperation')->after('add',$info['type'],$data_link);
            return $field;
        }
    }

    public function field(){
        $data=["field"=>[
                "novel"=>[
                    "category"=>"栏目",
                    "title"=>"名称",
                    "author"=>"作者",
                    "serialize"=>"连载",
                    "pic"=>"图片",
                    "content"=>"介绍",
                    "tag"=>"标签",
                    "chapter_title"=>"章节名称",
                    "chapter_content"=>"章节内容"
                ],
                "news"=>[
                    "category"=>"栏目",
                    "title"=>"名称",
                    "pic"=>"图片",
                    "content"=>"内容"
                ]
            ],
            "category"=>[
                'novel'=>get_tree(0),
                'news'=>get_tree(1)
            ]
        ];
        return $data;
    }
}