﻿DROP TABLE `jieqi_system_blocks`;

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";

CREATE TABLE IF NOT EXISTS `jieqi_system_blocks` (
  `bid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `blockname` varchar(50) NOT NULL DEFAULT '',
  `modname` varchar(50) NOT NULL DEFAULT '',
  `filename` varchar(50) NOT NULL DEFAULT '',
  `classname` varchar(50) NOT NULL DEFAULT '',
  `side` tinyint(3) NOT NULL DEFAULT '0',
  `title` text NOT NULL,
  `description` text NOT NULL,
  `content` mediumtext NOT NULL,
  `vars` text NOT NULL,
  `template` varchar(50) NOT NULL DEFAULT '',
  `cachetime` int(11) NOT NULL DEFAULT '0',
  `contenttype` tinyint(3) NOT NULL DEFAULT '0',
  `weight` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `showstatus` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `custom` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `canedit` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `publish` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `hasvars` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`bid`),
  KEY `modname` (`modname`),
  KEY `publish` (`publish`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk AUTO_INCREMENT=61 ;

--
-- Dumping data for table `jieqi_system_blocks`
--

INSERT INTO `jieqi_system_blocks` (`bid`, `blockname`, `modname`, `filename`, `classname`, `side`, `title`, `description`, `content`, `vars`, `template`, `cachetime`, `contenttype`, `weight`, `showstatus`, `custom`, `canedit`, `publish`, `hasvars`) VALUES
(1, '本站公告', 'system', '', 'BlockSystemCustom', 4, '本站公告', '', '<br>\r\n欢迎使用 JIEQI CMS，安装完成后请删除install目录，然后进入后台进行参数、用户组、权限和区块的相关设置。\r\n<br><br>\r\n更多程序和使用方面咨询请访问：\r\n<br><br>\r\n<a href="http://www.jieqi.com" target="_blank">http://www.jieqi.com</a>\r\n<br><br>', '', '', 0, 1, 10000, 0, 1, 1, 3, 0),
(2, '用户登录', 'system', 'block_login', 'BlockSystemLogin', 0, '用户登录', '', '', '', '', 0, 4, 10100, 0, 0, 0, 3, 0),
(3, '用户登录（AJAX）', 'system', '', 'BlockSystemCustom', 0, '用户登录', '', '<div id="block_login"></div>\r\n<script language="javascript" type="text/javascript">\r\nAjax.Update(''/blockshow.php?module=system&filename=block_login&classname=BlockSystemLogin&vars=&template=&contenttype=4&custom=0&publish=3&hasvars=0'', {outid:''block_login'', tipid:''block_login'', onLoading:''正在载入...''})\r\n</script>', '', '', 0, 1, 10150, 0, 1, 1, 0, 0),
(4, '用户分类', 'system', 'block_grouplist', 'BlockSystemGrouplist', 0, '用户分类', '', '', '', '', 0, 0, 10300, 1, 0, 0, 0, 0),
(5, '短消息', 'system', 'block_message', 'BlockSystemMessage', 0, '短消息', '', '', '', '', 0, 0, 10400, 1, 0, 0, 0, 0),
(6, '用户搜索', 'system', 'block_searchuser', 'BlockSystemSearchuser', 0, '用户搜索', '', '', '', '', 0, 0, 10500, 1, 0, 0, 0, 0),
(7, '用户排行', 'system', 'block_topuser', 'BlockSystemTopuser', 0, '用户排行', '', '', '', '', 0, 0, 10700, 1, 0, 0, 0, 0),
(8, '用户工具箱', 'system', 'block_userbox', 'BlockSystemUserbox', 0, '用户工具箱', '', '', '', '', 0, 0, 10800, 1, 0, 0, 0, 0),
(9, '用户设置', 'system', 'block_userset', 'BlockSystemUserset', 0, '用户设置', '', '', '', '', 0, 0, 10900, 1, 0, 0, 0, 0),
(10, '最新用户', 'system', 'block_userlist', 'BlockSystemUserlist', 0, '最新用户', '&nbsp;&nbsp;&nbsp;&nbsp;本区块允许用户自定义模板和参数，并且不同的设置可以保存成不同的区块。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块默认模板文件为“block_userlist.html”，在/templates/blocks目录下，如果您定义了另外模板文件，也必须在此目录。模板文件设置留空表示使用默认模板。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块允许设置四个参数，不同参数之间用英文逗号分隔“,”。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数一是排行方式（默认按用户积分），允许以下几种设置：1、“score” - 按用户积分；2、“experience” - 按经验值；3、“regdate” - 按加入日期；<br>&nbsp;&nbsp;&nbsp;&nbsp;参数二是显示行数，使用整数（默认 15）<br>&nbsp;&nbsp;&nbsp;&nbsp;参数三是用户类别（默认 0 表示所有类别），此处使用得是用户组序号而不是名称，比如“专栏作家”类别序号是 5 ，这里就设置成 5，如果要同时选择多个类别，可以用“|”分隔，比如 3|4|7<br>&nbsp;&nbsp;&nbsp;&nbsp;参数四是指显示顺序（默认 0 表示按从大到小排序），1 表示从小到大排序。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数设置中一项或者多项留空均表示使用默认值。例子： “score,20,0,0” 表示显示20个积分最多的用户。', '', 'regdate,15,0,0', 'block_usernew.html', 0, 4, 10900, 1, 0, 0, 0, 1),
(11, '积分排行', 'system', 'block_userlist', 'BlockSystemUserlist', 0, '积分排行', '&nbsp;&nbsp;&nbsp;&nbsp;本区块允许用户自定义模板和参数，并且不同的设置可以保存成不同的区块。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块默认模板文件为“block_userlist.html”，在/templates/blocks目录下，如果您定义了另外模板文件，也必须在此目录。模板文件设置留空表示使用默认模板。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块允许设置四个参数，不同参数之间用英文逗号分隔“,”。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数一是排行方式（默认按用户积分），允许以下几种设置：1、“score” - 按用户积分；2、“experience” - 按经验值；3、“regdate” - 按加入日期；<br>&nbsp;&nbsp;&nbsp;&nbsp;参数二是显示行数，使用整数（默认 15）<br>&nbsp;&nbsp;&nbsp;&nbsp;参数三是用户类别（默认 0 表示所有类别），此处使用得是用户组序号而不是名称，比如“专栏作家”类别序号是 5 ，这里就设置成 5，如果要同时选择多个类别，可以用“|”分隔，比如 3|4|7<br>&nbsp;&nbsp;&nbsp;&nbsp;参数四是指显示顺序（默认 0 表示按从大到小排序），1 表示从小到大排序。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数设置中一项或者多项留空均表示使用默认值。例子： “score,20,0,0” 表示显示20个积分最多的用户。', '', 'score,15,0,0', 'block_userscore.html', 0, 4, 11000, 1, 0, 0, 0, 1),
(12, '经验排行', 'system', 'block_userlist', 'BlockSystemUserlist', 0, '经验排行', '&nbsp;&nbsp;&nbsp;&nbsp;本区块允许用户自定义模板和参数，并且不同的设置可以保存成不同的区块。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块默认模板文件为“block_userlist.html”，在/templates/blocks目录下，如果您定义了另外模板文件，也必须在此目录。模板文件设置留空表示使用默认模板。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块允许设置四个参数，不同参数之间用英文逗号分隔“,”。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数一是排行方式（默认按用户积分），允许以下几种设置：1、“score” - 按用户积分；2、“experience” - 按经验值；3、“regdate” - 按加入日期；<br>&nbsp;&nbsp;&nbsp;&nbsp;参数二是显示行数，使用整数（默认 15）<br>&nbsp;&nbsp;&nbsp;&nbsp;参数三是用户类别（默认 0 表示所有类别），此处使用得是用户组序号而不是名称，比如“专栏作家”类别序号是 5 ，这里就设置成 5，如果要同时选择多个类别，可以用“|”分隔，比如 3|4|7<br>&nbsp;&nbsp;&nbsp;&nbsp;参数四是指显示顺序（默认 0 表示按从大到小排序），1 表示从小到大排序。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数设置中一项或者多项留空均表示使用默认值。例子： “score,20,0,0” 表示显示20个积分最多的用户。', '', 'experience,15,0,0', 'block_userexp.html', 0, 4, 11100, 1, 0, 0, 0, 1),
(13, '用户列表区块', 'system', 'block_userlist', 'BlockSystemUserlist', 0, '用户排行', '&nbsp;&nbsp;&nbsp;&nbsp;本区块允许用户自定义模板和参数，并且不同的设置可以保存成不同的区块。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块默认模板文件为“block_userlist.html”，在/templates/blocks目录下，如果您定义了另外模板文件，也必须在此目录。模板文件设置留空表示使用默认模板。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块允许设置四个参数，不同参数之间用英文逗号分隔“,”。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数一是排行方式（默认按用户积分），允许以下几种设置：1、“score” - 按用户积分；2、“experience” - 按经验值；3、“regdate” - 按加入日期；<br>&nbsp;&nbsp;&nbsp;&nbsp;参数二是显示行数，使用整数（默认 15）<br>&nbsp;&nbsp;&nbsp;&nbsp;参数三是用户类别（默认 0 表示所有类别），此处使用得是用户组序号而不是名称，比如“专栏作家”类别序号是 5 ，这里就设置成 5，如果要同时选择多个类别，可以用“|”分隔，比如 3|4|7<br>&nbsp;&nbsp;&nbsp;&nbsp;参数四是指显示顺序（默认 0 表示按从大到小排序），1 表示从小到大排序。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数设置中一项或者多项留空均表示使用默认值。例子： “score,20,0,0” 表示显示20个积分最多的用户。', '', 'score,15,0,0', 'block_userlist.html', 0, 4, 11200, 0, 0, 0, 0, 1),
(14, '用户推荐区块', 'system', 'block_usercommend', 'BlockSystemUsercommend', 0, '用户推荐', '&nbsp;&nbsp;&nbsp;&nbsp;本区块根据设置的参数显示对应ID的用户<br>&nbsp;&nbsp;&nbsp;&nbsp;默认一个参数，设置推荐的用户ID，多个ID用“|”分割，比如 12|34|56', '', '', 'block_usercommend.html', 0, 4, 11250, 0, 0, 0, 0, 1),
(15, '用户友情连接', 'system', 'block_userlink', 'BlockSystemUserlink', 1, '用户友情连接', '&nbsp;&nbsp;&nbsp;&nbsp;本区块显示某一用户自添加的友情连接<br>&nbsp;&nbsp;&nbsp;&nbsp;允许设置五个参数，不同参数之间用英文逗号分隔“,”。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数一是排序字段，允许设置成“toptime”-置顶时间，或者“addtime”-添加时间<br>&nbsp;&nbsp;&nbsp;&nbsp;参数二是显示几条记录，默认10<br>&nbsp;&nbsp;&nbsp;&nbsp;参数三是排序方式：0-从大到小，1-从小到大<br>&nbsp;&nbsp;&nbsp;&nbsp;参数四是显示哪个用户的友情链接，允许设置成“self”-当前用户，“uid”-url参数里面uid值对应的用户，“0”-所有用户，设置成大于0的一个整数，表示指定这个uid的用户<br>&nbsp;&nbsp;&nbsp;&nbsp;参数五是内容过滤，0-都显示，1-显示置顶的链接，2-显示非置顶链接', '', 'toptime,10,0,uid,0', 'block_userlink.html', 0, 4, 11300, 0, 0, 0, 0, 1),
(16, '用户好友列表', 'system', 'block_ufriends', 'BlockSystemUfriends', 1, '用户好友列表', '&nbsp;&nbsp;&nbsp;&nbsp;本区块显示某一用户好友列表<br>&nbsp;&nbsp;&nbsp;&nbsp;允许设置四个参数，不同参数之间用英文逗号分隔“,”。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数一是排序字段，允许设置成“friendsid”-好友记录ID，或者“adddate”-添加时间<br>&nbsp;&nbsp;&nbsp;&nbsp;参数二是显示几条记录，默认10<br>&nbsp;&nbsp;&nbsp;&nbsp;参数三是排序方式：0-从大到小，1-从小到大<br>&nbsp;&nbsp;&nbsp;&nbsp;参数四是显示哪个用户的好友列表，允许设置成“self”-当前用户，“uid”-url参数里面uid值对应的用户，“0”-所有用户，设置成大于0的一个整数，表示指定这个uid的用户', '', 'friendsid,10,0,uid', 'block_ufriends.html', 0, 4, 11400, 0, 0, 0, 0, 1),
(17, '用户资料', 'system', 'block_uinfo', 'BlockSystemUinfo', 0, '用户资料', '&nbsp;&nbsp;&nbsp;&nbsp;本区块显示某一用户资料<br>&nbsp;&nbsp;&nbsp;&nbsp;允许设置一个参数，不同参数之间用英文逗号分隔“,”。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数一是显示哪个用户的资料，允许设置成“self”-当前用户，“uid”-url参数里面uid值对应的用户，设置成大于0的一个整数，表示指定这个uid的用户', '', 'uid', 'block_uinfo.html', 0, 4, 11500, 0, 0, 0, 0, 1),
(18, '用户会客室主题', 'system', 'block_uptopics', 'BlockSystemUptopics', 6, '会客室主题', '&nbsp;&nbsp;&nbsp;&nbsp;本区块显示某一用户会客室主题<br>&nbsp;&nbsp;&nbsp;&nbsp;允许设置七个参数，不同参数之间用英文逗号分隔“,”。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数一是排序字段，允许设置成“topicid”-主题序号，“posttime”-发表时间，“replytime”-最后回复时间，“views”-点击数，“replies”-回复数间<br>&nbsp;&nbsp;&nbsp;&nbsp;参数二是显示几条记录，默认10<br>&nbsp;&nbsp;&nbsp;&nbsp;参数三是排序方式：0-从大到小，1-从小到大<br>&nbsp;&nbsp;&nbsp;&nbsp;参数四是显示哪个用户的友情链接，允许设置成“self”-当前用户，“uid”-url参数里面uid值对应的用户，“0”-所有用户，设置成大于0的一个整数，表示指定这个uid的用户<br>&nbsp;&nbsp;&nbsp;&nbsp;参数五是否置顶贴，0-都显示，1-显示置顶，2-显示非置顶<br>&nbsp;&nbsp;&nbsp;&nbsp;参数六是否精华贴，0-都显示，1-显示精华，2-显示非精华<br>&nbsp;&nbsp;&nbsp;&nbsp;参数七是否锁定贴，0-都显示，1-显示锁定，2-显示非锁定', '', 'topicid,10,0,uid,0,0,0', 'block_uptopics.html', 0, 4, 11600, 0, 0, 0, 0, 1),
(19, '网页内容调用区块', 'system', 'block_fileget', 'BlockSystemFileget', 0, '', '&nbsp;&nbsp;&nbsp;&nbsp;本区块是通过URL获取网页内容作为自己的区块内容。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块允许设置三个参数，不同参数之间用英文逗号分隔“,”。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数一是访问的URL(必须设置)，如 http://www.domain.com/block.php?id=1<br>&nbsp;&nbsp;&nbsp;&nbsp;参数二是缓存时间（单位是秒），本参数可以留空或者设置成0，表示使用系统默认缓存时间。设置成-1表示不用缓存，设置大于0的整数表示自定义缓存时间。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数三是指获取的网页内容编码，留空表示和系统默认编码相同。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数设置中一项或者多项留空均表示使用默认值。例子： “http://www.domain.com/block.php?id=1,1800,utf-8” 表示获取这个网址内容，缓存半个小时，内容编码是utf-8', '', '', '', 0, 4, 12500, 0, 0, 0, 0, 1),
(20, '分类阅读', 'article', 'block_sort', 'BlockArticleSort', 0, '分类阅读', '', '', '', '', 0, 0, 20100, 0, 0, 0, 0, 0),
(21, '文章搜索', 'article', 'block_search', 'BlockArticleSearch', 1, '文章搜索', '', '', '', '', 0, 0, 20200, 0, 0, 0, 3, 0),
(22, '排 行 榜', 'article', 'block_toplist', 'BlockArticleToplist', 0, '排 行 榜', '', '', '', '', 0, 0, 20300, 0, 0, 0, 0, 0),
(23, '文章总排行', 'article', 'block_articlelist', 'BlockArticleArticlelist', 0, '文章总排行', '&nbsp;&nbsp;&nbsp;&nbsp;本区块允许用户自定义模板和参数，并且不同的设置可以保存成不同的区块。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块默认模板文件为“block_articlelist.html”，在/modules/article/templates/blocks目录下，如果您定义了另外模板文件，也必须在此目录。模板文件设置留空表示使用默认模板。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块允许设置六个参数，不同参数之间用英文逗号分隔“,”。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数一是排行方式（默认按总访问量），允许以下几种设置：1、“allvisit” - 按总访问量；2、“monthvisit” - 按月访问量；3、“weekvisit” - 按周访问量；4、“dayvisit” - 按日访问量；5、“allvote” - 按总推荐次数；6、“monthvote” - 按月推荐次数；7、“weekvote” - 按周推荐次数；8、“dayvote” - 按日推荐次数；9、“postdate” - 按最新入库；10、“toptime” - 按本站推荐；11、“goodnum” - 按收藏数量；12、“size” - 按文章字数；13、“lastupdate” - 按最近更新；<br>&nbsp;&nbsp;&nbsp;&nbsp;参数二是显示行数，使用整数（默认 15）<br>&nbsp;&nbsp;&nbsp;&nbsp;参数三是文章类别（默认 0 表示所有类别），此处使用得是类别序号而不是名称，比如“玄幻小说”类别序号是 3 ，这里就设置成 3，如果要同时选择多个类别，可以用“|”分隔，比如 3|4|7<br>&nbsp;&nbsp;&nbsp;&nbsp;参数四是指是否原创（默认 0 表示不判断），1 表示只显示原创作品，2 表示转载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数五是指是否全本（默认 0 表示不判断），1 表示只显示全本作品，2 表示连载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数六是指显示顺序（默认 0 表示按从大到小排序），1 表示从小到大排序。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数设置中一项或者多项留空均表示使用默认值。例子： “lastupdate,,0,1,0,0” 表示显示15条最近更新的原创作品，其中第二个参数留空，所以使用默认的15条。', '', 'allvisit,15,0,0,0,0', 'block_allvisit.html', 0, 4, 20400, 0, 0, 0, 3, 1),
(24, '文章月排行', 'article', 'block_articlelist', 'BlockArticleArticlelist', 0, '文章月排行', '&nbsp;&nbsp;&nbsp;&nbsp;本区块允许用户自定义模板和参数，并且不同的设置可以保存成不同的区块。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块默认模板文件为“block_articlelist.html”，在/modules/article/templates/blocks目录下，如果您定义了另外模板文件，也必须在此目录。模板文件设置留空表示使用默认模板。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块允许设置六个参数，不同参数之间用英文逗号分隔“,”。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数一是排行方式（默认按总访问量），允许以下几种设置：1、“allvisit” - 按总访问量；2、“monthvisit” - 按月访问量；3、“weekvisit” - 按周访问量；4、“dayvisit” - 按日访问量；5、“allvote” - 按总推荐次数；6、“monthvote” - 按月推荐次数；7、“weekvote” - 按周推荐次数；8、“dayvote” - 按日推荐次数；9、“postdate” - 按最新入库；10、“toptime” - 按本站推荐；11、“goodnum” - 按收藏数量；12、“size” - 按文章字数；13、“lastupdate” - 按最近更新；<br>&nbsp;&nbsp;&nbsp;&nbsp;参数二是显示行数，使用整数（默认 15）<br>&nbsp;&nbsp;&nbsp;&nbsp;参数三是文章类别（默认 0 表示所有类别），此处使用得是类别序号而不是名称，比如“玄幻小说”类别序号是 3 ，这里就设置成 3，如果要同时选择多个类别，可以用“|”分隔，比如 3|4|7<br>&nbsp;&nbsp;&nbsp;&nbsp;参数四是指是否原创（默认 0 表示不判断），1 表示只显示原创作品，2 表示转载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数五是指是否全本（默认 0 表示不判断），1 表示只显示全本作品，2 表示连载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数六是指显示顺序（默认 0 表示按从大到小排序），1 表示从小到大排序。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数设置中一项或者多项留空均表示使用默认值。例子： “lastupdate,,0,1,0,0” 表示显示15条最近更新的原创作品，其中第二个参数留空，所以使用默认的15条。', '', 'monthvisit,15,0,0,0,0', 'block_monthvisit.html', 0, 4, 20500, 0, 0, 0, 3, 1),
(25, '文章周排行', 'article', 'block_articlelist', 'BlockArticleArticlelist', 0, '文章周排行', '&nbsp;&nbsp;&nbsp;&nbsp;本区块允许用户自定义模板和参数，并且不同的设置可以保存成不同的区块。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块默认模板文件为“block_articlelist.html”，在/modules/article/templates/blocks目录下，如果您定义了另外模板文件，也必须在此目录。模板文件设置留空表示使用默认模板。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块允许设置六个参数，不同参数之间用英文逗号分隔“,”。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数一是排行方式（默认按总访问量），允许以下几种设置：1、“allvisit” - 按总访问量；2、“monthvisit” - 按月访问量；3、“weekvisit” - 按周访问量；4、“dayvisit” - 按日访问量；5、“allvote” - 按总推荐次数；6、“monthvote” - 按月推荐次数；7、“weekvote” - 按周推荐次数；8、“dayvote” - 按日推荐次数；9、“postdate” - 按最新入库；10、“toptime” - 按本站推荐；11、“goodnum” - 按收藏数量；12、“size” - 按文章字数；13、“lastupdate” - 按最近更新；<br>&nbsp;&nbsp;&nbsp;&nbsp;参数二是显示行数，使用整数（默认 15）<br>&nbsp;&nbsp;&nbsp;&nbsp;参数三是文章类别（默认 0 表示所有类别），此处使用得是类别序号而不是名称，比如“玄幻小说”类别序号是 3 ，这里就设置成 3，如果要同时选择多个类别，可以用“|”分隔，比如 3|4|7<br>&nbsp;&nbsp;&nbsp;&nbsp;参数四是指是否原创（默认 0 表示不判断），1 表示只显示原创作品，2 表示转载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数五是指是否全本（默认 0 表示不判断），1 表示只显示全本作品，2 表示连载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数六是指显示顺序（默认 0 表示按从大到小排序），1 表示从小到大排序。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数设置中一项或者多项留空均表示使用默认值。例子： “lastupdate,,0,1,0,0” 表示显示15条最近更新的原创作品，其中第二个参数留空，所以使用默认的15条。', '', 'weekvisit,15,0,0,0,0', 'block_weekvisit.html', 0, 4, 20600, 0, 0, 0, 0, 1),
(26, '文章日排行', 'article', 'block_articlelist', 'BlockArticleArticlelist', 1, '文章日排行', '&nbsp;&nbsp;&nbsp;&nbsp;本区块允许用户自定义模板和参数，并且不同的设置可以保存成不同的区块。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块默认模板文件为“block_articlelist.html”，在/modules/article/templates/blocks目录下，如果您定义了另外模板文件，也必须在此目录。模板文件设置留空表示使用默认模板。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块允许设置六个参数，不同参数之间用英文逗号分隔“,”。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数一是排行方式（默认按总访问量），允许以下几种设置：1、“allvisit” - 按总访问量；2、“monthvisit” - 按月访问量；3、“weekvisit” - 按周访问量；4、“dayvisit” - 按日访问量；5、“allvote” - 按总推荐次数；6、“monthvote” - 按月推荐次数；7、“weekvote” - 按周推荐次数；8、“dayvote” - 按日推荐次数；9、“postdate” - 按最新入库；10、“toptime” - 按本站推荐；11、“goodnum” - 按收藏数量；12、“size” - 按文章字数；13、“lastupdate” - 按最近更新；<br>&nbsp;&nbsp;&nbsp;&nbsp;参数二是显示行数，使用整数（默认 15）<br>&nbsp;&nbsp;&nbsp;&nbsp;参数三是文章类别（默认 0 表示所有类别），此处使用得是类别序号而不是名称，比如“玄幻小说”类别序号是 3 ，这里就设置成 3，如果要同时选择多个类别，可以用“|”分隔，比如 3|4|7<br>&nbsp;&nbsp;&nbsp;&nbsp;参数四是指是否原创（默认 0 表示不判断），1 表示只显示原创作品，2 表示转载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数五是指是否全本（默认 0 表示不判断），1 表示只显示全本作品，2 表示连载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数六是指显示顺序（默认 0 表示按从大到小排序），1 表示从小到大排序。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数设置中一项或者多项留空均表示使用默认值。例子： “lastupdate,,0,1,0,0” 表示显示15条最近更新的原创作品，其中第二个参数留空，所以使用默认的15条。', '', 'dayvisit,15,0,0,0,0', 'block_dayvisit.html', 0, 4, 20700, 0, 0, 0, 0, 1),
(27, '原创总排行', 'article', 'block_articlelist', 'BlockArticleArticlelist', 0, '原创总排行', '&nbsp;&nbsp;&nbsp;&nbsp;本区块允许用户自定义模板和参数，并且不同的设置可以保存成不同的区块。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块默认模板文件为“block_articlelist.html”，在/modules/article/templates/blocks目录下，如果您定义了另外模板文件，也必须在此目录。模板文件设置留空表示使用默认模板。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块允许设置六个参数，不同参数之间用英文逗号分隔“,”。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数一是排行方式（默认按总访问量），允许以下几种设置：1、“allvisit” - 按总访问量；2、“monthvisit” - 按月访问量；3、“weekvisit” - 按周访问量；4、“dayvisit” - 按日访问量；5、“allvote” - 按总推荐次数；6、“monthvote” - 按月推荐次数；7、“weekvote” - 按周推荐次数；8、“dayvote” - 按日推荐次数；9、“postdate” - 按最新入库；10、“toptime” - 按本站推荐；11、“goodnum” - 按收藏数量；12、“size” - 按文章字数；13、“lastupdate” - 按最近更新；<br>&nbsp;&nbsp;&nbsp;&nbsp;参数二是显示行数，使用整数（默认 15）<br>&nbsp;&nbsp;&nbsp;&nbsp;参数三是文章类别（默认 0 表示所有类别），此处使用得是类别序号而不是名称，比如“玄幻小说”类别序号是 3 ，这里就设置成 3，如果要同时选择多个类别，可以用“|”分隔，比如 3|4|7<br>&nbsp;&nbsp;&nbsp;&nbsp;参数四是指是否原创（默认 0 表示不判断），1 表示只显示原创作品，2 表示转载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数五是指是否全本（默认 0 表示不判断），1 表示只显示全本作品，2 表示连载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数六是指显示顺序（默认 0 表示按从大到小排序），1 表示从小到大排序。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数设置中一项或者多项留空均表示使用默认值。例子： “lastupdate,,0,1,0,0” 表示显示15条最近更新的原创作品，其中第二个参数留空，所以使用默认的15条。', '', 'allvisit,15,0,1,0,0', 'block_allauthorvisit.html', 0, 4, 20800, 0, 0, 0, 0, 1),
(28, '原创月排行', 'article', 'block_articlelist', 'BlockArticleArticlelist', 0, '原创月排行', '&nbsp;&nbsp;&nbsp;&nbsp;本区块允许用户自定义模板和参数，并且不同的设置可以保存成不同的区块。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块默认模板文件为“block_articlelist.html”，在/modules/article/templates/blocks目录下，如果您定义了另外模板文件，也必须在此目录。模板文件设置留空表示使用默认模板。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块允许设置六个参数，不同参数之间用英文逗号分隔“,”。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数一是排行方式（默认按总访问量），允许以下几种设置：1、“allvisit” - 按总访问量；2、“monthvisit” - 按月访问量；3、“weekvisit” - 按周访问量；4、“dayvisit” - 按日访问量；5、“allvote” - 按总推荐次数；6、“monthvote” - 按月推荐次数；7、“weekvote” - 按周推荐次数；8、“dayvote” - 按日推荐次数；9、“postdate” - 按最新入库；10、“toptime” - 按本站推荐；11、“goodnum” - 按收藏数量；12、“size” - 按文章字数；13、“lastupdate” - 按最近更新；<br>&nbsp;&nbsp;&nbsp;&nbsp;参数二是显示行数，使用整数（默认 15）<br>&nbsp;&nbsp;&nbsp;&nbsp;参数三是文章类别（默认 0 表示所有类别），此处使用得是类别序号而不是名称，比如“玄幻小说”类别序号是 3 ，这里就设置成 3，如果要同时选择多个类别，可以用“|”分隔，比如 3|4|7<br>&nbsp;&nbsp;&nbsp;&nbsp;参数四是指是否原创（默认 0 表示不判断），1 表示只显示原创作品，2 表示转载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数五是指是否全本（默认 0 表示不判断），1 表示只显示全本作品，2 表示连载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数六是指显示顺序（默认 0 表示按从大到小排序），1 表示从小到大排序。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数设置中一项或者多项留空均表示使用默认值。例子： “lastupdate,,0,1,0,0” 表示显示15条最近更新的原创作品，其中第二个参数留空，所以使用默认的15条。', '', 'monthvisit,15,0,1,0,0', 'block_monthauthorvisit.html', 0, 4, 20900, 0, 0, 0, 0, 1),
(29, '原创周排行', 'article', 'block_articlelist', 'BlockArticleArticlelist', 0, '原创周排行', '&nbsp;&nbsp;&nbsp;&nbsp;本区块允许用户自定义模板和参数，并且不同的设置可以保存成不同的区块。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块默认模板文件为“block_articlelist.html”，在/modules/article/templates/blocks目录下，如果您定义了另外模板文件，也必须在此目录。模板文件设置留空表示使用默认模板。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块允许设置六个参数，不同参数之间用英文逗号分隔“,”。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数一是排行方式（默认按总访问量），允许以下几种设置：1、“allvisit” - 按总访问量；2、“monthvisit” - 按月访问量；3、“weekvisit” - 按周访问量；4、“dayvisit” - 按日访问量；5、“allvote” - 按总推荐次数；6、“monthvote” - 按月推荐次数；7、“weekvote” - 按周推荐次数；8、“dayvote” - 按日推荐次数；9、“postdate” - 按最新入库；10、“toptime” - 按本站推荐；11、“goodnum” - 按收藏数量；12、“size” - 按文章字数；13、“lastupdate” - 按最近更新；<br>&nbsp;&nbsp;&nbsp;&nbsp;参数二是显示行数，使用整数（默认 15）<br>&nbsp;&nbsp;&nbsp;&nbsp;参数三是文章类别（默认 0 表示所有类别），此处使用得是类别序号而不是名称，比如“玄幻小说”类别序号是 3 ，这里就设置成 3，如果要同时选择多个类别，可以用“|”分隔，比如 3|4|7<br>&nbsp;&nbsp;&nbsp;&nbsp;参数四是指是否原创（默认 0 表示不判断），1 表示只显示原创作品，2 表示转载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数五是指是否全本（默认 0 表示不判断），1 表示只显示全本作品，2 表示连载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数六是指显示顺序（默认 0 表示按从大到小排序），1 表示从小到大排序。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数设置中一项或者多项留空均表示使用默认值。例子： “lastupdate,,0,1,0,0” 表示显示15条最近更新的原创作品，其中第二个参数留空，所以使用默认的15条。', '', 'weekvisit,15,0,1,0,0', 'block_weekauthorvisit.html', 0, 4, 21000, 0, 0, 0, 0, 1),
(30, '原创日排行', 'article', 'block_articlelist', 'BlockArticleArticlelist', 0, '原创日排行', '&nbsp;&nbsp;&nbsp;&nbsp;本区块允许用户自定义模板和参数，并且不同的设置可以保存成不同的区块。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块默认模板文件为“block_articlelist.html”，在/modules/article/templates/blocks目录下，如果您定义了另外模板文件，也必须在此目录。模板文件设置留空表示使用默认模板。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块允许设置六个参数，不同参数之间用英文逗号分隔“,”。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数一是排行方式（默认按总访问量），允许以下几种设置：1、“allvisit” - 按总访问量；2、“monthvisit” - 按月访问量；3、“weekvisit” - 按周访问量；4、“dayvisit” - 按日访问量；5、“allvote” - 按总推荐次数；6、“monthvote” - 按月推荐次数；7、“weekvote” - 按周推荐次数；8、“dayvote” - 按日推荐次数；9、“postdate” - 按最新入库；10、“toptime” - 按本站推荐；11、“goodnum” - 按收藏数量；12、“size” - 按文章字数；13、“lastupdate” - 按最近更新；<br>&nbsp;&nbsp;&nbsp;&nbsp;参数二是显示行数，使用整数（默认 15）<br>&nbsp;&nbsp;&nbsp;&nbsp;参数三是文章类别（默认 0 表示所有类别），此处使用得是类别序号而不是名称，比如“玄幻小说”类别序号是 3 ，这里就设置成 3，如果要同时选择多个类别，可以用“|”分隔，比如 3|4|7<br>&nbsp;&nbsp;&nbsp;&nbsp;参数四是指是否原创（默认 0 表示不判断），1 表示只显示原创作品，2 表示转载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数五是指是否全本（默认 0 表示不判断），1 表示只显示全本作品，2 表示连载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数六是指显示顺序（默认 0 表示按从大到小排序），1 表示从小到大排序。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数设置中一项或者多项留空均表示使用默认值。例子： “lastupdate,,0,1,0,0” 表示显示15条最近更新的原创作品，其中第二个参数留空，所以使用默认的15条。', '', 'dayvisit,15,0,1,0,0', 'block_dayauthorvisit.html', 0, 4, 21100, 0, 0, 0, 0, 1),
(31, '本站推荐', 'article', 'block_articlelist', 'BlockArticleArticlelist', 0, '本站推荐', '&nbsp;&nbsp;&nbsp;&nbsp;本区块允许用户自定义模板和参数，并且不同的设置可以保存成不同的区块。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块默认模板文件为“block_articlelist.html”，在/modules/article/templates/blocks目录下，如果您定义了另外模板文件，也必须在此目录。模板文件设置留空表示使用默认模板。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块允许设置六个参数，不同参数之间用英文逗号分隔“,”。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数一是排行方式（默认按总访问量），允许以下几种设置：1、“allvisit” - 按总访问量；2、“monthvisit” - 按月访问量；3、“weekvisit” - 按周访问量；4、“dayvisit” - 按日访问量；5、“allvote” - 按总推荐次数；6、“monthvote” - 按月推荐次数；7、“weekvote” - 按周推荐次数；8、“dayvote” - 按日推荐次数；9、“postdate” - 按最新入库；10、“toptime” - 按本站推荐；11、“goodnum” - 按收藏数量；12、“size” - 按文章字数；13、“lastupdate” - 按最近更新；<br>&nbsp;&nbsp;&nbsp;&nbsp;参数二是显示行数，使用整数（默认 15）<br>&nbsp;&nbsp;&nbsp;&nbsp;参数三是文章类别（默认 0 表示所有类别），此处使用得是类别序号而不是名称，比如“玄幻小说”类别序号是 3 ，这里就设置成 3，如果要同时选择多个类别，可以用“|”分隔，比如 3|4|7<br>&nbsp;&nbsp;&nbsp;&nbsp;参数四是指是否原创（默认 0 表示不判断），1 表示只显示原创作品，2 表示转载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数五是指是否全本（默认 0 表示不判断），1 表示只显示全本作品，2 表示连载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数六是指显示顺序（默认 0 表示按从大到小排序），1 表示从小到大排序。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数设置中一项或者多项留空均表示使用默认值。例子： “lastupdate,,0,1,0,0” 表示显示15条最近更新的原创作品，其中第二个参数留空，所以使用默认的15条。', '', 'toptime,15,0,0,0,0', 'block_toptime.html', 0, 4, 21200, 0, 0, 0, 0, 1),
(32, '总推荐榜', 'article', 'block_articlelist', 'BlockArticleArticlelist', 1, '总推荐榜', '&nbsp;&nbsp;&nbsp;&nbsp;本区块允许用户自定义模板和参数，并且不同的设置可以保存成不同的区块。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块默认模板文件为“block_articlelist.html”，在/modules/article/templates/blocks目录下，如果您定义了另外模板文件，也必须在此目录。模板文件设置留空表示使用默认模板。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块允许设置六个参数，不同参数之间用英文逗号分隔“,”。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数一是排行方式（默认按总访问量），允许以下几种设置：1、“allvisit” - 按总访问量；2、“monthvisit” - 按月访问量；3、“weekvisit” - 按周访问量；4、“dayvisit” - 按日访问量；5、“allvote” - 按总推荐次数；6、“monthvote” - 按月推荐次数；7、“weekvote” - 按周推荐次数；8、“dayvote” - 按日推荐次数；9、“postdate” - 按最新入库；10、“toptime” - 按本站推荐；11、“goodnum” - 按收藏数量；12、“size” - 按文章字数；13、“lastupdate” - 按最近更新；<br>&nbsp;&nbsp;&nbsp;&nbsp;参数二是显示行数，使用整数（默认 15）<br>&nbsp;&nbsp;&nbsp;&nbsp;参数三是文章类别（默认 0 表示所有类别），此处使用得是类别序号而不是名称，比如“玄幻小说”类别序号是 3 ，这里就设置成 3，如果要同时选择多个类别，可以用“|”分隔，比如 3|4|7<br>&nbsp;&nbsp;&nbsp;&nbsp;参数四是指是否原创（默认 0 表示不判断），1 表示只显示原创作品，2 表示转载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数五是指是否全本（默认 0 表示不判断），1 表示只显示全本作品，2 表示连载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数六是指显示顺序（默认 0 表示按从大到小排序），1 表示从小到大排序。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数设置中一项或者多项留空均表示使用默认值。例子： “lastupdate,,0,1,0,0” 表示显示15条最近更新的原创作品，其中第二个参数留空，所以使用默认的15条。', '', 'allvote,15,0,0,0,0', 'block_allvote.html', 0, 4, 21300, 0, 0, 0, 3, 1),
(33, '本月推荐', 'article', 'block_articlelist', 'BlockArticleArticlelist', 1, '本月推荐', '&nbsp;&nbsp;&nbsp;&nbsp;本区块允许用户自定义模板和参数，并且不同的设置可以保存成不同的区块。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块默认模板文件为“block_articlelist.html”，在/modules/article/templates/blocks目录下，如果您定义了另外模板文件，也必须在此目录。模板文件设置留空表示使用默认模板。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块允许设置六个参数，不同参数之间用英文逗号分隔“,”。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数一是排行方式（默认按总访问量），允许以下几种设置：1、“allvisit” - 按总访问量；2、“monthvisit” - 按月访问量；3、“weekvisit” - 按周访问量；4、“dayvisit” - 按日访问量；5、“allvote” - 按总推荐次数；6、“monthvote” - 按月推荐次数；7、“weekvote” - 按周推荐次数；8、“dayvote” - 按日推荐次数；9、“postdate” - 按最新入库；10、“toptime” - 按本站推荐；11、“goodnum” - 按收藏数量；12、“size” - 按文章字数；13、“lastupdate” - 按最近更新；<br>&nbsp;&nbsp;&nbsp;&nbsp;参数二是显示行数，使用整数（默认 15）<br>&nbsp;&nbsp;&nbsp;&nbsp;参数三是文章类别（默认 0 表示所有类别），此处使用得是类别序号而不是名称，比如“玄幻小说”类别序号是 3 ，这里就设置成 3，如果要同时选择多个类别，可以用“|”分隔，比如 3|4|7<br>&nbsp;&nbsp;&nbsp;&nbsp;参数四是指是否原创（默认 0 表示不判断），1 表示只显示原创作品，2 表示转载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数五是指是否全本（默认 0 表示不判断），1 表示只显示全本作品，2 表示连载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数六是指显示顺序（默认 0 表示按从大到小排序），1 表示从小到大排序。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数设置中一项或者多项留空均表示使用默认值。例子： “lastupdate,,0,1,0,0” 表示显示15条最近更新的原创作品，其中第二个参数留空，所以使用默认的15条。', '', 'monthvote,15,0,0,0,0', 'block_monthvote.html', 0, 4, 21400, 0, 0, 0, 3, 1),
(34, '本周推荐', 'article', 'block_articlelist', 'BlockArticleArticlelist', 1, '本周推荐', '&nbsp;&nbsp;&nbsp;&nbsp;本区块允许用户自定义模板和参数，并且不同的设置可以保存成不同的区块。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块默认模板文件为“block_articlelist.html”，在/modules/article/templates/blocks目录下，如果您定义了另外模板文件，也必须在此目录。模板文件设置留空表示使用默认模板。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块允许设置六个参数，不同参数之间用英文逗号分隔“,”。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数一是排行方式（默认按总访问量），允许以下几种设置：1、“allvisit” - 按总访问量；2、“monthvisit” - 按月访问量；3、“weekvisit” - 按周访问量；4、“dayvisit” - 按日访问量；5、“allvote” - 按总推荐次数；6、“monthvote” - 按月推荐次数；7、“weekvote” - 按周推荐次数；8、“dayvote” - 按日推荐次数；9、“postdate” - 按最新入库；10、“toptime” - 按本站推荐；11、“goodnum” - 按收藏数量；12、“size” - 按文章字数；13、“lastupdate” - 按最近更新；<br>&nbsp;&nbsp;&nbsp;&nbsp;参数二是显示行数，使用整数（默认 15）<br>&nbsp;&nbsp;&nbsp;&nbsp;参数三是文章类别（默认 0 表示所有类别），此处使用得是类别序号而不是名称，比如“玄幻小说”类别序号是 3 ，这里就设置成 3，如果要同时选择多个类别，可以用“|”分隔，比如 3|4|7<br>&nbsp;&nbsp;&nbsp;&nbsp;参数四是指是否原创（默认 0 表示不判断），1 表示只显示原创作品，2 表示转载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数五是指是否全本（默认 0 表示不判断），1 表示只显示全本作品，2 表示连载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数六是指显示顺序（默认 0 表示按从大到小排序），1 表示从小到大排序。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数设置中一项或者多项留空均表示使用默认值。例子： “lastupdate,,0,1,0,0” 表示显示15条最近更新的原创作品，其中第二个参数留空，所以使用默认的15条。', '', 'weekvote,15,0,0,0,0', 'block_weekvote.html', 0, 4, 21500, 0, 0, 0, 0, 1),
(35, '本日推荐', 'article', 'block_articlelist', 'BlockArticleArticlelist', 1, '本日推荐', '&nbsp;&nbsp;&nbsp;&nbsp;本区块允许用户自定义模板和参数，并且不同的设置可以保存成不同的区块。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块默认模板文件为“block_articlelist.html”，在/modules/article/templates/blocks目录下，如果您定义了另外模板文件，也必须在此目录。模板文件设置留空表示使用默认模板。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块允许设置六个参数，不同参数之间用英文逗号分隔“,”。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数一是排行方式（默认按总访问量），允许以下几种设置：1、“allvisit” - 按总访问量；2、“monthvisit” - 按月访问量；3、“weekvisit” - 按周访问量；4、“dayvisit” - 按日访问量；5、“allvote” - 按总推荐次数；6、“monthvote” - 按月推荐次数；7、“weekvote” - 按周推荐次数；8、“dayvote” - 按日推荐次数；9、“postdate” - 按最新入库；10、“toptime” - 按本站推荐；11、“goodnum” - 按收藏数量；12、“size” - 按文章字数；13、“lastupdate” - 按最近更新；<br>&nbsp;&nbsp;&nbsp;&nbsp;参数二是显示行数，使用整数（默认 15）<br>&nbsp;&nbsp;&nbsp;&nbsp;参数三是文章类别（默认 0 表示所有类别），此处使用得是类别序号而不是名称，比如“玄幻小说”类别序号是 3 ，这里就设置成 3，如果要同时选择多个类别，可以用“|”分隔，比如 3|4|7<br>&nbsp;&nbsp;&nbsp;&nbsp;参数四是指是否原创（默认 0 表示不判断），1 表示只显示原创作品，2 表示转载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数五是指是否全本（默认 0 表示不判断），1 表示只显示全本作品，2 表示连载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数六是指显示顺序（默认 0 表示按从大到小排序），1 表示从小到大排序。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数设置中一项或者多项留空均表示使用默认值。例子： “lastupdate,,0,1,0,0” 表示显示15条最近更新的原创作品，其中第二个参数留空，所以使用默认的15条。', '', 'dayvote,15,0,0,0,0', 'block_dayvote.html', 0, 4, 21600, 0, 0, 0, 0, 1),
(36, '最近更新', 'article', 'block_articlelist', 'BlockArticleArticlelist', 5, '最近更新', '&nbsp;&nbsp;&nbsp;&nbsp;本区块允许用户自定义模板和参数，并且不同的设置可以保存成不同的区块。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块默认模板文件为“block_articlelist.html”，在/modules/article/templates/blocks目录下，如果您定义了另外模板文件，也必须在此目录。模板文件设置留空表示使用默认模板。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块允许设置六个参数，不同参数之间用英文逗号分隔“,”。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数一是排行方式（默认按总访问量），允许以下几种设置：1、“allvisit” - 按总访问量；2、“monthvisit” - 按月访问量；3、“weekvisit” - 按周访问量；4、“dayvisit” - 按日访问量；5、“allvote” - 按总推荐次数；6、“monthvote” - 按月推荐次数；7、“weekvote” - 按周推荐次数；8、“dayvote” - 按日推荐次数；9、“postdate” - 按最新入库；10、“toptime” - 按本站推荐；11、“goodnum” - 按收藏数量；12、“size” - 按文章字数；13、“lastupdate” - 按最近更新；<br>&nbsp;&nbsp;&nbsp;&nbsp;参数二是显示行数，使用整数（默认 15）<br>&nbsp;&nbsp;&nbsp;&nbsp;参数三是文章类别（默认 0 表示所有类别），此处使用得是类别序号而不是名称，比如“玄幻小说”类别序号是 3 ，这里就设置成 3，如果要同时选择多个类别，可以用“|”分隔，比如 3|4|7<br>&nbsp;&nbsp;&nbsp;&nbsp;参数四是指是否原创（默认 0 表示不判断），1 表示只显示原创作品，2 表示转载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数五是指是否全本（默认 0 表示不判断），1 表示只显示全本作品，2 表示连载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数六是指显示顺序（默认 0 表示按从大到小排序），1 表示从小到大排序。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数设置中一项或者多项留空均表示使用默认值。例子： “lastupdate,,0,1,0,0” 表示显示15条最近更新的原创作品，其中第二个参数留空，所以使用默认的15条。', '', 'lastupdate,15,0,0,0,0', 'block_lastupdate.html', 0, 4, 21700, 0, 0, 0, 3, 1),
(37, '原创更新', 'article', 'block_articlelist', 'BlockArticleArticlelist', 0, '原创更新', '&nbsp;&nbsp;&nbsp;&nbsp;本区块允许用户自定义模板和参数，并且不同的设置可以保存成不同的区块。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块默认模板文件为“block_articlelist.html”，在/modules/article/templates/blocks目录下，如果您定义了另外模板文件，也必须在此目录。模板文件设置留空表示使用默认模板。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块允许设置六个参数，不同参数之间用英文逗号分隔“,”。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数一是排行方式（默认按总访问量），允许以下几种设置：1、“allvisit” - 按总访问量；2、“monthvisit” - 按月访问量；3、“weekvisit” - 按周访问量；4、“dayvisit” - 按日访问量；5、“allvote” - 按总推荐次数；6、“monthvote” - 按月推荐次数；7、“weekvote” - 按周推荐次数；8、“dayvote” - 按日推荐次数；9、“postdate” - 按最新入库；10、“toptime” - 按本站推荐；11、“goodnum” - 按收藏数量；12、“size” - 按文章字数；13、“lastupdate” - 按最近更新；<br>&nbsp;&nbsp;&nbsp;&nbsp;参数二是显示行数，使用整数（默认 15）<br>&nbsp;&nbsp;&nbsp;&nbsp;参数三是文章类别（默认 0 表示所有类别），此处使用得是类别序号而不是名称，比如“玄幻小说”类别序号是 3 ，这里就设置成 3，如果要同时选择多个类别，可以用“|”分隔，比如 3|4|7<br>&nbsp;&nbsp;&nbsp;&nbsp;参数四是指是否原创（默认 0 表示不判断），1 表示只显示原创作品，2 表示转载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数五是指是否全本（默认 0 表示不判断），1 表示只显示全本作品，2 表示连载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数六是指显示顺序（默认 0 表示按从大到小排序），1 表示从小到大排序。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数设置中一项或者多项留空均表示使用默认值。例子： “lastupdate,,0,1,0,0” 表示显示15条最近更新的原创作品，其中第二个参数留空，所以使用默认的15条。', '', 'lastupdate,15,0,1,0,0', 'block_authorupdate.html', 0, 4, 21800, 0, 0, 0, 0, 1);
INSERT INTO `jieqi_system_blocks` (`bid`, `blockname`, `modname`, `filename`, `classname`, `side`, `title`, `description`, `content`, `vars`, `template`, `cachetime`, `contenttype`, `weight`, `showstatus`, `custom`, `canedit`, `publish`, `hasvars`) VALUES
(38, '转载更新', 'article', 'block_articlelist', 'BlockArticleArticlelist', 0, '转载更新', '&nbsp;&nbsp;&nbsp;&nbsp;本区块允许用户自定义模板和参数，并且不同的设置可以保存成不同的区块。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块默认模板文件为“block_articlelist.html”，在/modules/article/templates/blocks目录下，如果您定义了另外模板文件，也必须在此目录。模板文件设置留空表示使用默认模板。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块允许设置六个参数，不同参数之间用英文逗号分隔“,”。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数一是排行方式（默认按总访问量），允许以下几种设置：1、“allvisit” - 按总访问量；2、“monthvisit” - 按月访问量；3、“weekvisit” - 按周访问量；4、“dayvisit” - 按日访问量；5、“allvote” - 按总推荐次数；6、“monthvote” - 按月推荐次数；7、“weekvote” - 按周推荐次数；8、“dayvote” - 按日推荐次数；9、“postdate” - 按最新入库；10、“toptime” - 按本站推荐；11、“goodnum” - 按收藏数量；12、“size” - 按文章字数；13、“lastupdate” - 按最近更新；<br>&nbsp;&nbsp;&nbsp;&nbsp;参数二是显示行数，使用整数（默认 15）<br>&nbsp;&nbsp;&nbsp;&nbsp;参数三是文章类别（默认 0 表示所有类别），此处使用得是类别序号而不是名称，比如“玄幻小说”类别序号是 3 ，这里就设置成 3，如果要同时选择多个类别，可以用“|”分隔，比如 3|4|7<br>&nbsp;&nbsp;&nbsp;&nbsp;参数四是指是否原创（默认 0 表示不判断），1 表示只显示原创作品，2 表示转载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数五是指是否全本（默认 0 表示不判断），1 表示只显示全本作品，2 表示连载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数六是指显示顺序（默认 0 表示按从大到小排序），1 表示从小到大排序。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数设置中一项或者多项留空均表示使用默认值。例子： “lastupdate,,0,1,0,0” 表示显示15条最近更新的原创作品，其中第二个参数留空，所以使用默认的15条。', '', 'lastupdate,15,0,2,0,0', 'block_masterupdate.html', 0, 4, 21900, 0, 0, 0, 0, 1),
(39, '最新入库', 'article', 'block_articlelist', 'BlockArticleArticlelist', 0, '最新入库', '&nbsp;&nbsp;&nbsp;&nbsp;本区块允许用户自定义模板和参数，并且不同的设置可以保存成不同的区块。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块默认模板文件为“block_articlelist.html”，在/modules/article/templates/blocks目录下，如果您定义了另外模板文件，也必须在此目录。模板文件设置留空表示使用默认模板。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块允许设置六个参数，不同参数之间用英文逗号分隔“,”。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数一是排行方式（默认按总访问量），允许以下几种设置：1、“allvisit” - 按总访问量；2、“monthvisit” - 按月访问量；3、“weekvisit” - 按周访问量；4、“dayvisit” - 按日访问量；5、“allvote” - 按总推荐次数；6、“monthvote” - 按月推荐次数；7、“weekvote” - 按周推荐次数；8、“dayvote” - 按日推荐次数；9、“postdate” - 按最新入库；10、“toptime” - 按本站推荐；11、“goodnum” - 按收藏数量；12、“size” - 按文章字数；13、“lastupdate” - 按最近更新；<br>&nbsp;&nbsp;&nbsp;&nbsp;参数二是显示行数，使用整数（默认 15）<br>&nbsp;&nbsp;&nbsp;&nbsp;参数三是文章类别（默认 0 表示所有类别），此处使用得是类别序号而不是名称，比如“玄幻小说”类别序号是 3 ，这里就设置成 3，如果要同时选择多个类别，可以用“|”分隔，比如 3|4|7<br>&nbsp;&nbsp;&nbsp;&nbsp;参数四是指是否原创（默认 0 表示不判断），1 表示只显示原创作品，2 表示转载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数五是指是否全本（默认 0 表示不判断），1 表示只显示全本作品，2 表示连载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数六是指显示顺序（默认 0 表示按从大到小排序），1 表示从小到大排序。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数设置中一项或者多项留空均表示使用默认值。例子： “lastupdate,,0,1,0,0” 表示显示15条最近更新的原创作品，其中第二个参数留空，所以使用默认的15条。', '', 'postdate,15,0,0,0,0', 'block_postdate.html', 0, 4, 22000, 0, 0, 0, 0, 1),
(40, '最新书评', 'article', 'block_reviewslist', 'BlockArticleReviewslist', 0, '最新书评', '&nbsp;&nbsp;&nbsp;&nbsp;本区块允许用户自定义模板和参数，并且不同的设置可以保存成不同的区块。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块默认模板文件为“block_reviewslist.html”，在/modules/article/templates/blocks目录下，如果您定义了另外模板文件，也必须在此目录。模板文件设置留空表示使用默认模板。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块允许设置四个参数，不同参数之间用英文逗号分隔“,”。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数一是显示行数，使用整数（默认 10）<br>&nbsp;&nbsp;&nbsp;&nbsp;参数二是指是否置顶书评（默认 0 表示不判断），1 表示只显示置顶书评，2 表示非置顶书评<br>&nbsp;&nbsp;&nbsp;&nbsp;参数三是指是否精华书评（默认 0 表示不判断），1 表示只显示精华书评，2 表示非精华书评<br>&nbsp;&nbsp;&nbsp;&nbsp;参数四是指每条书评最大显示长度，必须是整数（默认 64 ，单位是字节，相当于 32 个汉字）<br>&nbsp;&nbsp;&nbsp;&nbsp;参数设置中一项或者多项留空均表示使用默认值。例子： “15,0,1,64” 表示显示15条最新精华书评。', '', '10,0,0,64', 'block_reviewslist.html', 0, 1, 22100, 0, 0, 0, 0, 1),
(41, '收藏排行', 'article', 'block_articlelist', 'BlockArticleArticlelist', 5, '收藏排行', '&nbsp;&nbsp;&nbsp;&nbsp;本区块允许用户自定义模板和参数，并且不同的设置可以保存成不同的区块。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块默认模板文件为“block_articlelist.html”，在/modules/article/templates/blocks目录下，如果您定义了另外模板文件，也必须在此目录。模板文件设置留空表示使用默认模板。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块允许设置六个参数，不同参数之间用英文逗号分隔“,”。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数一是排行方式（默认按总访问量），允许以下几种设置：1、“allvisit” - 按总访问量；2、“monthvisit” - 按月访问量；3、“weekvisit” - 按周访问量；4、“dayvisit” - 按日访问量；5、“allvote” - 按总推荐次数；6、“monthvote” - 按月推荐次数；7、“weekvote” - 按周推荐次数；8、“dayvote” - 按日推荐次数；9、“postdate” - 按最新入库；10、“toptime” - 按本站推荐；11、“goodnum” - 按收藏数量；12、“size” - 按文章字数；13、“lastupdate” - 按最近更新；<br>&nbsp;&nbsp;&nbsp;&nbsp;参数二是显示行数，使用整数（默认 15）<br>&nbsp;&nbsp;&nbsp;&nbsp;参数三是文章类别（默认 0 表示所有类别），此处使用得是类别序号而不是名称，比如“玄幻小说”类别序号是 3 ，这里就设置成 3，如果要同时选择多个类别，可以用“|”分隔，比如 3|4|7<br>&nbsp;&nbsp;&nbsp;&nbsp;参数四是指是否原创（默认 0 表示不判断），1 表示只显示原创作品，2 表示转载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数五是指是否全本（默认 0 表示不判断），1 表示只显示全本作品，2 表示连载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数六是指显示顺序（默认 0 表示按从大到小排序），1 表示从小到大排序。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数设置中一项或者多项留空均表示使用默认值。例子： “lastupdate,,0,1,0,0” 表示显示15条最近更新的原创作品，其中第二个参数留空，所以使用默认的15条。', '', 'goodnum,15,0,0,0,0', 'block_goodnum.html', 0, 4, 22200, 0, 0, 0, 0, 1),
(42, '字数排行', 'article', 'block_articlelist', 'BlockArticleArticlelist', 5, '字数排行', '&nbsp;&nbsp;&nbsp;&nbsp;本区块允许用户自定义模板和参数，并且不同的设置可以保存成不同的区块。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块默认模板文件为“block_articlelist.html”，在/modules/article/templates/blocks目录下，如果您定义了另外模板文件，也必须在此目录。模板文件设置留空表示使用默认模板。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块允许设置六个参数，不同参数之间用英文逗号分隔“,”。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数一是排行方式（默认按总访问量），允许以下几种设置：1、“allvisit” - 按总访问量；2、“monthvisit” - 按月访问量；3、“weekvisit” - 按周访问量；4、“dayvisit” - 按日访问量；5、“allvote” - 按总推荐次数；6、“monthvote” - 按月推荐次数；7、“weekvote” - 按周推荐次数；8、“dayvote” - 按日推荐次数；9、“postdate” - 按最新入库；10、“toptime” - 按本站推荐；11、“goodnum” - 按收藏数量；12、“size” - 按文章字数；13、“lastupdate” - 按最近更新；<br>&nbsp;&nbsp;&nbsp;&nbsp;参数二是显示行数，使用整数（默认 15）<br>&nbsp;&nbsp;&nbsp;&nbsp;参数三是文章类别（默认 0 表示所有类别），此处使用得是类别序号而不是名称，比如“玄幻小说”类别序号是 3 ，这里就设置成 3，如果要同时选择多个类别，可以用“|”分隔，比如 3|4|7<br>&nbsp;&nbsp;&nbsp;&nbsp;参数四是指是否原创（默认 0 表示不判断），1 表示只显示原创作品，2 表示转载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数五是指是否全本（默认 0 表示不判断），1 表示只显示全本作品，2 表示连载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数六是指显示顺序（默认 0 表示按从大到小排序），1 表示从小到大排序。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数设置中一项或者多项留空均表示使用默认值。例子： “lastupdate,,0,1,0,0” 表示显示15条最近更新的原创作品，其中第二个参数留空，所以使用默认的15条。', '', 'size,15,0,0,0,0', 'block_size.html', 0, 4, 22300, 0, 0, 0, 0, 1),
(43, '我的原创文章', 'article', 'block_myarticles', 'BlockArticleMyarticles', 0, '我的原创文章', '', '', '', '', 0, 4, 22400, 1, 0, 0, 0, 0),
(44, '我的转载文章', 'article', 'block_transarticles', 'BlockArticleTransarticles', 0, '我的转载文章', '', '', '', '', 0, 4, 22500, 1, 0, 0, 0, 0),
(45, '作家工具箱', 'article', 'block_writerbox', 'BlockArticleWriterbox', 0, '作家工具箱', '', '', '', '', 0, 0, 22600, 1, 0, 0, 0, 0),
(46, '文章列表区块', 'article', 'block_articlelist', 'BlockArticleArticlelist', 0, '文章总排行', '&nbsp;&nbsp;&nbsp;&nbsp;本区块允许用户自定义模板和参数，并且不同的设置可以保存成不同的区块。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块默认模板文件为“block_articlelist.html”，在/modules/article/templates/blocks目录下，如果您定义了另外模板文件，也必须在此目录。模板文件设置留空表示使用默认模板。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块允许设置六个参数，不同参数之间用英文逗号分隔“,”。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数一是排行方式（默认按总访问量），允许以下几种设置：1、“allvisit” - 按总访问量；2、“monthvisit” - 按月访问量；3、“weekvisit” - 按周访问量；4、“dayvisit” - 按日访问量；5、“allvote” - 按总推荐次数；6、“monthvote” - 按月推荐次数；7、“weekvote” - 按周推荐次数；8、“dayvote” - 按日推荐次数；9、“postdate” - 按最新入库；10、“toptime” - 按本站推荐；11、“goodnum” - 按收藏数量；12、“size” - 按文章字数；13、“lastupdate” - 按最近更新；<br>&nbsp;&nbsp;&nbsp;&nbsp;参数二是显示行数，使用整数（默认 15）<br>&nbsp;&nbsp;&nbsp;&nbsp;参数三是文章类别（默认 0 表示所有类别），此处使用得是类别序号而不是名称，比如“玄幻小说”类别序号是 3 ，这里就设置成 3，如果要同时选择多个类别，可以用“|”分隔，比如 3|4|7<br>&nbsp;&nbsp;&nbsp;&nbsp;参数四是指是否原创（默认 0 表示不判断），1 表示只显示原创作品，2 表示转载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数五是指是否全本（默认 0 表示不判断），1 表示只显示全本作品，2 表示连载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数六是指显示顺序（默认 0 表示按从大到小排序），1 表示从小到大排序。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数设置中一项或者多项留空均表示使用默认值。例子： “lastupdate,,0,1,0,0” 表示显示15条最近更新的原创作品，其中第二个参数留空，所以使用默认的15条。', '', 'allvisit,15,0,0,0,0', 'block_articlelist.html', 0, 4, 23000, 0, 0, 0, 0, 1),
(47, '文章封面推荐', 'article', 'block_commend', 'BlockArticleCommend', 0, '封面推荐', '&nbsp;&nbsp;&nbsp;&nbsp;本区块允许用户自定义模板和参数，并且不同的设置可以保存成不同的区块。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块默认模板文件为“block_commend.html”，在/modules/article/templates/blocks目录下，如果您定义了另外模板文件，也必须在此目录。模板文件设置留空表示使用默认模板。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块允许设置推荐的文章序号作为参数，不同参数之间用英文“|”分隔。比如： “123|234|456|678” 表示本区块调用这四个序号文章信息显示', '', '', 'block_commend.html', 0, 1, 23100, 0, 0, 0, 0, 2),
(48, '用户文章', 'article', 'block_uarticles', 'BlockArticleUarticles', 6, '我的文章', '&nbsp;&nbsp;&nbsp;&nbsp;本区块显示某一用户的原创文章<br>&nbsp;&nbsp;&nbsp;&nbsp;允许设置五个参数，不同参数之间用英文逗号分隔“,”。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数一是排序字段，允许设置成“lastupdate”-更新时间，“postdate”-发表时间，“articleid”-文章ID，“allvisit”-总点击，“monthvisit”-月点击，“weekvisit”-周点击，“allvote”-总推荐，“monthvote”-月推荐，“weekvote”-周推荐，“size”-字数，“goodnum”-收藏数<br>&nbsp;&nbsp;&nbsp;&nbsp;参数二是显示几条记录，默认10<br>&nbsp;&nbsp;&nbsp;&nbsp;参数三是排序方式：0-从大到小，1-从小到大<br>&nbsp;&nbsp;&nbsp;&nbsp;参数四是显示哪个用户的友情链接，允许设置成“self”-当前用户，“uid”-url参数里面uid值对应的用户，“0”-所有用户，设置成大于0的一个整数，表示指定这个uid的用户<br>&nbsp;&nbsp;&nbsp;&nbsp;参数五全本标志，0-都显示，1-显示全本，2-显示非全本', '', 'lastupdate,10,0,uid,0', 'block_uarticles.html', 0, 4, 25100, 0, 0, 0, 0, 1),
(49, '用户书架', 'article', 'block_ubookcase', 'BlockArticleUbookcase', 6, '我的书架', '&nbsp;&nbsp;&nbsp;&nbsp;本区块显示某一用户的书架文章<br>&nbsp;&nbsp;&nbsp;&nbsp;允许设置四个参数，不同参数之间用英文逗号分隔“,”。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数一是排序字段，允许设置成“lastupdate”-更新时间，“joindate”-加入时间，“articleid”-文章ID，“caseid”-书架ID，“lastvisit”-最后访问时间<br>&nbsp;&nbsp;&nbsp;&nbsp;参数二是显示几条记录，默认10<br>&nbsp;&nbsp;&nbsp;&nbsp;参数三是排序方式：0-从大到小，1-从小到大<br>&nbsp;&nbsp;&nbsp;&nbsp;参数四是显示哪个用户的友情链接，允许设置成“self”-当前用户，“uid”-url参数里面uid值对应的用户，“0”-所有用户，设置成大于0的一个整数，表示指定这个uid的用户', '', 'lastupdate,10,0,uid', 'block_ubookcase.html', 0, 4, 25200, 0, 0, 0, 0, 1),
(50, '笔聚阁_封面推荐（4本）', 'article', 'block_commend', 'BlockArticleCommend', 0, '', '&nbsp;&nbsp;&nbsp;&nbsp;本区块允许用户自定义模板和参数，并且不同的设置可以保存成不同的区块。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块默认模板文件为“block_commend.html”，在/modules/article/templates/blocks目录下，如果您定义了另外模板文件，也必须在此目录。模板文件设置留空表示使用默认模板。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块允许设置推荐的文章序号作为参数，不同参数之间用英文“|”分隔。比如： “123|234|456|678” 表示本区块调用这四个序号文章信息显示', '', '1|2|3|4', 'bijuge_fm.html', 0, 1, 0, 0, 0, 0, 3, 2),
(51, '笔聚阁_首页公告牌', 'article', '', 'BlockSystemCustom', 0, '', '', '<li><span class="s1">[公告]</span><span class="s2"><a href="">净网2015，查找清理中，欢迎举报！</a></span></li>\r\n\r\n<li><span class="s1">[公告]</span><span class="s2"><a href="/jifen.html">用户等级以及获取积分的详细规则</a></span></li>\r\n\r\n<li><span class="s1">[帮助]</span><span class="s2"><a href="/dns.html">笔聚阁被跳转到别站的处理办法</a></span></li>', '', '', 0, 1, 1, 0, 1, 1, 3, 0),
(52, '笔聚阁_上期强推（4本）', 'article', 'block_commend', 'BlockArticleCommend', 0, '', '&nbsp;&nbsp;&nbsp;&nbsp;本区块允许用户自定义模板和参数，并且不同的设置可以保存成不同的区块。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块默认模板文件为“block_commend.html”，在/modules/article/templates/blocks目录下，如果您定义了另外模板文件，也必须在此目录。模板文件设置留空表示使用默认模板。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块允许设置推荐的文章序号作为参数，不同参数之间用英文“|”分隔。比如： “123|234|456|678” 表示本区块调用这四个序号文章信息显示', '', '5|6|7|8', 'bijuge_shangqi.html', 0, 1, 0, 0, 0, 0, 3, 2),
(53, '笔聚阁_首页玄幻小说', 'article', 'block_articlelist', 'BlockArticleArticlelist', 0, '玄幻小说', '&nbsp;&nbsp;&nbsp;&nbsp;本区块允许用户自定义模板和参数，并且不同的设置可以保存成不同的区块。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块默认模板文件为“block_articlelist.html”，在/modules/article/templates/blocks目录下，如果您定义了另外模板文件，也必须在此目录。模板文件设置留空表示使用默认模板。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块允许设置六个参数，不同参数之间用英文逗号分隔“,”。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数一是排行方式（默认按总访问量），允许以下几种设置：1、“allvisit” - 按总访问量；2、“monthvisit” - 按月访问量；3、“weekvisit” - 按周访问量；4、“dayvisit” - 按日访问量；5、“allvote” - 按总推荐次数；6、“monthvote” - 按月推荐次数；7、“weekvote” - 按周推荐次数；8、“dayvote” - 按日推荐次数；9、“postdate” - 按最新入库；10、“toptime” - 按本站推荐；11、“goodnum” - 按收藏数量；12、“size” - 按文章字数；13、“lastupdate” - 按最近更新；<br>&nbsp;&nbsp;&nbsp;&nbsp;参数二是显示行数，使用整数（默认 15）<br>&nbsp;&nbsp;&nbsp;&nbsp;参数三是文章类别（默认 0 表示所有类别），此处使用得是类别序号而不是名称，比如“玄幻小说”类别序号是 3 ，这里就设置成 3，如果要同时选择多个类别，可以用“|”分隔，比如 3|4|7<br>&nbsp;&nbsp;&nbsp;&nbsp;参数四是指是否原创（默认 0 表示不判断），1 表示只显示原创作品，2 表示转载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数五是指是否全本（默认 0 表示不判断），1 表示只显示全本作品，2 表示连载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数六是指显示顺序（默认 0 表示按从大到小排序），1 表示从小到大排序。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数设置中一项或者多项留空均表示使用默认值。例子： “lastupdate,,0,1,0,0” 表示显示15条最近更新的原创作品，其中第二个参数留空，所以使用默认的15条。', '', 'allvisit,13,1,0,0,0', 'bijuge_index_sort.html', 0, 4, 10, 0, 0, 0, 3, 1),
(54, '笔聚阁_首页修真小说', 'article', 'block_articlelist', 'BlockArticleArticlelist', 0, '修真小说', '&nbsp;&nbsp;&nbsp;&nbsp;本区块允许用户自定义模板和参数，并且不同的设置可以保存成不同的区块。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块默认模板文件为“block_articlelist.html”，在/modules/article/templates/blocks目录下，如果您定义了另外模板文件，也必须在此目录。模板文件设置留空表示使用默认模板。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块允许设置六个参数，不同参数之间用英文逗号分隔“,”。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数一是排行方式（默认按总访问量），允许以下几种设置：1、“allvisit” - 按总访问量；2、“monthvisit” - 按月访问量；3、“weekvisit” - 按周访问量；4、“dayvisit” - 按日访问量；5、“allvote” - 按总推荐次数；6、“monthvote” - 按月推荐次数；7、“weekvote” - 按周推荐次数；8、“dayvote” - 按日推荐次数；9、“postdate” - 按最新入库；10、“toptime” - 按本站推荐；11、“goodnum” - 按收藏数量；12、“size” - 按文章字数；13、“lastupdate” - 按最近更新；<br>&nbsp;&nbsp;&nbsp;&nbsp;参数二是显示行数，使用整数（默认 15）<br>&nbsp;&nbsp;&nbsp;&nbsp;参数三是文章类别（默认 0 表示所有类别），此处使用得是类别序号而不是名称，比如“玄幻小说”类别序号是 3 ，这里就设置成 3，如果要同时选择多个类别，可以用“|”分隔，比如 3|4|7<br>&nbsp;&nbsp;&nbsp;&nbsp;参数四是指是否原创（默认 0 表示不判断），1 表示只显示原创作品，2 表示转载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数五是指是否全本（默认 0 表示不判断），1 表示只显示全本作品，2 表示连载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数六是指显示顺序（默认 0 表示按从大到小排序），1 表示从小到大排序。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数设置中一项或者多项留空均表示使用默认值。例子： “lastupdate,,0,1,0,0” 表示显示15条最近更新的原创作品，其中第二个参数留空，所以使用默认的15条。', '', 'allvisit,13,2,0,0,0', 'bijuge_index_sort.html', 0, 4, 10, 0, 0, 0, 3, 1),
(55, '笔聚阁_首页都市小说', 'article', 'block_articlelist', 'BlockArticleArticlelist', 0, '都市小说', '&nbsp;&nbsp;&nbsp;&nbsp;本区块允许用户自定义模板和参数，并且不同的设置可以保存成不同的区块。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块默认模板文件为“block_articlelist.html”，在/modules/article/templates/blocks目录下，如果您定义了另外模板文件，也必须在此目录。模板文件设置留空表示使用默认模板。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块允许设置六个参数，不同参数之间用英文逗号分隔“,”。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数一是排行方式（默认按总访问量），允许以下几种设置：1、“allvisit” - 按总访问量；2、“monthvisit” - 按月访问量；3、“weekvisit” - 按周访问量；4、“dayvisit” - 按日访问量；5、“allvote” - 按总推荐次数；6、“monthvote” - 按月推荐次数；7、“weekvote” - 按周推荐次数；8、“dayvote” - 按日推荐次数；9、“postdate” - 按最新入库；10、“toptime” - 按本站推荐；11、“goodnum” - 按收藏数量；12、“size” - 按文章字数；13、“lastupdate” - 按最近更新；<br>&nbsp;&nbsp;&nbsp;&nbsp;参数二是显示行数，使用整数（默认 15）<br>&nbsp;&nbsp;&nbsp;&nbsp;参数三是文章类别（默认 0 表示所有类别），此处使用得是类别序号而不是名称，比如“玄幻小说”类别序号是 3 ，这里就设置成 3，如果要同时选择多个类别，可以用“|”分隔，比如 3|4|7<br>&nbsp;&nbsp;&nbsp;&nbsp;参数四是指是否原创（默认 0 表示不判断），1 表示只显示原创作品，2 表示转载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数五是指是否全本（默认 0 表示不判断），1 表示只显示全本作品，2 表示连载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数六是指显示顺序（默认 0 表示按从大到小排序），1 表示从小到大排序。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数设置中一项或者多项留空均表示使用默认值。例子： “lastupdate,,0,1,0,0” 表示显示15条最近更新的原创作品，其中第二个参数留空，所以使用默认的15条。', '', 'allvisit,13,3,0,0,0', 'bijuge_index_sort.html', 0, 4, 10, 0, 0, 0, 3, 1),
(56, '笔聚阁_首页穿越小说', 'article', 'block_articlelist', 'BlockArticleArticlelist', 0, '穿越小说', '&nbsp;&nbsp;&nbsp;&nbsp;本区块允许用户自定义模板和参数，并且不同的设置可以保存成不同的区块。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块默认模板文件为“block_articlelist.html”，在/modules/article/templates/blocks目录下，如果您定义了另外模板文件，也必须在此目录。模板文件设置留空表示使用默认模板。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块允许设置六个参数，不同参数之间用英文逗号分隔“,”。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数一是排行方式（默认按总访问量），允许以下几种设置：1、“allvisit” - 按总访问量；2、“monthvisit” - 按月访问量；3、“weekvisit” - 按周访问量；4、“dayvisit” - 按日访问量；5、“allvote” - 按总推荐次数；6、“monthvote” - 按月推荐次数；7、“weekvote” - 按周推荐次数；8、“dayvote” - 按日推荐次数；9、“postdate” - 按最新入库；10、“toptime” - 按本站推荐；11、“goodnum” - 按收藏数量；12、“size” - 按文章字数；13、“lastupdate” - 按最近更新；<br>&nbsp;&nbsp;&nbsp;&nbsp;参数二是显示行数，使用整数（默认 15）<br>&nbsp;&nbsp;&nbsp;&nbsp;参数三是文章类别（默认 0 表示所有类别），此处使用得是类别序号而不是名称，比如“玄幻小说”类别序号是 3 ，这里就设置成 3，如果要同时选择多个类别，可以用“|”分隔，比如 3|4|7<br>&nbsp;&nbsp;&nbsp;&nbsp;参数四是指是否原创（默认 0 表示不判断），1 表示只显示原创作品，2 表示转载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数五是指是否全本（默认 0 表示不判断），1 表示只显示全本作品，2 表示连载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数六是指显示顺序（默认 0 表示按从大到小排序），1 表示从小到大排序。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数设置中一项或者多项留空均表示使用默认值。例子： “lastupdate,,0,1,0,0” 表示显示15条最近更新的原创作品，其中第二个参数留空，所以使用默认的15条。', '', 'allvisit,13,4,0,0,0', 'bijuge_index_sort.html', 0, 4, 10, 0, 0, 0, 3, 1),
(57, '笔聚阁_首页网游小说', 'article', 'block_articlelist', 'BlockArticleArticlelist', 0, '网游小说', '&nbsp;&nbsp;&nbsp;&nbsp;本区块允许用户自定义模板和参数，并且不同的设置可以保存成不同的区块。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块默认模板文件为“block_articlelist.html”，在/modules/article/templates/blocks目录下，如果您定义了另外模板文件，也必须在此目录。模板文件设置留空表示使用默认模板。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块允许设置六个参数，不同参数之间用英文逗号分隔“,”。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数一是排行方式（默认按总访问量），允许以下几种设置：1、“allvisit” - 按总访问量；2、“monthvisit” - 按月访问量；3、“weekvisit” - 按周访问量；4、“dayvisit” - 按日访问量；5、“allvote” - 按总推荐次数；6、“monthvote” - 按月推荐次数；7、“weekvote” - 按周推荐次数；8、“dayvote” - 按日推荐次数；9、“postdate” - 按最新入库；10、“toptime” - 按本站推荐；11、“goodnum” - 按收藏数量；12、“size” - 按文章字数；13、“lastupdate” - 按最近更新；<br>&nbsp;&nbsp;&nbsp;&nbsp;参数二是显示行数，使用整数（默认 15）<br>&nbsp;&nbsp;&nbsp;&nbsp;参数三是文章类别（默认 0 表示所有类别），此处使用得是类别序号而不是名称，比如“玄幻小说”类别序号是 3 ，这里就设置成 3，如果要同时选择多个类别，可以用“|”分隔，比如 3|4|7<br>&nbsp;&nbsp;&nbsp;&nbsp;参数四是指是否原创（默认 0 表示不判断），1 表示只显示原创作品，2 表示转载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数五是指是否全本（默认 0 表示不判断），1 表示只显示全本作品，2 表示连载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数六是指显示顺序（默认 0 表示按从大到小排序），1 表示从小到大排序。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数设置中一项或者多项留空均表示使用默认值。例子： “lastupdate,,0,1,0,0” 表示显示15条最近更新的原创作品，其中第二个参数留空，所以使用默认的15条。', '', 'allvisit,13,5,0,0,0', 'bijuge_index_sort.html', 0, 4, 10, 0, 0, 0, 3, 1),
(58, '笔聚阁_首页科幻小说', 'article', 'block_articlelist', 'BlockArticleArticlelist', 0, '科幻小说', '&nbsp;&nbsp;&nbsp;&nbsp;本区块允许用户自定义模板和参数，并且不同的设置可以保存成不同的区块。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块默认模板文件为“block_articlelist.html”，在/modules/article/templates/blocks目录下，如果您定义了另外模板文件，也必须在此目录。模板文件设置留空表示使用默认模板。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块允许设置六个参数，不同参数之间用英文逗号分隔“,”。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数一是排行方式（默认按总访问量），允许以下几种设置：1、“allvisit” - 按总访问量；2、“monthvisit” - 按月访问量；3、“weekvisit” - 按周访问量；4、“dayvisit” - 按日访问量；5、“allvote” - 按总推荐次数；6、“monthvote” - 按月推荐次数；7、“weekvote” - 按周推荐次数；8、“dayvote” - 按日推荐次数；9、“postdate” - 按最新入库；10、“toptime” - 按本站推荐；11、“goodnum” - 按收藏数量；12、“size” - 按文章字数；13、“lastupdate” - 按最近更新；<br>&nbsp;&nbsp;&nbsp;&nbsp;参数二是显示行数，使用整数（默认 15）<br>&nbsp;&nbsp;&nbsp;&nbsp;参数三是文章类别（默认 0 表示所有类别），此处使用得是类别序号而不是名称，比如“玄幻小说”类别序号是 3 ，这里就设置成 3，如果要同时选择多个类别，可以用“|”分隔，比如 3|4|7<br>&nbsp;&nbsp;&nbsp;&nbsp;参数四是指是否原创（默认 0 表示不判断），1 表示只显示原创作品，2 表示转载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数五是指是否全本（默认 0 表示不判断），1 表示只显示全本作品，2 表示连载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数六是指显示顺序（默认 0 表示按从大到小排序），1 表示从小到大排序。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数设置中一项或者多项留空均表示使用默认值。例子： “lastupdate,,0,1,0,0” 表示显示15条最近更新的原创作品，其中第二个参数留空，所以使用默认的15条。', '', 'allvisit,13,6,0,0,0', 'bijuge_index_sort.html', 0, 4, 10, 0, 0, 0, 3, 1),
(59, '笔聚阁_友情链接', 'article', '', 'BlockSystemCustom', 0, '', '', '<a href="http://www.bijuge.com/" target="_blank">免费小说</a>', '', '', 0, 1, 0, 0, 1, 1, 3, 0),
(60, '笔聚阁_首页女生小说', 'article', 'block_articlelist', 'BlockArticleArticlelist', 0, '女生小说', '&nbsp;&nbsp;&nbsp;&nbsp;本区块允许用户自定义模板和参数，并且不同的设置可以保存成不同的区块。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块默认模板文件为“block_articlelist.html”，在/modules/article/templates/blocks目录下，如果您定义了另外模板文件，也必须在此目录。模板文件设置留空表示使用默认模板。<br>&nbsp;&nbsp;&nbsp;&nbsp;区块允许设置六个参数，不同参数之间用英文逗号分隔“,”。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数一是排行方式（默认按总访问量），允许以下几种设置：1、“allvisit” - 按总访问量；2、“monthvisit” - 按月访问量；3、“weekvisit” - 按周访问量；4、“dayvisit” - 按日访问量；5、“allvote” - 按总推荐次数；6、“monthvote” - 按月推荐次数；7、“weekvote” - 按周推荐次数；8、“dayvote” - 按日推荐次数；9、“postdate” - 按最新入库；10、“toptime” - 按本站推荐；11、“goodnum” - 按收藏数量；12、“size” - 按文章字数；13、“lastupdate” - 按最近更新；<br>&nbsp;&nbsp;&nbsp;&nbsp;参数二是显示行数，使用整数（默认 15）<br>&nbsp;&nbsp;&nbsp;&nbsp;参数三是文章类别（默认 0 表示所有类别），此处使用得是类别序号而不是名称，比如“玄幻小说”类别序号是 3 ，这里就设置成 3，如果要同时选择多个类别，可以用“|”分隔，比如 3|4|7<br>&nbsp;&nbsp;&nbsp;&nbsp;参数四是指是否原创（默认 0 表示不判断），1 表示只显示原创作品，2 表示转载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数五是指是否全本（默认 0 表示不判断），1 表示只显示全本作品，2 表示连载作品<br>&nbsp;&nbsp;&nbsp;&nbsp;参数六是指显示顺序（默认 0 表示按从大到小排序），1 表示从小到大排序。<br>&nbsp;&nbsp;&nbsp;&nbsp;参数设置中一项或者多项留空均表示使用默认值。例子： “lastupdate,,0,1,0,0” 表示显示15条最近更新的原创作品，其中第二个参数留空，所以使用默认的15条。', '', 'allvisit,13,7,0,0,0', 'bijuge_index_sort.html', 0, 4, 10, 0, 0, 0, 3, 1);
