DROP TABLE IF EXISTS `jieqi_obook_obook`;
CREATE TABLE `jieqi_obook_obook` (
  `obookid` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `siteid` int(11) unsigned NOT NULL DEFAULT '0',
  `sourceid` int(11) unsigned NOT NULL DEFAULT '0',
  `postdate` int(11) unsigned NOT NULL DEFAULT '0',
  `lastupdate` int(11) unsigned NOT NULL DEFAULT '0',
  `obookname` varchar(100) binary NOT NULL DEFAULT '',
  `keywords` varchar(255) NOT NULL DEFAULT '',
  `articleid` int(11) unsigned NOT NULL DEFAULT '0',
  `initial` char(1) NOT NULL DEFAULT '',
  `sortid` smallint(6) unsigned NOT NULL DEFAULT '0',
  `intro` text,
  `notice` text,
  `setting` text,
  `lastvolumeid` int(11) unsigned NOT NULL DEFAULT '0',
  `lastvolume` varchar(255) NOT NULL DEFAULT '',
  `lastchapterid` int(11) unsigned NOT NULL DEFAULT '0',
  `lastchapter` varchar(255) NOT NULL DEFAULT '',
  `lastsummary` text,
  `chapters` smallint(6) unsigned NOT NULL DEFAULT '0',
  `size` int(11) unsigned NOT NULL DEFAULT '0',
  `authorid` int(11) unsigned NOT NULL DEFAULT '0',
  `author` varchar(50) binary NOT NULL DEFAULT '',
  `aintro` text,
  `agentid` int(11) unsigned NOT NULL DEFAULT '0',
  `agent` varchar(50) binary NOT NULL DEFAULT '',
  `posterid` int(11) unsigned NOT NULL DEFAULT '0',
  `poster` varchar(50) binary NOT NULL DEFAULT '',
  `publishid` int(11) unsigned NOT NULL DEFAULT '0',
  `tbookinfo` text,
  `toptime` int(11) unsigned NOT NULL DEFAULT '0',
  `goodnum` int(11) unsigned NOT NULL DEFAULT '0',
  `badnum` int(11) unsigned NOT NULL DEFAULT '0',
  `fullflag` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `imgflag` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `saleprice` int(11) unsigned NOT NULL DEFAULT '0',
  `vipprice` int(11) unsigned NOT NULL DEFAULT '0',
  `sumegold` int(11) unsigned NOT NULL DEFAULT '0',
  `sumesilver` int(11) unsigned NOT NULL DEFAULT '0',
  `sumtip` int(11) unsigned NOT NULL DEFAULT '0',
  `sumhurry` int(11) unsigned NOT NULL DEFAULT '0',
  `sumbesp` int(11) unsigned NOT NULL DEFAULT '0',
  `sumaward` int(11) unsigned NOT NULL DEFAULT '0',
  `sumagent` int(11) unsigned NOT NULL DEFAULT '0',
  `sumgift` int(11) unsigned NOT NULL DEFAULT '0',
  `sumother` int(11) unsigned NOT NULL DEFAULT '0',
  `sumemoney` int(11) unsigned NOT NULL DEFAULT '0',
  `summoney` int(11) unsigned NOT NULL DEFAULT '0',
  `paidmoney` int(11) unsigned NOT NULL DEFAULT '0',
  `paidemoney` int(11) unsigned NOT NULL DEFAULT '0',
  `paytime` int(11) unsigned NOT NULL DEFAULT '0',
  `normalsale` int(11) unsigned NOT NULL DEFAULT '0',
  `vipsale` int(11) unsigned NOT NULL DEFAULT '0',
  `freesale` int(11) unsigned NOT NULL DEFAULT '0',
  `bespsale` int(11) unsigned NOT NULL DEFAULT '0',
  `totalsale` int(11) unsigned NOT NULL DEFAULT '0',
  `daysale` int(11) unsigned NOT NULL DEFAULT '0',
  `weeksale` int(11) unsigned NOT NULL DEFAULT '0',
  `monthsale` int(11) unsigned NOT NULL DEFAULT '0',
  `allsale` int(11) unsigned NOT NULL DEFAULT '0',
  `lastsale` int(11) unsigned NOT NULL DEFAULT '0',
  `canvip` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `canfree` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `canbesp` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `hasebook` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `hastbook` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `state` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `flag` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `display` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`obookid`),
  KEY `articleid` (`articleid`),
  KEY `obookname` (`obookname`),
  KEY `display` (`display`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `jieqi_obook_obuy`;
CREATE TABLE `jieqi_obook_obuy` (
  `obuyid` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `siteid` smallint(6) unsigned NOT NULL DEFAULT '0',
  `osaleid` int(11) unsigned NOT NULL DEFAULT '0',
  `buytime` int(11) unsigned NOT NULL DEFAULT '0',
  `lastbuy` int(11) unsigned NOT NULL DEFAULT '0',
  `lastread` int(11) unsigned NOT NULL DEFAULT '0',
  `readnum` int(11) unsigned NOT NULL DEFAULT '0',
  `userid` int(11) unsigned NOT NULL DEFAULT '0',
  `username` varchar(30) NOT NULL DEFAULT '',
  `articleid` int(11) unsigned NOT NULL DEFAULT '0',
  `obookid` int(11) unsigned NOT NULL DEFAULT '0',
  `ochapterid` int(11) unsigned NOT NULL DEFAULT '0',
  `obookname` varchar(100) binary NOT NULL DEFAULT '',
  `chaptername` varchar(100) NOT NULL DEFAULT '',
  `chapternum` int(11) unsigned NOT NULL DEFAULT '0',
  `buynum` int(11) unsigned NOT NULL DEFAULT '0',
  `buypay` int(11) unsigned NOT NULL DEFAULT '0',
  `isread` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `isfull` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `autobuy` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `buymode` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `starlevel` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `oflag` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`obuyid`),
  UNIQUE KEY `userid` (`userid`,`obookid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `jieqi_obook_obuyinfo`;
CREATE TABLE `jieqi_obook_obuyinfo` (
  `obuyinfoid` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `siteid` smallint(6) unsigned NOT NULL DEFAULT '0',
  `osaleid` int(11) unsigned NOT NULL DEFAULT '0',
  `buytime` int(11) unsigned NOT NULL DEFAULT '0',
  `userid` int(11) unsigned NOT NULL DEFAULT '0',
  `username` varchar(30) NOT NULL DEFAULT '',
  `articleid` int(11) unsigned NOT NULL DEFAULT '0',
  `obookid` int(11) unsigned NOT NULL DEFAULT '0',
  `ochapterid` int(11) unsigned NOT NULL DEFAULT '0',
  `obookname` varchar(100) binary NOT NULL DEFAULT '',
  `chaptername` varchar(100) NOT NULL DEFAULT '',
  `lastread` int(11) unsigned NOT NULL DEFAULT '0',
  `readnum` int(11) unsigned NOT NULL DEFAULT '0',
  `checkcode` varchar(10) NOT NULL DEFAULT '',
  `buyprice` int(11) unsigned NOT NULL DEFAULT '0',
  `buynum` int(11) unsigned NOT NULL DEFAULT '0',
  `buypay` int(11) unsigned NOT NULL DEFAULT '0',
  `state` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `flag` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`obuyinfoid`),
  KEY `userid` (`userid`),
  KEY `obookid` (`obookid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `jieqi_obook_ochapter`;
CREATE TABLE `jieqi_obook_ochapter` (
  `ochapterid` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `siteid` int(11) unsigned NOT NULL DEFAULT '0',
  `sourceid` int(11) unsigned NOT NULL DEFAULT '0',
  `sourcecid` int(11) unsigned NOT NULL DEFAULT '0',
  `sourcecorder` int(11) unsigned NOT NULL DEFAULT '0',
  `obookid` int(11) unsigned NOT NULL DEFAULT '0',
  `articleid` int(11) unsigned NOT NULL DEFAULT '0',
  `chapterid` int(11) unsigned NOT NULL DEFAULT '0',
  `postdate` int(11) unsigned NOT NULL DEFAULT '0',
  `lastupdate` int(11) unsigned NOT NULL DEFAULT '0',
  `buytime` int(11) unsigned NOT NULL DEFAULT '0',
  `obookname` varchar(100) NOT NULL DEFAULT '',
  `chaptername` varchar(100) NOT NULL DEFAULT '',
  `chaptertype` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `chapterorder` smallint(6) unsigned NOT NULL DEFAULT '0',
  `volumeid` int(11) unsigned NOT NULL DEFAULT '0',
  `summary` text,
  `size` int(11) unsigned NOT NULL DEFAULT '0',
  `pages` smallint(6) unsigned NOT NULL DEFAULT '0',
  `posterid` int(11) unsigned NOT NULL DEFAULT '0',
  `poster` varchar(50) NOT NULL DEFAULT '',
  `toptime` int(11) unsigned NOT NULL DEFAULT '0',
  `picflag` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `saleprice` int(11) unsigned NOT NULL DEFAULT '0',
  `vipprice` int(11) unsigned NOT NULL DEFAULT '0',
  `sumegold` int(11) unsigned NOT NULL DEFAULT '0',
  `sumesilver` int(11) unsigned NOT NULL DEFAULT '0',
  `normalsale` int(11) unsigned NOT NULL DEFAULT '0',
  `vipsale` int(11) unsigned NOT NULL DEFAULT '0',
  `freesale` int(11) unsigned NOT NULL DEFAULT '0',
  `bespsale` int(11) unsigned NOT NULL DEFAULT '0',
  `totalsale` int(11) unsigned NOT NULL DEFAULT '0',
  `daysale` int(11) unsigned NOT NULL DEFAULT '0',
  `weeksale` int(11) unsigned NOT NULL DEFAULT '0',
  `monthsale` int(11) unsigned NOT NULL DEFAULT '0',
  `allsale` int(11) unsigned NOT NULL DEFAULT '0',
  `lastsale` int(11) unsigned NOT NULL DEFAULT '0',
  `state` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `flag` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `display` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ochapterid`),
  KEY `obookid` (`obookid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `jieqi_obook_ocontent`;
CREATE TABLE `jieqi_obook_ocontent` (
  `ochapterid` int(11) unsigned NOT NULL DEFAULT '0',
  `ocontent` mediumtext,
  UNIQUE KEY `ochapterid` (`ochapterid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `jieqi_obook_osale`;
CREATE TABLE `jieqi_obook_osale` (
  `osaleid` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `siteid` smallint(6) unsigned NOT NULL DEFAULT '0',
  `buytime` int(11) unsigned NOT NULL DEFAULT '0',
  `accountid` int(11) unsigned NOT NULL DEFAULT '0',
  `account` varchar(30) NOT NULL DEFAULT '',
  `articleid` int(11) unsigned NOT NULL DEFAULT '0',
  `obookid` int(11) unsigned NOT NULL DEFAULT '0',
  `ochapterid` int(11) unsigned NOT NULL DEFAULT '0',
  `obookname` varchar(100) binary NOT NULL DEFAULT '',
  `chaptername` varchar(100) NOT NULL DEFAULT '',
  `saleprice` int(11) unsigned NOT NULL DEFAULT '0',
  `salenum` int(11) unsigned NOT NULL DEFAULT '0',
  `sumprice` int(11) unsigned NOT NULL DEFAULT '0',
  `pricetype` tinyint(1) NOT NULL DEFAULT '0',
  `paytype` tinyint(1) NOT NULL DEFAULT '0',
  `payflag` tinyint(1) NOT NULL DEFAULT '0',
  `paynote` varchar(255) NOT NULL DEFAULT '',
  `state` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `flag` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`osaleid`),
  KEY `accountid` (`accountid`),
  KEY `obookid` (`obookid`),
  KEY `ochapterid` (`ochapterid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `jieqi_obook_paidlog`;
CREATE TABLE `jieqi_obook_paidlog` (
  `paidid` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `paytime` int(11) unsigned NOT NULL DEFAULT '0',
  `userid` int(11) unsigned NOT NULL DEFAULT '0',
  `username` varchar(30) NOT NULL DEFAULT '',
  `masterid` int(11) unsigned NOT NULL DEFAULT '0',
  `master` varchar(30) NOT NULL DEFAULT '',
  `obookid` int(11) unsigned NOT NULL DEFAULT '0',
  `obookname` varchar(100) NOT NULL DEFAULT '',
  `articleid` int(11) unsigned NOT NULL DEFAULT '0',
  `sumegold` int(11) NOT NULL DEFAULT '0',
  `sumesilver` int(11) NOT NULL DEFAULT '0',
  `sumemoney` int(11) NOT NULL DEFAULT '0',
  `paidemoney` int(11) NOT NULL DEFAULT '0',
  `payemoney` int(11) NOT NULL DEFAULT '0',
  `remainemoney` int(11) NOT NULL DEFAULT '0',
  `summoney` int(11) NOT NULL DEFAULT '0',
  `paymoney` int(11) NOT NULL DEFAULT '0',
  `remainmoney` int(11) NOT NULL DEFAULT '0',
  `paidcurrency` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `paidtype` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `paidflag` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `payinfo` text,
  `paynote` text,
  PRIMARY KEY (`paidid`),
  KEY `userid` (`userid`),
  KEY `obookid` (`obookid`),
  KEY `articleid` (`articleid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;