<?php

/**
 * 获取和设置配置参数 支持批量定义
 * @param string|array $name 配置变量
 * @param mixed $value 配置值
 * @param mixed $default 默认值
 * @return mixed
 */
function C($name=null, $value=null,$default=null) {
    static $_config = [];
	static $__config = [];
    // 无参数时获取所有
    if (empty($name)) {
        return $_config;
    }
    // 优先执行设置获取或赋值
    if (is_string($name)) {
		//如果存在分隔符说明来自模块或者插件
		$dir=false;//为插件或者模块所在路径
		if(empty($name)==FALSE && strpos($name, '|')){
			list($dir,$name)=explode('|',$name);
			$dir=strtoupper($dir);
		}
        if (!strpos($name, '.')) {
            $name = strtoupper($name);
            if (is_null($value)){
				//判断是否启用了高速缓存
				if(CACHING==true && !$_config['LOAD_CACHE_OK']){
					$_config['LOAD_CACHE_OK']=true;
					$config=\temmoku\vendor\think\cache::get('_config');
					$_config = array_merge($__config, $config);
				}
                return $dir && isset($_config[$dir][$name]) ? $_config[$dir][$name] : ( isset($_config[$name]) ? $_config[$name] : $default) ;
			}
			$dir ?  $_config[$dir][$name] = $value :  $_config[$name] = $value;
			CACHING==true ? ($dir ?  $__config[$dir][$name] = $value :  $__config[$name] = $value) : '';
            return null;
        }
        // 二维数组设置和获取支持
        $name = explode('.', $name);
        $name[0]   =  strtoupper($name[0]);
        if (is_null($value)){
			//判断是否启用了高速缓存
			if(CACHING==true && !$_config['LOAD_CACHE_OK']){
				$_config['LOAD_CACHE_OK']=true;
				$config=\temmoku\vendor\think\cache::get('_config');
				$_config = array_merge($_config, $config);
			}
            return $dir && isset($_config[$dir][$name[0]][$name[1]]) ? $_config[$dir][$name[0]][$name[1]] :( isset($_config[$name[0]][$name[1]]) ? $_config[$name[0]][$name[1]] : $default);
        }
		
		$dir ?  $_config[$dir][$name[0]][$name[1]] = $value :  $_config[$name[0]][$name[1]] = $value;
		CACHING==true ? ($dir ?  $__config[$dir][$name[0]][$name[1]] = $value :  $__config[$name[0]][$name[1]] = $value) : '';
        return null;
    }
	
    // 批量设置
    if (is_array($name)){
		
		$_config = array_merge_recursive($_config, array_change_key_case($name,CASE_UPPER));
		if(CACHING==true){
			$__config=$_config;
		}
        return null;
    }
    return null; // 避免非法参数
}

/**
 * 数据模型缓存
 */
function D() {
    return (new temmoku\db);
}

//错误类
function E($msg) {
	if(!defined('ENOSHOW')){
		if(APP_DEBUG==false){
			echo 'Not Found';
			http_response_code(404);
			exit;
		}
		echo "<pre>";
		throw new Exception($msg);
	}
}
/**
 * 拥有缓存功能
 * $table 数据库表名无需带前戳
 * $where	查询的字段
 * $order 	排序的方法可选 DESC  ASC
 * $Order_field	按照哪个字段进行排序
 * $rows 	输出行数
 * $select	输出哪些列
 */
function M($table='',$where='1',$order='DESC',$Order_field='id',$rows='10',$select='*', $tablePrefix=jab) {
	if('*'===$select){
		$_select='_';
	}
	
    $file=RUNTIME_PATH."m/".$table.$where.$order.$Order_field.$rows.$_select.$tablePrefix.".txt";
    if(is_file($file)){
    	$_time=filemtime ( $file )+3600;
    	//一个小时更新一次
    	if($_time>time()){
    		$file_contents=fils_content($file);
    		return unserialize($file_contents);
    	}
    }
    
    if(!strstr($table,$tablePrefix)){
    	$table       =  $tablePrefix . $table;
    }
	$sql="SELECT {$select} FROM `{$table}` WHERE {$where} ORDER BY {$Order_field} {$order}  LIMIT {$rows}";
    $_data = temmoku\db::query($sql);
    if(C('FUNCTION_M')){
    	write_file($file,serialize($_data));
    }
    return $_data;
}


/*
 * 替换屏蔽词
 * $content 为字符串
 */
function Shielding_words($content=''){
	$Shielding_words=explode('|',htmlspecialchars_decode(C('Shielding_words'),ENT_QUOTES));
	foreach($Shielding_words AS $V){
		list($oldv,$newv)=explode('&',$V);
		$newv ? $content=str_replace  ( $oldv , $newv , $content ) : $content=str_replace  ( $oldv , '**' , $content );
	}
	return $content;
}
/*
 * $dir 获取所有文件或者目录
 * 
 */
function Get_Flies($dir){
	!isset($dir) && $dir="";
	$dirs=Temmoku_PATH.$dir;
	//如果是文件而不是文件夹的话，就引用修改;否则则返回目录
	if(Is_Document($dirs)){
		$content=fils_content($dirs);
		return array("Result"=>'1','dir'=>"$dir",'content'=>"$content");
	}else{
		if ( $handle  =  opendir ( $dirs )) {
			while (( $file  =  readdir ( $handle ))!== false) {
			    if($file==='.' || $file==='..'){
			     	continue;
			    }
			    $r['is_file']=0;
			    $is_file=is_file($dirs."/".$file);
				if($is_file){
					$r['is_file']=1;
				}
				$r['file']=$file;
				$r['path']=$dir."/".$file;
			    $list[]=$r ;
			}
			//关闭打开的目录
			closedir ( $handle );
		}
	}
	return $list;
}

//获取缓存
function get_cache($dir){
	return fils_content($dir);
}

//获取文件内容
function fils_content($dir){
	if(file_exists($dir)){
		$content = file_get_contents($dir);//将整个文件内容读入到一个字符串中
	}
	return $content;
}



//将图片地址补全

function get_img_url($imgurl){
	return get_file_url($imgurl);
}

function get_file_url($path){
	if (preg_match('/(http|https):\/\/([\w\d\-_]+[\.\w\d\-_]+)[:\d+]?([\/]?[\w\/\.]+)/', $path )) {
		return $path;
	} else {
		if($path){
			$path=WEBURL."/".C('UPFILES_CATALOG').'/'.$path;
			return $path;
		}	
	}
}
	
//截取指定内容的字符
function Get_word_strpos($content,$leng='255',$encoding='UTF-8'){
	//去除html标签
	$content = strip_tags($content,"");
	$content=str_replace([" ","　","\t","\n","\r"], '', $content);  
	//将分页符替换掉
	$content=str_replace("##page##","",$content);
	return mb_substr($content,0,$leng,$encoding);
}
/*
 * 获取客户IP
 */
function getRealIp(){
	$ip=false;
	if(!empty($_SERVER["HTTP_CLIENT_IP"]) && preg_match('/^([0-9]{1,3}\.){3}[0-9]{1,3}$/', $_SERVER['HTTP_CLIENT_IP'])){
		$ip = $_SERVER["HTTP_CLIENT_IP"];
	}else if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
	    $ips = explode (", ", $_SERVER['HTTP_X_FORWARDED_FOR']);
		if ($ip) { array_unshift($ips, $ip); $ip = FALSE; }
		for ($i = 0; $i < count($ips); $i++) {
		    if (!preg_match ("/^(10│172.16│192.168)./", $ips[$i])) {
		       	$ip = $ips[$i];
		       	break;
		    }
		}
	}
	return ($ip ? $ip : $_SERVER['REMOTE_ADDR']);
}
/**
* 加密函数
* @param string $txt 需要加密的字符串
* @param string $key 密钥
* @return string 返回加密结果
*/
function encode($txt, $key = ''){
        if (empty($txt)) return $txt;
        if (empty($key)) $key = md5(C('MD5'));
        $chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_.";
        $ikey ="-x6g6ZWm2G9g_vr0Bo.pOq3kRIxsZ6rm";
        $nh1 = rand(0,64);
        $nh2 = rand(0,64);
        $nh3 = rand(0,64);
        $ch1 = $chars[$nh1];
        $ch2 = $chars[$nh2];
        $ch3 = $chars[$nh3];
        $nhnum = $nh1 + $nh2 + $nh3;
        $knum = 0;$i = 0;
        while(isset($key[$i])) $knum +=ord($key[$i++]);
        $mdKey = substr(md5(md5(md5($key.$ch1).$ch2.$ikey).$ch3),$nhnum%8,$knum%8 + 16);
        $txt = base64_encode(time().'_'.$txt);
        $txt = str_replace(array('+','/','='),array('-','_','.'),$txt);
        $tmp = '';
        $j=0;$k = 0;
        $tlen = strlen($txt);
        $klen = strlen($mdKey);
        for ($i=0; $i<$tlen; $i++) {
            $k = $k == $klen ? 0 : $k;
            $j = ($nhnum+strpos($chars,$txt[$i])+ord($mdKey[$k++]))%64;
            $tmp .= $chars[$j];
        }
        $tmplen = strlen($tmp);
        $tmp = substr_replace($tmp,$ch3,$nh2 % ++$tmplen,0);
        $tmp = substr_replace($tmp,$ch2,$nh1 % ++$tmplen,0);
        $tmp = substr_replace($tmp,$ch1,$knum % ++$tmplen,0);
        return $tmp;
}
   	/**
     * 解密函数
     * @param string $txt 需要解密的字符串
     * @param string $key 密匙
     * @return string 字符串类型的返回结果
     */
function decode($txt, $key = '', $ttl = 0){
        if (empty($txt)) return $txt;
        if (empty($key)) $key = md5(C('MD5'));
        $chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_.";
        $ikey ="-x6g6ZWm2G9g_vr0Bo.pOq3kRIxsZ6rm";
        $knum = 0;$i = 0;
        $tlen = @strlen($txt);
        while(isset($key[$i])) $knum +=ord($key[$i++]);
        $ch1 = @$txt[$knum % $tlen];
        $nh1 = strpos($chars,$ch1);
        $txt = @substr_replace($txt,'',$knum % $tlen--,1);
        $ch2 = @$txt[$nh1 % $tlen];
        $nh2 = @strpos($chars,$ch2);
        $txt = @substr_replace($txt,'',$nh1 % $tlen--,1);
        $ch3 = @$txt[$nh2 % $tlen];
        $nh3 = @strpos($chars,$ch3);
        $txt = @substr_replace($txt,'',$nh2 % $tlen--,1);
        $nhnum = $nh1 + $nh2 + $nh3;
        $mdKey = substr(md5(md5(md5($key.$ch1).$ch2.$ikey).$ch3),$nhnum % 8,$knum % 8 + 16);
        $tmp = '';
        $j=0; $k = 0;
        $tlen = @strlen($txt);
        $klen = @strlen($mdKey);
        for ($i=0; $i<$tlen; $i++) {
            $k = $k == $klen ? 0 : $k;
            $j = strpos($chars,$txt[$i])-$nhnum - ord($mdKey[$k++]);
            while ($j<0) $j+=64;
            $tmp .= $chars[$j];
        }
        $tmp = str_replace(array('-','_','.'),array('+','/','='),$tmp);
        $tmp = trim(base64_decode($tmp));
        if (preg_match("/\d{10}_/s",substr($tmp,0,11))){
            if ($ttl > 0 && (time() - substr($tmp,0,11) > $ttl)){
                $tmp = null;
            }else{
                $tmp = substr($tmp,11);
            }
        }
        return $tmp;
    }
    
//删除外链函数，返回STREET.如果存在白名单或者为自己主域名则不删除
function Articles_Del_link($content,$value=''){
	empty($value) && $value=C('Content_link_White_list');
	//核心设置了删除外链参数的话,执行，否则直接输出
	$Content_link_White_list=explode(PHP_EOL,$value);
	$host_rule = join('|', $Content_link_White_list);
	$host_rule = str_replace('.', "\\.", $host_rule);
	$host_rule = str_replace('/', "\\/", $host_rule);
	$arr = '';
	preg_match_all("#<a([^>]*)>(.*)<\/a>#iU", $content, $arr);
	if( is_array($arr[0]) )
	{
		$arr_url = [];
		$arr_title = [];
		foreach($arr[0] as $i=>$v){
		    if( $host_rule != '' && preg_match('#'.$host_rule.'#i', $arr[1][$i]) ){
		        continue;
		    } else {
		        $arr_url[] = $v;
		        $arr_title[] = $arr[2][$i];
		    }
		}
		if( !empty($arr_url) ){
		    $content = str_replace($arr_url, $arr_title, $content);
		}
	}
	$arr = $arr_url = $arr_title = '';
	return $content;
}
 //检测PHP设置参数
function is_php($varName)
{
	$data = get_cfg_var($varName);
	if('0'==$data){
		return '<font color="red">×</font>';
	}elseif('1'==$data){
		return '<font color="green">√</font>';
	}else{
		return $data;
	}
}
// 检测函数支持
function isfun($funName = '')
{
	if (!$funName || trim($funName) == '' || preg_match('~[^a-z0-9\_]+~i', $funName, $matches)) return '错误';
	return (false !== function_exists($funName)) ? '<font color="green">√</font>' : '<font color="red">×</font>';
}
//创建文件夹
 function write_dir($dir,$type='0'){
    $dir=pathinfo($dir);
    $dir=$dir['dirname'];
    if(!file_exists($dir)) {
    	if(!mkdir($dir,0777,true)) {
      		if($type==1){
    	  		return array("code"=>'401',"text"=>"创建文件夹失败，失败目录“{$dir}”请保证网站有写权限");
    	  	}else{
    	  		(new \temmoku\controller)->err("创建文件夹失败，失败目录“{$dir}”请保证网站有写权限");
    	  	}
    	}else{
    	 	if($type==1){
    	  		return array("code"=>'0',"text"=>"创建文件夹成功，成功目录“{$dir}”");
    		}
    	}
    }else{
    	if($type==1){
    		return array("code"=>'402',"text"=>"目录存在无需重复创建");
    	}
    }
}
/*
 * 递归删除文件夹
 * 删除$dir及$dir内的所有文件
 */
function delete_dir($dir){

	//判断目录是不是违法的，必须锁定下，防止误删。
	$not_del=[APP_PATH,Temmoku_PATH,Temmoku,TEMPLATE,TemmokuLib,APP_PATH.'plugin',APP_PATH.'plugin'.DS,TEMPLATE."admin".DS,TEMPLATE."admin",TEMPLATE."user".DS,TEMPLATE."user",TEMPLATE."home".DS,TEMPLATE."home"];
	
	if(!$dir || in_array($dir ,$not_del)){
		return;
	}

	if(is_dir($dir) || is_file($dir)){
		$path=$dir;
	}else{
		$path=Temmoku_PATH.$dir;
	}
	if(IS_WIN=='0' && function_exists('chomd')){
		chomd($path,'0777');
	}
	
	//判断是否是文件如果是文件，直接删除不需要遍历
	if(is_file($path)){
		@unlink ($path);
	}else{
		if ( $handle  =  @opendir ( $path )) {
			while (( $file  =  readdir ( $handle ))!== false) {
			    if($file==='.' || $file==='..'){
			     	continue;
			    }
				delete_dir($dir."/".$file);
			}
			//关闭打开的目录
			closedir ( $handle );
			rmdir ( $path );
		}
	}
}
/*创建文件
 * $dir必须是全地址
 * $content 为内容
 * $action为动作，默认覆盖文件
*/
function write_file($dir,$content='',$action='w'){
	$dir=str_caps_look($dir,1);
    write_dir($dir);
	$file = fopen($dir, $action);
	$content=stripslashes($content);
	fwrite($file,$content);
	fclose($file);
}

/*
 * 判断是文件还是目录
 */
function Is_Document($dir){
	return is_file($dir);
}

/* 移动附件 
 * $oldfile 为要移动文件地址
 * $dir_name保存的文件夹名称
 * $is_thumb 如果为ture 则裁剪
*/

function UploadFiles_MOVE($oldfile,$dir_name='',$is_thumb=false) {
    $_file=$oldfile;
    is_file($oldfile) ?  : $oldfile= Temmoku_PATH.C('UPFILES_CATALOG').'/'.$oldfile;
 
    if(is_file($oldfile)) {
		if(strpos($_file, "tmp") !== 0 && !stristr($oldfile, C('UPFILES_CATALOG')."/tmp") ){
			return $_file;
		}
    	$newfile_name=basename($oldfile);
    	if($dir_name){
    		$_dir_name=$dir_name.'/';
    	}
    	//是否按照后戳分类
    	if(C('ARTICLEDIRCLASS')){
    		$After = str_replace(".","",strtolower(strrchr($newfile_name,"."))).'/';
    	}
    	//是否按照时间分目录
    	if(C('ARTICLETIMEDIR')){
    		$time=date(C('ARTICLETIMEDIR'),time());
    	}
    	$newfile=Temmoku_PATH.C('UPFILES_CATALOG').'/'.$_dir_name.$After.$time.$newfile_name;
    	$imgurl=$_dir_name.$After.$time.$newfile_name;
    	//写目录
    	if(write_dir($newfile,'1')){
    		if(@move_uploaded_file($oldfile,$newfile))
			{
				@chmod($newfile, 0777);
				unlink($oldfile);
			}else{
				if(@copy($oldfile,$newfile))
				{
					@chmod($newfile, 0777);
					unlink($oldfile);
				}
			}
			//如果设置发布图片时打水印并缩略
			if(C('gd_time')){
				//判断是不是图片
				if(is_picture($newfile)){
					//这个是缩略图
					include_once TemmokuLib.'gd.php';
					if($is_thumb==true){
						$imgurl=(new temmoku\lib\gd ($newfile))->thumb();
					}else{
						//这是文字水印
						if('1'==C('gd_water')){
							$imgurl=(new Temmoku\lib\gd ($newfile))->water_images();
						}elseif('2'==C('gd_water')){
							$imgurl=(new Temmoku\lib\gd ($newfile))->water_text();
						}
					}
				}
			}else{
				//先进行判断是否设置了备份操作
				if(C('gd_copy')){
					//判断是不是图片
					if(is_picture($newfile)){
						//先上传后打水印
						$path= pathinfo($oldfile);
						if(strstr($path['filename'],'thumb_')){
							$oldimg=str_replace('thumb_','',$oldfile);
						}elseif(strstr($path['filename'],'new_')){
							$oldimg=str_replace('new_','',$oldfile);
						}
						UploadFiles_MOVE($oldimg,$dir_name);
					}
				}
			}
			return $imgurl;
    	}
   	}
   	return;
}

/*
 * 判断是否是图片
*/
function is_picture(&$file){
	is_file($file) ? $_file =&$file : $_file= Temmoku_PATH.C('upfiles_Catalog').'/'.$file;
	if(!is_file($_file)){return false;}
	if ( function_exists( 'exif_imagetype' ) ) {
		return  exif_imagetype($_file);
	}else{
		 if ( getimagesize( $_file )  !== false ) {
            return true;
         }
         return false;
	}
}
//获取模板目录
function Get_Template_catalogue($dir){
	$dirs=!isset($dir) && $dir="";
	
	//如果是文件而不是文件夹的话，就引用修改;否则则返回目录
	if(Is_Document($dirs)){
		$content=fils_content($dirs);
		$content=str_replace('</textarea>','<\/textarea>',$content);
		return array("Result"=>'1','dir'=>"$dir",'content'=>"$content");
	}else{
		if ( $handle  =  opendir ( $dirs )) {
			while (( $file  =  readdir ( $handle ))!== false) {
				   if($file==='.' || $file==='..'){
				    	continue;
				   }
			    $r['is_file']=0;
			    $is_file=is_file($dirs."/".$file);
				if($is_file){
					$r['is_file']=1;
				}
				$r['file']=$file;
				$r['path']=$dir."/".$file;
			    $list[]=$r ;
			}
			//关闭打开的目录
			closedir ( $handle );
		}
	}
	return $list;
}


/*网址生成函数
 * $data 为数组 aid cid
 * $module 模块默认为home
 * 自动加载模板名+‘_u’函数生成
 */
function U($data=[],$module=MODULE){
	static $_class=[];
	if($_class[$module]){
		$url=$_class[$module]->make_url($data,$module);
		return $url;
	}else{
		if($module=='admin' || $module=='user'){
			$dir=APP_PATH."home/route.php";
			$module_rute="home\\route";
		}else{
			$dir=APP_PATH."$module/route.php";
			$module_rute="$module\\route";
		}
		
		if (is_file($dir)) {
			$_class[$module]=new $module_rute;
			$url=$_class[$module]->make_url($data,$module);
			return $url;
		}else{
			return $module.'/route控制器不存在';
		}
	}
}
/*
* 加载方法
* $C 为控制器
* $A为方法
* $name 为命名空间
*/

function Load_Method($C,$A,$name){

   	if ((int)method_exists($C, $A)) {
        call_user_func_array([$C, $A],func_get_args());
        //call_user_func_array([$C, $A],[]);
    } else {
        exit('模块'.MODULE.'下的'. $name .' 控制器,'.$A.'方法不存在');
    }
}


function Plugin($Path,$Class,$Method){
   	
}
/*
 * 正则判断函数
 * 是不是数字
 * $content 为传入内容
 */
function is_id_number($content){
	$city_num = [
	     '11','12','13','14','15','21','22',
	     '23','31','32','33','34','35','36',
	     '37','41','42','43','44','45','46',
	     '50','51','52','53','54','61','62',
	     '63','64','65','71','81','82','91'
	];
	/*	正则匹配*/
	if (!preg_match('/^([\d]{17}[xX\d]|[\d]{15})$/', $content)) return false;
	//匹配前两个字符在数组是否存在
	if (!in_array(substr($content, 0, 2), $city_num)) return false;
	$content = preg_replace('/[xX]$/i', 'a', $content);
	$leng = strlen($content);
	//判断长度
	if ($leng == 18) {
	     	$time = substr($content, 6, 4) . '-' . substr($content, 10, 2) . '-' . substr($content, 12, 2);
	} else {
	     	$time = '19' . substr($content, 6, 2) . '-' . substr($content, 8, 2) . '-' . substr($content, 10, 2);
	}
	//判断时间是否正确
	if (date('Y-m-d', strtotime($time)) != $time) return false;
	if ($leng == 18) {
	    $vSum = 0;
	    for ($i = 17 ; $i >= 0 ; $i--) {
	       $vSubStr = substr($content, 17 - $i, 1);
	       $vSum += (pow(2, $i) % 11) * (($vSubStr == 'a') ? 10 : intval($vSubStr , 11));
	    }
	    if($vSum % 11 != 1) return false;
	}
	return true;
}
/*
 * 正则qq
 * $content 要匹配的内容
 * $regular 正则方法，不存在用默认的
 */
function is_qq($content,$regular='/[1-9][0-9]{4,9}/'){
	if (strlen($content) > "4" || strlen($content) < "11") {
		preg_match($regular, $content, $matches);
		if(!$matches){return false;}
		return true;
	}else{
		return false;
	}
}
/*
 * 正则手机号码
 * $content 要匹配的内容
 * $regular 正则方法
 */
function is_phone($content,$regular='/^1[3|4|5|7|8][0-9]{9}$/'){
	if (strlen($content) == "11") {
		preg_match($regular, $content, $matches);
		if(!$matches){return false;}
		return true;
	}else{
		return false;
	}
}
/*
 * 正则EMAIL
 * $content 要匹配的内容
 * $regular 正则方法
 */
function is_email($content,$regular='/\w[-\w.+]*@([A-Za-z0-9][-A-Za-z0-9]+\.)+[A-Za-z]{2,14}/'){
	preg_match($regular, $content, $matches);
	if(!$matches){return false;}
	return true;
}

/*
 * 正则URL
 * $content 要匹配的内容
 * $regular 正则方法
 */
function is_url($content,$regular='/[http|s]+:\/\//'){
	preg_match($regular, $content, $matches);
	if(!$matches){return false;}
	return true;
}
/*判断当前页面是不是SSL*/
function is_https() {
    if ( !empty($_SERVER['HTTPS']) && strtolower($_SERVER['HTTPS']) !== 'off') {
        return true;
    } elseif ( isset($_SERVER['HTTP_X_FORWARDED_PROTO']) && $_SERVER['HTTP_X_FORWARDED_PROTO'] === 'https' ) {
        return true;
    } elseif ( !empty($_SERVER['HTTP_FRONT_END_HTTPS']) && strtolower($_SERVER['HTTP_FRONT_END_HTTPS']) !== 'off') {
        return true;
    }
    return false;
}
/*
 * 快速加载vendor下的文件
 * $class 为文件名
 */
function vendor($class) {
	$class = str_replace(array('.', '#'), array('/', '.'), $class);
	$filename=Temmoku.'vendor/'.$class.".php";
    static $vendor = [];
    if (!isset($vendor[$filename])) {
        if (file_exists_case($filename)) {
        	
            include_once $filename;
            $vendor[$filename] = true;
        } else {
            $vendor[$filename] = false;
        }
    }
    return $vendor[$filename];
}


/*
 * $filename 为文件地址
 * 判断是不是一个正常的文件
 */
function file_exists_case($filename) {
    if (is_file($filename)) {
        if (IS_WIN && APP_DEBUG) {
            if (str_replace('\\', '/', realpath($filename)) != str_replace('\\', '/', $filename))
                return false;
            if (basename(realpath($filename)) != basename($filename))
                return false;
        }
        return true;
    }
    return false;
}


/*
 * $dir 删除的老图片地址完全地址
 */
function del_file(&$dir){
	$dir=realpath($dir);
	$is_upfiles=stripos($dir,Temmoku_PATH.C('UPFILES_CATALOG'));
	if($is_upfiles !== 0){
		return;
	}
	//先进行判断是否设置了备份操作
	if(C('gd_copy')){
		//判断是不是图片，因为只有图片才做备份
		if(is_picture($dir)){
	    	$path= pathinfo($dir);
	    	//判断是不是存在前戳
	    	if(strstr($path['filename'],'thumb_')){
				$_file=str_replace('thumb_','',$dir);
			}elseif(strstr($path['filename'],'new_')){
				$_file=str_replace('new_','',$dir);
			}
			@unlink($_file);//删除这个备份文件
		}
   	}
   	@unlink($dir);
}

/*
 * 判断是不是手机
 * 无需传入参数，如果是手机则返回true 否则返回 false
 */
function Is_Mobile() { 
	 // 如果有HTTP_X_WAP_PROFILE则一定是移动设备
	if (isset($_SERVER['HTTP_X_WAP_PROFILE'])) {
	    return true;
	} 
	// 如果via信息含有wap则一定是移动设备,部分服务商会屏蔽该信息
	if (isset($_SERVER['HTTP_VIA'])) { 
	    // 找不到为flase,否则为true
	    return stristr($_SERVER['HTTP_VIA'], "wap") ? true : false;
	} 
	// 脑残法，判断手机发送的客户端标志,兼容性有待提高。其中'MicroMessenger'是电脑微信
	if (isset($_SERVER['HTTP_USER_AGENT'])) {
	    $clientkeywords = array('nokia','sony','ericsson','mot','samsung','htc','sgh','lg','sharp','sie-','philips','panasonic','alcatel','lenovo','iphone','ipod','blackberry','meizu','android','netfront','symbian','ucweb','windowsce','palm','operamini','operamobi','openwave','nexusone','cldc','midp','wap','mobile','MicroMessenger'); 
	    // 从HTTP_USER_AGENT中查找手机浏览器的关键字
	    if (preg_match("/(" . implode('|', $clientkeywords) . ")/i", strtolower($_SERVER['HTTP_USER_AGENT']))) {
	      	return true;
	    } 
	} 
	// 协议法，因为有可能不准确，放到最后判断
	if (isset ($_SERVER['HTTP_ACCEPT'])) { 
	    // 如果只支持wml并且不支持html那一定是移动设备
	    // 如果支持wml和html但是wml在html之前则是移动设备
	    if ((strpos($_SERVER['HTTP_ACCEPT'], 'vnd.wap.wml') !== false) && (strpos($_SERVER['HTTP_ACCEPT'], 'text/html') === false || (strpos($_SERVER['HTTP_ACCEPT'], 'vnd.wap.wml') < strpos($_SERVER['HTTP_ACCEPT'], 'text/html')))) {
	      	return true;
	    } 
	}
	return false;
}

/*
 * 判断是不是微信
 * 无需传入参数，如果是微信则返回true 否则返回 false
 */
function Is_Weixin() { 
	if (strpos($_SERVER['HTTP_USER_AGENT'], 'MicroMessenger') !== false) { 
	    return true; 
	} else {
	    return false; 
	}
}
/*
	获取模板
	前台模板使用,获取模板路径
	$name 文件名
	$is_main 为true 时 调用的是主后台。方便其它模块或者插件调用
	$device 设备模板，强制显示哪种设备的模板
	$default如果为true。则直接从默认模板读取
 */
function tpl($name,$is_main=false,$device='',$default=false){
	$name=str_caps_look($name,1);
	
	//判断使用的是哪个位置的模板
	if($is_main==false){
		$home= MODULE=='admin' ? 'admin/' : (MODULE=='user' ? 'user/' : 'home/');
		$home=strtolower($home);
	}else{
		$home= MODULE=='admin' ? 'admin/' : (MODULE=='user' ? 'user/' : '');
	}
	
	//如果没有设置设备，则获取客户的设备信息
	
	if($device==false || $device==''){
		$device="/".DEVICE.'/';
	}
	
	//获取模板自定义位置
	if($default==false){
		if(MODULE=='admin'){
			$SELECT_TEMPLATE = C('select_admin_template') ? C('select_admin_template') :'default';
		}elseif(MODULE=='user'){
			$SELECT_TEMPLATE = C('select_user_template') ? C('select_user_template') :'default';
		}else{
			$SELECT_TEMPLATE=$default==false && C('SELECT_TEMPLATE') ? C('SELECT_TEMPLATE') : 'default';
		}
	}else{
		$SELECT_TEMPLATE='default';
	}
	
	//自定义模板小写
	$SELECT_TEMPLATE=strtolower($SELECT_TEMPLATE);
	
	if((defined('M_MODULE')==true || defined('P_MODULE')==TRUE) && $is_main==false ){
		$M_p = defined('M_MODULE') ?  M_MODULE : P_MODULE;
		$MODULE=strtolower($M_p);
	}else{
		$MODULE=MODULE;
	}
	//组合模板所在位置
	$FILES=TEMPLATE.$home.$SELECT_TEMPLATE.'/'.$MODULE.$device.$name.'.tpl';
	//echo $FILES."\n";
	if(!is_file($FILES)){
		if($device=='/pc/' && $SELECT_TEMPLATE != 'default' ){
			return tpl($name,$is_main,'/pc/',true);
		}
		if($device=='/wechat/'){
			return tpl($name,$is_main,'/wap/',$default);
		}elseif($device=='/wap/'){
			if($SELECT_TEMPLATE != 'default' && $default==false){
				return tpl($name,$is_main,"/".DEVICE.'/',true);
			}else{
				return tpl($name,$is_main,'/pc/',false);
			}  
		}
	}
	return $FILES;
}

/* 
	安装时移动模板目录
	$dir 模板目录
	$old 初始名称
	$new 新名称
*/
function move_tpl($dir,$old,$new){
	if(!is_dir($dir)){
		return;
	}
	if($old != $new){ //防止本地复制,要进行判断一下
		$array=['admin','user','home'];
		foreach($array as $value){
			$handle_dir=$dir.DS.$value;
			if(is_dir($handle_dir)){
				$dh  =  @opendir ( $handle_dir ) ;
				while (( $file  =  @readdir ( $dh )) !==  false ) {
					if ($file=='.' || $file=='..'){
						continue;
					}
					$test_old_path=$handle_dir.DS.$file;
					if(is_dir($test_old_path)){
						$_dh  =  @opendir ( $test_old_path ) ;
						while (( $_file  =  @readdir ( $_dh )) !==  false ) {
							if ($_file=='.' || $_file=='..'){
								continue;
							}
							if($_file== $new){
								continue;
							}else{
								$old_path=$test_old_path.DS.$_file;
								$new_path=$test_old_path.DS.$new;
								rename($old_path,$new_path);
							}
						}
						@closedir ( $_dh );
					}
				}
				@closedir ( $dh );
			}
		}
	}
	
	recurse_copy($dir,TEMPLATE);  // 原目录，复制到的目录
	delete_dir($dir);
}

/* 
	复制模块或插件时要复制模板目录 
	$olddir 老文件夹目录（老文件夹名称）
	$newdir 新文件夹目录（新文件夹名称）
*/
function copy_tpl($olddir,$newdir){
	$style=['admin','home','user'];
	foreach($style as $value){
		$style_path=TEMPLATE.$value;
		$dh  =  @opendir ( $style_path ) ;
		while (( $file  =  @readdir ( $dh )) !==  false ) {
			if ($file=='.' || $file=='..'){
				continue;
			}
			$old=$style_path.DS.$file.DS.$olddir;
			if(is_dir($old)){
				$new=$style_path.DS.$file.DS.$newdir;
				recurse_copy($old,$new);
			}
		}
		@closedir ( $dh );
	}
}

/* 
	删除模块或插件时要删除模板目录 
	$dir 文件夹目录
*/
function del_tpl($dir){
	$style=['admin','home','user'];
	foreach($style as $value){
		$style_path=TEMPLATE.$value;
		$dh  =  @opendir ( $style_path ) ;
		while (( $file  =  @readdir ( $dh )) !==  false ) {
			if ($file=='.' || $file=='..'){
				continue;
			}
			$_dir=$style_path.DS.$file.DS.$dir;
			if(is_dir($_dir)){
				delete_dir($_dir);
			}
		}
		@closedir ( $dh );
	}
}

/* 
	获取全部风格
	$location 默认home 可选项 admin|user|home
*/
function style($location='home'){
	$dir=TEMPLATE.$location;
	$style=[];
	$dh  =  @opendir ( $dir ) ;
	while (( $file  =  @readdir ( $dh )) !==  false ) {
		if ($file=='.' || $file=='..'){
		    continue;
		}
		$path=$file;
		$style[$path]=@include $dir.DS.$file.DS."style.php";
	}
	@closedir ( $dh );
	return $style;
}

/*
 * 生成配置文件
 * @param array  $array 需要生成的数组如['setting'=>[]];
 * @param string $filename 文件名称
 * @param string $module 如果是模块或者插件则写模块或者插件的文件夹名称比如news，login，也可以直接用init::$dir 但是必须引入
 * @param bool   $is_plugin 如果是插件则为 true 否则为false
 */
function createconf(&$array,$filename,$module='',$is_plugin=false){

	$text=addslashes(serialize($array));
	$plugin= $is_plugin ==true ? 'plugin'.DS : '';
	$_module = $module ? $module.DS  : '';
	$file=APP_PATH.$plugin.$_module.'conf'.DS.$filename;
	$conffile=$file.'_'.md5(c('MD5')).".conf";
	
	if(is_file($oldfile=$file.".php")){
		unlink($oldfile);
	}
	write_file($conffile,$text);
	if(CACHING==true && defined('CACHING_ALLCACHE')==false){
		$config=\temmoku\vendor\think\cache::get('_config');
		foreach($array as $key=>$row){
			$key=strtoupper($key);
			if($module){
				$__module=strtoupper($module);
				unset($config[$__module][$key]);
			}else{
				unset($config[$key]);
			}
		}
		\temmoku\vendor\think\cache::set('_config',$config);
		unset($config);
		Load_conf_mode($conffile,$module);
	}
	
}


/*
 * 加载配置文件
 * $dir 只加载一级目录，全网址
 */
function Load_conf(&$dir,$is_caching=true){
	
 	$dir_path = @realpath($dir);//返回规范化的绝对路径名
	
	if(CACHING==true && $is_caching==true){
		
		//如果有锁说明存在,并且$update为假.就不去执行读操作了.加快运行速度
		$lock=$dir_path.'_lock';
		$conf_file=\temmoku\vendor\think\cache::get('conf_file');
	 	if(in_array($lock,(array)$conf_file)){
	 		return;
	 	}
		
		$_conf_file=array_merge((array)$conf_file,(array)[$lock]);
		\temmoku\vendor\think\cache::set('conf_file',$_conf_file);
		\temmoku\vendor\think\cache::set($lock,'1');
		
	}
	//进行模块及插件的识别
	$app_path=realpath(APP_PATH);
	$path=explode($app_path,$dir_path);
	$dir=false;
	
	if ( is_dir ( $dir_path )) {
		if($path[1]){
			$_path= explode('/',trim(str_replace('\\','/',$path[1]),'/'));
			/* 
				如果为conf则是主配置文件
				如果为plugin则是插件配置文件
				其它为模块
				如果为插件或者模块时，将以模块或插件的文件夹名称做键。方便混淆
			*/
			$dir=$_path[0]=='conf' ? false : ($_path[0]=='plugin' ? $_path[1] : $_path[0]);
		}
	    if ( $dh  =  @opendir ( $dir_path )) {
	        while (( $file  =  @readdir ( $dh )) !==  false ) {
	           	if ($file=='.' || $file=='..'){
			        continue;
			    }
				$file = $dir_path . DIRECTORY_SEPARATOR . $file;
			    if(is_file($file)){
					Load_conf_mode($file,$dir,$is_caching);
			    }
	        }
	        @closedir ( $dh );
	    }
	}else if ( is_file ( $dir_path )){
		Load_conf_mode($dir_path,$dir,$is_caching);
	}
}
//判断加载模式
function Load_conf_mode($file,$dir,$is_caching=true){
	$after=strtolower(strrchr($file,"."));
	if($after=='.lock'){
		return;
	}
	if($after==='.conf'){
		$arr=unserialize(stripslashes(str_replace ('\\','\\\\',file_get_contents($file))));
	}else{
		$arr=include_once $file;
	}
	$arr=array_change_key_case((array)$arr,CASE_UPPER);
	if($dir){
		$_arr=$arr;
		unset($arr);
		$arr[strtoupper($dir)]=$_arr;
	}
	if(CACHING==true && $is_caching==true){
		$old_data=\temmoku\vendor\think\cache::get('_config');
		
		if($old_data){
			$arr = array_merge_recursive($old_data, $arr);
			unset($old_data);
		}
		\temmoku\vendor\think\cache::set('_config',$arr);
		C('LOAD_CACHE_OK',false);
	}else{
		C($arr);
	}
	
}

/*
 * 获取主模块模板路径
 * $filename 文件名称
 * 先获取的是选择的模块首页
 * 方便调用head，foot
 */
function Main_View($filename,$device=null,$default=false){
	
	$INDEX =C('index') ?  C('index') : '';
	if(!$INDEX || !$filename){
		return ;
	}
	if(!$device){
		$device=DEVICE.'/';
	}
	$SELECT_TEMPLATE=$default==true ? 'default' : C('SELECT_TEMPLATE');
	
	$dir=TEMPLATE.'home/'.$SELECT_TEMPLATE.'/'.$INDEX.'/'.$device.'/'.$filename.'.tpl';
	if(!is_file($dir) && $device=="wechat"){
		return Main_View($filename,'wap',$default);
	}elseif(!is_file($dir) && $device=="wap"){
		return Main_View($filename,'pc',$default);
	}
	$FILES=is_file($dir) ? $dir : "";
	//兼容home版本
	if((C('index')=='home' || $INDEX) && $FILES){
		$INDEX=C('index')=='home' ? 'home' : $INDEX;
		$tplclass=APP_PATH."$INDEX/public_class/tpl.php";
		if(is_file($tplclass)){
			$tpl="\\$INDEX\\public_class\\tpl";
			return "$tpl::parsing('$FILES')";
		}
	}
	
	return $FILES;
}
function filtering(&$content){
	if(is_array($content)){
		$data=[];
		foreach($content as $key=>$value){
			$array=['id','aid','sid','cid','uid','mid','cmid','iid','nid','cityid','proviceid','countyid','townid','upcid','state','reply_id','lid'];
			if(in_array($key,$array) && $key ){
				$data[$key]=intval($value);
			}elseif($key==='iddb'){
				$_iddb=[];
				foreach((array)$value as $id){
					$_iddb[]=intval($id);
				}
				$data[$key]=$_iddb;
			}else{
				$key=htmlspecialchars($key,ENT_QUOTES);
				$data[$key]=filtering($value);
			}
		}
		return $data;
	}else{
		return htmlspecialchars($content,ENT_QUOTES);
	}
}
/*
 * 时间转换成秒分天
 * $timer 时间戳
 */
function formatTime($timer) {
    $str = '';
    $_timer = $_SERVER['REQUEST_TIME'] - $timer;
    $day = floor($_timer / 86400);
    $free = $_timer % 86400;
    if($day > 0) {
    	if($day>30){
    		return date('Y-m-d H:i',$timer);
    	}else{
    		return $day."天前";
    	}
    }else{
        if($free>0){
            $hour = floor($free / 3600);
            $free = $free % 3600;
                if($hour>0){
                    return $hour."小时前";
                }else{
                    if($free>0){
                        $min = floor($free / 60);
                        $free = $free % 60;
                        if($min>0){
                            return $min."分钟前";
                        }else{
                            if($free>0){
                                return $free."秒前";
                            }else{
                                return '刚刚';
                            }
                       }
                    }else{
                        return '刚刚';
                    }
               }
       }else{
           return '刚刚';
       }
    }
}
/*
 * http 请求
 * $url 请求地址
 * $data 数组
 */
function http_request($url, $data = null)
{
    $curl = curl_init();
    curl_setopt($curl, CURLOPT_URL, $url);
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE);
    curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, FALSE);
    if (!empty($data)){
        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
    }
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($curl,CURLOPT_TIMEOUT,3); //定义超时3秒钟 
    $output = curl_exec($curl);
    curl_close($curl);
    return $output;
}
//将命名空间进行替换，
function recurse_replace($oldname,$name,$dir){
	$name=strtolower($name);
	$dirs = @opendir($dir);
	while(false !== ( $file = @readdir($dirs)) ) {
		if($file == '.' || $file == '..' || $file == 'conf'|| $file == 'view' ){
			continue;
		}
		if ( is_dir($dir . '/' . $file) ) {
			recurse_replace($oldname,$name,$dir . '/' . $file);
		}else {
			$files=$dir . '/' . $file;
			$fils_content=fils_content($files);
			$replace='/'.$oldname.'\\\\/is';
			$fils_content=preg_replace( $replace , "$name\\\\"  , $fils_content );
			$fils_content=preg_replace( '/\\\\/' , "\\\\\\"  , $fils_content );
			$replace="/namespace[\s]+".$oldname."/i";
			$fils_content=preg_replace($replace, "namespace ".$name, $fils_content);
			write_file($files,$fils_content);
		}
	}
	@closedir($dirs);
}

/*
 * 复制目录
 * $old 要复制的目录
 * $new 新的目录
 * $exec是否执行
 */
function recurse_copy($old,$new,$exec='') { // 原目录，复制到的目录
	$dirs = @opendir($old);
	@mkdir($new);
	while(false !== ( $file = @readdir($dirs)) ) {
		if($file == '.' || $file == '..'){
			continue;
		}
		if ( is_dir($old . DS . $file) ) {
			recurse_copy($old .DS . $file,$new . DS . $file);
		}else {
			$oldfile=$old . DS . $file;
			$newfile=$new . DS . $file;
			@copy($oldfile,$newfile);
			if($exec=="hook"){
				install_hook($newfile);
			}
		}
	}
	@closedir($dirs);
}

//安装狗子
function install_hook($flie) {
	$flie=str_ireplace(APP_PATH,'',$flie);
	$arr=explode('.',$flie,2);
	$class=str_replace('/','\\',$arr[0]);
	try {
		$class="\\".$class;
	    $obj=new $class;
	    $config=$obj->config;
	    $hook_embedded_point=explode('|',$config['hook_embedded_point']);
	    //入库
	    foreach($hook_embedded_point as $value){
			$row=\temmoku\db::select('*')->from(jab.'hook_list')->where("`class` LIKE '".str_replace('\\','\\\\\\\\',$class)."' AND `hook_name` LIKE '$value' ")->row();
			if(!$row){
				$array=[
					'class'=>$class,
					'hook_name'=>$value,
					'content'=>$config['content'],
					'developer'=>$config['developer'],
					'homepage'=>$config['homepage'],
					'version'=>$config['version'],
					'cloud_id'=>(int)0,
				];
				\temmoku\db::insert(jab.'hook_list')->cols($array)->query();
			}
	    }
	    if ((int)method_exists($obj, 'init')) {
	    	$obj->init();
	    }
	} catch (\Exception $e) {
	    echo $e->getMessage();
	}
}

/*
 * 将ip地址转换成int型
 * @param $ip  ip地址
 * @return number 返回数值
 */
function get_iplong($ip){
    //bindec(decbin(ip2long('这里填ip地址')));
    //ip2long();的意思是将IP地址转换成整型
    //之所以要decbin和bindec一下是为了防止IP数值过大int型存储不了出现负数
    $ip=trim($ip);
  	$ipdata = bindec(decbin(ip2long($ip)));
    return $ipdata;
}

/*
	将字符串分割后，实现字母大小写，
	$caps 为1时，全部小写，2全部大写，3，首字母大写，4首字母小写 ,其它原样输出
	$str为字符串
	$split 为分割用的符号
	$is_array 为真则返回数组，否则则是重新整合
*/

function str_caps_look($str,$caps='1',$split='/',$is_array=false){
	$_str=explode($split,$str);
	$__str=[];
	foreach($_str AS $value){
		switch ($caps) {
			case 1:
				$value=strtolower($value);
				break;
			case 2:
				$value=stroupper($value);
				break;
			case 3:
				$value=ucfirst($value);
				break;
			case 3:
				$value=lcfirst($value);
				break;
			default:
		}
		$__str[]=$value;
	}
	if($is_array==true){
		return $__str;
	}else{
		return implode($split,$__str);
	}
}
/**
 * array_column() // 不支持低版本;
 * 以下方法兼容PHP低版本
 */
function _array_column($array=[], $column_key, $index_key=null){
    $result = [];
    foreach($array as $arr) {
        if(!is_array($arr)) continue;

        if(is_null($column_key)){
            $value = $arr;
        }else{
            $value = $arr[$column_key];
        }

        if(!is_null($index_key)){
            $key = $arr[$index_key];
            $result[$key] = $value;
        }else{
            $result[] = $value;
        }
    }
    return $result; 
}
//sql 语句过滤
function sql_regular_replace(&$sql){
	$sql=preg_replace  ('/#(.+)/' , '', $sql );
	$sql=preg_replace  ('/--(.+)/' , '', $sql );
	$sql=preg_replace  ('/\/\*(.+)/' , '', $sql );
	$sql=str_replace("--",'',$sql);
	$explode=explode("\n",$sql);
	foreach($explode AS $V){
		if(!trim($V)){
			continue;
		}
		$_explode[]=trim($V);
	}
	if($_explode){
		$_explode=implode("\n",$_explode); 
		$explode=explode(";\n",$_explode);
	}
		
	return $explode;
}
//获取本机Ip
function get_client_ip() {  
    if(getenv('HTTP_CLIENT_IP')){  
        $client_ip = getenv('HTTP_CLIENT_IP');  
    } elseif(getenv('HTTP_X_FORWARDED_FOR')) {  
        $client_ip = getenv('HTTP_X_FORWARDED_FOR');  
    } elseif(getenv('REMOTE_ADDR')) { 
        $client_ip = getenv('REMOTE_ADDR');  
    } else { 
        $client_ip = $_SERVER['REMOTE_ADDR']; 
    }  
    return $client_ip;  
}
//获取本机Ip
function get_server_ip(){
	if(isset($_SERVER)){
		if($_SERVER['SERVER_ADDR']){
			$server_ip=$_SERVER['SERVER_ADDR'];
		}else{
			$server_ip=$_SERVER['LOCAL_ADDR'];
	    }
	}else{
	    $server_ip = getenv('SERVER_ADDR');
	}

	return $server_ip;
}
//监听钩子函数
function hook_listen($hook_name, $params = [], $extra = []){
	
	try {
		$data= temmoku\hook::listen($hook_name, $params, $extra);
   	} catch(Exception $e) {
        file_put_contents(RUNTIME_PATH.'hook_run_error.php', '<?php exit();'.var_export($e,true)."\r\n$hook_name\r\n" );
		$out = ob_get_clean();
		echo str_replace("<pre>",'',$out);
		echo $hook_name."钩子加载失败，具体请查看操作日志";
    }
    return $data;
}

/* 
	获取随机数
	int $len 字符长度
	int $type 可选类型
	string $add 新增字符串
*/
function _rand($len='4',$type='0',$add='') {
    $str ='';
    switch($type) {
        case 0:
            $text='ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz';
            break;
        case 1:
            $text= str_repeat('0123456789',5);
            break;
        case 2:
            $text = "邳州天目网络科技有限公司助你在网络上腾飞".$add;
            break;
        default :
            $text='ABCDEFGHIJKMNPQRSTUVWXYZabcdefghijkmnpqrstuvwxyz23456789';
             break;
    }
    if($type!=2) {
        $text   =   str_shuffle($text);
        $str     =   substr($text,0,$len);
    }else{
        // 中文随机
        $str='';
		for($i=0;$i<$len;$i++){
		  	$rand=rand(0,mb_strlen($text)/3);
		  	$str.= mb_substr($text, $rand, 1, 'utf-8') ;
		}
    }
    return $str;
}
/**
 * 获取当前页面完整URL地址
 */
function get_url() {
    $sys_protocal = isset($_SERVER['SERVER_PORT']) && $_SERVER['SERVER_PORT'] == '443' ? 'https://' : 'http://';
    $php_self = $_SERVER['PHP_SELF'] ? $_SERVER['PHP_SELF'] : $_SERVER['SCRIPT_NAME'];
    $path_info = isset($_SERVER['PATH_INFO']) ? $_SERVER['PATH_INFO'] : '';
    $relate_url = isset($_SERVER['REQUEST_URI']) ? $_SERVER['REQUEST_URI'] : $php_self.(isset($_SERVER['QUERY_STRING']) ? '?'.$_SERVER['QUERY_STRING'] : $path_info);
    return $sys_protocal.(isset($_SERVER['HTTP_HOST']) ? $_SERVER['HTTP_HOST'] : '').$relate_url;
}
/**
 *隐藏手机或者电话中间四位
 */
function tel_hidden($tel){
	$is_tel = preg_match('/(0[0-9]{2,3}[\-]?[2-9][0-9]{6,7}[\-]?[0-9]?)/i',$tel); //固定电话
    if($is_tel){
        return preg_replace('/(0[0-9]{2,3}[\-]?[2-9])[0-9]{3,4}([0-9]{3}[\-]?[0-9]?)/i','$1****$2',$tel);
    }else{
        return  preg_replace('/(1[34578]{1}[0-9])[0-9]{4}([0-9]{4})/i','$1****$2',$tel);
    }
}

/* 
	判断是否安装了某个插件
	string $name  是根据安装的文件夹
*/
function is_plugin ($name,$sql=false){
	extract(include APP_PATH."plugin_route.php");
	return	in_array($name,(array)$Plugin_Route) ? true :false;
}

/* 
	判断是否安装了某个插件
	string $name 是根据安装的文件夹
*/
function is_module ($name,$sql=false){
	extract(include APP_PATH."module_route.php");
	return	in_array($name,(array)$MODULE_ROTUE) ? true :false;
}

/* 
	从内容中获取关键字
	$text 传入的内容
	$num 获取数量默认为10;
	$xattr 属性过滤  开头用~多个用英文逗号分开，多格逗号后面不需要在加~
*/
function get_keyword($text,$num='10',$xattr='~en'){
	try{
		vendor("scws.scws4");
		$cws = new PSCWS4();
		$cws->set_charset('utf8');
		$cws->set_ignore(true);//清除标点
		$etc=Temmoku.DS.vendor.DS.'scws'.DS.'etc'.DS;
		$cws->set_dict($etc.'dict.utf8.xdb');
		$cws->set_rule($etc.'rules.utf8.ini');
		$cws->send_text($text);
		$res = $cws->get_tops($num,$xattr);
		$cws->close();
		$array=[];
		foreach((array)$res as $row){
			$array[]=$row['word'];
		}
		return $array;
	}catch (Exception $e) {
		echo "如果缺少dict.utf8.xdb，或者不能用，请查看https://bbs.temmoku.cn/share/articles_52.html";
	}
}
if (!function_exists('array_column')) {
	function array_column($arr2, $column_key) {
		$data = [];
		foreach ($arr2 as $key => $value) {
			$data[] = $value[$column_key];
		}
		return $data;
	}
}

/*
	String 	$text 需要判断的字符串
*/

function trigger_state_words($word){
	$dir=APP_PATH.'conf'.DS.'trigger_state_words'.DS;
	$state=false;
	if(is_dir($dir) && !c('trigger_state_words')){
		Load_conf($dir);
		$wordlist=explode(PHP_EOL,c('trigger_state_words'));
		foreach($wordlist as $text){
			if(trim($text)){
				preg_match('/'.$text.'/ims', $word, $matches);
				if($matches){
					$state=true;
					bleak;
				}
			}
		}
	}
	return $state;
}
?>