<?php
namespace temmoku;
class hook {
	
	/*
     * 获取某个方法
     * $method    方法名
     */
	public static function get($hook_name=[]){
		if(!$hook_name) return [];
		return array_key_exists($hook_name, (array)C('hook')) ?  C('hook.'.$hook_name) : [];
	}
	/*
     * $method 方法名
     * $params 传入参数
     * $extra  额外参数
     */
    public static function listen($hook_name, &$params = null, $extra = null)
    {
        $data = [];
        foreach (self::get($hook_name) as $key => $row) {
			if($row['method']){
				$method=$row['method'];
			}else{
				$method=$hook_name;
			}
	        $data[$key] = self::execute($row['class'], $method, $params, $extra);
	    }
        return $data;
    }
    /*
     * 执行类
     * $class  要执行的类
     * $method    方法名
     * $params 传人的参数
     * $extra  额外参数
     */
    public static function execute($class, $method = '', &$params = null, $extra = null)
    {
    	if(strpos($class, '::')==true) {
            $result = call_user_func_array($class, [ & $params, $extra]);
	    }else{
	     	$obj    = 	new $class();
			$method = 	($method && is_callable([$obj, $method])) ? $method : 'run';
			$result =	$obj->$method($params, $extra);
	    }
        return $result;
    }
}
?>