<?php
// +----------------------------------------------------------------------
// | TOPThink [ WE CAN DO IT JUST THINK ]
// +----------------------------------------------------------------------
// | Copyright (c) 2010 http://topthink.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 麦当苗儿 <zuojiazi@vip.qq.com> <http://www.zjzit.cn>
// +----------------------------------------------------------------------
// | ImageGd.class.php 2013-03-05
// +----------------------------------------------------------------------

// 此类库由topthink/ImageGd.class.php改制.以上为当时版权

namespace temmoku\lib;
class gd{
    private $file;
    private $old_file;
    private $is_thumb=false;
    private $img;
    public $width; //原图宽度
    public $height;//原图高度
    private $new_width; //新图宽度
    private $new_height; //新图高度
    public $type; //图片格式
    public $mime; //扩展类型
	private $frames = [];//GIF帧列表
	private $delays = [];// 每帧等待时间列表
    public function __construct($file=null,$data=[]) {
		ini_set('memory_limit','256M');
        is_file($file) ? $_file =&$file : $_file= Temmoku_PATH.C('upfiles_Catalog').'/'.$file;
        
        $this->old_file=$file;
        $this->new_width= $data['width'] ? $data['width'] : ( C('gd_thumb_width') ? C('gd_thumb_width') : '100' );
        $this->new_height= $data['height'] ? $data['height'] : ( C('gd_thumb_height') ?  C('gd_thumb_height') : '90');
        
		
		//不存在文件不执行
		if(!is_file($_file)){
			$this->file=&$file;
			return ;
		}
		$_file=str_replace('\\','/',$_file);
		$this->file=&$_file;
		//获取文件的信息
		$info=getimagesize ($_file);
		$this->width=&$info[0];
		$this->height=&$info[1];
		$this->type=image_type_to_extension($info[2], 0);
		$this->mime=&$info['mime'];
		
		//打开图像
        if('gif' == $this->type){
          	$this->star_gif();
           	$this->img = imagecreatefromstring($this->image_gif());
        } else {
            $fun = "imagecreatefrom".$this->type;
            $this->img = $fun($this->file);
        }
    }
    
    private function star_gif(){
    	$src = file_get_contents($this->file);
    	/* 解码GIF图片 */
		try{
			$de = new GIFDecoder($src);
			$this->frames = $de->GIFGetFrames();
			$this->delays = $de->GIFGetDelays();
		} catch(\Exception $e){
			E("解码GIF图片出错");
		}
    }


	/**
	 * 设置或获取当前帧的数据
	 * @param  string $stream 二进制数据流
	 * @return boolean        获取到的数据
	 */
	private function image_gif($stream = null){
		
		if(is_null($stream)){
			$current = current($this->frames);
			return false === $current ? reset($this->frames) : $current;
		} else {
			$this->frames[key($this->frames)] = $stream;
		}
	}

	/**
	 * 将当前帧移动到下一帧
	 * @return string 当前帧数据
	 */
	private function nextImage_gif(){
		return next($this->frames);
	}

	/* 切换到GIF的下一帧并保存当前帧，内部使用 */
    private function gifNext(){
        ob_start();
        ob_implicit_flush(0);
        imagegif($this->img);
        $img = ob_get_clean();
        $this->image_gif($img);
       	$next = $this->nextImage_gif();
        if($next){
            $this->img = imagecreatefromstring($next);
            return $next;
        } else {
            $this->img = imagecreatefromstring($this->image_gif());
            return false;
        }
    }

	public function thumb($new_width=0,$new_height=0,$type=0){
		if(empty($this->img)) return $this->file;
		$this->is_thumb=true;
		
		if(!$new_width){
			//新的宽度
			$new_width  =  $this->new_width ;
		}
		
		if(!$new_height){
			//新的高度
			$new_height =  $this->new_height ;
		}
		
		//按最小比例缩放
		if(('1'==C('gd_thumb') && $type===0) || $type==1){
			$scale=min($new_width/$this->width,$new_height/$this->height);
			$new_width  = $this->width * $scale;
	        $new_height = $this->height * $scale;
		}elseif(('2'==C('gd_thumb')  && $type===0 ) || $type==2){
			
			/*填充白色底图*/
			if($this->width < $new_width && $this->height < $new_height){
			    $scale = 1;
			} else {
			    $scale = min($new_width/$this->width, $new_height/$this->height);
			}
			//设置缩略图的坐标及宽度和高度
			$neww = $this->width * $scale;
			$newh = $this->height * $scale;
			$posx = ($new_width  - $this->width * $scale)/2;
			$posy = ($new_height - $this->height * $scale)/2;
			//创建新图像层
            $img = @imagecreatetruecolor($new_width, $new_height);
            // 为图像分配颜色
            $color = @imagecolorallocate($img, 255, 255, 255);
            //将上面的颜色填充进去
            @imagefill($img, 0, 0, $color);
            //重采样拷贝部分图像并调整大小
            @imagecopyresampled($img, $this->img, $posx, $posy, 0, 0, $neww, $newh, $this->width, $this->height);
            imagedestroy($this->img);
            $this->img= &$img;
            return $this->save();
            exit;
		}

		// 重新取样
		$image_p  =  @imagecreatetruecolor ( $new_width ,  $new_height );
		
		$imagecreatefrom='imagecreatefrom'.$this->type;
		
		$image  =  $imagecreatefrom ( $this->file );
		@imagecopyresampled ( $image_p ,  $image ,  0 ,  0 ,  0 ,  0 ,  $new_width ,  $new_height ,  $this->width ,  $this->height );
		imagedestroy($this->img);
		$this->img=&$image_p;
		return $this->save();
	}
	
	public function save($is_copy=null){
		//如果备份的话就新生成一个新的文件
		$path= pathinfo($this->file);
		$imgurl=explode('/',$path['dirname']);
		
		$is_copy=$is_copy !== null ? ( $is_copy ? true :false ) : (true==C('gd_copy') ? true :false);
		 
		if($is_copy){
			if(true==$this->is_thumb){
				$thumb="/thumb_".$path['basename'];
				$dir =$path['dirname'].$thumb;
			}else{
				$thumb="/new_".$path['basename'];
				$dir =$path['dirname'].$thumb;
			}
		}else{
			//不备份直接替换老文件
			$thumb='/'.$path['basename'];
			$dir=$this->file;
		}
		
        //保存图像
        if('jpeg' == $this->type || 'jpg' == $this->type){
            //JPEG图像设置隔行扫描
            @imageinterlace($this->img, true);
            @imagejpeg($this->img, $dir,'80');
        }elseif('gif' == $this->type){
            $gif = new GIFEncoder($this->frames, $this->delays, 0, 2, 0, 0, 0, 'bin');
			file_put_contents($dir, $gif->GetAnimation());
        }elseif ('png' == $type) {
            //设定保存完整的 alpha 通道信息
            imagesavealpha($this->im, true);
            //ImagePNG生成图像的质量范围从0到9的
            imagepng($this->img, $dir, min((int) ($quality / 10), 9));
        }else{
            $fun  =   'image'.$this->type;
            @$fun($this->img, $dir);
        }
        //将图销毁
        empty($this->img) || imagedestroy($this->img);
        $search =realpath(Temmoku_PATH.(C('upfiles_Catalog')));
        $__path=str_replace($search,'',realpath($this->file));
       	$__path= pathinfo($__path);
       	
       	$out_img=trim($__path['dirname'],'\\/').$thumb;
        return str_replace  ('\\' , '/' , $out_img );
	}
	
	private function test_img(){
		if(C('GD_WATER_MIN_WIDTH') && C('GD_WATER_MIN_HEIGHT')){
			if($this->height < C('GD_WATER_MIN_HEIGHT') && $this->width < C('GD_WATER_MIN_WIDTH')){
				return $this->old_file;
			}
		}elseif(C('GD_WATER_MIN_WIDTH')){
			if($this->width < C('GD_WATER_MIN_WIDTH')){
				return $this->old_file;
			}
		}elseif(C('GD_WATER_MIN_HEIGHT')){
			if($this->height < C('GD_WATER_MIN_HEIGHT')){
				return $this->old_file;
			}
		}
		return ;
	}
	
	/**
		* 图像添加文字
		*
		* @param  string  $text   添加的文字
		* @param  string  $font   字体路径绝对或者相对。必须能访问的到
		* @param  integer $size   字号
		* @param  string  $color  文字颜色
		* @param int      $locate 文字写入位置
		* @param  integer $offset 文字相对当前位置的偏移量
		* @param  integer $angle  文字倾斜角度
		* @param bool $line_feed 是否自动换行
		* @param bool $line_width 如果换行，每行的宽度
		* @param bool $line_height 如果换行，每行的字体高度
		* @param bool $is_save 是否直接保存
	*/
		
	public function water_text($text=null,$font=null,$size=null,$color=null,$locate=null,$offset = null,$angle=null,$line_feed=false,$line_width=0,$line_height=0,$is_save=true){
		if(empty($this->img)) return $this->file;
		if($ret=$this->test_img()){
			return $ret;
		}
		
		$font_file=	$font ? $font :Temmoku_PATH."public/global/font/".C('gd_water_text_font');
		
		$text=	$text ? $text : C('gd_water_text');
		$size = $size ? $size : C('gd_water_text_size');
		$color = $color ? $color : C('gd_water_text_color');
		//获取文字信息
        $info = @imagettfbbox($size, $angle, $font_file, $text);
        $min_x = min($info[0], $info[2], $info[4], $info[6]); 
        $max_x = max($info[0], $info[2], $info[4], $info[6]); 
        $min_y = min($info[1], $info[3], $info[5], $info[7]); 
        $max_y = max($info[1], $info[3], $info[5], $info[7]); 

        /* 计算文字初始坐标和尺寸 */
        $x = $min_x;
        $y = abs($min_y);
        $w = $max_x - $min_x;
        $h = $max_y - $min_y;
		
		$locate=$locate ? $locate : C('gd_water_position');
		
        /* 设定文字位置 */
        switch ($locate) {
            /* 左上角文字 */
            case 1:
                break;
            /* 上中文字 */
            case 2:
                $x += ($this->width - $w)/2;
                break;
            /* 右上文字 */
            case 3:
                $x += $this->width - $w;
                break;
            /* 左中文字 */
            case 4:
                $y += ($this->height - $h)/2;
                break;
            /* 中中文字 */
            case 5:
                $x += ($this->width  - $w)/2;
                $y += ($this->height - $h)/2;
                break;
            /* 右中文字 */
            case 6:
                $x += $this->width - $w;
                $y += ($this->height - $h)/2;
                break;
            /* 下左文字 */
            case 7:
                $y += $this->height - $h;
                break;
            /* 下中文字 */
            case 8:
                $x += ($this->width - $w)/2;
                $y += $this->height - $h;
                break;
            /* 下右文字 */
            case 9:
                $x += $this->width  - $w;
                $y += $this->height - $h;
                break;
			default:
			    /* 自定义文字坐标 */
			    if (is_array($locate)) {
					list($posx, $posy) = $locate;
					$x += $posx;
					$y += $posy;
				} else {
					throw new ImageException('不支持的文字位置类型');
				}
        }
        
 		do{
 			/* 设置偏移量 */
			if (is_array($offset)) {
				$offset        = array_map('intval', $offset);
				list($ox, $oy) = $offset;
			} else {
				$offset = intval($offset);
				$ox     = $oy     = $offset;
			}
 			/* 设置颜色 */
			if ( 0 === strpos($color, '#')) {
				$color=substr($color, 1);
			}
 			$color = str_split($color, 2);
	        $color = array_map('hexdec', $color);
			$color[3]=intval(C('gd_water_alpha'));
	       	if($color[3] > 127){
	            $color[3] = 0;
	        }
	        $black = @imagecolorallocatealpha($this->img, $color[0], $color[1], $color[2], $color[3]);
			if($line_feed==true){
				$lineArr =$this->autoLineSplit ($text, $info, $line_width);
				foreach ($lineArr as $k => $v) {
				   @imagettftext( $this->img, $size, 0, $x+ $ox, ($y + ($line_height * $k))+$oy, $black, $font_file, $v);
				}
			}else{
				@imagefttext ( $this->img ,  $size ,  0 ,  $x + $ox, $y + $oy ,  $black ,  $font_file ,  $text );
			}
 		}while($this->type=='gif' && $this->gifNext());
		if($is_save==true){
			return $this->save();
		}
	}
	
	
	private function autolinesplit ($text, $info, $width) {
	    $result = [];
	    $len = (strlen($text) + mb_strlen($text)) / 2;
	    $textWidth = abs($info[4] - $info[0]);
	    // 计算每个字符的长度
	    $singleW = $textWidth / $len;
	    // 计算每行最多容纳多少个字符
	    $maxCount = floor($width / $singleW);
	    while ($len > $maxCount) {
	        $result[] = mb_strimwidth($text, 0, $maxCount, '');
	        $text = str_replace($result[count($result) - 1], '', $text);
	        $len = (strlen($text) + mb_strlen($text)) / 2;
	    }
	    $result[] = $text;
	    return $result;
	}
	
	
	/**
		* 添加水印
		*
		* @param  string $source 水印图片路径.绝对路径
		* @param int     $locate 水印位置
		* @param int     $alpha  透明度
		* @param bool $is_save 是否直接保存
	*/
   
	public function water_images($source=null, $locate = null, $alpha = null ,$is_save=true){
		if(empty($this->img)) return $this->file;
		if($ret=$this->test_img()){
			return $ret;
		}
		
		$source=$source ? $source : Temmoku_PATH.'public/global/images/'.C('gd_water_img');
		
		$water_img_info = @getimagesize($source);
		$width=$water_img_info[0];
		$height=$water_img_info[1];
		//创建水印图像资源
        $fun   = 'imagecreatefrom' .image_type_to_extension($water_img_info[2], 0);
        $water = $fun($source);
		
        //设定水印图像的混色模式
        imagealphablending($water, true);
		
		
		$locate=  $locate ?  $locate : C('gd_water_position');
		
		
		
        /* 设定水印位置 */
        switch ($locate) {
            /* 左上角水印 */
            case 1:
                $x = $y = 0;
                break;
            /* 上居中水印 */
            case 2:
                $x = ($this->width - $width)/2;
                $y = 0;
                break;
            /* 右上角水印 */
            case 3:
                $x = $this->width - $width;
                $y = 0;
                break;
			/* 左居中水印 */
            case 4:
                $x = 0;
                $y = ($this->height - $height)/2;
                break;
            /* 居中水印 */
            case 5:
                $x = ($this->width - $width)/2;
                $y = ($this->height - $height)/2;
                break;
			/* 右居中水印 */
            case 6:
                $x = $this->width - $width;
                $y = ($this->height - $height)/2;
                break;
			/* 左下角水印 */
            case 7:
                $x = 0;
                $y = $this->height - $height;
                break;
            /* 下居中水印 */
            case 8:
                $x = ($this->width - $width)/2;
                $y = $this->height - $height;
                break;
			/* 右下角水印 */
            case 9:
                $x = $this->width - $width;
                $y = $this->height - $height;
                break;
			default:
				/* 自定义水印坐标 */
				if (is_array($locate)) {
					list($x, $y) = $locate;
				} else {
					throw new ImageException('不支持的水印位置类型');
				}
        }
        
        do{
			
			$alpha=  $alpha ? $alpha : ( intval(C('gd_water_alpha')) ? C('gd_water_alpha') : '100' );
	       
	        //添加水印
	        $newimg = imagecreatetruecolor($width, $height);
	        // 调整默认颜色
	        $color = imagecolorallocate($newimg, 255, 255, 255);
	        imagefill($newimg, 0, 0, $color);
	
	       	imagecopy($newimg, $this->img, 0, 0, $x, $y, $width, $height);
	        imagecopy($newimg, $water, 0, 0, 0, 0, $width, $height);
	        imagecopymerge($this->img, $newimg, $x, $y, 0, 0, $width, $height, $alpha);
	        
       	}while($this->type=='gif' && $this->gifNext());
       	imagedestroy($water);
	    imagedestroy($newimg);
		if($is_save==true){
			return  $this->save();
		}
       	
	}
	
 /**
     * 旋转图像
     * @param int $degrees 顺时针旋转的度数
     * @return $this
     */
    public function rotate($degrees = 90)
    {
        do {
            $img = imagerotate($this->img, -$degrees, imagecolorallocatealpha($this->img, 0, 0, 0, 127));
            imagedestroy($this->img);
            $this->img = $img;
        } while (!empty($this->gif) && $this->gifNext());

        $this->info['width']  = imagesx($this->img);
        $this->info['height'] = imagesy($this->img);

        return $this;
    }

    /**
     * 翻转图像
     * @param integer $direction 翻转轴,X或者Y
     * @return $this
     */
    public function flip($direction = 1)
    {
        //原图宽度和高度
        $w = $this->width;
        $h = $this->height;
        do {

            $img = imagecreatetruecolor($w, $h);

            switch ($direction) {
                case 1:
                    for ($y = 0; $y < $h; $y++) {
                        imagecopy($img, $this->img, 0, $h - $y - 1, 0, $y, $w, 1);
                    }
                    break;
                case 2:
                    for ($x = 0; $x < $w; $x++) {
                        imagecopy($img, $this->img, $w - $x - 1, 0, $x, 0, 1, $h);
                    }
                    break;
                default:
                    throw new ImageException('不支持的翻转类型');
            }

            imagedestroy($this->img);
            $this->img = $img;

        } while (!empty($this->gif) && $this->gifNext());

        return $this;
    }

    /**
     * 裁剪图像
     *
     * @param  integer $w      裁剪区域宽度
     * @param  integer $h      裁剪区域高度
     * @param  integer $x      裁剪区域x坐标
     * @param  integer $y      裁剪区域y坐标
     * @param  integer $width  图像保存宽度
     * @param  integer $height 图像保存高度
     *
     * @return $this
     */
    public function crop($w, $h, $x = 0, $y = 0, $width = null, $height = null)
    {
        //设置保存尺寸
        empty($width) && $width   = $w;
        empty($height) && $height = $h;
        do {
            //创建新图像
            $img = imagecreatetruecolor($width, $height);
            // 调整默认颜色
            $color = imagecolorallocate($img, 255, 255, 255);
            imagefill($img, 0, 0, $color);
            //裁剪
            imagecopyresampled($img, $this->img, 0, 0, $x, $y, $width, $height, $w, $h);
            imagedestroy($this->img); //销毁原图
            //设置新图像
            $this->img = $img;
        } while (!empty($this->gif) && $this->gifNext());
        $this->new_width  = (int) $width;
        $this->new_height = (int) $height;
        return $this;
    }

}


/*
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::
::	GIFEncoder Version 2.0 by László Zsidi, http://gifs.hu
::
::	This class is a rewritten 'GifMerge.class.php' version.
::
::  Modification:
::   - Simplified and easy code,
::   - Ultra fast encoding,
::   - Built-in errors,
::   - Stable working
::
::
::	Updated at 2007. 02. 13. '00.05.AM'
::
::
::
::  Try on-line GIFBuilder Form demo based on GIFEncoder.
::
::  http://gifs.hu/phpclasses/demos/GifBuilder/
::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
*/

Class GIFEncoder {
	private $GIF = "GIF89a";		/* GIF header 6 bytes	*/
	private $VER = "GIFEncoder V2.05";	/* Encoder version		*/

	private $BUF = Array ( );
	private $LOP =  0;
	private $DIS =  2;
	private $COL = -1;
	private $IMG = -1;

	private $ERR = Array (
		'ERR00'	=>	"Does not supported function for only one image!",
		'ERR01'	=>	"Source is not a GIF image!",
		'ERR02'	=>	"Unintelligible flag ",
		'ERR03'	=>	"Does not make animation from animated GIF source",
	);

	/*
	:::::::::::::::::::::::::::::::::::::::::::::::::::
	::
	::	GIFEncoder...
	::
	*/
	public function __construct($GIF_src, $GIF_dly, $GIF_lop, $GIF_dis,$GIF_red, $GIF_grn, $GIF_blu, $GIF_mod) {
		if ( ! is_array ( $GIF_src ) && ! is_array ( $GIF_dly ) ) {
			printf	( "%s: %s", $this->VER, $this->ERR [ 'ERR00' ] );
			exit	( 0 );
		}
		$this->LOP = ( $GIF_lop > -1 ) ? $GIF_lop : 0;
		$this->DIS = ( $GIF_dis > -1 ) ? ( ( $GIF_dis < 3 ) ? $GIF_dis : 3 ) : 2;
		$this->COL = ( $GIF_red > -1 && $GIF_grn > -1 && $GIF_blu > -1 ) ?
						( $GIF_red | ( $GIF_grn << 8 ) | ( $GIF_blu << 16 ) ) : -1;

		for ( $i = 0; $i < count ( $GIF_src ); $i++ ) {
			if ( strToLower ( $GIF_mod ) == "url" ) {
				$this->BUF [ ] = fread ( fopen ( $GIF_src [ $i ], "rb" ), filesize ( $GIF_src [ $i ] ) );
			}
			else if ( strToLower ( $GIF_mod ) == "bin" ) {
				$this->BUF [ ] = $GIF_src [ $i ];
			}
			else {
				printf	( "%s: %s ( %s )!", $this->VER, $this->ERR [ 'ERR02' ], $GIF_mod );
				exit	( 0 );
			}
			if ( substr ( $this->BUF [ $i ], 0, 6 ) != "GIF87a" && substr ( $this->BUF [ $i ], 0, 6 ) != "GIF89a" ) {
				printf	( "%s: %d %s", $this->VER, $i, $this->ERR [ 'ERR01' ] );
				exit	( 0 );
			}
			for ( $j = ( 13 + 3 * ( 2 << ( ord ( $this->BUF [ $i ] { 10 } ) & 0x07 ) ) ), $k = TRUE; $k; $j++ ) {
				switch ( $this->BUF [ $i ] { $j } ) {
					case "!":
						if ( ( substr ( $this->BUF [ $i ], ( $j + 3 ), 8 ) ) == "NETSCAPE" ) {
							printf	( "%s: %s ( %s source )!", $this->VER, $this->ERR [ 'ERR03' ], ( $i + 1 ) );
							exit	( 0 );
						}
						break;
					case ";":
						$k = FALSE;
						break;
				}
			}
		}
		$this->GIFAddHeader ( );
		for ( $i = 0; $i < count ( $this->BUF ); $i++ ) {
			$this->GIFAddFrames ( $i, $GIF_dly [ $i ] );
		}
		$this->GIFAddFooter ( );
	}
	/*
	:::::::::::::::::::::::::::::::::::::::::::::::::::
	::
	::	GIFAddHeader...
	::
	*/
	private function GIFAddHeader ( ) {
		$cmap = 0;

		if ( ord ( $this->BUF [ 0 ] { 10 } ) & 0x80 ) {
			$cmap = 3 * ( 2 << ( ord ( $this->BUF [ 0 ] { 10 } ) & 0x07 ) );

			$this->GIF .= substr ( $this->BUF [ 0 ], 6, 7		);
			$this->GIF .= substr ( $this->BUF [ 0 ], 13, $cmap	);
			$this->GIF .= "!\377\13NETSCAPE2.0\3\1" . $this->GIFWord ( $this->LOP ) . "\0";
		}
	}
	/*
	:::::::::::::::::::::::::::::::::::::::::::::::::::
	::
	::	GIFAddFrames...
	::
	*/
	private function GIFAddFrames ( $i, $d ) {

		$Locals_str = 13 + 3 * ( 2 << ( ord ( $this->BUF [ $i ] { 10 } ) & 0x07 ) );

		$Locals_end = strlen ( $this->BUF [ $i ] ) - $Locals_str - 1;
		$Locals_tmp = substr ( $this->BUF [ $i ], $Locals_str, $Locals_end );

		$Global_len = 2 << ( ord ( $this->BUF [ 0  ] { 10 } ) & 0x07 );
		$Locals_len = 2 << ( ord ( $this->BUF [ $i ] { 10 } ) & 0x07 );

		$Global_rgb = substr ( $this->BUF [ 0  ], 13,
							3 * ( 2 << ( ord ( $this->BUF [ 0  ] { 10 } ) & 0x07 ) ) );
		$Locals_rgb = substr ( $this->BUF [ $i ], 13,
							3 * ( 2 << ( ord ( $this->BUF [ $i ] { 10 } ) & 0x07 ) ) );

		$Locals_ext = "!\xF9\x04" . chr ( ( $this->DIS << 2 ) + 0 ) .
						chr ( ( $d >> 0 ) & 0xFF ) . chr ( ( $d >> 8 ) & 0xFF ) . "\x0\x0";

		if ( $this->COL > -1 && ord ( $this->BUF [ $i ] { 10 } ) & 0x80 ) {
			for ( $j = 0; $j < ( 2 << ( ord ( $this->BUF [ $i ] { 10 } ) & 0x07 ) ); $j++ ) {
				if	(
						ord ( $Locals_rgb { 3 * $j + 0 } ) == ( ( $this->COL >> 16 ) & 0xFF ) &&
						ord ( $Locals_rgb { 3 * $j + 1 } ) == ( ( $this->COL >>  8 ) & 0xFF ) &&
						ord ( $Locals_rgb { 3 * $j + 2 } ) == ( ( $this->COL >>  0 ) & 0xFF )
					) {
					$Locals_ext = "!\xF9\x04" . chr ( ( $this->DIS << 2 ) + 1 ) .
									chr ( ( $d >> 0 ) & 0xFF ) . chr ( ( $d >> 8 ) & 0xFF ) . chr ( $j ) . "\x0";
					break;
				}
			}
		}
		switch ( $Locals_tmp { 0 } ) {
			case "!":
				$Locals_img = substr ( $Locals_tmp, 8, 10 );
				$Locals_tmp = substr ( $Locals_tmp, 18, strlen ( $Locals_tmp ) - 18 );
				break;
			case ",":
				$Locals_img = substr ( $Locals_tmp, 0, 10 );
				$Locals_tmp = substr ( $Locals_tmp, 10, strlen ( $Locals_tmp ) - 10 );
				break;
		}
		if ( ord ( $this->BUF [ $i ] { 10 } ) & 0x80 && $this->IMG > -1 ) {
			if ( $Global_len == $Locals_len ) {
				if ( $this->GIFBlockCompare ( $Global_rgb, $Locals_rgb, $Global_len ) ) {
					$this->GIF .= ( $Locals_ext . $Locals_img . $Locals_tmp );
				}
				else {
					$byte  = ord ( $Locals_img { 9 } );
					$byte |= 0x80;
					$byte &= 0xF8;
					$byte |= ( ord ( $this->BUF [ 0 ] { 10 } ) & 0x07 );
					$Locals_img { 9 } = chr ( $byte );
					$this->GIF .= ( $Locals_ext . $Locals_img . $Locals_rgb . $Locals_tmp );
				}
			}
			else {
				$byte  = ord ( $Locals_img { 9 } );
				$byte |= 0x80;
				$byte &= 0xF8;
				$byte |= ( ord ( $this->BUF [ $i ] { 10 } ) & 0x07 );
				$Locals_img { 9 } = chr ( $byte );
				$this->GIF .= ( $Locals_ext . $Locals_img . $Locals_rgb . $Locals_tmp );
			}
		}
		else {
			$this->GIF .= ( $Locals_ext . $Locals_img . $Locals_tmp );
		}
		$this->IMG  = 1;
	}
	/*
	:::::::::::::::::::::::::::::::::::::::::::::::::::
	::
	::	GIFAddFooter...
	::
	*/
	private function GIFAddFooter ( ) {
		$this->GIF .= ";";
	}
	/*
	:::::::::::::::::::::::::::::::::::::::::::::::::::
	::
	::	GIFBlockCompare...
	::
	*/
	private function GIFBlockCompare ( $GlobalBlock, $LocalBlock, $Len ) {

		for ( $i = 0; $i < $Len; $i++ ) {
			if	(
					$GlobalBlock { 3 * $i + 0 } != $LocalBlock { 3 * $i + 0 } ||
					$GlobalBlock { 3 * $i + 1 } != $LocalBlock { 3 * $i + 1 } ||
					$GlobalBlock { 3 * $i + 2 } != $LocalBlock { 3 * $i + 2 }
				) {
					return ( 0 );
			}
		}

		return ( 1 );
	}
	/*
	:::::::::::::::::::::::::::::::::::::::::::::::::::
	::
	::	GIFWord...
	::
	*/
	private function GIFWord ( $int ) {

		return ( chr ( $int & 0xFF ) . chr ( ( $int >> 8 ) & 0xFF ) );
	}
	/*
	:::::::::::::::::::::::::::::::::::::::::::::::::::
	::
	::	GetAnimation...
	::
	*/
	public function GetAnimation ( ) {
		return ( $this->GIF );
	}
}


/*
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::
::	GIFDecoder Version 2.0 by László Zsidi, http://gifs.hu
::
::	Created at 2007. 02. 01. '07.47.AM'
::
::
::
::
::  Try on-line GIFBuilder Form demo based on GIFDecoder.
::
::  http://gifs.hu/phpclasses/demos/GifBuilder/
::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
*/

Class GIFDecoder {
	private $GIF_buffer = Array ( );
	private $GIF_arrays = Array ( );
	private $GIF_delays = Array ( );
	private $GIF_stream = "";
	private $GIF_string = "";
	private $GIF_bfseek =  0;

	private $GIF_screen = Array ( );
	private $GIF_global = Array ( );
	private $GIF_sorted;
	private $GIF_colorS;
	private $GIF_colorC;
	private $GIF_colorF;

	/*
	:::::::::::::::::::::::::::::::::::::::::::::::::::
	::
	::	GIFDecoder ( $GIF_pointer )
	::
	*/
	public function __construct ( $GIF_pointer ) {
		$this->GIF_stream = $GIF_pointer;

		$this->GIFGetByte ( 6 );	// GIF89a
		$this->GIFGetByte ( 7 );	// Logical Screen Descriptor

		$this->GIF_screen = $this->GIF_buffer;
		$this->GIF_colorF = $this->GIF_buffer [ 4 ] & 0x80 ? 1 : 0;
		$this->GIF_sorted = $this->GIF_buffer [ 4 ] & 0x08 ? 1 : 0;
		$this->GIF_colorC = $this->GIF_buffer [ 4 ] & 0x07;
		$this->GIF_colorS = 2 << $this->GIF_colorC;

		if ( $this->GIF_colorF == 1 ) {
			$this->GIFGetByte ( 3 * $this->GIF_colorS );
			$this->GIF_global = $this->GIF_buffer;
		}
		/*
		 *
		 *  05.06.2007.
		 *  Made a little modification
		 *
		 *
		 -	for ( $cycle = 1; $cycle; ) {
		 +		if ( GIFDecoder::GIFGetByte ( 1 ) ) {
		 -			switch ( $this->GIF_buffer [ 0 ] ) {
		 -				case 0x21:
		 -					GIFDecoder::GIFReadExtensions ( );
		 -					break;
		 -				case 0x2C:
		 -					GIFDecoder::GIFReadDescriptor ( );
		 -					break;
		 -				case 0x3B:
		 -					$cycle = 0;
		 -					break;
		 -		  	}
		 -		}
		 +		else {
		 +			$cycle = 0;
		 +		}
		 -	}
		*/
		for ( $cycle = 1; $cycle; ) {
			if ( $this->GIFGetByte ( 1 ) ) {
				switch ( $this->GIF_buffer [ 0 ] ) {
					case 0x21:
						$this->GIFReadExtensions ( );
						break;
					case 0x2C:
						$this->GIFReadDescriptor ( );
						break;
					case 0x3B:
						$cycle = 0;
						break;
				}
			}
			else {
				$cycle = 0;
			}
		}
	}
	/*
	:::::::::::::::::::::::::::::::::::::::::::::::::::
	::
	::	GIFReadExtension ( )
	::
	*/
	private function GIFReadExtensions ( ) {
		$this->GIFGetByte ( 1 );
		for ( ; ; ) {
			$this->GIFGetByte ( 1 );
			if ( ( $u = $this->GIF_buffer [ 0 ] ) == 0x00 ) {
				break;
			}
			$this->GIFGetByte ( $u );
			/*
			 * 07.05.2007.
			 * Implemented a new line for a new function
			 * to determine the originaly delays between
			 * frames.
			 *
			 */
			if ( $u == 4 ) {
				$this->GIF_delays [ ] = ( $this->GIF_buffer [ 1 ] | $this->GIF_buffer [ 2 ] << 8 );
			}
		}
	}
	/*
	:::::::::::::::::::::::::::::::::::::::::::::::::::
	::
	::	GIFReadExtension ( )
	::
	*/
	private function GIFReadDescriptor ( ) {
		$GIF_screen	= Array ( );

		$this->GIFGetByte ( 9 );
		$GIF_screen = $this->GIF_buffer;
		$GIF_colorF = $this->GIF_buffer [ 8 ] & 0x80 ? 1 : 0;
		if ( $GIF_colorF ) {
			$GIF_code = $this->GIF_buffer [ 8 ] & 0x07;
			$GIF_sort = $this->GIF_buffer [ 8 ] & 0x20 ? 1 : 0;
		}
		else {
			$GIF_code = $this->GIF_colorC;
			$GIF_sort = $this->GIF_sorted;
		}
		$GIF_size = 2 << $GIF_code;
		$this->GIF_screen [ 4 ] &= 0x70;
		$this->GIF_screen [ 4 ] |= 0x80;
		$this->GIF_screen [ 4 ] |= $GIF_code;
		if ( $GIF_sort ) {
			$this->GIF_screen [ 4 ] |= 0x08;
		}
		$this->GIF_string = "GIF87a";
		$this->GIFPutByte ( $this->GIF_screen );
		if ( $GIF_colorF == 1 ) {
			$this->GIFGetByte ( 3 * $GIF_size );
			$this->GIFPutByte ( $this->GIF_buffer );
		}
		else {
			$this->GIFPutByte ( $this->GIF_global );
		}
		$this->GIF_string .= chr ( 0x2C );
		$GIF_screen [ 8 ] &= 0x40;
		$this->GIFPutByte ( $GIF_screen );
		$this->GIFGetByte ( 1 );
		$this->GIFPutByte ( $this->GIF_buffer );
		for ( ; ; ) {
			$this->GIFGetByte ( 1 );
			$this->GIFPutByte ( $this->GIF_buffer );
			if ( ( $u = $this->GIF_buffer [ 0 ] ) == 0x00 ) {
				break;
			}
			$this->GIFGetByte ( $u );
			$this->GIFPutByte ( $this->GIF_buffer );
		}
		$this->GIF_string .= chr ( 0x3B );
		/*
		   Add frames into $GIF_stream array...
		*/
		$this->GIF_arrays [ ] = $this->GIF_string;
	}
	/*
	:::::::::::::::::::::::::::::::::::::::::::::::::::
	::
	::	GIFGetByte ( $len )
	::
	*/

	/*
	 *
	 *  05.06.2007.
	 *  Made a little modification
	 *
	 *
	 -	function GIFGetByte ( $len ) {
	 -		$this->GIF_buffer = Array ( );
	 -
	 -		for ( $i = 0; $i < $len; $i++ ) {
	 +			if ( $this->GIF_bfseek > strlen ( $this->GIF_stream ) ) {
	 +				return 0;
	 +			}
	 -			$this->GIF_buffer [ ] = ord ( $this->GIF_stream { $this->GIF_bfseek++ } );
	 -		}
	 +		return 1;
	 -	}
	 */
	private function GIFGetByte ( $len ) {
		$this->GIF_buffer = Array ( );

		for ( $i = 0; $i < $len; $i++ ) {
			if ( $this->GIF_bfseek > strlen ( $this->GIF_stream ) ) {
				return 0;
			}
			$this->GIF_buffer [ ] = ord ( $this->GIF_stream { $this->GIF_bfseek++ } );
		}
		return 1;
	}
	/*
	:::::::::::::::::::::::::::::::::::::::::::::::::::
	::
	::	GIFPutByte ( $bytes )
	::
	*/
	private function GIFPutByte ( $bytes ) {
		for ( $i = 0; $i < count ( $bytes ); $i++ ) {
			$this->GIF_string .= chr ( $bytes [ $i ] );
		}
	}
	/*
	:::::::::::::::::::::::::::::::::::::::::::::::::::
	::
	::	PUBLIC FUNCTIONS
	::
	::
	::	GIFGetFrames ( )
	::
	*/
	public function GIFGetFrames ( ) {
		return ( $this->GIF_arrays );
	}
	/*
	:::::::::::::::::::::::::::::::::::::::::::::::::::
	::
	::	GIFGetDelays ( )
	::
	*/
	public function GIFGetDelays ( ) {
		return ( $this->GIF_delays );
	}
}
