<?php
/*
 +----------------------------------------------------------------------
 | TEMMOKUMVC [ NO BEST, ONLY BETTER ]
 +----------------------------------------------------------------------
 | Copyright (c) 2018~2019 https://www.temmoku.cn All rights reserved.
 +----------------------------------------------------------------------
 | Author: 张宗强 Email:webmaster@temmoku.cn QQ:158726877 516669373 TEL:17895221001 微信:temmokumvc
 +---------------------------------------------------------------------- 
*/
namespace temmoku\lib;
use temmoku\lib\gd;
class uploadFiles{
	protected $_ModelDB_Setting=[];
	protected $_file_name='';
	protected $_file_tmp='';
	protected $_After='';
	private $is_thumb=false;
	private $is_gd=null;
	private $path=null;
	/*
	 * $ModelDB_Setting 为模型的上传允许的文件
	 * $files_path 为上传时的名称
	 * $Return 以数组还是json数据返回
	 * $thumb 是否缩略图，如果设置不备份，会覆盖原图
	 * $is_gd 设置值时才启用
	 * $path 保存路径(绝对地址)
	 */
	public function Upload_Star($ModelDB_Setting,$files_path,$is_thumb=false,$Return='json',$is_gd=null,$path=null){
		ob_clean();
		error_reporting(E_ERROR);
		$this->is_gd=$is_gd;
		$this->path=$path;
		$this->is_thumb=&$is_thumb;
		$this->_ModelDB_Setting		=	$ModelDB_Setting['ziduan_neirong'];
		$this->_file_name 			= 	$_FILES[$files_path]['name']; //上传文件的文件名 'Chrysanthemum.jpg'  
		$this->_file_tmp 			= 	$_FILES[$files_path]['tmp_name']; //服务器端临时文件存放路径 'D:\wamp\tmp\php71E6.tmp'      
		$file_size 					= 	$_FILES[$files_path]['size']; //上传文件的大小 879394   858 KB (879,394 字节)  
		$file_error 				= 	$_FILES[$files_path]['error']; //错误信息 0
		$file_type 					= 	$_FILES[$files_path]['type']; //文件类型
		$err=$this->err($file_error);
		if($err){
			$result=array('code'=>'300','text'=>$err.'错误文件为'.$this->_file_name);
			if($Return==="json"){
				return json_encode($result);
			}
			return $result;
		}
		if(($file_size >intval($ModelDB_Setting['ziduan_up_size'])*1000*1000) && $ModelDB_Setting['ziduan_up_size']){
			$result=array('code'=>'301','text'=>'文件'.$this->_file_name.'大于了设置的'.$ModelDB_Setting['ziduan_up_size'].'MB值。不允许上传');
			if($Return==="json"){
				return json_encode($result);
			}
			return $result;
		}
		if(is_Array($this->_file_name)){
			//暂时不写
		}else{
			//检查文件后戳是否合法
			$After=$this->UploadFiles_type_yz($this->UploadFiles_After());
			$result=array('code'=>'302','text'=>'不允许的上传后戳,'.$After['text']);
			if($After['code']=='0'){
				$this->_After=$After['text'];
				$result=$this->Upload_up($file_tmp_name,$After['text'],$file_name);
			}
			if($Return==="json"){
				return json_encode($result);
			}
			return $result;
      	}
    }
    public function Upload_up(){
		$result=$this->UploadFiles_Cache();
		if($result['code']=='0'){
			return array('code'=>'0','text'=>'上传成功','url'=>$result['url'],'name'=>$this->_file_name);
		}
		return $result;
    }
	//进行后戳验证防止上传一些不允许的文件
	public function UploadFiles_type_yz($type) {
		//如果是执行文件，不管是不是管理员都不允许
		$filetype =['php','asp','jsp'];
		foreach($filetype as $_type){
			if(strpos($type,$_type) !==false){
				return array("code"=>'1','text'=>$type);
			}
		}
		
		if($this->_ModelDB_Setting){//存在就是模型，必须先验证模型支持的文件类型/不是模型就往下走
			$setting= explode(" ",$this->_ModelDB_Setting);
			$in=in_array($type,$setting);
			if($in){
				return array("code"=>'0','text'=>$type);
			}else{
				return array("code"=>'1','text'=>$type);
			}
		}
		//判断会员是否设置上传的属性，没设置往下走，直接使用核心设置的参数判断
		$user_setting=C('MYGROUP.setting');
		if($user_setting['upfiles_type']){
			$U= explode(" ",$user_setting['upfiles_type']);
			$in=in_array($type,$U);
			if($in){
				return array("code"=>'0','text'=>$type);
			}else{
				return array("code"=>'1','text'=>$type);
			}
		}
		//使用全局判断
		
		$setting= explode(" ",C('UPFILES_TYPES'));
		$in=in_array($type,$setting);
		if($in){
			return array("code"=>'0','text'=>$type);
		}else{
			return array("code"=>'1','text'=>$type);
		}
	}
	//获取文件后戳
	public function UploadFiles_After()
	{
		//从左数最后一个小数点，然后进行全部小写处理。防止内部有点
		$v=strtolower(strrchr($this->_file_name,"."));
		return $v;
	}
    /* 复制上传文件到缓存位置，方便在发布的时候调用 */  
    public function UploadFiles_Cache() {
		$tempname=time().rand(10000,99999).$this->_After;
		if($this->path){
			$pic=$tempname;
			$path=$this->path;
		}else{
			$pic='tmp/'.$tempname;
			$path= Temmoku_PATH.C('UPFILES_CATALOG');
		}
        $newfile=$path.'/'.$pic;
        $write_dir=write_dir($newfile,'1');
        if($write_dir['code'] !='401'){
        	
        	if(move_uploaded_file($this->_file_tmp,$newfile))
			{
				if(IS_WIN=='0'){
					chmod($newfile, 0777);
				}
				
			}else{
				if(copy($this->_file_tmp,$newfile))
				{
					if(IS_WIN=='0'){
						chmod($newfile, 0777);
					}
				}
			}
			//如果设置上传图片时打水印并缩略
			
			$is_gd= $this->is_gd !==null ? ( $this->is_gd ? true :false ) :( C('gd_time')=='0' && C('gd')=='1' ? true :false);
			
			if( $is_gd ){
				//要判断下是不是图片，是图片才往下执行
				if(is_picture($newfile)){
					//这个是缩略图
					if($this->is_thumb==true){
						$pic=(new Gd($pic))->thumb();
					}else{
						//这是文字水印
						if('1'==C('gd_water')){
							$pic=(new Gd($pic))->water_images();
						}elseif('2'==C('gd_water')){
							$pic=(new Gd($pic))->water_text();
						}
					}
				}
			}
			return array("code"=>'0','url'=>$pic);
        }else{
        	return $write_dir;
        }
    }
    public function err($type){
    	switch ($type)
		{
			case '1':
				return	'上传的文件超过了'.get_cfg_var('upload_max_filesize');
				break;  
			case '2':
			  	return  '上传文件的大小超过了 HTML 表单中 MAX_FILE_SIZE 选项指定的值';
			  	break;
			case '3':
			  	return '文件只有部分被上传';
			  	break;
			case '4':
			  	return '没有文件被上传';
			  	break;
			case '6':
			  	return '找不到临时文件夹';
			  	break;
			case '7':
			  	return	'文件写入失败';
			  	break;
			default:
				return ;
		}
    }
}
?>