<?php 
	$this->display(tpl('head')); 
?>
	<div class="body">
		<table class="layui-table my-tabel">
			<tr>
				<td>
					<a href="/user/sms/index/" class="layui-btn layui-btn-normal">所有短信息</a>
					<a href="/user/sms/index/read/2" class="layui-btn layui-btn-warm">未读短信息</a>
					<a href="/user/sms/index/read/1" class="layui-btn layui-btn-danger">已读短信息</a>
					<a href="javascript:" lay-submit lay-filter="new_post" class="layui-btn layui-btn-danger">发短信</a>
				</td>
			</tr>
		</table>
		<form class="layui-form" method="post" action="/user/sms/del">
			<table class="layui-table my-tabel sms">
				<thead>
					<tr>
						<th width="3%"></th>
						<th width="41%">标题</th>
						<th width="10%">发信人</th>
						<th width="10%">状态</th>
						<th width="16%">发信时间</th>
						<th>操作</th>
					</tr>
				</thead>
				<tbody>
					<?php foreach($data AS $row){ ?>
					<tr id="list_<?php echo $row[id] ?>">
						<td>
							<input lay-skin="primary" type="checkbox" name="iddb[]" value="<?php echo $row[id] ?>" />
						</td>
						<td><?php echo $row[title] ?></td>
						<td><?php echo $row[from_username] ?></td>
						<td class="center" id="state_<?php echo $row[id] ?>">
							<?php if( $row[is_read] ){?>
								<span class="green">【已阅】</span>.
								
							<?php }else{?>
								<span class="red">【未读】</span>
							<?php } ?>
						</td>
						<td class="center"><?php echo date('Y-m-d H:i',$row[posttime]) ?></td>
						<td class="center">
							<button lay-submit lay-filter="look"	iid="<?php echo $row[id] ?>" class="layui-btn  layui-btn-xs">查看</button>
							<button lay-submit lay-filter="reply"	uid="<?php echo $row[from_uid] ?>" username="<?php echo $row[from_username] ?>" class="layui-btn  layui-btn-warm layui-btn-xs">回复</button>
							<button lay-submit lay-filter="del"		iid="<?php echo $row[id] ?>" class="layui-btn layui-btn-danger  layui-btn-xs">删除</button>
						</td>
					</tr>
					<?php } ?>
				</tbody>
			</table>
			<?php if($Get_Page) { ?>
			<table class="layui-table my-tabel">
				<tr>
					<td class="my-button page">
						<?php echo $Get_Page ?>
					</td>
				</tr>
			</table>
			<?php } ?>
			<table class="layui-table my-tabel">
				<tr>
					<td class="my-button">
						<button class="layui-btn layui-btn-sm layui-btn-warm" 	onclick="return all_checkbox_check('1')">全选</button>
						<button class="layui-btn layui-btn-sm layui-btn-warm" 	onclick="return all_checkbox_check('-1')">反选</button>
						<button class="layui-btn layui-btn-sm layui-btn-warm" 	onclick="return all_checkbox_check('0')">取消选择</button>
						<button class="layui-btn layui-btn-sm layui-btn-danger">删除</button>
					</td>
				</tr>
			</table>
		</form>
	</div>
	<div class="sms_read" id="sms_read" style="display: none;">
		<div class="body">
			<table class="layui-table my-tabel">
				<tr>
					<td>短信标题</td>
					<td id="title"></td>
				</tr>
				<tr>
					<td>发送人</td>
					<td id="username"></td>
				</tr>
				<tr>
					<td>短信内容</td>
					<td id="content"></td>
				</tr>
				<tr>
					<td>发送时间</td>
					<td id="time"></td>
				</tr>
			</table>
		</div>
	</div>
	<div class="sms_post" id="sms_post" style="display: none;">
		<div class="body">
			<table class="layui-table my-tabel layui-form">
				<tr>
					<td>短信标题</td>
					<td>
						<input type="text" name="title" id="post_title" class="layui-input"  placeholder="请输入短信标题"/>
					</td>
				</tr>
				<tr>
					<td>收件人</td>
					<td>
						<input type="text" id="post_username" name="username" class="layui-input" />
					</td>
				</tr>
				<tr>
					<td>短信内容</td>
					<td>
						<textarea name="content" id="post_content" placeholder="请输入短信内容" class="layui-textarea"></textarea>
					</td>
				</tr>
				<tr>
					<td colspan="2" class="my-button">
						<input type="hidden" name="uid" id="uid" />
						<button lay-submit lay-filter="post" class="layui-btn">发送</button>
					</td>
				</tr>
			</table>
		</div>
	</div>
<script type="text/javascript">
function all_checkbox_check(type){
	if(document.getElementsByClassName('layui-form-checkbox')!=undefined && document.getElementsByClassName('layui-form-checkbox').length>0){  
	  var class_box = document.getElementsByClassName('layui-form-checkbox');
	  var ids = document.getElementsByName('iddb[]');
		if(type=="1"){//全选
			for(var i=0;i<class_box.length;i++){
					$(ids[i]).prop("checked", true);
			   	$(class_box[i]).addClass("layui-form-checked");
			}
		}else if(type=="0"){//全不选
			for(var i=0;i<class_box.length;i++){
					$(ids[i]).prop("checked", false);
			    $(class_box[i]).removeClass("layui-form-checked");
			}
		}else if(type=="-1"){//反选
			for(var i=0;i<class_box.length;i++){
					if(ids[i].checked==true){
						$(ids[i]).prop("checked", false);
					}else{
						$(ids[i]).prop("checked", true);
					}
			   	$(class_box[i]).toggleClass("layui-form-checked");
			}
		}
	}
	return false;
}
layui.use(['form'], function(){
	var form = layui.form;
	//监听提交
	form.on('submit(look)', function(obj){
		var index = layer.load(1, {
		  shade: [0.5,'#000'] //0.1透明度的白色背景
		});
		var iid=obj.elem.attributes.iid.value;
		$.ajax({
			url:"/user/sms/read/",
			type: 'POST',
			data:{'id':iid,'json':true},
			dataType: 'json',
			success: function(data){
				layer.closeAll('loading');
				if(data.code !=0){
					layer.msg(data.text);
					return false;
				}else{
					$("#state_"+iid).html("<span class='green'>【已阅】</span>");
					$("#title").html(data.data.title);
					$("#content").html(data.data.content);
					$("#time").html(data.data.posttime);
					$("#username").html(data.data.from_username);
				}
			}
		})
		layer.open({
			title: '阅读短消息',
			type: 1,
			shadeClose: true,
			skin: 'layui-layer-rim', //加上边框
			area: ['80%', '240px'], //宽高
			content: $("#sms_read")
		});
	    return false;
	});
	var close_post='';
	form.on('submit(reply)', function(obj){
		var uid=obj.elem.attributes.uid.value;
		if(uid=='0'){
			layer.msg("系统信息禁止回复");
			return false;
		}
		var username=obj.elem.attributes.username.value;
		$("#uid").val(uid);
		$("#post_username").val(username);
		$("#post_username").attr('disabled',true);
	    close_post=layer.open({
			title: '发信息',
			type: 1,
			shadeClose: true,
			skin: 'layui-layer-rim', //加上边框
			area: ['80%', '370px'], //宽高
			content: $("#sms_post")
		});
	    return false;
	});
	form.on('submit(new_post)', function(obj){
		$("#uid").val('0');
		$("#post_username").val('');
		$("#post_title").val('');
		$("#post_content").val('');
	    close_post=layer.open({
			title: '发信息',
			type: 1,
			shadeClose: true,
			skin: 'layui-layer-rim', //加上边框
			area: ['80%', '370px'], //宽高
			content: $("#sms_post")
		});
	    return false;
	});
	form.on('submit(post)', function(data){
		var index = layer.load(1, {
		  shade: [0.5,'#000'] //0.1透明度的白色背景
		});
		var jsontrue={'json':true};
		c = Object.assign(data.field,jsontrue); 
		$.ajax({
			url:"/user/sms/post/",
			type: 'POST',
			data:c,
			dataType: 'json',
			success: function(data){
				layer.closeAll('loading');
				if(data.code !=0){
					layer.msg(data.text);
					return false;
				}else{
					layer.msg(data.text);
					layer.close(close_post);
					$("#uid").val('');
					$("#post_username").val('');
					$("#post_title").val('');
					$("#post_content").val('');
				}
			}
		})
    	return false;
	})
	form.on('submit(del)', function(obj){
	    var iid=obj.elem.attributes.iid.value;
		$.ajax({
			url:"/user/sms/del/",
			type: 'POST',
			data:{'id':iid,'json':true},
			dataType: 'json',
			success: function(data){
				layer.closeAll('loading');
				if(data.Result==0){
					layer.msg(data.content);
					return false;
				}else{
					$("#list_"+iid).hide("slow");;
				}
			}
		})
	    return false;
	});
})
</script>
<?php 
	$this->display(tpl('foot')); 
?>
