<?php

/*
  PHP version 5
  Copyright (c) 2002-2018 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/



use application\ESPCMS_AdminAuthority;
use application\ESPCMS_Core;
use admin_application\AdminPublicDB;
use admin_application\link\AdvertisementLink;

class AdvertisementType {

	private static $advert_type_list_cache_key;
	private static $advert_type_read_cache_key;

	public function __construct() {
		global $module_array;
		$exclude_method = array('saveAdvertisementType', 'setAdvertisementType');
		ESPCMS_AdminAuthority::authorityAdminVerify($exclude_method);
		$app_config = ESPCMS_Core::get_app_config('advertisement', false);
		if (!$app_config['isetup']) {
			espcms_message_err('public_pack-espcms_module_file_err', array($module_array['module']));
		}
		self::$advert_type_list_cache_key = ESPCMS_CACHE_DBLIST_NAME . ESPCMS_DB_PREFIX . 'advert_type_';
		self::$advert_type_read_cache_key = ESPCMS_CACHE_DBREAD_NAME . ESPCMS_DB_PREFIX . 'advert_type_';
	}
	public static function listAdvertisementType() {
		global $espcms_admin_templates, $espcms_link_db;
		$db_table = ESPCMS_DB_PREFIX . "advert_type";
		$db_table_advert = ESPCMS_DB_PREFIX . "advert";
		$out_type = $_REQUEST['out_type'];
		$lng = AdminPublicDB::get_lancode();
		$db_where = " AND lng='$lng'";
		if ($out_type == 'list') {
			$limit = $_REQUEST['limit'] && espcms_ismatches($_REQUEST['limit']) ? $_REQUEST['limit'] : 0;
			$per_page_num = $_REQUEST['per_page_num'] && espcms_ismatches($_REQUEST['per_page_num']) ? $_REQUEST['per_page_num'] : 10;
			$isclass = $_REQUEST['isclass'];
			if (espcms_ismatches($isclass)) {
				$db_where .= " AND isclass=$isclass";
			}
			$searchlist = $_GET['searchlist'];
			if ($searchlist == 'true') {
				exit(espcms_page_db($db_table, $db_where, true));
			}
			$sort_key = $_REQUEST['sort_key'];
			$sort_key_array = array('atid');
			if (isset($sort_key) && in_array($sort_key, $sort_key_array)) {
				$order_key = $sort_key;
			} else {
				$order_key = "atid";
			}
			$sort_rank = $_REQUEST['sort_rank'];
			$sort_rank_array = array('ASC', 'DESC');
			if (isset($sort_rank) && in_array($sort_rank, $sort_rank_array)) {
				$order_rank = $sort_rank;
			} else {
				$order_rank = "DESC";
			}
			$db_query = $espcms_link_db->db_query(espcms_db_list_out($db_table, $db_where, $order_key, $order_rank, $limit, $per_page_num));
			while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
				$fetch_row['adtypesum'] = espcms_db_num($db_table_advert, ' AND atid=' . $fetch_row['atid']);
				$fetch_row['edit'] = AdvertisementLink::AdvertisementType_link_array('edit', $fetch_row);
				$fetch_row['copy'] = AdvertisementLink::AdvertisementType_link_array('copy', $fetch_row);
				$fetch_row['advertlist'] = AdvertisementLink::Advertisement_link_array('index', $fetch_row);
				$array[] = $fetch_row;
			}
			$espcms_admin_templates->into('array', $array);
			$templates = 'advertisement/advertisement_type_list';
		} else {
			$espcms_admin_templates->into('page_db', espcms_page_db($db_table, $db_where));
			$espcms_admin_templates->into('link', AdvertisementLink::AdvertisementType_link_array(false, $_REQUEST));
			$templates = 'advertisement/advertisement_type_index';
		}
		$espcms_admin_templates->output($templates);
	}
	public static function addAdvertisementType() {
		global $espcms_admin_templates;
		$espcms_admin_templates->into('link', AdvertisementLink::AdvertisementType_link_array());
		$espcms_admin_templates->into('token', token());
		$espcms_admin_templates->output('advertisement/advertisement_type_add');
	}
	public static function editAdvertisementType() {
		global $espcms_admin_templates;
		$atid = $_GET['atid'];
		if (!$atid || !espcms_ismatches($atid)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($atid));
		}
		$db_table = ESPCMS_DB_PREFIX . "advert_type";
		$db_where = " WHERE atid=$atid";
		$talbe_field_array = espcms_field_out($db_table, false);
		$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read) {
			espcms_message_err('db_pack-espcms_db_read_fail', array($db_where));
		}
		$espcms_admin_templates->into('read', $read);
		$espcms_admin_templates->into('link', AdvertisementLink::AdvertisementType_link_array());
		$espcms_admin_templates->into('token', token());
		$espcms_admin_templates->into('type', !$_GET['type'] ? 'edit' : 'copy');
		$espcms_admin_templates->output('advertisement/advertisement_type_edit');
	}
	public static function saveAdvertisementType() {
		global $espcms_db_cache, $espcms_link_db;
		if (!is_token($_POST['token_name'], $_POST['token_key'])) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_repeat_fail', 'false', array($_POST['token_name']));
		}
		$saveType = $_POST['savetype'] ? $_POST['savetype'] : 'add';
		$db_table = ESPCMS_DB_PREFIX . "advert_type";
		$db_table_advert = ESPCMS_DB_PREFIX . "advert";
		$talbe_field_array = espcms_field_out($db_table, true);
		$db_table_advert_install = espcms_field_out($db_table_advert, true);
		if (!$_POST['adtypename']) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
		}
		if ($saveType == 'add' || $saveType == 'copy') {
			if (!ESPCMS_AdminAuthority::authorityVerify('addAdvertisementType')) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
			}
			$_POST['lng'] = AdminPublicDB::get_lancode();
			$_POST['isclass'] = 1;
			$postvalue = espcms_post($_POST, $talbe_field_array, true);
			if (!$postvalue || !is_array($postvalue)) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			$install_id = espcms_db_install_save($db_table, $postvalue);
			if (!$install_id) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			if ($saveType == 'copy' && $_POST['atid'] && espcms_ismatches($_POST['atid'])) {
				$install_db_where = " AND atid=" . $_POST['atid'];
				$db_query = $espcms_link_db->db_query(espcms_db_list_out($db_table_advert, $install_db_where, 'adid', 'ASC'));
				while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
					$fetch_row['atid'] = $install_id;
					$fetch_row['click'] = 0;
					$fetch_row['addtime'] = time();
					$postvalue_advert = espcms_post($fetch_row, $db_table_advert_install, true, true);
					if (!$postvalue_advert || !is_array($postvalue_advert)) {
						continue;
					}
					$advert_install_id = espcms_db_install_save($db_table_advert, $postvalue_advert);
					if (!$advert_install_id) {
						continue;
					}
				}
			}
			$espcms_db_cache->cacheDEL(self::$advert_type_list_cache_key, true);
			espcms_log_install('advert_pack-espcms_advertisemen_type_button_add', $_POST['adtypename']);
			espcms_public_dialog('espcms_info_save_ok', 'advert_pack-espcms_advertisemen_type_add_save_ok_message', 'true', array($_POST['adtypename']));
		} elseif ($saveType == 'edit') {
			if (!ESPCMS_AdminAuthority::authorityVerify('editAdvertisementType')) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
			}
			$atid = $_POST['atid'];
			if (empty($atid) || !espcms_ismatches($atid)) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($atid));
			}
			$db_where = "WHERE atid=$atid";
			$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
			if (!$read) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($atid));
			}
			unset($_POST['isclass'], $_POST['lng']);
			$postvalue = espcms_post($_POST, $talbe_field_array, true);
			if (!$postvalue || !is_array($postvalue)) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			$update_id = espcms_db_update_save($db_table, $db_where, $postvalue);
			if (!$update_id) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			$espcms_db_cache->cacheDEL(self::$advert_type_read_cache_key . $atid);
			$espcms_db_cache->cacheDEL(self::$advert_type_list_cache_key, true);
			espcms_log_install('advert_pack-espcms_advertisemen_type_button_edit', $_POST['adtypename']);
			espcms_public_dialog('espcms_info_save_ok', 'advert_pack-espcms_advertisemen_type_edit_save_ok_message', 'true', array($_POST['adtypename']));
		}
	}
	public static function setAdvertisementType() {
		global $espcms_db_cache;
		if (!ESPCMS_AdminAuthority::authorityVerify('editAdvertisementType')) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
		}
		$select_id = $_POST['select_id'];
		$field = $_POST['field'];
		$field_value = $_POST['field_value'];
		if (!is_array($select_id) || count($select_id) <= 0) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($select_id));
		}
		if (!$field || !espcms_ismatches($field_value)) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_input_parameter_fail', 'false', array($field));
		}
		$db_table = ESPCMS_DB_PREFIX . "advert_type";
		$talbe_field_array = array('isclass');
		if (!in_array($field, $talbe_field_array)) {
			espcms_public_dialog('info_set_err', 'db_pack-espcms_db_field_fail', 'false', array($field));
		}
		$update_count = 0;
		foreach ($select_id as $key => $value) {
			if (!espcms_ismatches($value)) {
				continue;
			}
			$update_key = espcms_db_update_set_save($db_table, "WHERE atid=$value", "$field='$field_value'");
			if ($update_key) {
				$update_count++;
				$espcms_db_cache->cacheDEL(self::$advert_type_read_cache_key . $value);
			}
		}
		$set_info_id = implode(', ', $select_id);
		$espcms_db_cache->cacheDEL(self::$advert_type_list_cache_key, true);
		espcms_log_install('advert_pack-espcms_advertisemen_type_button_set', "$field=$field_value" . " atid=" . $set_info_id);
		espcms_public_dialog('info_set_ok', 'advert_pack-espcms_advertisemen_type_set_message', 'true', array($field));
	}
	public static function delAdvertisementType() {
		global $espcms_db_cache;
		$select_id = $_POST['select_id'];
		if (!is_array($select_id) || count($select_id) <= 0) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($select_id));
		}
		$delcount = 0;
		foreach ($select_id as $value) {
			$operate_result = self::delAdvertisementTypeDB($value);
			if ($operate_result['code'] == 'true') {
				$delcount++;
			}
		}
		$espcms_del_id = implode(', ', $select_id);
		$espcms_db_cache->cacheDEL(self::$advert_type_list_cache_key, true);
		espcms_log_install('advert_pack-espcms_advertisemen_type_button_del', $espcms_del_id);
		$return['count'] = $delcount;
		espcms_public_dialog('espcms_public_dialog', 'advert_pack-espcms_advertisemen_type_del_message', 'true', array(), 'json', $return);
	}
	public static function delAdvertisementTypeDB($atid = 0) {
		global $espcms_db_cache;
		if (!$atid || !espcms_ismatches($atid)) {
			$return_array = array('lan' => 'public_pack-espcms_input_parameter_fail', 'code' => 'false', 'key' => $atid);
			return $return_array;
		}
		$db_table = ESPCMS_DB_PREFIX . "advert_type";
		$db_table_advert = ESPCMS_DB_PREFIX . "advert";
		$del_query = espcms_db_del($db_table, 'atid', $atid);
		if ($del_query) {
			espcms_db_del($db_table_advert, 'atid', $atid);
			$espcms_db_cache->cacheDEL(self::$advert_type_read_cache_key . $atid);
			$return_array = array('lan' => 'public_pack-espcms_del_ok', 'code' => 'true', 'key' => $atid);
			return $return_array;
		} else {
			$return_array = array('lan' => 'public_pack-espcms_del_err', 'code' => 'false', 'key' => $atid);
			return $return_array;
		}
	}

}
