<?php

/*
  PHP version 5
  Copyright (c) 2002-2019ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/

use application\ESPCMS_AdminAuthority;
use admin_application\AdminPublicDB;
use application\ESPCMS_FileTool;
use admin_application\link\SettingLink;

class CacheMange {
    public function __construct() {
        $exclude_method = array('saveCacheMange');
        ESPCMS_AdminAuthority::authorityAdminVerify($exclude_method);
    }

    public static function entranceCacheMange() {
        global $espcms_admin_templates;
        $admin_member_id = ESPCMS_AdminAuthority::getUserLoginInfo('admin_member_id');
        if (empty($admin_member_id) || !espcms_ismatches($admin_member_id)) {
            espcms_message_err('public_pack-espcms_input_parameter_fail', array($admin_member_id));
        }
        $admin_view = AdminPublicDB::get_admin_member_view($admin_member_id);
        if (!$admin_view) {
            espcms_message_err('db_pack-espcms_db_read_fail', array($admin_member_id));
        }
        $espcms_admin_templates->into('admin_view', $admin_view);
        $espcms_admin_templates->into('link', SettingLink::Cache_link_array());
        $espcms_admin_templates->into('token', token());
        $espcms_admin_templates->output('admin/admin_cache_manage');
    }

    public static function saveCacheMange() {
        if (!is_token($_POST['token_name'], $_POST['token_key'])) {
            espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_repeat_fail', 'false', array($_POST['token_name']));
        }
        $cache_type = $_POST['cache_type'];
        switch ($cache_type) {
            case 'db':
                $cache_name = espcms_lan_pack('setting_pack-espcms_admin_cache_type_db');
                $cache_dir = ESPCMS_FILE_ROOT . 'espcms_datacache/dbcache/';
                break;
            case 'webtemplates':
                $cache_name = espcms_lan_pack('setting_pack-espcms_admin_cache_type_webtemplates');
                $cache_dir = ESPCMS_FILE_ROOT . 'espcms_datacache/web_templates/';
                break;
            case 'waptemplates':
                $cache_name = espcms_lan_pack('setting_pack-espcms_admin_cache_type_waptemplates');
                $cache_dir = ESPCMS_FILE_ROOT . 'espcms_datacache/wap_templates/';
                break;
            case 'get':
                $cache_name = espcms_lan_pack('setting_pack-espcms_admin_cache_type_get');
                $cache_dir = ESPCMS_FILE_ROOT . 'espcms_datacache/dbcache/';
                break;
            case 'pic':
                $cache_name = espcms_lan_pack('setting_pack-espcms_admin_cache_type_pic');
                $cache_dir = ESPCMS_FILE_ROOT . 'espcms_datacache/dbpic/';
                break;
        }
        if ($cache_name) {
            ESPCMS_FileTool::delDirFile($cache_dir);
        }
        espcms_log_install('setting_pack-espcms_admin_cache_name', $cache_name);
        espcms_public_dialog('espcms_info_save_ok', 'setting_pack-espcms_admin_cache_ok_message', 'true', array($cache_name));
    }
}
