<?php
/*
  PHP version 5
  Copyright (c) 2002-2020 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/
use application\ESPCMS_AdminAuthority;
use application\ESPCMS_Core;
use admin_application\AdminPublicDB;
use admin_application\ArticleMainDB;
use admin_application\NevigateDB;
use admin_application\ArticleTypeDB;
use modul_application\ESPCMS_FormDB;
use modul_application\ESPCMS_ArticleTypeDB;
use modul_application\ESPCMS_ForumDB;
use modul_application\ESPCMS_NevigateDB;
use admin_application\link\NevigateLink;
use admin_application\link\ArticleLink;
class Nevigate {
    private static $nevigate_list_cache_key;
    public function __construct() {
        $exclude_method = array('importNevigate', 'editNevigate', 'saveNevigate', 'sortNevigate');
        ESPCMS_AdminAuthority::authorityAdminVerify($exclude_method);
        self::$nevigate_list_cache_key = ESPCMS_CACHE_DBLIST_NAME . ESPCMS_DB_PREFIX . 'nevigate_';
    }
    public static function listNevigate() {
        global $espcms_admin_templates, $espcms_link_db;
        $db_table = ESPCMS_DB_PREFIX . "nevigate";
        $out_type = $_REQUEST['out_type'];
        $lng = AdminPublicDB::get_lancode();
        $db_where = " AND lng='$lng' AND nevigate_uid=0";
        if ($out_type == 'list') {
            $nevigate_ismenu = $_REQUEST['nevigate_ismenu'];
            if (espcms_ismatches($nevigate_ismenu)) {
                $db_where .= " AND nevigate_ismenu=$nevigate_ismenu";
            }
            $nevigate_iswap = $_REQUEST['nevigate_iswap'];
            if (espcms_ismatches($nevigate_iswap)) {
                $db_where .= " AND nevigate_iswap=$nevigate_iswap";
            }
            $nevigate_isaccessory = $_REQUEST['nevigate_isaccessory'];
            if (espcms_ismatches($nevigate_isaccessory)) {
                $db_where .= " AND nevigate_isaccessory=$nevigate_isaccessory";
            }
            $searchlist = $_GET['searchlist'];
            if ($searchlist == 'true') {
                exit(espcms_page_db($db_table, $db_where, true));
            }
            $sort_key = $_REQUEST['sort_key'];
            $sort_key_array = array('nevigate_id', 'nevigate_pid');
            if (isset($sort_key) && in_array($sort_key, $sort_key_array)) {
                $order_key = $sort_key;
            } else {
                $order_key = "nevigate_id";
            }
            $sort_rank = $_REQUEST['sort_rank'];
            $sort_rank_array = array('ASC', 'DESC');
            if (isset($sort_rank) && in_array($sort_rank, $sort_rank_array)) {
                $order_rank = $sort_rank;
            } else {
                $order_rank = "DESC";
            }
            $db_query = $espcms_link_db->db_query(espcms_db_list_out($db_table, $db_where, $order_key, $order_rank));
            while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
                if ($fetch_row['nevigate_modul'] == 'article' && $fetch_row['nevigate_linkid'] && espcms_ismatches($fetch_row['nevigate_linkid'])) {
                    $fetch_row['link_title'] = ArticleMainDB::get_article_view($fetch_row['nevigate_linkid'], 'title');
                }
                if ($fetch_row['nevigate_modul'] == 'type' && $fetch_row['nevigate_linkid'] && espcms_ismatches($fetch_row['nevigate_linkid'])) {
                    $fetch_row['link_title'] = ESPCMS_ArticleTypeDB::get_article_type_view($fetch_row['nevigate_linkid'], 'typename');
                }
                if ($fetch_row['nevigate_modul'] == 'sub' && $fetch_row['nevigate_linkid'] && espcms_ismatches($fetch_row['nevigate_linkid'])) {
                    $fetch_row['link_title'] = ESPCMS_ArticleTypeDB::get_article_subjectlist_view($fetch_row['nevigate_linkid'], 'subjectname');
                }
                if ($fetch_row['nevigate_modul'] == 'bbs' && $fetch_row['nevigate_linkid'] && espcms_ismatches($fetch_row['nevigate_linkid'])) {
                    $fetch_row['link_title'] = ESPCMS_ForumDB::get_bbs_typelist_view($fetch_row['nevigate_linkid'], 'typename');
                }
                if ($fetch_row['nevigate_modul'] == 'forms' && $fetch_row['nevigate_linkid'] && espcms_ismatches($fetch_row['nevigate_linkid'])) {
                    $fetch_row['link_title'] = ESPCMS_FormDB::get_form_group_view($fetch_row['nevigate_linkid'], 'formgroupname');
                }
                $fetch_row['edit'] = NevigateLink::Nevigate_link_array('edit', $fetch_row);
                $fetch_row['add'] = NevigateLink::Nevigate_link_array('add', $fetch_row);
                $fetch_row['addlink'] = NevigateLink::Nevigate_link_array('addlink', $fetch_row);
                $fetch_row['import'] = NevigateLink::Nevigate_link_array('import', $fetch_row);
                $fetch_row['pathid'] = $fetch_row['nevigate_id'];
                $fetch_row['parentpath'] = 0;
                $fetch_row['childArray'] = ESPCMS_NevigateDB::get_nevigate_last_list($fetch_row['lng'], $fetch_row['nevigate_id']);
                if (is_array($fetch_row['childArray'])) {
                    foreach ($fetch_row['childArray'] as $key => $value) {
                        if ($value['nevigate_modul'] == 'article' && $value['nevigate_linkid'] && espcms_ismatches($value['nevigate_linkid'])) {
                            $fetch_row['childArray'][$key]['link_title'] = ArticleMainDB::get_article_view($value['nevigate_linkid'], 'title');
                        }
                        if ($value['nevigate_modul'] == 'type' && $value['nevigate_linkid'] && espcms_ismatches($value['nevigate_linkid'])) {
                            $fetch_row['childArray'][$key]['link_title'] = ESPCMS_ArticleTypeDB::get_article_type_view($value['nevigate_linkid'], 'typename');
                        }
                        if ($value['nevigate_modul'] == 'sub' && $value['nevigate_linkid'] && espcms_ismatches($value['nevigate_linkid'])) {
                            $fetch_row['childArray'][$key]['link_title'] = ESPCMS_ArticleTypeDB::get_article_subjectlist_view($value['nevigate_linkid'], 'subjectname');
                        }
                        if ($value['nevigate_modul'] == 'bbs' && $value['nevigate_linkid'] && espcms_ismatches($value['nevigate_linkid'])) {
                            $fetch_row['childArray'][$key]['link_title'] = ESPCMS_ForumDB::get_bbs_typelist_view($value['nevigate_linkid'], 'typename');
                        }
                        if ($value['nevigate_modul'] == 'forms' && $value['nevigate_linkid'] && espcms_ismatches($value['nevigate_linkid'])) {
                            $fetch_row['childArray'][$key]['link_title'] = ESPCMS_FormDB::get_form_group_view($value['nevigate_linkid'], 'formgroupname');
                        }
                        $fetch_row['childArray'][$key]['childArray'] = ESPCMS_NevigateDB::get_nevigate_last_list($fetch_row['lng'], $value['nevigate_id'], $fetch_row['pathid']);
                        if (is_array($fetch_row['childArray'][$key]['childArray'])) {
                            foreach ($fetch_row['childArray'][$key]['childArray'] as $ii => $las_read) {
                                if ($las_read['nevigate_modul'] == 'article' && $las_read['nevigate_linkid'] && espcms_ismatches($las_read['nevigate_linkid'])) {
                                    $fetch_row['childArray'][$key]['childArray'][$ii]['link_title'] = ArticleMainDB::get_article_view($las_read['nevigate_linkid'], 'title');
                                }
                                if ($las_read['nevigate_modul'] == 'type' && $las_read['nevigate_linkid'] && espcms_ismatches($las_read['nevigate_linkid'])) {
                                    $fetch_row['childArray'][$key]['childArray'][$ii]['link_title'] = ESPCMS_ArticleTypeDB::get_article_type_view($las_read['nevigate_linkid'], 'typename');
                                }
                                if ($las_read['nevigate_modul'] == 'sub' && $las_read['nevigate_linkid'] && espcms_ismatches($las_read['nevigate_linkid'])) {
                                    $fetch_row['childArray'][$key]['childArray'][$ii]['link_title'] = ESPCMS_ArticleTypeDB::get_article_subjectlist_view($las_read['nevigate_linkid'], 'subjectname');
                                }
                                if ($las_read['nevigate_modul'] == 'bbs' && $las_read['nevigate_linkid'] && espcms_ismatches($las_read['nevigate_linkid'])) {
                                    $fetch_row['childArray'][$key]['childArray'][$ii]['link_title'] = ESPCMS_ForumDB::get_bbs_typelist_view($las_read['nevigate_linkid'], 'typename');
                                }
                                if ($las_read['nevigate_modul'] == 'forms' && $las_read['nevigate_linkid'] && espcms_ismatches($las_read['nevigate_linkid'])) {
                                    $fetch_row['childArray'][$key]['childArray'][$ii]['link_title'] = ESPCMS_FormDB::get_form_group_view($las_read['nevigate_linkid'], 'formgroupname');
                                }
                            }
                        }
                    }
                }
                $array[] = $fetch_row;
            }
            $espcms_admin_templates->into('array', $array);
            $templates = 'admin/nevigate_list';
        } else {
            $espcms_admin_templates->into('link', NevigateLink::Nevigate_link_array(false, $_REQUEST));
            $templates = 'admin/nevigate_index';
        }
        $espcms_admin_templates->output($templates);
    }
    public static function addNevigate() {
        global $espcms_admin_templates;
        $lng = AdminPublicDB::get_lancode();
        $nevigate_linktype = $_GET['nevigate_linktype'] && espcms_ismatches($_GET['nevigate_linktype']) ? $_GET['nevigate_linktype'] : 1;
        if ($nevigate_linktype == 1) {
            $member_app_config = ESPCMS_Core::get_app_config('member', false);
            $espcms_admin_templates->into('member_app', $member_app_config);
            $order_app_config = ESPCMS_Core::get_app_config('order', false);
            $espcms_admin_templates->into('order_app', $order_app_config);
            $enquiry_app_config = ESPCMS_Core::get_app_config('enquiry', false);
            $espcms_admin_templates->into('enquiry_app', $enquiry_app_config);
            $forms_app_config = ESPCMS_Core::get_app_config('formsmanage', false);
            if ($forms_app_config['isetup'] && $forms_app_config['isopen']) {
                $form_group_array = ESPCMS_FormDB::get_form_group_list($lng);
                $espcms_admin_templates->into('form_group_array', $form_group_array);
            }
            $espcms_admin_templates->into('forms_app', $forms_app_config);
            $bbs_app_config = ESPCMS_Core::get_app_config('bbsemanage', false);
            if ($bbs_app_config['isetup'] && $bbs_app_config['isopen']) {
                $bbs_type_array = ESPCMS_ForumDB::get_bbs_typelist_list($lng, 0, 1);
                $espcms_admin_templates->into('bbs_type_array', $bbs_type_array);
            }
            $espcms_admin_templates->into('bbs_app', $bbs_app_config);
            $espcms_admin_templates->into('article_select_link', ArticleLink::Article_Main_link_array('select'));
            $article_type_array = ArticleTypeDB::get_article_type_list(0, 0, 0, 1, $lng, true, false);
            $espcms_admin_templates->into('article_type_array', $article_type_array);
            $article_subjectlist_array = ArticleTypeDB::get_document_subjectlist_list($lng, 0, 0, 1);
            $espcms_admin_templates->into('article_subjectlist_array', $article_subjectlist_array);
        }
        $nevigate_id = $_GET['nevigate_id'];
        if ($nevigate_id && espcms_ismatches($nevigate_id)) {
            $read = NevigateDB::get_nevigate_id_view($nevigate_id);
            $espcms_admin_templates->into('read', $read);
        }
        $espcms_admin_templates->into('link', NevigateLink::Nevigate_link_array());
        $espcms_admin_templates->into('token', token());
        $espcms_admin_templates->into('nevigate_linktype', $nevigate_linktype);
        $espcms_admin_templates->output('admin/nevigate_add');
    }
    public static function editNevigate() {
        global $espcms_admin_templates;
        $lng = AdminPublicDB::get_lancode();
        $nevigate_id = $_GET['nevigate_id'];
        if (!$nevigate_id || !espcms_ismatches($nevigate_id)) {
            espcms_message_err('public_pack-espcms_input_parameter_fail', array($nevigate_id));
        }
        $db_where = "WHERE nevigate_id=$nevigate_id";
        $db_table = ESPCMS_DB_PREFIX . 'nevigate';
        $talbe_field_array = espcms_field_out($db_table, false);
        $read = espcms_db_read($db_table, $db_where, $talbe_field_array);
        if (!$read) {
            espcms_message_err('db_pack-espcms_db_read_fail', array($nevigate_id));
        }
        if ($read['nevigate_linktype'] == 1) {
            $member_app_config = ESPCMS_Core::get_app_config('member', false);
            $espcms_admin_templates->into('member_app', $member_app_config);
            $order_app_config = ESPCMS_Core::get_app_config('order', false);
            $espcms_admin_templates->into('order_app', $order_app_config);
            $enquiry_app_config = ESPCMS_Core::get_app_config('enquiry', false);
            $espcms_admin_templates->into('enquiry_app', $enquiry_app_config);
            $forms_app_config = ESPCMS_Core::get_app_config('formsmanage', false);
            if ($forms_app_config['isetup'] && $forms_app_config['isopen']) {
                if ($read['nevigate_modul'] == 'forms') {
                    $form_group_array = ESPCMS_FormDB::get_form_group_list($lng, $read['nevigate_linkid']);
                } else {
                    $form_group_array = ESPCMS_FormDB::get_form_group_list($lng);
                }
                $espcms_admin_templates->into('form_group_array', $form_group_array);
            }
            $espcms_admin_templates->into('forms_app', $forms_app_config);
            $bbs_app_config = ESPCMS_Core::get_app_config('bbsemanage', false);
            if ($bbs_app_config['isetup'] && $bbs_app_config['isopen'] && $read['nevigate_modul'] == 'bbs') {
                if ($read['nevigate_modul'] == 'bbs') {
                    $bbs_type_array = ESPCMS_ForumDB::get_bbs_typelist_list($lng, $read['nevigate_linkid'], 1);
                } else {
                    $bbs_type_array = ESPCMS_ForumDB::get_bbs_typelist_list($lng, 0, 1);
                }
                $espcms_admin_templates->into('bbs_type_array', $bbs_type_array);
            }
            $espcms_admin_templates->into('bbs_app', $bbs_app_config);
            $espcms_admin_templates->into('article_select_link', ArticleLink::Article_Main_link_array('select'));
            $article_type_array = $read['nevigate_modul'] == 'type' ? ArticleTypeDB::get_article_type_list($read['nevigate_linkid'], 0, 0, 1, $lng, true, false) : ArticleTypeDB::get_article_type_list(0, 0, 0, 1, $lng, true, false);
            $espcms_admin_templates->into('article_type_array', $article_type_array);
            $article_subjectlist_array = $read['nevigate_modul'] == 'sub' ? ArticleTypeDB::get_document_subjectlist_list($lng, $read['nevigate_linkid'], 0, 1) : ArticleTypeDB::get_document_subjectlist_list($lng, 0, 0, 1);
            $espcms_admin_templates->into('article_subjectlist_array', $article_subjectlist_array);
            if ($read['nevigate_linkid'] && espcms_ismatches($read['nevigate_linkid']) && $read['nevigate_modul'] == 'article') {
                $doc_list = ArticleMainDB::get_article_list($read['nevigate_linkid']);
                $title_array = is_array($doc_list) ? espcms_array_onedim($doc_list, 'title') : array();
                $title_list = is_array($title_array) ? implode(',', $title_array) : '';
                $espcms_admin_templates->into('doc_list', $doc_list);
                $espcms_admin_templates->into('title_list', $title_list);
            }
        }
        $espcms_admin_templates->into('read', $read);
        $espcms_admin_templates->into('link', NevigateLink::Nevigate_link_array());
        $espcms_admin_templates->into('token', token());
        $espcms_admin_templates->output('admin/nevigate_edit');
    }
    public static function importNevigate() {
        global $espcms_admin_templates;
        $lng = AdminPublicDB::get_lancode();
        $nevigate_id = $_GET['nevigate_id'];
        if (!$nevigate_id || !espcms_ismatches($nevigate_id)) {
            espcms_message_err('public_pack-espcms_input_parameter_fail', array($nevigate_id));
        }
        $db_where = "WHERE nevigate_id=$nevigate_id";
        $db_table = ESPCMS_DB_PREFIX . 'nevigate';
        $talbe_field_array = espcms_field_out($db_table, false);
        $read = espcms_db_read($db_table, $db_where, $talbe_field_array);
        if (!$read || $read['nevigate_modul'] != 'type') {
            espcms_message_err('db_pack-espcms_db_read_fail', array($nevigate_id));
        }
        $article_type_array = ArticleTypeDB::get_article_type_list($read['nevigate_linkid'], 0, 0, 1, $lng, true, false);
        $espcms_admin_templates->into('article_type_array', $article_type_array);
        $espcms_admin_templates->into('read', $read);
        $espcms_admin_templates->into('link', NevigateLink::Nevigate_link_array());
        $espcms_admin_templates->into('token', token());
        $espcms_admin_templates->output('admin/nevigate_import');
    }
    public static function saveNevigate() {
        global $espcms_db_cache;
        if (!is_token($_POST['token_name'], $_POST['token_key'])) {
            espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_repeat_fail', 'false', array($_POST['token_name']));
        }
        $saveType = $_POST['savetype'] ? $_POST['savetype'] : 'add';
        $lng = AdminPublicDB::get_lancode();
        $db_table = ESPCMS_DB_PREFIX . "nevigate";
        $talbe_field_array = espcms_field_out($db_table, true);
        if ($saveType != 'import') {
            if (!espcms_ismatches($_POST['nevigate_isaccessory']) || !espcms_ismatches($_POST['nevigate_iswap']) || !espcms_ismatches($_POST['nevigate_ismenu'])) {
                espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
            }
            if ($_POST['nevigate_linktype'] == 1 && !$_POST['nevigate_modul']) {
                espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
            }
            if ($_POST['nevigate_linktype'] == 2 && !espcms_isurl($_POST['nevigate_url'])) {
                espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
            }
            if (!espcms_ismatches($_POST['nevigate_linktype']) || !espcms_ismatches($_POST['nevigate_target']) || !$_POST['nevigate_name']) {
                espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
            }
            $_POST['nevigate_modul'] = $_POST['nevigate_linktype'] == 2 ? 'link' : $_POST['nevigate_modul'];
            $_POST['nevigate_url'] = $_POST['nevigate_linktype'] == 2 ? $_POST['nevigate_url'] : '';
            if ($_POST['nevigate_linktype'] == 1 && $_POST['nevigate_modul'] == 'type' && !espcms_ismatches($_POST['tid'], "/^[1-9]{1}[0-9]*$/i")) {
                espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
            }
            if ($_POST['nevigate_linktype'] == 1 && $_POST['nevigate_modul'] == 'sub' && !espcms_ismatches($_POST['sid'], "/^[1-9]{1}[0-9]*$/i")) {
                espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
            }
            if ($_POST['nevigate_linktype'] == 1 && $_POST['nevigate_modul'] == 'article' && !espcms_ismatches($_POST['nevigate_linkid'], "/^[1-9]{1}[0-9]*$/i")) {
                espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
            }
            if ($_POST['nevigate_linktype'] == 1 && $_POST['nevigate_modul'] == 'forms' && !espcms_ismatches($_POST['fgid'], "/^[1-9]{1}[0-9]*$/i")) {
                espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
            }
            if ($_POST['nevigate_linktype'] == 1 && $_POST['nevigate_modul'] == 'bbs' && !espcms_ismatches($_POST['btid'], "/^[1-9]{1}[0-9]*$/i")) {
                espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
            }
            if ($_POST['nevigate_linktype'] == 1) {
                switch ($_POST['nevigate_modul']) {
                    case 'type':
                        $_POST['nevigate_linkid'] = $_POST['tid'];
                        break;
                    case 'sub':
                        $_POST['nevigate_linkid'] = $_POST['sid'];
                        break;
                    case 'article':
                        $_POST['nevigate_linkid'] = $_POST['nevigate_linkid'];
                        break;
                    case 'forms':
                        $_POST['nevigate_linkid'] = $_POST['fgid'];
                        break;
                    case 'bbs':
                        $_POST['nevigate_linkid'] = $_POST['btid'];
                        break;
                    default:
                        $_POST['nevigate_linkid'] = 0;
                        break;
                }
            } else {
                $_POST['nevigate_linkid'] = 0;
            }
        }
        if ($saveType == 'import') {
            if (!espcms_ismatches($_POST['tid'], "/^[1-9]{1}[0-9]*$/i")) {
                espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
            }
        }
        if ($saveType == 'add') {
            if (!ESPCMS_AdminAuthority::authorityVerify('addNevigate')) {
                espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
            }
            $_POST['nevigate_uid'] = $_POST['nevigate_uid'] && espcms_ismatches($_POST['nevigate_uid']) ? $_POST['nevigate_uid'] : 0;
            if ($_POST['nevigate_uid']) {
                $up_read = NevigateDB::get_nevigate_id_view($_POST['nevigate_uid']);
                $_POST['nevigate_topid'] = $up_read['nevigate_topid'] && espcms_ismatches($up_read['nevigate_topid']) ? $up_read['nevigate_topid'] : $up_read['nevigate_id'];
            } else {
                $_POST['nevigate_topid'] = 0;
            }
            $_POST['lng'] = $lng;
            $nevigate_pid = NevigateDB::lastPidNevigate($lng, 'nevigate_pid');
            $_POST['nevigate_pid'] = espcms_ismatches($nevigate_pid) ? $nevigate_pid + 1 : 0;
            $postvalue = espcms_post($_POST, $talbe_field_array, true);
            if (!$postvalue || !is_array($postvalue)) {
                espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
            }
            $install_id = espcms_db_install_save($db_table, $postvalue);
            if (!$install_id) {
                espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
            }
            $espcms_db_cache->cacheDEL(self::$nevigate_list_cache_key . $_POST['lng'], true);
            espcms_log_install('nevigate_pack-espcms_nevigate_button_add', $_POST['nevigate_name']);
            espcms_public_dialog('espcms_info_save_ok', 'nevigate_pack-espcms_nevigate_add_save_ok_message', 'true', array($_POST['nevigate_name']));
        } elseif ($saveType == 'edit') {
            if (!ESPCMS_AdminAuthority::authorityVerify('addNevigate')) {
                espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
            }
            $nevigate_id = $_POST['nevigate_id'];
            if (empty($nevigate_id) || !espcms_ismatches($nevigate_id)) {
                espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($nevigate_id));
            }
            $db_where = "WHERE nevigate_id=$nevigate_id";
            $read = espcms_db_read($db_table, $db_where, $talbe_field_array);
            if (!$read) {
                espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($nevigate_id));
            }
            unset($_POST['nevigate_linktype'], $_POST['nevigate_pid'], $_POST['lng'], $_POST['nevigate_uid'], $_POST['nevigate_topid']);
            $postvalue = espcms_post($_POST, $talbe_field_array, true);
            if (!$postvalue || !is_array($postvalue)) {
                espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
            }
            $update_id = espcms_db_update_save($db_table, $db_where, $postvalue);
            if (!$update_id) {
                espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
            }
            $espcms_db_cache->cacheDEL(self::$nevigate_list_cache_key . $read['lng'], true);
            espcms_log_install('nevigate_pack-espcms_nevigate_button_edit', $_POST['nevigate_name']);
            espcms_public_dialog('espcms_info_save_ok', 'nevigate_pack-espcms_nevigate_edit_save_ok_message', 'true', array($_POST['nevigate_name']));
        } elseif ($saveType == 'import') {
            if (!ESPCMS_AdminAuthority::authorityVerify('addNevigate')) {
                espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
            }
            $nevigate_id = $_POST['nevigate_id'];
            if (empty($nevigate_id) || !espcms_ismatches($nevigate_id)) {
                espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($nevigate_id));
            }
            $db_where = "WHERE nevigate_id=$nevigate_id";
            $read = espcms_db_read($db_table, $db_where, $talbe_field_array);
            if (!$read) {
                espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($nevigate_id));
            }
            $upid = $_POST['tid'];
            $db_where_type = " AND upid=$upid AND isclass=1";
            $db_table_type = ESPCMS_DB_PREFIX . 'document_typelist';
            $talbe_field_array_type = espcms_field_out($db_table_type, false);
            $type_array = espcms_db_list_array($db_table_type, $talbe_field_array_type, $db_where_type, "pid,tid DESC");
            if (!is_array($type_array) || count($type_array) < 1) {
                espcms_public_dialog('espcms_public_dialog', 'nevigate_pack-espcms_nevigate_import_save_err', 'false');
            }
            foreach ($type_array as $type_read) {
                $nev_install_id = NevigateDB::nevigat_type_install($nevigate_id, $read, $type_read, $lng);
                if ($nev_install_id) {
                    continue;
                }
            }
            $espcms_db_cache->cacheDEL(self::$nevigate_list_cache_key . $read['lng'], true);
            espcms_log_install('nevigate_pack-espcms_nevigate_button_edit', $read['nevigate_name']);
            espcms_public_dialog('espcms_info_save_ok', 'nevigate_pack-espcms_nevigate_import_save_ok_message', 'true', array($read['nevigate_name']));
        }
    }
    public static function delNevigate() {
        global $espcms_db_cache;
        $select_id = $_POST['select_id'];
        $lng = AdminPublicDB::get_lancode();
        if (!is_array($select_id) || count($select_id) <= 0) {
            espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($select_id));
        }
        $delcount = 0;
        foreach ($select_id as $value) {
            $operate_result = self::delNevigateDB($value);
            if ($operate_result['code'] == 'true') {
                $delcount++;
            }
        }
        $espcms_db_cache->cacheDEL(self::$nevigate_list_cache_key . $lng, true);
        $espcms_del_id = implode(', ', $select_id);
        espcms_log_install('nevigate_pack-espcms_nevigate_button_del', $espcms_del_id);
        $return['count'] = $delcount;
        espcms_public_dialog('espcms_public_dialog', 'nevigate_pack-espcms_nevigate_del_message', 'true', array(), 'json', $return);
    }
    private static function delNevigateDB($nevigate_id = 0) {
        if (!$nevigate_id || !espcms_ismatches($nevigate_id)) {
            $return_array = array('lan' => 'public_pack-espcms_input_parameter_fail', 'code' => 'false', 'key' => $nevigate_id);
            return $return_array;
        }
        $read = NevigateDB::get_nevigate_id_view($nevigate_id);
        if (!$read) {
            $return_array = array('lan' => 'public_pack-espcms_input_parameter_fail', 'code' => 'false', 'key' => $nevigate_id);
            return $return_array;
        }
        $db_table = ESPCMS_DB_PREFIX . "nevigate";
        if ($read['nevigate_uid'] == 0 && $read['nevigate_topid'] == 0) {
            espcms_db_delall($db_table, "nevigate_topid=$nevigate_id");
        } else {
            espcms_db_delall($db_table, "nevigate_uid=$nevigate_id");
        }
        $db_where = "nevigate_id=$nevigate_id";
        if (espcms_db_delall($db_table, $db_where)) {
            $return_array = array('lan' => 'public_pack-espcms_del_ok', 'code' => 'true', 'key' => $nevigate_id);
            return $return_array;
        } else {
            $return_array = array('lan' => 'public_pack-espcms_del_err', 'code' => 'false', 'key' => $nevigate_id);
            return $return_array;
        }
    }
    public static function sortNevigate() {
        global $espcms_db_cache;
        $lng = AdminPublicDB::get_lancode();
        $aid_array = $_POST['id_array'];
        if (!is_array($aid_array) || count($aid_array) <= 0) {
            exit('false');
        }
        $db_table = ESPCMS_DB_PREFIX . "nevigate";
        foreach ($aid_array as $key => $value) {
            $pid = $key;
            if (espcms_ismatches($pid) && espcms_ismatches($value) && $value) {
                espcms_db_update_set_save($db_table, "WHERE nevigate_id=$value", "nevigate_pid=$pid");
            }
        }
        $espcms_db_cache->cacheDEL(self::$nevigate_list_cache_key . $lng, true);
        espcms_log_install('nevigate_pack-espcms_nevigate_sort_message', 'nevigate_id=' . $value);
        exit('true');
    }
}
