<?php

/*
  PHP version 5
  Copyright (c) 2002-2018 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030
*/

use application\ESPCMS_AdminAuthority;
use application\ESPCMS_Core;
use admin_application\AdminPublicDB;
use admin_application\OnlineServiceDB;
use admin_application\link\SettingLink;
use admin_application\link\OnlineServiceLink;

class OnlineService {

	private static $calling_list_cache_key;

	public function __construct() {
		global $module_array;
		$exclude_method = array('saveOnlineService', 'setOnlineService', 'sortOnlineService');
		ESPCMS_AdminAuthority::authorityAdminVerify($exclude_method);
		$app_config = ESPCMS_Core::get_app_config('onlineService', false);
		if (!$app_config['isetup']) {
			espcms_message_err('public_pack-espcms_module_file_err', array($module_array['module']));
		}
		self::$calling_list_cache_key = ESPCMS_CACHE_DBLIST_NAME . ESPCMS_DB_PREFIX . 'calling_';
	}
	public static function listOnlineService() {
		global $espcms_admin_templates, $espcms_link_db;
		$db_table = ESPCMS_DB_PREFIX . "calling";
		$out_type = $_REQUEST['out_type'];
		$lng = AdminPublicDB::get_lancode();
		$db_where = " AND lng='$lng'";
		if ($out_type == 'list') {
			$isclass = $_REQUEST['isclass'];
			if (espcms_ismatches($isclass)) {
				$db_where .= " AND isclass=$isclass";
			}
			$searchlist = $_GET['searchlist'];
			if ($searchlist == 'true') {
				exit(espcms_page_db($db_table, $db_where, true));
			}
			$sort_key = $_REQUEST['sort_key'];
			$sort_key_array = array('cid', 'pid');
			if (isset($sort_key) && in_array($sort_key, $sort_key_array)) {
				$order_key = $sort_key;
			} else {
				$order_key = "cid";
			}
			$sort_rank = $_REQUEST['sort_rank'];
			$sort_rank_array = array('ASC', 'DESC');
			if (isset($sort_rank) && in_array($sort_rank, $sort_rank_array)) {
				$order_rank = $sort_rank;
			} else {
				$order_rank = "DESC";
			}
			$db_query = $espcms_link_db->db_query(espcms_db_list_out($db_table, $db_where, $order_key, $order_rank));
			while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
				$fetch_row['edit'] = OnlineServiceLink::OnlineService_link_array('edit', $fetch_row);
				$fetch_row['copy'] = OnlineServiceLink::OnlineService_link_array('copy', $fetch_row);
				$array[] = $fetch_row;
			}
			$espcms_admin_templates->into('array', $array);
			$templates = 'onlineservice/onlineservice_list';
		} else {
			$espcms_admin_templates->into('link', OnlineServiceLink::OnlineService_link_array(false, $_REQUEST));
			$templates = 'onlineservice/onlineservice_index';
		}
		$espcms_admin_templates->output($templates);
	}
	public static function addOnlineService() {
		global $espcms_admin_templates;
		$espcms_admin_templates->into('link', OnlineServiceLink::OnlineService_link_array());
		$espcms_admin_templates->into('fileDialog', SettingLink::FileManage_link_array('dialog', $_GET));
		$espcms_admin_templates->into('token', token());
		$espcms_admin_templates->output('onlineservice/onlineservice_add');
	}
	public static function editOnlineService() {
		global $espcms_admin_templates;
		$cid = $_GET['cid'];
		if (!$cid || !espcms_ismatches($cid)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($cid));
		}
		$db_table = ESPCMS_DB_PREFIX . "calling";
		$db_where = " WHERE cid=$cid";
		$talbe_field_array = espcms_field_out($db_table, false);
		$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read) {
			espcms_message_err('db_pack-espcms_db_read_fail', array($db_where));
		}
		$espcms_admin_templates->into('read', $read);
		$espcms_admin_templates->into('link', OnlineServiceLink::OnlineService_link_array());
		$espcms_admin_templates->into('fileDialog', SettingLink::FileManage_link_array('dialog', $_GET));
		$espcms_admin_templates->into('token', token());
		$espcms_admin_templates->into('type', !$_GET['type'] ? 'edit' : 'copy');
		$espcms_admin_templates->output('onlineservice/onlineservice_edit');
	}
	public static function saveOnlineService() {
		global $espcms_db_cache;
		if (!is_token($_POST['token_name'], $_POST['token_key'])) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_repeat_fail', 'false', array($_POST['token_name']));
		}
		$saveType = $_POST['savetype'] ? $_POST['savetype'] : 'add';
		$db_table = ESPCMS_DB_PREFIX . "calling";
		$talbe_field_array = espcms_field_out($db_table, true);
		if (!$_POST['call_name'] || !espcms_ismatches($_POST['call_type']) || !$_POST['call_type'] || !espcms_ismatches($_POST['istype']) || !espcms_ismatches($_POST['call_style']) || !espcms_ismatches($_POST['isnone'])) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
		}
		$_POST['call_code'] = espcms_ismatches($_POST['call_type']) && $_POST['call_type'] == 4 ? $_POST['content'] : $_POST['call_code'];
		if ($saveType == 'add') {
			if (!ESPCMS_AdminAuthority::authorityVerify('addOnlineService')) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
			}
			$_POST['lng'] = AdminPublicDB::get_lancode();
			$pid = OnlineServiceDB::lastPidOnlineService($_POST['lng'], 'pid');
			$_POST['pid'] = espcms_ismatches($pid) && $pid ? $pid + 1 : 1;
			$_POST['isclass'] = 1;
			$_POST['addtime'] = time();
			unset($_POST['isclass'], $_POST['click']);
			$postvalue = espcms_post($_POST, $talbe_field_array, true);
			if (!$postvalue || !is_array($postvalue)) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			$install_id = espcms_db_install_save($db_table, $postvalue);
			if (!$install_id) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			$espcms_db_cache->cacheDEL(self::$calling_list_cache_key . $_POST['lng'], true);
			espcms_log_install('onlineservice_pack-espcms_onlineservice_button_add', $_POST['call_name']);
			espcms_public_dialog('espcms_info_save_ok', 'onlineservice_pack-espcms_onlineservice_add_save_ok_message', 'true', array($_POST['call_name']));
		} elseif ($saveType == 'edit') {
			if (!ESPCMS_AdminAuthority::authorityVerify('editOnlineService')) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
			}
			$cid = $_POST['cid'];
			if (empty($cid) || !espcms_ismatches($cid)) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($cid));
			}
			$db_where = "WHERE cid=$cid";
			$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
			if (!$read) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($cid));
			}
			unset($_POST['isclass'], $_POST['addtime'], $_POST['lng'], $_POST['pid']);
			$postvalue = espcms_post($_POST, $talbe_field_array, true);
			if (!$postvalue || !is_array($postvalue)) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			$update_id = espcms_db_update_save($db_table, $db_where, $postvalue);
			if (!$update_id) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			$espcms_db_cache->cacheDEL(self::$calling_list_cache_key . $read['lng'], true);
			espcms_log_install('onlineservice_pack-espcms_onlineservice_button_edit', $_POST['call_name']);
			espcms_public_dialog('espcms_info_save_ok', 'onlineservice_pack-espcms_onlineservice_edit_save_ok_message', 'true', array($_POST['call_name']));
		}
	}
	public static function sortOnlineService() {
		global $espcms_db_cache;
		if (!ESPCMS_AdminAuthority::authorityVerify('editOnlineService')) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
		}
		$lng = AdminPublicDB::get_lancode();
		$aid_array = $_POST['id_array'];
		if (!is_array($aid_array) || count($aid_array) <= 0) {
			exit('false');
		}
		$db_table = ESPCMS_DB_PREFIX . "calling";
		foreach ($aid_array as $key => $value) {
			$pid = $key;
			if (espcms_ismatches($pid) && espcms_ismatches($value) && $value) {
				espcms_db_update_set_save($db_table, "WHERE cid=$value", "pid=$pid");
			}
		}
		$espcms_db_cache->cacheDEL(self::$calling_list_cache_key . $lng, true);
		espcms_log_install('onlineservice_pack-espcms_onlineservice_button_sort', $lng);
		exit('true');
	}
	public static function setOnlineService() {
		global $espcms_db_cache;
		if (!ESPCMS_AdminAuthority::authorityVerify('editOnlineService')) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
		}
		$select_id = $_POST['select_id'];
		$field = $_POST['field'];
		$field_value = $_POST['field_value'];
		if (!is_array($select_id) || count($select_id) <= 0) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($select_id));
		}
		if (!$field || !espcms_ismatches($field_value)) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_input_parameter_fail', 'false', array($field));
		}
		$db_table = ESPCMS_DB_PREFIX . "calling";
		$talbe_field_array = array('isclass');
		if (!in_array($field, $talbe_field_array)) {
			espcms_public_dialog('info_set_err', 'db_pack-espcms_db_field_fail', 'false', array($field));
		}
		$update_count = 0;
		foreach ($select_id as $value) {
			if (!espcms_ismatches($value)) {
				continue;
			}
			$update_key = espcms_db_update_set_save($db_table, "WHERE cid=$value", "$field='$field_value'");
			if ($update_key) {
				$update_count++;
			}
		}
		$lng = AdminPublicDB::get_lancode();
		$espcms_db_cache->cacheDEL(self::$calling_list_cache_key . $lng, true);
		$set_info_id = implode(', ', $select_id);
		espcms_log_install('onlineservice_pack-espcms_onlineservice_button_set', "$field=$field_value" . " cid=" . $set_info_id);
		espcms_public_dialog('info_set_ok', 'onlineservice_pack-espcms_onlineservice_set_message', 'true', array($field));
	}
	public static function delOnlineService() {
		global $espcms_db_cache;
		$select_id = $_POST['select_id'];
		if (!is_array($select_id) || count($select_id) <= 0) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($select_id));
		}
		$delcount = 0;
		foreach ($select_id as $value) {
			$operate_result = self::delOnlineServiceDB($value);
			if ($operate_result['code'] == 'true') {
				$delcount++;
			}
		}
		$espcms_del_id = implode(', ', $select_id);
		$lng = AdminPublicDB::get_lancode();
		$espcms_db_cache->cacheDEL(self::$calling_list_cache_key . $lng, true);
		espcms_log_install('onlineservice_pack-espcms_onlineservice_button_del', $espcms_del_id);
		$return['count'] = $delcount;
		espcms_public_dialog('espcms_public_dialog', 'onlineservice_pack-espcms_onlineservice_del_message', 'true', array(), 'json', $return);
	}
	public static function delOnlineServiceDB($cid = 0) {
		if (!$cid || !espcms_ismatches($cid)) {
			$return_array = array('lan' => 'public_pack-espcms_input_parameter_fail', 'code' => 'false', 'key' => $cid);
			return $return_array;
		}
		$db_table = ESPCMS_DB_PREFIX . "calling";
		$del_query = espcms_db_del($db_table, 'cid', $cid);
		if ($del_query) {
			$return_array = array('lan' => 'public_pack-espcms_del_ok', 'code' => 'true', 'key' => $cid);
			return $return_array;
		} else {
			$return_array = array('lan' => 'public_pack-espcms_del_err', 'code' => 'false', 'key' => $cid);
			return $return_array;
		}
	}

}
