<?php
/*
  PHP version 5
  Copyright (c) 2002-2020 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/
use application\ESPCMS_AdminAuthority;
use application\ESPCMS_Core;
use modul_application\ESPCMS_MemberDB;
use modul_application\ESPCMS_OrderDB;
use admin_application\ApplyDB;
use admin_application\link\OrderLink;
use admin_application\link\ArticleLink;
use inc_application\link\ArticleLink AS ArticleLinkWeb;
use admin_application\link\SettingLink;
use admin_application\link\MemberLink;
class OrderMain {
    public function __construct() {
        global $module_array;
        $exclude_method = array('saveOrder', 'printOrder', 'viewOrder', 'setOrder', 'argumentOrder', 'argumentSaveOrder');
        ESPCMS_AdminAuthority::authorityAdminVerify($exclude_method);
        $order_app_config = ESPCMS_Core::get_app_config('order', false);
        if (!$order_app_config['isetup']) {
            espcms_message_err('public_pack-espcms_module_file_err', array($module_array['module']));
        }
    }
    public static function listOrder() {
        global $espcms_admin_templates, $espcms_link_db;
        $db_table = ESPCMS_DB_PREFIX . "order";
        $userid = $_REQUEST['userid'];
        if (espcms_ismatches($userid) && $userid) {
            $db_where .= " AND userid=$userid";
        }
        $out_type = $_REQUEST['out_type'];
        if ($out_type == 'list') {
            $limit = $_REQUEST['limit'] && espcms_ismatches($_REQUEST['limit']) ? $_REQUEST['limit'] : 0;
            $per_page_num = $_REQUEST['per_page_num'] && espcms_ismatches($_REQUEST['per_page_num']) ? $_REQUEST['per_page_num'] : 10;
            $ordertype = $_REQUEST['ordertype'];
            if (espcms_ismatches($ordertype)) {
                $db_where .= " AND ordertype=$ordertype";
            }
            $ispay = $_REQUEST['ispay'];
            if (espcms_ismatches($ispay)) {
                $db_where .= " AND ispay=$ispay";
            }
            $isshipping = $_REQUEST['isshipping'];
            if (espcms_ismatches($isshipping)) {
                $db_where .= " AND isshipping=$isshipping";
            }
            $isinvoice = $_REQUEST['isinvoice'];
            if (espcms_ismatches($isinvoice)) {
                $db_where .= " AND isinvoice=$isinvoice";
            }
            $islock = $_REQUEST['islock'];
            if (espcms_ismatches($islock)) {
                $db_where .= " AND islock=$islock";
            }
            $order_source = $_REQUEST['order_source'];
            if ($order_source) {
                $db_where .= " AND order_source='$order_source'";
            }
            $osid = $_REQUEST['osid'];
            if (espcms_ismatches($osid) && $osid) {
                $db_where .= " AND osid=$osid";
            }
            $opid = $_REQUEST['opid'];
            if (espcms_ismatches($opid) && $opid) {
                $db_where .= " AND opid=$opid";
            }
            $search_keyname_array = array('ordersn');
            $search_keyname = $_REQUEST['search_keyname'] && in_array($_REQUEST['search_keyname'], $search_keyname_array) ? $_REQUEST['search_keyname'] : 'ordersn';
            $search_key = $_REQUEST['search_key'];
            if (isset($search_key) && !empty($search_key)) {
                $search_key = urldecode($search_key);
                $db_where .= " AND $search_keyname LIKE '%$search_key%'";
            }
            $searchlist = $_GET['searchlist'];
            if ($searchlist == 'true') {
                exit(espcms_page_db($db_table, $db_where, true));
            }
            $sort_key = $_REQUEST['sort_key'];
            $sort_key_array = array('oid', 'orderamount');
            if (isset($sort_key) && in_array($sort_key, $sort_key_array)) {
                $order_key = $sort_key;
            } else {
                $order_key = "oid";
            }
            $sort_rank = $_REQUEST['sort_rank'];
            $sort_rank_array = array('ASC', 'DESC');
            if (isset($sort_rank) && in_array($sort_rank, $sort_rank_array)) {
                $order_rank = $sort_rank;
            } else {
                $order_rank = "DESC";
            }
            $db_query = $espcms_link_db->db_query(espcms_db_list_out($db_table, $db_where, $order_key, $order_rank, $limit, $per_page_num));
            while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
                $fetch_row['username'] = ESPCMS_MemberDB::get_member_noatt_view($fetch_row['userid'], 'username');
                $fetch_row['edit'] = OrderLink::Order_link_array('edit', $fetch_row);
                $fetch_row['view'] = OrderLink::Order_link_array('view', $fetch_row);
                $fetch_row['print_ship'] = OrderLink::Order_link_array('print_ship', $fetch_row);
                $fetch_row['print'] = OrderLink::Order_link_array('print', $fetch_row);
                $fetch_row['addPay'] = OrderLink::OrderFinance_link_array('add', $fetch_row);
                $fetch_row['addExpress'] = OrderLink::OrderExpress_link_array('add', $fetch_row);
                $array[] = $fetch_row;
            }
            $espcms_admin_templates->into('array', $array);
            $templates = 'order/order_list';
        } else {
            $espcms_admin_templates->into('page_db', espcms_page_db($db_table, $db_where));
            $espcms_admin_templates->into('link', OrderLink::Order_link_array(false, $_REQUEST));
            $templates = 'order/order_index';
        }
        $espcms_admin_templates->output($templates);
    }
    public static function addOrder() {
        global $espcms_admin_templates;
        $userid = $_GET['userid'];
        if ($userid && espcms_ismatches($userid)) {
            $read = ESPCMS_MemberDB::get_member_noatt_view($userid);
            if (!$read) {
                espcms_message_err('db_pack-espcms_db_read_fail', array($userid));
            }
            $espcms_admin_templates->into('read', $read);
        }
        $espcms_admin_templates->into('fileDialog', SettingLink::FileManage_link_array('dialog', $_GET));
        $espcms_admin_templates->into('link', OrderLink::Order_link_array());
        $espcms_admin_templates->into('userlink', MemberLink::Member_link_array());
        $espcms_admin_templates->into('articlelink', ArticleLink::Article_Main_link_array());
        $espcms_admin_templates->into('token', token());
        $espcms_admin_templates->output('order/order_add');
    }
    public static function editOrder() {
        global $espcms_admin_templates;
        $oid = $_GET['oid'];
        if (!$oid || !espcms_ismatches($oid)) {
            espcms_message_err('public_pack-espcms_input_parameter_fail', array($oid));
        }
        $read = ESPCMS_OrderDB::get_order_view($oid);
        if (!$read) {
            espcms_message_err('db_pack-espcms_db_read_fail', array($oid));
        }
        $member_app_config = ESPCMS_Core::get_app_config('member', false);
        $product_array = ESPCMS_OrderDB::get_order_info_list($oid);
        $linkdid = is_array($product_array) ? espcms_array_onedim($product_array, 'did') : array();
        $read['linkdid'] = is_array($linkdid) && count($linkdid) > 0 ? implode(',', $linkdid) : '';
        $read['product_item_count'] = count($linkdid);
        if ($member_app_config['isetup'] && $read['userid'] && espcms_ismatches($read['userid'])) {
            $user_read = ESPCMS_MemberDB::get_member_noatt_view($read['userid']);
            if (!$user_read) {
                espcms_message_err('db_pack-espcms_db_read_fail', array($read['userid']));
            }
            $espcms_admin_templates->into('user_read', $user_read);
        }
        $espcms_admin_templates->into('product_array', $product_array);
        $espcms_admin_templates->into('read', $read);
        $espcms_admin_templates->into('link', OrderLink::Order_link_array());
        $espcms_admin_templates->into('userlink', MemberLink::Member_link_array());
        $espcms_admin_templates->into('articlelink', ArticleLink::Article_Main_link_array());
        $espcms_admin_templates->into('token', token());
        $espcms_admin_templates->output('order/order_edit');
    }
    public static function viewOrder() {
        global $espcms_admin_templates;
        $oid = $_GET['oid'];
        if (!$oid || !espcms_ismatches($oid)) {
            espcms_message_err('public_pack-espcms_input_parameter_fail', array($oid));
        }
        $read = ESPCMS_OrderDB::get_order_view($oid);
        if (!$read) {
            espcms_message_err('db_pack-espcms_db_read_fail', array($oid));
        }
        $member_app_config = ESPCMS_Core::get_app_config('member', false);
        $product_array = ESPCMS_OrderDB::get_order_info_list($oid);
        if (is_array($product_array)) {
            foreach ($product_array as $key => $value) {
                $product_array[$key]['view'] = ArticleLinkWeb::doc_link($value, true, false, $value['lng']);
            }
        }
        if ($member_app_config['isetup'] && $read['userid'] && espcms_ismatches($read['userid'])) {
            $user_read = ESPCMS_MemberDB::get_member_noatt_view($read['userid']);
            if (!$user_read) {
                espcms_message_err('db_pack-espcms_db_read_fail', array($read['userid']));
            }
            $espcms_admin_templates->into('user_read', $user_read);
        }
        $payreceipt_list = ESPCMS_OrderDB::get_order_payreceipt_list($oid);
        if (is_array($payreceipt_list)) {
            foreach ($payreceipt_list as $key => $value) {
                $payreceipt_list[$key]['payname'] = ESPCMS_OrderDB::get_pay_plug_view($value['opid'], 'payname');
                $payreceipt_list[$key]['view'] = OrderLink::OrderFinance_link_array('view', $value);
            }
        }
        $espcms_admin_templates->into('payreceipt_list', $payreceipt_list);
        $shipreceipt_list = ESPCMS_OrderDB::get_order_shipreceipt_list($oid);
        if (is_array($shipreceipt_list)) {
            foreach ($shipreceipt_list as $key => $value) {
                $shipreceipt_list[$key]['shippingname'] = ESPCMS_OrderDB::get_express_view($value['osid'], 'shippingname');
                $shipreceipt_list[$key]['view'] = OrderLink::OrderExpress_link_array('view', $value);
            }
        }
        $espcms_admin_templates->into('shipreceipt_list', $shipreceipt_list);
        $espcms_admin_templates->into('product_array', $product_array);
        $espcms_admin_templates->into('read', $read);
        $espcms_admin_templates->output('order/order_view');
    }
    public static function printOrder() {
        global $espcms_admin_templates;
        $oid = $_GET['oid'];
        if (!$oid || !espcms_ismatches($oid)) {
            espcms_message_err('public_pack-espcms_input_parameter_fail', array($oid));
        }
        $app_read = ESPCMS_Core::get_app_config('order', true, 'appconfig');
        $read = ESPCMS_OrderDB::get_order_view($oid);
        if (!$read) {
            espcms_message_err('db_pack-espcms_db_read_fail', array($oid));
        }
        $product_array = ESPCMS_OrderDB::get_order_info_list($oid);
        $linkdid = is_array($product_array) ? espcms_array_onedim($product_array, 'did') : array();
        $read['linkdid'] = is_array($linkdid) && count($linkdid) > 0 ? implode(',', $linkdid) : '';
        $read['product_item_count'] = count($linkdid);
        $member_app_config = ESPCMS_Core::get_app_config('member', false);
        if ($member_app_config['isetup'] && $read['userid'] && espcms_ismatches($read['userid'])) {
            $user_read = ESPCMS_MemberDB::get_member_noatt_view($read['userid']);
            if (!$user_read) {
                espcms_message_err('db_pack-espcms_db_read_fail', array($read['userid']));
            }
            $espcms_admin_templates->into('user_read', $user_read);
        }
        $GetCode = ESPCMS_Core::connect_url('GetCode', array('code' => $read['ordersn']));
        $read['barcode'] = $GetCode;
        $espcms_admin_templates->into('product_array', $product_array);
        $espcms_admin_templates->into('read', $read);
        $espcms_admin_templates->into('app_read', $app_read);
        $templates = $_GET['type'] == 'ship' ? 'order/order_print_ship' : 'order/order_print';
        $espcms_admin_templates->output($templates);
    }
    public static function saveOrder() {
        if (!is_token($_POST['token_name'], $_POST['token_key'])) {
            espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_repeat_fail', 'false', array($_POST['token_name']));
        }
        $saveType = $_POST['savetype'] ? $_POST['savetype'] : 'add';
        $db_table = ESPCMS_DB_PREFIX . "order";
        $talbe_field_array = espcms_field_out($db_table, true);
        $app_read = ESPCMS_Core::get_app_config('order', true, 'appconfig');
        $_POST['userid'] = !espcms_ismatches($_POST['userid']) || !$_POST['userid'] ? 0 : $_POST['userid'];
        if (!espcms_ismoney($_POST['productmoney']) || !espcms_ismoney($_POST['shippingmoney']) || !espcms_ismoney($_POST['paymoney']) || !espcms_ismoney($_POST['discount']) || !espcms_ismoney($_POST['orderamount']) || !espcms_ismoney($_POST['invoicefeemoney'])) {
            espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
        }
        if (!espcms_ismatches($_POST['isinvoice'])) {
            espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
        }
        if (!preg_match("/^[0-9,]+$/i", $_POST['linkdid'])) {
            espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
        }
        if ($saveType == 'add') {
            if (!ESPCMS_AdminAuthority::authorityVerify('addOrder')) {
                espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
            }
            $_POST['ordersn'] = $app_read['ORDER_SN'] ? espcms_random($app_read['ORDER_SN']) : espcms_random('ESP-[Y][M][D][H][I][S][R,2]');
            $_POST['addtime'] = time();
            $_POST['order_source'] = 'web';
            $_POST['ordertype'] = 1;
            $_POST['ispay'] = 0;
            $_POST['isshipping'] = 0;
            unset($_POST['osid'], $_POST['opid'], $_POST['paytime'], $_POST['updatetime'], $_POST['shippingtime'], $_POST['integral']);
            $postvalue = espcms_post($_POST, $talbe_field_array, true);
            if (!$postvalue || !is_array($postvalue)) {
                espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
            }
            $install_id = espcms_db_install_save($db_table, $postvalue);
            if (!$install_id) {
                espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
            }
            ESPCMS_OrderDB::order_install_goods($install_id, $_POST);
            espcms_log_install('order_pack-espcms_order_button_add', $_POST['ordersn']);
            espcms_public_dialog('espcms_info_save_ok', 'order_pack-espcms_order_add_save_ok_message', 'true', array($_POST['ordersn']));
        } elseif ($saveType == 'edit') {
            if (!ESPCMS_AdminAuthority::authorityVerify('editOrder')) {
                espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
            }
            $oid = $_POST['oid'];
            if (empty($oid) || !espcms_ismatches($oid)) {
                espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($oid));
            }
            $db_where = "WHERE oid=$oid";
            $read = espcms_db_read($db_table, $db_where, $talbe_field_array);
            if (!$read) {
                espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($oid));
            }
            $_POST['updatetime'] = time();
            unset($_POST['ordersn'], $_POST['osid'], $_POST['opid'], $_POST['paytime'], $_POST['addtime'], $_POST['shippingtime'], $_POST['integral']);
            $postvalue = espcms_post($_POST, $talbe_field_array, true);
            if (!$postvalue || !is_array($postvalue)) {
                espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
            }
            $update_id = espcms_db_update_save($db_table, $db_where, $postvalue);
            if (!$update_id) {
                espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
            }
            ESPCMS_OrderDB::order_install_goods($oid, $_POST, true);
            espcms_log_install('order_pack-espcms_order_button_edit', $read['ordersn']);
            espcms_public_dialog('espcms_info_save_ok', 'order_pack-espcms_order_edit_save_ok_message', 'true', array($read['ordersn']));
        }
    }
    public static function setOrder() {
        $oid = $_POST['oid'];
        if (!$oid || !espcms_ismatches($oid)) {
            espcms_public_dialog('info_set_err', 'public_pack-espcms_input_parameter_fail', 'false', array($oid));
        }
        $field = $_POST['field'];
        $field_value = $_POST['field_value'];
        if (!$field || !espcms_ismatches($field_value)) {
            espcms_public_dialog('info_set_err', 'public_pack-espcms_input_parameter_fail', 'false', array($field));
        }
        $db_table = ESPCMS_DB_PREFIX . "order";
        $talbe_field_array = array('islock');
        if (!in_array($field, $talbe_field_array)) {
            espcms_public_dialog('info_set_err', 'db_pack-espcms_db_field_fail', 'false', array($field));
        }
        espcms_db_update_set_save($db_table, "WHERE oid=$oid", "$field='$field_value'");
        espcms_log_install('order_pack-espcms_order_button_set', "$field=$field_value" . " oid=" . $oid);
        espcms_public_dialog('info_set_ok', 'order_pack-espcms_order_lock_message', 'true', array($field));
    }
    public static function delOrder() {
        $select_id = $_POST['select_id'];
        if (!is_array($select_id) || count($select_id) <= 0) {
            espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($select_id));
        }
        $delcount = 0;
        foreach ($select_id as $value) {
            $operate_result = self::delOrderDB($value);
            if ($operate_result['code'] == 'true') {
                $delcount++;
            }
        }
        $espcms_del_id = implode(', ', $select_id);
        espcms_log_install('order_pack-espcms_order_button_del', $espcms_del_id);
        $return['count'] = $delcount;
        espcms_public_dialog('espcms_public_dialog', 'order_pack-espcms_order_del_message', 'true', array(), 'json', $return);
    }
    private static function delOrderDB($oid = 0) {
        if (!$oid || !espcms_ismatches($oid)) {
            $return_array = array('lan' => 'public_pack-espcms_input_parameter_fail', 'code' => 'false', 'key' => $oid);
            return $return_array;
        }
        $db_table = ESPCMS_DB_PREFIX . "order";
        $db_table_order_info = ESPCMS_DB_PREFIX . "order_info";
        $db_table_order_payreceipt = ESPCMS_DB_PREFIX . "order_payreceipt";
        $db_table_order_shipreceipt = ESPCMS_DB_PREFIX . "order_shipreceipt";
        $del_query = espcms_db_del($db_table, 'oid', $oid);
        if ($del_query) {
            espcms_db_del($db_table_order_info, 'oid', $oid);
            espcms_db_del($db_table_order_payreceipt, 'oid', $oid);
            espcms_db_del($db_table_order_shipreceipt, 'oid', $oid);
            $return_array = array('lan' => 'public_pack-espcms_del_ok', 'code' => 'true', 'key' => $oid);
            return $return_array;
        } else {
            $return_array = array('lan' => 'public_pack-espcms_del_err', 'code' => 'false', 'key' => $oid);
            return $return_array;
        }
    }
    public static function argOrder() {
        global $espcms_admin_templates;
        if (!ESPCMS_AdminAuthority::authorityVerify('setExtensions')) {
            espcms_message_err('public_pack-espcms_authority_function_fail');
        }
        $app_read = ESPCMS_Core::get_app_config('order', true, 'appconfig');
        $express_list = ESPCMS_OrderDB::get_express_list($app_read['ORDER_OPID']);
        $espcms_admin_templates->into('express_list', $express_list);
        $espcms_admin_templates->into('link', OrderLink::Order_link_array());
        $espcms_admin_templates->into('token', token());
        $espcms_admin_templates->into('app_read', $app_read);
        $espcms_admin_templates->output('order/order_set');
    }
    public static function argSaveOrder() {
        if (!ESPCMS_AdminAuthority::authorityVerify('setExtensions')) {
            espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
        }
        if (!is_token($_POST['token_name'], $_POST['token_key'])) {
            espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_repeat_fail', 'false', array($_POST['token_name']));
        }
        $_POST['ORDER_INVOICE_FEE'] = espcms_ismatches($_POST['ORDER_INVOICE_FEE']) ? $_POST['ORDER_INVOICE_FEE'] : 0;
        $_POST['ORDER_ISMEMBER'] = !espcms_ismatches($_POST['ORDER_ISMEMBER']) ? 1 : $_POST['ORDER_ISMEMBER'];
        $_POST['ORDER_ISPAYDELI'] = !espcms_ismatches($_POST['ORDER_ISPAYDELI']) ? 0 : $_POST['ORDER_ISPAYDELI'];
        $_POST['ORDER_ISONLINEPAY'] = !espcms_ismatches($_POST['ORDER_ISONLINEPAY']) ? 0 : $_POST['ORDER_ISONLINEPAY'];
        $_POST['ORDER_ISTRANSFEL'] = !espcms_ismatches($_POST['ORDER_ISTRANSFEL']) ? 0 : $_POST['ORDER_ISTRANSFEL'];
        $_POST['ORDER_ISOPID'] = !espcms_ismatches($_POST['ORDER_ISOPID']) ? 0 : $_POST['ORDER_ISOPID'];
        $_POST['ORDER_OPID'] = !espcms_ismatches($_POST['ORDER_OPID']) ? 0 : $_POST['ORDER_OPID'];
        $_POST['ORDER_INTEGRAL'] = !espcms_ismatches($_POST['ORDER_INTEGRAL']) ? 0 : $_POST['ORDER_INTEGRAL'];
        $_POST['ORDER_SN'] = preg_match('/^[\w\-\[\]\,]+$/', $_POST['ORDER_SN']) ? $_POST['ORDER_SN'] : 'ESP-[Y][M][D][H][I][S][R,2]';
        $_POST['ORDER_ISEMAIL'] = !espcms_ismatches($_POST['ORDER_ISEMAIL']) ? 0 : $_POST['ORDER_ISEMAIL'];
        $_POST['ORDER_ISMOBLIE'] = !espcms_ismatches($_POST['ORDER_ISMOBLIE']) ? 0 : $_POST['ORDER_ISMOBLIE'];
        unset($_POST['token_key'], $_POST['token_name']);
        $update_id = ApplyDB::save_apply('order', $_POST);
        if ($update_id) {
            espcms_log_install('order_pack-espcms_order_set_ORDER_title');
            espcms_public_dialog('save_ok', 'order_pack-espcms_order_set_message', 'true');
        } else {
            espcms_public_dialog('save_ok', 'order_pack-espcms_order_set_message_err', 'false');
        }
    }
}
