<?php

/*
  PHP version 5
  Copyright (c) 2002-2019ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/


use application\ESPCMS_AdminAuthority;
use admin_application\link\SettingLink;

class PowerGroups {

	private static $power_groups_list_cache_key;
	private static $power_groups_read_cache_key;

	public function __construct() {
		$exclude_method = array('savePowerGroups');
		ESPCMS_AdminAuthority::authorityAdminVerify($exclude_method);
		self::$power_groups_list_cache_key = ESPCMS_CACHE_DBLIST_NAME . ESPCMS_DB_PREFIX . 'power_groups_';
		self::$power_groups_read_cache_key = ESPCMS_CACHE_DBREAD_NAME . ESPCMS_DB_PREFIX . 'power_groups_';
	}

	public static function listPowerGroups() {
		global $espcms_admin_templates, $espcms_link_db;
		$db_table = ESPCMS_DB_PREFIX . "power_groups";
		$admin_member_id = ESPCMS_AdminAuthority::getUserLoginInfo('admin_member_id');
		if (empty($admin_member_id) || !espcms_ismatches($admin_member_id)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($admin_member_id));
		}
		$out_type = $_REQUEST['out_type'];
		$db_where = " AND power_groups_isdel=1";
		if ($out_type == 'list') {

			$limit = $_REQUEST['limit'] && espcms_ismatches($_REQUEST['limit']) ? $_REQUEST['limit'] : 0;

			$per_page_num = $_REQUEST['per_page_num'] && espcms_ismatches($_REQUEST['per_page_num']) ? $_REQUEST['per_page_num'] : 10;
			$power_groups_issystem = $_REQUEST['power_groups_issystem'];
			if (espcms_ismatches($power_groups_issystem)) {
				$db_where .= " AND power_groups_issystem=$power_groups_issystem";
			}

			$searchlist = $_GET['searchlist'];
			if ($searchlist == 'true') {
				exit(espcms_page_db($db_table, $db_where, true));
			}

			$sort_key = $_REQUEST['sort_key'];
			$sort_key_array = array('power_groups_id');
			if (isset($sort_key) && in_array($sort_key, $sort_key_array)) {
				$order_key = $sort_key;
			} else {
				$order_key = "power_groups_id";
			}

			$sort_rank = $_REQUEST['sort_rank'];
			$sort_rank_array = array('ASC', 'DESC');
			if (isset($sort_rank) && in_array($sort_rank, $sort_rank_array)) {
				$order_rank = $sort_rank;
			} else {
				$order_rank = "DESC";
			}
			$db_query = $espcms_link_db->db_query(espcms_db_list_out($db_table, $db_where, $order_key, $order_rank, $limit, $per_page_num));
			while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
				$fetch_row['edit'] = SettingLink::PowerGroups_link_array('edit', $fetch_row);
				$array[] = $fetch_row;
			}
			$espcms_admin_templates->into('array', $array);
			$templates = 'admin/power_groups_list';
		} else {
			$espcms_admin_templates->into('page_db', espcms_page_db($db_table, $db_where));
			$espcms_admin_templates->into('link', SettingLink::PowerGroups_link_array(false, $_REQUEST));
			$templates = 'admin/power_groups_index';
		}
		$espcms_admin_templates->output($templates);
	}

	public static function addPowerGroups() {
		global $espcms_admin_templates, $espcms_link_db;
		$admin_member_id = ESPCMS_AdminAuthority::getUserLoginInfo('admin_member_id');
		if (empty($admin_member_id) || !espcms_ismatches($admin_member_id)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($admin_member_id));
		}
		$espcms_admin_templates->into('link', SettingLink::PowerGroups_link_array());

		$espcms_admin_templates->into('token', token());

		$db_table_menu = ESPCMS_DB_PREFIX . "menulink";
		$db_sql = "SELECT * FROM $db_table_menu WHERE menu_upid=0 AND menu_isclass=1 ORDER BY menu_pid,menu_id";
		$db_query = $espcms_link_db->db_query($db_sql);
		while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
			$menu_array_nov = array();

			$db_sql_nov = "SELECT * FROM $db_table_menu WHERE menu_upid=" . $fetch_row['menu_id'] . " AND menu_isclass=1 ORDER BY menu_pid,menu_id";
			$db_query_nov = $espcms_link_db->db_query($db_sql_nov);
			while ($fetch_row_nov = $espcms_link_db->db_array_list($db_query_nov)) {
				$menu_array_nov_ls = array();
				$db_sql_nov_ls = "SELECT * FROM $db_table_menu WHERE menu_upid=" . $fetch_row_nov['menu_id'] . " AND menu_isclass=1 ORDER BY menu_pid,menu_id";
				$db_query_nov_ls = $espcms_link_db->db_query($db_sql_nov_ls);
				while ($fetch_row_nov_ls = $espcms_link_db->db_array_list($db_query_nov_ls)) {
					$menu_array_nov_ls[] = $fetch_row_nov_ls;
				}
				$fetch_row_nov['nov'] = $menu_array_nov_ls;
				$menu_array_nov[] = $fetch_row_nov;
			}
			$fetch_row['nov'] = $menu_array_nov;
			$menu_array[] = $fetch_row;
		}
		$espcms_admin_templates->into('menu_function', $menu_array);
		$espcms_admin_templates->output('admin/power_groups_add');
	}

	public static function editPowerGroups() {
		global $espcms_admin_templates, $espcms_link_db;
		$admin_member_id = ESPCMS_AdminAuthority::getUserLoginInfo('admin_member_id');
		if (empty($admin_member_id) || !espcms_ismatches($admin_member_id)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($admin_member_id));
		}
		$power_groups_id = $_GET['power_groups_id'];
		if (!$power_groups_id || !espcms_ismatches($power_groups_id)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($power_groups_id));
		}
		$db_table = ESPCMS_DB_PREFIX . "power_groups";
		$db_where = " WHERE power_groups_id=$power_groups_id";
		$talbe_field_array = espcms_field_out($db_table, false);
		$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read) {
			espcms_message_err('db_pack-espcms_db_read_fail', array($db_where));
		}

		$nowMenu_array = $read['power_groups_function'] ? explode(',', $read['power_groups_function']) : array();

		$db_table_menu = ESPCMS_DB_PREFIX . "menulink";
		$db_sql = "SELECT * FROM $db_table_menu WHERE menu_upid=0 AND menu_isclass=1 ORDER BY menu_pid,menu_id";
		$db_query = $espcms_link_db->db_query($db_sql);
		while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
			$menu_array_nov = array();

			$db_sql_nov = "SELECT * FROM $db_table_menu WHERE menu_upid=" . $fetch_row['menu_id'] . " AND menu_isclass=1 ORDER BY menu_pid,menu_id";
			$db_query_nov = $espcms_link_db->db_query($db_sql_nov);
			while ($fetch_row_nov = $espcms_link_db->db_array_list($db_query_nov)) {
				$menu_array_nov_ls = array();
				$db_sql_nov_ls = "SELECT * FROM $db_table_menu WHERE menu_upid=" . $fetch_row_nov['menu_id'] . " AND menu_isclass=1 ORDER BY menu_pid,menu_id";
				$db_query_nov_ls = $espcms_link_db->db_query($db_sql_nov_ls);
				while ($fetch_row_nov_ls = $espcms_link_db->db_array_list($db_query_nov_ls)) {
					$fetch_row_nov_ls['checked'] = in_array($fetch_row_nov_ls['menu_module'], $nowMenu_array) ? 'checked' : 'close';
					$menu_array_nov_ls[] = $fetch_row_nov_ls;
				}
				$fetch_row_nov['checked'] = in_array($fetch_row_nov['menu_classname'], $nowMenu_array) ? 'checked' : 'close';
				$fetch_row_nov['nov'] = $menu_array_nov_ls;
				$menu_array_nov[] = $fetch_row_nov;
			}
			$fetch_row['checked'] = in_array($fetch_row['menu_dirname'], $nowMenu_array) ? 'checked' : 'close';
			$fetch_row['nov'] = $menu_array_nov;
			$menu_array[] = $fetch_row;
		}
		$espcms_admin_templates->into('menu_function', $menu_array);

		$espcms_admin_templates->into('read', $read);
		$espcms_admin_templates->into('token', token());
		$espcms_admin_templates->into('gobaklink', espcms_server_url('HTTP_REFERER'));
		$espcms_admin_templates->into('link', SettingLink::PowerGroups_link_array());
		$espcms_admin_templates->output('admin/power_groups_edit');
	}

	public static function savePowerGroups() {
		global $espcms_db_cache;

		if (!is_token($_POST['token_name'], $_POST['token_key'])) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_repeat_fail', 'false', array($_POST['token_name']));
		}
		$saveType = $_POST['savetype'] ? $_POST['savetype'] : 'add';

		$db_table = ESPCMS_DB_PREFIX . "power_groups";
		$talbe_field_array = espcms_field_out($db_table, true);

		if (is_array($_POST['authority_function']) && count($_POST['authority_function']) > 0) {

			$_POST['authority_function'] = array_unique($_POST['authority_function']);
			$_POST['authority_function'] = unArrayEmpty($_POST['authority_function']);
			$function_array = array();
			foreach ($_POST['authority_function'] as $value) {
				$function_key = strchr($value, '|') ? explode('|', $value) : $value;
				if (is_array($function_key)) {
					$function_array[] = $function_key[0];
					$function_array[] = $function_key[1];
				} else {
					$function_array[] = $function_key;
				}
			}
			$_POST['authority_function'] = array_unique($function_array);

			$_POST['authority_function'] = is_array($_POST['authority_function']) && count($_POST['authority_function']) > 0 ? implode(',', $_POST['authority_function']) : '';
		}
		$_POST['power_groups_function'] = $_POST['authority_function'];
		if (!espcms_ismatches($_POST['power_groups_issystem'])) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($_POST['power_groups_issystem']));
		}
		if ($saveType == 'add') {
			if (!ESPCMS_AdminAuthority::authorityVerify('addPowerGroups')) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
			}

			$_POST['power_groups_addtime'] = time();

			$postvalue = espcms_post($_POST, $talbe_field_array, true);
			if ($postvalue) {
				$install_id = espcms_db_install_save($db_table, $postvalue);
				if (!$install_id) {
					espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
				}
			} else {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}

			$espcms_db_cache->cacheDEL(self::$power_groups_list_cache_key, true);
			espcms_log_install('setting_pack-espcms_power_groups_button_add', $_POST['power_groups_name']);
			espcms_public_dialog('espcms_info_save_ok', 'setting_pack-espcms_power_groups_add_save_ok_message', 'true', array($_POST['power_groups_name']));
		} elseif ($saveType == 'edit') {
			if (!ESPCMS_AdminAuthority::authorityVerify('editPowerGroups')) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
			}
			$power_groups_id = $_POST['power_groups_id'];
			if (empty($power_groups_id) || !espcms_ismatches($power_groups_id)) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($power_groups_id));
			}
			$db_where = "WHERE power_groups_id=$power_groups_id";
			$postvalue = espcms_post($_POST, $talbe_field_array, true);
			if ($postvalue && is_array($postvalue)) {
				$update_id = espcms_db_update_save($db_table, $db_where, $postvalue);

				if (!$update_id) {
					espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
				}
			} else {

				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}

			$espcms_db_cache->cacheDEL(self::$power_groups_read_cache_key . $power_groups_id);

			$espcms_db_cache->cacheDEL(self::$power_groups_list_cache_key, true);

			espcms_log_install('setting_pack-espcms_power_groups_button_edit', $_POST['power_groups_name']);

			espcms_public_dialog('espcms_info_save_ok', 'setting_pack-espcms_power_groups_edit_save_ok_message', 'true', array($_POST['power_groups_name']));
		}
	}

	public static function setPowerGroups() {
		global $espcms_db_cache;
		$select_id = $_POST['select_id'];
		$field = $_POST['field'];
		$field_value = $_POST['field_value'];

		if (!is_array($select_id) || count($select_id) <= 0) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($select_id));
		}

		if (!$field || !espcms_ismatches($field_value)) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_input_parameter_fail', 'false', array($field));
		}

		$db_table = ESPCMS_DB_PREFIX . "power_groups";
		$talbe_field_array = espcms_field_out($db_table, true);
		$isavlue = false;
		foreach ($talbe_field_array as $key => $value) {
			if ($value['Field'] == $field) {
				$isavlue = true;
			}
		}
		if (!$isavlue) {
			espcms_public_dialog('info_set_err', 'db_pack-espcms_db_field_fail', 'false', array($field));
		}

		$update_count = 0;
		foreach ($select_id as $key => $value) {
			if (!espcms_ismatches($value)) {
				continue;
			}
			$update_key = espcms_db_update_set_save($db_table, "WHERE power_groups_id=$value", "$field='$field_value'");
			if ($update_key) {
				$espcms_db_cache->cacheDEL(self::$power_groups_read_cache_key . $value, true);
				$update_count++;
			}
		}
		if ($update_count > 0) {
			$espcms_db_cache->cacheDEL(self::$power_groups_list_cache_key, true);
		}
		$power_groups_id = implode(', ', $select_id);
		espcms_log_install('setting_pack-espcms_power_groups_button_set', "$field=$field_value" . " power_groups_id=" . $power_groups_id);

		espcms_public_dialog('info_set_ok', 'setting_pack-espcms_power_groups_set_message', 'true', array($field));
	}

	public static function delPowerGroups() {
		global $espcms_db_cache;
		$select_id = $_POST['select_id'];

		if (!is_array($select_id) || count($select_id) <= 0) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($select_id));
		}

		$delcount = 0;
		foreach ($select_id as $value) {
			$operate_result = self::delPowerGroupsDB($value);
			if ($operate_result['code'] == 'true') {
				$espcms_db_cache->cacheDEL(self::$power_groups_read_cache_key . $value, true);
				$delcount++;
			}
		}
		if ($delcount > 0) {
			$espcms_db_cache->cacheDEL(self::$power_groups_list_cache_key, true);
		}
		$power_groups_id = implode(', ', $select_id);
		espcms_log_install('setting_pack-espcms_power_groups_button_del', $power_groups_id);

		$return['count'] = $delcount;
		espcms_public_dialog('espcms_public_dialog', 'setting_pack-espcms_power_groups_del_message', 'true', array(), 'json', $return);
	}

	public static function delPowerGroupsDB($power_groups_id = 0) {
		if (!$power_groups_id || !espcms_ismatches($power_groups_id)) {
			$return_array = array('lan' => 'public_pack-espcms_input_parameter_fail', 'code' => 'false', 'key' => $power_groups_id);
			return $return_array;
		}
		$db_table = ESPCMS_DB_PREFIX . "power_groups";
		$talbe_field_array = espcms_field_out($db_table, true);
		$db_where = " WHERE power_groups_isdel=1 AND power_groups_id=$power_groups_id";
		$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read) {
			$return_array = array('lan' => 'public_pack-espcms_input_parameter_fail', 'code' => 'false', 'key' => $power_groups_id);
			return $return_array;
		}
		$del_query = espcms_db_del($db_table, 'power_groups_id', $power_groups_id);
		if ($del_query) {
			$return_array = array('lan' => 'public_pack-espcms_del_ok', 'code' => 'true', 'key' => $power_groups_id);
			return $return_array;
		} else {
			$return_array = array('lan' => 'public_pack-espcms_del_err', 'code' => 'false', 'key' => $power_groups_id);
			return $return_array;
		}
	}

}
