<?php

/*
  PHP version 5
  Copyright (c) 2002-2018 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030
  ESPCMS官网介绍：http://www.ecisp.cn	企业建站：http://www.earclink.cn

 */
namespace modul_application;
use application\ESPCMS_Change;
use inc_application\link\ArticleLink;
class ESPCMS_ArticleTypeDB {
    public static function get_article_type_array($tid = false) {
        if (!$tid || !preg_match("/^[\d]+[\d,]*$/i", $tid)) {
            return false;
        }
        $db_where = $tid && espcms_ismatches($tid) ? "AND tid=$tid" : "AND tid IN ($tid)";
        $db_table = ESPCMS_DB_PREFIX . 'document_typelist';
        $talbe_field_array = espcms_field_out($db_table, false);
        $array = espcms_db_list_array($db_table, $talbe_field_array, $db_where, 'tid');
        if (!is_array($array) || count($array) < 1) {
            return array();
        }
        return $array;
    }
    public static function get_article_type_view($tid = 0, $return_key = false) {
        global $espcms_db_cache;
        if (!$tid || !espcms_ismatches($tid)) {
            return false;
        }
        $db_where = "WHERE tid=$tid";
        $db_table = ESPCMS_DB_PREFIX . 'document_typelist';
        $cache_key = ESPCMS_CACHE_DBREAD_NAME . $db_table . '_' . $tid;
        $read_info = $espcms_db_cache->cacheCheck($cache_key, false);
        if (!$read_info) {
            $talbe_field_array = espcms_field_out($db_table, false);
            $read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
            if (!$read_info) {
                return false;
            }
            $espcms_db_cache->cacheSave($cache_key, $read_info);
        }
        $read_info['content'] = $read_info['content'] ? htmlspecialchars_decode($read_info['content']) : '';
        return !$return_key ? $read_info : $read_info[$return_key];
    }
    public static function get_article_type_list($tid = 0, $upid = 0, $mid = 0, $lng = false, $islink = false, $isbase = false, $istree = false, $iswap = false) {
        global $espcms_db_cache;
        $db_table = ESPCMS_DB_PREFIX . 'document_typelist';
        $cache_key = ESPCMS_CACHE_DBLIST_NAME . $db_table . '_' . $lng . '_' . $mid . '_' . $upid . '_' . $isbase . '_' . $iswap;
        $article_type_array = $espcms_db_cache->cacheCheck($cache_key, false);
        if (!$article_type_array) {
            $article_type_array = self::get_article_type_listDB($upid, $lng, $mid, 0, 0, $isbase, $iswap);
            $espcms_db_cache->cacheSave($cache_key, $article_type_array);
        }
        if (!is_array($article_type_array) || !$article_type_array) {
            return false;
        }
        $article_type_new_array = array();
        foreach ($article_type_array as $key => $value) {
            if ((!$value['isclass']) || ($islink && $value['styleid'] == 3)) {
                $un_id = $value['pathid'] . '-';
                continue;
            }
            $type_goto_read = $value['gotoid'] && espcms_ismatches($value['gotoid']) ? self::get_article_type_view($value['gotoid']) : $value;
            $article_type_array[$key]['link'] = ArticleLink::type_link($type_goto_read);
            $article_type_array[$key]['selected'] = ($tid == $value['tid']) ? 'selected' : '';
            $article_type_array[$key]['content'] = $value['content'] ? htmlspecialchars_decode($value['content']) : '';
            $unkey = $un_id ? stripos($value['pathid'], $un_id, 0) : 1;
            if ($unkey === 0) {
                continue;
            }
            $article_type_new_array[] = $article_type_array[$key];
        }
        if ($istree) {
            $array = ESPCMS_Change::getTree($article_type_new_array, 'tid', 'upid', 'childArray', $upid);
        } else {
            $array = $article_type_new_array;
        }
        return $array;
    }
    public static function get_article_type_listDB($in_tid = 0, $lng = 'cn', $mid = 0, $tid = 0, $level = 0, $isbase = false, $iswap = false) {
        global $espcms_link_db;
        $db_table = ESPCMS_DB_PREFIX . 'document_typelist';
        $db_where = " AND c.isclass=1";
        if ($mid && espcms_ismatches($mid)) {
            $db_where .= " AND c.mid=$mid";
        }
        if ($isbase) {
            $db_where .= " AND c.styleid<3";
        }
        if (!$in_tid || !espcms_ismatches($in_tid)) {
            $db_where .= " AND c.lng='$lng'";
        }
        if ($iswap) {
            $db_where .= " AND c.iswap=$iswap";
        }
        $db_sql = "SELECT c.lng,c.tid,c.pid,c.mid,c.topid,c.upid,c.linkid,c.gotoid,c.styleid,c.purview,c.ismenu,c.isaccessory,c.ispart,c.pageclass,c.isclass,c.isline,c.typeurl,c.gotoline,c.pagemax,c.iswap,c.typename,c.content,c.typepic,c.dirname,c.filenamestyle,COUNT(a.tid) AS has_c FROM $db_table AS c LEFT JOIN $db_table AS a ON a.upid = c.tid WHERE 1=1 $db_where GROUP BY c.tid ORDER BY c.upid,c.pid,c.tid";
        $db_query = $espcms_link_db->db_query($db_sql);
        while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
            $array[] = $fetch_row;
        }
        if ($tid > 0) {
            foreach ($array as $key => $value) {
                $array[$key]['selected'] = ($tid == $value['tid']) ? 'selected' : '';
            }
        }
        $out_category_array = ESPCMS_Change::has_category($in_tid, $array, 'tid', 'upid');
        if (is_array($out_category_array)) {
            foreach ($out_category_array as $key => $value) {
                $out_category_array[$key]['classname'] = 'opt_three_' . $value['level'];
                $out_category_array[$key]['icon'] = $value['has_c'] > 0 ? 'espcms_icon_fa espcms_icon_fa-chevron-circle-down text-orange' : 'espcms_icon_fa espcms_icon_fa-chevron-circle-right text-danfei';
            }
        }
        if ($level > 0) {
            if ($in_tid == 0) {
                $end_level = $level;
            } else {
                $first_item = reset($out_category_array);
                $end_level = $first_item['level'] + $level;
            }
            foreach ($out_category_array as $key => $val) {
                if ($val['level'] >= $end_level) {
                    unset($out_category_array[$key]);
                }
            }
        }
        return $out_category_array;
    }
    public static function get_document_subjectlist_list($lng = false, $sid = 0, $mid = 0) {
        global $espcms_db_cache;
        if (!$lng || !preg_match("/^[a-z0-9]{2,50}$/i", $lng)) {
            return false;
        }
        $db_where .= " AND isclass=1 AND lng='$lng'";
        if ($mid && espcms_ismatches($mid)) {
            $db_where .= " AND mid=$mid";
        }
        $db_table = ESPCMS_DB_PREFIX . 'document_subjectlist';
        $cache_key = ESPCMS_CACHE_DBLIST_NAME . $db_table . '_' . $lng . '_' . $mid . '_1';
        $array = $espcms_db_cache->cacheCheck($cache_key, false);
        if (!$array) {
            $talbe_field_array = espcms_field_out($db_table, false);
            $array = espcms_db_list_array($db_table, $talbe_field_array, $db_where, "pid,sid DESC");
            if (!is_array($array) || count($array) < 1) {
                return array();
            }
            $espcms_db_cache->cacheSave($cache_key, $array);
        }
        if (is_array($array) && count($array) > 0) {
            foreach ($array as $key => $value) {
                $array[$key]['link'] = ArticleLink::subtype_link($value);
                $array[$key]['selected'] = ($sid == $value['sid']) ? 'selected' : '';
            }
        }
        return $array;
    }
    public static function get_article_subjectlist_view($sid = 0, $return_key = false) {
        global $espcms_db_cache;
        if (!$sid || !espcms_ismatches($sid)) {
            return false;
        }
        $db_where = "WHERE sid=$sid";
        $db_table = ESPCMS_DB_PREFIX . 'document_subjectlist';
        $cache_key = ESPCMS_CACHE_DBREAD_NAME . $db_table . '_' . $sid;
        $read_info = $espcms_db_cache->cacheCheck($cache_key, false);
        if (!$read_info) {
            $talbe_field_array = espcms_field_out($db_table, false);
            $read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
            if (!$read_info) {
                return false;
            }
            $espcms_db_cache->cacheSave($cache_key, $read_info);
        }
        return !$return_key ? $read_info : $read_info[$return_key];
    }
    public static function get_type_topout($tid = 0, $type_array = false) {
        if (!$tid || !espcms_ismatches($tid)) {
            return false;
        }
        $type_read = self::get_article_type_view($tid);
        if (!$type_read) {
            return false;
        }
        $type_read['title'] = $type_read['typename'];
        $type_goto_read = $type_read['gotoid'] && espcms_ismatches($type_read['gotoid']) ? ESPCMS_ArticleTypeDB::get_article_type_view($type_read['gotoid']) : $type_read;
        $type_read['link'] = ArticleLink::type_link($type_goto_read);
        $type_array[] = $type_read;
        if ($type_read['upid']) {
            return self::get_type_topout($type_read['upid'], $type_array);
        } else {
            return $type_array;
        }
    }
    public static function get_type_menu_hover($tid = 0) {
        static $hover_tid = false;
        if (!$tid || !espcms_ismatches($tid)) {
            return false;
        }
        $type_read = self::get_article_type_view($tid);
        if (!$type_read) {
            return false;
        }
        if ($type_read['ismenu']) {
            $hover_tid = $type_read['tid'];
        } else {
            if ($type_read['upid']) {
                self::get_type_menu_hover($type_read['upid']);
            }
        }
        return $hover_tid;
    }
}
