<?php

/*
  PHP version 5
  Copyright (c) 2002-2019ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/


namespace modul_application;

use modul_application\ESPCMS_MemberDB;
use modul_application\ESPCMS_TemplateDB;
use application\ESPCMS_PublicDB;
use application\ESPCMS_Core;
use application\phpmailer;

class ESPCMS_SendMessage {

	public static function send_email_message($templates_code, $key, $user_id, $member_read = true) {
		global $espcms_command;
		if (!$user_id || !preg_match("/^[\d,]+$/i", $user_id) || !$templates_code || !is_array($key)) {
			return false;
		}
		if (!$espcms_command['EMAIL_ISOPEN']) {
			return false;
		}
		$templates_read = ESPCMS_TemplateDB::get_templates_code_view($templates_code);
		if (!$templates_read || !$templates_read['isclass'] || !$templates_read['title'] || !$templates_read['templatecontent']) {
			return false;
		}
		if (espcms_ismatches($user_id)) {
			if ($member_read) {
				$user_read = ESPCMS_MemberDB::get_member_noatt_view($user_id);
				if (!$user_read) {
					return false;
				}
				$find_key = array_merge($user_read, $key);
			} else {
				$find_key = $key;
			}
			$message_title = self::templates_format_dbkey_array($templates_read['title'], $find_key);
			$message_mail_content = self::templates_format_dbkey_array($templates_read['templatecontent'], $find_key);
			self::mailsend($message_title, $message_mail_content, $find_key['email']);
			return true;
		} elseif (preg_match("/^[\d,]+$/i", $user_id)) {
			$accept_user_id_array = explode(',', $user_id);
			foreach ($accept_user_id_array as $value) {
				$user_read = ESPCMS_MemberDB::get_member_noatt_view($value);
				$find_key = array_merge($user_read, $key);
				$message_title = self::templates_format_dbkey_array($templates_read['title'], $find_key);
				$message_mail_content = self::templates_format_dbkey_array($templates_read['templatecontent'], $find_key);
				self::mailsend($message_title, $message_mail_content, $user_read['email']);
			}
			return true;
		} else {
			return false;
		}
	}

	public static function send_sms_message($templates_code, $key, $user_id, $member_read = true) {
		global $espcms_command;
		if (!$espcms_command['SMS_ISOPEN']) {
			return false;
		}
		if (!$user_id || !preg_match("/^[\d,]+$/i", $user_id) || !$templates_code || !is_array($key)) {
			return false;
		}
		$templates_read = ESPCMS_TemplateDB::get_templates_code_view($templates_code, 'sms');
		if (!$templates_read || !$templates_read['isclass'] || !$templates_read['templatecontent']) {
			return false;
		}
		if (espcms_ismatches($user_id)) {
			if ($member_read) {
				$user_read = ESPCMS_MemberDB::get_member_noatt_view($user_id);
				if (!$user_read) {
					return false;
				}
				$find_key = array_merge($user_read, $key);
			} else {
				$find_key = $key;
			}
			if (!preg_match("/^1[0-9]{10}$/i", $find_key['mobile'])) {
				return false;
			}
			$message_content = self::templates_format_dbkey_array($templates_read['templatecontent'], $find_key);
			self::smssend($message_content, $find_key['mobile']);
			return true;
		} elseif (preg_match("/^[\d,]+$/i", $user_id)) {
			$accept_user_id_array = explode(',', $user_id);
			foreach ($accept_user_id_array as $value) {
				$user_read = ESPCMS_MemberDB::get_member_noatt_view($value);
				if (!preg_match("/^1[0-9]{10}$/i", $user_read['mobile'])) {
					continue;
				}
				$find_key = array_merge($user_read, $key);
				$message_content = self::templates_format_dbkey_array($templates_read['templatecontent'], $find_key);
				self::smssend($message_content, $find_key['mobile']);
			}
			return true;
		} else {
			return false;
		}
	}

	public static function send_moblie_sms_message($templates_code, $moblie = 0, $key = array()) {
		global $espcms_command;
		if (!$espcms_command['SMS_ISOPEN'] || !is_array($key)) {
			return false;
		}
		if (!preg_match("/^1[0-9]{10}$/i", $moblie)) {
			return false;
		}
		$templates_read = ESPCMS_TemplateDB::get_templates_code_view($templates_code, 'sms');
		if (!$templates_read || !$templates_read['isclass'] || !$templates_read['templatecontent']) {
			return false;
		}
		$message_content = self::templates_format_dbkey_array($templates_read['templatecontent'], $key);
		self::smssend($message_content, $moblie);
		return true;
	}

	public static function send_email_key_message($templates_code, $email, $key = array()) {
		global $espcms_command;
		if (!$espcms_command['EMAIL_ISOPEN'] || !is_array($key)) {
			return false;
		}
		if (!preg_match("/^\w+((-\w+)|(\.\w+))*\@[A-Za-z0-9]+((\.|-)[A-Za-z0-9]+)*\.[A-Za-z0-9]+$/i", $email)) {
			return false;
		}
		$templates_read = ESPCMS_TemplateDB::get_templates_code_view($templates_code);
		if (!$templates_read || !$templates_read['isclass'] || !$templates_read['title'] || !$templates_read['templatecontent']) {
			return false;
		}
		$message_title = self::templates_format_dbkey_array($templates_read['title'], $key);
		$message_mail_content = self::templates_format_dbkey_array($templates_read['templatecontent'], $key);
		self::mailsend($message_title, $message_mail_content, $email);
		return true;
	}

	public static function send_demo_mail($send_val = array()) {
		if (!is_array($send_val)) {
			return false;
		}
		$mail_content = espcms_lan_pack('setting_pack-espcms_setting_send_demo_mail_content');
		ESPCMS_SendMessage::mailsend($mail_content, $mail_content, $send_val['EMAIL_SEND_MAIL'], $send_val);
		return true;
	}

	private static function templates_format_dbkey_array($replace_str, $find_key = array()) {
		global $espcms_command;
		if (!$replace_str || !$find_key || !is_array($find_key)) {
			return false;
		}
		$find_key['nowtime'] = espcms_timeformat(time(), 3);
		$find_key['nowdate'] = espcms_timeformat(time(), 2);
		$find_key['domain'] = ESPCMS_URL;
		$find_key['admine_mail'] = $espcms_command['ADMINE_MAIL'];
		$key_array = ESPCMS_PublicDB::get_templates_key(false, $find_key);
		foreach ($key_array as $key => $value) {
			foreach ($value as $i => $read) {
				$replace_str = str_replace($read['title'], $read['content'], $replace_str);
			}
		}
		return $replace_str;
	}

	private static function mailsend($subject, $bodycontent, $email, $send_val = array()) {
		global $espcms_command;
		if (empty($subject) || empty($email) || empty($bodycontent)) {
			return false;
		}
		if ($send_val['EMAIL_SEND_TYPE']) {
			$espcms_command['EMAIL_SEND_TYPE'] = $send_val['EMAIL_SEND_TYPE'];
		}
		if ($send_val['EMAIL_SEND_MAIL']) {
			$espcms_command['EMAIL_SEND_MAIL'] = $send_val['EMAIL_SEND_MAIL'];
		}
		if ($send_val['COMPANY_NAME']) {
			$espcms_command['COMPANY_NAME'] = $send_val['COMPANY_NAME'];
		}
		if ($send_val['EMAIL_USERNAME']) {
			$espcms_command['EMAIL_USERNAME'] = $send_val['EMAIL_USERNAME'];
		}
		if ($send_val['EMAIL_PASSWORD']) {
			$espcms_command['EMAIL_PASSWORD'] = $send_val['EMAIL_PASSWORD'];
		}
		if (!preg_match("/^\w+((-\w+)|(\.\w+))*\@[A-Za-z0-9]+((\.|-)[A-Za-z0-9]+)*\.[A-Za-z0-9]+$/i", $email)) {
			return false;
		}
		if ($espcms_command['EMAIL_SEND_TYPE'] == 1) {
			$mail = new PHPMailer();
			$mail->From = $espcms_command['EMAIL_SEND_MAIL'];
			$mail->FromName = $espcms_command['COMPANY_NAME'];
			$mail->Username = $espcms_command['EMAIL_USERNAME'];
			$mail->Password = $espcms_command['EMAIL_PASSWORD'];
			$mail->Host = $espcms_command['EMAIL_SMTP_HTTP'];
			$mail->CharSet = "UTF-8";
			$mail->SMTPAuth = true;
			$mail->Mailer = "mail";
			$mail->Port = $espcms_command['EMAIL_SMTP_PORT'];
			if ($espcms_command['EMAIL_SMTP_PORT'] == 465) {
				$mail->SMTPSecure = "ssl";
			}
			$mail->Subject = $subject;
			$mail->MsgHTML($bodycontent);
			$mail->AddAddress($email);
			if (!@$mail->Send()) {
				return false;
			} else {
				return true;
			}
		} elseif ($espcms_command['EMAIL_SEND_TYPE'] == 2) {
			$mail = new phpmailer\PHPMailer();
			$mail->From = $espcms_command['EMAIL_SEND_MAIL'];
			$mail->FromName = $espcms_command['COMPANY_NAME'];
			$mail->Username = $espcms_command['EMAIL_USERNAME'];
			$mail->Password = $espcms_command['EMAIL_PASSWORD'];
			$mail->Host = $espcms_command['EMAIL_SMTP_HTTP'];
			$mail->CharSet = "UTF-8";
			$mail->SMTPAuth = true;
			$mail->Mailer = "smtp";
			$mail->Port = $espcms_command['EMAIL_SMTP_PORT'];
			if ($espcms_command['EMAIL_SMTP_PORT'] == 465) {
				$mail->SMTPSecure = "ssl";
			}
			$mail->Subject = $subject;
			$mail->MsgHTML($bodycontent);
			$mail->AddAddress($email);
			if (!@$mail->Send()) {
				return false;
			} else {
				return true;
			}
		} elseif ($espcms_command['EMAIL_SEND_TYPE'] == 3) {
			$mail = new phpmailer\PHPMailer();
			$mail->From = $espcms_command['EMAIL_SEND_MAIL'];
			$mail->FromName = $espcms_command['COMPANY_NAME'];
			$mail->Username = $espcms_command['EMAIL_USERNAME'];
			$mail->Password = $espcms_command['EMAIL_PASSWORD'];
			$mail->Host = $espcms_command['EMAIL_SMTP_HTTP'];
			$mail->CharSet = "UTF-8";
			$mail->SMTPAuth = true;
			$mail->Mailer = "sendmail";
			$mail->Port = $espcms_command['EMAIL_SMTP_PORT'];
			if ($espcms_command['EMAIL_SMTP_PORT'] == 465) {
				$mail->SMTPSecure = "ssl";
			}
			$mail->Subject = $subject;
			$mail->MsgHTML($bodycontent);
			$mail->AddAddress($email);
			if (!@$mail->Send()) {
				return false;
			} else {
				return true;
			}
		}
	}

	public static function smssend($smsContent = null, $toMoblie = 0, $isSendtype = 0) {
		global $espcms_command;
		$smsContent = trim(strip_tags($smsContent));
		if (empty($smsContent) || empty($toMoblie)) {
			return false;
		}
		if (!preg_match("/^1[0-9]{10}$/i", $toMoblie)) {
			return false;
		}
		$userid = $espcms_command['SMS_USER_ID'];
		$smssnid = $espcms_command['SMS_MESSAGE_ID'];
		$smskey = $espcms_command['SMS_KEY'];
		$moblienumber = $espcms_command['SMS_MOBLIE_NB'];
		$ipadd = real_remote_ip(true);
		if (!espcms_ismatches($userid) || !espcms_ismatches($smssnid) || empty($smskey) || empty($ipadd)) {
			return false;
		}
		$post['userid'] = $userid;
		$post['smssnid'] = $smssnid;
		$post['smskey'] = $smskey;
		$post['ip'] = $ipadd;
		$post['smsmoblie'] = $moblienumber;
		$post['sendmoblie'] = $toMoblie;
		$post['smscontent'] = $smsContent;
		$service_status = ESPCMS_Core::connect_service('MoblieSend', $post);
		if ($service_status && $service_status['code'] == 1) {
			return true;
		} else {
			return false;
		}
	}

}
