<?php
/*
  PHP version 5
  Copyright (c) 2002-2020 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/

namespace application;
class ESPCMS_PageButton {
    public $page_maxhit = 5;
    private $pagination_start;
    private $pagination_end;
    private $db_num;
    private $db_sql;
    private $page_list_num;
    private $page_num;
    private $page_id;
    private $page_style;
    private $page_start_id;
    private $page_prev_id;
    private $page_next_id;
    private $page_botton_name;
    private $link_class;
    private $link_fun;
    private $link_array;

    public function __construct($db_sql = false, $db_num = 0, $page_list_num = 0, $page_id = 1, $page_style = 1, $botton_lanpack = '首页/上一页/下一页/尾页', $link_class = false, $link_fun = false, $link_array = array()) {
        $this->db_num = $db_num;
        $this->db_sql = $db_sql;
        $this->page_list_num = $page_list_num;
        $this->page_num = $db_num && $page_list_num ? ceil($db_num / $page_list_num) : 1;
        $this->page_id = $page_id;
        $this->page_style = $page_style;
        $this->page_start_id = 1;
        $this->page_prev_id = $this->page_id - 1;
        $this->page_next_id = $this->page_id + 1;
        $this->page_botton_name = explode('/', $botton_lanpack);
        $this->link_class = $link_class;
        $this->link_fun = $link_fun;
        $this->link_array = $link_array;
    }

    public function sql_creat($order_key = false, $order_rank = 'DESC') {
        if (!$order_key) {
            return false;
        }
        if ($this->page_id <= 0) {
            $this->page_id = 1;
        } elseif ($this->page_id > $this->page_num) {
            $this->page_id = $this->page_num;
        }
        if ($this->page_id == 1) {
            $limit = 0;
        } else {
            $limit = $this->page_list_num * ($this->page_id - 1);
        }
        $db_limit = "LIMIT $limit," . $this->page_list_num;
        $db_sql = $this->db_sql . ' ORDER BY ' . $order_key . ' ' . $order_rank . ' ' . $db_limit;
        return $db_sql;
    }

    public function page_botton_creat() {
        $link_class = $this->link_class;
        $link_fun = $this->link_fun;
        if ($this->page_id > 1) {
            $home_link = $link_class::$link_fun($this->link_array, 1);
            $prev_link = $link_class::$link_fun($this->link_array, $this->page_prev_id);
            $this->pagination_start = '<div class="btn-group" role="group" id="page_left_botton"><a class="btn btn-default"  title="' . $this->page_botton_name[0] . '" href="' . $home_link . '">' . $this->page_botton_name[0] . '</a>'
                . '<a class="btn btn-default" title="' . $this->page_botton_name[1] . '" href="' . $prev_link . '">' . $this->page_botton_name[1] . '</a></div> ';
        } else {
            $this->pagination_start = '<div class="btn-group" role="group" id="page_left_botton"><span class="btn btn-default  active">' . $this->page_botton_name[0] . '</span><span class="btn btn-default  active">' . $this->page_botton_name[1] . '</span></div> ';
        }
        if ($this->page_id < $this->page_num) {
            $end_link = $link_class::$link_fun($this->link_array, $this->page_num);
            $next_link = $link_class::$link_fun($this->link_array, $this->page_next_id);
            $this->pagination_end = ' <div class="btn-group" role="group" id="page_left_botton"> <a class="btn btn-default" title="' . $this->page_botton_name[2] . '" href="' . $next_link . '">' . $this->page_botton_name[2] . '</a>'
                . '<a class="btn btn-default" title="' . $this->page_botton_name[3] . '" href="' . $end_link . '">' . $this->page_botton_name[3] . '</a></div>';
        } else {
            $this->pagination_end = ' <div class="btn-group" role="group" id="page_left_botton"><span class="btn btn-default  active">' . $this->page_botton_name[2] . '</span><span class="btn btn-default  active">' . $this->page_botton_name[3] . '</span></div>';
        }
        if ($this->page_style == 2) {
            $page_botton = $this->pagination_start . $this->pagination_end;
        } else {
            $page_botton = $this->pagination_start . $this->page_number_botton_creat() . $this->pagination_end;
        }
        return $page_botton;
    }

    public function page_number_botton_creat() {
        $link_class = $this->link_class;
        $link_fun = $this->link_fun;
        $for_end = $this->page_num > ($this->page_id + $this->page_maxhit) ? ($this->page_id + $this->page_maxhit) : $this->page_num;
        $for_begin = ($this->page_id - $this->page_maxhit) > 1 ? $this->page_id - $this->page_maxhit : 1;
        $page_number_botton = '<div class="btn-group" role="group" id="page_center_botton">';
        for ($i = $for_begin; $i <= $for_end; $i++) {
            if ($i == $this->page_id) {
                $page_number_botton .= "<span class=\"btn btn-default active\">$i</span>";
            } else {
                $link = $link_class::$link_fun($this->link_array, $i);
                $page_number_botton .= "<a class=\"btn btn-default\" title=\"" . $i . "\" href=\"" . $link . "\">$i</a>";
            }
        }
        if ($this->page_num != $this->page_id && ($this->page_num - 5) > $this->page_id) {
            $link = $link_class::$link_fun($this->link_array, $this->page_num);
            $page_number_botton .= "<a class=\"btn btn-default\" href=\"\">...</a><a class=\"btn btn-default\" title=\"" . $this->page_num . "\" href=\"" . $link . "\">$this->page_num</a>";
        }
        $page_number_botton .= '</div>';
        return $page_number_botton;
    }

    public function page_argument_out() {
        $page_arg = array();
        $page_arg['page_id'] = $this->page_id;
        $page_arg['db_num'] = $this->db_num;
        $page_arg['page_num'] = $this->page_num;
        $page_arg['page_list_num'] = $this->page_list_num;
        return $page_arg;
    }
}
