<?php

/*
  PHP version 5
  Copyright (c) 2002-2018 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030
  ESPCMS官网介绍：http://www.ecisp.cn	企业建站：http://www.earclink.cn

 */

use application\ESPCMS_Core;
use application\ESPCMS_PageButton;
use modul_application\ESPCMS_Dialog;
use modul_application\ESPCMS_MemberDB;
use modul_application\ESPCMS_MemberAuthority;
use modul_application\ESPCMS_EnquiryDB;
use inc_application\link\MemberLink;
use inc_application\link\EnquiryLink;
use inc_application\link\ArticleLink;

class EnquiryMain {

    private static $member_cookie_read;
    private static $member_con;
    private static $enquiry_con;

    public function __construct() {
        $member_app_config = ESPCMS_Core::get_app_config('member', false);
        if (!$member_app_config['isetup'] || !$member_app_config['isopen']) {
            ESPCMS_Dialog::Message_Page('app_close');
        }
        ESPCMS_MemberAuthority::authorityWebVerify(false, $member_app_config['appconfig']);
        static::$member_con = unserialize($member_app_config['appconfig']);

        $member_cookie_info = ESPCMS_MemberAuthority::getMemberInfo();
        static::$member_cookie_read = ESPCMS_MemberDB::get_member_view($member_cookie_info['userid']);
        if (!static::$member_cookie_read) {
            ESPCMS_Dialog::Message_Page('member_read_err', MemberLink::get_link('quit'));
        }
        $enquiry_app_config = ESPCMS_Core::get_app_config('enquiry', false);
        if (!$enquiry_app_config['isetup'] || !$enquiry_app_config['isopen']) {
            ESPCMS_Dialog::Message_Page('app_close');
        }
        static::$enquiry_con = unserialize($enquiry_app_config['appconfig']);
    }


    public static function in_List() {
        global $espcms_web_templates, $espcms_link_db;
        $db_table = ESPCMS_DB_PREFIX . 'enquiry';

        $pageid = $_GET['pageid'] && espcms_ismatches($_GET['pageid']) ? $_GET['pageid'] : 1;
        $per_page_num = 20;

        $userid = static::$member_cookie_read['userid'];
        if (!espcms_ismatches($userid) || !$userid) {
            ESPCMS_Dialog::Message_Page('db_err', MemberLink::get_link('center'));
        }

        $db_where = " AND userid=$userid";

        $db_num = espcms_db_num($db_table, $db_where);

        $db_sql = espcms_db_list_out($db_table, $db_where);

        $lanpack = $espcms_web_templates->geto('lngpack');
        $page_style = defined('ESPCMS_WEB_TYPE') && ESPCMS_WEB_TYPE == 'WAP' ? 2 : 1;

        $espcms_page_button = new ESPCMS_PageButton($db_sql, $db_num, $per_page_num, $pageid, $page_style, $lanpack['pagebotton'], 'inc_application\link\EnquiryLink', 'enquiry_member_link', array());

        $sql = $espcms_page_button->sql_creat('eid', 'DESC');
        $db_query = $espcms_link_db->db_query($sql);
        while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
            $fetch_row['edit'] = EnquiryLink::get_enquiry_link('edit', $fetch_row);
            $fetch_row['view'] = EnquiryLink::get_enquiry_link('view', $fetch_row);
            $array[] = $fetch_row;
        }
        $lanpack['sitename'] = $lanpack['title_member_name'] . '-' . $lanpack['sitename'];
        $espcms_web_templates->into('lngpack', $lanpack);
        $espcms_web_templates->into('array', $array);
        $espcms_web_templates->into('path', 'member');
        $espcms_web_templates->into('mlink', MemberLink::get_link());
        $espcms_web_templates->into('page_read', $espcms_page_button->page_argument_out());
        $espcms_web_templates->into('pagebotton', $espcms_page_button->page_botton_creat());
        $espcms_web_templates->output('member/member_enquiry_list', 'member_enquiry_list', false, false);
    }


    public static function in_View() {
        global $espcms_web_templates;
        $eid = $_GET['eid'];
        if (!$eid || !espcms_ismatches($eid)) {
            ESPCMS_Dialog::Message_Page('db_err', EnquiryLink::enquiry_member_link());
        }
        $read = ESPCMS_EnquiryDB::get_enquiry_view($eid);
        if (!$read || $read['userid'] != static::$member_cookie_read['userid']) {
            ESPCMS_Dialog::Message_Page('enquiry_read_err', EnquiryLink::enquiry_member_link());
        }

        if ($_GET['type'] == 'edit' && $read['isreply']) {
            ESPCMS_Dialog::Message_Page('enquiry_lock_edit_err', EnquiryLink::enquiry_member_link());
        }
        $product_array = ESPCMS_EnquiryDB::get_enquiry_info_list($eid);
        if ($product_array && is_array($product_array)) {
            foreach ($product_array as $key => $value) {
                $product_array[$key]['link'] = ArticleLink::doc_link($value);
            }
        }
        $espcms_web_templates->into('enquiry_link', EnquiryLink::get_enquiry_link(false, $read));
        $espcms_web_templates->into('product_array', $product_array);
        $espcms_web_templates->into('read', $read);
        $espcms_web_templates->into('member_con', static::$member_con);
        $espcms_web_templates->into('tokenkey', token('enquiry_edit'));
        $espcms_web_templates->into('path', 'member');
        $filename = $_GET['type'] == 'edit' ? 'member_enquiry_edit' : 'member_enquiry_view';
        $espcms_web_templates->output('member/' . $filename, $filename, false, false);
    }


    public static function in_EditSave() {

        if (!is_token($_POST['tokenname'], $_POST['tokenkey'])) {
            ESPCMS_Dialog::Message_Page('repeat_inut', MemberLink::get_link('center'));
        }
        $eid = $_POST['eid'];
        if (!$eid || !espcms_ismatches($eid)) {
            ESPCMS_Dialog::Message_Page('db_err');
        }
        $read = ESPCMS_EnquiryDB::get_enquiry_view($eid);
        if (!$read || $read['userid'] != static::$member_cookie_read['userid']) {
            ESPCMS_Dialog::Message_Page('enquiry_read_err');
        }
        if ($read['isreply']) {
            ESPCMS_Dialog::Message_Page('enquiry_lock_edit_err');
        }
        $_POST['linkman'] = $_POST['linkman'] ? htmlspecialchars($_POST['linkman']) : '';
        $_POST['country'] = $_POST['country'] ? htmlspecialchars($_POST['country']) : '';
        $_POST['province'] = $_POST['province'] ? htmlspecialchars($_POST['province']) : '';
        $_POST['city'] = $_POST['city'] ? htmlspecialchars($_POST['city']) : '';
        $_POST['address'] = $_POST['address'] ? htmlspecialchars($_POST['address']) : '';
        $_POST['zipcode'] = $_POST['zipcode'] ? htmlspecialchars($_POST['zipcode']) : '';
        $_POST['tel'] = $_POST['tel'] ? htmlspecialchars($_POST['tel']) : '';
        $_POST['fax'] = $_POST['fax'] ? htmlspecialchars($_POST['fax']) : '';
        $_POST['mobile'] = $_POST['mobile'] ? htmlspecialchars($_POST['mobile']) : '';
        $_POST['email'] = $_POST['email'] ? htmlspecialchars($_POST['email']) : '';
        $_POST['content'] = $_POST['content'] ? htmlspecialchars($_POST['content']) : '';

        unset($_POST['eid'], $_POST['enquirysn'], $_POST['userid'], $_POST['isclass'], $_POST['isreply'], $_POST['addtime'], $_POST['edittime'], $_POST['editresult']);
        $db_where = "WHERE eid=$eid AND userid=" . static::$member_cookie_read['userid'];
        $db_table = ESPCMS_DB_PREFIX . "enquiry";
        $talbe_field_array = espcms_field_out($db_table, true);
        $postvalue = espcms_post($_POST, $talbe_field_array, true);
        if (!$postvalue || !is_array($postvalue)) {
            ESPCMS_Dialog::Message_Page('dba_read_err', MemberLink::get_link('edit_info'));
        }
        $update_id = espcms_db_update_save($db_table, $db_where, $postvalue);
        if (!$update_id) {
            ESPCMS_Dialog::Message_Page('save_err', EnquiryLink::enquiry_member_link());
        }
        ESPCMS_Dialog::Message_Page('enquiry_edit_ok', EnquiryLink::enquiry_member_link());
    }

}
