<?php

/*
  PHP version 5
  Copyright (c) 2002-2019ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/

use application\ESPCMS_Core;
use application\ESPCMS_PageButton;
use modul_application\ESPCMS_Dialog;
use modul_application\ESPCMS_ForumDB;
use modul_application\ESPCMS_MemberDB;
use modul_application\ESPCMS_SendMessage;
use modul_application\ESPCMS_MemberAuthority;
use inc_application\link\ForumLink;

class Forum {

    public static function in_List() {
        global $espcms_web_templates, $espcms_link_db;
        $bbsemanage_app_config = ESPCMS_Core::get_app_config('bbsemanage', false);
        if (!$bbsemanage_app_config['isetup'] || !$bbsemanage_app_config['isopen']) {
            ESPCMS_Dialog::Message_Page('app_close');
        }
        $db_table = ESPCMS_DB_PREFIX . 'bbs';
        $btid = $_GET['btid'];
        if (empty($btid) || !espcms_ismatches($btid)) {
            ESPCMS_Dialog::Message_Page('db_err');
        }

        $type_read = ESPCMS_ForumDB::get_bbs_typelist_view($btid);
        if (!$type_read || !$type_read['isclass']) {
            ESPCMS_Dialog::Message_Page('type_read_err');
        }
        $type_read['link'] = ForumLink::type_link($type_read);

        $member_app_config = ESPCMS_Core::get_app_config('member', false);
        if ($type_read['view_purview'] && $member_app_config['isetup'] && $member_app_config['isopen']) {
            ESPCMS_MemberAuthority::authorityRandVerify($type_read['view_purview']);
        }

        $pageid = $_GET['pageid'] && espcms_ismatches($_GET['pageid']) ? $_GET['pageid'] : 1;

        if ($type_read['pagemax'] && espcms_ismatches($type_read['pagemax'])) {
            $per_page_num = $type_read['pagemax'];
        } else {
            $per_page_num = 20;
        }

        $template_list = $type_read['istemplates'] && $type_read['templates'] && ESPCMS_WEB_TYPE != 'WAP' ? $type_read['templates'] : 'bbs_center';

        $out_type = ESPCMS_WEB_TYPE != 'WAP' && $type_read['ispage'] == 2 ? 'bbslist' : 'bbspage';

        $lanpack = $espcms_web_templates->geto('lngpack');
        $lanpack['sitename'] = $type_read['typename'] . '-' . $lanpack['sitename'];
        $espcms_web_templates->into('out', $out_type);
        $espcms_web_templates->into('current', $btid);
        $espcms_web_templates->into('type', $type_read);
        $espcms_web_templates->into('path', 'bbs');

        $db_where = " AND isclass=1 AND upbid=0 AND btid=$btid AND issourceurl=0";

        $db_num = espcms_db_num($db_table, $db_where);

        $order_rank = 'DESC';

        $order_key = 'istop DESC,bid';

        $db_sql = espcms_db_list_out($db_table, $db_where);
        $page_style = ESPCMS_WEB_TYPE == 'WAP' && defined('ESPCMS_WEB_TYPE') ? 2 : 1;

        $espcms_page_button = new ESPCMS_PageButton($db_sql, $db_num, $per_page_num, $pageid, $page_style, $lanpack['pagebotton'], 'inc_application\link\ForumLink', 'type_link', $type_read);

        $sql = $espcms_page_button->sql_creat($order_key, $order_rank);
        $db_query = $espcms_link_db->db_query($sql);
        while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
            $fetch_row['link'] = ForumLink::bbs_link($fetch_row);
            if ($type_read['ispage'] < 2) {
                $fetch_row['list'] = ESPCMS_ForumDB::get_bbs_reply_list($fetch_row['bid']);
            }
            $array[] = $fetch_row;
        }
        $espcms_web_templates->into('lngpack', $lanpack);
        $espcms_web_templates->into('array', $array);
        $espcms_web_templates->into('page_read', $espcms_page_button->page_argument_out());
        $espcms_web_templates->into('pagebotton', $espcms_page_button->page_botton_creat());
        $espcms_web_templates->output('bbs/' . $template_list, 'bbs_list', false, false);
    }

    public static function in_Read() {
        global $espcms_web_templates, $espcms_link_db;
        $bbsemanage_app_config = ESPCMS_Core::get_app_config('bbsemanage', false);
        if (!$bbsemanage_app_config['isetup'] || !$bbsemanage_app_config['isopen']) {
            ESPCMS_Dialog::Message_Page('app_close');
        }
        $db_table = ESPCMS_DB_PREFIX . 'bbs';
        $bid = $_GET['bid'];
        if (empty($bid) || !espcms_ismatches($bid)) {
            ESPCMS_Dialog::Message_Page('db_err');
        }
        $bbs_read = ESPCMS_ForumDB::get_bbs_view($bid);
        if (!$bbs_read || !$bbs_read['isclass']) {
            ESPCMS_Dialog::Message_Page('doc_read_err');
        }
        if (!$bbs_read['btid'] || !espcms_ismatches($bbs_read['btid'])) {
            ESPCMS_Dialog::Message_Page('db_err');
        }
        $type_read = ESPCMS_ForumDB::get_bbs_typelist_view($bbs_read['btid']);
        if (!$type_read || !$type_read['isclass']) {
            ESPCMS_Dialog::Message_Page('type_read_err');
        }

        $member_app_config = ESPCMS_Core::get_app_config('member', false);

        if ($type_read['view_purview'] && $member_app_config['isetup'] && $member_app_config['isopen']) {
            ESPCMS_MemberAuthority::authorityRandVerify($type_read['view_purview']);
        }
        $type_read['link'] = ForumLink::type_link($type_read);
        $lanpack = $espcms_web_templates->geto('lngpack');
        $lanpack['sitename'] = $bbs_read['title'] . '-' . $type_read['typename'] . '-' . $lanpack['sitename'];
        $espcms_web_templates->into('lngpack', $lanpack);
        $espcms_web_templates->into('read', $bbs_read);

        ESPCMS_ForumDB::bbs_DB($bid, 'ck');

        $pageid = $_GET['pageid'] && espcms_ismatches($_GET['pageid']) ? $_GET['pageid'] : 1;

        if ($type_read['listmax'] && espcms_ismatches($type_read['listmax'])) {
            $per_page_num = $type_read['listmax'];
        } else {
            $per_page_num = 20;
        }

        $db_where = " AND isclass=1 AND upbid=$bid";

        $db_num = espcms_db_num($db_table, $db_where);

        $order_rank = 'DESC';

        $order_key = 'istop DESC,bid';

        $db_sql = espcms_db_list_out($db_table, $db_where);

        $espcms_page_button = new ESPCMS_PageButton($db_sql, $db_num, $per_page_num, $pageid, 1, $lanpack['pagebotton'], 'inc_application\link\ForumLink', 'bbs_link', $bbs_read);

        $sql = $espcms_page_button->sql_creat($order_key, $order_rank);
        $db_query = $espcms_link_db->db_query($sql);
        while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
            $fetch_row['link'] = ForumLink::bbs_link($fetch_row);
            if ($type_read['ispage'] < 2) {
                $fetch_row['list'] = ESPCMS_ForumDB::get_bbs_reply_list($fetch_row['bid']);
            }
            $array[] = $fetch_row;
        }
        $espcms_web_templates->into('array', $array);
        $espcms_web_templates->into('page_read', $espcms_page_button->page_argument_out());
        $espcms_web_templates->into('pagebotton', $espcms_page_button->page_botton_creat());
        if (ESPCMS_WEB_TYPE == 'WAP' && defined('ESPCMS_WEB_TYPE')) {
            $template_read = 'bbs_read';
        } else {
            $template_read = $type_read['readtemplate'] ? $type_read['readtemplate'] : 'bbs_read';
        }
        $espcms_web_templates->into('type', $type_read);
        $espcms_web_templates->into('path', 'bbs');
        $espcms_web_templates->output('bbs/' . $template_read, 'bbs_read', false, false);
    }

    public static function in_AjaxDocList() {
        global $espcms_web_templates, $espcms_link_db;
        $lanpack = $espcms_web_templates->geto('lngpack');
        $btid = $_GET['btid'];
        if (!$btid || !espcms_ismatches($btid)) {
            exit('<div class="center">' . $lanpack['db_err'] . '</div>');
        }
        $db_where = " AND isclass=1 AND btid=$btid AND upbid>0 AND adminid=0";
        if (preg_match('/^[\w]{2,50}$/i', $_GET['sourcecode'])) {
            $db_where .= " AND sourcecode='" . $_GET['sourcecode'] . "'";
        }
        $db_table = ESPCMS_DB_PREFIX . "bbs";
        $limit = $_GET['limit'] && espcms_ismatches($_GET['limit']) ? $_GET['limit'] : 20;
        $limitstard = $_GET['limitstard'] && espcms_ismatches($_GET['limitstard']) ? $_GET['limitstard'] : 0;
        $db_query = $espcms_link_db->db_query(espcms_db_list_out($db_table, $db_where, 'bid', 'DESC', $limitstard, $limit));
        while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {

            $re_list = ESPCMS_ForumDB::get_bbs_reply_list($fetch_row['bid']);
            $fetch_row['re_list'] = $re_list;
            $array[] = $fetch_row;
        }
        $espcms_web_templates->into('array', $array);
        $espcms_web_templates->output('bbs/bbs_ajax_list');
    }

    public static function in_Save() {
        global $espcms_command;
        $addtype = $_POST['addtype'] ? $_POST['addtype'] : 'addsave';
        if (!$_POST['btid'] || !espcms_ismatches($_POST['btid'])) {
            ESPCMS_Dialog::Message_Page('db_err');
        }

        if (!is_token($_POST['tokenname'], $_POST['tokenkey'])) {
            ESPCMS_Dialog::Message_Page('repeat_inut');
        }
        $bbsemanage_app_config = ESPCMS_Core::get_app_config('bbsemanage', false);
        if (!$bbsemanage_app_config['isetup'] || !$bbsemanage_app_config['isopen']) {
            ESPCMS_Dialog::Message_Page('app_close');
        }

        $bbs_con = unserialize($bbsemanage_app_config['appconfig']);

        $member_app_config = ESPCMS_Core::get_app_config('member', false);
        if ($member_app_config['isetup'] && $member_app_config['isopen']) {
            $member_info = ESPCMS_MemberAuthority::getMemberInfo();
            $_POST['userid'] = $member_info['userid'] && espcms_ismatches($member_info['userid']) ? $member_info['userid'] : 0;
        }
        $_POST['lng'] = espcms_lancode();
        $_POST['adminid'] = 0;
        $_POST['replynum'] = 0;
        $_POST['click'] = 0;
        $_POST['addtime'] = time();
        $_POST['retime'] = 0;
        $_POST['istop'] = 0;
        $_POST['issourceurl'] = $_POST['sourceurl'] && preg_match('/^[\w]+$/i', $_POST['sourcecode']) && $_POST['sourcetitle'] ? 1 : 0;
        $_POST['email'] = espcms_isemail($_POST['email']) ? $_POST['email'] : '';
        $_POST['mobile'] = espcms_ismoblie($_POST['mobile']) ? $_POST['mobile'] : '';
        $_POST['ipadd'] = real_remote_ip();
        $_POST['addname'] = $_POST['addname'] ? htmlspecialchars($_POST['addname']) : '';
        $_POST['sourcetitle'] = $_POST['sourcetitle'] ? htmlspecialchars($_POST['sourcetitle']) : '';
        $_POST['sourcecode'] = $_POST['sourcecode'] ? htmlspecialchars($_POST['sourcecode']) : '';
        $_POST['sourceurl'] = $_POST['sourceurl'] ? htmlspecialchars($_POST['sourceurl']) : '';
        $bbs_type_read = ESPCMS_ForumDB::get_bbs_typelist_view($_POST['btid']);
        if (!$bbs_type_read || !$bbs_type_read['isclass']) {
            ESPCMS_Dialog::Message_Page('type_read_err');
        }
        $_POST['isclass'] = $bbs_type_read['isaddclass'] ? 0 : 1;

        if ($bbs_type_read['isseccode'] && $espcms_command['SAFETY_ISVERIFICATION_CODE']) {

            require_once(ESPCMS_FILE_ROOT . 'espcms_public/ESPCMS_VerificationCode.php');

            $espcms_login_verification_code_cookie = $_COOKIE['espcms_web_login_verification_code'];
            if ($espcms_login_verification_code_cookie) {
                $espcms_login_verification_code = espcms_decrypt($espcms_login_verification_code_cookie, ESPCMS_ENCRYPT_CODE);
            } else {
                ESPCMS_Dialog::Message_Page('seescode_err');
            }
            $code = new ESPCMS_VerificationCode();
            $code->seccodeconvert($espcms_login_verification_code);
            $_POST['seccode'] = $_POST['seccode'] ? strtoupper($_POST['seccode']) : '';
            if ($espcms_login_verification_code != $_POST['seccode']) {
                ESPCMS_Dialog::Message_Page('seescode_err');
            }
        }

        if ((($bbs_type_read['add_purview'] && espcms_ismatches($bbs_type_read['add_purview'])) || ($bbs_type_read['add_purview'] && espcms_islongfig($bbs_type_read['add_purview']))) && $member_app_config['isopen'] && $member_app_config['isetup'] && !ESPCMS_MemberAuthority::authorityRandVerify($bbs_type_read['add_purview'], true)) {
            ESPCMS_Dialog::Message_Page('purview_err');
        }

        if ($bbs_type_read['inputtime'] && espcms_ismatches($bbs_type_read['inputtime'])) {
            $input_cookie_id = md5($_POST['ipadd'] . $_POST['btid'] . 'bbsinput');
            $is_repeat = $_COOKIE[$input_cookie_id];
            if (!$is_repeat) {
                espcms_set_cookie($input_cookie_id, time(), $bbs_type_read['inputtime']);
            } else {
                ESPCMS_Dialog::Message_Page('operating_fast');
            }
        }

        $lock_user_array = $bbs_con['FORUM_USERFILTERS'] ? explode(',', $bbs_con['FORUM_USERFILTERS']) : false;
        if ($_POST['userid'] && $member_app_config['isopen'] && $member_app_config['isetup'] && is_array($lock_user_array)) {
            $username = ESPCMS_MemberDB::get_member_noatt_view($_POST['userid'], 'username');
            if (in_array($username, $lock_user_array)) {
                ESPCMS_Dialog::Message_Page('blacklist_user');
            }
        }

        if (espcms_screening_key($_POST['content'], $bbs_con['FORUM_ALLOWCENSORWORD']) || espcms_screening_key($_POST['title'], $bbs_con['FORUM_ALLOWCENSORWORD'])) {
            ESPCMS_Dialog::Message_Page('blacklist_word');
        }
        $_POST['content'] = $_POST['content'] ? espcms_t2h($_POST['content']) : '';

        $db_table = ESPCMS_DB_PREFIX . "bbs";
        $talbe_field_array = espcms_field_out($db_table, true);
        if ($addtype == 'ajaxlistadd') {

            if (!preg_match('/^[\w]+$/i', $_POST['sourcecode']) || !$_POST['sourceurl']) {
                ESPCMS_Dialog::Message_Page('db_err');
            }
            $link_bbs_read = ESPCMS_ForumDB::get_bbs_code_view($_POST['sourcecode']);
            if (!$link_bbs_read) {

                $install_id = ESPCMS_ForumDB::install_bbs_subject($_POST);
            } else {
                ESPCMS_ForumDB::bbs_DB($link_bbs_read['bid']);
            }
            $_POST['title'] = !$_POST['title'] ? htmlspecialchars($_POST['sourcetitle']) : htmlspecialchars($_POST['title']);
            $_POST['upbid'] = $link_bbs_read['bid'] && espcms_ismatches($link_bbs_read['bid']) ? $link_bbs_read['bid'] : $install_id;
            $postvalue = espcms_post($_POST, $talbe_field_array, true);
            if (!$postvalue || !is_array($postvalue)) {
                ESPCMS_Dialog::Message_Page('db_err');
            }
            $install_id = espcms_db_install_save($db_table, $postvalue);
            if (!$install_id) {
                ESPCMS_Dialog::Message_Page('save_err');
            }
            if ($espcms_command['EMAIL_ISOPEN'] && $bbs_type_read['ismail'] && $bbs_type_read['mailcode'] && espcms_isemail($bbs_type_read['putmail']) && !$_POST['upbid']) {

                $_POST['bid'] = $install_id;
                $_POST['retime'] = $_POST['retime'] > 0 ? espcms_timeformat($_POST['retime'], 3) : 0;
                $_POST['forumlink'] = ForumLink::bbs_link($_POST, 0, true);
                ESPCMS_SendMessage::send_email_key_message($bbs_type_read['mailcode'], $bbs_type_read['putmail'], $_POST);
            }
            if ($espcms_command['SMS_ISOPEN'] && $bbs_type_read['issms'] && $bbs_type_read['smscode'] && !$_POST['upbid']) {
                $_POST['bid'] = $install_id;
                $_POST['retime'] = $_POST['retime'] > 0 ? espcms_timeformat($_POST['retime'], 3) : 0;
                $_POST['forumlink'] = ForumLink::bbs_link($_POST, 0, true);
                ESPCMS_SendMessage::send_moblie_sms_message($bbs_type_read['smscode'], $espcms_command['SMS_MOBLIE_NB'], $_POST);
            }
            ESPCMS_Dialog::Message_Page('bbs_save_ok');
        } elseif ($addtype == 'addsave') {
            $_POST['upbid'] = espcms_ismatches($_POST['bid']) && $_POST['bid'] ? $_POST['bid'] : 0;
            $_POST['title'] = $_POST['title'] ? htmlspecialchars($_POST['title']) : '';
            $postvalue = espcms_post($_POST, $talbe_field_array, true);
            if (!$postvalue || !is_array($postvalue)) {
                ESPCMS_Dialog::Message_Page('db_err');
            }
            $install_id = espcms_db_install_save($db_table, $postvalue);
            if (!$install_id) {
                ESPCMS_Dialog::Message_Page('save_err');
            }
            if ($espcms_command['EMAIL_ISOPEN'] && $bbs_type_read['ismail'] && $bbs_type_read['mailcode'] && espcms_isemail($bbs_type_read['putmail'])) {

                $_POST['bid'] = $install_id;
                $_POST['retime'] = $_POST['retime'] > 0 ? espcms_timeformat($_POST['retime'], 3) : 0;
                $_POST['forumlink'] = ForumLink::bbs_link($_POST, 0, true);
                ESPCMS_SendMessage::send_email_key_message($bbs_type_read['mailcode'], $bbs_type_read['putmail'], $_POST);
            }
            if ($espcms_command['SMS_ISOPEN'] && $bbs_type_read['issms'] && $bbs_type_read['smscode']) {

                $_POST['bid'] = $install_id;
                $_POST['retime'] = $_POST['retime'] > 0 ? espcms_timeformat($_POST['retime'], 3) : 0;
                $_POST['forumlink'] = ForumLink::bbs_link($_POST, 0, true);
                ESPCMS_SendMessage::send_moblie_sms_message($bbs_type_read['smscode'], $espcms_command['SMS_MOBLIE_NB'], $_POST);
            }
            ESPCMS_Dialog::Message_Page('bbs_save_ok');
        } elseif ($addtype == 'readdsave') {
            $_POST['upbid'] = espcms_ismatches($_POST['upbid']) && $_POST['upbid'] ? $_POST['upbid'] : 0;
            $_POST['title'] = $_POST['title'] ? htmlspecialchars($_POST['title']) : '';
            $postvalue = espcms_post($_POST, $talbe_field_array, true);
            if (!$postvalue || !is_array($postvalue)) {
                ESPCMS_Dialog::Message_Page('db_err');
            }
            $install_id = espcms_db_install_save($db_table, $postvalue);
            if (!$install_id) {
                ESPCMS_Dialog::Message_Page('save_err');
            }

            ESPCMS_ForumDB::bbs_DB($_POST['upbid']);
            if ($espcms_command['EMAIL_ISOPEN'] && $bbs_type_read['ismail'] && $bbs_type_read['mailcode'] && espcms_isemail($bbs_type_read['putmail'])) {

                $_POST['bid'] = $_POST['upbid'];
                $_POST['retime'] = espcms_timeformat(time(), 3);
                $_POST['forumlink'] = ForumLink::bbs_link($_POST, 0, true);
                ESPCMS_SendMessage::send_email_key_message($bbs_type_read['mailcode'], $bbs_type_read['putmail'], $_POST);

                $email = ESPCMS_ForumDB::get_bbs_view($_POST['upbid'], 'email');
                ESPCMS_SendMessage::send_email_key_message('forumre', $email, $_POST);
            }
            if ($espcms_command['SMS_ISOPEN'] && $bbs_type_read['issms'] && $bbs_type_read['smscode']) {

                $_POST['bid'] = $_POST['upbid'];
                $_POST['retime'] = espcms_timeformat(time(), 3);
                $_POST['forumlink'] = ForumLink::bbs_link($_POST, 0, true);
                ESPCMS_SendMessage::send_moblie_sms_message($bbs_type_read['smscode'], $espcms_command['SMS_MOBLIE_NB'], $_POST);
            }
            ESPCMS_Dialog::Message_Page('bbs_re_save_ok');
        }
    }

    public static function in_Token() {
        global $espcms_command;
        if (!$_GET['btid'] || !espcms_ismatches($_GET['btid']) || !espcms_isact($_GET['key'], "/^[\w]+$/i") || $espcms_command['IS_HTML']) {
            return false;
        }
        $tokenkey = token($_GET['key']);
        $out_json = json_encode($tokenkey);
        exit($out_json);
    }
}
