<?php

/*
  PHP version 5
  Copyright (c) 2002-2018 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030
  ESPCMS官网介绍：http://www.ecisp.cn	企业建站：http://www.earclink.cn
 */

use application\ESPCMS_Core;
use application\ESPCMS_PageButton;
use modul_application\ESPCMS_Dialog;
use modul_application\ESPCMS_MemberDB;
use modul_application\ESPCMS_ForumDB;
use modul_application\ESPCMS_MemberAuthority;
use inc_application\link\MemberLink;
use inc_application\link\ForumLink;

class ForumMember {

	private static $member_cookie_read;
	private static $member_con;

	public function __construct() {
		$member_app_config = ESPCMS_Core::get_app_config('member', false);
		if (!$member_app_config['isetup'] || !$member_app_config['isopen']) {
			ESPCMS_Dialog::Message_Page('app_close');
		}
		ESPCMS_MemberAuthority::authorityWebVerify(false, $member_app_config['appconfig']);
		static::$member_con = unserialize($member_app_config['appconfig']);

		$member_cookie_info = ESPCMS_MemberAuthority::getMemberInfo();
		static::$member_cookie_read = ESPCMS_MemberDB::get_member_view($member_cookie_info['userid']);
		if (!static::$member_cookie_read) {
			ESPCMS_Dialog::Message_Page('member_read_err', MemberLink::get_link('quit'));
		}
	}

	public static function in_List() {
		global $espcms_web_templates, $espcms_link_db;
		$db_table = ESPCMS_DB_PREFIX . 'bbs';

		$pageid = $_GET['pageid'] && espcms_ismatches($_GET['pageid']) ? $_GET['pageid'] : 1;
		$per_page_num = 20;

		$userid = static::$member_cookie_read['userid'];
		if (!espcms_ismatches($userid) || !$userid) {
			ESPCMS_Dialog::Message_Page('db_err', MemberLink::get_link('center'));
		}
		$lng = espcms_lancode();

		$db_where = " AND userid=$userid AND lng='$lng'";

		$db_num = espcms_db_num($db_table, $db_where);

		$db_sql = espcms_db_list_out($db_table, $db_where);

		$lanpack = $espcms_web_templates->geto('lngpack');
		$page_style = defined('ESPCMS_WEB_TYPE') && ESPCMS_WEB_TYPE == 'WAP' ? 2 : 1;

		$espcms_page_button = new ESPCMS_PageButton($db_sql, $db_num, $per_page_num, $pageid, $page_style, $lanpack['pagebotton'], 'inc_application\link\ForumLink', 'bbs_member_link', array());

		$sql = $espcms_page_button->sql_creat('bid', 'DESC');
		$db_query = $espcms_link_db->db_query($sql);
		while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
			$fetch_row['edit_link'] = ForumLink::bbs_member_edit_link('edit', $fetch_row);
			$array[] = $fetch_row;
		}
		$lanpack['sitename'] = $lanpack['title_member_name'] . '-' . $lanpack['sitename'];
		$espcms_web_templates->into('lngpack', $lanpack);
		$espcms_web_templates->into('array', $array);
		$espcms_web_templates->into('path', 'member');
		$espcms_web_templates->into('mlink', MemberLink::get_link());
		$espcms_web_templates->into('page_read', $espcms_page_button->page_argument_out());
		$espcms_web_templates->into('pagebotton', $espcms_page_button->page_botton_creat());
		$espcms_web_templates->output('member/member_bbs', 'member_bbs', false, false);
	}

	public static function in_Edit() {
		global $espcms_web_templates;
		$bid = $_GET['bid'];
		if (!espcms_ismatches($bid) || !$bid) {
			ESPCMS_Dialog::Message_Page('db_err', ForumLink::bbs_member_link());
		}
		$userid = static::$member_cookie_read['userid'];
		if (!espcms_ismatches($userid) || !$userid) {
			ESPCMS_Dialog::Message_Page('db_err', MemberLink::get_link('center'));
		}
		$bbs_read = ESPCMS_ForumDB::get_bbs_view($bid);
		if (!$bbs_read || !$bbs_read['isclass'] || $bbs_read['userid'] != $userid) {
			ESPCMS_Dialog::Message_Page('doc_read_err');
		}
		if (!$bbs_read['btid'] || !espcms_ismatches($bbs_read['btid'])) {
			ESPCMS_Dialog::Message_Page('db_err');
		}
		$type_read = ESPCMS_ForumDB::get_bbs_typelist_view($bbs_read['btid']);
		if (!$type_read || !$type_read['isclass']) {
			ESPCMS_Dialog::Message_Page('type_read_err');
		}
		$bbs_read['content'] = $bbs_read['content'] ? espcms_h2t($bbs_read['content']) : '';

		$lanpack = $espcms_web_templates->geto('lngpack');
		$lanpack['sitename'] = $lanpack['title_member_name'] . '-' . $lanpack['sitename'];
		$espcms_web_templates->into('lngpack', $lanpack);
		$espcms_web_templates->into('read', $bbs_read);
		$espcms_web_templates->into('type', $type_read);
		$espcms_web_templates->into('mlink', MemberLink::get_link());
		$espcms_web_templates->into('savelink', ForumLink::bbs_member_edit_link('save'));
		$espcms_web_templates->into('path', 'member');
		$espcms_web_templates->into('tokenkey', token('member_bbs_edit'));
		$espcms_web_templates->output('member/member_bbs_edit', 'member_bbs_edit', false, false);
	}

	public static function in_Save() {
		global $espcms_command;

		$userid = static::$member_cookie_read['userid'];
		if (!espcms_ismatches($userid) || !$userid) {
			ESPCMS_Dialog::Message_Page('db_err');
		}
		$bbsemanage_app_config = ESPCMS_Core::get_app_config('bbsemanage', false);
		if (!$bbsemanage_app_config['isetup'] || !$bbsemanage_app_config['isopen']) {
			ESPCMS_Dialog::Message_Page('app_close');
		}

		$bbs_con = unserialize($bbsemanage_app_config['appconfig']);
		$bid = $_POST['bid'];
		if (!espcms_ismatches($bid) || !$bid) {
			ESPCMS_Dialog::Message_Page('db_err');
		}
		if (!is_token($_POST['tokenname'], $_POST['tokenkey'])) {
			ESPCMS_Dialog::Message_Page('repeat_inut', ForumLink::bbs_member_link());
		}
		$bbs_read = ESPCMS_ForumDB::get_bbs_view($bid);
		if (!$bbs_read || !$bbs_read['isclass'] || $bbs_read['userid'] != $userid) {
			ESPCMS_Dialog::Message_Page('doc_read_err');
		}
		$type_read = ESPCMS_ForumDB::get_bbs_typelist_view($bbs_read['btid']);
		if (!$type_read || !$type_read['isclass']) {
			ESPCMS_Dialog::Message_Page('type_read_err');
		}

		if (espcms_screening_key($_POST['content'], $bbs_con['FORUM_ALLOWCENSORWORD']) || espcms_screening_key($_POST['title'], $bbs_con['FORUM_ALLOWCENSORWORD'])) {
			ESPCMS_Dialog::Message_Page('blacklist_word');
		}
		$_POST['isclass'] = $type_read['isaddclass'] ? 0 : 1;
		$_POST['title'] = $_POST['title'] ? htmlspecialchars($_POST['title']) : '';
		$_POST['addname'] = $_POST['addname'] ? htmlspecialchars($_POST['addname']) : '';
		$_POST['content'] = $_POST['content'] ? espcms_t2h($_POST['content']) : '';
		$db_where = "WHERE userid=$userid AND bid=$bid";
		$db_table = ESPCMS_DB_PREFIX . "bbs";
		$talbe_field_array = espcms_field_out($db_table, true);
		unset($_POST['btid'], $_POST['did'], $_POST['upbid'], $_POST['adminid'], $_POST['userid'], $_POST['lng'], $_POST['replynum'], $_POST['click'], $_POST['addtime'], $_POST['retime'], $_POST['istop']);
		unset($_POST['ipadd'], $_POST['issourceurl'], $_POST['sourceurl'], $_POST['sourcecode'], $_POST['sourcetitle']);
		$postvalue = espcms_post($_POST, $talbe_field_array, true);
		if (!$postvalue || !is_array($postvalue)) {
			ESPCMS_Dialog::Message_Page('dba_read_err');
		}
		$update_id = espcms_db_update_save($db_table, $db_where, $postvalue);
		if (!$update_id) {
			ESPCMS_Dialog::Message_Page('save_err');
		}
		ESPCMS_Dialog::Message_Page('bbs_edit_save_ok', ForumLink::bbs_member_link());
	}

}
