<?php

/*
  PHP version 5
  Copyright (c) 2002-2019ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/


use modul_application\ESPCMS_ArticleTypeDB;
use modul_application\ESPCMS_ForumDB;
use modul_application\ESPCMS_FormDB;
use inc_application\link\ArticleLink;
use inc_application\link\ForumLink;
use inc_application\link\FormsLink;

class lib_path {

	public static function call_path($parameter, $filename = 'path', $outHTML = null) {
		$espcms_lib_template = espcms_web_template();
		$espcms_lib_template->libfile = true;
		$para = espcms_array_getvalue($parameter);
		if ((!espcms_ismatches($para['id']) || !$para['id']) && !$para['key']) {
			return false;
		}
		$type_array = array('doc', 'tag', 'sub', 'bbs', 'order', 'forms', 'faq');
		$type = in_array($para['type'], $type_array) ? $para['type'] : 'doc';
		$path_array = array();
		if ($type == 'doc') {
			$type_read = ESPCMS_ArticleTypeDB::get_article_type_view($para['id']);
			if (!$type_read) {
				return false;
			}
			$type_read['title'] = $type_read['typename'];
			$type_goto_read = $type_read['gotoid'] && espcms_ismatches($type_read['gotoid']) ? ESPCMS_ArticleTypeDB::get_article_type_view($type_read['gotoid']) : $type_read;
			$type_read['link'] = ArticleLink::type_link($type_goto_read);
			if ($type_read['upid']) {
				$path_array = ESPCMS_ArticleTypeDB::get_type_topout($type_read['upid']);
				if (is_array($path_array)) {
					sort($path_array);
				}
			}
			$path_array[] = $type_read;
		}
		if ($type == 'sub') {
			$sub_array = ESPCMS_ArticleTypeDB::get_article_subjectlist_view($para['id']);
			if (!$sub_array) {
				return false;
			}
			$sub_array['title'] = $sub_array['subjectname'];
			$sub_array['link'] = ArticleLink::subtype_link($sub_array);
			$path_array[] = $sub_array;
		}
		if ($type == 'tag') {
			$tag_array['title'] = $para['key'];
			$tag_array['link'] = ArticleLink::tags_link($tag_array);
			$path_array[] = $tag_array;
		}
		if ($type == 'bbs') {
			$bbs_array = ESPCMS_ForumDB::get_bbs_typelist_view($para['id']);
			if (!$bbs_array) {
				return false;
			}
			$bbs_array['title'] = $bbs_array['typename'];
			$bbs_array['link'] = ForumLink::type_link($bbs_array);
			$path_array[] = $bbs_array;
		}
		if ($type == 'forms') {
			$forms_array = ESPCMS_FormDB::get_form_group_view($para['id']);
			if (!$forms_array) {
				return false;
			}
			$forms_array['title'] = $forms_array['formgroupname'];
			$forms_array['link'] = FormsLink::type_link($forms_array);
			$path_array[] = $forms_array;
		}
		$espcms_lib_template->into('para', $para);
		$espcms_lib_template->into('array', $path_array);
		$espcms_lib_template->into('path_key', count($path_array));
		if (!empty($outHTML)) {
			$output = $espcms_lib_template->fetch(null, null, $outHTML);
		} else {
			$output = $espcms_lib_template->fetch('lib/' . $filename);
		}
		return $output;
	}

}
