<?php

/*
  PHP version 5
  Copyright (c) 2002-2019ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/


use application\ESPCMS_Core;
use modul_application\ESPCMS_ArticleDB;
use modul_application\ESPCMS_ArticleTypeDB;
use inc_application\link\ArticleLink;
use inc_application\link\OrderLink;
use inc_application\link\EnquiryLink;

class lib_plist {

    public static function call_plist($parameter, $filename = 'plist', $outHTML = null) {
        $espcms_lib_template = espcms_web_template();
        $espcms_lib_template->libfile = true;
        $para = espcms_array_getvalue($parameter);
        if (!espcms_ismatches($para['did']) || !$para['did']) {
            return false;
        }

        $class = $para['class'] && espcms_ismatches($para['class']) ? $para['class'] : 0;
        $did = $para['did'];
        $doc_read = ESPCMS_ArticleDB::get_article_read($did);
        if (!$doc_read) {
            return false;
        }

        $order_app_config = ESPCMS_Core::get_app_config('order', false);
        $enquiry_app_config = ESPCMS_Core::get_app_config('enquiry', false);

        $type_read = ESPCMS_ArticleTypeDB::get_article_type_view($doc_read['tid']);
        $doc_read['ctitle'] = empty($doc_read['color']) ? $doc_read['title'] : "<font color='" . $doc_read['color'] . "'>" . $doc_read['title'] . "</font>";
        $doc_read['ishtml'] = $type_read['pageclass'] == 2 ? 2 : $doc_read['ishtml'];
        $doc_read['typename'] = $type_read['typename'];
        $doc_read['typelink'] = ArticleLink::type_link($type_read);
        $doc_read['pageclass'] = $type_read['pageclass'];
        $doc_read['link'] = ArticleLink::doc_link($doc_read);
        if ($order_app_config['isetup'] && $order_app_config['isopen']) {
            $doc_read['buylink'] = OrderLink::get_order_link('buy', $doc_read);
        }
        if ($enquiry_app_config['isetup'] && $enquiry_app_config['isopen']) {
            $doc_read['enqlink'] = EnquiryLink::get_enquiry_link('into', $doc_read);
        }

        $tid = $doc_read['tid'];
        $db_table = ESPCMS_DB_PREFIX . 'document';
        if ($class) {
            $db_where = "WHERE isclass=1 AND tid=$tid AND did > $did ORDER BY did ASC LIMIT 0,1";
        } else {
            $db_where = "WHERE isclass=1 AND tid=$tid AND did < $did ORDER BY did DESC LIMIT 0,1";
        }
        $talbe_field_array = espcms_field_out($db_table, false);
        $read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
        if (!$read_info) {
            return false;
        }
        $read_info['ctitle'] = empty($read_info['color']) ? $read_info['title'] : "<font color='" . $read_info['color'] . "'>" . $read_info['title'] . "</font>";
        $read_info['ishtml'] = $type_read['pageclass'] == 2 ? 2 : $read_info['ishtml'];
        $read_info['link'] = ArticleLink::doc_link($read_info);
        if ($order_app_config['isetup'] && $order_app_config['isopen']) {
            $read_info['buylink'] = OrderLink::get_order_link('buy', $read_info);
        }
        if ($enquiry_app_config['isetup'] && $enquiry_app_config['isopen']) {
            $read_info['enqlink'] = EnquiryLink::get_enquiry_link('into', $read_info);
        }

        $espcms_lib_template->into('read', $read_info);
        $espcms_lib_template->into('doc_read', $doc_read);
        $espcms_lib_template->into('para', $para);
        if (!empty($outHTML)) {
            $output = $espcms_lib_template->fetch(null, null, $outHTML);
        } else {
            $output = $espcms_lib_template->fetch('lib/' . $filename);
        }
        return $output;
    }

}
