<?php

/*
  PHP version 5
  Copyright (c) 2002-2019ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/


use modul_application\ESPCMS_ArticleTypeDB;
use modul_application\ESPCMS_ArticleModelDB;
use inc_application\link\ArticleLink;

class lib_search {

    public static function call_search($parameter, $filename = 'search', $outHTML = null) {
        $espcms_lib_template = espcms_web_template();
        $espcms_lib_template->libfile = true;
        $para = espcms_array_getvalue($parameter);
        $lng = espcms_lancode();
        $mid = $para['mid'] && espcms_ismatches($para['mid']) ? $para['mid'] : 0;
        $tid = $para['tid'] && espcms_ismatches($para['tid']) ? $para['tid'] : 0;
        $para['keyname'] = $para['keyname'] ? $para['keyname'] : 'title';
        $att = espcms_ismatches($para['att']) ? $para['att'] : 0;
        $now_tid = $_REQUEST['tid'] && espcms_ismatches($_REQUEST['tid']) ? $_REQUEST['tid'] : 0;
        $attr_array = $_REQUEST['attr_array'] && is_array($_REQUEST['attr_array']) ? $_REQUEST['attr_array'] : array();

        if ($tid && $mid) {
            $typelist = ESPCMS_ArticleTypeDB::get_article_type_list($now_tid, $tid, $mid, $lng, false, false, false);
            array_shift($typelist);
            $espcms_lib_template->into('type_array', $typelist);
        }

        if ($att && $mid) {
            $model_attr_array = ESPCMS_ArticleModelDB::get_document_model_att_list($mid, false, true);
            if (is_array($model_attr_array)) {
                foreach ($model_attr_array as $key => $value) {
                    if (($value['inputtype'] == 'select' || $value['inputtype'] == 'radio') && is_array($value['attrvalue'])) {
                        foreach ($value['attrvalue'] as $key2 => $value2) {
                            $model_attr_array[$key]['attrvalue'][$key2]['selected'] = trim($attr_array[$value['attrname']]) == trim($value2['name']) ? 'selected' : '';
                        }
                    } elseif ($value['inputtype'] == 'checkbox') {
                        foreach ($value['attrvalue'] as $key2 => $value2) {
                            $model_attr_array[$key]['attrvalue'][$key2]['selected'] = is_array($attr_array[$value['attrname']]) && in_array($value2['name'], $attr_array[$value['attrname']]) ? 'selected' : '';
                        }
                    }
                }
            }
            $espcms_lib_template->into('attr_array', $model_attr_array);
        }
        $espcms_lib_template->into('para', $para);
        $espcms_lib_template->into('searchlink', ArticleLink::search_link());
        if (!empty($outHTML)) {
            $output = $espcms_lib_template->fetch(null, null, $outHTML);
        } else {
            $output = $espcms_lib_template->fetch('lib/' . $filename);
        }
        return $output;
    }

}
