const app = getApp()
import IMService from '../../static/lib/imservice.js';
Page({
	data : {
		conversations : [],
		action : {
			conversation : null,
			show : false,
			toastMessage : '',
			showToast : false
		}
	},
	onShow () {
		let currentUser = wx.getStorageSync("currentUser");
		if(!currentUser){
			wx.redirectTo({
				url : '../login/login'
			});
			return;
		}

		if(wx.im.getStatus() === 'disconnected') {
			app.globalData.imService= new IMService(wx.im);
			app.globalData.imService.connectIM(currentUser);
		}
		wx.showLoading({
			title: '加载中'
		});
		//监听会话列表变化
		let self = this;
		wx.im.on(wx.GoEasyIM.EVENT.CONVERSATIONS_UPDATED, (conversations) => {
			// 设置tabBar未读消息总数以及conversation
			self.setConversations(conversations);
		});

		//加载会话列表
		wx.im.latestConversations()
			.then(res => {
				let content = res.content;
				self.setConversations(content);
				wx.hideLoading();
			})
			.catch(e => {
				console.log(e);
				wx.hideLoading();
			});
	},
	onHide(){
		// 销毁conversation监听器
		wx.im.on(wx.GoEasyIM.EVENT.CONVERSATIONS_UPDATED, (conversations) => {});
	},
	setConversations (conversations) {
		conversations.conversations && conversations.conversations.map((item) => {
			// 格式化时间格式
			item.lastMessage.date = app.formatDate(item.lastMessage.timestamp)
		});
		this.setData({
			conversations : conversations.conversations
		});
		this.setUnreadAmount(conversations.unreadTotal);
	},
	navigateToChat (e) {
		let conversation = e.currentTarget.dataset.conversation;
		let path = conversation.type === wx.GoEasyIM.SCENE.PRIVATE?
			       '../chat/privateChat/privateChat?to='+conversation.userId
					:'../chat/groupChat/groupChat?to='+ conversation.groupId;
		wx.navigateTo({
			url : path
		});
	},
	setUnreadAmount(unreadTotal) {
		if(unreadTotal >0){
			wx.setTabBarBadge({
				index: 0,
				text: unreadTotal.toString()
			});
		}else{
			wx.hideTabBarRedDot({
				index :0
			});
		}
	},
	showAction(e){
		let conversation = e.currentTarget.dataset.conversation;
		this.setData({
			["action.conversation"]: conversation,
			["action.show"]: true
		});
	},
	topConversation(){
		let conversation = this.data.action.conversation;
		let title = conversation.top ? '取消置顶失败' : '置顶失败';
		let promise;
		wx.showLoading({
			title: ""
		});
		if(conversation.type === wx.GoEasyIM.SCENE.PRIVATE){
			promise = wx.im.topPrivateConversation(conversation.userId, !conversation.top)
		}else{
			promise = wx.im.topGroupConversation(conversation.groupId, !conversation.top)
		}
		this.afterDoAction(promise, title)
	},
	removeConversation(){
		wx.showLoading({title: "删除中"});
		let conversation = this.data.action.conversation;
		let promise;
		if(conversation.type === wx.GoEasyIM.SCENE.PRIVATE){
			promise = wx.im.removePrivateConversation(conversation.userId);
		}else{
			promise = wx.im.removeGroupConversation(conversation.groupId);
		}
		this.afterDoAction(promise, '删除失败')
	},
	afterDoAction (promise, failedDescription) {
		promise.then(() => {
			wx.hideLoading()
		}).catch(() => {
			let self = this;
			wx.hideLoading();
			this.setData({
				["action.showToast"]: true,
				["action.toastMessage"]: failedDescription,
			});
			setTimeout(() => {
				self.setData({
					["action.showToast"]: false
				});
			},2000);
		});
		this.setData({
			["action.show"]: false
		})
	},

	// 关闭弹窗
	closeMask(){
		this.setData({
			["action.show"]: false
		})
	},
})