/*
Navicat MySQL Data Transfer

Source Server         : localhost
Source Server Version : 50553
Source Host           : localhost:3306
Source Database       : test

Target Server Type    : MYSQL
Target Server Version : 50553
File Encoding         : 65001

Date: 2017-12-09 15:18:38
*/

SET AUTOCOMMIT=0;
SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for ebcms5_app
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_app`;
CREATE TABLE `ebcms5_app` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `app_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '应用ID',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '名称',
  `version` varchar(255) NOT NULL DEFAULT '' COMMENT '版本',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='已经安装的APP表';

-- ----------------------------
-- Records of ebcms5_app
-- ----------------------------
INSERT INTO `ebcms5_app` VALUES ('1', '1', '核心', 'ebcms', '1.8.6', '1479890844', '1475398105', '1');
INSERT INTO `ebcms5_app` VALUES ('2', '24', '企业内容管理系统', 'content', '1.1.3', '1499652344', '1499652344', '1');
INSERT INTO `ebcms5_app` VALUES ('3', '6', '友情链接', 'link', '1.1.0', '1499652371', '1499652371', '1');
INSERT INTO `ebcms5_app` VALUES ('4', '11', '留言板', 'guestbook', '1.1.1', '1499652390', '1499652390', '1');
INSERT INTO `ebcms5_app` VALUES ('5', '5', '模板助手', 'mbzs', '1.1.1', '1499652824', '1499652824', '1');
INSERT INTO `ebcms5_app` VALUES ('6', '16', '访问统计', 'tongji', '1.0.1', '1499919722', '1499919722', '1');

-- ----------------------------
-- Table structure for ebcms5_auth_access
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_auth_access`;
CREATE TABLE `ebcms5_auth_access` (
  `uid` mediumint(8) unsigned NOT NULL,
  `group_id` mediumint(8) unsigned NOT NULL,
  UNIQUE KEY `uid_group_id` (`uid`,`group_id`),
  KEY `uid` (`uid`),
  KEY `group_id` (`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='角色权限表';

-- ----------------------------
-- Records of ebcms5_auth_access
-- ----------------------------

-- ----------------------------
-- Table structure for ebcms5_auth_group
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_auth_group`;
CREATE TABLE `ebcms5_auth_group` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `group` varchar(255) NOT NULL DEFAULT '' COMMENT '分组',
  `title` char(100) NOT NULL DEFAULT '',
  `remark` varchar(255) NOT NULL DEFAULT '' COMMENT '简介',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `rules` text COMMENT '规则',
  `c_rules` text COMMENT '栏目权限规则',
  `menus` text COMMENT '菜单权限',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='角色表';

-- ----------------------------
-- Records of ebcms5_auth_group
-- ----------------------------
INSERT INTO `ebcms5_auth_group` VALUES ('1', '系统', '管理员', '', '1', '', '', '', '5');
INSERT INTO `ebcms5_auth_group` VALUES ('2', '系统', '工程师', '', '1', '', '', '', '4');
INSERT INTO `ebcms5_auth_group` VALUES ('3', '系统', '编辑', '', '1', '', '', '', '3');
INSERT INTO `ebcms5_auth_group` VALUES ('4', '系统', '客服', '', '1', '', '', '', '2');

-- ----------------------------
-- Table structure for ebcms5_auth_rule
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_auth_rule`;
CREATE TABLE `ebcms5_auth_rule` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父id',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '操作说明',
  `name` char(80) NOT NULL DEFAULT '',
  `type` tinyint(1) NOT NULL DEFAULT '1',
  `condition` char(100) NOT NULL DEFAULT '',
  `sort` int(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `app` varchar(255) NOT NULL DEFAULT '' COMMENT '应用',
  `opstr` varchar(255) NOT NULL DEFAULT '' COMMENT '操作说明',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=6644 DEFAULT CHARSET=utf8 COMMENT='权限规则表';

-- ----------------------------
-- Records of ebcms5_auth_rule
-- ----------------------------
INSERT INTO `ebcms5_auth_rule` VALUES ('1', '0', '后台', 'ebcms_api_index', '1', '', '10', 'ebcms', '后台');
INSERT INTO `ebcms5_auth_rule` VALUES ('2', '1', '配置管理', 'ebcms_config_index', '1', '', '0', 'ebcms', '配置管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('3', '2', '设置', 'ebcms_config_setting', '1', '', '0', 'ebcms', '系统设置');
INSERT INTO `ebcms5_auth_rule` VALUES ('34', '1', '扩展管理', 'ebcms_extend_index', '1', '', '0', 'ebcms', '扩展管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('35', '34', '添加', 'ebcms_extend_add', '1', '', '0', 'ebcms', '添加扩展');
INSERT INTO `ebcms5_auth_rule` VALUES ('36', '34', '修改', 'ebcms_extend_edit', '1', '', '0', 'ebcms', '修改扩展');
INSERT INTO `ebcms5_auth_rule` VALUES ('37', '34', '删除', 'ebcms_extend_delete', '1', '', '0', 'ebcms', '删除扩展');
INSERT INTO `ebcms5_auth_rule` VALUES ('40', '34', '排序', 'ebcms_extend_resort', '1', '', '0', 'ebcms', '排序扩展');
INSERT INTO `ebcms5_auth_rule` VALUES ('41', '1', '扩展字段管理', 'ebcms_extendfield_index', '1', '', '0', 'ebcms', '扩展字段管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('42', '41', '添加', 'ebcms_extendfield_add', '1', '', '0', 'ebcms', '添加扩展字段');
INSERT INTO `ebcms5_auth_rule` VALUES ('43', '41', '编辑', 'ebcms_extendfield_edit', '1', '', '0', 'ebcms', '修改扩展字段');
INSERT INTO `ebcms5_auth_rule` VALUES ('44', '41', '删除', 'ebcms_extendfield_delete', '1', '', '0', 'ebcms', '删除扩展字段');
INSERT INTO `ebcms5_auth_rule` VALUES ('45', '41', '变更状态', 'ebcms_extendfield_status', '1', '', '0', 'ebcms', '变更扩展字段状态');
INSERT INTO `ebcms5_auth_rule` VALUES ('47', '41', '排序', 'ebcms_extendfield_resort', '1', '', '0', 'ebcms', '排序扩展字段');
INSERT INTO `ebcms5_auth_rule` VALUES ('48', '1', '后台首页', 'ebcms_index_index', '1', '', '0', 'ebcms', '后台首页');
INSERT INTO `ebcms5_auth_rule` VALUES ('49', '48', '主页', 'ebcms_index_main', '1', '', '0', 'ebcms', '主页');
INSERT INTO `ebcms5_auth_rule` VALUES ('50', '48', '删除缓存', 'ebcms_index_runtime', '1', '', '0', 'ebcms', '删除缓存');
INSERT INTO `ebcms5_auth_rule` VALUES ('51', '48', '修改自己的密码', 'ebcms_index_password', '1', '', '0', 'ebcms', '修改自己的密码');
INSERT INTO `ebcms5_auth_rule` VALUES ('52', '48', '附件上传', 'ebcms_index_upload', '1', '', '0', 'ebcms', '附件上传');
INSERT INTO `ebcms5_auth_rule` VALUES ('53', '48', '编辑器附件上传', 'ebcms_index_ueditor', '1', '', '0', 'ebcms', '编辑器附件上传');
INSERT INTO `ebcms5_auth_rule` VALUES ('58', '1', '角色管理', 'ebcms_group_index', '1', '', '0', 'ebcms', '角色管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('59', '58', '添加', 'ebcms_group_add', '1', '', '0', 'ebcms', '添加角色');
INSERT INTO `ebcms5_auth_rule` VALUES ('60', '58', '编辑', 'ebcms_group_edit', '1', '', '0', 'ebcms', '修改角色');
INSERT INTO `ebcms5_auth_rule` VALUES ('61', '58', '删除', 'ebcms_group_delete', '1', '', '0', 'ebcms', '删除角色');
INSERT INTO `ebcms5_auth_rule` VALUES ('62', '58', '分配权限', 'ebcms_group_rule', '1', '', '0', 'ebcms', '对角色分配权限');
INSERT INTO `ebcms5_auth_rule` VALUES ('63', '58', '分配菜单', 'ebcms_group_menu', '1', '', '0', 'ebcms', '对角色分配菜单权限');
INSERT INTO `ebcms5_auth_rule` VALUES ('64', '58', '变更状态', 'ebcms_group_status', '1', '', '0', 'ebcms', '审核角色');
INSERT INTO `ebcms5_auth_rule` VALUES ('66', '58', '排序', 'ebcms_group_resort', '1', '', '0', 'ebcms', '对角色排序');
INSERT INTO `ebcms5_auth_rule` VALUES ('72', '1318', '分配角色', 'ebcms_manager_group', '1', '', '0', 'ebcms', '给后台账户分配角色');
INSERT INTO `ebcms5_auth_rule` VALUES ('77', '1', '操作日志管理', 'ebcms_oplog_index', '1', '', '0', 'ebcms', '操作日志管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('78', '77', '删除', 'ebcms_oplog_delete', '1', '', '0', 'ebcms', '删除操作日志');
INSERT INTO `ebcms5_auth_rule` VALUES ('79', '77', '查看详情', 'ebcms_oplog_show', '1', '', '0', 'ebcms', '查看操作日志');
INSERT INTO `ebcms5_auth_rule` VALUES ('862', '1', '导航管理', 'ebcms_nav_index', '1', '', '0', 'ebcms', '导航管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('863', '862', '添加', 'ebcms_nav_add', '1', '', '0', 'ebcms', '添加导航');
INSERT INTO `ebcms5_auth_rule` VALUES ('864', '862', '编辑', 'ebcms_nav_edit', '1', '', '0', 'ebcms', '编辑导航');
INSERT INTO `ebcms5_auth_rule` VALUES ('865', '862', '审核', 'ebcms_nav_status', '1', '', '0', 'ebcms', '审核导航');
INSERT INTO `ebcms5_auth_rule` VALUES ('867', '862', '删除', 'ebcms_nav_delete', '1', '', '0', 'ebcms', '删除导航');
INSERT INTO `ebcms5_auth_rule` VALUES ('1318', '1', '账户管理', 'ebcms_manager_index', '1', '', '3', 'ebcms', '账户管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('1319', '1318', '查看信息', 'ebcms_manager_info', '1', '', '0', 'ebcms', '查看后台账户信息');
INSERT INTO `ebcms5_auth_rule` VALUES ('1320', '1318', '添加', 'ebcms_manager_add', '1', '', '0', 'ebcms', '添加后台账户');
INSERT INTO `ebcms5_auth_rule` VALUES ('1321', '1318', '编辑', 'ebcms_manager_edit', '1', '', '0', 'ebcms', '编辑后台账户');
INSERT INTO `ebcms5_auth_rule` VALUES ('1322', '1318', '删除', 'ebcms_manager_delete', '1', '', '0', 'ebcms', '删除后台账户');
INSERT INTO `ebcms5_auth_rule` VALUES ('1323', '1318', '重置密码', 'ebcms_manager_password', '1', '', '0', 'ebcms', '重置后台账户密码');
INSERT INTO `ebcms5_auth_rule` VALUES ('1324', '1318', '变更状态', 'ebcms_manager_status', '1', '', '0', 'ebcms', '变更后台账户状态');
INSERT INTO `ebcms5_auth_rule` VALUES ('3636', '48', '发邮件', 'ebcms_index_email', '1', '', '0', 'ebcms', '发邮件');
INSERT INTO `ebcms5_auth_rule` VALUES ('6365', '862', '排序', 'ebcms_nav_resort', '1', '', '0', 'ebcms', '导航排序');
INSERT INTO `ebcms5_auth_rule` VALUES ('6595', '0', '内容管理系统', 'content', '1', '', '200', 'content', '内容管理系统');
INSERT INTO `ebcms5_auth_rule` VALUES ('6596', '6595', '内容管理', 'content_admin.content_index', '1', '', '0', 'content', '内容管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('6597', '6596', '添加', 'content_admin.content_add', '1', '', '9', 'content', '添加内容');
INSERT INTO `ebcms5_auth_rule` VALUES ('6598', '6596', '编辑', 'content_admin.content_edit', '1', '', '8', 'content', '编辑内容');
INSERT INTO `ebcms5_auth_rule` VALUES ('6599', '6596', '批量移动', 'content_admin.content_move', '1', '', '0', 'content', '批量移动');
INSERT INTO `ebcms5_auth_rule` VALUES ('6600', '6596', '更改样式', 'content_admin.content_style', '1', '', '0', 'content', '更改样式');
INSERT INTO `ebcms5_auth_rule` VALUES ('6601', '6596', '设置标签', 'content_admin.content_tag', '1', '', '0', 'content', '设置内容聚合标签');
INSERT INTO `ebcms5_auth_rule` VALUES ('6602', '6596', '排序', 'content_admin.content_resort', '1', '', '0', 'content', '内容排序');
INSERT INTO `ebcms5_auth_rule` VALUES ('6603', '6596', '变更状态', 'content_admin.content_status', '1', '', '0', 'content', '变更内容状态');
INSERT INTO `ebcms5_auth_rule` VALUES ('6604', '6596', '设置属性', 'content_admin.content_attr', '1', '', '0', 'content', '设置内容推荐属性');
INSERT INTO `ebcms5_auth_rule` VALUES ('6605', '6596', '删除', 'content_admin.content_delete', '1', '', '0', 'content', '内容删除');
INSERT INTO `ebcms5_auth_rule` VALUES ('6606', '6595', '属性管理', 'content_admin.attr_index', '1', '', '0', 'content', '属性管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('6607', '6606', '内容排序', 'content_admin.attr_resort', '1', '', '0', 'content', '内容排序');
INSERT INTO `ebcms5_auth_rule` VALUES ('6608', '6606', '内容移除', 'content_admin.attr_remove', '1', '', '0', 'content', '内容移除');
INSERT INTO `ebcms5_auth_rule` VALUES ('6609', '6595', '关联标签', 'content_admin.tag_index', '1', '', '0', 'content', '关联标签管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('6610', '6609', '内容移除', 'content_admin.tag_remove', '1', '', '0', 'content', '关联标签内容移除');
INSERT INTO `ebcms5_auth_rule` VALUES ('6611', '6595', '栏目管理', 'content_admin.channel_index', '1', '', '0', 'content', '栏目管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('6612', '6611', '添加', 'content_admin.channel_add', '1', '', '9', 'content', '添加栏目');
INSERT INTO `ebcms5_auth_rule` VALUES ('6613', '6611', '导航显示切换', 'content_admin.channel_nav', '1', '', '0', 'content', '切换导航显示');
INSERT INTO `ebcms5_auth_rule` VALUES ('6614', '6611', '变更状态', 'content_admin.channel_status', '1', '', '0', 'content', '变更栏目状态');
INSERT INTO `ebcms5_auth_rule` VALUES ('6615', '6611', '排序', 'content_admin.channel_resort', '1', '', '0', 'content', '栏目排序');
INSERT INTO `ebcms5_auth_rule` VALUES ('6616', '6611', '删除', 'content_admin.channel_delete', '1', '', '0', 'content', '删除栏目');
INSERT INTO `ebcms5_auth_rule` VALUES ('6617', '6611', '编辑', 'content_admin.channel_edit', '1', '', '0', 'content', '编辑栏目');
INSERT INTO `ebcms5_auth_rule` VALUES ('6618', '0', '友情链接', 'link', '1', '', '40', 'link', '友情链接');
INSERT INTO `ebcms5_auth_rule` VALUES ('6619', '6618', '友情链接管理', 'link_admin.link_index', '1', '', '0', 'link', '友情链接管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('6620', '6619', '删除', 'link_admin.link_delete', '1', '', '0', 'link', '删除友情链接');
INSERT INTO `ebcms5_auth_rule` VALUES ('6621', '6619', '编辑', 'link_admin.link_edit', '1', '', '0', 'link', '编辑友情链接');
INSERT INTO `ebcms5_auth_rule` VALUES ('6622', '6619', '添加', 'link_admin.link_add', '1', '', '0', 'link', '添加友情链接');
INSERT INTO `ebcms5_auth_rule` VALUES ('6623', '6619', '审核', 'link_admin.link_status', '1', '', '0', 'link', '审核友情链接');
INSERT INTO `ebcms5_auth_rule` VALUES ('6624', '6619', '排序', 'link_admin.link_resort', '1', '', '0', 'link', '友情链接排序');
INSERT INTO `ebcms5_auth_rule` VALUES ('6625', '0', '在线留言', 'guestbook', '1', '', '90', 'guestbook', '');
INSERT INTO `ebcms5_auth_rule` VALUES ('6626', '6625', '留言管理', 'guestbook_admin.guestbook_index', '1', '', '0', 'guestbook', '');
INSERT INTO `ebcms5_auth_rule` VALUES ('6627', '6626', '编辑留言', 'guestbook_admin.guestbook_edit', '1', '', '0', 'guestbook', '');
INSERT INTO `ebcms5_auth_rule` VALUES ('6628', '6626', '审核留言', 'guestbook_admin.guestbook_status', '1', '', '0', 'guestbook', '');
INSERT INTO `ebcms5_auth_rule` VALUES ('6629', '6626', '推荐', 'guestbook_admin.guestbook_recommend', '1', '', '0', 'guestbook', '');
INSERT INTO `ebcms5_auth_rule` VALUES ('6630', '6626', '回复留言', 'guestbook_admin.guestbook_reply', '1', '', '0', 'guestbook', '');
INSERT INTO `ebcms5_auth_rule` VALUES ('6631', '6626', '删除留言', 'guestbook_admin.guestbook_delete', '1', '', '0', 'guestbook', '');
INSERT INTO `ebcms5_auth_rule` VALUES ('6632', '0', '模板助手', 'mbzs', '1', '', '200', 'mbzs', '模板助手');
INSERT INTO `ebcms5_auth_rule` VALUES ('6633', '6632', '模板助手管理', 'mbzs_mbzs_index', '1', '', '0', 'mbzs', '模板助手管理');
INSERT INTO `ebcms5_auth_rule` VALUES ('6634', '6633', '变更状态', 'mbzs_mbzs_status', '1', '', '0', 'mbzs', '变更模板变量状态');
INSERT INTO `ebcms5_auth_rule` VALUES ('6635', '6633', '编辑', 'mbzs_mbzs_edit', '1', '', '0', 'mbzs', '编辑模板变量');
INSERT INTO `ebcms5_auth_rule` VALUES ('6636', '6633', '添加', 'mbzs_mbzs_add', '1', '', '0', 'mbzs', '添加模板助手变量');
INSERT INTO `ebcms5_auth_rule` VALUES ('6637', '6633', '删除', 'mbzs_mbzs_delete', '1', '', '0', 'mbzs', '删除模板助手变量');
INSERT INTO `ebcms5_auth_rule` VALUES ('6638', '6633', '排序', 'mbzs_mbzs_resort', '1', '', '0', 'mbzs', '模板助手变量排序');
INSERT INTO `ebcms5_auth_rule` VALUES ('6639', '0', '统计', 'tongji', '1', '', '3000', 'tongji', '');
INSERT INTO `ebcms5_auth_rule` VALUES ('6640', '6639', '统计', 'tongji_index', '1', '', '0', 'tongji', '');
INSERT INTO `ebcms5_auth_rule` VALUES ('6641', '6640', '查看浏览记录', 'tongji_index_index', '1', '', '0', 'tongji', '');
INSERT INTO `ebcms5_auth_rule` VALUES ('6642', '6640', '查看页面统计', 'tongji_index_tj', '1', '', '0', 'tongji', '查看页面统计');
INSERT INTO `ebcms5_auth_rule` VALUES ('6643', '6640', '删除统计数据', 'tongji_index_delete', '1', '', '0', 'tongji', '删除统计数据');

-- ----------------------------
-- Table structure for ebcms5_config
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_config`;
CREATE TABLE `ebcms5_config` (
  `id` int(4) unsigned NOT NULL AUTO_INCREMENT COMMENT '配置ID',
  `group` varchar(255) NOT NULL DEFAULT '' COMMENT '分组',
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分类',
  `title` varchar(250) NOT NULL DEFAULT '' COMMENT '标题',
  `name` char(40) NOT NULL DEFAULT '' COMMENT '配置项',
  `value` text COMMENT '配置值',
  `render` varchar(255) NOT NULL DEFAULT '' COMMENT '类型',
  `form` varchar(255) NOT NULL DEFAULT '' COMMENT '表单类型',
  `config` text COMMENT '类型配置',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否允许用户配置',
  `remark` text COMMENT '说明',
  `sort` int(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1429 DEFAULT CHARSET=utf8 COMMENT='核心配置表';

-- ----------------------------
-- Records of ebcms5_config
-- ----------------------------
INSERT INTO `ebcms5_config` VALUES ('5', '系统配置@base', '1', '操作权限认证', 'auth_type', '1', 'number', 'form_radio', '{\"disabled\":\"0\",\"readonly\":\"0\",\"values\":\"\\u5b9e\\u65f6\\u8ba4\\u8bc1|1\\r\\n\\u767b\\u5f55\\u8ba4\\u8bc1|2\"}', '1', '实时认证更安全，登陆认证更高效', '80');
INSERT INTO `ebcms5_config` VALUES ('10', '邮箱配置@email', '1', '邮箱密码', 'password', 'zzeddixysnsnbhai', 'string', 'form_textbox', '', '1', '', '7');
INSERT INTO `ebcms5_config` VALUES ('11', '系统配置@base', '1', '操作日志记录', 'oplog_on', '1', 'bool', 'form_bool', '', '1', '', '1');
INSERT INTO `ebcms5_config` VALUES ('12', '邮箱配置@email', '1', '邮箱账号', 'name', 'market@ebcms.com', 'string', 'form_textbox', '', '1', '', '8');
INSERT INTO `ebcms5_config` VALUES ('13', '邮箱配置@email', '1', '发送者地址', 'from', 'market@ebcms.com', 'string', 'form_textbox', '', '1', '', '5');
INSERT INTO `ebcms5_config` VALUES ('14', '邮箱配置@email', '1', '发送者名称', 'fromname', '易贝科技', 'string', 'form_textbox', '', '1', '', '6');
INSERT INTO `ebcms5_config` VALUES ('15', '邮箱配置@email', '1', '服务器', 'host', 'smtp.qq.com', 'string', 'form_textbox', '', '1', '', '60');
INSERT INTO `ebcms5_config` VALUES ('16', '邮箱配置@email', '1', '端口', 'port', '25', 'string', 'form_textbox', '', '1', '', '9');
INSERT INTO `ebcms5_config` VALUES ('17', '邮箱配置@email', '1', 'SMTP验证', 'smtpauth', '1', 'bool', 'form_bool', '', '1', '', '4');
INSERT INTO `ebcms5_config` VALUES ('18', '邮箱配置@email', '1', '允许HTML', 'html', '1', 'bool', 'form_bool', '', '1', '', '3');
INSERT INTO `ebcms5_config` VALUES ('19', '系统配置@base', '1', '备份目录', 'backup_path', './backup', 'string', 'form_textbox', '', '1', '相对于入口文件 index.php 的目录，备份目录请设置为可读可写！', '1');
INSERT INTO `ebcms5_config` VALUES ('23', '编辑器@ueditor', '1', '编辑器配置', 'config', '{\r\n&quot;iframeCssUrl&quot;:&quot;/third/bootstrap/css/bootstrap.min.css&quot;,\r\n&quot;initialStyle&quot;:&quot;body{margin:15px;}&quot;\r\n}', 'json', 'form_multitextbox', '{\"required\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"height\":\"5\",\"width\":\"\",\"maxlength\":\"\",\"minlength\":\"\",\"prompt\":\"\"}', '1', '请参考百度编辑器的配置文档 ueditor.config.js', '50');
INSERT INTO `ebcms5_config` VALUES ('24', '编辑器@ueditor', '1', '编辑器上传配置', 'upload', '', 'json', 'form_multitextbox', '{\"required\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"height\":\"10\",\"width\":\"\",\"maxlength\":\"\",\"minlength\":\"\",\"prompt\":\"\"}', '1', '参考百度编辑器的配置文件：config.json', '9');
INSERT INTO `ebcms5_config` VALUES ('25', 'SEO配置@seo', '2', '网站名称', 'sitename', '易贝内容管理系统', 'string', 'form_textbox', '', '1', '定义浏览器顶部标签显示的文字。对SEO友好。\r\n首页：网站名称 + 网站标题\r\n其他页面：页面标题 + 网站名称', '90');
INSERT INTO `ebcms5_config` VALUES ('26', 'SEO配置@seo', '2', '网站标题', 'title', '易贝内容管理系统|免费的内容管理系统|EBCMS|phpcms', 'string', 'form_textbox', '{\"required\":\"0\",\"readonly\":\"0\",\"disabled\":\"0\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"prompt\":\"\"}', '1', '定义浏览器顶部标签显示的文字。对SEO友好。\r\n首页：网站名称 + 网站标题\r\n其他页面：页面标题 + 网站名称', '8');
INSERT INTO `ebcms5_config` VALUES ('27', 'SEO配置@seo', '2', '关键字', 'keywords', '易贝内容管理系统 内容管理系统 cms ebcms 开源cms', 'string', 'form_textbox', '', '1', '用空格或英文的逗号 , 分割。', '7');
INSERT INTO `ebcms5_config` VALUES ('28', 'SEO配置@seo', '2', '网站简介', 'description', '易贝内容管理系统是一套自由的功能灵活的开源的内容管理系统。', 'string', 'form_multitextbox', '', '1', '', '6');
INSERT INTO `ebcms5_config` VALUES ('1199', '基本配置@site', '2', '关闭网站', 'closed', '0', 'bool', 'form_bool', null, '1', '', '100');
INSERT INTO `ebcms5_config` VALUES ('1200', '基本配置@site', '2', '关闭原因', 'closed_reason', '系统维护中。。。', 'string', 'form_textbox', null, '1', '', '9');
INSERT INTO `ebcms5_config` VALUES ('1203', '验证码@captcha', '2', '加密密钥', 'seKey', 'http://www.ebcms.com', 'string', 'form_textbox', null, '0', '', '0');
INSERT INTO `ebcms5_config` VALUES ('1204', '验证码@captcha', '2', '字符', 'codeSet', '2345678abcdefhijkmnpqrstuvwxyzABCDEFGHJKLMNPQRTUVWXY', 'string', 'form_textbox', null, '1', '2345678abcdefhijkmnpqrstuvwxyzABCDEFGHJKLMNPQRTUVWXY', '28');
INSERT INTO `ebcms5_config` VALUES ('1205', '验证码@captcha', '2', '有效期', 'expire', '18000', 'number', 'form_numberbox', null, '0', '', '6');
INSERT INTO `ebcms5_config` VALUES ('1206', '验证码@captcha', '2', '是否使用中文', 'useZh', '1', 'bool', 'form_bool', null, '1', '', '26');
INSERT INTO `ebcms5_config` VALUES ('1207', '验证码@captcha', '2', '中文字符', 'zhSet', 'ABCDEFGHJKLMNPQRTUVWXY磷燃穗藏薄潮爆谬障霸腾燥趋墨龄骗', 'string', 'form_multitextbox', null, '1', '', '24');
INSERT INTO `ebcms5_config` VALUES ('1208', '验证码@captcha', '2', '背景混淆', 'useImgBg', '1', 'bool', 'form_bool', null, '1', '', '18');
INSERT INTO `ebcms5_config` VALUES ('1209', '验证码@captcha', '2', '字体大小', 'fontSize', '25', 'number', 'form_numberbox', null, '0', '', '16');
INSERT INTO `ebcms5_config` VALUES ('1210', '验证码@captcha', '2', '曲线混淆', 'useCurve', '1', 'bool', 'form_bool', null, '1', '', '22');
INSERT INTO `ebcms5_config` VALUES ('1211', '验证码@captcha', '2', '杂点混淆', 'useNoise', '1', 'bool', 'form_bool', null, '1', '', '20');
INSERT INTO `ebcms5_config` VALUES ('1212', '验证码@captcha', '2', '图片高', 'imageH', '0', 'number', 'form_numberbox', null, '0', '', '14');
INSERT INTO `ebcms5_config` VALUES ('1213', '验证码@captcha', '2', '图片宽', 'imageW', '0', 'number', 'form_numberbox', null, '0', '', '12');
INSERT INTO `ebcms5_config` VALUES ('1214', '验证码@captcha', '2', '字符数', 'length', '4', 'number', 'form_numberbox', null, '1', '', '30');
INSERT INTO `ebcms5_config` VALUES ('1215', '验证码@captcha', '2', '字体', 'fontttf', '', 'string', 'form_textbox', null, '0', '', '10');
INSERT INTO `ebcms5_config` VALUES ('1216', '验证码@captcha', '2', '背景色', 'bg', '243\r\n251\r\n254', 'item', 'form_multitextbox', null, '0', 'rgb色  一行一个。\r\n243\r\n251\r\n254', '8');
INSERT INTO `ebcms5_config` VALUES ('1217', '验证码@captcha', '2', '验证重置', 'reset', '1', 'bool', 'form_bool', null, '0', '', '0');
INSERT INTO `ebcms5_config` VALUES ('1377', '路由配置@route', '2', '路由模式', 'model', '1', 'number', 'form_radio', '{\"values\":\"普通模式|0\\r\\n应用模式|1\"}', '1', '', '50');
INSERT INTO `ebcms5_config` VALUES ('1378', '路由配置@route', '2', '自定义路由', 'rules', '/|index/index/index\r\nuser_reg|user/auth/reg\r\nuser_login|user/auth/login', 'string', 'form_multitextbox', '{\"height\":\"15\",\"width\":\"\",\"prompt\":\"\"}', '1', '非专业人士，请不要随意定义，否则可能导致无法访问！\r\n用竖线分割 一行一个，例如：\r\nuser_reg|user/auth/reg\r\nuser_login|user/auth/login', '0');
INSERT INTO `ebcms5_config` VALUES ('1418', '基本配置@site', '2', '手机版', 'mobile', '0', 'bool', 'form_bool', null, '1', '开启手机版后，手机访问会自动定位到 当前模板主题对应的移动端模板 例如：default_mobile', '7');
INSERT INTO `ebcms5_config` VALUES ('1419', '基本配置@site', '2', '模板主题', 'theme', 'qiye', 'string', 'form_custom', '{\"html\":\"{php}\\r\\n\\t$path = ROOT_PATH . \'templates\' . DS;\\r\\n\\t$dirs = scandir($path);\\r\\n\\t$res = [];\\r\\n\\t$thumbs = [];\\r\\n\\tforeach($dirs as $k){\\r\\n\\t\\tif(!in_array($k,[\'.\',\'..\']) &amp;&amp; !preg_match(&quot;\\/[\\\\x7f-\\\\xff]\\/&quot;, $k) &amp;&amp; is_dir($path . $k)){\\r\\n\\t\\t\\tif(\'_mobile\' != substr($k,-7)){\\r\\n\\t\\t\\t\\t$res[] = $k;\\r\\n\\t\\t\\t\\t$thumb = $path . $k . DS . \'thumb.png\';\\r\\n\\t\\t\\t\\t$thumb = is_file($thumb)?$thumb:\'.\\/system\\/image\\/nopic.gif\';\\r\\n\\t\\t\\t\\t$img_info = getimagesize($thumb);\\r\\n\\t\\t\\t\\t$thumbs[$k] = \'data:\' . $img_info[\'mime\'] . \';base64,\' . base64_encode(file_get_contents($thumb));\\r\\n\\t\\t\\t}\\r\\n\\t\\t}\\r\\n\\t}\\r\\n{\\/php}\\r\\n&lt;div style=&quot;clear: both;overflow: hidden;&quot;&gt;\\r\\n{foreach name=\'res\' item=\'v\'}\\r\\n\\t&lt;div class=&quot;thumbnail&quot; onclick=&quot;$(this).css(\'border\', \'1px solid red\').siblings().css(\'border\', \'1px solid #ddd\');$(\'#{$field.unique}\').val(\'{$v}\');&quot; style=&quot;width:13em;float:left;cursor: pointer; margin-right:10px;{eq name=&quot;field.value&quot; value=\'$v\'}border:1px solid red;{\\/eq}&quot;&gt;\\r\\n\\t\\t&lt;img src=&quot;{$thumbs[$v]}&quot; alt=&quot;{$v}&quot; style=&quot;width: 100%;height: 10em;&quot;&gt;\\r\\n\\t\\t&lt;div class=&quot;caption&quot;&gt;\\r\\n\\t\\t\\t&lt;h4 class=&quot;text-center&quot;&gt;{$v}&lt;\\/h4&gt;\\r\\n\\t\\t&lt;\\/div&gt;\\r\\n\\t&lt;\\/div&gt;\\r\\n{\\/foreach}\\r\\n&lt;\\/div&gt;\\r\\n&lt;input type=&quot;hidden&quot; name=&quot;{$field.field}&quot; id=&quot;{$field.unique}&quot; value=&quot;{$field.value}&quot;&gt;\"}', '1', '模板位于templates目录下', '8');
INSERT INTO `ebcms5_config` VALUES ('1420', '常规配置', '3', 'URL模式', 'url_model', '2', 'number', 'form_radio', '{\"disabled\":\"0\",\"readonly\":\"0\",\"values\":\"普通模式|0\\r\\n标准模式|1\\r\\n高级模式|2\"}', '1', '普通模式不走路由，标准模式是常规路由，高级模式支持自定义文件夹和文件名。', '30');
INSERT INTO `ebcms5_config` VALUES ('1421', '常规配置', '3', '是否记录点击', 'click_record', '1', 'bool', 'form_bool', null, '1', '', '9');
INSERT INTO `ebcms5_config` VALUES ('1422', '常规配置', '3', '内容属性', 'attr', '轮播\r\n推荐\r\n推荐产品\r\n请在设置中心设置默认数据', 'item', 'form_multitextbox', null, '1', '', '0');
INSERT INTO `ebcms5_config` VALUES ('1423', '友情链接', '4', '开启验证码', 'captcha', '1', 'bool', 'form_bool', null, '1', '', '2');
INSERT INTO `ebcms5_config` VALUES ('1424', '友情链接', '4', '开启在线申请', 'apply', '1', 'bool', 'form_bool', null, '1', '', '1');
INSERT INTO `ebcms5_config` VALUES ('1425', '基本配置', '5', '是否开启验证码', 'verify', '1', 'bool', 'form_bool', null, '1', '', '0');
INSERT INTO `ebcms5_config` VALUES ('1426', '基本配置', '5', '是否需要审核', 'check_on', '1', 'bool', 'form_bool', null, '1', '', '0');
INSERT INTO `ebcms5_config` VALUES ('1427', '基本配置', '5', '通知邮箱', 'notice_email', '', 'string', 'form_textbox', null, '1', '有新留言的时候，会自动发送消息通知到该邮箱！', '0');
INSERT INTO `ebcms5_config` VALUES ('1428', '基本配置', '6', '是否开启', 'on', '1', 'bool', 'form_bool', null, '1', '', '0');

-- ----------------------------
-- Table structure for ebcms5_configcate
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_configcate`;
CREATE TABLE `ebcms5_configcate` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `group` varchar(255) NOT NULL DEFAULT '' COMMENT '分组',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '名称',
  `name` varchar(255) NOT NULL DEFAULT 'Common' COMMENT '生效应用',
  `remark` varchar(255) NOT NULL DEFAULT '' COMMENT '说明',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否允许用户配置',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `app` varchar(255) NOT NULL DEFAULT '' COMMENT '应用',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='核心配置分类表';

-- ----------------------------
-- Records of ebcms5_configcate
-- ----------------------------
INSERT INTO `ebcms5_configcate` VALUES ('1', '系统配置', '系统配置', 'system', '', '1', '90', 'ebcms');
INSERT INTO `ebcms5_configcate` VALUES ('2', '应用配置', '前台配置', 'home', '', '1', '85', 'ebcms');
INSERT INTO `ebcms5_configcate` VALUES ('3', '应用配置', '企业网站管理系统', 'content', '', '1', '1', 'content');
INSERT INTO `ebcms5_configcate` VALUES ('4', '应用配置', '友情链接', 'link', '', '1', '2', 'link');
INSERT INTO `ebcms5_configcate` VALUES ('5', '应用配置', '在线留言', 'guestbook', '', '1', '0', 'guestbook');
INSERT INTO `ebcms5_configcate` VALUES ('6', '应用配置', '访客统计', 'tongji', '', '1', '0', 'tongji');

-- ----------------------------
-- Table structure for ebcms5_content_attr
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_content_attr`;
CREATE TABLE `ebcms5_content_attr` (
  `content_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '内容ID',
  `attr` varchar(255) NOT NULL DEFAULT '' COMMENT '属性',
  `sort` int(10) unsigned DEFAULT '0' COMMENT '排序'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='内容属性表';

-- ----------------------------
-- Records of ebcms5_content_attr
-- ----------------------------

-- ----------------------------
-- Table structure for ebcms5_content_body
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_content_body`;
CREATE TABLE `ebcms5_content_body` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `body` text COMMENT '内容主体',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='内容副表';

-- ----------------------------
-- Records of ebcms5_content_body
-- ----------------------------

-- ----------------------------
-- Table structure for ebcms5_content_channel
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_content_channel`;
CREATE TABLE `ebcms5_content_channel` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `type` varchar(255) NOT NULL DEFAULT '' COMMENT '类型',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父ID',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '名称',
  `eb_metatitle` varchar(255) NOT NULL DEFAULT '' COMMENT 'meta标题',
  `keywords` varchar(255) NOT NULL DEFAULT '' COMMENT '关键字',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT '简介',
  `extend_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '扩展id',
  `tpl` varchar(255) NOT NULL DEFAULT '' COMMENT '模板',
  `tpl_detail` varchar(255) NOT NULL DEFAULT '' COMMENT '内容页模板',
  `eb_url` varchar(255) NOT NULL DEFAULT '' COMMENT '外部链接',
  `eb_ext` text COMMENT '扩展信息',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '状态',
  `nav` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '导航显示',
  `target` varchar(255) NOT NULL DEFAULT '' COMMENT '打开方式',
  `body` text COMMENT '内容',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COMMENT='内容栏目表';

-- ----------------------------
-- Records of ebcms5_content_channel
-- ----------------------------
INSERT INTO `ebcms5_content_channel` VALUES ('1', 'page', '0', '公司简介', 'company', '', '华为公司简介', '', '0', '', '', '', '{\"logo\":\"http:\\/\\/static.ebcms.com\\/img\\/huawei.jpg\",\"__config__\":{\"logo\":\"file\",\"__test__\":\"test\"}}', '1499652938', '1482486632', '0', '1', '1', '_self', '&lt;p&gt;华为是全球领先的信息与通信技术( ICT)解决方案供应商，专注于ICT领域，坚持稳健经营、持续创新、开放合 作，在电信运营商、企业、终端和云计算等领域构筑了端到端的解决方案优势，为运营商客户、企业客户和消 费者提供有竞争力的ICT解决方案、 产品和服务， 并致力于使能未来信息社会、 构建更美好的全联接世界。 目 前，华为有17万多名员工，业务遍及全球170多个国家和地区，服务全世界三分之一以上的人口。&lt;/p&gt;&lt;p&gt;&lt;strong&gt;我们为世界带来了什么？&lt;/strong&gt;&lt;/p&gt;&lt;p&gt;为客户创造价值。华为和运营商一起，在全球建设了1,500多张网络，帮助世界超过三分之一的人口实现联接。 华为和企业客户一起，以开放的云计算和敏捷的企业网络，助力平安城市、金融、交通、能源等领域实现高效运 营和敏捷创新。华为智能终端和智能手机，正在帮助人们享受高品质的数字工作、生活和娱乐体验。&lt;/p&gt;');
INSERT INTO `ebcms5_content_channel` VALUES ('2', 'page', '0', '联系我们', 'contactus', '', '', '', '0', '', '', '', '{\"__config__\":{\"__test__\":\"test\"}}', '1499652970', '1482486665', '0', '1', '1', '_self', '&lt;p style=&quot;white-space: normal;&quot;&gt;&lt;img width=&quot;530&quot; height=&quot;340&quot; src=&quot;http://api.map.baidu.com/staticimage?center=104.125554,30.548496&amp;zoom=10&amp;width=530&amp;height=340&amp;markers=104.114056,30.444936&quot;/&gt;&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;地址：成都高新区环球中心A座13楼&lt;br/&gt;&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;电话：18000534006&lt;/p&gt;');
INSERT INTO `ebcms5_content_channel` VALUES ('3', 'channel', '0', '新闻中心', 'news', '', '', '', '0', '', '', '', '{\"__config__\":{\"__test__\":\"test\"}}', '1482576897', '1482486691', '0', '1', '1', '_self', '');
INSERT INTO `ebcms5_content_channel` VALUES ('4', 'channel', '3', '公司新闻', 'company', '', '', '', '0', '', '', '', '{\"__config__\":{\"__test__\":\"test\"}}', '1482504751', '1482486716', '0', '1', '1', '_self', '');
INSERT INTO `ebcms5_content_channel` VALUES ('5', 'channel', '3', '行业新闻', 'hangye', '', '', '', '0', '', '', '', '{\"__config__\":{\"__test__\":\"test\"}}', '1482504756', '1482486728', '0', '1', '1', '_self', '');
INSERT INTO `ebcms5_content_channel` VALUES ('6', 'page', '0', '人才招聘', 'jobs', '', '', '', '0', '', '', '', '{\"__config__\":{\"__test__\":\"test\"}}', '1482504763', '1482486762', '0', '1', '1', '_self', '&lt;p&gt;&lt;span style=&quot;color: rgb(51, 51, 51); font-family: &amp;quot;Helvetica Neue&amp;quot;, Helvetica, Arial, sans-serif; font-size: 14px; background-color: rgb(255, 255, 255);&quot;&gt;人才招聘&lt;/span&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_channel` VALUES ('8', 'channel', '0', '公告', 'gonggao', '', '', '', '0', '', '', '', '{\"__config__\":{\"__test__\":\"test\"}}', '1482504781', '1482498249', '0', '1', '0', '_self', '');
INSERT INTO `ebcms5_content_channel` VALUES ('9', 'page', '0', '联系方式', 'lxfs', '', '', '', '0', '', '', '', '{\"__config__\":{\"__test__\":\"test\"}}', '1482504786', '1482498932', '0', '1', '0', '_self', '&lt;p&gt;&lt;img src=&quot;http://static.ebcms.com/img/lxwm.jpg&quot; class=&quot;img-responsive&quot; title=&quot;联系我们&quot; alt=&quot;联系我们&quot;/&gt;&lt;/p&gt;&lt;p&gt;地址：成都高新区环球中心A座13楼&lt;br/&gt;&lt;/p&gt;&lt;p&gt;电话：18000534006&lt;/p&gt;');
INSERT INTO `ebcms5_content_channel` VALUES ('10', 'channel', '0', '产品中心', 'product', '', '', '', '0', '', '', '', '{\"__config__\":{\"__test__\":\"test\"}}', '1482585725', '1482585725', '0', '1', '0', '_self', null);
INSERT INTO `ebcms5_content_channel` VALUES ('11', 'jump', '0', '在线留言', '', '', '', '', '0', '', '', 'guestbook/index/index', null, '1499653142', '1499653142', '0', '1', '1', '_self', null);

-- ----------------------------
-- Table structure for ebcms5_content_content
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_content_content`;
CREATE TABLE `ebcms5_content_content` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `channel_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分类id',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `eb_shorttitle` varchar(255) NOT NULL DEFAULT '' COMMENT '短标题',
  `eb_metatitle` varchar(255) NOT NULL DEFAULT '' COMMENT 'META标题',
  `keywords` varchar(255) NOT NULL DEFAULT '' COMMENT '关键字',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT '简介',
  `thumb` varchar(255) NOT NULL DEFAULT '' COMMENT '缩略图',
  `tpl` varchar(255) NOT NULL DEFAULT '' COMMENT '模板',
  `eb_url` varchar(255) NOT NULL DEFAULT '' COMMENT '外部链接',
  `filename` varchar(255) NOT NULL DEFAULT '' COMMENT '文件名称',
  `ext` text COMMENT '扩展信息',
  `click` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '点击量',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '99' COMMENT '状态',
  `eb_style` varchar(255) NOT NULL DEFAULT '' COMMENT '样式',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  PRIMARY KEY (`id`),
  KEY `list` (`channel_id`,`status`,`id`),
  KEY `list2` (`status`,`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='内容基本表';

-- ----------------------------
-- Records of ebcms5_content_content
-- ----------------------------

-- ----------------------------
-- Table structure for ebcms5_content_tag
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_content_tag`;
CREATE TABLE `ebcms5_content_tag` (
  `content_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '内容ID',
  `tag` varchar(255) NOT NULL DEFAULT '' COMMENT '属性'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='内容属性表';

-- ----------------------------
-- Records of ebcms5_content_tag
-- ----------------------------

-- ----------------------------
-- Table structure for ebcms5_extend
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_extend`;
CREATE TABLE `ebcms5_extend` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `group` varchar(255) NOT NULL DEFAULT '' COMMENT '分组',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `remark` varchar(255) NOT NULL DEFAULT '' COMMENT '说明',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  `app` varchar(255) DEFAULT '' COMMENT '应用',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='扩展表';

-- ----------------------------
-- Records of ebcms5_extend
-- ----------------------------

-- ----------------------------
-- Table structure for ebcms5_extendfield
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_extendfield`;
CREATE TABLE `ebcms5_extendfield` (
  `id` int(4) unsigned NOT NULL AUTO_INCREMENT COMMENT '配置ID',
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分类',
  `group` varchar(250) NOT NULL DEFAULT '' COMMENT '分组',
  `title` varchar(250) NOT NULL DEFAULT '' COMMENT '标题',
  `name` char(40) NOT NULL DEFAULT '' COMMENT '键',
  `value` text COMMENT '默认值',
  `type` varchar(255) NOT NULL DEFAULT '' COMMENT '表单类型',
  `config` text COMMENT '表单配置',
  `remark` text COMMENT '表单说明',
  `sort` int(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='扩展字段表';

-- ----------------------------
-- Records of ebcms5_extendfield
-- ----------------------------

-- ----------------------------
-- Table structure for ebcms5_form
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_form`;
CREATE TABLE `ebcms5_form` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `group` varchar(255) NOT NULL DEFAULT '' COMMENT '分组',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '名称',
  `remark` varchar(255) NOT NULL DEFAULT '' COMMENT '说明',
  `sort` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `html` text COMMENT '模板',
  `app` varchar(255) NOT NULL DEFAULT '' COMMENT '应用',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3188 DEFAULT CHARSET=utf8 COMMENT='表单表';

-- ----------------------------
-- Records of ebcms5_form
-- ----------------------------
INSERT INTO `ebcms5_form` VALUES ('1', '表单配置', '单行文本', 'form_textbox', '', '100', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('2', '表单配置', '布尔选项', 'form_bool', '', '56', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('3', '表单配置', '隐藏域', 'form_hidden', '', '1', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('4', '表单配置', '百度编辑器', 'form_ueditor', '', '86', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('5', '表单配置', '数字框', 'form_numberbox', '', '91', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('6', '表单配置', '上传', 'form_upload', '', '69', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('9', '表单配置', '多文件上传', 'form_uploads', '', '62', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('13', '表单配置', '数据库', 'form_database', '', '45', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('14', '表单配置', '多行文本', 'form_multitextbox', '', '97', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('18', '账户管理', '添加角色', 'ebcms_group_add', '', '66', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('19', '账户管理', '修改角色', 'ebcms_group_edit', '', '56', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('20', '账户管理', '添加账户', 'ebcms_manager_add', '', '136', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('21', '账户管理', '编辑账户', 'ebcms_manager_edit', '', '75', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('22', '扩展管理', '添加扩展', 'ebcms_extend_add', '', '141', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('23', '扩展管理', '修改扩展', 'ebcms_extend_edit', '', '71', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('24', '扩展管理', '添加字段', 'ebcms_extendfield_add', '', '60', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('25', '扩展管理', '修改字段', 'ebcms_extendfield_edit', '', '1', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('26', '表单配置', '单选', 'form_radio', '', '72', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('27', '表单配置', '复选', 'form_checkbox', '', '71', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('32', '基本表单', '修改自己密码', 'ebcms_index_password', '', '90', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('33', '表单配置', '下拉选项', 'form_select', '', '44', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('411', '导航管理', '添加导航', 'ebcms_nav_add', '', '160', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('412', '导航管理', '编辑导航', 'ebcms_nav_edit', '', '0', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('1444', '基本表单', '发送邮件', 'ebcms_index_email', '', '110', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('1497', '表单配置', '自定义', 'form_custom', '', '0', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('2542', '账户管理', '分配权限', 'ebcms_group_rule', '', '0', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('2543', '账户管理', '菜单权限', 'ebcms_group_menu', '', '0', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('2544', '账户管理', '重置密码', 'ebcms_manager_password', '', '0', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('2545', '账户管理', '分配角色', 'ebcms_manager_group', '', '0', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('2546', '基本表单', '应用卸载', 'ebcms_app_uninstall', '', '1', '', 'ebcms');
INSERT INTO `ebcms5_form` VALUES ('3173', '内容管理', '添加单页', 'content_admin.channel_add_page', '', '350', '', 'content');
INSERT INTO `ebcms5_form` VALUES ('3174', '内容管理', '编辑跳转', 'content_admin.channel_edit_jump', '', '49', '', 'content');
INSERT INTO `ebcms5_form` VALUES ('3175', '内容管理', '编辑单页', 'content_admin.channel_edit_page', '', '49', '', 'content');
INSERT INTO `ebcms5_form` VALUES ('3176', '内容管理', '修改内容', 'content_admin.content_edit', '', '38', null, 'content');
INSERT INTO `ebcms5_form` VALUES ('3177', '内容管理', '内容批量移动', 'content_admin.content_move', '', '37', null, 'content');
INSERT INTO `ebcms5_form` VALUES ('3178', '内容管理', '编辑栏目', 'content_admin.channel_edit_channel', '', '49', '', 'content');
INSERT INTO `ebcms5_form` VALUES ('3179', '内容管理', '添加跳转', 'content_admin.channel_add_jump', '', '350', '', 'content');
INSERT INTO `ebcms5_form` VALUES ('3180', '内容管理', '添加内容', 'content_admin.content_add', '', '39', null, 'content');
INSERT INTO `ebcms5_form` VALUES ('3181', '内容管理', '添加栏目', 'content_admin.channel_add_channel', '', '350', '', 'content');
INSERT INTO `ebcms5_form` VALUES ('3182', '友情链接', '添加', 'link_admin.link_add', '', '220', null, 'link');
INSERT INTO `ebcms5_form` VALUES ('3183', '友情链接', '编辑', 'link_admin.link_edit', '', '0', null, 'link');
INSERT INTO `ebcms5_form` VALUES ('3184', '在线留言', '编辑留言', 'guestbook_admin.guestbook_edit', '', '300', null, 'guestbook');
INSERT INTO `ebcms5_form` VALUES ('3185', '在线留言', '回复留言', 'guestbook_admin.guestbook_reply', '', '0', null, 'guestbook');
INSERT INTO `ebcms5_form` VALUES ('3186', '模板助手', '添加', 'mbzs_mbzs_add', '', '300', '', 'mbzs');
INSERT INTO `ebcms5_form` VALUES ('3187', '模板助手', '编辑', 'mbzs_mbzs_edit', '', '3', '', 'mbzs');

-- ----------------------------
-- Table structure for ebcms5_formfield
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_formfield`;
CREATE TABLE `ebcms5_formfield` (
  `id` int(4) unsigned NOT NULL AUTO_INCREMENT COMMENT '配置ID',
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分类',
  `group` varchar(250) NOT NULL DEFAULT '' COMMENT '分组',
  `title` varchar(250) NOT NULL DEFAULT '' COMMENT '标题',
  `name` char(40) NOT NULL DEFAULT '' COMMENT '键',
  `subtable` varchar(250) NOT NULL DEFAULT '' COMMENT '副表',
  `extfield` varchar(250) NOT NULL DEFAULT '' COMMENT '扩展字段',
  `defaultvaluetype` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '取值类型',
  `defaultvalue` text COMMENT '默认值',
  `type` varchar(255) NOT NULL DEFAULT '' COMMENT '表单类型',
  `config` text COMMENT '表单配置',
  `remark` text COMMENT '表单说明',
  `sort` int(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=22485 DEFAULT CHARSET=utf8 COMMENT='表单字段表';

-- ----------------------------
-- Records of ebcms5_formfield
-- ----------------------------
INSERT INTO `ebcms5_formfield` VALUES ('2', '1', '基本配置', '是否只读', 'readonly', '', 'config', '3', 'readonly', 'form_bool', 'null', '', '40');
INSERT INTO `ebcms5_formfield` VALUES ('3', '1', '基本配置', '是否失效', 'disabled', '', 'config', '3', 'disabled', 'form_bool', 'null', '', '38');
INSERT INTO `ebcms5_formfield` VALUES ('7', '1', '基本配置', '提示字符', 'prompt', '', 'config', '3', 'prompt', 'form_textbox', '{\"width\":\"\",\"prompt\":\"\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"required\":\"0\"}', '', '5');
INSERT INTO `ebcms5_formfield` VALUES ('8', '1', '基本配置', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('9', '2', '基本配置', '是否失效', 'disabled', '', 'config', '3', 'disabled', 'form_bool', 'null', '', '50');
INSERT INTO `ebcms5_formfield` VALUES ('10', '2', '基本配置', '是否只读', 'readonly', '', 'config', '3', 'readonly', 'form_bool', 'null', '', '40');
INSERT INTO `ebcms5_formfield` VALUES ('11', '2', '基本配置', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('12', '3', '基本配置', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('13', '4', '基本配置', '高度', 'initialframeheight', '', 'config', '3', 'initialframeheight', 'form_numberbox', 'null', '', '50');
INSERT INTO `ebcms5_formfield` VALUES ('14', '4', '基本配置', '自动高度', 'autoheightenabled', '', 'config', '3', 'autoheightenabled', 'form_bool', 'null', '', '45');
INSERT INTO `ebcms5_formfield` VALUES ('15', '4', '基本配置', '最大字符数', 'maximumwords', '', 'config', '3', 'maximumwords', 'form_numberbox', '{\"required\":\"0\",\"editable\":\"1\",\"readonly\":\"0\",\"max\":\"\",\"min\":\"\",\"prompt\":\"\",\"disabled\":\"0\",\"width\":\"\",\"prefix\":\"\",\"suffix\":\"\",\"groupseparator\":\"\",\"decimalseparator\":\"\",\"precision\":\"\"}', '', '40');
INSERT INTO `ebcms5_formfield` VALUES ('16', '4', '基本配置', '开启字数统计', 'wordcount', '', 'config', '3', 'wordcount', 'form_bool', 'null', '', '30');
INSERT INTO `ebcms5_formfield` VALUES ('17', '4', '基本配置', '显示元素路径', 'elementpathenabled', '', 'config', '3', 'elementpathenabled', 'form_bool', 'null', '', '20');
INSERT INTO `ebcms5_formfield` VALUES ('18', '4', '基本配置', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('20', '5', '基本配置', '是否失效', 'disabled', '', 'config', '3', 'disabled', 'form_bool', 'null', '', '40');
INSERT INTO `ebcms5_formfield` VALUES ('21', '5', '基本配置', '是否只读', 'readonly', '', 'config', '3', 'readonly', 'form_bool', 'null', '', '38');
INSERT INTO `ebcms5_formfield` VALUES ('22', '5', '基本配置', '最大值', 'max', '', 'config', '3', 'max', 'form_numberbox', 'null', '', '30');
INSERT INTO `ebcms5_formfield` VALUES ('23', '5', '基本配置', '最小值', 'min', '', 'config', '3', 'min', 'form_numberbox', 'null', '', '25');
INSERT INTO `ebcms5_formfield` VALUES ('24', '5', '基本配置', '提示信息', 'prompt', '', 'config', '3', 'prompt', 'form_textbox', 'null', '', '15');
INSERT INTO `ebcms5_formfield` VALUES ('25', '5', '基本配置', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('29', '6', '基本配置', '允许的类型', 'extensions', '', 'config', '3', 'extensions', 'form_textbox', 'null', '多个类型用‘,’分割，例如：jpg,png,gif,bmp', '40');
INSERT INTO `ebcms5_formfield` VALUES ('30', '6', '基本配置', '提示信息', 'prompt', '', 'config', '3', 'prompt', 'form_textbox', 'null', '', '20');
INSERT INTO `ebcms5_formfield` VALUES ('31', '6', '基本配置', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('47', '9', '基本配置', '允许的类型', 'extensions', '', 'config', '3', 'extensions', 'form_textbox', 'null', '多个类型用‘,’分割，例如：jpg,png,gif,bmp', '40');
INSERT INTO `ebcms5_formfield` VALUES ('48', '9', '基本配置', '提示字符', 'prompt', '', 'config', '3', 'prompt', 'form_textbox', 'null', '', '20');
INSERT INTO `ebcms5_formfield` VALUES ('49', '9', '基本配置', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('66', '13', '基本配置', '模型名称', 'model', '', 'config', '3', 'model', 'form_textbox', '{\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\"}', '对应的后台的模型名称', '50');
INSERT INTO `ebcms5_formfield` VALUES ('67', '13', '基本配置', '是否可编辑', 'editable', '', 'config', '3', 'editable', 'form_bool', 'null', '可编辑是指下拉选项只是作为辅助选项，实际上还是一个文本框', '48');
INSERT INTO `ebcms5_formfield` VALUES ('69', '13', '基本配置', '是否失效', 'disabled', '', 'config', '3', 'disabled', 'form_bool', 'null', '', '43');
INSERT INTO `ebcms5_formfield` VALUES ('70', '13', '基本配置', '是否只读', 'readonly', '', 'config', '3', 'readonly', 'form_bool', 'null', '', '42');
INSERT INTO `ebcms5_formfield` VALUES ('71', '13', '基本配置', '根选项', 'rootitem', '', 'config', '3', 'rootitem', 'form_bool', 'null', '根选项开启后 所有条目都会在根选项之下，通常用于选择父级 默认0', '40');
INSERT INTO `ebcms5_formfield` VALUES ('72', '13', '其他配置', '查询条件', 'queryparams', '', 'config', '3', 'queryparams', 'form_multitextbox', 'null', '格式：字段|eq|value\r\n字段|eq|(I)value 添加(I)表示的是提交变量\r\n字段|eq|(@)value 添加(@)表示的是变量', '40');
INSERT INTO `ebcms5_formfield` VALUES ('73', '13', '基本配置', '树型化', 'tree', '', 'config', '3', 'tree', 'form_bool', 'null', '', '30');
INSERT INTO `ebcms5_formfield` VALUES ('74', '13', '其他配置', '递归字段', 'pid', '', 'config', '3', 'pid', 'form_textbox', 'null', '通常请不要修改 默认pid', '30');
INSERT INTO `ebcms5_formfield` VALUES ('75', '13', '基本配置', '提示字符', 'prompt', '', 'config', '3', 'prompt', 'form_textbox', 'null', '', '10');
INSERT INTO `ebcms5_formfield` VALUES ('76', '13', '其他配置', '显示字段', 'titlefield', '', 'config', '3', 'titlefield', 'form_textbox', 'null', '默认为text', '9');
INSERT INTO `ebcms5_formfield` VALUES ('77', '13', '其他配置', '值字段', 'valuefield', '', 'config', '3', 'valuefield', 'form_textbox', 'null', '默认为id', '6');
INSERT INTO `ebcms5_formfield` VALUES ('78', '13', '基本配置', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('79', '13', '其他配置', '宽度', 'width', '', 'config', '3', 'width', 'form_numberbox', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('81', '14', '基本配置', '是否失效', 'disabled', '', 'config', '3', 'disabled', 'form_bool', 'null', '', '45');
INSERT INTO `ebcms5_formfield` VALUES ('82', '14', '基本配置', '是否只读', 'readonly', '', 'config', '3', 'readonly', 'form_bool', 'null', '', '40');
INSERT INTO `ebcms5_formfield` VALUES ('83', '14', '基本配置', '高度', 'height', '', 'config', '3', 'height', 'form_numberbox', 'null', '这里是指行数。默认5', '31');
INSERT INTO `ebcms5_formfield` VALUES ('84', '14', '基本配置', '宽度', 'width', '', 'config', '3', 'width', 'form_numberbox', 'null', '不填写表示 100% ', '30');
INSERT INTO `ebcms5_formfield` VALUES ('87', '14', '基本配置', '提示字符', 'prompt', '', 'config', '3', 'prompt', 'form_textbox', '{\"width\":\"\",\"prompt\":\"\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"required\":\"0\"}', '', '15');
INSERT INTO `ebcms5_formfield` VALUES ('88', '14', '基本配置', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('104', '18', '基本信息', '分组', 'group', '', '', '1', 'group', 'form_textbox', '{\"disabled\":\"0\",\"values\":\"系统|系统\\r\\n普通|普通\"}', '', '99');
INSERT INTO `ebcms5_formfield` VALUES ('106', '18', '基本信息', '名称', 'title', '', '', '0', '', 'form_textbox', 'null', '', '91');
INSERT INTO `ebcms5_formfield` VALUES ('107', '18', '基本信息', '备注', 'remark', '', '', '0', '', 'form_multitextbox', 'null', '', '10');
INSERT INTO `ebcms5_formfield` VALUES ('109', '19', '基本信息', '分组', 'group', '', '', '3', 'group', 'form_textbox', '{\"disabled\":\"0\",\"values\":\"系统|系统\\r\\n普通|普通\"}', '', '99');
INSERT INTO `ebcms5_formfield` VALUES ('110', '19', '基本信息', '名称', 'title', '', '', '3', 'title', 'form_textbox', 'null', '', '82');
INSERT INTO `ebcms5_formfield` VALUES ('111', '19', '基本信息', '备注', 'remark', '', '', '3', 'remark', 'form_multitextbox', 'null', '', '20');
INSERT INTO `ebcms5_formfield` VALUES ('112', '19', '基本信息', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '10');
INSERT INTO `ebcms5_formfield` VALUES ('113', '20', '基本信息', '邮箱', 'email', '', '', '0', '', 'form_textbox', 'null', '', '99');
INSERT INTO `ebcms5_formfield` VALUES ('114', '20', '基本信息', '昵称', 'nickname', '', '', '0', '', 'form_textbox', '{\"width\":\"\",\"prompt\":\"2-6个字符\",\"maxlength\":\"6\",\"minlength\":\"2\",\"validtype\":\"\",\"required\":\"1\",\"editable\":\"1\",\"disabled\":\"0\",\"readonly\":\"0\"}', '', '50');
INSERT INTO `ebcms5_formfield` VALUES ('115', '20', '基本信息', '密码', 'password', '', '', '0', '', 'form_textbox', '{\"width\":\"\",\"prompt\":\"5-10个字符\",\"maxlength\":\"10\",\"minlength\":\"5\",\"validtype\":\"\",\"required\":\"1\",\"editable\":\"1\",\"disabled\":\"0\",\"readonly\":\"0\"}', '', '40');
INSERT INTO `ebcms5_formfield` VALUES ('116', '20', '基本信息', '头像', 'avatar', '', '', '0', '', 'form_upload', '{\"extensions\":\"\",\"path\":\"\\/manager\\/avatar\",\"prompt\":\"\"}', '', '30');
INSERT INTO `ebcms5_formfield` VALUES ('119', '21', '基本信息', '邮箱', 'email', '', '', '3', 'email', 'form_textbox', 'null', '', '90');
INSERT INTO `ebcms5_formfield` VALUES ('120', '21', '基本信息', '昵称', 'nickname', '', '', '3', 'nickname', 'form_textbox', '{\"width\":\"\",\"prompt\":\"\",\"maxlength\":\"6\",\"minlength\":\"2\",\"validtype\":\"\",\"required\":\"1\",\"editable\":\"1\",\"disabled\":\"0\",\"readonly\":\"0\"}', '', '40');
INSERT INTO `ebcms5_formfield` VALUES ('121', '21', '基本信息', '头像', 'avatar', '', '', '3', 'avatar', 'form_upload', '{\"disabled\":\"0\",\"readonly\":\"0\",\"extensions\":\"\",\"path\":\"\\/manager\\/avatar\",\"prompt\":\"\"}', '', '30');
INSERT INTO `ebcms5_formfield` VALUES ('123', '21', '基本信息', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('124', '22', '基本信息', '分组', 'group', '', '', '1', 'group', 'form_textbox', 'null', '', '99');
INSERT INTO `ebcms5_formfield` VALUES ('125', '22', '基本信息', '标题', 'title', '', '', '0', '', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '', '96');
INSERT INTO `ebcms5_formfield` VALUES ('126', '22', '基本信息', '说明', 'remark', '', '', '0', '', 'form_multitextbox', 'null', '', '75');
INSERT INTO `ebcms5_formfield` VALUES ('127', '23', '基本信息', '分组', 'group', '', '', '3', 'group', 'form_textbox', 'null', '', '99');
INSERT INTO `ebcms5_formfield` VALUES ('128', '23', '基本信息', '标题', 'title', '', '', '3', 'title', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '', '97');
INSERT INTO `ebcms5_formfield` VALUES ('129', '23', '基本信息', '说明', 'remark', '', '', '3', 'remark', 'form_multitextbox', 'null', '', '46');
INSERT INTO `ebcms5_formfield` VALUES ('130', '23', '基本信息', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('131', '24', '基本信息', '分组', 'group', '', '', '1', 'group', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '', '99');
INSERT INTO `ebcms5_formfield` VALUES ('132', '24', '基本信息', '标题', 'title', '', '', '0', '', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"10\",\"minlength\":\"1\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '', '96');
INSERT INTO `ebcms5_formfield` VALUES ('133', '24', '基本信息', '字段', 'name', '', '', '0', '', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"20\",\"minlength\":\"1\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '', '89');
INSERT INTO `ebcms5_formfield` VALUES ('134', '24', '基本信息', '表单类型', 'type', '', '', '0', '', 'form_database', '{\"model\":\"ebcms\\/form\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"0\",\"tree\":\"0\",\"prompt\":\"\",\"queryparams\":\"group|eq|表单配置\",\"pid\":\"\",\"titlefield\":\"\",\"valuefield\":\"name\",\"width\":\"\"}', '', '80');
INSERT INTO `ebcms5_formfield` VALUES ('135', '24', '基本信息', '默认值', 'value', '', '', '0', '', 'form_multitextbox', 'null', '', '78');
INSERT INTO `ebcms5_formfield` VALUES ('136', '24', '基本信息', '说明', 'remark', '', '', '0', '', 'form_multitextbox', 'null', '', '60');
INSERT INTO `ebcms5_formfield` VALUES ('137', '24', '基本信息', '分类', 'category_id', '', '', '1', 'category_id', 'form_hidden', 'null', '', '2');
INSERT INTO `ebcms5_formfield` VALUES ('138', '25', '基本信息', '分组', 'group', '', '', '3', 'group', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '', '99');
INSERT INTO `ebcms5_formfield` VALUES ('139', '25', '基本信息', '标题', 'title', '', '', '3', 'title', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '', '95');
INSERT INTO `ebcms5_formfield` VALUES ('140', '25', '基本信息', '字段', 'name', '', '', '3', 'name', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '', '94');
INSERT INTO `ebcms5_formfield` VALUES ('141', '25', '基本信息', '表单类型', 'type', '', '', '3', 'type', 'form_database', '{\"model\":\"ebcms\\/form\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"0\",\"tree\":\"0\",\"prompt\":\"\",\"queryparams\":\"group|eq|表单配置\",\"pid\":\"\",\"titlefield\":\"\",\"valuefield\":\"name\",\"width\":\"\"}', '更改表单类型后 请更改上一行字段名称 否则可能报错', '93');
INSERT INTO `ebcms5_formfield` VALUES ('142', '25', '基本信息', '默认值', 'value', '', '', '3', 'value', 'form_multitextbox', 'null', '', '87');
INSERT INTO `ebcms5_formfield` VALUES ('143', '25', '基本信息', '说明', 'remark', '', '', '3', 'remark', 'form_multitextbox', 'null', '', '67');
INSERT INTO `ebcms5_formfield` VALUES ('144', '25', '基本信息', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('145', '26', '基本配置', '是否失效', 'disabled', '', 'config', '3', 'disabled', 'form_bool', 'null', '', '60');
INSERT INTO `ebcms5_formfield` VALUES ('146', '26', '基本配置', '是否只读', 'readonly', '', 'config', '3', 'readonly', 'form_bool', 'null', '', '55');
INSERT INTO `ebcms5_formfield` VALUES ('147', '26', '基本配置', '可选值', 'values', '', 'config', '3', 'values', 'form_multitextbox', 'null', '一样一个，用|分割键值对，例如：\r\n红色|red\r\n绿色|green\r\n黑色|black\r\n灰色|gray', '50');
INSERT INTO `ebcms5_formfield` VALUES ('148', '26', '基本配置', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('149', '27', '基本信息', '是否失效', 'disabled', '', 'config', '3', 'disabled', 'form_bool', 'null', '', '99');
INSERT INTO `ebcms5_formfield` VALUES ('150', '27', '基本信息', '是否只读', 'readonly', '', 'config', '3', 'readonly', 'form_bool', 'null', '', '70');
INSERT INTO `ebcms5_formfield` VALUES ('151', '27', '基本信息', '可选值', 'values', '', 'config', '3', 'values', 'form_multitextbox', 'null', '一样一个，用|分割键值对，例如：\r\n红色|red\r\n绿色|green\r\n黑色|black\r\n灰色|gray', '50');
INSERT INTO `ebcms5_formfield` VALUES ('152', '27', '基本信息', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('175', '32', '基本信息', '旧密码', 'oldpassword', '', '', '0', '', 'form_textbox', 'null', '', '50');
INSERT INTO `ebcms5_formfield` VALUES ('176', '32', '基本信息', '新密码', 'password', '', '', '0', '', 'form_textbox', 'null', '', '45');
INSERT INTO `ebcms5_formfield` VALUES ('177', '32', '基本信息', '重复密码', 'passwordtwo', '', '', '0', '', 'form_textbox', 'null', '', '40');
INSERT INTO `ebcms5_formfield` VALUES ('178', '33', '基本信息', '可选值', 'values', '', 'config', '3', 'values', 'form_multitextbox', 'null', '一样一个，用|分割键值对，例如：\r\n红色|red\r\n绿色|green\r\n黑色|black\r\n灰色|gray', '80');
INSERT INTO `ebcms5_formfield` VALUES ('179', '33', '基本信息', '是否可编辑', 'editable', '', 'config', '3', 'editable', 'form_bool', 'null', '可编辑是指下拉选项只是作为辅助选项，实际上还是一个文本框', '60');
INSERT INTO `ebcms5_formfield` VALUES ('180', '33', '基本信息', '是否只读', 'readonly', '', 'config', '3', 'readonly', 'form_bool', 'null', '', '40');
INSERT INTO `ebcms5_formfield` VALUES ('181', '33', '基本信息', '是否失效', 'disabled', '', 'config', '3', 'disabled', 'form_bool', 'null', '', '30');
INSERT INTO `ebcms5_formfield` VALUES ('182', '33', '基本信息', 'id', 'id', '', '', '3', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('2882', '411', '基本信息', '标题', 'title', '', '', '0', '', 'form_textbox', 'null', '', '7');
INSERT INTO `ebcms5_formfield` VALUES ('2883', '411', '基本信息', '链接地址', 'eb_url', '', '', '0', '', 'form_textbox', 'null', '常规写法：http://www.ebcms.com/\r\n系统写法：content/index/lists?id=1', '6');
INSERT INTO `ebcms5_formfield` VALUES ('2884', '411', '基本信息', '分组', 'group', '', '', '1', 'group', 'form_textbox', 'null', '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('2885', '411', '基本信息', '父级', 'pid', '', '', '0', '', 'form_database', '{\"model\":\"ebcms\\/nav\",\"editable\":\"0\",\"required\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"1\",\"tree\":\"1\",\"prompt\":\"\",\"queryparams\":\"group|eq|(I)group\",\"pid\":\"\",\"titlefield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '', '8');
INSERT INTO `ebcms5_formfield` VALUES ('2886', '412', '基本信息', '父级', 'pid', '', '', '3', 'pid', 'form_database', '{\"model\":\"ebcms\\/nav\",\"editable\":\"0\",\"required\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"1\",\"tree\":\"1\",\"prompt\":\"\",\"queryparams\":\"group|eq|(@)group\",\"pid\":\"\",\"titlefield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('2887', '412', '基本信息', '标题', 'title', '', '', '3', 'title', 'form_textbox', 'null', '', '8');
INSERT INTO `ebcms5_formfield` VALUES ('2888', '412', '基本信息', '链接地址', 'eb_url', '', '', '3', 'eb_url', 'form_textbox', 'null', '常规写法：http://www.ebcms.com/\r\n系统写法：content/index/lists?id=1', '7');
INSERT INTO `ebcms5_formfield` VALUES ('2889', '412', '个性扩展', '个性扩展', 'eb_ext', '', '', '3', 'eb_ext', 'form_custom', '{\"html\":\"&lt;script&gt;\\r\\n    Namespace.register(&quot;EBCMS.Form_{$field.unique}&quot;);\\r\\n    $(function() {\\r\\n\\r\\n        \\/*\\u6539\\u540d\\u540d\\u79f0*\\/\\r\\n        EBCMS.Form_{$field.unique}.changename = function(id,value){\\r\\n            if ($(id).is(\'div\')) {\\r\\n                \\/*\\u7f16\\u8f91\\u5668*\\/\\r\\n                $(id).next().attr(\'name\',\'{$field.field}[\'+value+\']\');\\r\\n            }else{\\r\\n                $(id).attr(\'name\',\'{$field.field}[\'+value+\']\');\\r\\n            }\\r\\n            $(id+\'__config__\').attr(\'name\',\'{$field.field}[__config__][\'+value+\']\');\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.up = function(dom){\\r\\n            var thisdom = $(dom).parent().parent().parent();\\r\\n            if (thisdom.prev().length) {\\r\\n                thisdom.insertBefore(thisdom.prev());\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.down = function(dom){\\r\\n            var thisdom = $(dom).parent().parent().parent();\\r\\n            if (thisdom.next().length) {\\r\\n                thisdom.next().insertBefore(thisdom);\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render = function(name,value,target){\\r\\n            if (EBCMS.Form_{$field.unique}.config[name]) {\\r\\n                \\r\\n            }else{\\r\\n                EBCMS.Form_{$field.unique}.config[name] = \'text\';\\r\\n            }\\r\\n            if (EBCMS.Form_{$field.unique}[\'render_\'+EBCMS.Form_{$field.unique}.config[name]]) {\\r\\n                EBCMS.Form_{$field.unique}[\'render_\'+EBCMS.Form_{$field.unique}.config[name]](name,value,target);\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_text = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; value=&quot;\'+opt.value+\'&quot; placeholder=&quot;\\u586b\\u5199\\u5185\\u5bb9&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;text&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_textarea = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;textarea class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; rows=&quot;3&quot; placeholder=&quot;\\u586b\\u5199\\u5185\\u5bb9&quot;&gt;\'+opt.value+\'&lt;\\/textarea&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;textarea&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_file = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;table class=&quot;table&quot; style=&quot;margin-bottom: 0px;&quot;&gt;\';\\r\\n            str += \'&lt;tr&gt;\';\\r\\n            str += \'&lt;td style=&quot;padding: 0px !important;border-top:none;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; value=&quot;\'+opt.value+\'&quot; placeholder=&quot;\\u586b\\u5199\\u5185\\u5bb9&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;file&quot;&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td style=&quot;width: 100px;padding: 0px 0px 0px 10px !important;border-top:none;&quot;&gt;\';\\r\\n            str += \'&lt;div id=&quot;\'+opt.id+\'_pick&quot;&gt;\\u4e0a\\u4f20&lt;\\/div&gt;\';\\r\\n            str += \'&lt;script&gt;\';\\r\\n            str += \'$(function(){\';\\r\\n            str += \'    EBCMS.MYFUN.renderUploader(\\\\\'#\'+opt.id+\'_pick\\\\\',function(file,res){ if (res.code) { $(\\\\\'#\'+opt.id+\'\\\\\').val(res.data.pathname); }else{ EBCMS.MSG.alert(res.msg);};});\';\\r\\n            str += \'});\';\\r\\n            str += \'&lt;\\\\\\/script&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;\\/tr&gt;\';\\r\\n            str += \'&lt;\\/table&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_ueditor = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;textarea id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; &gt;\'+opt.value+\'&lt;\\/textarea&gt;\';\\r\\n            str += \'&lt;script&gt;\';\\r\\n            str += \'$(function(){\';\\r\\n            str += \'    EBCMS.MYFUN.renderUE(&quot;\'+opt.id+\'&quot;,{\';\\r\\n            str += \'          autoHeightEnabled:false,\';\\r\\n            str += \'          maximumWords:99999,\';\\r\\n            str += \'          wordCount:true,\';\\r\\n            str += \'          elementPathEnabled:true,\';\\r\\n            str += \'          initialFrameHeight:400,\';\\r\\n            str += \'    });\';\\r\\n            str += \'});\';\\r\\n            str += \'&lt;\\\\\\/script&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;ueditor&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        \\r\\n        var forms = {$field.value|json_encode};\\r\\n        if (typeof forms!=\'object\') {\\r\\n            forms = {};\\r\\n        }\\r\\n        EBCMS.Form_{$field.unique}.config = forms[\'__config__\']||{};\\r\\n        delete forms[\'__config__\'];\\r\\n        $.each(forms, function(name, val) {\\r\\n            EBCMS.Form_{$field.unique}.render(name,val,\'#{$field.unique}_container\');\\r\\n        });\\r\\n    });\\r\\n&lt;\\/script&gt;\\r\\n&lt;div class=&quot;row&quot;&gt;\\r\\n    &lt;div class=&quot;col-md-12&quot;&gt;\\r\\n        &lt;div class=&quot;btn-group&quot; role=&quot;group&quot; aria-label=&quot;...&quot;&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_text(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u5355\\u884c\\u6587\\u672c&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_textarea(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u591a\\u884c\\u6587\\u672c&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_file(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u6587\\u4ef6&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_ueditor(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u7f16\\u8f91\\u6846&lt;\\/button&gt;\\r\\n        &lt;\\/div&gt;\\r\\n        &lt;br&gt;\\r\\n    &lt;\\/div&gt;\\r\\n&lt;\\/div&gt;\\r\\n&lt;div id=&quot;{$field.unique}_container&quot;&gt;&lt;\\/div&gt;\\r\\n&lt;input type=&quot;hidden&quot; name=&quot;{$field.field}[__config__][__test__]&quot; value=\'test\'&gt;\"}', '', '8');
INSERT INTO `ebcms5_formfield` VALUES ('2890', '412', '基本信息', 'id', 'id', '', '', '3', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('2891', '411', '基本信息', '所属应用', 'app', '', '', '0', '', 'form_textbox', '{\"prompt\":\"可不填\"}', '填写所属应用名称，例如 您安装了单页模块的话 此处就填写 single，\r\n作用：\r\n1、卸载应用的时候，自动删除\r\n2、暂停应用的时候，前台自动隐藏', '1');
INSERT INTO `ebcms5_formfield` VALUES ('2892', '412', '基本信息', '所属应用', 'app', '', '', '3', 'app', 'form_textbox', '{\"prompt\":\"可不填\"}', '填写所属应用名称，例如 您安装了单页模块的话 此处就填写 single，\r\n作用：\r\n1、卸载应用的时候，自动删除\r\n2、暂停应用的时候，前台自动隐藏', '5');
INSERT INTO `ebcms5_formfield` VALUES ('7002', '411', '个性扩展', '个性扩展', 'eb_ext', '', '', '0', '', 'form_custom', '{\"html\":\"&lt;script&gt;\\r\\n    Namespace.register(&quot;EBCMS.Form_{$field.unique}&quot;);\\r\\n    $(function() {\\r\\n\\r\\n        \\/*\\u6539\\u540d\\u540d\\u79f0*\\/\\r\\n        EBCMS.Form_{$field.unique}.changename = function(id,value){\\r\\n            if ($(id).is(\'div\')) {\\r\\n                \\/*\\u7f16\\u8f91\\u5668*\\/\\r\\n                $(id).next().attr(\'name\',\'{$field.field}[\'+value+\']\');\\r\\n            }else{\\r\\n                $(id).attr(\'name\',\'{$field.field}[\'+value+\']\');\\r\\n            }\\r\\n            $(id+\'__config__\').attr(\'name\',\'{$field.field}[__config__][\'+value+\']\');\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.up = function(dom){\\r\\n            var thisdom = $(dom).parent().parent().parent();\\r\\n            if (thisdom.prev().length) {\\r\\n                thisdom.insertBefore(thisdom.prev());\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.down = function(dom){\\r\\n            var thisdom = $(dom).parent().parent().parent();\\r\\n            if (thisdom.next().length) {\\r\\n                thisdom.next().insertBefore(thisdom);\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render = function(name,value,target){\\r\\n            if (EBCMS.Form_{$field.unique}.config[name]) {\\r\\n                \\r\\n            }else{\\r\\n                EBCMS.Form_{$field.unique}.config[name] = \'text\';\\r\\n            }\\r\\n            if (EBCMS.Form_{$field.unique}[\'render_\'+EBCMS.Form_{$field.unique}.config[name]]) {\\r\\n                EBCMS.Form_{$field.unique}[\'render_\'+EBCMS.Form_{$field.unique}.config[name]](name,value,target);\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_text = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; value=&quot;\'+opt.value+\'&quot; placeholder=&quot;\\u586b\\u5199\\u5185\\u5bb9&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;text&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_textarea = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;textarea class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; rows=&quot;3&quot; placeholder=&quot;\\u586b\\u5199\\u5185\\u5bb9&quot;&gt;\'+opt.value+\'&lt;\\/textarea&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;textarea&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_file = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;table class=&quot;table&quot; style=&quot;margin-bottom: 0px;&quot;&gt;\';\\r\\n            str += \'&lt;tr&gt;\';\\r\\n            str += \'&lt;td style=&quot;padding: 0px !important;border-top:none;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; value=&quot;\'+opt.value+\'&quot; placeholder=&quot;\\u586b\\u5199\\u5185\\u5bb9&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;file&quot;&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td style=&quot;width: 100px;padding: 0px 0px 0px 10px !important;border-top:none;&quot;&gt;\';\\r\\n            str += \'&lt;div id=&quot;\'+opt.id+\'_pick&quot;&gt;\\u4e0a\\u4f20&lt;\\/div&gt;\';\\r\\n            str += \'&lt;script&gt;\';\\r\\n            str += \'$(function(){\';\\r\\n            str += \'    EBCMS.MYFUN.renderUploader(\\\\\'#\'+opt.id+\'_pick\\\\\',function(file,res){ if (res.code) { $(\\\\\'#\'+opt.id+\'\\\\\').val(res.data.pathname); }else{ EBCMS.MSG.alert(res.msg);};});\';\\r\\n            str += \'});\';\\r\\n            str += \'&lt;\\\\\\/script&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;\\/tr&gt;\';\\r\\n            str += \'&lt;\\/table&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_ueditor = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;textarea id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; &gt;\'+opt.value+\'&lt;\\/textarea&gt;\';\\r\\n            str += \'&lt;script&gt;\';\\r\\n            str += \'$(function(){\';\\r\\n            str += \'    EBCMS.MYFUN.renderUE(&quot;\'+opt.id+\'&quot;,{\';\\r\\n            str += \'          autoHeightEnabled:false,\';\\r\\n            str += \'          maximumWords:99999,\';\\r\\n            str += \'          wordCount:true,\';\\r\\n            str += \'          elementPathEnabled:true,\';\\r\\n            str += \'          initialFrameHeight:400,\';\\r\\n            str += \'    });\';\\r\\n            str += \'});\';\\r\\n            str += \'&lt;\\\\\\/script&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;ueditor&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        \\r\\n        var forms = {$field.value|json_encode};\\r\\n        if (typeof forms!=\'object\') {\\r\\n            forms = {};\\r\\n        }\\r\\n        EBCMS.Form_{$field.unique}.config = forms[\'__config__\']||{};\\r\\n        delete forms[\'__config__\'];\\r\\n        $.each(forms, function(name, val) {\\r\\n            EBCMS.Form_{$field.unique}.render(name,val,\'#{$field.unique}_container\');\\r\\n        });\\r\\n    });\\r\\n&lt;\\/script&gt;\\r\\n&lt;div class=&quot;row&quot;&gt;\\r\\n    &lt;div class=&quot;col-md-12&quot;&gt;\\r\\n        &lt;div class=&quot;btn-group&quot; role=&quot;group&quot; aria-label=&quot;...&quot;&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_text(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u5355\\u884c\\u6587\\u672c&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_textarea(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u591a\\u884c\\u6587\\u672c&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_file(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u6587\\u4ef6&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_ueditor(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u7f16\\u8f91\\u6846&lt;\\/button&gt;\\r\\n        &lt;\\/div&gt;\\r\\n        &lt;br&gt;\\r\\n    &lt;\\/div&gt;\\r\\n&lt;\\/div&gt;\\r\\n&lt;div id=&quot;{$field.unique}_container&quot;&gt;&lt;\\/div&gt;\\r\\n&lt;input type=&quot;hidden&quot; name=&quot;{$field.field}[__config__][__test__]&quot; value=\'test\'&gt;\"}', '', '8');
INSERT INTO `ebcms5_formfield` VALUES ('7006', '13', '基本配置', '分组化', 'group', '', 'config', '3', 'group', 'form_bool', 'null', '', '35');
INSERT INTO `ebcms5_formfield` VALUES ('10186', '1444', '基本信息', '邮件主题', 'topic', '', '', '1', 'topic', 'form_select', '{\"values\":\"系统消息|系统消息\\r\\n优惠信息|优惠信息\",\"editable\":\"1\",\"readonly\":\"0\",\"disabled\":\"0\"}', '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('10187', '1444', '基本信息', '邮件地址', 'email', '', '', '1', 'email', 'form_textbox', 'null', '', '8');
INSERT INTO `ebcms5_formfield` VALUES ('10188', '1444', '基本信息', '对方称呼', 'name', '', '', '0', '', 'form_textbox', 'null', '', '7');
INSERT INTO `ebcms5_formfield` VALUES ('10189', '1444', '基本信息', '内容', 'content', '', '', '0', '', 'form_ueditor', '{\"initialframeheight\":\"200\",\"maximumwords\":\"\"}', '', '6');
INSERT INTO `ebcms5_formfield` VALUES ('10558', '1497', '基本配置', 'HTML', 'html', '', 'config', '3', 'html', 'form_multitextbox', '{\"height\":\"20\",\"width\":\"\",\"prompt\":\"\"}', '常见结构：\r\n&lt;tr&gt;\r\n	&lt;th&gt;{$field.title}&lt;/th&gt;\r\n	&lt;td&gt;\r\n		&lt;input type=&quot;text&quot; class=&quot;form-control&quot; id=&quot;{$field.unique}&quot; name=&quot;{$field.field}&quot; value=&quot;{$field.value}&quot; placeholder=&quot;示例&quot;&gt;\r\n		{notempty name=\'field.remark\'}\r\n			&lt;p class=&quot;help-block&quot;&gt;{$field.remark}&lt;/p&gt;\r\n		{/notempty}\r\n	&lt;/td&gt;\r\n&lt;/tr&gt;\r\n支持变量：\r\nfield   当前字段的配置数据\r\ndata    当前表单分配的数据\r\ngroups  当前表单的字段信息\r\nform    当前表单信息', '9');
INSERT INTO `ebcms5_formfield` VALUES ('10559', '1497', '基本配置', 'ID', 'id', '', '', '3', 'id', 'form_hidden', 'null', '', '0');
INSERT INTO `ebcms5_formfield` VALUES ('11750', '411', '基本信息', '打开方式', 'target', '', '', '0', '_self', 'form_select', '{\"values\":\"新窗口|_blank\\r\\n当前窗口|_self\\r\\n父窗口|_parent\\r\\n_top|_top\",\"editable\":\"1\"}', '', '5');
INSERT INTO `ebcms5_formfield` VALUES ('11751', '412', '基本信息', '打开方式', 'target', '', '', '3', 'target', 'form_select', '{\"values\":\"新窗口|_blank\\r\\n当前窗口|_self\\r\\n父窗口|_parent\\r\\n_top|_top\",\"editable\":\"1\"}', '', '6');
INSERT INTO `ebcms5_formfield` VALUES ('12294', '22', '基本信息', '所属应用', 'app', '', '', '0', '', 'form_textbox', 'null', '填写所属应用名称，例如 您安装了单页模块的话 此处就填写 single，\r\n作用：卸载应用的时候，自动删除', '10');
INSERT INTO `ebcms5_formfield` VALUES ('12295', '23', '基本信息', '所属应用', 'app', '', '', '3', 'app', 'form_textbox', 'null', '填写所属应用名称，例如 您安装了单页模块的话 此处就填写 single，\r\n作用：卸载应用的时候，自动删除', '10');
INSERT INTO `ebcms5_formfield` VALUES ('17492', '2542', '基本信息', '权限', 'rule_ids', '', '', '0', '', 'form_custom', '{\"html\":\"{php}\\r\\n    $checked = \\\\think\\\\Db::name(\'auth_group\')-&gt;where(array(\'id\' =&gt; array(\'eq\', input(\'id\'))))-&gt;value(\'rules\');\\r\\n    $rules = \\\\think\\\\Db::name(\'auth_rule\')-&gt;order(\'sort desc\')-&gt;select();\\r\\n    $rules = \\\\ebcms\\\\Tree::tree($rules);\\r\\n{\\/php}\\r\\n{foreach name=\'rules\' item=\'a\'}\\r\\n    &lt;table class=&quot;table table-bordered&quot;&gt;\\r\\n        &lt;tr&gt;\\r\\n            &lt;td colspan=&quot;2&quot;&gt;\\r\\n                &lt;label class=&quot;checkbox-inline&quot;&gt;\\r\\n                    &lt;input type=&quot;checkbox&quot; name=&quot;{$field.field}[]&quot; value=&quot;{$a.id}&quot; {in name=&quot;a.id&quot; value=&quot;$checked&quot;}checked=&quot;checked&quot;{\\/in}&gt; {$a.title}\\r\\n                &lt;\\/label&gt;\\r\\n            &lt;\\/td&gt;\\r\\n        &lt;\\/tr&gt;\\r\\n        {foreach name=\'a.rows\' item=\'b\'}\\r\\n        &lt;tr&gt;\\r\\n            &lt;th&gt;\\r\\n                &lt;label class=&quot;checkbox-inline&quot;&gt;\\r\\n                    &lt;input type=&quot;checkbox&quot; name=&quot;{$field.field}[]&quot; value=&quot;{$b.id}&quot; {in name=&quot;b.id&quot; value=&quot;$checked&quot;}checked=&quot;checked&quot;{\\/in}&gt; {$b.title}\\r\\n                &lt;\\/label&gt;\\r\\n            &lt;\\/th&gt;\\r\\n            &lt;td&gt;\\r\\n                {foreach name=\'b.rows\' item=\'c\'}\\r\\n                &lt;label class=&quot;checkbox-inline&quot;&gt;\\r\\n                    &lt;input type=&quot;checkbox&quot; name=&quot;{$field.field}[]&quot; value=&quot;{$c.id}&quot; {in name=&quot;c.id&quot; value=&quot;$checked&quot;}checked=&quot;checked&quot;{\\/in}&gt; {$c.title}\\r\\n                &lt;\\/label&gt;\\r\\n                {\\/foreach}\\r\\n            &lt;\\/td&gt;\\r\\n        &lt;\\/tr&gt;\\r\\n        {\\/foreach}\\r\\n    &lt;\\/table&gt;\\r\\n{\\/foreach}\"}', '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('17493', '2542', '基本信息', 'id', 'id', '', '', '1', 'id', 'form_hidden', null, '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('17494', '2543', '基本信息', 'id', 'id', '', '', '1', 'id', 'form_hidden', null, '', '0');
INSERT INTO `ebcms5_formfield` VALUES ('17495', '2543', '基本信息', '菜单', 'menu_ids', '', '', '0', '', 'form_custom', '{\"html\":\"{php}\\r\\n\\t$checked = \\\\think\\\\Db::name(\'auth_group\')-&gt;where(array(\'id\' =&gt; array(\'eq\', input(\'id\'))))-&gt;value(\'menus\');\\r\\n\\t$menus = \\\\think\\\\Db::name(\'menu\')-&gt;order(\'sort desc\')-&gt;select();\\r\\n\\t$menus = \\\\ebcms\\\\Tree::tree($menus);\\r\\n{\\/php}\\r\\n&lt;table class=&quot;table table-bordered&quot;&gt;\\r\\n\\t{foreach name=\'menus\' item=\'top\'}\\r\\n\\t&lt;tr&gt;\\r\\n\\t\\t&lt;th&gt;\\r\\n\\t\\t\\t&lt;label class=&quot;checkbox-inline&quot;&gt;\\r\\n\\t\\t\\t\\t&lt;input type=&quot;checkbox&quot; name=&quot;{$field.field}[]&quot; value=&quot;{$top.id}&quot; {in name=&quot;top.id&quot; value=&quot;$checked&quot;}checked=&quot;checked&quot;{\\/in}&gt; {$top.title}\\r\\n\\t\\t\\t&lt;\\/label&gt;\\r\\n\\t\\t&lt;\\/th&gt;\\r\\n\\t\\t&lt;td&gt;\\r\\n\\t\\t\\t{foreach name=\'top.rows\' item=\'sub\'}\\r\\n\\t\\t\\t&lt;label class=&quot;checkbox-inline&quot;&gt;\\r\\n\\t\\t\\t\\t&lt;input type=&quot;checkbox&quot; name=&quot;{$field.field}[]&quot; value=&quot;{$sub.id}&quot; {in name=&quot;sub.id&quot; value=&quot;$checked&quot;}checked=&quot;checked&quot;{\\/in}&gt; {$sub.title}\\r\\n\\t\\t\\t&lt;\\/label&gt;\\r\\n\\t\\t\\t{\\/foreach}\\r\\n\\t\\t&lt;\\/td&gt;\\r\\n\\t&lt;\\/tr&gt;\\r\\n\\t{\\/foreach}\\r\\n&lt;\\/table&gt;\"}', '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('17496', '2544', '基本信息', '密码', 'password', '', '', '0', '', 'form_textbox', null, '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('17497', '2544', '基本信息', 'id', 'id', '', '', '1', 'id', 'form_hidden', null, '', '2');
INSERT INTO `ebcms5_formfield` VALUES ('17498', '2545', '基本信息', '角色', 'group_ids', '', '', '0', '', 'form_custom', '{\"html\":\"{php}\\r\\n\\t$checked = \\\\think\\\\Db::name(\'auth_access\')-&gt;where(\'uid=\' . input(\'id\'))-&gt;column(\'group_id\');\\r\\n\\t$groups = \\\\think\\\\Db::name(\'auth_group\')-&gt;select();\\r\\n\\t$groups = \\\\ebcms\\\\Tree::group($groups);\\r\\n{\\/php}\\r\\n&lt;table class=&quot;table table-bordered&quot;&gt;\\r\\n\\t{foreach name=\'groups\' item=\'items\'}\\r\\n\\t&lt;tr&gt;\\r\\n\\t\\t&lt;th&gt;\\r\\n\\t\\t\\t{$key}\\r\\n\\t\\t&lt;\\/th&gt;\\r\\n\\t\\t&lt;td&gt;\\r\\n\\t\\t\\t{foreach name=\'items\' item=\'vo\'}\\r\\n\\t\\t\\t&lt;label class=&quot;checkbox-inline&quot;&gt;\\r\\n\\t\\t\\t\\t&lt;input type=&quot;checkbox&quot; name=&quot;{$field.field}[]&quot; value=&quot;{$vo.id}&quot; {in name=&quot;vo.id&quot; value=&quot;$checked&quot;}checked=&quot;checked&quot;{\\/in}&gt; {$vo.title}\\r\\n\\t\\t\\t&lt;\\/label&gt;\\r\\n\\t\\t\\t{\\/foreach}\\r\\n\\t\\t&lt;\\/td&gt;\\r\\n\\t&lt;\\/tr&gt;\\r\\n\\t{\\/foreach}\\r\\n&lt;\\/table&gt;\"}', '', '0');
INSERT INTO `ebcms5_formfield` VALUES ('17499', '2545', '基本信息', 'id', 'id', '', '', '1', 'id', 'form_hidden', null, '', '0');
INSERT INTO `ebcms5_formfield` VALUES ('17500', '2546', '基本信息', '密码', 'password', '', '', '0', '', 'form_textbox', null, '为保证系统安全，请输入密码！', '9');
INSERT INTO `ebcms5_formfield` VALUES ('17501', '2546', '基本信息', 'id', 'id', '', '', '1', 'id', 'form_hidden', null, '', '0');
INSERT INTO `ebcms5_formfield` VALUES ('18296', '6', '基本配置', '上传目录', 'path', '', 'config', '3', 'path', 'form_textbox', null, '', '30');
INSERT INTO `ebcms5_formfield` VALUES ('18299', '9', '基本配置', '上传目录', 'path', '', 'config', '3', 'path', 'form_textbox', null, '', '30');
INSERT INTO `ebcms5_formfield` VALUES ('21544', '13', '基本配置', '查询排序', 'order', '', 'config', '3', '', 'form_textbox', null, '', '49');
INSERT INTO `ebcms5_formfield` VALUES ('21545', '13', '基本配置', '查询排序', 'order', '', 'config', '3', '', 'form_textbox', null, '', '49');
INSERT INTO `ebcms5_formfield` VALUES ('22372', '3173', '基本信息', '父级', 'pid', '', '', '1', 'pid', 'form_database', '{\"model\":\"content\\/channel\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"1\",\"group\":\"0\",\"tree\":\"1\",\"prompt\":\"\",\"queryparams\":\"\",\"pid\":\"\",\"titlefield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '', '90');
INSERT INTO `ebcms5_formfield` VALUES ('22373', '3173', '基本信息', '标题', 'title', '', '', '0', '', 'form_textbox', '{\"required\":\"0\",\"editable\":\"1\",\"maxlength\":\"80\",\"minlength\":\"\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '', '85');
INSERT INTO `ebcms5_formfield` VALUES ('22374', '3173', '基本信息', '名称', 'name', '', '', '0', '', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"20\",\"minlength\":\"2\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"请填写英文字符\",\"width\":\"\"}', '请填写英文字符，对应栏目路径，高级模式生效', '82');
INSERT INTO `ebcms5_formfield` VALUES ('22375', '3173', '基本信息', '类型', 'type', '', '', '0', 'page', 'form_hidden', '{\"html\":\"&lt;tr&gt;\\r\\n\\t&lt;th&gt;{$field.title}&lt;\\/th&gt;\\r\\n\\t&lt;td&gt;\\r\\n\\t\\t{php}\\r\\n\\t\\t\\t$radios = [\'channel\'=&gt;\'栏目\',\'page\'=&gt;\'单页\',\'jump\'=&gt;\'跳转\'];\\r\\n\\t\\t{\\/php}\\r\\n\\t\\t{foreach name=\'radios\' item=\'_temp\'}\\r\\n\\t\\t\\t&lt;label class=&quot;radio-inline&quot; for=&quot;{$field.unique}_{$key}&quot;&gt;\\r\\n\\t\\t\\t\\t&lt;input type=&quot;radio&quot; name=&quot;{$field.field}&quot; onclick=&quot;M_{$field.unique}.x();&quot; id=&quot;{$field.unique}_{$key}&quot; value=&quot;{$key}&quot; {eq name=&quot;field.value&quot; value=\'$key\'}checked{\\/eq}&gt; {$_temp}\\r\\n\\t\\t\\t&lt;\\/label&gt;\\r\\n\\t\\t{\\/foreach}\\r\\n\\t\\t&lt;script&gt;\\r\\n\\t\\t\\tvar M_{$field.unique} = {};\\r\\n\\t\\t\\t$(function() {\\r\\n\\t\\t\\t\\tM_{$field.unique}.x = function(){\\r\\n\\t\\t\\t\\t\\tvar val = $(&quot;input[name={$field.field}]:checked&quot;).val();\\r\\n\\t\\t\\t\\t\\tvar fields = [\'eb_metatitle\',\'keywords\',\'description\',\'extend_id\',\'tpl\',\'tpl_detail\',\'eb_url\',\'body\'];\\r\\n\\t\\t\\t\\t\\tswitch(val){\\r\\n\\t\\t\\t\\t\\t\\tcase \'channel\':\\r\\n\\t\\t\\t\\t\\t\\t\\tvar field = [\'eb_metatitle\',\'keywords\',\'description\',\'extend_id\',\'tpl\',\'tpl_detail\'];\\r\\n\\t\\t\\t\\t\\t\\tbreak;\\r\\n\\t\\t\\t\\t\\t\\tcase \'page\':\\r\\n\\t\\t\\t\\t\\t\\t\\tvar field = [\'eb_metatitle\',\'keywords\',\'description\',\'tpl\',\'body\'];\\r\\n\\t\\t\\t\\t\\t\\tbreak;\\r\\n\\t\\t\\t\\t\\t\\tcase \'jump\':\\r\\n\\t\\t\\t\\t\\t\\t\\tvar field = [\'eb_url\'];\\r\\n\\t\\t\\t\\t\\t\\tbreak;\\r\\n\\t\\t\\t\\t\\t\\tdefault:\\r\\n\\r\\n\\t\\t\\t\\t\\t}\\r\\n\\t\\t\\t\\t\\t$.each(fields, function(index, f) {\\r\\n\\t\\t\\t\\t\\t\\tif (-1 == field.indexOf(f)) {\\r\\n\\t\\t\\t\\t\\t\\t\\t$(\'*[name=\'+f+\']\').closest(\'tr\').hide();\\r\\n\\t\\t\\t\\t\\t\\t}else{\\r\\n\\t\\t\\t\\t\\t\\t\\t$(\'*[name=\'+f+\']\').closest(\'tr\').show();\\r\\n\\t\\t\\t\\t\\t\\t}\\r\\n\\t\\t\\t\\t\\t});\\r\\n\\t\\t\\t\\t\\tif (val == \'jump\') {\\r\\n\\t\\t\\t\\t\\t\\t$(\'form .tabs .tab-head\').eq(0).siblings().hide();\\r\\n\\t\\t\\t\\t\\t}else{\\r\\n\\t\\t\\t\\t\\t\\t$(\'form .tabs .tab-head\').eq(0).siblings().show();\\r\\n\\t\\t\\t\\t\\t}\\r\\n\\t\\t\\t\\t}\\r\\n\\t\\t\\t\\tif (\'{$field.value}\' != \'\') {\\r\\n\\t\\t\\t\\t\\t$(\'input[name={$field.field}][value={$field.value}]\').trigger(\'click\');\\r\\n\\t\\t\\t\\t\\t$(\'input[name={$field.field}][value={$field.value}]\').closest(\'tr\').hide();\\r\\n\\t\\t\\t\\t}else{\\r\\n\\t\\t\\t\\t\\t$(\'input[name={$field.field}]\').eq(0).trigger(\'click\');\\r\\n\\t\\t\\t\\t}\\r\\n\\t\\t\\t});\\r\\n\\t\\t&lt;\\/script&gt;\\r\\n\\t&lt;\\/td&gt;\\r\\n&lt;\\/tr&gt;\"}', '', '80');
INSERT INTO `ebcms5_formfield` VALUES ('22376', '3173', '其他设置', 'meta标题', 'eb_metatitle', '', '', '0', '', 'form_textbox', 'null', '不填则默认为标题', '74');
INSERT INTO `ebcms5_formfield` VALUES ('22377', '3173', '其他设置', '关键字', 'keywords', '', '', '0', '', 'form_textbox', '{\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\"}', '空格或英文的逗号分割', '74');
INSERT INTO `ebcms5_formfield` VALUES ('22378', '3173', '其他设置', '摘要', 'description', '', '', '0', '', 'form_multitextbox', '{\"required\":\"0\",\"height\":\"\",\"width\":\"\",\"editable\":\"1\",\"maxlength\":\"255\",\"minlength\":\"\",\"validtype\":\"\",\"prompt\":\"\",\"readonly\":\"0\",\"disabled\":\"0\"}', '', '73');
INSERT INTO `ebcms5_formfield` VALUES ('22379', '3173', '基本信息', '打开方式', 'target', '', '', '0', '_self', 'form_radio', '{\"disabled\":\"0\",\"readonly\":\"0\",\"values\":\"当前窗口|_self\\r\\n新窗口|_blank\"}', '', '50');
INSERT INTO `ebcms5_formfield` VALUES ('22380', '3173', '其他设置', '模板', 'tpl', '', '', '0', '', 'form_textbox', '{\"prompt\":\"默认为page\"}', '默认位page', '22');
INSERT INTO `ebcms5_formfield` VALUES ('22381', '3173', '自定义数据', '自定义数据', 'eb_ext', '', '', '0', '', 'form_custom', '{\"html\":\"&lt;script&gt;\\r\\n    Namespace.register(&quot;EBCMS.Form_{$field.unique}&quot;);\\r\\n    $(function() {\\r\\n\\r\\n        \\/*\\u6539\\u540d\\u540d\\u79f0*\\/\\r\\n        EBCMS.Form_{$field.unique}.changename = function(id,value){\\r\\n            if ($(id).is(\'div\')) {\\r\\n                \\/*\\u7f16\\u8f91\\u5668*\\/\\r\\n                $(id).next().attr(\'name\',\'{$field.field}[\'+value+\']\');\\r\\n            }else{\\r\\n                $(id).attr(\'name\',\'{$field.field}[\'+value+\']\');\\r\\n            }\\r\\n            $(id+\'__config__\').attr(\'name\',\'{$field.field}[__config__][\'+value+\']\');\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.up = function(dom){\\r\\n            var thisdom = $(dom).parent().parent().parent();\\r\\n            if (thisdom.prev().length) {\\r\\n                thisdom.insertBefore(thisdom.prev());\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.down = function(dom){\\r\\n            var thisdom = $(dom).parent().parent().parent();\\r\\n            if (thisdom.next().length) {\\r\\n                thisdom.next().insertBefore(thisdom);\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render = function(name,value,target){\\r\\n            if (EBCMS.Form_{$field.unique}.config[name]) {\\r\\n                \\r\\n            }else{\\r\\n                EBCMS.Form_{$field.unique}.config[name] = \'text\';\\r\\n            }\\r\\n            if (EBCMS.Form_{$field.unique}[\'render_\'+EBCMS.Form_{$field.unique}.config[name]]) {\\r\\n                EBCMS.Form_{$field.unique}[\'render_\'+EBCMS.Form_{$field.unique}.config[name]](name,value,target);\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_text = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; value=&quot;\'+opt.value+\'&quot; placeholder=&quot;\\u586b\\u5199\\u5185\\u5bb9&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;text&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_textarea = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;textarea class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; rows=&quot;3&quot; placeholder=&quot;\\u586b\\u5199\\u5185\\u5bb9&quot;&gt;\'+opt.value+\'&lt;\\/textarea&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;textarea&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_file = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;table class=&quot;table&quot; style=&quot;margin-bottom: 0px;&quot;&gt;\';\\r\\n            str += \'&lt;tr&gt;\';\\r\\n            str += \'&lt;td style=&quot;padding: 0px !important;border-top:none;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; value=&quot;\'+opt.value+\'&quot; placeholder=&quot;\\u586b\\u5199\\u5185\\u5bb9&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;file&quot;&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td style=&quot;width: 100px;padding: 0px 0px 0px 10px !important;border-top:none;&quot;&gt;\';\\r\\n            str += \'&lt;div id=&quot;\'+opt.id+\'_pick&quot;&gt;\\u4e0a\\u4f20&lt;\\/div&gt;\';\\r\\n            str += \'&lt;script&gt;\';\\r\\n            str += \'$(function(){\';\\r\\n            str += \'    EBCMS.MYFUN.renderUploader(\\\\\'#\'+opt.id+\'_pick\\\\\',function(file,res){ if (res.code) { $(\\\\\'#\'+opt.id+\'\\\\\').val(res.data.pathname); }else{ EBCMS.MSG.alert(res.msg);};});\';\\r\\n            str += \'});\';\\r\\n            str += \'&lt;\\\\\\/script&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;\\/tr&gt;\';\\r\\n            str += \'&lt;\\/table&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_ueditor = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;textarea id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; &gt;\'+opt.value+\'&lt;\\/textarea&gt;\';\\r\\n            str += \'&lt;script&gt;\';\\r\\n            str += \'$(function(){\';\\r\\n            str += \'    EBCMS.MYFUN.renderUE(&quot;\'+opt.id+\'&quot;,{\';\\r\\n            str += \'          autoHeightEnabled:false,\';\\r\\n            str += \'          maximumWords:99999,\';\\r\\n            str += \'          wordCount:true,\';\\r\\n            str += \'          elementPathEnabled:true,\';\\r\\n            str += \'          initialFrameHeight:400,\';\\r\\n            str += \'    });\';\\r\\n            str += \'});\';\\r\\n            str += \'&lt;\\\\\\/script&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;ueditor&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        \\r\\n        var forms = {$field.value|json_encode};\\r\\n        if (typeof forms!=\'object\') {\\r\\n            forms = {};\\r\\n        }\\r\\n        EBCMS.Form_{$field.unique}.config = forms[\'__config__\']||{};\\r\\n        delete forms[\'__config__\'];\\r\\n        $.each(forms, function(name, val) {\\r\\n            EBCMS.Form_{$field.unique}.render(name,val,\'#{$field.unique}_container\');\\r\\n        });\\r\\n    });\\r\\n&lt;\\/script&gt;\\r\\n&lt;div class=&quot;row&quot;&gt;\\r\\n    &lt;div class=&quot;col-md-12&quot;&gt;\\r\\n        &lt;div class=&quot;btn-group&quot; role=&quot;group&quot; aria-label=&quot;...&quot;&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_text(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u5355\\u884c\\u6587\\u672c&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_textarea(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u591a\\u884c\\u6587\\u672c&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_file(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u6587\\u4ef6&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_ueditor(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u7f16\\u8f91\\u6846&lt;\\/button&gt;\\r\\n        &lt;\\/div&gt;\\r\\n        &lt;br&gt;\\r\\n    &lt;\\/div&gt;\\r\\n&lt;\\/div&gt;\\r\\n&lt;div id=&quot;{$field.unique}_container&quot;&gt;&lt;\\/div&gt;\\r\\n&lt;input type=&quot;hidden&quot; name=&quot;{$field.field}[__config__][__test__]&quot; value=\'test\'&gt;\"}', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('22382', '3173', '基本信息', '内容', 'body', '', '', '0', '', 'form_ueditor', null, '', '0');
INSERT INTO `ebcms5_formfield` VALUES ('22383', '3174', '基本信息', '父级', 'pid', '', '', '3', 'pid', 'form_database', '{\"model\":\"content\\/channel\",\"editable\":\"0\",\"disabled\":\"0\",\"rootitem\":\"1\",\"tree\":\"1\",\"prompt\":\"\",\"queryparams\":\"\",\"pid\":\"\",\"titlefield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '', '90');
INSERT INTO `ebcms5_formfield` VALUES ('22384', '3174', '基本信息', '标题', 'title', '', '', '3', 'title', 'form_textbox', 'null', '', '85');
INSERT INTO `ebcms5_formfield` VALUES ('22385', '3174', '基本信息', '打开方式', 'target', '', '', '3', 'target', 'form_radio', '{\"disabled\":\"0\",\"readonly\":\"0\",\"values\":\"当前窗口|_self\\r\\n新窗口|_blank\"}', '', '60');
INSERT INTO `ebcms5_formfield` VALUES ('22386', '3174', '基本信息', '跳转链接', 'eb_url', '', '', '3', 'eb_url', 'form_textbox', null, '', '40');
INSERT INTO `ebcms5_formfield` VALUES ('22387', '3174', '基本信息', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('22388', '3175', '基本信息', '父级', 'pid', '', '', '3', 'pid', 'form_database', '{\"model\":\"content\\/channel\",\"editable\":\"0\",\"disabled\":\"0\",\"rootitem\":\"1\",\"tree\":\"1\",\"prompt\":\"\",\"queryparams\":\"\",\"pid\":\"\",\"titlefield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '', '90');
INSERT INTO `ebcms5_formfield` VALUES ('22389', '3175', '基本信息', '标题', 'title', '', '', '3', 'title', 'form_textbox', 'null', '', '85');
INSERT INTO `ebcms5_formfield` VALUES ('22390', '3175', '基本信息', '名称', 'name', '', '', '3', 'name', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '请填写英文字符，对应栏目路径，高级模式生效', '82');
INSERT INTO `ebcms5_formfield` VALUES ('22391', '3175', '其他设置', '关键字', 'keywords', '', '', '3', 'keywords', 'form_textbox', '{\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\"}', '用空格或英文的逗号”,“分割', '74');
INSERT INTO `ebcms5_formfield` VALUES ('22392', '3175', '其他设置', 'meta标题', 'eb_metatitle', '', '', '3', 'eb_metatitle', 'form_textbox', '{\"required\":\"0\",\"readonly\":\"0\",\"disabled\":\"0\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"prompt\":\"\"}', '不填则默认为标题', '74');
INSERT INTO `ebcms5_formfield` VALUES ('22393', '3175', '其他设置', '摘要', 'description', '', '', '3', 'description', 'form_multitextbox', 'null', '', '73');
INSERT INTO `ebcms5_formfield` VALUES ('22394', '3175', '基本信息', '打开方式', 'target', '', '', '3', 'target', 'form_radio', '{\"disabled\":\"0\",\"readonly\":\"0\",\"values\":\"当前窗口|_self\\r\\n新窗口|_blank\"}', '', '60');
INSERT INTO `ebcms5_formfield` VALUES ('22395', '3175', '基本信息', '内容', 'body', '', '', '3', 'body', 'form_ueditor', null, '', '40');
INSERT INTO `ebcms5_formfield` VALUES ('22396', '3175', '其他设置', '模板', 'tpl', '', '', '3', 'tpl', 'form_textbox', '{\"prompt\":\"默认为page\"}', '默认为page', '22');
INSERT INTO `ebcms5_formfield` VALUES ('22397', '3175', '基本信息', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('22398', '3175', '自定义数据', '自定义数据', 'eb_ext', '', '', '3', 'eb_ext', 'form_custom', '{\"html\":\"&lt;script&gt;\\r\\n    Namespace.register(&quot;EBCMS.Form_{$field.unique}&quot;);\\r\\n    $(function() {\\r\\n\\r\\n        \\/*\\u6539\\u540d\\u540d\\u79f0*\\/\\r\\n        EBCMS.Form_{$field.unique}.changename = function(id,value){\\r\\n            if ($(id).is(\'div\')) {\\r\\n                \\/*\\u7f16\\u8f91\\u5668*\\/\\r\\n                $(id).next().attr(\'name\',\'{$field.field}[\'+value+\']\');\\r\\n            }else{\\r\\n                $(id).attr(\'name\',\'{$field.field}[\'+value+\']\');\\r\\n            }\\r\\n            $(id+\'__config__\').attr(\'name\',\'{$field.field}[__config__][\'+value+\']\');\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.up = function(dom){\\r\\n            var thisdom = $(dom).parent().parent().parent();\\r\\n            if (thisdom.prev().length) {\\r\\n                thisdom.insertBefore(thisdom.prev());\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.down = function(dom){\\r\\n            var thisdom = $(dom).parent().parent().parent();\\r\\n            if (thisdom.next().length) {\\r\\n                thisdom.next().insertBefore(thisdom);\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render = function(name,value,target){\\r\\n            if (EBCMS.Form_{$field.unique}.config[name]) {\\r\\n                \\r\\n            }else{\\r\\n                EBCMS.Form_{$field.unique}.config[name] = \'text\';\\r\\n            }\\r\\n            if (EBCMS.Form_{$field.unique}[\'render_\'+EBCMS.Form_{$field.unique}.config[name]]) {\\r\\n                EBCMS.Form_{$field.unique}[\'render_\'+EBCMS.Form_{$field.unique}.config[name]](name,value,target);\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_text = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; value=&quot;\'+opt.value+\'&quot; placeholder=&quot;\\u586b\\u5199\\u5185\\u5bb9&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;text&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_textarea = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;textarea class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; rows=&quot;3&quot; placeholder=&quot;\\u586b\\u5199\\u5185\\u5bb9&quot;&gt;\'+opt.value+\'&lt;\\/textarea&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;textarea&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_file = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;table class=&quot;table&quot; style=&quot;margin-bottom: 0px;&quot;&gt;\';\\r\\n            str += \'&lt;tr&gt;\';\\r\\n            str += \'&lt;td style=&quot;padding: 0px !important;border-top:none;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; value=&quot;\'+opt.value+\'&quot; placeholder=&quot;\\u586b\\u5199\\u5185\\u5bb9&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;file&quot;&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td style=&quot;width: 100px;padding: 0px 0px 0px 10px !important;border-top:none;&quot;&gt;\';\\r\\n            str += \'&lt;div id=&quot;\'+opt.id+\'_pick&quot;&gt;\\u4e0a\\u4f20&lt;\\/div&gt;\';\\r\\n            str += \'&lt;script&gt;\';\\r\\n            str += \'$(function(){\';\\r\\n            str += \'    EBCMS.MYFUN.renderUploader(\\\\\'#\'+opt.id+\'_pick\\\\\',function(file,res){ if (res.code) { $(\\\\\'#\'+opt.id+\'\\\\\').val(res.data.pathname); }else{ EBCMS.MSG.alert(res.msg);};});\';\\r\\n            str += \'});\';\\r\\n            str += \'&lt;\\\\\\/script&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;\\/tr&gt;\';\\r\\n            str += \'&lt;\\/table&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_ueditor = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;textarea id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; &gt;\'+opt.value+\'&lt;\\/textarea&gt;\';\\r\\n            str += \'&lt;script&gt;\';\\r\\n            str += \'$(function(){\';\\r\\n            str += \'    EBCMS.MYFUN.renderUE(&quot;\'+opt.id+\'&quot;,{\';\\r\\n            str += \'          autoHeightEnabled:false,\';\\r\\n            str += \'          maximumWords:99999,\';\\r\\n            str += \'          wordCount:true,\';\\r\\n            str += \'          elementPathEnabled:true,\';\\r\\n            str += \'          initialFrameHeight:400,\';\\r\\n            str += \'    });\';\\r\\n            str += \'});\';\\r\\n            str += \'&lt;\\\\\\/script&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;ueditor&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        \\r\\n        var forms = {$field.value|json_encode};\\r\\n        if (typeof forms!=\'object\') {\\r\\n            forms = {};\\r\\n        }\\r\\n        EBCMS.Form_{$field.unique}.config = forms[\'__config__\']||{};\\r\\n        delete forms[\'__config__\'];\\r\\n        $.each(forms, function(name, val) {\\r\\n            EBCMS.Form_{$field.unique}.render(name,val,\'#{$field.unique}_container\');\\r\\n        });\\r\\n    });\\r\\n&lt;\\/script&gt;\\r\\n&lt;div class=&quot;row&quot;&gt;\\r\\n    &lt;div class=&quot;col-md-12&quot;&gt;\\r\\n        &lt;div class=&quot;btn-group&quot; role=&quot;group&quot; aria-label=&quot;...&quot;&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_text(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u5355\\u884c\\u6587\\u672c&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_textarea(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u591a\\u884c\\u6587\\u672c&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_file(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u6587\\u4ef6&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_ueditor(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u7f16\\u8f91\\u6846&lt;\\/button&gt;\\r\\n        &lt;\\/div&gt;\\r\\n        &lt;br&gt;\\r\\n    &lt;\\/div&gt;\\r\\n&lt;\\/div&gt;\\r\\n&lt;div id=&quot;{$field.unique}_container&quot;&gt;&lt;\\/div&gt;\\r\\n&lt;input type=&quot;hidden&quot; name=&quot;{$field.field}[__config__][__test__]&quot; value=\'test\'&gt;\"}', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('22399', '3176', '基本信息', '标题', 'title', '', '', '3', 'title', 'form_textbox', 'null', '', '600');
INSERT INTO `ebcms5_formfield` VALUES ('22400', '3176', '高级设置', 'META标题', 'eb_metatitle', '', '', '3', 'eb_metatitle', 'form_textbox', 'null', '用作seo标题设置，不填则默认为标题', '300');
INSERT INTO `ebcms5_formfield` VALUES ('22401', '3176', '高级设置', '短标题', 'eb_shorttitle', '', '', '3', 'eb_shorttitle', 'form_textbox', 'null', '一般用作 首页 列表页调用 没有则调用标题', '70');
INSERT INTO `ebcms5_formfield` VALUES ('22402', '3176', '基本信息', '关键字', 'keywords', '', '', '3', 'keywords', 'form_custom', '{\"html\":\"&lt;script&gt;\\r\\n    $(function() {\\r\\n        EBCMS.CORE.myfun(\'suggest_keywords\',function(container,content,strong){\\r\\n            if (content) {\\r\\n                if (content != 0) {\\r\\n                    if ($(container).val()) {\\r\\n                        var keywords = $(container).val().split(\',\');\\r\\n                        var ue = UE.getEditor(content);\\r\\n                        var contents = ue.getContent().split(\'\\uff0c\');\\r\\n                        var num = Math.min(keywords.length,contents.length-1);\\r\\n                        var nums = EBCMS.FN.random_num(num,0,contents.length-1);\\r\\n                        $.each(nums, function(index, val) {\\r\\n                            if (strong == 1) {\\r\\n                                contents[val] = contents[val]+\'\\uff0c&lt;strong&gt;\'+keywords[index]+\'&lt;\\/strong&gt;\';\\r\\n                            }else{\\r\\n                                contents[val] = contents[val]+\'\\uff0c\'+keywords[index];\\r\\n                            }\\r\\n                        });\\r\\n                        ue.setContent(contents.join(\'\\uff0c\'));\\r\\n                    }\\r\\n                }else{\\r\\n                    EBCMS.MSG.notice(\'\\u672a\\u914d\\u7f6e\\u63a5\\u6536\\u5b57\\u6bb5\\uff01\');\\r\\n                }\\r\\n            }else{\\r\\n                EBCMS.MSG.tips(\'\\u83b7\\u53d6\\u4e2d...\');\\r\\n                $.ajax({\\r\\n                    url: \'{:url(\'ebcms\\/api\\/index\')}\',\\r\\n                    type: \'POST\',\\r\\n                    dataType: \'json\',\\r\\n                    data: {\\r\\n                        api: \'suggest_keywords\',\\r\\n                        k:$(container).val(),\\r\\n                    },\\r\\n                    success:function(res){\\r\\n                        if (res.data &amp;&amp; res.data.length) {\\r\\n                            EBCMS.MSG.tips(\'\\u83b7\\u53d6\\u6210\\u529f...\',0.5);\\r\\n                            $(container).val($(container).val()+\',\'+res.data.join(\',\'));\\r\\n                        }else{\\r\\n                            EBCMS.MSG.tips(\'\\u6682\\u65e0\\u5185\\u5bb9...\');\\r\\n                        }\\r\\n                    },\\r\\n                    error:function(){\\r\\n                        EBCMS.MSG.alert(\'\\u670d\\u52a1\\u5668\\u5fd9\\uff0c\\u8bf7\\u7a0d\\u540e\\u518d\\u8bd5\\uff01\');\\r\\n                    }\\r\\n                });\\r\\n            }\\r\\n        });\\r\\n    });\\r\\n&lt;\\/script&gt;\\r\\n&lt;table class=&quot;table&quot; style=&quot;margin-bottom: 0px;&quot;&gt;\\r\\n    &lt;tr&gt;\\r\\n        &lt;td style=&quot;padding: 0px !important;border-top:none;&quot;&gt;\\r\\n            &lt;input id=&quot;{$field.unique}&quot; class=&quot;form-control&quot; name=&quot;{$field.field}&quot; value=&quot;{$field.value}&quot; placeholder=&quot;{$field.config.prompt|default=\'\'}&quot; {eq name=\'field.config.disabled\' value=\'1\'} disabled{\\/eq} {eq name=\'field.config.readonly\' value=\'1\'} readonly{\\/eq}\\/&gt;\\r\\n        &lt;\\/td&gt;\\r\\n        &lt;td style=&quot;width: 100px;padding: 0px 0px 0px 10px !important;border-top:none;&quot;&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-block&quot; onclick=&quot;EBCMS.MYFUN.suggest_keywords(\'#{$field.unique}\');&quot;&gt;\\u957f\\u5c3e\\u5173\\u952e\\u8bcd&lt;\\/button&gt;\\r\\n        &lt;\\/td&gt;\\r\\n        &lt;td style=&quot;width: 100px;padding: 0px 0px 0px 10px !important;border-top:none;&quot;&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-block&quot; onclick=&quot;EBCMS.MYFUN.suggest_keywords(\'#{$field.unique}\',\'{$groups[\'\\u57fa\\u672c\\u4fe1\\u606f\'][\'body[body]\'][\'unique\']}\',1);&quot;&gt;\\u63d2\\u5165\\u5230\\u5185\\u5bb9&lt;\\/button&gt;\\r\\n        &lt;\\/td&gt;\\r\\n    &lt;\\/tr&gt;\\r\\n&lt;\\/table&gt;\"}', '', '60');
INSERT INTO `ebcms5_formfield` VALUES ('22403', '3176', '高级设置', '摘要', 'description', '', '', '3', 'description', 'form_multitextbox', 'null', '', '50');
INSERT INTO `ebcms5_formfield` VALUES ('22404', '3176', '高级设置', '模板', 'tpl', '', '', '3', 'tpl', 'form_textbox', '{\"prompt\":\"不填写 默认为detail\"}', '只填写文件名，不要写后缀\n模板位于 application/content/view/index/下', '40');
INSERT INTO `ebcms5_formfield` VALUES ('22405', '3176', '基本信息', '标签', 'tags', '', '', '3', 'tags', 'form_textbox', '{\"required\":\"0\",\"readonly\":\"0\",\"disabled\":\"0\",\"maxlength\":\"\",\"minlength\":\"\",\"prompt\":\"\"}', '', '35');
INSERT INTO `ebcms5_formfield` VALUES ('22406', '3176', '高级设置', '文件名', 'filename', '', '', '3', 'filename', 'form_textbox', '{\"prompt\":\"\"}', '默认为文章id', '30');
INSERT INTO `ebcms5_formfield` VALUES ('22407', '3176', '基本信息', '缩略图', 'thumb', '', '', '3', 'thumb', 'form_upload', '{\"disabled\":\"0\",\"readonly\":\"0\",\"extensions\":\"\",\"path\":\"\\/content\",\"prompt\":\"\"}', '', '20');
INSERT INTO `ebcms5_formfield` VALUES ('22408', '3176', '高级设置', '外部链接', 'eb_url', '', '', '3', 'eb_url', 'form_textbox', '{\"required\":\"0\",\"readonly\":\"0\",\"disabled\":\"0\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"0\",\"prompt\":\"http:\\/\\/\"}', '常规写法：http://www.ebcms.com/news.html\n系统写法：content/index/channel?id=1', '10');
INSERT INTO `ebcms5_formfield` VALUES ('22409', '3176', '基本信息', '内容', 'body', 'body', '', '3', 'body', 'form_ueditor', 'null', '', '10');
INSERT INTO `ebcms5_formfield` VALUES ('22410', '3176', '高级设置', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '0');
INSERT INTO `ebcms5_formfield` VALUES ('22411', '3177', '基本信息', '内容id', 'ids', '', '', '1', 'ids', 'form_multitextbox', 'null', '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('22412', '3177', '基本信息', '移动到', 'channel_id', '', '', '1', 'channel_id', 'form_database', '{\"model\":\"content\\/channel\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"0\",\"tree\":\"1\",\"prompt\":\"\",\"queryparams\":\"type|eq|channel\",\"pid\":\"\",\"titlefield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '如果移动的内容和移动到的栏目的模型不一样，会造成移动的内容中模型不一样的那一部分数据的自定义扩展内容数据丢失，但主体内容数据不会丢失！\n非超级管理员操作，会自动排除已经锁定的数据。', '1');
INSERT INTO `ebcms5_formfield` VALUES ('22413', '3178', '基本信息', '父级', 'pid', '', '', '3', 'pid', 'form_database', '{\"model\":\"content\\/channel\",\"editable\":\"0\",\"disabled\":\"0\",\"rootitem\":\"1\",\"tree\":\"1\",\"prompt\":\"\",\"queryparams\":\"\",\"pid\":\"\",\"titlefield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '', '90');
INSERT INTO `ebcms5_formfield` VALUES ('22414', '3178', '基本信息', '标题', 'title', '', '', '3', 'title', 'form_textbox', 'null', '', '85');
INSERT INTO `ebcms5_formfield` VALUES ('22415', '3178', '基本信息', '名称', 'name', '', '', '3', 'name', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '请填写英文字符，对应栏目路径，高级模式生效', '82');
INSERT INTO `ebcms5_formfield` VALUES ('22416', '3178', '其他设置', '关键字', 'keywords', '', '', '3', 'keywords', 'form_textbox', '{\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\"}', '用空格或英文的逗号”,“分割', '74');
INSERT INTO `ebcms5_formfield` VALUES ('22417', '3178', '其他设置', 'meta标题', 'eb_metatitle', '', '', '3', 'eb_metatitle', 'form_textbox', '{\"required\":\"0\",\"readonly\":\"0\",\"disabled\":\"0\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"prompt\":\"\"}', '不填则默认为标题', '74');
INSERT INTO `ebcms5_formfield` VALUES ('22418', '3178', '其他设置', '摘要', 'description', '', '', '3', 'description', 'form_multitextbox', 'null', '', '73');
INSERT INTO `ebcms5_formfield` VALUES ('22419', '3178', '基本信息', '打开方式', 'target', '', '', '3', 'target', 'form_radio', '{\"disabled\":\"0\",\"readonly\":\"0\",\"values\":\"当前窗口|_self\\r\\n新窗口|_blank\"}', '', '60');
INSERT INTO `ebcms5_formfield` VALUES ('22420', '3178', '基本信息', '栏目模型', 'extend_id', '', '', '3', 'extend_id', 'form_database', '{\"model\":\"ebcms\\/extend\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"1\",\"group\":\"1\",\"tree\":\"0\",\"prompt\":\"\",\"queryparams\":\"\",\"pid\":\"\",\"titlefield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '在 【系统管理 =&gt; 模型扩展】 里面设置\r\n可以根据自身网站需要扩展出 产品模型 图集模型 下载模型等等', '41');
INSERT INTO `ebcms5_formfield` VALUES ('22421', '3178', '其他设置', '列表页模板', 'tpl', '', '', '3', 'tpl', 'form_textbox', '{\"prompt\":\"不填写 默认为channel\"}', '只填写文件名，不要写填写后缀\r\n模板文件位于 application/content/view/index/下面', '22');
INSERT INTO `ebcms5_formfield` VALUES ('22422', '3178', '其他设置', '内容页模板', 'tpl_detail', '', '', '3', 'tpl_detail', 'form_textbox', '{\"prompt\":\"不填写 默认为detail\"}', '只填写文件名，不要写填写后缀\r\n模板文件位于 application/content/view/index/下面', '21');
INSERT INTO `ebcms5_formfield` VALUES ('22423', '3178', '基本信息', 'id', 'id', '', '', '1', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('22424', '3178', '自定义数据', '自定义数据', 'eb_ext', '', '', '3', 'eb_ext', 'form_custom', '{\"html\":\"&lt;script&gt;\\r\\n    Namespace.register(&quot;EBCMS.Form_{$field.unique}&quot;);\\r\\n    $(function() {\\r\\n\\r\\n        \\/*\\u6539\\u540d\\u540d\\u79f0*\\/\\r\\n        EBCMS.Form_{$field.unique}.changename = function(id,value){\\r\\n            if ($(id).is(\'div\')) {\\r\\n                \\/*\\u7f16\\u8f91\\u5668*\\/\\r\\n                $(id).next().attr(\'name\',\'{$field.field}[\'+value+\']\');\\r\\n            }else{\\r\\n                $(id).attr(\'name\',\'{$field.field}[\'+value+\']\');\\r\\n            }\\r\\n            $(id+\'__config__\').attr(\'name\',\'{$field.field}[__config__][\'+value+\']\');\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.up = function(dom){\\r\\n            var thisdom = $(dom).parent().parent().parent();\\r\\n            if (thisdom.prev().length) {\\r\\n                thisdom.insertBefore(thisdom.prev());\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.down = function(dom){\\r\\n            var thisdom = $(dom).parent().parent().parent();\\r\\n            if (thisdom.next().length) {\\r\\n                thisdom.next().insertBefore(thisdom);\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render = function(name,value,target){\\r\\n            if (EBCMS.Form_{$field.unique}.config[name]) {\\r\\n                \\r\\n            }else{\\r\\n                EBCMS.Form_{$field.unique}.config[name] = \'text\';\\r\\n            }\\r\\n            if (EBCMS.Form_{$field.unique}[\'render_\'+EBCMS.Form_{$field.unique}.config[name]]) {\\r\\n                EBCMS.Form_{$field.unique}[\'render_\'+EBCMS.Form_{$field.unique}.config[name]](name,value,target);\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_text = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; value=&quot;\'+opt.value+\'&quot; placeholder=&quot;\\u586b\\u5199\\u5185\\u5bb9&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;text&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_textarea = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;textarea class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; rows=&quot;3&quot; placeholder=&quot;\\u586b\\u5199\\u5185\\u5bb9&quot;&gt;\'+opt.value+\'&lt;\\/textarea&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;textarea&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_file = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;table class=&quot;table&quot; style=&quot;margin-bottom: 0px;&quot;&gt;\';\\r\\n            str += \'&lt;tr&gt;\';\\r\\n            str += \'&lt;td style=&quot;padding: 0px !important;border-top:none;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; value=&quot;\'+opt.value+\'&quot; placeholder=&quot;\\u586b\\u5199\\u5185\\u5bb9&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;file&quot;&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td style=&quot;width: 100px;padding: 0px 0px 0px 10px !important;border-top:none;&quot;&gt;\';\\r\\n            str += \'&lt;div id=&quot;\'+opt.id+\'_pick&quot;&gt;\\u4e0a\\u4f20&lt;\\/div&gt;\';\\r\\n            str += \'&lt;script&gt;\';\\r\\n            str += \'$(function(){\';\\r\\n            str += \'    EBCMS.MYFUN.renderUploader(\\\\\'#\'+opt.id+\'_pick\\\\\',function(file,res){ if (res.code) { $(\\\\\'#\'+opt.id+\'\\\\\').val(res.data.pathname); }else{ EBCMS.MSG.alert(res.msg);};});\';\\r\\n            str += \'});\';\\r\\n            str += \'&lt;\\\\\\/script&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;\\/tr&gt;\';\\r\\n            str += \'&lt;\\/table&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_ueditor = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;textarea id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; &gt;\'+opt.value+\'&lt;\\/textarea&gt;\';\\r\\n            str += \'&lt;script&gt;\';\\r\\n            str += \'$(function(){\';\\r\\n            str += \'    EBCMS.MYFUN.renderUE(&quot;\'+opt.id+\'&quot;,{\';\\r\\n            str += \'          autoHeightEnabled:false,\';\\r\\n            str += \'          maximumWords:99999,\';\\r\\n            str += \'          wordCount:true,\';\\r\\n            str += \'          elementPathEnabled:true,\';\\r\\n            str += \'          initialFrameHeight:400,\';\\r\\n            str += \'    });\';\\r\\n            str += \'});\';\\r\\n            str += \'&lt;\\\\\\/script&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;ueditor&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        \\r\\n        var forms = {$field.value|json_encode};\\r\\n        if (typeof forms!=\'object\') {\\r\\n            forms = {};\\r\\n        }\\r\\n        EBCMS.Form_{$field.unique}.config = forms[\'__config__\']||{};\\r\\n        delete forms[\'__config__\'];\\r\\n        $.each(forms, function(name, val) {\\r\\n            EBCMS.Form_{$field.unique}.render(name,val,\'#{$field.unique}_container\');\\r\\n        });\\r\\n    });\\r\\n&lt;\\/script&gt;\\r\\n&lt;div class=&quot;row&quot;&gt;\\r\\n    &lt;div class=&quot;col-md-12&quot;&gt;\\r\\n        &lt;div class=&quot;btn-group&quot; role=&quot;group&quot; aria-label=&quot;...&quot;&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_text(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u5355\\u884c\\u6587\\u672c&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_textarea(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u591a\\u884c\\u6587\\u672c&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_file(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u6587\\u4ef6&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_ueditor(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u7f16\\u8f91\\u6846&lt;\\/button&gt;\\r\\n        &lt;\\/div&gt;\\r\\n        &lt;br&gt;\\r\\n    &lt;\\/div&gt;\\r\\n&lt;\\/div&gt;\\r\\n&lt;div id=&quot;{$field.unique}_container&quot;&gt;&lt;\\/div&gt;\\r\\n&lt;input type=&quot;hidden&quot; name=&quot;{$field.field}[__config__][__test__]&quot; value=\'test\'&gt;\"}', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('22425', '3179', '基本信息', '父级', 'pid', '', '', '1', 'pid', 'form_database', '{\"model\":\"content\\/channel\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"1\",\"group\":\"0\",\"tree\":\"1\",\"prompt\":\"\",\"queryparams\":\"\",\"pid\":\"\",\"titlefield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '', '90');
INSERT INTO `ebcms5_formfield` VALUES ('22426', '3179', '基本信息', '标题', 'title', '', '', '0', '', 'form_textbox', '{\"required\":\"0\",\"editable\":\"1\",\"maxlength\":\"80\",\"minlength\":\"\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '', '85');
INSERT INTO `ebcms5_formfield` VALUES ('22427', '3179', '基本信息', '类型', 'type', '', '', '0', 'jump', 'form_hidden', '{\"html\":\"&lt;tr&gt;\\r\\n\\t&lt;th&gt;{$field.title}&lt;\\/th&gt;\\r\\n\\t&lt;td&gt;\\r\\n\\t\\t{php}\\r\\n\\t\\t\\t$radios = [\'channel\'=&gt;\'栏目\',\'page\'=&gt;\'单页\',\'jump\'=&gt;\'跳转\'];\\r\\n\\t\\t{\\/php}\\r\\n\\t\\t{foreach name=\'radios\' item=\'_temp\'}\\r\\n\\t\\t\\t&lt;label class=&quot;radio-inline&quot; for=&quot;{$field.unique}_{$key}&quot;&gt;\\r\\n\\t\\t\\t\\t&lt;input type=&quot;radio&quot; name=&quot;{$field.field}&quot; onclick=&quot;M_{$field.unique}.x();&quot; id=&quot;{$field.unique}_{$key}&quot; value=&quot;{$key}&quot; {eq name=&quot;field.value&quot; value=\'$key\'}checked{\\/eq}&gt; {$_temp}\\r\\n\\t\\t\\t&lt;\\/label&gt;\\r\\n\\t\\t{\\/foreach}\\r\\n\\t\\t&lt;script&gt;\\r\\n\\t\\t\\tvar M_{$field.unique} = {};\\r\\n\\t\\t\\t$(function() {\\r\\n\\t\\t\\t\\tM_{$field.unique}.x = function(){\\r\\n\\t\\t\\t\\t\\tvar val = $(&quot;input[name={$field.field}]:checked&quot;).val();\\r\\n\\t\\t\\t\\t\\tvar fields = [\'eb_metatitle\',\'keywords\',\'description\',\'extend_id\',\'tpl\',\'tpl_detail\',\'eb_url\',\'body\'];\\r\\n\\t\\t\\t\\t\\tswitch(val){\\r\\n\\t\\t\\t\\t\\t\\tcase \'channel\':\\r\\n\\t\\t\\t\\t\\t\\t\\tvar field = [\'eb_metatitle\',\'keywords\',\'description\',\'extend_id\',\'tpl\',\'tpl_detail\'];\\r\\n\\t\\t\\t\\t\\t\\tbreak;\\r\\n\\t\\t\\t\\t\\t\\tcase \'page\':\\r\\n\\t\\t\\t\\t\\t\\t\\tvar field = [\'eb_metatitle\',\'keywords\',\'description\',\'tpl\',\'body\'];\\r\\n\\t\\t\\t\\t\\t\\tbreak;\\r\\n\\t\\t\\t\\t\\t\\tcase \'jump\':\\r\\n\\t\\t\\t\\t\\t\\t\\tvar field = [\'eb_url\'];\\r\\n\\t\\t\\t\\t\\t\\tbreak;\\r\\n\\t\\t\\t\\t\\t\\tdefault:\\r\\n\\r\\n\\t\\t\\t\\t\\t}\\r\\n\\t\\t\\t\\t\\t$.each(fields, function(index, f) {\\r\\n\\t\\t\\t\\t\\t\\tif (-1 == field.indexOf(f)) {\\r\\n\\t\\t\\t\\t\\t\\t\\t$(\'*[name=\'+f+\']\').closest(\'tr\').hide();\\r\\n\\t\\t\\t\\t\\t\\t}else{\\r\\n\\t\\t\\t\\t\\t\\t\\t$(\'*[name=\'+f+\']\').closest(\'tr\').show();\\r\\n\\t\\t\\t\\t\\t\\t}\\r\\n\\t\\t\\t\\t\\t});\\r\\n\\t\\t\\t\\t\\tif (val == \'jump\') {\\r\\n\\t\\t\\t\\t\\t\\t$(\'form .tabs .tab-head\').eq(0).siblings().hide();\\r\\n\\t\\t\\t\\t\\t}else{\\r\\n\\t\\t\\t\\t\\t\\t$(\'form .tabs .tab-head\').eq(0).siblings().show();\\r\\n\\t\\t\\t\\t\\t}\\r\\n\\t\\t\\t\\t}\\r\\n\\t\\t\\t\\tif (\'{$field.value}\' != \'\') {\\r\\n\\t\\t\\t\\t\\t$(\'input[name={$field.field}][value={$field.value}]\').trigger(\'click\');\\r\\n\\t\\t\\t\\t\\t$(\'input[name={$field.field}][value={$field.value}]\').closest(\'tr\').hide();\\r\\n\\t\\t\\t\\t}else{\\r\\n\\t\\t\\t\\t\\t$(\'input[name={$field.field}]\').eq(0).trigger(\'click\');\\r\\n\\t\\t\\t\\t}\\r\\n\\t\\t\\t});\\r\\n\\t\\t&lt;\\/script&gt;\\r\\n\\t&lt;\\/td&gt;\\r\\n&lt;\\/tr&gt;\"}', '', '80');
INSERT INTO `ebcms5_formfield` VALUES ('22428', '3179', '基本信息', '打开方式', 'target', '', '', '0', '_self', 'form_radio', '{\"disabled\":\"0\",\"readonly\":\"0\",\"values\":\"当前窗口|_self\\r\\n新窗口|_blank\"}', '', '50');
INSERT INTO `ebcms5_formfield` VALUES ('22429', '3179', '基本信息', '跳转链接', 'eb_url', '', '', '0', '', 'form_textbox', null, '', '0');
INSERT INTO `ebcms5_formfield` VALUES ('22430', '3180', '基本信息', '标题', 'title', '', '', '0', '', 'form_textbox', 'null', '', '600');
INSERT INTO `ebcms5_formfield` VALUES ('22431', '3180', '高级设置', 'META标题', 'eb_metatitle', '', '', '0', '', 'form_textbox', 'null', '用作seo标题设置，不填则默认为标题', '300');
INSERT INTO `ebcms5_formfield` VALUES ('22432', '3180', '高级设置', '短标题', 'eb_shorttitle', '', '', '0', '', 'form_textbox', 'null', '一般用作 首页 列表页调用 没有则调用标题', '70');
INSERT INTO `ebcms5_formfield` VALUES ('22433', '3180', '高级设置', '摘要', 'description', '', '', '0', '', 'form_multitextbox', 'null', '', '50');
INSERT INTO `ebcms5_formfield` VALUES ('22434', '3180', '基本信息', '关键字', 'keywords', '', '', '0', '', 'form_custom', '{\"html\":\"&lt;script&gt;\\r\\n    $(function() {\\r\\n        EBCMS.CORE.myfun(\'suggest_keywords\',function(container,content,strong){\\r\\n            if (content) {\\r\\n                if (content != 0) {\\r\\n                    if ($(container).val()) {\\r\\n                        var keywords = $(container).val().split(\',\');\\r\\n                        var ue = UE.getEditor(content);\\r\\n                        var contents = ue.getContent().split(\'\\uff0c\');\\r\\n                        var num = Math.min(keywords.length,contents.length-1);\\r\\n                        var nums = EBCMS.FN.random_num(num,0,contents.length-1);\\r\\n                        $.each(nums, function(index, val) {\\r\\n                            if (strong == 1) {\\r\\n                                contents[val] = contents[val]+\'\\uff0c&lt;strong&gt;\'+keywords[index]+\'&lt;\\/strong&gt;\';\\r\\n                            }else{\\r\\n                                contents[val] = contents[val]+\'\\uff0c\'+keywords[index];\\r\\n                            }\\r\\n                        });\\r\\n                        ue.setContent(contents.join(\'\\uff0c\'));\\r\\n                    }\\r\\n                }else{\\r\\n                    EBCMS.MSG.notice(\'\\u672a\\u914d\\u7f6e\\u63a5\\u6536\\u5b57\\u6bb5\\uff01\');\\r\\n                }\\r\\n            }else{\\r\\n                EBCMS.MSG.tips(\'\\u83b7\\u53d6\\u4e2d...\');\\r\\n                $.ajax({\\r\\n                    url: \'{:url(\'ebcms\\/api\\/index\')}\',\\r\\n                    type: \'POST\',\\r\\n                    dataType: \'json\',\\r\\n                    data: {\\r\\n                        api: \'suggest_keywords\',\\r\\n                        k:$(container).val(),\\r\\n                    },\\r\\n                    success:function(res){\\r\\n                        if (res.data &amp;&amp; res.data.length) {\\r\\n                            EBCMS.MSG.tips(\'\\u83b7\\u53d6\\u6210\\u529f...\',0.5);\\r\\n                            $(container).val($(container).val()+\',\'+res.data.join(\',\'));\\r\\n                        }else{\\r\\n                            EBCMS.MSG.tips(\'\\u6682\\u65e0\\u5185\\u5bb9...\');\\r\\n                        }\\r\\n                    },\\r\\n                    error:function(){\\r\\n                        EBCMS.MSG.alert(\'\\u670d\\u52a1\\u5668\\u5fd9\\uff0c\\u8bf7\\u7a0d\\u540e\\u518d\\u8bd5\\uff01\');\\r\\n                    }\\r\\n                });\\r\\n            }\\r\\n        });\\r\\n    });\\r\\n&lt;\\/script&gt;\\r\\n&lt;table class=&quot;table&quot; style=&quot;margin-bottom: 0px;&quot;&gt;\\r\\n    &lt;tr&gt;\\r\\n        &lt;td style=&quot;padding: 0px !important;border-top:none;&quot;&gt;\\r\\n            &lt;input id=&quot;{$field.unique}&quot; class=&quot;form-control&quot; name=&quot;{$field.field}&quot; value=&quot;{$field.value}&quot; placeholder=&quot;{$field.config.prompt|default=\'\'}&quot; {eq name=\'field.config.disabled\' value=\'1\'} disabled{\\/eq} {eq name=\'field.config.readonly\' value=\'1\'} readonly{\\/eq}\\/&gt;\\r\\n        &lt;\\/td&gt;\\r\\n        &lt;td style=&quot;width: 100px;padding: 0px 0px 0px 10px !important;border-top:none;&quot;&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-block&quot; onclick=&quot;EBCMS.MYFUN.suggest_keywords(\'#{$field.unique}\');&quot;&gt;\\u957f\\u5c3e\\u5173\\u952e\\u8bcd&lt;\\/button&gt;\\r\\n        &lt;\\/td&gt;\\r\\n        &lt;td style=&quot;width: 100px;padding: 0px 0px 0px 10px !important;border-top:none;&quot;&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-block&quot; onclick=&quot;EBCMS.MYFUN.suggest_keywords(\'#{$field.unique}\',\'{$groups[\'\\u57fa\\u672c\\u4fe1\\u606f\'][\'body[body]\'][\'unique\']}\',1);&quot;&gt;\\u63d2\\u5165\\u5230\\u5185\\u5bb9&lt;\\/button&gt;\\r\\n        &lt;\\/td&gt;\\r\\n    &lt;\\/tr&gt;\\r\\n&lt;\\/table&gt;\"}', '空格或英文的逗号分割', '50');
INSERT INTO `ebcms5_formfield` VALUES ('22435', '3180', '基本信息', '标签', 'tags', '', '', '0', '', 'form_textbox', 'null', '空格或英文的逗号分割', '42');
INSERT INTO `ebcms5_formfield` VALUES ('22436', '3180', '高级设置', '模板', 'tpl', '', '', '0', '', 'form_textbox', '{\"prompt\":\"不填默认为detail\"}', '只填写文件名，不要写后缀\n模板位于 application/content/view/index/下', '40');
INSERT INTO `ebcms5_formfield` VALUES ('22437', '3180', '高级设置', '文件名', 'filename', '', '', '0', '', 'form_textbox', 'null', '默认为文章id', '30');
INSERT INTO `ebcms5_formfield` VALUES ('22438', '3180', '基本信息', '缩略图', 'thumb', '', '', '0', '', 'form_upload', '{\"disabled\":\"0\",\"readonly\":\"0\",\"extensions\":\"\",\"path\":\"\\/content\",\"prompt\":\"\"}', '', '30');
INSERT INTO `ebcms5_formfield` VALUES ('22439', '3180', '基本信息', '内容', 'body', '', 'body', '0', '', 'form_ueditor', 'null', '', '20');
INSERT INTO `ebcms5_formfield` VALUES ('22440', '3180', '高级设置', '外部链接', 'eb_url', '', '', '0', '', 'form_textbox', '{\"required\":\"0\",\"readonly\":\"0\",\"disabled\":\"0\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"0\",\"prompt\":\"http:\\/\\/\"}', '常规写法：http://www.ebcms.com/news.html\n系统写法：content/index/channel?id=1', '10');
INSERT INTO `ebcms5_formfield` VALUES ('22441', '3180', '基本信息', '分类', 'channel_id', '', '', '1', 'channel_id', 'form_hidden', '{\"model\":\"content\\/channel\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"0\",\"tree\":\"1\",\"prompt\":\"\",\"queryparams\":\"extend_id|eq|($)channel.extend_id\",\"pid\":\"\",\"titlefield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '', '0');
INSERT INTO `ebcms5_formfield` VALUES ('22442', '3181', '基本信息', '父级', 'pid', '', '', '1', 'pid', 'form_database', '{\"model\":\"content\\/channel\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"1\",\"group\":\"0\",\"tree\":\"1\",\"prompt\":\"\",\"queryparams\":\"\",\"pid\":\"\",\"titlefield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '', '90');
INSERT INTO `ebcms5_formfield` VALUES ('22443', '3181', '基本信息', '标题', 'title', '', '', '0', '', 'form_textbox', '{\"required\":\"0\",\"editable\":\"1\",\"maxlength\":\"80\",\"minlength\":\"\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '', '85');
INSERT INTO `ebcms5_formfield` VALUES ('22444', '3181', '基本信息', '名称', 'name', '', '', '0', '', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"20\",\"minlength\":\"2\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"请填写英文字符\",\"width\":\"\"}', '请填写英文字符，对应栏目路径，高级模式生效', '82');
INSERT INTO `ebcms5_formfield` VALUES ('22445', '3181', '基本信息', '类型', 'type', '', '', '0', 'channel', 'form_hidden', '{\"html\":\"&lt;tr&gt;\\r\\n\\t&lt;th&gt;{$field.title}&lt;\\/th&gt;\\r\\n\\t&lt;td&gt;\\r\\n\\t\\t{php}\\r\\n\\t\\t\\t$radios = [\'channel\'=&gt;\'栏目\',\'page\'=&gt;\'单页\',\'jump\'=&gt;\'跳转\'];\\r\\n\\t\\t{\\/php}\\r\\n\\t\\t{foreach name=\'radios\' item=\'_temp\'}\\r\\n\\t\\t\\t&lt;label class=&quot;radio-inline&quot; for=&quot;{$field.unique}_{$key}&quot;&gt;\\r\\n\\t\\t\\t\\t&lt;input type=&quot;radio&quot; name=&quot;{$field.field}&quot; onclick=&quot;M_{$field.unique}.x();&quot; id=&quot;{$field.unique}_{$key}&quot; value=&quot;{$key}&quot; {eq name=&quot;field.value&quot; value=\'$key\'}checked{\\/eq}&gt; {$_temp}\\r\\n\\t\\t\\t&lt;\\/label&gt;\\r\\n\\t\\t{\\/foreach}\\r\\n\\t\\t&lt;script&gt;\\r\\n\\t\\t\\tvar M_{$field.unique} = {};\\r\\n\\t\\t\\t$(function() {\\r\\n\\t\\t\\t\\tM_{$field.unique}.x = function(){\\r\\n\\t\\t\\t\\t\\tvar val = $(&quot;input[name={$field.field}]:checked&quot;).val();\\r\\n\\t\\t\\t\\t\\tvar fields = [\'eb_metatitle\',\'keywords\',\'description\',\'extend_id\',\'tpl\',\'tpl_detail\',\'eb_url\',\'body\'];\\r\\n\\t\\t\\t\\t\\tswitch(val){\\r\\n\\t\\t\\t\\t\\t\\tcase \'channel\':\\r\\n\\t\\t\\t\\t\\t\\t\\tvar field = [\'eb_metatitle\',\'keywords\',\'description\',\'extend_id\',\'tpl\',\'tpl_detail\'];\\r\\n\\t\\t\\t\\t\\t\\tbreak;\\r\\n\\t\\t\\t\\t\\t\\tcase \'page\':\\r\\n\\t\\t\\t\\t\\t\\t\\tvar field = [\'eb_metatitle\',\'keywords\',\'description\',\'tpl\',\'body\'];\\r\\n\\t\\t\\t\\t\\t\\tbreak;\\r\\n\\t\\t\\t\\t\\t\\tcase \'jump\':\\r\\n\\t\\t\\t\\t\\t\\t\\tvar field = [\'eb_url\'];\\r\\n\\t\\t\\t\\t\\t\\tbreak;\\r\\n\\t\\t\\t\\t\\t\\tdefault:\\r\\n\\r\\n\\t\\t\\t\\t\\t}\\r\\n\\t\\t\\t\\t\\t$.each(fields, function(index, f) {\\r\\n\\t\\t\\t\\t\\t\\tif (-1 == field.indexOf(f)) {\\r\\n\\t\\t\\t\\t\\t\\t\\t$(\'*[name=\'+f+\']\').closest(\'tr\').hide();\\r\\n\\t\\t\\t\\t\\t\\t}else{\\r\\n\\t\\t\\t\\t\\t\\t\\t$(\'*[name=\'+f+\']\').closest(\'tr\').show();\\r\\n\\t\\t\\t\\t\\t\\t}\\r\\n\\t\\t\\t\\t\\t});\\r\\n\\t\\t\\t\\t\\tif (val == \'jump\') {\\r\\n\\t\\t\\t\\t\\t\\t$(\'form .tabs .tab-head\').eq(0).siblings().hide();\\r\\n\\t\\t\\t\\t\\t}else{\\r\\n\\t\\t\\t\\t\\t\\t$(\'form .tabs .tab-head\').eq(0).siblings().show();\\r\\n\\t\\t\\t\\t\\t}\\r\\n\\t\\t\\t\\t}\\r\\n\\t\\t\\t\\tif (\'{$field.value}\' != \'\') {\\r\\n\\t\\t\\t\\t\\t$(\'input[name={$field.field}][value={$field.value}]\').trigger(\'click\');\\r\\n\\t\\t\\t\\t\\t$(\'input[name={$field.field}][value={$field.value}]\').closest(\'tr\').hide();\\r\\n\\t\\t\\t\\t}else{\\r\\n\\t\\t\\t\\t\\t$(\'input[name={$field.field}]\').eq(0).trigger(\'click\');\\r\\n\\t\\t\\t\\t}\\r\\n\\t\\t\\t});\\r\\n\\t\\t&lt;\\/script&gt;\\r\\n\\t&lt;\\/td&gt;\\r\\n&lt;\\/tr&gt;\"}', '', '80');
INSERT INTO `ebcms5_formfield` VALUES ('22446', '3181', '其他设置', 'meta标题', 'eb_metatitle', '', '', '0', '', 'form_textbox', 'null', '不填则默认为标题', '74');
INSERT INTO `ebcms5_formfield` VALUES ('22447', '3181', '其他设置', '关键字', 'keywords', '', '', '0', '', 'form_textbox', '{\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\"}', '空格或英文的逗号分割', '74');
INSERT INTO `ebcms5_formfield` VALUES ('22448', '3181', '其他设置', '摘要', 'description', '', '', '0', '', 'form_multitextbox', '{\"required\":\"0\",\"height\":\"\",\"width\":\"\",\"editable\":\"1\",\"maxlength\":\"255\",\"minlength\":\"\",\"validtype\":\"\",\"prompt\":\"\",\"readonly\":\"0\",\"disabled\":\"0\"}', '', '73');
INSERT INTO `ebcms5_formfield` VALUES ('22449', '3181', '基本信息', '打开方式', 'target', '', '', '0', '_self', 'form_radio', '{\"disabled\":\"0\",\"readonly\":\"0\",\"values\":\"当前窗口|_self\\r\\n新窗口|_blank\"}', '', '50');
INSERT INTO `ebcms5_formfield` VALUES ('22450', '3181', '基本信息', '栏目模型', 'extend_id', '', '', '0', '', 'form_database', '{\"model\":\"ebcms\\/extend\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"1\",\"group\":\"1\",\"tree\":\"0\",\"prompt\":\"\",\"queryparams\":\"\",\"pid\":\"\",\"titlefield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '在 【系统管理 =&gt; 模型扩展】 里面设置\r\n可以根据自身网站需要扩展出 产品模型 图集模型 下载模型等等', '41');
INSERT INTO `ebcms5_formfield` VALUES ('22451', '3181', '其他设置', '栏目模板', 'tpl', '', '', '0', '', 'form_textbox', '{\"prompt\":\"不填写 默认为channel\"}', '只填写文件名，不要写填写后缀\r\n模板文件位于 application/content/view/index/下面', '22');
INSERT INTO `ebcms5_formfield` VALUES ('22452', '3181', '其他设置', '内容页模板', 'tpl_detail', '', '', '0', '', 'form_textbox', '{\"prompt\":\"不填写默认为 detail\"}', '只填写文件名，不要写填写后缀\r\n模板文件位于 application/content/view/index/下面', '21');
INSERT INTO `ebcms5_formfield` VALUES ('22453', '3181', '自定义数据', '自定义数据', 'eb_ext', '', '', '0', '', 'form_custom', '{\"html\":\"&lt;script&gt;\\r\\n    Namespace.register(&quot;EBCMS.Form_{$field.unique}&quot;);\\r\\n    $(function() {\\r\\n\\r\\n        \\/*\\u6539\\u540d\\u540d\\u79f0*\\/\\r\\n        EBCMS.Form_{$field.unique}.changename = function(id,value){\\r\\n            if ($(id).is(\'div\')) {\\r\\n                \\/*\\u7f16\\u8f91\\u5668*\\/\\r\\n                $(id).next().attr(\'name\',\'{$field.field}[\'+value+\']\');\\r\\n            }else{\\r\\n                $(id).attr(\'name\',\'{$field.field}[\'+value+\']\');\\r\\n            }\\r\\n            $(id+\'__config__\').attr(\'name\',\'{$field.field}[__config__][\'+value+\']\');\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.up = function(dom){\\r\\n            var thisdom = $(dom).parent().parent().parent();\\r\\n            if (thisdom.prev().length) {\\r\\n                thisdom.insertBefore(thisdom.prev());\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.down = function(dom){\\r\\n            var thisdom = $(dom).parent().parent().parent();\\r\\n            if (thisdom.next().length) {\\r\\n                thisdom.next().insertBefore(thisdom);\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render = function(name,value,target){\\r\\n            if (EBCMS.Form_{$field.unique}.config[name]) {\\r\\n                \\r\\n            }else{\\r\\n                EBCMS.Form_{$field.unique}.config[name] = \'text\';\\r\\n            }\\r\\n            if (EBCMS.Form_{$field.unique}[\'render_\'+EBCMS.Form_{$field.unique}.config[name]]) {\\r\\n                EBCMS.Form_{$field.unique}[\'render_\'+EBCMS.Form_{$field.unique}.config[name]](name,value,target);\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_text = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; value=&quot;\'+opt.value+\'&quot; placeholder=&quot;\\u586b\\u5199\\u5185\\u5bb9&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;text&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_textarea = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;textarea class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; rows=&quot;3&quot; placeholder=&quot;\\u586b\\u5199\\u5185\\u5bb9&quot;&gt;\'+opt.value+\'&lt;\\/textarea&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;textarea&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_file = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;table class=&quot;table&quot; style=&quot;margin-bottom: 0px;&quot;&gt;\';\\r\\n            str += \'&lt;tr&gt;\';\\r\\n            str += \'&lt;td style=&quot;padding: 0px !important;border-top:none;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; value=&quot;\'+opt.value+\'&quot; placeholder=&quot;\\u586b\\u5199\\u5185\\u5bb9&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;file&quot;&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;td style=&quot;width: 100px;padding: 0px 0px 0px 10px !important;border-top:none;&quot;&gt;\';\\r\\n            str += \'&lt;div id=&quot;\'+opt.id+\'_pick&quot;&gt;\\u4e0a\\u4f20&lt;\\/div&gt;\';\\r\\n            str += \'&lt;script&gt;\';\\r\\n            str += \'$(function(){\';\\r\\n            str += \'    EBCMS.MYFUN.renderUploader(\\\\\'#\'+opt.id+\'_pick\\\\\',function(file,res){ if (res.code) { $(\\\\\'#\'+opt.id+\'\\\\\').val(res.data.pathname); }else{ EBCMS.MSG.alert(res.msg);};});\';\\r\\n            str += \'});\';\\r\\n            str += \'&lt;\\\\\\/script&gt;\';\\r\\n            str += \'&lt;\\/td&gt;\';\\r\\n            str += \'&lt;\\/tr&gt;\';\\r\\n            str += \'&lt;\\/table&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        EBCMS.Form_{$field.unique}.render_ueditor = function(name,value,target){\\r\\n            name = name||\'EB_\' + EBCMS.FN.random_str(6);\\r\\n            opt = {\\r\\n                name:name,\\r\\n                value:value||\'\',\\r\\n                id:\'{$field.unique}_\' + EBCMS.FN.random_str(15),\\r\\n            };\\r\\n\\r\\n            var str = \'&lt;div class=&quot;row&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;div class=&quot;btn-group&quot;&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;$(this).parent().parent().parent().remove();&quot;&gt;\\u5220\\u9664&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.up(this);&quot;&gt;\\u4e0a\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;button type=&quot;button&quot; class=&quot;btn btn-primary&quot; onclick=&quot;EBCMS.Form_{$field.unique}.down(this);&quot;&gt;\\u4e0b\\u79fb&lt;\\/button&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-2 col-sm-6&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;input type=&quot;text&quot; class=&quot;form-control&quot; value=&quot;\'+opt.name+\'&quot; onKeyUp=&quot;EBCMS.Form_{$field.unique}.changename(\\\\\'#\'+opt.id+\'\\\\\',$(this).val());&quot; placeholder=&quot;\\u586b\\u5199\\u540d\\u79f0&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;div class=&quot;col-md-8 col-sm-12&quot; style=&quot;padding-top:15px;&quot;&gt;\';\\r\\n            str += \'&lt;textarea id=&quot;\'+opt.id+\'&quot; name=&quot;{$field.field}[\'+opt.name+\']&quot; &gt;\'+opt.value+\'&lt;\\/textarea&gt;\';\\r\\n            str += \'&lt;script&gt;\';\\r\\n            str += \'$(function(){\';\\r\\n            str += \'    EBCMS.MYFUN.renderUE(&quot;\'+opt.id+\'&quot;,{\';\\r\\n            str += \'          autoHeightEnabled:false,\';\\r\\n            str += \'          maximumWords:99999,\';\\r\\n            str += \'          wordCount:true,\';\\r\\n            str += \'          elementPathEnabled:true,\';\\r\\n            str += \'          initialFrameHeight:400,\';\\r\\n            str += \'    });\';\\r\\n            str += \'});\';\\r\\n            str += \'&lt;\\\\\\/script&gt;\';\\r\\n            str += \'&lt;input type=&quot;hidden&quot; id=&quot;\'+opt.id+\'__config__&quot; name=&quot;{$field.field}[__config__][\'+opt.name+\']&quot; value=&quot;ueditor&quot;&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            str += \'&lt;\\/div&gt;\';\\r\\n            if (target) {\\r\\n                $(target).append(str);\\r\\n            }else{\\r\\n                return str;\\r\\n            }\\r\\n        };\\r\\n        \\r\\n        var forms = {$field.value|json_encode};\\r\\n        if (typeof forms!=\'object\') {\\r\\n            forms = {};\\r\\n        }\\r\\n        EBCMS.Form_{$field.unique}.config = forms[\'__config__\']||{};\\r\\n        delete forms[\'__config__\'];\\r\\n        $.each(forms, function(name, val) {\\r\\n            EBCMS.Form_{$field.unique}.render(name,val,\'#{$field.unique}_container\');\\r\\n        });\\r\\n    });\\r\\n&lt;\\/script&gt;\\r\\n&lt;div class=&quot;row&quot;&gt;\\r\\n    &lt;div class=&quot;col-md-12&quot;&gt;\\r\\n        &lt;div class=&quot;btn-group&quot; role=&quot;group&quot; aria-label=&quot;...&quot;&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_text(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u5355\\u884c\\u6587\\u672c&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_textarea(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u591a\\u884c\\u6587\\u672c&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_file(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u6587\\u4ef6&lt;\\/button&gt;\\r\\n            &lt;button type=&quot;button&quot; class=&quot;btn btn-primary btn-sm&quot; onclick=&quot;EBCMS.Form_{$field.unique}.render_ueditor(\'\',\'\',\'#{$field.unique}_container\');&quot;&gt;\\u7f16\\u8f91\\u6846&lt;\\/button&gt;\\r\\n        &lt;\\/div&gt;\\r\\n        &lt;br&gt;\\r\\n    &lt;\\/div&gt;\\r\\n&lt;\\/div&gt;\\r\\n&lt;div id=&quot;{$field.unique}_container&quot;&gt;&lt;\\/div&gt;\\r\\n&lt;input type=&quot;hidden&quot; name=&quot;{$field.field}[__config__][__test__]&quot; value=\'test\'&gt;\"}', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('22454', '3182', '基本信息', '分组', 'group', '', '', '1', 'group', 'form_select', '{\"values\":\"友情链接|友情链接\\r\\n合作伙伴|合作伙伴\",\"editable\":\"1\",\"readonly\":\"0\",\"disabled\":\"0\"}', '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('22455', '3182', '基本信息', '名称', 'title', '', '', '0', '', 'form_textbox', 'null', '', '8');
INSERT INTO `ebcms5_formfield` VALUES ('22456', '3182', '基本信息', '网址', 'url', '', '', '0', '', 'form_textbox', 'null', '', '7');
INSERT INTO `ebcms5_formfield` VALUES ('22457', '3182', '基本信息', '站标', 'logo', '', '', '0', '', 'form_upload', '{\"extensions\":\"\",\"path\":\"\\/link\",\"prompt\":\"\"}', '', '6');
INSERT INTO `ebcms5_formfield` VALUES ('22458', '3182', '基本信息', '简介', 'description', '', '', '0', '', 'form_multitextbox', 'null', '', '5');
INSERT INTO `ebcms5_formfield` VALUES ('22459', '3182', '基本信息', '其他信息', 'info', '', '', '0', '', 'form_multitextbox', 'null', '', '4');
INSERT INTO `ebcms5_formfield` VALUES ('22460', '3183', '基本信息', '分组', 'group', '', '', '3', 'group', 'form_select', '{\"values\":\"友情链接|友情链接\\r\\n合作伙伴|合作伙伴\",\"editable\":\"1\",\"readonly\":\"0\",\"disabled\":\"0\"}', '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('22461', '3183', '基本信息', '名称', 'title', '', '', '3', 'title', 'form_textbox', 'null', '', '8');
INSERT INTO `ebcms5_formfield` VALUES ('22462', '3183', '基本信息', '网址', 'url', '', '', '3', 'url', 'form_textbox', 'null', '', '7');
INSERT INTO `ebcms5_formfield` VALUES ('22463', '3183', '基本信息', '站标', 'logo', '', '', '3', 'logo', 'form_upload', '{\"extensions\":\"\",\"path\":\"\\/link\",\"prompt\":\"\"}', '', '6');
INSERT INTO `ebcms5_formfield` VALUES ('22464', '3183', '基本信息', '简介', 'description', '', '', '3', 'description', 'form_multitextbox', 'null', '', '5');
INSERT INTO `ebcms5_formfield` VALUES ('22465', '3183', '基本信息', '其他信息', 'info', '', '', '3', 'info', 'form_multitextbox', 'null', '', '4');
INSERT INTO `ebcms5_formfield` VALUES ('22466', '3183', '基本信息', 'id', 'id', '', '', '3', 'id', 'form_hidden', 'null', '', '1');
INSERT INTO `ebcms5_formfield` VALUES ('22467', '3184', '基本信息', '留言内容', 'content', '', '', '3', 'content', 'form_multitextbox', null, '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('22468', '3184', '基本信息', '回复内容', 'reply', '', '', '3', 'reply', 'form_multitextbox', '{\"required\":\"0\",\"disabled\":\"0\",\"readonly\":\"1\",\"height\":\"\",\"width\":\"\",\"maxlength\":\"\",\"minlength\":\"\",\"prompt\":\"\"}', '', '8');
INSERT INTO `ebcms5_formfield` VALUES ('22469', '3184', '基本信息', 'id', 'id', '', '', '3', 'id', 'form_hidden', null, '', '0');
INSERT INTO `ebcms5_formfield` VALUES ('22470', '3185', '基本信息', '留言内容', 'content', '', '', '3', 'content', 'form_multitextbox', '{\"required\":\"0\",\"disabled\":\"0\",\"readonly\":\"1\",\"height\":\"\",\"width\":\"\",\"maxlength\":\"\",\"minlength\":\"\",\"prompt\":\"\"}', '', '9');
INSERT INTO `ebcms5_formfield` VALUES ('22471', '3185', '基本信息', '回复内容', 'reply', '', '', '3', 'reply', 'form_multitextbox', null, '', '8');
INSERT INTO `ebcms5_formfield` VALUES ('22472', '3185', '基本信息', 'id', 'id', '', '', '3', 'id', 'form_hidden', null, '', '0');
INSERT INTO `ebcms5_formfield` VALUES ('22473', '3186', '基本信息', '分组', 'group', '', '', '1', 'group', 'form_textbox', '', '', '90');
INSERT INTO `ebcms5_formfield` VALUES ('22474', '3186', '基本信息', '标题', 'title', '', '', '0', '', 'form_textbox', '', '', '80');
INSERT INTO `ebcms5_formfield` VALUES ('22475', '3186', '基本信息', '键', 'name', '', '', '0', '', 'form_textbox', '', '英文字符', '60');
INSERT INTO `ebcms5_formfield` VALUES ('22476', '3186', '基本信息', '值', 'value', '', '', '0', '', 'form_custom', '{\"html\":\"{switch name=&quot;$Request.param.form&quot;}\\r\\n\\t{case value=&quot;multitextbox&quot;}\\r\\n\\t\\t&lt;textarea class=&quot;form-control&quot; id=&quot;{$field.unique}&quot; name=&quot;{$field.field}&quot; rows=&quot;{$field.config.height|default=\'5\'}&quot; placeholder=&quot;{$field.config.prompt|default=\'\'}&quot; {eq name=\'field.config.disabled\' value=\'1\'} disabled{\\/eq} {eq name=\'field.config.readonly\' value=\'1\'} readonly{\\/eq}&gt;{$field.value}&lt;\\/textarea&gt;\\r\\n\\t{\\/case}\\r\\n\\t{case value=&quot;ueditor&quot;}\\r\\n\\t\\t&lt;script&gt;\\r\\n\\t\\t\\t$(function(){\\r\\n\\t\\t\\t\\tEBCMS.MYFUN.renderUE(\'{$field.unique}\',{\\r\\n\\t\\t\\t\\t\\tautoHeightEnabled:{$field.config.autoheightenabled|default=\'false\'},\\r\\n\\t\\t\\t\\t\\tmaximumWords:{$field.config.maximumwords|default=\'10000\'},\\r\\n\\t\\t\\t\\t\\twordCount:{$field.config.wordcount|default=\'true\'},\\r\\n\\t\\t\\t\\t\\telementPathEnabled:{$field.config.elementpathenabled|default=\'true\'},\\r\\n\\t\\t\\t\\t\\tinitialFrameHeight:{$field.config.initialframeheight|default=\'420\'},\\r\\n\\t\\t\\t\\t});\\r\\n\\t\\t\\t});\\r\\n\\t\\t&lt;\\/script&gt;\\r\\n\\t\\t&lt;textarea name=&quot;{$field.field}&quot; id=&quot;{$field.unique}&quot;&gt;{$field.value}&lt;\\/textarea&gt;\\r\\n\\t{\\/case}\\r\\n\\t{case value=&quot;upload&quot;}\\r\\n\\t\\t{php}\\r\\n\\t\\t\\t$field[\'config\'][\'path\'] = \'\\/mbzs\'\\r\\n\\t\\t{\\/php}\\r\\n\\t\\t&lt;script&gt;\\r\\n\\t\\t\\t$(function(){\\r\\n\\t\\t\\t\\tEBCMS.MYFUN.renderUploader(\'#{$field.unique}_pick\',function(file,res){\\r\\n\\t\\t\\t\\t\\tif (res.code) {\\r\\n\\t\\t\\t\\t\\t\\t$(\'#{$field.unique}\').val(res.data.pathname);\\r\\n\\t\\t\\t\\t\\t}else{\\r\\n\\t\\t\\t\\t\\t\\tEBCMS.MSG.alert(res.msg);\\r\\n\\t\\t\\t\\t\\t};\\r\\n\\t\\t\\t\\t},\'{$field.config.extensions|default=&quot;&quot;}\',\'{$field.config.path|default=&quot;&quot;}\');\\r\\n\\t\\t\\t});\\r\\n\\t\\t&lt;\\/script&gt;\\r\\n\\t\\t&lt;table class=&quot;table&quot; style=&quot;margin-bottom: 0px;&quot;&gt;\\r\\n\\t\\t\\t&lt;tr&gt;\\r\\n\\t\\t\\t\\t&lt;td style=&quot;padding: 0px !important;border-top: none;&quot;&gt;\\r\\n\\t\\t\\t\\t\\t&lt;input id=&quot;{$field.unique}&quot; class=&quot;form-control&quot; name=&quot;{$field.field}&quot; value=&quot;{$field.value}&quot; placeholder=&quot;{$field.config.prompt|default=\'\'}&quot; {eq name=\'field.config.disabled\' value=\'1\'} disabled{\\/eq} {eq name=\'field.config.readonly\' value=\'1\'} readonly{\\/eq}\\/&gt;\\r\\n\\t\\t\\t\\t&lt;\\/td&gt;\\r\\n\\t\\t\\t\\t&lt;td style=&quot;width: 100px;padding: 0px 0px 0px 10px !important;border-top: none;&quot;&gt;\\r\\n\\t\\t\\t\\t\\t&lt;div id=&quot;{$field.unique}_pick&quot;&gt;\\u4e0a\\u4f20&lt;\\/div&gt;\\r\\n\\t\\t\\t\\t&lt;\\/td&gt;\\r\\n\\t\\t\\t&lt;\\/tr&gt;\\r\\n\\t\\t&lt;\\/table&gt;\\r\\n\\t{\\/case}\\r\\n\\t{case value=&quot;tpl&quot;}\\r\\n\\t\\t&lt;textarea class=&quot;form-control&quot; id=&quot;{$field.unique}&quot; name=&quot;{$field.field}&quot; rows=&quot;{$field.config.height|default=\'5\'}&quot; placeholder=&quot;{$field.config.prompt|default=\'\'}&quot; {eq name=\'field.config.disabled\' value=\'1\'} disabled{\\/eq} {eq name=\'field.config.readonly\' value=\'1\'} readonly{\\/eq}&gt;{$field.value}&lt;\\/textarea&gt;\\r\\n\\t{\\/case}\\r\\n{\\/switch}\"}', '', '30');
INSERT INTO `ebcms5_formfield` VALUES ('22477', '3186', '基本信息', '备注', 'remark', '', '', '0', '', 'form_multitextbox', '', '', '20');
INSERT INTO `ebcms5_formfield` VALUES ('22478', '3186', '基本信息', '表单类型', 'form', '', '', '1', 'form', 'form_hidden', '{\"disabled\":\"0\",\"readonly\":\"0\",\"values\":\"\\u5355\\u884c\\u6587\\u672c|form_textbox\\r\\n\\u591a\\u884c\\u6587\\u672c|form_multitextbox\\r\\n\\u7f16\\u8f91\\u5668|form_ueditor\\r\\n\\u56fe\\u7247|form_image\\r\\n\\u5e03\\u5c14|form_bool\"}', '', '0');
INSERT INTO `ebcms5_formfield` VALUES ('22479', '3187', '基本信息', '分组', 'group', '', '', '3', 'group', 'form_textbox', '', '', '90');
INSERT INTO `ebcms5_formfield` VALUES ('22480', '3187', '基本信息', '标题', 'title', '', '', '3', 'title', 'form_textbox', '', '', '50');
INSERT INTO `ebcms5_formfield` VALUES ('22481', '3187', '基本信息', '键', 'name', '', '', '3', 'name', 'form_textbox', '', '', '40');
INSERT INTO `ebcms5_formfield` VALUES ('22482', '3187', '基本信息', '值', 'value', '', '', '3', 'value', 'form_custom', '{\"html\":\"{switch name=&quot;data.form&quot;}\\r\\n\\t{case value=&quot;multitextbox&quot;}\\r\\n\\t\\t&lt;textarea class=&quot;form-control&quot; id=&quot;{$field.unique}&quot; name=&quot;{$field.field}&quot; rows=&quot;{$field.config.height|default=\'5\'}&quot; placeholder=&quot;{$field.config.prompt|default=\'\'}&quot; {eq name=\'field.config.disabled\' value=\'1\'} disabled{\\/eq} {eq name=\'field.config.readonly\' value=\'1\'} readonly{\\/eq}&gt;{$field.value}&lt;\\/textarea&gt;\\r\\n\\t{\\/case}\\r\\n\\t{case value=&quot;ueditor&quot;}\\r\\n\\t\\t&lt;script&gt;\\r\\n\\t\\t\\t$(function(){\\r\\n\\t\\t\\t\\tEBCMS.MYFUN.renderUE(\'{$field.unique}\',{\\r\\n\\t\\t\\t\\t\\tautoHeightEnabled:{$field.config.autoheightenabled|default=\'false\'},\\r\\n\\t\\t\\t\\t\\tmaximumWords:{$field.config.maximumwords|default=\'10000\'},\\r\\n\\t\\t\\t\\t\\twordCount:{$field.config.wordcount|default=\'true\'},\\r\\n\\t\\t\\t\\t\\telementPathEnabled:{$field.config.elementpathenabled|default=\'true\'},\\r\\n\\t\\t\\t\\t\\tinitialFrameHeight:{$field.config.initialframeheight|default=\'420\'},\\r\\n\\t\\t\\t\\t});\\r\\n\\t\\t\\t});\\r\\n\\t\\t&lt;\\/script&gt;\\r\\n\\t\\t&lt;textarea name=&quot;{$field.field}&quot; id=&quot;{$field.unique}&quot;&gt;{$field.value}&lt;\\/textarea&gt;\\r\\n\\t{\\/case}\\r\\n\\t{case value=&quot;upload&quot;}\\r\\n\\t\\t{php}\\r\\n\\t\\t\\t$field[\'config\'][\'path\'] = \'\\/mbzs\'\\r\\n\\t\\t{\\/php}\\r\\n\\t\\t&lt;script&gt;\\r\\n\\t\\t\\t$(function(){\\r\\n\\t\\t\\t\\tEBCMS.MYFUN.renderUploader(\'#{$field.unique}_pick\',function(file,res){\\r\\n\\t\\t\\t\\t\\tif (res.code) {\\r\\n\\t\\t\\t\\t\\t\\t$(\'#{$field.unique}\').val(res.data.pathname);\\r\\n\\t\\t\\t\\t\\t}else{\\r\\n\\t\\t\\t\\t\\t\\tEBCMS.MSG.alert(res.msg);\\r\\n\\t\\t\\t\\t\\t};\\r\\n\\t\\t\\t\\t},\'{$field.config.extensions|default=&quot;&quot;}\',\'{$field.config.path|default=&quot;&quot;}\');\\r\\n\\t\\t\\t});\\r\\n\\t\\t&lt;\\/script&gt;\\r\\n\\t\\t&lt;table class=&quot;table&quot; style=&quot;margin-bottom: 0px;&quot;&gt;\\r\\n\\t\\t\\t&lt;tr&gt;\\r\\n\\t\\t\\t\\t&lt;td style=&quot;padding: 0px !important;border-top: none;&quot;&gt;\\r\\n\\t\\t\\t\\t\\t&lt;input id=&quot;{$field.unique}&quot; class=&quot;form-control&quot; name=&quot;{$field.field}&quot; value=&quot;{$field.value}&quot; placeholder=&quot;{$field.config.prompt|default=\'\'}&quot; {eq name=\'field.config.disabled\' value=\'1\'} disabled{\\/eq} {eq name=\'field.config.readonly\' value=\'1\'} readonly{\\/eq}\\/&gt;\\r\\n\\t\\t\\t\\t&lt;\\/td&gt;\\r\\n\\t\\t\\t\\t&lt;td style=&quot;width: 100px;padding: 0px 0px 0px 10px !important;border-top: none;&quot;&gt;\\r\\n\\t\\t\\t\\t\\t&lt;div id=&quot;{$field.unique}_pick&quot;&gt;\\u4e0a\\u4f20&lt;\\/div&gt;\\r\\n\\t\\t\\t\\t&lt;\\/td&gt;\\r\\n\\t\\t\\t&lt;\\/tr&gt;\\r\\n\\t\\t&lt;\\/table&gt;\\r\\n\\t{\\/case}\\r\\n\\t{case value=&quot;tpl&quot;}\\r\\n\\t\\t&lt;textarea class=&quot;form-control&quot; id=&quot;{$field.unique}&quot; name=&quot;{$field.field}&quot; rows=&quot;{$field.config.height|default=\'5\'}&quot; placeholder=&quot;{$field.config.prompt|default=\'\'}&quot; {eq name=\'field.config.disabled\' value=\'1\'} disabled{\\/eq} {eq name=\'field.config.readonly\' value=\'1\'} readonly{\\/eq}&gt;{$field.value}&lt;\\/textarea&gt;\\r\\n\\t{\\/case}\\r\\n{\\/switch}\"}', '', '30');
INSERT INTO `ebcms5_formfield` VALUES ('22483', '3187', '基本信息', '备注', 'remark', '', '', '3', 'remark', 'form_multitextbox', '', '', '20');
INSERT INTO `ebcms5_formfield` VALUES ('22484', '3187', '基本信息', 'id', 'id', '', '', '3', 'id', 'form_hidden', '', '', '4');

-- ----------------------------
-- Table structure for ebcms5_guestbook_guestbook
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_guestbook_guestbook`;
CREATE TABLE `ebcms5_guestbook_guestbook` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `nickname` varchar(255) NOT NULL DEFAULT '' COMMENT '昵称',
  `contact` varchar(255) NOT NULL DEFAULT '' COMMENT '手机号码',
  `content` text COMMENT '留言内容',
  `reply` text COMMENT '回复内容',
  `recommend` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '推荐',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '回复时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '99' COMMENT '状态',
  `ip` varchar(255) NOT NULL DEFAULT '' COMMENT 'ip地址',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='留言板表';

-- ----------------------------
-- Records of ebcms5_guestbook_guestbook
-- ----------------------------

-- ----------------------------
-- Table structure for ebcms5_link_link
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_link_link`;
CREATE TABLE `ebcms5_link_link` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `group` varchar(255) NOT NULL DEFAULT '' COMMENT '分组',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT '简介',
  `info` varchar(255) NOT NULL DEFAULT '' COMMENT '其他信息',
  `logo` varchar(255) NOT NULL DEFAULT '' COMMENT '图片地址',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '连接地址',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '99' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='友情链接表';

-- ----------------------------
-- Records of ebcms5_link_link
-- ----------------------------
INSERT INTO `ebcms5_link_link` VALUES ('1', '友情链接', '易贝网站管理系统', '', '', '', 'http://www.ebcms.com/', '1479188905', '1479188905', '0', '1');
INSERT INTO `ebcms5_link_link` VALUES ('2', '友情链接', '开源CMS', '', '', '', 'http://www.ebcms.com/', '1479189038', '1479188937', '0', '1');

-- ----------------------------
-- Table structure for ebcms5_manager
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_manager`;
CREATE TABLE `ebcms5_manager` (
  `id` int(3) unsigned NOT NULL AUTO_INCREMENT COMMENT '后台人员ID',
  `email` varchar(255) NOT NULL DEFAULT '' COMMENT 'QQ号码',
  `nickname` char(20) NOT NULL DEFAULT '' COMMENT '用户名',
  `avatar` varchar(255) NOT NULL DEFAULT '' COMMENT '头像',
  `password` char(32) NOT NULL DEFAULT '' COMMENT '密码',
  `login_times` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '登陆次数',
  `login_ip` char(15) NOT NULL DEFAULT '' COMMENT '登陆ip地址',
  `login_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最后登陆时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `sort` int(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='用户表';

-- ----------------------------
-- Records of ebcms5_manager
-- ----------------------------
INSERT INTO `ebcms5_manager` VALUES ('1', 'kujiw@qq.com', '管理员', '', '559461b6b41e9e4010dfb8f069cf0e2c', '954', '182.150.164.222', '1512801058', '0', '0', '0', '1');

-- ----------------------------
-- Table structure for ebcms5_mbzs
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_mbzs`;
CREATE TABLE `ebcms5_mbzs` (
  `id` int(4) unsigned NOT NULL AUTO_INCREMENT COMMENT '配置ID',
  `group` varchar(255) NOT NULL DEFAULT '' COMMENT '分组',
  `title` varchar(250) NOT NULL DEFAULT '' COMMENT '标题',
  `name` char(40) NOT NULL DEFAULT '' COMMENT '配置项',
  `value` text COMMENT '配置值',
  `form` varchar(255) NOT NULL DEFAULT '' COMMENT '表单类型',
  `remark` text COMMENT '说明',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `sort` int(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='核心配置表';

-- ----------------------------
-- Records of ebcms5_mbzs
-- ----------------------------
INSERT INTO `ebcms5_mbzs` VALUES ('1', '广告', '头部banner', 'header_banner', 'http://static.ebcms.com/img/ad1.gif', 'upload', '首页头部广告', '1479041750', '1479037002', '0', '1');
INSERT INTO `ebcms5_mbzs` VALUES ('2', '广告', '首页栏目上方', 'index_panel_ad', 'http://static.ebcms.com/img/ad2.gif', 'upload', '首页栏目面板上方刚搞', '1479041759', '1479037071', '0', '1');
INSERT INTO `ebcms5_mbzs` VALUES ('3', '广告', '侧栏广告', 'side_ad', 'http://static.ebcms.com/img/ad3.gif', 'upload', '', '1479041767', '1479037097', '0', '1');
INSERT INTO `ebcms5_mbzs` VALUES ('5', '碎片', '联系我们', 'lxwm', '&lt;p&gt;地址：成都高新区环球中心A座13楼&lt;/p&gt;&lt;p&gt;电话：18000534006&lt;/p&gt;', 'ueditor', '', '1499653080', '1499653080', '0', '1');

-- ----------------------------
-- Table structure for ebcms5_menu
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_menu`;
CREATE TABLE `ebcms5_menu` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '菜菜单ID',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父ID',
  `title` varchar(20) NOT NULL DEFAULT '' COMMENT '标题',
  `url` varchar(250) NOT NULL DEFAULT '' COMMENT '附加参数',
  `sort` int(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `app` varchar(255) NOT NULL DEFAULT '' COMMENT '应用',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1662 DEFAULT CHARSET=utf8 COMMENT='导航表';

-- ----------------------------
-- Records of ebcms5_menu
-- ----------------------------
INSERT INTO `ebcms5_menu` VALUES ('3', '10', '账户管理', 'ebcms/manager/index', '53', 'ebcms');
INSERT INTO `ebcms5_menu` VALUES ('4', '10', '角色管理', 'ebcms/group/index', '54', 'ebcms');
INSERT INTO `ebcms5_menu` VALUES ('8', '10', '操作日志', 'ebcms/oplog/index', '52', 'ebcms');
INSERT INTO `ebcms5_menu` VALUES ('10', '0', '系统', '', '2000', 'ebcms');
INSERT INTO `ebcms5_menu` VALUES ('11', '10', '设置中心', 'ebcms/config/index', '83', 'ebcms');
INSERT INTO `ebcms5_menu` VALUES ('22', '936', '应用商店', 'ebcms/store/index', '98', 'ebcms');
INSERT INTO `ebcms5_menu` VALUES ('560', '10', '__DIVIDER__', '', '60', 'ebcms');
INSERT INTO `ebcms5_menu` VALUES ('935', '10', '模型扩展', 'ebcms/extend/index', '81', 'ebcms');
INSERT INTO `ebcms5_menu` VALUES ('936', '0', '模块', '', '3000', 'ebcms');
INSERT INTO `ebcms5_menu` VALUES ('1030', '936', '__DIVIDER__', '', '50', 'ebcms');
INSERT INTO `ebcms5_menu` VALUES ('1315', '10', '清理缓存', 'javascript:M.runtime();', '1', 'ebcms');
INSERT INTO `ebcms5_menu` VALUES ('1330', '10', '前台导航', 'ebcms/nav/index', '80', 'ebcms');
INSERT INTO `ebcms5_menu` VALUES ('1652', '0', '内容', '', '5000', 'content');
INSERT INTO `ebcms5_menu` VALUES ('1653', '1652', '栏目管理', 'content/admin.channel/index', '9', 'content');
INSERT INTO `ebcms5_menu` VALUES ('1654', '1652', '内容管理', 'content/admin.content/index', '8', 'content');
INSERT INTO `ebcms5_menu` VALUES ('1655', '1652', '推荐属性', 'content/admin.attr/index', '7', 'content');
INSERT INTO `ebcms5_menu` VALUES ('1656', '1652', '聚合标签', 'content/admin.tag/index', '6', 'content');
INSERT INTO `ebcms5_menu` VALUES ('1657', '936', '内容管理', 'content/admin.content/index', '3', 'content');
INSERT INTO `ebcms5_menu` VALUES ('1658', '936', '友情链接', 'link/admin.link/index', '3', 'link');
INSERT INTO `ebcms5_menu` VALUES ('1659', '936', '留言管理', 'guestbook/admin.guestbook/index', '0', 'guestbook');
INSERT INTO `ebcms5_menu` VALUES ('1660', '936', '模板助手', 'mbzs/mbzs/index', '4', 'mbzs');
INSERT INTO `ebcms5_menu` VALUES ('1661', '936', '访客统计', 'tongji/tongji/index', '0', 'tongji');

-- ----------------------------
-- Table structure for ebcms5_nav
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_nav`;
CREATE TABLE `ebcms5_nav` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '菜菜单ID',
  `group` varchar(255) NOT NULL DEFAULT '' COMMENT '分组',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父ID',
  `title` varchar(20) NOT NULL DEFAULT '' COMMENT '标题',
  `eb_url` varchar(250) NOT NULL DEFAULT '' COMMENT '附加参数',
  `target` varchar(20) NOT NULL DEFAULT '' COMMENT '目标窗口',
  `eb_ext` text COMMENT '扩展',
  `sort` int(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  `app` varchar(255) NOT NULL DEFAULT '' COMMENT '应用',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='功能菜单表';

-- ----------------------------
-- Records of ebcms5_nav
-- ----------------------------
INSERT INTO `ebcms5_nav` VALUES ('1', '主导航', '0', '友情链接', 'link/index/index', '', null, '1', '1', 'link');
INSERT INTO `ebcms5_nav` VALUES ('2', '主导航', '0', '在线留言', 'guestbook/index/index', '', null, '0', '1', 'guestbook');

-- ----------------------------
-- Table structure for ebcms5_oplog
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_oplog`;
CREATE TABLE `ebcms5_oplog` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `manager_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作员ID',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '说明',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '动作',
  `ip` varchar(255) NOT NULL DEFAULT '' COMMENT 'ip',
  `ids` text COMMENT '提交的id',
  `request` text COMMENT '详细',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '执行状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='操作日志表';

-- ----------------------------
-- Records of ebcms5_oplog
-- ----------------------------

-- ----------------------------
-- Table structure for ebcms5_tongji_tongji
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_tongji_tongji`;
CREATE TABLE `ebcms5_tongji_tongji` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '网页标题',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '链接地址',
  `from` varchar(255) NOT NULL DEFAULT '' COMMENT '来源地址',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `ip` varchar(255) NOT NULL DEFAULT '' COMMENT 'ip',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='操作日志表';

-- ----------------------------
-- Records of ebcms5_tongji_tongji
-- ----------------------------
