<?php
namespace app\index\controller;
class Comment extends \app\index\controller\Common
{

    public function index()
    {
        if (request()->isGet()) {
        } elseif (request()->isPost()) {
            $size = input('size', 5, 'intval') ?: 5;
            $size = min($size, 50);
            $lists = \app\content\model\Comment::with('touser,user')->where(['comment.pid' => 0, 'comment.tid' => input('tid')])->order('comment.id', 'desc')->paginate($size);
            $ids = [];
            foreach ($lists as $v) {
                $ids[] = $v->id;
            }
            $sublists = [];
            if ($ids) {
                $x = \app\content\model\Comment::with('touser,user')->where(['comment.topid' => ['in', $ids]])->order('comment.id', 'desc')->select();
                foreach ($x as $key => $v) {
                    $sublists[] = $v->toArray();
                }
            }
            $this->success('加载成功！', '', [
                'page' => $lists->render(),
                'comments' => $lists->toArray(),
                'subcomments' => $sublists,
            ]);
        }
    }

    // 添加评论
    public function add()
    {
        if (request()->isPost()) {

            if (\ebcms\Config::get('content.comment_able')) {

                if (session('?user_id')) {
                    if (\ebcms\Config::get('content.comment_verify')) {
                        // 验证验证码
                        $verify = new \org\Verify([]);
                        if (!$verify->check(input('verify'), 1)) {
                            $this->error('验证码错误！');
                        }
                    }
                } else {
                    if (!\ebcms\Config::get('content.comment_visitor')) {
                        $this->error('请登录！');
                    }
                    if (\ebcms\Config::get('content.comment_visitor_verify')) {
                        // 验证验证码
                        $verify = new \org\Verify([]);
                        if (!$verify->check(input('verify'), 1)) {
                            $this->error('验证码错误！');
                        }
                    }
                }

                $status = \ebcms\Config::get('content.comment_check') ? 99 : 1;
                $data = [
                    'uid' => session('?user_id') ? session('user_id') : 0,
                    'touid' => 0,
                    'topid' => 0,
                    'tid' => input('tid'),
                    'pid' => 0,
                    'content' => input('content'),
                    'status' => $status,
                ];
                if (\ebcms\Config::get('content.comment_getip')) {
                    $data['ip'] = request()->ip(0, true);
                }
                \app\content\model\Comment::create($data);
                $this->success('评论成功！');

            } else {
                $this->error('评论已关闭！');
            }
        }
    }

    // 回复评论
    public function reply()
    {
        if (request()->isPost()) {

            if (\ebcms\Config::get('content.comment_able')) {

                if (session('?user_id')) {
                    if (\ebcms\Config::get('content.comment_verify')) {
                        // 验证验证码
                        $verify = new \org\Verify([]);
                        if (!$verify->check(input('verify'), 2)) {
                            $this->error('验证码错误！');
                        }
                    }
                } else {
                    if (!\ebcms\Config::get('content.comment_visitor')) {
                        $this->error('请登录！');
                    }
                    if (\ebcms\Config::get('content.comment_visitor_verify')) {
                        // 验证验证码
                        $verify = new \org\Verify([]);
                        if (!$verify->check(input('verify'), 2)) {
                            $this->error('验证码错误！');
                        }
                    }
                }

                $reply_id = input('reply_id');
                $m = new \app\content\model\Comment();
                $reply = $m->find($reply_id);
                $status = \ebcms\Config::get('content.comment_check') ? 99 : 1;
                $data = [
                    'uid' => session('?user_id') ? session('user_id') : 0,
                    'touid' => $reply['uid'],
                    'topid' => $reply['topid'] ?: $reply['id'],
                    'tid' => $reply['tid'],
                    'pid' => $reply['id'],
                    'content' => input('content'),
                    'status' => $status,
                ];
                $comment = \app\content\model\Comment::create($data);

                // 消息提醒
                $param = [
                    'mycomment' => $reply,
                    'comment' => $comment,
                ];
                $content = str_preg_parse(htmlspecialchars_decode(\ebcms\Config::get('user.notice_comment')), $param);
                $notice = [
                    'user_id' => $reply['uid'],
                    'content' => $content,
                ];
                \ebcms\Notice::add($notice);

                $this->success('评论成功！');

            } else {
                $this->error('评论已关闭！');
            }
        }
    }

}