/*
Navicat MySQL Data Transfer

Source Server         : localhost
Source Server Version : 50547
Source Host           : localhost:3306
Source Database       : ebcms5_temp

Target Server Type    : MYSQL
Target Server Version : 50547
File Encoding         : 65001

Date: 2016-08-30 08:10:06
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for ebcms5_auth_access
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_auth_access`;
CREATE TABLE `ebcms5_auth_access` (
  `uid` mediumint(8) unsigned NOT NULL,
  `group_id` mediumint(8) unsigned NOT NULL,
  UNIQUE KEY `uid_group_id` (`uid`,`group_id`),
  KEY `uid` (`uid`),
  KEY `group_id` (`group_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='角色权限表';

-- ----------------------------
-- Records of ebcms5_auth_access
-- ----------------------------

-- ----------------------------
-- Table structure for ebcms5_auth_group
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_auth_group`;
CREATE TABLE `ebcms5_auth_group` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父id',
  `group` varchar(255) NOT NULL DEFAULT '' COMMENT '分组',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT '简介',
  `title` char(100) NOT NULL DEFAULT '',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `rules` text COMMENT '规则',
  `c_rules` text COMMENT '栏目权限规则',
  `menus` text COMMENT '菜单权限',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `locked` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '锁定',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COMMENT='角色表';

-- ----------------------------
-- Records of ebcms5_auth_group
-- ----------------------------
INSERT INTO `ebcms5_auth_group` VALUES ('1', '0', '系统', '', '管理员', '1', '1,2,30,31,32,33,115,116,173,3,34,35,36,37,38,39,40,41,42,4,43,44,45,117,118,155,5,46,47,48,119,120,156,6,49,50,51,121,122,157,7,52,53,54,123,124,158,8,55,56,57,58,59,60,61,9,62,63,64,125,126,159,10,65,66,67,127,128,160,12,73,74,75,183,185,13,14,76,77,78,131,132,162,182,15,79,80,81,82,133,134,163,181,16,83,84,85,135,136,164,17,86,87,88,89,137,138,165,18,19,90,91,92,139,140,166,20,21,93,94,141,142,143,167,22,23,95,96,97,144,145,168,24,98,99,100,101,146,147,169,25,26,102,103,104,148,149,170,27,28,105,106,107,108,109,150,151,171,29,110,111,112,113,114,152,153,172', '', '72,79,80,81,95,118,96,11,13,92,98,100,105,106,127,132,128,129,130,131', '99', '1', '0', '0');
INSERT INTO `ebcms5_auth_group` VALUES ('2', '0', '系统', '', '工程师', '1', '2,3,193,194,195,196,6,35,34,36,37,7,39,40,41,43', '', '72,79,80,81,95,96', '99', '1', '0', '0');
INSERT INTO `ebcms5_auth_group` VALUES ('3', '0', '系统', '', '编辑', '1', '2,3,5,193,194,195,196,6,35,34,36,38,7,39,40,41,42', '', '72,95', '99', '1', '0', '1467883487');
INSERT INTO `ebcms5_auth_group` VALUES ('4', '0', '系统', '', '客服', '1', '2,3,193,194,195,13,69,70,71,73,14,74,162,197,10,54,55,56,58,223,224,225,226,227,228,229,230,231,232,233', '', '72,80,81', '99', '1', '0', '0');
INSERT INTO `ebcms5_auth_group` VALUES ('5', '0', '普通', '刚注册的时候默认的用户角色', '见习会员', '1', '223,224,225,226,232,233', '', '', '99', '1', '0', '0');
INSERT INTO `ebcms5_auth_group` VALUES ('6', '0', '普通', '', '初级会员', '1', '223,224,225,226,227,228,229,230,231,232,233', '', '', '99', '1', '0', '0');
INSERT INTO `ebcms5_auth_group` VALUES ('7', '0', '普通', '', '中级会员', '1', '223,224,225,226,227,228,229,230,231,232,233', '', '', '99', '1', '0', '0');
INSERT INTO `ebcms5_auth_group` VALUES ('8', '0', '普通', '', '高级会员', '1', '223,224,225,226,227,228,229,230,231,232,233', '', '', '99', '1', '0', '0');
INSERT INTO `ebcms5_auth_group` VALUES ('9', '0', '普通', '', '至尊会员', '1', '2,3,5,193,195', '', '7', '99', '1', '0', '0');

-- ----------------------------
-- Table structure for ebcms5_auth_rule
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_auth_rule`;
CREATE TABLE `ebcms5_auth_rule` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父id',
  `group` varchar(255) NOT NULL DEFAULT '' COMMENT '分组',
  `opstr` varchar(255) NOT NULL DEFAULT '' COMMENT '操作说明',
  `name` char(80) NOT NULL DEFAULT '',
  `title` char(20) NOT NULL DEFAULT '',
  `type` tinyint(1) NOT NULL DEFAULT '1',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `condition` char(100) NOT NULL DEFAULT '',
  `sort` int(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `locked` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '锁定',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=215 DEFAULT CHARSET=utf8 COMMENT='权限规则表';

-- ----------------------------
-- Records of ebcms5_auth_rule
-- ----------------------------
INSERT INTO `ebcms5_auth_rule` VALUES ('1', '0', '节点权限', '后台', 'admin_api_index', '后台', '1', '1', '', '0', '1', '1468568884', '1468568884');
INSERT INTO `ebcms5_auth_rule` VALUES ('2', '1', '节点权限', '配置管理', 'admin_config_index', '配置管理', '1', '1', '', '0', '1', '1468568972', '1468569450');
INSERT INTO `ebcms5_auth_rule` VALUES ('3', '1', '节点权限', '数据库管理', 'admin_database_index', '数据库管理', '1', '1', '', '0', '1', '1468568994', '1468569442');
INSERT INTO `ebcms5_auth_rule` VALUES ('4', '1', '节点权限', '数据字典管理', 'admin_datadict_index', '数据字典管理', '1', '1', '', '0', '1', '1468569433', '1468569433');
INSERT INTO `ebcms5_auth_rule` VALUES ('5', '1', '节点权限', '数据字典分类管理', 'admin_datadictcate_index', '字典分类', '1', '1', '', '0', '1', '1468569496', '1468569496');
INSERT INTO `ebcms5_auth_rule` VALUES ('6', '1', '节点权限', '扩展管理', 'admin_extend_index', '扩展管理', '1', '1', '', '0', '1', '1468569517', '1468569517');
INSERT INTO `ebcms5_auth_rule` VALUES ('7', '1', '节点权限', '扩展字段管理', 'admin_extendfield_index', '扩展字典管理', '1', '1', '', '0', '1', '1468569543', '1468569543');
INSERT INTO `ebcms5_auth_rule` VALUES ('8', '1', '节点权限', '后台首页', 'admin_index_index', '后台首页', '1', '1', '', '0', '1', '1468569569', '1468569569');
INSERT INTO `ebcms5_auth_rule` VALUES ('9', '1', '节点权限', '导航管理', 'admin_nav_index', '导航管理', '1', '1', '', '0', '1', '1468569587', '1468569587');
INSERT INTO `ebcms5_auth_rule` VALUES ('10', '1', '节点权限', '导航分类管理', 'admin_navcate_index', '导航分类管理', '1', '1', '', '0', '1', '1468569603', '1468569603');
INSERT INTO `ebcms5_auth_rule` VALUES ('12', '1', '节点权限', '模板管理', 'admin_template_index', '模板管理', '1', '1', '', '0', '1', '1468569637', '1468569637');
INSERT INTO `ebcms5_auth_rule` VALUES ('13', '0', '节点权限', '内容管理', 'content', '内容模块', '1', '1', '', '0', '1', '1468569651', '1468569651');
INSERT INTO `ebcms5_auth_rule` VALUES ('14', '13', '节点权限', '栏目管理', 'content_admin.category_index', '栏目管理', '1', '1', '', '0', '1', '1468569691', '1468569719');
INSERT INTO `ebcms5_auth_rule` VALUES ('15', '13', '节点权限', '内容管理', 'content_admin.content_index', '内容管理', '1', '1', '', '0', '1', '1468569730', '1468569730');
INSERT INTO `ebcms5_auth_rule` VALUES ('16', '13', '节点权限', '评论管理', 'content_admin.comment_index', '评论管理', '1', '1', '', '0', '1', '1468569744', '1468569744');
INSERT INTO `ebcms5_auth_rule` VALUES ('17', '13', '节点权限', '标签管理', 'content_admin.tag_index', '标签管理', '1', '1', '', '0', '1', '1468569766', '1468569766');
INSERT INTO `ebcms5_auth_rule` VALUES ('18', '0', '节点权限', '万能表单管理', 'forms', '万能表单模块', '1', '1', '', '0', '1', '1468569790', '1471825569');
INSERT INTO `ebcms5_auth_rule` VALUES ('19', '1', '节点权限', '留言管理', 'admin_guestbook_index', '留言管理', '1', '1', '', '0', '1', '1468569809', '1471825483');
INSERT INTO `ebcms5_auth_rule` VALUES ('188', '18', '节点权限', '万能表单管理', 'forms_forms_index', '表单管理', '1', '1', '', '0', '0', '1471825597', '1471825697');
INSERT INTO `ebcms5_auth_rule` VALUES ('21', '1', '节点权限', '友情链接管理', 'admin_link_index', '友情链接管理', '1', '1', '', '0', '1', '1468569840', '1471825470');
INSERT INTO `ebcms5_auth_rule` VALUES ('23', '1', '节点权限', '推荐位管理', 'admin_recommendcate_index', '推荐位管理', '1', '1', '', '0', '1', '1468569876', '1471825463');
INSERT INTO `ebcms5_auth_rule` VALUES ('24', '1', '节点权限', '推荐内容管理', 'admin_recommend_index', '推荐管理', '1', '1', '', '0', '1', '1468569894', '1471825477');
INSERT INTO `ebcms5_auth_rule` VALUES ('189', '18', '节点权限', '万能表单字段管理', 'forms_formsfield_index', '字段管理', '1', '1', '', '0', '0', '1471825635', '1471825687');
INSERT INTO `ebcms5_auth_rule` VALUES ('26', '1', '节点权限', '单页管理', 'admin_single_index', '单页管理', '1', '1', '', '0', '1', '1468569926', '1471825456');
INSERT INTO `ebcms5_auth_rule` VALUES ('190', '18', '节点权限', '万能表单数据管理', 'forms_formsdata_index', '数据管理', '1', '1', '', '0', '0', '1471825676', '1471825704');
INSERT INTO `ebcms5_auth_rule` VALUES ('28', '1', '节点权限', '角色管理', 'admin_group_index', '角色管理', '1', '1', '', '0', '1', '1468569966', '1471825437');
INSERT INTO `ebcms5_auth_rule` VALUES ('29', '1', '节点权限', '用户管理', 'admin_user_index', '用户管理', '1', '1', '', '0', '1', '1468569983', '1471825446');
INSERT INTO `ebcms5_auth_rule` VALUES ('30', '2', '节点权限', '系统设置', 'admin_config_setting', '设置', '1', '1', '', '0', '1', '1468570197', '1468570244');
INSERT INTO `ebcms5_auth_rule` VALUES ('31', '2', '节点权限', '自定义配置管理', 'admin_config_custom', '自定义管理', '1', '1', '', '0', '1', '1468570221', '1468570221');
INSERT INTO `ebcms5_auth_rule` VALUES ('32', '2', '节点权限', '添加自定义配置', 'admin_config_add', '添加', '1', '1', '', '0', '1', '1468570230', '1468570230');
INSERT INTO `ebcms5_auth_rule` VALUES ('33', '2', '节点权限', '修改自定义配置', 'admin_config_edit', '修改', '1', '1', '', '0', '1', '1468570237', '1468570237');
INSERT INTO `ebcms5_auth_rule` VALUES ('34', '3', '节点权限', '查看表信息', 'admin_database_datatables', '查看表信息', '1', '1', '', '0', '1', '1468570281', '1468570281');
INSERT INTO `ebcms5_auth_rule` VALUES ('35', '3', '节点权限', '查看备份包', 'admin_database_databackups', '查看备份包', '1', '1', '', '0', '1', '1468570297', '1468570297');
INSERT INTO `ebcms5_auth_rule` VALUES ('36', '3', '节点权限', '预览备份包', 'admin_database_showsql', '预览备份包', '1', '1', '', '0', '1', '1468570312', '1468570312');
INSERT INTO `ebcms5_auth_rule` VALUES ('37', '3', '节点权限', '数据库导入', 'admin_database_imports', '导入', '1', '1', '', '0', '1', '1468570333', '1468570333');
INSERT INTO `ebcms5_auth_rule` VALUES ('38', '3', '节点权限', '删除备份包', 'admin_database_delete', '删除备份包', '1', '1', '', '0', '1', '1468570345', '1468570345');
INSERT INTO `ebcms5_auth_rule` VALUES ('39', '3', '节点权限', '优化数据表', 'admin_database_optimize', '优化数据表', '1', '1', '', '0', '1', '1468570367', '1468570367');
INSERT INTO `ebcms5_auth_rule` VALUES ('40', '3', '节点权限', '修复数据表', 'admin_database_repair', '修复数据表', '1', '1', '', '0', '1', '1468570379', '1468570379');
INSERT INTO `ebcms5_auth_rule` VALUES ('41', '3', '节点权限', '查看数据表创建信息', 'admin_database_showcreate', '查看创建信息', '1', '1', '', '0', '1', '1468570394', '1468570394');
INSERT INTO `ebcms5_auth_rule` VALUES ('42', '3', '节点权限', '备份数据库', 'admin_database_exports', '备份数据库', '1', '1', '', '0', '1', '1468570406', '1468570406');
INSERT INTO `ebcms5_auth_rule` VALUES ('43', '4', '节点权限', '添加数据字典', 'admin_datadict_add', '添加', '1', '1', '', '0', '1', '1468570428', '1468570428');
INSERT INTO `ebcms5_auth_rule` VALUES ('44', '4', '节点权限', '修改数据字典', 'admin_datadict_edit', '修改', '1', '1', '', '0', '1', '1468570447', '1468570447');
INSERT INTO `ebcms5_auth_rule` VALUES ('45', '4', '节点权限', '删除数据字典', 'admin_datadict_delete', '删除', '1', '1', '', '0', '1', '1468570458', '1468570458');
INSERT INTO `ebcms5_auth_rule` VALUES ('46', '5', '节点权限', '添加数据字典分类', 'admin_datadictcate_add', '添加', '1', '1', '', '0', '1', '1468570476', '1468570476');
INSERT INTO `ebcms5_auth_rule` VALUES ('47', '5', '节点权限', '修改数据字典分类', 'admin_datadictcate_edit', '修改', '1', '1', '', '0', '1', '1468570483', '1468570483');
INSERT INTO `ebcms5_auth_rule` VALUES ('48', '5', '节点权限', '删除数据字典分类', 'admin_datadictcate_delete', '删除', '1', '1', '', '0', '1', '1468570493', '1468570493');
INSERT INTO `ebcms5_auth_rule` VALUES ('49', '6', '节点权限', '添加扩展', 'admin_extend_add', '添加', '1', '1', '', '0', '1', '1468570513', '1468570513');
INSERT INTO `ebcms5_auth_rule` VALUES ('50', '6', '节点权限', '修改扩展', 'admin_extend_edit', '修改', '1', '1', '', '0', '1', '1468570522', '1468570522');
INSERT INTO `ebcms5_auth_rule` VALUES ('51', '6', '节点权限', '删除扩展', 'admin_extend_delete', '删除', '1', '1', '', '0', '1', '1468570531', '1468570531');
INSERT INTO `ebcms5_auth_rule` VALUES ('52', '7', '节点权限', '添加扩展字段', 'admin_extendfield_add', '添加', '1', '1', '', '0', '1', '1468570556', '1468570556');
INSERT INTO `ebcms5_auth_rule` VALUES ('53', '7', '节点权限', '修改扩展字段', 'admin_extendfield_edit', '修改', '1', '1', '', '0', '1', '1468570564', '1468570564');
INSERT INTO `ebcms5_auth_rule` VALUES ('54', '7', '节点权限', '删除扩展字段', 'admin_extendfield_delete', '删除', '1', '1', '', '0', '1', '1468570571', '1468570571');
INSERT INTO `ebcms5_auth_rule` VALUES ('55', '8', '节点权限', '主页', 'admin_index_main', '主页', '1', '1', '', '0', '1', '1468570615', '1468570615');
INSERT INTO `ebcms5_auth_rule` VALUES ('56', '8', '节点权限', '删除缓存', 'admin_index_runtime', '删除缓存', '1', '1', '', '0', '1', '1468570632', '1468570632');
INSERT INTO `ebcms5_auth_rule` VALUES ('57', '8', '节点权限', '修改自己的密码', 'admin_index_password', '修改自己的密码', '1', '1', '', '0', '1', '1468570643', '1468570643');
INSERT INTO `ebcms5_auth_rule` VALUES ('58', '29', '节点权限', '查看用户信息', 'admin_user_info', '查看用户信息', '1', '1', '', '0', '1', '1468570654', '1470556369');
INSERT INTO `ebcms5_auth_rule` VALUES ('59', '8', '节点权限', '附件上传', 'admin_index_upload', '附件上传', '1', '1', '', '0', '1', '1468570669', '1468570669');
INSERT INTO `ebcms5_auth_rule` VALUES ('60', '8', '节点权限', '编辑器附件上传', 'admin_index_ueditor', '编辑器附件上传', '1', '1', '', '0', '1', '1468570681', '1468570681');
INSERT INTO `ebcms5_auth_rule` VALUES ('61', '8', '节点权限', '数据库地址替换', 'admin_index_replaceattachbaseurl', '数据库附件地址替换', '1', '1', '', '0', '1', '1468570719', '1468570719');
INSERT INTO `ebcms5_auth_rule` VALUES ('62', '9', '节点权限', '添加导航', 'admin_nav_add', '添加', '1', '1', '', '0', '1', '1468570740', '1468570740');
INSERT INTO `ebcms5_auth_rule` VALUES ('63', '9', '节点权限', '修改导航', 'admin_nav_edit', '修改', '1', '1', '', '0', '1', '1468570753', '1468570753');
INSERT INTO `ebcms5_auth_rule` VALUES ('64', '9', '节点权限', '删除导航', 'admin_nav_delete', '删除', '1', '1', '', '0', '1', '1468570761', '1468570761');
INSERT INTO `ebcms5_auth_rule` VALUES ('65', '10', '节点权限', '添加导航分类', 'admin_navcate_add', '添加', '1', '1', '', '0', '1', '1468570775', '1468570775');
INSERT INTO `ebcms5_auth_rule` VALUES ('66', '10', '节点权限', '修改导航分类', 'admin_navcate_edit', '修改', '1', '1', '', '0', '1', '1468570783', '1468570783');
INSERT INTO `ebcms5_auth_rule` VALUES ('67', '10', '节点权限', '删除导航分类', 'admin_navcate_delete', '删除', '1', '1', '', '0', '1', '1468570790', '1468570790');
INSERT INTO `ebcms5_auth_rule` VALUES ('73', '12', '节点权限', '添加模板', 'admin_template_add', '添加', '1', '1', '', '0', '1', '1468570889', '1468570889');
INSERT INTO `ebcms5_auth_rule` VALUES ('74', '12', '节点权限', '修改模板', 'admin_template_edit', '修改', '1', '1', '', '0', '1', '1468570911', '1468570911');
INSERT INTO `ebcms5_auth_rule` VALUES ('75', '12', '节点权限', '删除模板', 'admin_template_delete', '删除', '1', '1', '', '0', '1', '1468570921', '1468570921');
INSERT INTO `ebcms5_auth_rule` VALUES ('76', '14', '节点权限', '添加栏目', 'content_admin.category_add', '添加', '1', '1', '', '0', '1', '1468570950', '1468570950');
INSERT INTO `ebcms5_auth_rule` VALUES ('77', '14', '节点权限', '修改栏目', 'content_admin.category_edit', '修改', '1', '1', '', '0', '1', '1468570961', '1468570961');
INSERT INTO `ebcms5_auth_rule` VALUES ('78', '14', '节点权限', '删除栏目', 'content_admin.category_delete', '删除', '1', '1', '', '0', '1', '1468570970', '1468570970');
INSERT INTO `ebcms5_auth_rule` VALUES ('79', '15', '节点权限', '添加内容', 'content_admin.content_add', '添加', '1', '1', '', '0', '1', '1468570995', '1468570995');
INSERT INTO `ebcms5_auth_rule` VALUES ('80', '15', '节点权限', '修改内容', 'content_admin.content_edit', '修改', '1', '1', '', '0', '1', '1468571005', '1468571005');
INSERT INTO `ebcms5_auth_rule` VALUES ('81', '15', '节点权限', '删除内容', 'content_admin.content_delete', '删除', '1', '1', '', '0', '1', '1468571015', '1468571015');
INSERT INTO `ebcms5_auth_rule` VALUES ('82', '15', '节点权限', '检测百度收录', 'content_admin.content_baidu', '查看是否收录', '1', '1', '', '0', '1', '1468571041', '1468571041');
INSERT INTO `ebcms5_auth_rule` VALUES ('83', '16', '节点权限', '修改评论', 'content_admin.comment_edit', '修改', '1', '1', '', '0', '1', '1468571065', '1468571065');
INSERT INTO `ebcms5_auth_rule` VALUES ('84', '16', '节点权限', '屏蔽评论', 'content_admin.comment_pingbi', '屏蔽', '1', '1', '', '0', '1', '1468571083', '1468571083');
INSERT INTO `ebcms5_auth_rule` VALUES ('85', '16', '节点权限', '删除评论', 'content_admin.comment_delete', '删除', '1', '1', '', '0', '1', '1468571096', '1468571096');
INSERT INTO `ebcms5_auth_rule` VALUES ('86', '17', '节点权限', '添加标签', 'content_admin.tag_add', '添加', '1', '1', '', '0', '1', '1468571115', '1468571115');
INSERT INTO `ebcms5_auth_rule` VALUES ('87', '17', '节点权限', '修改标签', 'content_admin.tag_edit', '修改', '1', '1', '', '0', '1', '1468571126', '1468571126');
INSERT INTO `ebcms5_auth_rule` VALUES ('88', '17', '节点权限', '删除标签', 'content_admin.tag_delete', '删除', '1', '1', '', '0', '1', '1468571136', '1468571136');
INSERT INTO `ebcms5_auth_rule` VALUES ('89', '17', '节点权限', '合并标签', 'content_admin.tag_merge', '合并（不受锁定影响）', '1', '1', '', '0', '1', '1468571149', '1468986871');
INSERT INTO `ebcms5_auth_rule` VALUES ('90', '19', '节点权限', '修改留言', 'admin_guestbook_edit', '修改', '1', '1', '', '0', '1', '1468571169', '1468571239');
INSERT INTO `ebcms5_auth_rule` VALUES ('91', '19', '节点权限', '回复留言', 'admin_guestbook_reply', '回复', '1', '1', '', '0', '1', '1468571179', '1468571244');
INSERT INTO `ebcms5_auth_rule` VALUES ('92', '19', '节点权限', '删除留言', 'admin_guestbook_delete', '删除', '1', '1', '', '0', '1', '1468571186', '1468571248');
INSERT INTO `ebcms5_auth_rule` VALUES ('93', '21', '节点权限', '添加友情链接', 'admin_link_add', '添加', '1', '1', '', '0', '1', '1468571207', '1468571349');
INSERT INTO `ebcms5_auth_rule` VALUES ('94', '21', '节点权限', '修改友情链接', 'admin_link_edit', '修改', '1', '1', '', '0', '1', '1468571217', '1471336342');
INSERT INTO `ebcms5_auth_rule` VALUES ('95', '23', '节点权限', '添加推荐位', 'admin_recommendcate_add', '添加', '1', '1', '', '0', '1', '1468571280', '1468571280');
INSERT INTO `ebcms5_auth_rule` VALUES ('96', '23', '节点权限', '修改推荐位', 'admin_recommendcate_edit', '修改', '1', '1', '', '0', '1', '1468571291', '1468571291');
INSERT INTO `ebcms5_auth_rule` VALUES ('97', '23', '节点权限', '删除推荐位', 'admin_recommendcate_delete', '删除', '1', '1', '', '0', '1', '1468571306', '1468571306');
INSERT INTO `ebcms5_auth_rule` VALUES ('98', '24', '节点权限', '添加推荐内容', 'admin_recommend_add', '添加', '1', '1', '', '0', '1', '1468571322', '1468571342');
INSERT INTO `ebcms5_auth_rule` VALUES ('99', '24', '节点权限', '修改推荐内容', 'admin_recommend_edit', '修改', '1', '1', '', '0', '1', '1468571333', '1468571333');
INSERT INTO `ebcms5_auth_rule` VALUES ('100', '24', '节点权限', '删除推荐内容', 'admin_recommend_delete', '删除', '1', '1', '', '0', '1', '1468571365', '1468571365');
INSERT INTO `ebcms5_auth_rule` VALUES ('101', '24', '节点权限', '推送', 'admin_recommend_push', '推送', '1', '1', '', '0', '1', '1468571375', '1468571375');
INSERT INTO `ebcms5_auth_rule` VALUES ('102', '26', '节点权限', '添加单页', 'admin_single_add', '添加', '1', '1', '', '0', '1', '1468571654', '1468571654');
INSERT INTO `ebcms5_auth_rule` VALUES ('103', '26', '节点权限', '修改单页', 'admin_single_edit', '修改', '1', '1', '', '0', '1', '1468571663', '1468571663');
INSERT INTO `ebcms5_auth_rule` VALUES ('104', '26', '节点权限', '删除单页', 'admin_single_delete', '删除', '1', '1', '', '0', '1', '1468571670', '1468571670');
INSERT INTO `ebcms5_auth_rule` VALUES ('105', '28', '节点权限', '添加角色', 'admin_group_add', '添加', '1', '1', '', '0', '1', '1468571689', '1468571776');
INSERT INTO `ebcms5_auth_rule` VALUES ('106', '28', '节点权限', '修改角色', 'admin_group_edit', '修改', '1', '1', '', '0', '1', '1468571701', '1468571780');
INSERT INTO `ebcms5_auth_rule` VALUES ('107', '28', '节点权限', '删除角色', 'admin_group_delete', '删除', '1', '1', '', '0', '1', '1468571710', '1468571784');
INSERT INTO `ebcms5_auth_rule` VALUES ('108', '28', '节点权限', '对角色分配权限', 'admin_group_rule', '分配权限', '1', '1', '', '0', '1', '1468571724', '1468571790');
INSERT INTO `ebcms5_auth_rule` VALUES ('109', '28', '节点权限', '对角色分配菜单权限', 'admin_group_menu', '分配菜单权限', '1', '1', '', '0', '1', '1468571737', '1468571794');
INSERT INTO `ebcms5_auth_rule` VALUES ('110', '29', '节点权限', '添加用户', 'admin_user_add', '添加', '1', '1', '', '0', '1', '1468571811', '1468571811');
INSERT INTO `ebcms5_auth_rule` VALUES ('111', '29', '节点权限', '修改用户信息', 'admin_user_edit', '修改', '1', '1', '', '0', '1', '1468571821', '1468571821');
INSERT INTO `ebcms5_auth_rule` VALUES ('112', '29', '节点权限', '删除用户', 'admin_user_delete', '删除', '1', '1', '', '0', '1', '1468571833', '1468571833');
INSERT INTO `ebcms5_auth_rule` VALUES ('113', '29', '节点权限', '用户分配角色', 'admin_user_group', '分配角色', '1', '1', '', '0', '1', '1468571844', '1468571844');
INSERT INTO `ebcms5_auth_rule` VALUES ('114', '29', '节点权限', '重置用户密码', 'admin_user_password', '重置密码', '1', '1', '', '0', '1', '1468571855', '1468571855');
INSERT INTO `ebcms5_auth_rule` VALUES ('115', '2', '节点权限', '审核自定义配置', 'admin_config_status', '审核', '1', '1', '', '0', '1', '1468574707', '1468574707');
INSERT INTO `ebcms5_auth_rule` VALUES ('116', '2', '节点权限', '锁定自定义配置', 'admin_config_lock', '锁定', '1', '1', '', '0', '1', '1468574720', '1468574720');
INSERT INTO `ebcms5_auth_rule` VALUES ('117', '4', '节点权限', '审核数据字典', 'admin_datadict_status', '审核', '1', '1', '', '0', '1', '1468574782', '1468574782');
INSERT INTO `ebcms5_auth_rule` VALUES ('118', '4', '节点权限', '锁定数据字典', 'admin_datadict_lock', '锁定', '1', '1', '', '0', '1', '1468574789', '1468574789');
INSERT INTO `ebcms5_auth_rule` VALUES ('119', '5', '节点权限', '审核数据字典分类', 'admin_datadictcate_status', '审核', '1', '1', '', '0', '1', '1468574801', '1468574801');
INSERT INTO `ebcms5_auth_rule` VALUES ('120', '5', '节点权限', '锁定数据字典分类', 'admin_datadictcate_lock', '锁定', '1', '1', '', '0', '1', '1468574809', '1468574809');
INSERT INTO `ebcms5_auth_rule` VALUES ('121', '6', '节点权限', '审核扩展', 'admin_extend_status', '审核', '1', '1', '', '0', '1', '1468574823', '1468574823');
INSERT INTO `ebcms5_auth_rule` VALUES ('122', '6', '节点权限', '锁定扩展', 'admin_extend_lock', '锁定', '1', '1', '', '0', '1', '1468574829', '1468574829');
INSERT INTO `ebcms5_auth_rule` VALUES ('123', '7', '节点权限', '审核扩展字段', 'admin_extendfield_status', '审核', '1', '1', '', '0', '1', '1468574846', '1468574846');
INSERT INTO `ebcms5_auth_rule` VALUES ('124', '7', '节点权限', '锁定扩展字段', 'admin_extendfield_lock', '锁定', '1', '1', '', '0', '1', '1468574855', '1468574855');
INSERT INTO `ebcms5_auth_rule` VALUES ('125', '9', '节点权限', '审核导航', 'admin_nav_status', '审核', '1', '1', '', '0', '1', '1468574867', '1468574867');
INSERT INTO `ebcms5_auth_rule` VALUES ('126', '9', '节点权限', '锁定导航', 'admin_nav_lock', '锁定', '1', '1', '', '0', '1', '1468574875', '1468574875');
INSERT INTO `ebcms5_auth_rule` VALUES ('127', '10', '节点权限', '审核导航分类', 'admin_navcate_status', '审核', '1', '1', '', '0', '1', '1468574887', '1468574887');
INSERT INTO `ebcms5_auth_rule` VALUES ('128', '10', '节点权限', '锁定导航分类', 'admin_navcate_lock', '锁定', '1', '1', '', '0', '1', '1468574893', '1468574893');
INSERT INTO `ebcms5_auth_rule` VALUES ('131', '14', '节点权限', '审核栏目', 'content_admin.category_status', '审核', '1', '1', '', '0', '1', '1468574930', '1468574930');
INSERT INTO `ebcms5_auth_rule` VALUES ('132', '14', '节点权限', '锁定栏目', 'content_admin.category_lock', '锁定', '1', '1', '', '0', '1', '1468574937', '1468574937');
INSERT INTO `ebcms5_auth_rule` VALUES ('133', '15', '节点权限', '审核内容', 'content_admin.content_status', '审核', '1', '1', '', '0', '1', '1468574957', '1468574957');
INSERT INTO `ebcms5_auth_rule` VALUES ('134', '15', '节点权限', '锁定内容', 'content_admin.content_lock', '锁定', '1', '1', '', '0', '1', '1468574967', '1468574967');
INSERT INTO `ebcms5_auth_rule` VALUES ('135', '16', '节点权限', '审核评论', 'content_admin.comment_status', '审核', '1', '1', '', '0', '1', '1468574987', '1468574987');
INSERT INTO `ebcms5_auth_rule` VALUES ('136', '16', '节点权限', '锁定评论', 'content_admin.comment_lock', '锁定', '1', '1', '', '0', '1', '1468574995', '1468574995');
INSERT INTO `ebcms5_auth_rule` VALUES ('137', '17', '节点权限', '审核标签', 'content_admin.tag_status', '审核', '1', '1', '', '0', '1', '1468575015', '1468575015');
INSERT INTO `ebcms5_auth_rule` VALUES ('138', '17', '节点权限', '锁定标签', 'content_admin.tag_lock', '锁定', '1', '1', '', '0', '1', '1468575023', '1468575023');
INSERT INTO `ebcms5_auth_rule` VALUES ('139', '19', '节点权限', '审核留言', 'admin_guestbook_status', '审核', '1', '1', '', '0', '1', '1468575034', '1468575034');
INSERT INTO `ebcms5_auth_rule` VALUES ('140', '19', '节点权限', '锁定留言', 'admin_guestbook_lock', '锁定', '1', '1', '', '0', '1', '1468575042', '1468575042');
INSERT INTO `ebcms5_auth_rule` VALUES ('141', '21', '节点权限', '删除友情链接', 'admin_link_delete', '删除', '1', '1', '', '0', '1', '1468575056', '1471336316');
INSERT INTO `ebcms5_auth_rule` VALUES ('142', '21', '节点权限', '审核友情链接', 'admin_link_status', '审核', '1', '1', '', '0', '1', '1468575065', '1471336322');
INSERT INTO `ebcms5_auth_rule` VALUES ('143', '21', '节点权限', '锁定友情链接', 'admin_link_lock', '锁定', '1', '1', '', '0', '1', '1468575073', '1471336327');
INSERT INTO `ebcms5_auth_rule` VALUES ('144', '23', '节点权限', '审核推荐位', 'admin_recommendcate_status', '审核', '1', '1', '', '0', '1', '1468575086', '1468575086');
INSERT INTO `ebcms5_auth_rule` VALUES ('145', '23', '节点权限', '锁定推荐位', 'admin_recommendcate_lock', '锁定', '1', '1', '', '0', '1', '1468575094', '1468575094');
INSERT INTO `ebcms5_auth_rule` VALUES ('146', '24', '节点权限', '审核推荐内容', 'admin_recommend_status', '审核', '1', '1', '', '0', '1', '1468575106', '1468575106');
INSERT INTO `ebcms5_auth_rule` VALUES ('147', '24', '节点权限', '锁定推荐内容', 'admin_recommend_lock', '锁定', '1', '1', '', '0', '1', '1468575113', '1468575113');
INSERT INTO `ebcms5_auth_rule` VALUES ('148', '26', '节点权限', '审核单页', 'admin_single_status', '审核', '1', '1', '', '0', '1', '1468575132', '1468575132');
INSERT INTO `ebcms5_auth_rule` VALUES ('149', '26', '节点权限', '锁定单页', 'admin_single_lock', '锁定', '1', '1', '', '0', '1', '1468575140', '1468575140');
INSERT INTO `ebcms5_auth_rule` VALUES ('150', '28', '节点权限', '审核角色', 'admin_group_status', '审核', '1', '1', '', '0', '1', '1468575152', '1468575152');
INSERT INTO `ebcms5_auth_rule` VALUES ('151', '28', '节点权限', '锁定角色', 'admin_group_lock', '锁定', '1', '1', '', '0', '1', '1468575158', '1468575158');
INSERT INTO `ebcms5_auth_rule` VALUES ('152', '29', '节点权限', '审核用户', 'admin_user_status', '审核', '1', '1', '', '0', '1', '1468575171', '1468575171');
INSERT INTO `ebcms5_auth_rule` VALUES ('153', '29', '节点权限', '锁定用户', 'admin_user_lock', '锁定', '1', '1', '', '0', '1', '1468575178', '1468575178');
INSERT INTO `ebcms5_auth_rule` VALUES ('155', '4', '节点权限', '排序数据字典', 'admin_datadict_resort', '排序', '1', '1', '', '0', '1', '1468894789', '1468894896');
INSERT INTO `ebcms5_auth_rule` VALUES ('156', '5', '节点权限', '排序数据字典分类', 'admin_datadictcate_resort', '排序', '1', '1', '', '0', '1', '1468894952', '1468894952');
INSERT INTO `ebcms5_auth_rule` VALUES ('157', '6', '节点权限', '排序扩展', 'admin_extend_resort', '排序', '1', '1', '', '0', '1', '1468894972', '1468894972');
INSERT INTO `ebcms5_auth_rule` VALUES ('158', '7', '节点权限', '排序扩展字段', 'admin_extendfield_resort', '排序', '1', '1', '', '0', '1', '1468894987', '1468894987');
INSERT INTO `ebcms5_auth_rule` VALUES ('159', '9', '节点权限', '排序导航', 'admin_nav_resort', '排序', '1', '1', '', '0', '1', '1468895004', '1468895004');
INSERT INTO `ebcms5_auth_rule` VALUES ('160', '10', '节点权限', '排序导航分类', 'admin_navcate_resort', '排序', '1', '1', '', '0', '1', '1468895020', '1468895020');
INSERT INTO `ebcms5_auth_rule` VALUES ('162', '14', '节点权限', '对栏目排序', 'content_admin.category_resort', '排序', '1', '1', '', '0', '1', '1468895057', '1468895057');
INSERT INTO `ebcms5_auth_rule` VALUES ('163', '15', '节点权限', '推荐内容', 'content_admin.content_resort', '推荐', '1', '1', '', '0', '1', '1468895070', '1468895126');
INSERT INTO `ebcms5_auth_rule` VALUES ('164', '16', '节点权限', '推荐评论', 'content_admin.comment_resort', '推荐', '1', '1', '', '0', '1', '1468895111', '1468895111');
INSERT INTO `ebcms5_auth_rule` VALUES ('165', '17', '节点权限', '推荐标签', 'content_admin.tag_resort', '推荐', '1', '1', '', '0', '1', '1468895150', '1468895150');
INSERT INTO `ebcms5_auth_rule` VALUES ('166', '19', '节点权限', '留言推荐', 'admin_guestbook_resort', '推荐', '1', '1', '', '0', '1', '1468895192', '1468895192');
INSERT INTO `ebcms5_auth_rule` VALUES ('167', '21', '节点权限', '友情链接排序', 'admin_link_resort', '排序', '1', '1', '', '0', '1', '1468895229', '1471336335');
INSERT INTO `ebcms5_auth_rule` VALUES ('168', '23', '节点权限', '排序推荐位', 'admin_recommendcate_resort', '排序', '1', '1', '', '0', '1', '1468895249', '1468895249');
INSERT INTO `ebcms5_auth_rule` VALUES ('169', '24', '节点权限', '排序推荐内容', 'admin_recommend_resort', '排序', '1', '1', '', '0', '1', '1468895263', '1468895263');
INSERT INTO `ebcms5_auth_rule` VALUES ('170', '26', '节点权限', '对单页排序', 'admin_single_resort', '排序', '1', '1', '', '0', '1', '1468895281', '1468895281');
INSERT INTO `ebcms5_auth_rule` VALUES ('171', '28', '节点权限', '对角色排序', 'admin_group_resort', '排序', '1', '1', '', '0', '1', '1468895297', '1468895297');
INSERT INTO `ebcms5_auth_rule` VALUES ('172', '29', '节点权限', '用户推荐', 'admin_user_resort', '推荐', '1', '1', '', '0', '1', '1468895323', '1468895323');
INSERT INTO `ebcms5_auth_rule` VALUES ('173', '2', '节点权限', '排序自定义配置', 'admin_config_resort', '排序', '1', '1', '', '0', '1', '1468895409', '1468895409');
INSERT INTO `ebcms5_auth_rule` VALUES ('181', '15', '节点权限', '批量移动内容', 'content_admin.content_move', '批量移动', '1', '1', '', '0', '1', '1468979228', '1468979228');
INSERT INTO `ebcms5_auth_rule` VALUES ('182', '14', '节点权限', '合并栏目', 'content_admin.category_merge', '合并（不受锁定影响）', '1', '1', '', '0', '1', '1468986793', '1468986881');
INSERT INTO `ebcms5_auth_rule` VALUES ('183', '1', '节点权限', '操作日志管理', 'admin_oplog_index', '操作日志管理', '1', '1', '', '0', '0', '1469020331', '1469020331');
INSERT INTO `ebcms5_auth_rule` VALUES ('184', '183', '节点权限', '删除操作日志', 'admin_oplog_delete', '删除', '1', '1', '', '0', '0', '1469020353', '1469020353');
INSERT INTO `ebcms5_auth_rule` VALUES ('185', '183', '节点权限', '查看操作日志', 'admin_oplog_show', '查看', '1', '1', '', '0', '0', '1469021555', '1469021555');
INSERT INTO `ebcms5_auth_rule` VALUES ('186', '17', '节点权限', '修改TAG样式', 'content_admin.tag_style', '修改样式', '1', '1', '', '0', '0', '1469167307', '1469167307');
INSERT INTO `ebcms5_auth_rule` VALUES ('187', '15', '节点权限', '修改内容标题样式', 'content_admin.content_style', '修改样式', '1', '1', '', '0', '0', '1469167354', '1469167354');
INSERT INTO `ebcms5_auth_rule` VALUES ('191', '188', '节点权限', '添加万能表单', 'forms_forms_add', '添加', '1', '1', '', '0', '0', '1471825736', '1471825766');
INSERT INTO `ebcms5_auth_rule` VALUES ('192', '188', '节点权限', '编辑万能表单', 'forms_forms_edit', '编辑', '1', '1', '', '0', '0', '1471825757', '1471825757');
INSERT INTO `ebcms5_auth_rule` VALUES ('193', '188', '节点权限', '删除万能表单', 'forms_forms_delete', '删除', '1', '1', '', '0', '0', '1471825782', '1471825782');
INSERT INTO `ebcms5_auth_rule` VALUES ('194', '188', '节点权限', '审核万能表单', 'forms_forms_status', '审核', '1', '1', '', '0', '0', '1471825803', '1471825803');
INSERT INTO `ebcms5_auth_rule` VALUES ('195', '188', '节点权限', '锁定万能表单', 'forms_forms_lock', '锁定', '1', '1', '', '0', '0', '1471825820', '1471825820');
INSERT INTO `ebcms5_auth_rule` VALUES ('196', '188', '节点权限', '万能表单排序', 'forms_forms_resort', '排序', '1', '1', '', '0', '0', '1471825835', '1471825835');
INSERT INTO `ebcms5_auth_rule` VALUES ('197', '189', '节点权限', '添加万能表单字段', 'forms_formsfield_add', '添加', '1', '1', '', '0', '0', '1471825869', '1471825869');
INSERT INTO `ebcms5_auth_rule` VALUES ('198', '189', '节点权限', '编辑万能表单字段', 'forms_formsfield_edit', '编辑', '1', '1', '', '0', '0', '1471825885', '1471825885');
INSERT INTO `ebcms5_auth_rule` VALUES ('199', '189', '节点权限', '删除万能表单字段', 'forms_formsfield_delete', '删除', '1', '1', '', '0', '0', '1471825897', '1471825897');
INSERT INTO `ebcms5_auth_rule` VALUES ('200', '189', '节点权限', '审核万能表单字段', 'forms_formsfield_status', '审核', '1', '1', '', '0', '0', '1471825911', '1471825911');
INSERT INTO `ebcms5_auth_rule` VALUES ('201', '189', '节点权限', '锁定万能表单字段', 'forms_formsfield_lock', '锁定', '1', '1', '', '0', '0', '1471825926', '1471825926');
INSERT INTO `ebcms5_auth_rule` VALUES ('202', '189', '节点权限', '万能表单字段排序', 'forms_formsfield_resort', '排序', '1', '1', '', '0', '0', '1471825943', '1471825943');
INSERT INTO `ebcms5_auth_rule` VALUES ('203', '190', '节点权限', '锁定万能表单用户提交的数据', 'forms_formsdata_lock', '锁定', '1', '1', '', '0', '0', '1471825986', '1471825986');
INSERT INTO `ebcms5_auth_rule` VALUES ('204', '190', '节点权限', '删除万能表单用户提交的数据', 'forms_formsdata_delete', '删除', '1', '1', '', '0', '0', '1471826015', '1471826015');
INSERT INTO `ebcms5_auth_rule` VALUES ('205', '0', '节点权限', '公告管理', 'bulletin', '公告模块', '1', '1', '', '0', '0', '1471837838', '1471837838');
INSERT INTO `ebcms5_auth_rule` VALUES ('206', '205', '节点权限', '公告管理', 'bulletin_bulletin_index', '公告管理', '1', '1', '', '0', '0', '1471837876', '1471837876');
INSERT INTO `ebcms5_auth_rule` VALUES ('207', '206', '节点权限', '添加公告', 'bulletin_bulletin_add', '添加', '1', '1', '', '0', '0', '1471837886', '1471837886');
INSERT INTO `ebcms5_auth_rule` VALUES ('208', '206', '节点权限', '编辑公告', 'bulletin_bulletin_edit', '编辑', '1', '1', '', '0', '0', '1471837897', '1471837897');
INSERT INTO `ebcms5_auth_rule` VALUES ('209', '206', '节点权限', '删除公告', 'bulletin_bulletin_delete', '删除', '1', '1', '', '0', '0', '1471837939', '1471837939');
INSERT INTO `ebcms5_auth_rule` VALUES ('210', '206', '节点权限', '审核公告', 'bulletin_bulletin_status', '审核', '1', '1', '', '0', '0', '1471837956', '1471837956');
INSERT INTO `ebcms5_auth_rule` VALUES ('211', '206', '节点权限', '锁定公告', 'bulletin_bulletin_lock', '锁定', '1', '1', '', '0', '0', '1471837972', '1471837972');
INSERT INTO `ebcms5_auth_rule` VALUES ('212', '206', '节点权限', '公告加粗着色', 'bulletin_bulletin_style', '加粗着色', '1', '1', '', '0', '0', '1471838450', '1471838450');
INSERT INTO `ebcms5_auth_rule` VALUES ('213', '1', '节点权限', '统计管理', 'admin_tongji_index', '统计管理', '1', '1', '', '0', '0', '1471835120', '1471835120');
INSERT INTO `ebcms5_auth_rule` VALUES ('214', '213', '节点权限', '删除统计数据', 'admin_tongji_delete', '删除', '1', '1', '', '0', '0', '1471835183', '1471835183');

-- ----------------------------
-- Table structure for ebcms5_bulletin
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_bulletin`;
CREATE TABLE `ebcms5_bulletin` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `shorttitle` varchar(255) NOT NULL DEFAULT '' COMMENT '短标题',
  `metatitle` varchar(255) NOT NULL DEFAULT '' COMMENT 'META标题',
  `keywords` varchar(255) NOT NULL DEFAULT '' COMMENT '关键字',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT '简介',
  `thumb` varchar(255) NOT NULL DEFAULT '' COMMENT '缩略图',
  `tpl` varchar(255) NOT NULL DEFAULT '' COMMENT '模板',
  `body` text COMMENT '内容',
  `ext` text COMMENT '扩展内容',
  `ebcms_url` varchar(255) NOT NULL DEFAULT '' COMMENT '外部链接',
  `click` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '点击量',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  `locked` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '锁定',
  `color` varchar(255) NOT NULL DEFAULT '' COMMENT '字体颜色',
  `size` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '字号',
  `bold` varchar(255) NOT NULL DEFAULT '' COMMENT '加粗',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='公告表';

-- ----------------------------
-- Records of ebcms5_bulletin
-- ----------------------------
INSERT INTO `ebcms5_bulletin` VALUES ('1', '2016年8月3日0:00-6:00华为企业云服务平台升级通知', '', '', '', '尊敬的华为企业云服务客户：您好！为了让平台为您提供更稳定的服务，我们计划于2016年8月3日0:00-6:00进行平台版本升级，升级期间通过新旧版本的平台管理资源的功能将无法使用（例如：无法进行登录、下单、删除操作等），需通过管理控制台完成的业务（bigdata、devcloud）也将暂时无法使用，其他业务不受影响。提请贵公司知悉，如有操作请提前进行，相关事宜做好安排。给您带来的不便，敬请谅解！如', '', '', '&lt;p&gt;尊敬的华为企业云服务客户：&lt;/p&gt;&lt;p&gt;您好！&lt;/p&gt;&lt;p&gt;为了让平台为您提供更稳定的服务，我们计划于2016年8月3日0:00-6:00进行平台版本升级，升级期间通过新旧版本的平台管理资源的功能将无法使 用（例如：无法进行登录、下单、删除操作等），需通过管理控制台完成的业务（bigdata、devcloud）也将暂时无法使用，其他业务不受影响。&lt;/p&gt;&lt;p&gt;提请贵公司知悉，如有操作请提前进行，相关事宜做好安排。给您带来的不便，敬请谅解！&lt;/p&gt;&lt;p&gt;如有问题，请拨打我们的服务热线:4000-955-988。&lt;/p&gt;&lt;p&gt;感谢您的支持与理解!&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '{\"__config__\":{\"__test__\":\"test\"}}', '', '0', '1471838736', '1471838736', '0', '1', '0', '', '0', '');

-- ----------------------------
-- Table structure for ebcms5_config
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_config`;
CREATE TABLE `ebcms5_config` (
  `id` int(4) unsigned NOT NULL AUTO_INCREMENT COMMENT '配置ID',
  `group` varchar(255) NOT NULL DEFAULT '' COMMENT '分组',
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分类',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父id',
  `title` varchar(250) NOT NULL DEFAULT '' COMMENT '标题',
  `name` char(40) NOT NULL DEFAULT '' COMMENT '配置项',
  `value` text COMMENT '配置值',
  `render` varchar(255) NOT NULL DEFAULT '' COMMENT '类型',
  `form` varchar(255) NOT NULL DEFAULT '' COMMENT '表单类型',
  `config` text COMMENT '类型配置',
  `remark` text COMMENT '说明',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `sort` int(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  `locked` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '锁定',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=228 DEFAULT CHARSET=utf8 COMMENT='核心配置表';

-- ----------------------------
-- Records of ebcms5_config
-- ----------------------------
INSERT INTO `ebcms5_config` VALUES ('2', '备份配置', '1', '0', '备份配置', 'backup_db', '', 'string', 'form_textbox', '', '', '1470528673', '0', '99', '1', '1');
INSERT INTO `ebcms5_config` VALUES ('4', '备份配置', '1', '2', '分卷大小', 'part', '2048000', 'number', 'form_numberbox', '', '', '0', '0', '99', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('5', '备份配置', '1', '2', '是否压缩', 'compress', '0', 'bool', 'form_bool', '', '', '0', '0', '99', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('7', '默认分组', '2', '0', '是否启用验证码', 'verify', '1', 'bool', 'form_bool', '', '', '0', '0', '99', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('8', '注册', '3', '0', '验证码', 'reg_verify', '1', 'bool', 'form_bool', '{\"disabled\":\"0\",\"readonly\":\"0\"}', '说到做到，感觉这个系统还不错。', '1467015119', '0', '80', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('9', '登录', '3', '0', '验证码', 'login_verify', '1', 'bool', 'form_bool', '{\"disabled\":\"0\",\"readonly\":\"0\"}', '', '1469457517', '0', '98', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('10', '找回密码', '3', '0', '验证码', 'password_verify', '1', 'bool', 'form_bool', '{\"disabled\":\"0\",\"readonly\":\"0\"}', '', '1467015126', '0', '60', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('11', '注册', '3', '0', '注册成功发送的消息模板', 'reg_success', '&lt;p&gt;尊敬的会员，你好，你注册的邮箱是 {email} 密码是 {password} 请妥善保管！ 谢谢！&lt;/p&gt;', 'string', 'form_ueditor', '{\"initialframeheight\":\"100\",\"autoheightenabled\":\"0\",\"maximumwords\":\"\",\"wordcount\":\"0\",\"elementpathenabled\":\"0\"}', '', '1471147501', '0', '60', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('12', '注册', '3', '0', '注册验证邮件模板', 'reg_url', '&lt;p&gt;你的注册链接地址是： {url} 点击链接或复制到浏览器打开即可注册成功&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', 'string', 'form_ueditor', '{\"initialframeheight\":\"100\",\"autoheightenabled\":\"0\",\"maximumwords\":\"\",\"wordcount\":\"0\",\"elementpathenabled\":\"0\"}', '如果可以的话，你就联系我吧。呵呵', '1471147489', '0', '85', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('13', '找回密码', '3', '0', '找回密码邮件模板', 'password_url', '&lt;p&gt;尊敬的会员，你好，点击下面的连接找回密码 {url} 谢谢！&lt;/p&gt;', 'string', 'form_ueditor', '{\"initialframeheight\":\"100\",\"autoheightenabled\":\"0\",\"maximumwords\":\"\",\"wordcount\":\"0\",\"elementpathenabled\":\"0\"}', '呵呵，我是说明，还没有添加的。感觉怎么样呢', '1471147513', '0', '97', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('15', '权限认证', '1', '0', '认证方式', 'auth_type', '1', 'number', 'form_radio', '{\"disabled\":\"0\",\"readonly\":\"0\",\"values\":\"\\u5b9e\\u65f6\\u8ba4\\u8bc1|1\\r\\n\\u767b\\u5f55\\u8ba4\\u8bc1|2\"}', '', '1467013609', '1467013399', '99', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('16', '权限认证', '1', '0', '认证开关', 'auth_on', '1', 'bool', 'form_bool', '', '', '1467013472', '1467013472', '99', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('17', '评论配置', '4', '0', '是否允许评论', 'comment_able', '1', 'bool', 'form_bool', '', '', '1467014870', '1467014745', '99', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('18', '评论配置', '4', '0', '允许游客评论', 'comment_visitor', '1', 'bool', 'form_bool', '', '', '1467883367', '1467014850', '89', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('19', '注册', '3', '0', '默认用户组', 'reg_group', '5', 'number', 'form_combotree', '{\"model\":\"admin/group\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"0\",\"tree\":\"0\",\"prompt\":\"\",\"queryparams\":\"group|eq|\\u666e\\u901a\",\"pid\":\"\",\"textfield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '', '1467015518', '1467014982', '70', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('20', '评论配置', '4', '0', '游客评论验证码', 'comment_visitor_verify', '1', 'bool', 'form_bool', '', '', '1467016419', '1467016419', '88', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('21', '评论配置', '4', '0', '会员评论验证码', 'comment_verify', '1', 'bool', 'form_bool', '', '', '1467016484', '1467016484', '91', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('22', '常规设置', '5', '0', '是否开启友链申请', 'apply_on', '1', 'bool', 'form_bool', '', '', '0', '0', '99', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('23', '常规设置', '5', '0', '是否开启验证码', 'apply_verify', '1', 'bool', 'form_bool', '', '', '0', '0', '99', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('176', '注册', '3', '0', '开启注册', 'reg_on', '1', 'bool', 'form_bool', '', '', '0', '0', '99', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('178', 'SEO配置', '8', '0', '网站名称', 'sitename', '易贝内容管理系统', 'string', 'form_textbox', '', '', '1467620254', '1467620197', '250', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('179', 'SEO配置', '8', '0', '关键字', 'keywords', '易贝内容管理系统 内容管理系统 cms ebcms 开源cms', 'string', 'form_textbox', '', '', '1467620240', '1467620240', '240', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('180', 'SEO配置', '8', '0', '网站简介', 'description', '易贝内容管理系统是一套自由的功能灵活的开源的内容管理系统。', 'string', 'form_multitextbox', '', '', '1467620296', '1467620296', '235', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('181', '系统配置', '1', '0', '关闭网站', 'site_closed', '0', 'bool', 'form_bool', '', '', '1467622192', '1467620367', '255', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('182', '系统配置', '1', '0', '关闭原因', 'site_closed_reason', '网站维护中。。。', 'string', 'form_multitextbox', '', '', '1467620412', '1467620412', '99', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('183', 'SEO配置', '2', '0', '标题', 'title', '留言中心', 'string', 'form_textbox', '', '', '1467621540', '1467621540', '99', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('184', 'SEO配置', '2', '0', '关键字', 'keywords', '留言中心', 'string', 'form_textbox', '', '', '1467621553', '1467621553', '99', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('185', 'SEO配置', '2', '0', '简介', 'description', '留言中心', 'string', 'form_multitextbox', '', '', '1467621572', '1467621572', '99', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('186', 'SEO配置', '8', '0', '网站标题', 'title', '易贝内容管理系统|免费的内容管理系统|EBCMS|phpcms', 'string', 'form_textbox', '{\"required\":\"0\",\"readonly\":\"0\",\"disabled\":\"0\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"prompt\":\"\"}', '', '1468854767', '1467622421', '245', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('187', '修改信息', '3', '0', '开启验证码', 'info_verify', '1', 'bool', 'form_bool', '{\"disabled\":\"0\",\"readonly\":\"0\"}', '', '1469457525', '1467715903', '99', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('188', '修改密码', '3', '0', '开启验证码', 'password_verifys', '1', 'bool', 'form_bool', '{\"disabled\":\"0\",\"readonly\":\"0\"}', '', '1471147277', '1467716039', '99', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('189', '常规配置', '4', '0', '记录点击', 'click_record', '1', 'bool', 'form_bool', '', '', '1467780362', '1467780362', '99', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('190', '评论配置', '4', '0', '评论是否需要审核', 'comment_check', '0', 'bool', 'form_bool', '', '', '1468033697', '1468033697', '99', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('191', '评论配置', '4', '0', '是否获取ip', 'comment_getip', '1', 'bool', 'form_bool', '', '', '1468033858', '1468033858', '99', '1', '1');
INSERT INTO `ebcms5_config` VALUES ('194', '收录检测', '4', '0', '关键词', 'baidu_notfound_keyword', '没有找到', 'string', 'form_textbox', '', '没有找到该url的关键词。', '1468463446', '1468463424', '99', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('195', '自定义配置', '9', '0', '百度首页广告代码', 'ad_index', '<script type=\"text/javascript\">\r\n    /*450*400 创建于 2016/7/4*/\r\n    var cpro_id = \"u2694067\";\r\n</script>\r\n<script type=\"text/javascript\" src=\"http://cpro.baidustatic.com/cpro/ui/c.js\"></script>', 'string', 'form_multitextbox', '', '', '1469075917', '1468484288', '9', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('205', '邮箱配置', '1', '0', '邮箱密码', 'email_password', '111111', 'string', 'form_textbox', '', '', '1469097163', '1469097163', '0', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('200', '路由配置', '1', '0', 'URL模式', 'url_model', '2', 'number', 'form_radio', '{\"disabled\":\"0\",\"readonly\":\"0\",\"values\":\"\\u666e\\u901a\\u6a21\\u5f0f|0\\r\\n\\u6807\\u51c6\\u6a21\\u5f0f|1\\r\\n\\u9ad8\\u7ea7\\u6a21\\u5f0f|2\"}', '', '1468553128', '1468508400', '99', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('201', '路由配置', '1', '0', '路由配置', 'url_route_rules', '', 'string', 'form_multitextbox', '{\"height\":\"22\",\"width\":\"\",\"maxlength\":\"\",\"minlength\":\"\",\"prompt\":\"\"}', '高级模式下生效', '1468578244', '1468552997', '99', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('202', '操作日志', '1', '0', '是否开启日志记录', 'oplog_on', '0', 'bool', 'form_bool', '', '', '1469019654', '1469019654', '0', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('204', '邮箱配置', '1', '0', '邮箱账号', 'email_name', 'kujiw@qq.com', 'string', 'form_textbox', '', '', '1469097134', '1469097134', '0', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('206', '邮箱配置', '1', '0', '发送者地址', 'email_from', 'kujiw@qq.com', 'string', 'form_textbox', '', '', '1469097211', '1469097211', '0', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('207', '邮箱配置', '1', '0', '发送者名称', 'email_fromname', 'ebcms', 'string', 'form_textbox', '', '', '1469097247', '1469097247', '0', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('208', '邮箱配置', '1', '0', '服务器', 'email_host', 'smtp.qq.com', 'string', 'form_textbox', '', '', '1469097284', '1469097284', '0', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('209', '邮箱配置', '1', '0', '端口', 'email_port', '25', 'string', 'form_textbox', '', '', '1469097313', '1469097313', '0', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('210', '邮箱配置', '1', '0', 'SMTP验证', 'email_smtpauth', '1', 'bool', 'form_bool', '', '', '1469097352', '1469097352', '0', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('211', '邮箱配置', '1', '0', '允许HTML', 'email_html', '1', 'bool', 'form_bool', '', '', '1469097408', '1469097408', '0', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('212', '默认分组', '2', '0', '是否需要审核', 'status', '0', 'bool', 'form_bool', '', '', '1471570571', '1469160016', '0', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('213', '搜索', '4', '0', '缓存时间', 'search_cache', '0', 'number', 'form_numberbox', '', '0表示不缓存 单位秒', '1469168744', '1469168744', '0', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('214', '默认分组', '2', '0', '分页大小', 'pagenum', '10', 'number', 'form_numberbox', '', '', '1469922753', '1469922753', '0', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('217', '基本配置', '12', '0', '是否开启浏览统计', 'tongji_on', '1', 'bool', 'form_bool', null, '', '1470463564', '1470463564', '0', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('218', '系统配置', '1', '0', '备份目录', 'backup_path', './backup', 'string', 'form_textbox', null, '', '1470528942', '1470528704', '0', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('219', '服务配置', '1', '221', '服务ID', 'appid', '', 'string', 'form_textbox', null, '请到http://www.ebcms.com/申请', '1470553058', '1470552864', '0', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('220', '服务配置', '1', '221', '密钥', 'appsecret', '', 'string', 'form_textbox', null, '', '1470553050', '1470552912', '0', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('221', '服务配置', '1', '0', 'server', 'server', '', 'string', 'form_textbox', null, '', '1470553042', '1470553042', '0', '1', '1');
INSERT INTO `ebcms5_config` VALUES ('222', '编辑器', '1', '0', '编辑器配置', 'ueditor', '{\r\n&quot;iframeCssUrl&quot;:&quot;{{get_root()}}/third/bootstrap/css/bootstrap.min.css&quot;,\r\n&quot;initialStyle&quot;:&quot;body{margin:15px;}&quot;\r\n}', 'json', 'form_multitextbox', '{\"required\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"height\":\"5\",\"width\":\"\",\"maxlength\":\"\",\"minlength\":\"\",\"prompt\":\"\"}', '请参考百度编辑器的config.js配置文档', '1471492669', '1471055188', '0', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('223', '消息通知', '3', '0', '评论通知模板', 'notice_comment', '&lt;p&gt;&lt;a href=&quot;{comment.user.space}&quot; target=&quot;_self&quot;&gt;{comment.user.nickname}&lt;/a&gt; 评论了你的评论&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;blockquote&gt;&lt;p&gt;&amp;nbsp;{mycomment.content}&lt;/p&gt;&lt;pre class=&quot;brush:php;toolbar:false&quot; style=&quot;line-height: 1.42857;&quot;&gt;{comment.content}&lt;/pre&gt;&lt;/blockquote&gt;', 'string', 'form_ueditor', '{\"initialframeheight\":\"100\",\"autoheightenabled\":\"0\",\"maximumwords\":\"\",\"wordcount\":\"1\",\"elementpathenabled\":\"0\"}', '提供两个变量\r\nmycomment 我的评论\r\ncomment 评论', '1471147428', '1471144518', '0', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('224', '编辑器', '1', '0', '编辑器上传配置', 'ueditor_upload', '', 'json', 'form_multitextbox', '{\"required\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"height\":\"10\",\"width\":\"\",\"maxlength\":\"\",\"minlength\":\"\",\"prompt\":\"\"}', '请参考third/ueditor/php/config.json', '1471492830', '1471492777', '0', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('225', '默认分组', '13', '0', '列表分页大小', 'pagenum', '20', 'number', 'form_numberbox', null, '', '1471837771', '1471837771', '0', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('226', '系统配置', '1', '0', '模板主题', 'theme', 'default', 'string', 'form_textbox', null, '', '1471999841', '1471999841', '0', '1', '0');
INSERT INTO `ebcms5_config` VALUES ('227', '系统配置', '1', '0', '移动版', 'mobile_on', '1', 'bool', 'form_bool', null, '开启手机版后，手机访问会自动定位模板，例如 当前主题是default，则对应的移动版模板主题为default_mobile', '1471999962', '1471999962', '0', '1', '0');

-- ----------------------------
-- Table structure for ebcms5_configcate
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_configcate`;
CREATE TABLE `ebcms5_configcate` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `group` varchar(255) NOT NULL DEFAULT '' COMMENT '分组',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '名称',
  `name` varchar(255) NOT NULL DEFAULT 'Common' COMMENT '生效模块',
  `remark` varchar(255) NOT NULL DEFAULT '' COMMENT '说明',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  `locked` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否锁定',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COMMENT='核心配置分类表';

-- ----------------------------
-- Records of ebcms5_configcate
-- ----------------------------
INSERT INTO `ebcms5_configcate` VALUES ('1', '系统配置', '系统配置', 'system', '', '0', '0', '90', '1', '0');
INSERT INTO `ebcms5_configcate` VALUES ('2', '模块配置', '留言模块', 'guestbook', '', '0', '0', '0', '1', '0');
INSERT INTO `ebcms5_configcate` VALUES ('3', '模块配置', '用户模块', 'user', '', '0', '0', '0', '1', '0');
INSERT INTO `ebcms5_configcate` VALUES ('4', '模块配置', '内容模块', 'content', '', '1467014698', '1467014698', '80', '1', '0');
INSERT INTO `ebcms5_configcate` VALUES ('5', '模块配置', '友情链接', 'link', '', '0', '0', '0', '1', '0');
INSERT INTO `ebcms5_configcate` VALUES ('8', '模块配置', '首页配置', 'index', '', '1467883363', '1467620168', '85', '1', '0');
INSERT INTO `ebcms5_configcate` VALUES ('9', '系统配置', '自定义配置', 'custom', '该配置项主要是 用于用户自己添加自己的配置项。方便前端模板开发。', '1468483060', '1468483000', '0', '1', '0');
INSERT INTO `ebcms5_configcate` VALUES ('11', '系统配置', '升级配置', 'upgrade', '', '1470459778', '1470459778', '0', '1', '0');
INSERT INTO `ebcms5_configcate` VALUES ('12', '系统配置', '统计配置', 'tongji', '', '1470463528', '1470463528', '0', '1', '0');
INSERT INTO `ebcms5_configcate` VALUES ('13', '模块配置', '公告配置', 'bulletin', '', '1471837750', '1471837750', '0', '1', '0');

-- ----------------------------
-- Table structure for ebcms5_content_body
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_content_body`;
CREATE TABLE `ebcms5_content_body` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `body` text COMMENT '内容主体',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=89 DEFAULT CHARSET=utf8 COMMENT='内容副表';

-- ----------------------------
-- Records of ebcms5_content_body
-- ----------------------------
INSERT INTO `ebcms5_content_body` VALUES ('1', '&lt;p&gt;外媒称，美国海军14日宣布，海军作战部长约翰·理查森上将即将访问中国，以探讨南中国海安全事宜。&lt;br/&gt;&lt;br/&gt;　　据美国《星条旗报》网站7月14日报道，一份海军新闻稿说，理查森在三天访问期间将参观中国人民解放军海军设施，并与解放军海军司令员吴胜利上将举行会晤。&lt;br/&gt;&lt;br/&gt;　　除南中国海议题外，两位上将预计还将探讨其他争议性较小的议题，包括最近举行的“环太平洋”联合军事演习。&lt;br/&gt;&lt;br/&gt;　　理查森将于7月17日起访问北京和青岛。这是他首次访华。&lt;br/&gt;&lt;br/&gt;　　根据海军新闻稿，理查森将参观中国的海军潜艇学院以及航空母舰辽宁舰。&lt;br/&gt;&lt;br/&gt;　　另据法新社7月15日报道，美国海军14日表示，美国和中国海军的指挥官将举行会晤。&lt;br/&gt;&lt;br/&gt;　　海军作战部长约翰·理查森上将即将从17日起对北京和沿海城市青岛进行为期三天的访问，其间将与中国海军司令员吴胜利举行会晤。&lt;br/&gt;&lt;br/&gt;　　北京被海牙仲裁庭12日作出的裁决所激怒，裁决认为中国对南中国海的主权主张是无效的。&lt;br/&gt;&lt;br/&gt;　　拥有世界上最大规模海军力量的美国在该地区派驻有军舰。从去年起，它还在该地区进行了三次“航行自由”行动，派遣军舰进入北京在南中国海修筑的人工岛12海里范围内，以显示华盛顿不接受中国的领土主权主张。&lt;br/&gt;&lt;br/&gt;　　尽管紧张态势不断加剧，但中美海军之间仍然保持着联系，试图将发生任何误解的风险降到最低。&lt;br/&gt;&lt;br/&gt;　　中国受邀参加了今年的“环太平洋”军事演习，目前该演习正在夏威夷和加利福尼亚之间的海域举行。&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('2', '&lt;p&gt;土耳其7月15日晚发生一起未遂军事政变，导致至少161人死亡和1440人受伤。16日，土政府指责流亡美国的土耳其宗教人士费特胡拉·居伦（Fethullah Gulen）在幕后策划这次政变，使土美关系出现紧张迹象，并封锁了美国在土耳其的空军基地，白宫为此召开紧急会议。&lt;br/&gt;&lt;br/&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 据俄罗斯卫星新闻网17日报道，美国驻土耳其领事馆16日说，在发生军人政变后，美国在土耳其南部的因斯里克空军基地被封锁，基地电力供应也被切断。美国官员称，因土耳其领空关闭，美国暂停对IS实施空中打击。&amp;nbsp;&lt;br/&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160717/1468748981125747578b54b5930ce.png&quot; alt=&quot;资料图：美国在土耳其南部的因斯里克空军基地&quot;/&gt;资料图：美国在土耳其南部的因斯里克空军基地&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 另据新华网7月17日消息，美国时间7月16日，白宫发表声明说，奥巴马7月16日在白宫紧急召集其国家安全顾问班子开会，专门听取有关土耳其最新局势的汇报。&lt;br/&gt;&lt;br/&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 美国总统奥巴马当日重申，美国“坚定不移地”支持土耳其的民选政府，希望美土双方在应对共同挑战方面继续合作。&lt;br/&gt;&lt;br/&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 尽管迄今美方没有收到有关美国人在这次政变中死伤的报告，但奥巴马指示其国安班子继续与土耳其相关部门合作，确保美在土外交人员、军人及家属的安全。&lt;br/&gt;&lt;br/&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 声明说，美国同时呼吁土耳其各方在法治框架内行事，避免采取会导致进一步暴力和局势动荡的行动。奥巴马还强调，在联合打击恐怖主义等应对共同挑战方面，美土双方需要继续合作。&lt;br/&gt;&lt;br/&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 土耳其政变使土美关系出现紧张迹象。这次白宫会议是在有报道说土政府封锁了美军驻扎的因吉尔利克空军基地后举行的。美军利用该基地对叙利亚境内的极端组织“伊斯兰国”武装发动空袭。&lt;br/&gt;&lt;br/&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 土耳其流亡美国宗教人士被指远程策划政变&lt;br/&gt;&lt;br/&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 土政府指责流亡美国的土耳其人费特胡拉·居伦在幕后策划这次政变，要求美政府将他引渡回土耳其。&lt;br/&gt;&lt;br/&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 美国务卿克里7月16日在卢森堡表示，美将考虑这个引渡请求，但美国尚未收到证明居伦有罪的证据。&amp;nbsp;&lt;br/&gt;&lt;br/&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 而费特胡拉·居伦本人则表示与政变无关，并强烈谴责土耳其的政变行为。他说，作为一个饱受多次军事政变折磨的人，如果我被指控与本次政变有关联，这是相当侮辱的。&lt;br/&gt;&lt;br/&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 他还表示，政府应当由自由公平的选举来产生，而非武力。&lt;br/&gt;&lt;br/&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 近期勿前往土耳其旅游&lt;br/&gt;&lt;br/&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 美国国务院16日还发布了旅游警告，建议美国公民目前重新考虑是否到土耳其旅游。&lt;br/&gt;&lt;br/&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 中国外交部及中国驻土耳其大使馆网站早在今年5月16日就曾发布最新旅游警告，提醒中国公民在近期谨慎前往土耳其、暂勿前往土耳其东南部和土耳其叙利亚边境地区，该提醒有效期至2016年11月16日。（综合/观察者网 周远方）&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('3', '&lt;p&gt;最近美帝国主义两艘航母战斗群公然闯入南海，耀武扬威的嘴脸令人发指，再加上南海仲裁对中国非常不利，这两件事牵动了无数中国人的心，一时间中美开战的舆论“甚嚣尘上”。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;如果因为南海问题真的打起来了，中国的胜算有几何？&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;得出结论之前，先做如下考虑：&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;第一，孰叫胜，孰叫败？现代的战争，军事上的胜败远不是最终的评判标准。最终的评判标准，应该是谁在战争中获取了更多的政治利益和战略利益！&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;第二，战争的形式问题。毫无疑问，军事行动应该是战争的直接形式，但是，现代战争还有政治、经济、金融、文化等等表现方式。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;那么，单纯从军事上说，美国就一定能打败中国吗？&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;如这场战争发生在中国家门口，美国绝无完胜的把握。理由有二：&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;一，美国的后勤补给线，无法支撑一场大规模且耗时漫长，并充满危险的战争。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;二，情报系统的不确定性，将影响美军的指挥协调能力。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;武器对比方面，中国自1996年后的知耻后进奋发图强终于弥补了和美军的代差，看看央视播放演习镜头里的鹰击12反舰导弹，看看苏30MKKII，歼16D，看看运20和红旗九、S300部署在人造岛礁。当然还有052D、052C这些不亚于美军的战舰。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;诚然，中美之间的武器装备仍确实存在着较大的差距。但中美如开战的话，以美军的大规模进攻为标志的第一阶段的战斗，中国将付出重大的代价。但是，战争转入第二阶段，美国将在付出巨大代价后，由于无法征服中国，从而不得承认中国作为真正的谈判对手，接受中国参与制定的国际规则。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;综述以上，中美之间的战争孰胜孰败？由于中美之间发展阶段的不同，文化背景、民族性格的差异，中美之间如果发生一场的战争，美国将失去现有的霸主地位，中国将凤凰涅槃！&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('4', '&lt;p&gt;针对所谓的南海“仲裁结果”，太平岛被认定为是礁，台湾渔民自组船队预订20日开往太平岛登岛护权。台“海岸巡防署”16日也派出千吨级的巡防救难舰“台东舰”前往太平岛，接替“伟星舰”执行巡弋护渔任务。&lt;br/&gt;&lt;br/&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 据台湾《联合报》报道，所谓南海“仲裁结果”引起岛内渔民的强烈反弹。“判决实在太不公平了”东港籍海吉利号渔船船主郑春忠表示，太平岛怎么可能是礁？一出领海就是别人的经济海域，以后怎么去捕鱼，既然台当局力度不够，干脆渔民自己来捍卫权益。&lt;br/&gt;&lt;br/&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 台湾屏东东港渔民自15日晚起，大肆号召各地渔民登太平岛宣示，虽路途遥远往返需费9至10天，截至16日下午4时，已有6艘船响应，预计20日上午10时出发。据台湾《中国时报》报道，宣示活动发言人罗强飞表示，从台湾到太平岛的路途约864海里，往返要花掉10天左右，以CT4吨级渔船估计，要花上20万元（新台币，下同）的油料，因此虽不少渔民想加入响应，碍于生计仍在观望。罗强飞透露，他们会以民间的力量募集款项，不愿任何政党经费介入，要让台当局看见渔民的决心和愤慨。&amp;nbsp;&lt;br/&gt;&lt;br/&gt;&amp;nbsp; &amp;nbsp;&amp;nbsp; 《联合报》指出，原只设定6艘渔船组成船队出发，但消息传出后有不少渔船声援，16日讨论决定维持在十艘。东港籍海吉利号渔船船主郑春忠表示，他也会派一艘一百多吨的渔船前往。&lt;br/&gt;&lt;br/&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; “我们是合法出海捕鱼作业”郑春忠说，船队将在太平岛附近经济海域作业，也会带物品登岛慰劳驻岛海巡官兵。他们计划取太平岛的淡水，在岛上生火煮饭，“用行动来证明这是岛”。东港区渔会总干事林汉丑表示，登岛行动由渔民自主发起，渔会尊重，渔民在紧急情况下可登岛。&lt;br/&gt;&lt;br/&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 台湾琉球区渔会总干事蔡宝兴说，渔会积极鼓励渔船主参加，争取捕鱼权益。“渔业署副署长”黄鸿燕也表示，尊重渔民的行动，渔民只要依正常渠道申请，即可出海作业；登太平岛非“渔业署”管辖业务，但会持续和渔民沟通。&lt;br/&gt;&lt;br/&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 据台湾“东森新闻云”报道，民国党16日发起全民联署行动，民国党主席徐欣莹指出，太平岛绝对是岛不是礁，台湾地区领导人蔡英文应该拿出决心，别让渔民孤军奋战。&lt;br/&gt;&lt;br/&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 报道指出，太平岛被判定为“礁”，严重影响屏东东港及小琉球地区的渔民，但台当局除提前派出“康定舰”巡弋南海外，后续动态静悄悄。对于外传蔡英文可能在近期登岛宣示，蔡英文办公室也澄清，目前没有规划，让渔民痛批台当局实在太软弱。&lt;br/&gt;&lt;br/&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 此次渔民自主发起的宣示活动，有渔民热烈响应，也有渔民认为在没有官方加持下，自行登岛根本没效果。屏东县议员洪慈綪说，“不是几个渔民去喊口号就有效，若与菲律宾渔船擦枪走火，安全问题谁负责？”&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('5', '&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160717/1468749103749957578b552f5e073.png&quot; alt=&quot;&quot;/&gt;&lt;/p&gt;&lt;p&gt;　　经过多年的讨价还价，美韩还是在7月8日敲定了部署“萨德”（THAAD：末段高空区域防御系统）到韩国的具体地点，当然了目前所有消息都认为这是美国的一次战略上的胜利。尤其是“萨德”本身2000公里探测距离，将会让中国东部的远程弹道导弹都处于美国反导网络侦测范围内，而这一带正好是中国对美洲大陆进行核打击的“东风-31”弹道导弹的发射阵地。这不等于卡主了中国“东风”导弹的命门了吗？实际上并非如此，美国如此急迫的把自己又送到了中国门口，反而给中国火箭军送了个新目标。&lt;br/&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160717/1468749103117821578b552f69e00.png&quot; alt=&quot;&quot;/&gt;&lt;/p&gt;&lt;p&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 大家最担心的“萨德“的AN/TPY-2型X波段雷达，其实真没有必要过分担心。美国早在2006年和2014年就在日本部署过两台X波段AN/ATY-2机动式早期预警雷达，结果呢？美国获得了什么核心数据了吗？同样没有。而且X波段也没有多么神秘，在这个波段上带宽就这么大，使用多台老式远程雷达进行大功率持续干扰，“萨德”就根本没有办法发挥效用了。有些朋友认为这样效费比不高，不过相对于能够克制的威胁，这些投入问题不大，其实相当划算。因为要完成同样功能的大型远程相控阵雷达，仅建造费用就是天文数字，仅仅建造费用就要7亿美元，后期维护更是天文数字。&lt;br/&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160717/1468749103148717578b552f7255a.png&quot; alt=&quot;&quot;/&gt;&lt;/p&gt;&lt;p&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 而且中国要想打击”萨德“有很多手段可以进行反击：目前中国的远程火箭炮部队正在进行海上训练。大家可以看下从海上打击”萨德“部署地点的距离是多少。以前都说真理在火炮的射程之内，现在也可以在火箭炮射程之内。而且“萨德”最有效的是针对高空的弹道导弹，在中国火箭军的“东风-10”陆地巡航导弹的超低空掠海打击下毫无还手之力。虽然韩国会负责“萨德”低空防御任务，不过由于韩国在开战之初就可能面临来自三方的同时打击，能拦住多少是个说不准的事情。只要一发摧毁了“萨德”的远程雷达，整套系统就此瘫痪了。而且，对于中国火箭军来说，”萨德“反而是给他们提供了一个陆基直接打击美军的合理目标，尤其”萨德“部署地点完全在“东风-21“中程弹道导弹和”东风-10“巡航导弹打击范围。对美军来说，最宝贵的还是人而不是装备，眼皮子底下的目标中国能不打？&lt;br/&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160717/1468749103352430578b552f8041d.png&quot; alt=&quot;&quot;/&gt;&lt;/p&gt;&lt;p&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 不过韩国部分媒体称根本不怕中国和俄罗斯对”萨德“进行打击。韩国亚洲大学中国研究室的金姓主任在韩国的《每日经济新闻》上撰文称：在部署”萨德“的实际协议中就隐含了对在韩”萨德“系统被打击时的反击条款，就是美、日对韩国联合的保证：当遭受到中、俄等国的摧毁时，将会履行反击义务。不过这种保证只是一种纸面保证。相对于中国多种反击手段：从陆地上的短程弹道导弹、远程火箭炮、空射和陆基巡航导弹等多种报复手段，毕竟”萨德“再能机动，韩国国土范围就是这么大，没有丝毫战略纵深可言。所以还是奉劝韩国不要耍小聪明，这样只会让自己处于更被动的情况，损人不利己其实就是韩国目前状态。&lt;br/&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160717/1468749103184176578b552f8e88a.png&quot; alt=&quot;&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 大家一直都认为美国在这个时间点部署“萨德”反导系统其实是针对中国的一招狠招。事实则是关于部署萨德，美国人心中早有小算盘。考虑到未来的极端情况，美国甚至可以直接空运部署部署“萨德”到美军驻韩基地里；这个根本不需要韩国同意，直接空运部署就好了，只不过防御角度上可能会存在一些死角，但是肯定确保美国自己的安全了，跟帮韩国防御没什么关系。而且美国越过韩国直接部署装备以前就有先例：当年美国驻扎在韩国的”斗牛犬“导弹和核弹头就完全部署在乌山基地里。所以“萨德”不过就是美国人手中一张可打可藏的牌，只不过在这个时间点打出来就是针对中国的。我们不要过分担心也不能轻视，更要思考未来面对这样情况要提前遏制的手段，而不是事后亮反击手段。（作者署名：无名高地）&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('6', '&lt;p&gt;导言： 新华社快讯：菲律宾 南海 仲裁案仲裁庭１２日作出非法无效的所谓最终裁决。对此，中方多次声明，菲律宾共和国阿基诺三世政府单方面提起仲裁违背国际法，仲裁庭没有管辖权，中国不接受，不承认。&amp;nbsp;&lt;br/&gt;　　美国曾经遇到此类所谓的判决，靠的强大的军事机器让胜诉者执行不了，对于中国来说，若菲国不撤诉，就不要指望与中国合作解决经济困境的问题，就象尼加拿瓜一样，没打一仗就象得到岛屿与土地，这个是不可能的，美国就是靠打来解决所有的问题，什么联合国都是屁，何况海牙法庭这搞笑的组织，不认它时屁都不是。维护国家利益的十一段线（九段线）还靠全体国民的努力，家不和，结果是外敌得利，这个历史的教训值得记取的。&amp;nbsp;&lt;br/&gt;　　国家领土的坚守不靠一纸文书，靠的就是枪杆子，没有这个一切就不要谈了，宁可死一个亿也要把所有的岛屿保下来，否则倒退一步，意味着步步退，敌进是没有止境的，也许国人应当丢掉幻想，准备战斗，死多少无所谓，只要打退想侵占土地的敌国就可以了，甚至也不需要笨猪式的不首先用核，要以死来抵抗任何国家趁机侵占国家的岛屿与领土。当然已经被敌国占的，可以等待，若有新占，必须血战到底，不然当局就应当下课，因为人民不满意了。&amp;nbsp;&lt;br/&gt;　　只有血洗，才能立威，若内部的贪腐分子亦会得到清洗与震撼，谁卖国，谁爱国，不看你说什么，不看你是否是在位在野，而在你的实际行动。&amp;nbsp;&lt;br/&gt;　　什么都向内，不敢保祖产，意味着民心将失，执政的基础便荡然无存，所以南海风云，可以显各方的真实面目。在国土将被侵入的条件下，执政者，得利者应当有相当重要的担当，走在前面，而不是退缩，所谓在其谋其政。亦不是保其权位而向敌国绥靖，国家的领土，没有一寸多余的。&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('7', '&lt;p&gt;海牙国际法庭所谓的南海仲裁案终于公布了，结果中国被置于彻底否定和相当不利的地位。这件事当然不能就此了结，相反，这恐怕只是一个开始，不要说接下来会不会有具体执行的，仅就这项裁决本身而言，也注定要成为中国头上的一个“紧箍咒”，被“国际社会”用来时时地敲打中国。预计，在今后与美国进一步“良性互动”，“深化互信，增强合作”的诸般过程中，中国将始终摆脱不了这方面的讹诈，美国将时时、处处、事事借仲裁要挟中国，这是起码的后续效应。南海问题被地国际化了，而且是“化”得彻头彻尾、彻里彻外，这意味着今后可能要出现种种意想不到的麻烦。从这个意义上说，这当然是一件坏事。&lt;br/&gt;　　但是，凡事都有两个方面，南海仲裁案也不例外。笔者以为，从另外一个视角看，这又是一件大好事，主要体现在它是生动的一课，对中国具有不可忽视的教育作用。&lt;br/&gt;　　首先，这是对中国爱国主义的一次空前动员，效果十分明显。中国人民的爱国热情过去很多时候都是帝国主义的炮声唤醒的，现在，他们又开着大炮回来了，这比他们巧梳妆、细打扮的绅士摸样来得好，因为这后一种摸样很有欺骗性，会助长中国人的散沙现象，而他们的大炮则不同，在他们大炮的威胁下，中华民族的凝聚力、爆发力和战斗力将得以快速增长。此次南海仲裁及围绕此次仲裁所发生的一系列事件就是这样。现在，平常关心不关心国家领土安全的人，现在都空前地关心了；平常对爱国与否漫不经心的人现在也都空前地关心了。可以说，爱国主义在中国被空前地激发起来了，效果已经十分明显。这不是一件大好事吗？&lt;br/&gt;　　其次，这还是对中国人民一次相当深刻的教育。长期以来，在“专家”、“学者”们的鼓噪下，关于中国与美国的关系，有关中国与资本主义世界的关系，基本逻辑与基本价值体系全都颠倒了，以致于是非不分、敌我不分，相当一些中国人把中国的前途与出路寄托在美国身上，相当一中国人认为中国将与美国“风雨同舟、殊途同归”，把美国当成帮助中国发展崛起的外部条件，把美国当成中国未来所努力的方向。现在，通过在南海争端中美国扮演的角色，相当多的中国人将因此进一步认清美国的霸权本质，进一步认清中美关系的本质属性，同时也能进一步认清美国主导下的世界秩序的丑陋与丑恶。这样教育作用很了不得，只有美国霸权主义者才有资格充当这个称职的反面教员。&lt;br/&gt;　　最后，这将促进一些中国人在思想灵魂深处进行反思。他们将因此反思自己，以前那样亲美，那样对美国歌颂赞美是不是有些过了；他们会反思自己，以前那样“逢中必反、逢美必赞”是不是有点没良心、缺人味。这样的反思将导致中国庞大的亲美阵营出现分裂，而这样的分裂，将极大地压缩中国亲美主义者的政治空间，极大地削弱他们的社会基础。可以说，美国对中国挥舞大棒，可能会让中国国内少数铁杆亲美分子嚣张，而将处使多数亲美主义者清醒过来，从而在事实上降低了中国国内的政治危险。这对中国而言，也是一件很好的事情。&lt;br/&gt;　　正是因为这样，笔者才坚定地认为，南海这堂生动的政治课，实在是上得好啊！坦率地说，现如今中国各种政治迷魂汤到处蔓延流淌，而像这等发人深省的政治课却少之又少，不能不说是一个缺憾。类似这样的课程，今后可能还要发生很多，但眼前这一堂课，无疑具有里程碑意义，它可能要成为中美关系上的一个里程碑，成为当代中国对外安全战略上的一个历史转折点。&lt;br/&gt;　　现在，一切具有基本爱国心的中国人都已经明白，中国同美国打交道，同资本主义世界打交道，不斗争就没有出路，“合作”是相对的、有限的，而“斗争”则是绝对的、长期的，面向未来，实现中华民族的伟大崛起，中国必须高举反霸、爱国的旗帜，这也是相辅相成的两大主题，把这样的两个主题牢固地树立起来，中国才能在美国面前挺直腰杆，才能在“不接受、不承认”的基础上更进一步。&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('8', '&lt;p&gt;中国已经多年没有进行过核弹核爆试验，那么现在中国核力量到达是个什么水平，就引发了网友的关心和热议。&lt;/p&gt;&lt;p&gt;　　由于中国一直都不愿意公开谈论中国本身装备的核弹数量，威力等等细节，因此外界对此也是有各式各样的猜测。&lt;/p&gt;&lt;p&gt;　　韩国认为评价核弹技术的一个重要指标是核弹小型化技术，在这个方面中国没有优势，还不如印度。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;img width=&quot;500&quot; height=&quot;308&quot; src=&quot;http://p3.pstatp.com/large/32300032edb32aa9061&quot; alt=&quot;&quot;/&gt;只有核弹小型化，才能缩小洲际导弹的尺寸，或者搭载更多的探测设备和燃料。按韩国的数字，美国核弹头仅有110公斤，俄罗斯225公斤，印度500公斤，中国600公斤。&lt;br/&gt;&lt;/p&gt;&lt;p&gt;　　但是我们知道，在1966年，从酒泉卫星发射中心就已经试验了当时的最高机密。使用东风2型导弹搭载核弹射向罗布泊试验场。结果，是圆满完成任务，中国第一次有了可以搭载核弹的弹道导弹。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;img width=&quot;500&quot; height=&quot;300&quot; src=&quot;http://p3.pstatp.com/large/32700032fcaa4aace28&quot; alt=&quot;&quot;/&gt;1969年，中国又使用东风3号导弹测试了搭载氢弹试验，当时就可以安装爆炸威力为百万吨级的小型化氢弹。至于韩国说的，中国导弹核弹头为500公斤不如印度，那都是几十年前的数据了。这种拿几十年前数据说现在的，逻辑未免太可笑了。&lt;br/&gt;&lt;/p&gt;&lt;p&gt;　　1966年东风2号导弹搭载的核弹头才是500公斤。而且，大核弹头也不是坏事，只是需要更大型导弹，但是其爆炸威力也是响应成倍增长的。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('9', '&lt;p&gt;最近，俄罗斯媒体一直在吹风，一会要把原来俄罗斯的超级航母技术卖给中国，一会又要卖给中国核潜艇，这和过去毛子卖给中国武器的态度完全不同，俄罗斯媒体为何突然吹这个风呢？在占豪看来，主要应该是基于三方面原因：&lt;br/&gt;　　一、经济压力所迫。&lt;br/&gt;　　由于俄罗斯经济陷入衰退，俄罗斯2016年的军事预算削减了5%，这种压力对俄罗斯来说非常大，那么出售装备给中国就是维系其军工企业运营和升级的关键。然而，现在中国军事实力也上来了，一般的东西中国根本不需要，所以这就想着试探一下看看这些高附加值的东西中国是不是需要，通过媒体释放出来一些信号可以试探中国反应。&lt;br/&gt;　　二、战略上刺激中美海上争霸。&lt;br/&gt;　　关于这一点俄罗斯的军事专家也说了，将这些战略装备和技术卖给中国可以促使中国与美国进行海上争霸，俄罗斯认为中国资源是有限的，投入更大的海军对俄罗斯这个陆上强国来说就是好事。既然俄罗斯现在造不出超级航母，那不如在中国还没有设计出更高级别航母的情况下卖给中国还能换钱。特别是中国拥有更高级别的核潜艇对俄罗斯威胁不会增加多少，但对美国威胁却会增加不少，更重要的是这玩意真值钱，也只有中国、印度能买得起。&lt;br/&gt;　　三、中国军事科技进步所逼。&lt;br/&gt;　　俄罗斯的科技进步速度远不如中国，现在中国自己的航母技术正在突飞猛进，估计自主航母到第三或第四艘的时候，差不多也就能造到8万到10万吨级了，这个时间根本用不了几年，估计2020年到2025年之间中国就开造这样的超大型航母，到那时俄罗斯的8万吨的超级航母技术对中国又有什么吸引力？也别说到那时候，哪怕现在，中国对俄罗斯的这些技术是否感冒都很难说，因为中国已经有了自己的设计能力。至于核动力潜艇，中国与俄罗斯技术上还有较大差距，如果俄罗斯真卖，中国还真有可能买，但再过十年八年俄罗斯再卖中国就不一定买了。没有中国这个买家顶着，俄罗斯想黑印度的钱也就难了。所以，俄罗斯这么提出来，哪怕不代表克里姆林宫的意见，也至少代表俄罗斯军方的部分意见。&lt;br/&gt;　　当然，至于中国是否感兴趣，那又是另说了，因为中国的军事科技的确是日新月异。&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('11', '&lt;p&gt;最近关于印度的话题很火，&lt;strong&gt;印度电影大全&lt;/strong&gt;，今年因为工作关系我在印度呆了半年，所以对印度的情况相对了解一点，又发现国内的很多同志们对印度并不很清楚，&lt;strong&gt;印度&lt;/strong&gt;，所以向大家介绍下我在印度的感受。&lt;/p&gt;&lt;p&gt;1、基本建设真的是糟糕透顶。我在印度坐十个小时的火车，沿途就没看到过任何令人赏心悦目的建筑，&lt;strong&gt;印度舞蹈&lt;/strong&gt;，&lt;strong&gt;印度性与艺术照片&lt;/strong&gt;，到处都是一片破败的景象。说他们基本建设落后我们30年绝不为过。&lt;/p&gt;&lt;p&gt;而且在十个小时的火车中，我也没有看到任何工厂!很奇怪吧!火车包括火车站也是超级破烂，印度的大、中、小城市我都去过，到处都是乱糟糟的，&lt;strong&gt;印度舞蹈&lt;/strong&gt;，我常常想印度人的钱都拿去干嘛了。&lt;/p&gt;&lt;pre class=&quot;brush:php;toolbar:false&quot;&gt;啊手动阀手动阀&lt;/pre&gt;&lt;p&gt;2、印度人不讲卫生也是真的。右手抓饭左手擦屁股。而且他们的食物粘乎乎的，看到印度人把他们的黑手在里面搅来搅去，真是有多恶心就有多恶心。&lt;/p&gt;&lt;p&gt;反正我在印度是从来没吃过印度人的饭，&lt;strong&gt;印度尼西亚&lt;/strong&gt;，&lt;strong&gt;印度尼西亚&lt;/strong&gt;，只吃中国厨师做的，&lt;strong&gt;印度罕见连体婴降生&lt;/strong&gt;，坐火车就带些煮熟的鸡蛋，和一些饼干。印度人的带包装的饼干也不干净。另外，在我吃饭的时候，绝对不能看到任何印度人，否则没法吃。&lt;/p&gt;&lt;p&gt;印度火车内部，不通空气，气味刺鼻，&lt;strong&gt;印度妓女村&lt;/strong&gt;，&lt;strong&gt;印度&lt;/strong&gt;，你吃得下去饭么&lt;/p&gt;&lt;p&gt;3、印度人很穷也是真的。很多人就睡在路边上，&lt;strong&gt;印度妓女村&lt;/strong&gt;，没有家。我还看到过住在树上的。很多文盲。我们在那边找一个焊工比在国内找一个高级工程师还要难。但是干体力活的人很容易找。&lt;/p&gt;&lt;p&gt;4、印度有些电视台24小时都在放歌舞，这个很无敌。&lt;/p&gt;&lt;p&gt;5、大多数印度人并不认为他们领先中国20年，&lt;strong&gt;印度罕见连体婴降生&lt;/strong&gt;，他们谈起自己的国家就大摇其头，说我们太穷之类的话。去过中国的印度人很羡慕中国。&lt;/p&gt;&lt;p&gt;印度人大便后用左手擦屁股，&lt;strong&gt;印度吧&lt;/strong&gt;，右手一般用来吃饭，问题是当你一只手拿不过来时&lt;/p&gt;&lt;p&gt;6、医疗卫生方面。离我们那(我们在一个小城)300公里远才有一个医院，&lt;strong&gt;印度电影大全&lt;/strong&gt;，所以在印度千万不能得病。常用的药一定要带够。&lt;/p&gt;&lt;p&gt;7、但是印度的治安还可以。有个同事走了，&lt;strong&gt;印度人看中国&lt;/strong&gt;，鞋放在宿舍外面几个月都没丢。我们宿舍区也有些印度人在住，&lt;strong&gt;印度罕见连体婴降生&lt;/strong&gt;，&lt;strong&gt;印度性与艺术照片&lt;/strong&gt;，搞卫生的也是印度人。&lt;/p&gt;&lt;p&gt;8、印度的敌人。我问几个印度青年，&lt;strong&gt;印度电影&lt;/strong&gt;，他们回答是：第一，美国(阻挠他们发展核武器)第二，&lt;strong&gt;印度吧&lt;/strong&gt;，巴基斯坦(不用说了)，第三，中国(不用说了)。&lt;/p&gt;&lt;p&gt;9、印度超级热。比中国最热的地方还要热。&lt;/p&gt;&lt;p&gt;10、公共汽车超级破，出租车也很破。&lt;/p&gt;&lt;p&gt;11、我在印度呆一个小时都嫌多。&lt;/p&gt;&lt;p&gt;12、这辈子再也不想去印度。&lt;/p&gt;&lt;p&gt;13、我既不是愤青，也不是精英，&lt;strong&gt;印度尼西亚&lt;/strong&gt;，只是写下自己真实感受的普通中国人。&lt;/p&gt;&lt;p&gt;曝光印度重口味生活中国人吐着回来&lt;/p&gt;&lt;p&gt;听我一好朋友说过，她的姐姐被印度人邀请去印度参加婚礼，住的五星级酒店照样没有厕纸!你可别不相信，你到印度旅游一圈才能深有体会!这是一个集腐尸，粪便为一体的国家。&lt;/p&gt;&lt;p&gt;恒河上漂着的尸体，&lt;strong&gt;印度人看中国&lt;/strong&gt;，活人就在旁边刷牙洗澡&lt;/p&gt;&lt;p&gt;印度土地干燥，树木并不繁茂，有时候放眼大地一片荒芜。印度人喜欢尊崇牛为圣牛，&lt;strong&gt;印度神油&lt;/strong&gt;，满大街的圣牛随便拉屎。印度妇女更是有了收集牛粪这一项娱乐活动。&lt;/p&gt;&lt;p&gt;你能想象BODHGAYA，多少年来游客朝圣者络绎不绝的圣地，当地人还是生活在赤贫的脏乱中。古镇大街旁，&lt;strong&gt;印度电影&lt;/strong&gt;，垃圾洒满地。野生动物们争相恐后的把垃圾当做早餐。&lt;/p&gt;&lt;p&gt;PURI是印度东海岸有名的度假胜地。也是一个天堂与地狱共存的清贫渔村。整个村的人几乎都在海滩上拉屎，郊外也如此。更令人震惊的是，印度男人把随处方便当做一种传统文化。&lt;/p&gt;&lt;p&gt;秉持着我脏但是我精彩的理念，在恒哥边上的古城VARANSY，每天都有人在垃圾堆上大小便，排泄物，垃圾一堆堆回归圣河，各地的朝圣者，&lt;strong&gt;印度神油&lt;/strong&gt;，&lt;strong&gt;印度电影大全&lt;/strong&gt;，怀着对神的敬意在此刷牙洗脸沐浴游泳。&lt;/p&gt;&lt;p&gt;近日，一小群人争论印度落后中国多少。结果很快出来，落后10年至25年以上。事实上，弄清两个“正在崛起的亚洲巨人”之间的差距是一项有益的研究。比如，中国2011年的GDP是6.99万亿美元，或者说是印度1.84万亿美元的4倍。&lt;/p&gt;&lt;p&gt;如果印度经济以年平均7.8%的速度发展(过去10年的速度)，&lt;strong&gt;印度性与艺术照片&lt;/strong&gt;，&lt;strong&gt;印度舞蹈&lt;/strong&gt;，印度需要18年的时间才能达到中国目前的规模。&lt;/p&gt;&lt;p&gt;如果发展速度加快到9%，印度仍然需要15年。印度是否本可以避免落后中国如此多?毕竟，当中国于1978年开始四个现代化的时候，&lt;strong&gt;印度吧&lt;/strong&gt;，&lt;strong&gt;印度神油&lt;/strong&gt;，两个经济体的规模大约 相等(1450亿美元至1480亿美元)。甚至在1991年，&lt;strong&gt;印度人看中国&lt;/strong&gt;，当印度开始改革的时候，中国经济只比印度2680亿美元的经济大40%。&lt;/p&gt;&lt;p&gt;答案是，印度1991年就已经在主要的指标上落后中国二十年以上。差距并没有弥合。&lt;/p&gt;&lt;p&gt;我正好访问了中国…别说落后中国十年或者二十年左右——我们至少落后他们200年…当我们200年后达到他们目前水平的时候——中国将领先我们500年…虽然那里的人们有某些问题…不过在商场、基础设施、公路、汽车、精通科技的人才等方面，&lt;strong&gt;印度妓女村&lt;/strong&gt;，&lt;strong&gt;印度电影&lt;/strong&gt;，&lt;strong&gt;印度&lt;/strong&gt;，你无法进行比较…&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('12', '&lt;p&gt;让拥有一定资产的能人、富人走上村干部岗位，曾被当成发展农村经济的捷径，在江苏乃至全国遍地开花。然而，在“老板村官”为农村面貌带来改变的同 时，一些问题也随之暴露。今年5月，南通海门明星村官叶剑生疑因身陷债务纠纷服下化学物品。时隔两个月，常州也发生类似情况，一村支书因身缠巨债与外界失 联。现代快报记者历时数日调查，从个案到现象，尝试找出“老板村官”频繁出事的潜在原因。知名社会学专家邱建新在接受现代快报记者采访时表示，自身素质的 不足以及监管、考核制度的缺陷，共同导致了乡村治理的异化。因此，必须完善监管制度，把权力关进笼子。&lt;/p&gt;&lt;p&gt;　　现代快报/ZAKER南京记者&lt;/p&gt;&lt;p&gt;　　宋体佳 文/摄&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160717/1468750519481568578b5ab75d880.png&quot; alt=&quot;1468750519481568578b5ab75d880.png&quot;/&gt;&lt;/p&gt;&lt;p&gt;　　身缠巨债，常州一村支书跑路&lt;/p&gt;&lt;p&gt;　　7 月9日，有网友在当地论坛爆料称，常州青城村村支书陈某跑路了，然而，因网帖语焉不详，这条信息并未引起网友的太多关注。此后两天，不断有人在网络上发帖 谈及此事，且情节越来越丰富，按网友的说法，陈某因无力偿还巨额高利贷，只好跑路。随后，这一说法得到当地村委及镇政府的证实。&lt;/p&gt;&lt;p&gt;　　“前几 天一直在做防汛工作，也没发现有什么异常。”7月14日，青城村委会工作人员谷芳（化名）在接受现代快报记者采访时称，她最后一次见到陈某是在6日的防汛 工作会议上，而到了7月8日，防汛工作会议的组织者变成了镇里的领导。崔敏（化名）也是青城村委会的工作人员，她回忆，自从去年8月，陈某提任村支书后， 就经常有些社会人员到村委会找他，“有的开着豪车，也有银行的”。崔敏称，陈某跑路之后，仍有不少人到村委会找他，“都是要债的，坐在办公室不肯走。听说 欠得太多了，接近2个亿。”&lt;/p&gt;&lt;p&gt;　　“一开始我也是从网上看到的，直到镇里开紧急会议，我才知道这个事情。”当地镇政府相关负责人在接受现代快 报记者采访时称，镇党委对此事非常重视，于7月11日紧急召开党政工作会议，由于陈某“因个人债务原因离职，已不能胜任村支书工作”，免去其青城村村支书 职务。此外，该镇还及时选派了新村支书暂时接管青城村事务。该负责人称，陈某确实因身缠巨债躲了起来，具体的欠债数额还在进一步统计中。另外，陈某欠下的 主要是个人债务，与村、镇政府无任何关系，“若有触犯法律的地方，将由相关部门调查，交由司法机关处理”。&lt;/p&gt;&lt;p&gt;　　此后，青城村多位知情村民告诉现代快报记者，陈某所欠下的债务和政府无关。&lt;/p&gt;&lt;p&gt;　　因为致富有方走上了村官岗位&lt;/p&gt;&lt;p&gt;　　在青城村，村支书陈某因身缠巨债跑路的消息早就炸开了锅。至于欠款的数额，尽管官方至今没有给出确切的说法，但在当地人的传言中，陈某身上背负的债务至少有一亿元，且这笔钱和他的企业有很大的关联。&lt;/p&gt;&lt;p&gt;　　在 青城村工作人员出具的一份统计表中，现代快报记者看到，陈某还是“常州恒源钢结构工程有限公司”的法人代表。而据崔敏透露，陈某也正是因为企业主的身份， 才被作为“能人”引进村官岗位的。“他就是这个地方的人。”崔敏称，早前，陈某曾因生活困苦做过“托锅底”的手艺活，后于2003年前后成立钢结构公司， 企业也不断壮大。因为做事踏实、勤奋、脑袋灵活，深得老支书的赏识，得到不少帮助。&lt;/p&gt;&lt;p&gt;　　2013年5月，老支书临退休前，将陈某作为能人推 选进入青城村委，当了副书记。“本来是打算让他做村支书的，后来因为各种原因，镇里另派了支书人员，只给他安排了一个副支书。”崔敏介绍，在副支书岗位工 作近两年后，镇里来的书记因为患病被调离，作为唯一副书记，陈某临危受命，于去年8月被提拔为青城村村支书。没想到，担任村支书还未满一年，陈某就身陷债 务漩涡。7月14日下午，现代快报记者在青城工业园看到，曾红火一时的“常州恒源钢结构工程有限公司”非常冷清。门卫称，目前工厂已处于停业状态，老板也 不知去向。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('13', '&lt;p&gt;正值暑假，安徽阜阳3男孩在家看动画《葫芦娃》，一时兴起想“扮”葫芦娃玩儿。于是他们走到村里一处葫芦地，顺手偷了几个葫芦，“扮起”葫芦娃。民警找来家长，协商赔偿了农民伯伯的损失。男孩不解：“想当葫芦娃有错吗？”@@中警安徽&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('14', '&lt;p&gt;记者 左燕燕 实习生 龚晨霞&lt;/p&gt;&lt;p&gt;　　“遭遇‘呼死你’软件攻击，一分钟5个电话，一小时600个电话，一天14000多个电话，持续一天了，微信转账300元才能停止骚扰”。昨日，网友聂先生发微博称。&lt;/p&gt;&lt;p&gt;　　通讯专家向重案组37号(微信号：zhonganzu37)解释，针对这种情况，可下载一些拦截软件，通过设置拦截无主叫号码电话，便可脱离困扰。警方则建议市民遇到上述情况，可立即报警求助。&lt;/p&gt;&lt;p&gt;　　莫名遭遇一天14000多无主电话骚扰&lt;/p&gt;&lt;p&gt;　　7月15日下午五点，互联网产品公司经理聂先生突然接到电话骚扰，一分钟5个电话，一小时600个电话，一天14000多个电话，响一秒就挂断，“我的手机是吉祥号码，对方可能觉得我比较有钱。”&lt;/p&gt;&lt;p&gt;　　由于骚扰电话均未显示号码，聂先生无法设置黑/白名单拒绝接听，只好开启了勿扰模式，但电话仍旧可以打进来。联系运营公司，“说是无主号码，无法拦截处理和查找信息，建议办理紧急停机。”&lt;/p&gt;&lt;p&gt;　　电话“轰炸”的同时，聂先生接收到两条短信，内容基本相似，告知他号码被“呼死你”软件攻击，每天呼叫时间为早上8点到晚上23点，需要添加微信公众号，支付300元才能解除骚扰。&lt;/p&gt;&lt;p&gt;　　对方短信中甚至扬言，“钱不多，给你10分钟解除时间，如果超过解除时间，会根据小时解除费用50%收取呼叫费用。”手机号码归属地是浙江绍兴，但回拨过去却一直无法接听。&lt;/p&gt;&lt;p&gt;　　昨日上午11点多，聂先生没有给对方转钱，而是选择报警，中午12点半，将近一天的电话骚扰终于停止。&lt;/p&gt;&lt;p&gt;　　“也不知道为什么突然停了，幸好这是周末，不在工作时间，所以没有造成太大影响。如果长期如此，只能考虑换个号码。”聂先生对重案组37号(微信号：zhonganzu37)说道。&lt;/p&gt;&lt;p&gt;　　使用软件拨打上千次电话仅几分钱&lt;/p&gt;&lt;p&gt;　　360手机卫士安全的专家买昭一丁表示，这类软件使用成本非常低，基本上千次可能才几分钱。本来这种服务是用来协助有关部门整治非法广告的，但如今已经被滥用，甚至出现了这位市民遭遇的被敲诈情况。&lt;/p&gt;&lt;p&gt;　　那么手机是否真的无法拦截这类电话？专家称，可以在手机上安装如360手机卫士这样的安全软件，开启其中的骚扰拦截功能。将拦截模式设置为“只接受通讯录”，“只接受白名单”，或者“全部拦截”，就能有效避免手机被不断的呼叫。&lt;/p&gt;&lt;p&gt;　　另外，如果有人宣传在手机上安装类似“呼死你”这样的App，也确实有可能是窃取用户隐私甚至恶意扣费的恶意木马应用。推荐大家不要安装来路不明的手机应用，同时使用手机安全软件定期扫描与查杀手机病毒，避免个人财产遭受损失。&lt;/p&gt;&lt;p&gt;　　应对：涉嫌敲诈勒索 应立即报警&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('15', '&lt;p&gt;网友视频爆料，“广东大沥新都会一男子的女友要换电影票，工作人员不让，男子就跟工作人员吵了起来，随后从6楼跳下”。对此佛山市公安局南海分局称，事发7月14日，地点是南海大沥新都会商场，男子跳楼原因仍在调查。网友：为什么把命看得那么淡[蜡烛]&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160717/1468748981125747578b54b5930ce.png&quot; alt=&quot;1468748981125747578b54b5930ce.png&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('16', '&lt;p&gt;据香港《文汇报》7月17日报道，香港西区观龙楼昨天（16日）凌晨发生骸人听闻纵火及凶杀案。独居6旬老汉因噪音与一邻居积怨，争执后有人突向对方住所掷燃烧弹纵火，邻居一家三口惨遭灭门，其中持单程证（又称前往港澳通行证，为公安部门发给有条件的申请人赴港澳地区定居的证件--观察者网注）来港团聚仅5日的妻子及年仅3岁半女儿相拥葬身火海，男户主全身着火坠楼死亡，疑凶后折返再纵火自焚同丧黄泉。警方港岛总区重案组已接手调查惨剧肇因。&lt;/p&gt;&lt;p&gt;　　男户主堕4楼平台 烧至皮开肉绽&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160717/1468732963154225578b16235ae02.png&quot; alt=&quot;1468732963154225578b16235ae02.png&quot;/&gt;&lt;/p&gt;&lt;p&gt;　　酿成4人死亡的邻里惨剧现场为西环观龙楼D座13楼两个对户单位。其中59号单位住有一家三口，包括26岁男子黄志强、同龄妻子吴倩欣、及年仅3岁半的女儿黄依琳。对户64号单位为一名63岁独居男子许伟忠，4人同在案件中身亡。&lt;/p&gt;&lt;p&gt;　　港岛总区刑事总部警司温兆雄表示，独居汉死者患精神病多年，曾有多次投诉噪音及与邻居争执记录，屋苑管理部门及社工均有跟进事件。警方正设法联络独居汉的兄长，调查其精神状况及背景，以及两户人家事发前有否发生争执等。案件暂列作纵火及凶杀案，交由港岛总区重案组跟进。&lt;/p&gt;&lt;p&gt;　　事发于昨日凌晨1时40分，上址两个单位几乎同时冒烟起火，大厦多名居民发现纷纷报案，在消防员到场前，其中一家三口单位的火势已迅速蔓延全屋，烈焰及浓烟由露台向外喷窜，其间有住客更目睹一个火人攀出窗外挣扎呼救，约半分钟终不支飞堕至4楼平台。&lt;/p&gt;&lt;p&gt;　　消防员赶到立即出动搜救队进入火场扑救，并协助约200名大厦住客逃生。同时间，救援人员在4楼平台发现一名被烧至衣衫尽毁、皮开肉绽的男子，证实已当场死亡。&lt;/p&gt;&lt;p&gt;　　至凌晨3时58分，消防员终将两个单位的大火扑灭，并在堕楼男子的单位客厅处，发现两具相拥烧焦女尸，又在另一单位的大门后发现一具男焦尸。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('17', '&lt;p&gt;据港媒报道，爱金成狂的印度宾布里富豪普盖（Datta Phuge）周四遇袭身亡，12名嫌犯手持镰刀和石头对其痛殴，普盖送医后死亡。警方随后拘捕5名疑犯，其中一人为普盖的侄儿，事件怀疑与金钱纠纷有关。&lt;/p&gt;&lt;p&gt;　　事发于周四晚上，48岁的普盖与22岁儿子获邀出席一个生日派对，当他们开车抵达派对地点后，袭击者把普盖从座驾里拉了出来，有指12名疑犯用镰刀和大石殴打普盖至死。普盖22岁儿子舒布汉驾驶另一辆车子从旁经过，目击整场袭击，但未受攻击。舒布汉称认识大部分行凶者。&lt;/p&gt;&lt;p&gt;　　普盖从2013年开始有了名气，从事贷款业的他曾豪掷18.7万英镑打造一件重3.5公斤、由15名工人制造的黄金战衣，更自称“宾布里黄金汉”。普盖外出时均有保镖护驾，唯独事发当日保镖未有随行。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('18', '&lt;p&gt;华商报汉中讯（记者周金柱）6月25日晚9时许，南郑县青树镇冉家营村发生惨剧：上门女婿罗某因琐事与妻子发生口角，将妻子和岳母残忍杀害。行凶过程中，女儿一度呼救，却被他关进厨房后继续行凶。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160717/1468750425575162578b5a5991dc0.png&quot; alt=&quot;1468750425575162578b5a5991dc0.png&quot;/&gt;&lt;/p&gt;&lt;p&gt;　　7月13日上午，在南郑县青树镇冉家营村杨明志家，9岁的孙女躲在他身后一语不发。杨明志说，当时他正在镇上工地打工，听孙女电话里说“妈妈和奶奶都被爸爸砍倒了”，就赶紧骑摩托车赶回家，发现老伴和女儿躺在院子里，已没有了呼吸，周围还有很多血迹。&lt;/p&gt;&lt;p&gt;　　杨明志的二女儿杨春兰说，2003年1月，姐姐和同村男子罗某经人介绍认识一个月便结了婚，婚后发现两人性格差异大，关系开始恶化。2007年，他们的女儿秀秀（化名）出生。&lt;/p&gt;&lt;p&gt;　　“秀秀出生时患有血管瘤。”杨春兰说，今年6月6日，姐姐向法院提出离婚，7月5日就要开庭。办案民警介绍，6月25日晚，42岁的罗某打工回家，因琐事与妻子发生争吵，罗某便从厨房拿出菜刀将妻子砍伤在地，岳母邓某上前阻拦并追打罗某，罗某便捡起院中砖块朝邓某头部连打数下。见岳母倒地，罗某又用砖块和木墩向母女头部连砸数下，致二人死亡。作案后，罗某前往派出所投案自首。7月13日，罗某因涉嫌故意杀人罪被批捕。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('19', '&lt;p&gt;重庆商报讯 日前，合川区公安局云门派出所接到群众报警，称他家里进去了一名陌生男子，怀疑是小偷。民警迅速赶到现场，发现了擅自闯入的年轻男子倪某。经了解，倪某今年23岁，浙江温州人，与居住在该处的李某曾是男女朋友。后来两人分手，但倪某一直放不下这段感情。为挽回李某，倪某买了一堆礼物，从工作地广东打飞的来到重庆，找到了李某的住处。面对“从天而降”的前男友，李某当场婉拒了，随后便藏身朋友家“玩失踪”。倪某则找来锁匠换掉李某家大门的锁芯，并进入李某家中静待其回家。&lt;/p&gt;&lt;p&gt;　　这一切被李某的邻居发现，邻居立即给李某的父亲打了电话，李某父亲马上报了警。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160717/1468750404803833578b5a441cb15.png&quot; alt=&quot;1468750404803833578b5a441cb15.png&quot;/&gt;&lt;/p&gt;&lt;p&gt;　　近日，对倪某非法侵入他人住宅的违法行为，合川区公安局对其处以行政拘留5日并罚款200元。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('20', '&lt;p&gt;据中山电视台《城市零距离》报道，在广东中山古镇打工的汪先生向我们报料，说工厂给他的工资中有假钱，他数了一下，竟然有12张之多！&lt;/p&gt;&lt;p&gt;　　事情还要从7月11日说起，当时汪先生去广州火车站买车票，打算坐火车去浙江找工作。“我是拿两张100元钞票出来，因为它是200元的车票，售票员说这钱是假的，然后叫我换几张。”&lt;/p&gt;&lt;p&gt;　　汪先生于是又从钱包里重新拿了四张百元钞票出来，谁知道还是被告知是假的。汪先生赶紧清点自己的钱，发现类似这样的钞票一共有12张！&lt;/p&gt;&lt;p&gt;　　记者仔细观察发现，这12张钞票中有很多张的编号都是一致的。比如说有5张钞票都是用了P50W373099这个编号，有4张钞票用了P50W373092的编号，有3张钞票用了P50W373096的编号。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160717/1468750485466163578b5a95e6159.png&quot; alt=&quot;1468750485466163578b5a95e6159.png&quot;/&gt;&lt;/p&gt;&lt;p&gt;　　而迎光一看这些钞票，还可发现钞票的水印印刷十分粗糙，水印的头像也与真钞的有明显的不同。记者之后随机找了一间商铺用验钞机逐一检验这些钞票的真假，无一例外全是假钞。&lt;/p&gt;&lt;p&gt;　　那这些假钞究竟是从哪里来的呢？汪先生就说，他之前在古镇一家儿童用品公司工作，辞工后，他在7月7日领到了3月份到6月份的工资，共计6150元，全部现金发放。他就怀疑，这些假钞是工厂给他的。&lt;/p&gt;&lt;p&gt;　　（记者：你这些假钞确定是从工厂里领出来的？）确定！因为我又没换，又没拿去用，一拿来我就包起来了，就揣在这包里了。汪先生说，当时他只清点了下数目就走了，并没有一张一张去辨认钞票的真假。12张是假的话，等于工资就少了1200元，真是欲哭无泪！&lt;/p&gt;&lt;p&gt;　　记者之后通过电话联系上汪先生之前工作的儿童用品公司的负责人。对方就说，工厂发的钱都是真钞，他建议汪先生去报警。儿童用品厂负责人袁先生说：“员工和人事是点得清清楚楚的了，当面点清当面过了机的，我们发工资的时候，他应该是在火车站或者在其他场所被人调换了。”&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('21', '&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160717/1468749632123505578b5740aee7a.png&quot; alt=&quot;&quot;/&gt;网站截图&lt;/p&gt;&lt;p&gt;　　这个犀利、理直气壮甚至十分粗鲁的问题，来自Quora上一位不知名人士。Quora类似知乎，是美国知名的问答平台。&lt;/p&gt;&lt;p&gt;　　一年多来，超过100名网友给出了答案，美国人、印度人、挪威人以及海外华人……长期受到西方媒体轰炸的他们，却道出了风格各异的精彩见解，一个上海姑娘的短文配图更是获赞两万。&lt;/p&gt;&lt;p&gt;　　7月13日，微博网友@天涯尼丹小 发现了这些回答，他感叹这简直是在“用论文方式给题主洗脑”，读书人现在干嘛要造反？中国人为何要搞（西式）民主？中国政府真独裁？……“颜色革命威武，教育了全球读书人！”&lt;/p&gt;&lt;p&gt;　　下面，观察者网摘译了其中阅读量和点赞量最高的一批，以飨读者。&lt;/p&gt;&lt;p&gt;　　Mickey Lin：把美国强扭成单一国家，美国人也会拒绝吧？&lt;/p&gt;&lt;p&gt;　　曾在北京和台北学习，加州大学影视艺术学院&lt;/p&gt;&lt;p&gt;　　民主不过是政治体制中的一种，不一定是一个国家最好的政府组成形式。&lt;/p&gt;&lt;p&gt;　　许多民主国家的发展并不如中国好，比如印度。上世纪60年代到80年代，印度的GDP高于中国，但现在却落后于中国。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160717/1468749632483246578b5740b590c.png&quot; alt=&quot;&quot;/&gt;中印GDP增长对比&lt;/p&gt;&lt;p&gt;　　题主假设每个知识精英都渴望民主或者美式政府制度，但事实可能并非如此。&lt;/p&gt;&lt;p&gt;　　比如，联合国193个成员国中，165个是单一国家（观察者网注：unitary states），中央政府权力高于地方政府。但美国各州却是部分自治的。美国是否该变得向其他大多数国家一样呢？大多数美国人应该是拒绝的吧，因为这可能适合其他国家，但不适合美国。&lt;/p&gt;&lt;p&gt;　　民主很好，但也应该尊重其他人的不同爱好和选择。&lt;/p&gt;&lt;p&gt;　　（6月8日，610赞，31113阅读）&lt;/p&gt;&lt;p&gt;　　Akshay Lawange：言论自由能吃么？&lt;/p&gt;&lt;p&gt;　　坐标新德里，“政治学理论研究者”&lt;/p&gt;&lt;p&gt;　　如果说民主是一套软件，你为什么想把它满世界安装呢？&lt;/p&gt;&lt;p&gt;　　中国如今比民主国家还好，比如印度。&lt;/p&gt;&lt;p&gt;　　中国人发明了新的发展模式。统治阶级（观察者网注：political class）每天都要为生存而战。中国知道，经济一旦出事，执政党接着就得下岗。他们必须把经济搞好。”&lt;/p&gt;&lt;p&gt;　　就印度而言，我们不享有“实质民主”（substantial democracy），只是处于“程序民主”（procedural democracy）。当民众连识字、吃饱饭的权力都没有的时候，你还能想到什么公民权利？&lt;/p&gt;&lt;p&gt;　　对于乞丐来说，言论自由能吃么？&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('22', '&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160717/1468749103184176578b552f8e88a.png&quot; alt=&quot;1468749103184176578b552f8e88a.png&quot;/&gt;新华社北京7月16日电&amp;nbsp; 日本前首相鸠山由纪夫16日回答新华社记者提问时说，南海问题应该由当事方通过对话与合作解决，不应该从外部施加压力要求中国和菲律宾接受仲裁结果。&lt;/p&gt;&lt;p&gt;　　鸠山说：“南海问题应该由中国与菲律宾来解决，据说新上任的菲律宾总统也想开始与中国对话。我不希望看到，有外部压力利用这个事情一个劲地挑衅对方。”&lt;/p&gt;&lt;p&gt;　　当天，鸠山在北京举行的第五届世界和平论坛上发表了演讲。&lt;/p&gt;&lt;p&gt;　　在谈到菲律宾南海仲裁案临时仲裁庭本月12日公布的所谓最终裁决时，他指出，南海仲裁案无助于解决南海问题，南海问题应当通过协商特别是双边谈判来解决。&lt;/p&gt;&lt;p&gt;　　鸠山评论说，菲律宾单方面提起并强行推进仲裁的做法对解决南海问题没有任何益处，甚至会导致矛盾升级。“当事方应当坐到谈判桌前，在深入了解立场、找到共同点的基础上进行协商，这其中双边谈判无疑是重中之重。”&lt;/p&gt;&lt;p&gt;　　“领土纠纷应该在地区层面予以解决，通过构建合作框架，保证地区的安全与稳定，”他说。&lt;/p&gt;&lt;p&gt;　　鸠山2009年9月担任日本首相，次年6月辞去首相职务。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('23', '&lt;p&gt;[土军方：上百名叛乱分子被杀]BBC报道，土耳其军方代理参谋长表示，104名叛乱分子被杀。此前报道中提到的在政变中死亡的90人中，包括41名警察、47名平民和两名士兵。目前，军事政变造成的死亡人数已超过190人&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160717/1468749103352430578b552f8041d.png&quot; alt=&quot;1468749103352430578b552f8041d.png&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('24', '&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160717/1468749689124589578b577924502.png&quot; alt=&quot;&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;　　#环球快讯# [亚美尼亚首都警方大楼被占领 当局驳斥“政变”传闻]据外电报道，亚美尼亚安全部门官员7月17日说，首都埃里温一警察局遭一队与被拘禁反对派领导有关的武装部队袭击，并劫持了多名人 质。人质中包括警察局副局长。政府和武装部队的谈判正在进行，不过当局已驳斥了政变传闻。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('25', '&lt;p&gt;北京时间7月17日，今年NBA总决赛，勒布朗-詹姆斯带领骑士完成了历史性的逆转，并夺得总冠军。在不少人看来，今年31岁的詹姆斯有望夺得更多的总冠军，但是cheatsheet网站却列出了詹姆斯无法再夺冠的十点理由，前提是他一直留在骑士队。&lt;/p&gt;&lt;p&gt;　　10）东部正在变强&lt;/p&gt;&lt;p&gt;　　在过去长达十年的时间里，东部已经成为了詹姆斯的“私人后花园”。他已经赢得了3个NBA总冠军，而且连续6次参加总决赛。但是这种局面可能不会维持太久。&lt;br/&gt;今夏，凯尔特人签下了艾尔-霍福德，德怀特-霍华德加盟老鹰，尼克斯引进了罗斯和诺阿，公牛得到了韦德。虽然詹姆斯的骑士依然是东部老大，但是东部的其他球队看上去已经准备好挑战骑士的霸主的地位。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160717/1468750380830771578b5a2c7acbc.png&quot; alt=&quot;1468750380830771578b5a2c7acbc.png&quot;/&gt;&lt;/p&gt;&lt;p&gt;　　9）夺冠的代价非常昂贵&lt;/p&gt;&lt;p&gt;　　虽然NBA的工资帽涨到了9410万美元，而且可能还会上涨，但是詹姆斯会想尽一切办法让自己的经济利益得到最大化。他不会再接受降薪，即便这意味着腾出薪金空间签下另一个明星球员。现在，要想打造一支总冠军球队需要付出昂贵的代价，正如我们看到的骑士队。&lt;/p&gt;&lt;p&gt;　　8）詹姆斯的投篮在退步&lt;/p&gt;&lt;p&gt;　　詹姆斯的运动能力非常恐怖，再加上超高的篮球智商，使得他在场上难以阻挡。但是随着年龄的增长，突破对詹姆斯而言会变得越来越困难。考虑到他跳投的不稳定性，这可能会成为一个问题。&lt;/p&gt;&lt;p&gt;　　上赛季，詹姆斯的三分球命中率只有30.9%，而其他球队也敢于在比赛中放他在外面投篮。如果不能提升外线投篮，这将成为詹姆斯的一个挑战。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('26', '&lt;p&gt;新浪体育讯　　北京时间7月16日，据《波士顿先驱报》报道，最近，有关凯尔特人仍然希望补强并且可能通过交易得到球星的消息成为一大热门，而跟绿军联系紧密的其中一个巨星，就是快船核心布雷克-格里芬。但最新消息显示，凯尔特人方面对于格里芬并没有太大的兴趣，除了他的合同之外，还有另外一个因素。&lt;/p&gt;&lt;p&gt;　　根据此前的报道，凯尔特人曾经希望通过引入第三方来跟快船进行有关格里芬的交易，而这第三方很有可能会是国王队，他们最近在兜售鲁迪-盖伊。不过，根据先驱报得到的消息显示，凯尔特人目前对于格里芬有一些顾虑，让他们并不太想要得到这位球星了。&lt;/p&gt;&lt;p&gt;　　首先就是格里芬的合同，下赛季格里芬的薪水将会是2009万美元，而2017-18赛季的薪水将会是2132万美元，但他有着球员选项，很可能会选择在18年夏天跳出合同寻求薪水更高的新约。也就是说，如果交易来了格里芬，他是有可能在一个赛季之后就跳出合同走人的，这让凯尔特人就必须在考虑交易时非常慎重。&lt;/p&gt;&lt;p&gt;　　不过，除了合同外还有另一个因素让绿军对格里芬望而却步，那就是他腿部伤势的隐患。根据一位第三方球队的高管透露，格里芬的腿伤隐患让所有想要交易他的球队都非常慎重。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('27', '&lt;p&gt;新浪体育讯　　北京时间7月17日，迈阿密热火队总裁帕特-莱利今天召开了一场新闻发布会，并主要谈论了热火在今夏的运作。发布会上，莱利坦言德维恩-韦德离开热火让他“大感震惊”。&lt;/p&gt;&lt;p&gt;　　今年夏天，虽然热火队留住了白边，但是他们没有追到第一目标凯文-杜兰特，而且还流失了队魂韦德。&lt;/p&gt;&lt;p&gt;　　“我们经历了一个艰难的夏天，就是这样。”帕特-莱利告诉在场的记者。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160717/1468749103352430578b552f8041d.png&quot; alt=&quot;1468749103352430578b552f8041d.png&quot;/&gt;&lt;/p&gt;&lt;p&gt;　　“发生在德维恩身上的事情让我大感震惊。”&lt;/p&gt;&lt;p&gt;　　今夏自由球员市场上，韦德与热火的谈判再度陷入僵局，而且从头至尾，作为总裁的莱利一直没有出现在与韦德的谈判过程中。对此，莱利在今天的发布会上感到非常后悔。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('29', '&lt;p&gt;新浪体育讯　　北京时间7月17日，中超联赛烽火继续，中超第17轮最焦点的赛事无疑是上海申花坐镇主场虹口足球场对阵上海上港的德比大战。今天申花方面放弃了赛前前往虹口足球场适应场地的训练，而是全队在康桥基地完成了德比大战之前的最后一练，今晚7点30分，主帅曼萨诺携阵中大将柏佳骏出席了赛前发布会。&lt;/p&gt;&lt;p&gt;　　针对德比大战的备战情况，申花主帅曼萨诺表示：“周三刚打好足协杯，准备时间不长，但是大家都做好了充分准备对这场比赛。对手方面我们很了解，对手是强队，也有实力，今年投入很大，中期刚换了一个很有能力球员。不过明天是我们的主场，有球迷助威，希望拿下对手，给球迷带来胜利。”&lt;/p&gt;&lt;p&gt;　　针对目前申花阵中伤病方面是否只有李运秋一个伤员这个问题，曼萨诺透露：“确实是的，当然他在恢复的最后一个阶段了。”&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160717/1468750223257416578b598fc590b.png&quot; alt=&quot;1468750223257416578b598fc590b.png&quot;/&gt;&lt;/p&gt;&lt;p&gt;　　本赛季首回合德比大战中，申花在客场战平了上港，这场是否渴望战胜对手？是否会针对胡尔克有所准备？面对这一系列外界关注的话题，曼萨诺表示：“你的这个问题提醒我想起来，德比比赛第一场时，我们是在1比0领先时，登巴巴点球没进，留下遗憾，希望明天能多点运气，跟这样强队交手，运气很重要。我也知道，刚才胡尔克他们都跟队训练了，上港的实力更强大，最重要是做好我们自己！”&lt;/p&gt;&lt;p&gt;　　之前三场没踩场结果零封对手并且都赢球了，是不是因为这个原因，今天没有来虹口足球场适应场地？曼萨诺笑言：“你说的这个数据我还没考虑过，今天没有踩场主要是因为考虑到球场之前演唱会办完草皮不是很好，想保护一下草皮，不过，如果明天赢了，我下场还不来踩场，那么你就说对了！”随后曼帅也不忘提醒在场媒体朋友们：“你们都问下柏佳骏吧，他现在是申花队员，不是对手阵中的队员了。”&lt;/p&gt;&lt;p&gt;　　假如明天胡尔克出场，那么柏佳骏防守胡尔克有没有问题？对此，柏佳骏淡然表示：“以前也在比赛中碰到过身体强的，还有就是比赛不是我一个人在踢，我相信我的队友也会过来帮忙，一起防守胡尔克的。”（曲小尤）&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('30', '&lt;p&gt;新浪体育讯　　北京时间7月16日晚19：35，2016年中超联赛第17轮，河北华夏幸福主场迎战北京国安，上半场比赛伤停补时阶段，国安门将杨智带着腰伤扑出了姜宁近在咫尺的头球攻门，再次展现了圣杨智的威风，完成这次扑救后，杨智中场休息时只能在队友的搀扶才能离场，下半场比赛也被侯森换下，希望他的伤势没有大碍。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://n.sinaimg.cn/sports/transform/20160716/519s-fxuapvw2139898.gif&quot; alt=&quot;杨智受伤瞬间&quot;/&gt;&lt;/p&gt;&lt;p&gt;杨智受伤瞬间&lt;/p&gt;&lt;p&gt;　　比赛第31分钟，华夏幸福中路过顶长传，老将杜威前插抢点时与杨智撞在一起，杜威的大腿顶在了杨智的腰部，队医进场给杨智进行了短暂治疗后，杨智选择继续坚持比赛。但上半场行将结束时，杨智主动将皮球抛出界，示意无法坚持比赛，国安计划让杨智踢完上半场到中场休息再做调整，但没想到伤停补时阶段，球队门前再度出现险情，杨智带着腰伤扑出必进球。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('31', '&lt;p&gt;北京时间7月15日，中国足协官网公布处罚决定，上海申花俱乐部官员庞斯因在7月9日与延边富德的比赛中指责裁判员造成不良影响，被禁止进入替补席3场并罚款15000元。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160717/1468750425137305578b5a599e3dc.png&quot; alt=&quot;1468750425137305578b5a599e3dc.png&quot;/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('32', '&lt;p&gt;北京时间7月17日消息，在2016年世界女排大奖赛结束后，国际排联公布了最新一期的世界排名。上期位居次席的中国女排因今年大奖赛仅获第5、被最终夺魁的巴西以2分的微弱优势反超，积278分退至第3。大奖赛卫冕受挫屈居亚军的美国仍以315分高居榜首，280分的巴西升至第2。&lt;/p&gt;&lt;p&gt;　　本期世界排名所统计的比赛包括2016年世界女排大奖赛、2015年世界杯、2014年世界锦标赛和2012年伦敦奥运会，2015年洲际锦标赛的积分被剔除。&lt;/p&gt;&lt;p&gt;　　上期排名第2的中国队在今年大奖赛仅列第5进账38分，加上2015年世界杯夺魁计入100分、2014年世锦赛亚军赢得90分和2012年伦敦奥运会并列第5收获50分，总分达到278分。此前排名第3的巴西在今年大奖赛名次比去年提升2位、中国下降1位，此消彼长，中国女排在世界排名累计分上被对手超越落至第3。&lt;/p&gt;&lt;p&gt;　　本期世界排名三甲球队的归属与上期一致，只是排名第2、第3的中巴两强位置对调。美国女排虽在大奖赛卫冕受挫亚军收官，但作为唯一一支在统计积分的大赛中均跻身三甲的球队，仍以总成绩315分领跑诸强。斩获大奖赛第11冠的巴西以2分优势力压中国升至次席，其总分为280分。&lt;/p&gt;&lt;p&gt;　　排名第4至第10位的球队与上期完全一致。俄罗斯218分居第4，日本208分排第5，塞尔维亚192分列第6，多米尼加、意大利、韩国和土耳其分居第7至第10位。&lt;/p&gt;&lt;p&gt;　　本期世界排名的变动主要受大奖赛成绩的影响。荷兰在一档总决赛力夺季军进账42分，总分达78分、排名飙升4位来到第11，成为本期名次提升幅度最大的球队。欧洲两强德国和比利时因大奖赛成绩欠佳，排名均下降2位。一档垫底的德国积69分退至第13，比排在第14的泰国仅多1分；获得一档第11名的比利时以64分落至第15。再度无缘三档总决赛的昔日豪门古巴队降至第22位。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('33', '&lt;p&gt;新浪体育讯　　随着美国奥运选拔赛告一段落，美国奥运游泳团队也已经集结完毕，正在美国本土进行最后的紧张训练中。美国当地时间昨天，NBA圣安东尼奥马刺队的主教练波波维奇和曾经获得总决赛MVP的法国球星帕克造访美国奥运泳团，给美国泳军打气助威。&lt;/p&gt;&lt;p&gt;　　在里约奥运会前，美国泳军获得奥运资格的选手都将来到奥运备战训练营进行最后的备战。包括菲尔普斯、罗切特、莱德基、富兰克林等诸多名将都在阵中。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('34', '&lt;p&gt;新浪体育讯　　北京时间7月15日消息，里约热内卢红灯区的妓女们正在为&lt;a href=&quot;http://2016.sina.com.cn/&quot; target=&quot;_blank&quot;&gt;里约奥运会&lt;/a&gt;提供“性服务销售”，原本希望在巴西举办世界杯之后迎来井喷的市场，却在两年后意外遇冷。身处臭名昭著的比拉-米莫萨区的性工作者们表示，原本期待在巴西世界杯后延续热潮的市场却出现了大幅下滑。&lt;/p&gt;&lt;p&gt;　　目前距离奥运会开幕还有不到一个月的时间， 性工作者表示她们已经准备好了英文传单邀请运动员光顾里约城旁边的这个红灯区，提供十分便宜的性交易。破旧的传单上写着30分钟的性交易是40雷亚尔（约合9英镑），比原来的75雷亚尔（约合17英镑）下降了48%。&lt;/p&gt;&lt;p&gt;　　比拉-米莫萨是里约最老和最大的嫖娼区，超过3000名女性在这片繁华市井的70多个酒吧和夜总会提供服务。但是这些女性的收入最近由于巴西严峻的经济形势而大幅缩水，巴西正在经历着经济衰退最为严重的时期。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160717/fc8089f45dee67f9454cbd0d053b85fb.gif&quot; alt=&quot;fc8089f45dee67f9454cbd0d053b85fb.gif&quot;/&gt;&lt;/p&gt;&lt;p&gt;　　在奥运会开幕前四周的时候，一些米莫萨的性工作者已经开出了白菜价来吸引外国游客。里约城内正在分发一份英文传单，但它显然不为很多人所知。上面说一小时的性服务收费从原来的90雷亚尔（约合20英镑）降至60雷亚尔（约合13英镑），半小时的三人性服务标价是每个女孩40雷亚尔（约合9英镑）。&lt;/p&gt;&lt;p&gt;　　39岁的长期性工作者艾琳-多辛尼娅透露给每日邮报记者称，她们不想看到世界杯重演，业务确实下降的很严重。她表示：“我们对于世界杯期望太高，因为每个人都告诉我们需求是巨大的，我们都以为自己要发财了。我们在路上放置大电视屏给男人们去看足球，我们还提供烧烤和音乐派对。但是几乎没有人来，世界杯时路上几乎是空的。我觉得外国人可能比较担心来到这样的地方，因为它既不靠近海滩也不靠近酒店。而且他们可能也害怕染上什么病。”&lt;/p&gt;&lt;p&gt;　　“只有一些阿根廷人和乌拉圭人，但是他们并不是很有钱，甚至还讨价还价。甚至连我们的巴西常客都不来了，他们都忙着去看足球了。但是这一次，我们不抱任何幻想。我们知道我们会在奥运会期间被遗忘，就像我们在世界杯期间一样。这就是为什么我们要更加的积极主动，我们只想挣些钱来谋生。”&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('35', '&lt;p&gt;A股在投资者的万众瞩目下站稳3000点，且一路震荡走高，板块轮动明显，两融余额逐渐上升，不过沪指面对3100点关口还是心有余而力不足。&lt;/p&gt;&lt;p&gt;　　在市场人士看来，英国脱欧落地后，市场一路震荡上行，在一举回补此前留下的跳空缺口3066点后。短期看，多方一个目标已经实现，在向下一个目标发起进攻前可能需要休整。&lt;/p&gt;&lt;p&gt;　　3150点至3200点之间将是下一个重要目标，市场短期仍是存量资金在不同的板块间腾挪，逐渐抬高市场底部。但是向上的空间有限，且上方的套牢盘不可小视，市场短期将呈震荡走势。&lt;/p&gt;&lt;p&gt;　　底部逐渐抬高&lt;/p&gt;&lt;p&gt;　　7月11日，A股继续开盘震荡走高，3000点多空争夺激烈，午后大盘出现跳水。在宝钢、武钢启动重组后，央企的重组大戏被市场看好，黄金和煤炭板块表现抢眼。&lt;/p&gt;&lt;p&gt;　　12日，市场先抑后扬，在早盘急速下跌后，中字头股票齐发力，出现了大幅反弹，上证指数收复3000点失地，收盘上涨1.82%。&lt;/p&gt;&lt;p&gt;　　13日，隔夜欧美市场普遍上扬，其中道琼斯指数再创历史新高，刺激亚太市场周三全线上扬，A股市场早盘在银行、券商等权重股整体上扬的带动下一度快速冲高至3069点，随后逐级震荡回落，午后随着中小创类公司的逐步走强，两市股指重拾升势，上证综指收于3060.59点，涨0.37%；深证成指收市报10853.56点，涨0.89%。&lt;a href=&quot;http://finance.sina.com.cn/realstock/company/sz399101/nc.shtml&quot; target=&quot;_blank&quot;&gt;中小板指&lt;/a&gt;(11948.907,&amp;nbsp;-33.87,-0.28%)上涨0.78%，创业板指上涨1.69%。深沪两市全日共成交7291亿元，成交量有所萎缩。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('36', '&lt;p&gt;　7月15日，据证监会新闻发言人邓舸通报，证监会公布了2016年证券公司分类评价结果，经综合评价，2016年95家证券公司分类评价结果为：A类公司36家，占比38%，B类公司51家，占比54%，C类公司8家，占比8%，无D、E类公司。此次评价期间为2015年5月份至2016年4月份。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160717/1468749103749957578b552f5e073.png&quot; alt=&quot;1468749103749957578b552f5e073.png&quot;/&gt;&lt;/p&gt;&lt;p&gt;　　据邓舸表示，证券公司分类结果不是对证券公司资信状况及等级的评价，而是证券监管部门根据审慎监管的需要，以证券公司风险管理能力为基础，结合公司市场竞争力和合规管理水平，对证券公司进行的综合性评价，主要体现的是证券公司合规管理和风险控制的整体状况。分类结果主要供证券监管部门使用，证券公司不得将分类结果用于广告、宣传、营销等商业目的。&lt;/p&gt;&lt;p&gt;　　根据评价结果，中信证券(16.820,&amp;nbsp;-0.14,&amp;nbsp;-0.83%)、海通证券(15.&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('37', '&lt;p&gt;7月15日，证监会新闻发言人邓舸表示，证监会于7月13日正式发布《上市公司股权激励管理办法》（以下简称《办法》），股权激励方式仍是限制性股票和股票期权。《办法》明确了激励对象的范围，如明确独董、监事不得成为激励对象，单独或合计持有上市公司5%以上股份的股东或实际控制人及其配偶、父母、子女，不得成为激励对象；明确境内工作的外籍员工可成为激励对象。另外，还完善了上市公司内部问责与不当利益回吐机制。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160717/1468749632483246578b5740b590c.png&quot; alt=&quot;1468749632483246578b5740b590c.png&quot;/&gt;&lt;/p&gt;&lt;p&gt;　　根据《办法》，“限制性股票”对采取限制性股票实行股权激励进行了细化规定，包括限制性股票的定义与权利限制、授予价格的定价要求、分期解除限售以及回购安排等；“股票期权”对采取股票期权形式实行股权激励提出了要求，包括股票期权的定义与权利限制、行权价格的定价要求、分期行权与终止行权等。&lt;/p&gt;&lt;p&gt;　　近年来，上市公司实施股权激励的积极性不断提高，但在实践中，暴露出现行股权激励制度的不足，例如事前备案影响激励效率，不符合简政放权的要求；股权激励条件过于刚性，上市公司自主灵活性不强；市场剧烈变化时，行权价格倒挂致使激励对象无法行权等情况。&lt;/p&gt;&lt;p&gt;　　现行《上市公司股权激励管理办法（试行）》自2005年发布以来，实行股权激励的上市公司数量逐年持续增长，截至2015年年底，推出股权激励计划的上市公司总共有808家，涉及股权激励计划达1110个，其中有229家公司推出两个或两个以上的股权激励计划，对科技型、创新型公司的推动比较明显。上市公司实行股权激励对调动员工积极性、提升公司业绩发挥作用显著。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('38', '&lt;p&gt;王海雄，前华夏基金首席投资官，去年年初辞职，当年6月自创百毅资本，前后发行私募产品7只，现6只已清盘；&lt;/p&gt;&lt;p&gt;　　陈扬帆，被媒体誉为基金男神，去年年初离职，随即创立猛犸资产，当年3月开始，前后发行私募产品31只，现7只已清盘；&lt;/p&gt;&lt;p&gt;　　曹剑飞，前中欧基金投资总监，今年4月离职奔私。业内介绍，因其公司源实资产挖走东家大量客户，引发与董事长窦玉明的龃龉。&lt;/p&gt;&lt;p&gt;　　．．．．．．&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160717/1468749632123505578b5740aee7a.png&quot; alt=&quot;1468749632123505578b5740aee7a.png&quot;/&gt;&lt;/p&gt;&lt;p&gt;　　他们都可谓明星基金经理。&lt;/p&gt;&lt;p&gt;　　失落背后的细节&lt;/p&gt;&lt;p&gt;　　王海雄，4年多时间，从管理一只基金到同时管理四只基金，从20亿管理规模到280亿管理规模（对比：泽熙资产约300亿），从一名基金经理到华夏基金投资决策委员会委员、投资副总监、公司首席投资官，期间又荣获明星基金经理奖、金牛基金经理奖。&lt;/p&gt;&lt;p&gt;　　现在，却演绎了公奔私后水土不服的经典案例。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('39', '&lt;p&gt;证券期货经营机构私募资产管理业务运作管理暂行规定全文：　　&lt;/p&gt;&lt;p&gt;　　第一条 为了进一步加强对证券期货经营机构私募资产管理业务的监管，规范市场行为，强化风险管控，根据《证券法》《证券投资基金法》《证券公司监督管理条例》《期货交易管理条例》《私募投资基金监督管理暂行办法》《证券公司客户资产管理业务管理办法》《基金管理公司特定客户资产管理业务试点办法》《期货公司监督管理办法》和《期货公司资产管理业务试点办法》等法律法规，制定本规定。&lt;/p&gt;&lt;p&gt;　　第二条 本规定所称证券期货经营机构，是指证券公司、基金管理公司、期货公司及其依法设立的从事私募资产管理业务的子公司。&lt;/p&gt;&lt;p&gt;　　第三条 证券期货经营机构及相关销售机构不得违规销售资产管理计划，不得存在不适当宣传、误导欺诈投资者以及以任何方式向投资者承诺本金不受损失或者承诺最低收益等行为，包括但不限于以下情形：&lt;/p&gt;&lt;p&gt;　　（一）资产管理合同及销售材料中存在包含保本保收益内涵的表述，如零风险、收益有保障、本金无忧等；&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('40', '&lt;p&gt;　在3000点上方市场做多氛围比较活跃，成长股、价值股热点轮动较快。私募人士认为，结构性吃饭行情已经显现，三季度大概率是窄幅震荡格局，或出现前低后高走势。短期谨防博弈风险，中长期应关注风险收益比较高的公司，例如消费类价值股的成长性机会。总体上看，下半年是介入权益类资产的较好时点。&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('41', '&lt;p&gt;英国脱欧风暴阴霾未散，另一片乌云便忙不迭地滚滚袭来——北京时间7月16日约凌晨4时（土耳其当地时间15日晚），土耳其突然传出消息——军方人员发动政变，截至北京时间16日上午8时，土耳其政府称，局势已经得到控制。这场不到6个小时的“政变惊魂”，或在下周一再度使得刚刚平静的全球金融市场动荡不安。&lt;/p&gt;&lt;p&gt;　　据第一财经记者整理，事发后，尽管部分市场已经收市，但部分全球金融市场仍颇为躁动——土耳其里拉对美元暴跌4.73%；美股终结了一周狂欢，小幅收跌；具有避险功能的美国10年期国债收益率瞬间跳水，金价瞬间从1326美元/盎司暴涨至1337美元/盎司。&lt;/p&gt;&lt;p&gt;　　土耳其总统埃尔多安（Erdogan）今晨已安全降落在伊斯坦布尔机场，出现在人群并发表讲话称，“土耳其的政变由Gulen运动领导，武装叛变的人将会付出巨大代价。”据悉，Gulen 运动是一个跨国性宗教社会运动组织，由土耳其伊斯兰阿訇兼鼓吹者Fethullah Fulen领导，此人现在居住在美国境内。该组织并没有正式的称谓，但往往被其土耳其境内追随者称为“Hizmet”（意指服务）和“Cemaat”（社区或集会）。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('42', '&lt;p&gt;　汇通网7月15日讯——周五(7月15日)国内期市工业品普遍走高，有色金属、黑色系商品一片红，橡胶涨幅逾2%，因早间统计局公布中国包括二季度GDP在内多项宏观数据均好于预期，市场情绪改善。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160717/1468750141412674578b593d80b86.png&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('43', '&lt;p&gt;新华社北京7月16日专电 题：大宗商品周评：终结连续数周上涨 黑色金属小幅回调&lt;/p&gt;&lt;p&gt;　　新华社记者刘开雄、赵晓辉&lt;/p&gt;&lt;p&gt;　　尽管本周一度出现涨停的局面，但黑色系金属在经历了数周连涨之后，在本周出现了小幅回调的局面。&lt;/p&gt;&lt;p&gt;　　在过去的四周里，螺纹钢、热卷、焦煤、焦炭(1007,&amp;nbsp;-9.00,&amp;nbsp;-0.89%)等黑色系产品价格快速上涨，走出了5月暴跌之后的一轮价格修复行情，平均涨幅在25％左右。但在本周，这些品种出现了小幅下跌，螺纹钢单周跌幅1．87％，铁矿石当周跌幅1．2％，热卷跌幅2．37％，两焦产品平均跌幅在1．2％左右。&lt;/p&gt;&lt;p&gt;　　有分析师认为，黑色系金属价格自5月份受到钢厂复产压制大幅下跌之后，在6月份初期处于震荡态势，但随着唐山限产停产消息的不断传出，导致价格出现一轮快速上涨。&lt;/p&gt;&lt;p&gt;　　从实际情况上看，目前社会库存正处在低位，由于6月份是由旺季转淡季的过渡期，钢铁需求回落的阶段，但今年走势比较反常，3月至6月的出货高点是3月和6月，呈现出“淡季不淡”的局面，而4月、5月的传统旺季却因为钢价突飞猛进的上涨和水银泻地般的下跌而让企业不敢进货。“重要的是价格稳定，今年4月、5月份的价格波动剧烈，无论涨跌都是一天一个价格，这让现货企业很难做出采购决策。”华北一现货贸易商表示。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('44', '&lt;p&gt;　新浪娱乐讯 不知不觉，又到星期五了，号称周五播报员的鹿晗[微博]貌似又有大动作？是的，#鹿晗运动季#在今天正式开启啦！7月11日，新浪娱乐就发微博预告，鹿晗小镇再次开启，神秘大礼盒就是#鹿晗运动季#！别再“北京瘫”、“横店瘫”、“葛优瘫”等各种瘫了，快跟着鹿晗一块儿来运动吧~！&lt;/p&gt;&lt;p&gt;　　一言不合就运动？ 鹿晗早就预告过啦！&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('45', '&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160717/1468750223257416578b598fc590b.png&quot; alt=&quot;喜上加喜！林心如陈妍希领衔鈥湸蜮澇黾薜10大女星&quot; title=&quot;喜上加喜！林心如陈妍希领衔鈥湸蜮澇黾薜10大女星&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;据台湾媒体报道，霍建华与林心如14日凌晨相约KTV欢唱，出门时林心如却媒体被拍到“大肚照”，疑似坐实怀孕传闻。两性观念开放的年代，娱乐圈中有很多女星曾“带球”出嫁，下面一床情书便来扒扒奉子成婚喜上加喜的10大女星。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('46', '&lt;p&gt;　本文来自“玩儿电影”公众号（id：wan2movie）　　&lt;/p&gt;&lt;p&gt;　　进入暑期以后，每周都有不止一部吸引眼球的新片上线抢市场。观众看得热闹，但为了跟上点评/吐槽的节奏，本玩可能会在这个夏天里，在厕所哭晕N次……&lt;/p&gt;&lt;p&gt;　　但，也是没有办法的事，这就是暑期档嘛。&lt;/p&gt;&lt;p&gt;　　《寒战2》《大鱼海棠》等片的热度还没完全过去，本周的新片已经气势汹汹地杀来——文艺佳作、爱情喜剧、动作喜剧、犯罪悬疑、惊悚、动画……乍看之下眼花缭乱，但其实选择起来依然没啥难度，听我道来。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('47', '&lt;p&gt;据澎湃新闻7月14日报道 7月13日，《华尔街日报》援引知情人士称，万达集团正与维亚康姆（Viacom）进行磋商，欲收购对方旗下公司派拉蒙影业（Paramount Pictures）49%的股份。但该消息还未得到万达方面的官方确认。&lt;/p&gt;&lt;p&gt;　　但现在，维亚康姆内部分成了两派：目前维亚康姆最大股东、现年92岁的亿万富翁萨默•雷石东（Sumner Redstone）竭力反对该交易的进行；而另一边，包括董事长和首席执行长Philippe Dauman在内的维亚康姆高管主张出售派拉蒙影片部分股权，来获得急需的现金。同时，维亚康姆正在为派拉蒙影业寻求80亿-100亿美元的估值。&lt;/p&gt;&lt;p&gt;　　报道称，还有一位投资者也在寻求洽购派拉蒙影业的股份。维亚康姆第二大股东Mario Gabelli曾在2015年12月表示，维亚康姆应当联络阿里巴巴，以围绕派拉蒙股权出售事宜展开商谈。&lt;/p&gt;&lt;p&gt;　　在今年2月份的时候，维亚康姆的CEO菲利普•道曼就曾宣布，正在寻找战略投资人，将出售派拉蒙的少数股权。派拉蒙影业2015年的财报数据显示，公司营收10.25&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('48', '&lt;p&gt;新浪娱乐讯 第18届台北电影奖16日晚间在台北举行，许玮甯以《红衣小女孩》、《失控谎言》、短片《世纪末的华丽》夺下影后宝座，也是台北电影奖史上首度以三部作品同时得奖，许玮甯硬咽感谢工作人员与家人，不免被问到是否与旧爱阮经天复合？她表示：“先不回应了，把焦点放在电影上吧。”合作鬼片《红衣小女孩》的黄河也擒下影帝，备受瞩目的任达华、王大陆、宋芸桦等人则与奖项失之交臂。以原住民为主角的《只要我长大》获得百万首奖、最佳剧情长片、最佳导演奖、最佳新演员奖与最佳剪辑奖，让导演陈洁瑶直呼像作梦。&lt;/p&gt;&lt;p&gt;　　许玮甯三作品夺影后瞄准金马 黄河《红衣小女孩》称帝&lt;/p&gt;&lt;p&gt;　　许玮甯夺得最佳女主角奖，这是她第一个电影奖项。评审认为，她在参赛片中曝光率高，但每次都给予不同的深刻印象，人物的阴暗、罪咎、自我毁灭都活灵活现，展现出她多样化的表演能力，潜力深不可测，评审也一致通过她以三部片同时得奖，显现她演戏的范围广。&lt;/p&gt;&lt;p&gt;　　许玮甯接连获得金钟奖最佳女配角、台北电影奖影后的肯定，她表示：“对我来说很具意义，会觉得自己是在往对的方向走。”也希望把年底的金马奖当目标。许玮甯上台时，一直告诉自己不要哭，就怕像去年领金钟奖时讲话一直发抖，这次比较冷静。&lt;/p&gt;&lt;p&gt;　　合作《红衣小女孩》的黄河夺得最佳男主角奖，他18岁就夺得金钟视帝，这是他首座电影影帝奖项，评审认为，虽然电影剧情不在他、戏份也不多，但他从气质到小动作，都细致具现了一个被现实压迫的年轻人，并让观众记住该角色，评审团主席舒琪说：“越平凡的角色越难演。”&lt;/p&gt;&lt;p&gt;　　黄河完全没有预想到自己得奖，当颁奖人念到他名字时眼睛瞪的超大，他感谢恩师易智言导演，表示：“他对我影响很大，没有他就没有我。”他17岁就就出道，26岁的他经历演艺生涯起伏，曾长达一年多没拍戏，妈妈问他：“怎么每天都待在家。”黄河只能不停充实自己、把握每个机会。&lt;/p&gt;&lt;p&gt;　　庄凯勋、简嫚书以《菜鸟》囊括男女配角 两人获得首座电影奖&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('49', '&lt;p&gt;朋友圈已经随着网络的普及成为了许多人日常生活中的一个组成部分，产生了任何想法、发生了某件事情第一时间并不是和身边人分享，而是组织一下语言发朋友圈。科技紫微星座网今天就要为大家揭秘，在12星座好友的可见范围内，千万别发这些内容，否则你就等着被屏蔽吧&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('50', '&lt;p&gt;2017年将是苹果iPhone诞生的第十个年头，在这样一个特殊的日子，全新的iPhone8或7s也将以崭新的面貌展现在用户面前，根据内部人士的爆料和分析师的预测，下一代iPhone8无论在材质还是功能上都将有飞跃，其中可以确定的是明年的iPhone将使用OLED屏幕。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160717/1468750358617419578b5a167f4ee.png&quot; alt=&quot;iPhone8采用OLED屏幕，夏普或借苹果打翻身仗&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;　　全球OLED供应商包括LG Display、三星、JDI和夏普，无论是谁都想抢得苹果这个超级金主，三星目前垄断全球90% OLED屏幕出货量，是其中最可能成为苹果供应商的厂家，LG Display此前就曾表示会为了争取订单而增大对OLED屏幕的研发投入。对于夏普而言，刚刚被鸿海收购的它们亟需一个好的机会打翻身仗，所以争取苹果 明年的订单将非常迫切。&lt;/p&gt;&lt;p&gt;　　按照原来的计划，鸿海预计会在今年6月份结束之前完成对夏普的收购，只不过由于中国大陆的反垄断审查耗时较长，收购进度并没有像鸿海所想象的那样快。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('51', '&lt;p&gt;5月底我们曾经报道了三星A9 Pro在海外开售的消息，不过根据最新消息，三星A9 Pro的销售范围将仅限亚洲市场。也就是说三星A9 Pro将成为一款名副其实的亚洲特供机。&lt;/p&gt;&lt;p&gt;&lt;img id=&quot;content-first-img&quot; class=&quot;nomotu&quot; src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160717/1468750380830771578b5a2c7acbc.png&quot; alt=&quot;大屏更适合亚洲 三星A9 Pro销售区域确定 &quot; height=&quot;475&quot; width=&quot;640&quot;/&gt;&lt;/p&gt;&lt;p&gt;&amp;nbsp;&amp;nbsp; 三星A9 Pro拥有一块6英寸的大屏幕，或许是考虑到如此大的机身尺寸在某些国家和地区可能不受欢迎，三星A9&amp;nbsp;Pro才选择只限定在亚洲范围开卖。&lt;/p&gt;&lt;p&gt;&amp;nbsp;&amp;nbsp; 除了6英寸屏幕，三星A9 Pro的主要卖点还包括骁龙652处理器、4GB RAM+32GB ROM、800万像素+1600万像素的摄像头组合、5000毫安时电池和Android 6.0.1系统。在中国市场其早在数月前就已经开卖了，售价2999元人民币。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('52', '&lt;p&gt;魅族已经宣布将在7月19日正式发布新旗舰MX6。此前，魅族联合创始人、总裁白永祥表示，魅族把PRO 6的很多工艺带给了MX6，供应链部门也正在努力让MX6成为备货最好的梦想机。&lt;/p&gt;&lt;p&gt;　　此外，白永祥强调，MX6的成本提高了，售价也会提升，但他相信MX6会是两千元价位上设计和工艺最好的产品。&lt;/p&gt;&lt;p&gt;　　如此来说，MX6的售价就不是原来的1799元起了，会是多少呢？&lt;/p&gt;&lt;p&gt;　　今日，有网友曝光了一张魅族内部文件，文件显示，即将发布的MX6、智能保护套搭售价格为2299元，看来是要一起亮相了。&lt;/p&gt;&lt;p&gt;　　据此前曝光的高清谍照来看，这款保护套应该是皮革材质，外观简洁大方，目前已知支持开盖唤醒、合上休眠，是否还有更多功能暂时不详。保护套边缘配备了LED呼吸灯，还有不同颜色变化。预计，LED灯将用来提示手机来电、短信等通知。&lt;/p&gt;&lt;p&gt;　　据悉，魅族MX6将采用1080p屏幕（预计是5.5英寸），搭载联发科Helio X20（MT6797）处理器，4GB内存+32GB机身存储，摄像头组合为前置500万像素+1200万像素，运行系统为Flyme 5.2.2（Android 6.0）。据悉，电池容量预计在3000mAh以上。&lt;/p&gt;&lt;p&gt;　　这价格大家觉得贵吗？&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160717/1468750404803833578b5a441cb15.png&quot; alt=&quot;果然涨价了！魅族MX6售价曝光：这价格贵吗？&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('53', '&lt;p&gt;巴西里约奥运会开幕在即，作为奥运会的主赞助商之一，三星也顺势推出了一款里约奥运限量版的Galaxy S7 Edge。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160717/1468750425575162578b5a5991dc0.png&quot; alt=&quot;五环五色：三星S7 Edge巴西里约奥运会限量版上手图集&quot;/&gt;&lt;/p&gt;&lt;p&gt;　　在造型上，这款奥运限量版的S7 Edge与普通版基本相同，不过它在设计中大量运用奥运五环的颜色对机身进行点缀。其中，机身左侧的音量键就用上了奥运五环中的绿色。&lt;/p&gt;&lt;p&gt;&lt;img class=&quot;lazy&quot; src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160717/1468750425137305578b5a599e3dc.png&quot; alt=&quot;五环五色：三星S7 Edge巴西里约奥运会限量版上手图集&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('54', '&lt;p&gt;　经过多轮爆料和三星官方的预热，我们对三星Note 7的外观、配置和发布日期已经有了基本的了解，变数不会太大。接下来，我们所关心的就是其究竟什么时候开卖了，毕竟咱们买得到才是王道。关于这一点，韩国媒体最新消息称，三星Note 7有望在发布当日就开卖，也就是8月2日。&lt;/p&gt;&lt;p&gt;&lt;img id=&quot;img_first&quot; title=&quot;要赶奥运热 三星Note 7或发布日就开卖第1张图&quot; src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160717/1468750442642464578b5a6a81663.png&quot; alt=&quot;要赶奥运热 三星Note 7或发布日就开卖第1张图&quot;/&gt;&lt;/p&gt;&lt;p&gt;　　回顾上代Note旗舰，三星Note 5是在发布后大约一周才实现首发的，Note 7今年这上市速度有点惊人了。据了解，2016年里约奥运会将在8月5日开幕，三星此举正是为了最大化地利用奥运热，并且已经为8月2日首发供货做好了准备。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('55', '&lt;p&gt;编者按：太阳黑子是太阳活动水平的标识，但是在2016年6月底，太阳上连续十几天没有黑子，难道很快要进入太阳活动低年？太阳马上要进入休眠状态了？地球要进入新一轮“冰河期”了？&lt;/p&gt;&lt;p&gt;　　“冰河期”真的要来了吗？&lt;/p&gt;&lt;p&gt;　　最近，随着第24活动周太阳活动水平的不断下降，太阳上的黑子真是越来越少 了，以前还可以掰着指头数，现在恐怕只能握着拳头数了。甚至在6月下旬开始的十几天里，太阳上便没有了黑子，明亮的太阳上干干净净的。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160717/1468750467317875578b5a83981b9.png&quot; alt=&quot;7月5日没有黑子的太阳(SDO卫星观测)&quot;/&gt;7月5日没有黑子的太阳(SDO卫星观测)　&lt;/p&gt;&lt;p&gt;　　眼瞅着这么冷冷清清的太阳，仿佛要进入休眠状态了。这不禁让我们想起了去年流传甚广的一篇报道——《太阳2030年将休眠 地球即将步入冰河时期》。文章回忆起&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('56', '&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160717/1468750485466163578b5a95e6159.png&quot; alt=&quot;资料图：亚马逊雨林被开垦用来种大豆。&quot;/&gt;资料图：亚马逊雨林被开垦用来种大豆。&lt;/p&gt;&lt;p&gt;　　中新网7月16日电 据外媒报道，最新《科学》期刊上的一份研究报告称，地球陆地上58%地区的物种多样性完整指数已低于安全值。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;　　该份报告指出，受此冲击最大的是美国、阿根廷、南非与中亚的草原地区，这些地区的动物与植物数量皆因人类活动而减少。&lt;/p&gt;&lt;p&gt;　　报告指出，陆地表面约58%地区的物种“完整性”已经降至安全界限以下；这主要是农业用地、道路与城市发展持续扩充所致。全球大约71%的人口居住在这些陆地上。&lt;/p&gt;&lt;p&gt;　　研究人员在18659个地点进行了238万次记录，共录得39123个生物物种。他们以此数据界定，相较于没有人类活动的地方，所谓“安全”地方的在地物种数量必须至少达到90%水平。&lt;/p&gt;&lt;p&gt;　　报告主要作者为伦敦大学学院学者纽博尔德，他说：“如果我们任由生物多样性受破坏，到头来农业发展将难以支撑下去。”&lt;/p&gt;&lt;p&gt;　　物种多样性水平降低后，依靠蜜蜂等昆虫授粉传播的农作物、为粮食作物生产养分与水分等的健康土壤，以及吸收大气中二氧化碳以应对气候暖化的树林等自然生态服务系统将面对更大风险。&lt;/p&gt;&lt;p&gt;　　该报告的另一作者珀维斯表示，“许多决策者最担心的是经济衰退，殊不知生态&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('57', '&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160717/1468750519481568578b5ab75d880.png&quot; alt=&quot;&quot;/&gt;&lt;/p&gt;&lt;p&gt;　　文章来源：蝌蚪五线谱&lt;/p&gt;&lt;p&gt;　　科学家已经发现军舰鸟能长时间的飞行，但是近期的一项研究结果令人有点震惊，研究人员发现军舰鸟的飞行时间可以长达两个月！&lt;/p&gt;&lt;p&gt;　　发表在《科学》杂志上的新研究发现，居住在印度洋和太平洋的大型的军舰鸟，借助上升气流，每隔六分钟挥舞着巨大翅膀，从而飞行几百英里。&lt;/p&gt;&lt;p&gt;　　研究团队在军舰鸟的后颈贴上了极轻的设备。该小型太阳能设备与卫星相连，其功能包括GPS跟踪、心率监视器、加速计和测高计。它们的重量只有10克，可以在跟随着军舰鸟的同时保证其的自由飞行。&lt;/p&gt;&lt;p&gt;　　研究人员知道军舰鸟拥有其轻的体重，并且体重分布在大翅膀上，这有助于它们在空中持久的飞行。因为大型的军舰鸟没有防水的羽毛，他们必须持久的在空中飞行，来防止在水面上降落。&lt;/p&gt;&lt;p&gt;　　发现大型军舰鸟的飞行模式&lt;/p&gt;&lt;p&gt;　　研究团队认为，在印度洋的核心地段，大型的军舰鸟充分利用这里独特的气候，实现长久俯冲后的高飞和滑翔过程。一年四季，巨大的印度洋仍然表现得相当平稳的，这里被称为赤道无风带。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;　　大型的的军舰鸟坚守在赤道无风带的周围，环绕在这周围数天甚至数月，因为它们发现在赤道无风带的周围的天气相当恒定和可靠，充满了有利于飞升的上升气流。在这赤道无风带周围飞行时，军舰鸟只花费它们10%的时间去寻找食物。而剩余的时间它们都用在了从云到积雨云的飞翔，每天飞行的距离长达400英里。&lt;/p&gt;&lt;p&gt;　　研究团队表示，他们很可能在长途跋涉的空气中睡觉。&lt;/p&gt;&lt;p&gt;　　在之前的研究中，研究人员认为大型军舰鸟由于云层中可能存&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('58', '&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160717/1468750543292487578b5acf8baca.png&quot; alt=&quot;&quot;/&gt;&lt;/p&gt;&lt;p&gt;　　文章来源：中国科学报 微信公众号&lt;/p&gt;&lt;p&gt;　　专家建议尽快完善相关法律规避伦理风险和社会争议&lt;/p&gt;&lt;p&gt;　　从修改植物基因，到改变蝴蝶翅膀的图案，再到修改人类细胞……以CRISPR为代表的基因编辑技术风靡生命科学领域。&lt;/p&gt;&lt;p&gt;　　日前，在香山科学会议第564次学术讨论会上，专家指出，我国基因编辑研究工作正在向源头创新转移，现阶段应大力推动该领域的研究及应用，并及时制定严格有效的监管措施和伦理规范，保证基因编辑下游应用快速健康有序发展。&lt;/p&gt;&lt;p&gt;　　向源头创新转移&lt;/p&gt;&lt;p&gt;　　今年5月，河北科技大学生命科学与工程学院副教授韩春雨等人的最新成果：一种全新的基因编辑技术(NgAgo-gDNA)，引发了全球生物学研究者的关注。&lt;/p&gt;&lt;p&gt;　　在此之前，基因编辑界最大腕的“明星”是美国结构生物学家詹妮弗·杜德纳发明的CRISPR/Cas9，科学界称之为基因“魔剪”。&lt;/p&gt;&lt;p&gt;　　而更早之前，包括ZFN、TALEN等在内的基因编辑技术的原创者也都不是中国科学家。&lt;/p&gt;&lt;p&gt;　　“韩春雨实验室的成果代表了我国在基因编辑源头技术开发上的重要突破。”&lt;/p&gt;&lt;p&gt;　　此次会议执行主席之一、中科院院士周琪告诉《中国科学报》记者，“这标志着中国的基因编辑研究工作已经在向源头创新转移。”&lt;/p&gt;&lt;p&gt;　　研究者相信，中国科学家在基因编辑技术上的一系列具有国际影响力的成果，将推动基因修饰技术在人类疾病研究等领域的快速发展。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('59', '&lt;p&gt;央视财经讯 我国年内第14次成品油零售价调价窗口期，于7月21日24时开启。经过前两次搁浅后,国家发改委宣布，本次成品油价格迎来年内第二次下调！汽、柴油每吨分别下调155元和150元；全国平均来看折合90号汽油每升下调0.1元，0号柴油每升下调0.13元，&lt;strong&gt;油价下调原因&lt;/strong&gt;，&lt;strong&gt;中国油价下调&lt;/strong&gt;，&lt;strong&gt;今日油价下调&lt;/strong&gt;，92号汽油均每升下调0.11元。按一般家用汽车油箱50L的容量估测,加满一箱汽油将节省约5元。&lt;/p&gt;&lt;p&gt;此次成品油零售价格下调，&lt;strong&gt;油价下调整最新消息&lt;/strong&gt;，&lt;strong&gt;油价下调&lt;/strong&gt;，国内汽柴油零售市场将再次全面回归“五元时代”。对于终端消费者来说，&lt;strong&gt;油价下调最新消息&lt;/strong&gt;，降低出行成本无疑是个好消息。以北京为例，&lt;strong&gt;油价下调图片&lt;/strong&gt;，#92#号汽油将从6.05元/升降至5.94元/升，而上海#92#号汽油则从6.01元/升降至5.90元/升。&lt;/p&gt;&lt;p style=&quot;text-align:center&quot;&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160721/d6d66f3a745d88930e035c7d00ef5fc7.jpg!100_100_3.jpg&quot; alt=&quot;d6d66f3a745d88930e035c7d00ef5fc7.jpg!100_100_3.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;6月份开始,国际原油价格一直处于45-52美元/桶的价格区间内震荡盘整。前两次调价周期(6月9日-7月7日)内,按国内成品油价格机制,调价金额每吨不足50元,成品油价格不调整。&lt;/p&gt;&lt;p&gt;多家机构认为,本轮调价周期内,因美元上涨,美国库欣地区等全球各地燃油库存大涨,加重了市场对供应过剩的忧虑,导致国际油价震荡下行。&lt;/p&gt;&lt;p&gt;截至7月19日收盘,伦敦洲际交易所布伦特原油期货结算价报48.18美元,WTI原油期货结算价报47.6美元；纽约商品交易所原油期货结算价收报45.45美元,相比6月8日的51.23美元,下跌幅度为11.28%。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;，&lt;strong&gt;油价下调再爽约&lt;/strong&gt;，&lt;strong&gt;油价下调时间&lt;/strong&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('60', '&lt;p&gt;【环球网报道 记者 余鹏飞】菲律宾总统杜特尔特日前暗示了他愿意按照前总统菲德尔·拉莫斯的建议，搁置南海仲裁案的“裁决”，恢复与中国的双边对话。杜特尔特就此解释称，“中国有钱，美国是没有钱的”。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;　　据《菲律宾商报》7月24日报道，菲律宾总统杜特尔特22日发表演讲称，菲德尔·拉莫斯向其建议在与中国对话时，搁置南海仲裁案的“裁决”是没有问题的。与中国的经济合作可帮助菲律宾的南部群岛致富。&lt;/p&gt;&lt;p&gt;　　不过，菲律宾最高法院高级陪审法官加彪(音译)22日声称，重启与中国的谈判也是有前提的，即中国将不提到其“九段线”主张。此前菲律宾总检察长卡利达和外交部长亚赛表示，菲律宾在与中国政府谈判时将必须利用“裁决”。&lt;/p&gt;&lt;p&gt;　　报道称，菲律宾总统杜特尔特表示，菲律宾仍然希望与中国友好，菲律宾打算建设经济区和农场到市场的道路，“中国有钱，不是美国。美国是没有钱的”。&lt;/p&gt;&lt;p&gt;　　对于所谓的“南海仲裁”，中国政府已经多次表示，由菲律宾阿基诺政府单方面提起的所谓仲裁，扭曲《联合国海洋法公约》宗旨，挑战作为地区规则的《南海各方行为宣言》，是打着法治和规则旗号反法治和规则。南海仲裁从一开始就是个非法的东西。中方根本不承认、也绝对不会接受这样一个非法的、完全违背了国际法的这么一个单方面提起来的所谓仲裁案，中方会继续表明立场。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('61', '&lt;p&gt;北京时间7月24日，据雅虎体育报道，凯文-杜兰特今夏加盟勇士队的决定引起了很大的争议，但是据阿杜本人表示，从那之后，从来没有人当面抨击过他的这个决定。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;　　自从杜兰特在7月4日宣布加盟勇士队之后，外界的反应非常激烈，雷霆队球迷开始烧杜兰特的球衣；查尔斯-巴克利对他的决定表示失望，并称杜兰特这是“想骗一个总冠军”；甚至连他的两位昔日队友坎特和亚当斯都在推特上唱双簧并讽刺杜兰特背叛球队。&lt;/p&gt;&lt;p&gt;　　虽然杜兰特已经听到了那些批评的声音，但是他表示外界对这个决定的反应并不是太糟糕。&lt;/p&gt;&lt;p&gt;　　“所有那些批评的声音都发生在网络上。我从来没有遇到过一个人当面说我坏话。”杜兰特说道，“对于外面的批评家来说，他们很容易告诉你应该做什么以及怎么去做。我是那个需要经历整个过程的人，所以我真的不能去在意外部的噪音。工作没有停止，一切保持原样。”&lt;/p&gt;&lt;p&gt;　　正如杜兰特说的，他在今夏从篮球的角度做出了一个对他来说最有利的决定，所以他愿意承担一切后果。此外，他强调自己只会在意那些真正爱他的人，至于其他人，杜兰特根本不会在乎他们的评论。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('62', '&lt;p&gt;佩莱出席战申花赛前发布会&lt;/p&gt;&lt;p&gt;　　齐鲁网济南7月23日讯 （ 记者 李淼 实习记者 薛睿 ） 中超联赛第19轮山东鲁能主场迎战上海申花，鲁能主帅马加特出席了赛前发布会，主帅马加特表示申花是一支强大的队伍，明天不会期待很多进球。&lt;/p&gt;&lt;p&gt;　　马加特：申花是强大的对手&amp;nbsp;明天不会期待很多进球&lt;/p&gt;&lt;p&gt;　　发布会上，鲁能主帅马加特表示申花是一个强大的对手，“在几周前足协杯的比赛中对阵上海申花使我们积攒了经验，我认为那是一场不错的比赛。申花向我们展示出他是一支强大的球队，甚至在过去的比赛中他是最强大的一支。”&lt;/p&gt;&lt;p&gt;　　在此前上海滩新旧霸主上海申花与上海上港的德比之战中，申花外援登巴巴断腿重伤，对此，主教练马加特表示：“登巴巴受伤对我们来说是好是坏不能 判断，但对申花来说是一种损失。通常一个队员的重伤能让他的队员更众志成城，因此我们面对的是一场艰苦的比赛，想拿下三分不是简单的事。”&lt;/p&gt;&lt;p&gt;　　过去的两场比赛鲁能都以大比分胜利，而鲁能是否还有进攻的潜力成为大家关注的话题，对此，马加特表示，“就像刚才说的明天我们面对是更强大的对手，会有更多困难。过去两场球队的确都进了很多球，但对手开场都为我们制造了麻烦，直到比赛最后我们才确定胜利，因此明天不会期待很多进球。”&lt;/p&gt;&lt;p&gt;　　马加特上任后果敢的使用年轻小将让球迷十分惊喜，而对于明天的首发名单，马加特坦言，“我的比赛名单主要通过球员训练表现和对手而决定，过去他们表现很好，明天的首发名单不会有大改变，但会有一两个人退出首发名单，会有其他人补充进来。”&lt;/p&gt;&lt;p&gt;　　佩莱：集中精力打好比赛&amp;nbsp;希望进球帮助球队胜利&lt;/p&gt;&lt;p&gt;　　跟随主教练马加特出席发布会的是上一轮联赛中刚刚打入中超首球的外援佩莱，佩莱先是祝福了重伤的登巴巴，“关于登巴巴我为他送上祝福，祝他早日康复。”对于明天的比赛，佩莱说，“从我第一天来就知道每场比赛对我们都很重要，每一分都很重要，这从积分榜上可以看出。之前几场球队有很好的表现，希望接下来我们也有好的表现。主教练之前和上海交过手，但我是第一次，从排名来看他们是很强的对手，所以90分钟里我们要集中精力，打好这场比赛。”&lt;/p&gt;&lt;p&gt;　　上轮联赛中，新援佩莱首发出场并打入了自己的中超首颗进球，而对于明天比赛的进球目标，佩莱表示，“首先很高兴我已经取得联赛进球。对一个前锋大家最期待的就是进球，进球建立在球队胜利的基础上，作为前锋我希望进球帮助球队胜利，如果我的进球能帮球队胜利或者拿到奖杯，那是我所期待的。”&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('63', '&lt;p&gt;李源一进球后被队友包围庆祝&lt;br/&gt;&lt;/p&gt;&lt;p&gt;　　新浪体育讯　　2016赛季中超联赛第19轮，天津泰达客场1-3负于杭州绿城。虽然输掉了比赛，但天津泰达本场比赛也有收获。前国奥主力中场李源一本场比赛奉献一脚世界波，一度为天津泰达扳平比分，在重返天津泰达后踢得第一场中超比赛中就收获了中超首球。李源一本场比赛25分钟的出场时间虽然不多，但已经超过了他在广州恒大半个赛季的中超出场时间，攻防两端都很积极，表现让人眼前一亮。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('64', '&lt;p&gt;俄罗斯田径之前被判定不能参加里约奥运会，而现在又传来更惊人的消息，据英国媒体《每日邮报》报道，国际奥林匹克委员会准备对整个俄罗斯代表团实行禁赛，代表团387名运动员将无法出战里约奥运会。&lt;/p&gt;&lt;p&gt;　　《每日邮报》周日版了解到，整个俄罗斯奥运代表团都无法参加下个月的里约奥运会，根据他们的消息源，国际奥委会将用最强硬的方式处罚这387名俄罗斯代表团运动员。&lt;/p&gt;&lt;p&gt;　　之前，受到处罚的只是俄罗斯田径代表团，但《每日邮报》表示，今天的裁决结果将排除俄罗斯在自行车、柔道、摔跤等其他项目的夺金希望。这场争论涉及到俄罗斯总统普京的体育部发放类固醇混合物以及在2012年伦敦奥运会前掩盖污染的尿液样本。&lt;/p&gt;&lt;p&gt;　　不过，《每日邮报》也指出，一小部分在国外训练、经过严格的反兴奋剂程序并且没有涉及腐败的俄罗斯运动员，有希望以中立的身份出战奥运会。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('65', '&lt;p&gt;陆浩杰和陆永（右）&lt;br/&gt;&lt;/p&gt;&lt;p&gt;　　中新社北京7月23日电 （记者 张素）力拔山兮，壮士出征，中国举重队23日晚从北京兵发里约。这支最“给力”的队伍说：这次要全面超越上届奥运会。&lt;/p&gt;&lt;p&gt;　　自1984年洛杉矶奥运会至今，中国举重队共获29枚金牌，与中国体操队并列“金牌榜”第二。近4届奥运会，除了2008年北京奥运会时豪夺8金，他们在悉尼、雅典、伦敦三次境外参赛所获金牌数均为5枚。&lt;/p&gt;&lt;p&gt;　　这一次，中国举重队派出10名大力士出战10个级别，明确喊出目标：保六争八。女队主教练王国新已是第七次奥运之旅，他将带领四位“90后”女将“保三争四”。面对中新社记者提出对于时差、气温、治安等问题有无担忧，王国新回答：“我们在两年前就已做好全部准备”。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;　　出征仪式上，中国国家体育总局举摔柔运动管理中心主任周进强连用三句诗鼓舞全队士气。“人生能有几回搏”，引自新中国首位世界冠军容国团的誓言；“壮士一去兮不复还”，是借《荆轲歌》号召选手们“抱着必胜信念”；“黄沙百战穿金甲，不破楼兰终不还”，是借《从军行》激发选手们对金牌的渴望。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('66', '&lt;p&gt;英国公投“脱欧”以来，流动性宽松预期叠加供给侧改革的推进，助推A股出现小反弹。从6月24日至7月21日，上证指数上涨超过5%，A股重回3000点之上。&lt;/p&gt;&lt;p&gt;　　是追涨入场还是获利了结，机构分歧加大。国泰君安(18.080,&amp;nbsp;-0.20,&amp;nbsp;-1.09%)认为，乐观预期正提前透支，谨防吃饭变买单。安信证券则认为现在处于吃饭行情的上半场，还会进入“山脚下板块补涨”的纵深发展阶段。&lt;/p&gt;&lt;p&gt;　　“熊市中吃饭行情往往都是非常短暂的，有时候甚至短得超出我们判断，只有结构性行情可以在一定程度上穿越牛熊，因此，下半年我们认为仍然是结构行情为主，特别是政策主导的如新能源产业、供给侧改革及国企改革等相关板块，仍有不错的投资机会。”移动互联网证券平台投顾大师CEO彭亮在接受《中国经营报》记者采访时表示。&lt;/p&gt;&lt;p&gt;　　“吃药喝酒”行情&lt;/p&gt;&lt;p&gt;　　7月21日，A股终结5连阴，三大股指在早盘震荡后，便展开一波强势的反弹，权重股、题材股双双做多。然而，午后成交量萎缩，沪指在3050点附近盘整回落。截至收盘，上证指数全天报3039.01点，小幅收阳。&lt;/p&gt;&lt;p&gt;　　对此，彭亮表示，创业板方面也是风险积聚，已到达前期密集套牢盘附近。虽然近期沪股通持续净流入、融资盘也不断买入，但增量入场资金有限，目前仍是存量资金博弈阶段，股指还会在3000点附近盘整，风险犹存。&lt;/p&gt;&lt;p&gt;　　步入三季度以来，随着市场企稳，市场情绪回暖，越来越多的机构开始对“吃饭行情”有进一步期待。虽然指数整体呈现出震荡徘徊的趋势，但消费品中的食品饮料表现相对突出。&lt;/p&gt;&lt;p&gt;　　根据以往经验，震荡市中“吃药喝酒”行情总是联袂上演，而今年上半年“吃药”的行情却有些冷清。进入7月后，沉寂已久的医药隐现板块启动的迹象。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('67', '&lt;p&gt;房地产拉动了今年中国经济增长，国家统计局发布2016年二季度GDP，数据显示为6.7%，与一季度持平。从数据上看，中国GDP增速处于逐渐下降趋势，去年四季度GDP增速6.8%，2015年中国全年GDP增速为6.9%。在经济增长的“L”型走势中，我们是否已经处在底部，还是经济增长会继续下行？中国经济增长在下半年面临什么挑战和风险，是值得我们思量的。&lt;/p&gt;&lt;p&gt;　　6月第一次出现了民间投资负增长的情况，1-6月，民间固定资产投资同比名义增长2.8%，增速比1-5月回落1.1个百分点；民间固定资产投资占全国固定资产的比重为61.5%，比去年同期降低3.6个百分点。民间投资是推动中国经济增长的一个重要引擎。但是，近年来中国民间投资动力不断减弱。值得注意的是，民间投资走弱发生在政府稳增长政策不断追加国企投资、基础建设领域不断加码的环境下，就更应该引起我们的重视。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;　　民间投资走弱的一个原因是，近年来工业品的出厂价格持续下滑，尤其是一些产能过剩行业的企业利润出现负增长甚至亏损，这在很大程度上影响了民间投资的积极性。从民间投资区域性的差异也可以看出，过剩产能问题严重的东北地区、中部地区、西部地区，民间投资疲弱的现象更为严重。上半年，东北地区的民间投资增速下降了31.9%，中部和西部民间投资增速分别只有5.1%和1.9%。另&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('68', '&lt;p&gt;上半年公募基金产品中最为风光的，莫过于QDII了。不仅在业绩上表现优异，而且也为基金公司带来了吸金效应。&lt;/p&gt;&lt;p&gt;　　截至7月21日，公募基金二季度报告披露收官。民生证券研究显示，在A股市场持续震荡的行情中，QDII规模增速最为可观，其二季度末规模较2016年一季度末增长197亿元，增速达到29.95%。就连QDII额度也与之伴随水涨船高的，愈来愈紧俏。&lt;/p&gt;&lt;p&gt;　　不过，在QDII基金经理眼中，下半年，QDII这个热门的投资类型，将随着海外市场的走势，而呈现出分化。&lt;/p&gt;&lt;p&gt;　　QDII规模占比首超1%&lt;/p&gt;&lt;p&gt;　　民生证券统计显示，截至上半年末，共有3072只公募基金产品，规模合计7.97万亿元。从分类看，货币市场型43672亿元居首，QDII型达到854亿元；从规模占比看，债券型和货币型合计占比66.6%，首次达到2/3的比例，QDII型占比首超1%；从规模增速看，总规模较2016年一季度末增长2.4%，其中QDII型增长197亿元，增速达到29.95%，为各类型中增速最高，股票型则缩水84亿元。&lt;/p&gt;&lt;p&gt;　　据同花顺(78.690,&amp;nbsp;-0.85,&amp;nbsp;-1.07%)数据统计显示，截至7月22日，共有30家基金公司设立了QDII，正在运行管理的QDII数量共有155只。其中广发基金所管理的QDII基金产品数量为15只，数量最多，而华安基金、嘉实基金分别以14、11只位列第二名和第三名。&lt;/p&gt;&lt;p&gt;　　这155只QDII基金今年整体收益3.63%，88只QDII获得正收益。其中，中银标普全球精选以37.63%的累计净值增长率位居榜首，上投摩根全球天然资源、汇添富黄金及贵金属以 27.37%、24.95%的收益分列QDII基金收益榜第二、三位。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('69', '&lt;p&gt;资管行业迎来“紧箍咒”——《证券期货经营机构私募资产管理业务运作管理暂行规定》（以下简称《暂行规定》）于7月18日正式实施。&lt;/p&gt;&lt;p&gt;　　业内人士仍表示，较此前的“八条底线”，此次新规对杠杆的要求再有升级，而文件下发单位从行业协会转至&lt;a href=&quot;http://weibo.com/csrcfabu?zw=finance&quot; target=&quot;_blank&quot;&gt;证监会&lt;/a&gt;则体现出监管层对资管业务规范的高度重视，“治理过去的资管乱象将成为接下来各机构的重要工作。”&lt;/p&gt;&lt;p&gt;　　在上述新规的导向下，另据媒体报道，监管层近期亦对银行理财资金对接券商资管、基金子公司专户甚至契约型私募开展的委外业务提高了关注程度，后期也将对该类业务酝酿配套规范措施。&lt;/p&gt;&lt;p&gt;　　严控杠杆&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('70', '&lt;p&gt;　[去年3月，国家外汇管理局大额放行了5家基金公司共计84亿美元的QDII额度。目前有约30家基金公司获批了QDII额度，其中在10亿美元规模以上的基金公司只有8家，占比不到三成最近一次的QDII基金暂停申购公告来自于广发基金]&lt;/p&gt;&lt;p&gt;　　[据《第一财经日报》记者统计，目前暂停申购的QDII基金占到总体的比例大约是44%，其中暂停大额申购的比例也达到43%。]&lt;/p&gt;&lt;p&gt;　　[“现在QDII通道费是在1%~2%之间，一般来说，除了有些是机构，还有些则是一些企业有这方面的需求。”华南一家公募国际业务部副总经理如此表示。]&lt;/p&gt;&lt;p&gt;　　[7月18日在岸人民币对美元跌破6.7关口，为2010年11月以来的首次，而这个水平已经较年初跌去了约3.5%。]&lt;/p&gt;&lt;p&gt;　　近来，人民币贬值压力较大，机构出海意愿再次高涨。而基金公司QDII额度早已告急，可供机构借用的通道费也随之大涨。《第一财经日报》记者了解到，目前一些公募的通道费水平大概在2%附近，该水平较此前平均水平翻了一倍还多。&lt;/p&gt;&lt;p&gt;　　去年3月至今，国家外汇管理局再未新增QDII额度，目前总额度保持在约900亿美元。本报记者统计发现，近半数QDII暂停了申购及大额申购。&lt;/p&gt;&lt;p&gt;　　近半数QDII暂停申购&lt;/p&gt;&lt;p&gt;　　截至今年7月21日，65只QDII基金采取了限购措施。自2015年3月至今，QDII未获新增额度，很多基金公司的外汇额度告急。据《第一财经日报》记者统计，目前暂停申购的QDII基金占到总体的比例大约是44%，其中暂停大额申购的比例也达到43%。一方面基金公司额度紧缺，但是机构出海意愿仍非常强烈。因此，基金公司的QDII通道费也是“水涨船高”。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('71', '&lt;p&gt;英国退欧，日元升值为哪般？&lt;/p&gt;&lt;p&gt;　　徐瑾&lt;/p&gt;&lt;p&gt;　　按照“蝴蝶效应”的理论，大西洋畔的一只蝴蝶震动翅膀，可能会迎来太平洋这边的海啸。这种说法听起来夸张，但是在全球化时代却并非危言耸听，东西经济体一体化之下，确实容易出现各种误伤。典型如同6月末英国退欧全民公投，其结果是以微弱优势离开欧洲，这结果其实出乎主流精英以及金融市场预测之外。这对于欧盟、英国的影响自不待言，对于亚洲的日本，也不啻于一个重大打击。&lt;/p&gt;&lt;p&gt;　　原因何在？一言以蔽之，日元升值。在英国脱欧之后，日元兑美元汇率立即上升超过4%，幅度几乎接近二十年内最高，日元兑英镑(1.3105,&amp;nbsp;-0.0111,&amp;nbsp;-0.84%)更是大跌超过12%；更值得注意的是，去年年中以来，日元兑人民币(6.6876,&amp;nbsp;0.0122,&amp;nbsp;0.18%)升值足有三成。在经济低迷之下，强势货币并不是福音：日元升值打击日本出口，而安倍经济学的核心要点之一正在于货币贬值。&lt;/p&gt;&lt;p&gt;　　日元在国际货币中处于一个非常吊诡的情况。在常规情况之下，日元因为利率低廉，一直是各类“息差交易”的主角，投资者一般借入日元买入其他资产，从利息之差获取稳定收益，因此日本家庭主妇也是其中主力，她们甚至有一个外号叫“渡边太太”，昔日名声之大，几乎可以和买黄金的中国大妈们相提并论。当英国退欧这&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('72', '&lt;p&gt;新浪财经讯 7月22日消息，据彭博报道，澳大利亚联邦银行（CBA）驻新加坡外汇策略师Andy Ji称，中国&lt;a href=&quot;http://weibo.com/u/3921015143?zw=finance&quot; target=&quot;_blank&quot;&gt;央行&lt;/a&gt;本周已通过强劲的&lt;a href=&quot;http://biz.finance.sina.com.cn/forex/quote.php?code=USDCNY&amp;img_type=min&quot; target=&quot;_blank&quot;&gt;人民币&lt;/a&gt;(6.6876,&amp;nbsp;0.0122,&amp;nbsp;0.18%)中间价向市场明确传达了这个信息：要在1美元兑6.7元水平上捍卫人民币汇率。&lt;/p&gt;&lt;p&gt;　　人民币中间价今日设在6.6669元，本周累计调升0.2%，创下6周最大升幅。&lt;a href=&quot;http://biz.finance.sina.com.cn/forex/quote.php?code=USDCNY&amp;img_type=min&quot; target=&quot;_blank&quot;&gt;人民币兑美元&lt;/a&gt;本周走强0.28%，至1美元兑6.6995元，迈向7周来首次周涨幅。&lt;/p&gt;&lt;p&gt;　　在英国脱欧之后，美元/人民币逼近6.7元，是因为在&lt;a href=&quot;http://biz.finance.sina.com.cn/forex/quote.php?code=EURUSD&amp;img_type=min&quot; target=&quot;_blank&quot;&gt;欧元&lt;/a&gt;(1.0975,&amp;nbsp;-0.0051,&amp;nbsp;-0.46%)、&lt;a href=&quot;http://biz.finance.sina.com.cn/forex/quote.php?code=GBPUSD&amp;img_type=min&quot; target=&quot;_blank&quot;&gt;英镑&lt;/a&gt;(1.3105,&amp;nbsp;-0.0111,&amp;nbsp;-0.84%)走软背景下人民币中间价遭下调，而非为政策决定所驱动。&lt;/p&gt;&lt;p&gt;　　央行有能力保卫人民币在年内不跌穿1美元兑6.7元，因为事况仍在当局掌控之中。&lt;/p&gt;&lt;p&gt;　　美国财政部官员昨日称，中国最近已干预市场阻止人民币进一步贬值，但这与主动干预谋求弱势汇率不同。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('73', '&lt;p style=&quot;white-space: normal;&quot;&gt;&lt;img alt=&quot;&quot; src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160724/146935299958097857948c2778f27.png&quot; title=&quot;陈晓陈妍希办婚礼&amp;nbsp;&amp;lt;wbr&amp;gt;盘点明星的天价婚礼&quot; width=&quot;550&quot;/&gt;&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;小龙女与杨过终于结婚了，这个无论是在小说还是影视作品中均为出现的场景，今天(7月19日)将在现实中出现！7月19日，“过儿”陈晓和“小龙女”陈妍希将在北京的雁西湖举办婚礼！&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;&lt;img alt=&quot;&quot; src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160724/146935300030262857948c28357c4.png&quot; title=&quot;陈晓陈妍希办婚礼&amp;nbsp;&amp;lt;wbr&amp;gt;盘点明星的天价婚礼&quot; width=&quot;550&quot;/&gt;&lt;/p&gt;&lt;p style=&quot;white-space: normal;&quot;&gt;陈晓陈妍希婚礼内场布置&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('74', '&lt;p&gt;陈乔恩以前一段说自己爱吃睾丸，尤其是鸡睾丸的视频被网友扒了出来，引起热议。对此陈乔恩透露自己的丰胸秘诀是吃鸡睾丸。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&lt;img alt=&quot;陈乔恩&quot; src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160724/146935305469916557948c5e3e621.png&quot;/&gt;陈乔恩&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('75', '&lt;p&gt;今年24岁的34D屋村少女何洛沂推出写真，首批发行4000本。透露获内地老板朋友扫写真，预计中港合共售出近3000本。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&lt;img alt=&quot;24岁何洛沂穿低胸装展露事业线&quot; src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160724/146935310946549157948c9530e23.png&quot;/&gt;24岁何洛沂穿低胸装展露事业线&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;　　新浪娱乐讯 北京时间7月24日消息，据香港媒体报导，今年24岁的34D屋村少女何洛沂推出写真，首批发行4000本。昨天（7月23日）她凑热闹入书展宣传，以低胸上衣配短裤，露事业线加长腿赠兴。她透露获内地老板朋友扫写真，预计中港合共售出近3000本。&lt;/p&gt;&lt;p&gt;　　拒50万饭局&lt;/p&gt;&lt;p&gt;　　追问有没有老板出价邀约饭局？何洛沂表明内地老板只是普通朋友，但另有人出价：“试过几次，其中有人在微博户口私讯我说出50万邀饭局，但我没回复。因为是原则不是价钱问题，觉得不道德，约吃饭出价已不合理，还不淮我带助手或朋友出席，感觉不舒服。”她还不停暗讽其他写真对手，例如自己没干爹支持、有人年过30岁出写真感觉老、和自己写真没有修图，句句有骨。她拒开名讽刺，认为读书眼睛雪亮，一看便明白，而她本人则敢素颜上阵，强调自己真材实料。（颖颖）&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('76', '&lt;p&gt;新浪娱乐讯 在承诺不再拍“大型动作片”四年后，62岁的成龙[微博]在这个夏天又出山了。虽没亲自担任导演，但《绝地逃亡》那笑料和动作齐飞的熟悉配方、那中外混血的熟悉味道，早已将他出卖。这次他多了约翰尼·诺克斯维尔这个在片中成事不足败事有余的老外拍档，多了范冰冰[微博]的倾情助阵，也多了些力不从心的自知。但大哥依然是那个爱玩命、爱“教年轻人”、爱感叹苦日子里出光辉的大哥。年过六旬的成龙为何坚持扮演动作英雄？他如何教育王大陆[微博]、黄子韬[微博]、吴彦祖[微博]和谢霆锋？怎么惊险万分地掉进水中、假戏真做到喊救命？约翰尼和范冰冰的吻戏隐藏着怎样的心机？耀莱签约吴亦凡之后有什么样的远大计划？一切的一切，都在这次访谈中解答。&lt;/p&gt;&lt;p&gt;　　三十年坚持成式动作喜剧 只因影迷支持依旧&lt;/p&gt;&lt;p&gt;　　新浪娱乐：首先请问成龙，至今你专注于“成龙式”动作喜剧已有三十余年了，是什么样的动力让你坚持继续拍下去？&lt;/p&gt;&lt;p&gt;　　成龙：是全世界的影迷，以及新的观众。我自己也很喜欢拍动作。以前拍动作的时候，大家看到我做那些平常人做不到、却又有机会去做的东西，都说“哇”。比如说一般是坐直升机，而我是吊在直升机外面。现在继续做，就是让大家觉得：“哇，成龙到现在还可以这样子！”&lt;/p&gt;&lt;p&gt;　　所以感谢大家的支持。每一个月、每一天我都收到大家寄来的信或是基金会提供的钱。我没法一一致谢，只能用好的电影来回报大家。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('77', '&lt;p&gt;不知不觉7月已到月尾，大雨也从南方下到了北方，可就算大雨让整座城市倾倒，影院也会为你上新片……&lt;/p&gt;&lt;p&gt;　　但也有觉得暑期档太挤，移到中秋档的《大话西游3》，还有作别七夕档进军贺岁档的《三少爷的剑》。就让小玩向这两部改档的电影挥挥手，然后再激动的和你们讲讲这周的新片情况。&lt;/p&gt;&lt;p&gt;　　相较于前几周的清一色的国产片，这周影院里多了日本、印度和美国的片子，票房厮杀战就更厉害了，大家的选择空间也更多了一些。新片一共有十部，但并不是每一部都值得去看哦。&lt;/p&gt;&lt;p&gt;　　《绝地逃亡》&amp;nbsp;2016-7-21&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160724/146935332148182357948d697cdbb.png&quot; alt=&quot;&quot;/&gt;&lt;/p&gt;&lt;p&gt;　　导演： 雷尼·哈林&lt;/p&gt;&lt;p&gt;　　主演： 成龙 /范冰冰 / 约翰尼·诺克斯维尔 / 曾志伟&lt;/p&gt;&lt;p&gt;　　类型： 喜剧 / 动作&lt;/p&gt;&lt;p&gt;　　成龙的动作喜剧，总感觉说完这七个字就已经明白这部电影是怎样的了……&lt;/p&gt;&lt;p&gt;　　虽然影片宣传的时候主打成龙和范冰冰，但其实范冰冰戏份少到打酱油，主要是成龙和约翰尼·诺克斯维尔两人从俄罗斯一路逃到香港的故事，有种风光旅游穿插剧情的感觉。&lt;/p&gt;&lt;p&gt;　　以前成龙的电影最大的看点就是干净利索的打斗了，可今年成龙已经62岁了，都到了不应该叫大哥，应该叫大爷了的年龄了。所以整部电影看下来，更多的也许是辛酸吧……&lt;/p&gt;&lt;p&gt;　　关注“玩儿电影”公众号（id：wan2movie）有机会抢票。&lt;/p&gt;&lt;p&gt;　　《泰山归来：险战丛林》&amp;nbsp;2016-7-19&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160724/146935332193137157948d69c1906.png&quot; alt=&quot;&quot;/&gt;&lt;/p&gt;&lt;p&gt;　　导演： 大卫·叶茨&lt;/p&gt;&lt;p&gt;　　主演： 亚历山大·斯卡斯加德 / 玛格特·罗比 / 塞缪尔·杰克逊&lt;/p&gt;&lt;p&gt;　　类型： 动作 / 冒险&lt;/p&gt;&lt;p&gt;　　古老传说的现代新诠释，强调了殖民时代背景，企图从人性入手让整个故事更加有深度，不过导演大卫耶茨功力所限，结果显得四六不靠。&lt;/p&gt;&lt;p&gt;　　而颜和肉更是拉动这部电影票房的两架大马车！主角颜值都奇高，E大一言不合就爆衫，优美的人鱼线简直可以让人原谅影片的一切问题，玛格特罗比爱捆绑，各种捆绑湿身戏，美的不要太动人~配角方面赛缪尔杰克逊、瓦尔兹的表现也十分抢眼。影片中热带丛林环境和动物还会让人屡次想起《奇幻森林》。&lt;/p&gt;&lt;p&gt;　　《哆啦A梦：新·大雄的日本诞生》&amp;nbsp;2016-7-22&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160724/146935332237330157948d6a2154c.png&quot; alt=&quot;&quot;/&gt;&lt;/p&gt;&lt;p&gt;　　导演： 八锹新之介&lt;/p&gt;&lt;p&gt;　　主演： 水田山葵 / 大原惠美 / 嘉数由美 / 木村昴 / 关智一&lt;/p&gt;&lt;p&gt;　　类型： 动画&lt;/p&gt;&lt;p&gt;　　看见蓝胖子，必然就得说到情怀，既然如此，那就请让我自动变身脑残粉吧！因为太多人的童年都是哆啦A梦和大雄陪伴的，而预告里一句“一起天真”简直直戳泪点，让人想立马冲进电影院刷个几遍。&lt;/p&gt;&lt;p&gt;　　虽然影片故事只是在89年剧场版的基础上进行重制和改良，依旧是讲述的大雄一行人穿越到远古时代后卷入部落纷争的故事。但经典并不会被时代所遗弃，现在看感动也还在。&lt;/p&gt;&lt;p&gt;　　最最最为重要的是，这是良心的2D，人物也还是原来熟悉的原画造型！想想“伴我同行”的CG造型，简直感动的要流泪……&lt;/p&gt;&lt;p&gt;　　同样，在“玩儿电影”公众号上可以抢票。&lt;/p&gt;&lt;p&gt;　　《天亮之前》&amp;nbsp;2016-7-22&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160724/146935332260444357948d6a5726d.png&quot; alt=&quot;&quot;/&gt;&lt;/p&gt;&lt;p&gt;　　导演： 吴中天&lt;/p&gt;&lt;p&gt;　　主演： 郭富城 / 杨子姗 / 郝蕾 / 安志杰&lt;/p&gt;&lt;p&gt;　　类型： 爱情&lt;/p&gt;&lt;p&gt;　　简单来说就是一个欠债赌徒和一个风尘女的爱情故事。&lt;/p&gt;&lt;p&gt;　　杨子姗饰演的女主就算被赌徒骗尽钱财，也会愿意去相信一次，再赌一次，这样的设定致敬了经典的爱情电影《卡比利亚之夜》。可海报上“用你一夜，赌我一生”这种乡村文艺的宣传，档次真得就立马down下去了呢……&lt;/p&gt;&lt;p&gt;　　编剧任鹏，还写过《催眠大师》的剧本，所以剧情流畅性和逻辑性还是挺好的，只是再浪漫的爱情都容易陷入套路的深渊，好在男女主演技都在线，至少不会像某些青春片那样跳戏= =&lt;/p&gt;&lt;p&gt;　　这部片子我们也有票，关注“玩儿电影”公众号可参与抢票。&lt;/p&gt;&lt;p&gt;　　《巴霍巴利王：开端》&amp;nbsp;2016-7-22&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160724/146935332219437757948d6a87abf.png&quot; alt=&quot;&quot;/&gt;&lt;/p&gt;&lt;p&gt;　　导演： S·S·拉贾穆里&lt;/p&gt;&lt;p&gt;　　主演： 帕拉巴斯 / 拉纳·达格巴帝 / 安努舒卡·谢蒂 / 特曼娜·芭蒂亚&lt;/p&gt;&lt;p&gt;　　类型： 动作 / 历史 / 冒险&lt;/p&gt;&lt;p&gt;　　印度斥巨资（约等于1.69亿人民币）打造的史诗级神片，号称印度指环王的野心之作。在特效上面虽然不及好莱坞，但也可以看到印度人努力追赶的诚意。&lt;/p&gt;&lt;p&gt;　　另外，因为电影是以神话为背景的片子，所以里面很多故事情节都是基于……脑洞制作的，各种开挂各种神展开，一言不合男女主就拥抱在一起从冬天滚到了春天，而演员表演也非常夸张，如果你喜欢细腻不动声色的情感表达方式，可能刚开始会被他们的表演吓到。&lt;/p&gt;&lt;p&gt;　　说起印度片里惯有的歌舞，在这部电影里也有出现，并且美轮美奂，堪称亮点。&lt;/p&gt;&lt;p&gt;　　所以，如果你想周末在电影院里愉快地吐吐槽、过过眼瘾，可以去看一下这部邻国神片。同上，“玩儿电影”公众号上有赠票活动。&lt;/p&gt;&lt;p&gt;　　《泡沫之夏》&amp;nbsp;2016-7-21&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160724/146935332292321957948d6abfcc8.png&quot; alt=&quot;&quot;/&gt;&lt;/p&gt;&lt;p&gt;　　导演： 赖俊羽&lt;/p&gt;&lt;p&gt;　　主演： 黄灿灿 / 罗仲谦 / 严禹豪&lt;/p&gt;&lt;p&gt;　　类型： 剧情 / 爱情&lt;/p&gt;&lt;p&gt;　　《泡沫之夏》这部玛丽苏小说可谓是一代人的青春小读物，可是，敲黑板划重点，这是十年前的小说，十年前啊！！！什么车祸梗，失忆梗，三角恋梗，拜托，你以为这10年大家都没长大么？&lt;/p&gt;&lt;p&gt;　　而且这个选角，小说里形容男主欧辰是忧郁俊美冰冷的少爷，你再看看上图的男主……大哥，你认真的样子真得好像街边贴膜的……真心比何润东还毁欧辰0.0&lt;/p&gt;&lt;p&gt;　　如果硬要在大S那款剧版的《泡沫之夏》和这款黄灿灿的电影版《泡沫之夏》里选一个优胜者的话，我宁愿选择此生都没看过这部小说。&lt;/p&gt;&lt;p&gt;　　不过如果你要看这部电影的话，我们在“玩儿电影”公众号上有赠票活动。&lt;/p&gt;&lt;p&gt;　　《魔都凶音》&amp;nbsp;2016-7-22&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160724/146935332350629957948d6b20f33.png&quot; alt=&quot;&quot;/&gt;&lt;/p&gt;&lt;p&gt;　　导演： 彭鹏华&lt;/p&gt;&lt;p&gt;　　主演： 姜雯 / 于小伟 / 张瑶 / 张辛苑 / 王笑天&lt;/p&gt;&lt;p&gt;　　类型： 悬疑 / 惊悚 / 恐怖&lt;/p&gt;&lt;p&gt;　　看海报以为是小三被正房捉奸，而偷情男女将正房关入小黑屋，正房积怨，化身鬼魂报复他们的故事。&lt;/p&gt;&lt;p&gt;　　但其实并不是，剧情介绍说是女主刘小兰非要作死进一间别人都不去的房间进行探险这样……&lt;/p&gt;&lt;p&gt;　　嗯，感觉这个电影看海报开开脑洞就可以过去惹，所以没票送。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('78', '&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160724/146935334754032957948d835f361.png&quot; alt=&quot;杨子姗&quot;/&gt;杨子姗&lt;/p&gt;&lt;p&gt;　　新浪娱乐讯 面前的杨子姗[微博]一身黑色紧身小西装，长衣长裤，利落爽快，与《天亮之前》中那个“风尘女子”的人设相去甚远。这是生活中的杨子姗喜欢的穿衣风格，中性，再加那么一点酷，至于风情，她更多地留给了故事中的角色。&lt;/p&gt;&lt;p&gt;　　《天亮之前》是杨子姗与老公吴中天自公布婚讯以来的首度合作。此前，二人异地恋终成正果的爱情故事已遍传网络，声情并“貌”地甜倒了一片单身狗。不过当这对颜值演艺俱登对的小情侣调整身份变成了演员与导演，二人却好像“疏离”了不少，据说，连男一号郭富城[微博]，都是拍了一半戏才突然意识到二人之间可能存在着非比寻常的特殊关系……&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('79', '&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160724/146935338846924557948dac3db62.png&quot; alt=&quot;7月22日太阳进入狮子座的影响&quot;/&gt;7月22日太阳进入狮子座的影响&lt;/p&gt;&lt;p&gt;　　7月22日：太阳进入狮子座&lt;/p&gt;&lt;p&gt;　　（查看你的本命盘&amp;gt;&amp;gt;）&lt;/p&gt;&lt;p&gt;　　太阳这颗星体是狮子座的守护星座，象征着绝对的权力与光芒，富有活力与表现力，并且在执行力度上非常强劲，当这颗星体再次进入入庙位置的狮子座，对大众而言，经历过六月的沉淀与休憩，意味着下半年的真正开始与再次出发。&lt;/p&gt;&lt;p&gt;　　之前讲述过上半年对这一整年而言都是一种磨砺，而真正的重头戏则在下半年太阳进入狮子座之后，届时不论是对社会整体，还是我们自身来讲，都会经历一场蜕变。如果在上半年或者六月期间对某些事还有所逃避，那么在这个当下你会主动去解决，不再让问题蔓延。&lt;/p&gt;&lt;p&gt;　　在社会角度上，可能会面临经济政策的调整，届时会影响到很多人在就业与购房方面的意向；而对个人来说，这会是很多人考虑跳槽或者已经辞职准备新工作的阶段，这个时候你会觉得自己的想法非常重要，也会更多考虑自己的理想与未来，而变得不那么容易接受生活中的委屈。因为狮子座本身所特有的号召性，这会是很多人主动号召社会力量达成某些计划的时期，但是当多个人争夺同一利益时，角逐与争执再所难免，还是想清楚自己要的是什么才好。&lt;/p&gt;&lt;p&gt;　　行星影响强度：★★★★☆&lt;/p&gt;&lt;p&gt;　　注意的问题：&lt;/p&gt;&lt;p&gt;　　如果在这个当下你希望辞职或者对自己的人生做出另一番打算，那么就要想清楚自己的计划是不是真的可行，如果你的计划是七月中之前就已经筹划好的，那么基本上问题不大。可是如果是这个月底才开始有的新想法，还是慎重考虑，别到最后变成死撑着空谈理想，那就真的是美梦一场了。&lt;/p&gt;&lt;p&gt;　　绝对不能碰的禁区：&lt;/p&gt;&lt;p&gt;　　理想一定是会建立在现实基础之上的，谈理想，先谈钱。&lt;/p&gt;&lt;p&gt;　　影响范围最大的星座（参考太阳与上升星座）：白羊座、狮子座、射手座、水瓶座、双鱼座。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('80', '&lt;p&gt;如果某天你也成了相亲大军的一员，那就一定要学会这八个绝招，这样当你遇上心动男生时就不怕错失姻缘啦~&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160724/146935341163456057948dc337792.png&quot; alt=&quot;8心动绝招让男人拜倒裙下&quot;/&gt;8心动绝招让男人拜倒裙下&lt;/p&gt;&lt;p&gt;　　在崇尚自由恋爱的时代，大多数人不到万不得已都不会走上相亲这条老路，然而不得不承认的是，相亲确实是解决剩女问题最有效的方法之一。如果某天你也成了相亲大军的一员，那就一定要学会这八个绝招，这样当你遇上心动男生时就不怕错失姻缘啦！&lt;/p&gt;&lt;p&gt;　　注意一：首次见面一定要让他选地方&lt;/p&gt;&lt;p&gt;　　作为女人，有太多的主意会让男人觉得你想控制他，所以不要有太多的意见。他在电话里问你在什么地方见面，你就说：“听你的吧，哪里都可以啊。”这样一来，你不仅给他小鸟依人的感觉，而且把难题抛给他。&lt;/p&gt;&lt;p&gt;　　注意二：一定要比他晚到几分钟&lt;/p&gt;&lt;p&gt;　　相亲的女人一定不是二十啷当岁的小女孩儿吧，所以如果你到的比男人早，会让人觉得你特急，特上赶着，别听别人说什么准时到的女生给人感觉纯朴，都瞎掰。我们也不是不准时啊，如果他早到10分钟，我们正点到就好了，如果他正点到，我们就晚个两分钟喽~~怎么操作自己想办法。&lt;/p&gt;&lt;p&gt;　　注意三：点菜是个技巧&lt;/p&gt;&lt;p&gt;　　一定一定不要点贵的菜，尤其是你的约会对象是个钻石王老五的时候，他会觉得你想讹他。但是如果你点特便宜的菜他也许会觉得你以后上不了台面儿，所以意思到了就可以了，让他知道你不骄奢，但不是没吃过没见过。通常我的建议都是点一个青菜，很难出错。饮料嘛当然点酸奶喽，爱喝奶，可以让他浮想联翩哦~~&lt;/p&gt;&lt;p&gt;　　注意四：少说话多微笑&lt;/p&gt;&lt;p&gt;　　言多必失言多必失，一定要记住。哪怕他以后觉得你是个话痨，那是以后的事，第一次你也得给我忍住喽。淑女都是乖乖的坐在那里微笑。如果对方实在太不爱说话，而你又看上他了，就引出几个话题，如果他还是不怎么说话，你就讲个笑话给他，要这样说：“要不，我讲个笑话给你吧，你不许不笑哦。”即使你讲的不好听，他也会觉得你很可爱。&lt;/p&gt;&lt;p&gt;　　注意四：避开敏感话题&lt;/p&gt;&lt;p&gt;　　第一次见面就问人家交过几个女朋友，和前一个女朋友怎么分的手，太可怕了吧，太八婆了吧。记住：你是大家闺秀，那些问题留着以后慢慢知道也不迟。如果反过来他问你，你就说：“呀，你这么问我，我都有点不好意思了，以后慢慢告诉你好吗？”这样，一来你给他一个你想和她继续交往的讯号，二来他会觉得你很害羞，三来他还不会觉得你不实在，因为你没想隐瞒他，只是现在不想说而已。&lt;/p&gt;&lt;p&gt;　　注意五：表面看上去要很坦诚&lt;/p&gt;&lt;p&gt;　　虽然前面的几个小技巧都有点耍小心眼儿的意思，但是归根结底还是要让对方感觉你是很有诚意的，纯朴、老实都是男人认为老婆需要具备的素质，但是要知道老实和机灵并不冲突哦，千万别让人觉得你笨了巴叽的。比如你可以透露给他一些听上去很真诚但又无关痛痒的事情：“我特别爱睡懒觉，我妈妈说以后嫁了人要给老公做早点就不能睡懒觉了，呵呵~~”&lt;/p&gt;&lt;p&gt;　　注意六：时刻注意表情要娇羞&lt;/p&gt;&lt;p&gt;　　虽然现在娶个处女是很难的事，但男人都希望他的老婆没什么感情经历，如果你老盯着他看，他会心里发毛的，你可以在他看你的时候低下头，垂下眼，实在不会，就看看韩剧，里面的女主角个个都能装着呢~&lt;/p&gt;&lt;p&gt;　　注意七：您的手机准备好了吗&lt;/p&gt;&lt;p&gt;　　如果你和他初次见面就没完没了的有电话进来，是很让人烦的。但是如果你把手机改成震动被他发现他会不太舒服，如果你干脆放在书包里又让他觉得你肯定还有垫背的。所以把你的手机转移，大大方方的放在桌面 上，最好和你的好朋友约好，在中途给你发个短信，你也可以大大方方的告诉他是好朋友来的，一个电话没有一个短信没有也不太真实，是吧。&lt;/p&gt;&lt;p&gt;　　注意八：要适度的勾引&lt;/p&gt;&lt;p&gt;　　前面几条都做到了，只能说没有出什么错，但毕竟是要让他喜欢和你在一起啊，所以多少要勾引勾引他，据说，女孩子把手放在嘴边的时候最性感，你自己对着镜子练习一下吧：用白皙水嫩的手拿着饮料杯，喝完了再舔舔嘴唇，迷死他吧，不犯法的。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('81', '&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160724/146935344117426657948de10c361.png&quot; alt=&quot;12星座男能给你什么样的安全感&quot;/&gt;12星座男能给你什么样的安全感&lt;/p&gt;&lt;p&gt;　　恋爱中的女人，无疑是需要安全感的，而安全感的内容可以是不同的：男友温柔细心，对自己无尽呵护宠爱，让女人有安全感；男友勤勉上进，懂得为未来的美好生活奋斗、规划，让女人有安全感……那么，12星男又会带给恋人怎样的安全感呢？魔法星座即刻来揭晓！&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('82', '&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160724/146935347298148557948e0023c90.png&quot; alt=&quot;&quot;/&gt;&lt;/p&gt;&lt;p&gt;　　香港七星堂/文&lt;/p&gt;&lt;p&gt;　　眉也是面相学中的一种，也可以看出一个人的运势与否，看一个人能否带来好的运势，眉形也有影响，那么眉形要怎么样才是好的呢？下面来详细解析眉形看福气。&lt;/p&gt;&lt;p&gt;　　1，眉形长度比眼睛长有福气&lt;/p&gt;&lt;p&gt;　　眉毛无论是粗细还是长短，但是一定要顺，要比眼睛长，但是也不能太长，会对个人性格上有很大的反差，要适中，那才比较好，古人云：眉毛长过目为良相，本身也是如此，这是相学中针对眉毛中最基本的准则。除此之外，即使一个人的眉毛比较柔顺，但是也要看眉毛的光泽，也就是色泽，色泽上的深浅也有很大的讲究。&lt;/p&gt;&lt;p&gt;　　2，眉形以整齐为主有福气&lt;/p&gt;&lt;p&gt;　　毛色光润、整齐才是心理平衡、感情与理智并重的好相，眉毛长的人，体内荷尔蒙分泌正常，也代表父母的遗传良好，以前的相学家，还常以眉毛来看一个人兄弟姐妹多少，但是现在看兄弟姐妹是没法看，因为现在计划生育，一般的家庭兄弟姐妹也很少，一个，两个，甚至居多，三个往上几乎都少。&lt;/p&gt;&lt;p&gt;　　3，眉毛柔顺不宜太近有福气&lt;/p&gt;&lt;p&gt;　　眉毛太近的人过于计较，其为人比较自私一些，这种人不但烦恼多愁，性格也患得患失，相当疑神疑鬼，因此好机会都不能把握，尤其在自身的事业上体现最为明显，就算有贵人相助，内心的猜疑，也让自身难以在事业上有很好的发展眉毛如果是柔顺者，即可说明此人一生都顺利没有大起大落，且多半就是不愁烦恼，能够很看的开的人，一般不会纠结于一件事耿耿于怀的人。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('83', '&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160724/146935355878843857948e565a28d.png&quot; alt=&quot;科学家表示，如果能将猛犸象复活、重新引入生态系统之中，或许就能将冻原重新变回草原，从而将永久冻土层与大气隔离开来，阻止温室气体的逃逸。猛犸象约在1万年前从地球上灭绝。&quot;/&gt;　　科学家表示，如果能将猛犸象复活、重新引入生态系统之中，或许就能将冻原重新变回草原，从而将永久冻土层与大气隔离开来，阻止温室气体的逃逸。猛犸象约在1万年前从地球上灭绝。&lt;/p&gt;&lt;p&gt;　　新浪科技讯 北京时间7月21日消息，随着北极的永久冻土层不断融化，其中储存的远古时期的温室气体被逐渐释放出来，这可能会气候变化进一步加剧。但有一位“英雄”或许能帮助我们阻止这一进程。&lt;/p&gt;&lt;p&gt;　　科学家表示，如果能将猛犸象复活、重新引入生态系统之中，或许就能将冻原重新变回草原，从而将永久冻土层与大气隔离开来，阻止温室气体的逃逸。&lt;/p&gt;&lt;p&gt;　　猛犸象约在1万年前从地球上灭绝。但利用最新的DNA测序和基因编辑技术，我们或许在短短几年之内便能让它们起死回生。&lt;/p&gt;&lt;p&gt;　　据美国《大众杂志》(Popular Science)称，科学家有两种可以使猛犸象复活的方法。&lt;/p&gt;&lt;p&gt;　　一种是利用从远古生物身上收集的材料来克隆猛犸象。自从人们在一头名叫“毛毛”(Buttercup)的猛犸象尸体上找到了残留的组织之后，科学家就一直在尝试这一点。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160724/146935355835270857948e568caf4.png&quot; alt=&quot;自从人们在西伯利亚发现了一头名叫“毛毛”(Buttercup)的猛犸象尸体后，科学家就一直在尝试复活猛犸象。这头雌性猛犸象是在2013年5月发现的。它身高8英尺(约合2.4米)，死亡时年龄约为50岁，体型和现代大象差不多。&quot;/&gt;　　自从人们在西伯利亚发现了一头名叫“毛毛”(Buttercup)的猛犸象尸体后，科学家就一直在尝试复活猛犸象。这头雌性猛犸象是在2013年5月发现的。它身高8英尺(约合2.4米)，死亡时年龄约为50岁，体型和现代大象差不多。&lt;/p&gt;&lt;p&gt;　　这头雌性猛犸象是在2013年5月发现的。它身高8英尺(约合2.4米)，死亡时年龄约为50岁，体型和现代大象差不多。&lt;/p&gt;&lt;p&gt;　　虽然科学家认为“毛毛”是在陷入泥塘之后、被其它动物吃掉的，但它的大部分身体、三条腿、头部和鼻子都完好无损。&lt;/p&gt;&lt;p&gt;　　另一种复活猛犸象的方法是修改亚洲象的DNA，因为它是猛犸象仍未灭绝的近亲中与之最为相似的一种。&lt;/p&gt;&lt;p&gt;　　这些体型巨大的野兽一度是“猛犸大草原”上的主宰，这一草原生态系统曾占据了整个北半球。它们在草原上起到了至关重要的作用。作为食草生物，它们让树木在平原上无法生长，并在草原各处撒播营养物质。&lt;/p&gt;&lt;p&gt;　　如果猛犸象能够复活，这一生态系统也将得到修复，并阻止北极永久冻土层继续消融。&lt;/p&gt;&lt;p&gt;　　“由于缺乏猛犸象的帮助，冻土层不断上升，导致人类行为引发的气候变化进一步加剧。”该研究项目指出。&lt;/p&gt;&lt;p&gt;　　“如果没有草原将冻原的永久冻土层隔绝开来，永久冻土层就会消融，释放出其中已经储存了数十万年的温室气体。”&lt;/p&gt;&lt;p&gt;　　“全球的永久冻土层一旦消融，引发的后果相当于将全球的森林焚烧了2.5次。”&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160724/146935355870658157948e56b8fe5.png&quot; alt=&quot;虽然科学家认为“毛毛”是在陷入泥塘之后、被其它动物吃掉的，但它的大部分身体、三条腿、头部和鼻子都完好无损。&quot;/&gt;　　虽然科学家认为“毛毛”是在陷入泥塘之后、被其它动物吃掉的，但它的大部分身体、三条腿、头部和鼻子都完好无损。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160724/146935355871280457948e56e3bae.png&quot; alt=&quot;该项目指出，将亚洲象“改造”成猛犸象的过程主要分为三步。首先，他们需要让亚洲象具备在低温时提高血氧水平的能力。&quot;/&gt;　　该项目指出，将亚洲象“改造”成猛犸象的过程主要分为三步。首先，他们需要让亚洲象具备在低温时提高血氧水平的能力。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160724/146935355925684957948e573e8dd.png&quot; alt=&quot;其次，人们需要增加亚洲象的皮下脂肪，帮助它们度过没有食物的时期，最后还要让它们长出厚厚的皮毛。&quot;/&gt;　　其次，人们需要增加亚洲象的皮下脂肪，帮助它们度过没有食物的时期，最后还要让它们长出厚厚的皮毛。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160724/146935355942515557948e575dc89.png&quot; alt=&quot;虽然科学家认为“毛毛”是在陷入泥塘之后、被其它动物吃掉的，但它的大部分身体、三条腿、头部和鼻子都完好无损。&quot;/&gt;　　虽然科学家认为“毛毛”是在陷入泥塘之后、被其它动物吃掉的，但它的大部分身体、三条腿、头部和鼻子都完好无损。&lt;/p&gt;&lt;p&gt;　　该项目指出，将亚洲象“改造”成猛犸象的过程主要分为三步。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;　　首先，他们需要让亚洲象具备在低温时提高血氧水平的能力，还要增加亚洲象的皮下脂肪，帮助它们度过没有食物的时期，最后还要让它们长出厚厚的皮毛。&lt;/p&gt;&lt;p&gt;　　接下来，研究人员需要改造它们的成纤维细胞，让它们变成在实验室中“永远不会死亡”的诱导多能干细胞(iPSCs)。这样一来，就不需要培养新的细胞、或从胚胎开始培育了。&lt;/p&gt;&lt;p&gt;　　最后，这些干细胞将被培育成不同的组织，包括红细胞、脂肪和毛发等。他们还将在不同的条件下测试这些红细胞的携氧能力。&lt;/p&gt;&lt;p&gt;　　“我们复活猛犸象的终极目标是创造新的猛犸象，使欧亚大陆和北美的冻原和北部森林重获生机。”该项目指出。&lt;/p&gt;&lt;p&gt;　　“我们的目的并不是精确地复制出已经灭绝的猛犸象，而是努力研究亚洲象需要进行哪些改造、才能像猛犸象那样在冻原的寒冷气候中生存。从培育大象的身体组织，到基因编辑和克隆技术，这些都将是我们在研究之路上取得的里程碑。”(叶子)&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');
INSERT INTO `ebcms5_content_body` VALUES ('84', '&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160724/146935359129703157948e77096ba.png&quot; alt=&quot;2014年8月6日，欧空局任务控制中心，罗塞塔项目工作人员在接收到飞船成功入轨信号后兴奋不已&quot;/&gt;2014年8月6日，欧空局任务控制中心，罗塞塔项目工作人员在接收到飞船成功入轨信号后兴奋不已&lt;/p&gt;&lt;p&gt;　　新浪科技讯 北京时间7月19日消息，据英国广播公司(BBC)网站报道，两年前的2014年，全世界都被欧洲空间局的一艘小小飞船追逐并登陆一颗彗星的壮举所吸引，那么两年过去，今年9月份，这次探测任务就将接近尾声，我们在这次探测任务期间学习到了什么？&lt;/p&gt;&lt;p&gt;　　星际交会&lt;/p&gt;&lt;p&gt;　　经过10年的太空追逐，2014年11月12日，正在围绕67P彗星运行的欧洲空间局(ESA)“罗塞塔”探测器成功释放一艘小型着陆器“菲莱”(Philae)并成功降落在彗星表面。而现在，罗塞塔项目团队正在规划着更为复杂的举动：他们计划在2016年9月份，控制罗塞塔飞船本身直接撞击彗星。这将是欧洲空间局本次任务期间利用这艘出色的飞船采集彗星数据的最后机会。&lt;/p&gt;&lt;p&gt;　　但尽管罗塞塔任务逐渐临近尾声，本次任务已经让科学家们取得了一系列的新发现，揭示关于太阳系的诸多奥秘并拓展我们对于彗星的认识。&lt;/p&gt;&lt;p&gt;　　但是，罗塞塔飞船并非首个人类针对彗星的探测器。这个头衔属于1978年发射的“国际彗星探测器”(ICE)，它在1985年穿越了21P/Giacobini–Zinner彗星。但所罗塞塔飞船的确是首个围绕彗星运行的人类探测器，以及首个向彗星表明释放着陆器的探测器，菲莱是世界上首个成功降落在彗核表面的探测器。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160724/146935359154856557948e7727a4d.png&quot; alt=&quot;艺术示意图：着陆在彗星表面的“菲莱”着陆器&quot;/&gt;艺术示意图：着陆在彗星表面的“菲莱”着陆器&lt;/p&gt;&lt;p&gt;　　罗塞塔的发现&lt;/p&gt;&lt;p&gt;　　1) 关于地球起源&lt;/p&gt;&lt;p&gt;　　罗塞塔飞船发现彗星67P没有磁场。借助罗塞塔飞船和菲莱着陆器采集的数据，科学家们将能够排除一部分有关我们地球形成机制的候选理论。欧空局对比了罗塞塔飞船和菲莱着陆器在同一时间利用磁强计采集的磁场测量数据。数据显示67P彗星不存在自身磁场。这一结果不支持一项关于行星形成机制的理论，该理论认为磁场帮助将彗星物质聚集到一起，并最终成为构建原始行星的基本材料。&lt;/p&gt;&lt;p&gt;　　2) 关于生命起源&lt;/p&gt;&lt;p&gt;　　菲莱着陆器发现67P彗星上存在有机物质，其中包括一些此前从未在彗星上被探测到过的有机物成分。这是一项令人兴奋的发现，因为地球上所有生命都是由有机分子构成的，科学家们想要了解地球上最早的有机物质是否有可能是由彗星运送过来的。通过对类似67P这样彗星的研究，科学家们有望进一步加深对这一问题的理解。&lt;/p&gt;&lt;p&gt;　　3) 水的起源&lt;/p&gt;&lt;p&gt;　　罗塞塔飞船发现67P彗星上含有与地球不同的水。67P向外喷射的气体很多都是水汽。但罗塞塔飞船发现，相比地球水体，这些水体中氘的含量更高(氘是氢的同位素，其原子核中多了一个中子)。&lt;/p&gt;&lt;p&gt;　　此前科学家们一直认为彗星有可能是地球上最早水体的来源之一，当彗星撞击地球时就会为地球带来水体。但罗塞塔的发现显然让这个问题变得复杂化了。那么关于地球上水的起源是否还存在着其他的可能性呢？我们显然需要更多的探索。&lt;/p&gt;&lt;p&gt;　　4) 变化中的彗星表面&lt;/p&gt;&lt;p&gt;　　罗塞塔飞船发现67P彗星的地表处于时刻的变化之中。随着67P彗星逐渐接近太阳，罗塞塔团队开始观测到壮观的彗核活动现象。这是科学家们首次有能力近距离实地观察彗星上的水冰是如何变为水汽的。高分辨率图像显示彗星喷射的大量气体和尘埃云团都来自彗星表面巨大的塌陷空洞和悬崖崩塌过程，这也解释了为何彗核表面会如此千疮百孔。&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://www.ebcms.com/demo/v5/upload/image/20160724/146935359117762357948e7745a81.png&quot; alt=&quot;罗塞塔飞船近距离拍摄的彗核表面喷流&quot;/&gt;罗塞塔飞船近距离拍摄的彗核表面喷流&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p&gt;　　罗塞塔的谢幕演出&lt;/p&gt;&lt;p&gt;　　在2016年9月份，欧洲空间局计划为已经持续了20年之久的罗塞塔探测任务正式画上一个圆满的句号——他们将控制罗塞塔飞船，命令它直接撞向彗星表面。&lt;/p&gt;&lt;p&gt;　　随着彗星逐渐远离太阳，罗塞塔飞船的太阳能帆板能够接收到的太阳能电力将愈发萎缩，相对应的，飞船的各项功能也将逐渐受到影响。为此，科学家们决定让罗塞塔飞船缓慢下降到67P彗星表面，他们希望这样做将能够采集到分辨率更高的数据和图像——尽管是最后一次。&lt;/p&gt;&lt;p&gt;　　罗塞塔飞船上安装有远比着陆器“菲莱”强大的多的设备仪器。因此随着罗塞塔飞船逐渐下降高度，它搭载的相机和光谱仪将能够接收到最高分辨率的图像和各项其他数据。而关于彗星喷出的气体成分等等，随着距离的下降，其分析精度也将得到提升。&lt;/p&gt;&lt;p&gt;　　由于罗塞塔飞船很有可能将无法在这场命运的撞击之中幸存下来，科学家们决定让飞船一直持续采集数据，直到生命的最后一刻。(晨风)&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;');

-- ----------------------------
-- Table structure for ebcms5_content_category
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_content_category`;
CREATE TABLE `ebcms5_content_category` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父ID',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '名称',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `metatitle` varchar(255) NOT NULL DEFAULT '' COMMENT 'meta标题',
  `keywords` varchar(255) NOT NULL DEFAULT '' COMMENT '关键字',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT '简介',
  `extend_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '扩展id',
  `pagenum` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分页大小',
  `tpl` varchar(255) NOT NULL DEFAULT '' COMMENT '模板',
  `tpl_detail` varchar(255) NOT NULL DEFAULT '' COMMENT '内容页模板',
  `ebcms_url` varchar(255) NOT NULL DEFAULT '' COMMENT '外部链接',
  `datatype` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '读取内容',
  `expire` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '缓存时间',
  `order` varchar(255) NOT NULL DEFAULT 'id desc' COMMENT '排序',
  `ext` text COMMENT '扩展信息',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '状态',
  `locked` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否锁定',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COMMENT='内容栏目表';

-- ----------------------------
-- Records of ebcms5_content_category
-- ----------------------------
INSERT INTO `ebcms5_content_category` VALUES ('1', '0', 'news', '新闻', '', '', '', '0', '5', 'index_news', '', '', '0', '0', 'id desc', '{\"__config__\":{\"__test__\":\"test\"}}', '1468841939', '1468748433', '0', '1', '1');
INSERT INTO `ebcms5_content_category` VALUES ('2', '0', 'tiyu', '体育', '', '', '', '0', '5', 'index_news', '', '', '0', '0', 'id desc', '', '1468809624', '1468748443', '0', '1', '1');
INSERT INTO `ebcms5_content_category` VALUES ('3', '0', 'caijing', '财经', '财经', '', '', '0', '5', 'index_news', '', '', '0', '0', 'id desc', '{\"__config__\":{\"__test__\":\"test\"}}', '1469014379', '1468748463', '0', '1', '1');
INSERT INTO `ebcms5_content_category` VALUES ('4', '0', 'yule', '娱乐', '', '', '', '0', '5', 'index_news', '', '', '0', '0', 'id desc', '', '1468809611', '1468748480', '0', '1', '1');
INSERT INTO `ebcms5_content_category` VALUES ('5', '0', 'keji', '科技', '', '', '', '0', '8', 'index_news', '', '', '0', '0', 'id desc', '', '1468753447', '1468748492', '0', '1', '1');
INSERT INTO `ebcms5_content_category` VALUES ('7', '1', 'junshi', '军事', '军事哈哈哈哈', '', '', '1', '5', '', '', '', '1', '0', 'id desc', '{\"__config__\":{\"__test__\":\"test\"}}', '1469873596', '1468748523', '0', '1', '1');
INSERT INTO `ebcms5_content_category` VALUES ('8', '1', 'shehui', '社会', '', '', '', '0', '5', '', '', '', '1', '0', 'id desc', '', '1468752305', '1468748532', '0', '1', '1');
INSERT INTO `ebcms5_content_category` VALUES ('9', '1', 'guoji', '国际', '', '', '', '0', '5', '', '', '', '1', '0', 'id desc', '', '1468752309', '1468748540', '0', '1', '1');
INSERT INTO `ebcms5_content_category` VALUES ('10', '2', 'nba', 'NBA', '', '', '', '0', '5', '', '', '', '1', '0', 'id desc', '', '1468748553', '1468748553', '0', '1', '1');
INSERT INTO `ebcms5_content_category` VALUES ('11', '2', 'zhongchao', '中超', '', '', '', '0', '5', '', '', '', '1', '0', 'id desc', '{\"text\":\"自定义单行文本\",\"__config__\":{\"text\":\"text\",\"textarea\":\"textarea\",\"file\":\"file\",\"editor\":\"ueditor\",\"__test__\":\"test\"},\"textarea\":\"自定义多行文本\",\"file\":\"自定义文件上传\",\"editor\":\"<p>自定义编辑器。<br\\/><\\/p>\"}', '1468834879', '1468748568', '0', '1', '1');
INSERT INTO `ebcms5_content_category` VALUES ('12', '2', 'aoyun', '奥运', '奥运', '', '', '0', '5', '', '', '', '1', '0', 'id desc', '{\"__config__\":{\"__test__\":\"test\"}}', '1468900974', '1468748585', '0', '1', '1');
INSERT INTO `ebcms5_content_category` VALUES ('13', '3', 'gupiao', '股票', '', '', '', '0', '5', '', '', '', '1', '0', 'id desc', '', '1468748599', '1468748599', '0', '1', '1');
INSERT INTO `ebcms5_content_category` VALUES ('14', '3', 'jijin', '基金', '', '', '', '0', '5', '', '', '', '1', '0', 'id desc', '', '1468748610', '1468748610', '0', '1', '1');
INSERT INTO `ebcms5_content_category` VALUES ('15', '3', 'qihuo', '期货', '', '', '', '0', '5', '', '', '', '1', '0', 'id desc', '', '1468748618', '1468748618', '0', '1', '1');
INSERT INTO `ebcms5_content_category` VALUES ('16', '4', 'mingxing', '明星', '', '', '', '0', '5', '', '', '', '1', '0', 'id desc', '', '1468748640', '1468748640', '0', '1', '1');
INSERT INTO `ebcms5_content_category` VALUES ('17', '4', 'dianying', '电影', '', '', '', '0', '5', '', '', '', '1', '0', 'id desc', '', '1468748652', '1468748652', '0', '1', '1');
INSERT INTO `ebcms5_content_category` VALUES ('18', '4', 'xingzuo', '星座', '', '', '', '0', '5', '', '', '', '1', '0', 'id desc', '', '1468748664', '1468748664', '0', '1', '1');
INSERT INTO `ebcms5_content_category` VALUES ('19', '5', 'shouji', '手机', '', '', '', '0', '5', '', '', '', '1', '0', 'id desc', '', '1468748682', '1468748682', '0', '1', '1');
INSERT INTO `ebcms5_content_category` VALUES ('20', '5', 'tansuo', '探索', '', '', '', '0', '5', '', '', '', '1', '0', 'id desc', '', '1468748693', '1468748693', '0', '1', '1');

-- ----------------------------
-- Table structure for ebcms5_content_comment
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_content_comment`;
CREATE TABLE `ebcms5_content_comment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT '评论人id',
  `touid` int(11) DEFAULT '0' COMMENT '回复对象id',
  `topid` int(11) unsigned DEFAULT '0' COMMENT '顶级评论id',
  `tid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '内容id',
  `pid` int(11) NOT NULL DEFAULT '0' COMMENT '父评论id',
  `content` text NOT NULL COMMENT '评论内容',
  `update_time` int(10) NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '状态',
  `locked` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '锁定',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '推荐',
  `ip` varchar(255) NOT NULL DEFAULT '' COMMENT 'ip地址',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=121 DEFAULT CHARSET=utf8 COMMENT='内容评论表';

-- ----------------------------
-- Records of ebcms5_content_comment
-- ----------------------------
INSERT INTO `ebcms5_content_comment` VALUES ('4', '1', '0', '0', '59', '0', '下辈子投胎美利坚，长高长长5公分。', '1469093202', '1469093202', '99', '0', '0', '127.0.0.1');
INSERT INTO `ebcms5_content_comment` VALUES ('5', '1', '0', '0', '59', '0', '全国人民感谢阀盖萎的关怀！', '1469093222', '1469093222', '1', '0', '0', '127.0.0.1');
INSERT INTO `ebcms5_content_comment` VALUES ('6', '1', '0', '0', '59', '0', '一个月三箱油，才15块，你太大方了。', '1469093229', '1469093229', '1', '0', '0', '127.0.0.1');
INSERT INTO `ebcms5_content_comment` VALUES ('7', '1', '0', '0', '59', '0', '上调一次0.5元，下调一次0.1元，我们还要千恩万谢！', '1469093236', '1469093236', '1', '0', '0', '127.0.0.1');
INSERT INTO `ebcms5_content_comment` VALUES ('8', '1', '0', '0', '59', '0', '等我先去吃个肯德基压压惊', '1469093241', '1469093241', '1', '0', '0', '127.0.0.1');
INSERT INTO `ebcms5_content_comment` VALUES ('9', '1', '0', '0', '59', '0', '谢主隆恩', '1469093248', '1469093248', '1', '0', '0', '127.0.0.1');
INSERT INTO `ebcms5_content_comment` VALUES ('10', '1', '0', '0', '59', '0', '感谢党，感谢组织，感谢国家！', '1469093253', '1469093253', '1', '0', '0', '127.0.0.1');
INSERT INTO `ebcms5_content_comment` VALUES ('11', '1', '0', '0', '59', '0', '多大排量的一箱省5元?雅马哈125的一箱吗', '1469093258', '1469093258', '1', '0', '0', '127.0.0.1');
INSERT INTO `ebcms5_content_comment` VALUES ('12', '1', '0', '0', '59', '0', '呵呵！不要看新闻！看我！赞我！', '1469093263', '1469093263', '1', '0', '0', '127.0.0.1');
INSERT INTO `ebcms5_content_comment` VALUES ('13', '1', '0', '0', '59', '0', '为了不为难小编。我只能说这价格挺好的，感谢档 感谢祖国', '1469093271', '1469093271', '1', '0', '0', '127.0.0.1');
INSERT INTO `ebcms5_content_comment` VALUES ('14', '1', '0', '0', '59', '0', '尼玛昨天才加了了100害我多花1.6块钱', '1469093276', '1469093276', '1', '0', '0', '127.0.0.1');
INSERT INTO `ebcms5_content_comment` VALUES ('15', '1', '0', '0', '59', '0', '全国人民感谢阀盖萎的关怀！', '1469093282', '1469093282', '1', '0', '0', '127.0.0.1');
INSERT INTO `ebcms5_content_comment` VALUES ('16', '1', '0', '0', '59', '0', '屁民喜迎油价“调低”', '1469093287', '1469093287', '1', '0', '0', '127.0.0.1');
INSERT INTO `ebcms5_content_comment` VALUES ('17', '1', '0', '0', '59', '0', '为什么降价？瞧不起我没钱吗？', '1469093292', '1469093292', '1', '0', '0', '127.0.0.1');
INSERT INTO `ebcms5_content_comment` VALUES ('18', '1', '0', '0', '59', '0', '早就应该降。 人外国油那么便宜 你倒是好意思', '1469093297', '1469093297', '1', '0', '0', '127.0.0.1');
INSERT INTO `ebcms5_content_comment` VALUES ('19', '1', '0', '0', '59', '0', '为了不为难小编。我只能说这价格更挺好的，感谢档 感谢祖国。', '1469093305', '1469093305', '1', '0', '0', '127.0.0.1');
INSERT INTO `ebcms5_content_comment` VALUES ('20', '1', '0', '0', '59', '0', 'NMGB的发改委', '1469093311', '1469093311', '1', '0', '0', '127.0.0.1');
INSERT INTO `ebcms5_content_comment` VALUES ('21', '1', '1', '20', '59', '20', '今天去加油站加油，我说加300，加油站员工偷偷告诉我说，加100吧，明天油价要降了。这真是世上最有良心的加油工啊！！！', '1469093330', '1469093330', '1', '0', '0', '');
INSERT INTO `ebcms5_content_comment` VALUES ('22', '1', '1', '20', '59', '20', '太好了，有希望了', '1469093338', '1469093338', '0', '0', '0', '');
INSERT INTO `ebcms5_content_comment` VALUES ('23', '1', '1', '20', '59', '20', '谢主隆恩', '1469093345', '1469093345', '1', '0', '0', '');
INSERT INTO `ebcms5_content_comment` VALUES ('24', '1', '1', '20', '59', '20', '傻逼发改委，同意的顶', '1469093353', '1469093353', '1', '0', '0', '');
INSERT INTO `ebcms5_content_comment` VALUES ('25', '1', '1', '19', '59', '19', '谢主隆恩', '1469093362', '1469093362', '1', '0', '0', '');
INSERT INTO `ebcms5_content_comment` VALUES ('26', '1', '1', '18', '59', '18', '能省一桶方便面了', '1469093371', '1469093371', '1', '0', '0', '');
INSERT INTO `ebcms5_content_comment` VALUES ('27', '1', '1', '20', '59', '23', '一箱省五块，等于没变', '1469093383', '1469093383', '1', '0', '0', '');
INSERT INTO `ebcms5_content_comment` VALUES ('28', '1', '1', '20', '59', '23', '省了五块钱，这个月又可以进入小康生活了。', '1469093405', '1469093405', '1', '0', '0', '');
INSERT INTO `ebcms5_content_comment` VALUES ('29', '1', '1', '20', '59', '23', '好便宜呀，感谢国家，感谢祖国，降价这么多', '1469093474', '1469093474', '1', '0', '0', '');
INSERT INTO `ebcms5_content_comment` VALUES ('59', '1', '0', '0', '59', '0', '龛看阿斯顿', '1469158499', '1469158499', '1', '0', '0', '127.0.0.1');
INSERT INTO `ebcms5_content_comment` VALUES ('60', '1', '0', '0', '59', '0', '收盘,伦敦洲际交易所布伦特原油期货结算价报48.18美元,WTI原油期货结算价报47.6美元；纽约商品交易所原油期货结算价收报45.45美元,相比6月8日的51.23美元,下跌幅度为11.28%。\r\n\r\n', '1469158509', '1469158509', '1', '0', '1', '127.0.0.1');
INSERT INTO `ebcms5_content_comment` VALUES ('61', '1', '1', '59', '59', '59', '原油期货结算价报48.18美元,WTI原油期货结算价报47.6美元；纽约商品交易所原油期货结算价收报45.45美元,相比6月8日的51.23美元,下跌幅度为11.28%。', '1469238689', '1469238689', '1', '0', '0', '');
INSERT INTO `ebcms5_content_comment` VALUES ('62', '1', '1', '19', '59', '25', 'asdfasdfsadfasfd', '1469240228', '1469240228', '1', '0', '0', '');
INSERT INTO `ebcms5_content_comment` VALUES ('63', '1', '1', '59', '59', '59', 'asdfasdfasdf', '1469240305', '1469240305', '1', '0', '0', '');
INSERT INTO `ebcms5_content_comment` VALUES ('64', '1', '1', '59', '59', '63', 'sdfasdfasd', '1469240377', '1469240377', '1', '0', '0', '');
INSERT INTO `ebcms5_content_comment` VALUES ('65', '1', '1', '59', '59', '63', 'asdfasdfasdf', '1469240471', '1469240471', '1', '0', '0', '');
INSERT INTO `ebcms5_content_comment` VALUES ('66', '1', '1', '59', '59', '63', 'asdfdfasdfasdf', '1469240551', '1469240551', '1', '0', '0', '');
INSERT INTO `ebcms5_content_comment` VALUES ('87', '1', '1', '16', '59', '16', '民喜迎油价“调低”', '1469243945', '1469243945', '1', '0', '0', '');
INSERT INTO `ebcms5_content_comment` VALUES ('88', '1', '1', '9', '59', '9', '谢主隆恩', '1469243956', '1469243956', '1', '0', '0', '');
INSERT INTO `ebcms5_content_comment` VALUES ('89', '0', '1', '8', '59', '8', '吃个肯德基压压惊', '1469228861', '1469228861', '1', '0', '0', '');
INSERT INTO `ebcms5_content_comment` VALUES ('90', '1', '1', '7', '59', '7', '感谢党感谢国家感谢社会主义', '1469452814', '1469452814', '0', '0', '0', '');
INSERT INTO `ebcms5_content_comment` VALUES ('91', '1', '1', '7', '59', '7', '感谢党感谢国家感谢社会主义', '1469452829', '1469452829', '1', '0', '0', '');
INSERT INTO `ebcms5_content_comment` VALUES ('92', '1', '0', '0', '59', '0', '交易所布伦特原油期货结算价报48.18美元,WTI原油期货结算价报47.6美元；纽约商品交易所原油期货结算价收报45.45美元,相比6月8日的51.23美元,下跌', '1469849512', '1469849512', '1', '0', '0', '127.0.0.1');
INSERT INTO `ebcms5_content_comment` VALUES ('93', '1', '1', '92', '59', '92', '结算价报48.18美元,WTI原油期货结算价报47.6美元；纽约商品交易所原油期货结算价收报45.45美元,相比6月8日的51.23美元,下跌', '1469849526', '1469849526', '1', '0', '0', '');

-- ----------------------------
-- Table structure for ebcms5_content_content
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_content_content`;
CREATE TABLE `ebcms5_content_content` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分类id',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `shorttitle` varchar(255) NOT NULL DEFAULT '' COMMENT '短标题',
  `metatitle` varchar(255) NOT NULL DEFAULT '' COMMENT 'META标题',
  `keywords` varchar(255) NOT NULL DEFAULT '' COMMENT '关键字',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT '简介',
  `thumb` varchar(255) NOT NULL DEFAULT '' COMMENT '缩略图',
  `tpl` varchar(255) NOT NULL DEFAULT '' COMMENT '模板',
  `ebcms_url` varchar(255) NOT NULL DEFAULT '' COMMENT '外部链接',
  `filename` varchar(255) NOT NULL DEFAULT '' COMMENT '文件名称',
  `ext` text COMMENT '扩展信息',
  `click` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '点击量',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `baidu` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否被百度收录',
  `comment_able` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否允许评论',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '99' COMMENT '状态',
  `locked` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '锁定',
  `color` varchar(255) NOT NULL DEFAULT '' COMMENT '字体颜色',
  `size` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '字号',
  `bold` varchar(255) NOT NULL DEFAULT '' COMMENT '加粗',
  PRIMARY KEY (`id`),
  KEY `list` (`category_id`,`status`,`id`),
  KEY `list2` (`status`,`id`)
) ENGINE=MyISAM AUTO_INCREMENT=89 DEFAULT CHARSET=utf8 COMMENT='内容基本表';

-- ----------------------------
-- Records of ebcms5_content_content
-- ----------------------------
INSERT INTO `ebcms5_content_content` VALUES ('1', '7', '美国海军作战部长紧急访华谈南海问题 登辽宁舰', '', '', '', '外媒称，美国海军14日宣布，海军作战部长约翰·理查森上将即将访问中国，以探讨南中国海安全事宜。　　据美国《星条旗报》网站7月14日报道，一份海军新闻稿说，理查森在三天访问期间将参观中国人民解放军海军设施，并与解放军海军司令员吴胜利上将举行会晤。　　除南中国海议题外，两位上将预计还将探讨其他争议性较小的议题，包括最近举行的“环太平洋”联合军事演习。　　理查森将于7月17日起访问北京和青岛。这是他首次访华。　　', '', '', '', '', '{\"price\":\"\",\"param\":{\"__config__\":{\"__test__\":\"test\"}}}', '19', '0', '0', '1', '1469931819', '1468748963', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('2', '7', '土耳其封锁驻土美空军基地 白宫举行紧急会议', '', '', '', '土耳其7月15日晚发生一起未遂军事政变，导致至少161人死亡和1440人受伤。16日，土政府指责流亡美国的土耳其宗教人士费特胡拉·居伦（Fethullah Gulen）在幕后策划这次政变，使土美关系出现紧张迹象，并封锁了美国在土耳其的空军基地，白宫为此召开紧急会议。    据俄罗斯卫星新闻网17日报道，美国驻土耳其领事馆16日说，在发生军人政变后，美国在土耳其南部的因斯里克空军基地被封锁，基地电力供应也被切断。美国官员称，因土耳其领', '', '', '', '', '{\"price\":\"\",\"param\":{\"__config__\":{\"__test__\":\"test\"}}}', '30', '0', '0', '1', '1470447815', '1468749007', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('3', '7', '中美一旦在南海开战 中国胜算到底有多大？', '', '', '', '最近美帝国主义两艘航母战斗群公然闯入南海，耀武扬威的嘴脸令人发指，再加上南海仲裁对中国非常不利，这两件事牵动了无数中国人的心，一时间中美开战的舆论“甚嚣尘上”。如果因为南海问题真的打起来了，中国的胜算有几何？得出结论之前，先做如下考虑：第一，孰叫胜，孰叫败？现代的战争，军事上的胜败远不是最终的评判标准。最终的评判标准，应该是谁在战争中获取了更多的政治利益和战略利益！第二，战争的形式问题。毫无疑问，', '', '', '', '', '{\"price\":\"\",\"param\":{\"__config__\":{\"__test__\":\"test\"}}}', '5', '0', '0', '1', '1470447812', '1468749054', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('4', '7', '蔡英文不登太平岛 台渔民要自己去宣示“主权”', '', '', '', '针对所谓的南海“仲裁结果”，太平岛被认定为是礁，台湾渔民自组船队预订20日开往太平岛登岛护权。台“海岸巡防署”16日也派出千吨级的巡防救难舰“台东舰”前往太平岛，接替“伟星舰”执行巡弋护渔任务。    据台湾《联合报》报道，所谓南海“仲裁结果”引起岛内渔民的强烈反弹。“判决实在太不公平了”东港籍海吉利号渔船船主郑春忠表示，太平岛怎么可能是礁？一出领海就是别人的经济海域，以后怎么去捕鱼，既然台当局力', '', '', '', '', '{\"price\":\"\",\"param\":{\"__config__\":{\"__test__\":\"test\"}}}', '0', '0', '0', '1', '1469931812', '1468749074', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('5', '7', '美部署萨德卡住我导弹命门？反送火箭军新目标', '', '', '', '　　经过多年的讨价还价，美韩还是在7月8日敲定了部署“萨德”（THAAD：末段高空区域防御系统）到韩国的具体地点，当然了目前所有消息都认为这是美国的一次战略上的胜利。尤其是“萨德”本身2000公里探测距离，将会让中国东部的远程弹道导弹都处于美国反导网络侦测范围内，而这一带正好是中国对美洲大陆进行核打击的“东风-31”弹道导弹的发射阵地。这不等于卡主了中国“东风”导弹的命门了吗？实际上并非如此，美国如此急迫的把自己又', '', '', '', '', '{\"price\":\"\",\"param\":{\"__config__\":{\"__test__\":\"test\"}}}', '2', '0', '0', '1', '1469931809', '1468749113', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('6', '7', '战死一个亿，也要保住南海所有岛屿！', '', '', '', '导言： 新华社快讯：菲律宾 南海 仲裁案仲裁庭１２日作出非法无效的所谓最终裁决。对此，中方多次声明，菲律宾共和国阿基诺三世政府单方面提起仲裁违背国际法，仲裁庭没有管辖权，中国不接受，不承认。 　　美国曾经遇到此类所谓的判决，靠的强大的军事机器让胜诉者执行不了，对于中国来说，若菲国不撤诉，就不要指望与中国合作解决经济困境的问题，就象尼加拿瓜一样，没打一仗就象得到岛屿与土地，这个是不可能的，美国就是靠打', '', '', '', '', '{\"price\":\"\",\"param\":{\"__config__\":{\"__test__\":\"test\"}}}', '18', '0', '0', '1', '1470447809', '1468749135', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('7', '7', '南海仲裁，中国被上了生动的一课', '', '', '', '海牙国际法庭所谓的南海仲裁案终于公布了，结果中国被置于彻底否定和相当不利的地位。这件事当然不能就此了结，相反，这恐怕只是一个开始，不要说接下来会不会有具体执行的，仅就这项裁决本身而言，也注定要成为中国头上的一个“紧箍咒”，被“国际社会”用来时时地敲打中国。预计，在今后与美国进一步“良性互动”，“深化互信，增强合作”的诸般过程中，中国将始终摆脱不了这方面的讹诈，美国将时时、处处、事事借仲裁要挟中国，', '', '', '', '', '{\"price\":\"\",\"param\":{\"__config__\":{\"__test__\":\"test\"}}}', '7', '0', '0', '1', '1470447807', '1468749158', '0', '1', '0', '#d9534f', '0', '900');
INSERT INTO `ebcms5_content_content` VALUES ('8', '7', '韩国称中国核弹技术还不如印度', '', '', '', '中国已经多年没有进行过核弹核爆试验，那么现在中国核力量到达是个什么水平，就引发了网友的关心和热议。　　由于中国一直都不愿意公开谈论中国本身装备的核弹数量，威力等等细节，因此外界对此也是有各式各样的猜测。　　韩国认为评价核弹技术的一个重要指标是核弹小型化技术，在这个方面中国没有优势，还不如印度。只有核弹小型化，才能缩小洲际导弹的尺寸，或者搭载更多的探测设备和燃料。按韩国的数字，美国核弹头仅有110公斤，', '', '', '', '', '{\"price\":\"\",\"param\":{\"__config__\":{\"__test__\":\"test\"}}}', '6', '0', '0', '1', '1470447826', '1468749206', '0', '1', '0', '#d9534f', '0', '900');
INSERT INTO `ebcms5_content_content` VALUES ('9', '7', '俄罗斯为何拼命想卖给中国战略武器', '', '', '', '最近，俄罗斯媒体一直在吹风，一会要把原来俄罗斯的超级航母技术卖给中国，一会又要卖给中国核潜艇，这和过去毛子卖给中国武器的态度完全不同，俄罗斯媒体为何突然吹这个风呢？在占豪看来，主要应该是基于三方面原因：一、经济压力所迫。由于俄罗斯经济陷入衰退，俄罗斯2016年的军事预算削减了5%，这种压力对俄罗斯来说非常大，那么出售装备给中国就是维系其军工企业运营和升级的关键。然而，现在中国军事实力也上来了，一般', '', '', '', 'feiji', '{\"price\":\"\",\"param\":{\"__config__\":{\"__test__\":\"test\"}},\"xxx1\":\"\"}', '12', '0', '0', '1', '1470447804', '1468749226', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('11', '7', '归国华人诉说真实的印度：我是吐着回来的', '', '', '印度,印度电影,印度神油,印度尼西亚,印度舞蹈,印度性与艺术照片,印度电影大全,印度吧,印度人看中国,印度罕见连体婴降生,印度妓女村', '最近关于印度的话题很火，今年因为工作关系我在印度呆了半年，所以对印度的情况相对了解一点，又发现国内的很多同志们对印度并不很清楚，所以向大家介绍下我在印度的感受。1、基本建设真的是糟糕透顶。我在印度坐十个小时的火车，沿途就没看到过任何令人赏心悦目的建筑，到处都是一片破败的景象。说他们基本建设落后我们30年绝不为过。而且在十个小时的火车中，我也没有看到任何工厂!很奇怪吧!火车包括火车站也是超级破烂，印度的大', '', '', '', '', '{\"price\":\"12\",\"param\":{\"__config__\":{\"__test__\":\"test\"}},\"xxx1\":\"\"}', '125', '0', '0', '1', '1471055058', '1468749288', '0', '1', '1', '', '0', '600');
INSERT INTO `ebcms5_content_content` VALUES ('12', '8', '商人村官被指身背2亿巨债跑路 事发前仍在防汛', '', '', '', '让拥有一定资产的能人、富人走上村干部岗位，曾被当成发展农村经济的捷径，在江苏乃至全国遍地开花。然而，在“老板村官”为农村面貌带来改变的同 时，一些问题也随之暴露。今年5月，南通海门明星村官叶剑生疑因身陷债务纠纷服下化学物品。时隔两个月，常州也发生类似情况，一村支书因身缠巨债与外界失 联。现代快报记者历时数日调查，从个案到现象，尝试找出“老板村官”频繁出事的潜在原因。知名社会学专家邱建新在接受现代快报记', '', '', '', '', '', '3', '0', '0', '1', '1469931786', '1468749372', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('13', '8', '仨熊孩子偷葫芦 被抓后称想当葫芦娃有错吗', '', '', '', '正值暑假，安徽阜阳3男孩在家看动画《葫芦娃》，一时兴起想“扮”葫芦娃玩儿。于是他们走到村里一处葫芦地，顺手偷了几个葫芦，“扮起”葫芦娃。民警找来家长，协商赔偿了农民伯伯的损失。男孩不解：“想当葫芦娃有错吗？”@@中警安徽', '', '', '', '', '', '12', '0', '0', '1', '1469931783', '1468749388', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('14', '8', '男子一天遭14000通电话骚扰 被令花300元换清净', '', '', '', '记者 左燕燕 实习生 龚晨霞　　“遭遇‘呼死你’软件攻击，一分钟5个电话，一小时600个电话，一天14000多个电话，持续一天了，微信转账300元才能停止骚扰”。昨日，网友聂先生发微博称。　　通讯专家向重案组37号(微信号：zhonganzu37)解释，针对这种情况，可下载一些拦截软件，通过设置拦截无主叫号码电话，便可脱离困扰。警方则建议市民遇到上述情况，可立即报警求助。　　莫名遭遇一天14000多无主电话骚扰　　7月15日下午五点，互联网产品公', '', '', '', '', '', '26', '0', '0', '1', '1469931780', '1468749414', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('15', '8', '男子疑因未给女友买到电影票跳楼身亡', '', '', '', '网友视频爆料，“广东大沥新都会一男子的女友要换电影票，工作人员不让，男子就跟工作人员吵了起来，随后从6楼跳下”。对此佛山市公安局南海分局称，事发7月14日，地点是南海大沥新都会商场，男子跳楼原因仍在调查。网友：为什么把命看得那么淡[蜡烛]', '', '', '', '', '', '7', '0', '0', '1', '1469931775', '1468749435', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('16', '8', '男子因争执纵火致4死 遇害内地母女来港仅5日', '', '', '', '据香港《文汇报》7月17日报道，香港西区观龙楼昨天（16日）凌晨发生骸人听闻纵火及凶杀案。独居6旬老汉因噪音与一邻居积怨，争执后有人突向对方住所掷燃烧弹纵火，邻居一家三口惨遭灭门，其中持单程证（又称前往港澳通行证，为公安部门发给有条件的申请人赴港澳地区定居的证件--观察者网注）来港团聚仅5日的妻子及年仅3岁半女儿相拥葬身火海，男户主全身着火坠楼死亡，疑凶后折返再纵火自焚同丧黄泉。警方港岛总区重案组已接手调查惨', '', '', '', '', '', '7', '0', '0', '1', '1469931777', '1468749458', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('17', '8', '富豪遭12人打死 曾穿7斤重黄金T恤炫富(图)', '', '', '', '据港媒报道，爱金成狂的印度宾布里富豪普盖（Datta Phuge）周四遇袭身亡，12名嫌犯手持镰刀和石头对其痛殴，普盖送医后死亡。警方随后拘捕5名疑犯，其中一人为普盖的侄儿，事件怀疑与金钱纠纷有关。　　事发于周四晚上，48岁的普盖与22岁儿子获邀出席一个生日派对，当他们开车抵达派对地点后，袭击者把普盖从座驾里拉了出来，有指12名疑犯用镰刀和大石殴打普盖至死。普盖22岁儿子舒布汉驾驶另一辆车子从旁经过，目击整场袭击，但未受攻击', '', '', '', '', '', '16', '0', '0', '1', '1469931772', '1468749480', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('18', '8', '男子因琐事将妻子岳母杀害 女儿呼救被关进厨房', '', '', '', '华商报汉中讯（记者周金柱）6月25日晚9时许，南郑县青树镇冉家营村发生惨剧：上门女婿罗某因琐事与妻子发生口角，将妻子和岳母残忍杀害。行凶过程中，女儿一度呼救，却被他关进厨房后继续行凶。　　7月13日上午，在南郑县青树镇冉家营村杨明志家，9岁的孙女躲在他身后一语不发。杨明志说，当时他正在镇上工地打工，听孙女电话里说“妈妈和奶奶都被爸爸砍倒了”，就赶紧骑摩托车赶回家，发现老伴和女儿躺在院子里，已没有了呼吸，周围', '', '', '', '', '', '14', '0', '0', '1', '1469931853', '1468749557', '0', '1', '0', '#428bca', '0', '900');
INSERT INTO `ebcms5_content_content` VALUES ('19', '8', '男子打飞的向前女友求爱遭拒换对方家锁芯', '', '', '', '重庆商报讯 日前，合川区公安局云门派出所接到群众报警，称他家里进去了一名陌生男子，怀疑是小偷。民警迅速赶到现场，发现了擅自闯入的年轻男子倪某。经了解，倪某今年23岁，浙江温州人，与居住在该处的李某曾是男女朋友。后来两人分手，但倪某一直放不下这段感情。为挽回李某，倪某买了一堆礼物，从工作地广东打飞的来到重庆，找到了李某的住处。面对“从天而降”的前男友，李某当场婉拒了，随后便藏身朋友家“玩失踪”。倪某则找', '', '', '', '', '', '39', '0', '0', '1', '1469931766', '1468749583', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('20', '8', '小伙拿工资买车票发现12张假钞 疑工厂发放(图)', '', '', '', '据中山电视台《城市零距离》报道，在广东中山古镇打工的汪先生向我们报料，说工厂给他的工资中有假钱，他数了一下，竟然有12张之多！　　事情还要从7月11日说起，当时汪先生去广州火车站买车票，打算坐火车去浙江找工作。“我是拿两张100元钞票出来，因为它是200元的车票，售票员说这钱是假的，然后叫我换几张。”　　汪先生于是又从钱包里重新拿了四张百元钞票出来，谁知道还是被告知是假的。汪先生赶紧清点自己的钱，发现类似这样的', '', '', '', '', '', '51', '0', '0', '1', '1469931764', '1468749606', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('21', '9', '外国人问中国为何无颜色革命 中国姑娘回答获赞', '', '', '', '网站截图　　这个犀利、理直气壮甚至十分粗鲁的问题，来自Quora上一位不知名人士。Quora类似知乎，是美国知名的问答平台。　　一年多来，超过100名网友给出了答案，美国人、印度人、挪威人以及海外华人……长期受到西方媒体轰炸的他们，却道出了风格各异的精彩见解，一个上海姑娘的短文配图更是获赞两万。　　7月13日，微博网友@天涯尼丹小 发现了这些回答，他感叹这简直是在“用论文方式给题主洗脑”，读书人现在干嘛要造反？中国人为何', '', '', '', '', '', '1', '0', '0', '1', '1469931761', '1468749638', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('22', '9', '日本前首相鸠山:南海问题应由当事方对话解决', '', '', '', '新华社北京7月16日电  日本前首相鸠山由纪夫16日回答新华社记者提问时说，南海问题应该由当事方通过对话与合作解决，不应该从外部施加压力要求中国和菲律宾接受仲裁结果。　　鸠山说：“南海问题应该由中国与菲律宾来解决，据说新上任的菲律宾总统也想开始与中国对话。我不希望看到，有外部压力利用这个事情一个劲地挑衅对方。”　　当天，鸠山在北京举行的第五届世界和平论坛上发表了演讲。　　在谈到菲律宾南海仲裁案临时仲裁庭', '', '', '', '', '', '8', '0', '0', '1', '1469931759', '1468749657', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('23', '9', '土耳其军方：上百名叛乱分子被杀', '', '', '', '[土军方：上百名叛乱分子被杀]BBC报道，土耳其军方代理参谋长表示，104名叛乱分子被杀。此前报道中提到的在政变中死亡的90人中，包括41名警察、47名平民和两名士兵。目前，军事政变造成的死亡人数已超过190人', '', '', '', '', '', '24', '0', '0', '1', '1471343143', '1468749675', '0', '1', '0', '#d9534f', '0', '900');
INSERT INTO `ebcms5_content_content` VALUES ('24', '9', '亚美尼亚首都警察局遭袭击 当局驳斥政变传闻', '', '', '', '　　#环球快讯# [亚美尼亚首都警方大楼被占领 当局驳斥“政变”传闻]据外电报道，亚美尼亚安全部门官员7月17日说，首都埃里温一警察局遭一队与被拘禁反对派领导有关的武装部队袭击，并劫持了多名人 质。人质中包括警察局副局长。政府和武装部队的谈判正在进行，不过当局已驳斥了政变传闻。', '', '', '', '', '', '4', '0', '0', '1', '1469931753', '1468749695', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('25', '10', '美媒:10大理由让詹皇无法再夺冠 西部对手太强', '', '', '', '北京时间7月17日，今年NBA总决赛，勒布朗-詹姆斯带领骑士完成了历史性的逆转，并夺得总冠军。在不少人看来，今年31岁的詹姆斯有望夺得更多的总冠军，但是cheatsheet网站却列出了詹姆斯无法再夺冠的十点理由，前提是他一直留在骑士队。　　10）东部正在变强　　在过去长达十年的时间里，东部已经成为了詹姆斯的“私人后花园”。他已经赢得了3个NBA总冠军，而且连续6次参加总决赛。但是这种局面可能不会维持太久。今夏，凯尔特人签下了艾尔-霍', '', '', '', '', '', '4', '0', '0', '1', '1469931750', '1468749727', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('26', '10', '曝绿军已放弃追逐格里芬 他身上藏着2大隐患', '', '', '', '新浪体育讯　　北京时间7月16日，据《波士顿先驱报》报道，最近，有关凯尔特人仍然希望补强并且可能通过交易得到球星的消息成为一大热门，而跟绿军联系紧密的其中一个巨星，就是快船核心布雷克-格里芬。但最新消息显示，凯尔特人方面对于格里芬并没有太大的兴趣，除了他的合同之外，还有另外一个因素。　　根据此前的报道，凯尔特人曾经希望通过引入第三方来跟快船进行有关格里芬的交易，而这第三方很有可能会是国王队，他们最近在', '', '', '', '', '', '3', '0', '0', '1', '1469931742', '1468749747', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('27', '10', '莱利:韦德离开让我震惊 他走后我们还没交流过', '', '', '', '新浪体育讯　　北京时间7月17日，迈阿密热火队总裁帕特-莱利今天召开了一场新闻发布会，并主要谈论了热火在今夏的运作。发布会上，莱利坦言德维恩-韦德离开热火让他“大感震惊”。　　今年夏天，虽然热火队留住了白边，但是他们没有追到第一目标凯文-杜兰特，而且还流失了队魂韦德。　　“我们经历了一个艰难的夏天，就是这样。”帕特-莱利告诉在场的记者。　　“发生在德维恩身上的事情让我大感震惊。”　　今夏自由球员市场上，韦', '', '', '', '', '', '15', '0', '0', '1', '1470408255', '1468749765', '0', '1', '0', '#d9534f', '0', '900');
INSERT INTO `ebcms5_content_content` VALUES ('29', '11', '曼萨诺展望上海德比:盼主场拿下对手 先做好自己', '', '', '', '新浪体育讯　　北京时间7月17日，中超联赛烽火继续，中超第17轮最焦点的赛事无疑是上海申花坐镇主场虹口足球场对阵上海上港的德比大战。今天申花方面放弃了赛前前往虹口足球场适应场地的训练，而是全队在康桥基地完成了德比大战之前的最后一练，今晚7点30分，主帅曼萨诺携阵中大将柏佳骏出席了赛前发布会。　　针对德比大战的备战情况，申花主帅曼萨诺表示：“周三刚打好足协杯，准备时间不长，但是大家都做好了充分准备对这场比赛。', '', '', '', '', '', '1', '0', '0', '1', '1469931734', '1468749815', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('30', '11', '圣杨智不白叫!带伤扑出必进球 这一幕必成经典', '', '', '', '新浪体育讯　　北京时间7月16日晚19：35，2016年中超联赛第17轮，河北华夏幸福主场迎战北京国安，上半场比赛伤停补时阶段，国安门将杨智带着腰伤扑出了姜宁近在咫尺的头球攻门，再次展现了圣杨智的威风，完成这次扑救后，杨智中场休息时只能在队友的搀扶才能离场，下半场比赛也被侯森换下，希望他的伤势没有大碍。杨智受伤瞬间　　比赛第31分钟，华夏幸福中路过顶长传，老将杜威前插抢点时与杨智撞在一起，杜威的大腿顶在了杨智的腰部，', '', '', '', '', '', '6', '0', '0', '1', '1469931732', '1468749865', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('31', '11', '足协公布处罚:申花官员指责裁判被禁3场+罚15000元', '', '', '', '北京时间7月15日，中国足协官网公布处罚决定，上海申花俱乐部官员庞斯因在7月9日与延边富德的比赛中指责裁判员造成不良影响，被禁止进入替补席3场并罚款15000元。', '', '', '', '', '', '14', '0', '0', '1', '1469931729', '1468749905', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('32', '12', '女排排名中国被巴西反超至第3', '', '', '', '北京时间7月17日消息，在2016年世界女排大奖赛结束后，国际排联公布了最新一期的世界排名。上期位居次席的中国女排因今年大奖赛仅获第5、被最终夺魁的巴西以2分的微弱优势反超，积278分退至第3。大奖赛卫冕受挫屈居亚军的美国仍以315分高居榜首，280分的巴西升至第2。　　本期世界排名所统计的比赛包括2016年世界女排大奖赛、2015年世界杯、2014年世界锦标赛和2012年伦敦奥运会，2015年洲际锦标赛的积分被剔除。　　上期排名第2的中国队在今年大', '', '', '', '', '', '10', '0', '0', '1', '1469931726', '1468749931', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('33', '12', '波波维奇帕克造访美国泳军 秒变粉丝合影菲鱼|图', '', '', '', '新浪体育讯　　随着美国奥运选拔赛告一段落，美国奥运游泳团队也已经集结完毕，正在美国本土进行最后的紧张训练中。美国当地时间昨天，NBA圣安东尼奥马刺队的主教练波波维奇和曾经获得总决赛MVP的法国球星帕克造访美国奥运泳团，给美国泳军打气助威。　　在里约奥运会前，美国泳军获得奥运资格的选手都将来到奥运备战训练营进行最后的备战。包括菲尔普斯、罗切特、莱德基、富兰克林等诸多名将都在阵中。', '', '', '', '', '', '10', '0', '0', '1', '1469931723', '1468749955', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('34', '12', '里约红灯区变成性交易超市 30分钟交易仅需9英镑', '', '', '', '新浪体育讯　　北京时间7月15日消息，里约热内卢红灯区的妓女们正在为里约奥运会提供“性服务销售”，原本希望在巴西举办世界杯之后迎来井喷的市场，却在两年后意外遇冷。身处臭名昭著的比拉-米莫萨区的性工作者们表示，原本期待在巴西世界杯后延续热潮的市场却出现了大幅下滑。　　目前距离奥运会开幕还有不到一个月的时间， 性工作者表示她们已经准备好了英文传单邀请运动员光顾里约城旁边的这个红灯区，提供十分便宜的性交易。破', '', '', '', '', '', '22', '0', '0', '1', '1469931720', '1468749974', '0', '1', '0', '#d9534f', '0', 'bold');
INSERT INTO `ebcms5_content_content` VALUES ('35', '13', '底部逐渐抬高 3100点面临压力', '', '', '', 'A股在投资者的万众瞩目下站稳3000点，且一路震荡走高，板块轮动明显，两融余额逐渐上升，不过沪指面对3100点关口还是心有余而力不足。　　在市场人士看来，英国脱欧落地后，市场一路震荡上行，在一举回补此前留下的跳空缺口3066点后。短期看，多方一个目标已经实现，在向下一个目标发起进攻前可能需要休整。　　3150点至3200点之间将是下一个重要目标，市场短期仍是存量资金在不同的板块间腾挪，逐渐抬高市场底部。但是向上的空间有限，且', '', '', '', '', '', '2', '0', '0', '1', '1469931718', '1468749998', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('36', '13', '券商分类评价结果揭晓 7家上市券商被降级', '', '', '', '　7月15日，据证监会新闻发言人邓舸通报，证监会公布了2016年证券公司分类评价结果，经综合评价，2016年95家证券公司分类评价结果为：A类公司36家，占比38%，B类公司51家，占比54%，C类公司8家，占比8%，无D、E类公司。此次评价期间为2015年5月份至2016年4月份。　　据邓舸表示，证券公司分类结果不是对证券公司资信状况及等级的评价，而是证券监管部门根据审慎监管的需要，以证券公司风险管理能力为基础，结合公司市场竞争力和合规管理水平，对', '', '', '', '', '', '1', '0', '0', '1', '1469931715', '1468750012', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('37', '13', '上市公司股权激励办法出炉 独董等三类人不属激励对象', '', '', '', '7月15日，证监会新闻发言人邓舸表示，证监会于7月13日正式发布《上市公司股权激励管理办法》（以下简称《办法》），股权激励方式仍是限制性股票和股票期权。《办法》明确了激励对象的范围，如明确独董、监事不得成为激励对象，单独或合计持有上市公司5%以上股份的股东或实际控制人及其配偶、父母、子女，不得成为激励对象；明确境内工作的外籍员工可成为激励对象。另外，还完善了上市公司内部问责与不当利益回吐机制。　　根据《办法', '', '', '', '', '', '1', '0', '0', '1', '1469931712', '1468750033', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('38', '13', '明星基金经理陨落背后：公奔私后水土不服', '', '', '', '王海雄，前华夏基金首席投资官，去年年初辞职，当年6月自创百毅资本，前后发行私募产品7只，现6只已清盘；　　陈扬帆，被媒体誉为基金男神，去年年初离职，随即创立猛犸资产，当年3月开始，前后发行私募产品31只，现7只已清盘；　　曹剑飞，前中欧基金投资总监，今年4月离职奔私。业内介绍，因其公司源实资产挖走东家大量客户，引发与董事长窦玉明的龃龉。　　．．．．．．　　他们都可谓明星基金经理。　　失落背后的细节　　王海雄', '', '', '', '', '', '3', '0', '0', '1', '1469931710', '1468750057', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('39', '14', '证券期货经营机构私募资管运作管理暂行规定全文公布', '', '', '', '证券期货经营机构私募资产管理业务运作管理暂行规定全文：　　　　第一条 为了进一步加强对证券期货经营机构私募资产管理业务的监管，规范市场行为，强化风险管控，根据《证券法》《证券投资基金法》《证券公司监督管理条例》《期货交易管理条例》《私募投资基金监督管理暂行办法》《证券公司客户资产管理业务管理办法》《基金管理公司特定客户资产管理业务试点办法》《期货公司监督管理办法》和《期货公司资产管理业务试点办法》', '', '', '', '', '', '4', '0', '0', '1', '1469931707', '1468750074', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('40', '14', '私募：三季度大概率是窄幅震荡 坚守价值投资', '', '', '', '　在3000点上方市场做多氛围比较活跃，成长股、价值股热点轮动较快。私募人士认为，结构性吃饭行情已经显现，三季度大概率是窄幅震荡格局，或出现前低后高走势。短期谨防博弈风险，中长期应关注风险收益比较高的公司，例如消费类价值股的成长性机会。总体上看，下半年是介入权益类资产的较好时点。', '', '', '', '', '', '2', '0', '0', '1', '1469931705', '1468750105', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('41', '15', '土耳其“政变惊魂”：全球金融市场影响全解析', '', '', '', '英国脱欧风暴阴霾未散，另一片乌云便忙不迭地滚滚袭来——北京时间7月16日约凌晨4时（土耳其当地时间15日晚），土耳其突然传出消息——军方人员发动政变，截至北京时间16日上午8时，土耳其政府称，局势已经得到控制。这场不到6个小时的“政变惊魂”，或在下周一再度使得刚刚平静的全球金融市场动荡不安。　　据第一财经记者整理，事发后，尽管部分市场已经收市，但部分全球金融市场仍颇为躁动——土耳其里拉对美元暴跌4.73%；美股终结了', '', '', '', '', '', '9', '0', '0', '1', '1469931702', '1468750128', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('42', '15', '中国二季度GDP超预期 有色金属及橡胶等工业品走强', '', '', '', '　汇通网7月15日讯——周五(7月15日)国内期市工业品普遍走高，有色金属、黑色系商品一片红，橡胶涨幅逾2%，因早间统计局公布中国包括二季度GDP在内多项宏观数据均好于预期，市场情绪改善。', '', '', '', '', '', '5', '0', '0', '1', '1469931700', '1468750147', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('43', '15', '终结连续数周上涨 黑色金属小幅回调', '', '', '', '新华社北京7月16日专电 题：大宗商品周评：终结连续数周上涨 黑色金属小幅回调　　新华社记者刘开雄、赵晓辉　　尽管本周一度出现涨停的局面，但黑色系金属在经历了数周连涨之后，在本周出现了小幅回调的局面。　　在过去的四周里，螺纹钢、热卷、焦煤、焦炭(1007, -9.00, -0.89%)等黑色系产品价格快速上涨，走出了5月暴跌之后的一轮价格修复行情，平均涨幅在25％左右。但在本周，这些品种出现了小幅下跌，螺纹钢单周跌幅1．87％，铁矿', '', '', '', '', '', '3', '0', '0', '1', '1469931697', '1468750168', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('44', '16', '还在各种瘫？鹿晗运动季开启 快来运动吧', '', '', '', '　新浪娱乐讯 不知不觉，又到星期五了，号称周五播报员的鹿晗[微博]貌似又有大动作？是的，#鹿晗运动季#在今天正式开启啦！7月11日，新浪娱乐就发微博预告，鹿晗小镇再次开启，神秘大礼盒就是#鹿晗运动季#！别再“北京瘫”、“横店瘫”、“葛优瘫”等各种瘫了，快跟着鹿晗一块儿来运动吧~！　　一言不合就运动？ 鹿晗早就预告过啦！', '', '', '', '', '', '3', '0', '0', '1', '1469931695', '1468750210', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('45', '16', '喜上加喜！林心如陈妍希领衔“带球”出嫁的10大女星', '', '', '', '据台湾媒体报道，霍建华与林心如14日凌晨相约KTV欢唱，出门时林心如却媒体被拍到“大肚照”，疑似坐实怀孕传闻。两性观念开放的年代，娱乐圈中有很多女星曾“带球”出嫁，下面一床情书便来扒扒奉子成婚喜上加喜的10大女星。', '', '', '', '', '', '8', '0', '0', '1', '1469931693', '1468750232', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('46', '17', '周末看电影丨八部新片上映 高分佳作现身', '', '', '', '　本文来自“玩儿电影”公众号（id：wan2movie）　　　　进入暑期以后，每周都有不止一部吸引眼球的新片上线抢市场。观众看得热闹，但为了跟上点评/吐槽的节奏，本玩可能会在这个夏天里，在厕所哭晕N次……　　但，也是没有办法的事，这就是暑期档嘛。　　《寒战2》《大鱼海棠》等片的热度还没完全过去，本周的新片已经气势汹汹地杀来——文艺佳作、爱情喜剧、动作喜剧、犯罪悬疑、惊悚、动画……乍看之下眼花缭乱，但其实选择起来依然', '', '', '', '', '', '6', '0', '0', '1', '1469931683', '1468750261', '0', '1', '0', '#d9534f', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('47', '17', '又要买买买？传万达正洽购派拉蒙49%股权', '', '', '', '据澎湃新闻7月14日报道 7月13日，《华尔街日报》援引知情人士称，万达集团正与维亚康姆（Viacom）进行磋商，欲收购对方旗下公司派拉蒙影业（Paramount Pictures）49%的股份。但该消息还未得到万达方面的官方确认。　　但现在，维亚康姆内部分成了两派：目前维亚康姆最大股东、现年92岁的亿万富翁萨默•雷石东（Sumner Redstone）竭力反对该交易的进行；而另一边，包括董事长和首席执行长Philippe Dauman在内的维亚康姆高管主张出售派拉蒙影片部分股权，来', '', '', '', '', '', '13', '0', '0', '1', '1469931680', '1468750282', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('48', '17', '许玮甯台北影奖封后 王大陆遗憾错失影帝', '', '', '', '新浪娱乐讯 第18届台北电影奖16日晚间在台北举行，许玮甯以《红衣小女孩》、《失控谎言》、短片《世纪末的华丽》夺下影后宝座，也是台北电影奖史上首度以三部作品同时得奖，许玮甯硬咽感谢工作人员与家人，不免被问到是否与旧爱阮经天复合？她表示：“先不回应了，把焦点放在电影上吧。”合作鬼片《红衣小女孩》的黄河也擒下影帝，备受瞩目的任达华、王大陆、宋芸桦等人则与奖项失之交臂。以原住民为主角的《只要我长大》获得百万首', '', '', '', '', '', '3', '0', '0', '1', '1469931678', '1468750305', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('49', '18', '朋友圈：12星座见啥会分分钟拉黑你(组图)', '', '', '', '朋友圈已经随着网络的普及成为了许多人日常生活中的一个组成部分，产生了任何想法、发生了某件事情第一时间并不是和身边人分享，而是组织一下语言发朋友圈。科技紫微星座网今天就要为大家揭秘，在12星座好友的可见范围内，千万别发这些内容，否则你就等着被屏蔽吧', '', '', '', '', '', '3', '0', '0', '1', '1469931676', '1468750336', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('50', '19', 'iPhone 7还没发布8的消息就来了：将采用OLED屏幕', '', '', '', '2017年将是苹果iPhone诞生的第十个年头，在这样一个特殊的日子，全新的iPhone8或7s也将以崭新的面貌展现在用户面前，根据内部人士的爆料和分析师的预测，下一代iPhone8无论在材质还是功能上都将有飞跃，其中可以确定的是明年的iPhone将使用OLED屏幕。　　全球OLED供应商包括LG Display、三星、JDI和夏普，无论是谁都想抢得苹果这个超级金主，三星目前垄断全球90% OLED屏幕出货量，是其中最可能成为苹果供应商的厂家，LG Display此前就曾表示会为了争取订单', '', '', '', '', '', '12', '0', '0', '1', '1469931673', '1468750363', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('51', '19', '还是大屏更适合亚洲 三星A9 Pro销售区域确定', '', '', '', '5月底我们曾经报道了三星A9 Pro在海外开售的消息，不过根据最新消息，三星A9 Pro的销售范围将仅限亚洲市场。也就是说三星A9 Pro将成为一款名副其实的亚洲特供机。   三星A9 Pro拥有一块6英寸的大屏幕，或许是考虑到如此大的机身尺寸在某些国家和地区可能不受欢迎，三星A9 Pro才选择只限定在亚洲范围开卖。   除了6英寸屏幕，三星A9 Pro的主要卖点还包括骁龙652处理器、4GB RAM+32GB ROM、800万像素+1600万像素的摄像头', '', '', '', '', '', '2', '0', '0', '1', '1469931669', '1468750387', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('52', '19', '果然涨价了 魅族MX6售价曝光：这价格贵吗？', '', '', '', '魅族已经宣布将在7月19日正式发布新旗舰MX6。此前，魅族联合创始人、总裁白永祥表示，魅族把PRO 6的很多工艺带给了MX6，供应链部门也正在努力让MX6成为备货最好的梦想机。　　此外，白永祥强调，MX6的成本提高了，售价也会提升，但他相信MX6会是两千元价位上设计和工艺最好的产品。　　如此来说，MX6的售价就不是原来的1799元起了，会是多少呢？　　今日，有网友曝光了一张魅族内部文件，文件显示，即将发布的MX6、智能保护套搭售价格为2299元', '', '', '', '', '', '0', '0', '0', '1', '1469931665', '1468750412', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('53', '19', '三星S7 Edge巴西里约奥运会限量版：五环五色', '', '', '', '巴西里约奥运会开幕在即，作为奥运会的主赞助商之一，三星也顺势推出了一款里约奥运限量版的Galaxy S7 Edge。　　在造型上，这款奥运限量版的S7 Edge与普通版基本相同，不过它在设计中大量运用奥运五环的颜色对机身进行点缀。其中，机身左侧的音量键就用上了奥运五环中的绿色。', '', '', '', '', '', '4', '0', '0', '1', '1469931663', '1468750428', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('54', '10', '要赶奥运热：三星Note 7或发布日就开卖', '', '', '', '　经过多轮爆料和三星官方的预热，我们对三星Note 7的外观、配置和发布日期已经有了基本的了解，变数不会太大。接下来，我们所关心的就是其究竟什么时候开卖了，毕竟咱们买得到才是王道。关于这一点，韩国媒体最新消息称，三星Note 7有望在发布当日就开卖，也就是8月2日。　　回顾上代Note旗舰，三星Note 5是在发布后大约一周才实现首发的，Note 7今年这上市速度有点惊人了。据了解，2016年里约奥运会将在8月5日开幕，三星此举正是为了最大化地', '', '', '', '', '', '15', '0', '0', '1', '1471359160', '1468750445', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('55', '20', '太阳黑子连续十几天消失 新一轮“冰河期”要来了？', '', '', '', '编者按：太阳黑子是太阳活动水平的标识，但是在2016年6月底，太阳上连续十几天没有黑子，难道很快要进入太阳活动低年？太阳马上要进入休眠状态了？地球要进入新一轮“冰河期”了？　　“冰河期”真的要来了吗？　　最近，随着第24活动周太阳活动水平的不断下降，太阳上的黑子真是越来越少 了，以前还可以掰着指头数，现在恐怕只能握着拳头数了。甚至在6月下旬开始的十几天里，太阳上便没有了黑子，明亮的太阳上干干净净的。7月5日没有', '', '', '', '', '', '4', '0', '0', '1', '1469931657', '1468750469', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('56', '20', '研究报告：地球近六成陆地物种多样性遭严重破坏', '', '', '', '资料图：亚马逊雨林被开垦用来种大豆。　　中新网7月16日电 据外媒报道，最新《科学》期刊上的一份研究报告称，地球陆地上58%地区的物种多样性完整指数已低于安全值。　　该份报告指出，受此冲击最大的是美国、阿根廷、南非与中亚的草原地区，这些地区的动物与植物数量皆因人类活动而减少。　　报告指出，陆地表面约58%地区的物种“完整性”已经降至安全界限以下；这主要是农业用地、道路与城市发展持续扩充所致。全球大约71%的人口居', '', '', '', '', '', '17', '0', '0', '1', '1469931654', '1468750489', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('57', '20', '军舰鸟空中连续飞行两个月不落地：长途跋涉在空气中睡觉', '军舰鸟空中连续飞行两个月不落地', '军舰鸟空中连续飞行两个月不落地', '', '　　文章来源：蝌蚪五线谱　　科学家已经发现军舰鸟能长时间的飞行，但是近期的一项研究结果令人有点震惊，研究人员发现军舰鸟的飞行时间可以长达两个月！　　发表在《科学》杂志上的新研究发现，居住在印度洋和太平洋的大型的军舰鸟，借助上升气流，每隔六分钟挥舞着巨大翅膀，从而飞行几百英里。　　研究团队在军舰鸟的后颈贴上了极轻的设备。该小型太阳能设备与卫星相连，其功能包括GPS跟踪、心率监视器、加速计和测高计。它们的', '', '', '', '', '', '7', '0', '0', '1', '1469931650', '1468750525', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('58', '20', '中国基因编辑研究且快且急，看专家怎么说？', '', '', '', '　　文章来源：中国科学报 微信公众号　　专家建议尽快完善相关法律规避伦理风险和社会争议　　从修改植物基因，到改变蝴蝶翅膀的图案，再到修改人类细胞……以CRISPR为代表的基因编辑技术风靡生命科学领域。　　日前，在香山科学会议第564次学术讨论会上，专家指出，我国基因编辑研究工作正在向源头创新转移，现阶段应大力推动该领域的研究及应用，并及时制定严格有效的监管措施和伦理规范，保证基因编辑下游应用快速健康有序发展。', '', '', '', '', '', '28', '0', '0', '1', '1469931648', '1468750556', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('59', '8', '油价回归“5元时代” 加满一箱油省五块钱', '', '', '油价下调,油价下调时间,今日油价下调,中国油价下调,油价下调最新消息,油价下调整最新消息,油价下调再爽约,油价下调图片,油价下调原因,国内油价下调,最新国内油价下调', '央视财经讯 我国年内第14次成品油零售价调价窗口期，于7月21日24时开启。经过前两次搁浅后,国家发改委宣布，本次成品油价格迎来年内第二次下调！汽、柴油每吨分别下调155元和150元；全国平均来看折合90号汽油每升下调0.1元，0号柴油每升下调0.13元，92号汽油均每升下调0.11元。按一般家用汽车油箱50L的容量估测,加满一箱汽油将节省约5元。此次成品油零售价格下调，国内汽柴油零售市场将再次全面回归“五元时代”。对于终端消费者来说，降低出行成本无疑是个好消息。以北京为例，#92#号汽油将从6.05元/', '', '', '', 'heheyoujia', '', '134', '0', '0', '1', '1470538312', '1469092861', '0', '1', '0', '#d9534f', '0', 'bold');
INSERT INTO `ebcms5_content_content` VALUES ('60', '9', '菲总统称将恢复与华对话 因中国有钱而美国没钱', '', '', '', '【环球网报道 记者 余鹏飞】菲律宾总统杜特尔特日前暗示了他愿意按照前总统菲德尔·拉莫斯的建议，搁置南海仲裁案的“裁决”，恢复与中国的双边对话。杜特尔特就此解释称，“中国有钱，美国是没有钱的”。　　据《菲律宾商报》7月24日报道，菲律宾总统杜特尔特22日发表演讲称，菲德尔·拉莫斯向其建议在与中国对话时，搁置南海仲裁案的“裁决”是没有问题的。与中国的经济合作可帮助菲律宾的南部群岛致富。　　不过，菲律宾最高法院高级陪审法官加彪(音译)22日声称，重启与中国的谈判也是有前提的，即中国将不提到其“九段线”主张。此前', '', '', '', '', '', '2', '0', '0', '1', '1469931643', '1469348616', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('61', '10', '阿杜:没人当面喷我加盟勇士 都是键盘侠在作祟', '', '', '', '北京时间7月24日，据雅虎体育报道，凯文-杜兰特今夏加盟勇士队的决定引起了很大的争议，但是据阿杜本人表示，从那之后，从来没有人当面抨击过他的这个决定。　　自从杜兰特在7月4日宣布加盟勇士队之后，外界的反应非常激烈，雷霆队球迷开始烧杜兰特的球衣；查尔斯-巴克利对他的决定表示失望，并称杜兰特这是“想骗一个总冠军”；甚至连他的两位昔日队友坎特和亚当斯都在推特上唱双簧并讽刺杜兰特背叛球队。　　虽然杜兰特已经听到了那些批评的声音，但是他表示外界对这个决定的反应并不是太糟糕。　　“所有那些批评的声音都发生在网络上。我', '', '', '', '', '', '4', '0', '0', '1', '1469931641', '1469348661', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('62', '11', '佩莱:申花是很强大的对手 祝福登巴巴早日康复', '', '', '', '佩莱出席战申花赛前发布会　　齐鲁网济南7月23日讯 （ 记者 李淼 实习记者 薛睿 ） 中超联赛第19轮山东鲁能主场迎战上海申花，鲁能主帅马加特出席了赛前发布会，主帅马加特表示申花是一支强大的队伍，明天不会期待很多进球。　　马加特：申花是强大的对手 明天不会期待很多进球　　发布会上，鲁能主帅马加特表示申花是一个强大的对手，“在几周前足协杯的比赛中对阵上海申花使我们积攒了经验，我认为那是一场不错的比赛。申花向我们展示出他是一支强大的球队，甚至在过去的比赛中他是最强大的一支。”　　在此前上海滩新旧霸', '', '', '', '', '', '0', '0', '0', '1', '1469931639', '1469348698', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('63', '11', '李源一世界波斩中超首球 回泰达想这刻他等太久', '', '', '', '李源一进球后被队友包围庆祝　　新浪体育讯　　2016赛季中超联赛第19轮，天津泰达客场1-3负于杭州绿城。虽然输掉了比赛，但天津泰达本场比赛也有收获。前国奥主力中场李源一本场比赛奉献一脚世界波，一度为天津泰达扳平比分，在重返天津泰达后踢得第一场中超比赛中就收获了中超首球。李源一本场比赛25分钟的出场时间虽然不多，但已经超过了他在广州恒大半个赛季的中超出场时间，攻防两端都很积极，表现让人眼前一亮。', '', '', '', '', '', '2', '0', '0', '1', '1469931634', '1469352465', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('64', '12', '重磅！曝俄罗斯或全员无缘里约奥运 一共387人', '', '', '', '俄罗斯田径之前被判定不能参加里约奥运会，而现在又传来更惊人的消息，据英国媒体《每日邮报》报道，国际奥林匹克委员会准备对整个俄罗斯代表团实行禁赛，代表团387名运动员将无法出战里约奥运会。　　《每日邮报》周日版了解到，整个俄罗斯奥运代表团都无法参加下个月的里约奥运会，根据他们的消息源，国际奥委会将用最强硬的方式处罚这387名俄罗斯代表团运动员。　　之前，受到处罚的只是俄罗斯田径代表团，但《每日邮报》表示，今天的裁决结果将排除俄罗斯在自行车、柔道、摔跤等其他项目的夺金希望。这场争论涉及到俄罗斯总统普京的体育部', '', '', '', '', '', '6', '0', '0', '1', '1469931632', '1469352503', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('65', '12', '举重队里约最低目标六金 8届奥运29金堪称王牌军', '', '', '', '陆浩杰和陆永（右）　　中新社北京7月23日电 （记者 张素）力拔山兮，壮士出征，中国举重队23日晚从北京兵发里约。这支最“给力”的队伍说：这次要全面超越上届奥运会。　　自1984年洛杉矶奥运会至今，中国举重队共获29枚金牌，与中国体操队并列“金牌榜”第二。近4届奥运会，除了2008年北京奥运会时豪夺8金，他们在悉尼、雅典、伦敦三次境外参赛所获金牌数均为5枚。　　这一次，中国举重队派出10名大力士出战10个级别，明确喊出目标：保六争八。女队主教练王国新已是第七次奥运之旅，他将带领四位“90后”女将“保三争四', '', '', '', '', '', '4', '0', '0', '1', '1469931630', '1469352532', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('66', '13', '宽松货币预期再起 震荡A股尚能饭否？', '', '', '', '英国公投“脱欧”以来，流动性宽松预期叠加供给侧改革的推进，助推A股出现小反弹。从6月24日至7月21日，上证指数上涨超过5%，A股重回3000点之上。　　是追涨入场还是获利了结，机构分歧加大。国泰君安(18.080, -0.20, -1.09%)认为，乐观预期正提前透支，谨防吃饭变买单。安信证券则认为现在处于吃饭行情的上半场，还会进入“山脚下板块补涨”的纵深发展阶段。　　“熊市中吃饭行情往往都是非常短暂的，有时候甚至短得超出我们判断，只有结构性行情可以在一定程度上穿越牛熊，因此，下半年', '', '', '', '', '', '0', '0', '0', '1', '1469931402', '1469352613', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('67', '13', '股市出现疲态 市场有内在调整需求', '', '', '', '房地产拉动了今年中国经济增长，国家统计局发布2016年二季度GDP，数据显示为6.7%，与一季度持平。从数据上看，中国GDP增速处于逐渐下降趋势，去年四季度GDP增速6.8%，2015年中国全年GDP增速为6.9%。在经济增长的“L”型走势中，我们是否已经处在底部，还是经济增长会继续下行？中国经济增长在下半年面临什么挑战和风险，是值得我们思量的。　　6月第一次出现了民间投资负增长的情况，1-6月，民间固定资产投资同比名义增长2.8%，增速比1-5月回落1.1个百分点；民间固定资产投资占全国固定资产的比重为', '', '', '', '', '', '0', '0', '0', '1', '1469931399', '1469352635', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('68', '14', '公募基金“吸金王”首推QDII 下半年日子不会这么好过了', '', '', '', '上半年公募基金产品中最为风光的，莫过于QDII了。不仅在业绩上表现优异，而且也为基金公司带来了吸金效应。　　截至7月21日，公募基金二季度报告披露收官。民生证券研究显示，在A股市场持续震荡的行情中，QDII规模增速最为可观，其二季度末规模较2016年一季度末增长197亿元，增速达到29.95%。就连QDII额度也与之伴随水涨船高的，愈来愈紧俏。　　不过，在QDII基金经理眼中，下半年，QDII这个热门的投资类型，将随着海外市场的走势，而呈现出分化。　　QDII规模占比首超1%　　民生证券统计显示，截至上半', '', '', '', '', '', '0', '0', '0', '1', '1469931393', '1469352665', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('69', '14', '资管新规再降杠杆 高风险偏好资金套利无门', '', '', '', '资管行业迎来“紧箍咒”——《证券期货经营机构私募资产管理业务运作管理暂行规定》（以下简称《暂行规定》）于7月18日正式实施。　　业内人士仍表示，较此前的“八条底线”，此次新规对杠杆的要求再有升级，而文件下发单位从行业协会转至证监会则体现出监管层对资管业务规范的高度重视，“治理过去的资管乱象将成为接下来各机构的重要工作。”　　在上述新规的导向下，另据媒体报道，监管层近期亦对银行理财资金对接券商资管、基金子公司专户甚至契约型私募开展的委外业务提高了关注程度，后期也将对该类业务酝酿配套规范措施。　　严控杠杆', '', '', '', '', '', '0', '0', '0', '1', '1469931390', '1469352685', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('70', '14', 'QDII额度紧张 公募通道费价格暴涨至2%', '7.8日：窄幅震荡后要择机突破', '7.8日：窄幅震荡后要择机突破', '', '　[去年3月，国家外汇管理局大额放行了5家基金公司共计84亿美元的QDII额度。目前有约30家基金公司获批了QDII额度，其中在10亿美元规模以上的基金公司只有8家，占比不到三成最近一次的QDII基金暂停申购公告来自于广发基金]　　[据《第一财经日报》记者统计，目前暂停申购的QDII基金占到总体的比例大约是44%，其中暂停大额申购的比例也达到43%。]　　[“现在QDII通道费是在1%~2%之间，一般来说，除了有些是机构，还有些则是一些企业有这方面的需求。”华南一家公募国际业务部副总经理如此表示。]　　[', '', '', '', '', '', '1', '0', '0', '1', '1469931388', '1469352731', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('71', '15', '英国退欧 日元升值为哪般？', '', '', '', '英国退欧，日元升值为哪般？　　徐瑾　　按照“蝴蝶效应”的理论，大西洋畔的一只蝴蝶震动翅膀，可能会迎来太平洋这边的海啸。这种说法听起来夸张，但是在全球化时代却并非危言耸听，东西经济体一体化之下，确实容易出现各种误伤。典型如同6月末英国退欧全民公投，其结果是以微弱优势离开欧洲，这结果其实出乎主流精英以及金融市场预测之外。这对于欧盟、英国的影响自不待言，对于亚洲的日本，也不啻于一个重大打击。　　原因何在？一言以蔽之，日元升值。在英国脱欧之后，日元兑美元汇率立即上升超过4%，幅度几乎接近二十年内最高，日元兑英镑(', '', '', '', '', '', '1', '0', '0', '1', '1469931385', '1469352835', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('72', '15', 'CBA：中国央行要在6.7捍卫人民币的决心很明确', '', '', '', '新浪财经讯 7月22日消息，据彭博报道，澳大利亚联邦银行（CBA）驻新加坡外汇策略师Andy Ji称，中国央行本周已通过强劲的人民币(6.6876, 0.0122, 0.18%)中间价向市场明确传达了这个信息：要在1美元兑6.7元水平上捍卫人民币汇率。　　人民币中间价今日设在6.6669元，本周累计调升0.2%，创下6周最大升幅。人民币兑美元本周走强0.28%，至1美元兑6.6995元，迈向7周来首次周涨幅。　　在英国脱欧之后，美元/人民币逼近6.7元，是因为在欧元(1.0975,&amp;n', '', '', '', '', '', '2', '0', '0', '1', '1469931383', '1469352865', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('73', '16', '陈晓陈妍希办婚礼 盘点明星的天价婚礼', '', '', '', '小龙女与杨过终于结婚了，这个无论是在小说还是影视作品中均为出现的场景，今天(7月19日)将在现实中出现！7月19日，“过儿”陈晓和“小龙女”陈妍希将在北京的雁西湖举办婚礼！陈晓陈妍希婚礼内场布置', '', '', '', '', '', '6', '0', '0', '1', '1469931380', '1469353010', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('74', '16', '34D陈乔恩大方传授丰胸秘诀：吃鸡睾丸', '', '', '', '陈乔恩以前一段说自己爱吃睾丸，尤其是鸡睾丸的视频被网友扒了出来，引起热议。对此陈乔恩透露自己的丰胸秘诀是吃鸡睾丸。陈乔恩', '', '', '', '', '', '3', '0', '0', '1', '1469931377', '1469353063', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('75', '16', '34D港星写真内地老板买3000本 拒50万饭局', '', '', '', '今年24岁的34D屋村少女何洛沂推出写真，首批发行4000本。透露获内地老板朋友扫写真，预计中港合共售出近3000本。24岁何洛沂穿低胸装展露事业线　　新浪娱乐讯 北京时间7月24日消息，据香港媒体报导，今年24岁的34D屋村少女何洛沂推出写真，首批发行4000本。昨天（7月23日）她凑热闹入书展宣传，以低胸上衣配短裤，露事业线加长腿赠兴。她透露获内地老板朋友扫写真，预计中港合共售出近3000本。　　拒50万饭局　　追问有没有老板出价邀约饭局？何洛沂表明内地老板只是普通朋友，但另有人出价：“试过几次，其中', '', '', '', '', '', '6', '0', '0', '1', '1469931375', '1469353113', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('76', '17', '成龙：为影迷坚持拍戏 签约吴亦凡有计划', '', '', '', '新浪娱乐讯 在承诺不再拍“大型动作片”四年后，62岁的成龙[微博]在这个夏天又出山了。虽没亲自担任导演，但《绝地逃亡》那笑料和动作齐飞的熟悉配方、那中外混血的熟悉味道，早已将他出卖。这次他多了约翰尼·诺克斯维尔这个在片中成事不足败事有余的老外拍档，多了范冰冰[微博]的倾情助阵，也多了些力不从心的自知。但大哥依然是那个爱玩命、爱“教年轻人”、爱感叹苦日子里出光辉的大哥。年过六旬的成龙为何坚持扮演动作英雄？他如何教育王大陆[微博]、黄子韬[微博]、吴彦祖[微博]和谢霆锋？怎么惊险万分地掉进水中、假戏真做到喊救', '', '', '', '', '', '0', '0', '0', '1', '1469931372', '1469353294', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('77', '17', '周末看电影丨中日印美四国影片上阵混战', '', '', '', '不知不觉7月已到月尾，大雨也从南方下到了北方，可就算大雨让整座城市倾倒，影院也会为你上新片……　　但也有觉得暑期档太挤，移到中秋档的《大话西游3》，还有作别七夕档进军贺岁档的《三少爷的剑》。就让小玩向这两部改档的电影挥挥手，然后再激动的和你们讲讲这周的新片情况。　　相较于前几周的清一色的国产片，这周影院里多了日本、印度和美国的片子，票房厮杀战就更厉害了，大家的选择空间也更多了一些。新片一共有十部，但并不是每一部都值得去看哦。　　《绝地逃亡》 2016-7-21　　导演： 雷尼·哈林　　主演： 成', '', '', '', '', '', '0', '0', '0', '1', '1469931369', '1469353327', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('78', '17', '不满宣传？杨子姗:和预想不同 常被问档期', '', '', '', '杨子姗　　新浪娱乐讯 面前的杨子姗[微博]一身黑色紧身小西装，长衣长裤，利落爽快，与《天亮之前》中那个“风尘女子”的人设相去甚远。这是生活中的杨子姗喜欢的穿衣风格，中性，再加那么一点酷，至于风情，她更多地留给了故事中的角色。　　《天亮之前》是杨子姗与老公吴中天自公布婚讯以来的首度合作。此前，二人异地恋终成正果的爱情故事已遍传网络，声情并“貌”地甜倒了一片单身狗。不过当这对颜值演艺俱登对的小情侣调整身份变成了演员与导演，二人却好像“疏离”了不少，据说，连男一号郭富城[微博]，都是拍了一半戏才突然意识到二人之', '', '', '', '', '', '1', '0', '0', '1', '1469931365', '1469353356', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('79', '18', '7月22日太阳进入狮子座的影响(图)', '', '', '', '7月22日太阳进入狮子座的影响　　7月22日：太阳进入狮子座　　（查看你的本命盘&gt;&gt;）　　太阳这颗星体是狮子座的守护星座，象征着绝对的权力与光芒，富有活力与表现力，并且在执行力度上非常强劲，当这颗星体再次进入入庙位置的狮子座，对大众而言，经历过六月的沉淀与休憩，意味着下半年的真正开始与再次出发。　　之前讲述过上半年对这一整年而言都是一种磨砺，而真正的重头戏则在下半年太阳进入狮子座之后，届时不论是对社会整体，还是我们自身来讲，都会经历一场蜕变。如果在上半年或者六月期间对某些事还有所逃避，那么在这', '', '', '', '', '', '2', '0', '0', '1', '1469931363', '1469353392', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('80', '18', '婚恋心理：8心动绝招让男人拜倒裙下(图)', '', '', '', '如果某天你也成了相亲大军的一员，那就一定要学会这八个绝招，这样当你遇上心动男生时就不怕错失姻缘啦~8心动绝招让男人拜倒裙下　　在崇尚自由恋爱的时代，大多数人不到万不得已都不会走上相亲这条老路，然而不得不承认的是，相亲确实是解决剩女问题最有效的方法之一。如果某天你也成了相亲大军的一员，那就一定要学会这八个绝招，这样当你遇上心动男生时就不怕错失姻缘啦！　　注意一：首次见面一定要让他选地方　　作为女人，有太多的主意会让男人觉得你想控制他，所以不要有太多的意见。他在电话里问你在什么地方见面，你就说：“听你的吧，哪', '', '', '', '', '', '3', '0', '0', '1', '1469931360', '1469353424', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('81', '18', '12星座男能给你什么样的安全感(组图)', '', '', '', '12星座男能给你什么样的安全感　　恋爱中的女人，无疑是需要安全感的，而安全感的内容可以是不同的：男友温柔细心，对自己无尽呵护宠爱，让女人有安全感；男友勤勉上进，懂得为未来的美好生活奋斗、规划，让女人有安全感……那么，12星男又会带给恋人怎样的安全感呢？魔法星座即刻来揭晓！', '', '', '', '', '', '1', '0', '0', '1', '1469931357', '1469353450', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('82', '18', '福气满满的3种眉型你有吗', '', '', '', '　　香港七星堂/文　　眉也是面相学中的一种，也可以看出一个人的运势与否，看一个人能否带来好的运势，眉形也有影响，那么眉形要怎么样才是好的呢？下面来详细解析眉形看福气。　　1，眉形长度比眼睛长有福气　　眉毛无论是粗细还是长短，但是一定要顺，要比眼睛长，但是也不能太长，会对个人性格上有很大的反差，要适中，那才比较好，古人云：眉毛长过目为良相，本身也是如此，这是相学中针对眉毛中最基本的准则。除此之外，即使一个人的眉毛比较柔顺，但是也要看眉毛的光泽，也就是色泽，色泽上的深浅也有很大的讲究。　　2，眉形以整齐为主有', '', '', '', '', '', '9', '0', '0', '1', '1469931355', '1469353477', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('83', '20', '科学家计划“复活”猛犸象：减慢温室效应', '', '', '', '　　科学家表示，如果能将猛犸象复活、重新引入生态系统之中，或许就能将冻原重新变回草原，从而将永久冻土层与大气隔离开来，阻止温室气体的逃逸。猛犸象约在1万年前从地球上灭绝。　　新浪科技讯 北京时间7月21日消息，随着北极的永久冻土层不断融化，其中储存的远古时期的温室气体被逐渐释放出来，这可能会气候变化进一步加剧。但有一位“英雄”或许能帮助我们阻止这一进程。　　科学家表示，如果能将猛犸象复活、重新引入生态系统之中，或许就能将冻原重新变回草原，从而将永久冻土层与大气隔离开来，阻止温室气体的逃逸。　　猛犸象约在1', '', '', '', '', '', '5', '0', '0', '1', '1469931353', '1469353566', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_content` VALUES ('84', '20', '罗塞塔计划9月直接撞击彗星：登陆彗星让我们学到了什么？', '', '', '', '2014年8月6日，欧空局任务控制中心，罗塞塔项目工作人员在接收到飞船成功入轨信号后兴奋不已　　新浪科技讯 北京时间7月19日消息，据英国广播公司(BBC)网站报道，两年前的2014年，全世界都被欧洲空间局的一艘小小飞船追逐并登陆一颗彗星的壮举所吸引，那么两年过去，今年9月份，这次探测任务就将接近尾声，我们在这次探测任务期间学习到了什么？　　星际交会　　经过10年的太空追逐，2014年11月12日，正在围绕67P彗星运行的欧洲空间局(ESA)“罗塞塔”探测器成功释放一艘小型着陆器“菲莱”(Philae)并', '', '', '', '', '', '6', '0', '0', '1', '1469962571', '1469353600', '0', '1', '0', '', '0', '');

-- ----------------------------
-- Table structure for ebcms5_content_tag
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_content_tag`;
CREATE TABLE `ebcms5_content_tag` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `tag` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '数量',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  `locked` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '锁定',
  `color` varchar(255) NOT NULL DEFAULT '' COMMENT '字体颜色',
  `size` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '字号',
  `bold` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=86 DEFAULT CHARSET=utf8 COMMENT='内容标签表';

-- ----------------------------
-- Records of ebcms5_content_tag
-- ----------------------------
INSERT INTO `ebcms5_content_tag` VALUES ('1', '村官', '1', '1468811348', '0', '1', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('2', '基因工程', '1', '1468811374', '0', '1', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('3', '生命科学', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('4', '武器', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('5', '人与自然', '1', '1468811372', '0', '1', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('6', '环境保护', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('7', '宇宙科学', '1', '1468811369', '0', '1', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('8', '三星', '3', '1469167870', '0', '1', '1', '1', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('9', '魅族', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('10', 'iphone8', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('11', 'iphone7', '1', '1468811367', '0', '1', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('12', '星座', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('13', '王大陆', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('14', '许玮甯', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('15', '万达', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('16', '派拉蒙', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('17', '王健林', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('18', '王思聪', '1', '1468811377', '0', '1', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('19', '寒战2', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('20', '大鱼海棠', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('21', '林心如', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('22', '陈妍希', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('23', '鹿晗', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('24', '黑色金属', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('25', 'GDP', '1', '1468811335', '0', '1', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('26', '有色金属', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('27', '橡胶', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('28', '土耳其', '3', '1469252784', '0', '1', '1', '1', '#d9534f', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('29', '私募', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('30', '证券', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('31', '期货', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('32', '王海雄', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('33', '百毅资本', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('34', '曹剑飞', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('35', '股权激励', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('36', '券商', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('37', 'A股', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('38', '红灯区', '1', '1469252801', '0', '1', '1', '0', '#d9534f', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('39', '性', '1', '1469252798', '0', '1', '1', '0', '#d9534f', '0', 'bold');
INSERT INTO `ebcms5_content_tag` VALUES ('40', '里约', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('41', '波波维奇帕克', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('42', '菲鱼', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('43', '女排', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('44', '上海申花', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('45', '圣杨智', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('46', '曼萨诺', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('47', '中超联赛', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('48', '韦德', '2', '1469196699', '0', '0', '1', '1', '', '0', 'bold');
INSERT INTO `ebcms5_content_tag` VALUES ('49', '马刺', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('50', '利拉德', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('51', '莱利', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('52', '绿军', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('53', '格里芬', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('54', '詹皇', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('55', '亚美尼亚', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('56', '鸠山', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('58', '海外华人', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('59', '华侨', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('60', '假钞', '1', '1468811306', '0', '1', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('61', '假币', '1', '1468811407', '0', '1', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('62', '秀恩爱', '2', '1471343902', '0', '0', '1', '1', '#d9534f', '0', 'bold');
INSERT INTO `ebcms5_content_tag` VALUES ('63', '飞的', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('64', '家庭暴力', '2', '1469841887', '0', '1', '1', '1', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('65', '家庭犯罪', '1', '1468811315', '0', '1', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('66', '富豪', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('67', '炫富', '1', '1468811281', '0', '1', '1', '1', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('68', '骚扰电话', '1', '1468811298', '0', '1', '1', '1', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('69', '电话诈骗', '1', '1468811299', '0', '0', '1', '1', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('70', '动画片', '1', '0', '0', '0', '1', '1', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('71', '教育', '1', '0', '0', '0', '1', '1', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('72', '贪污', '1', '1468811297', '0', '1', '1', '1', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('73', '印度', '1', '0', '0', '0', '1', '1', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('74', '南海', '1', '1468811295', '0', '1', '1', '1', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('75', '菲律宾', '1', '1469252786', '0', '1', '1', '1', '#d9534f', '0', 'bold');
INSERT INTO `ebcms5_content_tag` VALUES ('76', '俄罗斯', '1', '0', '0', '0', '1', '1', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('77', '韩国', '1', '0', '0', '0', '1', '1', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('78', '核技术', '1', '0', '0', '0', '1', '1', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('79', '萨德', '1', '1469167698', '0', '0', '1', '1', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('80', '太平岛', '1', '0', '0', '0', '1', '1', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('81', '测试', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('82', '123', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('83', '罗塞塔', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('84', '彗星', '1', '0', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_content_tag` VALUES ('85', '南海问题', '4', '1471860805', '1471860794', '1', '1', '0', '#d9534f', '0', '900');

-- ----------------------------
-- Table structure for ebcms5_content_tags
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_content_tags`;
CREATE TABLE `ebcms5_content_tags` (
  `c_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '内容ID',
  `tag_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '标签ID'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='内容标签关联表';

-- ----------------------------
-- Records of ebcms5_content_tags
-- ----------------------------
INSERT INTO `ebcms5_content_tags` VALUES ('12', '72');
INSERT INTO `ebcms5_content_tags` VALUES ('58', '3');
INSERT INTO `ebcms5_content_tags` VALUES ('58', '2');
INSERT INTO `ebcms5_content_tags` VALUES ('57', '4');
INSERT INTO `ebcms5_content_tags` VALUES ('56', '6');
INSERT INTO `ebcms5_content_tags` VALUES ('56', '5');
INSERT INTO `ebcms5_content_tags` VALUES ('55', '7');
INSERT INTO `ebcms5_content_tags` VALUES ('54', '8');
INSERT INTO `ebcms5_content_tags` VALUES ('53', '8');
INSERT INTO `ebcms5_content_tags` VALUES ('52', '9');
INSERT INTO `ebcms5_content_tags` VALUES ('51', '8');
INSERT INTO `ebcms5_content_tags` VALUES ('50', '11');
INSERT INTO `ebcms5_content_tags` VALUES ('50', '10');
INSERT INTO `ebcms5_content_tags` VALUES ('49', '12');
INSERT INTO `ebcms5_content_tags` VALUES ('48', '14');
INSERT INTO `ebcms5_content_tags` VALUES ('48', '13');
INSERT INTO `ebcms5_content_tags` VALUES ('47', '18');
INSERT INTO `ebcms5_content_tags` VALUES ('47', '17');
INSERT INTO `ebcms5_content_tags` VALUES ('47', '16');
INSERT INTO `ebcms5_content_tags` VALUES ('47', '15');
INSERT INTO `ebcms5_content_tags` VALUES ('46', '20');
INSERT INTO `ebcms5_content_tags` VALUES ('46', '19');
INSERT INTO `ebcms5_content_tags` VALUES ('45', '22');
INSERT INTO `ebcms5_content_tags` VALUES ('45', '21');
INSERT INTO `ebcms5_content_tags` VALUES ('44', '23');
INSERT INTO `ebcms5_content_tags` VALUES ('43', '24');
INSERT INTO `ebcms5_content_tags` VALUES ('42', '27');
INSERT INTO `ebcms5_content_tags` VALUES ('42', '26');
INSERT INTO `ebcms5_content_tags` VALUES ('42', '25');
INSERT INTO `ebcms5_content_tags` VALUES ('41', '28');
INSERT INTO `ebcms5_content_tags` VALUES ('40', '29');
INSERT INTO `ebcms5_content_tags` VALUES ('39', '31');
INSERT INTO `ebcms5_content_tags` VALUES ('39', '30');
INSERT INTO `ebcms5_content_tags` VALUES ('38', '34');
INSERT INTO `ebcms5_content_tags` VALUES ('38', '33');
INSERT INTO `ebcms5_content_tags` VALUES ('38', '32');
INSERT INTO `ebcms5_content_tags` VALUES ('37', '35');
INSERT INTO `ebcms5_content_tags` VALUES ('36', '36');
INSERT INTO `ebcms5_content_tags` VALUES ('35', '37');
INSERT INTO `ebcms5_content_tags` VALUES ('34', '40');
INSERT INTO `ebcms5_content_tags` VALUES ('34', '38');
INSERT INTO `ebcms5_content_tags` VALUES ('34', '39');
INSERT INTO `ebcms5_content_tags` VALUES ('33', '42');
INSERT INTO `ebcms5_content_tags` VALUES ('33', '41');
INSERT INTO `ebcms5_content_tags` VALUES ('32', '43');
INSERT INTO `ebcms5_content_tags` VALUES ('31', '44');
INSERT INTO `ebcms5_content_tags` VALUES ('30', '45');
INSERT INTO `ebcms5_content_tags` VALUES ('29', '47');
INSERT INTO `ebcms5_content_tags` VALUES ('29', '46');
INSERT INTO `ebcms5_content_tags` VALUES ('27', '48');
INSERT INTO `ebcms5_content_tags` VALUES ('27', '51');
INSERT INTO `ebcms5_content_tags` VALUES ('26', '53');
INSERT INTO `ebcms5_content_tags` VALUES ('26', '52');
INSERT INTO `ebcms5_content_tags` VALUES ('25', '54');
INSERT INTO `ebcms5_content_tags` VALUES ('24', '55');
INSERT INTO `ebcms5_content_tags` VALUES ('23', '28');
INSERT INTO `ebcms5_content_tags` VALUES ('1', '85');
INSERT INTO `ebcms5_content_tags` VALUES ('22', '56');
INSERT INTO `ebcms5_content_tags` VALUES ('21', '59');
INSERT INTO `ebcms5_content_tags` VALUES ('21', '58');
INSERT INTO `ebcms5_content_tags` VALUES ('20', '61');
INSERT INTO `ebcms5_content_tags` VALUES ('20', '60');
INSERT INTO `ebcms5_content_tags` VALUES ('19', '63');
INSERT INTO `ebcms5_content_tags` VALUES ('19', '62');
INSERT INTO `ebcms5_content_tags` VALUES ('18', '65');
INSERT INTO `ebcms5_content_tags` VALUES ('18', '64');
INSERT INTO `ebcms5_content_tags` VALUES ('17', '67');
INSERT INTO `ebcms5_content_tags` VALUES ('17', '66');
INSERT INTO `ebcms5_content_tags` VALUES ('16', '64');
INSERT INTO `ebcms5_content_tags` VALUES ('15', '62');
INSERT INTO `ebcms5_content_tags` VALUES ('14', '69');
INSERT INTO `ebcms5_content_tags` VALUES ('14', '68');
INSERT INTO `ebcms5_content_tags` VALUES ('13', '71');
INSERT INTO `ebcms5_content_tags` VALUES ('13', '70');
INSERT INTO `ebcms5_content_tags` VALUES ('12', '1');
INSERT INTO `ebcms5_content_tags` VALUES ('11', '73');
INSERT INTO `ebcms5_content_tags` VALUES ('9', '76');
INSERT INTO `ebcms5_content_tags` VALUES ('8', '78');
INSERT INTO `ebcms5_content_tags` VALUES ('8', '77');
INSERT INTO `ebcms5_content_tags` VALUES ('3', '85');
INSERT INTO `ebcms5_content_tags` VALUES ('5', '79');
INSERT INTO `ebcms5_content_tags` VALUES ('4', '80');
INSERT INTO `ebcms5_content_tags` VALUES ('6', '85');
INSERT INTO `ebcms5_content_tags` VALUES ('2', '28');
INSERT INTO `ebcms5_content_tags` VALUES ('22', '85');
INSERT INTO `ebcms5_content_tags` VALUES ('11', '81');
INSERT INTO `ebcms5_content_tags` VALUES ('84', '83');
INSERT INTO `ebcms5_content_tags` VALUES ('84', '84');

-- ----------------------------
-- Table structure for ebcms5_datadict
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_datadict`;
CREATE TABLE `ebcms5_datadict` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '配置ID',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父ID',
  `category_id` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '分类ID',
  `title` varchar(20) NOT NULL DEFAULT '' COMMENT '标题',
  `value` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `ext` text COMMENT '扩展信息',
  `remark` varchar(255) NOT NULL DEFAULT '' COMMENT '说明',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  `locked` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '锁定',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=489 DEFAULT CHARSET=utf8 COMMENT='数据字典表';

-- ----------------------------
-- Records of ebcms5_datadict
-- ----------------------------
INSERT INTO `ebcms5_datadict` VALUES ('9', '0', '3', '后台菜单', 'admin', '', '', '2015', '2015', '1', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('10', '0', '4', '图片文件', 'jpeg,jpg,gif,bmp,png', '', '', '2015', '2015', '20', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('11', '10', '4', 'JPG', 'jpg', '', '', '2015', '2015', '1', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('12', '10', '4', 'PNG', 'png', '', '', '2015', '2015', '1', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('13', '10', '4', 'GIF', 'gif', '', '', '2015', '2015', '1', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('14', '10', '4', 'BMP', 'bmp', '', '', '1467883359', '2015', '1', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('15', '10', '4', 'JPEG', 'jpeg', '', '', '2015', '2015', '1', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('16', '0', '4', '视频文件', 'rmvb,rmb,mkv,mp4,3gp,avi', '', '', '2015', '2015', '10', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('17', '16', '4', 'RMVB', 'rmvb', '', '', '2015', '2015', '1', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('18', '16', '4', 'MKV', 'mkv', '', '', '2015', '2015', '1', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('19', '16', '4', 'RMB', 'rmb', '', '', '2015', '2015', '1', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('20', '16', '4', 'AVI', 'avi', '', '', '2015', '2015', '1', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('21', '16', '4', 'MP4', 'mp4', '', '', '2015', '2015', '1', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('22', '16', '4', '3GP', '3gp', '', '', '2015', '2015', '1', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('23', '0', '4', '其他类型', 'zip,rar,7z', '', '', '2015', '2015', '1', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('25', '0', '5', '模板样式', '{{eb_encrypt(ROOT_PATH.\'templates\'.DS)}}', '', '', '1472004472', '2015', '1', '1', '1');
INSERT INTO `ebcms5_datadict` VALUES ('26', '0', '5', '静态资源', '{{eb_encrypt(\'./static\')}}', '', '', '1469491152', '2015', '1', '1', '1');
INSERT INTO `ebcms5_datadict` VALUES ('27', '0', '6', '字符', 'string', '', 'required:true/false //是否必填\r\n', '2015', '2015', '250', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('29', '0', '6', '整数', 'number', '', '\r\n\r\n\r\n\r\n\r\n\r\n\r\n**注意事项**\r\n*双大括号括起来的标示变量，例如:{{time()}}、{{__FILE__}、{{$value}}等等', '2015', '2015', '222', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('30', '0', '6', '布尔', 'bool', '', '0或1\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n**注意事项**\r\n*双大括号括起来的标示变量，例如:{{time()}}、{{__FILE__}、{{$value}}等等', '2015', '2015', '210', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('31', '0', '6', '浮点数', 'float', '', '一行一条，例如：\r\n中国\r\n日本\r\n韩国\r\n德国\r\n\r\n\r\n\r\n**注意事项**\r\n*双大括号括起来的标示变量，例如:{{time()}}、{{__FILE__}、{{$value}}等等', '2015', '2015', '195', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('32', '0', '6', 'JSON', 'json', '', '标准的json数据格式！\r\n例如：\r\n{\r\n&quot;key1&quot;:&quot;value1&quot;,\r\n&quot;key2&quot;:&quot;value2&quot;\r\n}\r\n例如：\r\n[&quot;value1&quot;,&quot;value2&quot;]\r\n**注意事项**\r\n*双大括号括起来的标示变量，例如:{{time()}}、{{__FILE__}、{{$value}}等等', '2015', '2015', '40', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('33', '0', '6', 'INI', 'ini', '', 'key1=value1;\r\nkey2=value2;\r\n\r\n\r\n\r\n\r\n\r\n\r\n**注意事项**\r\n*双大括号括起来的标示变量，例如:{{time()}}、{{__FILE__}、{{$value}}等等', '2015', '2015', '25', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('34', '0', '6', 'YAML', 'yaml', '', '\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n**注意事项**\r\n*双大括号括起来的标示变量，例如:{{time()}}、{{__FILE__}、{{$value}}等等', '2015', '2015', '14', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('35', '0', '6', 'XML', 'xml', '', '\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n**注意事项**\r\n*双大括号括起来的标示变量，例如:{{time()}}、{{__FILE__}、{{$value}}等等', '2015', '2015', '1', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('200', '0', '9', '当前栏目', '1', '', '', '2015', '2015', '247', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('201', '0', '9', '不调用', '0', '', '', '2015', '2015', '232', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('202', '0', '9', '当前栏目及子栏目', '2', '', '', '1468921991', '2015', '198', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('203', '0', '9', '所有子孙栏目', '3', '', '', '2015', '2015', '165', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('204', '0', '9', '所有栏目', '4', '', '', '1468921983', '2015', '1', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('251', '0', '14', '1分钟', '60', '', '', '2015', '2015', '50', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('252', '0', '14', '5分钟', '300', '', '', '2015', '2015', '49', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('253', '0', '14', '10分钟', '600', '', '', '2015', '2015', '48', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('254', '0', '14', '15分钟', '900', '', '', '2015', '2015', '47', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('255', '0', '14', '30分钟', '1800', '', '', '2015', '2015', '46', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('256', '0', '14', '1小时', '3600', '', '', '2015', '2015', '45', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('257', '0', '14', '2小时', '7200', '', '', '2015', '2015', '44', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('258', '0', '14', '3小时', '10800', '', '', '2015', '2015', '43', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('259', '0', '14', '4小时', '14400', '', '', '2015', '2015', '42', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('260', '0', '14', '5小时', '18000', '', '', '2015', '2015', '41', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('261', '0', '14', '6小时', '21600', '', '', '2015', '2015', '40', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('262', '0', '14', '8小时', '28800', '', '', '2015', '2015', '39', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('263', '0', '14', '10小时', '36000', '', '', '2015', '2015', '38', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('264', '0', '14', '12小时', '39600', '', '', '2015', '2015', '37', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('265', '0', '14', '1天', '86400', '', '', '2015', '2015', '36', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('266', '0', '14', '2天', '172800', '', '', '2015', '2015', '35', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('267', '0', '14', '3天', '259200', '', '', '2015', '2015', '34', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('268', '0', '14', '5天', '432000', '', '', '2015', '2015', '33', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('290', '0', '6', '枚举', 'item', '', '一样一个，例如\r\nhaha\r\nhehe\r\nxixi', '2015', '2015', '2', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('315', '0', '22', '超链接', 'url', '', '', '2015', '2015', '1', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('316', '0', '22', '电子邮箱', 'email', '{\"test\":\"332\"}', '', '2015', '2015', '1', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('483', '0', '27', '内容栏目', 'content/category', '', '', '1470233848', '1470233848', '0', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('484', '0', '27', '导航分类', 'admin/navcate', '', '', '1470233885', '1470233885', '0', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('485', '0', '27', '角色列表', 'admin/group', '', '', '1471334463', '1470233926', '0', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('486', '0', '27', '推荐位', 'admin/recommendcate', '', '', '1471334472', '1470233946', '0', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('487', '0', '27', '数据源', 'admin/datadictcate', '', '', '1470234001', '1470234001', '0', '1', '0');
INSERT INTO `ebcms5_datadict` VALUES ('488', '0', '27', '后台菜单', 'admin/menu', '', '', '1470234022', '1470234022', '0', '1', '0');

-- ----------------------------
-- Table structure for ebcms5_datadictcate
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_datadictcate`;
CREATE TABLE `ebcms5_datadictcate` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `group` varchar(255) NOT NULL DEFAULT '' COMMENT '分组',
  `title` varchar(20) NOT NULL DEFAULT '' COMMENT '标题',
  `field` varchar(20) NOT NULL DEFAULT '' COMMENT '字段',
  `extend_id` varchar(255) NOT NULL DEFAULT '' COMMENT '扩展id',
  `remark` varchar(255) NOT NULL DEFAULT '' COMMENT '说明',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `sort` int(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  `locked` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '锁定',
  `system` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '系统',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=28 DEFAULT CHARSET=utf8 COMMENT='数据字典分类表';

-- ----------------------------
-- Records of ebcms5_datadictcate
-- ----------------------------
INSERT INTO `ebcms5_datadictcate` VALUES ('3', '核心字典', '菜单分类', 'menutype', '10', '未填写', '2015', '2015', '1', '1', '1', '1');
INSERT INTO `ebcms5_datadictcate` VALUES ('4', '核心字典', '附件分类', 'attachtype', '', '', '2015', '2015', '44', '1', '1', '1');
INSERT INTO `ebcms5_datadictcate` VALUES ('5', '核心字典', '模板分类', 'tpltype', '', '', '2015', '2015', '1', '1', '1', '1');
INSERT INTO `ebcms5_datadictcate` VALUES ('6', '核心字典', '配置解析类型', 'configtype', '', '', '2015', '2015', '99', '1', '1', '1');
INSERT INTO `ebcms5_datadictcate` VALUES ('9', '核心字典', '内容调用方式', 'recursion', '', '', '2015', '2015', '1', '1', '0', '1');
INSERT INTO `ebcms5_datadictcate` VALUES ('14', '核心字典', '秒', 'second', '', '', '2015', '2015', '1', '1', '0', '1');
INSERT INTO `ebcms5_datadictcate` VALUES ('22', '核心字典', '表单认证类型', 'formvalidtype', '1', '', '2015', '2015', '2', '1', '0', '1');
INSERT INTO `ebcms5_datadictcate` VALUES ('27', '核心字典', '常用模型', 'models', '0', '常用模型', '1470233817', '1470233817', '0', '1', '0', '1');

-- ----------------------------
-- Table structure for ebcms5_extend
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_extend`;
CREATE TABLE `ebcms5_extend` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `group` varchar(255) NOT NULL DEFAULT '' COMMENT '分组',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `remark` varchar(255) NOT NULL DEFAULT '' COMMENT '说明',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  `locked` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否锁定',
  `sys_mark` varchar(255) NOT NULL DEFAULT '' COMMENT '系统标志',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COMMENT='扩展表';

-- ----------------------------
-- Records of ebcms5_extend
-- ----------------------------
INSERT INTO `ebcms5_extend` VALUES ('1', '内容扩展', '产品扩展', '', '9', '1467854024', '2015', '1', '0', '');
INSERT INTO `ebcms5_extend` VALUES ('2', '导航扩展', '顶部导航', '', '7', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_extend` VALUES ('3', '推荐扩展', '扩展1', '', '5', '1469414392', '2015', '1', '0', '');
INSERT INTO `ebcms5_extend` VALUES ('4', '字典扩展', '地区扩展', '', '3', '2016', '2016', '1', '0', '');
INSERT INTO `ebcms5_extend` VALUES ('8', '内容扩展', '图集扩展', '', '0', '1467988554', '1467988554', '1', '0', '');

-- ----------------------------
-- Table structure for ebcms5_extendfield
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_extendfield`;
CREATE TABLE `ebcms5_extendfield` (
  `id` int(4) unsigned NOT NULL AUTO_INCREMENT COMMENT '配置ID',
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分类',
  `group` varchar(250) NOT NULL DEFAULT '' COMMENT '分组',
  `title` varchar(250) NOT NULL DEFAULT '' COMMENT '标题',
  `name` char(40) NOT NULL DEFAULT '' COMMENT '键',
  `value` text COMMENT '默认值',
  `type` varchar(255) NOT NULL DEFAULT '' COMMENT '表单类型',
  `config` text COMMENT '表单配置',
  `remark` text COMMENT '表单说明',
  `sort` int(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  `locked` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '锁定',
  `sys_mark` varchar(255) NOT NULL DEFAULT '' COMMENT '系统标志',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COMMENT='扩展字段表';

-- ----------------------------
-- Records of ebcms5_extendfield
-- ----------------------------
INSERT INTO `ebcms5_extendfield` VALUES ('13', '1', '产品资料', '产品图', 'pics', '', 'form_images', '', '', '0', '1469000565', '2016', '1', '0', '');
INSERT INTO `ebcms5_extendfield` VALUES ('2', '2', '其他设置', '字体颜色', 'color', '', 'form_radio', '{\"disabled\":\"0\",\"readonly\":\"0\",\"values\":\"红|red\\r\\n绿|green\\r\\n蓝|blue\"}', '', '2', '1469458529', '2015', '1', '0', '');
INSERT INTO `ebcms5_extendfield` VALUES ('4', '3', '扩展', '推荐理由', 'tjly', '', 'form_multitextbox', '', '', '0', '1469414360', '2015', '1', '0', '');
INSERT INTO `ebcms5_extendfield` VALUES ('21', '3', '扩展', '单选', 'radio', 'beijing', 'form_radio', '{\"disabled\":\"0\",\"readonly\":\"0\",\"values\":\"哈哈|haha\\r\\n中国|china\\r\\n北京|beijing\"}', '', '0', '1469453506', '1469453479', '1', '0', '');
INSERT INTO `ebcms5_extendfield` VALUES ('19', '4', '基本信息', '国家代号', 'daihao', '', 'form_textbox', '', '', '0', '1469412670', '1469412670', '1', '0', '');
INSERT INTO `ebcms5_extendfield` VALUES ('20', '4', '基本信息', '国旗', 'guoqi', '', 'form_textbox', '', '', '0', '1469412697', '1469412697', '1', '0', '');
INSERT INTO `ebcms5_extendfield` VALUES ('14', '1', '产品资料', '价格', 'price', '', 'form_textbox', '{\"datadict\":\"area\",\"editable\":\"1\",\"required\":\"1\",\"rootitem\":\"1\",\"disabled\":\"0\",\"readonly\":\"0\",\"prompt\":\"\"}', '', '9', '1469413244', '1457573415', '1', '0', '');
INSERT INTO `ebcms5_extendfield` VALUES ('16', '8', '图集管理', '图集', 'pics', '', 'form_images', '{\"required\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"extensions\":\"\",\"prompt\":\"\"}', '', '0', '1469411114', '1467988587', '1', '1', '');
INSERT INTO `ebcms5_extendfield` VALUES ('17', '1', '更多参数', '参数', 'param', '', 'form_extend', '{\"required\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"height\":\"\",\"width\":\"\",\"maxlength\":\"\",\"minlength\":\"\",\"prompt\":\"\"}', '', '0', '1469413279', '1468162609', '1', '0', '');
INSERT INTO `ebcms5_extendfield` VALUES ('22', '3', '扩展', '多选', 'checkbox', 'black', 'form_checkbox', '{\"disabled\":\"0\",\"readonly\":\"0\",\"values\":\"红色|red\\r\\n绿色|green\\r\\n黑色|black\\r\\n灰色|gray\"}', '', '0', '1469453546', '1469453528', '1', '0', '');
INSERT INTO `ebcms5_extendfield` VALUES ('23', '1', '阿斯蒂芬', '但文本扩展', 'xxx1', '', 'form_select', '{\"values\":\"红色|red\\r\\n绿色|green\\r\\n黑色|black\\r\\n灰色|gray\",\"editable\":\"1\",\"readonly\":\"0\",\"disabled\":\"0\"}', '', '0', '1470234436', '1469868152', '1', '0', '');

-- ----------------------------
-- Table structure for ebcms5_form
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_form`;
CREATE TABLE `ebcms5_form` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `group` varchar(255) NOT NULL DEFAULT '' COMMENT '分组',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '名称',
  `remark` varchar(255) NOT NULL DEFAULT '' COMMENT '说明',
  `sort` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  `locked` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否锁定',
  `ext` text COMMENT '扩展信息',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=148 DEFAULT CHARSET=utf8 COMMENT='表单表';

-- ----------------------------
-- Records of ebcms5_form
-- ----------------------------
INSERT INTO `ebcms5_form` VALUES ('19', '表单配置', '单行文本', 'form_textbox', '', '101', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_form` VALUES ('20', '表单配置', '布尔选项', 'form_bool', '', '56', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_form` VALUES ('21', '表单配置', '隐藏域', 'form_hidden', '', '1', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_form` VALUES ('22', '表单配置', '百度编辑器', 'form_ueditor', '', '86', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_form` VALUES ('23', '表单配置', '数字框', 'form_numberbox', '', '91', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_form` VALUES ('24', '表单配置', '图片', 'form_image', '', '69', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_form` VALUES ('25', '表单配置', '多图上传', 'form_images', '', '66', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_form` VALUES ('26', '表单配置', '附件', 'form_file', '', '68', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_form` VALUES ('27', '表单配置', '多附件', 'form_files', '', '62', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_form` VALUES ('28', '表单配置', '日期', 'form_datebox', '', '33', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_form` VALUES ('29', '表单配置', '时间', 'form_time', '', '31', '2016', '2015', '1', '0', '');
INSERT INTO `ebcms5_form` VALUES ('30', '表单配置', '时间日期', 'form_datetimebox', '', '32', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_form` VALUES ('32', '表单配置', '下拉选项（数据源）', 'form_combotree', '', '45', '1457272266', '2015', '1', '0', '');
INSERT INTO `ebcms5_form` VALUES ('33', '表单配置', '多行文本', 'form_multitextbox', '', '97', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_form` VALUES ('34', '表单配置', '数据字典', 'form_datadict', '', '47', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_form` VALUES ('47', '模板管理', '添加', 'admin_template_add', '', '121', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_form` VALUES ('48', '模板管理', '修改', 'admin_template_edit', '', '1', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_form` VALUES ('50', '用户管理', '添加角色', 'admin_group_add', '', '66', '1471335921', '2015', '1', '0', '{\"submit_alert\":\"0\",\"submit_msg\":\"\"}');
INSERT INTO `ebcms5_form` VALUES ('51', '用户管理', '修改角色', 'admin_group_edit', '', '56', '1471335925', '2015', '1', '0', '{\"submit_alert\":\"0\",\"submit_msg\":\"\"}');
INSERT INTO `ebcms5_form` VALUES ('52', '用户管理', '添加用户', 'admin_user_add', '', '136', '1471335913', '2015', '1', '0', '{\"submit_alert\":\"0\",\"submit_msg\":\"\"}');
INSERT INTO `ebcms5_form` VALUES ('53', '用户管理', '修改用户', 'admin_user_edit', '', '75', '1471335917', '2015', '1', '0', '{\"submit_alert\":\"0\",\"submit_msg\":\"\"}');
INSERT INTO `ebcms5_form` VALUES ('54', '扩展管理', '添加扩展', 'admin_extend_add', '', '141', '1467988370', '2015', '1', '0', '{\"submit_msg\":\"\"}');
INSERT INTO `ebcms5_form` VALUES ('55', '扩展管理', '修改扩展', 'admin_extend_edit', '', '71', '1467988376', '2015', '1', '0', '{\"submit_msg\":\"\"}');
INSERT INTO `ebcms5_form` VALUES ('56', '扩展管理', '添加字段', 'admin_extendfield_add', '', '60', '1467988383', '2015', '1', '0', '{\"submit_msg\":\"\"}');
INSERT INTO `ebcms5_form` VALUES ('57', '扩展管理', '修改字段', 'admin_extendfield_edit', '', '1', '1467988389', '2015', '1', '0', '{\"submit_msg\":\"\"}');
INSERT INTO `ebcms5_form` VALUES ('64', '表单配置', '单选', 'form_radio', '', '72', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_form` VALUES ('65', '表单配置', '复选', 'form_checkbox', '', '71', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_form` VALUES ('66', '数据字典', '添加字典分类', 'admin_datadictcate_add', '', '128', '1468488877', '2015', '1', '0', '{\"submit_msg\":\"\"}');
INSERT INTO `ebcms5_form` VALUES ('67', '数据字典', '修改字典分类', 'admin_datadictcate_edit', '', '86', '1468488881', '2015', '1', '0', '{\"submit_msg\":\"\"}');
INSERT INTO `ebcms5_form` VALUES ('68', '数据字典', '添加字典', 'admin_datadict_add', '', '59', '1468488885', '2015', '1', '0', '{\"submit_msg\":\"\"}');
INSERT INTO `ebcms5_form` VALUES ('69', '数据字典', '修改字典', 'admin_datadict_edit', '', '1', '1468488889', '2015', '1', '0', '{\"submit_msg\":\"\"}');
INSERT INTO `ebcms5_form` VALUES ('76', '内容管理', '添加分类', 'content_admin.category_add', '', '160', '1457501688', '2015', '1', '0', '');
INSERT INTO `ebcms5_form` VALUES ('77', '内容管理', '修改分类', 'content_admin.category_edit', '', '49', '1457501694', '2015', '1', '0', '');
INSERT INTO `ebcms5_form` VALUES ('78', '内容管理', '添加内容', 'content_admin.content_add', '', '39', '1457501646', '2015', '1', '0', '');
INSERT INTO `ebcms5_form` VALUES ('79', '内容管理', '修改内容', 'content_admin.content_edit', '', '38', '1457501651', '2015', '1', '0', '');
INSERT INTO `ebcms5_form` VALUES ('80', '导航管理', '添加导航', 'admin_nav_add', '', '155', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_form` VALUES ('81', '导航管理', '修改导航', 'admin_nav_edit', '', '50', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_form` VALUES ('82', '导航管理', '添加导航分类', 'admin_navcate_add', '', '30', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_form` VALUES ('83', '导航管理', '修改导航分类', 'admin_navcate_edit', '', '20', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_form` VALUES ('84', '友情链接', '添加友情链接', 'admin_link_add', '', '154', '1471335858', '2015', '1', '0', '{\"submit_alert\":\"0\",\"submit_msg\":\"\"}');
INSERT INTO `ebcms5_form` VALUES ('85', '友情链接', '修改友情链接', 'admin_link_edit', '', '1', '1471335863', '2015', '1', '0', '{\"submit_alert\":\"0\",\"submit_msg\":\"\"}');
INSERT INTO `ebcms5_form` VALUES ('86', '留言中心', '修改留言', 'admin_guestbook_edit', '', '153', '1471335869', '2015', '1', '0', '{\"submit_alert\":\"0\",\"submit_msg\":\"\"}');
INSERT INTO `ebcms5_form` VALUES ('87', '留言中心', '回复留言', 'admin_guestbook_reply', '', '50', '1471335875', '2015', '1', '0', '{\"submit_alert\":\"0\",\"submit_msg\":\"\"}');
INSERT INTO `ebcms5_form` VALUES ('88', '推荐管理', '添加推荐位', 'admin_recommendcate_add', '', '152', '1471335881', '2015', '1', '0', '{\"submit_alert\":\"0\",\"submit_msg\":\"\"}');
INSERT INTO `ebcms5_form` VALUES ('89', '推荐管理', '修改推荐位', 'admin_recommendcate_edit', '', '45', '1471335886', '2015', '1', '0', '{\"submit_alert\":\"0\",\"submit_msg\":\"\"}');
INSERT INTO `ebcms5_form` VALUES ('90', '推荐管理', '添加推荐内容', 'admin_recommend_add', '', '40', '1471335899', '2015', '1', '0', '{\"submit_alert\":\"0\",\"submit_msg\":\"\"}');
INSERT INTO `ebcms5_form` VALUES ('91', '推荐管理', '修改推荐内容', 'admin_recommend_edit', '', '35', '1471335905', '2015', '1', '0', '{\"submit_alert\":\"0\",\"submit_msg\":\"\"}');
INSERT INTO `ebcms5_form` VALUES ('98', '基本表单', '修改密码', 'admin_index_password', '', '122', '2016', '2016', '1', '0', '');
INSERT INTO `ebcms5_form` VALUES ('107', '表单配置', '下拉选项（枚举）', 'form_select', '', '44', '1457272331', '1457272331', '1', '0', '');
INSERT INTO `ebcms5_form` VALUES ('108', '自定义配置', '添加', 'admin_config_add', '', '128', '1468484127', '1457591227', '1', '0', '{\"submit_msg\":\"\"}');
INSERT INTO `ebcms5_form` VALUES ('109', '自定义配置', '修改', 'admin_config_edit', '', '1', '1468484138', '1457591250', '1', '0', '{\"submit_msg\":\"\"}');
INSERT INTO `ebcms5_form` VALUES ('110', '单页管理', '添加单页', 'admin_single_add', '', '240', '1471335842', '1460040107', '1', '0', '{\"submit_alert\":\"0\",\"submit_msg\":\"\"}');
INSERT INTO `ebcms5_form` VALUES ('111', '单页管理', '修改单页', 'admin_single_edit', '', '0', '1471335848', '1460040129', '1', '0', '{\"submit_alert\":\"0\",\"submit_msg\":\"\"}');
INSERT INTO `ebcms5_form` VALUES ('117', '表单配置', '扩展类型', 'form_extend', '扩展类型表单。强大的表单。', '2', '0', '0', '1', '0', '');
INSERT INTO `ebcms5_form` VALUES ('129', '基本表单', '地址替换', 'admin_index_replaceattachbaseurl', '', '0', '1468045970', '0', '1', '0', '{\"submit_alert\":\"1\",\"submit_msg\":\"<p><span style=\\\"color: rgb(255, 0, 0);\\\"><strong>\\u8be5\\u64cd\\u4f5c\\u76f8\\u5f53\\u5371\\u9669\\uff01<\\/strong><\\/span><\\/p><p><span style=\\\"color: rgb(255, 0, 0);\\\"><strong>\\u4e00\\u65e6\\u63d0\\u4ea4\\uff0c\\u65e0\\u6cd5\\u6062\\u590d!<\\/strong><\\/span><\\/p><p><span style=\\\"color: rgb(255, 0, 0);\\\"><strong>\\u5efa\\u8bae\\u60a8\\u6267\\u884c\\u6b64\\u64cd\\u4f5c\\u524d\\u5148\\u5907\\u4efd\\u6570\\u636e\\u5e93!<\\/strong><\\/span><\\/p><p>\\u4f60\\u786e\\u5b9a\\u8981\\u63d0\\u4ea4\\u5417\\uff1f<\\/p>\"}');
INSERT INTO `ebcms5_form` VALUES ('132', '内容管理', '标签合并', 'content_admin.tag_merge', '', '17', '1467944918', '1467944918', '1', '0', '{\"submit_alert\":\"0\",\"submit_msg\":\"\"}');
INSERT INTO `ebcms5_form` VALUES ('133', '内容管理', '添加标签', 'content_admin.tag_add', '', '19', '1468024466', '1468024466', '1', '0', '{\"submit_alert\":\"0\",\"submit_msg\":\"\"}');
INSERT INTO `ebcms5_form` VALUES ('134', '内容管理', '修改标签', 'content_admin.tag_edit', '', '18', '1468024479', '1468024479', '1', '0', '{\"submit_alert\":\"0\",\"submit_msg\":\"\"}');
INSERT INTO `ebcms5_form` VALUES ('135', '内容管理', '修改评论', 'content_admin.comment_edit', '', '29', '1469457496', '1468030119', '1', '0', '{\"submit_alert\":\"0\",\"submit_msg\":\"<p>尽量不要随意修改用户评论\\r\\n修改吗？<\\/p>\"}');
INSERT INTO `ebcms5_form` VALUES ('136', '内容管理', '内容批量移动', 'content_admin.content_move', '', '37', '1468980178', '1468979536', '1', '0', '{\"submit_alert\":\"1\",\"submit_msg\":\"<p>如果移动的内容和移动到的栏目的模型不一样，会造成移动的内容中模型不一样的那一部分数据的自定义扩展内容数据丢失，但主体内容数据不会丢失！<\\/p><p>提交吗？<\\/p>\"}');
INSERT INTO `ebcms5_form` VALUES ('137', '内容管理', '合并', 'content_admin.category_merge', '', '48', '1468985844', '1468985263', '1', '0', '{\"submit_alert\":\"1\",\"submit_msg\":\"<p>不同模型之间的栏目合并，如果和目标栏目模型不一样，<strong>会造成这些栏目下面的内容的自定义扩展数据丢失<\\/strong>，但主体内容不受影响！<\\/p><p><strong><span style=\\\"color: rgb(255, 0, 0);\\\">提交吗？<\\/span><\\/strong><\\/p>\"}');
INSERT INTO `ebcms5_form` VALUES ('138', '表单配置', '单行文本扩展', 'form_extendtext', '', '3', '1469868111', '1469868111', '1', '0', '{\"submit_alert\":\"0\",\"submit_msg\":\"\"}');
INSERT INTO `ebcms5_form` VALUES ('139', '表单配置', '关键字', 'form_keywords', '', '4', '1470312668', '1470312668', '1', '0', '{\"submit_alert\":\"0\",\"submit_msg\":\"\"}');
INSERT INTO `ebcms5_form` VALUES ('142', '万能表单', '添加表单', 'forms_forms_add', '', '0', '1471739897', '1471739897', '1', '0', '{\"submit_alert\":\"0\",\"submit_msg\":\"\"}');
INSERT INTO `ebcms5_form` VALUES ('143', '万能表单', '修改表单', 'forms_forms_edit', '', '0', '1471739912', '1471739912', '1', '0', '{\"submit_alert\":\"0\",\"submit_msg\":\"\"}');
INSERT INTO `ebcms5_form` VALUES ('144', '万能表单', '添加字段', 'forms_formsfield_add', '', '0', '1471739929', '1471739929', '1', '0', '{\"submit_alert\":\"0\",\"submit_msg\":\"\"}');
INSERT INTO `ebcms5_form` VALUES ('145', '万能表单', '编辑字段', 'forms_formsfield_edit', '', '0', '1471739942', '1471739942', '1', '0', '{\"submit_alert\":\"0\",\"submit_msg\":\"\"}');
INSERT INTO `ebcms5_form` VALUES ('146', '公告管理', '添加公告', 'bulletin_bulletin_add', '', '0', '1471834705', '1471834705', '1', '0', '{\"submit_alert\":\"0\",\"submit_msg\":\"\"}');
INSERT INTO `ebcms5_form` VALUES ('147', '公告管理', '编辑公告', 'bulletin_bulletin_edit', '', '0', '1471834719', '1471834719', '1', '0', '{\"submit_alert\":\"0\",\"submit_msg\":\"\"}');

-- ----------------------------
-- Table structure for ebcms5_formfield
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_formfield`;
CREATE TABLE `ebcms5_formfield` (
  `id` int(4) unsigned NOT NULL AUTO_INCREMENT COMMENT '配置ID',
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分类',
  `group` varchar(250) NOT NULL DEFAULT '' COMMENT '分组',
  `title` varchar(250) NOT NULL DEFAULT '' COMMENT '标题',
  `subtable` varchar(250) NOT NULL DEFAULT '' COMMENT '副表',
  `extfield` varchar(250) NOT NULL DEFAULT '' COMMENT '扩展字段',
  `name` char(40) NOT NULL DEFAULT '' COMMENT '键',
  `defaultvaluetype` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '取值类型',
  `defaultvalue` text COMMENT '默认值',
  `type` varchar(255) NOT NULL DEFAULT '' COMMENT '表单类型',
  `config` text COMMENT '表单配置',
  `remark` text COMMENT '表单说明',
  `sort` int(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  `locked` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '锁定',
  `sys_mark` varchar(255) NOT NULL DEFAULT '' COMMENT '系统标致',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=914 DEFAULT CHARSET=utf8 COMMENT='表单字段表';

-- ----------------------------
-- Records of ebcms5_formfield
-- ----------------------------
INSERT INTO `ebcms5_formfield` VALUES ('352', '66', '基本信息', '扩展', '', '', 'extend_id', '0', '', 'form_combotree', '{\"model\":\"admin\\/extend\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"1\",\"tree\":\"0\",\"prompt\":\"\",\"queryparams\":\"group|eq|\\u5b57\\u5178\\u6269\\u5c55\",\"pid\":\"\",\"textfield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '可以进入左上角的扩展  自定义更多字段扩展', '20', '1468489552', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('353', '66', '基本信息', '备注', '', '', 'remark', '0', '', 'form_multitextbox', '', '', '14', '1470233279', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('10', '11', '阿斯顿发', '附件', '', '', 'attachment', '0', '', 'form_files', '', '', '1', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('72', '31', '基本配置', '是否必填', '', 'config', 'required', '3', 'required', 'form_bool', '', '', '50', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('26', '19', '基本配置', 'id', '', '', 'id', '1', 'id', 'form_hidden', '', '', '1', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('71', '31', '基本配置', 'id', '', '', 'id', '1', 'id', 'form_hidden', '', '', '1', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('27', '19', '基本配置', '是否必填', '', 'config', 'required', '3', 'required', 'form_bool', '', '', '45', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('32', '33', '基本配置', '宽度', '', 'config', 'width', '3', 'width', 'form_numberbox', '', '不填写表示 100% ', '30', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('29', '33', '基本配置', '是否必填', '', 'config', 'required', '3', 'required', 'form_bool', '', '', '48', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('30', '33', '基本配置', 'id', '', '', 'id', '1', 'id', 'form_hidden', '', '', '1', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('31', '33', '基本配置', '高度', '', 'config', 'height', '3', 'height', 'form_numberbox', '', '这里是指行数。默认5', '31', '1468487028', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('39', '19', '基本配置', '是否只读', '', 'config', 'readonly', '3', 'readonly', 'form_bool', '', '', '40', '1457834503', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('34', '33', '基本配置', '提示字符', '', 'config', 'prompt', '3', 'prompt', 'form_textbox', '{\"width\":\"\",\"prompt\":\"\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"required\":\"0\"}', '', '15', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('36', '33', '基本配置', '是否失效', '', 'config', 'disabled', '3', 'disabled', 'form_bool', '', '', '45', '1457834547', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('41', '19', '基本配置', '提示字符', '', 'config', 'prompt', '3', 'prompt', 'form_textbox', '{\"width\":\"\",\"prompt\":\"\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"required\":\"0\"}', '', '5', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('42', '33', '基本配置', '最少字符数', '', 'config', 'minlength', '3', 'minlength', 'form_numberbox', '', '默认0', '20', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('43', '33', '基本配置', '最大字符数', '', 'config', 'maxlength', '3', 'maxlength', 'form_numberbox', '', '默认999999', '21', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('45', '34', '基本配置', 'id', '', '', 'id', '1', 'id', 'form_hidden', '', '', '1', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('47', '34', '基本配置', '是否必填', '', 'config', 'required', '3', 'required', 'form_bool', '', '', '45', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('48', '34', '基本配置', '提示字符', '', 'config', 'prompt', '3', 'prompt', 'form_textbox', '', '', '10', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('53', '34', '基本配置', '是否失效', '', 'config', 'disabled', '3', 'disabled', 'form_bool', '', '', '30', '1457835284', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('55', '34', '基本配置', '数据来源', '', 'config', 'datadict', '3', 'datadict', 'form_combotree', '{\"model\":\"admin\\/datadictcate\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"0\",\"tree\":\"0\",\"prompt\":\"\",\"queryparams\":\"\",\"pid\":\"\",\"textfield\":\"\",\"valuefield\":\"field\",\"width\":\"\"}', '', '50', '1459572401', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('56', '32', '基本配置', 'id', '', '', 'id', '1', 'id', 'form_hidden', '', '', '1', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('57', '32', '基本配置', '模型名称', '', 'config', 'model', '3', 'model', 'form_datadict', '{\"datadict\":\"models\",\"editable\":\"1\",\"required\":\"0\",\"rootitem\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"prompt\":\"\"}', '对应的后台的模型名称', '50', '1470234107', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('58', '32', '其他配置', '宽度', '', 'config', 'width', '3', 'width', 'form_numberbox', '', '', '1', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('60', '32', '基本配置', '是否必填', '', 'config', 'required', '3', 'required', 'form_bool', '', '', '45', '1457835341', '2015', '0', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('61', '32', '基本配置', '提示字符', '', 'config', 'prompt', '3', 'prompt', 'form_textbox', '', '', '10', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('63', '32', '基本配置', '是否失效', '', 'config', 'disabled', '3', 'disabled', 'form_bool', '', '', '43', '1457835349', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('567', '32', '基本配置', '树型化', '', 'config', 'tree', '3', 'tree', 'form_bool', '', '', '35', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('68', '32', '其他配置', '递归字段', '', 'config', 'pid', '3', 'pid', 'form_textbox', '', '通常请不要修改 默认pid', '30', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('69', '32', '基本配置', '根选项', '', 'config', 'rootitem', '3', 'rootitem', 'form_bool', '', '根选项开启后 所有条目都会在根选项之下，通常用于选择父级 默认0', '40', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('73', '31', '基本配置', '提示信息', '', 'config', 'prompt', '3', 'prompt', 'form_textbox', '', '', '35', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('74', '31', '基本配置', '是否只读', '', 'config', 'readonly', '3', 'readonly', 'form_bool', '', '', '30', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('75', '31', '基本配置', '是否失效', '', 'config', 'disabled', '3', 'disabled', 'form_bool', '', '', '10', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('76', '31', '基本配置', '是否可编辑', '', 'config', 'editable', '3', 'editable', 'form_bool', '', '', '40', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('77', '30', '基本配置', 'id', '', '', 'id', '1', 'id', 'form_hidden', '', '', '1', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('78', '29', '基本配置', 'id', '', '', 'id', '1', 'id', 'form_hidden', '', '', '1', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('79', '28', '基本配置', 'id', '', '', 'id', '1', 'id', 'form_hidden', '', '', '1', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('80', '27', '基本配置', 'id', '', '', 'id', '1', 'id', 'form_hidden', '', '', '1', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('81', '26', '基本配置', 'id', '', '', 'id', '1', 'id', 'form_hidden', '', '', '1', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('82', '25', '基本配置', 'id', '', '', 'id', '1', 'id', 'form_hidden', '', '', '1', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('83', '24', '基本配置', 'id', '', '', 'id', '1', 'id', 'form_hidden', '', '', '1', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('84', '23', '基本配置', 'id', '', '', 'id', '1', 'id', 'form_hidden', '', '', '1', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('85', '22', '基本配置', 'id', '', '', 'id', '1', 'id', 'form_hidden', '', '', '1', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('86', '21', '基本配置', 'id', '', '', 'id', '1', 'id', 'form_hidden', '', '', '1', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('87', '20', '基本配置', 'id', '', '', 'id', '1', 'id', 'form_hidden', '', '', '1', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('88', '19', '基本配置', '认证类型', '', 'config', 'validtype', '3', 'validtype', 'form_datadict', '{\"datadict\":\"formvalidtype\",\"required\":\"0\",\"rootitem\":\"1\",\"disabled\":\"0\",\"prompt\":\"\"}', '', '30', '2015', '2015', '0', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('89', '34', '基本配置', '根选项', '', 'config', 'rootitem', '3', 'rootitem', 'form_bool', '', '', '40', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('90', '23', '基本配置', '最小值', '', 'config', 'min', '3', 'min', 'form_numberbox', '', '', '25', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('91', '23', '基本配置', '最大值', '', 'config', 'max', '3', 'max', 'form_numberbox', '', '', '30', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('97', '23', '基本配置', '是否必填', '', 'config', 'required', '3', 'required', 'form_bool', '', '', '45', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('99', '23', '基本配置', '提示信息', '', 'config', 'prompt', '3', 'prompt', 'form_textbox', '', '', '15', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('101', '23', '基本配置', '是否失效', '', 'config', 'disabled', '3', 'disabled', 'form_bool', '', '', '40', '1457834603', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('104', '22', '基本配置', '高度', '', 'config', 'initialframeheight', '3', 'initialframeheight', 'form_numberbox', '', '', '50', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('105', '22', '基本配置', '显示元素路径', '', 'config', 'elementpathenabled', '3', 'elementpathenabled', 'form_bool', '', '', '20', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('106', '22', '基本配置', '开启字数统计', '', 'config', 'wordcount', '3', 'wordcount', 'form_bool', '', '', '30', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('107', '22', '基本配置', '最大字符数', '', 'config', 'maximumwords', '3', 'maximumwords', 'form_numberbox', '{\"required\":\"0\",\"editable\":\"1\",\"readonly\":\"0\",\"max\":\"\",\"min\":\"\",\"prompt\":\"\",\"disabled\":\"0\",\"width\":\"\",\"prefix\":\"\",\"suffix\":\"\",\"groupseparator\":\"\",\"decimalseparator\":\"\",\"precision\":\"\"}', '', '40', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('108', '22', '基本配置', '自动高度', '', 'config', 'autoheightenabled', '3', 'autoheightenabled', 'form_bool', '', '', '45', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('112', '24', '基本配置', '允许的类型', '', 'config', 'extensions', '3', 'extensions', 'form_textbox', '', '多个类型用‘,’分割，例如：jpg,png,gif,bmp', '40', '1470233576', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('113', '24', '基本配置', '是否必填', '', 'config', 'required', '3', 'required', 'form_bool', '', '', '50', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('114', '24', '基本配置', '提示信息', '', 'config', 'prompt', '3', 'prompt', 'form_textbox', '', '', '20', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('116', '24', '基本配置', '是否失效', '', 'config', 'disabled', '3', 'disabled', 'form_bool', '', '', '45', '1457835074', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('118', '26', '基本配置', '允许的类型', '', 'config', 'extensions', '3', 'extensions', 'form_textbox', '', '多个类型用‘,’分割，例如：jpg,png,gif,bmp', '35', '1470233583', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('119', '26', '基本配置', '是否必填', '', 'config', 'required', '3', 'required', 'form_bool', '', '', '50', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('121', '26', '基本配置', '是否失效', '', 'config', 'disabled', '3', 'disabled', 'form_bool', '', '', '40', '1457835114', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('123', '25', '基本配置', '允许的类型', '', 'config', 'extensions', '3', 'extensions', 'form_textbox', '', '多个类型用‘,’分割，例如：jpg,png,gif,bmp', '40', '1470233593', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('124', '25', '基本配置', '是否失效', '', 'config', 'disabled', '3', 'disabled', 'form_bool', '', '', '45', '1457835154', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('126', '25', '基本配置', '是否必填', '', 'config', 'required', '3', 'required', 'form_bool', '', '', '50', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('127', '27', '基本配置', '允许的类型', '', 'config', 'extensions', '3', 'extensions', 'form_textbox', '', '多个类型用‘,’分割，例如：jpg,png,gif,bmp', '40', '1470233599', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('129', '27', '基本配置', '是否必填', '', 'config', 'required', '3', 'required', 'form_bool', '', '', '50', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('132', '27', '基本配置', '是否失效', '', 'config', 'disabled', '3', 'disabled', 'form_bool', '', '', '45', '1457835190', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('133', '28', '基本配置', '面板宽度', '', 'config', 'panelwidth', '3', 'panelwidth', 'form_numberbox', '', '默认180', '15', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('134', '28', '基本配置', '面板高度', '', 'config', 'panelheight', '3', 'panelheight', 'form_numberbox', '', '默认自动', '10', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('139', '28', '基本配置', '是否失效', '', 'config', 'disabled', '3', 'disabled', 'form_bool', '', '', '40', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('140', '28', '基本配置', '是否只读', '', 'config', 'readonly', '3', 'readonly', 'form_bool', '', '', '35', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('141', '28', '基本配置', '提示字符', '', 'config', 'prompt', '3', 'prompt', 'form_textbox', '', '', '25', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('142', '26', '基本配置', '提示字符', '', 'config', 'prompt', '3', 'prompt', 'form_textbox', '', '', '20', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('143', '25', '基本配置', '提示字符', '', 'config', 'prompt', '3', 'prompt', 'form_textbox', '', '', '20', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('144', '27', '基本配置', '提示字符', '', 'config', 'prompt', '3', 'prompt', 'form_textbox', '', '', '20', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('146', '30', '基本配置', '是否必填', '', 'config', 'required', '3', 'required', 'form_bool', '', '', '45', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('147', '28', '基本配置', '是否必填', '', 'config', 'required', '3', 'required', 'form_bool', '', '', '45', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('148', '30', '基本配置', '提示字符', '', 'config', 'prompt', '3', 'prompt', 'form_textbox', '', '', '30', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('149', '30', '基本配置', '是否只读', '', 'config', 'readonly', '3', 'readonly', 'form_bool', '', '', '35', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('150', '30', '基本配置', '是否失效', '', 'config', 'disabled', '3', 'disabled', 'form_bool', '', '', '40', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('158', '29', '基本配置', '是否必填', '', 'config', 'required', '3', 'required', 'form_bool', '', '', '50', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('160', '29', '基本配置', '是否失效', '', 'config', 'disabled', '3', 'disabled', 'form_bool', '', '', '40', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('161', '29', '基本配置', '是否只读', '', 'config', 'readonly', '3', 'readonly', 'form_bool', '', '', '30', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('190', '32', '其他配置', '查询条件', '', 'config', 'queryparams', '3', 'queryparams', 'form_multitextbox', '', '格式：字段|eq|value\r\n字段|eq|(I)value 添加(I)表示的是提交变量\r\n字段|eq|(@)value 添加(@)表示的是变量', '40', '1459578173', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('258', '47', '基本信息', '目录', '', '', 'title', '3', 'title', 'form_textbox', '{\"required\":\"1\",\"readonly\":\"1\",\"disabled\":\"0\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"prompt\":\"\"}', '', '40', '1459084153', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('259', '47', '基本信息', '文件名', '', '', 'name', '0', 'newfile.txt', 'form_textbox', '{\"required\":\"1\",\"disabled\":\"0\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"prompt\":\"\"}', '请填写完整的文件名 包含后缀', '30', '2016', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('260', '47', '基本信息', '路径', '', '', 'path', '1', 'path', 'form_hidden', '', '', '1', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('261', '47', '基本信息', '内容', '', '', 'content', '0', '默认值，呵呵', 'form_multitextbox', '{\"required\":\"1\",\"disabled\":\"0\",\"height\":\"20\",\"width\":\"\",\"maxlength\":\"\",\"minlength\":\"0\",\"prompt\":\"\"}', '', '20', '2016', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('262', '48', '基本信息', '文件', '', '', 'title', '3', 'title', 'form_textbox', '{\"required\":\"1\",\"readonly\":\"1\",\"disabled\":\"0\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"prompt\":\"\"}', '', '40', '1459084165', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('263', '48', '基本信息', '内容', '', '', 'content', '3', 'content', 'form_multitextbox', '{\"required\":\"0\",\"disabled\":\"0\",\"height\":\"20\",\"width\":\"\",\"maxlength\":\"\",\"minlength\":\"0\",\"prompt\":\"\"}', '', '30', '2016', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('264', '48', '基本信息', '文件路径', '', '', 'filename', '1', 'filename', 'form_hidden', '', '', '1', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('270', '51', '基本信息', 'id', '', '', 'id', '1', 'id', 'form_hidden', '', '', '10', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('271', '51', '基本信息', '父级', '', '', 'pid', '3', 'pid', 'form_combotree', '{\"model\":\"admin/group\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"1\",\"tree\":\"1\",\"prompt\":\"\",\"queryparams\":\"\",\"pid\":\"\",\"textfield\":\"title\",\"valuefield\":\"\",\"width\":\"\"}', '', '99', '2016', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('272', '51', '基本信息', '名称', '', '', 'title', '3', 'title', 'form_textbox', '', '', '82', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('274', '50', '基本信息', '父级', '', '', 'pid', '1', 'pid', 'form_combotree', '{\"model\":\"admin/group\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"1\",\"tree\":\"1\",\"prompt\":\"\",\"queryparams\":\"\",\"pid\":\"\",\"textfield\":\"title\",\"valuefield\":\"\",\"width\":\"\"}', '', '98', '2016', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('275', '50', '基本信息', '名称', '', '', 'title', '0', '', 'form_textbox', '', '', '91', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('277', '52', '基本信息', '昵称', '', '', 'nickname', '0', '', 'form_textbox', '{\"width\":\"\",\"prompt\":\"2-6\\u4e2a\\u5b57\\u7b26\",\"maxlength\":\"6\",\"minlength\":\"2\",\"validtype\":\"\",\"required\":\"1\",\"editable\":\"1\",\"disabled\":\"0\",\"readonly\":\"0\"}', '', '50', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('278', '52', '基本信息', '密码', '', '', 'password', '0', '', 'form_textbox', '{\"width\":\"\",\"prompt\":\"5-10\\u4e2a\\u5b57\\u7b26\",\"maxlength\":\"10\",\"minlength\":\"5\",\"validtype\":\"\",\"required\":\"1\",\"editable\":\"1\",\"disabled\":\"0\",\"readonly\":\"0\"}', '', '40', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('279', '53', '基本信息', '昵称', '', '', 'nickname', '3', 'nickname', 'form_textbox', '{\"width\":\"\",\"prompt\":\"\",\"maxlength\":\"6\",\"minlength\":\"2\",\"validtype\":\"\",\"required\":\"1\",\"editable\":\"1\",\"disabled\":\"0\",\"readonly\":\"0\"}', '', '40', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('280', '53', '基本信息', 'id', '', '', 'id', '1', 'id', 'form_hidden', '', '', '1', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('281', '19', '基本配置', '最小字符数', '', 'config', 'minlength', '3', 'minlength', 'form_numberbox', '', '', '34', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('282', '19', '基本配置', '最多字符数', '', 'config', 'maxlength', '3', 'maxlength', 'form_numberbox', '', '', '35', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('283', '55', '基本信息', 'id', '', '', 'id', '1', 'id', 'form_hidden', '', '', '1', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('284', '55', '基本信息', '标题', '', '', 'title', '3', 'title', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '', '97', '1457524594', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('338', '64', '基本配置', 'id', '', '', 'id', '1', 'id', 'form_hidden', '', '', '1', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('287', '55', '基本信息', '说明', '', '', 'remark', '3', 'remark', 'form_multitextbox', '', '', '46', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('813', '133', '基本信息', '标签', '', '', 'tag', '0', '', 'form_textbox', '', '', '0', '1468024496', '1468024496', '1', '1', '');
INSERT INTO `ebcms5_formfield` VALUES ('814', '134', '基本信息', '标签', '', '', 'tag', '3', 'tag', 'form_textbox', '', '', '0', '1468024515', '1468024515', '1', '1', '');
INSERT INTO `ebcms5_formfield` VALUES ('815', '134', '基本信息', 'id', '', '', 'id', '1', 'id', 'form_hidden', '', '', '0', '1468024533', '1468024533', '1', '1', '');
INSERT INTO `ebcms5_formfield` VALUES ('816', '135', '基本信息', '评论内容', '', '', 'content', '3', 'content', 'form_multitextbox', '', '', '0', '1468030178', '1468030178', '1', '1', '');
INSERT INTO `ebcms5_formfield` VALUES ('817', '135', '基本信息', 'id', '', '', 'id', '1', 'id', 'form_hidden', '', '', '0', '1468030196', '1468030196', '1', '1', '');
INSERT INTO `ebcms5_formfield` VALUES ('291', '54', '基本信息', '标题', '', '', 'title', '0', '', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '', '96', '1457524589', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('339', '64', '基本配置', '可选值', '', 'config', 'values', '3', 'values', 'form_multitextbox', '', '一样一个，用|分割键值对，例如：\r\n红色|red\r\n绿色|green\r\n黑色|black\r\n灰色|gray', '50', '1470233566', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('293', '54', '基本信息', '说明', '', '', 'remark', '0', '', 'form_multitextbox', '', '', '75', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('296', '57', '基本信息', 'id', '', '', 'id', '1', 'id', 'form_hidden', '', '', '1', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('297', '57', '基本信息', '分组', '', '', 'group', '3', 'group', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '', '99', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('298', '57', '基本信息', '标题', '', '', 'title', '3', 'title', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '', '95', '1457524606', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('299', '57', '基本信息', '字段', '', '', 'name', '3', 'name', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '', '94', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('300', '57', '基本信息', '默认值', '', '', 'value', '3', 'value', 'form_multitextbox', '', '', '87', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('301', '57', '基本信息', '表单类型', '', '', 'type', '3', 'type', 'form_combotree', '{\"model\":\"admin\\/form\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"0\",\"tree\":\"0\",\"prompt\":\"\",\"queryparams\":\"group|eq|\\u8868\\u5355\\u914d\\u7f6e\",\"pid\":\"\",\"textfield\":\"\",\"valuefield\":\"name\",\"width\":\"\"}', '更改表单类型后 请更改上一行字段名称 否则可能报错', '93', '1470234585', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('302', '57', '基本信息', '说明', '', '', 'remark', '3', 'remark', 'form_multitextbox', '', '', '67', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('304', '56', '基本信息', '分组', '', '', 'group', '0', '', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '', '99', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('305', '56', '基本信息', '标题', '', '', 'title', '0', '', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"10\",\"minlength\":\"1\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '', '96', '1457524600', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('306', '56', '基本信息', '字段', '', '', 'name', '0', '', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"20\",\"minlength\":\"1\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '', '89', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('307', '56', '基本信息', '默认值', '', '', 'value', '0', '', 'form_multitextbox', '', '', '78', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('308', '56', '基本信息', '表单类型', '', '', 'type', '0', '', 'form_combotree', '{\"model\":\"admin\\/form\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"0\",\"tree\":\"0\",\"prompt\":\"\",\"queryparams\":\"group|eq|\\u8868\\u5355\\u914d\\u7f6e\",\"pid\":\"\",\"textfield\":\"\",\"valuefield\":\"name\",\"width\":\"\"}', '', '80', '1460040920', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('309', '56', '基本信息', '说明', '', '', 'remark', '0', '', 'form_multitextbox', '', '', '60', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('573', '51', '基本信息', '分组', '', '', 'group', '3', 'group', 'form_radio', '{\"disabled\":\"0\",\"values\":\"\\u7cfb\\u7edf|\\u7cfb\\u7edf\\r\\n\\u666e\\u901a|\\u666e\\u901a\"}', '', '99', '2016', '2016', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('650', '65', '基本信息', '是否只读', '', 'config', 'readonly', '3', 'readonly', 'form_bool', '', '', '70', '1457835028', '1457835028', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('571', '65', '基本信息', '是否失效', '', 'config', 'disabled', '3', 'disabled', 'form_bool', '', '', '99', '1457835011', '2016', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('572', '50', '基本信息', '分组', '', '', 'group', '3', 'group', 'form_radio', '{\"disabled\":\"0\",\"values\":\"\\u7cfb\\u7edf|\\u7cfb\\u7edf\\r\\n\\u666e\\u901a|\\u666e\\u901a\"}', '', '99', '2016', '2016', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('343', '65', '基本信息', '可选值', '', 'config', 'values', '3', 'values', 'form_multitextbox', '', '一样一个，用|分割键值对，例如：\r\n红色|red\r\n绿色|green\r\n黑色|black\r\n灰色|gray', '50', '1470233559', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('342', '65', '基本信息', 'id', '', '', 'id', '1', 'id', 'form_hidden', '', '', '1', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('355', '67', '基本信息', 'id', '', '', 'id', '1', 'id', 'form_hidden', '', '', '1', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('356', '67', '基本信息', '分组', '', '', 'group', '3', 'group', 'form_textbox', '', '', '48', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('357', '67', '基本信息', '标题', '', '', 'title', '3', 'title', 'form_textbox', '', '', '44', '1457515428', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('358', '67', '基本信息', '字段', '', '', 'field', '3', 'field', 'form_textbox', '', '', '39', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('359', '67', '基本信息', '扩展', '', '', 'extend_id', '3', 'extend_id', 'form_combotree', '{\"model\":\"admin\\/extend\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"1\",\"tree\":\"0\",\"prompt\":\"\",\"queryparams\":\"group|eq|\\u5b57\\u5178\\u6269\\u5c55\",\"pid\":\"\",\"textfield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '可以进入左上角的扩展  自定义更多字段扩展', '35', '1468489564', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('360', '67', '基本信息', '备注', '', '', 'remark', '3', 'remark', 'form_multitextbox', '', '', '33', '1470233285', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('371', '69', '基本信息', '值', '', '', 'value', '3', 'value', 'form_multitextbox', '', '', '36', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('363', '68', '基本信息', '分类', '', '', 'category_id', '1', 'category_id', 'form_hidden', '{\"url\":\"Admin\\/Datadictcate\\/index\",\"rootitem\":\"0\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"1\",\"prompt\":\"\",\"required\":\"1\",\"queryparams\":\"\",\"textfield\":\"\",\"pid\":\"\",\"validtype\":\"\",\"maxlength\":\"\",\"minlength\":\"\",\"height\":\"\",\"width\":\"\"}', '', '0', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('364', '68', '基本信息', '父级', '', '', 'pid', '1', 'pid', 'form_combotree', '{\"model\":\"admin\\/datadict\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"1\",\"tree\":\"1\",\"prompt\":\"\",\"queryparams\":\"category_id|eq|(I)category_id\",\"pid\":\"\",\"textfield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '', '47', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('365', '68', '基本信息', '标题', '', '', 'title', '0', '', 'form_textbox', '', '', '32', '1457515434', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('366', '68', '基本信息', '值', '', '', 'value', '0', '', 'form_multitextbox', '', '', '27', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('367', '68', '基本信息', '备注', '', '', 'remark', '0', '', 'form_multitextbox', '', '', '13', '1470233292', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('369', '69', '基本信息', '标题', '', '', 'title', '3', 'title', 'form_textbox', '', '', '42', '1457515442', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('370', '69', '基本信息', '父级', '', '', 'pid', '3', 'pid', 'form_combotree', '{\"model\":\"admin\\/datadict\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"1\",\"tree\":\"1\",\"prompt\":\"\",\"queryparams\":\"category_id|eq|(@)category_id\",\"pid\":\"\",\"textfield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '', '48', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('372', '69', '基本信息', '备注', '', '', 'remark', '3', 'remark', 'form_multitextbox', '', '', '19', '1470233299', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('374', '69', '基本信息', 'id', '', '', 'id', '3', 'id', 'form_hidden', '', '', '1', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('375', '69', '基本信息', '分类', '', '', 'category_id', '3', 'category_id', 'form_hidden', '{\"url\":\"Admin\\/Datadictcate\\/index\",\"rootitem\":\"0\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"1\",\"prompt\":\"\",\"required\":\"1\",\"queryparams\":\"\",\"textfield\":\"\",\"pid\":\"\",\"validtype\":\"\",\"maxlength\":\"\",\"minlength\":\"\",\"height\":\"\",\"width\":\"\"}', '', '0', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('422', '76', '基本信息', '父级', '', '', 'pid', '1', 'pid', 'form_combotree', '{\"model\":\"content/category\",\"editable\":\"0\",\"disabled\":\"0\",\"rootitem\":\"1\",\"tree\":\"1\",\"prompt\":\"\",\"queryparams\":\"\",\"pid\":\"\",\"textfield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '', '90', '1457504178', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('647', '23', '基本配置', '是否只读', '', 'config', 'readonly', '3', 'readonly', 'form_bool', '', '', '38', '1457834630', '1457834630', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('648', '64', '基本配置', '是否只读', '', 'config', 'readonly', '3', 'readonly', 'form_bool', '', '', '55', '1457834949', '1457834919', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('649', '64', '基本配置', '是否失效', '', 'config', 'disabled', '3', 'disabled', 'form_bool', '', '', '60', '1457834943', '1457834943', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('424', '76', '基本信息', '名称', '', '', 'name', '0', '', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"20\",\"minlength\":\"2\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\\u8bf7\\u586b\\u5199\\u82f1\\u6587\\u5b57\\u7b26\",\"width\":\"\"}', '请填写英文字符，高级模式生效', '80', '1470232299', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('425', '76', '高级设置', '字段扩展', '', '', 'extend_id', '0', '', 'form_combotree', '{\"model\":\"admin/extend\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"1\",\"tree\":\"0\",\"prompt\":\"\",\"queryparams\":\"group|eq|\\u5185\\u5bb9\\u6269\\u5c55\",\"pid\":\"\",\"textfield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '', '41', '1468825542', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('426', '76', '高级设置', '内容页模板', '', '', 'tpl_detail', '0', '', 'form_textbox', '', '', '21', '1468825562', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('427', '76', '高级设置', '列表页模板', '', '', 'tpl', '0', '', 'form_textbox', '', '', '22', '1468825558', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('428', '76', '高级设置', '列表分页大小', '', '', 'pagenum', '0', '20', 'form_numberbox', '', '0 表示不分页', '33', '1468825546', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('429', '76', '基本信息', '标题', '', '', 'title', '0', '', 'form_textbox', '{\"required\":\"0\",\"editable\":\"1\",\"maxlength\":\"80\",\"minlength\":\"\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '', '85', '1457833405', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('430', '76', '基本信息', '关键字', '', '', 'keywords', '0', '', 'form_keywords', '{\"field\":\"\",\"strong\":\"0\"}', '', '74', '1470319488', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('431', '76', '基本信息', '摘要', '', '', 'description', '0', '', 'form_multitextbox', '{\"required\":\"0\",\"height\":\"\",\"width\":\"\",\"editable\":\"1\",\"maxlength\":\"255\",\"minlength\":\"\",\"validtype\":\"\",\"prompt\":\"\",\"readonly\":\"0\",\"disabled\":\"0\"}', '', '73', '1457833417', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('433', '77', '基本信息', '父级', '', '', 'pid', '3', 'pid', 'form_combotree', '{\"model\":\"content/category\",\"editable\":\"0\",\"disabled\":\"0\",\"rootitem\":\"1\",\"tree\":\"1\",\"prompt\":\"\",\"queryparams\":\"\",\"pid\":\"\",\"textfield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '', '90', '1457504174', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('645', '19', '基本配置', '是否失效', '', 'config', 'disabled', '3', 'disabled', 'form_bool', '', '', '38', '1457834468', '1457834468', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('646', '33', '基本配置', '是否只读', '', 'config', 'readonly', '3', 'readonly', 'form_bool', '', '', '40', '1457834535', '1457834535', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('435', '77', '基本信息', '名称', '', '', 'name', '3', 'name', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '请填写英文字符，高级模式生效', '80', '1470232307', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('436', '77', '高级设置', '字段扩展', '', '', 'extend_id', '3', 'extend_id', 'form_combotree', '{\"model\":\"admin/extend\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"1\",\"tree\":\"0\",\"prompt\":\"\",\"queryparams\":\"group|eq|\\u5185\\u5bb9\\u6269\\u5c55\",\"pid\":\"\",\"textfield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '', '41', '1468825501', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('437', '77', '高级设置', '列表页模板', '', '', 'tpl', '3', 'tpl', 'form_textbox', '', '', '22', '1468825518', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('438', '77', '高级设置', '列表页分页大小', '', '', 'pagenum', '3', 'pagenum', 'form_numberbox', '', '0 表示不分页', '33', '1468825507', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('439', '77', '高级设置', '内容页模板', '', '', 'tpl_detail', '3', 'tpl_detail', 'form_textbox', '', '', '21', '1468825521', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('440', '77', '基本信息', '标题', '', '', 'title', '3', 'title', 'form_textbox', '', '', '85', '1457833347', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('441', '77', '基本信息', '关键字', '', '', 'keywords', '3', 'keywords', 'form_keywords', '', '', '74', '1470312727', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('442', '77', '基本信息', '摘要', '', '', 'description', '3', 'description', 'form_multitextbox', '', '', '73', '1457833359', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('444', '77', '基本信息', 'id', '', '', 'id', '1', 'id', 'form_hidden', '', '', '1', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('445', '79', '基本信息', '标题', '', '', 'title', '3', 'title', 'form_textbox', '', '', '90', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('446', '79', '基本信息', '缩略图', '', '', 'thumb', '3', 'thumb', 'form_image', '', '', '20', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('447', '79', '基本信息', '内容', 'body', '', 'body', '3', 'body', 'form_ueditor', '', '', '10', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('448', '79', '基本信息', '关键字', '', '', 'keywords', '3', 'keywords', 'form_keywords', '{\"field\":\"body[body]\",\"strong\":\"1\"}', '', '60', '1470319455', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('449', '79', '高级设置', '摘要', '', '', 'description', '3', 'description', 'form_multitextbox', '', '', '50', '1469236244', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('450', '79', '高级设置', '模板', '', '', 'tpl', '3', 'tpl', 'form_textbox', '', '', '40', '1469236278', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('451', '79', '高级设置', 'id', '', '', 'id', '1', 'id', 'form_hidden', '', '', '0', '1469236417', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('818', '79', '基本信息', '栏目', '', '', 'category_id', '3', 'category_id', 'form_combotree', '{\"model\":\"content\\/category\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"0\",\"tree\":\"1\",\"prompt\":\"\",\"queryparams\":\"extend_id|eq|($)category.extend_id\",\"pid\":\"\",\"textfield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '', '250', '1468156625', '1468153990', '1', '1', '');
INSERT INTO `ebcms5_formfield` VALUES ('454', '78', '基本信息', '分类', '', '', 'category_id', '1', 'category_id', 'form_combotree', '{\"model\":\"content\\/category\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"0\",\"tree\":\"1\",\"prompt\":\"\",\"queryparams\":\"extend_id|eq|($)category.extend_id\",\"pid\":\"\",\"textfield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '', '90', '1468161897', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('455', '78', '基本信息', '标题', '', '', 'title', '0', '', 'form_textbox', '', '', '50', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('456', '78', '基本信息', '缩略图', '', '', 'thumb', '0', '', 'form_image', '', '', '30', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('457', '78', '基本信息', '内容', '', 'body', 'body', '0', '', 'form_ueditor', '', '', '20', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('458', '78', '基本信息', '关键字', '', '', 'keywords', '0', '', 'form_keywords', '{\"field\":\"body[body]\",\"strong\":\"1\"}', '', '60', '1470319466', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('459', '78', '高级设置', '摘要', '', '', 'description', '0', '', 'form_multitextbox', '', '', '50', '1469235130', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('461', '78', '高级设置', '模板', '', '', 'tpl', '0', '', 'form_textbox', '', '', '40', '1469235144', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('468', '83', '基本信息', '标题', '', '', 'title', '3', 'title', 'form_textbox', '', '', '50', '1457524648', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('464', '82', '基本信息', '标题', '', '', 'title', '0', '', 'form_textbox', '', '', '35', '1457524642', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('465', '82', '基本信息', '标识', '', '', 'mark', '0', '', 'form_textbox', '', '', '30', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('466', '82', '基本信息', '扩展', '', '', 'extend_id', '0', '', 'form_combotree', '{\"model\":\"admin/extend\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"1\",\"tree\":\"1\",\"prompt\":\"\",\"queryparams\":\"group|eq|\\u5bfc\\u822a\\u6269\\u5c55\",\"pid\":\"\",\"textfield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '', '25', '1470232935', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('469', '83', '基本信息', '标识', '', '', 'mark', '3', 'mark', 'form_textbox', '', '', '45', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('470', '83', '基本信息', '扩展', '', '', 'extend_id', '3', 'extend_id', 'form_combotree', '{\"model\":\"admin/extend\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"1\",\"tree\":\"0\",\"prompt\":\"\",\"queryparams\":\"group|eq|\\u5bfc\\u822a\\u6269\\u5c55\",\"pid\":\"\",\"textfield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '', '30', '1470232941', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('472', '83', '基本信息', 'id', '', '', 'id', '1', 'id', 'form_hidden', '', '', '1', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('473', '80', '基本信息', '分类', '', '', 'category_id', '1', 'category_id', 'form_hidden', '', '', '50', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('474', '80', '基本信息', '父级', '', '', 'pid', '1', 'pid', 'form_combotree', '{\"model\":\"nav\",\"disabled\":\"0\",\"rootitem\":\"1\",\"tree\":\"1\",\"prompt\":\"\",\"queryparams\":\"category_id|eq|(I)category_id\",\"pid\":\"\",\"textfield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '', '45', '2016', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('475', '80', '基本信息', '标题', '', '', 'title', '0', '', 'form_textbox', '', '', '40', '1457524622', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('476', '80', '基本信息', '链接地址', '', '', 'ebcms_url', '0', '', 'form_textbox', '', '', '35', '1469454708', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('478', '56', '基本信息', '分类', '', '', 'category_id', '1', 'category_id', 'form_hidden', '', '', '2', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('479', '81', '基本信息', '父级', '', '', 'pid', '3', 'pid', 'form_combotree', '{\"model\":\"nav\",\"disabled\":\"0\",\"rootitem\":\"1\",\"tree\":\"1\",\"prompt\":\"\",\"queryparams\":\"category_id|eq|(@)category_id\",\"pid\":\"\",\"textfield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '', '45', '1470232774', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('480', '81', '基本信息', '标题', '', '', 'title', '3', 'title', 'form_textbox', '', '', '40', '1457524630', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('481', '81', '基本信息', '链接地址', '', '', 'ebcms_url', '3', 'ebcms_url', 'form_textbox', '', '', '35', '1470232739', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('483', '81', '基本信息', 'id', '', '', 'id', '1', 'id', 'form_hidden', '', '', '1', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('484', '81', '基本信息', '分类', '', '', 'category_id', '3', 'category_id', 'form_hidden', '', '', '0', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('485', '85', '基本信息', 'id', '', '', 'id', '1', 'id', 'form_hidden', '', '', '0', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('486', '85', '基本信息', '名称', '', '', 'title', '3', 'title', 'form_textbox', '', '', '45', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('487', '85', '基本信息', '链接', '', '', 'url', '3', 'url', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"url\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '', '40', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('488', '85', '基本信息', 'LOGO', '', '', 'logo', '3', 'logo', 'form_image', '', '', '35', '2016', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('489', '85', '基本信息', '简介', '', '', 'description', '3', 'description', 'form_multitextbox', '', '', '30', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('490', '85', '基本信息', '备注', '', '', 'info', '3', 'info', 'form_multitextbox', '', '', '25', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('492', '84', '基本信息', '名称', '', '', 'title', '0', '', 'form_textbox', '', '', '45', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('493', '84', '基本信息', '网址', '', '', 'url', '0', '', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"url\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '', '40', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('494', '84', '基本信息', 'LOGO', '', '', 'logo', '0', '', 'form_image', '', '', '35', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('495', '84', '基本信息', '简介', '', '', 'description', '0', '', 'form_multitextbox', '', '', '30', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('496', '84', '基本信息', '备注', '', '', 'info', '0', '', 'form_multitextbox', '', '', '25', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('498', '85', '基本信息', '分组', '', '', 'group', '3', 'group', 'form_select', '{\"values\":\"\\u53cb\\u60c5\\u94fe\\u63a5|\\u53cb\\u60c5\\u94fe\\u63a5\\r\\n\\u5408\\u4f5c\\u4f19\\u4f34|\\u5408\\u4f5c\\u4f19\\u4f34\",\"editable\":\"1\",\"readonly\":\"0\",\"disabled\":\"0\"}', '', '50', '1459580809', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('499', '84', '基本信息', '分组', '', '', 'group', '0', '友情链接', 'form_select', '{\"values\":\"\\u53cb\\u60c5\\u94fe\\u63a5|\\u53cb\\u60c5\\u94fe\\u63a5\\r\\n\\u5408\\u4f5c\\u4f19\\u4f34|\\u5408\\u4f5c\\u4f19\\u4f34\",\"editable\":\"1\",\"readonly\":\"0\",\"disabled\":\"0\"}', '', '50', '1459580869', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('500', '86', '基本信息', '留言内容', '', '', 'content', '3', 'content', 'form_multitextbox', '{\"required\":\"1\",\"height\":\"\",\"width\":\"\",\"editable\":\"1\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"prompt\":\"\",\"readonly\":\"0\",\"disabled\":\"0\"}', '', '45', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('501', '86', '基本信息', '回复内容', '', '', 'reply', '3', 'reply', 'form_multitextbox', '{\"required\":\"0\",\"height\":\"\",\"width\":\"\",\"editable\":\"0\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"prompt\":\"\",\"readonly\":\"1\",\"disabled\":\"1\"}', '', '40', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('502', '86', '基本信息', 'id', '', '', 'id', '1', 'id', 'form_hidden', '', '', '0', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('503', '87', '基本信息', '留言内容', '', '', 'content', '3', 'content', 'form_multitextbox', '{\"required\":\"1\",\"height\":\"\",\"width\":\"\",\"editable\":\"0\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"prompt\":\"\",\"readonly\":\"1\",\"disabled\":\"1\"}', '', '45', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('504', '87', '基本信息', '回复内容', '', '', 'reply', '3', 'reply', 'form_multitextbox', '{\"required\":\"1\",\"height\":\"\",\"width\":\"\",\"editable\":\"1\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"prompt\":\"\",\"readonly\":\"0\",\"disabled\":\"0\"}', '', '40', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('505', '87', '基本信息', 'id', '', '', 'id', '1', 'id', 'form_hidden', '', '', '12', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('506', '88', '基本信息', '分组', '', '', 'group', '0', '默认分组', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '', '50', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('507', '88', '基本信息', '标题', '', '', 'title', '0', '', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"20\",\"minlength\":\"1\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '', '45', '1457524679', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('508', '88', '基本信息', '标识', '', '', 'mark', '0', '', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"20\",\"minlength\":\"2\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\\u82f1\\u6587\\u6807\\u8bc6\",\"width\":\"\"}', '', '40', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('509', '88', '基本信息', '扩展', '', '', 'extend_id', '0', '', 'form_combotree', '{\"model\":\"admin\\/extend\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"1\",\"tree\":\"0\",\"prompt\":\"\",\"queryparams\":\"group|eq|\\u63a8\\u8350\\u6269\\u5c55\",\"pid\":\"\",\"textfield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '', '30', '1470232915', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('512', '89', '基本信息', 'id', '', '', 'id', '1', 'id', 'form_hidden', '', '', '0', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('513', '89', '基本信息', '分组', '', '', 'group', '3', 'group', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"20\",\"minlength\":\"2\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '', '50', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('514', '89', '基本信息', '标题', '', '', 'title', '3', 'title', 'form_textbox', '', '', '45', '1457524686', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('515', '89', '基本信息', '标识', '', '', 'mark', '3', 'mark', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"10\",\"minlength\":\"2\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\\u82f1\\u6587\\u5b57\\u7b26\",\"width\":\"\"}', '', '40', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('516', '89', '基本信息', '扩展', '', '', 'extend_id', '3', 'extend_id', 'form_combotree', '{\"model\":\"admin\\/extend\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"1\",\"tree\":\"0\",\"prompt\":\"\",\"queryparams\":\"group|eq|\\u63a8\\u8350\\u6269\\u5c55\",\"pid\":\"\",\"textfield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '', '35', '1470232907', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('519', '91', '基本信息', '推荐位', '', '', 'category_id', '3', 'category_id', 'form_hidden', '{\"url\":\"Admin\\/Recommendcate\\/index\",\"required\":\"1\",\"editable\":\"0\",\"rootitem\":\"0\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"queryparams\":\"\",\"textfield\":\"\",\"pid\":\"\",\"validtype\":\"\",\"minlength\":\"\",\"maxlength\":\"\",\"width\":\"\"}', '', '50', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('520', '91', '基本信息', 'id', '', '', 'id', '1', 'id', 'form_hidden', '', '', '22', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('521', '91', '基本信息', '标题', '', '', 'title', '3', 'title', 'form_textbox', '{\"required\":\"1\",\"editable\":\"1\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '', '45', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('522', '91', '基本信息', '图片', '', '', 'thumb', '3', 'thumb', 'form_image', '{\"required\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"extensions\":\"\",\"prompt\":\"\"}', '', '35', '1459050914', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('523', '91', '基本信息', '链接地址', '', '', 'ebcms_url', '3', 'ebcms_url', 'form_textbox', '{\"required\":\"0\",\"editable\":\"1\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"readonly\":\"0\",\"disabled\":\"0\",\"prompt\":\"\",\"width\":\"\"}', '', '40', '1469453932', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('524', '91', '基本信息', '摘要', '', '', 'description', '3', 'description', 'form_multitextbox', '{\"required\":\"0\",\"height\":\"\",\"width\":\"\",\"editable\":\"1\",\"maxlength\":\"255\",\"minlength\":\"\",\"validtype\":\"\",\"prompt\":\"\",\"readonly\":\"0\",\"disabled\":\"0\"}', '', '30', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('526', '90', '基本信息', '推荐位', '', '', 'category_id', '1', 'category_id', 'form_hidden', '', '', '50', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('527', '90', '基本信息', '标题', '', '', 'title', '0', '', 'form_textbox', '', '', '45', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('528', '90', '基本信息', '链接地址', '', '', 'ebcms_url', '0', '', 'form_textbox', '', '', '40', '1469453921', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('529', '90', '基本信息', '图片', '', '', 'thumb', '0', '', 'form_image', '{\"required\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"extensions\":\"\",\"prompt\":\"\"}', '', '35', '1459084215', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('530', '90', '基本信息', '摘要', '', '', 'description', '0', '', 'form_multitextbox', '', '', '30', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('554', '93', '基本信息', '删除文件', '', '', 'dels', '3', 'dels', 'form_multitextbox', '', '', '25', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('537', '93', '基本信息', '版本号', '', '', 'version', '3', 'version', 'form_textbox', '', '', '40', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('538', '93', '基本信息', '数据库', '', '', 'sqls', '3', 'sqls', 'form_multitextbox', '', '', '30', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('539', '93', '基本信息', '更新说明', '', '', 'remark', '3', 'remark', 'form_multitextbox', '', '', '20', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('540', '93', '基本信息', 'id', '', '', 'id', '1', 'id', 'form_hidden', '', '', '1', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('564', '93', '基本信息', '核心版本需求', '', '', 'core_version', '3', 'core_version', 'form_textbox', '', '', '35', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('565', '32', '其他配置', '显示字段', '', 'config', 'textfield', '3', 'textfield', 'form_textbox', '', '默认为text', '9', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('566', '32', '其他配置', '值字段', '', 'config', 'valuefield', '3', 'valuefield', 'form_textbox', '', '默认为id', '6', '2015', '2015', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('574', '98', '基本信息', '旧密码', '', '', 'oldpassword', '0', '', 'form_textbox', '', '', '50', '2016', '2016', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('575', '98', '基本信息', '新密码', '', '', 'password', '0', '', 'form_textbox', '', '', '45', '2016', '2016', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('576', '98', '基本信息', '重复密码', '', '', 'passwordtwo', '0', '', 'form_textbox', '', '', '40', '2016', '2016', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('577', '52', '基本信息', '邮箱', '', '', 'email', '0', '', 'form_textbox', '', '', '99', '1456668417', '2016', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('578', '53', '基本信息', '邮箱', '', '', 'email', '3', 'email', 'form_textbox', '', '', '90', '1456668402', '2016', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('615', '53', '基本信息', '头像', '', '', 'avatar', '3', 'avatar', 'form_image', '', '', '30', '1457001956', '1457001956', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('616', '52', '基本信息', '头像', '', '', 'avatar', '0', '', 'form_image', '', '', '30', '1457001983', '1457001983', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('617', '76', '高级设置', '列表数据来源', '', '', 'datatype', '0', '1', 'form_radio', '{\"disabled\":\"0\",\"readonly\":\"0\",\"values\":\"不读取|0\\r\\n当前栏目|1\\r\\n子栏目|2\\r\\n所有子级栏目（数据多时不推荐）|3\\r\\n不限栏目|4\"}', '', '32', '1469353924', '1457270483', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('618', '77', '高级设置', '列表数据来源', '', '', 'datatype', '3', 'datatype', 'form_radio', '{\"disabled\":\"0\",\"readonly\":\"0\",\"values\":\"不读取|0\\r\\n当前栏目|1\\r\\n子栏目|2\\r\\n所有子级栏目（数据多时不推荐）|3\\r\\n不限栏目|4\"}', '', '32', '1469353917', '1457270608', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('619', '77', '高级设置', '列表排序', '', '', 'order', '3', 'order', 'form_select', '{\"values\":\"id \\u4ece\\u5927\\u5230\\u5c0f(\\u63a8\\u8350)|id desc\\r\\nid \\u4ece\\u5c0f\\u5230\\u5927|id asc\\r\\n\\u6392\\u5e8f \\u4ece\\u5927\\u5230\\u5c0f|sort desc,id desc\\r\\n\\u6392\\u5e8f \\u4ece\\u5c0f\\u5230\\u8fbe|sort asc,id desc\\r\\n\\u66f4\\u65b0\\u65f6\\u95f4 \\u4ece\\u5927\\u5230\\u5c0f|update_time desc,id desc\\r\\n\\u66f4\\u65b0\\u65f6\\u95f4 \\u4ece\\u5c0f\\u5230\\u8fbe|update_time desc,id desc\"}', '', '31', '1468825515', '1457271515', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('620', '76', '高级设置', '列表排序', '', '', 'order', '0', 'id desc', 'form_select', '{\"disabled\":\"0\",\"values\":\"id \\u4ece\\u5927\\u5230\\u5c0f(\\u63a8\\u8350)|id desc\\r\\nid \\u4ece\\u5c0f\\u5230\\u5927|id asc\\r\\n\\u6392\\u5e8f \\u4ece\\u5927\\u5230\\u5c0f|sort desc,id desc\\r\\n\\u6392\\u5e8f \\u4ece\\u5c0f\\u5230\\u8fbe|sort asc,id desc\\r\\n\\u66f4\\u65b0\\u65f6\\u95f4 \\u4ece\\u5927\\u5230\\u5c0f|update_time desc,id desc\\r\\n\\u66f4\\u65b0\\u65f6\\u95f4 \\u4ece\\u5c0f\\u5230\\u8fbe|update_time desc,id desc\"}', '', '31', '1468825554', '1457271659', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('621', '107', '基本信息', '是否失效', '', 'config', 'disabled', '3', 'disabled', 'form_bool', '', '', '30', '1457835383', '1457272451', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('622', '107', '基本信息', '可选值', '', 'config', 'values', '3', 'values', 'form_multitextbox', '', '一样一个，用|分割键值对，例如：\r\n红色|red\r\n绿色|green\r\n黑色|black\r\n灰色|gray', '80', '1470234154', '1457272486', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('623', '107', '基本信息', 'id', '', '', 'id', '3', 'id', 'form_hidden', '', '', '1', '1457272520', '1457272520', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('628', '108', '基本信息', '父级', '', '', 'pid', '0', '0', 'form_hidden', '', '', '0', '1468484410', '1457591539', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('629', '108', '基本信息', '标题', '', '', 'title', '0', '', 'form_textbox', '', '', '80', '1468484823', '1457591584', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('630', '108', '基本信息', '表单类型', '', '', 'form', '0', 'form_textbox', 'form_radio', '{\"disabled\":\"0\",\"readonly\":\"0\",\"values\":\"\\u5355\\u884c\\u6587\\u672c|form_textbox\\r\\n\\u591a\\u884c\\u6587\\u672c|form_multitextbox\\r\\n\\u7f16\\u8f91\\u5668|form_ueditor\\r\\n\\u56fe\\u7247|form_image\\r\\n\\u5e03\\u5c14|form_bool\"}', '', '40', '1468485204', '1457591622', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('631', '108', '基本信息', '键', '', '', 'name', '0', '', 'form_textbox', '', '英文字符', '60', '1457591703', '1457591703', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('633', '108', '基本信息', '解析类型', '', '', 'render', '0', 'string', 'form_hidden', '', '', '0', '1457591824', '1457591824', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('634', '108', '基本信息', '备注', '', '', 'remark', '0', '', 'form_multitextbox', '', '', '30', '1457591851', '1457591851', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('636', '108', '基本信息', '分类', '', '', 'category_id', '0', '9', 'form_hidden', '', '', '0', '1468484391', '1457591914', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('637', '109', '基本信息', '键', '', '', 'name', '3', 'name', 'form_textbox', '', '', '40', '1457592182', '1457592182', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('825', '109', '基本信息', '表单类型', '', '', 'form', '3', 'form', 'form_radio', '{\"disabled\":\"0\",\"readonly\":\"0\",\"values\":\"\\u5355\\u884c\\u6587\\u672c|form_textbox\\r\\n\\u591a\\u884c\\u6587\\u672c|form_multitextbox\\r\\n\\u7f16\\u8f91\\u5668|form_ueditor\\r\\n\\u56fe\\u7247|form_image\\r\\n\\u5e03\\u5c14|form_bool\"}', '', '30', '1468485208', '1468485017', '1', '1', '');
INSERT INTO `ebcms5_formfield` VALUES ('639', '109', '基本信息', '备注', '', '', 'remark', '3', 'remark', 'form_multitextbox', '', '', '20', '1457592292', '1457592226', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('640', '109', '基本信息', 'id', '', '', 'id', '3', 'id', 'form_hidden', '', '', '0', '1457592245', '1457592245', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('641', '53', '基本信息', '座右铭', '', '', 'motto', '3', 'motto', 'form_multitextbox', '', '', '20', '1457599144', '1457599128', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('642', '52', '基本信息', '座右铭', '', '', 'motto', '0', '我光荣的使用EBCMS内容管理系统！', 'form_multitextbox', '', '', '20', '1457599246', '1457599204', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('643', '50', '基本信息', '简介', '', '', 'description', '0', '', 'form_multitextbox', '', '', '10', '1457752347', '1457752347', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('644', '51', '基本信息', '简介', '', '', 'description', '3', 'description', 'form_multitextbox', '', '', '20', '1457752386', '1457752386', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('651', '24', '基本配置', '是否只读', '', 'config', 'readonly', '3', 'readonly', 'form_bool', '', '', '42', '1457835095', '1457835095', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('652', '26', '基本配置', '是否只读', '', 'config', 'readonly', '3', 'readonly', 'form_bool', '', '', '37', '1457835134', '1457835134', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('653', '25', '基本配置', '是否只读', '', 'config', 'readonly', '3', 'readonly', 'form_bool', '', '', '42', '1457835173', '1457835173', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('654', '27', '基本配置', '是否只读', '', 'config', 'readonly', '3', 'readonly', 'form_bool', '', '', '42', '1457835211', '1457835211', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('655', '20', '基本配置', '是否失效', '', 'config', 'disabled', '3', 'disabled', 'form_bool', '', '', '50', '1457835240', '1457835240', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('656', '20', '基本配置', '是否只读', '', 'config', 'readonly', '3', 'readonly', 'form_bool', '', '', '40', '1457835261', '1457835261', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('657', '34', '基本配置', '是否只读', '', 'config', 'readonly', '3', 'readonly', 'form_bool', '', '', '25', '1457835304', '1457835304', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('658', '32', '基本配置', '是否只读', '', 'config', 'readonly', '3', 'readonly', 'form_bool', '', '', '42', '1457835368', '1457835368', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('659', '107', '基本信息', '是否只读', '', 'config', 'readonly', '3', 'readonly', 'form_bool', '', '', '40', '1457835411', '1457835403', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('660', '78', '高级设置', '短标题', '', '', 'shorttitle', '0', '', 'form_textbox', '', '一般用作 首页 列表页调用 没有则调用标题', '70', '1469236342', '1459511260', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('661', '78', '高级设置', 'META标题', '', '', 'metatitle', '0', '', 'form_textbox', '', '用作seo标题设置，不填则默认为标题', '80', '1469236380', '1459511284', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('662', '78', '基本信息', '标签', '', '', 'tags', '0', '', 'form_textbox', '', '', '42', '1459511356', '1459511356', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('663', '79', '高级设置', '短标题', '', '', 'shorttitle', '3', 'shorttitle', 'form_textbox', '', '一般用作 首页 列表页调用 没有则调用标题', '70', '1469236335', '1459511458', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('664', '79', '高级设置', 'META标题', '', '', 'metatitle', '3', 'metatitle', 'form_textbox', '', '用作seo标题设置，不填则默认为标题', '80', '1469236386', '1459511480', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('665', '79', '基本信息', '标签', '', '', 'tags', '3', 'tags', 'form_textbox', '{\"required\":\"0\",\"readonly\":\"0\",\"disabled\":\"0\",\"maxlength\":\"\",\"minlength\":\"\",\"prompt\":\"\"}', '', '35', '1470315834', '1459511523', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('666', '76', '高级设置', 'meta标题', '', '', 'metatitle', '0', '', 'form_textbox', '', '', '74', '1468825537', '1459512626', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('667', '77', '高级设置', 'meta标题', '', '', 'metatitle', '3', 'metatitle', 'form_textbox', '{\"required\":\"0\",\"readonly\":\"0\",\"disabled\":\"0\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"\",\"prompt\":\"\"}', '', '74', '1468825503', '1459512653', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('668', '34', '基本配置', '是否可编辑', '', 'config', 'editable', '3', 'editable', 'form_bool', '', '可编辑是指下拉选项只是作为辅助选项，实际上还是一个文本框', '48', '1459577971', '1459577748', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('669', '32', '基本配置', '是否可编辑', '', 'config', 'editable', '3', 'editable', 'form_bool', '', '可编辑是指下拉选项只是作为辅助选项，实际上还是一个文本框', '48', '1459577845', '1459577845', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('670', '107', '基本信息', '是否可编辑', '', 'config', 'editable', '3', 'editable', 'form_bool', '', '可编辑是指下拉选项只是作为辅助选项，实际上还是一个文本框', '60', '1459577965', '1459577881', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('829', '55', '基本信息', '分组', '', '', 'group', '3', 'group', 'form_textbox', '', '此项请不要修改', '99', '1468490486', '1468490486', '1', '1', '');
INSERT INTO `ebcms5_formfield` VALUES ('828', '54', '基本信息', '分组', '', '', 'group', '1', 'group', 'form_textbox', '', '此项请不要修改', '99', '1468490732', '1468490448', '1', '1', '');
INSERT INTO `ebcms5_formfield` VALUES ('820', '111', '基本信息', '内容', '', '', 'body', '3', 'body', 'form_ueditor', '{\"initialframeheight\":\"\",\"autoheightenabled\":\"0\",\"maximumwords\":\"\",\"wordcount\":\"0\",\"elementpathenabled\":\"0\"}', '', '12', '1468822357', '1468473743', '1', '1', '');
INSERT INTO `ebcms5_formfield` VALUES ('821', '110', '基本信息', '内容', '', '', 'body', '0', '', 'form_ueditor', '', '', '12', '1468473773', '1468473773', '1', '1', '');
INSERT INTO `ebcms5_formfield` VALUES ('823', '109', '基本信息', '标题', '', '', 'title', '3', 'title', 'form_textbox', '', '', '50', '1468484771', '1468484771', '1', '1', '');
INSERT INTO `ebcms5_formfield` VALUES ('826', '108', '基本信息', '分组', '', '', 'group', '1', 'group', 'form_textbox', '', '', '90', '1468486423', '1468485320', '1', '1', '');
INSERT INTO `ebcms5_formfield` VALUES ('827', '109', '基本信息', '分组', '', '', 'group', '3', 'group', 'form_textbox', '', '', '90', '1468485336', '1468485336', '1', '1', '');
INSERT INTO `ebcms5_formfield` VALUES ('687', '110', '基本信息', '分组', '', '', 'group', '1', 'group', 'form_textbox', '', '', '99', '1469406256', '1460041314', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('688', '110', '高级设置', '路径', '', '', 'path', '0', '', 'form_textbox', '', '例如：/about/us、/about、/contactus 等等\r\n可不填', '50', '1469406245', '1460041336', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('689', '110', '基本信息', '标题', '', '', 'title', '0', '', 'form_textbox', '', '', '80', '1468476814', '1460041353', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('690', '110', '基本信息', '关键字', '', '', 'keywords', '0', '', 'form_keywords', '{\"field\":\"body\",\"strong\":\"1\"}', '', '70', '1470319502', '1460041373', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('691', '110', '高级设置', '简介', '', '', 'description', '0', '', 'form_multitextbox', '', '', '60', '1469406313', '1460041395', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('693', '111', '基本信息', 'id', '', '', 'id', '3', 'id', 'form_hidden', '', '', '1', '1468822384', '1460041484', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('694', '111', '基本信息', '分组', '', '', 'group', '3', 'group', 'form_textbox', '', '', '99', '1469406450', '1460041505', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('695', '111', '高级设置', '路径', '', '', 'path', '3', 'path', 'form_textbox', '', '例如：/about/us、/about、/contactus 等等\r\n可不填', '50', '1469406426', '1460041522', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('696', '111', '基本信息', '标题', '', '', 'title', '3', 'title', 'form_textbox', '', '', '90', '1468476829', '1460041543', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('697', '111', '基本信息', '关键字', '', '', 'keywords', '3', 'keywords', 'form_keywords', '{\"field\":\"body\",\"strong\":\"1\"}', '', '80', '1470319497', '1460041560', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('698', '111', '高级设置', '简介', '', '', 'description', '3', 'description', 'form_multitextbox', '', '', '60', '1469406437', '1460041581', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('700', '110', '高级设置', '模板', '', '', 'tpl', '0', '', 'form_textbox', '', '模板位于模板目录下的Single目录下。不填默认index', '15', '1469406316', '1462196672', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('701', '111', '高级设置', '模板', '', '', 'tpl', '3', 'tpl', 'form_textbox', '', '模板位于模板目录下的Single目录下。不填默认index', '15', '1469406441', '1462196704', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('830', '77', '个性扩展', '扩展字段', '', '', 'ext', '3', 'ext', 'form_extend', '', '', '1', '1468835046', '1468826053', '1', '1', '');
INSERT INTO `ebcms5_formfield` VALUES ('715', '117', '基本信息', '扩展字段', '', 'config', 'field', '3', 'field', 'form_textbox', '', '', '0', '0', '0', '1', '1', '');
INSERT INTO `ebcms5_formfield` VALUES ('716', '117', '基本信息', 'id', '', '', 'id', '1', 'id', 'form_hidden', '', '', '0', '0', '0', '1', '1', '');
INSERT INTO `ebcms5_formfield` VALUES ('746', '66', '基本信息', '分组', '', '', 'group', '1', 'group', 'form_textbox', '', '', '48', '1468898550', '0', '1', '1', '');
INSERT INTO `ebcms5_formfield` VALUES ('747', '66', '基本信息', '标题', '', '', 'title', '0', '', 'form_textbox', '', '', '44', '0', '0', '1', '1', '');
INSERT INTO `ebcms5_formfield` VALUES ('748', '66', '基本信息', '字段', '', '', 'field', '0', '', 'form_textbox', '', '', '39', '0', '0', '1', '1', '');
INSERT INTO `ebcms5_formfield` VALUES ('848', '76', '高级设置', '跳转链接', '', '', 'ebcms_url', '0', '', 'form_textbox', '', '', '5', '1469493098', '1469493098', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('849', '77', '高级设置', '跳转链接', '', '', 'ebcms_url', '3', 'ebcms_url', 'form_textbox', '', '', '5', '1469493138', '1469493138', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('782', '129', '基本信息', '将字符', '', '', 'fromstr', '0', '', 'form_textbox', '', '该功能一般在网站更改域名或更改路径之后才会用到，非专业人士请谨慎操作！\r\n此处一般填写原来的网站域名+安装目录，例如 http://img.baidu.com/dir/', '0', '0', '0', '1', '1', '');
INSERT INTO `ebcms5_formfield` VALUES ('783', '129', '基本信息', '替换成', '', '', 'tostr', '0', '', 'form_textbox', '', '此处填写替换成的字符，一般填写 当前网站域名+安装目录，例如：http://ebcms5.ebcms.com/dir/', '0', '1468046015', '0', '1', '1', '');
INSERT INTO `ebcms5_formfield` VALUES ('806', '76', '高级设置', '缓存时间', '', '', 'expire', '0', '0', 'form_numberbox', '', '0标识不缓存 单位秒', '10', '1468825565', '1467730081', '1', '1', '');
INSERT INTO `ebcms5_formfield` VALUES ('807', '77', '高级设置', '缓存时间', '', '', 'expire', '3', 'expire', 'form_numberbox', '', '0表示不缓存 单位秒', '10', '1468825527', '1467730184', '1', '1', '');
INSERT INTO `ebcms5_formfield` VALUES ('808', '78', '高级设置', '是否允许评论', '', '', 'comment_able', '0', '1', 'form_bool', '', '', '20', '1469235119', '1467864540', '1', '1', '');
INSERT INTO `ebcms5_formfield` VALUES ('809', '79', '高级设置', '是否允许评论', '', '', 'comment_able', '3', 'comment_able', 'form_bool', '', '', '20', '1469236250', '1467864575', '1', '1', '');
INSERT INTO `ebcms5_formfield` VALUES ('810', '132', '基本信息', '将标签', '', '', 'tag1', '1', 'tag1', 'form_textbox', '{\"required\":\"1\",\"readonly\":\"0\",\"disabled\":\"0\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"0\",\"prompt\":\"\"}', '多个标签 请用空格分隔', '0', '1468982030', '1467944978', '1', '1', '');
INSERT INTO `ebcms5_formfield` VALUES ('811', '132', '基本信息', '合并到', '', '', 'tag2', '1', 'tag2', 'form_textbox', '', '不存在则自动创建', '0', '1468982022', '1467945030', '1', '1', '');
INSERT INTO `ebcms5_formfield` VALUES ('831', '76', '个性扩展', '个性扩展', '', '', 'ext', '0', '', 'form_extend', '', '', '1', '1468835067', '1468835067', '1', '1', '');
INSERT INTO `ebcms5_formfield` VALUES ('832', '110', '个性扩展', '个性扩展', '', '', 'ext', '0', '', 'form_extend', '', '', '1', '1468835354', '1468835354', '1', '1', '');
INSERT INTO `ebcms5_formfield` VALUES ('833', '111', '个性扩展', '个性扩展', '', '', 'ext', '3', 'ext', 'form_extend', '', '', '10', '1468835389', '1468835389', '1', '1', '');
INSERT INTO `ebcms5_formfield` VALUES ('834', '136', '基本信息', '内容id', '', '', 'ids', '1', 'ids', 'form_multitextbox', '', '', '0', '1468980037', '1468979577', '1', '1', '');
INSERT INTO `ebcms5_formfield` VALUES ('835', '136', '基本信息', '移动到', '', '', 'category_id', '1', 'category_id', 'form_combotree', '{\"model\":\"content\\/category\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"0\",\"tree\":\"1\",\"prompt\":\"\",\"queryparams\":\"\",\"pid\":\"\",\"textfield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '如果移动的内容和移动到的栏目的模型不一样，会造成移动的内容中模型不一样的那一部分数据的自定义扩展内容数据丢失，但主体内容数据不会丢失！\r\n非超级管理员操作，会自动排除已经锁定的数据。', '0', '1468981649', '1468979611', '1', '1', '');
INSERT INTO `ebcms5_formfield` VALUES ('836', '137', '基本信息', '栏目id', '', '', 'ids', '1', 'ids', 'form_multitextbox', '{\"required\":\"1\",\"disabled\":\"0\",\"readonly\":\"1\",\"height\":\"\",\"width\":\"\",\"maxlength\":\"\",\"minlength\":\"\",\"prompt\":\"\"}', '', '0', '1468985752', '1468985302', '1', '1', '');
INSERT INTO `ebcms5_formfield` VALUES ('837', '137', '基本信息', '合并到', '', '', 'id', '0', '', 'form_combotree', '{\"model\":\"content\\/category\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"0\",\"tree\":\"1\",\"prompt\":\"\",\"queryparams\":\"id|notin|(I)ids\",\"pid\":\"\",\"textfield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '不同模型之间的栏目合并，如果和目标栏目模型不一样，会造成这些栏目下面的内容的自定义扩展数据丢失，但主体内容不受影响！', '0', '1468985757', '1468985486', '1', '1', '');
INSERT INTO `ebcms5_formfield` VALUES ('840', '110', '基本信息', '缩略图', '', '', 'thumb', '0', '', 'form_image', '', '', '60', '1469406278', '1469195366', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('841', '111', '基本信息', '缩略图', '', '', 'thumb', '3', 'thumb', 'form_image', '', '', '70', '1469406458', '1469195394', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('842', '78', '高级设置', '外部链接', '', '', 'ebcms_url', '0', '', 'form_textbox', '{\"required\":\"0\",\"readonly\":\"0\",\"disabled\":\"0\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"0\",\"prompt\":\"http:\\/\\/\"}', '如果需要链接到其他地址，请填写完整url', '10', '1469458969', '1469236199', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('843', '79', '高级设置', '外部链接', '', '', 'ebcms_url', '3', 'ebcms_url', 'form_textbox', '{\"required\":\"0\",\"readonly\":\"0\",\"disabled\":\"0\",\"maxlength\":\"\",\"minlength\":\"\",\"validtype\":\"0\",\"prompt\":\"http:\\/\\/\"}', '链接到外部地址', '10', '1469458976', '1469236468', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('844', '110', '高级设置', '短标题', '', '', 'shorttitle', '0', '', 'form_textbox', '', '', '85', '1469406366', '1469406366', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('845', '110', '高级设置', 'META标题', '', '', 'metatitle', '0', '', 'form_textbox', '', '', '90', '1469406384', '1469406384', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('846', '111', '高级设置', '短标题', '', '', 'shorttitle', '3', 'shorttitle', 'form_textbox', '', '', '80', '1469406517', '1469406517', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('847', '111', '高级设置', 'META标题', '', '', 'metatitle', '3', 'metatitle', 'form_textbox', '', '', '90', '1469406532', '1469406532', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('850', '79', '高级设置', '文件名', '', '', 'filename', '3', 'filename', 'form_textbox', '', '', '30', '1469851161', '1469851161', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('853', '110', '高级设置', '跳转链接', '', '', 'ebcms_url', '0', '', 'form_textbox', '', '', '0', '1469872747', '1469872747', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('854', '111', '高级设置', '跳转链接', '', '', 'ebcms_url', '3', 'ebcms_url', 'form_textbox', '', '', '0', '1469872777', '1469872777', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('855', '78', '高级设置', '文件名', '', '', 'filename', '0', '', 'form_textbox', '', '', '30', '1470232456', '1470232456', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('856', '139', '基本配置', '接收字段', '', 'config', 'field', '3', 'field', 'form_textbox', '', '如果需要随机插入到内容，此处请填写内容字段', '8', '1470319339', '1470315282', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('857', '139', '基本配置', 'id', '', '', 'id', '1', 'id', 'form_hidden', '', '', '0', '1470315541', '1470315541', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('858', '139', '基本配置', '是否强调', '', 'config', 'strong', '3', 'strong', 'form_bool', '', '勾选强调后，插入的时候会自动加粗', '6', '1470318415', '1470318367', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('872', '52', '基本信息', 'salt', '', '', 'salt', '0', '', 'form_hidden', '', '', '0', '1471669554', '1471669554', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('873', '142', '基本信息', '标题', '', '', 'title', '0', '', 'form_textbox', '', '', '9', '1471740046', '1471740046', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('874', '142', '基本信息', '名称', '', '', 'name', '0', '', 'form_textbox', '', '英文', '8', '1471740077', '1471740077', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('875', '142', '基本信息', '开启验证码', '', '', 'verify', '0', '1', 'form_bool', '', '', '7', '1471750061', '1471740105', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('876', '143', '基本信息', '标题', '', '', 'title', '3', 'title', 'form_textbox', '', '', '9', '1471740126', '1471740126', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('877', '143', '基本信息', '名称', '', '', 'name', '3', 'name', 'form_textbox', '', '', '8', '1471740138', '1471740138', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('878', '143', '基本信息', '备注', '', '', 'remark', '3', 'remark', 'form_multitextbox', '', '', '7', '1471740155', '1471740155', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('879', '143', '基本信息', 'id', '', '', 'id', '3', 'id', 'form_hidden', '', '', '0', '1471740177', '1471740177', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('880', '144', '基本信息', '表单', '', '', 'forms_id', '1', 'forms_id', 'form_combotree', '{\"model\":\"forms\\/forms\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"0\",\"tree\":\"0\",\"prompt\":\"\",\"queryparams\":\"\",\"pid\":\"\",\"textfield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '', '0', '1471740754', '1471740236', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('881', '144', '基本信息', '标题', '', '', 'title', '0', '', 'form_textbox', '', '', '0', '1471740256', '1471740256', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('882', '144', '基本信息', '类型', '', '', 'type', '0', 'text', 'form_radio', '{\"disabled\":\"0\",\"readonly\":\"0\",\"values\":\"单行文本|text\\r\\n多行文本|textarea\\r\\n单选|radio\\r\\n多选|checkbox\"}', '', '0', '1471740868', '1471740277', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('883', '144', '基本信息', '配置', '', '', 'config', '0', '', 'form_multitextbox', '', '单选 多选 配置格式为一行一个\r\n红色\r\n黑色\r\n黄色', '0', '1471747304', '1471740295', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('884', '144', '基本信息', '备注', '', '', 'remark', '0', '', 'form_multitextbox', '', '', '0', '1471740309', '1471740309', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('885', '145', '基本信息', '表单', '', '', 'forms_id', '3', 'forms_id', 'form_combotree', '{\"model\":\"forms\\/forms\",\"editable\":\"0\",\"disabled\":\"0\",\"readonly\":\"0\",\"rootitem\":\"0\",\"tree\":\"0\",\"prompt\":\"\",\"queryparams\":\"\",\"pid\":\"\",\"textfield\":\"\",\"valuefield\":\"\",\"width\":\"\"}', '', '0', '1471828478', '1471740484', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('886', '145', '基本信息', '标题', '', '', 'title', '3', 'title', 'form_textbox', '{\"required\":\"0\",\"readonly\":\"0\",\"disabled\":\"0\",\"maxlength\":\"\",\"minlength\":\"\",\"prompt\":\"\"}', '', '0', '1471828724', '1471740520', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('887', '145', '基本信息', '类型', '', '', 'type', '3', 'type', 'form_radio', '{\"disabled\":\"0\",\"readonly\":\"0\",\"values\":\"单行文本|text\\r\\n多行文本|textarea\\r\\n单选|radio\\r\\n多选|checkbox\"}', '', '0', '1471740635', '1471740542', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('888', '145', '基本信息', '配置', '', '', 'config', '3', 'config', 'form_multitextbox', '', '单选 多选 配置格式为一行一个\r\n红色\r\n黑色\r\n黄色', '0', '1471747315', '1471740561', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('889', '145', '基本信息', '备注', '', '', 'remark', '3', 'remark', 'form_multitextbox', '', '', '0', '1471740576', '1471740576', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('890', '145', '基本信息', 'id', '', '', 'id', '3', 'id', 'form_hidden', '', '', '0', '1471740590', '1471740590', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('891', '142', '基本信息', '备注', '', '', 'remark', '0', '', 'form_multitextbox', '', '', '6', '1471750078', '1471750036', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('892', '143', '基本信息', '验证码', '', '', 'verify', '3', 'verify', 'form_bool', '', '', '6', '1471750106', '1471750106', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('893', '146', '基本信息', '标题', '', '', 'title', '0', '', 'form_textbox', '', '', '0', '1471834741', '1471834741', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('894', '146', '基本信息', '内容', '', '', 'body', '0', '', 'form_ueditor', '', '', '0', '1471834757', '1471834757', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('895', '146', '更多设置', '关键词', '', '', 'keywords', '0', '', 'form_textbox', '', '', '0', '1471834829', '1471834810', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('896', '146', '更多设置', '简介', '', '', 'description', '0', '', 'form_multitextbox', '', '', '0', '1471834841', '1471834841', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('897', '146', '更多设置', '短标题', '', '', 'shorttitle', '0', '', 'form_textbox', '', '', '0', '1471834867', '1471834867', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('898', '146', '更多设置', 'meta标题', '', '', 'metatitle', '0', '', 'form_textbox', '', '', '0', '1471834877', '1471834877', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('899', '146', '更多设置', '缩略图', '', '', 'thumb', '0', '', 'form_image', '', '', '0', '1471834903', '1471834903', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('900', '146', '更多设置', '模板', '', '', 'tpl', '0', '', 'form_textbox', '', '', '0', '1471834914', '1471834914', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('901', '146', '更多设置', '跳转链接', '', '', 'ebcms_url', '0', '', 'form_textbox', '', '', '0', '1471834938', '1471834938', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('902', '146', '个性扩展', '个性扩展', '', '', 'ext', '0', '', 'form_extend', '', '', '0', '1471834973', '1471834973', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('903', '147', '基本信息', '标题', '', '', 'title', '3', 'title', 'form_textbox', '', '', '0', '1471835198', '1471835198', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('904', '147', '基本信息', '内容', '', '', 'body', '3', 'body', 'form_ueditor', '', '', '0', '1471835215', '1471835215', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('905', '147', '更多设置', '关键词', '', '', 'keywords', '3', 'keywords', 'form_textbox', '', '', '0', '1471835245', '1471835245', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('906', '147', '更多设置', '简介', '', '', 'description', '3', 'description', 'form_multitextbox', '', '', '0', '1471835260', '1471835260', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('907', '147', '更多设置', '短标题', '', '', 'shorttitle', '3', 'shorttitle', 'form_textbox', '', '', '0', '1471835273', '1471835273', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('908', '147', '更多设置', 'meta标题', '', '', 'metatitle', '3', 'metatitle', 'form_textbox', '', '', '0', '1471835290', '1471835290', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('909', '147', '更多设置', '缩略图', '', '', 'thumb', '3', 'thumb', 'form_image', '', '', '0', '1471835308', '1471835308', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('910', '147', '更多设置', '模板', '', '', 'tpl', '3', 'tpl', 'form_textbox', '', '', '0', '1471835322', '1471835322', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('911', '147', '更多设置', '跳转链接', '', '', 'ebcms_url', '3', 'ebcms_url', 'form_textbox', '', '', '0', '1471835338', '1471835338', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('912', '147', '个性扩展', '个性扩展', '', '', 'ext', '3', 'ext', 'form_extend', '', '', '0', '1471835358', '1471835358', '1', '0', '');
INSERT INTO `ebcms5_formfield` VALUES ('913', '147', '基本信息', 'id', '', '', 'id', '3', 'id', 'form_hidden', '', '', '0', '1471835371', '1471835371', '1', '0', '');

-- ----------------------------
-- Table structure for ebcms5_forms
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_forms`;
CREATE TABLE `ebcms5_forms` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '表单名称',
  `remark` varchar(255) NOT NULL DEFAULT '' COMMENT '说明',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  `locked` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否锁定',
  `verify` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '验证码',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='万能表单表';

-- ----------------------------
-- Records of ebcms5_forms
-- ----------------------------
INSERT INTO `ebcms5_forms` VALUES ('1', '意见反馈', 'suggest', '', '0', '1471838809', '1471838809', '1', '0', '1');

-- ----------------------------
-- Table structure for ebcms5_formsdata
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_formsdata`;
CREATE TABLE `ebcms5_formsdata` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `forms_id` int(10) unsigned DEFAULT '0',
  `data` text,
  `ip` varchar(255) NOT NULL DEFAULT '' COMMENT 'ip',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  `locked` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '锁定',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='万能表单数据表';

-- ----------------------------
-- Records of ebcms5_formsdata
-- ----------------------------
INSERT INTO `ebcms5_formsdata` VALUES ('1', '1', '{\"您的称呼\":\"小明\",\"您的联系方式\":\"15451425568\",\"您的意见\":\"希望增加投稿功能\"}', '0.0.0.0', '1471838977', '1471838977', '0', '1', '0');

-- ----------------------------
-- Table structure for ebcms5_formsfield
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_formsfield`;
CREATE TABLE `ebcms5_formsfield` (
  `id` int(4) unsigned NOT NULL AUTO_INCREMENT COMMENT '配置ID',
  `forms_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分类',
  `title` varchar(250) NOT NULL DEFAULT '' COMMENT '标题',
  `type` varchar(255) NOT NULL DEFAULT '' COMMENT '表单类型',
  `config` text COMMENT '表单配置',
  `remark` text COMMENT '表单说明',
  `sort` int(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  `locked` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '锁定',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='万能表单字段表';

-- ----------------------------
-- Records of ebcms5_formsfield
-- ----------------------------
INSERT INTO `ebcms5_formsfield` VALUES ('1', '1', '您的称呼', 'text', '', '', '0', '1471838824', '1471838824', '1', '0');
INSERT INTO `ebcms5_formsfield` VALUES ('2', '1', '您的联系方式', 'text', '', '', '0', '1471838844', '1471838844', '1', '0');
INSERT INTO `ebcms5_formsfield` VALUES ('3', '1', '您的意见', 'textarea', '', '', '0', '1471838854', '1471838854', '1', '0');

-- ----------------------------
-- Table structure for ebcms5_guestbook
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_guestbook`;
CREATE TABLE `ebcms5_guestbook` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `nickname` varchar(255) NOT NULL DEFAULT '' COMMENT '昵称',
  `mobile` bigint(20) unsigned NOT NULL DEFAULT '0' COMMENT '手机号码',
  `content` varchar(255) NOT NULL DEFAULT '' COMMENT '留言内容',
  `reply` varchar(255) NOT NULL DEFAULT '' COMMENT '回复内容',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '回复时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '99' COMMENT '状态',
  `locked` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '锁定',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COMMENT='留言板表';

-- ----------------------------
-- Records of ebcms5_guestbook
-- ----------------------------
INSERT INTO `ebcms5_guestbook` VALUES ('1', '呵呵', '15425263253', '测试一下留言', '感谢你的留言。', '1468206437', '1469002109', '0', '1', '0');

-- ----------------------------
-- Table structure for ebcms5_link
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_link`;
CREATE TABLE `ebcms5_link` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `group` varchar(255) NOT NULL DEFAULT '' COMMENT '分组',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT '简介',
  `info` varchar(255) NOT NULL DEFAULT '' COMMENT '其他信息',
  `logo` varchar(255) NOT NULL DEFAULT '' COMMENT '图片地址',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '连接地址',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '99' COMMENT '状态',
  `locked` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否锁定',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='友情链接表';

-- ----------------------------
-- Records of ebcms5_link
-- ----------------------------
INSERT INTO `ebcms5_link` VALUES ('1', '友情链接', '易贝CMS', '易贝cms是一款开源的cms系统', '', '', 'http://www.ebcms.com', '1468853839', '1468148360', '0', '1', '0');
INSERT INTO `ebcms5_link` VALUES ('2', '友情链接', 'ThinkPHP官网', 'thinkphp是国内著名的php开发框架', '', '', 'http://www.thinkphp.cn/', '1468148406', '1468148406', '0', '1', '0');

-- ----------------------------
-- Table structure for ebcms5_menu
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_menu`;
CREATE TABLE `ebcms5_menu` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '菜菜单ID',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父ID',
  `type` varchar(20) NOT NULL DEFAULT '' COMMENT '类型',
  `title` varchar(20) NOT NULL DEFAULT '' COMMENT '标题',
  `url` varchar(250) NOT NULL DEFAULT '' COMMENT '附加参数',
  `iconcls` varchar(40) NOT NULL DEFAULT '' COMMENT '图标',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `sort` int(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  `locked` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '锁定',
  `sys_mark` varchar(255) NOT NULL DEFAULT '' COMMENT '系统标志',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=MyISAM AUTO_INCREMENT=137 DEFAULT CHARSET=utf8 COMMENT='功能菜单表';

-- ----------------------------
-- Records of ebcms5_menu
-- ----------------------------
INSERT INTO `ebcms5_menu` VALUES ('11', '96', 'admin', '操作日志', 'admin/oplog/index', 'iconfont icon-caozuorizhi', '1469019502', '2015', '1', '1', '1', '');
INSERT INTO `ebcms5_menu` VALUES ('13', '96', 'admin', '模板管理', 'admin/template/index', 'iconfont icon-sheweimoban', '1457527938', '2015', '14', '1', '1', '');
INSERT INTO `ebcms5_menu` VALUES ('72', '0', 'admin', '基本管理', '', 'icon-rainbow', '2015', '2015', '50', '1', '0', '');
INSERT INTO `ebcms5_menu` VALUES ('132', '127', 'admin', '评论管理', 'content/admin.comment/index', 'iconfont icon-luntan', '1467943935', '1467939010', '0', '1', '1', '');
INSERT INTO `ebcms5_menu` VALUES ('79', '72', 'admin', '导航管理', 'admin/nav/index', 'iconfont icon-caidan', '1457527841', '2015', '10', '1', '0', '');
INSERT INTO `ebcms5_menu` VALUES ('80', '72', 'admin', '友情链接', 'admin/link/index', 'iconfont icon-lianjie', '1471334381', '2015', '20', '1', '1', '');
INSERT INTO `ebcms5_menu` VALUES ('81', '72', 'admin', '留言中心', 'admin/guestbook/index', 'iconfont icon-fangbianregistration-copy', '1471334375', '2015', '31', '1', '0', '');
INSERT INTO `ebcms5_menu` VALUES ('92', '96', 'admin', '备份优化', 'admin/database/index', 'iconfont icon-mysqlshujuku', '1457745746', '2015', '10', '1', '1', '');
INSERT INTO `ebcms5_menu` VALUES ('95', '72', 'admin', '推荐管理', 'admin/recommend/index', 'iconfont icon-tuijian', '1471334370', '2015', '40', '1', '0', '');
INSERT INTO `ebcms5_menu` VALUES ('96', '0', 'admin', '站点管理', '', 'icon-zone', '1469019491', '2015', '30', '1', '0', '');
INSERT INTO `ebcms5_menu` VALUES ('100', '0', 'admin', '会员管理', '', 'icon-group', '2015', '2015', '40', '1', '0', '');
INSERT INTO `ebcms5_menu` VALUES ('105', '100', 'admin', '会员管理', 'admin/user/index', 'iconfont icon-huiyuan21', '1471334389', '2015', '90', '1', '0', '');
INSERT INTO `ebcms5_menu` VALUES ('106', '100', 'admin', '角色管理', 'admin/group/index', 'iconfont icon-jiaoseguanli-copy', '1471334393', '2015', '85', '1', '0', '');
INSERT INTO `ebcms5_menu` VALUES ('118', '72', 'admin', '单页管理', 'admin/single/index', 'iconfont icon-wenzhang', '1471334364', '1460039274', '48', '1', '0', '');
INSERT INTO `ebcms5_menu` VALUES ('127', '0', 'admin', '内容管理', '', '', '1467938803', '1467938803', '120', '1', '1', '');
INSERT INTO `ebcms5_menu` VALUES ('128', '127', 'admin', '内容管理', 'content/admin.content/index', 'iconfont icon-wenzhang', '1467938943', '1467938833', '0', '1', '1', '');
INSERT INTO `ebcms5_menu` VALUES ('129', '127', 'admin', '栏目管理', 'content/admin.category/index', 'iconfont icon-lanmu', '1467943997', '1467938852', '0', '1', '1', '');
INSERT INTO `ebcms5_menu` VALUES ('130', '127', 'admin', '内容扩展', 'admin/extend/index?group=content', 'iconfont icon-unie678', '1467988323', '1467938877', '0', '1', '1', '');
INSERT INTO `ebcms5_menu` VALUES ('131', '127', 'admin', '标签管理', 'content/admin.tag/index', 'iconfont icon-biaoqian', '1467943956', '1467938892', '0', '1', '1', '');
INSERT INTO `ebcms5_menu` VALUES ('135', '72', 'admin', '万能表单', 'forms/formsdata/index', 'iconfont icon-caidan', '1471751543', '1471705877', '0', '1', '0', '');
INSERT INTO `ebcms5_menu` VALUES ('136', '72', 'admin', '公告管理', 'bulletin/bulletin/index', 'iconfont icon-wenzhang', '1471834065', '1471834038', '0', '1', '0', '');

-- ----------------------------
-- Table structure for ebcms5_nav
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_nav`;
CREATE TABLE `ebcms5_nav` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `group` varchar(255) NOT NULL DEFAULT '' COMMENT '分组',
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'category_id 冗余',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父ID',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `ebcms_url` varchar(255) NOT NULL DEFAULT '' COMMENT '连接地址',
  `ext` text COMMENT '扩展信息',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  `locked` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '锁定',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COMMENT='导航表';

-- ----------------------------
-- Records of ebcms5_nav
-- ----------------------------
INSERT INTO `ebcms5_nav` VALUES ('1', '', '1', '0', '帮助', '', '{\"icon\":\"AISA\",\"bigicon\":\"\"}', '0', '1469929043', '3', '1', '0');
INSERT INTO `ebcms5_nav` VALUES ('2', '', '1', '0', '留言', 'index/guestbook/index', '{\"icon\":\"AISA\",\"bigicon\":\"\"}', '0', '1471335655', '1', '1', '0');
INSERT INTO `ebcms5_nav` VALUES ('3', '', '1', '0', '标签', 'index/content/tag', '{\"icon\":\"AISA\",\"bigicon\":\"\"}', '0', '1469929041', '0', '1', '0');
INSERT INTO `ebcms5_nav` VALUES ('4', '', '3', '0', '个人信息', '', '', '1467714466', '1469929049', '0', '1', '0');
INSERT INTO `ebcms5_nav` VALUES ('5', '', '3', '0', '其他信息', '', '', '1467714473', '1469929055', '0', '1', '0');
INSERT INTO `ebcms5_nav` VALUES ('6', '', '3', '4', '修改密码', 'index/user/password', '', '1467714488', '1471335625', '0', '1', '0');
INSERT INTO `ebcms5_nav` VALUES ('7', '', '3', '4', '修改信息', 'index/user/info', '', '1467714499', '1471335631', '0', '1', '0');
INSERT INTO `ebcms5_nav` VALUES ('8', '', '2', '0', '关于我们', '/company/jianjie', '{\"icon\":\"AISA\",\"bigicon\":\"\"}', '1468480673', '1469929046', '0', '1', '0');
INSERT INTO `ebcms5_nav` VALUES ('9', '', '1', '1', '公司简介', 'index/single/index?id=1', '{\"color\":\"green\"}', '1468482259', '1471335643', '0', '1', '0');
INSERT INTO `ebcms5_nav` VALUES ('10', '', '1', '1', '联系我们', 'index/single/index?id=2', '{\"icon\":\"AISA\",\"bigicon\":\"\"}', '1468546613', '1471335648', '0', '1', '0');

-- ----------------------------
-- Table structure for ebcms5_navcate
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_navcate`;
CREATE TABLE `ebcms5_navcate` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `mark` varchar(255) NOT NULL DEFAULT '' COMMENT '标识',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `extend_id` varchar(255) NOT NULL DEFAULT '' COMMENT '导航模型',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  `locked` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否锁定',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='导航分类表';

-- ----------------------------
-- Records of ebcms5_navcate
-- ----------------------------
INSERT INTO `ebcms5_navcate` VALUES ('1', 'main', '主导航 - 右侧', '2', '1468480882', '0', '99', '1', '1');
INSERT INTO `ebcms5_navcate` VALUES ('2', 'bottom', '底部导航', '2', '1468639064', '0', '10', '1', '1');
INSERT INTO `ebcms5_navcate` VALUES ('3', 'user', '会员中心', '', '1467714350', '1457330210', '3', '1', '0');

-- ----------------------------
-- Table structure for ebcms5_oplog
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_oplog`;
CREATE TABLE `ebcms5_oplog` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作人id',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '说明',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '动作',
  `ids` text COMMENT '提交的id',
  `request` text COMMENT '详细',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '执行状态',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='操作日志表';

-- ----------------------------
-- Records of ebcms5_oplog
-- ----------------------------

-- ----------------------------
-- Table structure for ebcms5_recommend
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_recommend`;
CREATE TABLE `ebcms5_recommend` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分类id',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `thumb` varchar(255) NOT NULL DEFAULT '' COMMENT '缩略图',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT '简介',
  `ebcms_url` varchar(255) NOT NULL DEFAULT '' COMMENT '链接地址',
  `push_url` varchar(255) NOT NULL DEFAULT '' COMMENT '未处理的url',
  `ext` text COMMENT '扩展信息',
  `model` varchar(255) NOT NULL DEFAULT '' COMMENT '模块',
  `content_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  `locked` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '锁定',
  `color` varchar(255) NOT NULL DEFAULT '' COMMENT '字体颜色',
  `size` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '字号',
  `bold` varchar(255) NOT NULL DEFAULT '' COMMENT '加粗',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 COMMENT='推荐内容表';

-- ----------------------------
-- Records of ebcms5_recommend
-- ----------------------------
INSERT INTO `ebcms5_recommend` VALUES ('8', '1', '中国基因编辑研究且快且急，看专家怎么说？', '', '　　文章来源：中国科学报 微信公众号　　专家建议尽快完善相关法律规避伦理风险和社会争议　　从修改植物基因，到改变蝴蝶翅膀的图案，再到修改人类细胞……以CRISPR为代表的基因编辑技术风靡生命科学领域。　　日前，在香山科学会议第564次学术讨论会上，专家指出，我国基因编辑研究工作正在向源头创新转移，现阶段应大力推动该领域的研究及应用，并及时制定严格有效的监管措施和伦理规范，保证基因编辑下游应用快速健康有序发展。', '', '', '{\"tjly\":\"\",\"radio\":\"beijing\",\"checkbox\":[\"black\"]}', 'content/content', '58', '1471358628', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_recommend` VALUES ('2', '1', '研究报告：地球近六成陆地物种多样性遭严重破坏', '', '资料图：亚马逊雨林被开垦用来种大豆。　　中新网7月16日电 据外媒报道，最新《科学》期刊上的一份研究报告称，地球陆地上58%地区的物种多样性完整指数已低于安全值。　　该份报告指出，受此冲击最大的是美国、阿根廷、南非与中亚的草原地区，这些地区的动物与植物数量皆因人类活动而减少。　　报告指出，陆地表面约58%地区的物种“完整性”已经降至安全界限以下；这主要是农业用地、道路与城市发展持续扩充所致。全球大约71%的人口居', '', '', '{\"tjly\":\"\",\"radio\":\"beijing\",\"checkbox\":[\"black\"]}', 'content/content', '56', '1471358641', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_recommend` VALUES ('3', '2', 'iPhone 7还没发布8的消息就来了：将采用OLED屏幕', 'http://www.ebcms.com/demo/v5/upload/image/20160728/5b0acc9f54cb0c73bbd6834e164eef10.jpg!1200_300_3.jpg', '2017年将是苹果iPhone诞生的第十个年头，在这样一个特殊的日子，全新的iPhone8或7s也将以崭新的面貌展现在用户面前，根据内部人士的爆料和分析师的预测，下一代iPhone8无论在材质还是功能上都将有飞跃，其中可以确定的是明年的iPhone将使用OLED屏幕。', '', '', '', 'content/content', '50', '1471358666', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_recommend` VALUES ('4', '1', 'iPhone 7还没发布8的消息就来了：将采用OLED屏幕', '', '2017年将是苹果iPhone诞生的第十个年头，在这样一个特殊的日子，全新的iPhone8或7s也将以崭新的面貌展现在用户面前，根据内部人士的爆料和分析师的预测，下一代iPhone8无论在材质还是功能上都将有飞跃，其中可以确定的是明年的iPhone将使用OLED屏幕。　　全球OLED供应商包括LG Display、三星、JDI和夏普，无论是谁都想抢得苹果这个超级金主，三星目前垄断全球90% OLED屏幕出货量，是其中最可能成为苹果供应商的厂家，LG Display此前就曾表示会为了争取订单', '', '', '{\"tjly\":\"\",\"radio\":\"beijing\",\"checkbox\":[\"black\"]}', 'content/content', '50', '1471358637', '0', '0', '1', '1', '', '0', '');
INSERT INTO `ebcms5_recommend` VALUES ('5', '2', '里约红灯区变成性交易超市 30分钟交易仅需9英镑', 'http://www.ebcms.com/demo/v5/upload/image/20160728/cf8a3ac52824729849c9b1d719aab5cd.jpg!1200_300_3.jpg', '新浪体育讯　　北京时间7月15日消息，里约热内卢红灯区的妓女们正在为里约奥运会提供“性服务销售”，原本希望在巴西举办世界杯之后迎来井喷的市场，却在两年后意外遇冷。身处臭名昭著的比拉-米莫萨区的性工作者们表示，原本期待在巴西世界杯后延续热潮的市场却出现了大幅下滑。　　目前距离奥运会开幕还有不到一个月的时间， 性工作者表示她们已经准备好了英文传单邀请运动员光顾里约城旁边的这个红灯区，提供十分便宜的性交易。破', '', '', '', 'content/content', '34', '1471358657', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_recommend` VALUES ('6', '1', '里约红灯区变成性交易超市 30分钟交易仅需9英镑', '', '新浪体育讯　　北京时间7月15日消息，里约热内卢红灯区的妓女们正在为里约奥运会提供“性服务销售”，原本希望在巴西举办世界杯之后迎来井喷的市场，却在两年后意外遇冷。身处臭名昭著的比拉-米莫萨区的性工作者们表示，原本期待在巴西世界杯后延续热潮的市场却出现了大幅下滑。　　目前距离奥运会开幕还有不到一个月的时间， 性工作者表示她们已经准备好了英文传单邀请运动员光顾里约城旁边的这个红灯区，提供十分便宜的性交易。破', '', '', '{\"tjly\":\"\",\"radio\":\"beijing\",\"checkbox\":[\"black\"]}', 'content/content', '34', '1471358632', '0', '0', '1', '1', '', '0', '');
INSERT INTO `ebcms5_recommend` VALUES ('7', '2', '三星S7 Edge巴西里约奥运会限量版：五环五色', 'http://www.ebcms.com/demo/v5/upload/image/20160728/f4826d6cc8bf8f22e0f84b10b8e1027e.jpg!1200_300_3.jpg', '巴西里1', '', '', '', 'content/content', '53', '1471358647', '0', '0', '1', '0', '', '0', '');
INSERT INTO `ebcms5_recommend` VALUES ('11', '1', '油价回归“5元时代” 加满一箱油省五块钱', 'http://www.ebcms.com/demo/v5/upload/image/20160727/18ce56816ccb0534532d79c8c9025f4e.png!100_100_3.png', '央视财经讯 我国年内第14次成品油零售价调价窗口期，于7月21日24时开启。经过前两次搁浅后,国家发改委宣布，本次成品油价格迎来年内第二次下调！汽、柴油每吨分别下调155元和150元；全国平均来看折合90号汽油每升下调0.1元，0号柴油每升下调0.13元，92号汽油均每升下调0.11元。按一般家用汽车油箱50L的容量估测,加满一箱汽油将节省约5元。此次成品油零售价格下调，国内汽柴油零售市场将再次全面回归“五元时代”。对于终端消费者来说，降低出行成本无疑是个好消息。以北京为例，#92#号汽油将从6.05元/', '', '', '{\"tjly\":\"\",\"radio\":\"beijing\",\"checkbox\":[\"black\"]}', 'content/content', '59', '1471358688', '0', '0', '1', '0', '', '0', '');

-- ----------------------------
-- Table structure for ebcms5_recommendcate
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_recommendcate`;
CREATE TABLE `ebcms5_recommendcate` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `group` varchar(255) NOT NULL DEFAULT '' COMMENT '分组',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `mark` varchar(255) NOT NULL DEFAULT '' COMMENT '标识',
  `extend_id` varchar(255) NOT NULL DEFAULT '' COMMENT '模型',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  `locked` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否锁定',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='推荐位表';

-- ----------------------------
-- Records of ebcms5_recommendcate
-- ----------------------------
INSERT INTO `ebcms5_recommendcate` VALUES ('1', '默认分组', '头条', 'index_toutiao', '3', '1469453438', '1468150377', '0', '1', '0');
INSERT INTO `ebcms5_recommendcate` VALUES ('2', '默认分组', '轮播', 'index_slide', '', '1468573414', '1468150388', '0', '1', '0');

-- ----------------------------
-- Table structure for ebcms5_single
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_single`;
CREATE TABLE `ebcms5_single` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `group` varchar(255) NOT NULL DEFAULT '' COMMENT '分组',
  `path` varchar(255) NOT NULL DEFAULT '' COMMENT '名称',
  `ebcms_url` varchar(255) NOT NULL DEFAULT '' COMMENT '外部链接',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `shorttitle` varchar(255) NOT NULL DEFAULT '' COMMENT '短标题',
  `metatitle` varchar(255) NOT NULL DEFAULT '' COMMENT 'META标题',
  `keywords` varchar(255) NOT NULL DEFAULT '' COMMENT '关键字',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT '简介',
  `thumb` varchar(255) NOT NULL DEFAULT '' COMMENT '缩略图',
  `tpl` varchar(255) NOT NULL DEFAULT '' COMMENT '模板',
  `body` text COMMENT '内容',
  `ext` text COMMENT '扩展内容',
  `click` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '点击量',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  `locked` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '锁定',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='单页表';

-- ----------------------------
-- Records of ebcms5_single
-- ----------------------------
INSERT INTO `ebcms5_single` VALUES ('1', '公司相关', '/company/jianjie', '', '公司简介', '', '', '', '某某公司是一个什么养的公司。', '', '', '&lt;p&gt;某某公司是一个什么养的公司。&lt;/p&gt;', '{\"__config__\":{\"__test__\":\"test\"}}', '0', '1471839311', '1468478445', '8', '1', '0');
INSERT INTO `ebcms5_single` VALUES ('2', '公司相关', '/haha', '', '联系我们', '', '', '', '/about/us /about /contactus', '', '', '&lt;p&gt;&lt;span style=&quot;color: rgb(115, 115, 115); font-family: &quot;&gt;联系我们咯&lt;/span&gt;&lt;/p&gt;', '{\"联系方式\":\"成都市武侯区。。\",\"__config__\":{\"联系方式\":\"text\",\"联系电话\":\"text\",\"公司简介\":\"textarea\",\"公司logo\":\"file\",\"__test__\":\"test\"},\"联系电话\":\"18202839759\",\"公司简介\":\"我们公司是。。。\",\"公司logo\":\"\\/image\\/20160722\\/cb8748649029192ee9bd1d1dd7bbc7d5.jpg\"}', '0', '1471839315', '1468479488', '6', '1', '0');
INSERT INTO `ebcms5_single` VALUES ('3', '公司相关', '/asdf_d', '', '测试一下子。', '', '', '', '阿斯顿发生啊手动阀十大撒旦发射点发', '/image/20160717/1468749632483246578b5740b590c.png', '', '&lt;p&gt;阿斯顿发生啊手动阀十大撒旦发射点发&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://www.ebcms5.com/upload/image/20160717/1468749632483246578b5740b590c.png!200_160_3.png&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://www.ebcms5.com/upload/image/20160717/1468749103184176578b552f8e88a.png!200_160_3.png&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;img src=&quot;http://www.ebcms5.com/upload/image/20160717/1468748981125747578b54b5930ce.png!200_160_3.png&quot;/&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '{\"__config__\":{\"__test__\":\"test\"}}', '0', '1471839318', '1468583893', '9', '1', '0');

-- ----------------------------
-- Table structure for ebcms5_tongji
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_tongji`;
CREATE TABLE `ebcms5_tongji` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '网页标题',
  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '链接地址',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `ip` varchar(255) NOT NULL DEFAULT '' COMMENT 'ip',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='操作日志表';

-- ----------------------------
-- Records of ebcms5_tongji
-- ----------------------------

-- ----------------------------
-- Table structure for ebcms5_user
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_user`;
CREATE TABLE `ebcms5_user` (
  `id` int(3) unsigned NOT NULL AUTO_INCREMENT COMMENT '后台人员ID',
  `email` varchar(255) NOT NULL DEFAULT '' COMMENT 'QQ号码',
  `nickname` char(20) NOT NULL DEFAULT '' COMMENT '用户名',
  `avatar` varchar(255) NOT NULL DEFAULT '' COMMENT '头像',
  `motto` varchar(255) NOT NULL DEFAULT '' COMMENT '座右铭',
  `password` char(32) NOT NULL DEFAULT '' COMMENT '密码',
  `login_times` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '登陆次数',
  `login_ip` char(15) NOT NULL DEFAULT '' COMMENT '登陆ip地址',
  `jifen` int(11) NOT NULL DEFAULT '0' COMMENT '积分',
  `jinbi` int(11) NOT NULL DEFAULT '0' COMMENT '金币',
  `login_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最后登陆时间',
  `salt` varchar(255) NOT NULL DEFAULT ' love ebcms forever!' COMMENT '盐',
  `safe_code` varchar(255) NOT NULL DEFAULT '' COMMENT '安全码',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `sort` int(4) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
  `locked` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '锁定',
  `ext` text COMMENT '扩展信息',
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='用户表';

-- ----------------------------
-- Records of ebcms5_user
-- ----------------------------
INSERT INTO `ebcms5_user` VALUES ('1', '1540837821@qq.com', '管理员', '/avatar/20160725/0ec6892ebc2ef6b79bf06e8493d5c9fe.jpg', '18202839759', '6ae17bf0ec58760592c21cb5749f0d9f', '38', '0.0.0.0', '0', '0', '1472541455', '1540837821@qq.com love ebcms forever!', '', '1472541455', '0', '0', '1', '0', '');

-- ----------------------------
-- Table structure for ebcms5_user_notice
-- ----------------------------
DROP TABLE IF EXISTS `ebcms5_user_notice`;
CREATE TABLE `ebcms5_user_notice` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '节点ID',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `content` text COMMENT '消息内容',
  `isread` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否已读',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '回复时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '99' COMMENT '状态',
  `locked` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '锁定',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='消息通知表';

-- ----------------------------
-- Records of ebcms5_user_notice
-- ----------------------------
