<!-- RIBBON -->
<div id="ribbon">

				<span class="ribbon-button-alignment"> 
					<span id="refresh" class="btn btn-ribbon" data-action="resetWidgets" data-title="refresh"  rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Warning! This will reset all your widget settings." data-html="true">
						<i class="fa fa-refresh"></i>
					</span> 
				</span>

    <!-- breadcrumb -->
    <ol class="breadcrumb">
        <li>Home</li><li>Forms</li><li>Dropzone</li>
    </ol>
    <!-- end breadcrumb -->

    <!-- You can also add more buttons to the
    ribbon for further usability

    Example below:

    <span class="ribbon-button-alignment pull-right">
    <span id="search" class="btn btn-ribbon hidden-xs" data-title="search"><i class="fa-grid"></i> Change Grid</span>
    <span id="add" class="btn btn-ribbon hidden-xs" data-title="add"><i class="fa-plus"></i> Add</span>
    <span id="search" class="btn btn-ribbon" data-title="search"><i class="fa-search"></i> <span class="hidden-mobile">Search</span></span>
    </span> -->

</div>
<!-- END RIBBON -->

<!-- MAIN CONTENT -->
<div id="content">

    <div class="row">
        <div class="col-xs-12 col-sm-7 col-md-7 col-lg-4">
            <h1 class="page-title txt-color-blueDark">
                <i class="fa fa-pencil-square-o fa-fw "></i>
                Forms
			<span>> 
				Dropzone
			</span>
            </h1>
        </div>
        <div class="col-xs-12 col-sm-5 col-md-5 col-lg-8">
            <ul id="sparks" class="">
                <li class="sparks-info">
                    <h5> My Income <span class="txt-color-blue">$47,171</span></h5>
                    <div class="sparkline txt-color-blue hidden-mobile hidden-md hidden-sm">
                        1300, 1877, 2500, 2577, 2000, 2100, 3000, 2700, 3631, 2471, 2700, 3631, 2471
                    </div>
                </li>
                <li class="sparks-info">
                    <h5> Site Traffic <span class="txt-color-purple"><i class="fa fa-arrow-circle-up" data-rel="bootstrap-tooltip" title="Increased"></i>&nbsp;45%</span></h5>
                    <div class="sparkline txt-color-purple hidden-mobile hidden-md hidden-sm">
                        110,150,300,130,400,240,220,310,220,300, 270, 210
                    </div>
                </li>
                <li class="sparks-info">
                    <h5> Site Orders <span class="txt-color-greenDark"><i class="fa fa-shopping-cart"></i>&nbsp;2447</span></h5>
                    <div class="sparkline txt-color-greenDark hidden-mobile hidden-md hidden-sm">
                        110,150,300,130,400,240,220,310,220,300, 270, 210
                    </div>
                </li>
            </ul>
        </div>
    </div>

    <!-- widget grid -->
    <section id="widget-grid" class="">

        <!-- row -->
        <div class="row">

            <!-- NEW WIDGET START -->
            <article class="col-sm-12">

                <p class="alert alert-warning">
                    <i class="fa fa-warning fa-fw fa-lg"></i><strong>Opps!</strong>
                    You may get an error during the upload for this demo. The error will subside once the backend portion is properly configured.
                </p>
                <p>
				<span class="label label-warning">
				NOTE</span> &nbsp; This plugins works only on Latest Chrome, Firefox, Safari, Opera &amp; Internet Explorer 10.
                </p>

                <!-- Widget ID (each widget will need unique ID)-->
                <div class="jarviswidget jarviswidget-color-blueLight" id="wid-id-0" data-widget-editbutton="false">
                    <!-- widget options:
                    usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false">

                    data-widget-colorbutton="false"
                    data-widget-editbutton="false"
                    data-widget-togglebutton="false"
                    data-widget-deletebutton="false"
                    data-widget-fullscreenbutton="false"
                    data-widget-custombutton="false"
                    data-widget-collapsed="true"
                    data-widget-sortable="false"

                    -->
                    <header>
                        <span class="widget-icon"> <i class="fa fa-cloud"></i> </span>
                        <h2>My Dropzone! </h2>

                    </header>

                    <!-- widget div-->
                    <div>

                        <!-- widget edit box -->
                        <div class="jarviswidget-editbox">
                            <!-- This area used as dropdown edit box -->

                        </div>
                        <!-- end widget edit box -->

                        <!-- widget content -->
                        <div class="widget-body">

                            <form action="upload.php" class="dropzone" id="mydropzone"></form>

                        </div>
                        <!-- end widget content -->

                    </div>
                    <!-- end widget div -->

                </div>
                <!-- end widget -->

            </article>
            <!-- WIDGET END -->

        </div>

        <!-- end row -->

        <!-- row -->

        <div class="row">

            <div class="col-sm-12 col-md-12">
                <div class="well">
                    <h1>Dropzone Faqs</h1>
                    <hr class="simple">
                    <h3>I get the error "Dropzone already attached." when creating the Dropzone.</h3>
                    <p>
                        This is most likely due to the autoDiscover feature of Dropzone.
                    </p>

                    <p>
                        When Dropzone starts, it scans the whole document, and looks for elements with the <code>
                            dropzone</code>
                        class. It then creates an instance of Dropzone for every element found. If you, later on, create a Dropzone instance yourself, you'll create a second Dropzone which causes this error.</p>

                    <p>
                        So you can either:</p>

                    <ol>
                        <li>
                            Turn off autoDiscover globally like this: <code>
                                Dropzone.autoDiscover = false;</code>
                            , or
                        </li>
                        <li>
                            Turn off autoDiscover of specific elements like this: <code>
                                Dropzone.options.myAwesomeDropzone = false;</code>
                        </li>
                    </ol>

                    <blockquote>
                        <p>
                            You don't have to create an instance of Dropzone programmatically in most situations! It's recommended
                            to leave <strong>autoDiscover</strong> enabled, and configure your Dropzone in the <code>
                                init</code>
                            option of your configuration.</p>
                    </blockquote>
                    <br>

                    <h3>Why are large files not uploading?</h3>
                    <p>
                        There is a <code>
                            maxFileSize</code>
                        option in Dropzone which defaults to <code>
                            256</code>
                        (MB). Increase this to upload files bigger than that. If your files upload fine but aren't stored on the server, then it's due to your server configuration. Most servers limit the file upload size as well. Please check with the appropriate documentation.</p>
                    <br>

                    <h3>How to get notified when all files finished uploading?</h3>
                    <p>
                        At the moment there isn't a single event to do that, but you can listen to the <code>
                            complete</code>
                        event, which fires every time a file completed uploading, and see if there are still files in the queue or being processed.</p>
                    <br>

                    <h3>Why are some image thumbnails not generated?</h3>
                    <p>
                        There is a <code>
                            maxThumbnailFilesize</code>
                        option in Dropzone which defaults to <code>
                            10</code>
                        (MB) to prevent the browser from downsizing images that are too big. Increase this to create thumbnails of bigger files.</p>
                    <br>

                    <h3>How to get notified when all files finished uploading?</h3>
                    <p>
                        At the moment there isn't a single event to do that, but you can listen to the <code>
                            complete</code>
                        event, which fires every time a file completed uploading, and see if there are still files in the queue or being processed.</p>
				<pre><span class="nx">Dropzone</span><span class="p">.</span><span class="nx">options</span><span class="p">.</span><span class="nx">myDrop</span> <span class="o">=</span> <span class="p">{</span>
  <span class="nx">init</span><span class="o">:</span> <span class="kd">function</span><span class="p">()</span> <span class="p">{</span>
    <span class="k">this</span><span class="p">.</span><span class="nx">on</span><span class="p">(</span><span class="s2">"complete"</span><span class="p">,</span> <span class="kd">function</span><span class="p">()</span> <span class="p">{</span>
      <span class="k">if</span> <span class="p">(</span><span class="k">this</span><span class="p">.</span><span class="nx">filesQueue</span><span class="p">.</span><span class="nx">length</span> <span class="o">==</span> <span class="mi">0</span> <span class="o">&amp;&amp;</span> <span class="k">this</span><span class="p">.</span><span class="nx">filesProcessing</span><span class="p">.</span><span class="nx">length</span> <span class="o">==</span> <span class="mi">0</span><span class="p">)</span> <span class="p">{</span>
        <span class="c1">// File finished uploading, and there aren't any left in the queue.</span>
      <span class="p">}</span>
    <span class="p">});</span>
  <span class="p">}</span>
<span class="p">};</span>
</pre>
                    <br>

                    <h3>How to show an error returned by the server?</h3>
                    <p>
                        Very often you have to do some verification on the server to check if the file is actually valid. If you want Dropzone to display any error encountered on the server, all you have to do, is send back a proper <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.4" target="_blank">HTTP status code</a> in the range of 400 - 500.</p>
                    <p>
                        Dropzone will then know that the file upload was invalid, and will display the returned text as error message.</p>
                    <p>
                        In most frameworks those error codes are generated automatically when you send back an error to the client. In PHP (for example) you can set it with the <code>
                            header</code>
                        command.</p>
                    <br>
                    <h3>How to add a button to remove each file preview?</h3>

                    <p>
                        Starting with Dropzone version 3.5.0, there is an option that will handle all this for you: <code>
                            addRemoveLinks</code>
                        . This will add an <code>
                            &lt;a class="dz-remove"&gt;Remove file&lt;/a&gt;</code>
                        element to the file preview that will remove the file, and it will change to <em>Cancel upload</em> if the file is currently being uploaded (this will trigger a confirmation dialog).</p>

                    <p>
                        You can change those sentences with the <code>
                            dictRemoveFile</code>
                        , <code>
                            dictCancelUpload</code>
                        and <code>
                            dictCancelUploadConfirmation</code>
                        options.</p>

                    <p>
                        If you still want to create the button yourself, you can do so like this:</p>
				<pre><span class="nt">&lt;form</span> <span class="na">action=</span><span class="s">"/target-url"</span> <span class="na">id=</span><span class="s">"my-dropzone"</span> <span class="na">class=</span><span class="s">"dropzone"</span><span class="nt">&gt;&lt;/form&gt;</span>

<span class="nt">&lt;script&gt;</span>
  <span class="c1">// myDropzone is the configuration for the element that has an id attribute</span>
  <span class="c1">// with the value my-dropzone (or myDropzone)</span>
  <span class="nx">Dropzone</span><span class="p">.</span><span class="nx">options</span><span class="p">.</span><span class="nx">myDropzone</span> <span class="o">=</span> <span class="p">{</span>
    <span class="nx">init</span><span class="o">:</span> <span class="kd">function</span><span class="p">()</span> <span class="p">{</span>
      <span class="k">this</span><span class="p">.</span><span class="nx">on</span><span class="p">(</span><span class="s2">"addedfile"</span><span class="p">,</span> <span class="kd">function</span><span class="p">(</span><span class="nx">file</span><span class="p">)</span> <span class="p">{</span>

        <span class="c1">// Create the remove button</span>
        <span class="kd">var</span> <span class="nx">removeButton</span> <span class="o">=</span> <span class="nx">Dropzone</span><span class="p">.</span><span class="nx">createElement</span><span class="p">(</span><span class="s2">"&lt;button&gt;Remove file&lt;/button&gt;"</span><span class="p">);</span>
        

        <span class="c1">// Capture the Dropzone instance as closure.</span>
        <span class="kd">var</span> <span class="nx">_this</span> <span class="o">=</span> <span class="k">this</span><span class="p">;</span>

        <span class="c1">// Listen to the click event</span>
        <span class="nx">removeButton</span><span class="p">.</span><span class="nx">addEventListener</span><span class="p">(</span><span class="s2">"click"</span><span class="p">,</span> <span class="kd">function</span><span class="p">(</span><span class="nx">e</span><span class="p">)</span> <span class="p">{</span>
          <span class="c1">// Make sure the button click doesn't submit the form:</span>
          <span class="nx">e</span><span class="p">.</span><span class="nx">preventDefault</span><span class="p">();</span>
          <span class="nx">e</span><span class="p">.</span><span class="nx">stopPropagation</span><span class="p">();</span>

          <span class="c1">// Remove the file preview.</span>
          <span class="nx">_this</span><span class="p">.</span><span class="nx">removeFile</span><span class="p">(</span><span class="nx">file</span><span class="p">);</span>
          <span class="c1">// If you want to the delete the file on the server as well,</span>
          <span class="c1">// you can do the AJAX request here.</span>
        <span class="p">});</span>

        <span class="c1">// Add the button to the file preview element.</span>
        <span class="nx">file</span><span class="p">.</span><span class="nx">previewElement</span><span class="p">.</span><span class="nx">appendChild</span><span class="p">(</span><span class="nx">removeButton</span><span class="p">);</span>
      <span class="p">});</span>
    <span class="p">}</span>
  <span class="p">};</span>
<span class="nt">&lt;/script&gt;</span>
</pre>

                    <br>

                    <h3>How to submit additional data along the file upload?</h3>

                    <p>
                        If your Dropzone element is a <code>
                            &lt;form&gt;</code>
                        element, all hidden input fields will automatically be submitted as POST data along with the file upload.</p>

                    <p>
                        Example:</p>

				
					<pre><span class="nt">&lt;form</span> <span class="na">action=</span><span class="s">"/"</span> <span class="na">class=</span><span class="s">"dropzone"</span><span class="nt">&gt;</span>
  <span class="nt">&lt;input</span> <span class="na">type=</span><span class="s">"hidden"</span> <span class="na">name=</span><span class="s">"additionaldata"</span> <span class="na">value=</span><span class="s">"1"</span> <span class="nt">/&gt;</span>

  <span class="c">&lt;!-- If you want control over the fallback form, just add it here: --&gt;</span>
  <span class="nt">&lt;div</span> <span class="na">class=</span><span class="s">"fallback"</span><span class="nt">&gt;</span> <span class="c">&lt;!-- This div will be removed if the fallback is not necessary --&gt;</span>
    <span class="nt">&lt;input</span> <span class="na">type=</span><span class="s">"file"</span> <span class="na">name=</span><span class="s">"youfilename"</span> <span class="nt">/&gt;</span>
    etc...
  <span class="nt">&lt;/div&gt;</span>
<span class="nt">&lt;/form&gt;</span>
</pre>
                    <br>
                    <h3>I want to display additional information after a file uploaded.</h3>

                    <p>
                        To use the information sent back from the server, use the <code>
                            success</code>
                        event, like this:</p>

				
					<pre><span class="nx">Dropzone</span><span class="p">.</span><span class="nx">options</span><span class="p">.</span><span class="nx">myDropzone</span> <span class="o">=</span> <span class="p">{</span>
  <span class="nx">init</span><span class="o">:</span> <span class="kd">function</span><span class="p">()</span> <span class="p">{</span>
    <span class="k">this</span><span class="p">.</span><span class="nx">on</span><span class="p">(</span><span class="s2">"success"</span><span class="p">,</span> <span class="kd">function</span><span class="p">(</span><span class="nx">file</span><span class="p">,</span> <span class="nx">responseText</span><span class="p">)</span> <span class="p">{</span>
      <span class="c1">// Handle the responseText here. For example, add the text to the preview element:</span>
      <span class="nx">file</span><span class="p">.</span><span class="nx">previewTemplate</span><span class="p">.</span><span class="nx">appendChild</span><span class="p">(</span><span class="nb">document</span><span class="p">.</span><span class="nx">createTextNode</span><span class="p">(</span><span class="nx">responseText</span><span class="p">));</span>
    <span class="p">});</span>
  <span class="p">}</span>
<span class="p">};</span>
</pre>
                    <br>
                    <h3>How to show files already stored on server</h3>

                    <p>
                        Although there's no builtin functionality to do that, you can use Dropzone's default event handlers to your advantage.</p>

                    <p>
                        The concept is, to create a <em>mock</em> file, and call the event handlers <code>
                            addedfile</code>
                        and <code>
                            thumbnail</code>
                        to draw the preview.</p>

				
					<pre><span class="c1">// Create the mock file:</span>
<span class="kd">var</span> <span class="nx">mockFile</span> <span class="o">=</span> <span class="p">{</span> <span class="nx">name</span><span class="o">:</span> <span class="s2">"Filename"</span><span class="p">,</span> <span class="nx">size</span><span class="o">:</span> <span class="mi">12345</span> <span class="p">};</span>

<span class="c1">// Call the default addedfile event handler</span>
<span class="nx">myDropzone</span><span class="p">.</span><span class="nx">emit</span><span class="p">(</span><span class="s2">"addedfile"</span><span class="p">,</span> <span class="nx">mockFile</span><span class="p">);</span>

<span class="c1">// And optionally show the thumbnail of the file:</span>
<span class="nx">myDropzone</span><span class="p">.</span><span class="nx">emit</span><span class="p">(</span><span class="s2">"thumbnail"</span><span class="p">,</span> <span class="nx">mockFile</span><span class="p">,</span> <span class="s2">"/image/url"</span><span class="p">);</span>

<span class="c1">// If you use the maxFiles option, make sure you adjust it to the</span>
<span class="c1">// correct amount:</span>
<span class="kd">var</span> <span class="nx">existingFileCount</span> <span class="o">=</span> <span class="mi">1</span><span class="p">;</span> <span class="c1">// The number of files already uploaded</span>
<span class="nx">myDropzone</span><span class="p">.</span><span class="nx">options</span><span class="p">.</span><span class="nx">maxFiles</span> <span class="o">=</span> <span class="nx">myDropzone</span><span class="p">.</span><span class="nx">options</span><span class="p">.</span><span class="nx">maxFiles</span> <span class="o">-</span> <span class="nx">existingFileCount</span><span class="p">;</span>
</pre>
                    <br>
                    <h3>Use own <code>
                            confirm</code> implementation</h3>

                    <p>
                        If you are unhappy with the way Dropzone asks a user if she wants to cancel or remove a file, and want to use some other way (e.g.: bootstrap's modal), you can simply overwrite the <code>
                            Dropzone.confirm</code>
                        function.</p>
				<pre><span class="c1">// accepted and rejected are functions to be called whenever the user response</span>
<span class="c1">// has been received.</span>
<span class="c1">// rejected is not mandatory! So make sure to check if it exists before</span>
<span class="c1">// calling it. Do nothing if it doesn't.</span>
<span class="nx">Dropzone</span><span class="p">.</span><span class="nx">confirm</span> <span class="o">=</span> <span class="kd">function</span><span class="p">(</span><span class="nx">question</span><span class="p">,</span> <span class="nx">accepted</span><span class="p">,</span> <span class="nx">rejected</span><span class="p">)</span> <span class="p">{</span>
  <span class="c1">// Do your thing, ask the user for confirmation or rejection, and call</span>
  <span class="c1">// accepted() if the user accepts, or rejected() otherwise. Make</span>
  <span class="c1">// sure that rejected is actually defined!</span>
<span class="p">};</span>
</pre>

                    <br>
                    <h3>How can I limit the number of files</h3>

                    <p>
                        You're in luck! Starting with <code>
                            3.7.0</code>
                        Dropzone supports the <code>
                            maxFiles</code>
                        option. Simply set it to the desired quantity and you're good to go. If you don't want the rejected files to be viewed, simply register for the <code>
                            maxfilesexceeded</code>
                        event, and remove the file immediately:</p>
				<pre><span class="nx">myDropzone</span><span class="p">.</span><span class="nx">on</span><span class="p">(</span><span class="s2">"maxfilesexceeded"</span><span class="p">,</span> <span class="kd">function</span><span class="p">(</span><span class="nx">file</span><span class="p">)</span> <span class="p">{</span> <span class="k">this</span><span class="p">.</span><span class="nx">removeFile</span><span class="p">(</span><span class="nx">file</span><span class="p">);</span> <span class="p">});</span>
</pre>





                </div>

            </div>

        </div>

        <!-- end row -->

    </section>
    <!-- end widget grid -->

</div>
<!-- END MAIN CONTENT -->