<?php
/* @var $this SiteController */

$this->pageTitle=Yii::app()->name;
?>

<div class="container">
    <div class="row">
        <div class="col-md-12">
            <div class="alert alert-warning alert-dismissible fade in" role="alert">
                <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">×</span></button>
                首先用扫描枪扫描物流跟踪单号条形码，然后将物品放到电子秤上称重即可自动录入数据到本系统。
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <?php $this->renderPartial('_form', array('model'=>$model)); ?>
        </div>
    </div>
    <div class="row m-t-20">
        <div class="col-md-12">
            <form class="form-inline" method="post" id="datetime-form" action="<?php echo $this->createUrl('createexcel'); ?>">
                <div class="form-group">
                    <div class='input-group date datetimepicker'>
                        <div class="input-group-addon">开始时间</div>
                        <input name="Datetime[begin]" type='text' class="form-control" value="<?php echo date("Y-m-d H:i:s",strtotime("-1 day")); ?>" />
                        <span class="input-group-addon">
                            <span class="glyphicon glyphicon-calendar"></span>
                        </span>
                    </div>
                </div>
                <div class="form-group">
                    <div class='input-group date datetimepicker'>
                        <div class="input-group-addon">结束时间</div>
                        <input name="Datetime[end]" type='text' class="form-control" value="<?php echo date('Y-m-d H:i:s') ?>" />
                    <span class="input-group-addon">
                        <span class="glyphicon glyphicon-calendar"></span>
                    </span>
                    </div>
                </div>
                <button type="submit" class="btn btn-success" id="export">导出数据</button>
            </form>

            <table class="table table-bordered m-t-20">
                <thead>
                <tr>
                    <th>物流跟踪号</th>
                    <th>重量</th>
                    <th>创建日期</th>
                    <th width="150">操作</th>
                </tr>
                </thead>
                <tbody>
                <?php if($result) : ?>
                    <?php foreach($result as $v) : ?>
                        <tr>
                            <td><?php echo $v['tracking_no']; ?></td>
                            <td><?php echo $v['weight']; ?></td>
                            <td><?php echo $v['created']; ?></td>
                            <td>
                                <a href="javascript:void(0)" class="btn btn-info js-btn-update" role="button" data-url="<?php echo $this->createUrl('update',array('id'=>$v['id'])) ?>">修改</a>
                                <a href="javascript:void(0)" class="btn btn-warning js-btn-delete" data-url="<?php echo $this->createUrl('delete',array('id'=>$v['id'])); ?>">删除</a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else : ?>
                    <tr>
                        <td colspan="4" class="text-center">暂无数据</td>
                    </tr>
                <?php endif ?>
                </tbody>
            </table>
            <nav class="pagination-container">
                <?php
                $this->widget('CLinkPager', array(
                    'pages' => $pages,
                    'cssFile'=> false,
                    'header' => '',
                    'firstPageLabel' => '首页',
                    'lastPageLabel' => '页尾',
                    'nextPageLabel' => '下一页',
                    'prevPageLabel' => '上一页',
                    'selectedPageCssClass' => 'active',
                    'hiddenPageCssClass' => 'disabled',
                    'htmlOptions' => array(
                        'class' => 'pagination',
                    )
                ))
                ?>
            </nav>
        </div>
    </div>
</div>

<audio id="audio" preload="auto">
    <source src="/public/default/media/success.mp3">
    <source src="/public/default/media/success.ogg">
</audio>

<!-- Modal -->
<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">

</div>