<?php
if(@opendir('.svn')) exit('forbidden');
chdir(dirname(__FILE__));
define('CORE_ROOT', './');
define('AK_ROOT', './');
include('include/common.inc.php');
$params = parseparams();
$tablepre = 'ak';
@ak_rmdir('document');
@ak_rmdir('tools');
@unlink('include/language/index.php');
@unlink('include/language/ul.php');
@unlink('language.php');
@unlink('release.php');
@unlink('akcms.php');
@unlink('codeline.php');
@unlink('include/render.inc.php');

$themes = readpathtoarray('themes');
foreach($themes as $theme) {
	$_theme = str_replace('themes/', '', $theme);
	require($theme.'/db/config.php');
	unlink($theme.'/db/config.php');
	$path = $theme;
	$db2 = db($themedb, 1);
	foreach($tables as $table => $value) {
		if(!isset($value['where'])) $value['where'] = 1;
		$fields = array_keys($value['fields']);
		$fields = implode(',', $fields);
		$query = $db2->query_by($fields, $table, $value['where']);
		while($row = $db2->fetch_array($query)) {
			foreach($row as $k => $v) {
				if($v == $value['fields'][$k]) unset($row[$k]);
			}
			$_row = array(
				'table' => $table,
				'value' => $row
			);
			$_row = base64_encode(serialize($_row));
			aklog($_row, $path."/db/db.ak");
		}
	}
}

function clearspace($text) {
	$text = str_replace("\r", '', $text);
	$text = str_replace("\n", '', $text);
	$text = str_replace("\t", '', $text);
	return $text;
}

function clearcomment($text) {
	$texts = explode("\n", $text);
	foreach($texts as $k => $v) {
		if(substr(ltrim($v), 0, 2) == '//') unset($texts[$k]);
	}
	$text = implode("\n", $texts);
	return $text;
}

function compress($path) {
	global $sysedition;
	chdir($path);
	system("7z a -ttar akcms.tar *");
	system("7z a -tgzip {$path}-akcms{$sysedition}.tar.gz akcms.tar");
	unlink('akcms.tar');
	system("7z a -tzip {$path}-akcms{$sysedition}.zip *");
	chdir("../akcms/");
	ak_rmdir($path);
}
?>