/*
Navicat MySQL Data Transfer

Source Server         : localhost_3340
Source Server Version : 50171
Source Host           : localhost:3340
Source Database       : gerenfaka

Target Server Type    : MYSQL
Target Server Version : 50171
File Encoding         : 65001

Date: 2017-02-28 20:58:50
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for `faka_access`
-- ----------------------------
DROP TABLE IF EXISTS `faka_access`;
CREATE TABLE `faka_access` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `access` varchar(255) DEFAULT NULL,
  `alias` varchar(255) DEFAULT NULL,
  `category` enum('CARD','BANK','PAY') DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of faka_access
-- ----------------------------
INSERT INTO `faka_access` VALUES ('1', '工商银行', 'a8tg', 'ICBC-NET-B2C', 'BANK');
INSERT INTO `faka_access` VALUES ('2', '建设银行', 'a8tg', 'CCB-NET-B2C', 'BANK');
INSERT INTO `faka_access` VALUES ('3', '农业银行', 'a8tg', 'ABC-NET-B2C', 'BANK');
INSERT INTO `faka_access` VALUES ('4', '招商银行', 'a8tg', 'CMBCHINA-NET-B2C', 'BANK');
INSERT INTO `faka_access` VALUES ('5', '交通银行', 'a8tg', 'BOCO-NET-B2C', 'BANK');
INSERT INTO `faka_access` VALUES ('6', '民生银行', 'a8tg', 'CMBC-NET-B2C', 'BANK');
INSERT INTO `faka_access` VALUES ('7', '光大银行', 'a8tg', 'CEB-NET-B2C', 'BANK');
INSERT INTO `faka_access` VALUES ('8', '中国银行', 'a8tg', 'BOC-NET-B2C', 'BANK');
INSERT INTO `faka_access` VALUES ('9', '浦发银行', 'a8tg', 'SPDB-NET-B2C', 'BANK');
INSERT INTO `faka_access` VALUES ('10', '兴业银行', 'a8tg', 'CIB-NET-B2C', 'BANK');
INSERT INTO `faka_access` VALUES ('11', '中信银行', 'a8tg', 'ECITIC-NET-B2C', 'BANK');
INSERT INTO `faka_access` VALUES ('12', '广发银行', 'a8tg', 'GDB-NET-B2C', 'BANK');
INSERT INTO `faka_access` VALUES ('13', '渤海银行', 'a8tg', 'CBHB-NET-B2C', 'BANK');
INSERT INTO `faka_access` VALUES ('14', '北京银行', 'a8tg', 'BCCB-NET-B2C', 'BANK');
INSERT INTO `faka_access` VALUES ('15', '平安银行', 'a8tg', 'PINGANBANK-NET', 'BANK');
INSERT INTO `faka_access` VALUES ('16', '南京银行', 'a8tg', 'NJCB-NET-B2C', 'BANK');
INSERT INTO `faka_access` VALUES ('17', '宁波银行', 'a8tg', 'NBCB-NET-B2C', 'BANK');
INSERT INTO `faka_access` VALUES ('18', '上海银行', 'a8tg', 'SHB-NET-B2C', 'BANK');
INSERT INTO `faka_access` VALUES ('19', '东亚银行', 'a8tg', 'HKBEA-NET-B2C', 'BANK');
INSERT INTO `faka_access` VALUES ('20', '浙商银行', 'a8tg', 'CZ-NET-B2C', 'BANK');
INSERT INTO `faka_access` VALUES ('21', '深圳发展银行', 'a8tg', 'SDB-NET-B2C', 'BANK');
INSERT INTO `faka_access` VALUES ('22', '北京农商银行', 'a8tg', 'BJRCB-NET-B2C', 'BANK');
INSERT INTO `faka_access` VALUES ('42', '支付宝', 'a8tg', 'ALIPAY', 'PAY');
INSERT INTO `faka_access` VALUES ('43', '财付通', 'a8tg', 'TENPAY', 'PAY');
INSERT INTO `faka_access` VALUES ('44', '微信支付', 'a8tg', 'WEIXIN', 'PAY');
INSERT INTO `faka_access` VALUES ('45', '微信WAP', 'a8tg', 'QQCODE', 'PAY');
INSERT INTO `faka_access` VALUES ('46', '支付宝wap', 'a8tg', 'ALIWAP', 'PAY');

-- ----------------------------
-- Table structure for `faka_access_copy`
-- ----------------------------
DROP TABLE IF EXISTS `faka_access_copy`;
CREATE TABLE `faka_access_copy` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `access` varchar(255) DEFAULT NULL,
  `alias` varchar(255) DEFAULT NULL,
  `category` enum('CARD','BANK','PAY') DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of faka_access_copy
-- ----------------------------
INSERT INTO `faka_access_copy` VALUES ('1', '工商银行', 'ebao', 'ICBC-NET-B2C', 'BANK');
INSERT INTO `faka_access_copy` VALUES ('2', '建设银行', 'ebao', 'CCB-NET-B2C', 'BANK');
INSERT INTO `faka_access_copy` VALUES ('3', '农业银行', 'ebao', 'ABC-NET-B2C', 'BANK');
INSERT INTO `faka_access_copy` VALUES ('4', '招商银行', 'ebao', 'CMBCHINA-NET-B2C', 'BANK');
INSERT INTO `faka_access_copy` VALUES ('5', '交通银行', 'ebao', 'BOCO-NET-B2C', 'BANK');
INSERT INTO `faka_access_copy` VALUES ('6', '民生银行', 'ebao', 'CMBC-NET-B2C', 'BANK');
INSERT INTO `faka_access_copy` VALUES ('7', '光大银行', 'ebao', 'CEB-NET-B2C', 'BANK');
INSERT INTO `faka_access_copy` VALUES ('8', '中国银行', 'ebao', 'BOC-NET-B2C', 'BANK');
INSERT INTO `faka_access_copy` VALUES ('9', '浦发银行', 'ebao', 'SPDB-NET-B2C', 'BANK');
INSERT INTO `faka_access_copy` VALUES ('10', '兴业银行', 'ebao', 'CIB-NET-B2C', 'BANK');
INSERT INTO `faka_access_copy` VALUES ('11', '中信银行', 'ebao', 'ECITIC-NET-B2C', 'BANK');
INSERT INTO `faka_access_copy` VALUES ('12', '广发银行', 'ebao', 'GDB-NET-B2C', 'BANK');
INSERT INTO `faka_access_copy` VALUES ('13', '渤海银行', 'ebao', 'CBHB-NET-B2C', 'BANK');
INSERT INTO `faka_access_copy` VALUES ('14', '北京银行', 'ebao', 'BCCB-NET-B2C', 'BANK');
INSERT INTO `faka_access_copy` VALUES ('15', '平安银行', 'ebao', 'PINGANBANK-NET', 'BANK');
INSERT INTO `faka_access_copy` VALUES ('16', '南京银行', 'ebao', 'NJCB-NET-B2C', 'BANK');
INSERT INTO `faka_access_copy` VALUES ('17', '宁波银行', 'ebao', 'NBCB-NET-B2C', 'BANK');
INSERT INTO `faka_access_copy` VALUES ('18', '上海银行', 'ebao', 'SHB-NET-B2C', 'BANK');
INSERT INTO `faka_access_copy` VALUES ('19', '东亚银行', 'ebao', 'HKBEA-NET-B2C', 'BANK');
INSERT INTO `faka_access_copy` VALUES ('20', '浙商银行', 'ebao', 'CZ-NET-B2C', 'BANK');
INSERT INTO `faka_access_copy` VALUES ('21', '深圳发展银行', 'ebao', 'SDB-NET-B2C', 'BANK');
INSERT INTO `faka_access_copy` VALUES ('22', '北京农商银行', 'ebao', 'BJRCB-NET-B2C', 'BANK');
INSERT INTO `faka_access_copy` VALUES ('38', '支付宝', 'ALIPAY', 'alipay', 'PAY');
INSERT INTO `faka_access_copy` VALUES ('39', '财付通', null, 'tenpay', 'PAY');
INSERT INTO `faka_access_copy` VALUES ('40', '微信扫码', 'weixin', 'WEIXIN', 'PAY');
INSERT INTO `faka_access_copy` VALUES ('41', '微信WAP', 'QQCODE', 'QQCODE', 'PAY');
INSERT INTO `faka_access_copy` VALUES ('42', '支付宝', 'a8tg', 'ALIPAY', 'PAY');
INSERT INTO `faka_access_copy` VALUES ('43', '财付通', 'a8tg', 'TENPAY', 'PAY');
INSERT INTO `faka_access_copy` VALUES ('44', '微信支付', 'a8tg', 'WEIXIN', 'PAY');
INSERT INTO `faka_access_copy` VALUES ('45', '微信WAP', 'a8tg', 'QQCODE', 'PAY');
INSERT INTO `faka_access_copy` VALUES ('46', '支付宝WAP', 'a8tg', 'ALIWAP', 'PAY');

-- ----------------------------
-- Table structure for `faka_goods`
-- ----------------------------
DROP TABLE IF EXISTS `faka_goods`;
CREATE TABLE `faka_goods` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `price` decimal(10,2) DEFAULT NULL,
  `money` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of faka_goods
-- ----------------------------
INSERT INTO `faka_goods` VALUES ('7', '支付接口申请www.yc88.net', '0.10', null);
INSERT INTO `faka_goods` VALUES ('8', '源码官网www.a8tg.com', '0.10', null);
INSERT INTO `faka_goods` VALUES ('9', '拿去用可以，随便用，别哪去后说你自己开发的要点脸谢谢', '999.00', null);

-- ----------------------------
-- Table structure for `faka_orders`
-- ----------------------------
DROP TABLE IF EXISTS `faka_orders`;
CREATE TABLE `faka_orders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_no` varchar(255) DEFAULT NULL,
  `order_body` text,
  `goods` int(11) DEFAULT NULL,
  `num` int(11) DEFAULT NULL,
  `money` decimal(11,3) DEFAULT NULL,
  `real_money` decimal(11,3) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `payment` varchar(255) DEFAULT NULL,
  `access` int(11) DEFAULT NULL,
  `status` enum('NONE','PAYERROR','PAYSUCCESS','FINISH','DRAW') DEFAULT NULL,
  `ip` varchar(255) DEFAULT NULL,
  `created_at` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=834 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of faka_orders
-- ----------------------------

-- ----------------------------
-- Table structure for `faka_orders_trade`
-- ----------------------------
DROP TABLE IF EXISTS `faka_orders_trade`;
CREATE TABLE `faka_orders_trade` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) DEFAULT NULL,
  `status` enum('NONE','SUCCESS','ERROR','PART') DEFAULT NULL,
  `money` decimal(10,2) DEFAULT NULL COMMENT '交易总额',
  `real_money` decimal(10,2) DEFAULT NULL COMMENT '付款成功金额',
  `price` decimal(10,2) DEFAULT NULL,
  `card` varchar(255) DEFAULT NULL,
  `pwd` varchar(255) DEFAULT NULL,
  `created_at` int(11) DEFAULT NULL,
  `updated_at` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=846 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of faka_orders_trade
-- ----------------------------

-- ----------------------------
-- Table structure for `faka_payments`
-- ----------------------------
DROP TABLE IF EXISTS `faka_payments`;
CREATE TABLE `faka_payments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `payment` enum('BANK','CARD','ALIPAY','WEIXIN','QQCODE','TENPAY','ALIWAP') DEFAULT NULL,
  `access` varchar(255) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `pid` varchar(255) DEFAULT NULL,
  `email` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of faka_payments
-- ----------------------------
INSERT INTO `faka_payments` VALUES ('1', '网银支付', 'BANK', 'a8tg', '2A40DB4CBC09E859F8A4F173BB075E9', '10019', '');
INSERT INTO `faka_payments` VALUES ('2', '卡类支付', 'CARD', '', '', '', '');
INSERT INTO `faka_payments` VALUES ('3', '支付宝支付', 'ALIPAY', 'a8tg', '2A40DB4CBC09E859F8A4F173BB075E9', '10019', '');
INSERT INTO `faka_payments` VALUES ('4', '财付通支付', 'TENPAY', 'a8tg', '2A40DB4CBC09E859F8A4F173BB075E9', '10019', '');
INSERT INTO `faka_payments` VALUES ('5', '微信扫码', 'WEIXIN', 'a8tg', '2A40DB4CBC09E859F8A4F173BB075E9', '10019', '');
INSERT INTO `faka_payments` VALUES ('6', '微信WAP', 'QQCODE', 'a8tg', '2A40DB4CBC09E859F8A4F173BB075E9', '10019', '');
INSERT INTO `faka_payments` VALUES ('7', '支付宝WAP', 'ALIWAP', 'a8tg', '2A40DB4CBC09E859F8A4F173BB075E9', '10019', '');

-- ----------------------------
-- Table structure for `faka_stocks`
-- ----------------------------
DROP TABLE IF EXISTS `faka_stocks`;
CREATE TABLE `faka_stocks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `goods_id` int(11) DEFAULT NULL,
  `card` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `status` enum('NONE','USED') DEFAULT NULL,
  `order_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=630 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of faka_stocks
-- ----------------------------

-- ----------------------------
-- Table structure for `faka_users`
-- ----------------------------
DROP TABLE IF EXISTS `faka_users`;
CREATE TABLE `faka_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of faka_users
-- ----------------------------
INSERT INTO `faka_users` VALUES ('1', 'admin', 'd28ed719cb9a3e76f4f0f5e8b281add8', null);
