﻿<?php
//---------------------------------------------------------
//财付通即时到帐支付请求示例，商户按照此文档进行开发即可
//---------------------------------------------------------

require_once ("classes/RequestHandler.class.php");

/* 获取提交的订单号 */
$out_trade_no = $_REQUEST["order_no"];
/* 获取提交的商品名称 */
$subject = $_REQUEST["subject"];
/* 获取提交的商品价格 */
$total_fee = round($_REQUEST["money"], 2) * 100;

/* 获取提交的备注信息 */
$body = $_REQUEST["body"];
/* 支付方式 */
$trade_mode = $_REQUEST["service"];

$return_url = "http://" . $_SERVER['HTTP_HOST'] . "/pay/tenpay/payReturnUrl.php";
$notify_url = "http://" . $_SERVER['HTTP_HOST'] . "/pay/tenpay/payNotifyUrl.php";
date_default_timezone_set('Asia/Shanghai');
$strDate = date("Ymd");
$strTime = date("His");


/* 创建支付请求对象 */
$reqHandler = new RequestHandler();
$reqHandler->init();
$reqHandler->setKey($_REQUEST["key"]);
$reqHandler->setGateUrl("https://gw.tenpay.com/gateway/pay.htm");

//----------------------------------------
//设置支付参数 
//----------------------------------------
$reqHandler->setParameter("partner", $_REQUEST["partner"]);
$reqHandler->setParameter("out_trade_no", $out_trade_no);
$reqHandler->setParameter("total_fee", $total_fee);  //总金额
$reqHandler->setParameter("return_url", $return_url);
$reqHandler->setParameter("notify_url", $notify_url);
$reqHandler->setParameter("body", $body);
$reqHandler->setParameter("bank_type", "DEFAULT");  	  //银行类型，默认为财付通
//用户ip
$reqHandler->setParameter("spbill_create_ip", $_SERVER['REMOTE_ADDR']);//客户端IP
$reqHandler->setParameter("fee_type", "1");               //币种
$reqHandler->setParameter("subject",$subject);          //商品名称，（中介交易时必填）

//系统可选参数
$reqHandler->setParameter("sign_type", "MD5");  	 	  //签名方式，默认为MD5，可选RSA
$reqHandler->setParameter("service_version", "1.0"); 	  //接口版本号
$reqHandler->setParameter("input_charset", "utf-8");   	  //字符集
$reqHandler->setParameter("sign_key_index", "1");    	  //密钥序号

//业务可选参数
$reqHandler->setParameter("attach", "");             	  //附件数据，原样返回就可以了
$reqHandler->setParameter("product_fee", "0");        	  //商品费用
$reqHandler->setParameter("transport_fee", "0");      	  //物流费用
$reqHandler->setParameter("time_start", date("YmdHis"));  //订单生成时间
$reqHandler->setParameter("time_expire", "");             //订单失效时间
$reqHandler->setParameter("buyer_id", "");                //买方财付通帐号
$reqHandler->setParameter("goods_tag", "");               //商品标记
$reqHandler->setParameter("trade_mode",$trade_mode);              //交易模式（1.即时到帐模式，2.中介担保模式，3.后台选择（卖家进入支付中心列表选择））
$reqHandler->setParameter("transport_desc","");              //物流说明
$reqHandler->setParameter("trans_type","1");              //交易类型
$reqHandler->setParameter("agentid","");                  //平台ID
$reqHandler->setParameter("agent_type","");               //代理模式（0.无代理，1.表示卡易售模式，2.表示网店模式）
$reqHandler->setParameter("seller_id","");                //卖家的商户号



//请求的URL
$reqUrl = $reqHandler->getRequestURL();

//获取debug信息,建议把请求和debug信息写入日志，方便定位问题
/*
$debugInfo = $reqHandler->getDebugInfo();
echo "<br/>" . $reqUrl . "<br/>";
echo "<br/>" . $debugInfo . "<br/>";
*/


?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<base target='_self'>
	<title>财付通即时到帐支付</title>
</head>

<body>
<!--<a href="<?php echo $reqUrl ?>" target="_blank">财付通支付</a>-->
<form id='TenpaySubmit' name='TenpaySubmit' action="<?php echo $reqHandler->getGateUrl() ?>" method="post" target="_blank">
<?php
	$params = $reqHandler->getAllParameters();
	foreach($params as $k => $v) {
		echo "<input type=\"hidden\" name=\"{$k}\" value=\"{$v}\" />\n";
	}
?>
<input type="submit" value="财付通支付">
</form>
<script>document.forms['TenpaySubmit'].submit();</script>
</body>
</html>

