const app = getApp()

Page({
  data: {
    web: app.globalData.web,
    url: app.globalData.url,
    h_t: wx.getSystemInfoSync().windowHeight,
    cfg: {},
    tbl: [],
    tbi: 0,
    mdc: [],
    mds: 0,
    mdz: '',
    nid: 0,
    mex: 0,
    mey: 0,
    mzx: 0,
    mzy: 0,
    mzz: 14,
    mpl: [],
    mkr: [],
    mip: [],
    mod: 1,
    mos: 0,
    mot: 0,
    mof: 0,
    txt: {
      mon: '',
      mom: '',
      mod: '',
      mdz: ''
    }
  },
  onLoad: function (o) {
    if (!o.s) wx.navigateBack({})
    let t = this.data.txt
    wx.getStorage({
      key: 'userName',
      success(res) {
        t.mon = res.data
      }
    })
    wx.getStorage({
      key: 'userFone',
      success(res) {
        t.mom = res.data
      }
    })
    let b = app.globalData.mdt
    let d = ['选择餐桌', '打包外带'];
    for (let e in b) {
      if (b[e].h == 0) d.push(b[e].n)
    }
    t.mdz = app.globalData.mdz
    let k = app.dnc(app.globalData.uny, app.globalData.unx, app.globalData.shp[o.s].y, app.globalData.shp[o.s].x)
    this.setData({
      cfg: app.globalData.shp[o.s],
      tbl: d,
      mdc: app.globalData.mdc,
      mds: app.globalData.mds,
      mdz: app.globalData.mdz,
      mex: app.globalData.unx,
      mey: app.globalData.uny,
      mzx: app.globalData.shp[o.s].x,
      mzy: app.globalData.shp[o.s].y,
      mkr: [{
        latitude: app.globalData.shp[o.s].y,
        longitude: app.globalData.shp[o.s].x,
        iconPath: app.globalData.url + 'pics/mkrs.png',
        width: '30px',
        height: '34px'
      }],
      nid: o.s * 1,
      mos: k,
      mod: (app.globalData.shp[o.s].s.w && k > 0.1) ? 2 : app.globalData.shp[o.s].s.b,
      txt: t
    })
    wx.setNavigationBarTitle({
      title: this.data.cfg.n + ' - 快餐/外卖'
    })
    this.bike()
  },
  smod: function (e) {
    let i = e.currentTarget.dataset['im'] * 1
    if (i == 1 || this.data.cfg.s.w) {
      this.setData({
        mod: i
      })
    } else app.alt('当前餐厅暂时不接外卖，请选择店内用餐')
  },
  stbl: function (e) {
    this.setData({
      tbi: e.detail.value * 1
    })
  },
  bike: function (e) {
    let that = this
    let mx = e ? e.detail.longitude : this.data.mex
    let my = e ? e.detail.latitude : this.data.mey
    if (app.dnc(my, mx, this.data.cfg.y, this.data.cfg.x) > this.data.cfg.s.k) {
      app.alt('距离太远，超过配送范围！')
      return
    }
    if (e) this.setData({
      mex: mx,
      mey: my
    })
    app.xhr({
      act: 'bike',
      mx: mx,
      my: my,
      sx: that.data.cfg.x,
      sy: that.data.cfg.y
    }, function (r) {
      let n = app.dnc(my, mx, that.data.cfg.y, that.data.cfg.x)
      if (!r.result || !r.result.routes || r.result.routes.length == 0) {
        app.alt('规划路线失败，请重新选择送餐地点！')
        return
      }
      let d = r.result.routes[0].distance / 1000
      let p = r.result.routes[0].polyline
      for (let i = 2; i < p.length; i++) p[i] = p[i - 2] + p[i] / 1000000
      let b = [];
      for (let i = 0; i < p.length; i += 2) b.push({
        latitude: Math.round(p[i] * 1000000) / 1000000,
        longitude: Math.round(p[i + 1] * 1000000) / 1000000
      })
      let f = that.data.cfg.s.o
      let c = d - that.data.cfg.s.f
      if (c < 0) c = 0
      f += Math.ceil(c) * that.data.cfg.s.e
      if (that.data.mds > that.data.cfg.s.n) f = 0
      f = Math.round(f * 100)
      let t = that.data.txt
      t.mod = r.addr.result.formatted_addresses.recommend
      that.setData({
        mzx: (that.data.cfg.x + mx) / 2,
        mzy: (that.data.cfg.y + my) / 2,
        mzz: n > 100 ? 7 : (n > 33 ? 9 : (n > 10 ? 10 : (n > 5 ? 12 : (n > 2 ? 13 : (n > 1 ? 14 : 15))))),
        mpl: [{
          points: b,
          color: '#0099CCFF',
          width: 5
        }],
        mkr: [{
          latitude: that.data.cfg.y,
          longitude: that.data.cfg.x,
          iconPath: that.data.url + 'pics/mkrs.png',
          width: '30px',
          height: '34px'
        }, {
          latitude: my,
          longitude: mx,
          iconPath: that.data.url + 'pics/mkrm.png',
          width: '30px',
          height: '34px'
        }],
        mos: d,
        mof: f,
        mot: r.result.routes[0].duration + 10,
        txt: t
      })
    })
  },
  odru: function () {
    if (app.globalData.mdc.length == 0) {
      app.alt('请勿重复提交！')
      return
    }
    if (this.data.mod == 0) {
      app.alt('当前餐厅为正餐模式且不接外卖，请至餐厅用餐！')
      return
    }
    if (this.data.mod == 2 && this.data.mos > this.data.cfg.s.k) {
      app.alt('位置超出配送距离！')
      return
    }
    if (this.data.mod == 2 && (this.data.txt.mon == '' || this.data.txt.mom.length != 11)) {
      app.alt('请输入名称和电话！')
      return
    }
    if (this.data.mod == 1 && this.data.tbi == 0) {
      app.alt('请选择餐桌或外带！')
      return
    }
    let that = this
    wx.setStorage({
      key: 'userName',
      data: that.data.txt.mon
    })
    wx.setStorage({
      key: 'userFone',
      data: that.data.txt.mom
    })
    app.xhr({
      act: 'odru',
      mdc: app.t2f(JSON.parse(JSON.stringify(app.globalData.mdc)), app.globalData.mdf),
      mds: that.data.mds,
      mod: that.data.mod,
      mde: that.data.mod == 2 ? {
        n: that.data.txt.mon,
        m: that.data.txt.mom,
        d: that.data.txt.mod,
        f: that.data.mof,
        b: that.data.txt.mdz,
        t: that.data.mos,
        x: that.data.mex,
        y: that.data.mey
      } : {
        b: that.data.txt.mdz,
        t: that.data.tbl[that.data.tbi]
      }
    }, function (r) {
      wx.navigateTo({
        url: '../pay/pay?s=' + app.globalData.nid + '&o=' + r.oid
      })
    })
  },
  tomy: function () {
    wx.navigateTo({
      url: '../user/user'
    })
  },
  edit: function (e) {
    let n = e.currentTarget.dataset['n']
    let v = e.detail.value
    let t = this.data.txt
    t[n] = v
    this.setData({
      txt: t
    })
  }
})