const app = getApp()

Page({
  data: {
    web: app.globalData.web,
    url: app.globalData.url,
    nid: 0,
    cfg: {},
    h_t: wx.getSystemInfoSync().windowHeight,
    h_b: 0,
    eit: {},
    rid: null, //fixed
    mod: 0,
    odr: [],
    tbl: [],
    tbk: [],
    que: [],
    pra: 0,
    prt: [],
    prd: '',
    prm: '',
    prr: [],
    pri: 0,
    prc: false,
    pro: {
      m: '未选择'
    },
    pre: '',
    pru: {
      u: 1,
      c: 1
    },
    pid: null
  },
  onLoad: function (o) {
    if (!o.s) wx.navigateBack({})
    let that = this
    wx.getStorage({
      key: 'printInf',
      success(res) {
        that.setData({
          pro: res.data
        })
      }
    })
    let c = this.data.pru
    c.c = 1 - app.globalData.shp[o.s].s.c
    this.setData({
      nid: o.s,
      cfg: app.globalData.shp[o.s],
      pra: app.globalData.pra,
      pru: c
    })
    wx.setNavigationBarTitle({
      title: this.data.cfg.n + ' - 前台'
    })
    this.frts()
  },
  onUnload: function () {
    clearTimeout(this.data.rid)
  },
  frtc: function (e) {
    this.setData({
      mod: e.currentTarget.dataset['im'] * 1
    })
    this.frts()
  },
  frts: function () {
    let that = this
    clearTimeout(that.data.rid)
    app.xhr({
      act: 'frts'
    }, function (r) {
      let k = []
      let t = {}
      let b = []
      let d = []
      let o = []
      for (let i = 0; i < r.odr.length; i++) {
        d.push(r.odr[i].Ot);
        if (r.odr[i].Po * 1 > 0) o.push(r.odr[i])
      }
      d = ',' + d.join(',') + ','
      for (let i = 0; i < r.tbl.length; i++) {
        if (d.indexOf(',' + r.tbl[i].i + ',') == -1 && r.tbl[i].h == 0) k.push(r.tbl[i].n + '[' + r.tbl[i].c + '人座]')
        t[r.tbl[i].i] = r.tbl[i].n
      }
      that.setData({
        odr: o,
        tbl: t,
        tbk: k.join(', '),
        que: r.que
      })
      that.data.rid = setTimeout(function () {
        that.frts()
      }, 30000)
    })
  },
  frta: function (e) {
    let that = this
    app.xhr({
      act: 'frta',
      eid: e.currentTarget.dataset['id'],
      shp: that.data.cfg.n
    }, function (r) {
      if (r.errcode == 0) {
        app.alt('叫号成功，顾客ID： ' + e.currentTarget.dataset['id'])
      } else if (r.errcode == 43101) {
        app.alt('叫号失败，顾客已拒接消息，请口头叫号！')
      } else app.alt('通知失败：' + r.errmsg)
    })
  },
  frte: function (e) {
    let that = this
    wx.showModal({
      title: '确认',
      content: '确认销号？',
      success: function (res) {
        if (res.confirm) {
          app.xhr({
            act: 'frte',
            eid: e.currentTarget.dataset['id']
          }, function (r) {
            that.frts()
          })
        }
      }
    })
  },
  frto: function (e) {
    let t = this.data.eit
    let i = e.currentTarget.dataset['id']
    let o = this.data.odr[i]
    t['mny'] = (o.Po * 1 - o.Pc * 1 - o.Ps * 1) / 100
    t['prt'] = this.data.cfg.s.c
    t['odr'] = o
    this.setData({
      eit: t
    })
    this.fade('order', 1, 1)
  },
  frtv: function (e) {
    let that = this
    let m = that.data.eit.mny
    let s = e.currentTarget.dataset['st'] * 1
    wx.showModal({
      title: '确认',
      content: '确认 ' + ['', '', '刷卡', '现金'][s] + ' 结账 ' + m + ' 元？？',
      success: function (res) {
        if (res.confirm) {
          app.xhr({
            act: 'frtv',
            mny: Math.round(m * 100),
            oid: that.data.eit.odr.ID,
            ost: s,
            tnm: that.data.tbl[that.data.eit.odr.Ot],
            shp: that.data.cfg.n,
            prt: that.data.eit.prt
          }, function (r) {
            app.alt('结账成功')
            that.fade('order', 0, 0)
            that.frts()
          })
        }
      }
    })
  },
  prto: function () {
    this.fade('print', 1, 1)
  },
  prta: function () {
    let c = app.globalData.pra
    let that = this
    if (c) {
      wx.closeBluetoothAdapter({
        complete: function (res) {
          app.alt('蓝牙打印已关闭！')
          c = 0
          app.globalData.pra = c
          that.setData({
            pra: c,
            prc: false
          })
        }
      })
    } else {
      wx.openBluetoothAdapter({
        mode: 'central',
        success: function (res) {
          app.alt('蓝牙打印已开启！')
          c = 1
          app.globalData.pra = c
          that.setData({
            pra: c
          })
          that.frtl()
        },
        fail: function (res) {
          app.alt('蓝牙初始化失败！')
          c = 0
          app.globalData.pra = c
          that.setData({
            pra: c,
            prc: false
          })
        }
      })
    }
  },
  prtr: function () {
    let that = this
    wx.startBluetoothDevicesDiscovery({
      success(res) {
        wx.getBluetoothDevices({
          success: function (res) {
            let p = []
            for (let i = 0; i < res.devices.length; i++) {
              if (res.devices[i].name != '') p.push(res.devices[i])
            }
            that.setData({
              prt: p
            })
          },
          fail: function (res) {
            app.alt('获取蓝牙设备失败！')
          }
        })
        wx.onBluetoothDeviceFound((res) => {
          let p = that.data.prt
          for (let i = 0; i < res.devices.length; i++) {
            if (res.devices[i].name != '') p.push(res.devices[i])
          }
          that.setData({
            prt: p
          })
        })
      },
      fail: function (res) {
        app.alt('搜索蓝牙设备失败！')
      }
    })
  },
  prtn: function (e) {
    let that = this
    wx.stopBluetoothDevicesDiscovery({})
    that.setData({
      prd: e.currentTarget.dataset['id'],
      prm: e.currentTarget.dataset['nm'],
      pri: 0
    })
    wx.createBLEConnection({
      deviceId: that.data.prd,
      success: function (res) {
        that.setData({
          prc: true
        })
        wx.getBLEDeviceServices({
          deviceId: that.data.prd,
          success: function (res) {
            that.setData({
              prr: res.services
            })
            that.prtm()
          },
          fail: function (res) {
            app.alt('获取蓝牙服务列表失败！')
          }
        })
      },
      fail: function (e) {
        app.alt('连接蓝牙设备失败！')
      }
    })
  },
  prtm: function () {
    let that = this
    let p = that.data.prr
    let i = that.data.pri
    wx.getBLEDeviceCharacteristics({
      deviceId: that.data.prd,
      serviceId: p[i].uuid,
      success: function (res) {
        p[that.data.pri]['char'] = res.characteristics
      },
      fail: function (res) {
        p[that.data.pri]['char'] = false
      },
      complete: function (res) {
        i++
        that.setData({
          prr: p,
          pri: i,
          pre: JSON.stringify(p)
        })
        if (i == p.length) {
          that.prtv()
        } else that.prtm()
      }
    })
  },
  prtv: function () {
    let p = this.data.prr
    let r = 0
    let w = 0
    let n = 0
    let e = {
      i: this.data.prd,
      m: this.data.prm
    }
    for (let i = 0; i < p.length; i++) {
      if (!p[i].char) continue
      for (let j = 0; j < p[i].char.length; j++) {
        if (!r) {
          if (p[i].char[j].properties.read) {
            e['r'] = {
              s: p[i].uuid,
              c: p[i].char[j].uuid
            }
            r = 1
          }
        }
        if (!w) {
          if (p[i].char[j].properties.write) {
            e['w'] = {
              s: p[i].uuid,
              c: p[i].char[j].uuid
            }
            w = 1
          }
        }
        if (!n) {
          if (p[i].char[j].properties.notify) {
            e['n'] = {
              s: p[i].uuid,
              c: p[i].char[j].uuid
            }
            n = 1
          }
        }
      }
    }
    if (!r || !w || !n) {
      app.alt('读取蓝牙特征字串失败！')
      return
    }
    this.setData({
      pro: e
    })
    wx.setStorage({
      key: 'printInf',
      data: e
    })
    app.alt('蓝牙设备添加成功！')
    let that = this
    wx.closeBLEConnection({
      deviceId: e.i,
      success: function (res) {
        that.setData({
          prc: false
        })
      }
    })
  },
  prtc: function (t) {
    let that = this
    wx.createBLEConnection({
      deviceId: that.data.pro.i,
      success: function (res) {
        that.setData({
          prc: true
        })
        if (t) that.prts(t, 0)
      },
      fail: function (res) {
        app.alt('连接蓝牙设备失败！')
      }
    })
    wx.onBLEConnectionStateChange(function (res) {
      that.setData({
        prc: res.connected
      })
    })
  },
  prts: function (t, c) {
    let that = this;
    if (!this.data.prc) {
      this.prtc(t)
      return
    }
    let s = t.substr(40 * c, 40)
    if (s.length == 0) {
      wx.closeBLEConnection({
        deviceId: that.data.pro.i,
        success: function (res) {
          that.setData({
            prc: false
          })
          that.frtl(that.data.pre)
        }
      })
      return
    }
    let b = new ArrayBuffer(s.length / 2)
    let d = new DataView(b)
    for (let i = 0; i < s.length; i += 2) {
      d.setInt8(i / 2, Number('0x' + s.substr(i, 2)).toString(10));
    }
    wx.writeBLECharacteristicValue({
      deviceId: that.data.pro.i,
      serviceId: that.data.pro.w.s,
      characteristicId: that.data.pro.w.c,
      value: b,
      success: function (res) {},
      fail: function (res) {},
      complete: function (res) {
        setTimeout(function () {
          that.prts(t, c + 1)
        }, 50)
      }
    })
  },
  prtx: function () {
    this.prts('1b401b6101b4f2d3a1b2e2cad42020b1eacce2bed3d6d00a1b6100d5fdb3a3d7d6cce520201d2110bcd3bfedd7d6cce50a1d2101bcd3b8dfd7d6cce520201d2111cbabb1b6d7d6cce51d21000abdf0ceb6b2cdccfcd0a1b3ccd0f2b0e6a3acd7a3c4e3cab9d3c3d3e4bfeca3a10a0a0a0a1b69', 0)
  },
  prtu: function (e) {
    let c = e.currentTarget.dataset['u']
    let u = this.data.pru
    u[c] = 1 - u[c]
    if (this.data.cfg.s.c == 1) u.c = 0
    this.setData({
      pru: u
    })
  },
  frtl: function (f) {
    let that = this
    clearTimeout(that.data.pid)
    if (!that.data.pra) return
    app.xhr({
      act: 'frtl',
      pru: that.data.pru,
      del: f ? f : false
    }, function (r) {
      if (r.str.f && !that.data.prc) {
        that.setData({
          pre: r.str.f
        })
        //1B40 初始化 0A 换行 20 空格 1B6101 居中 1B6100 居左 1D2110 倍宽 1D2101 倍高 1D2100 正常 1B69 切纸
        if (r.str.f.substr(0, 1) == '1' && that.data.pru.c) {
          let c = '1b401b61011d2110b5e3b2cbb5a50a1b61001d2100b5a5bac5a3ba' + r.str.o + '2020d7c0bac5a3ba' + r.str.t + '0a1d2111'
          c += r.str.n + 'a1c1' + r.str.c + '1d21000abfdaceb6a3ba' + r.str.k + '0aoacab1bce4a3ba' + r.str.d + '0a0a0a0a1b69'
          that.prts(c)
        }
        if (r.str.f.substr(0, 1) == '0' && that.data.pru.u) {
          let c = '1b401b61011d2111' + r.str.Os + '0a1b61001d2100b5a5bac5a3ba' + r.str.ID
          c += '2020d7c0bac5a3ba' + (r.str.Dc == '31' ? r.str.Oe.t : r.str.Ot) + '0acab1bce4a3ba' + r.str.D0
          c += '0ab2cbc6b7202020202020202020202020202020202020b5a5bcdb2020cafdc1bf'
          c += '0a2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d'
          for (let i = 0; i < r.str.Oc.length; i++) {
            c += '0a' + (r.str.Oc[i].n + '20202020202020202020202020202020202020202020').substr(0, 44)
            c += (r.str.Oc[i].m + '202020202020').substr(0, 12) + ('a1c1' + r.str.Oc[i].c).substr(0, 8)
          }
          c += '0a2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d2d'
          c += ('0ab2cdb7d1a3ba' + r.str.Po + 'd4aa2020202020202020').substr(0, 32)
          c += ('d3c5bbdda3ba' + r.str.Pc + 'd4aa2020202020202020').substr(0, 32)
          c += 'cab5b8b6a3ba1d2110' + r.str.Ps + '1d2100d4aa'
          if (r.str.Dc == '32') c += '0a1d2101cbcdd6c1a3ba' + r.str.Oe.n.substr(0, 4) + '2a2a20' + r.str.Oe.m + '20' + r.str.Oe.d + '0ab1b8d7a2a3ba' + r.str.Oe.b + '0a1d2100b4f2b0fcbcb0cbcdb2cdb7d1a3ba' + r.str.Oe.f + 'd4aa'
          c += '0a1b61011d2110d7a3c4fad3c3b2cdd3e4bfec0abbb6d3adcfc2b4ceb9e2c1d90a0a0a0a1b69'
          that.prts(c)
        }
      }
      that.data.pid = setTimeout(function () {
        that.frtl()
      }, 5000)
    })
  },
  //====================================
  edit: function (e) {
    let n = e.currentTarget.dataset['n'] //name
    let m = e.currentTarget.dataset['m'] || false //number
    let c = e.currentTarget.dataset['c'] || false //checkbox
    let s = e.currentTarget.dataset['s'] || false //subarray
    let t = this.data.eit
    let v = c === false ? e.detail.value : 1 - (s === false ? t[n] : t[n][s * 1])
    if (m !== false) {
      v = parseFloat(v) || 0
      v = Math.round(v * Math.pow(10, m)) / Math.pow(10, m);
    }
    if (s === false) {
      t[n] = v;
    } else t[n][s * 1] = v
    this.setData({
      eit: t
    })
  },
  hide: function (e) {
    let c = e.currentTarget.dataset;
    c.m * 1 == 1 ? this.fade(c.n, 0, 0) : this.fade(c.n, 0)
  },
  fade: function (obj, io, bk) {
    this.setData(JSON.parse('{"d_' + obj + '":"block"}'))
    this.setData({
      d_msk: 'block',
      h_b: wx.getSystemInfoSync().windowHeight
    })
    let ao = wx.createAnimation({
      duration: 500,
      timingFunction: 'ease',
      delay: 0
    });
    ao.opacity(io ? 1 : 0).translateY(io ? 0 : 100).step()
    let am = wx.createAnimation({
      duration: 500,
      timingFunction: 'ease',
      delay: 0
    });
    am.opacity(bk ? 0.3 : (io ? 0.3 : 0)).step()
    let jo = JSON.parse('{"' + obj + '":""}')
    jo[obj] = ao.export()
    jo.msk = am.export()
    this.setData(jo)
    if (!io) {
      let that = this
      setTimeout(function () {
        that.setData(JSON.parse('{"d_' + obj + '":"none"' + (bk ? '' : ',"h_b":0') + '}'))
      }, 550)
    }
  }
})